/*
 * Office JavaScript API library
 *
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 *
 * Your use of this file is governed by the license terms for the Microsoft Office JavaScript (Office.js) API library: https://github.com/OfficeDev/office-js/blob/release/LICENSE.md
 *
 * This file also contains the following Promise implementation (with a few small modifications):
 *      * @overview es6-promise - a tiny implementation of Promises/A+.
 *      * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 *      * @license   Licensed under MIT license
 *      *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
 *      * @version   2.3.0
 */
var OSFPerformance,CustomFunctionMappings,CustomFunctions,Strings;!function(e){e.now=function(){return"undefined"!=typeof performance&&performance.now?performance.now():0},e.getTotalJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.totalJSHeapSize:0},e.getUsedJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.usedJSHeapSize:0},e.getJSHeapSizeLimit=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.jsHeapSizeLimit:0},e.officeExecuteStartDate=e.officeExecuteStartDate||Date.now(),e.officeExecuteStart=e.officeExecuteStart||0,e.officeExecuteEnd=e.officeExecuteEnd||0,e.hostInitializationStart=0,e.hostInitializationEnd=0,e.totalJSHeapSize=0,e.usedJSHeapSize=0,e.jsHeapSizeLimit=0,e.createOMEnd=0,e.hostSpecificFileName="",e.getAppContextStart=0,e.getAppContextEnd=0,e.getAppContextXdmStart=0,e.getAppContextXdmEnd=0,e.officeOnReady=0}(OSFPerformance||(OSFPerformance={})),function(e){e.definePropertyOnNamespace=function(e,t,n){Object.defineProperty(e,t,{get:function(){return n()},configurable:!0,enumerable:!0})}}(OSF||(OSF={})),OSFPerformance.hostInitializationStart=OSFPerformance.now(),function(e){!function(e){function t(){return e.m_association||(e.m_association=new OSF.Association),e.m_association}e.m_association=e.m_association,e.associate=function(){t().associate.apply(t(),arguments)},OSF.definePropertyOnNamespace(e,"_association",t)}(e.actions||(e.actions={}))}(Office||(Office={})),function(e){!function(e){e[e.Select=0]="Select",e[e.UnSelect=1]="UnSelect",e[e.CancelDialog=2]="CancelDialog",e[e.InsertAgave=3]="InsertAgave",e[e.CtrlF6In=4]="CtrlF6In",e[e.CtrlF6Exit=5]="CtrlF6Exit",e[e.CtrlF6ExitShift=6]="CtrlF6ExitShift",e[e.SelectWithError=7]="SelectWithError",e[e.NotifyHostError=8]="NotifyHostError",e[e.RefreshAddinCommands=9]="RefreshAddinCommands",e[e.PageIsReady=10]="PageIsReady",e[e.TabIn=11]="TabIn",e[e.TabInShift=12]="TabInShift",e[e.TabExit=13]="TabExit",e[e.TabExitShift=14]="TabExitShift",e[e.EscExit=15]="EscExit",e[e.F2Exit=16]="F2Exit",e[e.ExitNoFocusable=17]="ExitNoFocusable",e[e.ExitNoFocusableShift=18]="ExitNoFocusableShift",e[e.MouseEnter=19]="MouseEnter",e[e.MouseLeave=20]="MouseLeave",e[e.UpdateTargetUrl=21]="UpdateTargetUrl",e[e.InstallCustomFunctions=22]="InstallCustomFunctions",e[e.SendTelemetryEvent=23]="SendTelemetryEvent",e[e.UninstallCustomFunctions=24]="UninstallCustomFunctions",e[e.SendMessage=25]="SendMessage",e[e.LaunchExtensionComponent=26]="LaunchExtensionComponent",e[e.StopExtensionComponent=27]="StopExtensionComponent",e[e.RestartExtensionComponent=28]="RestartExtensionComponent",e[e.EnableTaskPaneHeaderButton=29]="EnableTaskPaneHeaderButton",e[e.DisableTaskPaneHeaderButton=30]="DisableTaskPaneHeaderButton",e[e.TaskPaneHeaderButtonClicked=31]="TaskPaneHeaderButtonClicked",e[e.RemoveAppCommandsAddin=32]="RemoveAppCommandsAddin",e[e.RefreshRibbonGallery=33]="RefreshRibbonGallery",e[e.GetOriginalControlId=34]="GetOriginalControlId",e[e.OfficeJsReady=35]="OfficeJsReady",e[e.InsertDevManifest=36]="InsertDevManifest",e[e.InsertDevManifestError=37]="InsertDevManifestError",e[e.SendCustomerContent=38]="SendCustomerContent",e[e.KeyboardShortcuts=39]="KeyboardShortcuts",e[e.CloseSDXDialog=42]="CloseSDXDialog",e[e.ResizeSDXDialog=43]="ResizeSDXDialog",e[e.SendNonStandardEvent=44]="SendNonStandardEvent"}(e.AgaveHostAction||(e.AgaveHostAction={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){var t=this;this._processAppCommandInvocation=function(e){var n=t._verifyManifestCallback(e.callbackName);if(0==n.errorCode){var r=t._constructEventObjectForCallback(e);r?window.setTimeout((function(){n.callback(r)}),0):t._invokeAppCommandCompletedMethod(e.appCommandId,5001,"")}else t._invokeAppCommandCompletedMethod(e.appCommandId,n.errorCode,"")},this._eventDispatch=new e.EventDispatch([{type:e.EventType.AppCommandInvoked,id:e.EventDispId.dispidAppCommandInvokedEvent,getTargetId:function(){return""},fromSafeArrayHost:function(t){return{type:e.EventType.AppCommandInvoked,appCommandId:t[0],callbackName:t[1],eventObjStr:t[2]}},fromWebHost:function(t){return{type:e.EventType.AppCommandInvoked,appCommandId:t[0],callbackName:t[1],eventObjStr:t[2]}}}])}return t.prototype.initializeEventHandler=function(t){var n=this;this.addHandlerAsync(e.EventType.AppCommandInvoked,(function(e){n._processAppCommandInvocation(e)}),t)},t.prototype.appCommandInvocationCompletedAsync=function(t,n,r,o){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(94,{fromSafeArrayHost:function(e){return e},fromWebHost:function(e){return e},toSafeArrayHost:function(){return[t,n,r]},toWebHost:function(){var e={};return e[0]=t,e[1]=n,e[2]=r,e}},o)},t.prototype.addHandlerAsync=function(t,n,r){e.EventHelper.addEventHandler(t,n,r,this._eventDispatch,void 0,e.OUtil.isPopupWindow())},t.prototype._verifyManifestCallback=function(e){var t={callback:null,errorCode:11101};e=e.trim();try{var n=this._getCallbackFunc(e);if("function"!=typeof n)return t}catch(e){return t}return{callback:n,errorCode:0}},t.prototype._getCallbackFuncFromActionAssociateTable=function(e){var t=e.toUpperCase();return Office.actions._association.mappings[t]},t.prototype._getCallbackFunc=function(e){return this._getCallbackFuncFromActionAssociateTable(e)},t.prototype._invokeAppCommandCompletedMethod=function(e,t,n){this.appCommandInvocationCompletedAsync(e,t,n,(function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Failed to notify the host thta app command is completed")}))},t.prototype._constructEventObjectForCallback=function(e){var t,n,r=this;try{t=JSON.parse(e.eventObjStr),n=JSON.parse(e.eventObjStr)}catch(e){}return t||(t={}),n||(n={}),t.completed=function(t){n.completedContext=t;var o=JSON.stringify(n);r._invokeAppCommandCompletedMethod(e.appCommandId,0,o)},t},t.initialize=function(){null==t._instance&&(t._instance=new t,t._instance.initializeEventHandler((function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Cannot initialize app command: "+JSON.stringify(e))})))},t._instance=null,t}();e.AppCommandManager=t}(OSF||(OSF={})),function(e){!function(e){e[e.Unsupported=0]="Unsupported",e[e.Excel=1]="Excel",e[e.Word=2]="Word",e[e.PowerPoint=4]="PowerPoint",e[e.Outlook=8]="Outlook",e[e.ExcelWebApp=16]="ExcelWebApp",e[e.WordWebApp=32]="WordWebApp",e[e.OutlookWebApp=64]="OutlookWebApp",e[e.Project=128]="Project",e[e.AccessWebApp=256]="AccessWebApp",e[e.PowerpointWebApp=512]="PowerpointWebApp",e[e.ExcelIOS=1024]="ExcelIOS",e[e.Sway=2048]="Sway",e[e.WordIOS=4096]="WordIOS",e[e.PowerPointIOS=8192]="PowerPointIOS",e[e.Access=16384]="Access",e[e.Lync=32768]="Lync",e[e.OutlookIOS=65536]="OutlookIOS",e[e.OneNoteWebApp=131072]="OneNoteWebApp",e[e.OneNote=262144]="OneNote",e[e.ExcelWinRT=524288]="ExcelWinRT",e[e.WordWinRT=1048576]="WordWinRT",e[e.PowerpointWinRT=2097152]="PowerpointWinRT",e[e.OutlookAndroid=4194304]="OutlookAndroid",e[e.OneNoteWinRT=8388608]="OneNoteWinRT",e[e.ExcelAndroid=8388609]="ExcelAndroid",e[e.VisioWebApp=8388610]="VisioWebApp",e[e.OneNoteIOS=8388611]="OneNoteIOS",e[e.WordAndroid=8388613]="WordAndroid",e[e.PowerpointAndroid=8388614]="PowerpointAndroid",e[e.Visio=8388615]="Visio",e[e.OneNoteAndroid=4194305]="OneNoteAndroid"}(e.AppName||(e.AppName={}))}(OSF||(OSF={})),function(e){var t=function(){function e(){this.m_mappings={},this.m_onchangeHandlers=[]}return e.prototype.associate=function(e,t){function n(e){"undefined"!=typeof console&&console.warn&&console.warn(e)}if(1==arguments.length&&"object"==typeof arguments[0]&&arguments[0]){var r=arguments[0];for(var o in r)this.associate(o,r[o])}else if(2==arguments.length){var i=arguments[0],a=arguments[1];if("string"!=typeof i)return void n("[InvalidArg] Function=associate");if("function"!=typeof a)return void n("[InvalidArg] Function=associate");var s=i.toUpperCase();this.m_mappings[s]&&n("[DuplicatedName] Function="+i),this.m_mappings[s]=a;for(var c=0;c<this.m_onchangeHandlers.length;c++)this.m_onchangeHandlers[c]()}else n("[InvalidArg] Function=associate")},e.prototype.onchange=function(e){e&&this.m_onchangeHandlers.push(e)},Object.defineProperty(e.prototype,"mappings",{get:function(){return this.m_mappings},enumerable:!0,configurable:!0}),e}();e.Association=t}(OSF||(OSF={})),function(e){var t=function(){function e(){}return e.prototype.invokeCallback=function(e,t,n,r,o){if(0==n){var i={status:Office.AsyncResultStatus.Succeeded,value:r,asyncContext:o};"function"==typeof t&&t(i)}else{var a={status:Office.AsyncResultStatus.Failed,error:{code:n},asyncContext:o};"function"==typeof t&&t(a)}},e}();e.AsyncMethodExecutor=t}(OSF||(OSF={})),function(e){var t=function(){function t(e){this._asyncMethodExecutor=e}return t.prototype.handleSafeArrayHostResponse=function(t,n,r,o,i,a,s){var c,l;if("number"==typeof(t=e.Utility.fromSafeArray(t))?(c=[],l=t):l=(c=t)[0],1==l)return null!=(u=c[1])&&(r[u[0]]=u[1]),!1;if(o){var u;if(0==l){if(c.length>2){u=[];for(var d=1;d<c.length;d++)u[d-1]=c[d]}else u=c[1];if(r.length>0&&null!=u){var f=u[u.length-1];r.length==f?u[u.length-1]=r:l=5001}}else u=c[1];var p=null;0==l&&(p=i.fromSafeArrayHost(u)),this._asyncMethodExecutor.invokeCallback(a,o,l,p,s)}return!0},t.prototype.handleWebHostResponse=function(e,t,n,r,o,i){var a=null;0==t&&(a=r.fromWebHost(e)),this._asyncMethodExecutor.invokeCallback(o,n,t,a,i)},t}();e.AsyncMethodExecutorHelper=t}(OSF||(OSF={})),function(e){!function(e){!function(e){!function(e){e.Context="Context",e.Value="Value",e.Status="Status",e.Error="Error"}(e.Properties||(e.Properties={})),function(e){e[e.Success=0]="Success",e[e.Failed=1]="Failed"}(e.ErrorCode||(e.ErrorCode={})),function(e){e.Name="Name",e.Message="Message",e.Code="Code"}(e.ErrorProperties||(e.ErrorProperties={}))}(e.AsyncResultEnum||(e.AsyncResultEnum={}));var t=function(e,t){this.value=e.Value,this.status=t?Office.AsyncResultStatus.Failed:Office.AsyncResultStatus.Succeeded,e.Context&&(this.asyncContext=e.Context),t&&(this.error=new n(t.Name,t.Message,t.Code))};e.AsyncResult=t;var n=function(e,t,n){this.name=e,this.message=t,this.code=n};e.Error=n}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){!function(t){t.createWebClientHostControllerHelper=function(t,n){return new e.WebClientHostControllerHelper(t,n)},t.createAsyncMethodExecutorHelper=function(t){return new e.AsyncMethodExecutorHelper(t)}}(e.BootStrapExtension||(e.BootStrapExtension={}))}(OSF||(OSF={})),function(e){!function(e){e.DefaultLocale="en-us",e.OfficeJS="office.js",e.OfficeDebugJS="office.debug.js",e.OfficeStringsId="OFFICESTRINGS",e.OfficeJsId="OFFICEJS",e.HostFileId="HOST",e.OfficeStringJS="office_strings.js",e.OfficeStringDebugJS="office_strings.debug.js",e.FileVersion="16.0.18214.15000"}(e.ConstantNames||(e.ConstantNames={}))}(OSF||(OSF={})),function(e){var t=function(){function e(){}return e.NotificationConversationIdSuffix="_ntf",e}();e.Constants=t}(OSF||(OSF={})),CustomFunctionMappings||(CustomFunctionMappings={}),function(e){e.delayInitialization=function(){CustomFunctionMappings.__delay__=!0},e._association=e._association||new OSF.Association,e.associate=function(){e._association.associate.apply(e._association,arguments),delete CustomFunctionMappings.__delay__}}(CustomFunctions||(CustomFunctions={})),function(e){!function(e){!function(e){var t={},n=!1;e.getErrorArgs=function(e){var r;n||(r=Strings.OfficeOM,t[1e3]={name:r.L_InvalidCoercion,message:r.L_CoercionTypeNotSupported},t[1001]={name:r.L_DataReadError,message:r.L_GetSelectionNotSupported},t[1002]={name:r.L_InvalidCoercion,message:r.L_CoercionTypeNotMatchBinding},t[1003]={name:r.L_DataReadError,message:r.L_InvalidGetRowColumnCounts},t[1004]={name:r.L_DataReadError,message:r.L_SelectionNotSupportCoercionType},t[1005]={name:r.L_DataReadError,message:r.L_InvalidGetStartRowColumn},t[1006]={name:r.L_DataReadError,message:r.L_NonUniformPartialGetNotSupported},t[1008]={name:r.L_DataReadError,message:r.L_GetDataIsTooLarge},t[1009]={name:r.L_DataReadError,message:r.L_FileTypeNotSupported},t[1010]={name:r.L_DataReadError,message:r.L_GetDataParametersConflict},t[1011]={name:r.L_DataReadError,message:r.L_InvalidGetColumns},t[1012]={name:r.L_DataReadError,message:r.L_InvalidGetRows},t[1013]={name:r.L_DataReadError,message:r.L_InvalidReadForBlankRow},t[2e3]={name:r.L_DataWriteError,message:r.L_UnsupportedDataObject},t[2001]={name:r.L_DataWriteError,message:r.L_CannotWriteToSelection},t[2002]={name:r.L_DataWriteError,message:r.L_DataNotMatchSelection},t[2003]={name:r.L_DataWriteError,message:r.L_OverwriteWorksheetData},t[2004]={name:r.L_DataWriteError,message:r.L_DataNotMatchBindingSize},t[2005]={name:r.L_DataWriteError,message:r.L_InvalidSetStartRowColumn},t[2006]={name:r.L_InvalidFormat,message:r.L_InvalidDataFormat},t[2007]={name:r.L_InvalidDataObject,message:r.L_DataNotMatchCoercionType},t[2008]={name:r.L_InvalidDataObject,message:r.L_DataNotMatchBindingType},t[2009]={name:r.L_DataWriteError,message:r.L_SetDataIsTooLarge},t[2010]={name:r.L_DataWriteError,message:r.L_NonUniformPartialSetNotSupported},t[2011]={name:r.L_DataWriteError,message:r.L_InvalidSetColumns},t[2012]={name:r.L_DataWriteError,message:r.L_InvalidSetRows},t[2013]={name:r.L_DataWriteError,message:r.L_SetDataParametersConflict},t[3e3]={name:r.L_BindingCreationError,message:r.L_SelectionCannotBound},t[3002]={name:r.L_InvalidBindingError,message:r.L_BindingNotExist},t[3003]={name:r.L_BindingCreationError,message:r.L_BindingToMultipleSelection},t[3004]={name:r.L_BindingCreationError,message:r.L_InvalidSelectionForBindingType},t[3005]={name:r.L_InvalidBindingOperation,message:r.L_OperationNotSupportedOnThisBindingType},t[3006]={name:r.L_BindingCreationError,message:r.L_NamedItemNotFound},t[3007]={name:r.L_BindingCreationError,message:r.L_MultipleNamedItemFound},t[3008]={name:r.L_BindingCreationError,message:r.L_InvalidNamedItemForBindingType},t[3009]={name:r.L_InvalidBinding,message:r.L_UnknownBindingType},t[3010]={name:r.L_InvalidBindingOperation,message:r.L_OperationNotSupportedOnMatrixData},t[3011]={name:r.L_InvalidBinding,message:r.L_InvalidColumnsForBinding},t[4e3]={name:r.L_ReadSettingsError,message:r.L_SettingNameNotExist},t[4001]={name:r.L_SaveSettingsError,message:r.L_SettingsCannotSave},t[4002]={name:r.L_SettingsStaleError,message:r.L_SettingsAreStale},t[5e3]={name:r.L_HostError,message:r.L_OperationNotSupported},t[5001]={name:r.L_InternalError,message:r.L_InternalErrorDescription},t[5002]={name:r.L_PermissionDenied,message:r.L_DocumentReadOnly},t[5003]={name:r.L_EventRegistrationError,message:r.L_EventHandlerNotExist},t[5004]={name:r.L_InvalidAPICall,message:r.L_InvalidApiCallInContext},t[5005]={name:r.L_ShuttingDown,message:r.L_ShuttingDown},t[5007]={name:r.L_UnsupportedEnumeration,message:r.L_UnsupportedEnumerationMessage},t[5008]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[5009]={name:r.L_APINotSupported,message:r.L_BrowserAPINotSupported},t[5011]={name:r.L_APICallFailed,message:r.L_RequestTimeout},t[5012]={name:r.L_InvalidOrTimedOutSession,message:r.L_InvalidOrTimedOutSessionMessage},t[5013]={name:r.L_APICallFailed,message:r.L_InvalidApiArgumentsMessage},t[5015]={name:r.L_APICallFailed,message:r.L_WorkbookHiddenMessage},t[5016]={name:r.L_APICallFailed,message:r.L_WriteNotSupportedWhenModalDialogOpen},t[5100]={name:r.L_APICallFailed,message:r.L_TooManyIncompleteRequests},t[5101]={name:r.L_APICallFailed,message:r.L_RequestTokenUnavailable},t[5102]={name:r.L_APICallFailed,message:r.L_ActivityLimitReached},t[5103]={name:r.L_APICallFailed,message:r.L_RequestPayloadSizeLimitExceededMessage},t[5104]={name:r.L_APICallFailed,message:r.L_ResponsePayloadSizeLimitExceededMessage},t[6e3]={name:r.L_InvalidNode,message:r.L_CustomXmlNodeNotFound},t[6100]={name:r.L_CustomXmlError,message:r.L_CustomXmlError},t[6101]={name:r.L_CustomXmlExceedQuotaName,message:r.L_CustomXmlExceedQuotaMessage},t[6102]={name:r.L_CustomXmlOutOfDateName,message:r.L_CustomXmlOutOfDateMessage},t[7e3]={name:r.L_PermissionDenied,message:r.L_NoCapability},t[7001]={name:r.L_CannotNavigateTo,message:r.L_CannotNavigateTo},t[7002]={name:r.L_SpecifiedIdNotExist,message:r.L_SpecifiedIdNotExist},t[7004]={name:r.L_NavOutOfBound,message:r.L_NavOutOfBound},t[2014]={name:r.L_DataWriteReminder,message:r.L_CellDataAmountBeyondLimits},t[8e3]={name:r.L_MissingParameter,message:r.L_ElementMissing},t[8001]={name:r.L_PermissionDenied,message:r.L_NoCapability},t[8010]={name:r.L_InvalidValue,message:r.L_InvalidCellsValue},t[8011]={name:r.L_InvalidValue,message:r.L_InvalidTableOptionValue},t[8012]={name:r.L_InvalidValue,message:r.L_InvalidFormatValue},t[8020]={name:r.L_OutOfRange,message:r.L_RowIndexOutOfRange},t[8021]={name:r.L_OutOfRange,message:r.L_ColIndexOutOfRange},t[8022]={name:r.L_OutOfRange,message:r.L_FormatValueOutOfRange},t[8023]={name:r.L_FormattingReminder,message:r.L_CellFormatAmountBeyondLimits},t[1e4]={name:r.L_UserNotSignedIn,message:r.L_UserNotSignedIn},t[11e3]={name:r.L_MemoryLimit,message:r.L_CloseFileBeforeRetrieve},t[11001]={name:r.L_NetworkProblem,message:r.L_NetworkProblemRetrieveFile},t[11002]={name:r.L_InvalidValue,message:r.L_SliceSizeNotSupported},t[12007]={name:r.L_DisplayDialogError,message:r.L_DialogAlreadyOpened},t[12e3]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[12001]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[12002]={name:r.L_DisplayDialogError,message:r.L_NetworkProblem},t[12003]={name:r.L_DialogNavigateError,message:r.L_DialogInvalidScheme},t[12004]={name:r.L_DisplayDialogError,message:r.L_DialogAddressNotTrusted},t[12005]={name:r.L_DisplayDialogError,message:r.L_DialogRequireHTTPS},t[12009]={name:r.L_DisplayDialogError,message:r.L_UserClickIgnore},t[12011]={name:r.L_DisplayDialogError,message:r.L_NewWindowCrossZoneErrorString},t[13e3]={name:r.L_APINotSupported,message:r.L_InvalidSSOAddinMessage},t[13001]={name:r.L_UserNotSignedIn,message:r.L_UserNotSignedIn},t[13002]={name:r.L_UserAborted,message:r.L_UserAbortedMessage},t[13003]={name:r.L_UnsupportedUserIdentity,message:r.L_UnsupportedUserIdentityMessage},t[13004]={name:r.L_InvalidResourceUrl,message:r.L_InvalidResourceUrlMessage},t[13005]={name:r.L_InvalidGrant,message:r.L_InvalidGrantMessage},t[13006]={name:r.L_SSOClientError,message:r.L_SSOClientErrorMessage},t[13007]={name:r.L_SSOServerError,message:r.L_SSOServerErrorMessage},t[13008]={name:r.L_AddinIsAlreadyRequestingToken,message:r.L_AddinIsAlreadyRequestingTokenMessage},t[13009]={name:r.L_SSOUserConsentNotSupportedByCurrentAddinCategory,message:r.L_SSOUserConsentNotSupportedByCurrentAddinCategoryMessage},t[13010]={name:r.L_SSOConnectionLostError,message:r.L_SSOConnectionLostErrorMessage},t[13012]={name:r.L_APINotSupported,message:r.L_SSOUnsupportedPlatform},t[13013]={name:r.L_APICallFailed,message:r.L_RequestTokenUnavailable},t[5014]={name:r.L_OperationCancelledError,message:r.L_OperationCancelledErrorMessage},n=!0);var o=t[e];return o?(o.name||(o.name=t[5001].name),o.message||(o.message=t[5001].message)):o=t[5001],o},e.addErrorMessage=function(e,n){t[e]=n}}(e.ErrorCodeManager||(e.ErrorCodeManager={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t=function(){function e(e){if(this._eventInfos={},this._queuedEventsArgs={},this._eventHandlers={},this._queuedEventsArgs={},null!=e)for(var t=0;t<e.length;t++)if("string"==typeof e[t]){var n=e[t];this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}else{n=e[t].type;this._eventInfos[n]=e[t],this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}}return e.prototype.getSupportedEvents=function(){var e=[];for(var t in this._eventHandlers)e.push(t);return e},e.prototype.supportsEvent=function(e){for(var t in this._eventHandlers)if(e==t)return!0;return!1},e.prototype.hasEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&n.length>0)for(var r=0;r<n.length;r++)if(n[r]===t)return!0;return!1},e.prototype.addEventHandler=function(e,t){if("function"!=typeof t)return!1;var n=this._eventHandlers[e];return!(!n||this.hasEventHandler(e,t))&&(n.push(t),!0)},e.prototype.addEventHandlerAndFireQueuedEvent=function(e,t){var n=this._eventHandlers[e],r=!n||0==n.length,o=this.addEventHandler(e,t);return r&&o&&this.fireQueuedEvent(e),o},e.prototype.removeEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&n.length>0)for(var r=0;r<n.length;r++)if(n[r]===t)return n.splice(r,1),!0;return!1},e.prototype.clearEventHandlers=function(e){return void 0!==this._eventHandlers[e]&&this._eventHandlers[e].length>0&&(this._eventHandlers[e]=[],!0)},e.prototype.getEventHandlerCount=function(e){return null!=this._eventHandlers[e]?this._eventHandlers[e].length:-1},e.prototype.getEventInfo=function(e){return this._eventInfos[e]},e.prototype.fireEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){for(var n=this._eventHandlers[t],r=0;r<n.length;r++)n[r](e);return!0}return!1},e.prototype.fireOrQueueEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){var n=this._eventHandlers[t],r=this._queuedEventsArgs[t];return 0==n.length?r.push(e):this.fireEvent(e),!0}return!1},e.prototype.fireQueuedEvent=function(e){if(e&&this._eventHandlers[e]){var t=this._eventHandlers[e],n=this._queuedEventsArgs[e];if(t.length>0){for(var r=t[0];n.length>0;){r(n.shift())}return!0}}return!1},e.prototype.clearQueuedEvent=function(e){e&&this._eventHandlers[e]&&(this._queuedEventsArgs[e]&&(this._queuedEventsArgs[e]=[]))},e}();e.EventDispatch=t}(OSF||(OSF={})),function(e){!function(e){e.dispidEventMin=0,e.dispidInitializeEvent=0,e.dispidSettingsChangedEvent=1,e.dispidDocumentSelectionChangedEvent=2,e.dispidBindingSelectionChangedEvent=3,e.dispidBindingDataChangedEvent=4,e.dispidDocumentOpenEvent=5,e.dispidDocumentCloseEvent=6,e.dispidActiveViewChangedEvent=7,e.dispidDocumentThemeChangedEvent=8,e.dispidOfficeThemeChangedEvent=9,e.dispidDialogMessageReceivedEvent=10,e.dispidDialogNotificationShownInAddinEvent=11,e.dispidDialogParentMessageReceivedEvent=12,e.dispidObjectDeletedEvent=13,e.dispidObjectSelectionChangedEvent=14,e.dispidObjectDataChangedEvent=15,e.dispidContentControlAddedEvent=16,e.dispidLiveShareStateChangedEvent=17,e.dispidActivationStatusChangedEvent=32,e.dispidRichApiMessageEvent=33,e.dispidAppCommandInvokedEvent=39,e.dispidOnSdxSendMessageEvent=40,e.dispidDataNodeAddedEvent=60,e.dispidDataNodeReplacedEvent=61,e.dispidDataNodeDeletedEvent=62}(e.EventDispId||(e.EventDispId={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.addEventHandler=function(n,r,o,i,a,s){var c=0;function l(t){0==t&&(i.hasEventHandler(n,r)||i.addEventHandler(n,r)||(t=5010));e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(c,o,t,null,a)}var u=i.getEventInfo(n);if(u)try{if(s)return void l(0);c=u.id;var d=u.getTargetId();if(0==i.getEventHandlerCount(n))e._OfficeAppFactory.getAsyncMethodExecutor().registerEventAsync(c,u.type,d,(function(e){i.fireEvent(e)}),u,(function(t){l(e.Utility.getErrorCodeFromAsyncResult(t))}),a);else l(0)}catch(e){t.onException(c,e,o)}else l(5010)},t.removeEventHandler=function(n,r,o,i,a,s){var c=0;function l(t){e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(c,o,t,null,a)}var u=i.getEventInfo(n);if(u)try{c=u.id;var d=u.getTargetId(),f=0,p=!0;null===r?(p=i.clearEventHandlers(n),f=0):f=(p=i.removeEventHandler(n,r))?0:5003;var g=i.getEventHandlerCount(n);if(p&&0==g)e._OfficeAppFactory.getAsyncMethodExecutor().unregisterEventAsync(c,u.type,d,(function(t){l(e.Utility.getErrorCodeFromAsyncResult(t))}),a);else l(f)}catch(e){t.onException(c,e,o)}else l(5010)},t.onException=function(t,n,r){if("number"!=typeof n)throw n;e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(t,r,n,null)},t}();e.EventHelper=t}(OSF||(OSF={})),function(e){!function(e){e.ActiveViewChanged="activeViewChanged",e.AppCommandInvoked="appCommandInvoked",e.RichApiMessage="richApiMessage",e.DocumentSelectionChanged="documentSelectionChanged",e.BindingSelectionChanged="bindingSelectionChanged",e.BindingDataChanged="bindingDataChanged",e.OfficeThemeChanged="officeThemeChanged",e.DocumentThemeChanged="documentThemeChanged",e.LiveShareStateChanged="liveShareStateChanged",e.DataNodeDeleted="nodeDeleted",e.DataNodeInserted="nodeInserted",e.DataNodeReplaced="nodeReplaced",e.DialogMessageReceived="dialogMessageReceived",e.DialogParentMessageReceived="dialogParentMessageReceived",e.DialogParentEventReceived="dialogParentEventReceived",e.DialogEventReceived="dialogEventReceived",e.NodeDeleted="nodeDeleted",e.NodeInserted="nodeInserted",e.NodeReplaced="nodeReplaced",e.SettingsChanged="settingsChanged"}(e.EventType||(e.EventType={}))}(OSF||(OSF={})),function(e){!function(t){var n=function(){function t(){this.platformRemappings={web:Office.PlatformType.OfficeOnline,winrt:Office.PlatformType.Universal,win32:Office.PlatformType.PC,mac:Office.PlatformType.Mac,ios:Office.PlatformType.iOS,android:Office.PlatformType.Android},this.camelCaseMappings={powerpoint:Office.HostType.PowerPoint,onenote:Office.HostType.OneNote},this.hostInfo=e._OfficeAppFactory.getHostInfo()}return t.prototype.capitalizeFirstLetter=function(e){return e?e[0].toUpperCase()+e.slice(1).toLowerCase():e},t.getInstance=function(){return void 0===t.hostObj&&(t.hostObj=new t),t.hostObj},t.prototype.getPlatform=function(e){if(this.hostInfo&&this.hostInfo.hostPlatform){var t=this.hostInfo.hostPlatform.toLowerCase();if(this.platformRemappings[t])return this.platformRemappings[t]}return null},t.prototype.getHost=function(e){if(this.hostInfo&&this.hostInfo.hostType){var t=this.hostInfo.hostType.toLowerCase();if(this.camelCaseMappings[t])return this.camelCaseMappings[t];if(t=this.capitalizeFirstLetter(this.hostInfo.hostType),Office.HostType[t])return Office.HostType[t]}return null},t.prototype.getDefaultVersion=function(){return this.getHost()?"16.0.0000.0000":null},t.prototype.getDiagnostics=function(e){return{host:this.getHost(),version:e||this.getDefaultVersion(),platform:this.getPlatform()}},t}();t.Host=n}(e.HostName||(e.HostName={}))}(OSF||(OSF={})),function(e){!function(e){e[e.SharedApp=1]="SharedApp",e[e.CustomFunction=2]="CustomFunction",e[e.ProtectedDocDisable=4]="ProtectedDocDisable",e[e.ExperimentJsEnabled=8]="ExperimentJsEnabled",e[e.PublicAddin=16]="PublicAddin",e[e.BundleJsEnabled=32]="BundleJsEnabled",e[e.IsMos=64]="IsMos",e[e.IsMonarch=128]="IsMonarch"}(e.HostInfoFlags||(e.HostInfoFlags={}))}(OSF||(OSF={})),function(e){!function(e){e.excel="excel",e.word="word"}(e.HostInfoHostType||(e.HostInfoHostType={}))}(OSF||(OSF={})),function(e){!function(e){e.web="web",e.winrt="winrt",e.win32="win32",e.mac="mac",e.ios="ios",e.android="android"}(e.HostInfoPlatform||(e.HostInfoPlatform={}))}(OSF||(OSF={})),function(e){var t=function(){function t(e,t,n,r){this._hostInfo=e,this._webAppState=t,this._context=n,this._hostFacade=r}return t.prototype.saveAndSetDialogInfo=function(e){},t.prototype.setAgaveHostCommunication=function(){},t.prototype.createClientHostController=function(){return null},t.prototype.createAsyncMethodExecutor=function(){return null},t.prototype.createClientSettingsManager=function(){return null},t.prototype.createSettings=function(t){var n=e.OUtil.getSessionStorage();if(n){var r=n.getItem(e._OfficeAppFactory.getCachedSessionSettingsKey());r?t=JSON.parse(r):(r=JSON.stringify(t),n.setItem(e._OfficeAppFactory.getCachedSessionSettingsKey(),r))}var o=e.OUtil.deserializeSettings(t),i=this.createClientSettingsManager();return new Office.Settings(o,i)},t.prototype.prepareApiSurface=function(t){var n=t.get_featureGates();n&&(Microsoft.Office.WebExtension.FeatureGates=n),e.BootStrapExtension.prepareApiSurface&&e.BootStrapExtension.prepareApiSurface(),e.BootStrapExtension.prepareHostSpecificSurface&&e.BootStrapExtension.prepareHostSpecificSurface(),OSFPerformance.createOMEnd=OSFPerformance.now()},t.prototype.getTabbableElements=function(){return null},t}();e.InitializationHelper=t}(OSF||(OSF={})),function(e){!function(e){e.Inserted="inserted",e.DocumentOpened="documentOpened"}(e.InitializationReason||(e.InitializationReason={}))}(OSF||(OSF={})),OSF||(OSF={}),function(e){!function(t){var n,r=null,o=!1,i=["excel","word","powerpoint","outlook","office-common","office.common","office","officebase"],a=[".js",".debug.js"],s="_osfDisableHostCheck",c=function(){try{return document.currentScript}catch(e){return null}}();function l(){return u(),n.trustedTypesOptIn}function u(){if(!n){var e=function(e){var t=null!=e?e.src:null;if(!t)return null;for(var n=t.toLowerCase(),r=0;r<i.length;r++)for(var o=0;o<a.length;o++){var c=i[r]+a[o],l=n.indexOf(c);if(l>=0&&(0===l||"/"===t.charAt(l-1)||"\\"===t.charAt(l-1))&&(l+c.length===t.length||"?"===t.charAt(l+c.length))){var u=t.substring(0,l),d=n.indexOf(".debug.js",l)>0,f=e.getAttribute("data-is-sdx"),p="1"===f||"true"===f,g=e.getAttribute("data-enable-trusted-types"),h="1"===g||"true"===g;return{basePath:u,name:c,isDebugJs:d,isSdx:p,disableHostCheck:window.hasOwnProperty(s)&&!0===window._osfDisableHostCheck,trustedTypesOptIn:h}}}return null};if(!(n=e(c))){for(var t=document.getElementsByTagName("script"),r=t.length,o=0;o<r;o++)if(n=e(t[o]))return;n={basePath:"",name:"",isDebugJs:!1,isSdx:!1,disableHostCheck:!1,trustedTypesOptIn:!1}}}}t.getHostBundleJsBasePath=function(){return u(),n.basePath},t.getHostBundleJsName=function(){return u(),n.name},t.getOfficeStringJsName=function(){return u(),n.isDebugJs?e.ConstantNames.OfficeStringDebugJS:e.ConstantNames.OfficeStringJS},t.isSdx=function(){return u(),n.isSdx},t.disableHostCheck=function(){return u(),n.disableHostCheck},t.trustedTypesOptIn=l,t.loadScriptWithBasename=function(t,r,o){u();var i=t+(n.isDebugJs?".debug.js":".js");i=i.toLowerCase();var a=n.basePath+i;e.OUtil.loadScript(a,r,f())};var d=["https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js"];function f(){if(!o){o=!0;try{if(!l()||!window.trustedTypes||!window.trustedTypes.createPolicy)return null;var e=c.src,t=new URL(e).origin.toLowerCase();if(!t)return null;r=window.trustedTypes.createPolicy("officejs",{createScriptURL:function(e){var n=e.toLowerCase(),r=new URL(n).origin;if(t&&t===r)return e;for(var o=0,i=d;o<i.length;o++){if(n===i[o])return e}throw new Error("Untrusted script URL")}})}catch(e){}}return r}t.getTrustedTypesPolicy=f}(e.LoadScriptHelper||(e.LoadScriptHelper={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){t.getAuthContextAsync=function(t){function n(e){var t=e.userObjectId||"",n=e.tenantId||"",r=e.userPrincipalName||"";return{userObjectId:t,tenantId:n,userPrincipalName:r,authorityType:e.authorityType||"",authorityBaseUrl:e.authorityBaseUrl||"",puid:e.puid||"",loginHint:e.loginHint||r}}var r={toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){try{return n(JSON.parse(e))}catch(e){return null}},toWebHost:function(){return{}},fromWebHost:function(e){return n(e)}};e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(205,r,t)}}(t.Auth||(t.Auth={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t;!function(e){e[e.MaxLiveShareStateDataSizeInBytes=1024]="MaxLiveShareStateDataSizeInBytes"}(t=e.LiveShareStateParams||(e.LiveShareStateParams={}));var n=function(){function e(e){var t=this;e=e||null,this._liveShareState=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidLiveShareStateChangedEvent,type:OSF.EventType.LiveShareStateChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}},fromWebHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}}}])}return e.prototype.get=function(){return this._liveShareState},e.prototype.set=function(e){if((new TextEncoder).encode(e).length>t.MaxLiveShareStateDataSizeInBytes)throw new Error("State data size is limited to "+t.MaxLiveShareStateDataSizeInBytes+" bytes.");this._liveShareState=e},e.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},e.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},e}();e.LiveShareState=n}(Office||(Office={})),function(e){var t={"ar-sa":!0,"bg-bg":!0,"bn-in":!0,"ca-es":!0,"cs-cz":!0,"da-dk":!0,"de-de":!0,"el-gr":!0,"en-us":!0,"es-es":!0,"et-ee":!0,"eu-es":!0,"fa-ir":!0,"fi-fi":!0,"fr-fr":!0,"gl-es":!0,"he-il":!0,"hi-in":!0,"hr-hr":!0,"hu-hu":!0,"id-id":!0,"it-it":!0,"ja-jp":!0,"kk-kz":!0,"ko-kr":!0,"lo-la":!0,"lt-lt":!0,"lv-lv":!0,"ms-my":!0,"nb-no":!0,"nl-nl":!0,"nn-no":!0,"pl-pl":!0,"pt-br":!0,"pt-pt":!0,"ro-ro":!0,"ru-ru":!0,"sk-sk":!0,"sl-si":!0,"sr-cyrl-cs":!0,"sr-cyrl-rs":!0,"sr-latn-cs":!0,"sr-latn-rs":!0,"sv-se":!0,"th-th":!0,"tr-tr":!0,"uk-ua":!0,"ur-pk":!0,"vi-vn":!0,"zh-cn":!0,"zh-tw":!0},n={ar:"ar-sa",bg:"bg-bg",bn:"bn-in",ca:"ca-es",cs:"cs-cz",da:"da-dk",de:"de-de",el:"el-gr",en:"en-us",es:"es-es",et:"et-ee",eu:"eu-es",fa:"fa-ir",fi:"fi-fi",fr:"fr-fr",gl:"gl-es",he:"he-il",hi:"hi-in",hr:"hr-hr",hu:"hu-hu",id:"id-id",it:"it-it",ja:"ja-jp",kk:"kk-kz",ko:"ko-kr",lo:"lo-la",lt:"lt-lt",lv:"lv-lv",ms:"ms-my",nb:"nb-no",nl:"nl-nl",nn:"nn-no",pl:"pl-pl",pt:"pt-br",ro:"ro-ro",ru:"ru-ru",sk:"sk-sk",sl:"sl-si",sr:"sr-cyrl-cs",sv:"sv-se",th:"th-th",tr:"tr-tr",uk:"uk-ua",ur:"ur-pk",vi:"vi-vn",zh:"zh-cn"};e.getSupportedLocale=function(e,r){if(void 0===r&&(r="en-us"),!e)return r;var o;if((e=e.toLowerCase())in t)o=e;else{var i=e.split("-",1);i&&i.length>0&&(o=n[i[0]])}return o||(o=r),o}}(OSF||(OSF={})),function(e){e.OfficeOM||(e.OfficeOM={})}(Strings||(Strings={})),function(e){!function(t){var n;t.ensureOfficeStringsJs=function(){return n||(n=1==e.OUtil.getLibraryReleaseVehicle()?new Office.Promise((function(e,t){e()})):new Office.Promise((function(n,r){if(e._OfficeAppFactory.getHostInfo().hostLocale){var o=e.LoadScriptHelper.getHostBundleJsBasePath()+e._OfficeAppFactory.getHostInfo().hostLocale+"/"+e.LoadScriptHelper.getOfficeStringJsName();e.OUtil.loadScript(o,(function(o){if(o)n();else{var i=e.LoadScriptHelper.getHostBundleJsBasePath()+e.ConstantNames.DefaultLocale+"/"+e.LoadScriptHelper.getOfficeStringJsName();t.loadScript(i,(function(t){t?n():r(new Error("Cannot load "+e.ConstantNames.OfficeStringJS))}),e.LoadScriptHelper.getTrustedTypesPolicy())}}),e.LoadScriptHelper.getTrustedTypesPolicy())}else r(new Error("No host locale"))}))),n}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n;OSF.definePropertyOnNamespace(t,"url",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_docUrl()})),OSF.definePropertyOnNamespace(t,"mode",(function(){return 0==OSF._OfficeAppFactory.getOfficeAppContext().get_clientMode()?e.DocumentMode.ReadOnly:e.DocumentMode.ReadWrite})),OSF.definePropertyOnNamespace(t,"settings",(function(){if(!n){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_settingsFunc()();n=OSF._OfficeAppFactory.getInitializationHelper().createSettings(e)}return n})),t.goToByIdAsync=function(t,n,r,o){var i={};i[e.GoToType.Binding]=0,i[e.GoToType.NamedItem]=1,i[e.GoToType.Slide]=2,i[e.GoToType.Index]=3;var a={};a[e.SelectionMode.Default]=0,a[e.SelectionMode.Selected]=1,a[e.SelectionMode.None]=2;var s=i[n],c=0,l=o;"function"==typeof r?l=r:void 0!==r&&(c=a[r]);var u={toSafeArrayHost:function(){return[t,s,c]},fromSafeArrayHost:function(e){return e},toWebHost:function(){return{DdaGoToByIdMethod:{Id:t,GoToType:s,SelectionMode:c}}},fromWebHost:function(e){return e}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(82,u,l)}}(t.document||(t.document={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.sendMessage=function(e){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web){var t=OSF._OfficeAppFactory.getWebAppState();t.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t.id,OSF.AgaveHostAction.SendMessage,e])}else{var n=JSON.stringify(e);OSF._OfficeAppFactory.getClientHostController().execute(208,[n],null)}},e.registerOnMessageEventHandler=function(t){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web)e.onMessage=t;else{OSF._OfficeAppFactory.getClientHostController().registerEvent(OSF.EventDispId.dispidOnSdxSendMessageEvent,"","",(function(e,n){var r=n.toArray();t(JSON.parse(r[0]))}),null)}}}(e.messaging||(e.messaging={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(t){var n,r;OSF.definePropertyOnNamespace(t,"contentLanguage",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_dataLocale()})),OSF.definePropertyOnNamespace(t,"displayLanguage",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_appUILocale()})),OSF.definePropertyOnNamespace(t,"partitionKey",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_partitionKey()})),OSF.definePropertyOnNamespace(t,"isDialog",(function(){return OSF._OfficeAppFactory.getHostInfo().isDialog})),OSF.definePropertyOnNamespace(t,"touchEnabled",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_touchEnabled()})),OSF.definePropertyOnNamespace(t,"commerceAllowed",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_commerceAllowed()})),OSF.definePropertyOnNamespace(t,"host",(function(){return OSF.HostName.Host.getInstance().getHost()})),OSF.definePropertyOnNamespace(t,"platform",(function(){return OSF.HostName.Host.getInstance().getPlatform()})),OSF.definePropertyOnNamespace(t,"diagnostics",(function(){return OSF.HostName.Host.getInstance().getDiagnostics(OSF._OfficeAppFactory.getOfficeAppContext().get_hostFullVersion())})),OSF.definePropertyOnNamespace(t,"requirements",(function(){if(!n){var e=OSF._OfficeAppFactory.getOfficeAppContext();e&&(n=e.get_isDialog()?OSF.Requirement.RequirementsMatrixFactory.getDefaultDialogRequirementMatrix(e):OSF.Requirement.RequirementsMatrixFactory.getDefaultRequirementMatrix(e))}return n})),OSF.definePropertyOnNamespace(t,"officeTheme",(function(){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_officeThemeFunc();return e?"function"==typeof e?e():e:void 0})),OSF.definePropertyOnNamespace(t,"webAuth",(function(){if(OSF.DDA.WebAuth)return OSF.DDA.WebAuth})),OSF.definePropertyOnNamespace(t,"auth",(function(){if(OSF.DDA.Auth)return OSF.DDA.Auth})),OSF.definePropertyOnNamespace(t,"license",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_eToken()})),OSF.definePropertyOnNamespace(t,"hostSettings",(function(){if(!r){var t=OSF._OfficeAppFactory.getOfficeAppContext().get_hostSettingsFunc();if(void 0!==t){var n=t(),o=OSF.OUtil.deserializeSettings(n);r=new e.Settings(o,void 0)}}return r}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.refreshRibbon=function(e){OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[OSF._OfficeAppFactory.getWebAppState().id,OSF.AgaveHostAction.RefreshRibbonGallery,e])}}(e.ribbonGallery||(e.ribbonGallery={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.taskPaneAction||(e.taskPaneAction={})}(e.ui||(e.ui={}))}(e.context||(e.context={}))}(Office||(Office={}));var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(e){function t(){e._officeOnReadyState.officeOnReadyPromise||(e._officeOnReadyState.officeOnReadyPromise=new e.Promise((function(t,n){e._officeOnReadyState.officeOnReadyPromiseResolve=t})))}function n(n){return t(),n&&(e._officeOnReadyState.officeOnReadyFired?n(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo):e._officeOnReadyState.officeOnReadyCallbacks.push(n)),e._officeOnReadyState.officeOnReadyPromise}e._officeOnReadyState=e._officeOnReadyState||{isOfficeOnReadyCalled:!1,officeOnReadyPromise:null,officeOnReadyPromiseResolve:null,officeOnReadyCallbacks:[],officeOnReadyHostAndPlatformInfo:null,officeOnReadyFired:!1},e.initialize=e.initialize,e.onReadyInternal=n,e.onReady=function(t){return e._officeOnReadyState.isOfficeOnReadyCalled=!0,n(t)},e.fireOnReady=function(n){for(t(),e._officeOnReadyState.officeOnReadyHostAndPlatformInfo=__assign({},n),e._officeOnReadyState.officeOnReadyFired=!0,OSFPerformance.officeOnReady=OSFPerformance.now();e._officeOnReadyState.officeOnReadyCallbacks.length>0;)e._officeOnReadyState.officeOnReadyCallbacks.shift()(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo);e._officeOnReadyState.officeOnReadyPromiseResolve(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo),e._officeOnReadyState.isOfficeOnReadyCalled||OSF.OUtil.waitForFunction((function(){return"function"==typeof e.initialize}),(function(t){t&&e.initialize(OSF._OfficeAppFactory.getOfficeAppContext().get_reason())}),400,50)}}(Office||(Office={})),function(e){var t=function(){function t(t,n,r,o,i,a,s,c,l,u,d,f,p,g,h,m,y,v,b,C,_,O,S,A,E,P,R,T,I,w,F,D,x){this._id=t,this._appName=n,this._appVersion=r,this._appUILocale=o,this._dataLocale=i,this._docUrl=a,this._clientMode=s,this._settingsFunc=c,this._reason=l,this._osfControlType=u,this._eToken=d,this._correlationId=f,this._appInstanceId=p,this._touchEnabled=g,this._commerceAllowed=h,this._appMinorVersion=m,this._requirementMatrix=y,this._hostCustomMessage=v,this._hostFullVersion=b,this._isDialog=e.OUtil.isDialog(),this._clientWindowHeight=C,this._clientWindowWidth=_,this._addinName=O,this._appDomains=S,this._dialogRequirementMatrix=A,this._featureGates=E,this._officeThemeFunc=P,this._initialDisplayMode=R,this._isFromWacAutomation=T,this._wopiHostOriginForSingleSignOn=I,this._hostSettingsFunc=w,this._isWeb=F,this._nestedAppAuthBridgeType=D,this._partitionKey=x}return t.prototype.get_id=function(){return this._id},t.prototype.get_appName=function(){return this._appName},t.prototype.get_appVersion=function(){return this._appVersion},t.prototype.get_appUILocale=function(){return this._appUILocale},t.prototype.get_dataLocale=function(){return this._dataLocale},t.prototype.get_docUrl=function(){return this._docUrl},t.prototype.get_clientMode=function(){return this._isWeb?this._clientMode:0==this._clientMode?Office.DocumentMode.ReadWrite:Office.DocumentMode.ReadOnly},t.prototype.get_settingsFunc=function(){return this._settingsFunc},t.prototype.get_reason=function(){return this._reason},t.prototype.get_osfControlType=function(){return this._osfControlType},t.prototype.get_eToken=function(){return this._eToken},t.prototype.get_correlationId=function(){return this._correlationId},t.prototype.get_appInstanceId=function(){return this._appInstanceId},t.prototype.get_touchEnabled=function(){return this._touchEnabled},t.prototype.get_commerceAllowed=function(){return this._commerceAllowed},t.prototype.get_appMinorVersion=function(){return this._appMinorVersion},t.prototype.get_requirementMatrix=function(){return this._requirementMatrix},t.prototype.get_dialogRequirementMatrix=function(){return this._dialogRequirementMatrix},t.prototype.get_hostCustomMessage=function(){return this._hostCustomMessage},t.prototype.get_hostFullVersion=function(){return this._hostFullVersion},t.prototype.get_isDialog=function(){return this._isDialog},t.prototype.get_clientWindowHeight=function(){return this._clientWindowHeight},t.prototype.get_clientWindowWidth=function(){return this._clientWindowWidth},t.prototype.get_addinName=function(){return this._addinName},t.prototype.get_appDomains=function(){return this._appDomains},t.prototype.get_taskpaneUrl=function(){return this._taskpaneUrl},t.prototype.set_taskpaneUrl=function(e){this._taskpaneUrl=e},t.prototype.get_featureGates=function(){return this._featureGates},t.prototype.get_officeThemeFunc=function(){return this._officeThemeFunc},t.prototype.get_initialDisplayMode=function(){return this._initialDisplayMode?this._initialDisplayMode:0},t.prototype.get_isFromWacAutomation=function(){return this._isFromWacAutomation},t.prototype.get_wopiHostOriginForSingleSignOn=function(){return this._wopiHostOriginForSingleSignOn},t.prototype.get_hostSettingsFunc=function(){return this._hostSettingsFunc},t.prototype.get_isWeb=function(){return this._isWeb},t.prototype.get_nestedAppAuthBridgeType=function(){return this._nestedAppAuthBridgeType},t.prototype.get_partitionKey=function(){return this._partitionKey},t}();e.OfficeAppContext=t}(OSF||(OSF={})),function(e){!function(t){t.retrieveHostInfo=function(){var t={isO15:!0,isRichClient:!0,hostType:"",hostPlatform:"",hostSpecificFileVersion:"",hostLocale:"",osfControlAppCorrelationId:"",isDialog:!1,disableLogging:!1,flags:0},n="_host_Info",r=null;try{if(window.external=window.external||{},"undefined"!=typeof agaveHost&&agaveHost.GetHostInfo&&(window.external.GetHostInfo=function(){return agaveHost.GetHostInfo()}),window.external.GetHostInfo){var o=window.external.GetHostInfo();if("isDialog"==o)t.isO15=!0,t.isDialog=!0;else{var i=o.split("_host_Info=");r=i.length>1?i[1]:o}}}catch(t){e.Utility.log(JSON.stringify(t))}if(!r)try{var a=window.name;if(a){var s=JSON.parse(a);r=s?s.hostInfo:null}}catch(t){e.Utility.log(JSON.stringify(t))}r||(r=e.Utility.getQueryStringValue(n));var c=e.OUtil.getSessionStorage();if(!r&&c.getItem("hostInfoValue")&&(r=c.getItem("hostInfoValue")),r){r=decodeURIComponent(r),t.isO15=!1;var l=r.split("$");void 0===l[2]&&(l=r.split("|")),t.hostType=void 0===l[0]?"":l[0].toLowerCase(),t.hostPlatform=void 0===l[1]?"":l[1].toLowerCase(),t.hostSpecificFileVersion=void 0===l[2]?"":l[2].toLowerCase(),t.hostLocale=void 0===l[3]?"":l[3].toLowerCase(),t.osfControlAppCorrelationId=void 0===l[4]?"":l[4],"telemetry"==t.osfControlAppCorrelationId&&(t.osfControlAppCorrelationId=""),t.isDialog=void 0!==l[5]&&"isDialog"==l[5],t.disableLogging=void 0!==l[6]&&"disableLogging"==l[6],t.flags="string"==typeof l[7]&&l[7].length>0?parseInt(l[7]):0,c.setItem("hostInfoValue",r)}else t.isO15=!0,t.hostLocale=e.Utility.getQueryStringValue("locale");return t}}(e._OfficeAppFactory||(e._OfficeAppFactory={}))}(OSF||(OSF={})),function(e){var t;!function(t){var n,r,o,i,a,s,c,l,u;"undefined"!=typeof window&&(window.location&&(n=window.location.hash,r=window.location.search),o=window.name);var d={0:"Unknown",1:"Hidden",2:"Taskpane",3:"Dialog"};function f(t,n){e.AppCommandManager.initialize();var r=t.get_appName(),o=null;0!=(i.flags&e.HostInfoFlags.SharedApp)&&(o={visibilityMode:d[t.get_initialDisplayMode()]}),Office.fireOnReady({host:e.HostName.Host.getInstance().getHost(r),platform:e.HostName.Host.getInstance().getPlatform(r),addin:o}),i.hostPlatform==e.HostInfoPlatform.web&&null!=a.clientEndPoint&&a.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[a.id,e.AgaveHostAction.OfficeJsReady,Date.now()]),n(t)}t.bootstrap=function(n,r){if(a={id:null,webAppUrl:null,conversationID:null,clientEndPoint:null,wnd:window.parent,focused:!1,serviceEndPoint:null},i=t.retrieveHostInfo(),function(){!0;try{if(i.disableLogging)return void!1;window.external=window.external||{},void 0===window.external.GetLoggingAllowed||window.external.GetLoggingAllowed()}catch(e){}}(),function(){if(i.hostPlatform===e.HostInfoPlatform.web)s=new e.WebInitializationHelper(i,a,null,null);else if(i.hostPlatform===e.HostInfoPlatform.win32)s=new e.RichClientInitializationHelper(i,a,null,null);else if(i.hostPlatform===e.HostInfoPlatform.ios||i.hostPlatform===e.HostInfoPlatform.mac){if(!(window.webkit&&window.webkit.messageHandlers&&window.webkit.messageHandlers.Agave))throw e.Utility.createNotImplementedException();s=new e.WebkitInitializationHelper(i,a,null,null)}else i.hostPlatform===e.HostInfoPlatform.android||i.hostPlatform===e.HostInfoPlatform.winrt?s=new e.WebViewInitializationHelper(i,a,null,null):console.warn("Office.js is loaded inside in unknown host or platform "+i.hostPlatform)}(),s){i.hostPlatform===e.HostInfoPlatform.web&&s.saveAndSetDialogInfo(e.Utility.getQueryStringValue("_host_Info")),s.setAgaveHostCommunication(),OSFPerformance.getAppContextStart=OSFPerformance.now();s.getAppContext(window,(function(t){OSFPerformance.getAppContextEnd=OSFPerformance.now(),e.AppTelemetry.initialize(t),l=t,u=s.createClientHostController(),c=s.createAsyncMethodExecutor(),s.prepareApiSurface(t),e.BootStrapExtension.onGetAppContext?e.BootStrapExtension.onGetAppContext(t,a.wnd).then((function(){f(t,n)})):f(t,n)}),(function(e){r(e)}))}else r(new Error("Office.js cannot be initialized."))},t.getWindowName=function(){return o},t.getWindowLocationHash=function(){return n},t.getWindowLocationSearch=function(){return r},t.getAsyncMethodExecutor=function(){return c},t.getOfficeAppContext=function(){return l},t.getHostInfo=function(){return i},t.getCachedSessionSettingsKey=function(){return(null!=a.conversationID?a.conversationID:l.get_appInstanceId())+"CachedSessionSettings"},t.getWebAppState=function(){return a},t.getId=function(){return a.id},t.getInitializationHelper=function(){return s},t.getClientHostController=function(){return u}}(t=e._OfficeAppFactory||(e._OfficeAppFactory={})),e.getClientEndPoint=function(){return t.getWebAppState().clientEndPoint}}(OSF||(OSF={})),function(e){!function(e){e.Succeeded="succeeded",e.Failed="failed"}(e.AsyncResultStatus||(e.AsyncResultStatus={})),function(e){e.ReadOnly="readOnly",e.ReadWrite="readWrite"}(e.DocumentMode||(e.DocumentMode={})),function(e){e.Word="Word",e.Excel="Excel",e.PowerPoint="PowerPoint",e.Outlook="Outlook",e.OneNote="OneNote",e.Project="Project",e.Access="Access",e.Visio="Visio"}(e.HostType||(e.HostType={})),function(e){e.Inserted="inserted",e.DocumentOpened="documentOpened"}(e.InitializationReason||(e.InitializationReason={})),function(e){e.PC="PC",e.OfficeOnline="OfficeOnline",e.Mac="Mac",e.iOS="iOS",e.Android="Android",e.Universal="Universal"}(e.PlatformType||(e.PlatformType={})),function(e){e.Binding="binding",e.NamedItem="namedItem",e.Slide="slide",e.Index="index"}(e.GoToType||(e.GoToType={})),function(e){e.Default="default",e.Selected="selected",e.None="none"}(e.SelectionMode||(e.SelectionMode={})),function(e){e.Unformatted="unformatted",e.Formatted="formatted"}(e.ValueFormat||(e.ValueFormat={})),function(e){e.Text="text",e.Compressed="compressed",e.Pdf="pdf"}(e.FileType||(e.FileType={})),e.CoercionType={Html:"html",Matrix:"matrix",Ooxml:"ooxml",OoxmlPackage:"ooxmlPackage",PdfFile:"pdfFile",SlideRange:"slideRange",Table:"table",Text:"text"},function(e){e.Table="table",e.Text="text",e.Matrix="matrix"}(e.BindingType||(e.BindingType={})),function(e){e.OnlyVisible="onlyVisible",e.All="all"}(e.FilterType||(e.FilterType={})),function(e){e[e.All=0]="All",e[e.Data=1]="Data",e[e.Headers=2]="Headers"}(e.Table||(e.Table={})),function(e){e.Read="read",e.Edit="edit"}(e.ActiveView||(e.ActiveView={}))}(Office||(Office={}));var OSFPerfUtil,__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){e.appSpecificCheckOrigin=function(e,t,n,r){return!1}}(OfficeExt||(OfficeExt={})),function(e){var t=function(){function e(e,t,n){this._method=e,this._invokeType=t,this._blockingOthers=n}return e.prototype.getMethod=function(){return this._method},e.prototype.getInvokeType=function(){return this._invokeType},e.prototype.getBlockingFlag=function(){return this._blockingOthers},e}();e.XdmMethodObject=t;var n=function(){function e(e,t){this._registerMethodObject=e,this._unregisterMethodObject=t}return e.prototype.getRegisterMethodObject=function(){return this._registerMethodObject},e.prototype.getUnregisterMethodObject=function(){return this._unregisterMethodObject},e}();e.XdmEventMethodObject=n;var r=function(){function r(e){this._methodObjectList={},this._eventHandlerProxyList={},this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null,this._methodObjectList={},this._eventHandlerProxyList={},this._Id=e,this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null}return r.prototype.registerMethod=function(n,r,o,i){if(0!==o&&1!==o)throw e.Utility.createArgumentException("invokeType");var a=new t(r,o,i);this._methodObjectList[n]=a},r.prototype.unregisterMethod=function(e){delete this._methodObjectList[e]},r.prototype.registerEvent=function(e,r,o){var i=new n(new t(r,4,!1),new t(o,5,!1));this._methodObjectList[e]=i},r.prototype.registerEventEx=function(e,r,o,i,a){var s=new n(new t(r,o,!1),new t(i,a,!1));this._methodObjectList[e]=s},r.prototype.unregisterEvent=function(e){this.unregisterMethod(e)},r.prototype.registerConversation=function(t,n,r){if(e.Utility.xdmDebugLog("registerConversation: cId="+t+" Url="+n),r){if(!Array.isArray(r))throw e.Utility.createArgumentException("appDomains");this._appDomains[t]=r}this._conversations[t]={url:n}},r.prototype.unregisterConversation=function(e){delete this._conversations[e]},r.prototype.setPolicyManager=function(t){if(!t.checkPermission)throw e.Utility.createArgumentException("policyManager");this._policyManager=t},r.prototype.getPolicyManager=function(){return this._policyManager},r.prototype.dispose=function(){this._methodObjectList=null,this._eventHandlerProxyList=null,this._Id=null,this._conversations=null,this._policyManager=null,this._appDomains=null,this._onHandleRequestError=null},r}();e.XdmServiceEndPoint=r;var o,i=function(){function e(e,t,n){this._callbackList={},this._eventHandlerList={},this._hostTrustCheckStatus=0,this._checkStatusLogged=!1,this._fHostTrusted=!1,this._conversationId=e,this._targetWindow=t,this._targetUrl=n,this._callingIndex=0,this._callbackList={},this._eventHandlerList={},this._checkReceiverOriginAndRun=null}return Object.defineProperty(e.prototype,"targetUrl",{get:function(){return this._targetUrl},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hostTrustCheckStatus",{get:function(){return this._hostTrustCheckStatus},set:function(e){this._hostTrustCheckStatus=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fHostTrusted",{get:function(){return this._fHostTrusted},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"checkStatusLogged",{get:function(){return this._checkStatusLogged},set:function(e){this._checkStatusLogged=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"checkReceiverOriginAndRun",{get:function(){return this._checkReceiverOriginAndRun},set:function(e){this._checkReceiverOriginAndRun=e},enumerable:!0,configurable:!0}),e.prototype.invoke=function(e,t,n){var r=this,i=function(){var i=r._callingIndex++,a=new Date,c={callback:t,createdOn:a.getTime()};n&&"object"==typeof n&&"number"==typeof n.__timeout__&&(c.timeout=n.__timeout__,delete n.__timeout__),r._callbackList[i]=c;try{if(3!==r._hostTrustCheckStatus&&"ContextActivationManager_getAppContextAsync"!==e)throw"Access Denied";var u=new s(e,0,r._conversationId,i,n),d=l.envelope(u);r._targetWindow.postMessage(d,r._targetUrl),o._startMethodTimeoutTimer()}catch(e){try{null!==t&&t(-1,e)}finally{delete r._callbackList[i]}}};this._checkReceiverOriginAndRun?this._checkReceiverOriginAndRun(i):(this._hostTrustCheckStatus=3,i())},e.prototype.registerForEvent=function(e,t,n,r){var i=this._callingIndex++,a=new Date;this._callbackList[i]={callback:n,createdOn:a.getTime()};try{var c=new s(e,1,this._conversationId,i,r),u=l.envelope(c);this._targetWindow.postMessage(u,this._targetUrl),o._startMethodTimeoutTimer(),this._eventHandlerList[e]=t}catch(e){try{null!==n&&n(-1,e)}finally{delete this._callbackList[i]}}},e.prototype.unregisterForEvent=function(e,t,n){var r=this._callingIndex++,i=new Date;this._callbackList[r]={callback:t,createdOn:i.getTime()};try{var a=new s(e,2,this._conversationId,r,n),c=l.envelope(a);this._targetWindow.postMessage(c,this._targetUrl),o._startMethodTimeoutTimer()}catch(e){try{null!==t&&t(-1,e)}finally{delete this._callbackList[r]}}finally{delete this._eventHandlerList[e]}},e}();e.XdmClientEndPoint=i,function(t){var n=[],o=null,a=null,s=!1,u={},p={},g=!1;function h(){null!==a?s||(n.length>0?m(n.shift()):(clearInterval(a),a=null)):e.Utility.xdmDebugLog("channel is not ready.")}function m(e){s=e.getInvokeBlockingFlag(),e.invoke(),o=(new Date).getTime()}function y(){s=!1}function v(t,n){var r=!1;if(!(n&&"null"!==n&&n.length&&t&&t instanceof Array&&t.length))return r;for(var o=0;o<t.length&&!r;o++)if(-1!==t[o].indexOf("://")){var i=e.OUtil.parseUrl(n,!0);r=_(e.OUtil.parseUrl(t[o],!0),i)}return r}function b(t){if(!t||"null"===t)return!1;var n=new Array("^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.live\\.com$","^outlook-sdf\\.live\\.com$","^consumer\\.live-int\\.com$","^outlook-tdf\\.live\\.com$","^sdfpilot\\.live\\.com$","^outlook\\.office365\\.us$","^outlook\\.office365\\.com$","^exchangelabs\\.live-int\\.com$","^.*\\.dod\\.online\\.office365\\.us$","^.*\\.gov\\.online\\.office365\\.us$","^.*\\.officeapps\\.live\\.com$","^.*\\.officeapps-df\\.live\\.com$","^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$");return!0===e.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments&&n.push("^partner\\.outlook\\.cn$","^.*\\.partner\\.officewebapps\\.cn$"),new RegExp(n.join("|")).test(t)}function C(t,n){if(!t||!n||"null"===t||"null"===n)return!1;var r=e.OUtil.parseUrl(t,!0),o=e.OUtil.parseUrl(n,!0);if(null==r||null==o)return!1;var i=r.protocol===o.protocol,a=r.port===o.port,s=o.hostname,c=r.hostname,l=s===c,u=!1;return!l&&s.length>c.length+1&&(u=s.slice(-(c.length+1))==="."+c),a&&i&&(l||u)}function _(e,t){return e.hostname==t.hostname&&e.protocol==t.protocol&&e.port==t.port}function O(t){if(""!=t.data){var r,i=t.data;try{r=l.unenvelope(i)}catch(e){return}if(e.Utility.xdmDebugLog(i),0===r._messageType){var g=null==t.origin||"null"===t.origin?r._origin:t.origin;try{var O=function(t){for(var n in u)if(u[n]._conversations[t])return u[n];throw e.Utility.createArgumentException("conversationId")}(r._conversationId);e.Utility.xdmDebugLog("_receive: request, origin="+g+" sourceURL:"+O._conversations[r._conversationId]);var S=O._conversations[r._conversationId];e.Utility.xdmDebugLog("_receive: request, origin="+g+" sourceURL:"+S.url);var A=[S.url].concat(O._appDomains[r._conversationId]);if(!v(A,t.origin))if(!OfficeExt.appSpecificCheckOrigin(A,t,r._origin,v))if(!C(S.url,t.origin))throw"Failed origin check";var E=O.getPolicyManager();if(E&&!E.checkPermission(r._conversationId,r._actionName,r._data))throw"Access Denied";var P=function(t,n){var r=t._methodObjectList[n._actionName];if(!r)throw e.Utility.xdmDebugLog("The specified method is not registered on service endpoint:"+n._actionName),e.Utility.createArgumentException("messageObject");return 0===n._actionType?r:1===n._actionType?r.getRegisterMethodObject():r.getUnregisterMethodObject()}(O,r),R=new d(t.source,g,r._actionName,r._conversationId,r._correlationId,y),T=new f(P,r._data,R,O._eventHandlerProxyList,r._conversationId,r._actionName),I=!0;null==a&&((null==o||(new Date).getTime()-o>10)&&!s?(m(T),I=!1):a=setInterval(h,10)),I&&function(e){n.push(e)}(T)}catch(n){O&&O._onHandleRequestError&&O._onHandleRequestError(r,n);var w=-2;"Access Denied"==n&&(w=-5);var F=new c(r._actionName,r._conversationId,r._correlationId,w,0,n),D=l.envelope(F),x=!1;try{x=!(!t.source||!t.source.postMessage)}catch(e){}var k=!1;if(window.location.href&&t.origin&&"null"!==t.origin&&C(window.location.href,t.origin))k=!0;else if(t.origin&&"null"!==t.origin)k=b(e.OUtil.parseUrl(t.origin,!0).hostname);x&&k&&t.source.postMessage(D,g)}}else{if(1!==r._messageType)return;var N=function(t){var n=p[t];return n||e.Utility.xdmDebugLog("Unknown conversation Id."),n}(r._conversationId);if(!N)return;if(e.Utility.xdmDebugLog("_receive: response, origin="+t.origin+" targetURL:"+N._targetUrl),U=N._targetUrl,j=t.origin,!(U&&j&&"null"!==U&&"null"!==j&&U.length&&j.length&&_(e.OUtil.parseUrl(U,!0),e.OUtil.parseUrl(j,!0))))throw"Failed orgin check";if(3==N._hostTrustCheckStatus&&(N._fHostTrusted=!0),0===r._responseType){var M=N._callbackList[r._correlationId];if(M)try{M.callback&&M.callback(r._errorCode,r._data)}finally{delete N._callbackList[r._correlationId]}}else{var H=N._eventHandlerList[r._actionName];null!=H&&H(r._data)}}}var U,j}function S(){g||(!function(t){if(window.addEventListener)window.addEventListener("message",t,!1);else{if(!(navigator.userAgent.indexOf("MSIE")>-1&&window.attachEvent))throw e.Utility.xdmDebugLog("Browser doesn't support the required API."),e.Utility.createArgumentException("Browser");window.attachEvent("onmessage",t)}}(O),g=!0)}t.connect=function(e,t,n){var r=p[e];return r||(S(),r=new i(e,t,n),p[e]=r),r},t.getClientEndPoint=function(e){return p[e]},t.createServiceEndPoint=function(e){S();var t=new r(e);return u[e]=t,t},t.getServiceEndPoint=function(e){return u[e]},t.deleteClientEndPoint=function(e){delete p[e]},t.deleteServiceEndPoint=function(e){delete u[e]},t.checkUrlWithAppDomains=function(e,t){return v(e,t)},t.isTargetSubdomainOfSourceLocation=function(e,t){return C(e,t)},t._setMethodTimeout=function(e){e<=0?65e3:e},t._startMethodTimeoutTimer=function(){},t.isHostNameValidWacDomain=function(e){return b(e)}}(o=e.XdmCommunicationManager||(e.XdmCommunicationManager={}));var a=function(){function e(e,t,n,r,o){this._messageType=e,this._actionName=t,this._conversationId=n,this._correlationId=r,this._origin=window.location.origin,this._data=void 0===o?null:o}return e.prototype.getActionName=function(){return this._actionName},e.prototype.getConversationId=function(){return this._conversationId},e.prototype.getCorrelationId=function(){return this._correlationId},e.prototype.getOrigin=function(){return this._origin},e.prototype.getData=function(){return this._data},e.prototype.getMessageType=function(){return this._messageType},e}(),s=function(e){function t(t,n,r,o,i){var a=e.call(this,0,t,r,o,i)||this;return a._actionType=n,a}return __extends(t,e),t.prototype.getActionType=function(){return this._actionType},t}(a),c=function(e){function t(t,n,r,o,i,a){var s=e.call(this,1,t,n,r,a)||this;return s._errorCode=o,s._responseType=i,s}return __extends(t,e),t.prototype.getErrorCode=function(){return this._errorCode},t.prototype.getResponseType=function(){return this._responseType},t}(a),l=function(){function e(){}return e.envelope=function(e){return JSON.stringify(e)},e.unenvelope=function(e){return JSON.parse(e)},e}(),u=function(){function t(t,n,r,o,i,a){var s=this;this._invokeResultCode=0,this._requesterWindow=t,this._requesterUrl=n,this._actionName=r,this._conversationId=o,this._correlationId=i,this._invokeResultCode=0,this._responseType=a,this._send=function(t){try{var n=new c(s._actionName,s._conversationId,s._correlationId,s._invokeResultCode,s._responseType,t),r=l.envelope(n);s._requesterWindow.postMessage(r,s._requesterUrl),e.Utility.xdmDebugLog("_send: requestUrl="+s._requesterUrl+" _actionName:"+s._actionName)}catch(t){e.Utility.xdmDebugLog("ResponseSender._send error:"+t.message)}}}return t.prototype.getRequesterWindow=function(){return this._requesterWindow},t.prototype.getRequesterUrl=function(){return this._requesterUrl},t.prototype.getActionName=function(){return this._actionName},t.prototype.getConversationId=function(){return this._conversationId},t.prototype.getCorrelationId=function(){return this._correlationId},t.prototype.getSend=function(){return this._send},t.prototype.setResultCode=function(e){this._invokeResultCode=e},t}(),d=function(t){function n(n,r,o,i,a,s){var u=t.call(this,n,r,o,i,a,0)||this;return u._postCallbackHandler=s,u._send=function(t,n){null!=n&&(u._invokeResultCode=n);try{var r=new c(u._actionName,u._conversationId,u._correlationId,u._invokeResultCode,u._responseType,t),o=l.envelope(r);u._requesterWindow.postMessage(o,u._requesterUrl),u._postCallbackHandler()}catch(t){e.Utility.xdmDebugLog("InvokeCompleteCallback._send error:"+t.message)}},u}return __extends(n,t),n}(u),f=function(){function e(e,t,n,r,o,i){this._callerId="",this._methodObject=e,this._param=t,this._invokeCompleteCallback=n,this._eventHandlerProxyList=r,this._conversationId=o,this._eventName=i}return e.prototype.invoke=function(){try{var e;switch(this._methodObject.getInvokeType()){case 0:this._methodObject.getMethod()(this._param,this._invokeCompleteCallback.getSend());break;case 1:e=this._methodObject.getMethod()(this._param),this._invokeCompleteCallback.getSend()(e);break;case 4:var t=this._createEventHandlerProxyObject(this._invokeCompleteCallback);e=this._methodObject.getMethod()(t.getSend(),this._param),this._eventHandlerProxyList[this._conversationId+this._eventName]=t.getSend(),this._invokeCompleteCallback.getSend()(e);break;case 5:var n=this._eventHandlerProxyList[this._conversationId+this._eventName];e=this._methodObject.getMethod()(n,this._param),delete this._eventHandlerProxyList[this._conversationId+this._eventName],this._invokeCompleteCallback.getSend()(e);break;case 2:var r=this._createEventHandlerProxyObject(this._invokeCompleteCallback);this._methodObject.getMethod()(r.getSend(),this._invokeCompleteCallback.getSend(),this._param),this._eventHandlerProxyList[this._callerId+this._eventName]=r.getSend();break;case 3:var o=this._eventHandlerProxyList[this._callerId+this._eventName];this._methodObject.getMethod()(o,this._invokeCompleteCallback.getSend(),this._param),delete this._eventHandlerProxyList[this._callerId+this._eventName]}}catch(e){this._invokeCompleteCallback.setResultCode(-3),this._invokeCompleteCallback.getSend()(e)}},e.prototype.getInvokeBlockingFlag=function(){return this._methodObject.getBlockingFlag()},e.prototype._createEventHandlerProxyObject=function(e){return new u(e.getRequesterWindow(),e.getRequesterUrl(),e.getActionName(),e.getConversationId(),e.getCorrelationId(),1)},e}()}(OSF||(OSF={})),function(e){function t(e,t){return t+="_Resource",void 0!==oteljs?[oteljs.makeDoubleDataField(t+"_responseEnd",e.responseEnd),oteljs.makeDoubleDataField(t+"_responseStart",e.responseStart),oteljs.makeDoubleDataField(t+"_startTime",e.startTime),oteljs.makeDoubleDataField(t+"_transferSize",e.transferSize)]:[]}e.sendPerformanceTelemetry=function(){if(OSF.AppTelemetry.enableTelemetry&&"undefined"!=typeof performance&&performance.getEntriesByType){var e,n,r=OSF.LoadScriptHelper.getHostBundleJsName().toLowerCase();performance.getEntriesByType("resource").forEach((function(t){var o=t.name.toLowerCase();OSF.Utility.stringEndsWith(o,r)?e=t:(OSF.Utility.stringEndsWith(o,OSF.ConstantNames.OfficeDebugJS)||OSF.Utility.stringEndsWith(o,OSF.ConstantNames.OfficeJS))&&(n=t)})),OTel.OTelLogger.onTelemetryLoaded((function(){var r=[];e&&(r=r.concat(t(e,"HostJs"))),n&&(r=r.concat(t(n,"OfficeJs"))),r=r.concat([oteljs.makeDoubleDataField("officeExecuteStartDate",OSFPerformance.officeExecuteStartDate),oteljs.makeDoubleDataField("officeExecuteStart",OSFPerformance.officeExecuteStart),oteljs.makeDoubleDataField("officeExecuteEnd",OSFPerformance.officeExecuteEnd),oteljs.makeDoubleDataField("hostInitializationStart",OSFPerformance.hostInitializationStart),oteljs.makeDoubleDataField("hostInitializationEnd",OSFPerformance.hostInitializationEnd),oteljs.makeDoubleDataField("totalJSHeapSize",OSFPerformance.totalJSHeapSize),oteljs.makeDoubleDataField("usedJSHeapSize",OSFPerformance.usedJSHeapSize),oteljs.makeDoubleDataField("jsHeapSizeLimit",OSFPerformance.jsHeapSizeLimit),oteljs.makeDoubleDataField("getAppContextStart",OSFPerformance.getAppContextStart),oteljs.makeDoubleDataField("getAppContextEnd",OSFPerformance.getAppContextEnd),oteljs.makeDoubleDataField("getAppContextXdmStart",OSFPerformance.getAppContextXdmStart),oteljs.makeDoubleDataField("getAppContextXdmEnd",OSFPerformance.getAppContextXdmEnd),oteljs.makeDoubleDataField("createOMEnd",OSFPerformance.createOMEnd),oteljs.makeDoubleDataField("officeOnReady",OSFPerformance.officeOnReady),oteljs.makeBooleanDataField("isSharedRuntime",0!=(OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp))]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.JSPerformanceTelemetryV06",dataFields:r,eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}}}(OSFPerfUtil||(OSFPerfUtil={})),function(e){!function(t){var n,r,o={};!function(e){var t=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"];e.generateNewGuid=function(){for(var e="",n=(new Date).getTime(),r=0;r<32&&n>0;r++)8!=r&&12!=r&&16!=r&&20!=r||(e+="-"),e+=t[n%16],n=Math.floor(n/16);for(;r<32;r++)8!=r&&12!=r&&16!=r&&20!=r||(e+="-"),e+=t[Math.floor(16*Math.random())];return e}}(t.Guid||(t.Guid={})),t.loadScript=function(e,t,n,r){if(e&&t){var i=window.document,a=o[e];if(a)a.loaded?t(!0):a.pendingCallbacks.push(t);else{var s=i.createElement("script");s.type="text/javascript",a={loaded:!1,pendingCallbacks:[t],timer:null},o[e]=a;var c=function(){null!=a.timer&&(clearTimeout(a.timer),delete a.timer),a.loaded=!0;for(var e=a.pendingCallbacks.length,t=0;t<e;t++){a.pendingCallbacks.shift()(!0)}},l=function(){delete o[e],null!=a.timer&&(clearTimeout(a.timer),delete a.timer);for(var t=a.pendingCallbacks.length,n=0;n<t;n++){a.pendingCallbacks.shift()(!1)}};s.readyState?s.onreadystatechange=function(){"loaded"!=s.readyState&&"complete"!=s.readyState||(s.onreadystatechange=null,c())}:s.onload=c,s.onerror=l,r=r||3e4,a.timer=setTimeout(l,r),s.setAttribute("crossOrigin","anonymous"),s.src=n?n.createScriptURL(e):e,i.getElementsByTagName("head")[0].appendChild(s)}}},t.getSessionStorage=function(){if(!n){try{var t=window.sessionStorage}catch(e){t=null}n=new e.SafeStorage(t)}return n},t.getLocalStorage=function(){if(!r){try{var t=window.localStorage}catch(e){t=null}r=new e.SafeStorage(t)}return r},t.waitForFunction=function(e,t,n,r){var o,i=n,a=function(){i--,e()?t(!0):i>0?(o=window.setTimeout(a,r),i--):(window.clearTimeout(o),t(!1))};a()}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){e.Flights=[],e.DisabledChangeGates=[];e.FlightTreatmentNames={EnableMsal3SsoApi:"Microsoft.Office.SharedOnline.EnableMsal3SsoApi"},function(t){var n="&_flights=",r="&_disabledChangeGates=",o="_flights=",i="_disabledChangeGates=";function a(e,t){return e.substr(0,t.length)===t}function s(e,t,n,r){return a(e,t+"//"+n+":"+r)||a(e,n+":"+r)}t.isArray=function(e){return"[object Array]"===Object.prototype.toString.apply(e)},t.isFunction=function(e){return"[object Function]"===Object.prototype.toString.apply(e)},t.isDate=function(e){return"[object Date]"===Object.prototype.toString.apply(e)},t.addEventListener=function(e,t,n){if(e.addEventListener)e.addEventListener(t,n,!1);else{if(!e.attachEvent)throw new Error("Cannot attach event");e.attachEvent("on"+t,n)}},t.removeEventListener=function(e,t,n){if(e.removeEventListener)e.removeEventListener(t,n,!1);else{if(!e.detachEvent)throw new Error("Cannot remove event");e.detachEvent("on"+t,n)}};var c="Date(";function l(e){var t=[];try{t=JSON.parse(e)}catch(e){}return Array.isArray(t)||(t=[]),t}function u(e,n,r){try{var o=JSON.parse(n),i=null!=o?o[r]:null,a=t.getSessionStorage();if(!e&&a&&null!=o){var s=o.baseFrameName+r;i?a.setItem(s,i):i=a.getItem(s)}return i}catch(e){return null}}function d(e,n,r,o,i){var a=i.split(e),s=a.length>1?a[a.length-1]:null;r&&null!=s&&(s.indexOf("&")>=0&&(s=s.split("&")[0]),s=decodeURIComponent(s));var c=t.getSessionStorage();if(!o&&c){var l=window.name.indexOf(n);if(l>-1){var u=window.name.indexOf(";",l);-1==u&&(u=window.name.length);var d=window.name.substring(l,u);s?c.setItem(d,s):s=c.getItem(d)}}return s}function f(e,t){for(var n=0;n<e.length;n++)if(e.charAt(n)===t){if(n+1>=e.length)return this.removeChar(e,n);if("/"===t){if("?"===e.charAt(n+1)||"#"===e.charAt(n+1))return this.removeChar(e,n)}else if("?"===t&&"#"===e.charAt(n+1))return this.removeChar(e,n)}return e}function p(e){if(e=f(e,"/"),e=f(e,"?"),"https://"==(e=f(e,"#")).substr(0,8))-1!=(t=e.indexOf(":443"))&&(t!=e.length-4&&"/"!=e.charAt(t+4)&&"?"!=e.charAt(t+4)&&"#"!=e.charAt(t+4)||(e=e.substring(0,t)+e.substring(t+4)));else if("http://"==e.substr(0,7)){var t;-1!=(t=e.indexOf(":80"))&&(t!=e.length-3&&"/"!=e.charAt(t+3)&&"?"!=e.charAt(t+3)&&"#"!=e.charAt(t+3)||(e=e.substring(0,t)+e.substring(t+3)))}return e}function g(e){var t,n,r=[],o=[],i=e.length;for(t=0;t<i;t++)(n=e[t]).tabIndex?n.tabIndex>0?o.push(n):0===n.tabIndex&&r.push(n):r.push(n);return o=o.sort((function(e,t){var n=e.tabIndex-t.tabIndex;return 0===n&&(n=o.indexOf(e)-o.indexOf(t)),n})),[].concat(o,r)}t.serializeSettings=function(t){var n={};for(var r in t){var o=t[r];try{o=JSON.stringify(o,(function(t,n){return e.OUtil.isDate(this[t])?c+this[t].getTime()+")":n})),n[r]=o}catch(e){}}return n},t.deserializeSettings=function(e){var t={};for(var n in e=e||{}){var r=e[n];try{r=JSON.parse(r,(function(e,t){var n;return"string"==typeof t&&t&&t.length>6&&t.slice(0,5)===c&&")"===t.slice(-1)&&(n=new Date(parseInt(t.slice(5,-1))))?n:t})),t[n]=r}catch(e){}}return t},t.convertIntToCssHexColor=function(e){return"#"+(Number(e)+16777216).toString(16).slice(-6)},t.parseAppContextFromWindowName=function(e,n){return t.parseInfoFromWindowName(e,n,"appContext")},t.parseHostInfoFromWindowName=function(t,n){return e.OUtil.parseInfoFromWindowName(t,n,"hostInfo")},t.parseXdmInfo=function(e){var n=t.parseXdmInfoWithGivenFragment(e,window.location.hash);return n||(n=t.parseXdmInfoFromWindowName(e,window.name)),n},t.parseXdmInfoFromWindowName=function(t,n){return e.OUtil.parseInfoFromWindowName(t,n,"xdmInfo")},t.parseXdmInfoWithGivenFragment=function(t,n){return e.OUtil.parseInfoWithGivenFragment("&_xdm_Info=","_xdm_",!1,t,n)},t.parseFlights=function(e){var t=function(e,t){return l(d(n,o,!0,e,t))}(e,window.location.hash);return 0==t.length&&(t=function(e,t){return l(u(e,t,"flights"))}(e,window.name)),t},t.parseDisabledChangeGates=function(e){var t=function(e,t){return l(d(r,i,!0,e,t))}(e,window.location.hash);return 0==t.length&&(t=function(e,t){return l(u(e,t,"disabledChangeGates"))}(e,window.name)),t},t.checkFlight=function(t){return e.Flights&&e.Flights.indexOf(t)>=0},t.isChangeGateEnabled=function(t){return!e.DisabledChangeGates||-1===e.DisabledChangeGates.indexOf(t)},t.parseInfoFromWindowName=u,t.parseInfoWithGivenFragment=d,t.getConversationId=function(){var e=window.location.search,t=null;if(e){var n=e.indexOf("&");(t=n>0?e.substring(1,n):e.substr(1))&&"="===t.charAt(t.length-1)&&(t=t.substring(0,t.length-1))&&(t=decodeURIComponent(t))}return t},t.getInfoItems=function(e){var t=e.split("$");return void 0===t[1]&&(t=e.split("|")),void 0===t[1]&&(t=e.split("%7C")),t},t.getXdmFieldValue=function(t,n){var r="",o=e.OUtil.parseXdmInfo(n);if(o){var i=e.OUtil.getInfoItems(o);if(null!=i&&i.length>=3)switch(t){case"ConversationUrl":r=i[2];break;case"AppId":r=i[1]}}return r},t.parseUrl=function(t,n){if(void 0===n&&(n=!1),void 0!==t&&t){var r="NotHttps",o="undefined"!=typeof window&&void 0!==window.navigator&&window.navigator.userAgent.indexOf("Trident")>0,i=("undefined"!=typeof window&&void 0!==window.navigator&&window.navigator.userAgent.indexOf("Edge"),{protocol:void 0,hostname:void 0,host:void 0,port:void 0,pathname:void 0,search:void 0,hash:void 0,isPortPartOfUrl:void 0});try{if(o){var a=document.createElement("a");if(a.href=t,!(a&&a.protocol&&a.host&&a.hostname&&a.href&&p(a.href).toLowerCase()===p(t).toLowerCase()))throw"InvalidUrl";if(e.OUtil.checkFlight(2)&&n&&"https:"!=a.protocol)throw new Error(r);var c=function(e,t){return e&&t?"https:"==t.protocol&&s(e,"https:",t.hostname,"443")?":443":"http:"==t.protocol&&s(e,"http:",t.hostname,"80")?":80":"":""}(t,a);i.protocol=a.protocol,i.hostname=a.hostname,i.port=""==c?a.port:"",i.host=""!=c?a.hostname:a.host,i.pathname=(o?"/":"")+a.pathname,i.search=a.search,i.hash=a.hash,i.isPortPartOfUrl=s(t,a.protocol,a.hostname,a.port)}else{var l=new URL(t);if(l&&l.protocol&&l.host&&l.hostname){if(e.OUtil.checkFlight(2)&&n&&"https:"!=l.protocol)throw new Error(r);i.protocol=l.protocol,i.hostname=l.hostname,i.port=l.port,i.host=l.host,i.pathname=l.pathname,i.search=l.search,i.hash=l.hash,i.isPortPartOfUrl=l.host.lastIndexOf(":"+l.port)==l.host.length-l.port.length-1}}}catch(e){if(e.message===r)throw e}return i}},t.focusToFirstTabbable=function(e,t){var n,r,o=!1,i=function(e){o=!0},a=function(e,t,n){return t<0||t>e||0===t&&n?-1:t!==e-1||n?n?t-1:t+1:-1};if(e=g(e),n=t?e.length-1:0,0===e.length)return null;for(;!o&&n>=0&&n<e.length;)r=e[n],window.focus(),r.addEventListener("focus",i),r.focus(),r.removeEventListener("focus",i),n=a(e.length,n,t),o||r!==document.activeElement||(o=!0);return o?r:null},t.focusToNextTabbable=function(e,t,n){var r,o,i,a=!1,s=function(e){a=!0},c=function(e,t,n){return t<0||t>e||0===t&&n?-1:t!==e-1||n?n?t-1:t+1:-1};if(r=function(e,t){for(var n=0;n<e.length;n++)if(e[n]===t)return n;return-1}(e=g(e),t),(o=c(e.length,r,n))<0)return null;for(;!a&&o>=0&&o<e.length;)(i=e[o]).addEventListener("focus",s),i.focus(),i.removeEventListener("focus",s),o=c(e.length,o,n),a||i!==document.activeElement||(a=!0);return a?i:null},t.defineMethodOnNamespace=function(e,t,n){e[t]=n},t.isDialog=function(){return e._OfficeAppFactory.getHostInfo().isDialog},t.isPopupWindow=function(){return e.OUtil.isDialog()&&e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web&&null!=window.opener},t.getHostPlatform=function(){return e._OfficeAppFactory.getHostInfo().hostPlatform},t.getCustomOfficeInitializationSettings=function(){return"object"==typeof officeInitializationSettings?officeInitializationSettings:{}};var h=0;t.getLibraryReleaseVehicle=function(){return h},t.setLibraryReleaseVehicle=function(e){h=e}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){!function(e){e.Callback="callback",e.AsyncContext="asyncContext",e.Data="data",e.MessageToParent="messageToParent",e.MessageContent="messageContent",e.MessageOrigin="messageOrigin",e.TargetOrigin="targetOrigin",e.AppCommandInvocationCompletedData="appCommandInvocationCompletedData"}(e.ParameterNames||(e.ParameterNames={}))}(OSF||(OSF={})),function(e){!function(t){var n=function(){};t.RequirementVersion=n;var r=function(){function e(e){this._setMap=e}return e.prototype.isSetSupported=function(e,t){if(null==e)return!1;null==t&&(t=0);var n=this._setMap._sets;if(n.hasOwnProperty(e.toLowerCase())){var r=n[e.toLowerCase()];try{var o=this._getVersion(r+"");t+="";var i=this._getVersion(t);if(o.major>0&&o.major>i.major)return!0;if(o.major>0&&o.minor>=0&&o.major==i.major&&o.minor>=i.minor)return!0}catch(e){return!1}}return!1},e.prototype._getVersion=function(e){var t=(e+="").split("."),n=0,r=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),t.length>=2&&(r=Number(t[1])),isNaN(n)||isNaN(r))throw"version format incorrect";return{minor:r,major:n}},e}();t.RequirementMatrix=r;var o=function(){function e(e){this._sets=e}return e.prototype._addSetMap=function(e){for(var t in e)this._sets[t]=e[t]},e}();t.DefaultSetRequirement=o;var i=function(e){function t(){return e.call(this,{dialogapi:1.1})||this}return __extends(t,e),t}(o);t.DefaultRequiredDialogSetRequirement=i;var a=function(e){function t(){return e.call(this,{dialogorigin:1.1})||this}return __extends(t,e),t}(o);t.DefaultOptionalDialogSetRequirement=a;var s=function(){function t(){}return t.getDefaultRequirementMatrix=function(t){var n=void 0,i=t.get_requirementMatrix();if(null!=i&&i.length>0){var a=JSON.parse(t.get_requirementMatrix().toLowerCase());if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)try{var s="dialogorigin";a.hasOwnProperty(s)||(a[s]=1.1)}catch(e){}n=new r(new o(a))}else n=new r(new o({}));return n},t.getDefaultDialogRequirementMatrix=function(t){var n=void 0,s=t.get_dialogRequirementMatrix();if(null!=s&&s.length>0){var c=JSON.parse(t.get_requirementMatrix().toLowerCase());n=new o(c)}else{n=new i;var l=t.get_requirementMatrix();if(null!=l&&l.length>0&&"undefined"!=typeof JSON){c=JSON.parse(l.toLowerCase());for(var u in n._sets)c.hasOwnProperty(u)&&(n._sets[u]=c[u]);var d=new a;for(var u in d._sets)c.hasOwnProperty(u)&&(n._sets[u]=c[u])}}if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)try{var f="dialogorigin";!n._sets.hasOwnProperty(f)&&window.opener&&(n._sets[f]=1.1)}catch(e){}return new r(n)},t}();t.RequirementsMatrixFactory=s}(e.Requirement||(e.Requirement={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n;t.executeRichApiRequestAsync=function(t,n){var r={toSafeArrayHost:function(){return[t]},fromSafeArrayHost:function(e){return{data:e}},toWebHost:function(){return{ArrayData:t}},fromWebHost:function(e){return{data:e.Data}}};e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(93,r,n)},Object.defineProperty(t,"richApiMessageManager",{get:function(){return n||(n=new e.RichApiMessageManager),n}})}(t.RichApi||(t.RichApi={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){this._registerHandlers=[],this._eventDispatch=new e.EventDispatch([{type:e.EventType.RichApiMessage,id:e.EventDispId.dispidRichApiMessageEvent,getTargetId:function(){return""},fromSafeArrayHost:function(e){var n=e;return t.transferEventArgument(n)},fromWebHost:function(e){var n=e.ArrayData;return t.transferEventArgument(n)}}])}return t.transferEventArgument=function(t){var n=[];if(t)for(var r=0;r<t.length;r++){var o=t[r];o.toArray&&(o=o.toArray()),n.push({messageCategory:o[0],messageType:o[1],targetId:o[2],message:o[3],id:o[4],isRemoteOverride:o[5]})}return{type:e.EventType.RichApiMessage,entries:n}},t.prototype.addHandlerAsync=function(t,n,r){e.EventHelper.addEventHandler(t,n,r,this._eventDispatch)},t.prototype.removeHandlerAsync=function(t,n,r){e.EventHelper.removeEventHandler(t,n,r,this._eventDispatch)},t.prototype.register=function(t){var n=this;return this._registerPromise||(this._registerPromise=new Office.Promise((function(t,r){n.addHandlerAsync(e.EventType.RichApiMessage,(function(e){n._registerHandlers.forEach((function(t){t&&t(e)}))}),(function(e){"failed"==e.status?r(e.error):t()}))}))),this._registerPromise.then((function(){n._registerHandlers.push(t)}))},t}();e.RichApiMessageManager=t}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.prototype.execute=function(e,t,n){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.Execute(e,t,n,OsfOMToken):window.external.Execute(e,t,n)},t.prototype.registerEvent=function(e,t,n,r,o){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.RegisterEvent(e,n,r,o,OsfOMToken):window.external.RegisterEvent(e,n,r,o)},t.prototype.unregisterEvent=function(e,t,n,r){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.UnregisterEvent(e,n,r,OsfOMToken):window.external.UnregisterEvent(e,n,r)},t.prototype.closeSdxDialog=function(t){throw e.Utility.createNotImplementedException()},t.prototype.resizeSdxDialog=function(t,n){throw e.Utility.createNotImplementedException()},t}();e.RichClientHostController=t}(OSF||(OSF={})),function(e){var t=function(t){function n(){var e=null!==t&&t.apply(this,arguments)||this;return e.officeThemeTimeStamp=null,e.officeTheme=null,e}return __extends(n,t),n.prototype.getOsfControlContext=function(){if(!this._osfControlContext){var t="Warning: Office.js is loaded outside of Office client";try{if(!window.external)return console.error("There is no window.external."),e.Utility.trace(t),null;this._osfControlContext=window.external.GetContext()}catch(n){return console.error("Error when call window.external.GetContext() :"+JSON.stringify(n)),e.Utility.trace(t),null}}return this._osfControlContext},n.prototype.getAppContext=function(t,n,r){var o=this,i=this.getOsfControlContext();if(i){var a,s,c,l,u,d,f,p,g,h,m,y,v,b,C,_,O,S,A,E,P,R,T,I,w,F,D=0,x=!1;if((k=e.Utility.externalNativeFunctionExists)(typeof i.GetContextDataInJson))if("undefined"!=typeof OsfOMToken&&OsfOMToken)if((w=i.GetContextDataInJson(OsfOMToken))&&(F=JSON.parse(w)),F)a=F.appType,s=F.solutionRef,c=F.versionMajor,l=F.versionMinor,u=F.uiLocale,d=F.dataLocale,f=F.docUrl,p=F.clientMode,g=F.activationMode,m=F.controlType,y=F.eToken,v=F.correlationId,b=F.appInstanceId,C=F.touchEnabled,_=i.commerceAllowed,O=F.requirementMatrix,A=F.hostFullVersion,E=F.requirementMatrix,(N=F.featureGates)&&(P=JSON.parse(N)),D=F.initialDisplayMode,R=function(){var e,t=F.settings;t&&(e=JSON.parse(t));var n={};if(e)for(var r=e.names,o=e.values,i=0;i<r.length;i++)n[r[i]]=o[i];return n},T=function(){var e=F.themeInfo;return o.getOfficeThemeFromInfoString(e)};else x=!0;else x=!0;else x=!0;if(x){a=i.GetAppType(),s=i.GetSolutionRef(),c=i.GetAppVersionMajor(),l=i.GetAppVersionMinor(),u=i.GetAppUILocale(),d=i.GetAppDataLocale(),f=i.GetDocUrl(),p=i.GetAppCapabilities(),g=i.GetActivationMode(),m=i.GetControlIntegrationLevel();try{y=i.GetSolutionToken()}catch(e){}var k;if((k=e.Utility.externalNativeFunctionExists)(typeof i.GetCorrelationId)&&(v=i.GetCorrelationId()),k(typeof i.GetInstanceId)&&(b=i.GetInstanceId()),k(typeof i.GetTouchEnabled)&&(C=i.GetTouchEnabled()),k(typeof i.GetCommerceAllowed)&&(_=i.GetCommerceAllowed()),k(typeof i.GetSupportedMatrix)&&(O=i.GetSupportedMatrix()),k(typeof i.GetHostCustomMessage)&&(S=i.GetHostCustomMessage()),k(typeof i.GetHostFullVersion)&&(A=i.GetHostFullVersion()),k(typeof i.GetDialogRequirementMatrix)&&(E=i.GetDialogRequirementMatrix()),k(typeof i.GetFeaturesForSolution))try{var N;(N=i.GetFeaturesForSolution())&&(P=JSON.parse(N))}catch(t){e.Utility.trace("Exception while creating the SDX FeatureGates object. Details: "+t)}k(typeof i.GetInitialDisplayMode)&&(D=i.GetInitialDisplayMode()),R=function(){return o.getSerializedSettings()},T=function(){return o.getOfficeTheme()},I=function(){return o.getSerializedHostSettings()}}h=2===g?Office.InitializationReason.DocumentOpened:Office.InitializationReason.Inserted,y=y?y.toString():"",n(new e.OfficeAppContext(s,a,c,u,d,f,p,R,h,m,y,v,b,C,_,l,O,S,A,void 0,void 0,void 0,void 0,E,P,T,D,void 0,void 0,I,!1,void 0,void 0))}else r(new Error("The Office.js is loaded outside of Office client"))},n.prototype.createClientHostController=function(){if(!this._clientHostController){if(this._hostInfo.hostPlatform!==e.HostInfoPlatform.win32)throw e.Utility.createNotImplementedException();this._clientHostController=new e.Win32RichClientHostController}return this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this._clientHostController)},n.prototype.createClientSettingsManager=function(){return new e.RichClientSettingsManager(this.getOsfControlContext())},n.prototype.getSerializedSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).Read(t,n):e.GetSettings().Read(t,n);for(var r={},o=0;o<t.length;o++)r[t[o]]=n[o];return r},n.prototype.getOfficeTheme=function(){var e=this.getOsfControlContext();if(e){if(!(this.officeTheme&&this.officeThemeTimeStamp&&(new Date).getTime()-this.officeThemeTimeStamp<n.officeThemeCacheValidPeriod)){var t=e.GetOfficeThemeInfo();this.officeTheme=this.getOfficeThemeFromInfoString(t),this.officeThemeTimeStamp=(new Date).getTime()}return this.officeTheme}},n.prototype.getOfficeThemeFromInfoString=function(t){var n=null;if(t)try{n=JSON.parse(t)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+t)}var r={};if(n){var o={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var i in n){var a=!1,s=i;o[i]&&(s=o[i].name,a=o[i].convertToHex),r[s]=a?e.OUtil.convertIntToCssHexColor(n[i]):n[i]}}return r},n.prototype.getSerializedHostSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"function"==typeof e.GetSettings().ReadHost&&("undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).ReadHost(t,n):e.GetSettings().ReadHost(t,n));for(var r={},o=0;o<t.length;o++)r[t[o]]=n[o];return r},n.officeThemeCacheValidPeriod=5e3,n}(e.InitializationHelper);e.RichClientInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function e(e){this._osfClientContext=e}return e.prototype.read=function(e){var t,n=this._osfClientContext;t="undefined"!=typeof OsfOMToken&&OsfOMToken?n.GetSettings(OsfOMToken):n.GetSettings();var r=function(){var n=[],r=[];t.Read(n,r);for(var o={},i=0;i<n.length;i++)o[n[i]]=r[i];e&&e(0,o)};t.RefreshAsync?t.RefreshAsync((function(){r()})):r()},e.prototype.write=function(e,t){var n=[],r=[];for(var o in e)n.push(o),r.push(e[o]);var i,a=this._osfClientContext;void 0!==(i="undefined"!=typeof OsfOMToken&&OsfOMToken?a.GetSettings(OsfOMToken):a.GetSettings()).WriteAsync?i.WriteAsync(n,r,t):(i.Write(n,r),t(0))},e}();e.RichClientSettingsManager=t}(OSF||(OSF={})),function(e){var t=function(t){function n(n){var r=t.call(this)||this;return r._clientHostController=n,r._asyncMethodExecutorHelper=e.BootStrapExtension.createAsyncMethodExecutorHelper(r),r}return __extends(n,t),n.prototype.executeAsync=function(t,n,r,o){var i=this;try{var a=new Array;this._clientHostController.execute(t,n.toSafeArrayHost(),(function(s,c){var l=e.Utility.fromSafeArray(s);return i._asyncMethodExecutorHelper.handleSafeArrayHostResponse(l,c,a,r,n,t,o)}))}catch(e){this.onException(e,t,r)}},n.prototype.registerEventAsync=function(t,n,r,o,i,a,s){var c=this;try{this._clientHostController.registerEvent(t,n,r,(function(t,n){var r=e.Utility.fromSafeArray(n),a=i.fromSafeArrayHost(r);o(a)}),(function(n){var r,o=e.Utility.fromSafeArray(n);return"number"==typeof o?([],r=o):r=o[0],c.invokeCallback(t,a,r,null,s),!0}))}catch(e){this.onException(e,t,a)}},n.prototype.unregisterEventAsync=function(t,n,r,o,i){var a=this;try{this._clientHostController.unregisterEvent(t,n,r,(function(n,r){var s,c=e.Utility.fromSafeArray(n);return"number"==typeof c?([],s=c):s=c[0],a.invokeCallback(t,o,s,null,i),!0}))}catch(e){this.onException(e,t,o)}},n.prototype.onException=function(t,n,r){var o,i=t.number;if(i)switch(i){case-2146828218:o=7e3;break;case-2147467259:o=n==e.EventDispId.dispidDialogMessageReceivedEvent?12007:5001;break;case-2146828283:case-2147209089:o=5010;break;case-2147208704:o=5100;break;case-2146827850:default:o=5001}r&&this.invokeCallback(n,r,o||5001,null)},n}(e.AsyncMethodExecutor);e.SafeArrayAsyncMethodExecutor=t}(OSF||(OSF={})),function(e){var t=function(){function e(e){this._internalStorage=e}return e.prototype.getItem=function(e){try{return this._internalStorage&&this._internalStorage.getItem(e)}catch(e){return null}},e.prototype.setItem=function(e,t){try{this._internalStorage&&this._internalStorage.setItem(e,t)}catch(e){}},e.prototype.clear=function(){try{this._internalStorage&&this._internalStorage.clear()}catch(e){}},e.prototype.removeItem=function(e){try{this._internalStorage&&this._internalStorage.removeItem(e)}catch(e){}},e.prototype.getKeysWithPrefix=function(e){var t=[];try{for(var n=this._internalStorage&&this._internalStorage.length||0,r=0;r<n;r++){var o=this._internalStorage.key(r);0===o.indexOf(e)&&t.push(o)}}catch(e){}return t},e}();e.SafeStorage=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t){var n=this;this._clientSettingsManager=t,e=e||{},this._settings=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidSettingsChangedEvent,type:OSF.EventType.SettingsChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}},fromWebHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}}}])}return t.prototype.cacheSessionSettings=function(e){var t=OSF.OUtil.getSessionStorage();if(t){var n=OSF.OUtil.serializeSettings(e),r=JSON.stringify(n);t.setItem(OSF._OfficeAppFactory.getCachedSessionSettingsKey(),r)}},t.prototype.get=function(e){var t=this._settings[e];return void 0===t?null:t},t.prototype.set=function(e,t){this._settings[e]=t,this.cacheSessionSettings(this._settings)},t.prototype.remove=function(e){delete this._settings[e],this.cacheSessionSettings(this._settings)},t.prototype.saveAsync=function(e){var t=this._clientSettingsManager,n=OSF.OUtil.serializeSettings(this._settings);t.write(n,(function(t){var n=OSF.Utility.asyncResultFromErrorCode(t);e&&e(n)}))},t.prototype.refreshAsync=function(t){var n=this;this._clientSettingsManager.read((function(r,o){var i=OSF.Utility.asyncResultFromErrorCode(r);i.status===e.AsyncResultStatus.Succeeded&&(n._settings=OSF.OUtil.deserializeSettings(o),i.value=n),t&&t(i)}))},t.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},t.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},t.prototype.toJSON=function(){return this._settings},t}();e.Settings=t}(Office||(Office={}));var OSFWebkit,OTel,Microsoft,__awaiter=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function s(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){e.done?o(e.value):new n((function(t){t(e.value)})).then(a,s)}c((r=r.apply(e,t||[])).next())}))},__generator=this&&this.__generator||function(e,t){var n,r,o,i,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return i={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function s(i){return function(s){return function(i){if(n)throw new TypeError("Generator is already executing.");for(;a;)try{if(n=1,r&&(o=2&i[0]?r.return:i[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,i[1])).done)return o;switch(r=0,o&&(i=[2&i[0],o.value]),i[0]){case 0:case 1:o=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,r=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!(o=a.trys,(o=o.length>0&&o[o.length-1])||6!==i[0]&&2!==i[0])){a=0;continue}if(3===i[0]&&(!o||i[1]>o[0]&&i[1]<o[3])){a.label=i[1];break}if(6===i[0]&&a.label<o[1]){a.label=o[1],o=i;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(i);break}o[2]&&a.ops.pop(),a.trys.pop();continue}i=t.call(e,a)}catch(e){i=[6,e],r=0}finally{n=o=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,s])}}};!function(e){var t=function(){function t(){}return t.isSovereignVersion=function(){return"undefined"!=typeof isOsfSovereignVersion&&!0===isOsfSovereignVersion},t.prototype.getEnvironmentName=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())&&e.envName?e.envName:null]}}))}))},t.prototype.getEnvironmentType=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())&&e.envType?e.envType:null]}}))}))},t.prototype.getTrustedHostOrigins=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())?e.trustedHostOrigins:null]}}))}))},t.prototype.isConfigAvailable=function(){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,!!e.sent()]}}))}))},t.prototype.isSovereignHostTrusted=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return e?e===window.location.hostname?[2,!0]:[4,this.getTrustedHostOrigins()]:[2,!1];case 1:return(t=n.sent())&&0!=t.length?[2,new RegExp(t.join("|")).test(e)]:[2,!1]}}))}))},t.prototype.getConfigPath=function(){var t=e.LoadScriptHelper.getHostBundleJsBasePath();if(t){var n="/lib/",r=(t=t.toLowerCase()).indexOf(n);if(r>-1)return t.toLowerCase().substring(0,r+n.length)+"officeconfig.json"}return""},t.prototype.getConfig=function(){return this._configPromise||(this._configPromise=this.tryLoadConfig()),this._configPromise},t.prototype.tryLoadConfig=function(){return __awaiter(this,void 0,void 0,(function(){var t,n,r,o,i,a,s;return __generator(this,(function(c){switch(c.label){case 0:if(!(t=this.getConfigPath()))return[3,2];if(n=e.OUtil.getLocalStorage(),r=t+"_cache",o=n.getItem(r),i=null,o){try{i=JSON.parse(o)}catch(e){}if(864e5,a=(new Date).getTime(),i&&i.config&&i.createTime<=a&&i.createTime+864e5>=a)return[2,i.config]}return[4,this.downloadConfig(t)];case 1:return(s=c.sent())?(i={createTime:(new Date).getTime(),config:s},n.setItem(r,JSON.stringify(i))):i&&(s=i.config),[2,s];case 2:return[2,null]}}))}))},t.prototype.downloadConfig=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return t.trys.push([0,3,,4]),[4,fetch(e)];case 1:return[4,t.sent().json()];case 2:return[2,t.sent()];case 3:return t.sent(),[3,4];case 4:return[2,null]}}))}))},t}();e.SovereignHelper=t}(OSF||(OSF={})),function(e){!function(e){function t(e){return void 0===e||null===e}e.createParameterException=function(e){return new Error("Parameter count mismatch: "+e)},e.createArgumentException=function(e){return new Error("Invalid argument "+e)},e.createNotImplementedException=function(){return new Error("Not implemented yet")},e.log=function(e){console.log(e)},e.trace=function(e){console.log(e)},e.debugLog=function(e){console.log(e)},e.getQueryStringValue=function(e){if("undefined"!=typeof window&&window.location&&window.location.search){var t=new RegExp("[?&]"+e+"=([^&]*)").exec(window.location.search);if(t)return t[1]}return null},e.isNullOrUndefined=t,e.isNullOrEmpty=function(e){return!!t(e)||0===e.length},e.isInUnittest=function(){return"boolean"==typeof g_osfUnittest&&g_osfUnittest}}(e.Utility||(e.Utility={}))}(OSF||(OSF={})),function(e){e.isOfficeReactNative=function(){try{return"undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka}catch(e){return!1}},function(e){function t(e){return new Promise(e)}function n(e){var t=e,o=1;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray)if(e.dimensions&&(o=e.dimensions()),2===o)t=r(e);else{var i=e.toArray();t=new Array(i.length);for(var a=0;a<i.length;a++)t[a]=n(i[a])}return t}function r(e){var t;try{var n=e.ubound(1),r=e.ubound(2);if(e=e.toArray(),1==n&&1==r)t=[e];else{t=[];for(var o=0;o<n;o++){for(var i=[],a=0;a<r;a++){var s=e[o*r+a];"{66e7831f-81b2-42e2-823c-89e872d541b3}"!=s&&i.push(s)}i.length>0&&t.push(i)}}}catch(e){}return t}e.xdmDebugLog=function(t){e._DebugXdm&&console.log(t)},e.enableDebugXdm=function(){e._DebugXdm=!0},e.createPromiseFromResult=function(e){return Promise.resolve(e)},e.createPromise=t,e.promisify=function(e,n){return t((function(t,r){e((function(e){0===e?t():r()})),setTimeout((function(){r()}),n)}))},e.compareVersions=function(e,t){var n,r=e.split("."),o=t.split(".");for(n in r){if(parseInt(r[n])<parseInt(o[n]))return!1;if(parseInt(r[n])>parseInt(o[n]))return!0}return!1},e.getErrorCodeFromAsyncResult=function(e){return e.status===Office.AsyncResultStatus.Succeeded?0:e.error&&e.error.code?e.error.code:5001},e.externalNativeFunctionExists=function(e){return"unknown"===e||"undefined"!==e},e.stringEndsWith=function(t,n){if(e.isNullOrUndefined(t))throw e.createArgumentException("value");if(e.isNullOrUndefined(n))throw e.createArgumentException("subString");return!(n.length>t.length)&&t.substr(t.length-n.length)===n},e.fromSafeArray=function(e){var t=e;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray){var r=e.toArray();t=new Array(r.length);for(var o=0;o<r.length;o++)t[o]=n(r[o])}return t},e.twoDVBArrayToJaggedArray=r,e.asyncResultFromErrorCode=function(e){return Array.isArray(e)&&1===e.length&&(e=e[0]),0===e?{status:Office.AsyncResultStatus.Succeeded}:{status:Office.AsyncResultStatus.Failed,error:{code:e}}},e._DebugXdm=!1}(e.Utility||(e.Utility={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(n){var r=t.call(this)||this;return r._clientHostController=n,r._asyncMethodExecutorHelper=e.BootStrapExtension.createAsyncMethodExecutorHelper(r),r}return __extends(n,t),n.prototype.executeAsync=function(e,t,n,r){var o=this;this._clientHostController.execute(e,t.toWebHost(),(function(i,a){return n&&o._asyncMethodExecutorHelper.handleWebHostResponse(a,i,n,t,e,r),!0}))},n.prototype.registerEventAsync=function(e,t,n,r,o,i,a){var s=this;this._clientHostController.registerEvent(e,t,n,(function(e){var t=e,n=o.fromWebHost(t);r(n)}),(function(t,n){return i&&s.invokeCallback(e,i,t,null,a),!0}))},n.prototype.unregisterEventAsync=function(e,t,n,r,o){var i=this;this._clientHostController.unregisterEvent(e,t,n,(function(t,n){return r&&i.invokeCallback(e,r,t,null,o),!0}))},n}(e.AsyncMethodExecutor);e.WebAsyncMethodExecutor=t}(OSF||(OSF={})),function(e){!function(t){!function(t){t.getAuthContextAsync=function(t){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(99,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.authContext}},t)}}(t.WebAuth||(t.WebAuth={}))}(e.DDA||(e.DDA={})),function(t){var n;!function(e){e.AuthCode="authcode",e.Broker="broker",e.Implicit="implicit"}(n=t.AuthFlow||(t.AuthFlow={})),t.loadAttempts=0;var r="webauth/",o="webauth.browserauth.debug.js",i="webauth.browserauth.js",a=!1;t.load=function(){return t.config&&t.config.authFlow===n.AuthCode?(t.loadAttempts++,(a=t.config&&(!0===t.config.useMsal3||!1!==t.config.useMsal3&&e.OUtil.checkFlight(e.FlightTreatmentNames.EnableMsal3SsoApi)))&&(o="webauth.browserauth.msal3.debug.js",i="webauth.browserauth.msal3.js"),new Promise((function(n,s){var c=function(t,n,r){return new Promise((function(o,i){t?e.OUtil.loadScript(t,(function(e){if("boolean"!=typeof e||e)if(e instanceof Event&&e)i(new Event("loadScript: "+e.type+" '"+t+"'"));else if(r&&!n())var a=0,s=setInterval((function(){a+=500,!(n()||a>r)||(clearInterval(s),n())||i(new Event("Missing expected object after loaded."))}),500);else o(null);else i(new Event("loadScript: failed to load '"+t+"'"))}),e.LoadScriptHelper.getTrustedTypesPolicy(),r):o(null)}))},l=[c(t.config&&t.config.authVersion?e.LoadScriptHelper.getHostBundleJsBasePath()+r+t.config.authVersion+"/"+(t.config&&t.config.debugging?o:i):e.LoadScriptHelper.getHostBundleJsBasePath()+r+(t.config&&t.config.debugging?o:i),(function(){return!!BrowserAuth}),t.config.delayWebAuth)];a||l.push(c(t.config.msal,(function(){return!!msal}),t.config.delayMsal)),Promise.all(l).then((function(){t.config?BrowserAuth.Load(t.config,e._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId).then((function(e){n(e)}),(function(e){s(e)})):s(new Event("config is empty."))}),(function(e){s(e)}))}))):new Promise((function(e,t){return t(new Event("'authcode' as authFlow is only supported"))}))},t.getToken=function(e,r,o,i,s,c){return t.config&&t.config.authFlow===n.AuthCode?a?BrowserAuth.GetToken({resource:e,scopes:r,applicationId:o,correlationId:i,popup:!!s,claims:c}):BrowserAuth.GetToken(e,o,i,!!s,!!s,!1,c):Promise.reject(new Event("'authcode' as authFlow is only supported"))}}(e.WebAuth||(e.WebAuth={}))}(OSF||(OSF={})),function(e){var t=function(){function t(t){this._delegateVersion=1,this._webAppState=t,this._webClientHostControllerHelper=e.BootStrapExtension.createWebClientHostControllerHelper(this._webAppState,this._delegateVersion)}return t.prototype.execute=function(e,t,n){var r=this,o=this._webClientHostControllerHelper.getHostCallArgs(e,t),i=this._webClientHostControllerHelper.getTargetMethodName(e);this._webAppState.clientEndPoint.invoke(i,(function(t,o){var i=0;if(0==t)r._delegateVersion=o.Version,i=r._webClientHostControllerHelper.parseErrorFromPayload(e,o);else switch(t){case-5:i=7e3;break;default:i=5001}n&&n(i,o)}),o)},t.prototype.registerEvent=function(e,t,n,r,o){this._webAppState.clientEndPoint.registerForEvent(this.getXdmEventName(n,t),(function(e){r&&r(e)}),this._getOnAfterRegisterEvent(!0,e,o),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.unregisterEvent=function(e,t,n,r){this._webAppState.clientEndPoint.unregisterForEvent(this.getXdmEventName(n,t),this._getOnAfterRegisterEvent(!1,e,r),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.messageParent=function(t){throw e.Utility.createNotImplementedException()},t.prototype.openDialog=function(t,n,r,o,i){throw e.Utility.createNotImplementedException()},t.prototype.closeDialog=function(t,n,r,o){throw e.Utility.createNotImplementedException()},t.prototype.sendMessage=function(t){throw e.Utility.createNotImplementedException()},t.prototype.closeSdxDialog=function(t){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,e.AgaveHostAction.CloseSDXDialog,{InstanceId:this._webAppState.id,DialogCloseCallbackParam:t}])},t.prototype.resizeSdxDialog=function(t,n){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,e.AgaveHostAction.ResizeSDXDialog,{InstanceId:this._webAppState.id,DialogWidth:t+"px",DialogHeight:n+"px"}])},t.prototype.getXdmEventName=function(t,n){return n==e.EventType.BindingSelectionChanged||n==e.EventType.BindingDataChanged||n==e.EventType.DataNodeDeleted||n==e.EventType.DataNodeInserted||n==e.EventType.DataNodeReplaced?t+"_"+n:n},t.prototype._getOnAfterRegisterEvent=function(t,n,r){var o=(new Date).getTime();return function(i,a){var s;if(0!=i)switch(i){case-5:s=7e3;break;default:s=5001}else s=a?a.Error?a.Error:0:5001;r&&r(s),e.AppTelemetry&&e.AppTelemetry.onRegisterDone(t,n,Math.abs((new Date).getTime()-o),s)}},t}();e.WebClientHostController=t}(OSF||(OSF={})),function(e){var t=function(){function e(e,t){this._webAppState=e,this._delegateVersion=t}return e.prototype.getHostCallArgs=function(e,t){var n=t;return n||(n={}),n.DdaMethod={ControlId:this.getControlId(),DispatchId:e,Version:this._delegateVersion},n.__timeout__=-1,n},e.prototype.getTargetMethodName=function(e){return"executeMethod"},e.prototype.parseErrorFromPayload=function(e,t){return t.Error},e.prototype.getControlId=function(){return this._webAppState.id},e}();e.WebClientHostControllerHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.prototype.read=function(t){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(75,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.Properties.Settings}},(function(e){if(e.status===Office.AsyncResultStatus.Succeeded){for(var n={},r=0;r<e.value.length;r++){var o=e.value[r];Array.isArray(o)?n[o[0]]=o[1]:n[o.Name]=o.Value}t(0,n)}else{var i=e.error.code;t(i,{})}}))},t.prototype.write=function(t,n){var r=e._OfficeAppFactory.getAsyncMethodExecutor(),o=[];for(var i in t){var a=[];a.push(i),a.push(t[i]),o.push(a)}var s={toSafeArrayHost:function(){return null},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{DdaSettingsMethod:{OverwriteIfStale:!0,Properties:o}}},fromWebHost:function(e){return null}};r.executeAsync(76,s,(function(e){if(e.status===Office.AsyncResultStatus.Succeeded)n(0);else{var t=e.error.code;n(t)}}))},t}();e.WebClientSettingsManager=t}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,o){var i=t.call(this,e,n,r,o)||this;return i._appContext={},i._tabbableElements="a[href]:not([tabindex='-1']),area[href]:not([tabindex='-1']),button:not([disabled]):not([tabindex='-1']),input:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),textarea:not([disabled]):not([tabindex='-1']),*[tabindex]:not([tabindex='-1']),*[contenteditable]:not([disabled]):not([tabindex='-1'])",i}return __extends(n,t),Object.defineProperty(n.prototype,"isHostOriginTrusted",{get:function(){return this._isHostOriginTrustedFunc},set:function(e){this._isHostOriginTrustedFunc=e},enumerable:!0,configurable:!0}),n.prototype.saveAndSetDialogInfo=function(t){var n,r=e.OUtil.getSessionStorage();if(r){if(t||(t=e.OUtil.parseHostInfoFromWindowName(!0,e._OfficeAppFactory.getWindowName())),t&&t.indexOf("isDialog")>-1){var o=(n=e.OUtil.parseXdmInfo(!0))?n.split("|")[1]:null;return null!=o&&r.setItem(o+"IsDialog","true"),void(this._hostInfo.isDialog=!0)}this._hostInfo.isDialog=null!=r.getItem(e.OUtil.getXdmFieldValue("AppId",!1)+"IsDialog")}},n.prototype.checkReceiverOriginAndRun=function(t){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a,s,c,l,u,d;return __generator(this,(function(f){switch(f.label){case 0:return 3===(n=this)._webAppState.clientEndPoint.hostTrustCheckStatus?(t(),[2]):(r=e.OUtil.parseUrl(n._webAppState.clientEndPoint.targetUrl,!1),o="https:"==r.protocol,i=r.hostname,a="NotHttps",0!==n._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(o||(n._webAppState.clientEndPoint.hostTrustCheckStatus=2),2==n._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(s=!1,(c=e.SovereignHelper.isSovereignVersion())&&!0!==e.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments||(s=e.XdmCommunicationManager.isHostNameValidWacDomain(i),n.isHostOriginTrusted&&(s=s||n.isHostOriginTrusted(i))),s||!c?[3,3]:(n._sovereignHelper||(n._sovereignHelper=new e.SovereignHelper),[4,(l=n._sovereignHelper).isConfigAvailable()]))));case 1:return f.sent()?[4,l.isSovereignHostTrusted(i)]:[2];case 2:s=f.sent(),f.label=3;case 3:s&&(n._webAppState.clientEndPoint.hostTrustCheckStatus=3),f.label=4;case 4:if(n._webAppState.clientEndPoint.checkStatusLogged||null==n._hostInfo||void 0===n._hostInfo||(e.AppTelemetry.onCheckWACHost(n._webAppState.clientEndPoint.hostTrustCheckStatus,n._webAppState.id,n._hostInfo.hostType,n._hostInfo.hostPlatform,n._webAppState.clientEndPoint.targetUrl),n._webAppState.clientEndPoint.checkStatusLogged=!0),3===n._webAppState.clientEndPoint.hostTrustCheckStatus||e.LoadScriptHelper.disableHostCheck())t();else{if(e.LoadScriptHelper.isSdx())throw new Error("Not supported host");u=function(){var r=e.LoadScriptHelper.getHostBundleJsBasePath().match(/^https?:\/\/[^:/?#]*(?::([0-9]+))?/);if(r&&r[0]){var s=e.LoadScriptHelper.getHostBundleJsBasePath()+"AgaveErrorUX/index.html#",c={error:"NotTrustedWAC",locale:e.getSupportedLocale(n._hostInfo.hostLocale,e.ConstantNames.DefaultLocale),hostname:i,noHttps:!o,validate:!1},l=document.createElement("iframe");l.style.visibility="hidden",l.style.height="0",l.style.width="0";var u=function(o){if(o.source==l.contentWindow&&o.origin==r[0])try{!0===JSON.parse(o.data).hostUserTrusted?(n._webAppState.clientEndPoint.hostTrustCheckStatus=3,e.OUtil.removeEventListener(window,"message",u),document.body.removeChild(l)):(c.validate=!1,window.location.replace(s+encodeURIComponent(JSON.stringify(c)))),t()}catch(t){e.OUtil.ensureOfficeStringsJs().then((function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC}))}};e.OUtil.addEventListener(window,"message",u),c.validate=!0,l.setAttribute("src",s+encodeURIComponent(JSON.stringify(c))),l.onload=function(){var e={hostname:i,noHttps:!o};l.contentWindow.postMessage(JSON.stringify(e),r[0])},document.body.appendChild(l)}else e.OUtil.ensureOfficeStringsJs().then((function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC}));if(e.OUtil.checkFlight(2)&&!o)throw new Error(a)},document.body?u():(d=!1,document.addEventListener("DOMContentLoaded",(function(){d||(d=!0,u())})))}return[2]}}))}))},n.prototype.setAgaveHostCommunication=function(){try{var t=this,n=e.OUtil.parseXdmInfoWithGivenFragment(!1,e._OfficeAppFactory.getWindowLocationHash());if(n||(n=e.OUtil.parseXdmInfoFromWindowName(!1,e._OfficeAppFactory.getWindowName())),n){var r=e.OUtil.getInfoItems(n);null!=r&&r.length>=3&&(t._webAppState.conversationID=r[0],t._webAppState.id=r[1],t._webAppState.webAppUrl=r[2].indexOf(":")>=0?r[2]:decodeURIComponent(r[2]))}if(t._webAppState.wnd=null!=window.opener?window.opener:window.parent,this._hostInfo.isDialog&&null!=window.opener)return;t._webAppState.clientEndPoint=e.XdmCommunicationManager.connect(t._webAppState.conversationID,t._webAppState.wnd,t._webAppState.webAppUrl),t._webAppState.serviceEndPoint=e.XdmCommunicationManager.createServiceEndPoint(t._webAppState.id),t._webAppState.clientEndPoint.checkReceiverOriginAndRun=function(e){t.checkReceiverOriginAndRun(e)};var o=t._webAppState.conversationID+e.Constants.NotificationConversationIdSuffix;t._webAppState.serviceEndPoint.registerConversation(o,t._webAppState.webAppUrl);t._webAppState.serviceEndPoint.registerMethod("Office_notifyAgave",(function(n){var r;switch(r="string"==typeof n?n:n[0]){case e.AgaveHostAction.Select:t._webAppState.focused=!0;break;case e.AgaveHostAction.UnSelect:t._webAppState.focused=!1;break;case e.AgaveHostAction.TabIn:case e.AgaveHostAction.CtrlF6In:window.focus();var o=document.querySelectorAll(t._tabbableElements);e.OUtil.focusToFirstTabbable(o,!1)||(window.blur(),t._webAppState.focused=!1,t._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t._webAppState.id,e.AgaveHostAction.ExitNoFocusable]));break;case e.AgaveHostAction.TabInShift:window.focus();o=document.querySelectorAll(t._tabbableElements);e.OUtil.focusToFirstTabbable(o,!0)||(window.blur(),t._webAppState.focused=!1,t._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t._webAppState.id,e.AgaveHostAction.ExitNoFocusableShift]));break;case e.AgaveHostAction.SendMessage:if(Office.context.messaging.onMessage){var i=n[1];Office.context.messaging.onMessage(i)}break;case e.AgaveHostAction.TaskPaneHeaderButtonClicked:Office.context.ui.taskPaneAction.onHeaderButtonClick&&Office.context.ui.taskPaneAction.onHeaderButtonClick();break;default:e.Utility.trace("actionId "+r+" notifyAgave is wrong.")}}),0,!1),t.addOrRemoveEventListenersForWindow(!0)}catch(t){throw e.AppTelemetry&&e.AppTelemetry.logAppException("Exception thrown in setAgaveHostCommunication. Exception:["+t+"]"),t}},n.prototype.getAppContext=function(t,n,r){var o=this,i=this,a=function(t,a){if(OSFPerformance.getAppContextXdmEnd=OSFPerformance.now(),a._appName===e.AppName.ExcelWebApp){var s=a._settings;o._serializedSettings={};for(var c=0,l=s;c<l.length;c++){var u=l[c],d=u[0],f=u[1];o._serializedSettings[d]=f}var p=a._hostSettings;o._serializedHostSettings={};for(var g=0,h=p;g<h.length;g++){var m=h[g];d=m[0],f=m[1];o._serializedHostSettings[d]=f}}else o._serializedSettings=a._settings,o._serializedHostSettings=a._hostSettings;if(!i._hostInfo.isDialog||null==window.opener){var y=window.location.href;i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,e.AgaveHostAction.UpdateTargetUrl,y])}if(0===t&&null!=a._id&&null!=a._appName&&null!=a._appVersion&&null!=a._appUILocale&&null!=a._dataLocale&&null!=a._docUrl&&null!=a._clientMode&&null!=a._reason){i._appContext=a;var v=a._appInstanceId?a._appInstanceId:a._id,b=0;null!=a._appMinorVersion&&(b=a._appMinorVersion);var C=void 0;null!=a._requirementMatrix&&(C=a._requirementMatrix),a.eToken=a.eToken?a.eToken:"";var _=new e.OfficeAppContext(a._id,a._appName,a._appVersion,a._appUILocale,a._dataLocale,a._docUrl,a._clientMode,(function(){return o._serializedSettings}),a._reason,a._osfControlType,a._eToken,a._correlationId,v,!1,!0,b,C,a._hostCustomMessage,a._hostFullVersion,a._clientWindowHeight,a._clientWindowWidth,a._addinName,a._appDomains,a._dialogRequirementMatrix,a._featureGates,a._officeTheme,a._initialDisplayMode,a._isFromWacAutomation,a._wopiHostOriginForSingleSignOn,(function(){return o._serializedHostSettings}),!0,a._nestedAppAuthBridgeType,a._partitionKey);_.set_taskpaneUrl(a._taskpaneUrl),n(_)}else{var O="Function ContextActivationManager_getAppContextAsync call failed. ErrorCode is "+t+", exception: "+a;e.AppTelemetry&&e.AppTelemetry.logAppException(O),r(O)}};try{var s=!0;this._hostInfo.isDialog&&null!=window.opener&&(s=!1);var c=e.OUtil.parseAppContextFromWindowName(s,e._OfficeAppFactory.getWindowName());c?a(0,c):(OSFPerformance.getAppContextXdmStart=OSFPerformance.now(),this._webAppState.clientEndPoint.invoke("ContextActivationManager_getAppContextAsync",a,this._webAppState.id))}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception thrown when trying to invoke getAppContextAsync. Exception:["+t+"]"),r(t)}},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.WebClientHostController(this._webAppState)),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.WebAsyncMethodExecutor(this._clientHostController)},n.prototype.createClientSettingsManager=function(){return new e.WebClientSettingsManager},n.prototype.addOrRemoveEventListenersForWindow=function(t){var n=this,r=function(){n._webAppState.focused||(n._webAppState.focused=!0),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.Select])},o=function(){e&&(n._webAppState.focused&&(n._webAppState.focused=!1),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.UnSelect]))},i=function(t){if(t.preventDefault=t.preventDefault||function(){t.returnValue=!1},117==t.keyCode&&(t.ctrlKey||t.metaKey)){t.preventDefault();var r=e.AgaveHostAction.CtrlF6Exit;t.shiftKey&&(r=e.AgaveHostAction.CtrlF6ExitShift),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,r])}else if(9==t.keyCode){t.preventDefault();var o=document.querySelectorAll(n._tabbableElements);e.OUtil.focusToNextTabbable(o,t.target||t.srcElement,t.shiftKey)||(n._hostInfo.isDialog?e.OUtil.focusToFirstTabbable(o,t.shiftKey):t.shiftKey?n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExitShift]):n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExit]))}else if(27==t.keyCode)t.preventDefault(),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.EscExit]);else if(113==t.keyCode)t.preventDefault(),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.F2Exit]);else if((t.ctrlKey||t.metaKey||t.shiftKey||t.altKey)&&t.keyCode>=1&&t.keyCode<=255){var i={keyCode:t.keyCode,shiftKey:t.shiftKey,altKey:t.altKey,ctrlKey:t.ctrlKey,metaKey:t.metaKey};n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.KeyboardShortcuts,i])}},a=function(e){117==e.keyCode&&e.ctrlKey&&(e.preventDefault?e.preventDefault():e.returnValue=!1)};e.Utility._DebugXdm||(t?(e.OUtil.addEventListener(window,"focus",r),e.OUtil.addEventListener(window,"blur",o),e.OUtil.addEventListener(window,"keydown",i),e.OUtil.addEventListener(window,"keypress",a)):(e.OUtil.removeEventListener(window,"focus",r),e.OUtil.removeEventListener(window,"blur",o),e.OUtil.removeEventListener(window,"keydown",i),e.OUtil.removeEventListener(window,"keypress",a)))},n.prototype.getTabbableElements=function(){return this._tabbableElements},n}(e.InitializationHelper);e.WebInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t){this._initializationHelper=e,this._scriptMessager=t}return t.prototype.read=function(e){this._initializationHelper.getAppContext(null,(function(t){if(e){var n=t.get_settingsFunc()();e(0,n)}}),(function(t){e&&e(5001,{})}))},t.prototype.write=function(t,n){var r={},o=[],i=[];for(var a in t)o.push(a),i.push(t[a]);r.keys=o,r.values=i;this._scriptMessager.invokeMethod(e.Webkit.MessageHandlerName,e.Webkit.MethodId.WriteSettings,r,(function(e){n&&n(e[0])}))},t}();e.WebkitClientSettingsManager=t}(OSF||(OSF={})),function(e){!function(t){t.MessageHandlerName="Agave",t.PopupMessageHandlerName="WefPopupHandler",function(e){e[e.Settings=0]="Settings",e[e.SolutionReferenceId=1]="SolutionReferenceId",e[e.AppType=2]="AppType",e[e.MajorVersion=3]="MajorVersion",e[e.MinorVersion=4]="MinorVersion",e[e.RevisionVersion=5]="RevisionVersion",e[e.APIVersionSequence=6]="APIVersionSequence",e[e.AppCapabilities=7]="AppCapabilities",e[e.APPUILocale=8]="APPUILocale",e[e.AppDataLocale=9]="AppDataLocale",e[e.BindingCount=10]="BindingCount",e[e.DocumentUrl=11]="DocumentUrl",e[e.ActivationMode=12]="ActivationMode",e[e.ControlIntegrationLevel=13]="ControlIntegrationLevel",e[e.SolutionToken=14]="SolutionToken",e[e.APISetVersion=15]="APISetVersion",e[e.CorrelationId=16]="CorrelationId",e[e.InstanceId=17]="InstanceId",e[e.TouchEnabled=18]="TouchEnabled",e[e.CommerceAllowed=19]="CommerceAllowed",e[e.RequirementMatrix=20]="RequirementMatrix",e[e.HostCustomMessage=21]="HostCustomMessage",e[e.HostFullVersion=22]="HostFullVersion",e[e.InitialDisplayMode=23]="InitialDisplayMode",e[e.FeatureGates=24]="FeatureGates",e[e.HostSettings=25]="HostSettings",e[e.OfficeThemeInfo=26]="OfficeThemeInfo"}(t.AppContextProperties||(t.AppContextProperties={})),function(e){e[e.Execute=1]="Execute",e[e.RegisterEvent=2]="RegisterEvent",e[e.UnregisterEvent=3]="UnregisterEvent",e[e.WriteSettings=4]="WriteSettings",e[e.GetContext=5]="GetContext",e[e.SendMessage=6]="SendMessage",e[e.MessageParent=7]="MessageParent",e[e.SendMessage2=8]="SendMessage2",e[e.MessageParent2=9]="MessageParent2",e[e.CloseSdxDialog=10]="CloseSdxDialog",e[e.ResizeSdxDialog=11]="ResizeSdxDialog"}(t.MethodId||(t.MethodId={}));var n=function(){function t(e){this.hostScriptProxy=e,this.useFullDialogAPI=!!window._enableFullDialogAPI,this.osfSupportsDialogOrigin=!!window._osfEnableDialogOrigin}return t.prototype.execute=function(t,n,r){var o={id:t,apiArgs:n};this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,e.Webkit.MethodId.Execute,o,(function(t){if(r){var n=[];if(e.OUtil.isArray(t))for(var o=0;o<t.length;o++){var i=t[o];e.OUtil.isArray(i)&&(i=new e.WebkitSafeArray(i)),n.unshift(i)}return r.apply(null,n)}}))},t.prototype.registerEvent=function(t,n,r,o,i){this.hostScriptProxy.registerEvent(e.Webkit.MessageHandlerName,e.Webkit.MethodId.RegisterEvent,t,r,(function(t){var n=t,r=0;e.OUtil.isArray(t)&&t.length>=2&&(n=t[0],r=t[1]),o&&o(r,new e.WebkitSafeArray(n))}),(function(t){if(i)return i(new e.WebkitSafeArray(t))}))},t.prototype.unregisterEvent=function(t,n,r,o){this.hostScriptProxy.unregisterEvent(e.Webkit.MessageHandlerName,e.Webkit.MethodId.UnregisterEvent,t,r,(function(t){return o(new e.WebkitSafeArray(t))}))},t.prototype.messageParent=function(t){var n,r;if(this.osfSupportsDialogOrigin&&t[e.ParameterNames.TargetOrigin]?(n=this.useFullDialogAPI?JSON.stringify(t):t[e.ParameterNames.MessageToParent],r=e.Webkit.MethodId.MessageParent2):(n=t[e.ParameterNames.MessageToParent],r=e.Webkit.MethodId.MessageParent),this.useFullDialogAPI)this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null);else{var o={dialogMessage:{messageType:0,messageContent:n}},i=r==e.Webkit.MethodId.MessageParent2?t[e.ParameterNames.TargetOrigin]:window.location.origin;window.opener.postMessage(JSON.stringify(o),i)}},t.prototype.openDialog=function(n,r,o,i,a){if(this.useFullDialogAPI)this.registerEvent(n,r,o,i,a);else if(!t.popup||t.popup.closed){t.OpenDialogCallback=void 0;var s=JSON.parse(o),c=s.url;if(c){var l=c.split("#"),u="?";l[0].indexOf("?")>-1&&(u="&");var d="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;l[0]=l[0].concat(u).concat("action=displayDialog");var f=l.join("#");t.popup=window.open(f,"",d),t.DialogEventListener=function(t){if(t.origin==window.location.origin)try{var r=JSON.parse(t.data);r.dialogMessage&&i(n,[0,r.dialogMessage.messageContent,t.origin])}catch(n){e.Utility.trace("messages received cannot be handlered. Message:"+t.data)}},t.OpenDialogCallback=function(e){0==e&&(window.addEventListener("message",t.DialogEventListener),t.interval=window.setInterval(p,1e3),t.NotifyError=function(e){i(n,[e])}),a(e)}}else a(12003)}else a(12007);function p(){try{(null==t.popup||t.popup.closed)&&(window.clearInterval(t.interval),window.removeEventListener("message",t.DialogEventListener),t.NotifyError=null,t.popup=null,i(n,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}},t.prototype.closeDialog=function(e,n,r,o){this.useFullDialogAPI?this.unregisterEvent(e,n,r,o):t.popup?(t.interval&&window.clearInterval(t.interval),t.popup.close(),t.popup=null,window.removeEventListener("message",t.DialogEventListener),t.NotifyError=null,o(0)):o(5001)},t.prototype.sendMessage=function(t){var n,r;this.osfSupportsDialogOrigin&&t[e.ParameterNames.TargetOrigin]?(n=JSON.stringify(t),r=e.Webkit.MethodId.SendMessage2):(n=t[e.ParameterNames.MessageContent],r=e.Webkit.MethodId.SendMessage,!isNaN(parseFloat(n))&&isFinite(n)&&(n=n.toString())),this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null)},t.prototype.closeSdxDialog=function(t){var n=[t],r=e.Webkit.MethodId.CloseSdxDialog;this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null)},t.prototype.resizeSdxDialog=function(t,n){var r=[t,n],o=e.Webkit.MethodId.ResizeSdxDialog;this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,o,r,null)},t}();t.WebkitHostController=n}(e.Webkit||(e.Webkit={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,o){var i=t.call(this,e,n,r,o)||this;return i.initializeWebkitMessaging(),i}return __extends(n,t),n.prototype.initializeWebkitMessaging=function(){e.ScriptMessaging=OSFWebkit.ScriptMessaging},n.prototype.getAppContext=function(t,n,r){var o,i=this;o=this._hostInfo.isDialog&&window.webkit.messageHandlers[e.Webkit.PopupMessageHandlerName]?e.Webkit.PopupMessageHandlerName:e.Webkit.MessageHandlerName,e.ScriptMessaging.GetScriptMessenger().invokeMethod(o,e.Webkit.MethodId.GetContext,[],(function(t){var r,o=e.Webkit.AppContextProperties,a=t[o.AppType],s=t[o.Settings];i._serializedSettings={};for(var c=s[0],l=s[1],u=0;u<c.length;u++)i._serializedSettings[c[u]]=l[u];var d=t[o.HostSettings];if(i._serializedHostSettings={},d){c=d[0],l=d[1];for(u=0;u<c.length;u++)i._serializedHostSettings[c[u]]=l[u]}var f=t[o.SolutionReferenceId],p=t[o.MajorVersion],g=t[o.MinorVersion],h=t[o.AppCapabilities],m=t[o.APPUILocale],y=t[o.AppDataLocale],v=t[o.DocumentUrl],b=t[o.ActivationMode],C=t[o.ControlIntegrationLevel],_=t[o.SolutionToken];_=_?_.toString():"";var O,S=t[o.CorrelationId],A=t[o.InstanceId],E=t[o.TouchEnabled],P=t[o.CommerceAllowed],R=t[o.RequirementMatrix],T=t[o.HostCustomMessage],I=t[o.HostFullVersion],w=t[o.InitialDisplayMode],F=t[o.FeatureGates];if(F)try{O=JSON.parse(F)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception trying to parse FeatureGates."+t)}var D=null;if(t[o.OfficeThemeInfo])try{D=JSON.parse(t[o.OfficeThemeInfo])}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+t)}var x={};if(D){var k={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var N in D){var M=!1,H=N;k[N]&&(H=k[N].name,M=k[N].convertToHex),x[H]=M?e.OUtil.convertIntToCssHexColor(D[N]):D[N]}}r=new e.OfficeAppContext(f,a,p,m,y,v,h,(function(){return i._serializedSettings}),b,C,_,S,A,E,P,g,R,T,I,void 0,void 0,void 0,void 0,void 0,O,x,w,void 0,void 0,(function(){return i._serializedHostSettings}),!1,void 0,void 0),n(r)}))},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.Webkit.WebkitHostController(e.ScriptMessaging.GetScriptMessenger())),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this.createClientHostController())},n.prototype.createClientSettingsManager=function(){return new e.WebkitClientSettingsManager(this,e.ScriptMessaging.GetScriptMessenger())},n}(e.InitializationHelper);e.WebkitInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(e){this.data=e,this.safeArrayFlag=this.isSafeArray(e)}return t.prototype.dimensions=function(){var e=0;return this.safeArrayFlag?e=this.data[0][0]:this.isArray()&&(e=2),e},t.prototype.getItem=function(){var e=null;e=this.safeArrayFlag?this.toArray():this.data;for(var t=0;t<arguments.length;t++)e=e[arguments[t]];return e},t.prototype.lbound=function(e){return 0},t.prototype.ubound=function(t){var n=0;if(this.safeArrayFlag)n=this.data[0][t];else if(this.isArray()){if(1==t)return this.data.length;if(2==t){if(e.OUtil.isArray(this.data[0]))return this.data[0].length;if(null!=this.data[0])return 1}}return n},t.prototype.toArray=function(){if(0==this.isArray())return this.data;for(var e=[],n=this.safeArrayFlag?1:0;n<this.data.length;n++){var r=this.data[n];this.isSafeArray(r)?e.push(new t(r)):e.push(r)}return e},t.prototype.isArray=function(){return e.OUtil.isArray(this.data)},t.prototype.isSafeArray=function(t){var n=!1;if(e.OUtil.isArray(t)&&e.OUtil.isArray(t[0])){var r=t[0],o=r[0];if(r.length!=o+1)return!1;for(var i=1,a=1;a<r.length;a++){var s=r[a];if(0==isFinite(s))return!1;i*=s}n=++i==t.length}return n},t}();e.WebkitSafeArray=t}(OSF||(OSF={})),function(e){!function(e){var t=null;e.agaveHostCallback=function(e,n){t.agaveHostCallback(e,n)},e.agaveHostEventCallback=function(e,n){t.agaveHostEventCallback(e,n)},e.GetScriptMessenger=function(){return null==t&&(t=r.IsSupportedByHost()?new r:new o("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback")),t};var n=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},r=function(){function e(){this.eventHandlers=[]}return e.IsSupportedByHost=function(){return!!window._osfHostAPI},e.prototype.invokeMethod=function(e,t,n,r){window._osfHostAPI(e,this.constructMessagingArgs(t,n),(function(e){var t=r(e);return void 0===t||!0===t}))},e.prototype.registerEvent=function(e,t,n,r,o,i){var a={id:n,targetId:r},s=window._osfHostRegisterEvent(e,this.constructMessagingArgs(t,a),(function(e){return o(e),!1}),(function(e){return i(e),!0}));this.eventHandlers.push({targetId:r,dispId:n,callbackId:s.eventCallbackId})},e.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};window._osfHostAPI(e,this.constructMessagingArgs(t,i),(function(e){return o(e),!0}));for(var a=this.eventHandlers.length-1;a>=0;a--){var s=this.eventHandlers[a];s.dispId===n&&s.targetId===r&&(this.eventHandlers.splice(a,1),window._osfHostUnregisterCallback(s.callbackId))}},e.prototype.agaveHostCallback=function(e,t){},e.prototype.agaveHostEventCallback=function(e,t){},e.prototype.constructMessagingArgs=function(e,t){return{params:t,methodId:e}},e}(),o=function(){function e(t,n){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=t,this.eventCallbackFunctionName=n,this.conversationId=e.getCurrentTimeMS().toString()}return e.prototype.invokeMethod=function(e,t,n,r){this.postWebkitMessage({},e,t,n,r)},e.prototype.registerEvent=function(e,t,r,o,i,a){var s={eventCallbackFunction:this.eventCallbackFunctionName},c={id:r,targetId:o},l=this.postWebkitMessage(s,e,t,c,a);this.eventHandlerList[l]=new n(r,o,i)},e.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,i,o)},e.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},e.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},e.prototype.postWebkitMessage=function(t,n,r,o,i){t.methodId=r,t.params=o;var a="";i&&(a=this.generateCorrelationId(),this.callbackList[a]=i,t.callbackId=a,t.callbackFunction=this.asyncMethodCallbackFunctionName);var s=function(){window.webkit.messageHandlers[n].postMessage(JSON.stringify(t))},c=e.getCurrentTimeMS();return null==this.lastMessageTimestamp||c-this.lastMessageTimestamp>=e.MESSAGE_TIME_DELTA?(s(),this.lastMessageTimestamp=c):(this.lastMessageTimestamp+=e.MESSAGE_TIME_DELTA,setTimeout((function(){s()}),this.lastMessageTimestamp-c)),a},e.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},e.getCurrentTimeMS=function(){return(new Date).getTime()},e.MESSAGE_TIME_DELTA=10,e}()}(e.ScriptMessaging||(e.ScriptMessaging={}))}(OSFWebkit||(OSFWebkit={})),function(e){var t=function(){function t(e,t){this._initializationHelper=e,this._scriptMessager=t}return t.prototype.read=function(e){this._initializationHelper.getAppContext(null,(function(t){if(e){var n=t.get_settingsFunc()();e(0,n)}}),(function(t){e&&e(5001,{})}))},t.prototype.write=function(t,n){var r={},o=[],i=[];for(var a in t)o.push(a),i.push(t[a]);r.keys=o,r.values=i;this._scriptMessager.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.WriteSettings,r,(function(e){n&&n(e[0])}))},t}();e.WebViewClientSettingsManager=t}(OSF||(OSF={})),function(e){!function(t){t.MessageHandlerName="Agave",t.PopupMessageHandlerName="WefPopupHandler",function(e){e[e.Settings=0]="Settings",e[e.SolutionReferenceId=1]="SolutionReferenceId",e[e.AppType=2]="AppType",e[e.MajorVersion=3]="MajorVersion",e[e.MinorVersion=4]="MinorVersion",e[e.RevisionVersion=5]="RevisionVersion",e[e.APIVersionSequence=6]="APIVersionSequence",e[e.AppCapabilities=7]="AppCapabilities",e[e.APPUILocale=8]="APPUILocale",e[e.AppDataLocale=9]="AppDataLocale",e[e.BindingCount=10]="BindingCount",e[e.DocumentUrl=11]="DocumentUrl",e[e.ActivationMode=12]="ActivationMode",e[e.ControlIntegrationLevel=13]="ControlIntegrationLevel",e[e.SolutionToken=14]="SolutionToken",e[e.APISetVersion=15]="APISetVersion",e[e.CorrelationId=16]="CorrelationId",e[e.InstanceId=17]="InstanceId",e[e.TouchEnabled=18]="TouchEnabled",e[e.CommerceAllowed=19]="CommerceAllowed",e[e.RequirementMatrix=20]="RequirementMatrix",e[e.OfficeThemeInfo=21]="OfficeThemeInfo"}(t.AppContextProperties||(t.AppContextProperties={})),function(e){e[e.Execute=1]="Execute",e[e.RegisterEvent=2]="RegisterEvent",e[e.UnregisterEvent=3]="UnregisterEvent",e[e.WriteSettings=4]="WriteSettings",e[e.GetContext=5]="GetContext",e[e.OnKeydown=6]="OnKeydown",e[e.AddinInitialized=7]="AddinInitialized",e[e.OpenWindow=8]="OpenWindow",e[e.MessageParent=9]="MessageParent",e[e.SendMessage=10]="SendMessage"}(t.MethodId||(t.MethodId={}));var n=function(){function t(e){this.hostScriptProxy=e}return t.prototype.execute=function(t,n,r){var o=n;null==o&&(o=[]);var i={id:t,apiArgs:o};this.hostScriptProxy.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.Execute,i,(function(t){var n=t;if(e.OUtil.isArray(t)&&t.length>=2){t[0];n=t[1]}if(r)return r(new e.WebkitSafeArray(n))}))},t.prototype.registerEvent=function(t,n,r,o,i){this.hostScriptProxy.registerEvent(e.WebView.MessageHandlerName,e.WebView.MethodId.RegisterEvent,t,r,(function(t){var n=t,r=0;e.OUtil.isArray(t)&&t.length>=2&&(r=t[0],n=t[1]),o&&o(r,new e.WebkitSafeArray(n))}),(function(t){if(i)return i(new e.WebkitSafeArray(t))}))},t.prototype.unregisterEvent=function(t,n,r,o){this.hostScriptProxy.unregisterEvent(e.WebView.MessageHandlerName,e.WebView.MethodId.UnregisterEvent,t,r,(function(t){return o(new e.WebkitSafeArray(t))}))},t.prototype.messageParent=function(t){var n={dialogMessage:{messageType:0,messageContent:t[e.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(n),window.location.origin)},t.prototype.openDialog=function(n,r,o,i,a){var s=JSON.parse(o),c=s.url;if(c){var l=c.split("#"),u="?";c.indexOf("?")>-1&&(u="&");var d="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;l[0]=l[0].concat(u).concat("action=displayDialog");var f,p=l.join("#");t.popup=window.open(p,"",d),window.addEventListener("message",(function(r){if(r.source==t.popup)try{var o=JSON.parse(r.data);o.dialogMessage&&i(n,[0,o.dialogMessage.messageContent])}catch(t){e.Utility.trace("messages received cannot be handled. Message:"+r.data)}})),f=window.setInterval((function(){try{(null==t.popup||t.popup.closed)&&(window.clearInterval(f),i(n,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}),1e3),a(0)}},t.prototype.closeDialog=function(e,n,r,o){t.popup?(t.popup.close(),t.popup=null,o(0)):o(5001)},t.prototype.sendMessage=function(t){var n=t[e.ParameterNames.MessageContent];!isNaN(parseFloat(n))&&isFinite(n)&&(n=n.toString()),this.hostScriptProxy.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.SendMessage,n,null)},t.prototype.closeSdxDialog=function(t){throw e.Utility.createNotImplementedException()},t.prototype.resizeSdxDialog=function(t,n){throw e.Utility.createNotImplementedException()},t}();t.WebViewHostController=n}(e.WebView||(e.WebView={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,o){var i=t.call(this,e,n,r,o)||this;return i.initializeWebViewMessaging(),i}return __extends(n,t),n.prototype.initializeWebViewMessaging=function(){e.ScriptMessaging=e.WebView.ScriptMessaging},n.prototype.getAppContext=function(t,n,r){var o,i=this;o=this._hostInfo.isDialog?e.WebView.PopupMessageHandlerName:e.WebView.MessageHandlerName,e.ScriptMessaging.GetScriptMessenger().invokeMethod(o,e.WebView.MethodId.GetContext,[],(function(t){var r,o=e.Webkit.AppContextProperties,a=t[o.AppType],s=t[o.Settings];i._serializedSettings={};for(var c=s[0],l=s[1],u=0;u<c.length;u++)i._serializedSettings[c[u]]=l[u];var d=t[o.SolutionReferenceId],f=t[o.MajorVersion],p=t[o.MinorVersion],g=t[o.AppCapabilities],h=t[o.APPUILocale],m=t[o.AppDataLocale],y=t[o.DocumentUrl],v=t[o.ActivationMode],b=t[o.ControlIntegrationLevel],C=t[o.SolutionToken];C=C?C.toString():"";var _=t[o.CorrelationId],O=t[o.InstanceId],S=t[o.TouchEnabled],A=t[o.CommerceAllowed],E=t[o.RequirementMatrix],P=t[o.HostCustomMessage],R=t[o.HostFullVersion],T=t[o.InitialDisplayMode];r=new e.OfficeAppContext(d,a,f,h,m,y,g,(function(){return i._serializedSettings}),v,b,C,_,O,S,A,p,E,P,R,void 0,void 0,void 0,void 0,void 0,void 0,void 0,T,void 0,void 0,void 0,!1,void 0,void 0),n(r)}))},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.WebView.WebViewHostController(e.ScriptMessaging.GetScriptMessenger())),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this.createClientHostController())},n.prototype.createClientSettingsManager=function(){return new e.WebViewClientSettingsManager(this,e.ScriptMessaging.GetScriptMessenger())},n}(e.InitializationHelper);e.WebViewInitializationHelper=t}(OSF||(OSF={})),function(e){var t;!function(e){!function(e){e[e.MethodCallback=0]="MethodCallback",e[e.EventCallback=1]="EventCallback"}(e.CallbackType||(e.CallbackType={}));var t=function(e,t,n){this.callbackType=e,this.callbackId=t,this.params=n};e.CallbackData=t}(t||(t={})),function(n){var r=function(){function n(){}return n.getInstance=function(){return null==n.uniqueInstance&&(n.uniqueInstance=new n),n.uniqueInstance},n.prototype.postMessage=function(e,t){agaveHost.postMessage(t)},n.prototype.ReceiveMessage=function(n){switch(n.callbackType){case t.CallbackType.MethodCallback:e.WebView.ScriptMessaging.agaveHostCallback(n.callbackId,n.params);break;case t.CallbackType.EventCallback:e.WebView.ScriptMessaging.agaveHostEventCallback(n.callbackId,n.params)}},n}();n.Poster=r}(e.Android||(e.Android={})),function(n){var r=function(){function n(){window.addEventListener("message",this.OnReceiveMessage.bind(this))}return n.prototype.postMessage=function(e,t){window.parent.postMessage(t,"*")},n.prototype.OnReceiveMessage=function(n){if(n.source==window.parent&&window.parent==window.top&&n.origin.startsWith("ms-appx-web://")){var r;try{r=JSON.parse(n.data)}catch(e){return}switch(r.callbackType){case t.CallbackType.MethodCallback:e.WebView.ScriptMessaging.agaveHostCallback(r.callbackId,JSON.parse(r.params));break;case t.CallbackType.EventCallback:e.WebView.ScriptMessaging.agaveHostEventCallback(r.callbackId,JSON.parse(r.params))}}},n}();n.Poster=r}(e.WinRT||(e.WinRT={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n=null;t.agaveHostCallback=function(e,t){n.agaveHostCallback(e,t)},t.agaveHostEventCallback=function(e,t){n.agaveHostEventCallback(e,t)},t.GetScriptMessenger=function(){if(null==n){var t=e._OfficeAppFactory.getHostInfo().hostPlatform;if(t===e.HostInfoPlatform.android)n=new o("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback",e.Android.Poster.getInstance());else{if(t!==e.HostInfoPlatform.winrt)throw e.Utility.createNotImplementedException();n=new o("agaveHostCallback","agaveHostEventCallback",new e.WinRT.Poster)}}return n};var r=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},o=function(){function e(t,n,r){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=t,this.eventCallbackFunctionName=n,this.poster=r,this.conversationId=e.getCurrentTimeMS().toString()}return e.prototype.invokeMethod=function(e,t,n,r){this.postMessage({},e,t,n,r)},e.prototype.registerEvent=function(e,t,n,o,i,a){var s={eventCallbackFunction:this.eventCallbackFunctionName},c={id:n,targetId:o},l=this.postMessage(s,e,t,c,a);this.eventHandlerList[l]=new r(n,o,i)},e.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,i,o)},e.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},e.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},e.prototype.postMessage=function(e,t,n,r,o){var i=this.generateCorrelationId();return this.callbackList[i]=o,e.methodId=n,e.params=r,e.callbackId=i,e.callbackFunction=this.asyncMethodCallbackFunctionName,this.poster.postMessage(t,JSON.stringify(e)),i},e.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},e.getCurrentTimeMS=function(){return(new Date).getTime()},e.MESSAGE_TIME_DELTA=10,e}()}(t.ScriptMessaging||(t.ScriptMessaging={}))}(e.WebView||(e.WebView={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.prototype.messageParent=function(t){if(e.Utility.externalNativeFunctionExists(typeof window.external.MessageParent2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageParent2(JSON.stringify(t),OsfOMToken):window.external.MessageParent2(JSON.stringify(t));else{var n=t[e.ParameterNames.MessageToParent];window.external.MessageParent(n)}},n.prototype.openDialog=function(e,t,n,r,o){this.registerEvent(e,t,n,r,o)},n.prototype.closeDialog=function(e,t,n,r){this.unregisterEvent(e,t,n,r)},n.prototype.sendMessage=function(t){if(e.Utility.externalNativeFunctionExists(typeof window.external.MessageChild2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageChild2(JSON.stringify(t),OsfOMToken):window.external.MessageChild2(JSON.stringify(t));else{var n=t[e.ParameterNames.MessageContent];window.external.MessageChild(n)}},n.prototype.closeSdxDialog=function(t){e.Utility.externalNativeFunctionExists(typeof window.external.closeSdxDialog)&&window.external.closeSdxDialog(t)},n.prototype.resizeSdxDialog=function(t,n){e.Utility.externalNativeFunctionExists(typeof window.external.resizeSdxDialog)&&window.external.resizeSdxDialog(t,n)},n}(e.RichClientHostController);e.Win32RichClientHostController=t}(OSF||(OSF={})),function(e){var t=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.prototype.openDialog=function(t,r,o,i,a){if(!n.popup||n.popup.closed){window.dialogAPIErrorCode=void 0;var s=JSON.parse(o),c=s.url;if(c){var l=c.split("#"),u="?";l[0].indexOf("?")>-1&&(u="&");var d="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;l[0]=l[0].concat(u).concat("action=displayDialog");var f=l.join("#");if(n.popup=window.open(f,"",d),n.DialogEventListener=function(r){if(r.source==n.popup)try{var o=JSON.parse(r.data);o.dialogMessage&&i(t,[0,o.dialogMessage.messageContent])}catch(t){e.Utility.trace("messages received cannot be handlered. Message:"+r.data)}},null!=n.popup&&null==window.dialogAPIErrorCode)window.addEventListener("message",n.DialogEventListener),n.interval=window.setInterval((function(){try{(null==n.popup||n.popup.closed)&&(window.clearInterval(n.interval),window.removeEventListener("message",n.DialogEventListener),n.NotifyError=null,i(t,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}),500),n.NotifyError=function(e){i(t,[e])},a(0);else{var p=5001;window.dialogAPIErrorCode&&(p=window.dialogAPIErrorCode),a(p)}}else a(12003)}else a(12007)},n.prototype.messageParent=function(t){var n={dialogMessage:{messageType:0,messageContent:t[e.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(n),window.location.origin)},n.prototype.closeDialog=function(e,t,r,o){n.popup?(n.interval&&window.clearInterval(n.interval),n.popup.close(),n.popup=null,window.removeEventListener("message",n.DialogEventListener),n.NotifyError=null,o(0)):o(5001)},n}(e.Webkit.WebkitHostController);e.MacRichClientHostController=t}(OSF||(OSF={})),function(e){var t;!function(e){!function(e){e.Init=function(){return function(){"use strict";function e(e){return"function"==typeof e}var t,n=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},r=0,o=function(e,n){f[r]=e,f[r+1]=n,2===(r+=2)&&(t?t(p):c())};var i=("undefined"!=typeof window?window:void 0)||{},a=(i.MutationObserver||i.WebKitMutationObserver,"undefined"!=typeof process&&"[object process]"==={}.toString.call(process)),s="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;var c,l,u,d,f=new Array(1e3);function p(){for(var e=0;e<r;e+=2){(0,f[e])(f[e+1]),f[e]=void 0,f[e+1]=void 0}r=0}function g(){}a?(u=process.nextTick,d=process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/),Array.isArray(d)&&"0"===d[1]&&"10"===d[2]&&(u=setImmediate),c=function(){u(p)}):s?((l=new MessageChannel).port1.onmessage=p,c=function(){l.port2.postMessage(0)}):c=function(){setTimeout(p,1)};var h=void 0,m=new A;function y(t,n){if(n.constructor===t.constructor)!function(e,t){1===t._state?C(e,t._result):2===t._state?_(e,t._result):O(t,void 0,(function(t){v(e,t)}),(function(t){_(e,t)}))}(t,n);else{var r=function(e){try{return e.then}catch(e){return m.error=e,m}}(n);r===m?_(t,m.error):void 0===r?C(t,n):e(r)?function(e,t,n){o((function(e){var r=!1,o=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(n,t,(function(n){r||(r=!0,t!==n?v(e,n):C(e,n))}),(function(t){r||(r=!0,_(e,t))}),e._label);!r&&o&&(r=!0,_(e,o))}),e)}(t,n,r):C(t,n)}}function v(e,t){var n;e===t?_(e,new TypeError("You cannot resolve a promise with itself")):"function"==typeof(n=t)||"object"==typeof n&&null!==n?y(e,t):C(e,t)}function b(e){e._onerror&&e._onerror(e._result),S(e)}function C(e,t){e._state===h&&(e._result=t,e._state=1,0!==e._subscribers.length&&o(S,e))}function _(e,t){e._state===h&&(e._state=2,e._result=t,o(b,e))}function O(e,t,n,r){var i=e._subscribers,a=i.length;e._onerror=null,i[a]=t,i[a+1]=n,i[a+2]=r,0===a&&e._state&&o(S,e)}function S(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,o,i=e._result,a=0;a<t.length;a+=3)r=t[a],o=t[a+n],r?P(n,r,o,i):o(i);e._subscribers.length=0}}function A(){this.error=null}var E=new A;function P(t,n,r,o){var i,a,s,c,l=e(r);if(l){if((i=function(e,t){try{return e(t)}catch(e){return E.error=e,E}}(r,o))===E?(c=!0,a=i.error,i=null):s=!0,n===i)return void _(n,new TypeError("A promises callback cannot return that same promise."))}else i=o,s=!0;n._state!==h||(l&&s?v(n,i):c?_(n,a):1===t?C(n,i):2===t&&_(n,i))}function R(e,t){var n=this;n._instanceConstructor=e,n.promise=new e(g),n._validateInput(t)?(n._input=t,n.length=t.length,n._remaining=t.length,n._init(),0===n.length?C(n.promise,n._result):(n.length=n.length||0,n._enumerate(),0===n._remaining&&C(n.promise,n._result))):_(n.promise,n._validationError())}R.prototype._validateInput=function(e){return n(e)},R.prototype._validationError=function(){return new Error("Array Methods must be provided an Array")},R.prototype._init=function(){this._result=new Array(this.length)};var T=R;R.prototype._enumerate=function(){for(var e=this,t=e.length,n=e.promise,r=e._input,o=0;n._state===h&&o<t;o++)e._eachEntry(r[o],o)},R.prototype._eachEntry=function(e,t){var n,r=this,o=r._instanceConstructor;"object"==typeof(n=e)&&null!==n?e.constructor===o&&e._state!==h?(e._onerror=null,r._settledAt(e._state,t,e._result)):r._willSettleAt(o.resolve(e),t):(r._remaining--,r._result[t]=e)},R.prototype._settledAt=function(e,t,n){var r=this,o=r.promise;o._state===h&&(r._remaining--,2===e?_(o,n):r._result[t]=n),0===r._remaining&&C(o,r._result)},R.prototype._willSettleAt=function(e,t){var n=this;O(e,void 0,(function(e){n._settledAt(1,t,e)}),(function(e){n._settledAt(2,t,e)}))};var I=function(e){return new T(this,e).promise};var w=function(e){var t=new this(g);if(!n(e))return _(t,new TypeError("You must pass an array to race.")),t;var r=e.length;function o(e){v(t,e)}function i(e){_(t,e)}for(var a=0;t._state===h&&a<r;a++)O(this.resolve(e[a]),void 0,o,i);return t};var F=function(e){if(e&&"object"==typeof e&&e.constructor===this)return e;var t=new this(g);return v(t,e),t};var D=function(e){var t=new this(g);return _(t,e),t},x=0;var k=N;function N(t){this._id=x++,this._state=void 0,this._result=void 0,this._subscribers=[],g!==t&&(e(t)||function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof N||function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}(),function(e,t){try{t((function(t){v(e,t)}),(function(t){_(e,t)}))}catch(t){_(e,t)}}(this,t))}return N.all=I,N.race=w,N.resolve=F,N.reject=D,N._setScheduler=function(e){t=e},N._setAsap=function(e){o=e},N._asap=o,N.prototype={constructor:N,then:function(e,t){var n=this,r=n._state;if(1===r&&!e||2===r&&!t)return this;var i=new this.constructor(g),a=n._result;if(r){var s=arguments[r-1];o((function(){P(r,i,s,a)}))}else O(n,i,e,t);return i},catch:function(e){return this.then(null,e)}},k}.call(this)}}(e.PromiseImpl||(e.PromiseImpl={}))}(e._Internal||(e._Internal={})),function(e){e.OfficePromise=function(){if("undefined"==typeof window&&"function"==typeof Promise)return Promise;if("undefined"!=typeof window){if(window.Promise)return window.Promise;var t=e.PromiseImpl.Init();return window.Promise=t,t}}()}(t=e._Internal||(e._Internal={})),e.OfficePromise=t.OfficePromise,e.Promise=e.OfficePromise}(Office||(Office={})),function(e){!function(t){var n,r=e.OUtil.Guid.generateNewGuid(),o=new RegExp("^https?://store\\.office(ppe|-int)?\\.com/","i"),i=!1,a="PRIVATE";t.enableTelemetry=!0;var s=function(){};t.AppInfo=s;var c=function(){function t(){this.clientIDKey="Office API client",this.logIdSetKey="Office App Log Id Set"}return t.prototype.getClientId=function(){var t=this.getValue(this.clientIDKey);return(!t||t.length<=0||t.length>40)&&(t=e.OUtil.Guid.generateNewGuid(),this.setValue(this.clientIDKey,t)),t},t.prototype.getValue=function(t){var n=e.OUtil.getLocalStorage(),r="";return n&&(r=n.getItem(t)),r},t.prototype.setValue=function(t,n){var r=e.OUtil.getLocalStorage();r&&r.setItem(t,n)},t}();function l(e){return e&&(e=e.replace(/[{}]/g,"").toLowerCase()),e||""}function u(){n&&(i||OTel.OTelLogger.onTelemetryLoaded((function(){var e=[],t=n.isMos?1:0;e=e.concat([oteljs.makeStringDataField("Browser",n.browser),oteljs.makeInt64DataField("AppSizeWidth",window.innerWidth),oteljs.makeInt64DataField("AppSizeHeight",window.innerHeight),oteljs.makeInt64DataField("IsMOS",t)]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AppActivatedX",dataFields:e,eventFlags:{dataCategories:2,diagnosticLevel:110,samplingPolicy:191}})})))}function d(e,t){}function f(){var t=0!=(e._OfficeAppFactory.getHostInfo().flags&e.HostInfoFlags.PublicAddin);return t||!!n&&g(e._OfficeAppFactory.getHostInfo().hostPlatform,n.hostVersion)}function p(e,t){return f()||t!==e?t:a}function g(t,n){var r=!1,o=/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/.exec(n);if(o){var i=parseInt(o[1]),a=parseInt(o[2]),s=parseInt(o[3]);t==e.HostInfoPlatform.win32?(i<16||16==i&&s<14225)&&(r=!0):t==e.HostInfoPlatform.mac&&(i<16||16==i&&(a<52||52==a&&s<808))&&(r=!0)}return r}function h(){return 0!=(e._OfficeAppFactory.getHostInfo().flags&e.HostInfoFlags.IsMos)}t.initialize=function(u){if(t.enableTelemetry&&!n){n=new s,u.get_hostFullVersion()?n.hostVersion=u.get_hostFullVersion():n.hostVersion=u.get_appVersion(),n.appId=f()?u.get_id():a,n.marketplaceType=u._marketplaceType,n.host=""+u.get_appName(),n.browser=window.navigator.userAgent,n.correlationId=l(u.get_correlationId()),n.clientId=(new c).getClientId(),n.appInstanceId=u.get_appInstanceId(),n.appInstanceId&&(n.appInstanceId=l(n.appInstanceId),n.appInstanceId=p(u.get_id(),n.appInstanceId)),n.message=u.get_hostCustomMessage(),n.officeJSVersion=e.ConstantNames.FileVersion,n.hostJSVersion="NA",u._wacHostEnvironment&&(n.wacHostEnvironment=u._wacHostEnvironment);var d=u.get_isFromWacAutomation();null!=d&&(n.isFromWacAutomation=d.toString().toLowerCase());var g=u.get_docUrl();n.docUrl=o.test(g)?g:"";var m=location.href;m&&(n.isPreload=-1!==m.indexOf("preload=1"),m=m.split("?")[0].split("#")[0]),n.isMos=h(),function(t,n){n.assetId="",n.userId="";try{if(!e.Utility.isNullOrEmpty(t)){var r=decodeURIComponent(t),o=new DOMParser,i=void 0;if(e.LoadScriptHelper.trustedTypesOptIn()&&window.trustedTypes&&window.trustedTypes.createPolicy)i=window.trustedTypes.createPolicy("officejs-domparser",{createHTML:function(e){return e}}).createHTML(r);else i=r;var a=o.parseFromString(i,"text/xml"),s=a.getElementsByTagName("t")[0].attributes.getNamedItem("cid"),c=a.getElementsByTagName("t")[0].attributes.getNamedItem("oid");s&&s.nodeValue?n.userId=s.nodeValue:c&&c.nodeValue&&(n.userId=c.nodeValue),n.assetId=a.getElementsByTagName("t")[0].attributes.getNamedItem("aid").nodeValue}}catch(e){}}(u.get_eToken(),n),n.sessionId=r,OTel.OTelLogger.initialize(n),n.isPreload?i=!0:t.onAppActivated()}},t.onAppActivated=u,t.onScriptDone=function(e,t,n,r){},t.onCallDone=function(e,t,n,r,o){},t.onMethodDone=function(e,t,n,r){},t.onPropertyDone=function(t,n){e.AppTelemetry.onCallDone("property",-1,t,n,0)},t.onCheckWACHost=function(e,t,n,r,o){},t.onEventDone=function(t,n){e.AppTelemetry.onCallDone("event",t,null,0,n)},t.onRegisterDone=function(t,n,r,o){e.AppTelemetry.onCallDone(t?"registerevent":"unregisterevent",n,null,r,o)},t.onAppClosed=function(e,t){},t.setOsfControlAppCorrelationId=function(e){l(e)},t.doAppInitializationLogging=d,t.logAppCommonMessage=function(e){},t.logAppException=function(e){},t.CallOnAppActivatedIfPending=function(){i&&(i=!1,u())},t.canSendAddinId=f,t.getCompliantAppInstanceId=p,t._isComplianceExceptedHost=g,t.isMos=h}(e.AppTelemetry||(e.AppTelemetry={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.loaded=function(){return!(void 0===t.logger)},t.create=function(t){var n,r={id:t.appId,marketplaceType:t.marketplaceType,assetId:t.assetId,officeJsVersion:t.officeJSVersion,hostJsVersion:t.hostJSVersion,browserToken:t.clientId,instanceId:t.appInstanceId,sessionId:t.sessionId},o=oteljs.Contracts.Office.System.SDX.getFields("SDX",r);if("web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform)n=new e.SdxWacSink;else{if(!Office.context.requirements.isSetSupported("Telemetry","1.2"))return console.error("Cannot create telemetry sink successfully"),null;n=new e.RichApiSink}var i=new oteljs.SimpleTelemetryLogger(void 0,o);return i.addSink(n),i.setTenantToken("Office.Extensibility.OfficeJs","db334b301e7b474db5e0f02f07c51a47-a1b5bc36-1bbe-482f-a64a-c2d9cb606706-7439",1755),oteljs.onNotification().addListener((function(e){OSF.Utility.debugLog(e.message())})),i},t.checkAndResolvePromises=function(){t.loaded()&&(t.promises.forEach((function(e){e()})),t.promises=[])},t.initialize=function(e){t.Enabled?Office.onReadyInternal().then((function(){t.loaded()||(OSF.Utility.debugLog("Creating OTelLogger"),t.logger=t.create(e),t.checkAndResolvePromises())})):t.promises=[]},t.sendTelemetryEvent=function(e){t.onTelemetryLoaded((function(){try{t.logger.sendTelemetryEvent(e),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}}))},t.sendNonStandardEvent=function(e,n){t.onTelemetryLoaded((function(){try{t.logger.sendNonStandardEvent(e,n),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}}))},t.onTelemetryLoaded=function(e){t.Enabled&&(t.loaded()?e():t.promises.push(e))},t.promises=[],t.Enabled=!0,t}();e.OTelLogger=t}(OTel||(OTel={})),function(e){var t=function(){function e(){var e=this;this._requestIsPending=!0,this._telemetryQueue=[],this.pause(1e3).then((function(){var t=e._telemetryQueue;e._telemetryQueue=[],e._requestIsPending=!1,e.processTelemetryEvents(t)}))}return e.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push([e,1]),this._requestIsPending||this.processWorkBacklog()},e.prototype.sendNonStandardEvent=function(e,t){this._telemetryQueue.push([e,t]),this._requestIsPending||this.processWorkBacklog()},e.prototype.processWorkBacklog=function(){var e=this;this._requestIsPending=!0;var t=this._telemetryQueue;this._telemetryQueue=[],this.processTelemetryEvents(t).then(this.waitAndProcessMore).catch((function(t){oteljs.logError(1,"RichApiSink Error",t),e.waitAndProcessMore()}))},e.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then((function(){e._telemetryQueue.length>0&&setTimeout((function(){return e.processWorkBacklog()}),0),e._requestIsPending=!1})).catch((function(){}))},e.prototype.processTelemetryEvents=function(e){var t=this,n=new OfficeCore.RequestContext;return e.forEach((function(e){var r=e[0],o=e[1];if(r.telemetryProperties){var i=[];t.addDataFields(i,r.dataFields);var a=r.eventContract?r.eventContract.name:"";r.eventContract&&t.addDataFields(i,r.eventContract.dataFields),1===o?n.telemetry.sendTelemetryEvent(r.telemetryProperties,r.eventName,a,oteljs.getEffectiveEventFlags(r),i):n.telemetry.sendNonStandardEvent(r.telemetryProperties,r.eventName,a,oteljs.getEffectiveEventFlags(r),i,o)}})),n.sync().catch((function(){oteljs.logNotification(2,1,(function(){return"RichApi telemetry call failed."}))}))},e.prototype.addDataFields=function(e,t){t&&t.forEach((function(t){e.push({name:t.name,value:t.value,classification:t.classification?t.classification:4,type:t.dataType})}))},e.prototype.pause=function(e){return new Office.Promise((function(t){return setTimeout(t,e)}))},e}();e.RichApiSink=t}(OTel||(OTel={})),function(e){var t=function(){function e(){}return e.prototype.sendTelemetryEvent=function(e,t){try{if(e.dataFields&&e.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t})).length>0)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},e.prototype.sendNonStandardEvent=function(e,t){try{if(1===t)throw new Error("Please call sendTelemetryEvent for events of type "+t);if(e.dataFields&&e.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t&&2048!==t})).length>0)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendNonStandardEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},e}();e.SdxWacSink=t}(OTel||(OTel={})),function(e){var t,n=[];function r(e,t,n){OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionRequest",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeStringDataField("methodPath",t),oteljs.makeStringDataField("params",n)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}function o(e,t,n){OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionResponse",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeBooleanDataField("isSuccessful",t),oteljs.makeStringDataField("error",n?JSON.stringify({name:n.name,code:n.code,message:n.message}):void 0)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}try{for(var i=0,a=function(e){var t=Navigator.prototype[e];t&&(Navigator.prototype[e]=function(n,a,s){if(3===arguments.length&&Function.prototype.isPrototypeOf(a)&&Function.prototype.isPrototypeOf(s)){var c=(i++).toString();return r(c,"Navigator.prototype."+e,JSON.stringify([{audio:!!n.audio,video:!!n.video}])),t.apply(this,[n,function(){return o(c,!0),a.apply(this,arguments)},function(){return o(c,!1,arguments[0]),s.apply(this,arguments)}])}return t.apply(this,arguments)},n.push("Navigator.prototype."+e))},s=0,c=["getUserMedia","webkitGetUserMedia","mozGetUserMedia"];s<c.length;s++){a(c[s])}var l=MediaDevices.prototype.getUserMedia;l&&(MediaDevices.prototype.getUserMedia=function(e){var t=(i++).toString();return 1===arguments.length&&void 0!==e?(r(t,"MediaDevices.prototype.getUserMedia",JSON.stringify([{audio:!!e.audio,video:!!e.video}])),l.apply(this,arguments).then((function(){return o(t,!0),arguments[0]}),(function(){throw o(t,!1,arguments[0]),arguments[0]}))):l.apply(this,arguments)},n.push("MediaDevices.prototype.getUserMedia"));for(var u=function(e){var t=Geolocation.prototype[e];t&&(Geolocation.prototype[e]=function(n,a,s){for(var c=[],l=3;l<arguments.length;l++)c[l-3]=arguments[l];var u=(i++).toString(),d=!1;r(u,"Geolocation.prototype."+e,JSON.stringify([]));var f=Function.prototype.isPrototypeOf(n)?function(){return d||(o(u,!0),d=!0),n.apply(this,arguments)}:n,p=Function.prototype.isPrototypeOf(a)?function(){return d||(o(u,!1,arguments[0]),d=!0),a.apply(this,arguments)}:a;return t.apply(this,[f,p,s].concat(c))},n.push("Geolocation.prototype."+e))},d=0,f=["getCurrentPosition","watchPosition"];d<f.length;d++){u(f[d])}}catch(e){t=e.toString()}OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionHookInstall",dataFields:[oteljs.makeStringDataField("hooksInstalled",JSON.stringify(n)),oteljs.makeStringDataField("error",t)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}(Office||(Office={})),function(e){!function(e){!function(e){e.FeatureGates={},e.EventType=OSF.EventType,e.sendTelemetryEvent=function(e){OTel.OTelLogger.sendTelemetryEvent(e)},e.sendNonStandardEvent=function(e,t){OTel.OTelLogger.sendNonStandardEvent(e,t)},e.telemetrySink=OTel.OTelLogger}(e.WebExtension||(e.WebExtension={}))}(e.Office||(e.Office={}))}(Microsoft||(Microsoft={})),function(e){e.sendTelemetryEvent=function(e){Microsoft.Office.WebExtension.sendTelemetryEvent(e)},e.sendNonStandardEvent=function(e,t){Microsoft.Office.WebExtension.sendNonStandardEvent(e,t)},e.telemetrySink=Microsoft.Office.WebExtension.telemetrySink,e.isTrustedHost=function(){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(o){switch(o.label){case 0:return o.trys.push([0,6,,7]),OSF._OfficeAppFactory.getHostInfo().hostPlatform===OSF.HostInfoPlatform.web?[3,2]:[4,e.onReady()];case 1:return o.sent(),[2,!0];case 2:return null!=(t=OSF._OfficeAppFactory.getWebAppState().clientEndPoint)&&t.fHostTrusted||null!=document.referrer&&(n=OSF.OUtil.parseUrl(document.referrer,!1),"https:"==n.protocol&&OSF.XdmCommunicationManager.isHostNameValidWacDomain(n.hostname)&&!new RegExp("^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$").test(n.hostname))?[2,!0]:null==t?[3,4]:[4,OSF.Utility.promisify((function(e){t.invoke("ContextActivationManager_getAppContextAsync",e,OSF._OfficeAppFactory.getWebAppState().id)}),1e4)];case 3:return o.sent(),[2,!0];case 4:return[2,!1];case 5:return[3,7];case 6:return r=o.sent(),OSF.AppTelemetry&&OSF.AppTelemetry.logAppException("Exception happens at Office.isTrustedHost."+r),[2,!1];case 7:return[2]}}))}))},Microsoft.Office.WebExtension.onReadyInternal=e.onReadyInternal}(Office||(Office={}));var OfficeExtension;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){var t;!function(e){e.graph="graph",e.wfe="wfe"}(t=e.RemoteEndpointType||(e.RemoteEndpointType={}));var n=function(){function e(){}return e.prototype._resolveRequestUrlAndHeaderInfo=function(){return u._createPromiseFromResult(null)},e.prototype._createRequestExecutorOrNull=function(){return null},e.prototype.getEventRegistration=function(e){return null},e}();e.SessionBase=n;var r=function(){function e(){}return e.setCustomSendRequestFunc=function(t){e.s_customSendRequestFunc=t},e.xhrSendRequestFunc=function(e){return u.createPromise((function(t,n){var r=new XMLHttpRequest;if(r.open(e.method,e.url),r.onload=function(){var e={statusCode:r.status,headers:u._parseHttpResponseHeaders(r.getAllResponseHeaders()),body:r.responseText};t(e)},r.onerror=function(){n(new o.RuntimeError({code:a.connectionFailure,httpStatusCode:r.status,message:u._getResourceString(s.connectionFailureWithStatus,r.statusText)}))},e.headers)for(var i in e.headers)r.setRequestHeader(i,e.headers[i]);r.send(u._getRequestBodyText(e))}))},e.fetchSendRequestFunc=function(e){var t=u._getRequestBodyText(e);return""===t&&(t=void 0),fetch(e.url,{method:e.method,headers:e.headers,body:t}).then((function(e){return e.text().then((function(t){var n=e.status,r={};return e.headers.forEach((function(e,t){r[t]=e})),{statusCode:n,headers:r,body:t}}))}))},e.sendRequest=function(t){e.validateAndNormalizeRequest(t);var n=e.s_customSendRequestFunc;return n||(n="undefined"!=typeof fetch?e.fetchSendRequestFunc:e.xhrSendRequestFunc),n(t)},e.setCustomSendLocalDocumentRequestFunc=function(t){e.s_customSendLocalDocumentRequestFunc=t},e.sendLocalDocumentRequest=function(t){return e.validateAndNormalizeRequest(t),(e.s_customSendLocalDocumentRequestFunc||e.officeJsSendLocalDocumentRequestFunc)(t)},e.officeJsSendLocalDocumentRequestFunc=function(e){e=u._validateLocalDocumentRequest(e);var t=u._buildRequestMessageSafeArray(e);return u.createPromise((function(e,n){OSF.DDA.RichApi.executeRichApiRequestAsync(t,(function(t){var n;n="succeeded"==t.status?{statusCode:l.getResponseStatusCode(t),headers:l.getResponseHeaders(t),body:l.getResponseBody(t)}:l.buildHttpResponseFromOfficeJsError(t.error.code,t.error.message),u.log("Response:"),u.log(JSON.stringify(n)),e(n)}))}))},e.validateAndNormalizeRequest=function(e){if(u.isNullOrUndefined(e))throw o.RuntimeError._createInvalidArgError({argumentName:"request"});u.isNullOrEmptyString(e.method)&&(e.method="GET"),e.method=e.method.toUpperCase();var t=!1;if("object"==typeof e.headers&&e.headers[c.testRequestNameHeader]&&(t=!0),!t){var n=d._getCurrentTestNameWithSequenceId();n&&(e.headers||(e.headers={}),e.headers[c.testRequestNameHeader]=n)}},e.logRequest=function(t){if(u._logEnabled){if(u.log("---HTTP Request---"),u.log(t.method+" "+t.url),t.headers)for(var n in t.headers)u.log(n+": "+t.headers[n]);e._logBodyEnabled&&u.log(u._getRequestBodyText(t))}},e.logResponse=function(t){if(u._logEnabled){if(u.log("---HTTP Response---"),u.log(""+t.statusCode),t.headers)for(var n in t.headers)u.log(n+": "+t.headers[n]);e._logBodyEnabled&&u.log(t.body)}},e._logBodyEnabled=!1,e}();e.HttpUtility=r;var o,i=function(){function e(e){var t=this;this.m_bridge=e,this.m_promiseResolver={},this.m_handlers=[],this.m_bridge.onMessageFromHost=function(e){var n=JSON.parse(e);if(3==n.type){var r=n.message;if(r&&r.entries)for(var o=0;o<r.entries.length;o++){var i=r.entries[o];if(Array.isArray(i)){var a={messageCategory:i[0],messageType:i[1],targetId:i[2],message:i[3],id:i[4]};r.entries[o]=a}}}t.dispatchMessage(n)}}return e.init=function(t){if("object"==typeof t&&t){var n=new e(t);e.s_instance=n,r.setCustomSendLocalDocumentRequestFunc((function(t){t=u._validateLocalDocumentRequest(t);var r=0;u.isReadonlyRestRequest(t.method)||(r=1);var o=t.url.indexOf("?");if(o>=0){var i=t.url.substr(o+1),a=u._parseRequestFlagsAndCustomDataFromQueryStringIfAny(i);a.flags>=0&&(r=a.flags)}"string"==typeof t.body&&(t.body=JSON.parse(t.body));var s={id:e.nextId(),type:1,flags:r,message:t};return n.sendMessageToHostAndExpectResponse(s).then((function(e){return e.message}))}));for(var o=0;o<e.s_onInitedHandlers.length;o++)e.s_onInitedHandlers[o](n)}},Object.defineProperty(e,"instance",{get:function(){return e.s_instance},enumerable:!0,configurable:!0}),e.prototype.sendMessageToHost=function(e){this.m_bridge.sendMessageToHost(JSON.stringify(e))},e.prototype.sendMessageToHostAndExpectResponse=function(e){var t=this,n=u.createPromise((function(n,r){t.m_promiseResolver[e.id]=n}));return this.m_bridge.sendMessageToHost(JSON.stringify(e)),n},e.prototype.addHostMessageHandler=function(e){this.m_handlers.push(e)},e.prototype.removeHostMessageHandler=function(e){var t=this.m_handlers.indexOf(e);t>=0&&this.m_handlers.splice(t,1)},e.onInited=function(t){e.s_onInitedHandlers.push(t),e.s_instance&&t(e.s_instance)},e.prototype.dispatchMessage=function(e){if("number"==typeof e.id){var t=this.m_promiseResolver[e.id];if(t)return t(e),void delete this.m_promiseResolver[e.id]}for(var n=0;n<this.m_handlers.length;n++)this.m_handlers[n](e)},e.nextId=function(){return e.s_nextId++},e.s_onInitedHandlers=[],e.s_nextId=1,e}();e.HostBridge=i,"object"==typeof _richApiNativeBridge&&_richApiNativeBridge&&i.init(_richApiNativeBridge),function(e){var t=function(t){function n(e){var r=t.call(this,"string"==typeof e?e:e.message)||this;if(Object.setPrototypeOf(r,n.prototype),r.name="RichApi.Error","string"==typeof e?r.message=e:(r.code=e.code,r.message=e.message,r.traceMessages=e.traceMessages||[],r.innerError=e.innerError||null,r.debugInfo=r._createDebugInfo(e.debugInfo||{}),r.httpStatusCode=e.httpStatusCode,r.data=e.data),u.isNullOrUndefined(r.httpStatusCode)||200===r.httpStatusCode){var o={};o[a.accessDenied]=401,o[a.connectionFailure]=500,o[a.generalException]=500,o[a.invalidArgument]=400,o[a.invalidObjectPath]=400,o[a.invalidOrTimedOutSession]=408,o[a.invalidRequestContext]=400,o[a.timeout]=408,o[a.valueNotLoaded]=400,r.httpStatusCode=o[r.code]}return u.isNullOrUndefined(r.httpStatusCode)&&(r.httpStatusCode=500),r}return __extends(n,t),n.prototype.toString=function(){return this.code+": "+this.message},n.prototype._createDebugInfo=function(t){var n={code:this.code,message:this.message,toString:function(){return JSON.stringify(this)}};for(var r in t)n[r]=t[r];return this.innerError&&(this.innerError instanceof e.RuntimeError?n.innerError=this.innerError.debugInfo:n.innerError=this.innerError),n},n._createInvalidArgError=function(t){return new e.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u.isNullOrEmptyString(t.argumentName)?u._getResourceString(s.invalidArgumentGeneric):u._getResourceString(s.invalidArgument,t.argumentName),debugInfo:t.errorLocation?{errorLocation:t.errorLocation}:{},innerError:t.innerError})},n}(Error);e.RuntimeError=t}(o=e._Internal||(e._Internal={})),e.Error=o.RuntimeError;var a=function(){function e(){}return e.apiNotFound="ApiNotFound",e.accessDenied="AccessDenied",e.generalException="GeneralException",e.activityLimitReached="ActivityLimitReached",e.invalidArgument="InvalidArgument",e.connectionFailure="ConnectionFailure",e.timeout="Timeout",e.invalidOrTimedOutSession="InvalidOrTimedOutSession",e.invalidObjectPath="InvalidObjectPath",e.invalidRequestContext="InvalidRequestContext",e.valueNotLoaded="ValueNotLoaded",e.requestPayloadSizeLimitExceeded="RequestPayloadSizeLimitExceeded",e.responsePayloadSizeLimitExceeded="ResponsePayloadSizeLimitExceeded",e.writeNotSupportedWhenModalDialogOpen="WriteNotSupportedWhenModalDialogOpen",e}();e.CoreErrorCodes=a;var s=function(){function e(){}return e.apiNotFoundDetails="ApiNotFoundDetails",e.connectionFailureWithStatus="ConnectionFailureWithStatus",e.connectionFailureWithDetails="ConnectionFailureWithDetails",e.invalidArgument="InvalidArgument",e.invalidArgumentGeneric="InvalidArgumentGeneric",e.timeout="Timeout",e.invalidOrTimedOutSessionMessage="InvalidOrTimedOutSessionMessage",e.invalidSheetName="InvalidSheetName",e.invalidObjectPath="InvalidObjectPath",e.invalidRequestContext="InvalidRequestContext",e.valueNotLoaded="ValueNotLoaded",e}();e.CoreResourceStrings=s;var c=function(){function e(){}return e.flags="flags",e.sourceLibHeader="SdkVersion",e.processQuery="ProcessQuery",e.localDocument="http://document.localhost/",e.localDocumentApiPrefix="http://document.localhost/_api/",e.customData="customdata",e.testRequestNameHeader="x-test-request-name",e}();e.CoreConstants=c;var l=function(){function e(){}return e.buildMessageArrayForIRequestExecutor=function(t,n,r,o){var i=JSON.stringify(r.Body);u.log("Request:"),u.log(i);var a={};return u._copyHeaders(r.Headers,a),a[c.sourceLibHeader]=o,e.buildRequestMessageSafeArray(t,n,"POST",c.processQuery,a,i)},e.buildResponseOnSuccess=function(e,t){var n={HttpStatusCode:200,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return n.Body=JSON.parse(e),n.Headers=t,n},e.buildResponseOnError=function(t,n){var r={HttpStatusCode:500,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return r.ErrorCode=a.generalException,r.ErrorMessage=n,t==e.OfficeJsErrorCode_ooeNoCapability?(r.ErrorCode=a.accessDenied,r.HttpStatusCode=401):t==e.OfficeJsErrorCode_ooeActivityLimitReached?(r.ErrorCode=a.activityLimitReached,r.HttpStatusCode=429):t==e.OfficeJsErrorCode_ooeInvalidOrTimedOutSession?(r.ErrorCode=a.invalidOrTimedOutSession,r.HttpStatusCode=408,r.ErrorMessage=u._getResourceString(s.invalidOrTimedOutSessionMessage)):t==e.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded?(r.ErrorCode=a.requestPayloadSizeLimitExceeded,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded?(r.ErrorCode=a.responsePayloadSizeLimitExceeded,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen?(r.ErrorCode=a.writeNotSupportedWhenModalDialogOpen,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeInvalidSheetName&&(r.ErrorCode=a.invalidRequestContext,r.HttpStatusCode=400,r.ErrorMessage=u._getResourceString(s.invalidSheetName)),r},e.buildHttpResponseFromOfficeJsError=function(t,n){var r=500,o={error:{}};return o.error.code=a.generalException,o.error.message=n,t===e.OfficeJsErrorCode_ooeNoCapability?(r=403,o.error.code=a.accessDenied):t===e.OfficeJsErrorCode_ooeActivityLimitReached&&(r=429,o.error.code=a.activityLimitReached),{statusCode:r,headers:{},body:JSON.stringify(o)}},e.buildRequestMessageSafeArray=function(e,t,n,r,o,i){var a=[];if(o)for(var s in o)a.push(s),a.push(o[s]);return[e,n,r,a,i,0,t,"","","","","",""]},e.getResponseBody=function(t){return e.getResponseBodyFromSafeArray(t.value.data)},e.getResponseHeaders=function(t){return e.getResponseHeadersFromSafeArray(t.value.data)},e.getResponseBodyFromSafeArray=function(e){var t=e[2];return"string"==typeof t?t:t.join("")},e.getResponseHeadersFromSafeArray=function(e){var t=e[1];if(!t)return null;for(var n={},r=0;r<t.length-1;r+=2)n[t[r]]=t[r+1];return n},e.getResponseStatusCode=function(t){return e.getResponseStatusCodeFromSafeArray(t.value.data)},e.getResponseStatusCodeFromSafeArray=function(e){return e[0]},e.OfficeJsErrorCode_ooeInvalidOrTimedOutSession=5012,e.OfficeJsErrorCode_ooeActivityLimitReached=5102,e.OfficeJsErrorCode_ooeNoCapability=7e3,e.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded=5103,e.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded=5104,e.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen=5016,e.OfficeJsErrorCode_ooeInvalidSheetName=1014,e}();e.RichApiMessageUtility=l,function(e){e.getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;if(void 0!==OfficeExtension&&OfficeExtension.Promise)return OfficeExtension.Promise;throw new e.Error("No Promise implementation found")}}(o=e._Internal||(e._Internal={}));var u=function(){function e(){}return e.log=function(t){e._logEnabled&&"undefined"!=typeof console&&console.log&&console.log(t)},e.checkArgumentNull=function(t,n){if(e.isNullOrUndefined(t))throw o.RuntimeError._createInvalidArgError({argumentName:n})},e.isNullOrUndefined=function(e){return null===e||void 0===e},e.isUndefined=function(e){return void 0===e},e.isNullOrEmptyString=function(e){return null===e||(void 0===e||0==e.length)},e.isPlainJsonObject=function(t){if(e.isNullOrUndefined(t))return!1;if("object"!=typeof t)return!1;if("[object Object]"!==Object.prototype.toString.apply(t))return!1;if(t.constructor&&!Object.prototype.hasOwnProperty.call(t,"constructor")&&!Object.prototype.hasOwnProperty.call(t.constructor.prototype,"hasOwnProperty"))return!1;for(var n in t)if(!Object.prototype.hasOwnProperty.call(t,n))return!1;return!0},e.trim=function(e){return e.replace(new RegExp("^\\s+|\\s+$","g"),"")},e.caseInsensitiveCompareString=function(t,n){return e.isNullOrUndefined(t)?e.isNullOrUndefined(n):!e.isNullOrUndefined(n)&&t.toUpperCase()==n.toUpperCase()},e.isReadonlyRestRequest=function(t){return e.caseInsensitiveCompareString(t,"GET")},e._getResourceString=function(t,n){var r;if("undefined"!=typeof window&&window.Strings&&window.Strings.OfficeOM){var o="L_"+t,i=window.Strings.OfficeOM[o];i&&(r=i)}if(r||(r=e.s_resourceStringValues[t]),r||(r=t),!e.isNullOrUndefined(n))if(Array.isArray(n)){var a=n;r=e._formatString(r,a)}else r=r.replace("{0}",n);return r},e._formatString=function(e,t){return e.replace(/\{\d\}/g,(function(e){var n=parseInt(e.substr(1,e.length-2));if(n<t.length)return t[n];throw o.RuntimeError._createInvalidArgError({argumentName:"format"})}))},Object.defineProperty(e,"Promise",{get:function(){return o.getPromiseType()},enumerable:!0,configurable:!0}),e.createPromise=function(t){return new e.Promise(t)},e._createPromiseFromResult=function(t){return e.createPromise((function(e,n){e(t)}))},e._createPromiseFromException=function(t){return e.createPromise((function(e,n){n(t)}))},e._createTimeoutPromise=function(t){return e.createPromise((function(e,n){setTimeout((function(){e(null)}),t)}))},e._createInvalidArgError=function(e){return o.RuntimeError._createInvalidArgError(e)},e._isLocalDocumentUrl=function(t){return e._getLocalDocumentUrlPrefixLength(t)>0},e._getLocalDocumentUrlPrefixLength=function(e){for(var t=["http://document.localhost","https://document.localhost","//document.localhost"],n=e.toLowerCase().trim(),r=0;r<t.length;r++){if(n===t[r])return t[r].length;if(n.substr(0,t[r].length+1)===t[r]+"/")return t[r].length+1}return 0},e._validateLocalDocumentRequest=function(t){var n=e._getLocalDocumentUrlPrefixLength(t.url);if(n<=0)throw o.RuntimeError._createInvalidArgError({argumentName:"request"});var r=t.url.substr(n),i=r.toLowerCase();return"_api"===i?r="":"_api/"===i.substr(0,"_api/".length)&&(r=r.substr("_api/".length)),{method:t.method,url:r,headers:t.headers,body:t.body}},e._parseRequestFlagsAndCustomDataFromQueryStringIfAny=function(e){for(var t={flags:-1,customData:""},n=e.split("&"),r=0;r<n.length;r++){var o=n[r].split("=");if(o[0].toLowerCase()===c.flags){var i=parseInt(o[1]);i&=32767,t.flags=i}else o[0].toLowerCase()===c.customData&&(t.customData=decodeURIComponent(o[1]))}return t},e._getRequestBodyText=function(e){var t="";return"string"==typeof e.body?t=e.body:e.body&&"object"==typeof e.body&&(t=JSON.stringify(e.body)),t},e._parseResponseBody=function(t){if("string"==typeof t.body){var n=e.trim(t.body);return JSON.parse(n)}return t.body},e._buildRequestMessageSafeArray=function(t){var n=0;e.isReadonlyRestRequest(t.method)||(n=1);var r="";if(t.url.substr(0,c.processQuery.length).toLowerCase()===c.processQuery.toLowerCase()){var o=t.url.indexOf("?");if(o>0){var i=t.url.substr(o+1),a=e._parseRequestFlagsAndCustomDataFromQueryStringIfAny(i);a.flags>=0&&(n=a.flags),r=a.customData}}return l.buildRequestMessageSafeArray(r,n,t.method,t.url,t.headers,e._getRequestBodyText(t))},e._parseHttpResponseHeaders=function(t){var n={};if(!e.isNullOrEmptyString(t))for(var r=new RegExp("\r?\n"),o=t.split(r),i=0;i<o.length;i++){var a=o[i];if(null!=a){var s=a.indexOf(":");if(s>0){var c=a.substr(0,s),l=a.substr(s+1);c=e.trim(c),l=e.trim(l),n[c.toUpperCase()]=l}}}return n},e._parseErrorResponse=function(t){var n=e._parseErrorResponseBody(t),r=t.statusCode.toString();if(e.isNullOrUndefined(n)||"object"!=typeof n||!n.error)return e._createDefaultErrorResponse(r);var o=n.error,i=o.innerError;return i&&i.code?e._createErrorResponse(i.code,r,i.message):o.code?e._createErrorResponse(o.code,r,o.message):e._createDefaultErrorResponse(r)},e._parseErrorResponseBody=function(t){if(e.isPlainJsonObject(t.body))return t.body;if(!e.isNullOrEmptyString(t.body)){var n=e.trim(t.body);try{return JSON.parse(n)}catch(t){e.log("Error when parse "+n)}}},e._createDefaultErrorResponse=function(t){return{errorCode:a.connectionFailure,errorMessage:e._getResourceString(s.connectionFailureWithStatus,t)}},e._createErrorResponse=function(t,n,r){return{errorCode:t,errorMessage:e._getResourceString(s.connectionFailureWithDetails,[n,t,r])}},e._copyHeaders=function(e,t){if(e&&t)for(var n in e)t[n]=e[n]},e.addResourceStringValues=function(t){for(var n in t)e.s_resourceStringValues[n]=t[n]},e._logEnabled=!1,e.s_resourceStringValues={ApiNotFoundDetails:"The method or property {0} is part of the {1} requirement set, which is not available in your version of {2}.",ConnectionFailureWithStatus:"The request failed with status code of {0}.",ConnectionFailureWithDetails:"The request failed with status code of {0}, error code {1} and the following error message: {2}",InvalidArgument:"The argument '{0}' doesn't work for this situation, is missing, or isn't in the right format.",InvalidObjectPath:'The object path \'{0}\' isn\'t working for what you\'re trying to do. If you\'re using the object across multiple "context.sync" calls and outside the sequential execution of a ".run" batch, please use the "context.trackedObjects.add()" and "context.trackedObjects.remove()" methods to manage the object\'s lifetime.',InvalidRequestContext:"Cannot use the object across different request contexts.",Timeout:"The operation has timed out.",ValueNotLoaded:'The value of the result object has not been loaded yet. Before reading the value property, call "context.sync()" on the associated request context.'},e}();e.CoreUtility=u;var d=function(){function e(){}return e.setMock=function(t){e.s_isMock=t},e.isMock=function(){return e.s_isMock},e._setCurrentTestName=function(t){e.s_currentTestName=t,e.s_currentTestSequenceId=0},e._getCurrentTestNameWithSequenceId=function(){return e.s_currentTestName?(e.s_currentTestSequenceId++,e.s_currentTestName+"."+e.s_currentTestSequenceId):null},e}();e.TestUtility=d,e._internalConfig={showDisposeInfoInDebugInfo:!1,showInternalApiInDebugInfo:!1,enableEarlyDispose:!0,alwaysPolyfillClientObjectUpdateMethod:!1,alwaysPolyfillClientObjectRetrieveMethod:!1,enableConcurrentFlag:!0,enableUndoableFlag:!0,appendTypeNameToObjectPathInfo:!1,enablePreviewExecution:!1},e.config={extendedErrorLogging:!1};var f=function(){function t(){}return t.createSetPropertyAction=function(t,n,r,o,i){S.validateObjectPath(n);var a={Id:t._nextId(),ActionType:4,Name:r,ObjectPathId:n._objectPath.objectPathInfo.Id,ArgumentInfo:{}},s=[o],c=S.setMethodArguments(t,a.ArgumentInfo,s);S.validateReferencedObjectPaths(c);var l=new g(a,0,i);if(l.referencedObjectPath=n._objectPath,l.referencedArgumentObjectPaths=c,e._internalConfig.enablePreviewExecution&&0!=(16&i)){var u={Id:t._nextId(),ActionType:4,Name:r,ObjectId:"",ObjectType:"",Arguments:[o]};n._addPreviewExecutionAction(u)}return n._addAction(l)},t.createQueryAction=function(e,t,n,r){S.validateObjectPath(t);var o={Id:e._nextId(),ActionType:2,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},i=new g(o,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i,r)},t.createQueryAsJsonAction=function(e,t,n,r){S.validateObjectPath(t);var o={Id:e._nextId(),ActionType:7,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},i=new g(o,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i,r)},t.createUpdateAction=function(e,t,n){S.validateObjectPath(t);var r={Id:e._nextId(),ActionType:9,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},o=new g(r,0,0);return o.referencedObjectPath=t._objectPath,t._addAction(o)},t}();e.CommonActionFactory=f;var p=function(){function t(e,t){this.m_contextBase=e,this.m_objectPath=t}return Object.defineProperty(t.prototype,"_objectPath",{get:function(){return this.m_objectPath},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_context",{get:function(){return this.m_contextBase},enumerable:!0,configurable:!0}),t.prototype._addAction=function(e,t){var n=this;return void 0===t&&(t=null),u.createPromise((function(r,o){n._context._addServiceApiAction(e,t,r,o)}))},t.prototype._addPreviewExecutionAction=function(e){},t.prototype._retrieve=function(t,n){var r=e._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;r||(r=!S.isSetSupported("RichApiRuntime","1.1"));var o=m._parseQueryOption(t);return r?f.createQueryAction(this._context,this,o,n):f.createQueryAsJsonAction(this._context,this,o,n)},t.prototype._recursivelyUpdate=function(t){var n=e._internalConfig.alwaysPolyfillClientObjectUpdateMethod;n||(n=!S.isSetSupported("RichApiRuntime","1.2"));try{var r=this[O.scalarPropertyNames];r||(r=[]);var i=this[O.scalarPropertyUpdateable];if(!i){i=[];for(var c=0;c<r.length;c++)i.push(!1)}var l=this[O.navigationPropertyNames];l||(l=[]);var d={},p={},g=0;for(var h in t){var m=r.indexOf(h);if(m>=0){if(!i[m])throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(A.attemptingToSetReadOnlyProperty,h),debugInfo:{errorLocation:h}});d[h]=t[h],++g}else{if(!(l.indexOf(h)>=0))throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(A.propertyDoesNotExist,h),debugInfo:{errorLocation:h}});p[h]=t[h]}}if(g>0)if(n)for(c=0;c<r.length;c++){var y=d[h=r[c]];S.isUndefined(y)||f.createSetPropertyAction(this._context,this,h,y)}else f.createUpdateAction(this._context,this,d);for(var h in p){var v=this[h],b=p[h];v._recursivelyUpdate(b)}}catch(e){throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(s.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".update"},innerError:e})}},t}();e.ClientObjectBase=p;var g=function(){function e(e,t,n){this.m_actionInfo=e,this.m_operationType=t,this.m_flags=n}return Object.defineProperty(e.prototype,"actionInfo",{get:function(){return this.m_actionInfo},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),e}();e.Action=g;var h=function(){function t(e,t,n,r,o,i){this.m_objectPathInfo=e,this.m_parentObjectPath=t,this.m_isCollection=n,this.m_isInvalidAfterRequest=r,this.m_isValid=!0,this.m_operationType=o,this.m_flags=i}return Object.defineProperty(t.prototype,"id",{get:function(){var e=this.m_objectPathInfo.ArgumentInfo;if(e){var t=e.Arguments;if(t)return t[0]}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parent",{get:function(){var e=this.m_parentObjectPath;if(e)return e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parentId",{get:function(){return this.parent?this.parent.id:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"objectPathInfo",{get:function(){return this.m_objectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isCollection",{get:function(){return this.m_isCollection},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isInvalidAfterRequest",{get:function(){return this.m_isInvalidAfterRequest},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parentObjectPath",{get:function(){return this.m_parentObjectPath},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"argumentObjectPaths",{get:function(){return this.m_argumentObjectPaths},set:function(e){this.m_argumentObjectPaths=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isValid",{get:function(){return this.m_isValid},set:function(e){this.m_isValid=e,!e&&6===this.m_objectPathInfo.ObjectPathType&&this.m_savedObjectPathInfo&&(t.copyObjectPathInfo(this.m_savedObjectPathInfo.pathInfo,this.m_objectPathInfo),this.m_parentObjectPath=this.m_savedObjectPathInfo.parent,this.m_isValid=!0,this.m_savedObjectPathInfo=null)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"originalObjectPathInfo",{get:function(){return this.m_originalObjectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"getByIdMethodName",{get:function(){return this.m_getByIdMethodName},set:function(e){this.m_getByIdMethodName=e},enumerable:!0,configurable:!0}),t.prototype._updateAsNullObject=function(){this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=7,this.m_objectPathInfo.Name="",this.m_parentObjectPath=null},t.prototype.saveOriginalObjectPathInfo=function(){e.config.extendedErrorLogging&&!this.m_originalObjectPathInfo&&(this.m_originalObjectPathInfo={},t.copyObjectPathInfo(this.m_objectPathInfo,this.m_originalObjectPathInfo))},t.prototype.updateUsingObjectData=function(e,n){var r=e[O.referenceId];if(!u.isNullOrEmptyString(r)){if(!this.m_savedObjectPathInfo&&!this.isInvalidAfterRequest&&t.isRestorableObjectPath(this.m_objectPathInfo.ObjectPathType)){var o={};t.copyObjectPathInfo(this.m_objectPathInfo,o),this.m_savedObjectPathInfo={pathInfo:o,parent:this.m_parentObjectPath}}return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=6,this.m_objectPathInfo.Name=r,delete this.m_objectPathInfo.ParentObjectPathId,void(this.m_parentObjectPath=null)}if(n){var i=n[O.collectionPropertyPath];if(!u.isNullOrEmptyString(i)&&n.context){var a=S.tryGetObjectIdFromLoadOrRetrieveResult(e);if(!u.isNullOrUndefined(a)){for(var s=i.split("."),c=n.context[s[0]],l=1;l<s.length;l++)c=c[s[l]];return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_parentObjectPath=c._objectPath,this.m_objectPathInfo.ParentObjectPathId=this.m_parentObjectPath.objectPathInfo.Id,this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name="",void(this.m_objectPathInfo.ArgumentInfo.Arguments=[a])}}}var d=this.parentObjectPath&&this.parentObjectPath.isCollection,f=this.getByIdMethodName;if(d||!u.isNullOrEmptyString(f)){a=S.tryGetObjectIdFromLoadOrRetrieveResult(e);if(!u.isNullOrUndefined(a))return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),u.isNullOrEmptyString(f)?(this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name=""):(this.m_objectPathInfo.ObjectPathType=3,this.m_objectPathInfo.Name=f),void(this.m_objectPathInfo.ArgumentInfo.Arguments=[a])}},t.prototype.resetForUpdateUsingObjectData=function(){this.m_isInvalidAfterRequest=!1,this.m_isValid=!0,this.m_operationType=1,this.m_flags=4,this.m_objectPathInfo.ArgumentInfo={},this.m_argumentObjectPaths=null,this.m_getByIdMethodName=null},t.isRestorableObjectPath=function(e){return 1===e||5===e||3===e||4===e},t.copyObjectPathInfo=function(e,t){t.Id=e.Id,t.ArgumentInfo=e.ArgumentInfo,t.Name=e.Name,t.ObjectPathType=e.ObjectPathType,t.ParentObjectPathId=e.ParentObjectPathId},t}();e.ObjectPath=h;var m=function(){function e(){this.m_nextId=0}return e.prototype._nextId=function(){return++this.m_nextId},e.prototype._addServiceApiAction=function(e,t,n,r){this.m_serviceApiQueue||(this.m_serviceApiQueue=new C(this)),this.m_serviceApiQueue.add(e,t,n,r)},e._parseQueryOption=function(t){var n={};if("string"==typeof t){var r=t;n.Select=S._parseSelectExpand(r)}else if(Array.isArray(t))n.Select=t;else if("object"==typeof t){var i=t;if(e.isLoadOption(i)){if("string"==typeof i.select)n.Select=S._parseSelectExpand(i.select);else if(Array.isArray(i.select))n.Select=i.select;else if(!S.isNullOrUndefined(i.select))throw o.RuntimeError._createInvalidArgError({argumentName:"option.select"});if("string"==typeof i.expand)n.Expand=S._parseSelectExpand(i.expand);else if(Array.isArray(i.expand))n.Expand=i.expand;else if(!S.isNullOrUndefined(i.expand))throw o.RuntimeError._createInvalidArgError({argumentName:"option.expand"});if("number"==typeof i.top)n.Top=i.top;else if(!S.isNullOrUndefined(i.top))throw o.RuntimeError._createInvalidArgError({argumentName:"option.top"});if("number"==typeof i.skip)n.Skip=i.skip;else if(!S.isNullOrUndefined(i.skip))throw o.RuntimeError._createInvalidArgError({argumentName:"option.skip"})}else n=e.parseStrictLoadOption(t)}else if(!S.isNullOrUndefined(t))throw o.RuntimeError._createInvalidArgError({argumentName:"option"});return n},e.isLoadOption=function(e){if(!S.isUndefined(e.select)&&("string"==typeof e.select||Array.isArray(e.select)))return!0;if(!S.isUndefined(e.expand)&&("string"==typeof e.expand||Array.isArray(e.expand)))return!0;if(!S.isUndefined(e.top)&&"number"==typeof e.top)return!0;if(!S.isUndefined(e.skip)&&"number"==typeof e.skip)return!0;for(var t in e)return!1;return!0},e.parseStrictLoadOption=function(t){var n={Select:[]};return e.parseStrictLoadOptionHelper(n,"","option",t),n},e.combineQueryPath=function(e,t,n){return 0===e.length?t:e+n+t},e.parseStrictLoadOptionHelper=function(t,n,r,i){for(var a in i){var s=i[a];if("$all"===a){if("boolean"!=typeof s)throw o.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});s&&t.Select.push(e.combineQueryPath(n,"*","/"))}else if("$top"===a){if("number"!=typeof s||n.length>0)throw o.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});t.Top=s}else if("$skip"===a){if("number"!=typeof s||n.length>0)throw o.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});t.Skip=s}else if("boolean"==typeof s)s&&t.Select.push(e.combineQueryPath(n,a,"/"));else{if("object"!=typeof s)throw o.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});e.parseStrictLoadOptionHelper(t,e.combineQueryPath(n,a,"/"),e.combineQueryPath(r,a,"."),s)}}},e}();e.ClientRequestContextBase=m;var y=function(){function e(e){this.m_objectPath=e}return e.prototype._handleResult=function(e){u.isNullOrUndefined(e)?this.m_objectPath._updateAsNullObject():this.m_objectPath.updateUsingObjectData(e,null)},e}(),v=function(){function t(e){this.m_contextBase=e,this.m_actions=[],this.m_actionResultHandler={},this.m_referencedObjectPaths={},this.m_instantiatedObjectPaths={},this.m_preSyncPromises=[],this.m_previewExecutionActions=[]}return t.prototype.addAction=function(e){this.m_actions.push(e),1==e.actionInfo.ActionType&&(this.m_instantiatedObjectPaths[e.actionInfo.ObjectPathId]=e)},t.prototype.addPreviewExecutionAction=function(e){this.m_previewExecutionActions.push(e)},Object.defineProperty(t.prototype,"hasActions",{get:function(){return this.m_actions.length>0},enumerable:!0,configurable:!0}),t.prototype._getLastAction=function(){return this.m_actions[this.m_actions.length-1]},t.prototype.ensureInstantiateObjectPath=function(e){if(e){if(this.m_instantiatedObjectPaths[e.objectPathInfo.Id])return;if(this.ensureInstantiateObjectPath(e.parentObjectPath),this.ensureInstantiateObjectPaths(e.argumentObjectPaths),!this.m_instantiatedObjectPaths[e.objectPathInfo.Id]){var t={Id:this.m_contextBase._nextId(),ActionType:1,Name:"",ObjectPathId:e.objectPathInfo.Id},n=new g(t,1,4);n.referencedObjectPath=e,this.addReferencedObjectPath(e),this.addAction(n);var r=new y(e);this.addActionResultHandler(n,r)}}},t.prototype.ensureInstantiateObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.ensureInstantiateObjectPath(e[t])},t.prototype.addReferencedObjectPath=function(e){if(e&&!this.m_referencedObjectPaths[e.objectPathInfo.Id]){if(!e.isValid)throw new o.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:u._getResourceString(s.invalidObjectPath,S.getObjectPathExpression(e)),debugInfo:{errorLocation:S.getObjectPathExpression(e)}});for(;e;)this.m_referencedObjectPaths[e.objectPathInfo.Id]=e,3==e.objectPathInfo.ObjectPathType&&this.addReferencedObjectPaths(e.argumentObjectPaths),e=e.parentObjectPath}},t.prototype.addReferencedObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.addReferencedObjectPath(e[t])},t.prototype.addActionResultHandler=function(e,t){this.m_actionResultHandler[e.actionInfo.Id]=t},t.prototype.aggregrateRequestFlags=function(e,t,n){return 0===t&&(e|=1,0==(2&n)&&(e&=-17),0==(8&n)&&(e&=-257),e&=-5),1&n&&(e|=2),0==(4&n)&&(e&=-5),e},t.prototype.finallyNormalizeFlags=function(t){return 0==(1&t)&&(t&=-17,t&=-257),e._internalConfig.enableConcurrentFlag||(t&=-5),e._internalConfig.enableUndoableFlag||(t&=-17),S.isSetSupported("RichApiRuntimeFlag","1.1")||(t&=-5,t&=-17),S.isSetSupported("RichApiRuntimeFlag","1.2")||(t&=-257),"number"==typeof this.m_flagsForTesting&&(t=this.m_flagsForTesting),t},t.prototype.buildRequestMessageBodyAndRequestFlags=function(){e._internalConfig.enableEarlyDispose&&t._calculateLastUsedObjectPathIds(this.m_actions);var n=276,r={};for(var o in this.m_referencedObjectPaths)n=this.aggregrateRequestFlags(n,this.m_referencedObjectPaths[o].operationType,this.m_referencedObjectPaths[o].flags),r[o]=this.m_referencedObjectPaths[o].objectPathInfo;for(var i=[],a=!1,s=0;s<this.m_actions.length;s++){var c=this.m_actions[s];3===c.actionInfo.ActionType&&c.actionInfo.Name===O.keepReference&&(a=!0),n=this.aggregrateRequestFlags(n,c.operationType,c.flags),i.push(c.actionInfo)}n=this.finallyNormalizeFlags(n);var l={AutoKeepReference:this.m_contextBase._autoCleanup&&a,Actions:i,ObjectPaths:r};return this.m_previewExecutionActions.length>0&&(l.PreviewExecutionActions=this.m_previewExecutionActions,n|=4096),{body:l,flags:n}},t.prototype.processResponse=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t],r=this.m_actionResultHandler[n.ActionId];r&&r._handleResult(n.Value)}},t.prototype.invalidatePendingInvalidObjectPaths=function(){for(var e in this.m_referencedObjectPaths)this.m_referencedObjectPaths[e].isInvalidAfterRequest&&(this.m_referencedObjectPaths[e].isValid=!1)},t.prototype._addPreSyncPromise=function(e){this.m_preSyncPromises.push(e)},Object.defineProperty(t.prototype,"_preSyncPromises",{get:function(){return this.m_preSyncPromises},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_actions",{get:function(){return this.m_actions},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_objectPaths",{get:function(){return this.m_referencedObjectPaths},enumerable:!0,configurable:!0}),t.prototype._removeKeepReferenceAction=function(e){for(var t=this.m_actions.length-1;t>=0;t--){var n=this.m_actions[t].actionInfo;if(n.ObjectPathId===e&&3===n.ActionType&&n.Name===O.keepReference){this.m_actions.splice(t,1);break}}},t._updateLastUsedActionIdOfObjectPathId=function(e,n,r){for(;n;){if(e[n.objectPathInfo.Id])return;e[n.objectPathInfo.Id]=r;var o=n.argumentObjectPaths;if(o)for(var i=o.length,a=0;a<i;a++)t._updateLastUsedActionIdOfObjectPathId(e,o[a],r);n=n.parentObjectPath}},t._calculateLastUsedObjectPathIds=function(e){for(var n={},r=e.length,o=r-1;o>=0;--o){var i=(f=e[o]).actionInfo.Id;f.referencedObjectPath&&t._updateLastUsedActionIdOfObjectPathId(n,f.referencedObjectPath,i);var a=f.referencedArgumentObjectPaths;if(a)for(var s=a.length,c=0;c<s;c++)t._updateLastUsedActionIdOfObjectPathId(n,a[c],i)}var l={};for(var u in n){var d=l[i=n[u]];d||(d=[],l[i]=d),d.push(parseInt(u))}for(o=0;o<r;o++){var f,p=l[(f=e[o]).actionInfo.Id];p&&p.length>0?f.actionInfo.L=p:f.actionInfo.L&&delete f.actionInfo.L}},t}();e.ClientRequestBase=v;var b=function(){function e(e){this.m_type=e}return Object.defineProperty(e.prototype,"value",{get:function(){if(!this.m_isLoaded)throw new o.RuntimeError({code:a.valueNotLoaded,httpStatusCode:400,message:u._getResourceString(s.valueNotLoaded),debugInfo:{errorLocation:"clientResult.value"}});return this.m_value},enumerable:!0,configurable:!0}),e.prototype._handleResult=function(e){this.m_isLoaded=!0,"object"==typeof e&&e&&e._IsNull||(1===this.m_type?this.m_value=S.adjustToDateTime(e):this.m_value=e)},e}();e.ClientResult=b;var C=function(){function e(e){this.m_context=e,this.m_actions=[]}return e.prototype.add=function(e,t,n,r){var o=this;this.m_actions.push({action:e,resultHandler:t,resolve:n,reject:r}),1===this.m_actions.length&&setTimeout((function(){return o.processActions()}),0)},e.prototype.processActions=function(){var e=this;if(0!==this.m_actions.length){var t=this.m_actions;this.m_actions=[];for(var n=new v(this.m_context),r=0;r<t.length;r++){var o=t[r];n.ensureInstantiateObjectPath(o.action.referencedObjectPath),n.ensureInstantiateObjectPaths(o.action.referencedArgumentObjectPaths),n.addAction(o.action),n.addReferencedObjectPath(o.action.referencedObjectPath),n.addReferencedObjectPaths(o.action.referencedArgumentObjectPaths)}var i=n.buildRequestMessageBodyAndRequestFlags(),a=i.body,s=i.flags,l={Url:c.localDocumentApiPrefix,Headers:null,Body:a};u.log("Request:"),u.log(JSON.stringify(a)),(new _).executeAsync(this.m_context._customData,s,l).then((function(r){e.processResponse(n,t,r)})).catch((function(e){for(var n=0;n<t.length;n++){t[n].reject(e)}}))}},e.prototype.processResponse=function(e,t,n){var r=this.getErrorFromResponse(n),o=null;n.Body.Results?o=n.Body.Results:n.Body.ProcessedResults&&n.Body.ProcessedResults.Results&&(o=n.Body.ProcessedResults.Results),o||(o=[]),this.processActionResults(e,t,o,r)},e.prototype.getErrorFromResponse=function(e){return u.isNullOrEmptyString(e.ErrorCode)?e.Body&&e.Body.Error?new o.RuntimeError({code:e.Body.Error.Code,httpStatusCode:e.Body.Error.HttpStatusCode,message:e.Body.Error.Message}):null:new o.RuntimeError({code:e.ErrorCode,httpStatusCode:e.HttpStatusCode,message:e.ErrorMessage})},e.prototype.processActionResults=function(e,t,n,r){e.processResponse(n);for(var o=0;o<t.length;o++){for(var i=t[o],a=i.action.actionInfo.Id,s=!1,c=0;c<n.length;c++)if(a==n[c].ActionId){var l=n[c].Value;i.resultHandler&&(i.resultHandler._handleResult(l),l=i.resultHandler.value),i.resolve&&i.resolve(l),s=!0;break}!s&&i.reject&&(r?i.reject(r):i.reject("No response for the action."))}},e}(),_=function(){function e(){}return e.prototype.getRequestUrl=function(e,n,r){void 0===r&&(r=t.graph.toString());var o=c.flags+"="+n.toString();switch(r){case t.graph.toString():"/"!=e.charAt(e.length-1)&&(e+="/"),e=(e+=c.processQuery)+"?"+o;break;case t.wfe.toString():e=(e=e+"&"+o)+"&wdRestPart=_api/"+c.processQuery}return e},e.prototype.executeAsync=function(n,o,i){var a=i.Headers?i.Headers[O.remoteEndpointTypeHeaderKey]:t.graph.toString(),s={method:"POST",url:this.getRequestUrl(i.Url,o,a),headers:{},body:i.Body};if(s.headers[c.sourceLibHeader]=e.SourceLibHeaderValue,s.headers["CONTENT-TYPE"]="application/json",i.Headers)for(var l in i.Headers)s.headers[l]=i.Headers[l];return(u._isLocalDocumentUrl(s.url)?r.sendLocalDocumentRequest:r.sendRequest)(s).then((function(e){var t;if(200===e.statusCode)t={HttpStatusCode:e.statusCode,ErrorCode:null,ErrorMessage:null,Headers:e.headers,Body:u._parseResponseBody(e)};else{u.log("Error Response:"+e.body);var n=u._parseErrorResponse(e);t={HttpStatusCode:e.statusCode,ErrorCode:n.errorCode,ErrorMessage:n.errorMessage,Headers:e.headers,Body:null,RawErrorResponseBody:u._parseErrorResponseBody(e)}}return t}))},e.SourceLibHeaderValue="officejs-rest",e}();e.HttpRequestExecutor=_;var O=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.collectionPropertyPath="_collectionPropertyPath",t.id="Id",t.idLowerCase="id",t.idPrivate="_Id",t.keepReference="_KeepReference",t.objectPathIdPrivate="_ObjectPathId",t.referenceId="_ReferenceId",t.items="_Items",t.itemsLowerCase="items",t.scalarPropertyNames="_scalarPropertyNames",t.scalarPropertyOriginalNames="_scalarPropertyOriginalNames",t.navigationPropertyNames="_navigationPropertyNames",t.scalarPropertyUpdateable="_scalarPropertyUpdateable",t.previewExecutionObjectId="_previewExecutionObjectId",t.remoteEndpointTypeHeaderKey="X-EndpointType",t}(c);e.CommonConstants=O;var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.validateObjectPath=function(e){for(var n=e._objectPath;n;){if(!n.isValid)throw new o.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:u._getResourceString(s.invalidObjectPath,t.getObjectPathExpression(n)),debugInfo:{errorLocation:t.getObjectPathExpression(n)}});n=n.parentObjectPath}},t.validateReferencedObjectPaths=function(e){if(e)for(var n=0;n<e.length;n++)for(var r=e[n];r;){if(!r.isValid)throw new o.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:u._getResourceString(s.invalidObjectPath,t.getObjectPathExpression(r))});r=r.parentObjectPath}},t._toCamelLowerCase=function(e){if(u.isNullOrEmptyString(e))return e;for(var t=0;t<e.length&&e.charCodeAt(t)>=65&&e.charCodeAt(t)<=90;)t++;return t<e.length?e.substr(0,t).toLowerCase()+e.substr(t):e.toLowerCase()},t.adjustToDateTime=function(e){if(u.isNullOrUndefined(e))return null;if("string"==typeof e)return new Date(e);if(Array.isArray(e)){for(var n=e,r=0;r<n.length;r++)n[r]=t.adjustToDateTime(n[r]);return n}throw u._createInvalidArgError({argumentName:"date"})},t.tryGetObjectIdFromLoadOrRetrieveResult=function(e){var t=e[O.id];return u.isNullOrUndefined(t)&&(t=e[O.idLowerCase]),u.isNullOrUndefined(t)&&(t=e[O.idPrivate]),t},t.getObjectPathExpression=function(e){for(var n="";e;){switch(e.objectPathInfo.ObjectPathType){case 1:n=n;break;case 2:n="new()"+(n.length>0?".":"")+n;break;case 3:n=t.normalizeName(e.objectPathInfo.Name)+"()"+(n.length>0?".":"")+n;break;case 4:n=t.normalizeName(e.objectPathInfo.Name)+(n.length>0?".":"")+n;break;case 5:n="getItem()"+(n.length>0?".":"")+n;break;case 6:n="_reference()"+(n.length>0?".":"")+n}e=e.parentObjectPath}return n},t.setMethodArguments=function(e,n,r){if(u.isNullOrUndefined(r))return null;var o=new Array,i=new Array,a=t.collectObjectPathInfos(e,r,o,i);return n.Arguments=r,a&&(n.ReferencedObjectPathIds=i),o},t.validateContext=function(e,t){if(e&&t&&t._context!==e)throw new o.RuntimeError({code:a.invalidRequestContext,httpStatusCode:400,message:u._getResourceString(s.invalidRequestContext)})},t.isSetSupported=function(e,n){return"function"==typeof t.isSetSupportedOverride?t.isSetSupportedOverride(e,n):!("undefined"!=typeof window&&window.Office&&window.Office.context&&window.Office.context.requirements)||window.Office.context.requirements.isSetSupported(e,n)},t.throwIfApiNotSupported=function(e,n,r,i){if(t._doApiNotSupportedCheck&&!t.isSetSupported(n,r)){var c=u._getResourceString(s.apiNotFoundDetails,[e,n+" "+r,i]);throw new o.RuntimeError({code:a.apiNotFound,httpStatusCode:404,message:c,debugInfo:{errorLocation:e}})}},t.calculateApiFlags=function(e,n,r){var o=window&&window.location&&window.location.href&&-1!==window.location.href.indexOf("eed0a086-3498-4f91-a377-1e0265ecc0cc");return("function"==typeof t.isSetSupportedOverride?t.isSetSupportedOverride(n,r):!o&&t.isSetSupported(n,r))||(e&=-3),e},t._parseSelectExpand=function(e){var t=[];if(!u.isNullOrEmptyString(e))for(var n=e.split(","),r=0;r<n.length;r++){var o=n[r];(o=i(o.trim())).length>0&&t.push(o)}return t;function i(e){var t=e.toLowerCase();if("items"===t||"items/"===t)return"*";return("items/"===t.substr(0,6)||"items."===t.substr(0,6))&&(e=e.substr(6)),e.replace(new RegExp("[/.]items[/.]","gi"),"/")}},t.changePropertyNameToCamelLowerCase=function(e){if(Array.isArray(e)){for(var n=[],r=0;r<e.length;r++)n.push(this.changePropertyNameToCamelLowerCase(e[r]));return n}if("object"==typeof e&&null!==e){n={};for(var o in e){var i=e[o];if(o===O.items){(n={})[O.itemsLowerCase]=this.changePropertyNameToCamelLowerCase(i);break}n[t._toCamelLowerCase(o)]=this.changePropertyNameToCamelLowerCase(i)}return n}return e},t.purifyJson=function(e){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(this.purifyJson(e[n]));return t}if("object"==typeof e&&null!==e){t={};for(var r in e)if(95!==r.charCodeAt(0)){var o=e[r];"object"==typeof o&&null!==o&&Array.isArray(o.items)&&(o=o.items),t[r]=this.purifyJson(o)}return t}return e},t.collectObjectPathInfos=function(e,n,r,o){for(var i=!1,a=0;a<n.length;a++)if(n[a]instanceof p){var s=n[a];t.validateContext(e,s),n[a]=s._objectPath.objectPathInfo.Id,o.push(s._objectPath.objectPathInfo.Id),r.push(s._objectPath),i=!0}else if(Array.isArray(n[a])){var c=new Array;t.collectObjectPathInfos(e,n[a],r,c)?(o.push(c),i=!0):o.push(0)}else u.isPlainJsonObject(n[a])?(o.push(0),t.replaceClientObjectPropertiesWithObjectPathIds(n[a],r)):o.push(0);return i},t.replaceClientObjectPropertiesWithObjectPathIds=function(e,n){var r,o;for(var i in e){var a=e[i];if(a instanceof p)n.push(a._objectPath),e[i]=((r={})[O.objectPathIdPrivate]=a._objectPath.objectPathInfo.Id,r);else if(Array.isArray(a))for(var s=0;s<a.length;s++)if(a[s]instanceof p){var c=a[s];n.push(c._objectPath),a[s]=((o={})[O.objectPathIdPrivate]=c._objectPath.objectPathInfo.Id,o)}else u.isPlainJsonObject(a[s])&&t.replaceClientObjectPropertiesWithObjectPathIds(a[s],n);else u.isPlainJsonObject(a)&&t.replaceClientObjectPropertiesWithObjectPathIds(a,n)}},t.normalizeName=function(e){return e.substr(0,1).toLowerCase()+e.substr(1)},t._doApiNotSupportedCheck=!1,t}(u);e.CommonUtility=S;var A=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.propertyDoesNotExist="PropertyDoesNotExist",t.attemptingToSetReadOnlyProperty="AttemptingToSetReadOnlyProperty",t}(s);e.CommonResourceStrings=A;var E=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.propertyNotLoaded="PropertyNotLoaded",t.runMustReturnPromise="RunMustReturnPromise",t.cannotRegisterEvent="CannotRegisterEvent",t.invalidOrTimedOutSession="InvalidOrTimedOutSession",t.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",t}(a);e.ErrorCodes=E;var P=function(){function e(e){this.m_callback=e}return e.prototype._handleResult=function(e){this.m_callback&&this.m_callback()},e}(),R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.createMethodAction=function(t,n,r,o,i,a){z.validateObjectPath(n);var s={Id:t._nextId(),ActionType:3,Name:r,ObjectPathId:n._objectPath.objectPathInfo.Id,ArgumentInfo:{}},c=z.setMethodArguments(t,s.ArgumentInfo,i);z.validateReferencedObjectPaths(c);var l=z._fixupApiFlags(a),u=new g(s,o,l);if(u.referencedObjectPath=n._objectPath,u.referencedArgumentObjectPaths=c,n._addAction(u),e._internalConfig.enablePreviewExecution&&0!=(16&l)){var d={Id:t._nextId(),ActionType:3,Name:r,Arguments:i,ObjectId:"",ObjectType:""};n._addPreviewExecutionAction(d)}return u},n.createRecursiveQueryAction=function(e,t,n){z.validateObjectPath(t);var r={Id:e._nextId(),ActionType:6,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,RecursiveQueryInfo:n},o=new g(r,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o),o},n.createEnsureUnchangedAction=function(e,t,n){z.validateObjectPath(t);var r={Id:e._nextId(),ActionType:8,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},o=new g(r,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o),o},n.createInstantiateAction=function(e,t){z.validateObjectPath(t),e._pendingRequest.ensureInstantiateObjectPath(t._objectPath.parentObjectPath),e._pendingRequest.ensureInstantiateObjectPaths(t._objectPath.argumentObjectPaths);var n={Id:e._nextId(),ActionType:1,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id},r=new g(n,1,4);return r.referencedObjectPath=t._objectPath,t._addAction(r,new L(t),!0),r},n.createTraceAction=function(e,t,n){var r={Id:e._nextId(),ActionType:5,Name:"Trace",ObjectPathId:0},o=new g(r,1,4);return e._pendingRequest.addAction(o),n&&e._pendingRequest.addTrace(r.Id,t),o},n.createTraceMarkerForCallback=function(e,t){var r=n.createTraceAction(e,null,!1);e._pendingRequest.addActionResultHandler(r,new P(t))},n}(f);e.ActionFactory=R;var T=function(t){function n(n,r){var o=t.call(this,n,r)||this;return z.checkArgumentNull(n,"context"),o.m_context=n,o._objectPath&&(!n._processingResult&&n._pendingRequest&&(R.createInstantiateAction(n,o),n._autoCleanup&&o._KeepReference&&n.trackedObjects._autoAdd(o)),e._internalConfig.appendTypeNameToObjectPathInfo&&o._objectPath.objectPathInfo&&o._className&&(o._objectPath.objectPathInfo.T=o._className)),o}return __extends(n,t),Object.defineProperty(n.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isNull",{get:function(){return(void 0!==this.m_isNull||!d.isMock())&&(z.throwIfNotLoaded("isNull",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isNullObject",{get:function(){return(void 0!==this.m_isNull||!d.isMock())&&(z.throwIfNotLoaded("isNullObject",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isNull",{get:function(){return this.m_isNull},set:function(e){this.m_isNull=e,e&&this._objectPath&&this._objectPath._updateAsNullObject()},enumerable:!0,configurable:!0}),n.prototype._addAction=function(e,t,n){return void 0===t&&(t=null),n||(this.context._pendingRequest.ensureInstantiateObjectPath(this._objectPath),this.context._pendingRequest.ensureInstantiateObjectPaths(e.referencedArgumentObjectPaths)),this.context._pendingRequest.addAction(e),this.context._pendingRequest.addReferencedObjectPath(this._objectPath),this.context._pendingRequest.addReferencedObjectPaths(e.referencedArgumentObjectPaths),this.context._pendingRequest.addActionResultHandler(e,t),u._createPromiseFromResult(null)},n.prototype._addPreviewExecutionAction=function(e){if(!z.isUndefined(this._className)){e.ObjectType=this._className;var t=z._getPropertyValueWithoutCheckLoaded(this,x.idLowerCase);z.isUndefined(t)&&(t=z._getPropertyValueWithoutCheckLoaded(this,x.idPrivate)),z.isUndefined(t)&&(t=z._getPropertyValueWithoutCheckLoaded(this,x.previewExecutionObjectId)),e.ObjectId=t,this.context._pendingRequest.addPreviewExecutionAction(e)}},n.prototype._handleResult=function(e){this._isNull=z.isNullOrUndefined(e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},n.prototype._handleIdResult=function(e){this._isNull=z.isNullOrUndefined(e),z.fixObjectPathIfNecessary(this,e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},n.prototype._handleRetrieveResult=function(e,t){this._handleIdResult(e)},n.prototype._recursivelySet=function(e,t,r,i,c){var l=e instanceof n,d=e;if(l){if(Object.getPrototypeOf(this)!==Object.getPrototypeOf(e))throw o.RuntimeError._createInvalidArgError({argumentName:"properties",errorLocation:this._className+".set"});e=JSON.parse(JSON.stringify(e))}try{for(var f,p=0;p<r.length;p++)f=r[p],e.hasOwnProperty(f)&&void 0!==e[f]&&(this[f]=e[f]);for(p=0;p<i.length;p++)if(f=i[p],e.hasOwnProperty(f)&&void 0!==e[f]){var g=l?d[f]:e[f];this[f].set(g,t)}var h=!l;t&&!z.isNullOrUndefined(h)&&(h=t.throwOnReadOnly);for(p=0;p<c.length;p++)if(f=c[p],e.hasOwnProperty(f)&&void 0!==e[f]&&h)throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(G.cannotApplyPropertyThroughSetMethod,f),debugInfo:{errorLocation:f}});for(f in e)if(r.indexOf(f)<0&&i.indexOf(f)<0){var m=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(this),f);if(!m)throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(A.propertyDoesNotExist,f),debugInfo:{errorLocation:f}});if(h&&!m.set)throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(A.attemptingToSetReadOnlyProperty,f),debugInfo:{errorLocation:f}})}}catch(e){throw new o.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:u._getResourceString(s.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".set"},innerError:e})}},n}(p);e.ClientObject=T;var I=function(){function e(e){this.m_session=e}return e.prototype.executeAsync=function(e,t,n){var r={url:c.processQuery,method:"POST",headers:n.Headers,body:n.Body},o="";n.Headers&&(o=n.Headers[x.officeControlId]);var a={id:i.nextId(),type:1,flags:t,controlId:o,message:r};return u.log(JSON.stringify(a)),this.m_session.sendMessageToHost(a).then((function(e){u.log("Received response: "+JSON.stringify(e));var t,n=e.message;if(200===n.statusCode)t={HttpStatusCode:n.statusCode,ErrorCode:null,ErrorMessage:null,Headers:n.headers,Body:u._parseResponseBody(n)};else{u.log("Error Response:"+n.body);var r=u._parseErrorResponse(n);t={HttpStatusCode:n.statusCode,ErrorCode:r.errorCode,ErrorMessage:r.errorMessage,Headers:n.headers,Body:null}}return t}))},e}(),w=function(e){function t(t){var n=e.call(this)||this;return n.m_bridge=t,n.m_bridge.addHostMessageHandler((function(e){if(3===e.type){var t=e.controlId;if(u.isNullOrEmptyString(t))U.getGenericEventRegistration(t)._handleRichApiMessage(e.message);else{var n=U.peekGenericEventRegistrationOrNull(t);n&&n._handleRichApiMessage(e.message),(n=U.peekGenericEventRegistrationOrNull(""))&&n._handleRichApiMessage(e.message)}}})),n}return __extends(t,e),t.getInstanceIfHostBridgeInited=function(){return i.instance?((u.isNullOrUndefined(t.s_instance)||t.s_instance.m_bridge!==i.instance)&&(t.s_instance=new t(i.instance)),t.s_instance):null},t.prototype._resolveRequestUrlAndHeaderInfo=function(){return u._createPromiseFromResult(null)},t.prototype._createRequestExecutorOrNull=function(){return u.log("NativeBridgeSession::CreateRequestExecutor"),new I(this)},t.prototype.getEventRegistration=function(e){return U.getGenericEventRegistration(e)},t.prototype.sendMessageToHost=function(e){return this.m_bridge.sendMessageToHostAndExpectResponse(e)},t}(n);e.HostBridgeSession=w;var F=function(t){function r(e){var i=t.call(this)||this;if(i.m_customRequestHeaders={},i.m_batchMode=0,i._onRunFinishedNotifiers=[],n._overrideSession)i.m_requestUrlAndHeaderInfoResolver=n._overrideSession;else if((z.isNullOrUndefined(e)||"string"==typeof e&&0===e.length)&&((e=r.defaultRequestUrlAndHeaders)||(e={url:c.localDocument,headers:{}})),"string"==typeof e)i.m_requestUrlAndHeaderInfo={url:e,headers:{}};else if(r.isRequestUrlAndHeaderInfoResolver(e))i.m_requestUrlAndHeaderInfoResolver=e;else{if(!r.isRequestUrlAndHeaderInfo(e))throw o.RuntimeError._createInvalidArgError({argumentName:"url"});var a=e;i.m_requestUrlAndHeaderInfo={url:a.url,headers:{}},u._copyHeaders(a.headers,i.m_requestUrlAndHeaderInfo.headers)}return!i.m_requestUrlAndHeaderInfoResolver&&i.m_requestUrlAndHeaderInfo&&u._isLocalDocumentUrl(i.m_requestUrlAndHeaderInfo.url)&&w.getInstanceIfHostBridgeInited()&&(i.m_requestUrlAndHeaderInfo=null,i.m_requestUrlAndHeaderInfoResolver=w.getInstanceIfHostBridgeInited()),i.m_requestUrlAndHeaderInfoResolver instanceof n&&(i.m_session=i.m_requestUrlAndHeaderInfoResolver),i._processingResult=!1,i._customData=x.iterativeExecutor,i.sync=i.sync.bind(i),i}return __extends(r,t),Object.defineProperty(r.prototype,"session",{get:function(){return this.m_session},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"eventRegistration",{get:function(){return this.m_session?this.m_session.getEventRegistration(this._controlId):o.officeJsEventRegistration},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_url",{get:function(){return this.m_requestUrlAndHeaderInfo?this.m_requestUrlAndHeaderInfo.url:null},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_pendingRequest",{get:function(){return null==this.m_pendingRequest&&(this.m_pendingRequest=new k(this)),this.m_pendingRequest},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_controlId",{get:function(){var e=this.m_customRequestHeaders[x.officeControlId];return u.isNullOrUndefined(e)&&(e=""),e},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"debugInfo",{get:function(){return{pendingStatements:new q(this._rootObjectPropertyName,this._pendingRequest._objectPaths,this._pendingRequest._actions,e._internalConfig.showDisposeInfoInDebugInfo).process()}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"trackedObjects",{get:function(){return this.m_trackedObjects||(this.m_trackedObjects=new V(this)),this.m_trackedObjects},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"requestHeaders",{get:function(){return this.m_customRequestHeaders},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"batchMode",{get:function(){return this.m_batchMode},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"getAdditionalHeaders",{set:function(e){this.m_getAdditionalHeaders=e},enumerable:!0,configurable:!0}),r.prototype.ensureInProgressBatchIfBatchMode=function(){if(1===this.m_batchMode&&!this.m_explicitBatchInProgress)throw z.createRuntimeError(a.generalException,u._getResourceString(G.notInsideBatch),null)},r.prototype.load=function(e,t){z.validateContext(this,e);var n=r._parseQueryOption(t);f.createQueryAction(this,e,n,e)},r.prototype.loadRecursive=function(e,t,n){if(!z.isPlainJsonObject(t))throw o.RuntimeError._createInvalidArgError({argumentName:"options"});var i={};for(var a in t)i[a]=r._parseQueryOption(t[a]);var s=R.createRecursiveQueryAction(this,e,{Queries:i,MaxDepth:n});this._pendingRequest.addActionResultHandler(s,e)},r.prototype.trace=function(e){R.createTraceAction(this,e,!0)},r.prototype._processOfficeJsErrorResponse=function(e,t){},r.prototype.ensureRequestUrlAndHeaderInfo=function(){var e=this;return z._createPromiseFromResult(null).then((function(){if(!e.m_requestUrlAndHeaderInfo)return e.m_requestUrlAndHeaderInfoResolver._resolveRequestUrlAndHeaderInfo().then((function(t){if(e.m_requestUrlAndHeaderInfo=t,e.m_requestUrlAndHeaderInfo||(e.m_requestUrlAndHeaderInfo={url:c.localDocument,headers:{}}),z.isNullOrEmptyString(e.m_requestUrlAndHeaderInfo.url)&&(e.m_requestUrlAndHeaderInfo.url=c.localDocument),e.m_requestUrlAndHeaderInfo.headers||(e.m_requestUrlAndHeaderInfo.headers={}),"function"==typeof e.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull){var n=e.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull();n&&(e._requestExecutor=n)}}))}))},r.prototype.syncPrivateMain=function(){var e=this;return this.ensureRequestUrlAndHeaderInfo().then((function(){var t=e._pendingRequest;return e.m_pendingRequest=null,e.processPreSyncPromises(t).then((function(){return e.syncPrivate(t)}))}))},r.prototype.syncPrivate=function(t){var n=this;if(d.isMock())return u._createPromiseFromResult(null);if(!t.hasActions)return this.processPendingEventHandlers(t);var r=t.buildRequestMessageBodyAndRequestFlags(),i=r.body,a=r.flags;this._requestFlagModifier&&(a|=this._requestFlagModifier),this._requestExecutor||(u._isLocalDocumentUrl(this.m_requestUrlAndHeaderInfo.url)?this._requestExecutor=new W(this):this._requestExecutor=new _);var s=this._requestExecutor,l={};u._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,l),u._copyHeaders(this.m_customRequestHeaders,l),delete this.m_customRequestHeaders[x.officeScriptEventId],this.m_getAdditionalHeaders&&u._copyHeaders(this.m_getAdditionalHeaders(),l);var f=d._getCurrentTestNameWithSequenceId();f&&(l[c.testRequestNameHeader]=f);var p={Url:this.m_requestUrlAndHeaderInfo.url,Headers:l,Body:i};t.invalidatePendingInvalidObjectPaths();var g=null,h=null;return this._lastSyncStart="undefined"==typeof performance?Date.now():performance.now(),this._lastRequestFlags=a,s.executeAsync(this._customData,a,p).then((function(r){return n._lastSyncEnd="undefined"==typeof performance?Date.now():performance.now(),e.config.executePerfLogFunc&&e.config.executePerfLogFunc({syncStart:n._lastSyncStart,syncEnd:n._lastSyncEnd}),g=n.processRequestExecutorResponseMessage(t,r),n.processPendingEventHandlers(t).catch((function(e){u.log("Error in processPendingEventHandlers"),u.log(JSON.stringify(e)),h=e}))})).then((function(){if(g)throw u.log("Throw error from response: "+JSON.stringify(g)),g;if(h){u.log("Throw error from ProcessEventHandler: "+JSON.stringify(h));var e=null;if(h instanceof o.RuntimeError)(e=h).traceMessages=t._responseTraceMessages;else{var n=null;n="string"==typeof h?h:h.message,z.isNullOrEmptyString(n)&&(n=u._getResourceString(G.cannotRegisterEvent)),e=new o.RuntimeError({code:E.cannotRegisterEvent,httpStatusCode:400,message:n,traceMessages:t._responseTraceMessages})}throw e}}))},r.prototype.processRequestExecutorResponseMessage=function(t,n){n.Body&&n.Body.TraceIds&&t._setResponseTraceIds(n.Body.TraceIds);var r=t._responseTraceMessages,i=null;if(n.Body){if(n.Body.Error&&n.Body.Error.ActionIndex>=0){var a=new q(this._rootObjectPropertyName,t._objectPaths,t._actions,!1,!0),s=a.processForDebugStatementInfo(n.Body.Error.ActionIndex);i={statement:s.statement,surroundingStatements:s.surroundingStatements,fullStatements:["Please enable config.extendedErrorLogging to see full statements."]},e.config.extendedErrorLogging&&(a=new q(this._rootObjectPropertyName,t._objectPaths,t._actions,!1,!1),i.fullStatements=a.process())}var c=null;if(n.Body.Results?c=n.Body.Results:n.Body.ProcessedResults&&n.Body.ProcessedResults.Results&&(c=n.Body.ProcessedResults.Results),c){this._processingResult=!0;try{t.processResponse(c)}finally{this._processingResult=!1}}}if(!z.isNullOrEmptyString(n.ErrorCode))return new o.RuntimeError({code:n.ErrorCode,httpStatusCode:n.HttpStatusCode,message:n.ErrorMessage,traceMessages:r,data:{responseBody:n.RawErrorResponseBody}});if(n.Body&&n.Body.Error){var l={errorLocation:n.Body.Error.Location};return i&&(l.statement=i.statement,l.surroundingStatements=i.surroundingStatements,l.fullStatements=i.fullStatements),new o.RuntimeError({code:n.Body.Error.Code,httpStatusCode:n.Body.Error.HttpStatusCode,message:n.Body.Error.Message,traceMessages:r,debugInfo:l})}return null},r.prototype.processPendingEventHandlers=function(e){for(var t=z._createPromiseFromResult(null),n=0;n<e._pendingProcessEventHandlers.length;n++){var r=e._pendingProcessEventHandlers[n];t=t.then(this.createProcessOneEventHandlersFunc(r,e))}return t},r.prototype.createProcessOneEventHandlersFunc=function(e,t){return function(){return e._processRegistration(t)}},r.prototype.processPreSyncPromises=function(e){for(var t=z._createPromiseFromResult(null),n=0;n<e._preSyncPromises.length;n++){var r=e._preSyncPromises[n];t=t.then(this.createProcessOneProSyncFunc(r))}return t},r.prototype.createProcessOneProSyncFunc=function(e){return function(){return e}},r.prototype.sync=function(e){return d.isMock()?u._createPromiseFromResult(e):this.syncPrivateMain().then((function(){return e}))},r.prototype.batch=function(e){var t=this;if(1!==this.m_batchMode)return u._createPromiseFromException(z.createRuntimeError(a.generalException,null,null));if(this.m_explicitBatchInProgress)return u._createPromiseFromException(z.createRuntimeError(a.generalException,u._getResourceString(G.pendingBatchInProgress),null));if(z.isNullOrUndefined(e))return z._createPromiseFromResult(null);this.m_explicitBatchInProgress=!0;var n,r,o,i=this.m_pendingRequest;this.m_pendingRequest=new k(this);try{n=e(this._rootObject,this)}catch(e){return this.m_explicitBatchInProgress=!1,this.m_pendingRequest=i,u._createPromiseFromException(e)}return"object"==typeof n&&n&&"function"==typeof n.then?o=z._createPromiseFromResult(null).then((function(){return n})).then((function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=i,e})).catch((function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=i,u._createPromiseFromException(e)})):(this.m_explicitBatchInProgress=!1,r=this.m_pendingRequest,this.m_pendingRequest=i,o=z._createPromiseFromResult(n)),o.then((function(e){return t.ensureRequestUrlAndHeaderInfo().then((function(){return t.syncPrivate(r)})).then((function(){return e}))}))},r._run=function(e,t,n,o,i,a){return void 0===n&&(n=3),void 0===o&&(o=5e3),r._runCommon("run",null,e,0,t,n,o,null,i,a)},r.isValidRequestInfo=function(e){return"string"==typeof e||r.isRequestUrlAndHeaderInfo(e)||r.isRequestUrlAndHeaderInfoResolver(e)},r.isRequestUrlAndHeaderInfo=function(e){return"object"==typeof e&&null!==e&&Object.getPrototypeOf(e)===Object.getPrototypeOf({})&&!z.isNullOrUndefined(e.url)},r.isRequestUrlAndHeaderInfoResolver=function(e){return"object"==typeof e&&null!==e&&"function"==typeof e._resolveRequestUrlAndHeaderInfo},r._runBatch=function(e,t,n,o,i,a,s,c){return void 0===i&&(i=3),void 0===a&&(a=5e3),r._runBatchCommon(0,e,t,n,i,a,o,s,c)},r._runExplicitBatch=function(e,t,n,o,i,a,s,c){return void 0===i&&(i=3),void 0===a&&(a=5e3),r._runBatchCommon(1,e,t,n,i,a,o,s,c)},r._runBatchCommon=function(e,t,n,o,i,a,s,c,l){var u,d;void 0===i&&(i=3),void 0===a&&(a=5e3);var f=null,p=null,g=null,h=0,m=null;if(n.length>0)if(r.isValidRequestInfo(n[0]))f=n[0],h=1;else if(z.isPlainJsonObject(n[0])){if(null!=(f=(m=n[0]).session)&&!r.isValidRequestInfo(f))return r.createErrorPromise(t);p=m.getAdditionalHeaders,g=m.previousObjects,h=1}if(n.length==h+1)d=n[h+0];else{if(null!=m||n.length!=h+2)return r.createErrorPromise(t);g=n[h+0],d=n[h+1]}if(null!=g)if(g instanceof T)u=function(){return g.context};else if(g instanceof r)u=function(){return g};else{if(!Array.isArray(g))return r.createErrorPromise(t);var y=g;if(0==y.length)return r.createErrorPromise(t);for(var v=0;v<y.length;v++){if(!(y[v]instanceof T))return r.createErrorPromise(t);if(y[v].context!=y[0].context)return r.createErrorPromise(t,G.invalidRequestContext)}u=function(){return y[0].context}}else u=o;var b=null;return s&&(b=function(e){return s(m||{},e)}),r._runCommon(t,f,u,e,d,i,a,b,c,l,p)},r.createErrorPromise=function(e,t){return void 0===t&&(t=s.invalidArgument),u._createPromiseFromException(z.createRuntimeError(t,u._getResourceString(t),e))},r._runCommon=function(t,o,i,a,s,c,l,d,f,p,g){n._overrideSession&&(o=n._overrideSession);var h,m,y,v=u.createPromise((function(e,t){e()})),b=!1;return v.then((function(){if((h=i(o)).getAdditionalHeaders=g,h._autoCleanup)return new e.Promise((function(e,t){h._onRunFinishedNotifiers.push((function(){h._autoCleanup=!0,e()}))}));h._autoCleanup=!0})).then((function(){return"function"!=typeof s?r.createErrorPromise(t):(y=h.m_batchMode,h.m_batchMode=a,d&&d(h),e=s(1==a?h.batch.bind(h):h),(z.isNullOrUndefined(e)||"function"!=typeof e.then)&&z.throwError(G.runMustReturnPromise),e);var e})).then((function(e){return 1===a?e:h.sync(e)})).then((function(e){b=!0,m=e})).catch((function(e){m=e})).then((function(){var e=h.trackedObjects._retrieveAndClearAutoCleanupList();for(var t in h._autoCleanup=!1,h.m_batchMode=y,e)e[t]._objectPath.isValid=!1;var n=0;if(z._synchronousCleanup||r.isRequestUrlAndHeaderInfoResolver(o))return i();function i(){n++;var t=h.m_pendingRequest,r=h.m_batchMode,o=new k(h);h.m_pendingRequest=o,h.m_batchMode=0;try{for(var a in e)h.trackedObjects.remove(e[a])}finally{h.m_batchMode=r,h.m_pendingRequest=t}return h.syncPrivate(o).then((function(){f&&f(n)})).catch((function(){p&&p(n),n<c&&setTimeout((function(){i()}),l)}))}i()})).then((function(){h._onRunFinishedNotifiers&&h._onRunFinishedNotifiers.length>0&&h._onRunFinishedNotifiers.shift()();if(b)return m;throw m}))},r}(m);e.ClientRequestContext=F;var D=function(){function e(e,t){this.m_proxy=e,this.m_shouldPolyfill=t;var n=e[x.scalarPropertyNames],r=e[x.navigationPropertyNames],o=e[x.className],i=e[x.isCollection];if(n)for(var a=0;a<n.length;a++)z.definePropertyThrowUnloadedException(this,o,n[a]);if(r)for(a=0;a<r.length;a++)z.definePropertyThrowUnloadedException(this,o,r[a]);i&&z.definePropertyThrowUnloadedException(this,o,x.itemsLowerCase)}return Object.defineProperty(e.prototype,"$proxy",{get:function(){return this.m_proxy},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"$isNullObject",{get:function(){if(!this.m_isLoaded)throw new o.RuntimeError({code:E.valueNotLoaded,httpStatusCode:400,message:u._getResourceString(G.valueNotLoaded),debugInfo:{errorLocation:"retrieveResult.$isNullObject"}});return this.m_isNullObject},enumerable:!0,configurable:!0}),e.prototype.toJSON=function(){if(this.m_isLoaded)return this.m_isNullObject?null:(z.isUndefined(this.m_json)&&(this.m_json=z.purifyJson(this.m_value)),this.m_json)},e.prototype.toString=function(){return JSON.stringify(this.toJSON())},e.prototype._handleResult=function(e){this.m_isLoaded=!0,null===e||"object"==typeof e&&e&&e._IsNull?(this.m_isNullObject=!0,e=null):this.m_isNullObject=!1,this.m_shouldPolyfill&&(e=z.changePropertyNameToCamelLowerCase(e)),this.m_value=e,this.m_proxy._handleRetrieveResult(e,this)},e}(),x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.getItemAt="GetItemAt",t.index="_Index",t.iterativeExecutor="IterativeExecutor",t.isTracked="_IsTracked",t.eventMessageCategory=65536,t.eventWorkbookId="Workbook",t.eventSourceRemote="Remote",t.proxy="$proxy",t.className="_className",t.isCollection="_isCollection",t.collectionPropertyPath="_collectionPropertyPath",t.objectPathInfoDoNotKeepReferenceFieldName="D",t.officeScriptEventId="X-OfficeScriptEventId",t.officeScriptFireRecordingEvent="X-OfficeScriptFireRecordingEvent",t.officeControlId="X-OfficeControlId",t}(O);e.Constants=x;var k=function(e){function t(t){var n=e.call(this,t)||this;return n.m_context=t,n.m_pendingProcessEventHandlers=[],n.m_pendingEventHandlerActions={},n.m_traceInfos={},n.m_responseTraceIds={},n.m_responseTraceMessages=[],n}return __extends(t,e),Object.defineProperty(t.prototype,"traceInfos",{get:function(){return this.m_traceInfos},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_responseTraceMessages",{get:function(){return this.m_responseTraceMessages},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_responseTraceIds",{get:function(){return this.m_responseTraceIds},enumerable:!0,configurable:!0}),t.prototype._setResponseTraceIds=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t];this.m_responseTraceIds[n]=n;var r=this.m_traceInfos[n];u.isNullOrUndefined(r)||this.m_responseTraceMessages.push(r)}},t.prototype.addTrace=function(e,t){this.m_traceInfos[e]=t},t.prototype._addPendingEventHandlerAction=function(e,t){this.m_pendingEventHandlerActions[e._id]||(this.m_pendingEventHandlerActions[e._id]=[],this.m_pendingProcessEventHandlers.push(e)),this.m_pendingEventHandlerActions[e._id].push(t)},Object.defineProperty(t.prototype,"_pendingProcessEventHandlers",{get:function(){return this.m_pendingProcessEventHandlers},enumerable:!0,configurable:!0}),t.prototype._getPendingEventHandlerActions=function(e){return this.m_pendingEventHandlerActions[e._id]},t}(v);e.ClientRequest=k;var N=function(){function e(e,t,n,r){var o=this;this.m_id=e._nextId(),this.m_context=e,this.m_name=n,this.m_handlers=[],this.m_registered=!1,this.m_eventInfo=r,this.m_callback=function(e){o.m_eventInfo.eventArgsTransformFunc(e).then((function(e){return o.fireEvent(e)}))}}return Object.defineProperty(e.prototype,"_registered",{get:function(){return this.m_registered},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_handlers",{get:function(){return this.m_handlers},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_callback",{get:function(){return this.m_callback},enumerable:!0,configurable:!0}),e.prototype.add=function(e){var t=R.createTraceAction(this.m_context,null,!1);return this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:0}),new M(this.m_context,this,e)},e.prototype.remove=function(e){var t=R.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:1})},e.prototype.removeAll=function(){var e=R.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:e.actionInfo.Id,handler:null,operation:2})},e.prototype._processRegistration=function(e){var t=this,n=u._createPromiseFromResult(null),r=e._getPendingEventHandlerActions(this);if(!r)return n;for(var o=[],i=0;i<this.m_handlers.length;i++)o.push(this.m_handlers[i]);var a=!1;for(i=0;i<r.length;i++)if(e._responseTraceIds[r[i].id])switch(a=!0,r[i].operation){case 0:o.push(r[i].handler);break;case 1:for(var s=o.length-1;s>=0;s--)if(o[s]===r[i].handler){o.splice(s,1);break}break;case 2:o=[]}return a&&(!this.m_registered&&o.length>0?n=n.then((function(){return t.m_eventInfo.registerFunc(t.m_callback)})).then((function(){return t.m_registered=!0})):this.m_registered&&0==o.length&&(n=n.then((function(){return t.m_eventInfo.unregisterFunc(t.m_callback)})).catch((function(e){u.log("Error when unregister event: "+JSON.stringify(e))})).then((function(){return t.m_registered=!1}))),n=n.then((function(){return t.m_handlers=o}))),n},e.prototype.fireEvent=function(e){for(var t=[],n=0;n<this.m_handlers.length;n++){var r=this.m_handlers[n],o=u._createPromiseFromResult(null).then(this.createFireOneEventHandlerFunc(r,e)).catch((function(e){u.log("Error when invoke handler: "+JSON.stringify(e))}));t.push(o)}u.Promise.all(t)},e.prototype.createFireOneEventHandlerFunc=function(e,t){return function(){return e(t)}},e}();e.EventHandlers=N;var M=function(){function e(e,t,n){this.m_context=e,this.m_allHandlers=t,this.m_handler=n}return Object.defineProperty(e.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),e.prototype.remove=function(){this.m_allHandlers&&this.m_handler&&(this.m_allHandlers.remove(this.m_handler),this.m_allHandlers=null,this.m_handler=null)},e}();e.EventHandlerResult=M,function(e){var t=function(){function t(){}return t.prototype.register=function(t,n,r){switch(t){case 4:return z.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return z.promisify((function(t){return e.addHandlerAsync(Office.EventType.BindingDataChanged,r,t)}))}));case 3:return z.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return z.promisify((function(t){return e.addHandlerAsync(Office.EventType.BindingSelectionChanged,r,t)}))}));case 2:return z.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.DocumentSelectionChanged,r,e)}));case 1:return z.promisify((function(e){return Office.context.document.settings.addHandlerAsync(Office.EventType.SettingsChanged,r,e)}));case 5:return OSF.DDA.RichApi.richApiMessageManager.register(r);case 13:return z.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDeleted,r,{id:n},e)}));case 14:return z.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectSelectionChanged,r,{id:n},e)}));case 15:return z.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDataChanged,r,{id:n},e)}));case 16:return z.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ContentControlAdded,r,{id:n},e)}));default:throw e.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},t.prototype.unregister=function(t,n,r){switch(t){case 4:return z.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return z.promisify((function(t){return e.removeHandlerAsync(Office.EventType.BindingDataChanged,{handler:r},t)}))}));case 3:return z.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return z.promisify((function(t){return e.removeHandlerAsync(Office.EventType.BindingSelectionChanged,{handler:r},t)}))}));case 2:return z.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.DocumentSelectionChanged,{handler:r},e)}));case 1:return z.promisify((function(e){return Office.context.document.settings.removeHandlerAsync(Office.EventType.SettingsChanged,{handler:r},e)}));case 5:return z.promisify((function(e){return OSF.DDA.RichApi.richApiMessageManager.removeHandlerAsync("richApiMessage",{handler:r},e)}));case 13:return z.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDeleted,{id:n,handler:r},e)}));case 14:return z.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectSelectionChanged,{id:n,handler:r},e)}));case 15:return z.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDataChanged,{id:n,handler:r},e)}));case 16:return z.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ContentControlAdded,{id:n,handler:r},e)}));default:throw e.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},t}();e.officeJsEventRegistration=new t}(o=e._Internal||(e._Internal={}));var H=function(){function e(e,t){this.m_handlersByEventByTarget={},this.m_registerEventImpl=e,this.m_unregisterEventImpl=t}return e.getTargetIdOrDefault=function(e){return z.isNullOrUndefined(e)?"":e},e.prototype.getHandlers=function(t,n){n=e.getTargetIdOrDefault(n);var r=this.m_handlersByEventByTarget[t];r||(r={},this.m_handlersByEventByTarget[t]=r);var o=r[n];return o||(o=[],r[n]=o),o},e.prototype.callHandlers=function(e,t,n){for(var r=this.getHandlers(e,t),o=0;o<r.length;o++)r[o](n)},e.prototype.hasHandlers=function(e,t){return this.getHandlers(e,t).length>0},e.prototype.register=function(e,t,n){if(!n)throw o.RuntimeError._createInvalidArgError({argumentName:"handler"});var r=this.getHandlers(e,t);return r.push(n),1===r.length?this.m_registerEventImpl(e,t):z._createPromiseFromResult(null)},e.prototype.unregister=function(e,t,n){if(!n)throw o.RuntimeError._createInvalidArgError({argumentName:"handler"});for(var r=this.getHandlers(e,t),i=r.length-1;i>=0;i--)if(r[i]===n){r.splice(i,1);break}return 0===r.length?this.m_unregisterEventImpl(e,t):z._createPromiseFromResult(null)},e}();e.EventRegistration=H;var U=function(){function e(){this.m_eventRegistration=new H(this._registerEventImpl.bind(this),this._unregisterEventImpl.bind(this)),this.m_richApiMessageHandler=this._handleRichApiMessage.bind(this)}return e.prototype.ready=function(){var t=this;return this.m_ready||(e._testReadyImpl?this.m_ready=e._testReadyImpl().then((function(){t.m_isReady=!0})):i.instance?this.m_ready=z._createPromiseFromResult(null).then((function(){t.m_isReady=!0})):this.m_ready=o.officeJsEventRegistration.register(5,"",this.m_richApiMessageHandler).then((function(){t.m_isReady=!0}))),this.m_ready},Object.defineProperty(e.prototype,"isReady",{get:function(){return this.m_isReady},enumerable:!0,configurable:!0}),e.prototype.register=function(e,t,n){var r=this;return this.ready().then((function(){return r.m_eventRegistration.register(e,t,n)}))},e.prototype.unregister=function(e,t,n){var r=this;return this.ready().then((function(){return r.m_eventRegistration.unregister(e,t,n)}))},e.prototype._registerEventImpl=function(e,t){return z._createPromiseFromResult(null)},e.prototype._unregisterEventImpl=function(e,t){return z._createPromiseFromResult(null)},e.prototype._handleRichApiMessage=function(e){if(e&&e.entries)for(var t=0;t<e.entries.length;t++){var n=e.entries[t];if(n.messageCategory==x.eventMessageCategory){u._logEnabled&&u.log(JSON.stringify(n));var r=n.messageType,o=n.targetId;if(this.m_eventRegistration.hasHandlers(r,o)){var i=JSON.parse(n.message);n.isRemoteOverride&&(i.source=x.eventSourceRemote),this.m_eventRegistration.callHandlers(r,o,i)}}}},e.getGenericEventRegistration=function(t){u.isNullOrUndefined(t)&&(t="");var n=e.s_genericEventRegistrations[t];return n||(n=new e,e.s_genericEventRegistrations[t]=n),n},e.peekGenericEventRegistrationOrNull=function(t){return u.isNullOrUndefined(t)&&(t=""),e.s_genericEventRegistrations[t]},e.richApiMessageEventCategory=65536,e.s_genericEventRegistrations={},e}();e.GenericEventRegistration=U,e._testSetRichApiMessageReadyImpl=function(e){U._testReadyImpl=e},e._testTriggerRichApiMessageEvent=function(e){U.getGenericEventRegistration("")._handleRichApiMessage(e)};var j=function(e){function t(t,n,r,o){var i=e.call(this,t,n,r,o)||this;return i.m_genericEventInfo=o,i}return __extends(t,e),t.prototype.add=function(e){var t=this;0==this._handlers.length&&this.m_genericEventInfo.registerFunc&&this.m_genericEventInfo.registerFunc();var n=this._context._controlId;return U.getGenericEventRegistration(n).isReady||this._context._pendingRequest._addPreSyncPromise(U.getGenericEventRegistration(n).ready()),R.createTraceMarkerForCallback(this._context,(function(){t._handlers.push(e),1==t._handlers.length&&U.getGenericEventRegistration(n).register(t.m_genericEventInfo.eventType,t.m_genericEventInfo.getTargetIdFunc(),t._callback)})),new M(this._context,this,e)},t.prototype.remove=function(e){var t=this;1==this._handlers.length&&this.m_genericEventInfo.unregisterFunc&&this.m_genericEventInfo.unregisterFunc();var n=this._context._controlId;R.createTraceMarkerForCallback(this._context,(function(){for(var r=t._handlers,o=r.length-1;o>=0;o--)if(r[o]===e){r.splice(o,1);break}0==r.length&&U.getGenericEventRegistration(n).unregister(t.m_genericEventInfo.eventType,t.m_genericEventInfo.getTargetIdFunc(),t._callback)}))},t.prototype.removeAll=function(){},t}(N);e.GenericEventHandlers=j;var L=function(){function e(e){this.m_clientObject=e}return e.prototype._handleResult=function(e){this.m_clientObject._handleIdResult(e)},e}(),B=function(){function e(){}return e.createGlobalObjectObjectPath=function(e){var t={Id:e._nextId(),ObjectPathType:1,Name:""};return new h(t,null,!1,!1,1,4)},e.createNewObjectObjectPath=function(e,t,n,r){var o={Id:e._nextId(),ObjectPathType:2,Name:t};return new h(o,null,n,!1,1,z._fixupApiFlags(r))},e.createPropertyObjectPath=function(e,t,n,r,o,i){var a={Id:e._nextId(),ObjectPathType:4,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id};return new h(a,t._objectPath,r,o,1,z._fixupApiFlags(i))},e.createIndexerObjectPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new h(r,t._objectPath,!1,!1,1,4)},e.createIndexerObjectPathUsingParentPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new h(r,t,!1,!1,1,4)},e.createMethodObjectPath=function(e,t,n,r,o,i,a,s,c){var l={Id:e._nextId(),ObjectPathType:3,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}},u=z.setMethodArguments(e,l.ArgumentInfo,o),d=new h(l,t._objectPath,i,a,r,z._fixupApiFlags(c));return d.argumentObjectPaths=u,d.getByIdMethodName=s,d},e.createReferenceIdObjectPath=function(e,t){var n={Id:e._nextId(),ObjectPathType:6,Name:t,ArgumentInfo:{}};return new h(n,null,!1,!1,1,4)},e.createChildItemObjectPathUsingIndexerOrGetItemAt=function(t,n,r,o,i){var a=z.tryGetObjectIdFromLoadOrRetrieveResult(o);return t&&!z.isNullOrUndefined(a)?e.createChildItemObjectPathUsingIndexer(n,r,o):e.createChildItemObjectPathUsingGetItemAt(n,r,o,i)},e.createChildItemObjectPathUsingIndexer=function(e,t,n){var r=z.tryGetObjectIdFromLoadOrRetrieveResult(n),o=o={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return o.ArgumentInfo.Arguments=[r],new h(o,t._objectPath,!1,!1,1,4)},e.createChildItemObjectPathUsingGetItemAt=function(e,t,n,r){var o=n[x.index];o&&(r=o);var i={Id:e._nextId(),ObjectPathType:3,Name:x.getItemAt,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return i.ArgumentInfo.Arguments=[r],new h(i,t._objectPath,!1,!1,1,4)},e}();e.ObjectPathFactory=B;var W=function(){function t(e){this.m_context=e}return t.prototype.executeAsync=function(n,r,o){var i=this,a=l.buildMessageArrayForIRequestExecutor(n,r,o,t.SourceLibHeaderValue);return new e.Promise((function(e,t){OSF.DDA.RichApi.executeRichApiRequestAsync(a,(function(t){var n;u.log("Response:"),u.log(JSON.stringify(t)),"succeeded"==t.status?n=l.buildResponseOnSuccess(l.getResponseBody(t),l.getResponseHeaders(t)):(n=l.buildResponseOnError(t.error.code,t.error.message),i.m_context._processOfficeJsErrorResponse(t.error.code,n)),e(n)}))}))},t.SourceLibHeaderValue="officejs",t}(),V=function(){function e(e){this._autoCleanupList={},this.m_context=e}return e.prototype.add=function(e){var t=this;Array.isArray(e)?e.forEach((function(e){return t._addCommon(e,!0)})):this._addCommon(e,!0)},e.prototype._autoAdd=function(e){this._addCommon(e,!1),this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e},e.prototype._autoTrackIfNecessaryWhenHandleObjectResultValue=function(e,t){this.m_context._autoCleanup&&!e[x.isTracked]&&e!==this.m_context._rootObject&&t&&!z.isNullOrEmptyString(t[x.referenceId])&&(this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e,e[x.isTracked]=!0)},e.prototype._addCommon=function(e,t){if(e[x.isTracked])t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id];else{var n=e[x.referenceId];if(e._objectPath.objectPathInfo[x.objectPathInfoDoNotKeepReferenceFieldName])throw z.createRuntimeError(a.generalException,u._getResourceString(G.objectIsUntracked),null);z.isNullOrEmptyString(n)&&e._KeepReference&&(e._KeepReference(),R.createInstantiateAction(this.m_context,e),t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id],e[x.isTracked]=!0)}},e.prototype.remove=function(e){var t=this;Array.isArray(e)?e.forEach((function(e){return t._removeCommon(e)})):this._removeCommon(e)},e.prototype._removeCommon=function(e){e._objectPath.objectPathInfo[x.objectPathInfoDoNotKeepReferenceFieldName]=!0,e.context._pendingRequest._removeKeepReferenceAction(e._objectPath.objectPathInfo.Id);var t=e[x.referenceId];if(!z.isNullOrEmptyString(t)){var n=this.m_context._rootObject;n._RemoveReference&&n._RemoveReference(t)}delete e[x.isTracked]},e.prototype._retrieveAndClearAutoCleanupList=function(){var e=this._autoCleanupList;return this._autoCleanupList={},e},e}();e.TrackedObjects=V;var q=function(){function t(e,t,n,r,o){e||(e="root"),this.m_globalObjName=e,this.m_referencedObjectPaths=t,this.m_actions=n,this.m_statements=[],this.m_variableNameForObjectPathMap={},this.m_variableNameToObjectPathMap={},this.m_declaredObjectPathMap={},this.m_showDispose=r,this.m_removePII=o}return t.prototype.process=function(){this.m_showDispose&&k._calculateLastUsedObjectPathIds(this.m_actions);for(var e=0;e<this.m_actions.length;e++)this.processOneAction(this.m_actions[e]);return this.m_statements},t.prototype.processForDebugStatementInfo=function(e){this.m_showDispose&&k._calculateLastUsedObjectPathIds(this.m_actions);this.m_statements=[];for(var t=-1,n=0;n<this.m_actions.length&&(this.processOneAction(this.m_actions[n]),e==n&&(t=this.m_statements.length-1),!(t>=0&&this.m_statements.length>t+5+1));n++);if(t<0)return null;var r=t-5;r<0&&(r=0);var o=t+1+5;o>this.m_statements.length&&(o=this.m_statements.length);var i=[];0!=r&&i.push("...");for(var a=r;a<t;a++)i.push(this.m_statements[a]);i.push("// >>>>>"),i.push(this.m_statements[t]),i.push("// <<<<<");for(var s=t+1;s<o;s++)i.push(this.m_statements[s]);return o<this.m_statements.length&&i.push("..."),{statement:this.m_statements[t],surroundingStatements:i}},t.prototype.processOneAction=function(e){switch(e.actionInfo.ActionType){case 1:this.processInstantiateAction(e);break;case 3:this.processMethodAction(e);break;case 2:this.processQueryAction(e);break;case 7:this.processQueryAsJsonAction(e);break;case 6:this.processRecursiveQueryAction(e);break;case 4:this.processSetPropertyAction(e);break;case 5:this.processTraceAction(e);break;case 8:this.processEnsureUnchangedAction(e);break;case 9:this.processUpdateAction(e)}},t.prototype.processInstantiateAction=function(e){var t=e.actionInfo.ObjectPathId,n=this.m_referencedObjectPaths[t],r=this.getObjVarName(t);if(this.m_declaredObjectPathMap[t]){o="// Instantiate {"+r+"}";o=this.appendDisposeCommentIfRelevant(o,e),this.m_statements.push(o)}else{var o="var "+r+" = "+this.buildObjectPathExpressionWithParent(n)+";";o=this.appendDisposeCommentIfRelevant(o,e),this.m_statements.push(o),this.m_declaredObjectPathMap[t]=r}},t.prototype.processMethodAction=function(t){var n=t.actionInfo.Name;if("_KeepReference"===n){if(!e._internalConfig.showInternalApiInDebugInfo)return;n="track"}var r=this.getObjVarName(t.actionInfo.ObjectPathId)+"."+z._toCamelLowerCase(n)+"("+this.buildArgumentsExpression(t.actionInfo.ArgumentInfo)+");";r=this.appendDisposeCommentIfRelevant(r,t),this.m_statements.push(r)},t.prototype.processQueryAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".load("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processQueryAsJsonAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".retrieve("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processRecursiveQueryAction=function(e){var t="";e.actionInfo.RecursiveQueryInfo&&(t=JSON.stringify(e.actionInfo.RecursiveQueryInfo));var n=this.getObjVarName(e.actionInfo.ObjectPathId)+".loadRecursive("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processSetPropertyAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+"."+z._toCamelLowerCase(e.actionInfo.Name)+" = "+this.buildArgumentsExpression(e.actionInfo.ArgumentInfo)+";";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processTraceAction=function(e){var t="context.trace();";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processEnsureUnchangedAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".ensureUnchanged("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processUpdateAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".update("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.appendDisposeCommentIfRelevant=function(e,t){var n=this;if(this.m_showDispose){var r=t.actionInfo.L;if(r&&r.length>0)return e+" // And then dispose {"+r.map((function(e){return n.getObjVarName(e)})).join(", ")+"}"}return e},t.prototype.buildQueryExpression=function(e){if(e.actionInfo.QueryInfo){var t={};return t.select=e.actionInfo.QueryInfo.Select,t.expand=e.actionInfo.QueryInfo.Expand,t.skip=e.actionInfo.QueryInfo.Skip,t.top=e.actionInfo.QueryInfo.Top,void 0===t.top&&void 0===t.skip&&void 0===t.expand?void 0===t.select?"":JSON.stringify(t.select):JSON.stringify(t)}return""},t.prototype.buildObjectPathExpressionWithParent=function(e){return(5==e.objectPathInfo.ObjectPathType||3==e.objectPathInfo.ObjectPathType||4==e.objectPathInfo.ObjectPathType)&&e.objectPathInfo.ParentObjectPathId?this.getObjVarName(e.objectPathInfo.ParentObjectPathId)+"."+this.buildObjectPathExpression(e):this.buildObjectPathExpression(e)},t.prototype.buildObjectPathExpression=function(e){var t=this.buildObjectPathInfoExpression(e.objectPathInfo),n=e.originalObjectPathInfo;return n&&(t=t+" /* originally "+this.buildObjectPathInfoExpression(n)+" */"),t},t.prototype.buildObjectPathInfoExpression=function(e){switch(e.ObjectPathType){case 1:return"context."+this.m_globalObjName;case 5:return"getItem("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 3:return z._toCamelLowerCase(e.Name)+"("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 2:return e.Name+".newObject()";case 7:return"null";case 4:return z._toCamelLowerCase(e.Name);case 6:return"context."+this.m_globalObjName+"._getObjectByReferenceId("+JSON.stringify(e.Name)+")"}},t.prototype.buildArgumentsExpression=function(e){var t="";if(!e.Arguments||0===e.Arguments.length)return t;if(this.m_removePII)return void 0===e.Arguments[0]?t:"...";for(var n=0;n<e.Arguments.length;n++)n>0&&(t+=", "),t+=this.buildArgumentLiteral(e.Arguments[n],e.ReferencedObjectPathIds?e.ReferencedObjectPathIds[n]:null);return"undefined"===t&&(t=""),t},t.prototype.buildArgumentLiteral=function(e,t){return"number"==typeof e&&e===t?this.getObjVarName(t):JSON.stringify(e)},t.prototype.getObjVarNameBase=function(e){var t="v",n=this.m_referencedObjectPaths[e];if(n)switch(n.objectPathInfo.ObjectPathType){case 1:t=this.m_globalObjName;break;case 4:t=z._toCamelLowerCase(n.objectPathInfo.Name);break;case 3:var r=n.objectPathInfo.Name;r.length>3&&"Get"===r.substr(0,3)&&(r=r.substr(3)),t=z._toCamelLowerCase(r);break;case 5:var o=this.getObjVarNameBase(n.objectPathInfo.ParentObjectPathId);t="s"===o.charAt(o.length-1)?o.substr(0,o.length-1):o+"Item"}return t},t.prototype.getObjVarName=function(e){if(this.m_variableNameForObjectPathMap[e])return this.m_variableNameForObjectPathMap[e];var t=this.getObjVarNameBase(e);if(!this.m_variableNameToObjectPathMap[t])return this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t;for(var n=1;this.m_variableNameToObjectPathMap[t+n.toString()];)n++;return t+=n.toString(),this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t},t}(),G=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.cannotRegisterEvent="CannotRegisterEvent",t.connectionFailureWithStatus="ConnectionFailureWithStatus",t.connectionFailureWithDetails="ConnectionFailureWithDetails",t.propertyNotLoaded="PropertyNotLoaded",t.runMustReturnPromise="RunMustReturnPromise",t.moreInfoInnerError="MoreInfoInnerError",t.cannotApplyPropertyThroughSetMethod="CannotApplyPropertyThroughSetMethod",t.invalidOperationInCellEditMode="InvalidOperationInCellEditMode",t.objectIsUntracked="ObjectIsUntracked",t.customFunctionDefintionMissing="CustomFunctionDefintionMissing",t.customFunctionImplementationMissing="CustomFunctionImplementationMissing",t.customFunctionNameContainsBadChars="CustomFunctionNameContainsBadChars",t.customFunctionNameCannotSplit="CustomFunctionNameCannotSplit",t.customFunctionUnexpectedNumberOfEntriesInResultBatch="CustomFunctionUnexpectedNumberOfEntriesInResultBatch",t.customFunctionCancellationHandlerMissing="CustomFunctionCancellationHandlerMissing",t.customFunctionInvalidFunction="CustomFunctionInvalidFunction",t.customFunctionInvalidFunctionMapping="CustomFunctionInvalidFunctionMapping",t.customFunctionWindowMissing="CustomFunctionWindowMissing",t.customFunctionDefintionMissingOnWindow="CustomFunctionDefintionMissingOnWindow",t.pendingBatchInProgress="PendingBatchInProgress",t.notInsideBatch="NotInsideBatch",t.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",t}(A);e.ResourceStrings=G,u.addResourceStringValues({CannotRegisterEvent:"The event handler cannot be registered.",PropertyNotLoaded:"The property '{0}' is not available. Before reading the property's value, call the load method on the containing object and call \"context.sync()\" on the associated request context.",RunMustReturnPromise:'The batch function passed to the ".run" method didn\'t return a promise. The function must return a promise, so that any automatically-tracked objects can be released at the completion of the batch operation. Typically, you return a promise by returning the response from "context.sync()".',InvalidOrTimedOutSessionMessage:"Your Office Online session has expired or is invalid. To continue, refresh the page.",InvalidOperationInCellEditMode:"Excel is in cell-editing mode. Please exit the edit mode by pressing ENTER or TAB or selecting another cell, and then try again.",InvalidSheetName:"The request cannot be processed because the specified worksheet cannot be found. Please try again.",CustomFunctionDefintionMissing:"A property with the name '{0}' that represents the function's definition must exist on Excel.Script.CustomFunctions.",CustomFunctionDefintionMissingOnWindow:"A property with the name '{0}' that represents the function's definition must exist on the window object.",CustomFunctionImplementationMissing:"The property with the name '{0}' on Excel.Script.CustomFunctions that represents the function's definition must contain a 'call' property that implements the function.",CustomFunctionNameContainsBadChars:"The function name may only contain letters, digits, underscores, and periods.",CustomFunctionNameCannotSplit:"The function name must contain a non-empty namespace and a non-empty short name.",CustomFunctionUnexpectedNumberOfEntriesInResultBatch:"The batching function returned a number of results that doesn't match the number of parameter value sets that were passed into it.",CustomFunctionCancellationHandlerMissing:"The cancellation handler onCanceled is missing in the function. The handler must be present as the function is defined as cancelable.",CustomFunctionInvalidFunction:"The property with the name '{0}' that represents the function's definition is not a valid function.",CustomFunctionInvalidFunctionMapping:"The property with the name '{0}' on CustomFunctionMappings that represents the function's definition is not a valid function.",CustomFunctionWindowMissing:"The window object was not found.",PendingBatchInProgress:"There is a pending batch in progress. The batch method may not be called inside another batch, or simultaneously with another batch.",NotInsideBatch:"Operations may not be invoked outside of a batch method.",CannotUpdateReadOnlyProperty:"The property '{0}' is read-only and it cannot be updated.",ObjectIsUntracked:"The object is untracked."});var z=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.fixObjectPathIfNecessary=function(e,t){e&&e._objectPath&&t&&e._objectPath.updateUsingObjectData(t,e)},n.load=function(e,t){return e.context.load(e,t),e},n.loadAndSync=function(e,t){return e.context.load(e,t),e.context.sync().then((function(){return e}))},n.retrieve=function(t,r){var o=e._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;o||(o=!n.isSetSupported("RichApiRuntime","1.1"));var i=new D(t,o);return t._retrieve(r,i),i},n.retrieveAndSync=function(e,t){var r=n.retrieve(e,t);return e.context.sync().then((function(){return r}))},n.toJson=function(e,t,r,o){var i={};for(var a in t){void 0!==(s=t[a])&&(i[a]=s)}for(var a in r){var s;void 0!==(s=r[a])&&(s[n.fieldName_isCollection]&&void 0!==s[n.fieldName_m__items]?i[a]=s.toJSON().items:i[a]=s.toJSON())}return o&&(i.items=o.map((function(e){return e.toJSON()}))),i},n.throwError=function(e,t,n){throw new o.RuntimeError({code:e,httpStatusCode:400,message:u._getResourceString(e,t),debugInfo:n?{errorLocation:n}:void 0})},n.createRuntimeError=function(e,t,n,r,i){return new o.RuntimeError({code:e,httpStatusCode:r,message:t,debugInfo:{errorLocation:n},data:i})},n.throwIfNotLoaded=function(e,t,r,o){if(!o&&u.isUndefined(t)&&e.charCodeAt(0)!=n.s_underscoreCharCode&&!n.s_suppressPropertyNotLoadedException)throw n.createPropertyNotLoadedException(r,e)},n._getPropertyValueWithoutCheckLoaded=function(e,t){n.s_suppressPropertyNotLoadedException=!0;try{return e[t]}finally{n.s_suppressPropertyNotLoadedException=!1}},n.createPropertyNotLoadedException=function(e,t){return new o.RuntimeError({code:E.propertyNotLoaded,httpStatusCode:400,message:u._getResourceString(G.propertyNotLoaded,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},n.createCannotUpdateReadOnlyPropertyException=function(e,t){return new o.RuntimeError({code:E.cannotUpdateReadOnlyProperty,httpStatusCode:400,message:u._getResourceString(G.cannotUpdateReadOnlyProperty,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},n.promisify=function(t){return new e.Promise((function(e,n){t((function(t){"failed"==t.status?n(t.error):e(t.value)}))}))},n._addActionResultHandler=function(e,t,n){e.context._pendingRequest.addActionResultHandler(t,n)},n._handleNavigationPropertyResults=function(e,t,n){for(var r=0;r<n.length-1;r+=2)u.isUndefined(t[n[r+1]])||e[n[r]]._handleResult(t[n[r+1]])},n._fixupApiFlags=function(e){return"boolean"==typeof e&&(e=e?1:0),e},n.definePropertyThrowUnloadedException=function(e,t,r){Object.defineProperty(e,r,{configurable:!0,enumerable:!0,get:function(){throw n.createPropertyNotLoadedException(t,r)},set:function(){throw n.createCannotUpdateReadOnlyPropertyException(t,r)}})},n.defineReadOnlyPropertyWithValue=function(e,t,r){Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:function(){return r},set:function(){throw n.createCannotUpdateReadOnlyPropertyException(null,t)}})},n.processRetrieveResult=function(e,t,r,o){if(!u.isNullOrUndefined(t))if(o){var i=t[x.itemsLowerCase];if(Array.isArray(i)){for(var a=[],s=0;s<i.length;s++){var c=o(i[s],s),l={};l[x.proxy]=c,c._handleRetrieveResult(i[s],l),a.push(l)}n.defineReadOnlyPropertyWithValue(r,x.itemsLowerCase,a)}}else{var d=e[x.scalarPropertyNames],f=e[x.navigationPropertyNames],p=e[x.className];if(d)for(s=0;s<d.length;s++){var g=t[h=d[s]];u.isUndefined(g)?n.definePropertyThrowUnloadedException(r,p,h):n.defineReadOnlyPropertyWithValue(r,h,g)}if(f)for(s=0;s<f.length;s++){var h;g=t[h=f[s]];if(u.isUndefined(g))n.definePropertyThrowUnloadedException(r,p,h);else{var m=e[h],y={};m._handleRetrieveResult(g,y),y[x.proxy]=m,Array.isArray(y[x.itemsLowerCase])&&(y=y[x.itemsLowerCase]),n.defineReadOnlyPropertyWithValue(r,h,y)}}}},n.setMockData=function(e,t,r,o){if(u.isNullOrUndefined(t))e._handleResult(t);else{if(e[x.scalarPropertyOriginalNames]){for(var i={},a=e[x.scalarPropertyOriginalNames],s=e[x.scalarPropertyNames],c=0;c<s.length;c++)void 0!==t[s[c]]&&(i[a[c]]=t[s[c]]);e._handleResult(i)}if(e[x.navigationPropertyNames]){var l=e[x.navigationPropertyNames];for(c=0;c<l.length;c++)if(void 0!==t[l[c]]){var d=e[l[c]];d.setMockData&&d.setMockData(t[l[c]])}}if(e[x.isCollection]&&r){var f=Array.isArray(t)?t:t[x.itemsLowerCase];if(Array.isArray(f)){var p=[];for(c=0;c<f.length;c++){var g=r(f,c);n.setMockData(g,f[c]),p.push(g)}o(p)}}}},n.applyMixin=function(e,t){Object.getOwnPropertyNames(t.prototype).forEach((function(n){"constructor"!==n&&Object.defineProperty(e.prototype,n,Object.getOwnPropertyDescriptor(t.prototype,n))}))},n.ensureTypeInitialized=function(e){var t=new F;new e(t,B.createNewObjectObjectPath(t,"Temp",!1,0))},n.fieldName_m__items="m__items",n.fieldName_isCollection="_isCollection",n._synchronousCleanup=!1,n.s_underscoreCharCode="_".charCodeAt(0),n.s_suppressPropertyNotLoadedException=!1,n}(S);e.Utility=z;var J=function(){function e(){}return e.invokeMethod=function(e,t,n,r,o,i){var a=R.createMethodAction(e.context,e,t,n,r,o),s=new b(i);return z._addActionResultHandler(e,a,s),s},e.invokeEnsureUnchanged=function(e,t){R.createEnsureUnchangedAction(e.context,e,t)},e.invokeSetProperty=function(e,t,n,r){R.createSetPropertyAction(e.context,e,t,n,r)},e.createRootServiceObject=function(e,t){return new e(t,B.createGlobalObjectObjectPath(t))},e.createObjectFromReferenceId=function(e,t,n){return new e(t,B.createReferenceIdObjectPath(t,n))},e.createTopLevelServiceObject=function(e,t,n,r,o){return new e(t,B.createNewObjectObjectPath(t,n,r,o))},e.createPropertyObject=function(e,t,n,r,o){var i=B.createPropertyObjectPath(t.context,t,n,r,!1,o);return new e(t.context,i)},e.createIndexerObject=function(e,t,n){var r=B.createIndexerObjectPath(t.context,t,n);return new e(t.context,r)},e.createMethodObject=function(e,t,n,r,o,i,a,s,c){var l=B.createMethodObjectPath(t.context,t,n,r,o,i,a,s,c);return new e(t.context,l)},e.createChildItemObject=function(e,t,n,r,o){var i=B.createChildItemObjectPathUsingIndexerOrGetItemAt(t,n.context,n,r,o);return new e(n.context,i)},e}();e.BatchApiHelper=J;var K=function(){function t(e){if(this.m_namespaceMap={},this.m_namespace=e.metadata.name,this.m_targetNamespaceObject=e.targetNamespaceObject,this.m_namespaceMap[this.m_namespace]=e.targetNamespaceObject,e.namespaceMap)for(var t in e.namespaceMap)this.m_namespaceMap[t]=e.namespaceMap[t];this.m_defaultApiSetName=e.metadata.defaultApiSetName,this.m_hostName=e.metadata.hostName;var n=e.metadata;if(n.enumTypes)for(var r=0;r<n.enumTypes.length;r++)this.buildEnumType(n.enumTypes[r]);if(n.apiSets){for(r=0;r<n.apiSets.length;r++){var o=n.apiSets[r];Array.isArray(o)&&(n.apiSets[r]={version:o[0],name:o[1]||this.m_defaultApiSetName})}this.m_apiSets=n.apiSets}if(this.m_strings=n.strings,n.clientObjectTypes)for(r=0;r<n.clientObjectTypes.length;r++){o=n.clientObjectTypes[r];Array.isArray(o)&&(this.ensureArraySize(o,11),n.clientObjectTypes[r]={name:this.getString(o[0]),behaviorFlags:o[1],collectionPropertyPath:this.getString(o[6]),newObjectServerTypeFullName:this.getString(o[9]),newObjectApiFlags:o[10],childItemTypeFullName:this.getString(o[7]),scalarProperties:o[2],navigationProperties:o[3],scalarMethods:o[4],navigationMethods:o[5],events:o[8]}),this.buildClientObjectType(n.clientObjectTypes[r],e.fullyInitialize)}}return t.prototype.ensureArraySize=function(e,t){for(var n=t-e.length;n>0;)e.push(0),n--},t.prototype.getString=function(e){return"number"==typeof e?e>0?this.m_strings[e-1]:null:e},t.prototype.buildEnumType=function(e){var t;if(Array.isArray(e)){(t={name:e[0],fields:e[2]}).fields||(t.fields={});var n=e[1];if(Array.isArray(n))for(var r=0;r<n.length;r++)t.fields[n[r]]=this.toSimpleCamelUpperCase(n[r])}else t=e;this.m_targetNamespaceObject[t.name]=t.fields},t.prototype.buildClientObjectType=function(n,r){var o=this,i=function(t,r){T.apply(this,arguments),o.m_targetNamespaceObject[n.name]._typeInited||(o.buildPrototype(o.m_targetNamespaceObject[n.name],n),o.m_targetNamespaceObject[n.name]._typeInited=!0),e._internalConfig.appendTypeNameToObjectPathInfo&&this._objectPath&&this._objectPath.objectPathInfo&&this._className&&(this._objectPath.objectPathInfo.T=this._className)};(this.m_targetNamespaceObject[n.name]=i,this.extendsType(i,T),this.buildNewObject(i,n),0!=(2&n.behaviorFlags)&&(i.prototype._KeepReference=function(){J.invokeMethod(this,"_KeepReference",1,[],0,0)}),0!=(32&n.behaviorFlags))&&this.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_StaticCustomize").call(null,i);r&&(this.buildPrototype(i,n),i._typeInited=!0)},t.prototype.extendsType=function(e,t){function n(){this.constructor=e}e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)},t.prototype.findObjectUnderPath=function(t,n,r){for(var o=t,i=r;i<n.length;i++){if("object"!=typeof o)throw new e.Error("Cannot find "+n.join("."));o=o[n[i]]}return o},t.prototype.getFunction=function(t){var n=this.resolveObjectByFullName(t);if("function"!=typeof n)throw new e.Error("Cannot find function or type: "+t);return n},t.prototype.resolveObjectByFullName=function(e){var t=e.split(".");if(1===t.length)return this.m_targetNamespaceObject[t[0]];var n=t[0];return n===this.m_namespace?this.findObjectUnderPath(this.m_targetNamespaceObject,t,1):this.m_namespaceMap[n]?this.findObjectUnderPath(this.m_namespaceMap[n],t,1):this.findObjectUnderPath(this.m_targetNamespaceObject,t,0)},t.prototype.evaluateSimpleExpression=function(t,n){if(z.isNullOrUndefined(t))return null;var r=t.split(".");if(3===r.length&&"OfficeExtension"===r[0]&&"Constants"===r[1])return x[r[2]];if("this"===r[0]){for(var o=n,i=1;i<r.length;i++)o="toString()"==r[i]?o.toString():"()"===r[i].substr(r[i].length-2)?o[r[i].substr(0,r[i].length-2)]():o[r[i]];return o}throw new e.Error("Cannot evaluate: "+t)},t.prototype.evaluateEventTargetId=function(e,t){return z.isNullOrEmptyString(e)?"":this.evaluateSimpleExpression(e,t)},t.prototype.isAllDigits=function(e){for(var t="0".charCodeAt(0),n="9".charCodeAt(0),r=0;r<e.length;r++)if(e.charCodeAt(r)<t||e.charCodeAt(r)>n)return!1;return!0},t.prototype.evaluateEventType=function(t){if(z.isNullOrEmptyString(t))return 0;if(this.isAllDigits(t))return parseInt(t);var n=this.resolveObjectByFullName(t);if("number"!=typeof n)throw new e.Error("Invalid event type: "+t);return n},t.prototype.buildPrototype=function(e,t){this.buildScalarProperties(e,t),this.buildNavigationProperties(e,t),this.buildScalarMethods(e,t),this.buildNavigationMethods(e,t),this.buildEvents(e,t),this.buildHandleResult(e,t),this.buildHandleIdResult(e,t),this.buildHandleRetrieveResult(e,t),this.buildLoad(e,t),this.buildRetrieve(e,t),this.buildSetMockData(e,t),this.buildEnsureUnchanged(e,t),this.buildUpdate(e,t),this.buildSet(e,t),this.buildToJSON(e,t),this.buildItems(e,t),this.buildTypeMetadataInfo(e,t),this.buildTrackUntrack(e,t),this.buildMixin(e,t)},t.prototype.toSimpleCamelUpperCase=function(e){return e.substr(0,1).toUpperCase()+e.substr(1)},t.prototype.ensureOriginalName=function(e){null===e.originalName&&(e.originalName=this.toSimpleCamelUpperCase(e.name))},t.prototype.getFieldName=function(e){return"m_"+e.name},t.prototype.throwIfApiNotSupported=function(e,t){if(this.m_apiSets&&t.apiSetInfoOrdinal>0){var n=this.m_apiSets[t.apiSetInfoOrdinal-1];n&&z.throwIfApiNotSupported(e.name+"."+t.name,n.name,n.version,this.m_hostName)}},t.prototype.buildScalarProperties=function(e,t){if(Array.isArray(t.scalarProperties))for(var n=0;n<t.scalarProperties.length;n++){var r=t.scalarProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,6),t.scalarProperties[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],originalName:this.getString(r[3]),setMethodApiFlags:r[4],undoableApiSetInfoOrdinal:r[5]}),this.buildScalarProperty(e,t,t.scalarProperties[n])}},t.prototype.calculateApiFlags=function(e,t){if(t>0){var n=this.m_apiSets[t-1];n&&(e=S.calculateApiFlags(e,n.name,n.version))}return e},t.prototype.buildScalarProperty=function(e,n,r){this.ensureOriginalName(r);var o=this,i=this.getFieldName(r),a={get:function(){return z.throwIfNotLoaded(r.name,this[i],n.name,this._isNull),o.throwIfApiNotSupported(n,r),this[i]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(a.set=function(e){if(4&r.behaviorFlags&&o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)return;this[i]=e;var a=o.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);J.invokeSetProperty(this,r.originalName,e,a)}),Object.defineProperty(e.prototype,r.name,a)},t.prototype.buildNavigationProperties=function(e,t){if(Array.isArray(t.navigationProperties))for(var n=0;n<t.navigationProperties.length;n++){var r=t.navigationProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,8),t.navigationProperties[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[4]),getMethodApiFlags:r[5],setMethodApiFlags:r[6],propertyTypeFullName:this.getString(r[1]),undoableApiSetInfoOrdinal:r[7]}),this.buildNavigationProperty(e,t,t.navigationProperties[n])}},t.prototype.buildNavigationProperty=function(e,n,r){this.ensureOriginalName(r);var o=this,i=this.getFieldName(r),a={get:function(){(this[o.getFieldName(r)]||(o.throwIfApiNotSupported(n,r),this[i]=J.createPropertyObject(o.getFunction(r.propertyTypeFullName),this,r.originalName,0!=(16&r.behaviorFlags),r.getMethodApiFlags)),64&r.behaviorFlags)&&o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Get").call(this,this,this[i]);return this[i]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(a.set=function(e){if(4&r.behaviorFlags&&o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)return;this[i]=e;var a=o.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);J.invokeSetProperty(this,r.originalName,e,a)}),Object.defineProperty(e.prototype,r.name,a)},t.prototype.buildScalarMethods=function(e,t){if(Array.isArray(t.scalarMethods))for(var n=0;n<t.scalarMethods.length;n++){var r=t.scalarMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.scalarMethods[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[5]),apiFlags:r[4],parameterCount:r[1],undoableApiSetInfoOrdinal:r[6]}),this.buildScalarMethod(e,t,t.scalarMethods[n])}},t.prototype.buildScalarMethod=function(e,n,r){this.ensureOriginalName(r);var o=this;e.prototype[r.name]=function(){var e=[];if(64&r.behaviorFlags&&r.parameterCount>0){for(var i=0;i<r.parameterCount-1;i++)e.push(arguments[i]);var a=[];for(i=r.parameterCount-1;i<arguments.length;i++)a.push(arguments[i]);e.push(a)}else for(i=0;i<arguments.length;i++)e.push(arguments[i]);if(1&r.behaviorFlags){var s=o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName),c=[this];for(i=0;i<e.length;i++)c.push(e[i]);var l=s.apply(this,c),u=l.handled,d=l.result;if(u)return d}o.throwIfApiNotSupported(n,r);var f=0;32&r.behaviorFlags&&(f=1);var p=0;2&r.behaviorFlags&&(p=1);var g=o.calculateApiFlags(r.apiFlags,r.undoableApiSetInfoOrdinal);return J.invokeMethod(this,r.originalName,p,e,g,f)}},t.prototype.buildNavigationMethods=function(e,t){if(Array.isArray(t.navigationMethods))for(var n=0;n<t.navigationMethods.length;n++){var r=t.navigationMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,9),t.navigationMethods[n]={name:this.getString(r[0]),behaviorFlags:r[3],apiSetInfoOrdinal:r[4],originalName:this.getString(r[6]),apiFlags:r[5],parameterCount:r[2],returnTypeFullName:this.getString(r[1]),returnObjectGetByIdMethodName:this.getString(r[7]),undoableApiSetInfoOrdinal:r[8]}),this.buildNavigationMethod(e,t,t.navigationMethods[n])}},t.prototype.buildNavigationMethod=function(e,n,r){this.ensureOriginalName(r);var o=this;e.prototype[r.name]=function(){var e=[];if(64&r.behaviorFlags&&r.parameterCount>0){for(var i=0;i<r.parameterCount-1;i++)e.push(arguments[i]);var a=[];for(i=r.parameterCount-1;i<arguments.length;i++)a.push(arguments[i]);e.push(a)}else for(i=0;i<arguments.length;i++)e.push(arguments[i]);if(1&r.behaviorFlags){var s=o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName),c=[this];for(i=0;i<e.length;i++)c.push(e[i]);var l=s.apply(this,c),u=l.handled,d=l.result;if(u)return d}if(o.throwIfApiNotSupported(n,r),0!=(16&r.behaviorFlags))return J.createIndexerObject(o.getFunction(r.returnTypeFullName),this,e);var f=0;2&r.behaviorFlags&&(f=1);var p=o.calculateApiFlags(r.apiFlags,r.undoableApiSetInfoOrdinal);return J.createMethodObject(o.getFunction(r.returnTypeFullName),this,r.originalName,f,e,0!=(4&r.behaviorFlags),0!=(8&r.behaviorFlags),r.returnObjectGetByIdMethodName,p)}},t.prototype.buildHandleResult=function(e,n){var r=this;e.prototype._handleResult=function(e){if(T.prototype._handleResult.call(this,e),!z.isNullOrUndefined(e)){if(z.fixObjectPathIfNecessary(this,e),8&n.behaviorFlags)r.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_HandleResult").call(this,this,e);if(n.scalarProperties)for(var o=0;o<n.scalarProperties.length;o++)z.isUndefined(e[n.scalarProperties[o].originalName])||(0!=(8&n.scalarProperties[o].behaviorFlags)?this[r.getFieldName(n.scalarProperties[o])]=z.adjustToDateTime(e[n.scalarProperties[o].originalName]):this[r.getFieldName(n.scalarProperties[o])]=e[n.scalarProperties[o].originalName]);if(n.navigationProperties){for(var i=[],a=0;a<n.navigationProperties.length;a++)i.push(n.navigationProperties[a].name),i.push(n.navigationProperties[a].originalName);z._handleNavigationPropertyResults(this,e,i)}if(0!=(1&n.behaviorFlags)){var s=r.hasIndexMethod(n);if(!z.isNullOrUndefined(e[x.items])){this.m__items=[];for(var c=e[x.items],l=r.getFunction(n.childItemTypeFullName),u=0;u<c.length;u++){var d=J.createChildItemObject(l,s,this,c[u],u);d._handleResult(c[u]),this.m__items.push(d)}}}}}},t.prototype.buildHandleRetrieveResult=function(e,t){var n=this;e.prototype._handleRetrieveResult=function(e,r){if(T.prototype._handleRetrieveResult.call(this,e,r),!z.isNullOrUndefined(e)){if(t.scalarProperties)for(var o=0;o<t.scalarProperties.length;o++)8&t.scalarProperties[o].behaviorFlags&&(z.isNullOrUndefined(e[t.scalarProperties[o].name])||(e[t.scalarProperties[o].name]=z.adjustToDateTime(e[t.scalarProperties[o].name])));if(1&t.behaviorFlags){var i=n.hasIndexMethod(t),a=n.getFunction(t.childItemTypeFullName),s=this;z.processRetrieveResult(s,e,r,(function(e,t){return J.createChildItemObject(a,i,s,e,t)}))}else z.processRetrieveResult(this,e,r)}}},t.prototype.buildHandleIdResult=function(e,n){var r=this;e.prototype._handleIdResult=function(e){if(T.prototype._handleIdResult.call(this,e),!z.isNullOrUndefined(e)){if(16&n.behaviorFlags)r.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_HandleIdResult").call(this,this,e);if(n.scalarProperties)for(var o=0;o<n.scalarProperties.length;o++){var i=n.scalarProperties[o].originalName;"Id"!==i&&"_Id"!==i&&"_ReferenceId"!==i||z.isNullOrUndefined(e[n.scalarProperties[o].originalName])||(this[r.getFieldName(n.scalarProperties[o])]=e[n.scalarProperties[o].originalName])}}}},t.prototype.buildLoad=function(e,t){e.prototype.load=function(e){return z.load(this,e)}},t.prototype.buildRetrieve=function(e,t){e.prototype.retrieve=function(e){return z.retrieve(this,e)}},t.prototype.buildNewObject=function(e,t){z.isNullOrEmptyString(t.newObjectServerTypeFullName)||(e.newObject=function(n){return J.createTopLevelServiceObject(e,n,t.newObjectServerTypeFullName,0!=(1&t.behaviorFlags),t.newObjectApiFlags)})},t.prototype.buildSetMockData=function(e,t){var n=this;if(1&t.behaviorFlags){var r=n.hasIndexMethod(t);e.prototype.setMockData=function(e){var o=this;z.setMockData(o,e,(function(e,i){return J.createChildItemObject(n.getFunction(t.childItemTypeFullName),r,o,e,i)}),(function(e){o.m__items=e}))}}else e.prototype.setMockData=function(e){z.setMockData(this,e)}},t.prototype.buildEnsureUnchanged=function(e,t){e.prototype.ensureUnchanged=function(e){J.invokeEnsureUnchanged(this,e)}},t.prototype.buildUpdate=function(e,t){e.prototype.update=function(e){this._recursivelyUpdate(e)}},t.prototype.buildSet=function(e,t){if(0==(1&t.behaviorFlags)){var n=[],r=[];if(t.scalarProperties)for(var o=0;o<t.scalarProperties.length;o++)0==(2&t.scalarProperties[o].behaviorFlags)&&0!=(1&t.scalarProperties[o].behaviorFlags)?r.push(t.scalarProperties[o].name):n.push(t.scalarProperties[o].name);var i=[];if(t.navigationProperties)for(o=0;o<t.navigationProperties.length;o++)0!=(16&t.navigationProperties[o].behaviorFlags)||0==(1&t.navigationProperties[o].behaviorFlags)||0==(32&t.navigationProperties[o].behaviorFlags)?n.push(t.navigationProperties[o].name):i.push(t.navigationProperties[o].name);0===i.length&&0===r.length||(e.prototype.set=function(e,t){this._recursivelySet(e,t,r,i,n)})}},t.prototype.buildItems=function(e,t){0!=(1&t.behaviorFlags)&&Object.defineProperty(e.prototype,"items",{get:function(){return z.throwIfNotLoaded("items",this.m__items,t.name,this._isNull),this.m__items},enumerable:!0,configurable:!0})},t.prototype.buildToJSON=function(e,t){var n=this;0==(1&t.behaviorFlags)?e.prototype.toJSON=function(){var e={};if(t.scalarProperties)for(var r=0;r<t.scalarProperties.length;r++)0!=(1&t.scalarProperties[r].behaviorFlags)&&(e[t.scalarProperties[r].name]=this[n.getFieldName(t.scalarProperties[r])]);var o={};if(t.navigationProperties)for(r=0;r<t.navigationProperties.length;r++)0!=(1&t.navigationProperties[r].behaviorFlags)&&(o[t.navigationProperties[r].name]=this[n.getFieldName(t.navigationProperties[r])]);return z.toJson(this,e,o)}:e.prototype.toJSON=function(){return z.toJson(this,{},{},this.m__items)}},t.prototype.buildTypeMetadataInfo=function(e,t){Object.defineProperty(e.prototype,"_className",{get:function(){return t.name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_isCollection",{get:function(){return 0!=(1&t.behaviorFlags)},enumerable:!0,configurable:!0}),z.isNullOrEmptyString(t.collectionPropertyPath)||Object.defineProperty(e.prototype,"_collectionPropertyPath",{get:function(){return t.collectionPropertyPath},enumerable:!0,configurable:!0}),t.scalarProperties&&t.scalarProperties.length>0&&(Object.defineProperty(e.prototype,"_scalarPropertyNames",{get:function(){return this.m__scalarPropertyNames||(this.m__scalarPropertyNames=t.scalarProperties.map((function(e){return e.name}))),this.m__scalarPropertyNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyOriginalNames",{get:function(){return this.m__scalarPropertyOriginalNames||(this.m__scalarPropertyOriginalNames=t.scalarProperties.map((function(e){return e.originalName}))),this.m__scalarPropertyOriginalNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyUpdateable",{get:function(){return this.m__scalarPropertyUpdateable||(this.m__scalarPropertyUpdateable=t.scalarProperties.map((function(e){return 0==(2&e.behaviorFlags)}))),this.m__scalarPropertyUpdateable},enumerable:!0,configurable:!0})),t.navigationProperties&&t.navigationProperties.length>0&&Object.defineProperty(e.prototype,"_navigationPropertyNames",{get:function(){return this.m__navigationPropertyNames||(this.m__navigationPropertyNames=t.navigationProperties.map((function(e){return e.name}))),this.m__navigationPropertyNames},enumerable:!0,configurable:!0})},t.prototype.buildTrackUntrack=function(e,t){2&t.behaviorFlags&&(e.prototype.track=function(){return this.context.trackedObjects.add(this),this},e.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this})},t.prototype.buildMixin=function(e,t){if(4&t.behaviorFlags){var n=this.getFunction(t.name+"Custom");z.applyMixin(e,n)}},t.prototype.getOnEventName=function(e){return"_"===e[0]?"_on"+e.substr(1):"on"+e},t.prototype.buildEvents=function(e,t){if(t.events)for(var n=0;n<t.events.length;n++){var r=t.events[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.events[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],typeExpression:this.getString(r[3]),targetIdExpression:this.getString(r[4]),register:this.getString(r[5]),unregister:this.getString(r[6])}),this.buildEvent(e,t,t.events[n])}},t.prototype.buildEvent=function(e,t,n){1&n.behaviorFlags?this.buildV0Event(e,t,n):this.buildV2Event(e,t,n)},t.prototype.buildV2Event=function(e,n,r){var o=this,i=this.getOnEventName(r.name),a=this.getFieldName(r);Object.defineProperty(e.prototype,i,{get:function(){if(!this[a]){o.throwIfApiNotSupported(n,r);var e=this,i=null;"null"!==r.register&&(i=this[r.register].bind(this));var s=null;"null"!==r.unregister&&(s=this[r.unregister].bind(this));var c=null;2&r.behaviorFlags&&(c=o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.name+"_EventArgsTransform"));var l=o.evaluateEventType(r.typeExpression);this[a]=new j(this.context,this,r.name,{eventType:l,getTargetIdFunc:function(){return o.evaluateEventTargetId(r.targetIdExpression,e)},registerFunc:i,unregisterFunc:s,eventArgsTransformFunc:function(t){return c&&(t=c.call(e,e,t)),z._createPromiseFromResult(t)}})}return this[a]},enumerable:!0,configurable:!0})},t.prototype.buildV0Event=function(e,n,r){var o=this,i=this.getOnEventName(r.name),a=this.getFieldName(r);Object.defineProperty(e.prototype,i,{get:function(){if(!this[a]){o.throwIfApiNotSupported(n,r);var e=this,i=null;if(z.isNullOrEmptyString(r.register)){var s=o.evaluateEventType(r.typeExpression);i=function(t){var n=o.evaluateEventTargetId(r.targetIdExpression,e);return e.context.eventRegistration.register(s,n,t)}}else if("null"!==r.register){var c=o.getFunction(r.register);i=function(t){return c.call(e,e,t)}}var l=null;if(z.isNullOrEmptyString(r.unregister)){var u=o.evaluateEventType(r.typeExpression);l=function(t){var n=o.evaluateEventTargetId(r.targetIdExpression,e);return e.context.eventRegistration.unregister(u,n,t)}}else if("null"!==r.unregister){var d=o.getFunction(r.unregister);l=function(t){return d.call(e,e,t)}}var f=null;2&r.behaviorFlags&&(f=o.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.name+"_EventArgsTransform"));this[a]=new N(this.context,this,r.name,{registerFunc:i,unregisterFunc:l,eventArgsTransformFunc:function(t){return f&&(t=f.call(e,e,t)),z._createPromiseFromResult(t)}})}return this[a]},enumerable:!0,configurable:!0})},t.prototype.hasIndexMethod=function(e){var t=!1;if(e.navigationMethods)for(var n=0;n<e.navigationMethods.length;n++)if(0!=(16&e.navigationMethods[n].behaviorFlags)){t=!0;break}return t},t.CustomizationCodeNamespace="_CC",t}();e.LibraryBuilder=K}(OfficeExtension||(OfficeExtension={})),function(e){var t;!function(t){t.getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;throw new e.Error("No Promise implementation found")}}(t||(t={})),Object.defineProperty(e,"Promise",{get:function(){return t.getPromiseType()},enumerable:!0,configurable:!0})}(OfficeExtension||(OfficeExtension={}));try{if("undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka){var RichApiBridgeImpl=function(){function e(){}return e.prototype.sendMessageToHost=function(e){OfficePlatformGlobal.ReactNativeReka.RekaInstance.InvokeNative("RichApiDataService","ProcessMessageToHost",e)},e}(),RichApiBridge_1=new RichApiBridgeImpl,RichApiDataService_1=function(){function e(){}return e.prototype.Invoke=function(e,t){"ProcessMessageFromHost"===e&&RichApiBridge_1.onMessageFromHost&&RichApiBridge_1.onMessageFromHost(t)},e}();OfficePlatformGlobal.ReactNativeReka.initReka(),OfficePlatformGlobal.ReactNativeReka.RekaInstance.RegisterService("RichApiDataService",(function(){return new RichApiDataService_1})),OfficeExtension.HostBridge.init(RichApiBridge_1),OfficeExtension.HostBridgeSession.getInstanceIfHostBridgeInited()}}catch(e){}var oteljs;__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(e){function t(e,t,n,r){return{name:e,dataType:t,value:n,classification:r||4}}e.makeBooleanDataField=function(e,n,r){return t(e,1,n,r)},e.makeInt64DataField=function(e,n,r){return t(e,2,n,r)},e.makeDoubleDataField=function(e,n,r){return t(e,3,n,r)},e.makeStringDataField=function(e,n,r){return t(e,0,n,r)},e.makeGuidDataField=function(e,n,r){return t(e,4,n,r)}}(oteljs||(oteljs={})),function(e){!function(e){e[e.EssentialServiceMetadata=1]="EssentialServiceMetadata",e[e.AccountData=2]="AccountData",e[e.SystemMetadata=4]="SystemMetadata",e[e.OrganizationIdentifiableInformation=8]="OrganizationIdentifiableInformation",e[e.EndUserIdentifiableInformation=16]="EndUserIdentifiableInformation",e[e.CustomerContent=32]="CustomerContent",e[e.AccessControl=64]="AccessControl",e[e.PublicNonPersonalData=128]="PublicNonPersonalData",e[e.EndUserPseudonymousInformation=256]="EndUserPseudonymousInformation",e[e.PublicPersonalData=512]="PublicPersonalData",e[e.SupportData=1024]="SupportData",e[e.DirectMeasurementData=2048]="DirectMeasurementData",e[e.Everything=65535]="Everything"}(e.DataClassification||(e.DataClassification={})),function(e){e[e.String=0]="String",e[e.Boolean=1]="Boolean",e[e.Int64=2]="Int64",e[e.Double=3]="Double",e[e.Guid=4]="Guid"}(e.DataFieldType||(e.DataFieldType={})),function(e){e[e.NotSet=0]="NotSet",e[e.Measure=1]="Measure",e[e.Diagnostics=2]="Diagnostics",e[e.CriticalBusinessImpact=191]="CriticalBusinessImpact",e[e.CriticalCensus=192]="CriticalCensus",e[e.CriticalExperimentation=193]="CriticalExperimentation",e[e.CriticalUsage=194]="CriticalUsage"}(e.SamplingPolicy||(e.SamplingPolicy={})),function(e){e[e.NotSet=0]="NotSet",e[e.Normal=1]="Normal",e[e.High=2]="High"}(e.PersistencePriority||(e.PersistencePriority={})),function(e){e[e.NotSet=0]="NotSet",e[e.Normal=1]="Normal",e[e.High=2]="High"}(e.CostPriority||(e.CostPriority={})),function(e){e[e.NotSet=0]="NotSet",e[e.SoftwareSetup=1]="SoftwareSetup",e[e.ProductServiceUsage=2]="ProductServiceUsage",e[e.ProductServicePerformance=4]="ProductServicePerformance",e[e.DeviceConfiguration=8]="DeviceConfiguration",e[e.InkingTypingSpeech=16]="InkingTypingSpeech"}(e.DataCategories||(e.DataCategories={})),function(e){e[e.ReservedDoNotUse=0]="ReservedDoNotUse",e[e.Required=10]="Required",e[e.BasicEvent=10]="BasicEvent",e[e.Optional=100]="Optional",e[e.FullEvent=100]="FullEvent",e[e.RequiredServiceData=110]="RequiredServiceData",e[e.NecessaryServiceDataEvent=110]="NecessaryServiceDataEvent",e[e.RequiredServiceDataForEssentialServices=120]="RequiredServiceDataForEssentialServices",e[e.AlwaysOnNecessaryServiceDataEvent=120]="AlwaysOnNecessaryServiceDataEvent"}(e.DiagnosticLevel||(e.DiagnosticLevel={})),function(e){e[e.None=0]="None",e[e.MocaAddIn=1]="MocaAddIn"}(e.CustomerContentType||(e.CustomerContentType={})),function(e){e[e.Error=0]="Error",e[e.Warning=1]="Warning",e[e.Info=2]="Info",e[e.Verbose=3]="Verbose"}(e.LogLevel||(e.LogLevel={})),function(e){e[e.Core=0]="Core",e[e.Sink=1]="Sink",e[e.Transport=2]="Transport"}(e.Category||(e.Category={})),function(e){e[e.Hourly=1]="Hourly",e[e.Daily=2]="Daily"}(e.DnmInterval||(e.DnmInterval={})),function(e){e[e.ReleaseAudienceGroup=1]="ReleaseAudienceGroup",e[e.WacRing=2]="WacRing",e[e.AppName=3]="AppName",e[e.AppPlatform=4]="AppPlatform",e[e.AppVersion=5]="AppVersion"}(e.AllowedPartA||(e.AllowedPartA={})),function(e){e[e.SendTelemetryEvent=1]="SendTelemetryEvent",e[e.CustomerContent=2]="CustomerContent",e[e.DirectNumericEvent=3]="DirectNumericEvent"}(e.EventType||(e.EventType={}))}(oteljs||(oteljs={})),function(e){e.getEffectiveEventFlags=function(t){var n={costPriority:1,samplingPolicy:1,persistencePriority:1,dataCategories:0,diagnosticLevel:100};return t.eventFlags&&t.eventFlags.dataCategories||e.logNotification(0,0,(function(){return"DataCategories"})),t.eventFlags?(t.eventFlags.costPriority&&(n.costPriority=t.eventFlags.costPriority),t.eventFlags.samplingPolicy&&(n.samplingPolicy=t.eventFlags.samplingPolicy),t.eventFlags.persistencePriority&&(n.persistencePriority=t.eventFlags.persistencePriority),t.eventFlags.dataCategories&&(n.dataCategories=t.eventFlags.dataCategories),t.eventFlags.diagnosticLevel&&(n.diagnosticLevel=t.eventFlags.diagnosticLevel),n):n}}(oteljs||(oteljs={})),function(e){var t,n=(t=[],{fireEvent:function(e){t.forEach((function(t){return t(e)}))},addListener:function(e){e&&t.push(e)}});function r(e,t,r){n.fireEvent({level:e,category:t,message:r})}e.onNotification=function(){return n},e.logNotification=r,e.logError=function(e,t,n){r(0,e,(function(){var e=n instanceof Error?n.message:"";return"".concat(t,": ").concat(e)}))}}(oteljs||(oteljs={})),function(e){var t;function n(e){var t={eventName:e.eventName,eventFlags:e.eventFlags||{},telemetryProperties:e.telemetryProperties?__assign({},e.telemetryProperties):{},dataFields:e.dataFields?e.dataFields.slice():[],timestamp:e.timestamp||(new Date).getTime()};return e.eventContract&&(t.eventContract={name:e.eventContract.name,dataFields:e.eventContract.dataFields.slice()}),t}!function(e){e[e.TelemetryData=0]="TelemetryData",e[e.AnonymousData=1]="AnonymousData",e[e.CustomerContent=2]="CustomerContent"}(t||(t={})),e.SuppressNexus=-1,e.cloneEvent=n;var r=function(){function t(e,t,n){var r,o,i;this.telemetrySinks=[],this.persistentDataFields=[],this.partAFields=[],this.eventQueue=[],this.config=n||{},e&&(this.telemetrySinks=e.telemetrySinks,(r=this.persistentDataFields).push.apply(r,e.persistentDataFields),this.config=__assign(__assign({},e.getConfig()),this.config),(o=this.partAFields).push.apply(o,e.partAFields)),t&&(i=this.persistentDataFields).push.apply(i,t)}return t.prototype.addEventContentType=function(t,n){t.push(e.makeInt64DataField("EventContent.Type",n))},t.prototype.sendTelemetryEvent=function(t){var r=n(t),o=r.telemetryProperties;o.nexusTenantToken=e.SuppressNexus;var i=o.ariaTenantToken;if(!i&&(!e.fillTenantTokens(r.eventName,o)&&!i))return void e.logNotification(0,0,(function(){return"No tenant token: "+t.eventName}));this.sendTelemetryEventInternal(r,1)},t.prototype.sendNonStandardEvent=function(e,t){var r=n(e);this.sendTelemetryEventInternal(r,t)},t.prototype.sendCustomerContent=function(e){var t=n(e),r=t.telemetryProperties,o=r.customerContentVersion;return(!o||o>2)&&(r.customerContentVersion=2),r.ariaTenantToken=void 0,r.nexusTenantToken=void 0,r.dnmToken=void 0,this.addEventContentType(t.dataFields,2),this.sendTelemetryEventInternal(t,2)},t.prototype.sendDirectNumericEvent=function(t){var r=n(t),o=r.telemetryProperties;if(!o.dnmToken&&(!e.fillTenantTokens(r.eventName,o)&&!o.dnmToken))return void e.logNotification(0,0,(function(){return"No dnm token: "+r.eventName}));this.addEventContentType(r.dataFields,1),this.sendTelemetryEventInternal(r,3)},t.prototype.sendTelemetryEventInternal=function(t,n){if(2===n||!t.telemetryProperties.customerContentVersion&&!t.telemetryProperties.customerContentType){try{if(0===this.telemetrySinks.length)return void(this.config.enableQueue&&this.eventQueue.length<1e3?this.eventQueue.push([t,n]):e.logNotification(1,0,(function(){return"No telemetry sinks are attached."})));this.processTelemetryEvent(t,n)}catch(t){return void e.logError(0,"SendTelemetryEvent",t)}this.telemetrySinks.forEach((function(e){try{3===n||2===n?e.sendNonStandardEvent&&e.sendNonStandardEvent(t,n):e.sendTelemetryEvent(t)}catch(e){}}))}else e.logNotification(0,0,(function(){return"Customer content"}))},t.prototype.processTelemetryEvent=function(t,n){var r,o,i;if(t.dataFields&&(null===(i=t.dataFields)||void 0===i||i.unshift(e.makeStringDataField("OTelJS.Version",e.oteljsVersion)),3!==n&&this.persistentDataFields&&(r=t.dataFields).unshift.apply(r,this.persistentDataFields)),this.partAFields.length>0){var a=t.eventContract||{name:"",dataFields:[]};(o=a.dataFields).push.apply(o,this.partAFields),t.eventContract=a}this.config.disableValidation||e.validateTelemetryEvent(t)},t.prototype.addSink=function(e){this.telemetrySinks.push(e),this.flushQueue()},t.prototype.flushQueue=function(){var e=this.eventQueue;if(this.eventQueue=[],this.telemetrySinks.length>0)for(var t=0,n=e;t<n.length;t++){var r=n[t],o=r[0],i=r[1];this.sendTelemetryEventInternal(o,i)}},t.prototype.setTenantToken=function(t,n,r){e.setTenantTokens(t,{ariaTenantToken:n,nexusTenantToken:r})},t.prototype.setDNMToken=function(t,n){e.setTenantTokens(t,{dnmToken:n})},t.prototype.cloneEvent=function(e){return n(e)},t.prototype.getConfig=function(){return this.config},t}();e.SimpleTelemetryLogger=r}(oteljs||(oteljs={})),function(e){var t=9007199254740991,n=/^Office(\.[A-Z][a-zA-Z0-9]*){2,}$/,r=/^[a-zA-Z0-9_\.]{1,95}$/;function o(e){return r.test(e)}function i(e){e&&e.forEach((function(e){if("string"!=typeof e.name||!o(e.name))throw new Error("Invalid dataField name");2===e.dataType&&a(e.value)}))}function a(e){if("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e<-9007199254740991||e>t)throw new Error("Invalid integer ".concat(JSON.stringify(e)))}e.validateTelemetryEvent=function(e){if(!function(e){if(!e||e.length>98)return!1;return n.test(e)}(e.eventName))throw new Error("Invalid eventName");var t=e.eventContract;if(t){if(t.name&&!o(t.name))throw new Error("Invalid eventContract");i(t.dataFields)}i(e.dataFields)},e.validateInt=a}(oteljs||(oteljs={})),function(e){var t={};e.setTenantTokens=function(n,r){"Office."===n.substring(0,7)&&"."!==n[n.length-1]?t[n]?(r.ariaTenantToken&&(t[n].ariaTenantToken=r.ariaTenantToken),r.dnmToken&&(t[n].dnmToken=r.dnmToken)):t[n]=r:e.logNotification(0,0,(function(){return"Namespace: ".concat(n)}))},e.fillTenantTokens=function(e,n){for(var r=e.length;r>0;){var o=e.substr(0,r);if(t[o]){var i=t[o];return n.ariaTenantToken=i.ariaTenantToken,n.dnmToken=i.dnmToken,!0}r=e.lastIndexOf(".",r-1)}return!1},e.clear=function(){t={}}}(oteljs||(oteljs={})),function(e){e.oteljsVersion="4.18.0"}(oteljs||(oteljs={})),function(e){var t=function(){function t(){var e=this;this._requestIsPending=!0,this._telemetryQueue=[],this._customerContentQueue=[],this.pause(1e3).then((function(){return e._requestIsPending=!1,e.processTelemetryEvents()})).catch()}return t.isSupportedByDeclaration=function(){return t.isSupportedVersion("1.2")},t.isSupportedVersion=function(e){return Office.context.requirements.isSetSupported("Telemetry",e)},t.prototype.sendCustomerContent=function(e){t.isSupportedVersion("1.3")&&(this._customerContentQueue.push(e),this.processWorkBacklog())},t.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push(e),this.processWorkBacklog()},t.prototype.processWorkBacklog=function(){var t=this;this._requestIsPending||(this._requestIsPending=!0,this.processTelemetryEvents().then((function(){t.waitAndProcessMore()})).catch((function(n){e.logError(1,"RichApiSink Error",n),t.waitAndProcessMore()})))},t.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then((function(){e._requestIsPending=!1,e._telemetryQueue.length>0&&setTimeout((function(){return e.processWorkBacklog()}),0)})).catch((function(){e._requestIsPending=!1}))},t.prototype.processTelemetryEvents=function(){var t=this,n=this._telemetryQueue;this._telemetryQueue=[];var r=this._customerContentQueue;this._customerContentQueue=[];var o=new OfficeCore.RequestContext,i=function(n,r){if(n.telemetryProperties){var o=[];t.addDataFields(o,n.dataFields);var i=n.eventContract?n.eventContract.name:"";n.eventContract&&t.addDataFields(o,n.eventContract.dataFields),r(n.telemetryProperties,n.eventName,i,e.getEffectiveEventFlags(n),o)}};return n.forEach((function(e){i(e,(function(e,t,n,r,i){o.telemetry.sendTelemetryEvent(e,t,n,r,i)}))})),r.forEach((function(e){i(e,(function(e,t,n,r,i){o.telemetry.sendCustomerContent(e,t,n,r,i)}))})),o.sync().catch((function(t){e.logError(1,"RichApi telemetry failed.",t)}))},t.prototype.addDataFields=function(e,t){t&&t.forEach((function(t){e.push({name:t.name,value:t.value,classification:t.classification?t.classification:4,type:4===t.dataType?0:t.dataType})}))},t.prototype.pause=function(e){return new Office.Promise((function(t){return setTimeout(t,e)}))},t}();e.RichApiSink=t}(oteljs||(oteljs={})),function(e){!function(t){!function(t){!function(t){!function(t){t.getFields=function(t,n){var r=[];return void 0!==n.id&&r.push(e.makeStringDataField("".concat(t,".Id"),n.id)),void 0!==n.version&&r.push(e.makeStringDataField("".concat(t,".Version"),n.version)),void 0!==n.instanceId&&r.push(e.makeStringDataField("".concat(t,".InstanceId"),n.instanceId)),void 0!==n.name&&r.push(e.makeStringDataField("".concat(t,".Name"),n.name)),void 0!==n.marketplaceType&&r.push(e.makeStringDataField("".concat(t,".MarketplaceType"),n.marketplaceType)),void 0!==n.sessionId&&r.push(e.makeStringDataField("".concat(t,".SessionId"),n.sessionId)),void 0!==n.browserToken&&r.push(e.makeStringDataField("".concat(t,".BrowserToken"),n.browserToken)),void 0!==n.osfRuntimeVersion&&r.push(e.makeStringDataField("".concat(t,".OsfRuntimeVersion"),n.osfRuntimeVersion)),void 0!==n.officeJsVersion&&r.push(e.makeStringDataField("".concat(t,".OfficeJsVersion"),n.officeJsVersion)),void 0!==n.hostJsVersion&&r.push(e.makeStringDataField("".concat(t,".HostJsVersion"),n.hostJsVersion)),void 0!==n.assetId&&r.push(e.makeStringDataField("".concat(t,".AssetId"),n.assetId)),void 0!==n.providerName&&r.push(e.makeStringDataField("".concat(t,".ProviderName"),n.providerName)),void 0!==n.type&&r.push(e.makeStringDataField("".concat(t,".Type"),n.type)),r}}(t.SDX||(t.SDX={}))}(t.System||(t.System={}))}(t.Office||(t.Office={}))}(e.Contracts||(e.Contracts={}))}(oteljs||(oteljs={})),function(e){var t=function(){function t(){}return t.isSupported=function(){return Office.context&&Office.context.platform?Office.context.platform===Office.PlatformType.OfficeOnline:OfficeExt&&OfficeExt.HostName&&OfficeExt.HostName.Host&&OfficeExt.HostName.Host.getInstance().getPlatform()===Office.PlatformType.OfficeOnline},t.prototype.sendTelemetryEvent=function(t,n){try{if(t.dataFields&&t.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t})).length>0)return;var r=OSF._OfficeAppFactory.getId(),o=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[r,o,t])}catch(t){e.logError(1,"AgaveWacSink",t)}},t.prototype.sendCustomerContent=function(t,n){try{if(t.dataFields&&t.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t})).length>0)return;var r=OSF._OfficeAppFactory.getId(),o=OSF.AgaveHostAction.SendCustomerContent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[r,o,t])}catch(t){e.logError(1,"AgaveWacSink",t)}},t}();e.SdxWacSink=t}(oteljs||(oteljs={}));var OfficeFirstPartyDialog,OfficeFirstPartyAuth,OfficeCore,OfficeFirstParty;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}(),__awaiter=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function s(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){e.done?o(e.value):new n((function(t){t(e.value)})).then(a,s)}c((r=r.apply(e,t||[])).next())}))},__generator=this&&this.__generator||function(e,t){var n,r,o,i,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return i={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function s(i){return function(s){return function(i){if(n)throw new TypeError("Generator is already executing.");for(;a;)try{if(n=1,r&&(o=2&i[0]?r.return:i[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,i[1])).done)return o;switch(r=0,o&&(i=[2&i[0],o.value]),i[0]){case 0:case 1:o=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,r=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!(o=a.trys,(o=o.length>0&&o[o.length-1])||6!==i[0]&&2!==i[0])){a=0;continue}if(3===i[0]&&(!o||i[1]>o[0]&&i[1]<o[3])){a.label=i[1];break}if(6===i[0]&&a.label<o[1]){a.label=o[1],o=i;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(i);break}o[2]&&a.ops.pop(),a.trys.pop();continue}i=t.call(e,a)}catch(e){i=[6,e],r=0}finally{n=o=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,s])}}},__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),o=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),i=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"BiShim"},enumerable:!0,configurable:!0}),c.prototype.initialize=function(e){n(this,"Initialize",0,[e],0,0)},c.prototype.getData=function(){return n(this,"getData",1,[],4,0)},c.prototype.setVisualObjects=function(e){n(this,"setVisualObjects",0,[e],2,0)},c.prototype.setVisualObjectsToPersist=function(e){n(this,"setVisualObjectsToPersist",0,[e],2,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||i(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.BiShim,n,"Microsoft.AgaveVisual.BiShim",!1,4)},c.prototype.toJSON=function(){return o(this,{},{})},c}(OfficeExtension.ClientObject);e.BiShim=s,function(e){e.generalException1="GeneralException"}(e.AgaveVisualErrorCodes||(e.AgaveVisualErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject;var t=OfficeExtension.BatchApiHelper.createMethodObject,n=(OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject),r=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),o=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,i=(OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),a=OfficeExtension.Utility.isUndefined,s=OfficeExtension.Utility.throwIfNotLoaded,c=(OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load),l=OfficeExtension.Utility.retrieve,u=OfficeExtension.Utility.toJson,d=OfficeExtension.Utility.fixObjectPathIfNecessary,f=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),p=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"FlightingService"},enumerable:!0,configurable:!0}),a.prototype.getClientSessionId=function(){return r(this,"GetClientSessionId",1,[],4,0)},a.prototype.getDeferredFlights=function(){return r(this,"GetDeferredFlights",1,[],4,0)},a.prototype.getFeature=function(n,r,o,i){return t(e.ABType,this,"GetFeature",1,[n,r,o,i],!1,!1,null,4)},a.prototype.getFeatureGate=function(n,r){return t(e.ABType,this,"GetFeatureGate",1,[n,r],!1,!1,null,4)},a.prototype.resetOverride=function(e){r(this,"ResetOverride",0,[e],0,0)},a.prototype.setOverride=function(e,t,n){r(this,"SetOverride",0,[e,t,n],0,0)},a.prototype._handleResult=function(e){(o.prototype._handleResult.call(this,e),i(e))||d(this,e)},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),f(this,e,t)},a.newObject=function(t){return n(e.FlightingService,t,"Microsoft.Experiment.FlightingService",!1,4)},a.prototype.toJSON=function(){return u(this,{},{})},a}(OfficeExtension.ClientObject);e.FlightingService=p;var g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"ABType"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["value"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return s("value",this._V,"ABType",this._isNull),this._V},enumerable:!0,configurable:!0}),t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!i(t)){var n=t;d(this,n),a(n.Value)||(this._V=n.Value)}},t.prototype.load=function(e){return c(this,e)},t.prototype.retrieve=function(e){return l(this,e)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),f(this,t,n)},t.prototype.toJSON=function(){return u(this,{value:this._V},{})},t.prototype.ensureUnchanged=function(e){o(this,e)},t}(OfficeExtension.ClientObject);e.ABType=g,function(e){e.boolean="Boolean",e.integer="Integer",e.string="String"}(e.FeatureType||(e.FeatureType={})),function(e){e.generalException="GeneralException"}(e.ExperimentErrorCodes||(e.ExperimentErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){var t,n=function(){function e(e){this._dialogService=e}return e.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},e.prototype.messageChild=function(e,t){DialogApiManager&&DialogApiManager.messageChildRichApiBridge&&DialogApiManager.messageChildRichApiBridge(e,t)},e}();e.Dialog=n,e.displayWebDialog=function(t,n){return void 0===n&&(n={}),new OfficeExtension.CoreUtility.Promise((function(o,i){if(n.width&&n.height&&(!r(n.width)||!r(n.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var a=new OfficeExtension.ClientRequestContext,s=OfficeCore.FirstPartyDialogService.newObject(a),c=new e.Dialog(s),l=s.onDialogMessage.add((function(e){OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e));var t,r,s,u=JSON.parse(e.message),d=u.errorCode?new OfficeExtension.Error((t=u.errorCode,(r={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},r[12003]={code:"InvalidUrl",message:"HTTPS is required."},r[12004]={code:"Untrusted",message:"Domain is not trusted."},r[12005]={code:"InvalidUrl",message:"HTTPS is required."},r[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},(s=r)[t]?s[t]:{code:"Unknown",message:"An unknown error has occured with code: "+t})):null,f=u.type,p=u.origin,g=u.message;switch(f){case 17:d?i(d):o(c);break;case 12:n.onMessage&&n.onMessage(g,c,p);break;case 10:default:12006===u.errorCode?(l&&(l.remove(),a.sync()),n.onClose&&n.onClose()):n.onRuntimeError&&(n.onRuntimeError(d,c),i(d))}return OfficeExtension.CoreUtility.Promise.resolve()}));return a.sync().then((function(){var e={width:n.width?parseInt(n.width):50,height:n.height?parseInt(n.height):50,displayInIFrame:n.displayInIFrame,dialogTitle:n.dialogTitle,disableESCKeyCloseDialog:void 0!==n.disableESCKeyCloseDialog&&n.disableESCKeyCloseDialog};return s.displayDialog(t,e),a.sync()})).catch((function(e){i(e)}))}));function r(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}},function(e){e[e.dialogMessageReceived=0]="dialogMessageReceived",e[e.dialogEventReceived=1]="dialogEventReceived"}(t||(t={}))}(OfficeFirstPartyDialog||(OfficeFirstPartyDialog={})),function(e){e.OfficeOnlineDomainList=["*.dod.online.office365.us","*.gov.online.office365.us","*.officeapps-df.live.com","*.officeapps.live.com","*.online.office.de","*.partner.officewebapps.cn"],e.isHostOriginTrusted=function(){if(void 0===window.external||void 0===window.external.GetContext){var t=OSF.getClientEndPoint()._targetUrl,n=t.split("/")[2].split(":")[0].split("?")[0];return 0!=t.indexOf("https:")||e.OfficeOnlineDomainList.forEach((function(e){if(0==e.indexOf("*.")&&(e=e.substring(2)),n.indexOf(e)==n.length-e.length)return!0})),!1}return!0}}(OfficeCore||(OfficeCore={})),function(e){var t=function(){function t(e){this.context=e}return Object.defineProperty(t.prototype,"roamingSettings",{get:function(){return this.m_roamingSettings||(this.m_roamingSettings=e.AuthenticationService.newObject(this.context).roamingSettings),this.m_roamingSettings},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tap",{get:function(){return this.m_tap||(this.m_tap=e.Tap.newObject(this.context)),this.m_tap},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skill",{get:function(){return this.m_skill||(this.m_skill=e.Skill.newObject(this.context)),this.m_skill},enumerable:!0,configurable:!0}),t}();e.FirstPartyApis=t;var n=function(n){function r(e){return n.call(this,e)||this}return __extends(r,n),Object.defineProperty(r.prototype,"firstParty",{get:function(){return this.m_firstPartyApis||(this.m_firstPartyApis=new t(this)),this.m_firstPartyApis},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"flighting",{get:function(){return this.flightingService},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"telemetry",{get:function(){return this.m_telemetry||(this.m_telemetry=e.TelemetryService.newObject(this)),this.m_telemetry},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"ribbon",{get:function(){return this.m_ribbon||(this.m_ribbon=e.DynamicRibbon.newObject(this)),this.m_ribbon},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"bi",{get:function(){return this.m_biShim||(this.m_biShim=e.BiShim.newObject(this)),this.m_biShim},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"flightingService",{get:function(){return this.m_flightingService||(this.m_flightingService=e.FlightingService.newObject(this)),this.m_flightingService},enumerable:!0,configurable:!0}),r}(OfficeExtension.ClientRequestContext);e.RequestContext=n,e.run=function(t,n){return OfficeExtension.ClientRequestContext._runBatch("OfficeCore.run",arguments,(function(t){return new e.RequestContext(t)}))}}(OfficeCore||(OfficeCore={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}e.isFeatureEnabled=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,o,i;return __generator(this,(function(a){switch(a.label){case 0:return r=t(),o=OfficeCore.License.newObject(r),i=o.isFeatureEnabled(e,n),[4,r.sync()];case 1:return a.sent(),[2,i.value]}}))}))},e.getFeatureTier=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,o,i;return __generator(this,(function(a){switch(a.label){case 0:return r=t(),o=OfficeCore.License.newObject(r),i=o.getFeatureTier(e,n),[4,r.sync()];case 1:return a.sent(),[2,i.value]}}))}))},e.isFreemiumUpsellEnabled=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.License.newObject(e),r=n.isFreemiumUpsellEnabled(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))},e.launchUpsellExperience=function(e){return __awaiter(this,void 0,void 0,(function(){var n;return __generator(this,(function(r){switch(r.label){case 0:return n=t(),OfficeCore.License.newObject(n).launchUpsellExperience(e),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.onFeatureStateChanged=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,o,i,a;return __generator(this,(function(s){switch(s.label){case 0:return r=t(),o=OfficeCore.License.newObject(r),(i=o.getLicenseFeature(e)).onStateChanged.add(n),a=function(){return i.onStateChanged.remove(n),null},[4,r.sync()];case 1:return s.sent(),[2,a]}}))}))},e.getMsaDeviceTicket=function(e,n,r){return __awaiter(this,void 0,void 0,(function(){var o,i,a;return __generator(this,(function(s){switch(s.label){case 0:return o=t(),i=OfficeCore.License.newObject(o),a=i.getMsaDeviceTicket(e,n,r),[4,o.sync()];case 1:return s.sent(),[2,a.value]}}))}))}}(e.license||(e.license={}))}(Office||(Office={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t,n=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,r=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),o=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),i=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),a=OfficeExtension.Utility.fixObjectPathIfNecessary,s=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),c=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,function(c){function l(){return null!==c&&c.apply(this,arguments)||this}return __extends(l,c),Object.defineProperty(l.prototype,"_className",{get:function(){return"Skill"},enumerable:!0,configurable:!0}),l.prototype.executeAction=function(e,t,n){return r(this,"ExecuteAction",1,[e,t,n],5,0)},l.prototype.notifyPaneEvent=function(e,t){r(this,"NotifyPaneEvent",1,[e,t],5,0)},l.prototype.registerHostSkillEvent=function(){r(this,"RegisterHostSkillEvent",0,[],1,0)},l.prototype.testFireEvent=function(){r(this,"TestFireEvent",0,[],1,0)},l.prototype.unregisterHostSkillEvent=function(){r(this,"UnregisterHostSkillEvent",0,[],1,0)},l.prototype._handleResult=function(e){(c.prototype._handleResult.call(this,e),o(e))||a(this,e)},l.prototype._handleRetrieveResult=function(e,t){c.prototype._handleRetrieveResult.call(this,e,t),s(this,e,t)},l.newObject=function(t){return n(e.Skill,t,"Microsoft.SkillApi.Skill",!1,4)},Object.defineProperty(l.prototype,"onHostSkillEvent",{get:function(){var e=this;return this.m_hostSkillEvent||(this.m_hostSkillEvent=new OfficeExtension.GenericEventHandlers(this.context,this,"HostSkillEvent",{eventType:65538,registerFunc:function(){return e.registerHostSkillEvent()},unregisterFunc:function(){return e.unregisterHostSkillEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(n){var r=t.Skill_HostSkillEvent_EventArgsTransform(e,n);return OfficeExtension.Utility._createPromiseFromResult(r)}})),this.m_hostSkillEvent},enumerable:!0,configurable:!0}),l.prototype.toJSON=function(){return i(this,{},{})},l}(OfficeExtension.ClientObject));e.Skill=c,function(e){e.Skill_HostSkillEvent_EventArgsTransform=function(e,t){return{type:t.type,data:t.data}}}(t=e._CC||(e._CC={})),function(e){e.generalException="GeneralException"}(e.SkillErrorCodes||(e.SkillErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),o=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported),i=(OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),a=OfficeExtension.Utility.fixObjectPathIfNecessary,s=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),c=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,function(c){function l(){return null!==c&&c.apply(this,arguments)||this}return __extends(l,c),Object.defineProperty(l.prototype,"_className",{get:function(){return"TelemetryService"},enumerable:!0,configurable:!0}),l.prototype.sendNonStandardEvent=function(e,t,r,i,a,s){o("TelemetryService.sendNonStandardEvent","Telemetry","1.4","OfficeCore"),n(this,"SendNonStandardEvent",1,[e,t,r,i,a,s],4,0)},l.prototype.sendTelemetryEvent=function(e,t,r,o,i){n(this,"SendTelemetryEvent",1,[e,t,r,o,i],4,0)},l.prototype._handleResult=function(e){(c.prototype._handleResult.call(this,e),r(e))||a(this,e)},l.prototype._handleRetrieveResult=function(e,t){c.prototype._handleRetrieveResult.call(this,e,t),s(this,e,t)},l.newObject=function(n){return t(e.TelemetryService,n,"Microsoft.Telemetry.TelemetryService",!1,4)},l.prototype.toJSON=function(){return i(this,{},{})},l}(OfficeExtension.ClientObject));e.TelemetryService=c,function(e){e.unset="Unset",e.string="String",e.boolean="Boolean",e.int64="Int64",e.double="Double"}(e.DataFieldType||(e.DataFieldType={})),function(e){e.sendTelemetryEvent="SendTelemetryEvent",e.customerContent="CustomerContent",e.directNumericEvent="DirectNumericEvent"}(e.EventType||(e.EventType={})),function(e){e.generalException="GeneralException"}(e.TelemetryErrorCodes||(e.TelemetryErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){var t="officeWebAuthReplyUrls",n=!1,r=null;function o(e){var t=null,n=null,r=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return t=e.apply(void 0,n)};return{immediateCall:r,delayCall:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];n=function(){return r.apply(void 0,e)}},waitForPromise:function(){return n&&(n(),n=null),t||OfficeExtension.CoreUtility.Promise.resolve()}}}function i(t){var n=!1;return r&&(r.supportsAuthToken?n=!0:t&&r.authenticationApiEnabled&&(n=!r.hostPageSupportsAuth||e.supportsTeamsTokenFlow)),n}e.authFlow="authcode",e.autoPopup=!1,e.upnCheck=!0,e.timeout=void 0,e.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",e.debugging=!1,e.useMsal3=void 0,e.delay=0,e.delayMsal=0,e.supportsOauthManager=!1,e.supportsTeamsTokenFlow=!0,e.supportsBrowserAuth=!0;var a=o((function(r,o,i){return e.supportsBrowserAuth?new OfficeExtension.CoreUtility.Promise((function(a,s){try{var c="msa"===r.authorityType.toLowerCase();if(OSF.WebAuth.config={authFlow:e.authFlow,authVersion:e.authVersion?e.authVersion:null,msal:e.msal,delayWebAuth:e.delay,delayMsal:e.delayMsal,debugging:e.debugging,useMsal3:e.useMsal3,authority:e.authorityOverride?e.authorityOverride:r.authority,idp:r.authorityType.toLowerCase(),appIds:[c&&r.msaAppId?r.msaAppId:r.appId],redirectUri:o||null,upn:r.upn,puid:r.userId,prefetch:i,telemetryInstance:"otel",autoPopup:e.autoPopup,enableUpnCheck:e.upnCheck,enableConsoleLogging:e.debugging,tenantId:r.tenantId,timeout:e.timeout},OSF.WebAuth.load().then((function(e){l(e,n=!0),a()})).catch((function(e){l(e,n),s({code:"PackageNotLoaded",message:e instanceof Event?e.type:e})})),"implicit"===e.authFlow){var u=o||window.location.href.split("?")[0],d=sessionStorage.getItem(t);d||""===d?d=u:d+=", "+u,d&&sessionStorage.setItem(t,d)}}catch(e){OSF.WebAuth.config=null,OSF.WebAuth.load().then((function(){a()})).catch((function(){s({code:"FailedToLoad",message:e})}))}})):OfficeExtension.CoreUtility.Promise.reject({code:"PackageNotLoaded"})}));var s=o((function(t,n){return OSF.WebAuth&&"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform?(Office&&Office.context&&Office.context.webAuth?new OfficeExtension.CoreUtility.Promise((function(e,t){Office.context.webAuth.getAuthContextAsync((function(n){if("succeeded"===n.status){if(!(r=n.value)||r.isAnonymous)return void t({code:"CannotGetAuthContext",message:r?r.Error:void 0});e(r)}else t({code:"CannotGetAuthContext",message:n.status})}))})):OfficeExtension.CoreUtility.Promise.reject({code:"GetAuthContextAsyncMissing",message:"Office:["+!Office+"],Office.context:["+!Office.context+"],Office.context.webAuth:["+!Office.context.webAuth+"]"})).then((function(r){if(a.delayCall(r,t,n),!i(e.supportsOauthManager))return a.waitForPromise()})):OfficeExtension.CoreUtility.Promise.resolve()}));function c(e,t){return s.immediateCall(e,t)}function l(e,t){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var n=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Result",t),oteljs.makeStringDataField("Error",e instanceof Event?e.type:"")];if(e&&!(e instanceof Event)&&e.Telemetry)for(var r in e.Telemetry)if(e.Telemetry[r])switch(r){case"succeeded":n.push(oteljs.makeBooleanDataField(r,e.Telemetry[r]));break;case"loadedApplicationCount":case"timeToLoad":n.push(oteljs.makeInt64DataField(r,e.Telemetry[r]));break;default:n.push(oteljs.makeStringDataField(r,e.Telemetry[r]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.Load",dataFields:n,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}function u(e,t,n){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var r=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Popup","boolean"==typeof n&&n),oteljs.makeBooleanDataField("Result",t),oteljs.makeStringDataField("Error",e instanceof Event?e.type:e.ErrorCode)];if(e&&!(e instanceof Event)&&e.Telemetry)for(var o in e.Telemetry)if(e.Telemetry[o])switch(o){case"succeeded":r.push(oteljs.makeBooleanDataField(o,e.Telemetry[o]));break;case"timeToGetToken":r.push(oteljs.makeInt64DataField(o,e.Telemetry[o]));break;default:r.push(oteljs.makeStringDataField(o,e.Telemetry[o]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.GetAccessToken",dataFields:r,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}e.load=c,e.getAccessToken=function(e,t){return s.waitForPromise().then((function(){return new OfficeExtension.CoreUtility.Promise((function(r,o){if("web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform)if(i(!!e.appName)){var s=new OfficeCore.RequestContext,c=OfficeCore.AuthenticationService.newObject(s);s._customData="WacPartition";var l=c.getAccessToken(e,null);s.sync().then((function(){r(l.value)})).catch((function(e){return o(e)}))}else a.waitForPromise().then((function(){var i,a;OSF.WebAuth&&n?OSF.WebAuth.config.appIds[0]&&OSF.WebAuth.getToken(e.resource,null,OSF.WebAuth.config.appIds[0],OSF._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId,t&&t.popup?t.popup:null,e&&e.authChallenge?e.authChallenge:null).then((function(e){u(e,!0,!(!t||!t.popup)&&t.popup),r({accessToken:e.Token,tokenIdenityType:"msa"==OSF.WebAuth.config.idp.toLowerCase()?OfficeCore.IdentityType.microsoftAccount:OfficeCore.IdentityType.organizationAccount})})).catch((function(e){u(e,!1,!(!t||!t.popup)&&t.popup),o({code:e.ErrorCode,message:e instanceof Event?e.type:e.ErrorMessage})})):(i=n,a=OSF.WebAuth.loadAttempts,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var e=[oteljs.makeBooleanDataField("Loaded",i),oteljs.makeInt64DataField("LoadAttempts","number"==typeof a?a:0)];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.UnexpectedAcquire",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})})))})).catch((function(e){return o(e)}));else{var d=new OfficeCore.RequestContext,f=OfficeCore.AuthenticationService.newObject(d),p=f.onTokenReceived.add((function(e){if(!OfficeExtension.CoreUtility.isNullOrUndefined(e))if(p.remove(),d.sync().catch((function(){})),0==e.code)r(e.tokenValue);else if(OfficeExtension.CoreUtility.isNullOrUndefined(e.errorInfo))o({code:e.code});else try{o(JSON.parse(e.errorInfo))}catch(t){o({code:e.code,message:e.errorInfo})}return null}));d.sync().then((function(){var t=f.getAccessToken(e,f._targetId);return d.sync().then((function(){if(OfficeExtension.CoreUtility.isNullOrUndefined(t.value))return null;var e=t.value.accessToken;OfficeExtension.CoreUtility.isNullOrUndefined(e)||r(t.value)}))})).catch((function(e){o(e)}))}}))}))},e.getPrimaryIdentityInfo=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e);e._customData="WacPartition";var n=t.getPrimaryIdentityInfo();return e.sync().then((function(){return n.value}))},e.getIdentities=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e).getIdentities();return e.sync().then((function(){return t.value}))},e.onIdentityChanged=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r=this;return __generator(this,(function(o){switch(o.label){case 0:return o.trys.push([0,3,,4]),"web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform?[3,2]:(t=new OfficeCore.RequestContext,n=OfficeCore.AuthenticationService.newObject(t),n.onIdentityChanged.add(e),[4,t.sync()]);case 1:return o.sent(),[2,function(){return __awaiter(r,void 0,void 0,(function(){return __generator(this,(function(r){switch(r.label){case 0:return n.onIdentityChanged.remove(e),[4,t.sync()];case 1:return r.sent(),[2]}}))}))}];case 2:return[3,4];case 3:return o.sent(),[3,4];case 4:return[2,function(){return Promise.resolve()}]}}))}))},"undefined"!=typeof window&&window.OSF&&function(){try{if("undefined"==typeof window||!window.sessionStorage)return;var e=sessionStorage.getItem(t);null!==e&&-1!==e.indexOf(window.location.origin+window.location.pathname)&&c()}catch(e){console.error(e)}}()}(OfficeFirstPartyAuth||(OfficeFirstPartyAuth={})),function(e){!function(e){var t,n;!function(e){e[e.None=0]="None",e[e.Auto=1]="Auto",e[e.Force=2]="Force"}(t=e.PopupOptions||(e.PopupOptions={})),function(e){e[e.UnsupportedUserIdentity=13003]="UnsupportedUserIdentity",e[e.UserAborted=13004]="UserAborted",e[e.InteractionRequired=13005]="InteractionRequired",e[e.ClientError=13006]="ClientError",e[e.ServerError=13007]="ServerError",e[e.NotAvailable=13012]="NotAvailable",e[e.InternalError=5001]="InternalError",e[e.InvalidApiArguments=5013]="InvalidApiArguments"}(n=e.AuthErrorCode||(e.AuthErrorCode={}));var r={ACCOUNT_UNAVAILABLE:n.UnsupportedUserIdentity,USER_CANCEL:n.UserAborted,USER_INTERACTION_REQUIRED:n.InteractionRequired,PERSISTENT_ERROR:n.ClientError,NO_NETWORK:n.ServerError,TRANSIENT_ERROR:n.ServerError,NESTED_APP_AUTH_UNAVAILABLE:n.NotAvailable},o={POPUP_WINDOW_ERROR:n.ClientError,USER_CANCELLED:n.UserAborted},i="access_token",a="xms_cc",s=0,c=!1,l=!1,u=void 0,d=null,f=void 0;e.clientCapabilities=[],e.upnCheck=!0,e.timeout=void 0,e.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",e.debugging=!1,e.delay=0,e.delayMsal=0,e.useMsal3=void 0;var p={},g=function(e){try{var t="string"==typeof e?e:e.data,o=JSON.parse(t);if(o.requestId){var i=o.requestId;if(p.hasOwnProperty(i)){var a=n.InternalError,s=p[i],c=s[0],l=s[1];delete p[i];var u=o.token;if(u&&!0===o.success&&u.access_token&&"number"==typeof u.expires_in)return void c({accessToken:u.access_token,expiresOn:new Date(Date.now()+1e3*u.expires_in)});var d=o.error;if(d){var f=d.status;r[f]&&(a=r[f])}l({code:a})}}}catch(e){}},h={code:n.NotAvailable};function m(t){if(0===e.clientCapabilities.length)return t;var n={};if(t)try{n=JSON.parse(t)}catch(e){}return n.hasOwnProperty(i)||(n[i]={}),n[i][a]={values:e.clientCapabilities},JSON.stringify(n)}function y(e,t){var r=e.clientId||f,i=e.correlationId||OSF.OUtil.Guid.generateNewGuid(),a=Date.now(),d=function(e){var n=function(e,n){var o=Date.now()-a;!function(e,t,n,r,o,i){if(s>0&&!n)return;s++,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var o=[oteljs.makeStringDataField("AppId",e),oteljs.makeStringDataField("CorrelationId",t),oteljs.makeBooleanDataField("Popup",n),oteljs.makeInt64DataField("Duration",r),oteljs.makeInt64DataField("ErrorCode",i?i.code:0),oteljs.makeBooleanDataField("BridgeAvailable",v())];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.NestedAppAuth.GetAccessToken",dataFields:o,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}(r,i,t,o,0,n)};return e.then((function(e){n(0,null)})).catch((function(e){n(0,e)})),e};return v()?d(new Promise((function(n,o){var a=OSF.OUtil.Guid.generateNewGuid(),s=e.scopes.join(" "),l={messageType:"NestedAppAuthRequest",method:t?"GetTokenPopup":"GetToken",requestId:a,clientLibrary:"officejs",sendTime:Date.now(),tokenParams:{clientId:r,scope:s,correlationId:i,claims:m(e.claims)}};c||(nestedAppAuthBridge.addEventListener("message",g),c=!0),p[a]=[n,o],nestedAppAuthBridge.postMessage(JSON.stringify(l))}))):d(u?u.then((function(){if(!l)return Promise.reject(h);var a=e.scopes.join(" ");return a=a.replace(/(\/.default)$/,""),OSF.WebAuth.getToken(a,e.scopes,r,i,t,e.claims).then((function(e){return{accessToken:e.Token,expiresOn:e.MsalResult?e.MsalResult.expiresOn:void 0}})).catch((function(e){var t=n.InternalError,r=void 0;if(e)if(r=e.ErrorMessage,e.MsalResult&&"InteractionRequiredAuthError"===e.MsalResult.name)t=n.InteractionRequired;else if(e.ErrorCode){var i=e.ErrorCode.toUpperCase();o[i]&&(t=o[i])}return Promise.reject({code:t,description:r})}))})):Promise.reject(h))}function v(){return"undefined"!=typeof nestedAppAuthBridge}e.isBridgeAvailable=v,e.load=function(t,n,r,o){return f=t,o&&(e.clientCapabilities=o),u||(u=new Promise((function(i,a){if(v())i();else if(Office&&Office.context&&Office.context.auth&&OSF.WebAuth)try{Office.context.auth.getAuthContextAsync((function(s){if("succeeded"===s.status){if(!(d=s.value))return void a(h);OSF.WebAuth.config={authFlow:"authcode",authVersion:e.authVersion?e.authVersion:null,msal:e.msal,delayWebAuth:e.delay,delayMsal:e.delayMsal,debugging:e.debugging,useMsal3:e.useMsal3,authority:e.authorityOverride?e.authorityOverride:d.authorityBaseUrl,idp:"msa"===d.authorityType.toLowerCase()?"msa":"aad",appIds:[t],redirectUri:n||null,upn:d.userPrincipalName,prefetch:r,telemetryInstance:"otel",enableUpnCheck:e.upnCheck,enableConsoleLogging:e.debugging,checkActiveAccount:!0,tenantId:d.tenantId,timeout:e.timeout,clientCapabilities:o},OSF.WebAuth.load().then((function(e){l=!0,i()})).catch((function(e){a(__assign({},h,{description:e instanceof Event?e.type:void 0}))}))}else a(h)}))}catch(e){a(h)}else a(h)})))},e.getAccessToken=function(e){var r=null==e.popup?t.None:e.popup;if(r===t.Auto&&!e.directUserActionCallback)throw{code:n.InvalidApiArguments};return y(e,r===t.Force).catch((function(o){if(o.code==n.InteractionRequired&&r===t.Auto&&e.directUserActionCallback)return e.directUserActionCallback().then((function(t){if(t)return y(e,!0);throw{code:n.UserAborted}})).catch((function(){throw{code:n.UserAborted}}));throw o}))}}(e.NestedAppAuth||(e.NestedAppAuth={}))}(OfficeFirstPartyAuth||(OfficeFirstPartyAuth={})),function(e){var t,n="Office",r=OfficeExtension.BatchApiHelper.createPropertyObject,o=OfficeExtension.BatchApiHelper.createMethodObject,i=OfficeExtension.BatchApiHelper.createIndexerObject,a=(OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject),s=OfficeExtension.BatchApiHelper.createChildItemObject,c=OfficeExtension.BatchApiHelper.invokeMethod,l=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,u=OfficeExtension.BatchApiHelper.invokeSetProperty,d=OfficeExtension.Utility.isNullOrUndefined,f=OfficeExtension.Utility.isUndefined,p=OfficeExtension.Utility.throwIfNotLoaded,g=OfficeExtension.Utility.throwIfApiNotSupported,h=OfficeExtension.Utility.load,m=OfficeExtension.Utility.retrieve,y=OfficeExtension.Utility.toJson,v=OfficeExtension.Utility.fixObjectPathIfNecessary,b=OfficeExtension.Utility._handleNavigationPropertyResults,C=OfficeExtension.Utility.adjustToDateTime,_=OfficeExtension.Utility.processRetrieveResult,O=OfficeExtension.Utility.setMockData,S=OfficeExtension.CommonUtility.calculateApiFlags,A=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"DialogPage"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_Id",{get:function(){return p("_Id",this.__I,"DialogPage",this._isNull),this.__I},enumerable:!0,configurable:!0}),n.prototype.close=function(){c(this,"Close",1,[],4,0)},n.prototype.readyToShow=function(){c(this,"ReadyToShow",1,[],4,0)},n.prototype.registerOnShow=function(){c(this,"RegisterOnShow",1,[],4,0)},n.prototype.sendMessageToHost=function(e){c(this,"SendMessageToHost",1,[e],4,0)},n.prototype.unregisterOnShow=function(){c(this,"UnregisterOnShow",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n._Id)||(this.__I=n._Id)}},n.prototype.load=function(e){return h(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),d(e)||f(e._Id)||(this.__I=e._Id)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.DialogPage,t,"Microsoft.Office.DialogPage.DialogPage",!1,4)},Object.defineProperty(n.prototype,"onOnShowEvent",{get:function(){var e=this;return this.m_onShowEvent||(this.m_onShowEvent=new OfficeExtension.GenericEventHandlers(this.context,this,"OnShowEvent",{eventType:1,registerFunc:function(){return e.registerOnShow()},unregisterFunc:function(){return e.unregisterOnShow()},getTargetIdFunc:function(){return e._Id},eventArgsTransformFunc:function(e){return OfficeExtension.Utility._createPromiseFromResult({})}})),this.m_onShowEvent},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.DialogPage=A,function(e){e.unknown="Unknown",e.basic="Basic",e.premium="Premium"}(t=e.LicenseFeatureTier||(e.LicenseFeatureTier={}));var E=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"License"},enumerable:!0,configurable:!0}),n.prototype.getFeatureTier=function(e,t){return c(this,"GetFeatureTier",1,[e,t],4,0)},n.prototype.getLicenseFeature=function(t){return o(e.LicenseFeature,this,"GetLicenseFeature",1,[t],!1,!1,null,4)},n.prototype.getMsaDeviceTicket=function(e,t,n){return c(this,"GetMsaDeviceTicket",1,[e,t,n],5,0)},n.prototype.isFeatureEnabled=function(e,t){return c(this,"IsFeatureEnabled",1,[e,t],4,0)},n.prototype.isFreemiumUpsellEnabled=function(){return c(this,"IsFreemiumUpsellEnabled",1,[],4,0)},n.prototype.launchUpsellExperience=function(e){c(this,"LaunchUpsellExperience",1,[e],4,0)},n.prototype._TestFireStateChangedEvent=function(e){c(this,"_TestFireStateChangedEvent",0,[e],1,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.License,t,"Microsoft.Office.Licensing.License",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.License=E;var P,R=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"LicenseFeature"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,"LicenseFeature",this._isNull),this._I},enumerable:!0,configurable:!0}),t.prototype._RegisterStateChange=function(){c(this,"_RegisterStateChange",1,[],4,0)},t.prototype._UnregisterStateChange=function(){c(this,"_UnregisterStateChange",1,[],4,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Id)||(this._I=n.Id)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),d(t)||f(t.Id)||(this._I=t.Id)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},Object.defineProperty(t.prototype,"onStateChanged",{get:function(){var e=this;return this.m_stateChanged||(this.m_stateChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"StateChanged",{eventType:1,registerFunc:function(){return e._RegisterStateChange()},unregisterFunc:function(){return e._UnregisterStateChange()},getTargetIdFunc:function(){return e.id},eventArgsTransformFunc:function(t){var n=P.LicenseFeature_StateChanged_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_stateChanged},enumerable:!0,configurable:!0}),t.prototype.toJSON=function(){return y(this,{id:this._I},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.LicenseFeature=R,function(e){e.LicenseFeature_StateChanged_EventArgsTransform=function(e,n){var r={feature:n.featureName,isEnabled:n.isEnabled,tier:n.tierName};return n.tierName&&(r.tier=0==n.tierName?t.unknown:1==n.tierName?t.basic:2==n.tierName?t.premium:n.tierName),r}}(P=e._CC||(e._CC={}));var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"MsaDeviceTicketOptions"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["scopes"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Scopes"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"scopes",{get:function(){return p("scopes",this._S,"MsaDeviceTicketOptions",this._isNull),this._S},set:function(e){this._S=e,u(this,"Scopes",e,0)},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,["scopes"],[],[])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.Scopes)||(this._S=n.Scopes)}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.MsaDeviceTicketOptions,t,"Microsoft.Office.Licensing.MsaDeviceTicketOptions",!1,4)},n.prototype.toJSON=function(){return y(this,{scopes:this._S},{})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.MsaDeviceTicketOptions=T;var I=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"AppRuntimePersistenceService"},enumerable:!0,configurable:!0}),n.prototype.getAppRuntimeStartState=function(){return c(this,"GetAppRuntimeStartState",1,[],4,0)},n.prototype.setAppRuntimeStartState=function(e){c(this,"SetAppRuntimeStartState",0,[e],S(2,"SharedRuntimeInternal","1.2"),0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.AppRuntimePersistenceService,t,"Microsoft.AppRuntime.AppRuntimePersistenceService",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.AppRuntimePersistenceService=I;var w=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return __extends(r,t),Object.defineProperty(r.prototype,"_className",{get:function(){return"AppRuntimeService"},enumerable:!0,configurable:!0}),r.prototype.getAppRuntimeState=function(){return c(this,"GetAppRuntimeState",1,[],4,0)},r.prototype.getContentSnapshotAsBase64=function(){return g("AppRuntimeService.getContentSnapshotAsBase64","SnapshotControl","1.1",n),c(this,"GetContentSnapshotAsBase64",1,[],4,0)},r.prototype.getSnapshotEnabled=function(){return g("AppRuntimeService.getSnapshotEnabled","SnapshotControl","1.1",n),c(this,"GetSnapshotEnabled",1,[],4,0)},r.prototype.setAppRuntimeState=function(e){c(this,"SetAppRuntimeState",0,[e],S(2,"SharedRuntimeInternal","1.2"),0)},r.prototype.setSnapshotEnabled=function(e){g("AppRuntimeService.setSnapshotEnabled","SnapshotControl","1.1",n),c(this,"SetSnapshotEnabled",1,[e],4,0)},r.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},r.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},r.newObject=function(t){return a(e.AppRuntimeService,t,"Microsoft.AppRuntime.AppRuntimeService",!1,4)},Object.defineProperty(r.prototype,"onSnapshotImageReady",{get:function(){return g("AppRuntimeService.onSnapshotImageReady","SnapshotControl","1.1",n),this.m_snapshotImageReady||(this.m_snapshotImageReady=new OfficeExtension.GenericEventHandlers(this.context,this,"SnapshotImageReady",{eventType:65547,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={imageBase64:e.imageBase64};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_snapshotImageReady},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"onVisibilityChanged",{get:function(){return this.m_visibilityChanged||(this.m_visibilityChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"VisibilityChanged",{eventType:65539,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={visibility:e.visibility};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_visibilityChanged},enumerable:!0,configurable:!0}),r.prototype.toJSON=function(){return y(this,{},{})},r}(OfficeExtension.ClientObject);e.AppRuntimeService=w,function(e){e.inactive="Inactive",e.background="Background",e.visible="Visible"}(e.AppRuntimeState||(e.AppRuntimeState={})),function(e){e.hidden="Hidden",e.visible="Visible"}(e.Visibility||(e.Visibility={}));var F=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ThemeService"},enumerable:!0,configurable:!0}),n.prototype.registerOfficeThemeChangedEvent=function(){c(this,"RegisterOfficeThemeChangedEvent",0,[],0,0)},n.prototype.unregisterOfficeThemeChangedEvent=function(){c(this,"UnregisterOfficeThemeChangedEvent",0,[],0,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ThemeService,t,"Microsoft.Theme.ThemeService",!1,4)},Object.defineProperty(n.prototype,"onOfficeThemeChanged",{get:function(){var e=this;return this.m_officeThemeChanged||(this.m_officeThemeChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"OfficeThemeChanged",{eventType:65548,registerFunc:function(){return e.registerOfficeThemeChangedEvent()},unregisterFunc:function(){return e.unregisterOfficeThemeChangedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(t){var n=P.ThemeService_OfficeThemeChanged_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_officeThemeChanged},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ThemeService=F,function(e){e.ThemeService_OfficeThemeChanged_EventArgsTransform=function(e,t){return{bodyBackgroundColor:t.bodyBackgroundColor,bodyForegroundColor:t.bodyForegroundColor,controlBackgroundColor:t.controlBackgroundColor,controlForegroundColor:t.controlForegroundColor}}}(P=e._CC||(e._CC={}));var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"Tap"},enumerable:!0,configurable:!0}),n.prototype.getEnterpriseUserInfo=function(){return c(this,"GetEnterpriseUserInfo",1,[],5,0)},n.prototype.getMruFriendlyPath=function(e){return c(this,"GetMruFriendlyPath",1,[e],5,0)},n.prototype.launchFileUrlInOfficeApp=function(e,t){return c(this,"LaunchFileUrlInOfficeApp",1,[e,t],5,0)},n.prototype.performLocalSearch=function(e,t,n,r){return c(this,"PerformLocalSearch",1,[e,t,n,r],5,0)},n.prototype.readSearchCache=function(e,t,n){return c(this,"ReadSearchCache",1,[e,t,n],5,0)},n.prototype.writeSearchCache=function(e,t,n){return c(this,"WriteSearchCache",1,[e,t,n],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.Tap,t,"Microsoft.TapRichApi.Tap",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.Tap=D,function(e){e.unknown="Unknown",e.chart="Chart",e.smartArt="SmartArt",e.table="Table",e.image="Image",e.slide="Slide",e.ole="OLE",e.text="Text"}(e.ObjectType||(e.ObjectType={})),function(e){e.placeHolderRendered="PlaceHolderRendered",e.initialCardRendered="InitialCardRendered"}(e.PersonaCardPerfPoint||(e.PersonaCardPerfPoint={})),function(e){e.notSet="NotSet",e.free="Free",e.idle="Idle",e.busy="Busy",e.idleBusy="IdleBusy",e.doNotDisturb="DoNotDisturb",e.unalertable="Unalertable",e.unavailable="Unavailable"}(e.UnifiedCommunicationAvailability||(e.UnifiedCommunicationAvailability={})),function(e){e.online="Online",e.notOnline="NotOnline",e.away="Away",e.busy="Busy",e.beRightBack="BeRightBack",e.onThePhone="OnThePhone",e.outToLunch="OutToLunch",e.inAMeeting="InAMeeting",e.outOfOffice="OutOfOffice",e.doNotDisturb="DoNotDisturb",e.inAConference="InAConference",e.getting="Getting",e.notABuddy="NotABuddy",e.disconnected="Disconnected",e.notInstalled="NotInstalled",e.urgentInterruptionsOnly="UrgentInterruptionsOnly",e.mayBeAvailable="MayBeAvailable",e.idle="Idle",e.inPresentation="InPresentation"}(e.UnifiedCommunicationStatus||(e.UnifiedCommunicationStatus={})),function(e){e.free="Free",e.busy="Busy",e.idle="Idle",e.doNotDistrub="DoNotDistrub",e.blocked="Blocked",e.notSet="NotSet",e.outOfOffice="OutOfOffice"}(e.UnifiedCommunicationPresence||(e.UnifiedCommunicationPresence={})),function(e){e.unknown="Unknown",e.free="Free",e.busy="Busy",e.elsewhere="Elsewhere",e.tentative="Tentative",e.outOfOffice="OutOfOffice"}(e.FreeBusyCalendarState||(e.FreeBusyCalendarState={})),function(e){e.unknown="Unknown",e.enterprise="Enterprise",e.contact="Contact",e.bot="Bot",e.phoneOnly="PhoneOnly",e.oneOff="OneOff",e.distributionList="DistributionList",e.personalDistributionList="PersonalDistributionList",e.anonymous="Anonymous",e.unifiedGroup="UnifiedGroup"}(e.PersonaType||(e.PersonaType={})),function(e){e.workPhone="WorkPhone",e.homePhone="HomePhone",e.mobilePhone="MobilePhone",e.businessFax="BusinessFax",e.otherPhone="OtherPhone"}(e.PhoneType||(e.PhoneType={})),function(e){e.workAddress="WorkAddress",e.homeAddress="HomeAddress",e.otherAddress="OtherAddress"}(e.AddressType||(e.AddressType={})),function(e){e.unknown="Unknown",e.individual="Individual",e.group="Group"}(e.MemberType||(e.MemberType={}));var x,k="MemberInfoList",N=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"MemberInfoList"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["isWarmedUp","isWarmingUp"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["IsWarmedUp","IsWarmingUp"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isWarmedUp",{get:function(){return p("isWarmedUp",this._I,k,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isWarmingUp",{get:function(){return p("isWarmingUp",this._Is,k,this._isNull),this._Is},enumerable:!0,configurable:!0}),n.prototype.getPersonaForMember=function(t){return o(e.Persona,this,"GetPersonaForMember",1,[t],!1,!1,null,4)},n.prototype.items=function(){return c(this,"Items",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.IsWarmedUp)||(this._I=n.IsWarmedUp),f(n.IsWarmingUp)||(this._Is=n.IsWarmingUp)}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.prototype.toJSON=function(){return y(this,{isWarmedUp:this._I,isWarmingUp:this._Is},{})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.MemberInfoList=N,function(e){e.hostId="HostId",e.type="Type",e.photo="Photo",e.personaInfo="PersonaInfo",e.unifiedCommunicationInfo="UnifiedCommunicationInfo",e.organization="Organization",e.unifiedGroupInfo="UnifiedGroupInfo",e.members="Members",e.membership="Membership",e.capabilities="Capabilities",e.customizations="Customizations",e.viewableSources="ViewableSources",e.placeholder="Placeholder"}(x=e.PersonaDataUpdated||(e.PersonaDataUpdated={}));var M=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"PersonaActions"},enumerable:!0,configurable:!0}),t.prototype.addContact=function(){c(this,"AddContact",0,[],0,0)},t.prototype.callPhoneNumber=function(e){c(this,"CallPhoneNumber",0,[e],0,0)},t.prototype.composeEmail=function(e){c(this,"ComposeEmail",0,[e],0,0)},t.prototype.composeInstantMessage=function(e){c(this,"ComposeInstantMessage",0,[e],0,0)},t.prototype.editContact=function(){c(this,"EditContact",0,[],0,0)},t.prototype.editContactByIdentifier=function(e){c(this,"EditContactByIdentifier",0,[e],0,0)},t.prototype.editUnifiedGroup=function(){c(this,"EditUnifiedGroup",0,[],0,0)},t.prototype.getChangePhotoUrlAndOpenInBrowser=function(){c(this,"GetChangePhotoUrlAndOpenInBrowser",0,[],0,0)},t.prototype.hideHoverCardForPersona=function(){c(this,"HideHoverCardForPersona",0,[],0,0)},t.prototype.joinUnifiedGroup=function(){c(this,"JoinUnifiedGroup",0,[],0,0)},t.prototype.leaveUnifiedGroup=function(){c(this,"LeaveUnifiedGroup",0,[],0,0)},t.prototype.openGroupCalendar=function(){c(this,"OpenGroupCalendar",0,[],0,0)},t.prototype.openLinkContactUx=function(){c(this,"OpenLinkContactUx",0,[],0,0)},t.prototype.openOutlookProperties=function(){c(this,"OpenOutlookProperties",0,[],0,0)},t.prototype.pinPersonaToQuickContacts=function(){c(this,"PinPersonaToQuickContacts",0,[],0,0)},t.prototype.scheduleMeeting=function(){c(this,"ScheduleMeeting",0,[],0,0)},t.prototype.showContactCard=function(e,t,n,r,o,i){c(this,"ShowContactCard",0,[e,t,n,r,o,i],0,0)},t.prototype.showContextMenu=function(e,t,n,r,o,i){c(this,"ShowContextMenu",0,[e,t,n,r,o,i],0,0)},t.prototype.showExpandedCard=function(e,t,n,r,o,i){c(this,"ShowExpandedCard",0,[e,t,n,r,o,i],0,0)},t.prototype.showHoverCardForPersona=function(e,t,n,r,o,i){c(this,"ShowHoverCardForPersona",0,[e,t,n,r,o,i],0,0)},t.prototype.startAudioCall=function(){c(this,"StartAudioCall",0,[],0,0)},t.prototype.startVideoCall=function(){c(this,"StartVideoCall",0,[],0,0)},t.prototype.subscribeToGroup=function(){c(this,"SubscribeToGroup",0,[],0,0)},t.prototype.toggleTagForAlerts=function(){c(this,"ToggleTagForAlerts",0,[],0,0)},t.prototype.unsubscribeFromGroup=function(){c(this,"UnsubscribeFromGroup",0,[],0,0)},t.prototype._handleResult=function(t){(e.prototype._handleResult.call(this,t),d(t))||v(this,t)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{},{})},t}(OfficeExtension.ClientObject);e.PersonaActions=M;var H="PersonaInfoSource",U=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"PersonaInfoSource"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["displayName","email","emailAddresses","sipAddresses","birthday","birthdays","title","jobInfoDepartment","companyName","office","linkedTitles","linkedDepartments","linkedCompanyNames","linkedOffices","phones","addresses","webSites","notes"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["DisplayName","Email","EmailAddresses","SipAddresses","Birthday","Birthdays","Title","JobInfoDepartment","CompanyName","Office","LinkedTitles","LinkedDepartments","LinkedCompanyNames","LinkedOffices","Phones","Addresses","WebSites","Notes"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"addresses",{get:function(){return p("addresses",this._A,H,this._isNull),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"birthday",{get:function(){return p("birthday",this._B,H,this._isNull),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"birthdays",{get:function(){return p("birthdays",this._Bi,H,this._isNull),this._Bi},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"companyName",{get:function(){return p("companyName",this._C,H,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"displayName",{get:function(){return p("displayName",this._D,H,this._isNull),this._D},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"email",{get:function(){return p("email",this._E,H,this._isNull),this._E},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"emailAddresses",{get:function(){return p("emailAddresses",this._Em,H,this._isNull),this._Em},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"jobInfoDepartment",{get:function(){return p("jobInfoDepartment",this._J,H,this._isNull),this._J},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"linkedCompanyNames",{get:function(){return p("linkedCompanyNames",this._L,H,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"linkedDepartments",{get:function(){return p("linkedDepartments",this._Li,H,this._isNull),this._Li},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"linkedOffices",{get:function(){return p("linkedOffices",this._Lin,H,this._isNull),this._Lin},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"linkedTitles",{get:function(){return p("linkedTitles",this._Link,H,this._isNull),this._Link},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"notes",{get:function(){return p("notes",this._N,H,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"office",{get:function(){return p("office",this._O,H,this._isNull),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"phones",{get:function(){return p("phones",this._P,H,this._isNull),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"sipAddresses",{get:function(){return p("sipAddresses",this._S,H,this._isNull),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"title",{get:function(){return p("title",this._T,H,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"webSites",{get:function(){return p("webSites",this._W,H,this._isNull),this._W},enumerable:!0,configurable:!0}),t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Addresses)||(this._A=n.Addresses),f(n.Birthday)||(this._B=n.Birthday),f(n.Birthdays)||(this._Bi=n.Birthdays),f(n.CompanyName)||(this._C=n.CompanyName),f(n.DisplayName)||(this._D=n.DisplayName),f(n.Email)||(this._E=n.Email),f(n.EmailAddresses)||(this._Em=n.EmailAddresses),f(n.JobInfoDepartment)||(this._J=n.JobInfoDepartment),f(n.LinkedCompanyNames)||(this._L=n.LinkedCompanyNames),f(n.LinkedDepartments)||(this._Li=n.LinkedDepartments),f(n.LinkedOffices)||(this._Lin=n.LinkedOffices),f(n.LinkedTitles)||(this._Link=n.LinkedTitles),f(n.Notes)||(this._N=n.Notes),f(n.Office)||(this._O=n.Office),f(n.Phones)||(this._P=n.Phones),f(n.SipAddresses)||(this._S=n.SipAddresses),f(n.Title)||(this._T=n.Title),f(n.WebSites)||(this._W=n.WebSites)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{addresses:this._A,birthday:this._B,birthdays:this._Bi,companyName:this._C,displayName:this._D,email:this._E,emailAddresses:this._Em,jobInfoDepartment:this._J,linkedCompanyNames:this._L,linkedDepartments:this._Li,linkedOffices:this._Lin,linkedTitles:this._Link,notes:this._N,office:this._O,phones:this._P,sipAddresses:this._S,title:this._T,webSites:this._W},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.PersonaInfoSource=U;var j="PersonaInfo",L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PersonaInfo"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["displayName","email","emailAddresses","sipAddresses","birthday","birthdays","title","jobInfoDepartment","companyName","office","linkedTitles","linkedDepartments","linkedCompanyNames","linkedOffices","webSites","notes","isPersonResolved"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["DisplayName","Email","EmailAddresses","SipAddresses","Birthday","Birthdays","Title","JobInfoDepartment","CompanyName","Office","LinkedTitles","LinkedDepartments","LinkedCompanyNames","LinkedOffices","WebSites","Notes","IsPersonResolved"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["sources"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sources",{get:function(){return this._So||(this._So=r(e.PersonaInfoSource,this,"Sources",!1,4)),this._So},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"birthday",{get:function(){return p("birthday",this._B,j,this._isNull),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"birthdays",{get:function(){return p("birthdays",this._Bi,j,this._isNull),this._Bi},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"companyName",{get:function(){return p("companyName",this._C,j,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"displayName",{get:function(){return p("displayName",this._D,j,this._isNull),this._D},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"email",{get:function(){return p("email",this._E,j,this._isNull),this._E},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"emailAddresses",{get:function(){return p("emailAddresses",this._Em,j,this._isNull),this._Em},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isPersonResolved",{get:function(){return p("isPersonResolved",this._I,j,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"jobInfoDepartment",{get:function(){return p("jobInfoDepartment",this._J,j,this._isNull),this._J},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"linkedCompanyNames",{get:function(){return p("linkedCompanyNames",this._L,j,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"linkedDepartments",{get:function(){return p("linkedDepartments",this._Li,j,this._isNull),this._Li},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"linkedOffices",{get:function(){return p("linkedOffices",this._Lin,j,this._isNull),this._Lin},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"linkedTitles",{get:function(){return p("linkedTitles",this._Link,j,this._isNull),this._Link},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"notes",{get:function(){return p("notes",this._N,j,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"office",{get:function(){return p("office",this._O,j,this._isNull),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sipAddresses",{get:function(){return p("sipAddresses",this._S,j,this._isNull),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"title",{get:function(){return p("title",this._T,j,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"webSites",{get:function(){return p("webSites",this._W,j,this._isNull),this._W},enumerable:!0,configurable:!0}),n.prototype.getAddresses=function(){return c(this,"GetAddresses",1,[],4,0)},n.prototype.getPhones=function(){return c(this,"GetPhones",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.Birthday)||(this._B=C(n.Birthday)),f(n.Birthdays)||(this._Bi=C(n.Birthdays)),f(n.CompanyName)||(this._C=n.CompanyName),f(n.DisplayName)||(this._D=n.DisplayName),f(n.Email)||(this._E=n.Email),f(n.EmailAddresses)||(this._Em=n.EmailAddresses),f(n.IsPersonResolved)||(this._I=n.IsPersonResolved),f(n.JobInfoDepartment)||(this._J=n.JobInfoDepartment),f(n.LinkedCompanyNames)||(this._L=n.LinkedCompanyNames),f(n.LinkedDepartments)||(this._Li=n.LinkedDepartments),f(n.LinkedOffices)||(this._Lin=n.LinkedOffices),f(n.LinkedTitles)||(this._Link=n.LinkedTitles),f(n.Notes)||(this._N=n.Notes),f(n.Office)||(this._O=n.Office),f(n.SipAddresses)||(this._S=n.SipAddresses),f(n.Title)||(this._T=n.Title),f(n.WebSites)||(this._W=n.WebSites),b(this,n,["sources","Sources"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){if(t.prototype._handleRetrieveResult.call(this,e,n),!d(e)){var r=e;f(r.Birthday)||(r.birthday=C(r.birthday)),f(r.Birthdays)||(r.birthdays=C(r.birthdays)),_(this,e,n)}},n.prototype.toJSON=function(){return y(this,{birthday:this._B,birthdays:this._Bi,companyName:this._C,displayName:this._D,email:this._E,emailAddresses:this._Em,isPersonResolved:this._I,jobInfoDepartment:this._J,linkedCompanyNames:this._L,linkedDepartments:this._Li,linkedOffices:this._Lin,linkedTitles:this._Link,notes:this._N,office:this._O,sipAddresses:this._S,title:this._T,webSites:this._W},{sources:this._So})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.PersonaInfo=L;var B="PersonaUnifiedCommunicationInfo",W=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"PersonaUnifiedCommunicationInfo"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["availability","status","isSelf","isTagged","customStatusString","isBlocked","presenceTooltip","isOutOfOffice","outOfOfficeNote","timezone","meetingLocation","meetingSubject","timezoneBias","idleStartTime","overallCapability","isOnBuddyList","presenceNote","voiceMailUri","availabilityText","availabilityTooltip","isDurationInAvailabilityText","freeBusyStatus","calendarState","presence"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Availability","Status","IsSelf","IsTagged","CustomStatusString","IsBlocked","PresenceTooltip","IsOutOfOffice","OutOfOfficeNote","Timezone","MeetingLocation","MeetingSubject","TimezoneBias","IdleStartTime","OverallCapability","IsOnBuddyList","PresenceNote","VoiceMailUri","AvailabilityText","AvailabilityTooltip","IsDurationInAvailabilityText","FreeBusyStatus","CalendarState","Presence"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"availability",{get:function(){return p("availability",this._A,B,this._isNull),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"availabilityText",{get:function(){return p("availabilityText",this._Av,B,this._isNull),this._Av},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"availabilityTooltip",{get:function(){return p("availabilityTooltip",this._Ava,B,this._isNull),this._Ava},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"calendarState",{get:function(){return p("calendarState",this._C,B,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"customStatusString",{get:function(){return p("customStatusString",this._Cu,B,this._isNull),this._Cu},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"freeBusyStatus",{get:function(){return p("freeBusyStatus",this._F,B,this._isNull),this._F},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"idleStartTime",{get:function(){return p("idleStartTime",this._I,B,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isBlocked",{get:function(){return p("isBlocked",this._Is,B,this._isNull),this._Is},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isDurationInAvailabilityText",{get:function(){return p("isDurationInAvailabilityText",this._IsD,B,this._isNull),this._IsD},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isOnBuddyList",{get:function(){return p("isOnBuddyList",this._IsO,B,this._isNull),this._IsO},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isOutOfOffice",{get:function(){return p("isOutOfOffice",this._IsOu,B,this._isNull),this._IsOu},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isSelf",{get:function(){return p("isSelf",this._IsS,B,this._isNull),this._IsS},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isTagged",{get:function(){return p("isTagged",this._IsT,B,this._isNull),this._IsT},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"meetingLocation",{get:function(){return p("meetingLocation",this._M,B,this._isNull),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"meetingSubject",{get:function(){return p("meetingSubject",this._Me,B,this._isNull),this._Me},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"outOfOfficeNote",{get:function(){return p("outOfOfficeNote",this._O,B,this._isNull),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"overallCapability",{get:function(){return p("overallCapability",this._Ov,B,this._isNull),this._Ov},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"presence",{get:function(){return p("presence",this._P,B,this._isNull),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"presenceNote",{get:function(){return p("presenceNote",this._Pr,B,this._isNull),this._Pr},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"presenceTooltip",{get:function(){return p("presenceTooltip",this._Pre,B,this._isNull),this._Pre},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"status",{get:function(){return p("status",this._S,B,this._isNull),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"timezone",{get:function(){return p("timezone",this._T,B,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"timezoneBias",{get:function(){return p("timezoneBias",this._Ti,B,this._isNull),this._Ti},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"voiceMailUri",{get:function(){return p("voiceMailUri",this._V,B,this._isNull),this._V},enumerable:!0,configurable:!0}),t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Availability)||(this._A=n.Availability),f(n.AvailabilityText)||(this._Av=n.AvailabilityText),f(n.AvailabilityTooltip)||(this._Ava=n.AvailabilityTooltip),f(n.CalendarState)||(this._C=n.CalendarState),f(n.CustomStatusString)||(this._Cu=n.CustomStatusString),f(n.FreeBusyStatus)||(this._F=n.FreeBusyStatus),f(n.IdleStartTime)||(this._I=C(n.IdleStartTime)),f(n.IsBlocked)||(this._Is=n.IsBlocked),f(n.IsDurationInAvailabilityText)||(this._IsD=n.IsDurationInAvailabilityText),f(n.IsOnBuddyList)||(this._IsO=n.IsOnBuddyList),f(n.IsOutOfOffice)||(this._IsOu=n.IsOutOfOffice),f(n.IsSelf)||(this._IsS=n.IsSelf),f(n.IsTagged)||(this._IsT=n.IsTagged),f(n.MeetingLocation)||(this._M=n.MeetingLocation),f(n.MeetingSubject)||(this._Me=n.MeetingSubject),f(n.OutOfOfficeNote)||(this._O=n.OutOfOfficeNote),f(n.OverallCapability)||(this._Ov=n.OverallCapability),f(n.Presence)||(this._P=n.Presence),f(n.PresenceNote)||(this._Pr=n.PresenceNote),f(n.PresenceTooltip)||(this._Pre=n.PresenceTooltip),f(n.Status)||(this._S=n.Status),f(n.Timezone)||(this._T=n.Timezone),f(n.TimezoneBias)||(this._Ti=n.TimezoneBias),f(n.VoiceMailUri)||(this._V=n.VoiceMailUri)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleRetrieveResult=function(t,n){if(e.prototype._handleRetrieveResult.call(this,t,n),!d(t)){var r=t;f(r.IdleStartTime)||(r.idleStartTime=C(r.idleStartTime)),_(this,t,n)}},t.prototype.toJSON=function(){return y(this,{availability:this._A,availabilityText:this._Av,availabilityTooltip:this._Ava,calendarState:this._C,customStatusString:this._Cu,freeBusyStatus:this._F,idleStartTime:this._I,isBlocked:this._Is,isDurationInAvailabilityText:this._IsD,isOnBuddyList:this._IsO,isOutOfOffice:this._IsOu,isSelf:this._IsS,isTagged:this._IsT,meetingLocation:this._M,meetingSubject:this._Me,outOfOfficeNote:this._O,overallCapability:this._Ov,presence:this._P,presenceNote:this._Pr,presenceTooltip:this._Pre,status:this._S,timezone:this._T,timezoneBias:this._Ti,voiceMailUri:this._V},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.PersonaUnifiedCommunicationInfo=W;var V=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"PersonaPhotoInfo"},enumerable:!0,configurable:!0}),t.prototype.getImageUri=function(e){return c(this,"getImageUri",1,[e],4,0)},t.prototype.getImageUriWithMetadata=function(e){return c(this,"getImageUriWithMetadata",1,[e],4,0)},t.prototype.getPlaceholderUri=function(e){return c(this,"getPlaceholderUri",1,[e],4,0)},t.prototype.setPlaceholderColor=function(e){c(this,"setPlaceholderColor",0,[e],0,0)},t.prototype._handleResult=function(t){(e.prototype._handleResult.call(this,t),d(t))||v(this,t)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{},{})},t}(OfficeExtension.ClientObject);e.PersonaPhotoInfo=V;var q=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PersonaCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,"PersonaCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),n.prototype.getCount=function(){return c(this,"GetCount",1,[],4,0)},n.prototype.getItem=function(t){return i(e.Persona,this,[t])},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!d(n)){var r=n;if(v(this,r),!d(r[OfficeExtension.Constants.items])){this.m__items=[];for(var o=r[OfficeExtension.Constants.items],i=0;i<o.length;i++){var a=s(e.Persona,!0,this,o[i],i);a._handleResult(o[i]),this.m__items.push(a)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(n,r){var o=this;t.prototype._handleRetrieveResult.call(this,n,r),_(this,n,r,(function(t,n){return s(e.Persona,!0,o,t,n)}))},n.prototype.toJSON=function(){return y(this,{},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;O(this,t,(function(t,r){return s(e.Persona,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.PersonaCollection=q;var G="PersonaOrganizationInfo",z=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PersonaOrganizationInfo"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["isWarmedUp","isWarmingUp"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["IsWarmedUp","IsWarmingUp"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["hierarchy","manager","directReports"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"directReports",{get:function(){return this._D||(this._D=r(e.PersonaCollection,this,"DirectReports",!0,4)),this._D},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"hierarchy",{get:function(){return this._H||(this._H=r(e.PersonaCollection,this,"Hierarchy",!0,4)),this._H},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"manager",{get:function(){return this._M||(this._M=r(e.Persona,this,"Manager",!1,4)),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isWarmedUp",{get:function(){return p("isWarmedUp",this._I,G,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isWarmingUp",{get:function(){return p("isWarmingUp",this._Is,G,this._isNull),this._Is},enumerable:!0,configurable:!0}),n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.IsWarmedUp)||(this._I=n.IsWarmedUp),f(n.IsWarmingUp)||(this._Is=n.IsWarmingUp),b(this,n,["directReports","DirectReports","hierarchy","Hierarchy","manager","Manager"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.prototype.toJSON=function(){return y(this,{isWarmedUp:this._I,isWarmingUp:this._Is},{})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.PersonaOrganizationInfo=z,function(e){e.email="Email",e.workPhone="WorkPhone",e.workPhone2="WorkPhone2",e.workFax="WorkFax",e.mobilePhone="MobilePhone",e.homePhone="HomePhone",e.homePhone2="HomePhone2",e.otherPhone="OtherPhone",e.sipAddress="SipAddress",e.profile="Profile",e.office="Office",e.company="Company",e.workAddress="WorkAddress",e.homeAddress="HomeAddress",e.otherAddress="OtherAddress",e.birthday="Birthday"}(e.CustomizedData||(e.CustomizedData={}));var J="UnifiedGroupInfo",K=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"UnifiedGroupInfo"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["description","oneDrive","oneNote","isPublic","amIOwner","amIMember","amISubscribed","memberCount","ownerCount","hasGuests","site","planner","classification","subscriptionEnabled"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Description","OneDrive","OneNote","IsPublic","AmIOwner","AmIMember","AmISubscribed","MemberCount","OwnerCount","HasGuests","Site","Planner","Classification","SubscriptionEnabled"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"amIMember",{get:function(){return p("amIMember",this._A,J,this._isNull),this._A},set:function(e){this._A=e,u(this,"AmIMember",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"amIOwner",{get:function(){return p("amIOwner",this._Am,J,this._isNull),this._Am},set:function(e){this._Am=e,u(this,"AmIOwner",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"amISubscribed",{get:function(){return p("amISubscribed",this._AmI,J,this._isNull),this._AmI},set:function(e){this._AmI=e,u(this,"AmISubscribed",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"classification",{get:function(){return p("classification",this._C,J,this._isNull),this._C},set:function(e){this._C=e,u(this,"Classification",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"description",{get:function(){return p("description",this._D,J,this._isNull),this._D},set:function(e){this._D=e,u(this,"Description",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasGuests",{get:function(){return p("hasGuests",this._H,J,this._isNull),this._H},set:function(e){this._H=e,u(this,"HasGuests",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isPublic",{get:function(){return p("isPublic",this._I,J,this._isNull),this._I},set:function(e){this._I=e,u(this,"IsPublic",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"memberCount",{get:function(){return p("memberCount",this._M,J,this._isNull),this._M},set:function(e){this._M=e,u(this,"MemberCount",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"oneDrive",{get:function(){return p("oneDrive",this._O,J,this._isNull),this._O},set:function(e){this._O=e,u(this,"OneDrive",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"oneNote",{get:function(){return p("oneNote",this._On,J,this._isNull),this._On},set:function(e){this._On=e,u(this,"OneNote",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ownerCount",{get:function(){return p("ownerCount",this._Ow,J,this._isNull),this._Ow},set:function(e){this._Ow=e,u(this,"OwnerCount",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"planner",{get:function(){return p("planner",this._P,J,this._isNull),this._P},set:function(e){this._P=e,u(this,"Planner",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"site",{get:function(){return p("site",this._S,J,this._isNull),this._S},set:function(e){this._S=e,u(this,"Site",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"subscriptionEnabled",{get:function(){return p("subscriptionEnabled",this._Su,J,this._isNull),this._Su},set:function(e){this._Su=e,u(this,"SubscriptionEnabled",e,0)},enumerable:!0,configurable:!0}),t.prototype.set=function(e,t){this._recursivelySet(e,t,["description","oneDrive","oneNote","isPublic","amIOwner","amIMember","amISubscribed","memberCount","ownerCount","hasGuests","site","planner","classification","subscriptionEnabled"],[],[])},t.prototype.update=function(e){this._recursivelyUpdate(e)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.AmIMember)||(this._A=n.AmIMember),f(n.AmIOwner)||(this._Am=n.AmIOwner),f(n.AmISubscribed)||(this._AmI=n.AmISubscribed),f(n.Classification)||(this._C=n.Classification),f(n.Description)||(this._D=n.Description),f(n.HasGuests)||(this._H=n.HasGuests),f(n.IsPublic)||(this._I=n.IsPublic),f(n.MemberCount)||(this._M=n.MemberCount),f(n.OneDrive)||(this._O=n.OneDrive),f(n.OneNote)||(this._On=n.OneNote),f(n.OwnerCount)||(this._Ow=n.OwnerCount),f(n.Planner)||(this._P=n.Planner),f(n.Site)||(this._S=n.Site),f(n.SubscriptionEnabled)||(this._Su=n.SubscriptionEnabled)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{amIMember:this._A,amIOwner:this._Am,amISubscribed:this._AmI,classification:this._C,description:this._D,hasGuests:this._H,isPublic:this._I,memberCount:this._M,oneDrive:this._O,oneNote:this._On,ownerCount:this._Ow,planner:this._P,site:this._S,subscriptionEnabled:this._Su},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.UnifiedGroupInfo=K;var Q,X="Persona";!function(e){e[e.immediate=0]="immediate",e[e.load=3]="load"}(Q=e.PersonaPromiseType||(e.PersonaPromiseType={}));var Y=function(){};e.PersonaInfoAndSource=Y;var $=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"Persona"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["hostId","type","capabilities","diagnosticId","instanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["HostId","Type","Capabilities","DiagnosticId","InstanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["photo","personaInfo","unifiedCommunicationInfo","organization","unifiedGroupInfo","actions"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"actions",{get:function(){return this._A||(this._A=r(e.PersonaActions,this,"Actions",!1,4)),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"organization",{get:function(){return this._O||(this._O=r(e.PersonaOrganizationInfo,this,"Organization",!1,4)),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"personaInfo",{get:function(){return this._P||(this._P=r(e.PersonaInfo,this,"PersonaInfo",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"photo",{get:function(){return this._Ph||(this._Ph=r(e.PersonaPhotoInfo,this,"Photo",!1,4)),this._Ph},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"unifiedCommunicationInfo",{get:function(){return this._U||(this._U=r(e.PersonaUnifiedCommunicationInfo,this,"UnifiedCommunicationInfo",!1,4)),this._U},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"unifiedGroupInfo",{get:function(){return this._Un||(this._Un=r(e.UnifiedGroupInfo,this,"UnifiedGroupInfo",!1,4)),this._Un},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"capabilities",{get:function(){return p("capabilities",this._C,X,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"diagnosticId",{get:function(){return p("diagnosticId",this._D,X,this._isNull),this._D},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"hostId",{get:function(){return p("hostId",this._H,X,this._isNull),this._H},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"instanceId",{get:function(){return p("instanceId",this._I,X,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"type",{get:function(){return p("type",this._T,X,this._isNull),this._T},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["unifiedGroupInfo"],["actions","organization","personaInfo","photo","unifiedCommunicationInfo"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype.dispose=function(){c(this,"Dispose",0,[],0,0)},n.prototype.getCustomizations=function(){return c(this,"GetCustomizations",1,[],4,0)},n.prototype.getMembers=function(){return o(e.MemberInfoList,this,"GetMembers",1,[],!1,!1,null,4)},n.prototype.getMembership=function(){return o(e.MemberInfoList,this,"GetMembership",1,[],!1,!1,null,4)},n.prototype.getViewableSources=function(){return c(this,"GetViewableSources",1,[],4,0)},n.prototype.reportTimeForRender=function(e,t){c(this,"ReportTimeForRender",0,[e,t],0,0)},n.prototype.warmup=function(e){c(this,"Warmup",0,[e],0,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.Capabilities)||(this._C=n.Capabilities),f(n.DiagnosticId)||(this._D=n.DiagnosticId),f(n.HostId)||(this._H=n.HostId),f(n.InstanceId)||(this._I=n.InstanceId),f(n.Type)||(this._T=n.Type),b(this,n,["actions","Actions","organization","Organization","personaInfo","PersonaInfo","photo","Photo","unifiedCommunicationInfo","UnifiedCommunicationInfo","unifiedGroupInfo","UnifiedGroupInfo"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.prototype.toJSON=function(){return y(this,{capabilities:this._C,diagnosticId:this._D,hostId:this._H,instanceId:this._I,type:this._T},{organization:this._O,personaInfo:this._P,unifiedCommunicationInfo:this._U,unifiedGroupInfo:this._Un})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.Persona=$;var Z=function(){function t(){}return t.prototype.performAsyncOperation=function(e,t,n,r){var o=this;e!=Q.immediate?r().then((function(e){if(e)n();else{var i=o;i.load("hostId"),i.context.sync().then((function(){var e=i.hostId;o.getPersonaLifetime().then((function(o){var a=function(s){return new OfficeExtension.CoreUtility.Promise((function(c,l){if(s.sendingPersonaHostId==e)for(var u=0;u<s.dataUpdated.length;++u){var d=s.dataUpdated[u];if(t==d)return void r().then((function(e){e&&(n(),o.onPersonaUpdated.remove(a),i.context.sync()),c(e)}))}c(!1)}))};o.onPersonaUpdated.add(a),i.context.sync()}))}))}})):n()},t.prototype.getOrganizationAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.organization,(function(){var e=o.organization;e.load("*"),o.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e,t){var n=o.organization;n.load("isWarmedUp"),o.context.sync().then((function(){e(n.isWarmedUp)}))}))}))}))},t.prototype.getIsPersonaInfoResolvedCheck=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.personaInfo;r.load("isPersonResolved"),e.context.sync().then((function(){t(r.isPersonResolved)}))}))},t.prototype.getPersonaInfoAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.personaInfo,(function(){var e=o.personaInfo;e.load(),o.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getPersonaInfoWithSourceAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.personaInfo,(function(){var e=new Y;e.info=o.personaInfo,e.info.load(),e.source=o.personaInfo.sources,e.source.load(),o.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getUnifiedCommunicationInfo=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.personaInfo,(function(){var e=o.unifiedCommunicationInfo;e.load("*"),o.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getUnifiedGroupInfoAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.personaInfo,(function(){var e=o.unifiedGroupInfo;e.load("*"),o.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getTypeAsync=function(t){var n=this;return new OfficeExtension.CoreUtility.Promise((function(r,o){var i=n;n.performAsyncOperation(t,x.personaInfo,(function(){i.load("type"),i.context.sync().then((function(){r(e.PersonaType[i.type.valueOf()])}))}),(function(){return n.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getCustomizationsAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.personaInfo,(function(){var e=o.getCustomizations();o.context.sync().then((function(){n(e.value)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},t.prototype.getMembersAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.members,(function(){var e=o.getMembers();e.load("isWarmedUp"),o.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e,t){var n=o.getMembers();n.load("isWarmedUp"),o.context.sync().then((function(){e(n.isWarmedUp)}))}))}))}))},t.prototype.getMembershipAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=t;t.performAsyncOperation(e,x.membership,(function(){var e=o.getMembership();e.load("*"),o.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e){var t=o.getMembership();t.load("isWarmedUp"),o.context.sync().then((function(){e(t.isWarmedUp)}))}))}))}))},t.prototype.getPersonaLifetime=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e;r.load("instanceId"),r.context.sync().then((function(){new oe(r.context,r.instanceId).getPersonaLifetime().then((function(e){t(e)}))}))}))},t}();e.PersonaCustom=Z,OfficeExtension.Utility.applyMixin($,Z);var ee=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PersonaLifetime"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["instanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["InstanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"instanceId",{get:function(){return p("instanceId",this._I,"PersonaLifetime",this._isNull),this._I},enumerable:!0,configurable:!0}),n.prototype.getPersona=function(t){return o(e.Persona,this,"GetPersona",1,[t],!1,!1,null,4)},n.prototype.getPersonaForOrgByEntryId=function(t,n,r,i){return o(e.Persona,this,"GetPersonaForOrgByEntryId",1,[t,n,r,i],!1,!1,null,4)},n.prototype.getPersonaForOrgEntry=function(t,n,r,i){return o(e.Persona,this,"GetPersonaForOrgEntry",1,[t,n,r,i],!1,!1,null,4)},n.prototype.getPolicies=function(){return c(this,"GetPolicies",1,[],4,0)},n.prototype.getTextScaleFactor=function(){return c(this,"GetTextScaleFactor",1,[],4,0)},n.prototype._RegisterPersonaUpdatedEvent=function(){c(this,"_RegisterPersonaUpdatedEvent",0,[],0,0)},n.prototype._UnregisterPersonaUpdatedEvent=function(){c(this,"_UnregisterPersonaUpdatedEvent",0,[],0,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.InstanceId)||(this._I=n.InstanceId)}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},Object.defineProperty(n.prototype,"onPersonaUpdated",{get:function(){var e=this;return this.m_personaUpdated||(this.m_personaUpdated=new OfficeExtension.GenericEventHandlers(this.context,this,"PersonaUpdated",{eventType:3502,registerFunc:function(){return e._RegisterPersonaUpdatedEvent()},unregisterFunc:function(){return e._UnregisterPersonaUpdatedEvent()},getTargetIdFunc:function(){return e.instanceId},eventArgsTransformFunc:function(e){var t={dataUpdated:e.dataUpdated,sendingPersonaHostId:e.sendingPersonaHostId};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_personaUpdated},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{instanceId:this._I},{})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.PersonaLifetime=ee;var te="LokiTokenProvider",ne=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"LokiTokenProvider"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["emailOrUpn","instanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["EmailOrUpn","InstanceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"emailOrUpn",{get:function(){return p("emailOrUpn",this._E,te,this._isNull),this._E},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"instanceId",{get:function(){return p("instanceId",this._I,te,this._isNull),this._I},enumerable:!0,configurable:!0}),t.prototype.requestClientAccessToken=function(){c(this,"RequestClientAccessToken",0,[],0,0)},t.prototype.requestIdentityUniqueId=function(){c(this,"RequestIdentityUniqueId",0,[],0,0)},t.prototype.requestToken=function(){c(this,"RequestToken",0,[],0,0)},t.prototype._RegisterClientAccessTokenAvailableEvent=function(){c(this,"_RegisterClientAccessTokenAvailableEvent",0,[],0,0)},t.prototype._RegisterIdentityUniqueIdAvailableEvent=function(){c(this,"_RegisterIdentityUniqueIdAvailableEvent",0,[],0,0)},t.prototype._RegisterLokiTokenAvailableEvent=function(){c(this,"_RegisterLokiTokenAvailableEvent",0,[],0,0)},t.prototype._UnregisterClientAccessTokenAvailableEvent=function(){c(this,"_UnregisterClientAccessTokenAvailableEvent",0,[],0,0)},t.prototype._UnregisterIdentityUniqueIdAvailableEvent=function(){c(this,"_UnregisterIdentityUniqueIdAvailableEvent",0,[],0,0)},t.prototype._UnregisterLokiTokenAvailableEvent=function(){c(this,"_UnregisterLokiTokenAvailableEvent",0,[],0,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.EmailOrUpn)||(this._E=n.EmailOrUpn),f(n.InstanceId)||(this._I=n.InstanceId)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},Object.defineProperty(t.prototype,"onClientAccessTokenAvailable",{get:function(){var e=this;return this.m_clientAccessTokenAvailable||(this.m_clientAccessTokenAvailable=new OfficeExtension.GenericEventHandlers(this.context,this,"ClientAccessTokenAvailable",{eventType:3505,registerFunc:function(){return e._RegisterClientAccessTokenAvailableEvent()},unregisterFunc:function(){return e._UnregisterClientAccessTokenAvailableEvent()},getTargetIdFunc:function(){return e.instanceId},eventArgsTransformFunc:function(e){var t={clientAccessToken:e.clientAccessToken,isAvailable:e.isAvailable,tokenTTLInSeconds:e.tokenTTLInSeconds};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_clientAccessTokenAvailable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onIdentityUniqueIdAvailable",{get:function(){var e=this;return this.m_identityUniqueIdAvailable||(this.m_identityUniqueIdAvailable=new OfficeExtension.GenericEventHandlers(this.context,this,"IdentityUniqueIdAvailable",{eventType:3504,registerFunc:function(){return e._RegisterIdentityUniqueIdAvailableEvent()},unregisterFunc:function(){return e._UnregisterIdentityUniqueIdAvailableEvent()},getTargetIdFunc:function(){return e.instanceId},eventArgsTransformFunc:function(e){var t={isAvailable:e.isAvailable,uniqueId:e.uniqueId};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_identityUniqueIdAvailable},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"onLokiTokenAvailable",{get:function(){var e=this;return this.m_lokiTokenAvailable||(this.m_lokiTokenAvailable=new OfficeExtension.GenericEventHandlers(this.context,this,"LokiTokenAvailable",{eventType:3503,registerFunc:function(){return e._RegisterLokiTokenAvailableEvent()},unregisterFunc:function(){return e._UnregisterLokiTokenAvailableEvent()},getTargetIdFunc:function(){return e.instanceId},eventArgsTransformFunc:function(e){var t={isAvailable:e.isAvailable,lokiAutoDiscoverUrl:e.lokiAutoDiscoverUrl,lokiToken:e.lokiToken};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_lokiTokenAvailable},enumerable:!0,configurable:!0}),t.prototype.toJSON=function(){return y(this,{emailOrUpn:this._E,instanceId:this._I},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.LokiTokenProvider=ne;var re=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"LokiTokenProviderFactory"},enumerable:!0,configurable:!0}),n.prototype.getLokiTokenProvider=function(t){return o(e.LokiTokenProvider,this,"GetLokiTokenProvider",1,[t],!1,!1,null,4)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.LokiTokenProviderFactory,t,"Microsoft.People.LokiTokenProviderFactory",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.LokiTokenProviderFactory=re;var oe=function(){function t(e,t){this.context=e,this.instanceId=t}return Object.defineProperty(t.prototype,"serviceContext",{get:function(){return this.m_serviceConext||(this.m_serviceConext=e.ServiceContext.newObject(this.context)),this.m_serviceConext},enumerable:!0,configurable:!0}),t.prototype.getPersonaLifetime=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getPersonaLifetime(e.instanceId);e.context.sync().then((function(){r.load("instanceId"),e.context.sync().then((function(){t(r)}))}))}))},t.prototype.getInitialPersona=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getInitialPersona(e.instanceId);e.context.sync().then((function(){t(r)}))}))},t.prototype.getLokiTokenProvider=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getLokiTokenProvider(e.instanceId);e.context.sync().then((function(){r.load("instanceId"),e.context.sync().then((function(){t(r)}))}))}))},t}();e.PeopleApiContext=oe;var ie=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ServiceContext"},enumerable:!0,configurable:!0}),n.prototype.accountEmailOrUpn=function(e){return c(this,"AccountEmailOrUpn",1,[e],4,0)},n.prototype.dispose=function(e){c(this,"Dispose",0,[e],0,0)},n.prototype.getInitialPersona=function(t){return o(e.Persona,this,"GetInitialPersona",1,[t],!1,!1,null,4)},n.prototype.getLokiTokenProvider=function(t){return o(e.LokiTokenProvider,this,"GetLokiTokenProvider",1,[t],!1,!1,null,4)},n.prototype.getPersonaLifetime=function(t){return o(e.PersonaLifetime,this,"GetPersonaLifetime",1,[t],!1,!1,null,4)},n.prototype.getPersonaPolicies=function(){return c(this,"GetPersonaPolicies",1,[],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ServiceContext,t,"Microsoft.People.ServiceContext",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ServiceContext=ie;var ae=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"RichapiPcxFeatureChecks"},enumerable:!0,configurable:!0}),n.prototype.isAddChangePhotoLinkOnLpcPersonaImageFlightEnabled=function(){return c(this,"IsAddChangePhotoLinkOnLpcPersonaImageFlightEnabled",1,[],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.RichapiPcxFeatureChecks,t,"Microsoft.People.RichapiPcxFeatureChecks",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.RichapiPcxFeatureChecks=ae;var se="Comment",ce=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"Comment"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","text","created","level","resolved","author","mentions"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Text","Created","Level","Resolved","Author","Mentions"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0,!1,!1,!0,!1,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["parent","parentOrNullObject","replies"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parent",{get:function(){return this._P||(this._P=r(e.Comment,this,"Parent",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentOrNullObject",{get:function(){return this._Pa||(this._Pa=r(e.Comment,this,"ParentOrNullObject",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"replies",{get:function(){return this._R||(this._R=r(e.CommentCollection,this,"Replies",!0,4)),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"author",{get:function(){return p("author",this._A,se,this._isNull),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"created",{get:function(){return p("created",this._C,se,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,se,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"level",{get:function(){return p("level",this._L,se,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"mentions",{get:function(){return p("mentions",this._M,se,this._isNull),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"resolved",{get:function(){return p("resolved",this._Re,se,this._isNull),this._Re},set:function(e){this._Re=e,u(this,"Resolved",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"text",{get:function(){return p("text",this._T,se,this._isNull),this._T},set:function(e){this._T=e,u(this,"Text",e,0)},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,["text","resolved"],[],["parent","parentOrNullObject","replies"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype.delete=function(){c(this,"Delete",0,[],0,0)},n.prototype.getParentOrSelf=function(){return o(e.Comment,this,"GetParentOrSelf",1,[],!1,!1,null,4)},n.prototype.getRichText=function(e){return c(this,"GetRichText",1,[e],4,0)},n.prototype.reply=function(t,n){return o(e.Comment,this,"Reply",0,[t,n],!1,!1,null,0)},n.prototype.setRichText=function(e,t){return c(this,"SetRichText",0,[e,t],0,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),f(n.Author)||(this._A=n.Author),f(n.Created)||(this._C=C(n.Created)),f(n.Id)||(this._I=n.Id),f(n.Level)||(this._L=n.Level),f(n.Mentions)||(this._M=n.Mentions),f(n.Resolved)||(this._Re=n.Resolved),f(n.Text)||(this._T=n.Text),b(this,n,["parent","Parent","parentOrNullObject","ParentOrNullObject","replies","Replies"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),d(e)||f(e.Id)||(this._I=e.Id)},n.prototype._handleRetrieveResult=function(e,n){if(t.prototype._handleRetrieveResult.call(this,e,n),!d(e)){var r=e;f(r.Created)||(r.created=C(r.created)),_(this,e,n)}},n.prototype.toJSON=function(){return y(this,{author:this._A,created:this._C,id:this._I,level:this._L,mentions:this._M,resolved:this._Re,text:this._T},{replies:this._R})},n.prototype.setMockData=function(e){O(this,e)},n.prototype.ensureUnchanged=function(e){l(this,e)},n}(OfficeExtension.ClientObject);e.Comment=ce;var le=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"CommentCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,"CommentCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),n.prototype.getCount=function(){return c(this,"GetCount",1,[],4,0)},n.prototype.getItem=function(t){return i(e.Comment,this,[t])},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!d(n)){var r=n;if(v(this,r),!d(r[OfficeExtension.Constants.items])){this.m__items=[];for(var o=r[OfficeExtension.Constants.items],i=0;i<o.length;i++){var a=s(e.Comment,!0,this,o[i],i);a._handleResult(o[i]),this.m__items.push(a)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(n,r){var o=this;t.prototype._handleRetrieveResult.call(this,n,r),_(this,n,r,(function(t,n){return s(e.Comment,!0,o,t,n)}))},n.prototype.toJSON=function(){return y(this,{},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;O(this,t,(function(t,r){return s(e.Comment,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.CommentCollection=le;var ue=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ExtensionLifeCycle"},enumerable:!0,configurable:!0}),n.prototype.launchExtensionComponent=function(e,t,n){c(this,"LaunchExtensionComponent",1,[e,t,n],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ExtensionLifeCycle,t,"Microsoft.OfficeSharedApi.ExtensionLifeCycle",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ExtensionLifeCycle=ue,function(e){e.plain="Plain",e.markdown="Markdown",e.delta="Delta"}(e.CommentTextFormat||(e.CommentTextFormat={})),function(e){e.shortTime="ShortTime",e.longTime="LongTime",e.shortDate="ShortDate",e.longDate="LongDate"}(e.TimeStringFormat||(e.TimeStringFormat={}));var de=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"LocaleApi"},enumerable:!0,configurable:!0}),n.prototype.formatDateTimeString=function(e,t,n){return c(this,"FormatDateTimeString",1,[e,t,n],4,0)},n.prototype.getLocaleDateTimeFormattingInfo=function(e){return c(this,"GetLocaleDateTimeFormattingInfo",1,[e],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.LocaleApi,t,"Microsoft.LocaleApi.LocaleApi",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.LocaleApi=de;var fe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"FirstPartyDialogService"},enumerable:!0,configurable:!0}),n.prototype.close=function(){c(this,"Close",1,[],5,0)},n.prototype.displayDialog=function(e,t){c(this,"DisplayDialog",1,[e,t],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.FirstPartyDialogService,t,"Microsoft.FirstPartyDialog.FirstPartyDialogService",!1,4)},Object.defineProperty(n.prototype,"onDialogMessage",{get:function(){var e=this;return this.m_dialogMessage||(this.m_dialogMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"DialogMessage",{eventType:65536,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(t){var n=P.FirstPartyDialogService_DialogMessage_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_dialogMessage},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.FirstPartyDialogService=fe,function(e){e.FirstPartyDialogService_DialogMessage_EventArgsTransform=function(e,t){return{message:t.message}}}(P=e._CC||(e._CC={}));var pe=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return __extends(i,t),Object.defineProperty(i.prototype,"_className",{get:function(){return"DynamicRibbon"},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"_navigationPropertyNames",{get:function(){return["buttons"]},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"buttons",{get:function(){return this._B||(this._B=r(e.RibbonButtonCollection,this,"Buttons",!0,4)),this._B},enumerable:!0,configurable:!0}),i.prototype.executeRequestCreate=function(e){g("DynamicRibbon.executeRequestCreate","DynamicRibbon","1.2",n),c(this,"ExecuteRequestCreate",1,[e],4,0)},i.prototype.executeRequestUpdate=function(e){c(this,"ExecuteRequestUpdate",1,[e],4,0)},i.prototype.getButton=function(t){return o(e.RibbonButton,this,"GetButton",1,[t],!1,!1,null,4)},i.prototype.getTab=function(t){return o(e.RibbonTab,this,"GetTab",1,[t],!1,!1,null,4)},i.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),b(this,n,["buttons","Buttons"])}},i.prototype.load=function(e){return h(this,e)},i.prototype.retrieve=function(e){return m(this,e)},i.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},i.newObject=function(t){return a(e.DynamicRibbon,t,"Microsoft.DynamicRibbon.DynamicRibbon",!1,4)},i.prototype.toJSON=function(){return y(this,{},{buttons:this._B})},i}(OfficeExtension.ClientObject);e.DynamicRibbon=pe;var ge=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"RibbonTab"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,"RibbonTab",this._isNull),this._I},enumerable:!0,configurable:!0}),t.prototype.setVisibility=function(e){c(this,"SetVisibility",0,[e],S(2,"DynamicRibbonUndo","1.1"),0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Id)||(this._I=n.Id)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),d(t)||f(t.Id)||(this._I=t.Id)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{id:this._I},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.RibbonTab=ge;var he="RibbonButton",me=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"RibbonButton"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id","enabled","label"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Enabled","Label"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"enabled",{get:function(){return p("enabled",this._E,he,this._isNull),this._E},set:function(e){this._E=e,u(this,"Enabled",e,S(2,"DynamicRibbonUndo","1.1"))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,he,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"label",{get:function(){return p("label",this._L,he,this._isNull),this._L},enumerable:!0,configurable:!0}),t.prototype.set=function(e,t){this._recursivelySet(e,t,["enabled"],[],[])},t.prototype.update=function(e){this._recursivelyUpdate(e)},t.prototype.setEnabled=function(e){c(this,"SetEnabled",0,[e],S(2,"DynamicRibbonUndo","1.1"),0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Enabled)||(this._E=n.Enabled),f(n.Id)||(this._I=n.Id),f(n.Label)||(this._L=n.Label)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),d(t)||f(t.Id)||(this._I=t.Id)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{enabled:this._E,id:this._I,label:this._L},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.RibbonButton=me;var ye=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"RibbonButtonCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,"RibbonButtonCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),n.prototype.getCount=function(){return c(this,"GetCount",1,[],4,0)},n.prototype.getItem=function(t){return i(e.RibbonButton,this,[t])},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!d(n)){var r=n;if(v(this,r),!d(r[OfficeExtension.Constants.items])){this.m__items=[];for(var o=r[OfficeExtension.Constants.items],i=0;i<o.length;i++){var a=s(e.RibbonButton,!0,this,o[i],i);a._handleResult(o[i]),this.m__items.push(a)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return m(this,e)},n.prototype._handleRetrieveResult=function(n,r){var o=this;t.prototype._handleRetrieveResult.call(this,n,r),_(this,n,r,(function(t,n){return s(e.RibbonButton,!0,o,t,n)}))},n.prototype.toJSON=function(){return y(this,{},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;O(this,t,(function(t,r){return s(e.RibbonButton,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.RibbonButtonCollection=ye,function(e){e.ariaBrowserPipeUrl="AriaBrowserPipeUrl",e.ariaUploadUrl="AriaUploadUrl",e.ariaVNextUploadUrl="AriaVNextUploadUrl",e.lokiAutoDiscoverUrl="LokiAutoDiscoverUrl"}(e.ServiceProvider||(e.ServiceProvider={}));var ve=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ServiceUrlProvider"},enumerable:!0,configurable:!0}),n.prototype.getServiceUrl=function(e,t){return c(this,"GetServiceUrl",1,[e,t],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ServiceUrlProvider,t,"Microsoft.DesktopCompliance.ServiceUrlProvider",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ServiceUrlProvider=ve;var be=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"LinkedIn"},enumerable:!0,configurable:!0}),n.prototype.isEnabledForOffice=function(){return c(this,"IsEnabledForOffice",1,[],4,0)},n.prototype.recordLinkedInSettingsCompliance=function(e,t){c(this,"RecordLinkedInSettingsCompliance",0,[e,t],0,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.LinkedIn,t,"Microsoft.DesktopCompliance.LinkedIn",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.LinkedIn=be;var Ce=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"NetworkUsage"},enumerable:!0,configurable:!0}),n.prototype.isInDisconnectedMode=function(){return c(this,"IsInDisconnectedMode",1,[],4,0)},n.prototype.isInOnlineMode=function(){return c(this,"IsInOnlineMode",1,[],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.NetworkUsage,t,"Microsoft.DesktopCompliance.NetworkUsage",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.NetworkUsage=Ce;var _e=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"BeforeDocumentCloseNotification"},enumerable:!0,configurable:!0}),n.prototype.disable=function(){c(this,"Disable",1,[],4,0)},n.prototype.enable=function(){c(this,"Enable",1,[],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.BeforeDocumentCloseNotification,t,"Microsoft.BeforeDocumentCloseNotification.BeforeDocumentCloseNotification",!1,4)},Object.defineProperty(n.prototype,"onBeforeCloseNotificationCancelled",{get:function(){return this.m_beforeCloseNotificationCancelled||(this.m_beforeCloseNotificationCancelled=new OfficeExtension.GenericEventHandlers(this.context,this,"BeforeCloseNotificationCancelled",{eventType:65540,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){return OfficeExtension.Utility._createPromiseFromResult({})}})),this.m_beforeCloseNotificationCancelled},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.BeforeDocumentCloseNotification=_e,function(e){e.organizationAccount="OrganizationAccount",e.microsoftAccount="MicrosoftAccount",e.unsupported="Unsupported"}(e.IdentityType||(e.IdentityType={}));var Oe=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return __extends(o,t),Object.defineProperty(o.prototype,"_className",{get:function(){return"AuthenticationService"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["roamingSettings"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"roamingSettings",{get:function(){return this._R||(this._R=r(e.RoamingSettingCollection,this,"RoamingSettings",!1,4)),this._R},enumerable:!0,configurable:!0}),o.prototype.getAccessToken=function(e,t){return c(this,"GetAccessToken",1,[e,t],5,0)},o.prototype.getIdentities=function(){return g("AuthenticationService.getIdentities","FirstPartyAuthentication","1.3",n),c(this,"GetIdentities",1,[],5,0)},o.prototype.getPrimaryIdentityInfo=function(){return g("AuthenticationService.getPrimaryIdentityInfo","FirstPartyAuthentication","1.2",n),c(this,"GetPrimaryIdentityInfo",1,[],5,0)},o.prototype.registerIdentityChangedEvent=function(){g("AuthenticationService.registerIdentityChangedEvent","FirstPartyAuthentication","1.5",n),c(this,"RegisterIdentityChangedEvent",0,[],1,0)},o.prototype.unregisterIdentityChangedEvent=function(){g("AuthenticationService.unregisterIdentityChangedEvent","FirstPartyAuthentication","1.5",n),c(this,"UnregisterIdentityChangedEvent",0,[],1,0)},o.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!d(e)){var n=e;v(this,n),b(this,n,["roamingSettings","RoamingSettings"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return m(this,e)},o.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},o.newObject=function(t){return a(e.AuthenticationService,t,"Microsoft.Authentication.AuthenticationService",!1,4)},Object.defineProperty(o.prototype,"onIdentityChanged",{get:function(){var e=this;return g("AuthenticationService.onIdentityChanged","FirstPartyAuthentication","1.5",n),this.m_identityChanged||(this.m_identityChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"IdentityChanged",{eventType:65545,registerFunc:function(){return e.registerIdentityChangedEvent()},unregisterFunc:function(){return e.unregisterIdentityChangedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={email:e.email,environment:e.environment,uniqueId:e.uniqueId};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_identityChanged},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"onTokenReceived",{get:function(){var e=this;return g("AuthenticationService.onTokenReceived","FirstPartyAuthentication","1.2",n),this.m_tokenReceived||(this.m_tokenReceived=new OfficeExtension.GenericEventHandlers(this.context,this,"TokenReceived",{eventType:3001,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return e._targetId},eventArgsTransformFunc:function(t){var n=P.AuthenticationService_TokenReceived_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_tokenReceived},enumerable:!0,configurable:!0}),o.prototype.toJSON=function(){return y(this,{},{})},o}(OfficeExtension.ClientObject);e.AuthenticationService=Oe;var Se=function(){function e(){}return Object.defineProperty(e.prototype,"_targetId",{get:function(){return null==this.m_targetId&&(void 0!==OSF&&OSF.OUtil?this.m_targetId=OSF.OUtil.Guid.generateNewGuid():this.m_targetId=""+this.context._nextId()),this.m_targetId},enumerable:!0,configurable:!0}),e}();e.AuthenticationServiceCustom=Se,OfficeExtension.Utility.applyMixin(Oe,Se),function(e){e.AuthenticationService_TokenReceived_EventArgsTransform=function(e,t){var n=t;return{tokenValue:n.tokenValue,code:n.code,errorInfo:n.errorInfo}}}(P=e._CC||(e._CC={}));var Ae="RoamingSetting",Ee=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"RoamingSetting"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id","value"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Value"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,Ae,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return p("value",this._V,Ae,this._isNull),this._V},set:function(e){this._V=e,u(this,"Value",e,0)},enumerable:!0,configurable:!0}),t.prototype.set=function(e,t){this._recursivelySet(e,t,["value"],[],[])},t.prototype.update=function(e){this._recursivelyUpdate(e)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!d(t)){var n=t;v(this,n),f(n.Id)||(this._I=n.Id),f(n.Value)||(this._V=n.Value)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return m(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),d(t)||f(t.Id)||(this._I=t.Id)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),_(this,t,n)},t.prototype.toJSON=function(){return y(this,{id:this._I,value:this._V},{})},t.prototype.setMockData=function(e){O(this,e)},t.prototype.ensureUnchanged=function(e){l(this,e)},t}(OfficeExtension.ClientObject);e.RoamingSetting=Ee;var Pe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"RoamingSettingCollection"},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.RoamingSetting,this,"GetItem",1,[t],!1,!1,null,4)},n.prototype.getItemOrNullObject=function(t){return o(e.RoamingSetting,this,"GetItemOrNullObject",1,[t],!1,!1,null,4)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.RoamingSettingCollection=Pe;var Re=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"SharedFilePicker"},enumerable:!0,configurable:!0}),n.prototype.getSharedFilePickerResponse=function(e){return c(this,"GetSharedFilePickerResponse",1,[e],4,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.SharedFilePicker,t,"Microsoft.Office.SharedFilePicker",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.SharedFilePicker=Re;var Te=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ActionService"},enumerable:!0,configurable:!0}),n.prototype.areShortcutsInUse=function(e){return c(this,"AreShortcutsInUse",0,[e],0,0)},n.prototype.getShortcuts=function(){return c(this,"GetShortcuts",1,[],4,0)},n.prototype.replaceShortcuts=function(e){c(this,"ReplaceShortcuts",0,[e],0,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ActionService,t,"Microsoft.Office.ActionService",!1,4)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ActionService=Te;var Ie=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"Auth"},enumerable:!0,configurable:!0}),n.prototype.getAccessTokenFirstPartyOAuth=function(e,t){return c(this,"GetAccessTokenFirstPartyOAuth",1,[e,t],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.Auth,t,"Microsoft.Office.Auth",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.Auth=Ie;var we=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"AugLoopEventService"},enumerable:!0,configurable:!0}),n.prototype.sendMessage=function(e){c(this,"SendMessage",1,[e],5,0)},n.prototype._RegisterHostMessageReceivedEvent=function(){c(this,"_RegisterHostMessageReceivedEvent",1,[],5,0)},n.prototype._UnregisterHostMessageReceivedEvent=function(){c(this,"_UnregisterHostMessageReceivedEvent",1,[],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.AugLoopEventService,t,"Microsoft.Office.AugLoopEventService",!1,5)},Object.defineProperty(n.prototype,"onHostMessageReceived",{get:function(){var e=this;return this.m_hostMessageReceived||(this.m_hostMessageReceived=new OfficeExtension.GenericEventHandlers(this.context,this,"HostMessageReceived",{eventType:65542,registerFunc:function(){return e._RegisterHostMessageReceivedEvent()},unregisterFunc:function(){return e._UnregisterHostMessageReceivedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={data:e.data};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_hostMessageReceived},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.AugLoopEventService=we;var Fe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"UndoService"},enumerable:!0,configurable:!0}),n.prototype.endCopilotOperation=function(e){c(this,"EndCopilotOperation",0,[e],1,0)},n.prototype.startCopilotOperation=function(e){return c(this,"StartCopilotOperation",0,[e],1,0)},n.prototype.undo=function(){return c(this,"Undo",0,[],1,0)},n.prototype._RegisterUndoStackChangedEvent=function(){c(this,"_RegisterUndoStackChangedEvent",1,[],5,0)},n.prototype._UnregisterUndoStackChangedEvent=function(){c(this,"_UnregisterUndoStackChangedEvent",1,[],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.UndoService,t,"Microsoft.Office.UndoService",!1,5)},Object.defineProperty(n.prototype,"onCopilotOperationStarted",{get:function(){return this.m_copilotOperationStarted||(this.m_copilotOperationStarted=new OfficeExtension.GenericEventHandlers(this.context,this,"CopilotOperationStarted",{eventType:65544,registerFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},unregisterFunc:function(){return OfficeExtension.Utility._createPromiseFromResult(null)},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={batchId:e.batchId};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_copilotOperationStarted},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"onUndoStackChanged",{get:function(){var e=this;return this.m_undoStackChanged||(this.m_undoStackChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"UndoStackChanged",{eventType:65543,registerFunc:function(){return e._RegisterUndoStackChangedEvent()},unregisterFunc:function(){return e._UnregisterUndoStackChangedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){return OfficeExtension.Utility._createPromiseFromResult({})}})),this.m_undoStackChanged},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.UndoService=Fe,function(e){e.notSet="NotSet",e.true="True",e.false="False"}(e.TriStateOption||(e.TriStateOption={})),function(e){e.like="Like",e.dislike="Dislike",e.idea="Idea",e.unclassified="Unclassified"}(e.UserFeedbackType||(e.UserFeedbackType={})),function(e){e.modalDialog="ModalDialog",e.taskpane="Taskpane"}(e.UserFeedbackUIType||(e.UserFeedbackUIType={})),function(e){e.autoCapture="AutoCapture",e.autoCaptureWithHtml2Canvas="AutoCaptureWithHtml2Canvas",e.providedAtInitialization="ProvidedAtInitialization",e.dynamicallyProvided="DynamicallyProvided"}(e.UserFeedbackScreenshotInfoSourceType||(e.UserFeedbackScreenshotInfoSourceType={})),function(e){e.jpeg="jpeg",e.png="png"}(e.UserFeedbackScreenshotInfoImageFormat||(e.UserFeedbackScreenshotInfoImageFormat={}));var De=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"UserFeedbackService"},enumerable:!0,configurable:!0}),n.prototype.canCollectCopilotFeedback=function(){return c(this,"CanCollectCopilotFeedback",1,[],5,0)},n.prototype.canCollectUserFeedback=function(){return c(this,"CanCollectUserFeedback",1,[],5,0)},n.prototype.collectUserFeedback=function(e,t,n,r){c(this,"CollectUserFeedback",1,[e,t,n,r],5,0)},n.prototype.getHostScreenshot=function(){return c(this,"GetHostScreenshot",1,[],5,0)},n.prototype.getInitializationData=function(){return c(this,"GetInitializationData",1,[],5,0)},n.prototype.invokeDiagnosticsLogsUpload=function(e){c(this,"InvokeDiagnosticsLogsUpload",1,[e],5,0)},n.prototype._RegisterUserFeedbackResponseEvent=function(){c(this,"_RegisterUserFeedbackResponseEvent",1,[],5,0)},n.prototype._RegisterUserFeedbackUIDismissedEvent=function(){c(this,"_RegisterUserFeedbackUIDismissedEvent",1,[],5,0)},n.prototype._UnregisterUserFeedbackResponseEvent=function(){c(this,"_UnregisterUserFeedbackResponseEvent",1,[],5,0)},n.prototype._UnregisterUserFeedbackUIDismissedEvent=function(){c(this,"_UnregisterUserFeedbackUIDismissedEvent",1,[],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.UserFeedbackService,t,"Microsoft.Office.UserFeedbackService",!1,5)},Object.defineProperty(n.prototype,"onUserFeedbackResponse",{get:function(){var e=this;return this.m_userFeedbackResponse||(this.m_userFeedbackResponse=new OfficeExtension.GenericEventHandlers(this.context,this,"UserFeedbackResponse",{eventType:65550,registerFunc:function(){return e._RegisterUserFeedbackResponseEvent()},unregisterFunc:function(){return e._UnregisterUserFeedbackResponseEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={responseData:e.responseData};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_userFeedbackResponse},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"onUserFeedbackUIDismissed",{get:function(){var e=this;return this.m_userFeedbackUIDismissed||(this.m_userFeedbackUIDismissed=new OfficeExtension.GenericEventHandlers(this.context,this,"UserFeedbackUIDismissed",{eventType:65546,registerFunc:function(){return e._RegisterUserFeedbackUIDismissedEvent()},unregisterFunc:function(){return e._UnregisterUserFeedbackUIDismissedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={isFeedbackSent:e.isFeedbackSent};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_userFeedbackUIDismissed},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.UserFeedbackService=De;var xe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"NotificationService"},enumerable:!0,configurable:!0}),n.prototype.addNotification=function(e,t){return c(this,"AddNotification",0,[e,t],1,0)},n.prototype.removeNotification=function(e){c(this,"RemoveNotification",0,[e],1,0)},n.prototype.updateNotification=function(e,t){c(this,"UpdateNotification",0,[e,t],1,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.NotificationService,t,"Microsoft.Office.NotificationService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.NotificationService=xe;var ke=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return __extends(r,t),Object.defineProperty(r.prototype,"_className",{get:function(){return"SensitivityService"},enumerable:!0,configurable:!0}),r.prototype.getHighestSensitivityLabel=function(e){return c(this,"GetHighestSensitivityLabel",0,[e],S(3,"SensitivityUndo","1.1"),0)},r.prototype.getLabel=function(){return c(this,"GetLabel",0,[],S(3,"SensitivityUndo","1.1"),0)},r.prototype.getSensitivityResultDetails=function(e,t){return g("SensitivityService.getSensitivityResultDetails","SensitivityService","1.2",n),c(this,"GetSensitivityResultDetails",0,[e,t],S(3,"SensitivityUndo","1.2"),0)},r.prototype.getSensitivityResultDetailsByStringErrorCode=function(e,t){return g("SensitivityService.getSensitivityResultDetailsByStringErrorCode","SensitivityService","1.3",n),c(this,"GetSensitivityResultDetailsByStringErrorCode",0,[e,t],S(3,"SensitivityUndo","1.3"),0)},r.prototype.tryUpgradeLabel=function(e,t){c(this,"TryUpgradeLabel",0,[e,t],S(3,"SensitivityUndo","1.1"),0)},r.prototype._RegisterSensitivityLabelChangedEvent=function(){c(this,"_RegisterSensitivityLabelChangedEvent",1,[],5,0)},r.prototype._UnregisterSensitivityLabelChangedEvent=function(){c(this,"_UnregisterSensitivityLabelChangedEvent",1,[],5,0)},r.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},r.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},r.newObject=function(t){return a(e.SensitivityService,t,"Microsoft.Office.SensitivityService",!1,5)},Object.defineProperty(r.prototype,"onLabelChanged",{get:function(){var e=this;return this.m_labelChanged||(this.m_labelChanged=new OfficeExtension.GenericEventHandlers(this.context,this,"LabelChanged",{eventType:65549,registerFunc:function(){return e._RegisterSensitivityLabelChangedEvent()},unregisterFunc:function(){return e._UnregisterSensitivityLabelChangedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={context:e.context,error:e.error,newLabel:e.newLabel,previousLabel:e.previousLabel};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_labelChanged},enumerable:!0,configurable:!0}),r.prototype.toJSON=function(){return y(this,{},{})},r}(OfficeExtension.ClientObject);e.SensitivityService=ke;var Ne=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"CopilotService"},enumerable:!0,configurable:!0}),n.prototype.launchHelpPaneByArticleId=function(e){c(this,"LaunchHelpPaneByArticleId",0,[e],1,0)},n.prototype.launchHelpPaneByArticleIdString=function(e){c(this,"LaunchHelpPaneByArticleIdString",0,[e],1,0)},n.prototype.launchHelpPaneByQuery=function(e){c(this,"LaunchHelpPaneByQuery",0,[e],1,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.CopilotService,t,"Microsoft.Office.CopilotService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.CopilotService=Ne;var Me=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PrivateApiService"},enumerable:!0,configurable:!0}),n.prototype.execute=function(e){return c(this,"Execute",0,[e],1,0)},n.prototype._RegisterPrivateApiEvent=function(){c(this,"_RegisterPrivateApiEvent",1,[],5,0)},n.prototype._UnregisterPrivateApiEvent=function(){c(this,"_UnregisterPrivateApiEvent",1,[],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.PrivateApiService,t,"Microsoft.Office.PrivateApiService",!1,5)},Object.defineProperty(n.prototype,"onOnPrivateEvent",{get:function(){var e=this;return this.m_onPrivateEvent||(this.m_onPrivateEvent=new OfficeExtension.GenericEventHandlers(this.context,this,"OnPrivateEvent",{eventType:65552,registerFunc:function(){return e._RegisterPrivateApiEvent()},unregisterFunc:function(){return e._UnregisterPrivateApiEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(e){var t={messageData:e.messageData};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_onPrivateEvent},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.PrivateApiService=Me,function(e){e.get="Get",e.post="Post",e.patch="Patch",e.delete="Delete"}(e.RequestMethod||(e.RequestMethod={})),function(e){e.executionResult="ExecutionResult",e.runtimeInfo="RuntimeInfo",e.serviceResponse="ServiceResponse"}(e.ResultType||(e.ResultType={})),function(e){e.other="Other",e.environment="Environment",e.runtime="Runtime",e.license="License",e.user="User",e.auth="Auth",e.billing="Billing",e.invalidArg="InvalidArg",e.python="Python",e.service="Service",e.unsupported="Unsupported",e.dataUpload="DataUpload"}(e.ErrorCategory||(e.ErrorCategory={}));var He=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ExternalCodeService"},enumerable:!0,configurable:!0}),n.prototype.executePythonCode=function(e){return c(this,"ExecutePythonCode",0,[e],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.executePythonCodeAsync=function(e){c(this,"ExecutePythonCodeAsync",0,[e],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.executePythonCodeAsync2=function(e,t){c(this,"ExecutePythonCodeAsync2",0,[e,t],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.getRuntimeInfoAsync=function(){c(this,"GetRuntimeInfoAsync",1,[],5,0)},n.prototype.getRuntimeInfoAsync2=function(e){c(this,"GetRuntimeInfoAsync2",1,[e],5,0)},n.prototype.registerExternalCodeExecutionCompletedEvent=function(){c(this,"RegisterExternalCodeExecutionCompletedEvent",0,[],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.registerExternalCodeServiceRequestCompletedEvent=function(){c(this,"RegisterExternalCodeServiceRequestCompletedEvent",1,[],5,0)},n.prototype.registerExternalCodeServiceResultEvent=function(){c(this,"RegisterExternalCodeServiceResultEvent",0,[],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.sendRequestAsync=function(e,t,n,r){return c(this,"SendRequestAsync",1,[e,t,n,r],5,0)},n.prototype.unregisterExternalCodeExecutionCompletedEvent=function(){c(this,"UnregisterExternalCodeExecutionCompletedEvent",0,[],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype.unregisterExternalCodeServiceRequestCompletedEvent=function(){c(this,"UnregisterExternalCodeServiceRequestCompletedEvent",1,[],5,0)},n.prototype.unregisterExternalCodeServiceResultEvent=function(){c(this,"UnregisterExternalCodeServiceResultEvent",0,[],S(3,"ExternalCodeServiceUndo","1.1"),0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ExternalCodeService,t,"Microsoft.Office.ExternalCodeService",!1,5)},Object.defineProperty(n.prototype,"onExternalCodeExecutionCompleted",{get:function(){var e=this;return this.m_externalCodeExecutionCompleted||(this.m_externalCodeExecutionCompleted=new OfficeExtension.GenericEventHandlers(this.context,this,"ExternalCodeExecutionCompleted",{eventType:65551,registerFunc:function(){return e.registerExternalCodeExecutionCompletedEvent()},unregisterFunc:function(){return e.unregisterExternalCodeExecutionCompletedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(t){var n=P.ExternalCodeService_ExternalCodeExecutionCompleted_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_externalCodeExecutionCompleted},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"onExternalCodeServiceRequestCompleted",{get:function(){var e=this;return this.m_externalCodeServiceRequestCompleted||(this.m_externalCodeServiceRequestCompleted=new OfficeExtension.GenericEventHandlers(this.context,this,"ExternalCodeServiceRequestCompleted",{eventType:65553,registerFunc:function(){return e.registerExternalCodeServiceRequestCompletedEvent()},unregisterFunc:function(){return e.unregisterExternalCodeServiceRequestCompletedEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(t){var n=P.ExternalCodeService_ExternalCodeServiceRequestCompleted_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_externalCodeServiceRequestCompleted},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"onExternalCodeServiceResult",{get:function(){var e=this;return this.m_externalCodeServiceResult||(this.m_externalCodeServiceResult=new OfficeExtension.GenericEventHandlers(this.context,this,"ExternalCodeServiceResult",{eventType:65554,registerFunc:function(){return e.registerExternalCodeServiceResultEvent()},unregisterFunc:function(){return e.unregisterExternalCodeServiceResultEvent()},getTargetIdFunc:function(){return""},eventArgsTransformFunc:function(t){var n=P.ExternalCodeService_ExternalCodeServiceResult_EventArgsTransform(e,t);return OfficeExtension.Utility._createPromiseFromResult(n)}})),this.m_externalCodeServiceResult},enumerable:!0,configurable:!0}),n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ExternalCodeService=He,function(e){e.ExternalCodeService_ExternalCodeExecutionCompleted_EventArgsTransform=function(e,t){return{result:t.result}},e.ExternalCodeService_ExternalCodeServiceRequestCompleted_EventArgsTransform=function(e,t){return t},e.ExternalCodeService_ExternalCodeServiceResult_EventArgsTransform=function(e,t){return t}}(P=e._CC||(e._CC={})),function(e){e.info="Info",e.error="Error",e.blocked="Blocked",e.severeWarning="SevereWarning",e.success="Success",e.warning="Warning"}(e.BusinessBarType||(e.BusinessBarType={}));var Ue=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"BusinessBarService"},enumerable:!0,configurable:!0}),n.prototype.hide=function(e){c(this,"Hide",0,[e],1,0)},n.prototype.show=function(e,t){c(this,"Show",0,[e,t],1,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.BusinessBarService,t,"Microsoft.Office.BusinessBarService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.BusinessBarService=Ue,function(e){e.information="information",e.error="error",e.warning="warning",e.question="question",e.other="other"}(e.SimpleDialogCategory||(e.SimpleDialogCategory={}));var je=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ShowSimpleDialog"},enumerable:!0,configurable:!0}),n.prototype.launchSimpleDialog=function(e,t,n,r,o,i,a,s){return c(this,"LaunchSimpleDialog",0,[e,t,n,r,o,i,a,s],3,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.ShowSimpleDialog,t,"Microsoft.Office.ShowSimpleDialog",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.ShowSimpleDialog=je;var Le=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"DispatchApiService"},enumerable:!0,configurable:!0}),n.prototype.execute=function(e,t){return c(this,"Execute",1,[e,t],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.DispatchApiService,t,"Microsoft.Office.DispatchApiService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.DispatchApiService=Le,function(e){e.camera="camera",e.microphone="microphone",e.geolocation="geolocation"}(e.DevicePermissionType||(e.DevicePermissionType={}));var Be=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"DevicePermissionService"},enumerable:!0,configurable:!0}),n.prototype.requestPermissions=function(e){return c(this,"RequestPermissions",1,[e],5,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.DevicePermissionService,t,"Microsoft.Office.DevicePermissionService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.DevicePermissionService=Be;var We=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"TaskpaneService"},enumerable:!0,configurable:!0}),n.prototype.close=function(){c(this,"Close",0,[],1,0)},n.prototype.move=function(){c(this,"Move",0,[],1,0)},n.prototype.notifyHeaderLoaded=function(){c(this,"NotifyHeaderLoaded",0,[],1,0)},n.prototype._handleResult=function(e){(t.prototype._handleResult.call(this,e),d(e))||v(this,e)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),_(this,e,n)},n.newObject=function(t){return a(e.TaskpaneService,t,"Microsoft.Office.TaskpaneService",!1,5)},n.prototype.toJSON=function(){return y(this,{},{})},n}(OfficeExtension.ClientObject);e.TaskpaneService=We,function(e){e.apiNotAvailable="ApiNotAvailable",e.clientError="ClientError",e.clpSessionError="ClpSessionError",e.controlIdNotFound="ControlIdNotFound",e.docCookieError="DocCookieError",e.entryIdRequired="EntryIdRequired",e.errorPointer="ErrorPointer",e.generalException="GeneralException",e.hostIntegrationManagerError="HostIntegrationManagerError",e.hostRestartNeeded="HostRestartNeeded",e.instanceNotFound="InstanceNotFound",e.interactiveFlowAborted="InteractiveFlowAborted",e.invalidArgument="InvalidArgument",e.invalidGrant="InvalidGrant",e.invalidResourceUrl="InvalidResourceUrl",e.invalidRibbonDefinition="InvalidRibbonDefinition",e.labelingDisabledAppguard="LabelingDisabledAppguard",e.labelingDisabledNoSignedInClpCompatibleUsers="LabelingDisabledNoSignedInClpCompatibleUsers",e.labelingDisabledPrivacySettings="LabelingDisabledPrivacySettings",e.labelingDisabledProtectedView="LabelingDisabledProtectedView",e.labelingDisabledUnsupportedLabelClient="LabelingDisabledUnsupportedLabelClient",e.msoOLDocumentError="MsoOLDocumentError",e.notImplement="NotImplement",e.objectNotFound="ObjectNotFound",e.officeJSItemLabelForIdentityError="OfficeJSItemLabelForIdentityError",e.officeJSRMSLicenseError="OfficeJSRMSLicenseError",e.officeJSSessionOrDocError="OfficeJSSessionOrDocError",e.officeSolutionFrameworkHostError="OfficeSolutionFrameworkHostError",e.omworkflowUserNotFound="OMWorkflowUserNotFound",e.osfControlContainerError="OsfControlContainerError",e.outOfMemory="OutOfMemory",e.resourceNotSupported="ResourceNotSupported",e.sensitivityDocumentReadOnly="SensitivityDocumentReadOnly",e.sensitivityInsufficientPermission="SensitivityInsufficientPermission",e.sensitivityLabelDisabled="SensitivityLabelDisabled",e.sensitivityLabelingDisabled="SensitivityLabelingDisabled",e.sensitivityLabelNotFound="SensitivityLabelNotFound",e.sensitivityNewLabelSensitivityOrder="SensitivityNewLabelSensitivityOrder",e.sensitivityUnsupportedContentType="SensitivityUnsupportedContentType",e.sensitivityUnsupportedCrossTenant="SensitivityUnsupportedCrossTenant",e.sensitivityUnsupportedDke="SensitivityUnsupportedDke",e.sensitivityUnsupportedUdp="SensitivityUnsupportedUdp",e.serverError="ServerError",e.serviceUrlNotFound="ServiceUrlNotFound",e.sharedRuntimeNotAvailable="SharedRuntimeNotAvailable",e.ticketInvalidParams="TicketInvalidParams",e.ticketNetworkError="TicketNetworkError",e.ticketUnauthorized="TicketUnauthorized",e.ticketUninitialized="TicketUninitialized",e.ticketUnknownError="TicketUnknownError",e.unexpectedError="UnexpectedError",e.unsupportedUserIdentity="UnsupportedUserIdentity",e.userNotSignedIn="UserNotSignedIn"}(e.ErrorCodes||(e.ErrorCodes={})),e.Interfaces||(e.Interfaces={})}(OfficeCore||(OfficeCore={})),function(e){var t,n;!function(e){e.hidden="Hidden",e.taskpane="Taskpane"}(t=e.VisibilityMode||(e.VisibilityMode={})),function(e){e.none="None",e.load="Load"}(n=e.StartupBehavior||(e.StartupBehavior={})),function(e){function r(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}function o(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=r(!0),OfficeCore.AppRuntimeService.newObject(t).setAppRuntimeState(e),[4,t.sync()];case 1:return n.sent(),[2]}}))}))}var i;e.setStartupBehavior=function(e){return __awaiter(this,void 0,void 0,(function(){var t,o;return __generator(this,(function(i){switch(i.label){case 0:if(e!==n.load&&e!==n.none)throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.invalidArgument,null,null);return t=e==n.load?OfficeCore.AppRuntimeState.background:OfficeCore.AppRuntimeState.inactive,o=r(!1),OfficeCore.AppRuntimePersistenceService.newObject(o).setAppRuntimeStartState(t),[4,o.sync()];case 1:return i.sent(),[2]}}))}))},e.getStartupBehavior=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,o,i;return __generator(this,(function(a){switch(a.label){case 0:return e=r(!1),t=OfficeCore.AppRuntimePersistenceService.newObject(e),o=t.getAppRuntimeStartState(),[4,e.sync()];case 1:return a.sent(),i=o.value,[2,i==OfficeCore.AppRuntimeState.inactive?n.none:n.load]}}))}))},e.setSnapshotEnabled=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=r(!0),OfficeCore.AppRuntimeService.newObject(t).setSnapshotEnabled(e),[4,t.sync()];case 1:return n.sent(),[2,Promise.resolve()]}}))}))},e.getSnapshotEnabled=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(o){switch(o.label){case 0:return e=r(!0),t=OfficeCore.AppRuntimeService.newObject(e),n=t.getSnapshotEnabled(),[4,e.sync()];case 1:return o.sent(),[2,n.value]}}))}))},e.getContentSnapshotAsBase64=function(){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(e){return[2,new OfficeExtension.CoreUtility.Promise((function(e,t){var n=r(!0),o=OfficeCore.AppRuntimeService.newObject(n),i=setTimeout((function(){a.remove(),n.sync().catch((function(){})),t(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"timeout","getContentSnapshotAsBase64"))}),7e3),a=o.onSnapshotImageReady.add((function(r){return clearTimeout(i),a.remove(),OfficeExtension.CoreUtility.isNullOrUndefined(r)?(n.sync().catch((function(){})),t(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"execution failed","getContentSnapshotAsBase64"))):(n.sync().catch((function(){})),e(r.imageBase64)),null}));n.sync().then((function(){o.getContentSnapshotAsBase64();return n.sync().then((function(){return null}))})).catch((function(e){t(e)}))}))]}))}))},e._getState=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(o){switch(o.label){case 0:return e=r(!0),t=OfficeCore.AppRuntimeService.newObject(e),n=t.getAppRuntimeState(),[4,e.sync()];case 1:return o.sent(),[2,n.value]}}))}))},e.showAsTaskpane=function(){return o(OfficeCore.AppRuntimeState.visible)},e.hide=function(){return o(OfficeCore.AppRuntimeState.background)},e.onVisibilityModeChanged=function(e){return __awaiter(this,void 0,void 0,(function(){var n,o,a=this;return __generator(this,(function(s){switch(s.label){case 0:return n=function(){if(!i){var e=r(!0);i=OfficeCore.AppRuntimeService.newObject(e)}return i}(),o=n.onVisibilityChanged.add((function(n){if(e){var r={visibilityMode:(o=n.visibility,o===OfficeCore.Visibility.visible?t.taskpane:t.hidden)};e(r)}var o;return null})),[4,n.context.sync()];case 1:return s.sent(),[2,function(){return __awaiter(a,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.remove(),[4,n.context.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},function(e){function t(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}e.enable=function(){return __awaiter(this,void 0,void 0,(function(){var e,n;return __generator(this,(function(r){switch(r.label){case 0:return e=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e=!0),n=t(e),OfficeCore.BeforeDocumentCloseNotification.newObject(n).enable(),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.disable=function(){return __awaiter(this,void 0,void 0,(function(){var e,n;return __generator(this,(function(r){switch(r.label){case 0:return e=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e=!0),n=t(e),OfficeCore.BeforeDocumentCloseNotification.newObject(n).disable(),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.onCloseActionCancelled=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a=this;return __generator(this,(function(s){switch(s.label){case 0:return n=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(n=!0),r=t(n),o=OfficeCore.BeforeDocumentCloseNotification.newObject(r),i=o.onBeforeCloseNotificationCancelled.add((function(t){return e&&e(),null})),[4,r.sync()];case 1:return s.sent(),[2,function(){return __awaiter(a,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.remove(),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.beforeDocumentCloseNotification||(e.beforeDocumentCloseNotification={}))}(e.addin||(e.addin={}))}(Office||(Office={})),function(e){var t,n;!function(e){e.taskpane="Taskpane",e.dialog="Dialog"}(t||(t={})),function(n){function r(e){return new OfficeCore.RequestContext}!function(e){function t(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}e.close=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).close(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))},e.move=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).move(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))},e.notifyHeaderLoaded=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).notifyHeaderLoaded(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))}}(n.taskpane||(n.taskpane={})),n.launchTaskpane=function(n){return __awaiter(this,void 0,void 0,(function(){var o,i,a,s,c;return __generator(this,(function(l){switch(l.label){case 0:return e.context.platform&&"OfficeOnline"===e.context.platform?(o={SharedRuntimeId:n.sharedRuntimeId,SourceLocationOverrideResourceId:n.sourceLocationOverride,TaskPaneTitle:n.taskpaneTitle,TaskPaneWidth:n.taskpaneWidth},i={OptionalProperties:o,DevProperties:n.settings},e.context.extensionLifeCycle.launchExtensionComponent(null,"Taskpane",null,null,i),[3,3]):[3,1];case 1:return a=r(),s=OfficeCore.ExtensionLifeCycle.newObject(a),c=n.settings,n.settings=c&&OSF.OUtil.serializeSettings(c),s.launchExtensionComponent("",t.taskpane,n),[4,a.sync()];case 2:l.sent(),l.label=3;case 3:return[2]}}))}))},n.launchDialog=function(n){return __awaiter(this,void 0,void 0,(function(){var o,i,a,s,c;return __generator(this,(function(l){switch(l.label){case 0:return e.context.platform&&"OfficeOnline"===e.context.platform?(o={SharedRuntimeId:n.sharedRuntimeId,SourceLocationOverrideResourceId:n.sourceLocationOverride},i={OptionalProperties:o,DevProperties:n.settings},e.context.extensionLifeCycle.launchExtensionComponent(null,"SDXDialog",null,null,i),[3,3]):[3,1];case 1:return a=r(),s=OfficeCore.ExtensionLifeCycle.newObject(a),c=n.settings,n.settings=c&&OSF.OUtil.serializeSettings(c),s.launchExtensionComponent("",t.dialog,n),[4,a.sync()];case 2:l.sent(),l.label=3;case 3:return[2]}}))}))}}(n=e.ExtensionLifeCycle||(e.ExtensionLifeCycle={})),e.extensionLifeCycle=n}(Office||(Office={})),function(e){!function(e){e.executePythonCode=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(o){switch(o.label){case 0:return t=new OfficeCore.RequestContext,n=OfficeCore.ExternalCodeService.newObject(t),r=n.executePythonCode(e),[4,t.sync()];case 1:return o.sent(),[2,r.value]}}))}))}}(e.externalCodeService||(e.externalCodeService={}))}(Office||(Office={})),function(e){!function(e){function t(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(r){switch(r.label){case 0:return e=new OfficeCore.RequestContext,t=e.flighting,n=t.getFeatureGate("Microsoft.Office.OEP.UseRequestIdForExternalCodeServiceAsyncCalls"),e.load(n),[4,e.sync()];case 1:return r.sent(),"boolean"==typeof n.value?[2,n.value]:[2,!1]}}))}))}function n(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(r){switch(r.label){case 0:return e=new OfficeCore.RequestContext,t=e.flighting,n=t.getFeatureGate("Microsoft.Office.OEP.UseGenericEventForExternalCodeService"),e.load(n),[4,e.sync()];case 1:return r.sent(),"boolean"==typeof n.value?[2,n.value]:[2,!1]}}))}))}function r(){return new OfficeCore.RequestContext}function o(e){return __awaiter(this,void 0,void 0,(function(){var t,n,o;return __generator(this,(function(i){switch(i.label){case 0:return t=r(),(n=OfficeCore.ExternalCodeService.newObject(t)).onExternalCodeExecutionCompleted.add(e),o=function(){return n.onExternalCodeExecutionCompleted.remove(e),null},[4,t.sync()];case 1:return i.sent(),[2,o]}}))}))}var i=0;function a(e,t,o){return __awaiter(this,void 0,void 0,(function(){var a=this;return __generator(this,(function(s){return[2,new Promise((function(s){return __awaiter(a,void 0,void 0,(function(){var a,c,l,u,d,f=this;return __generator(this,(function(p){switch(p.label){case 0:return a=r(),c=OfficeCore.ExternalCodeService.newObject(a),l=++i,[4,n()];case 1:return p.sent()?(u=function(e){return __awaiter(f,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return e.requestId!=l?[3,3]:[4,c.onExternalCodeServiceResult.remove(u)];case 1:return t.sent(),[4,a.sync()];case 2:return t.sent(),s(e),[2,null];case 3:return[2]}}))}))},[4,c.onExternalCodeServiceResult.add(u)]):[3,3];case 2:return p.sent(),[3,5];case 3:return d=function(e){return __awaiter(f,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return e.requestId!=l?[3,3]:[4,c.onExternalCodeServiceRequestCompleted.remove(d)];case 1:return t.sent(),[4,a.sync()];case 2:return t.sent(),s(e),[2,null];case 3:return[2]}}))}))},[4,c.onExternalCodeServiceRequestCompleted.add(d)];case 4:p.sent(),p.label=5;case 5:return[4,a.sync()];case 6:return p.sent(),c.sendRequestAsync(l,e,t,o),[4,a.sync()];case 7:return p.sent(),[2]}}))}))}))]}))}))}e.executePythonCode=function(e){return __awaiter(this,void 0,void 0,(function(){var n=this;return __generator(this,(function(a){if(null==e||""==e)throw new Error("executePythonCode: Invalid argument");return[2,new Promise((function(a){return __awaiter(n,void 0,void 0,(function(){var n,s,c,l,u=this;return __generator(this,(function(d){switch(d.label){case 0:return n=r(),s=OfficeCore.ExternalCodeService.newObject(n),c=++i,[4,t()];case 1:return d.sent()?(l=function(e){return __awaiter(u,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return e.requestId!=c?[3,3]:[4,s.onExternalCodeServiceResult.remove(l)];case 1:return t.sent(),[4,n.sync()];case 2:return t.sent(),a(e.result),[2,null];case 3:return[2]}}))}))},[4,s.onExternalCodeServiceResult.add(l)]):[3,4];case 2:return d.sent(),[4,n.sync()];case 3:return d.sent(),s.executePythonCodeAsync2(c,e),[3,6];case 4:return[4,o((function(e){return a(e.result),null}))];case 5:d.sent(),s.executePythonCodeAsync(e),d.label=6;case 6:return[4,n.sync()];case 7:return d.sent(),[2]}}))}))}))]}))}))},e.getRuntimeInfoAsync=function(){return __awaiter(this,void 0,void 0,(function(){var e=this;return __generator(this,(function(n){return[2,new Promise((function(n){return __awaiter(e,void 0,void 0,(function(){var e,o,a,s,c,l=this;return __generator(this,(function(u){switch(u.label){case 0:return e=r(),o=++i,a=OfficeCore.ExternalCodeService.newObject(e),[4,t()];case 1:return u.sent()?(s=function(t){return __awaiter(l,void 0,void 0,(function(){var r;return __generator(this,(function(i){switch(i.label){case 0:return t.requestId!=o?[3,3]:[4,a.onExternalCodeServiceResult.remove(s)];case 1:return i.sent(),[4,e.sync()];case 2:return i.sent(),r=JSON.parse(t.result),n(r),[2,null];case 3:return[2]}}))}))},[4,a.onExternalCodeServiceResult.add(s)]):[3,4];case 2:return u.sent(),[4,e.sync()];case 3:return u.sent(),a.getRuntimeInfoAsync2(o),[3,7];case 4:return c=function(t){return __awaiter(l,void 0,void 0,(function(){var r;return __generator(this,(function(o){switch(o.label){case 0:return[4,a.onExternalCodeServiceResult.remove(c)];case 1:return o.sent(),[4,e.sync()];case 2:return o.sent(),r=JSON.parse(t.result),n(r),[2,null]}}))}))},[4,a.onExternalCodeServiceResult.add(c)];case 5:return u.sent(),[4,e.sync()];case 6:u.sent(),a.getRuntimeInfoAsync(),u.label=7;case 7:return[4,e.sync()];case 8:return u.sent(),[2]}}))}))}))]}))}))},e.sendRequestToService=function(e){return __awaiter(this,void 0,void 0,(function(){var t,r,o,i;return __generator(this,(function(s){switch(s.label){case 0:return(t="string"==typeof e.body?e.body:JSON.stringify(e.body))&&"string"==typeof e.body||(t=""),r=Date.now(),[4,a(e.method,e.serverRelativeUrl,t)];case 1:return(o=s.sent())?(i=null,[4,n()]):(OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.ExternalCodeServiceCore.SendRequestToService",dataFields:[oteljs.makeInt64DataField("Duration",Date.now()-r)],eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}}),[2,{status:400,body:null}]);case 2:return i=s.sent()?0==o.result.length?null:JSON.parse(o.result):0==o.body.length?null:JSON.parse(o.body),OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.ExternalCodeServiceCore.SendRequestToService",dataFields:[oteljs.makeInt64DataField("Duration",Date.now()-r),oteljs.makeInt64DataField("Status",o.status)],eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}}),[2,{status:o.status,body:i}]}}))}))}}(e.externalCodeService||(e.externalCodeService={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}e.requestUpdate=function(e){var n=t(),r=n.ribbon;function o(e){void 0!==e.controls&&void 0!==e.controls.length&&e.controls.length&&e.controls.filter((function(e){return!!e.id})).forEach((function(e){var t=r.getButton(e.id);void 0!==e.enabled&&null!==e.enabled&&(t.enabled=e.enabled)}))}return e.tabs.filter((function(e){return!!e.id})).forEach((function(e){var t=r.getTab(e.id);void 0!==e.visible&&null!==e.visible&&t.setVisibility(e.visible),e.groups&&e.groups.length?e.groups.filter((function(e){return!!e.id})).forEach((function(e){o(e)})):o(e)})),n.sync()},e.requestCreateControls=function(e){var n,r=t();return r.ribbon.executeRequestCreate(JSON.stringify(e)),(n=250,new Promise((function(e,t){return setTimeout((function(){return e()}),n)}))).then((function(){return r.sync()}))}}(e.ribbon||(e.ribbon={}))}(Office||(Office={})),function(e){var t;OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;!function(e){e.generalException="GeneralException"}(t||(t={}));new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[],strings:["AddinInternalService"],enumTypes:[],clientObjectTypes:[[1,0,0,0,[["notifyActionHandlerReady",0,2,0,4]],0,0,0,0,"Microsoft.InternalService.AddinInternalService",4]]},targetNamespaceObject:e})}(OfficeCore||(OfficeCore={})),function(e){var t;!function(t){var n,r,o=OfficeExtension.Utility.isNullOrUndefined;function i(e){if(e){var t=e.toUpperCase(),r=n.mappings[t];if(!o(r)&&"function"==typeof r)return r}throw OfficeExtension.Utility.createRuntimeError("invalidOperation","sourceData","ActionProxy._getFunction")}function a(e){try{OfficeExtension.Utility.log("ActionProxy._handleMessage"),OfficeExtension.Utility.checkArgumentNull(e,"args");for(var t=e.entries,n=0;n<t.length;n++)if(2===t[n].messageCategory)if("string"==typeof t[n].message&&(t[n].message=JSON.parse(t[n].message)),1e3===t[n].messageType){var r=null,o=i(t[n].message[0]);if(t[n].message.length>=2){var a=t[n].message[1];a&&(r=s(a)?JSON.parse(a):a)}void 0!==OSF&&OSF.AppTelemetry&&OSF.AppTelemetry.CallOnAppActivatedIfPending&&OSF.AppTelemetry.CallOnAppActivatedIfPending(),o.apply(null,[r])}else OfficeExtension.Utility.log("ActionProxy._handleMessage unknown message type "+t[n].messageType)}catch(e){throw function(e){var t=function(e){var t="Unknown Error";if(e)try{e.toString&&(t=e.toString()),t=t+" "+JSON.stringify(e)}catch(e){t="Unexpected Error"}return t}(e);OfficeExtension.Utility.log(t)}(e),e}return OfficeExtension.Utility._createPromiseFromResult(null)}function s(e){return"string"==typeof e&&"{"===e[0]}function c(){try{Microsoft.Office.WebExtension.onReadyInternal().then((function(){return function(){if(void 0!==OSF&&OSF.DDA&&OSF.DDA.RichApi&&OSF.DDA.RichApi.richApiMessageManager)return(new OfficeExtension.ClientRequestContext).eventRegistration.register(5,"",a)}()})).then((function(){var e,t,n=OSF._OfficeAppFactory.getHostInfo();return!0===n.isDialog||"web"===n.hostPlatform&&"word"!==n.hostType&&"excel"!==n.hostType?void 0:(e=new OfficeExtension.ClientRequestContext,t=OfficeCore.AddinInternalService.newObject(e),e._customData="WacPartition",t.notifyActionHandlerReady(),e.sync())}))}catch(e){}}OfficeExtension.Utility.log("ActionProxy.initOnce"),void 0!==e.actions&&(r=e.actions._association,n=r),"undefined"!=typeof document&&(document.readyState&&"loading"!==document.readyState?(OfficeExtension.Utility.log("ActionProxy.initOnce: document.readyState is not loading state"),c()):document.addEventListener&&document.addEventListener("DOMContentLoaded",(function(){OfficeExtension.Utility.log("ActionProxy.initOnce: DOMContentLoaded event triggered"),c()}))),OfficeExtension.HostBridge.onInited((function(e){!function(e){e.addHostMessageHandler((function(e){3===e.type&&a(e.message)}))}(e)}))}(t||(t={}))}(Office||(Office={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}e.areShortcutsInUse=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a;return __generator(this,(function(s){switch(s.label){case 0:return n=t(),r=OfficeCore.ActionService.newObject(n),o=r.areShortcutsInUse(e),[4,n.sync()];case 1:for(s.sent(),i=[],a=0;a<e.length;a++)i.push({shortcut:e[a],inUse:o.value[a]});return[2,i]}}))}))},e.replaceShortcuts=function(e){return __awaiter(this,void 0,void 0,(function(){var n;return __generator(this,(function(r){switch(r.label){case 0:return n=t(),OfficeCore.ActionService.newObject(n).replaceShortcuts(e),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.getShortcuts=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.ActionService.newObject(e),r=n.getShortcuts(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))}}(e.actions||(e.actions={}))}(Office||(Office={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}e.SendMessage=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,o;return __generator(this,(function(i){switch(i.label){case 0:return r=void 0!==n?n:e,o=t(void 0!==n?e:void 0),OfficeCore.AugLoopEventService.newObject(o).sendMessage(r),[4,o.sync()];case 1:return i.sent(),[2]}}))}))},e.onHostMessageReceived=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,o,i,a,s=this;return __generator(this,(function(c){switch(c.label){case 0:return r=void 0!==n?n:e,o=t(void 0!==n?e:void 0),i=OfficeCore.AugLoopEventService.newObject(o),a=function(e){if(r){var t=e.data;r(t)}return null},i.onHostMessageReceived.add(a),[4,i.context.sync()];case 1:return c.sent(),[2,function(){return __awaiter(s,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.onHostMessageReceived.remove(a),[4,o.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.AugLoop||(e.AugLoop={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){return"object"==typeof e&&"string"==typeof e.controlId?e.controlId:void 0}function n(e){var t=new OfficeCore.RequestContext;return e&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e),t._customData="SkipUndoRecording",t}var r,o={};e.undo=function(e){return __awaiter(this,void 0,void 0,(function(){var r,o,i;return __generator(this,(function(a){switch(a.label){case 0:return r=n(t(e)),o=OfficeCore.UndoService.newObject(r),i=o.undo(),[4,r.sync()];case 1:return a.sent(),[2,i.value]}}))}))},e.onUndoStackChanged=function(e,r){return __awaiter(this,void 0,void 0,(function(){var o,i,a,s=this;return __generator(this,(function(c){switch(c.label){case 0:return o=r||e,i=n(t(r?e:void 0)),(a=OfficeCore.UndoService.newObject(i)).onUndoStackChanged.add(o),[4,i.sync()];case 1:return c.sent(),[2,function(){return __awaiter(s,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return a.onUndoStackChanged.remove(o),[4,i.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.startCopilotOperation=function(e){return __awaiter(this,void 0,void 0,(function(){var i,a,s,c,l,u,d,f;return __generator(this,(function(p){switch(p.label){case 0:if(void 0===(i=t(e))){if(void 0!==r)throw new Error("startCopilotOperation is already inprogress")}else if(o[i])throw new Error("startCopilotOperation is already in progress");a=function(){},s=new Promise((function(e){void 0===i?r=e:o[i]=e})),p.label=1;case 1:return p.trys.push([1,4,,5]),c=n(i),l=OfficeCore.UndoService.newObject(c),u=function(){return function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){return void 0===e?void 0!==r&&(r(),r=void 0):o[e]&&(o[e](),delete o[e]),[2]}))}))}(i)},a=function(){try{l.onCopilotOperationStarted.remove(u),c.sync()}catch(e){}},l.onCopilotOperationStarted.add(u),[4,c.sync()];case 2:return p.sent(),d=l.startCopilotOperation(""),[4,c.sync()];case 3:return p.sent(),d.value?(void 0!==i&&s.then((function(){a()})),[2,s]):(void 0===i?r=void 0:(a(),delete o[i]),[3,5]);case 4:throw f=p.sent(),void 0===i?r=void 0:(a(),delete o[i]),f;case 5:return[2]}}))}))},e.endCopilotOperation=function(e){return __awaiter(this,void 0,void 0,(function(){var r;return __generator(this,(function(o){switch(o.label){case 0:return r=n(t(e)),OfficeCore.UndoService.newObject(r).endCopilotOperation(""),[4,r.sync()];case 1:return o.sent(),[2]}}))}))}}(e.Undo||(e.Undo={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){var t;(t=e.dialogPage||(e.dialogPage={})).close=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return e=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(e).close(),[4,e.sync()];case 1:return t.sent(),[2]}}))}))},t.readyToShow=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return e=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(e).readyToShow(),[4,e.sync()];case 1:return t.sent(),[2]}}))}))},t.onShow=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(o){switch(o.label){case 0:return t=new OfficeCore.RequestContext,(n=OfficeCore.DialogPage.newObject(t)).onOnShowEvent.add(e),r=function(){return n.onOnShowEvent.remove(e),null},[4,t.sync()];case 1:return o.sent(),[2,r]}}))}))},t.sendMessageToHost=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(t).sendMessageToHost(e),[4,t.sync()];case 1:return n.sent(),[2]}}))}))}}(Office||(Office={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.CollectUserFeedback=function(e,n,r,o){return __awaiter(this,void 0,void 0,(function(){var i;return __generator(this,(function(a){switch(a.label){case 0:return i=t(),OfficeCore.UserFeedbackService.newObject(i).collectUserFeedback(e,n,r,o),[4,i.sync()];case 1:return a.sent(),[2]}}))}))},e.onUserFeedbackUIDismissed=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.isFeedbackSent;e(n)}return null},r=t(),(o=OfficeCore.UserFeedbackService.newObject(r)).onUserFeedbackUIDismissed.add(n),[4,o.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(i,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.onUserFeedbackUIDismissed.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.CanCollectUserFeedback=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.canCollectUserFeedback(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))},e.onUserFeedbackResponse=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.responseData;e(n)}return null},r=t(),(o=OfficeCore.UserFeedbackService.newObject(r)).onUserFeedbackResponse.add(n),[4,o.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(i,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.onUserFeedbackResponse.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.InvokeDiagnosticsLogsUpload=function(e){return __awaiter(this,void 0,void 0,(function(){var n;return __generator(this,(function(r){switch(r.label){case 0:return n=t(),OfficeCore.UserFeedbackService.newObject(n).invokeDiagnosticsLogsUpload(e),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.GetInitializationData=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.getInitializationData(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))},e.GetHostScreenshot=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.getHostScreenshot(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))},e.CanCollectCopilotFeedback=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(o){switch(o.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.canCollectCopilotFeedback(),[4,e.sync()];case 1:return o.sent(),[2,r.value]}}))}))}}(e.UserFeedback||(e.UserFeedback={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){var t=function(){};function n(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}function r(e){return JSON.stringify(e instanceof t?{type:"callout",params:e.params}:{type:"custom",props:e})}e.callout=function(e){var n=new t;return n.params=e,n},e.addNotification=function(e,t){return __awaiter(this,void 0,void 0,(function(){var o,i,a;return __generator(this,(function(s){switch(s.label){case 0:return o=n(),i=OfficeCore.NotificationService.newObject(o),a=i.addNotification(r(e),function(e){return JSON.stringify(e)}(t)),[4,o.sync()];case 1:return s.sent(),[2,a.value]}}))}))},e.updateNotification=function(e,t){return __awaiter(this,void 0,void 0,(function(){var o;return __generator(this,(function(i){switch(i.label){case 0:return o=n(),OfficeCore.NotificationService.newObject(o).updateNotification(e,r(t)),[4,o.sync()];case 1:return i.sent(),[2]}}))}))},e.removeNotification=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(r){switch(r.label){case 0:return t=n(),OfficeCore.NotificationService.newObject(t).removeNotification(e),[4,t.sync()];case 1:return r.sent(),[2]}}))}))}}(e.Notification||(e.Notification={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}e.getLabel=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o;return __generator(this,(function(i){switch(i.label){case 0:return n=t(e),r=OfficeCore.SensitivityService.newObject(n),o=r.getLabel(),[4,n.sync()];case 1:return i.sent(),[2,o.value]}}))}))},e.tryUpgradeLabel=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a;return __generator(this,(function(s){switch(s.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("tryUpgradeLabel: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,o=n?e[1]:e[0],i=n?e[2]:e[1],a=t(r),OfficeCore.SensitivityService.newObject(a).tryUpgradeLabel(o,i),[4,a.sync()];case 1:return s.sent(),[2]}}))}))},e.getHighestSensitivityLabel=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a,s;return __generator(this,(function(c){switch(c.label){case 0:if(n=2===e.length,1!==e.length&&2!==e.length)throw new Error("getHighestSensitivityLabel: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,o=n?e[1]:e[0],i=t(r),a=OfficeCore.SensitivityService.newObject(i),s=a.getHighestSensitivityLabel(o),[4,i.sync()];case 1:return c.sent(),[2,s.value]}}))}))},e.getSensitivityResultDetails=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a,s,c;return __generator(this,(function(l){switch(l.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,o=n?e[1]:e[0],i=n?e[2]:e[1],a=t(r),s=OfficeCore.SensitivityService.newObject(a),c=s.getSensitivityResultDetails(o,i),[4,a.sync()];case 1:return l.sent(),[2,c.value]}}))}))},e.getSensitivityResultDetailsByStringErrorCode=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a,s,c;return __generator(this,(function(l){switch(l.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,o=n?e[1]:e[0],i=n?e[2]:e[1],a=t(r),s=OfficeCore.SensitivityService.newObject(a),c=s.getSensitivityResultDetailsByStringErrorCode(o,i),[4,a.sync()];case 1:return l.sent(),[2,c.value]}}))}))},e.onLabelChangedEvent=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,o,i,a,s,c=this;return __generator(this,(function(l){switch(l.label){case 0:if(n=2===e.length,1!==e.length&&2!==e.length)throw new Error("onLabelChangedEvent: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,o=n?e[1]:e[0],i=function(e){if(o){var t=e.previousLabel,n=e.newLabel,r=e.context,i=e.error;o(t,n,r,i)}return null},a=t(r),(s=OfficeCore.SensitivityService.newObject(a)).onLabelChanged.add(i),[4,s.context.sync()];case 1:return l.sent(),[2,function(){return __awaiter(c,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return s.onLabelChanged.remove(i),[4,a.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.Sensitivity||(e.Sensitivity={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.launchHelpPaneByQuery=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(o){switch(o.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByQuery(e),[4,n.sync()];case 1:return o.sent(),[2]}}))}))},e.launchHelpPaneByArticleId=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(o){switch(o.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByArticleId(e),[4,n.sync()];case 1:return o.sent(),[2]}}))}))},e.launchHelpPaneByArticleIdString=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(o){switch(o.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByArticleIdString(e),[4,n.sync()];case 1:return o.sent(),[2]}}))}))}}(e.Copilot||(e.Copilot={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.execute=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o;return __generator(this,(function(i){switch(i.label){case 0:return n=t(),r=OfficeCore.PrivateApiService.newObject(n),o=r.execute(e),[4,n.sync()];case 1:return i.sent(),[2,o.value]}}))}))},e.onPrivateEvent=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,o,i=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.messageData;e(n)}return null},r=t(),(o=OfficeCore.PrivateApiService.newObject(r)).onOnPrivateEvent.add(n),[4,o.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(i,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.onOnPrivateEvent.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.PrivateApi||(e.PrivateApi={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}e.hide=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(o){switch(o.label){case 0:return n=t(),r=OfficeCore.BusinessBarService.newObject(n),r.hide(e),[4,n.sync()];case 1:return o.sent(),[2]}}))}))},e.show=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r;return __generator(this,(function(o){switch(o.label){case 0:return r=t(),OfficeCore.BusinessBarService.newObject(r).show(e,n),[4,r.sync()];case 1:return o.sent(),[2]}}))}))}}(e.BusinessBar||(e.BusinessBar={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.launchSimpleDialog=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(o){switch(o.label){case 0:return t=function(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(),n=OfficeCore.ShowSimpleDialog.newObject(t),r=n.launchSimpleDialog(e.title,e.description,e.telemetryid,e.category,e.hasButton,e.buttonLabel,e.hasCheckbox,e.checkboxLabel),[4,t.sync()];case 1:return o.sent(),[2,r.value]}}))}))}}(e.SimpleDialog||(e.SimpleDialog={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.execute=function(e,t){return __awaiter(this,void 0,void 0,(function(){var n,r,o;return __generator(this,(function(i){switch(i.label){case 0:return n=function(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}(),r=OfficeCore.DispatchApiService.newObject(n),o=r.execute(e,t),[4,n.sync()];case 1:return i.sent(),[2,o.value]}}))}))}}(e.DispatchApi||(e.DispatchApi={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.camera="camera",e.microphone="microphone",e.geolocation="geolocation"}(e.DevicePermissionType||(e.DevicePermissionType={})),function(e){e.requestPermissions=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(o){switch(o.label){case 0:return t=function(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(),n=OfficeCore.DevicePermissionService.newObject(t),r=n.requestPermissions(e),[4,t.sync()];case 1:return o.sent(),[2,r.value]}}))}))}}(e.devicePermission||(e.devicePermission={}))}(Office||(Office={})),function(e){var t=function(){function t(e){this.m_activeView=e}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.ActiveViewChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"activeView",{get:function(){return this.m_activeView.activeView},enumerable:!0,configurable:!0}),t}();e.ActiveViewChangedEventArgs=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t,n,r,o){this._requiredParameters=e,this._supportedOptions=t,this._privateStateCallbacks=n,this._checkCallArgs=r,this._displayName=o,this._requiredCount=e.length}return t.prototype.verifyArguments=function(t,n){for(var r in t){var o=t[r],i=n[r];if(o.enum)switch(typeof i){case"string":if(e.OUtil.listContainsValue(o.enum,i))break;case"undefined":throw 5007;default:throw this.getInvalidParameterString()}if(o.types&&!e.OUtil.listContainsValue(o.types,typeof i))throw this.getInvalidParameterString()}},t.prototype.extractRequiredArguments=function(t,n,r){if(t.length<this._requiredCount)throw e.Utility.createParameterException(Strings.OfficeOM.L_MissingRequiredArguments);var o,i=[];for(o=0;o<this._requiredCount;o++)i.push(t[o]);this.verifyArguments(this._requiredParameters,i);var a={};for(o=0;o<this._requiredCount;o++){var s=this._requiredParameters[o],c=i[o];if(s.verify)if(!s.verify(c,n,r))throw this.getInvalidParameterString();a[s.name]=c}return a},t.prototype.fillOptions=function(t,n,r,o){for(var i in t=t||{},this._supportedOptions)if(!e.OUtil.listContainsKey(t,i)){var a=void 0,s=this._supportedOptions[i];s.calculate&&n&&(a=s.calculate(n,r,o)),a||void 0===s.defaultValue||(a=s.defaultValue),t[i]=a}return t},t.prototype.constructCallArgs=function(e,t,n,r){var o={};for(var i in e)o[i]=e[i];for(var a in t)o[a]=t[a];for(var s in this._privateStateCallbacks)o[s]=this._privateStateCallbacks[s](n,r);return this._checkCallArgs&&(o=this._checkCallArgs(o,n,r)),o},t.prototype.getInvalidParameterString=function(){var t=this;e.OUtil.delayExecutionAndCache((function(){return e.OUtil.formatString(Strings.OfficeOM.L_InvalidParameters,t._displayName)}))},t}();e.ApiMethodCall=t}(OSF||(OSF={})),function(e){var t=function(){function t(t,n,r,o,i,a,s){this._requiredParameters=t,this._supportedOptions=n,this._privateStateCallbacks=r,this._onSucceeded=o,this._onFailed=i,this._displayName=s,this._checkCallArgs=a,this._requiredCount=t.length,this._apiMethods=new e.ApiMethodCall(t,n,r,a,s)}return t.prototype.verifyAndExtractCall=function(e,t,n){var r=this._apiMethods.extractRequiredArguments(e,t,n),o=this.extractOptions(e,r,t,n);return this._apiMethods.constructCallArgs(r,o,t,n)},t.prototype.processResponse=function(t,n,r,o){return 0==t?this._onSucceeded?this._onSucceeded(n,r,o):n:this._onFailed?this._onFailed(t,n):e.DDA.ErrorCodeManager.getErrorArgs(t)},t.prototype.getCallArgs=function(t){for(var n,r,o=t.length-1;o>=this._requiredCount;o--){var i=t[o];switch(typeof i){case"object":n=i;break;case"function":r=i}}return n=n||{},r&&(n[e.ParameterNames.Callback]=r),n},t.prototype.extractOptions=function(t,n,r,o){if(t.length>this._requiredCount+2)throw e.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);for(var i,a,s=t.length-1;s>=this._requiredCount;s--){var c=t[s];switch(typeof c){case"object":if(i)throw e.Utility.createParameterException(Strings.OfficeOM.L_TooManyOptionalObjects);i=c;break;case"function":if(a)throw e.Utility.createParameterException(Strings.OfficeOM.L_TooManyOptionalFunction);a=c;break;default:throw e.Utility.createArgumentException(Strings.OfficeOM.L_InValidOptionalArgument)}}if(i=this._apiMethods.fillOptions(i,n,r,o),a){if(i[e.ParameterNames.Callback])throw Strings.OfficeOM.L_RedundantCallbackSpecification;i[e.ParameterNames.Callback]=a}return this._apiMethods.verifyArguments(this._supportedOptions,i),i},t}();e.AsyncMethodCall=t}(OSF||(OSF={})),function(e){!function(t){var n={};t.define=function(t){var r,o,i;n[t.method]=(o=(r=t).supportedOptions?e.OUtil.createObject(r.supportedOptions):[],i=r.privateStateCallbacks?e.OUtil.createObject(r.privateStateCallbacks):[],new e.AsyncMethodCall(r.requiredArguments||[],o,i,r.onSucceeded,r.onFailed,r.checkCallArgs,r.method))},t.get=function(e){return n[e]}}(e.AsyncMethodCalls||(e.AsyncMethodCalls={}))}(OSF||(OSF={})),function(e){e.AsyncMethods={AddColumnsAsync:"addColumnsAsync",AddFromSelectionAsync:"addFromSelectionAsync",AddFromNamedItemAsync:"addFromNamedItemAsync",AddFromPromptAsync:"addFromPromptAsync",AddHandlerAsync:"addHandlerAsync",AddRowsAsync:"addRowsAsync",BindingSelectionChanged:"bindingSelectionChanged",BindingDataChanged:"bindingDataChanged",ClearFormatsAsync:"clearFormatsAsync",CloseAsync:"close",CloseContainerAsync:"closeContainer",DeleteAllDataValuesAsync:"deleteAllDataValuesAsync",DisplayDialogAsync:"displayDialogAsync",ExecuteFeature:"executeFeature",ExecuteRichApiRequestAsync:"executeRichApiRequestAsync",GetAllAsync:"getAllAsync",GetAccessTokenAsync:"getAccessTokenAsync",GetByIdAsync:"getByIdAsync",GetDataAsync:"getDataAsync",GetDocumentCopyAsync:"getFileAsync",GetDocumentCopyChunkAsync:"getSliceAsync",GetFilePropertiesAsync:"getFilePropertiesAsync",GetSelectedDataAsync:"getSelectedDataAsync",GoToByIdAsync:"goToByIdAsync",OpenBrowserWindow:"openBrowserWindow",QueryFeature:"queryFeature",ReleaseByIdAsync:"releaseByIdAsync",RemoveHandlerAsync:"removeHandlerAsync",ReleaseDocumentCopyAsync:"closeAsync",SetDataAsync:"setDataAsync",SetFormatsAsync:"setFormatsAsync",SetSelectedDataAsync:"setSelectedDataAsync",SetTableOptionsAsync:"setTableOptionsAsync",GetOfficeThemeAsync:"getOfficeThemeAsync",GetDocumentThemeAsync:"getDocumentThemeAsync"}}(OSF||(OSF={})),function(e){!function(e){e.Subset="subset",e.BindingProperties="BindingProperties"}(e.PropertyDescriptors||(e.PropertyDescriptors={}));var t=function(){function t(e,t){this.m_bindingInstance=e,this.m_subset=t}return Object.defineProperty(t.prototype,"startRow",{get:function(){return this.m_subset.startRow},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"startColumn",{get:function(){return this.m_subset.startColumn},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rowCount",{get:function(){return this.m_subset.rowCount},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"columnCount",{get:function(){return this.m_subset.columnCount},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.BindingSelectionChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"binding",{get:function(){return this.m_bindingInstance},enumerable:!0,configurable:!0}),t}();e.BindingSelectionChangedEventArgs=t;var n=function(){function t(e){this.m_bindingInstance=e}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.BindingDataChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"binding",{get:function(){return this.m_bindingInstance},enumerable:!0,configurable:!0}),t}();e.BindingDataChangedEventArgs=n}(OSF||(OSF={})),function(e){!function(e){e.DataPartProperties="DataPartProperties",e.DataNodeProperties="DataNodeProperties"}(e.PropertyDescriptors||(e.PropertyDescriptors={})),function(e){!function(e){!function(e){e.OldNode="OldNode",e.NewNode="NewNode",e.NextSiblingNode="NextSiblingNode",e.InUndoRedo="InUndoRedo"}(e.DataNodeEventProperties||(e.DataNodeEventProperties={}))}(e.Customxml||(e.Customxml={}))}(e.Marshaling||(e.Marshaling={})),function(e){e.DataNodeInsertedEvent="DataNodeInsertedEvent",e.DataNodeReplacedEvent="DataNodeReplacedEvent",e.DataNodeDeletedEvent="DataNodeDeletedEvent"}(e.EventDescriptors||(e.EventDescriptors={})),function(e){e.OldNode="OldNode",e.NewNode="NewNode",e.NextSiblingNode="NextSiblingNode",e.InUndoRedo="InUndoRedo"}(e.DataNodeEventProperties||(e.DataNodeEventProperties={}));var t=function(){function t(e,t){this.m_newNode=e,this.m_inUndoRedo=t}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.DataNodeInserted},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"newNode",{get:function(){return this.m_newNode},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),t}();e.NodeInsertedEventArgs=t;var n=function(){function t(e,t,n){this.m_oldNode=e,this.m_newNode=t,this.m_inUndoRedo=n}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.DataNodeReplaced},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"oldNode",{get:function(){return this.m_oldNode},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"newNode",{get:function(){return this.m_newNode},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),t}();e.NodeReplacedEventArgs=n;var r=function(){function t(e,t,n){this.m_oldNode=e,this.m_oldNextSibling=t,this.m_inUndoRedo=n}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.DataNodeDeleted},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"oldNode",{get:function(){return this.m_oldNode},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"oldNextSibling",{get:function(){return this.m_oldNextSibling},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),t}();e.NodeDeletedEventArgs=r}(OSF||(OSF={})),function(e){var t=function(t){0==t[e.PropertyDescriptors.MessageType]?e.OUtil.defineEnumerableProperties(this,{type:{value:e.EventType.DialogMessageReceived},message:{value:t[e.PropertyDescriptors.MessageContent]},origin:{value:t[e.PropertyDescriptors.MessageOrigin]}}):e.OUtil.defineEnumerableProperties(this,{type:{value:e.EventType.DialogEventReceived},error:{value:t[e.PropertyDescriptors.MessageType]}})};e.DialogEventArgs=t,function(e){e.MessageType="messageType",e.MessageContent="messageContent",e.MessageOrigin="messageOrigin"}(e.PropertyDescriptors||(e.PropertyDescriptors={}))}(OSF||(OSF={})),function(e){var t=function(){function t(e){this.m_docInstance=e}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.DocumentSelectionChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"document",{get:function(){return this.m_docInstance},enumerable:!0,configurable:!0}),t}();e.DocumentSelectionChangedEventArgs=t}(OSF||(OSF={})),function(e){var t=function(t){e.OUtil.defineEnumerableProperties(this,{type:{value:e.EventType.DialogParentMessageReceived},message:{value:t[e.PropertyDescriptors.MessageContent]},origin:{value:t[e.PropertyDescriptors.MessageOrigin]}})};e.DialogParentEventArgs=t}(OSF||(OSF={})),function(e){e.DialogShownStatus={hasDialogShown:!1,isWindowDialog:!1},function(t){var n;function r(t){return t==e.EventDispId.dispidObjectDeletedEvent||t==e.EventDispId.dispidObjectSelectionChangedEvent||t==e.EventDispId.dispidObjectDataChangedEvent||t==e.EventDispId.dispidContentControlAddedEvent}function o(t,n,r,o){if("number"!=typeof t)throw t;o||(o=n.getCallArgs(r)),s(o,t,e.DDA.ErrorCodeManager.getErrorArgs(t))}function i(t){return(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web?e.WACDelegate:e.SafeArrayDelegate)[t]}function a(){return n||function(){n={};var t={GoToByIdAsync:82,GetSelectedDataAsync:64,SetSelectedDataAsync:65,GetDocumentCopyChunkAsync:80,ReleaseDocumentCopyAsync:81,GetDocumentCopyAsync:77,AddFromSelectionAsync:66,AddFromPromptAsync:67,AddFromNamedItemAsync:78,GetAllAsync:74,GetByIdAsync:68,ReleaseByIdAsync:69,GetDataAsync:70,SetDataAsync:71,AddRowsAsync:72,AddColumnsAsync:79,DeleteAllDataValuesAsync:73,RefreshAsync:75,SaveAsync:76,GetActiveViewAsync:83,GetFilePropertiesAsync:86,GetOfficeThemeAsync:85,GetDocumentThemeAsync:84,ClearFormatsAsync:87,SetTableOptionsAsync:88,SetFormatsAsync:89,GetUserIdentityInfoAsync:92,GetAccessTokenAsync:98,GetAuthContextAsync:99,ExecuteRichApiRequestAsync:93,AppCommandInvocationCompletedAsync:94,CloseContainerAsync:97,OpenBrowserWindow:102,CreateDocumentAsync:105,InsertFormAsync:106,ExecuteFeature:146,QueryFeature:147,AddDataPartAsync:128,GetDataPartByIdAsync:129,GetDataPartsByNameSpaceAsync:130,GetPartXmlAsync:131,GetPartNodesAsync:132,DeleteDataPartAsync:133,GetNodeValueAsync:134,GetNodeXmlAsync:135,GetRelativeNodesAsync:136,SetNodeValueAsync:137,SetNodeXmlAsync:138,AddDataPartNamespaceAsync:139,GetDataPartNamespaceAsync:140,GetDataPartPrefixAsync:141,GetNodeTextAsync:142,SetNodeTextAsync:143,GetSelectedTask:110,GetTask:112,GetWSSUrl:114,GetTaskField:115,GetSelectedResource:111,GetResourceField:113,GetProjectField:116,GetSelectedView:117,GetTaskByIndex:118,GetResourceByIndex:119,SetTaskField:120,SetResourceField:121,GetMaxTaskIndex:122,GetMaxResourceIndex:123,CreateTask:124};for(var r in t)e.AsyncMethods[r]&&(n[e.AsyncMethods[r]]=t[r]);var o={MessageParent:144,SendMessage:145};for(var r in o)e.SyncMethods[r]&&(n[e.SyncMethods[r]]=o[r]);var i={SettingsChanged:e.EventDispId.dispidSettingsChangedEvent,DocumentSelectionChanged:e.EventDispId.dispidDocumentSelectionChangedEvent,BindingSelectionChanged:e.EventDispId.dispidBindingSelectionChangedEvent,BindingDataChanged:e.EventDispId.dispidBindingDataChangedEvent,ActiveViewChanged:e.EventDispId.dispidActiveViewChangedEvent,OfficeThemeChanged:e.EventDispId.dispidOfficeThemeChangedEvent,DocumentThemeChanged:e.EventDispId.dispidDocumentThemeChangedEvent,AppCommandInvoked:e.EventDispId.dispidAppCommandInvokedEvent,DialogMessageReceived:e.EventDispId.dispidDialogMessageReceivedEvent,DialogParentMessageReceived:e.EventDispId.dispidDialogParentMessageReceivedEvent,ObjectDeleted:e.EventDispId.dispidObjectDeletedEvent,ObjectSelectionChanged:e.EventDispId.dispidObjectSelectionChangedEvent,ObjectDataChanged:e.EventDispId.dispidObjectDataChangedEvent,ContentControlAdded:e.EventDispId.dispidContentControlAddedEvent,LiveShareStateChanged:e.EventDispId.dispidLiveShareStateChangedEvent,RichApiMessage:e.EventDispId.dispidRichApiMessageEvent,DataNodeInserted:e.EventDispId.dispidDataNodeAddedEvent,DataNodeReplaced:e.EventDispId.dispidDataNodeReplacedEvent,DataNodeDeleted:e.EventDispId.dispidDataNodeDeletedEvent};for(var a in i)e.EventType[a]&&(n[e.EventType[a]]=i[a])}(),n}function s(t,n,r){var o=t[e.ParameterNames.Callback];if(o){var i,a={};a[e.DDA.AsyncResultEnum.Properties.Context]=t[e.ParameterNames.AsyncContext],0==n?a[e.DDA.AsyncResultEnum.Properties.Value]=r:(i={},r=r||e.DDA.ErrorCodeManager.getErrorArgs(5001),i[e.DDA.AsyncResultEnum.ErrorProperties.Code]=n||5001,i[e.DDA.AsyncResultEnum.ErrorProperties.Name]=r.name||r,i[e.DDA.AsyncResultEnum.ErrorProperties.Message]=r.message||r),o(new e.DDA.AsyncResult(a,i))}}t.InvokeMethod=function(t,n,r,c){var l;try{var u=e.AsyncMethodCalls.get(t);l=u.verifyAndExtractCall(n,r,c);var d=a()[t],f=i("executeAsync"),p=null;if(window.Excel&&window.Office.context.requirements.isSetSupported("RedirectV1Api")&&(window.Excel._RedirectV1APIs=!0),window.Excel&&window.Excel._RedirectV1APIs&&(p=window.Excel._V1APIMap[t])){var g=e.OUtil.shallowCopy(l);delete g[e.ParameterNames.AsyncContext],p.preprocess&&(g=p.preprocess(g));var h=new window.Excel.RequestContext,m=p.call(h,g);h.sync().then((function(){var t=m.value,n=t.status;delete t.status,delete t["@odata.type"],p.postprocess&&(t=p.postprocess(t,g)),0!=n&&(t=e.DDA.ErrorCodeManager.getErrorArgs(n)),s(l,n,t)})).catch((function(e){s(l,13991,null)}))}else{var y;y=e.HostParameterMap.toHost(d,l);var v=(new Date).getTime();f({dispId:d,hostCallArgs:y,onCalling:function(){},onReceiving:function(){},onComplete:function(t,n){var o;o=0==t?e.HostParameterMap.fromHost(d,n):n;var i=u.processResponse(t,o,r,l);s(l,t,i),e.AppTelemetry&&e.AppTelemetry.onMethodDone(d,y,Math.abs((new Date).getTime()-v),t)}})}}catch(e){o(e,u,n,l)}},t.AddEventHandler=function(t,n,c,l){var u,d,f,p=!1;function g(t){var r;0==t&&((p?n.addObjectEventHandler(d,u[e.ParameterNames.Id],f):n.addEventHandler(d,f))||(t=13991));0!=t&&(r=e.DDA.ErrorCodeManager.getErrorArgs(t)),s(u,t,r)}try{var h=e.AsyncMethodCalls.get(e.AsyncMethods.AddHandlerAsync);if(u=h.verifyAndExtractCall(t,c,n),d=u[e.ParameterNames.EventType],f=u[e.ParameterNames.Handler],l)return void g(0);var m=a()[d],y=(p=r(m))?u[e.ParameterNames.Id]:c.id||"";if(0==(p?n.getObjectEventHandlerCount(d,y):n.getEventHandlerCount(d)))i("registerEventAsync")({eventType:d,dispId:m,targetId:y,onCalling:function(){},onReceiving:function(){},onComplete:g,onEvent:function(t){var r=e.HostParameterMap.fromHost(m,t);p?n.fireObjectEvent(y,e.manufactureEventArgs(d,y,r)):n.fireEvent(e.manufactureEventArgs(d,c,r))}});else g(0)}catch(e){o(e,h,t,u)}},t.RemoveEventHandler=function(t,n,c){var l,u,d,f=!1;function p(t){var n;0!=t&&(n=e.DDA.ErrorCodeManager.getErrorArgs(t)),s(l,t,n)}try{var g=e.AsyncMethodCalls.get(e.AsyncMethods.RemoveHandlerAsync);u=(l=g.verifyAndExtractCall(t,c,n))[e.ParameterNames.EventType],d=l[e.ParameterNames.Handler];var h,m,y=a()[u],v=(f=r(y))?l[e.ParameterNames.Id]:c.id||"";null===d?(m=f?n.clearObjectEventHandlers(u,v):n.clearEventHandlers(u),h=0):h=(m=f?n.removeObjectEventHandler(u,v,d):n.removeEventHandler(u,d))?0:5003;var b=f?n.getObjectEventHandlerCount(u,v):n.getEventHandlerCount(u);if(m&&0==b)i("unregisterEventAsync")({eventType:u,dispId:y,targetId:v,onCalling:function(){},onReceiving:function(){},onComplete:p});else p(h)}catch(e){o(e,g,t,l)}},t.OpenDialog=function(t,n,r){var c,l,u=e.EventType.DialogMessageReceived,d=e.EventType.DialogEventReceived;function f(t){if(0!=t)i=e.DDA.ErrorCodeManager.getErrorArgs(t);else{var o={};o.id=l,o.data=n;var i=p.processResponse(t,o,r,c);e.DialogShownStatus.hasDialogShown=!0,n.clearEventHandlers(u),n.clearEventHandlers(d)}s(c,t,i)}try{if(null!=u&&null!=d||f(5e3),null==e.AsyncMethods.DisplayDialogAsync)return void f(5001);var p=e.AsyncMethodCalls.get(e.AsyncMethods.DisplayDialogAsync);c=p.verifyAndExtractCall(t,r,n);var g=a()[u],h=i("openDialog");l=JSON.stringify(c),e.DialogShownStatus.hasDialogShown||(n.clearQueuedEvent(u),n.clearQueuedEvent(d),n.clearQueuedEvent(e.EventType.DialogParentMessageReceived)),h({eventType:u,dispId:g,targetId:l,onCalling:function(){},onReceiving:function(){},onComplete:f,onEvent:function(t){var o=e.HostParameterMap.fromHost(g,t),i=e.manufactureEventArgs(u,r,o);if(i.type==d){e.DDA.ErrorCodeManager.getErrorArgs(i.error);var a={};a.code=status||5001,i.error=new e.DDA.Error(a[e.DDA.AsyncResultEnum.ErrorProperties.Name],a[e.DDA.AsyncResultEnum.ErrorProperties.Message],a[e.DDA.AsyncResultEnum.ErrorProperties.Code])}n.fireOrQueueEvent(i),12006==o.messageType&&(n.clearEventHandlers(u),n.clearEventHandlers(d),n.clearEventHandlers(e.EventType.DialogParentMessageReceived),e.DialogShownStatus.hasDialogShown=!1)}})}catch(e){o(e,p,t,c)}},t.CloseDialog=function(t,n,r,s){var c,l,u;try{var d=e.AsyncMethodCalls.get(e.AsyncMethods.CloseAsync);c=d.verifyAndExtractCall(t,s,r),l=e.EventType.DialogMessageReceived,u=e.EventType.DialogEventReceived,r.clearEventHandlers(l),r.clearEventHandlers(u);var f=a()[l];i("closeDialog")({eventType:l,dispId:f,targetId:n,onCalling:function(){},onReceiving:function(){},onComplete:function(t){t,e.DialogShownStatus.hasDialogShown=!1}})}catch(e){o(e,d,t,c)}},t.MessageParent=function(t,n){var r=e.SyncMethodCalls.get(e.SyncMethods.MessageParent).verifyAndExtractCall(t,n,{});return i("messageParent")({dispId:a()[e.SyncMethods.MessageParent],hostCallArgs:r,onCalling:function(){},onReceiving:function(){}})},t.SendMessage=function(t,n,r){var o=e.SyncMethodCalls.get(e.SyncMethods.SendMessage).verifyAndExtractCall(t,r,{});return i("sendMessage")({dispId:a()[e.SyncMethods.SendMessage],hostCallArgs:o,onCalling:function(){},onReceiving:function(){}})},t.addAsyncMethods=function(t,n,r){for(var o in n){var i=n[o];t[i]||e.OUtil.defineEnumerableProperty(t,i,{value:function(n){return function(){var o=e.DispIdHost.InvokeMethod;o(n,arguments,t,r)}}(i)})}},t.addEventSupport=function(t,n,r){var o=e.AsyncMethods.AddHandlerAsync,i=e.AsyncMethods.RemoveHandlerAsync;t[o]||e.OUtil.defineEnumerableProperty(t,o,{value:function(){var o=e.DispIdHost.AddEventHandler;o(arguments,n,t,r)}}),t[i]||e.OUtil.defineEnumerableProperty(t,i,{value:function(){var r=e.DispIdHost.RemoveEventHandler;r(arguments,n,t)}})},t.issueAsyncResult=s}(e.DispIdHost||(e.DispIdHost={}))}(OSF||(OSF={})),function(e){e.manufactureEventArgs=function(t,n,r){var o;switch(t){case e.EventType.DocumentSelectionChanged:o=new e.DocumentSelectionChangedEventArgs(n);break;case e.EventType.BindingSelectionChanged:o=new e.BindingSelectionChangedEventArgs(e.manufactureBinding(r,n.document),r[e.PropertyDescriptors.Subset]);break;case e.EventType.BindingDataChanged:o=new e.BindingDataChangedEventArgs(e.manufactureBinding(r,n.document));break;case e.EventType.SettingsChanged:o=new e.SettingsChangedEventArgs(n);break;case e.EventType.ActiveViewChanged:o=new e.ActiveViewChangedEventArgs(r);break;case e.EventType.LiveShareStateChanged:o=new e.LiveShareStateChangedEventArgs(r);break;case e.EventType.OfficeThemeChanged:o=new e.DDA.Theming.OfficeThemeChangedEventArgs(r);break;case e.EventType.DocumentThemeChanged:o=new e.DDA.Theming.DocumentThemeChangedEventArgs(r);break;case e.EventType.DataNodeInserted:o=new e.NodeInsertedEventArgs(e.manufactureDataNode(r[e.DataNodeEventProperties.NewNode]),r[e.DataNodeEventProperties.InUndoRedo]);break;case e.EventType.DataNodeReplaced:o=new e.NodeReplacedEventArgs(e.manufactureDataNode(r[e.DataNodeEventProperties.OldNode]),e.manufactureDataNode(r[e.DataNodeEventProperties.NewNode]),r[e.DataNodeEventProperties.InUndoRedo]);break;case e.EventType.DataNodeDeleted:o=new e.NodeDeletedEventArgs(e.manufactureDataNode(r[e.DataNodeEventProperties.OldNode]),e.manufactureDataNode(r[e.DataNodeEventProperties.NextSiblingNode]),r[e.DataNodeEventProperties.InUndoRedo]);break;case e.EventType.DialogMessageReceived:o=new e.DialogEventArgs(r);break;case e.EventType.DialogParentMessageReceived:o=new e.DialogParentEventArgs(r)}return o}}(OSF||(OSF={})),function(e){var t="toHost",n="fromHost";!function(r){var o;r.self="self",r.dynamicTypes={},r.dynamicTypes[e.ParameterNames.Data]={toHost:function(t){if(null!=t&&void 0!==t.rows){var n={};n[e.TableDataProperties.TableRows]=t.rows,n[e.TableDataProperties.TableHeaders]=t.headers,t=n}return t},fromHost:function(e){return e}},r.dynamicTypes.sampleData=r.dynamicTypes.data;var i={};function a(e,t){var n,o;if(t.map)for(var a in o={},n=t.map){var s=n[a];s==r.self&&(s=a),o[s]=a}else n=t.toHost,o=t.fromHost;var c=i[e];if(c){var l=c.toHost;for(var u in l)n[u]=l[u];for(var d in l=c.fromHost)o[d]=l[d]}else c=i[e]={};c.toHost=n,c.fromHost=o}function s(e){u().addComplexType(e)}function c(t,o){var a=t?{}:void 0;for(var s in t){var l,d=t[s];if(e.ListType.isListType(s))for(var f in l=[],d)l.push(c(d[f],o));else if(e.OUtil.listContainsKey(r.dynamicTypes,s))l=r.dynamicTypes[s][o](d);else if(o==n&&u().preserveNesting(s))l=c(d,o);else{var p=i[s];if(p){var g=p[o];g&&void 0===(l=g[d])&&(l=d)}else l=d}a[s]=l}return a}function l(t,n,o){var a,s=i[t][o];if("toHost"==o)a=function e(t,n){var o;for(var a in n){var s;if(null!=(s=u().isComplexType(a)?e(t,i[a].toHost):t[a])){o||(o={});var c=n[a];c==r.self&&(c=a),o[c]=u().pack(a,s)}}return o}(c(n,o),s);else if("fromHost"==o){a=c(function t(n,o,a){for(var s in a||(a={}),o){var c,l,d=o[s];if(d==r.self)c=n;else{if("sourceData"==d){a[s]=n.toArray();continue}c=n[d]}if(null==c)a[s]=void 0;else if(c=u().unpack(s,c),u().isComplexType(s))l=i[s].fromHost,u().preserveNesting(s)?a[s]=t(c,l):t(c,l,a);else if(e.ListType.isListType(s)){(l={})[e.ListType.getDescriptor(s)]=r.self;var f=new Array(c.length);for(var p in c)f[p]=t(c[p],l);a[s]=f}else a[s]=c}return a}(n,s),o)}return a}function u(){if(!o){var t=e._OfficeAppFactory.getHostInfo();o=t.hostPlatform==e.HostInfoPlatform.web?new e.WebSpecialProcessor:new e.SafeArraySpecialProcessor}return o}function d(e){var t=null;if(e){t={};for(var n=e.length,r=0;r<n;r++)t[e[r].name]=e[r].value}return t}r.define=function(e){var t={},n=d(e.toHost);e.invertible?t.map=n:e.canonical?t.toHost=t.fromHost=n:(t.toHost=n,t.fromHost=d(e.fromHost)),a(e.type,t),e.isComplexType&&s(e.type)},r.toHost=function(e,n){return l(e,n,t)},r.fromHost=function(e,t){return l(e,t,n)},r.addMapping=a,r.addComplexType=s,r.getDynamicType=function(e){return u().getDynamicType(e)},r.setDynamicType=function(e,t){u().setDynamicType(e,t)},r.doMapValues=function(e,t){return c(e,t)}}(e.HostParameterMap||(e.HostParameterMap={}))}(OSF||(OSF={})),function(e){!function(t){var n={};t.setListType=function(e,t){n[e]=t},t.isListType=function(t){return e.OUtil.listContainsKey(n,t)},t.getDescriptor=function(e){return n[e]}}(e.ListType||(e.ListType={}))}(OSF||(OSF={})),function(e){var t=function(){function t(e){this.m_liveShareStateInstance=e}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.LiveShareStateChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"liveShareState",{get:function(){return this.m_liveShareStateInstance},enumerable:!0,configurable:!0}),t}();e.LiveShareStateChangedEventArgs=t}(OSF||(OSF={})),function(e){!function(e){e.ActiveViewChanged="activeViewChanged",e.DialogMessageReceived="dialogMessageReceived",e.DialogParentMessageReceived="dialogParentMessageReceived",e.DialogParentEventReceived="dialogParentEventReceived",e.DialogEventReceived="dialogEventReceived",e.BindingDataChanged="bindingDataChanged",e.BindingSelectionChanged="bindingSelectionChanged",e.OfficeThemeChanged="officeThemeChanged",e.DocumentThemeChanged="documentThemeChanged",e.DataNodeDeleted="nodeDeleted",e.DataNodeInserted="nodeInserted",e.DataNodeReplaced="nodeReplaced",e.DocumentSelectionChanged="documentSelectionChanged",e.LiveShareStateChanged="liveShareStateChanged",e.NodeDeleted="nodeDeleted",e.NodeInserted="nodeInserted",e.NodeReplaced="nodeReplaced",e.SettingsChanged="settingsChanged"}(e.EventType||(e.EventType={}))}(Office||(Office={})),function(e){!function(e){e.TableRows="TableRows",e.TableHeaders="TableHeaders"}(e.TableDataProperties||(e.TableDataProperties={}))}(OSF||(OSF={})),function(e){!function(t){var n,r,o;function i(){try{var e=window.navigator.userAgent;return e.indexOf("MSIE ")>-1||e.indexOf("Trident/")>-1||e.indexOf("Edge/")>-1}catch(e){return l("Error happens in isInternetExplorer.",e),!1}}function a(e){if("undefined"!=typeof JSON)try{return JSON.stringify(e)}catch(e){}return""}!function(e){e.ButtonBorderColor="buttonBorderColor",e.ButtonBackgroundColor="buttonBackgroundColor"}(t.HostThemeButtonStyleKeys||(t.HostThemeButtonStyleKeys={})),function(e){e.HostButtonBorderColor="#86bfa0",e.HostButtonBackgroundColor="#d3f0e0"}(n||(n={})),function(e){e.HostButtonBorderColor="#a3bde3",e.HostButtonBackgroundColor="#d5e1f2"}(r||(r={})),function(e){e.HostButtonBorderColor="#f5ba9d",e.HostButtonBackgroundColor="#fcf0ed"}(o||(o={})),t.finalizeProperties=function(e,t){t=t||{};for(var n=Object.getOwnPropertyNames(e),r=n.length,o=0;o<r;o++){var i=n[o],a=Object.getOwnPropertyDescriptor(e,i);a.get||a.set||(a.writable=t.writable||!1),a.configurable=t.configurable||!1,a.enumerable=t.enumerable||!0,Object.defineProperty(e,i,a)}return e},t.defineEnumerableProperties=function(e,t){return function(e,t,n){for(var r in t=t||{})c(e,r,t[r],n);return e}(e,t,["enumerable"])},t.defineEnumerableProperty=function(e,t,n){return c(e,t,n,["enumerable"])},t.listContainsKey=function(e,t){for(var n in e)if(t==n)return!0;return!1},t.augmentList=function(e,t){var n=e.push?function(t,n){e.push(n)}:function(t,n){e[t]=n};for(var r in t)n(r,t[r])},t.createObject=function(e){var t=null;if(e){t={};for(var n=e.length,r=0;r<n;r++)t[e[r].name]=e[r].value}return t},t.listContainsValue=function(e,t){for(var n in e)if(t==e[n])return!0;return!1},t.shouldUseLocalStorageToPassMessage=function(){try{for(var e=["Windows NT 6.1","Windows NT 6.2","Windows NT 6.3","Windows NT 10.0"],t=window.navigator.userAgent,n=0,r=e.length;n<r;n++)if(t.indexOf(e[n])>-1)return i();return!1}catch(e){return l("Error happens in shouldUseLocalStorageToPassMessage.",e),!1}},t.isInternetExplorer=i,t.serializeObjectToString=a,t.formatString=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n=e,r=n[0];return r.replace(/{(\d+)}/gm,(function(e,t){var r=parseInt(t,10)+1;return void 0===n[r]?"{"+t+"}":n[r]}))},t.addHostInfoAsQueryParam=function(e,t){if(!e)return null;var n,r="#",o=(e=e.trim()||"").split(r),i=o.shift(),a=o.join(r),s=i.split("?");return s.length>1?n=i+"&_host_Info="+t:s.length>0&&(n=i+"?_host_Info="+t),a?[n,r,a].join(""):n},t.getHostnamePortionForLogging=function(e){var t=e.split("."),n=t.length;return n>=2?t[n-2]+"."+t[n-1]:1==n?t[0]:void 0},t.shallowCopy=function(e){if(null==e)return null;if(e instanceof Object){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(e[n]);return t}var r=e.constructor();for(var o in e)e.hasOwnProperty(o)&&(r[o]=e[o]);return r}return e},t.getXdmEventName=function(t,n){return n==e.EventType.BindingSelectionChanged||n==e.EventType.BindingDataChanged||n==e.EventType.DataNodeDeleted||n==e.EventType.DataNodeInserted||n==e.EventType.DataNodeReplaced?t+"_"+n:n},t.getCommonUI=function(){switch(Office.context.host){case Office.HostType.Excel:return n;case Office.HostType.Word:return r;case Office.HostType.PowerPoint:return o}return null},t.getDomainForUrl=function(e){if(!e)return null;var t=document.createElement("a");return t.href=e,t.protocol+"//"+t.host},t.delayExecutionAndCache=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n={calc:e[0]};return n.calc&&(n.val=n.calc.apply(this,e),delete n.calc),n.val};var s=-1;function c(e,t,n,r){for(var o in n=n||{},r){var i=r[o];null==n[i]&&(n[i]=!0)}return Object.defineProperty(e,t,n),e}function l(t,n){e.Utility.trace(t+" Exception details: "+a(n))}t.getUniqueId=function(){return(s+=1).toString()}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){!function(e){e.BindingType="bindingType",e.CoercionType="coercionType",e.ValueFormat="valueFormat",e.FilterType="filterType",e.Columns="columns",e.SampleData="sampleData",e.GoToType="goToType",e.SelectionMode="selectionMode",e.Id="id",e.PromptText="promptText",e.ItemName="itemName",e.FailOnCollision="failOnCollision",e.StartRow="startRow",e.StartColumn="startColumn",e.RowCount="rowCount",e.ColumnCount="columnCount",e.Rows="rows",e.OverwriteIfStale="overwriteIfStale",e.FileType="fileType",e.EventType="eventType",e.Handler="handler",e.SliceSize="sliceSize",e.SliceIndex="sliceIndex",e.ActiveView="activeView",e.Status="status",e.PlatformType="platformType",e.HostType="hostType",e.Email="email",e.OfficeTheme="officeTheme",e.DocumentTheme="documentTheme",e.ForceConsent="forceConsent",e.ForceAddAccount="forceAddAccount",e.AuthChallenge="authChallenge",e.AllowConsentPrompt="allowConsentPrompt",e.ForMSGraphAccess="forMSGraphAccess",e.AllowSignInPrompt="allowSignInPrompt",e.JsonPayload="jsonPayload",e.EnableNewHosts="enableNewHosts",e.AccountTypeFilter="accountTypeFilter",e.AddinTrustId="addinTrustId",e.Reserved="reserved",e.Tcid="tcid",e.Xml="xml",e.Namespace="namespace",e.Prefix="prefix",e.XPath="xPath",e.Text="text",e.ImageLeft="imageLeft",e.ImageTop="imageTop",e.ImageWidth="imageWidth",e.ImageHeight="imageHeight",e.TaskId="taskId",e.FieldId="fieldId",e.FieldValue="fieldValue",e.ServerUrl="serverUrl",e.ListName="listName",e.ResourceId="resourceId",e.ViewType="viewType",e.ViewName="viewName",e.GetRawValue="getRawValue",e.CellFormat="cellFormat",e.TableOptions="tableOptions",e.TaskIndex="taskIndex",e.ResourceIndex="resourceIndex",e.CustomFieldId="customFieldId",e.Url="url",e.MessageHandler="messageHandler",e.Width="width",e.Height="height",e.RequireHTTPs="requireHTTPS",e.DisplayInIframe="displayInIframe",e.HideTitle="hideTitle",e.UseDeviceIndependentPixels="useDeviceIndependentPixels",e.PromptBeforeOpen="promptBeforeOpen",e.EnforceAppDomain="enforceAppDomain",e.UrlNoHostInfo="urlNoHostInfo",e.Base64="base64",e.FormId="formId"}(e.ParameterNames||(e.ParameterNames={}))}(OSF||(OSF={})),function(e){!function(t){function n(t,n){var r=(new Date).getTime();return function(o){n.onReceiving&&n.onReceiving();var i=o.toArray?o.toArray()[0]:o;return n.onComplete&&n.onComplete(i),e.AppTelemetry&&e.AppTelemetry.onRegisterDone(t,n.dispId,Math.abs((new Date).getTime()-r),i),!0}}function r(e){var t=e;if(null!=e&&e.toArray){var n=e.toArray();t=new Array(n.length);for(var o=0;o<n.length;o++)t[o]=r(n[o])}return t}t.executeAsync=function(t){try{t.onCalling&&t.onCalling(),e._OfficeAppFactory.getClientHostController().execute(t.dispId,function t(n){var r=n;if(e.OUtil.isArray(n))for(var o=r.length,i=0;i<o;i++)r[i]=t(r[i]);else if(e.OUtil.isDate(n))r=n.getVarDate();else if("object"==typeof n&&!e.OUtil.isArray(n))for(var a in r=[],n)e.OUtil.isFunction(n[a])||(r[a]=t(n[a]));return r}(t.hostCallArgs),(function(e,n){var o,i;if("number"==typeof e?(o=[],i=e):i=(o=e.toArray())[0],1==i)return null!=(a=r(a=o[1]))&&(t._chunkResultData||(t._chunkResultData=new Array),t._chunkResultData[a[0]]=a[1]),!1;if(t.onReceiving&&t.onReceiving(),t.onComplete){var a;if(0==i){if(o.length>2){a=[];for(var s=1;s<o.length;s++)a[s-1]=o[s]}else a=o[1];if(t._chunkResultData&&null!=(a=r(a))){var c=a[a.length-1];t._chunkResultData.length==c?a[a.length-1]=t._chunkResultData:i=5001}}else a=o[1];t.onComplete(i,a)}return!0}))}catch(n){e.SafeArrayDelegate.onException(n,t)}},t.registerEventAsync=function(t){t.onCalling&&t.onCalling();var r=n(!0,t);try{e._OfficeAppFactory.getClientHostController().registerEvent(t.dispId,void 0,t.targetId,(function(n,r){t.onEvent&&t.onEvent(r),e.AppTelemetry&&e.AppTelemetry.onEventDone(t.dispId)}),r)}catch(n){e.SafeArrayDelegate.onException(n,t)}},t.unregisterEventAsync=function(t){t.onCalling&&t.onCalling();var r=n(!1,t);try{e._OfficeAppFactory.getClientHostController().unregisterEvent(t.dispId,void 0,t.targetId,r)}catch(n){e.SafeArrayDelegate.onException(n,t)}},t.onException=function(t,n){var r,o=t.number;if(o)switch(o){case-2146828218:r=7e3;break;case-2147467259:r=n.dispId==e.EventDispId.dispidDialogMessageReceivedEvent?12007:5001;break;case-2146828283:case-2147209089:r=5010;break;case-2147208704:r=5100;break;case-2146827850:default:r=5001}n.onComplete&&n.onComplete(r||5001)},t.onExceptionSyncMethod=function(e,t){var n,r=e.number;if(r)switch(r){case-2146828218:n=7e3;break;case-2146827850:default:n=5001}return n||5001},t.getOnAfterRegisterEvent=n}(e.SafeArrayDelegate||(e.SafeArrayDelegate={}))}(OSF||(OSF={})),function(e){var t=function(){function t(e){this.m_settingsInstance=e}return Object.defineProperty(t.prototype,"type",{get:function(){return e.EventType.SettingsChanged},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"settings",{get:function(){return this.m_settingsInstance},enumerable:!0,configurable:!0}),t}();e.SettingsChangedEventArgs=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t){this._complexTypes=e,this.dynamicTypes=t}return t.prototype.addComplexType=function(e){this._complexTypes.push(e)},t.prototype.getDynamicType=function(e){return this.dynamicTypes[e]},t.prototype.setDynamicType=function(e,t){this.dynamicTypes[e]=t},t.prototype.isComplexType=function(t){return e.OUtil.listContainsValue(this._complexTypes,t)},t.prototype.isDynamicType=function(t){return e.OUtil.listContainsKey(this.dynamicTypes,t)},t.prototype.preserveNesting=function(e){return!1},t.prototype.pack=function(e,t){return this.isDynamicType(e)?this.dynamicTypes[e].toHost(t):t},t.prototype.unpack=function(e,t){return this.isDynamicType(e)?this.dynamicTypes[e].fromHost(t):t},t}();e.SpecialProcessor=t}(OSF||(OSF={}));__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){var t=function(t){function n(){var n={};return n[e.ParameterNames.Data]={toHost:function(t){if(e.TableDataProperties&&"string"!=typeof t&&void 0!==t[e.TableDataProperties.TableRows]){var n=[];n[0]=t[e.TableDataProperties.TableRows],n[1]=t[e.TableDataProperties.TableHeaders],t=n}return t},fromHost:function(t){var n;if(t.toArray)if(2===t.dimensions())n=e.Utility.twoDVBArrayToJaggedArray(t);else{var r=t.toArray();2===r.length&&(null!=r[0]&&r[0].toArray||null!=r[1]&&r[1].toArray)?((n={})[e.TableDataProperties.TableRows]=e.Utility.twoDVBArrayToJaggedArray(r[0]),n[e.TableDataProperties.TableHeaders]=e.Utility.twoDVBArrayToJaggedArray(r[1])):n=r}else n=t;return n}},t.call(this,[],n)||this}return __extends(n,t),n.prototype.unpack=function(t,n){var r;this.isComplexType(t)||e.ListType.isListType(t)?r=void 0!==n&&void 0!==n.toArray?n.toArray():n||{}:r=this.isDynamicType(t)?this.dynamicTypes[t].fromHost(n):n;return r},n}(e.SpecialProcessor);e.SafeArraySpecialProcessor=t}(OSF||(OSF={})),function(e){var t=function(){function t(t,n,r,o,i){this._requiredCount=t.length,this._apiMethods=new e.ApiMethodCall(t,n,r,o,i),this._supportedOptions=n}return t.prototype.verifyAndExtractCall=function(e,t,n){var r=this._apiMethods.extractRequiredArguments(e,t,n),o=this.extractOptions(e,r,t,n);return this._apiMethods.constructCallArgs(r,o,t,n)},t.prototype.extractOptions=function(t,n,r,o){if(t.length>this._requiredCount+1)throw e.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);for(var i,a=t.length-1;a>=this._requiredCount;a--){var s=t[a];switch(typeof s){case"object":if(i)throw e.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);i=s;break;default:throw e.Utility.createArgumentException(Strings.OfficeOM.L_InValidOptionalArgument)}}return i=this._apiMethods.fillOptions(i,n,r,o),this._apiMethods.verifyArguments(this._supportedOptions,i),i},t}();e.SyncMethodCall=t}(OSF||(OSF={})),function(e){!function(t){var n={};t.define=function(t){var r,o;n[t.method]=(o=(r=t).supportedOptions?e.OUtil.createObject(r.supportedOptions):[],new e.SyncMethodCall(r.requiredArguments||[],o,r.privateStateCallbacks,r.checkCallArgs,r.method.displayName))},t.get=function(e){return n[e]}}(e.SyncMethodCalls||(e.SyncMethodCalls={}))}(OSF||(OSF={})),function(e){e.SyncMethods={MessageParent:"messageParent",MessageChild:"messageChild",SendMessage:"sendMessage",AddMessageHandler:"addEventHandler"}}(OSF||(OSF={})),function(e){!function(t){!function(t){function n(t){for(var n=[{name:e.DDA.Theming.DocumentThemeEnum.PrimaryFontColor,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.PrimaryBackgroundColor,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.SecondaryFontColor,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.SecondaryBackgroundColor,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent1,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent2,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent3,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent4,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent5,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Accent6,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.Hyperlink,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.FollowedHyperlink,needToConvertToHex:!0},{name:e.DDA.Theming.DocumentThemeEnum.HeaderLatinFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.HeaderEastAsianFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.HeaderScriptFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.HeaderLocalizedFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.BodyLatinFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.BodyEastAsianFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.BodyScriptFont,needToConvertToHex:!1},{name:e.DDA.Theming.DocumentThemeEnum.BodyLocalizedFont,needToConvertToHex:!1}],r={},o=0;o<n.length;o++)n[o].needToConvertToHex?r[n[o].name]=e.OUtil.convertIntToCssHexColor(t[n[o].name]):r[n[o].name]=t[n[o].name];return r}function r(t){var n={};if(t){var r=e.DDA.Theming.OfficeThemeEnum,o={bodyBackgroundColor:{name:r.BodyBackgroundColor,convertToHex:!0},bodyForegroundColor:{name:r.BodyForegroundColor,convertToHex:!0},controlBackgroundColor:{name:r.ControlBackgroundColor,convertToHex:!0},controlForegroundColor:{name:r.ControlForegroundColor,convertToHex:!0},primaryFontColor:{name:r.BodyForegroundColor,convertToHex:!0},primaryBackgroundColor:{name:r.BodyBackgroundColor,convertToHex:!0},secondaryFontColor:{name:r.ControlBackgroundColor,convertToHex:!0},secondaryBackgroundColor:{name:r.ControlForegroundColor,convertToHex:!0}};for(var i in t){var a=!1,s=i;o[i]&&(s=o[i].name,a=o[i].convertToHex),n[s]=a?e.OUtil.convertIntToCssHexColor(t[i]):t[i]}null==n[r.IsDarkTheme]&&(n[r.IsDarkTheme]=e.DDA.Theming.GetIsDarkThemeFromCSSHexColor(n[r.BodyBackgroundColor])),null==n[r.ThemeId]&&(n[r.ThemeId]=n[r.IsDarkTheme]?e.DDA.Theming.ThemeId.Black:e.DDA.Theming.ThemeId.White)}return n}!function(e){e.PrimaryFontColor="primaryFontColor",e.PrimaryBackgroundColor="primaryBackgroundColor",e.SecondaryFontColor="secondaryFontColor",e.SecondaryBackgroundColor="secondaryBackgroundColor",e.Accent1="accent1",e.Accent2="accent2",e.Accent3="accent3",e.Accent4="accent4",e.Accent5="accent5",e.Accent6="accent6",e.Hyperlink="hyperlink",e.FollowedHyperlink="followedHyperlink",e.HeaderLatinFont="headerLatinFont",e.HeaderEastAsianFont="headerEastAsianFont",e.HeaderScriptFont="headerScriptFont",e.HeaderLocalizedFont="headerLocalizedFont",e.BodyLatinFont="bodyLatinFont",e.BodyEastAsianFont="bodyEastAsianFont",e.BodyScriptFont="bodyScriptFont",e.BodyLocalizedFont="bodyLocalizedFont"}(t.DocumentThemeEnum||(t.DocumentThemeEnum={})),function(e){e.BodyBackgroundColor="bodyBackgroundColor",e.BodyForegroundColor="bodyForegroundColor",e.ControlBackgroundColor="controlBackgroundColor",e.ControlForegroundColor="controlForegroundColor",e.IsDarkTheme="isDarkTheme",e.ThemeId="themeId"}(t.OfficeThemeEnum||(t.OfficeThemeEnum={})),function(e){e.PrimaryFontColor="primaryFontColor",e.PrimaryBackgroundColor="primaryBackgroundColor",e.SecondaryFontColor="secondaryFontColor",e.SecondaryBackgroundColor="secondaryBackgroundColor",e.IsDarkTheme="isDarkTheme",e.ThemeId="themeId"}(t.OfficeThemeEnumWac||(t.OfficeThemeEnumWac={})),function(e){e[e.Colorful=0]="Colorful",e[e.DarkGray=1]="DarkGray",e[e.Black=2]="Black",e[e.White=3]="White"}(t.ThemeId||(t.ThemeId={})),t.ConvertToDocumentTheme=n,t.GetIsDarkThemeFromCSSHexColor=function(e){var t="#"===e.charAt(0)?e.substring(1,7):e;return.299*parseInt(t.substring(0,2),16)+.587*parseInt(t.substring(2,4),16)+.114*parseInt(t.substring(4,6),16)<186},t.ConvertToOfficeTheme=r;var o=function(t){var n=null,o=e._OfficeAppFactory.getHostInfo();(n=o.hostPlatform==e.HostInfoPlatform.web?t:r(t)).isDarkTheme=e.DDA.Theming.GetIsDarkThemeFromCSSHexColor(n.bodyBackgroundColor),o.hostPlatform!=e.HostInfoPlatform.web&&"mac"!=o.hostPlatform.toLowerCase()&&"ios"!=o.hostPlatform.toLowerCase()||(n.themeId=n.isDarkTheme?e.DDA.Theming.ThemeId.Black:e.DDA.Theming.ThemeId.White,Office.context&&Office.context.officeTheme&&(Office.context.officeTheme.bodyBackgroundColor=n.bodyBackgroundColor,Office.context.officeTheme.bodyForegroundColor=n.bodyForegroundColor,Office.context.officeTheme.controlBackgroundColor=n.controlBackgroundColor,Office.context.officeTheme.controlForegroundColor=n.controlForegroundColor,Office.context.officeTheme.isDarkTheme=n.isDarkTheme,Office.context.officeTheme.themeId=n.themeId)),e.OUtil.defineEnumerableProperties(this,{type:{value:Microsoft.Office.WebExtension.EventType.OfficeThemeChanged},officeTheme:{value:n}})};t.OfficeThemeChangedEventArgs=o;var i=function(t){var r=n(t);e.OUtil.defineEnumerableProperties(this,{type:{value:Microsoft.Office.WebExtension.EventType.DocumentThemeChanged},documentTheme:{value:r}})};t.DocumentThemeChangedEventArgs=i}(t.Theming||(t.Theming={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){!function(t){var n=[];t.initialize=function(){n.forEach((function(t){t.defineMethodsFunc(),e.OUtil.getHostPlatform()==e.HostInfoPlatform.web?"function"==typeof t.defineWebParameterMapFunc&&t.defineWebParameterMapFunc():"function"==typeof t.defineSafeArrayParameterMapFunc&&t.defineSafeArrayParameterMapFunc(),"function"==typeof t.initializeFunc&&t.initializeFunc()}))},t.register=function(e){n.push(e)}}(e.V10ApiFeatureRegistry||(e.V10ApiFeatureRegistry={}))}(OSF||(OSF={})),function(e){!function(t){function n(t,n){var r=(new Date).getTime();return function(o,i){var a;if(n.onReceiving&&n.onReceiving(),0!=o)switch(o){case-5:a=7e3;break;default:a=5001}else a=i?i.Error?i.Error:0:5001;n.onComplete&&n.onComplete(a),e.AppTelemetry&&e.AppTelemetry.onRegisterDone(t,n.dispId,Math.abs((new Date).getTime()-r),a)}}t.version=1,function(e){e.Data="Data",e.Properties="Properties",e.BindingRequest="DdaBindingsMethod",e.BindingResponse="Bindings",e.SingleBindingResponse="singleBindingResponse",e.GetData="DdaGetBindingData",e.AddRowsColumns="DdaAddRowsColumns",e.SetData="DdaSetBindingData",e.ClearFormats="DdaClearBindingFormats",e.SetFormats="DdaSetBindingFormats",e.SettingsRequest="DdaSettingsMethod",e.BindingEventSource="ddaBinding",e.ArrayData="ArrayData"}(t.UniqueArguments||(t.UniqueArguments={})),t.executeAsync=function(t){t.hostCallArgs||(t.hostCallArgs={}),t.hostCallArgs.DdaMethod={ControlId:e._OfficeAppFactory.getId(),Version:e.WACDelegate.version,DispatchId:t.dispId},t.hostCallArgs.__timeout__=-1,t.onCalling&&t.onCalling(),e.getClientEndPoint()&&e.getClientEndPoint().invoke("executeMethod",(function(n,r){var o;if(t.onReceiving&&t.onReceiving(),0==n)e.WACDelegate.version=r.Version,o=r.Error;else switch(n){case-5:o=7e3;break;default:o=5001}t.onComplete&&t.onComplete(o,r)}),t.hostCallArgs)},t.getOnAfterRegisterEvent=n,t.registerEventAsync=function(t){t.onCalling&&t.onCalling(),e.getClientEndPoint()&&e.getClientEndPoint().registerForEvent(e.OUtil.getXdmEventName(t.targetId,t.eventType),(function(n){t.onEvent&&t.onEvent(n),e.AppTelemetry&&e.AppTelemetry.onEventDone(t.dispId)}),n(!0,t),{controlId:e._OfficeAppFactory.getId(),eventDispId:t.dispId,targetId:t.targetId})},t.unregisterEventAsync=function(t){t.onCalling&&t.onCalling(),e.getClientEndPoint()&&e.getClientEndPoint().unregisterForEvent(e.OUtil.getXdmEventName(t.targetId,t.eventType),n(!1,t),{controlId:e._OfficeAppFactory.getId(),eventDispId:t.dispId,targetId:t.targetId})}}(e.WACDelegate||(e.WACDelegate={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(){var n=[e.WACDelegate.UniqueArguments.SingleBindingResponse,e.WACDelegate.UniqueArguments.BindingRequest,e.WACDelegate.UniqueArguments.BindingResponse,e.WACDelegate.UniqueArguments.GetData,e.WACDelegate.UniqueArguments.AddRowsColumns,e.WACDelegate.UniqueArguments.SetData,e.WACDelegate.UniqueArguments.ClearFormats,e.WACDelegate.UniqueArguments.SetFormats,e.WACDelegate.UniqueArguments.SettingsRequest,e.WACDelegate.UniqueArguments.BindingEventSource];return t.call(this,n,{})||this}return __extends(n,t),n}(e.SpecialProcessor);e.WebSpecialProcessor=t}(OSF||(OSF={}));__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){!function(e){!function(e){!function(e){e._eventDispatches=[],e.addFromSelectionAsync=function(e,t,n){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.AddFromSelectionAsync,arguments,this,void 0)},e.addFromNamedItemAsync=function(e,t,n,r){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.AddFromNamedItemAsync,arguments,this,void 0)},e.addFromPromptAsync=function(e,t,n){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.AddFromPromptAsync,arguments,this,void 0)},e.getAllAsync=function(e,t){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetAllAsync,arguments,this,void 0)},e.getByIdAsync=function(e,t,n){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetByIdAsync,arguments,this,void 0)},e.releaseByIdAsync=function(e,t,n){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.ReleaseByIdAsync,arguments,this,void 0)}}(e.bindings||(e.bindings={}))}(e.document||(e.document={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){e.Id="BindingId",e.Type="bindingType",e.RowCount="RowCount",e.ColumnCount="BindingColumnCount",e.HasHeaders="HasHeaders"}(e.BindingProperties||(e.BindingProperties={})),function(e){e.BindingList="BindingList"}(e.ListDescriptors||(e.ListDescriptors={})),e.ListType.setListType(e.ListDescriptors.BindingList,e.PropertyDescriptors.BindingProperties),function(e){e.BindingSelectionChangedEvent="BindingSelectionChangedEvent"}(e.EventDescriptors||(e.EventDescriptors={})),function(e){!function(e){e.Id="BindingId",e.BindingType="BindingType",e.ItemName="ItemName",e.StartRow="StartRow",e.StartCol="StartCol",e.RowCount="RowCount",e.ColCount="ColCount"}(e.BindingParameterKeys||(e.BindingParameterKeys={})),function(e){e.TableHeaders="TableHeaders",e.TableRows="TableRows"}(e.TableBindingParameterKeys||(e.TableBindingParameterKeys={})),function(e){e.BindingId="Name",e.BindingType="BindingType",e[e.BindingProperties=0]="BindingProperties",e.BindingEventSource="ddaBinding",e.RowCount="RowCount",e.ColumnCount="ColCount",e.HasHeaders="HasHeaders"}(e.AppBindingKeys||(e.AppBindingKeys={})),function(e){e.TableSubset="subset",e.StartRow="startRow",e.StartColumn="startColumn",e.RowCount="rowCount",e.ColumnCount="columnCount"}(e.TableSubsetKeys||(e.TableSubsetKeys={})),function(e){e[e.Table=1]="Table",e[e.Text=2]="Text",e[e.Matrix=3]="Matrix"}(e.BindingType||(e.BindingType={}))}(e.Marshaling||(e.Marshaling={})),function(t){function n(t){return e.manufactureBinding(t,Office.context.document)}function r(e){return e.id}function o(t,n,r){var o=t[e.ParameterNames.Data];return e.TableDataProperties&&o&&(null!=o[e.TableDataProperties.TableRows]||null!=o[e.TableDataProperties.TableHeaders])&&(o=Office.manufactureTableData(o)),null==(o=e.DataCoercion.coerceData(o,r[e.ParameterNames.CoercionType]))?null:o}e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.AddFromPromptAsync,requiredArguments:[{name:e.ParameterNames.BindingType,enum:Office.BindingType}],supportedOptions:[{name:e.ParameterNames.Id,value:{types:["string"],calculate:c}},{name:e.ParameterNames.PromptText,value:{types:["string"],calculate:function(){return Strings.OfficeOM.L_AddBindingFromPromptDefaultText}}},{name:e.ParameterNames.SampleData,value:{types:["object"],defaultValue:null}}],privateStateCallbacks:[],onSucceeded:function(t){return e.manufactureBinding(t,Office.context.document)}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.AddFromSelectionAsync,requiredArguments:[{name:e.ParameterNames.BindingType,enum:Office.BindingType}],supportedOptions:[{name:e.ParameterNames.Id,value:{types:["string"],calculate:c}},{name:e.ParameterNames.Columns,value:{types:["object"],defaultValue:null}}],privateStateCallbacks:[],onSucceeded:n}),e.AsyncMethodCalls.define({method:e.AsyncMethods.AddFromNamedItemAsync,requiredArguments:[{name:e.ParameterNames.ItemName,types:["string"]},{name:e.ParameterNames.BindingType,enum:Office.BindingType}],supportedOptions:[{name:e.ParameterNames.Id,value:{types:["string"],calculate:c}},{name:e.ParameterNames.Columns,value:{types:["object"],defaultValue:null}}],privateStateCallbacks:[{name:e.ParameterNames.FailOnCollision,value:function(){return!0}}],onSucceeded:n}),e.AsyncMethodCalls.define({method:e.AsyncMethods.GetAllAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[],onSucceeded:function(t){return t[e.ListDescriptors.BindingList].map(n)}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.GetByIdAsync,requiredArguments:[{name:e.ParameterNames.Id,types:["string"]}],supportedOptions:[],privateStateCallbacks:[],onSucceeded:n}),e.AsyncMethodCalls.define({method:e.AsyncMethods.ReleaseByIdAsync,requiredArguments:[{name:e.ParameterNames.Id,types:["string"]}],supportedOptions:[],privateStateCallbacks:[],onSucceeded:function(t,n,r){var o=r[e.ParameterNames.Id];delete n._eventDispatches[o]}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.GetDataAsync,requiredArguments:[],supportedOptions:[{name:e.ParameterNames.CoercionType,value:{enum:Office.CoercionType,calculate:function(t,n){return e.DataCoercion.getCoercionDefaultForBinding(n.type)}}},{name:e.ParameterNames.ValueFormat,value:{enum:Office.ValueFormat,defaultValue:Office.ValueFormat.Unformatted}},{name:e.ParameterNames.FilterType,value:{enum:Office.FilterType,defaultValue:Office.FilterType.All}},{name:e.ParameterNames.Rows,value:{types:["object","string"],defaultValue:null}},{name:e.ParameterNames.Columns,value:{types:["object"],defaultValue:null}},{name:e.ParameterNames.StartRow,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.StartColumn,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.RowCount,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.ColumnCount,value:{types:["number"],defaultValue:0}}],checkCallArgs:function(t,n,r){if(0==t[e.ParameterNames.StartRow]&&0==t[e.ParameterNames.StartColumn]&&0==t[e.ParameterNames.RowCount]&&0==t[e.ParameterNames.ColumnCount]&&(delete t[e.ParameterNames.StartRow],delete t[e.ParameterNames.StartColumn],delete t[e.ParameterNames.RowCount],delete t[e.ParameterNames.ColumnCount]),t[e.ParameterNames.CoercionType]!=e.DataCoercion.getCoercionDefaultForBinding(n.type)&&(t[e.ParameterNames.StartRow]||t[e.ParameterNames.StartColumn]||t[e.ParameterNames.RowCount]||t[e.ParameterNames.ColumnCount]))throw 1002;return t},privateStateCallbacks:[{name:e.ParameterNames.Id,value:r}],onSucceeded:o}),e.AsyncMethodCalls.define({method:e.AsyncMethods.SetDataAsync,requiredArguments:[{name:e.ParameterNames.Data,types:["string","object","number","boolean"]}],supportedOptions:[{name:e.ParameterNames.CoercionType,value:{enum:Office.CoercionType,calculate:function(t){return e.DataCoercion.determineCoercionType(t[e.ParameterNames.Data])}}},{name:e.ParameterNames.Rows,value:{types:["object","string"],defaultValue:null}},{name:e.ParameterNames.Columns,value:{types:["object"],defaultValue:null}},{name:e.ParameterNames.StartRow,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.StartColumn,value:{types:["number"],defaultValue:0}}],checkCallArgs:function(t,n,r){if(0==t[e.ParameterNames.StartRow]&&0==t[e.ParameterNames.StartColumn]&&(delete t[e.ParameterNames.StartRow],delete t[e.ParameterNames.StartColumn]),t[e.ParameterNames.CoercionType]!=e.DataCoercion.getCoercionDefaultForBinding(n.type)&&(t[e.ParameterNames.StartRow]||t[e.ParameterNames.StartColumn]))throw 1002;return t},privateStateCallbacks:[{name:e.ParameterNames.Id,value:r}]})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:"bindingSpecificData",fromHost:[{name:e.BindingProperties.RowCount,value:0},{name:e.BindingProperties.ColumnCount,value:1},{name:e.BindingProperties.HasHeaders,value:2}],isComplexType:!0}),e.HostParameterMap.define({type:e.PropertyDescriptors.Subset,toHost:[{name:"offset",value:0},{name:"run",value:1}],canonical:!0,isComplexType:!0}),e.HostParameterMap.define({type:"offset",toHost:[{name:e.ParameterNames.StartRow,value:0},{name:e.ParameterNames.StartColumn,value:1}],canonical:!0,isComplexType:!0}),e.HostParameterMap.define({type:"run",toHost:[{name:e.ParameterNames.RowCount,value:0},{name:e.ParameterNames.ColumnCount,value:1}],canonical:!0,isComplexType:!0}),e.HostParameterMap.define({type:"run",toHost:[{name:e.ParameterNames.RowCount,value:0},{name:e.ParameterNames.ColumnCount,value:1}],canonical:!0,isComplexType:!0}),e.HostParameterMap.define({type:79,toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.Data,value:1}]}),e.HostParameterMap.define({type:73,toHost:[{name:e.ParameterNames.Id,value:0}]}),e.HostParameterMap.define({type:e.PropertyDescriptors.BindingProperties,fromHost:[{name:e.BindingProperties.Id,value:0},{name:e.BindingProperties.Type,value:1},{name:"bindingSpecificData",value:2}],isComplexType:!0}),e.HostParameterMap.define({type:e.ParameterNames.BindingType,toHost:[{name:Office.BindingType.Text,value:0},{name:Office.BindingType.Matrix,value:1},{name:Office.BindingType.Table,value:2}],invertible:!0}),e.HostParameterMap.define({type:66,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.BindingType,value:1}]}),e.HostParameterMap.define({type:78,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.ItemName,value:0},{name:e.ParameterNames.Id,value:1},{name:e.ParameterNames.BindingType,value:2},{name:e.ParameterNames.FailOnCollision,value:3}]}),e.HostParameterMap.define({type:67,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.BindingType,value:1},{name:e.ParameterNames.PromptText,value:2}]}),e.HostParameterMap.define({type:69,toHost:[{name:e.ParameterNames.Id,value:0}]}),e.HostParameterMap.define({type:68,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.Id,value:0}]}),e.HostParameterMap.define({type:74,fromHost:[{name:e.ListDescriptors.BindingList,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:70,fromHost:[{name:e.ParameterNames.Data,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.CoercionType,value:1},{name:e.ParameterNames.ValueFormat,value:2},{name:e.ParameterNames.FilterType,value:3},{name:e.PropertyDescriptors.Subset,value:4}]}),e.HostParameterMap.define({type:71,toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.CoercionType,value:1},{name:e.ParameterNames.Data,value:2},{name:"offset",value:3}]})},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:72,toHost:[{name:e.WACDelegate.UniqueArguments.AddRowsColumns,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:79,toHost:[{name:e.WACDelegate.UniqueArguments.AddRowsColumns,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:73,toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.AddRowsColumns,toHost:[{name:e.ParameterNames.Id,value:"BindingId"},{name:e.ParameterNames.Data,value:e.WACDelegate.UniqueArguments.Data}]}),e.HostParameterMap.define({type:e.PropertyDescriptors.Subset,fromHost:[{name:e.ParameterNames.StartRow,value:"StartRow"},{name:e.ParameterNames.StartColumn,value:"StartCol"},{name:e.ParameterNames.RowCount,value:"RowCount"},{name:e.ParameterNames.ColumnCount,value:"ColCount"}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.BindingRequest,toHost:[{name:e.ParameterNames.ItemName,value:"ItemName"},{name:e.ParameterNames.Id,value:"BindingId"},{name:e.ParameterNames.BindingType,value:"BindingType"},{name:e.ParameterNames.PromptText,value:"PromptText"},{name:e.ParameterNames.Columns,value:"Columns"},{name:e.ParameterNames.SampleData,value:"SampleData"},{name:e.ParameterNames.FailOnCollision,value:"FailOnCollision"}]}),e.HostParameterMap.addComplexType(e.PropertyDescriptors.BindingProperties),e.HostParameterMap.define({type:e.ParameterNames.BindingType,toHost:[{name:Office.BindingType.Text,value:2},{name:Office.BindingType.Matrix,value:3},{name:Office.BindingType.Table,value:1}],invertible:!0}),e.HostParameterMap.define({type:e.PropertyDescriptors.BindingProperties,fromHost:[{name:e.BindingProperties.Id,value:"Name"},{name:e.BindingProperties.Type,value:"BindingType"},{name:e.BindingProperties.RowCount,value:"RowCount"},{name:e.BindingProperties.ColumnCount,value:"ColCount"},{name:e.BindingProperties.HasHeaders,value:"HasHeaders"}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.SingleBindingResponse,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:0}]}),e.HostParameterMap.define({type:66,fromHost:[{name:e.WACDelegate.UniqueArguments.SingleBindingResponse,value:e.WACDelegate.UniqueArguments.BindingResponse}],toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:67,fromHost:[{name:e.WACDelegate.UniqueArguments.SingleBindingResponse,value:e.WACDelegate.UniqueArguments.BindingResponse}],toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:78,fromHost:[{name:e.WACDelegate.UniqueArguments.SingleBindingResponse,value:e.WACDelegate.UniqueArguments.BindingResponse}],toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:69,toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:68,fromHost:[{name:e.WACDelegate.UniqueArguments.SingleBindingResponse,value:e.WACDelegate.UniqueArguments.BindingResponse}],toHost:[{name:e.WACDelegate.UniqueArguments.BindingRequest,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:74,fromHost:[{name:e.ListDescriptors.BindingList,value:e.WACDelegate.UniqueArguments.BindingResponse}]}),e.HostParameterMap.define({type:70,fromHost:[{name:e.ParameterNames.Data,value:e.WACDelegate.UniqueArguments.Data}],toHost:[{name:e.WACDelegate.UniqueArguments.GetData,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:71,toHost:[{name:e.WACDelegate.UniqueArguments.SetData,value:e.HostParameterMap.self}]})},initializeFunc:function(){e.manufactureBinding=function(t,n){var r,o=t[e.BindingProperties.Id],i=t[e.BindingProperties.RowCount],a=t[e.BindingProperties.ColumnCount],s=t[e.BindingProperties.HasHeaders];switch(t[e.BindingProperties.Type]){case Office.BindingType.Text:r=new e.TextBinding(o,n);break;case Office.BindingType.Matrix:r=null,r=new e.MatrixBinding(o,n,i,a);break;case Office.BindingType.Table:r=new(e._OfficeAppFactory.getHostInfo().hostType==e.HostInfoHostType.excel&&Office.context.document&&e.ExcelTableBinding?e.ExcelTableBinding:e.TableBinding)(o,n,i,a,s);break;default:r=new e.UnknownBinding(o,n)}return r}}})}(e.Bindings||(e.Bindings={})),e.BindingEvents||(e.BindingEvents={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDispId.dispidBindingSelectionChangedEvent,fromHost:[{name:e.EventDescriptors.BindingSelectionChangedEvent,value:e.HostParameterMap.self}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingDataChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}]})},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDescriptors.BindingSelectionChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.WACDelegate.UniqueArguments.BindingEventSource},{name:e.PropertyDescriptors.Subset,value:e.PropertyDescriptors.Subset}]}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingSelectionChangedEvent,fromHost:[{name:e.EventDescriptors.BindingSelectionChangedEvent,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingDataChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.WACDelegate.UniqueArguments.BindingEventSource}]})}});var t=function(){function t(e){this.m_id=e}return Object.defineProperty(t.prototype,"onFail",{get:function(){return this.m_errorCallback},set:function(t){var n=typeof t;if("undefined"!=n&&"function"!=n)throw e.OUtil.formatString(Strings.OfficeOM.L_CallbackNotAFunction,n);this.m_errorCallback=t},enumerable:!0,configurable:!0}),t.prototype._fetch=function(t){if(this.m_binding)t&&t(this.m_binding);else if(!this.m_binding){var n=this;Office.context.document.bindings.getByIdAsync(this.m_id,(function(r){r.status==Office.AsyncResultStatus.Succeeded?(e.OUtil.defineEnumerableProperty(n,"binding",{value:r.value}),t&&t(n.m_binding)):n.onFail&&n.onFail(r)}))}return this},t.prototype.getDataAsync=function(){var e=arguments;return this._fetch((function(t){t.getDataAsync.apply(t,e)})),this},t.prototype.setDataAsync=function(){var e=arguments;return this._fetch((function(t){t.setDataAsync.apply(t,e)})),this},t.prototype.addHandlerAsync=function(){var e=arguments;return this._fetch((function(t){t.addHandlerAsync.apply(t,e)})),this},t.prototype.removeHandlerAsync=function(){var e=arguments;return this._fetch((function(t){t.removeHandlerAsync.apply(t,e)})),this},t.prototype.setTableOptionsAsync=function(){var e=arguments;return this._fetch((function(t){t.setTableOptionsAsync.apply(t,e)})),this},t.prototype.setFormatsAsync=function(){var e=arguments;return this._fetch((function(t){t.setFormatsAsync.apply(t,e)})),this},t.prototype.clearFormatsAsync=function(){var e=arguments;return this._fetch((function(t){t.clearFormatsAsync.apply(t,e)})),this},t}();e.BindingPromise=t;var n=function(){function e(e,t){this.m_id=e,this.m_docInstance=t}return Object.defineProperty(e.prototype,"document",{get:function(){return this.m_docInstance},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),e}();e.UnknownBinding=n;var r=function(){function t(t,n){this.m_id=t,this.m_docInstance=n;var r=e.EventType,o=n.bindings._eventDispatches;o[t]||(o[t]=new e.EventDispatch([r.BindingSelectionChanged,r.BindingDataChanged]));var i=o[t];e.DispIdHost.addEventSupport(this,i)}return t.prototype.getDataAsync=function(t,n){e.DispIdHost.InvokeMethod(e.AsyncMethods.GetDataAsync,arguments,this,void 0)},t.prototype.setDataAsync=function(t,n,r){e.DispIdHost.InvokeMethod(e.AsyncMethods.SetDataAsync,arguments,this,void 0)},Object.defineProperty(t.prototype,"document",{get:function(){return this.m_docInstance},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),t}();e.Binding=r;var o=function(e){function t(t,n,r,o){var i=e.call(this,t,n)||this;return i.m_rows=r,i.m_cols=o,i}return __extends(t,e),Object.defineProperty(t.prototype,"type",{get:function(){return Office.BindingType.Matrix},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rowCount",{get:function(){return this.m_rows?this.m_rows:0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"columnCount",{get:function(){return this.m_cols?this.m_cols:0},enumerable:!0,configurable:!0}),t}(e.Binding);e.MatrixBinding=o;var i=function(t){function n(e,n,r,o,i){var a=t.call(this,e,n)||this;return a.m_rows=r,a.m_cols=o,a.m_hasHeaders=i,a}return __extends(n,t),Object.defineProperty(n.prototype,"type",{get:function(){return Office.BindingType.Table},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"rowCount",{get:function(){return this.m_rows?this.m_rows:0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"columnCount",{get:function(){return this.m_cols?this.m_cols:0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"hasHeaders",{get:function(){return!!this.m_hasHeaders&&this.m_hasHeaders},enumerable:!0,configurable:!0}),n.prototype.addRowsAsync=function(t,n,r){e.DispIdHost.InvokeMethod(e.AsyncMethods.AddRowsAsync,arguments,this,void 0)},n.prototype.addColumnsAsync=function(t,n,r){e.DispIdHost.InvokeMethod(e.AsyncMethods.AddColumnsAsync,arguments,this,void 0)},n.prototype.deleteAllDataValuesAsync=function(t,n){e.DispIdHost.InvokeMethod(e.AsyncMethods.DeleteAllDataValuesAsync,arguments,this,void 0)},n}(e.Binding);e.TableBinding=i;var a=function(t){function n(n,r,o,i,a){var s=t.call(this,n,r,o,i,a)||this;return e.OUtil.finalizeProperties(s),s}return __extends(n,t),n.prototype.clearFormatsAsync=function(t,n){e.DispIdHost.InvokeMethod(e.AsyncMethods.ClearFormatsAsync,arguments,this,void 0)},n.prototype.setTableOptionsAsync=function(t,n,r){e.DispIdHost.InvokeMethod(e.AsyncMethods.SetTableOptionsAsync,arguments,this,void 0)},n.prototype.setFormatsAsync=function(t,n,r){e.DispIdHost.InvokeMethod(e.AsyncMethods.SetFormatsAsync,arguments,this,void 0)},n}(e.TableBinding);e.ExcelTableBinding=a,function(t){function n(e){return e.id}e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.AddRowsAsync,requiredArguments:[{name:e.ParameterNames.Data,types:["object"]}],supportedOptions:[],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.AddColumnsAsync,requiredArguments:[{name:e.ParameterNames.Data,types:["object"]}],supportedOptions:[],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.DeleteAllDataValuesAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]})}})}(e.TableBindingMethods||(e.TableBindingMethods={}));var s=function(e){function t(t,n){return e.call(this,t,n)||this}return __extends(t,e),Object.defineProperty(t.prototype,"type",{get:function(){return Office.BindingType.Text},enumerable:!0,configurable:!0}),t}(e.Binding);function c(){return"UnnamedBinding_"+e.OUtil.getUniqueId()+"_"+(new Date).getTime()}e.TextBinding=s,e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.BindingSelectionChanged,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.BindingDataChanged,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[]})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDescriptors.BindingSelectionChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:0},{name:e.PropertyDescriptors.Subset,value:1}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingSelectionChangedEvent,fromHost:[{name:e.EventDescriptors.BindingSelectionChangedEvent,value:e.HostParameterMap.self}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingDataChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.HostParameterMap.self}]})},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDescriptors.BindingSelectionChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.WACDelegate.UniqueArguments.BindingEventSource},{name:e.PropertyDescriptors.Subset,value:e.PropertyDescriptors.Subset}]}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingSelectionChangedEvent,fromHost:[{name:e.EventDescriptors.BindingSelectionChangedEvent,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.EventDispId.dispidBindingDataChangedEvent,fromHost:[{name:e.PropertyDescriptors.BindingProperties,value:e.WACDelegate.UniqueArguments.BindingEventSource}]})}})}(OSF||(OSF={})),function(e){!function(t){function n(t){if(null==t||null==t)return null;var n=null,r=typeof t;return void 0!==t.rows?n=Office.CoercionType.Table:e.OUtil.isArray(t)?n=Office.CoercionType.Matrix:("string"==r||"number"==r||"boolean"==r||e.OUtil.isDate(t))&&(n=Office.CoercionType.Text),n}function r(t,r,o){return(o=o||n(t))&&o!=r&&(t=function(t,n){var r;switch(t){case Office.CoercionType.Table:r=n;break;case Office.CoercionType.Matrix:r=function(e){var t=e.rows;null!=e.headers&&t.unshift(e.headers);return t}(n);break;case Office.CoercionType.SlideRange:e.manufactureSlideRange&&null==(r=e.manufactureSlideRange(i(n)))&&(r=i(n));break;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:r=i(n)}return r}(r,function(e,t){null==t&&(t=n(e));var r;switch(t){case Office.CoercionType.Table:r=e;break;case Office.CoercionType.Matrix:r=new Office.TableData(e);break;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:r=new Office.TableData(function(e){for(var t=e.split("\n"),n=0;n<t.length;n++)t[n]=t[n].split("\t");return t}(e))}return r}(t,o))),t}function o(e){if(1==e.length&&1==e[0].length)return""+e[0][0];for(var t="",n=0;n<e.length;n++)t+=e[n].join("\t")+"\n";return t.substring(0,t.length-1)}function i(e){var t="";null!=e.headers&&(t=o([e.headers])+"\n");var n=o(e.rows);return""==n&&(t=t.substring(0,t.length-1)),t+n}e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.ParameterNames.CoercionType,toHost:[{name:Office.CoercionType.Text,value:0},{name:Office.CoercionType.Matrix,value:1},{name:Office.CoercionType.Table,value:2},{name:Office.CoercionType.Html,value:3},{name:Office.CoercionType.Ooxml,value:4},{name:Office.CoercionType.OoxmlPackage,value:5},{name:Office.CoercionType.PdfFile,value:6},{name:Office.CoercionType.SlideRange,value:7}]});var t=e._OfficeAppFactory.getHostInfo();t.hostPlatform!=e.HostInfoPlatform.win32&&t.hostPlatform!=e.HostInfoPlatform.mac&&t.hostPlatform!=e.HostInfoPlatform.ios&&t.hostPlatform!=e.HostInfoPlatform.android||(e.OUtil.augmentList(Office.CoercionType,{Image:"image"}),e.OUtil.augmentList(Office.CoercionType,{XmlSvg:"xmlSvg"}),e.HostParameterMap.define({type:e.ParameterNames.CoercionType,toHost:[{name:"image",value:8},{name:"xmlSvg",value:9}]}));e.HostParameterMap.define({type:e.ParameterNames.ValueFormat,toHost:[{name:Office.ValueFormat.Unformatted,value:0},{name:Office.ValueFormat.Formatted,value:1}]}),e.HostParameterMap.define({type:e.ParameterNames.FilterType,toHost:[{name:Office.FilterType.All,value:0}]})},defineWebParameterMapFunc:function(){e.OUtil.augmentList(Office.CoercionType,{Image:"image"}),e.OUtil.augmentList(Office.CoercionType,{XmlSvg:"xmlSvg"}),e.HostParameterMap.define({type:e.ParameterNames.CoercionType,toHost:[{name:Office.CoercionType.Text,value:0},{name:Office.CoercionType.Matrix,value:1},{name:Office.CoercionType.Table,value:2},{name:Office.CoercionType.Html,value:3},{name:Office.CoercionType.Ooxml,value:4},{name:Office.CoercionType.OoxmlPackage,value:5},{name:Office.CoercionType.PdfFile,value:6},{name:Office.CoercionType.SlideRange,value:7},{name:"image",value:8},{name:"xmlSvg",value:9}]}),e.HostParameterMap.define({type:e.ParameterNames.ValueFormat,toHost:[{name:Office.ValueFormat.Unformatted,value:0},{name:Office.ValueFormat.Formatted,value:1}]}),e.HostParameterMap.define({type:e.ParameterNames.FilterType,toHost:[{name:Office.FilterType.All,value:0}]})}}),t.findArrayDimensionality=function t(n){if(e.OUtil.isArray(n)){for(var r=0,o=0;o<n.length;o++)r=Math.max(r,t(n[o]));return r+1}return 0},t.getCoercionDefaultForBinding=function(e){switch(e){case Office.BindingType.Matrix:return Office.CoercionType.Matrix;case Office.BindingType.Table:return Office.CoercionType.Table;case Office.BindingType.Text:default:return Office.CoercionType.Text}},t.getBindingDefaultForCoercion=function(e){switch(e){case Office.CoercionType.Matrix:return Office.BindingType.Matrix;case Office.CoercionType.Table:return Office.BindingType.Table;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:return Office.BindingType.Text}},t.determineCoercionType=n,t.coerceData=r,t.serializeDynamicData=function(t){if(null!=t&&void 0!==t.rows){var n={};n[e.TableDataProperties.TableRows]=t.rows,n[e.TableDataProperties.TableHeaders]=t.headers,t=n}var r;if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)return"string"!=typeof t&&void 0!==t[e.TableDataProperties.TableRows]?((r={}).Rows=t[e.TableDataProperties.TableRows],r.Headers=t[e.TableDataProperties.TableHeaders],t=r):e.DataCoercion.determineCoercionType(t)==Office.CoercionType.Text&&(t=[[t]]),t;if(e.TableDataProperties&&"string"!=typeof t&&void 0!==t[e.TableDataProperties.TableRows]){(r=[])[0]=t[e.TableDataProperties.TableRows],r[1]=t[e.TableDataProperties.TableHeaders],t=r}return t},t.deserializeDynamicData=function(t,n){var o=null;if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)null!=t.Rows?((o={})[e.TableDataProperties.TableRows]=t.Rows,o[e.TableDataProperties.TableHeaders]=t.Headers):o=t,!o||null==o[e.TableDataProperties.TableRows]&&null==o[e.TableDataProperties.TableHeaders]||(o=Office.manufactureTableData(o)),o=r(o,n);else{if(2===t.length){(o={})[e.TableDataProperties.TableRows]=t[0],o[e.TableDataProperties.TableHeaders]=t[1],o=Office.manufactureTableData(o)}else o=t;o=r(o,n)}return o}}(e.DataCoercion||(e.DataCoercion={}))}(OSF||(OSF={})),function(e){!function(e){!function(e){e.CoercionType="CoerceType"}(e.GetDataKeys||(e.GetDataKeys={})),function(e){e.CoercionType="CoerceType",e.Data="Data",e.ImageLeft="ImageLeft",e.ImageTop="ImageTop",e.ImageWidth="ImageWidth",e.ImageHeight="ImageHeight"}(e.SetDataKeys||(e.SetDataKeys={})),function(e){e.Html="html",e.Ooxml="ooxml",e.SlideRange="slideRange",e.Text="text",e.Table="table",e.Matrix="matrix",e.Image="image",e.XmlSvg="xmlSvg"}(e.CoercionTypeKeys||(e.CoercionTypeKeys={}))}(e.Marshaling||(e.Marshaling={})),e.DataIO||(e.DataIO={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.GetData,toHost:[{name:e.ParameterNames.Id,value:"BindingId"},{name:e.ParameterNames.CoercionType,value:"CoerceType"},{name:e.ParameterNames.ValueFormat,value:"ValueFormat"},{name:e.ParameterNames.FilterType,value:"FilterType"},{name:e.ParameterNames.Rows,value:"Rows"},{name:e.ParameterNames.Columns,value:"Columns"},{name:e.ParameterNames.StartRow,value:"StartRow"},{name:e.ParameterNames.StartColumn,value:"StartCol"},{name:e.ParameterNames.RowCount,value:"RowCount"},{name:e.ParameterNames.ColumnCount,value:"ColCount"}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.SetData,toHost:[{name:e.ParameterNames.Id,value:"BindingId"},{name:e.ParameterNames.CoercionType,value:"CoerceType"},{name:e.ParameterNames.Data,value:e.WACDelegate.UniqueArguments.Data},{name:e.ParameterNames.Rows,value:"Rows"},{name:e.ParameterNames.Columns,value:"Columns"},{name:e.ParameterNames.StartRow,value:"StartRow"},{name:e.ParameterNames.StartColumn,value:"StartCol"},{name:e.ParameterNames.ImageLeft,value:"ImageLeft"},{name:e.ParameterNames.ImageTop,value:"ImageTop"},{name:e.ParameterNames.ImageWidth,value:"ImageWidth"},{name:e.ParameterNames.ImageHeight,value:"ImageHeight"}]})}})}(OSF||(OSF={})),function(e){!function(e){!function(e){e.MessageType="messageType",e.MessageContent="messageContent",e.MessageOrigin="messageOrigin"}(e.DialogMessageReceivedEventKeys||(e.DialogMessageReceivedEventKeys={})),function(e){e.MessageType="messageType",e.MessageContent="messageContent",e.MessageOrigin="messageOrigin"}(e.DialogParentMessageReceivedEventKeys||(e.DialogParentMessageReceivedEventKeys={})),function(e){e.MessageToParent="messageToParent",e.TargetOrigin="targetOrigin"}(e.MessageParentKeys||(e.MessageParentKeys={})),function(e){e.DialogNotificationShown="dialogNotificationShown"}(e.DialogNotificationShownEventType||(e.DialogNotificationShownEventType={})),function(e){e.MessageContent="messageContent",e.TargetOrigin="targetOrigin"}(e.SendMessageKeys||(e.SendMessageKeys={}))}(e.Marshaling||(e.Marshaling={}))}(OSF||(OSF={})),function(e){var t;!function(e){e.DialogParentMessageReceivedEvent="DialogParentMessageReceivedEvent",e.DialogMessageReceivedEvent="DialogMessageReceivedEvent"}(e.EventDescriptors||(e.EventDescriptors={})),e.DialogParentMessageEventDispatch=new e.EventDispatch([e.EventType.DialogParentMessageReceived,e.EventType.DialogParentEventReceived]),t||(t={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.DisplayDialogAsync,requiredArguments:[{name:e.ParameterNames.Url,types:["string"]}],supportedOptions:[{name:e.ParameterNames.Width,value:{types:["number"],defaultValue:99}},{name:e.ParameterNames.Height,value:{types:["number"],defaultValue:99}},{name:e.ParameterNames.RequireHTTPs,value:{types:["boolean"],defaultValue:!0}},{name:e.ParameterNames.DisplayInIframe,value:{types:["boolean"],defaultValue:!1}},{name:e.ParameterNames.HideTitle,value:{types:["boolean"],defaultValue:!1}},{name:e.ParameterNames.UseDeviceIndependentPixels,value:{types:["boolean"],defaultValue:!1}},{name:e.ParameterNames.PromptBeforeOpen,value:{types:["boolean"],defaultValue:!0}},{name:e.ParameterNames.EnforceAppDomain,value:{types:["boolean"],defaultValue:!0}},{name:e.ParameterNames.UrlNoHostInfo,value:{types:["boolean"],defaultValue:!1}}],privateStateCallbacks:[],onSucceeded:function(t,n,r){var o=t[e.ParameterNames.Id],i=t[e.ParameterNames.Data],a={},s=e.AsyncMethods.CloseAsync;e.OUtil.defineEnumerableProperty(a,s,{value:function(){var t=e.DispIdHost.CloseDialog;t(arguments,o,i,a)}});var c=e.SyncMethods.AddMessageHandler;if(e.OUtil.defineEnumerableProperty(a,c,{value:function(){var t=e.SyncMethodCalls.get(e.SyncMethods.AddMessageHandler),n=t.verifyAndExtractCall(arguments,a,i),r=n[e.ParameterNames.EventType],o=n[e.ParameterNames.Handler];return i.addEventHandlerAndFireQueuedEvent(r,o)}}),!0===e.EnableSendMessageDialogAPI){var l=e.SyncMethods.SendMessage;e.OUtil.defineEnumerableProperty(a,l,{value:function(){var t=e.DispIdHost.SendMessage;return t(arguments,i,a)}})}if(!0===e.EnableMessageChildDialogAPI){var u=e.SyncMethods.MessageChild;e.OUtil.defineEnumerableProperty(a,u,{value:function(){var t=e.DispIdHost.SendMessage;return t(arguments,i,a)}})}return a},checkCallArgs:function(t,n,r){return t[e.ParameterNames.Width]<=0&&(t[e.ParameterNames.Width]=1),!t[e.ParameterNames.UseDeviceIndependentPixels]&&t[e.ParameterNames.Width]>100&&(t[e.ParameterNames.Width]=99),t[e.ParameterNames.Height]<=0&&(t[e.ParameterNames.Height]=1),!t[e.ParameterNames.UseDeviceIndependentPixels]&&t[e.ParameterNames.Height]>100&&(t[e.ParameterNames.Height]=99),t[e.ParameterNames.RequireHTTPs]||(t[e.ParameterNames.RequireHTTPs]=!0),t}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.CloseAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[]}),e.SyncMethodCalls.define({method:e.SyncMethods.MessageParent,requiredArguments:[{name:e.ParameterNames.MessageToParent,types:["string","number","boolean"]}],supportedOptions:[{name:e.ParameterNames.TargetOrigin,value:{types:["string"],defaultValue:""}}]}),e.SyncMethodCalls.define({method:e.SyncMethods.AddMessageHandler,requiredArguments:[{name:e.ParameterNames.EventType,enum:e.EventType,verify:function(e,t,n){return n.supportsEvent(e)}},{name:e.ParameterNames.Handler,types:["function"]}],supportedOptions:[]}),e.SyncMethodCalls.define({method:e.SyncMethods.SendMessage,requiredArguments:[{name:e.ParameterNames.MessageContent,types:["string"]}],supportedOptions:[{name:e.ParameterNames.TargetOrigin,value:{types:["string"],defaultValue:""}}],privateStateCallbacks:[]})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDispId.dispidDialogMessageReceivedEvent,fromHost:[{name:e.EventDescriptors.DialogMessageReceivedEvent,value:e.HostParameterMap.self}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDescriptors.DialogMessageReceivedEvent,fromHost:[{name:e.PropertyDescriptors.MessageType,value:0},{name:e.PropertyDescriptors.MessageContent,value:1},{name:e.PropertyDescriptors.MessageOrigin,value:2}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidDialogParentMessageReceivedEvent,fromHost:[{name:e.EventDescriptors.DialogParentMessageReceivedEvent,value:e.HostParameterMap.self}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDescriptors.DialogParentMessageReceivedEvent,fromHost:[{name:e.PropertyDescriptors.MessageType,value:0},{name:e.PropertyDescriptors.MessageContent,value:1},{name:e.PropertyDescriptors.MessageOrigin,value:2}],isComplexType:!0})},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDispId.dispidDialogMessageReceivedEvent,fromHost:[{name:e.EventDescriptors.DialogMessageReceivedEvent,value:e.HostParameterMap.self}]}),e.HostParameterMap.addComplexType(e.EventDescriptors.DialogMessageReceivedEvent),e.HostParameterMap.define({type:e.EventDescriptors.DialogMessageReceivedEvent,fromHost:[{name:e.PropertyDescriptors.MessageType,value:e.Marshaling.DialogMessageReceivedEventKeys.MessageType},{name:e.PropertyDescriptors.MessageContent,value:e.Marshaling.DialogMessageReceivedEventKeys.MessageContent},{name:e.PropertyDescriptors.MessageOrigin,value:e.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin}]}),e.HostParameterMap.define({type:e.EventDispId.dispidDialogParentMessageReceivedEvent,fromHost:[{name:e.EventDescriptors.DialogParentMessageReceivedEvent,value:e.HostParameterMap.self}]}),e.HostParameterMap.addComplexType(e.EventDescriptors.DialogParentMessageReceivedEvent),e.HostParameterMap.define({type:e.EventDescriptors.DialogParentMessageReceivedEvent,fromHost:[{name:e.PropertyDescriptors.MessageType,value:e.Marshaling.DialogParentMessageReceivedEventKeys.MessageType},{name:e.PropertyDescriptors.MessageContent,value:e.Marshaling.DialogParentMessageReceivedEventKeys.MessageContent},{name:e.PropertyDescriptors.MessageOrigin,value:e.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin}]}),e.HostParameterMap.define({type:144,toHost:[{name:e.ParameterNames.MessageToParent,value:e.Marshaling.MessageParentKeys.MessageToParent},{name:e.ParameterNames.TargetOrigin,value:e.Marshaling.MessageParentKeys.TargetOrigin}]}),e.HostParameterMap.define({type:145,toHost:[{name:e.ParameterNames.MessageContent,value:e.Marshaling.SendMessageKeys.MessageContent},{name:e.ParameterNames.TargetOrigin,value:e.Marshaling.MessageParentKeys.TargetOrigin}]})},initializeFunc:function(){var t=e.OUtil.isPopupWindow();e.EnableMessageChildDialogAPI=!0,"onenote"==e._OfficeAppFactory.getHostInfo().hostType?e.EnableSendMessageDialogAPI=!1:e.EnableSendMessageDialogAPI=!0;var n=Office.context.ui;if(e.OUtil.isDialog()){var r=e.SyncMethods.MessageParent;n[r]||e.OUtil.defineEnumerableProperty(n,r,{value:function(){var t=e.DispIdHost.MessageParent;return t(arguments,n)}});var o=e.SyncMethods.AddMessageHandler;n[o]||void 0===e.DialogParentMessageEventDispatch||e.DispIdHost.addEventSupport(n,e.DialogParentMessageEventDispatch,t),t&&e.WacDialogAction.registerMessageReceivedEvent()}else{var i;i=null!=e.EventType.DialogParentMessageReceived?new e.EventDispatch([e.EventType.DialogMessageReceived,e.EventType.DialogEventReceived,e.EventType.DialogParentMessageReceived]):new e.EventDispatch([e.EventType.DialogMessageReceived,e.EventType.DialogEventReceived]);var a=e.AsyncMethods.DisplayDialogAsync;n[a]||e.OUtil.defineEnumerableProperty(n,a,{value:function(){var t=e.DispIdHost.OpenDialog;t(arguments,i,n)}})}e.OUtil.finalizeProperties(n)}})}(OSF||(OSF={}));var OfficeExt,Office,DialogApiManager=function(){function e(){}return e.messageChildRichApiBridge=function(){if(!0===OSF.EnableMessageChildDialogAPI){var e=OSF.DispIdHost.SendMessage;return e(arguments,null,null)}},e}();!function(e){!function(e){e.Url="url",e.Width="width",e.Height="height",e.DisplayInIframe="displayInIframe",e.HideTitle="hideTitle",e.UseDeviceIndependentPixels="useDeviceIndependentPixels",e.PromptBeforeOpen="promptBeforeOpen",e.EnforceAppDomain="enforceAppDomain",e.UrlNoHostInfo="urlNoHostInfo",e.TargetOrigin="targetOrigin"}(e.ShowWindowDialogParameterKeys||(e.ShowWindowDialogParameterKeys={})),function(e){var t="excel",n="word",r="powerpoint",o="outlook",i="visio";e.getDialogCssManager=function(e){switch(e){case t:case n:case r:case o:case i:default:return new a}};var a=function(){function e(){this.overlayElementCSS=["position: absolute","top: 0","left: 0","width: 100%","height: 100%","background-color: rgba(198, 198, 198, 0.5)","z-index: 99998"],this.dialogNotificationPanelCSS=["width: 100%","height: 190px","position: absolute","z-index: 99999","background-color: rgba(255, 255, 255, 1)","left: 0px","top: 50%","margin-top: -95px"],this.newWindowNotificationTextPanelCSS=["margin: 20px 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","font-size: 14px","height: 100px","line-height: 100px"],this.newWindowNotificationTextSpanCSS=["display: inline-block","line-height: normal","vertical-align: middle"],this.crossZoneNotificationTextPanelCSS=["margin: 20px 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","font-size: 14px","height: 100px"],this.dialogNotificationButtonPanelCSS="margin:0px 9px",this.buttonStyleCSS=["text-align: center","width: 70px","height: 25px","font-size: 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","margin: 0px 5px","border-width: 1px","border-style: solid"]}return e.prototype.getOverlayElementCSS=function(){return this.overlayElementCSS.join(";")},e.prototype.getDialogNotificationPanelCSS=function(){return this.dialogNotificationPanelCSS.join(";")},e.prototype.getNewWindowNotificationTextPanelCSS=function(){return this.newWindowNotificationTextPanelCSS.join(";")},e.prototype.getNewWindowNotificationTextSpanCSS=function(){return this.newWindowNotificationTextSpanCSS.join(";")},e.prototype.getCrossZoneNotificationTextPanelCSS=function(){return this.crossZoneNotificationTextPanelCSS.join(";")},e.prototype.getDialogNotificationButtonPanelCSS=function(){return this.dialogNotificationButtonPanelCSS},e.prototype.getDialogButtonCSS=function(){return this.buttonStyleCSS.join(";")},e}();e.DefaultDialogCSSManager=a}(e.WacCommonUICssManager||(e.WacCommonUICssManager={})),function(t){var n=null,r=null,o=null,i=null,a="osfDialogInternal:action=closeDialog",s=null,c=!1,l=-1,u="messageParentKey",d=null,f="#ababab",p="#ffffff",g="newWindowNotificaiton",h="configureBrowserLink",m="dialogNotificationTextPanel",y={dispId:e.EventDispId.dispidDialogNotificationShownInAddinEvent,eventType:e.Marshaling.DialogNotificationShownEventType.DialogNotificationShown,onComplete:null,onCalling:null};function v(t,n){var r=n.message,o=n.targetOrigin;if(o)t.postMessage(r,o);else{var i=e._OfficeAppFactory.getOfficeAppContext().get_appDomains(),a=window.location.origin;if(a||(a=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"")),i)for(var s=0;s<i.length&&-1!==i[s].indexOf("://");s++)t.postMessage(r,i[s]);e.XdmCommunicationManager.checkUrlWithAppDomains(i,a)||t.postMessage(r,a)}}function b(){try{i&&i.id==g&&s&&s(12009)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during executing displayDialogAsync callback."+t)}R()}function C(t,n){var r=!1,a=e.WacCommonUICssManager.getDialogCssManager(n);o=I(a),document.body.insertBefore(o,document.body.firstChild),(i=function(t,n){var r=document.createElement("div");r.style.cssText=t.getDialogNotificationPanelCSS(),D(r);var o=document.createElement("div");o.style.cssText=t.getCrossZoneNotificationTextPanelCSS(),o.id=m;var i=document.createElement("a");i.id=h,i.href="#",i.innerText=Strings.OfficeOM.L_NewWindowCrossZoneConfigureBrowserLink,i.setAttribute("onclick","window.open('https://support.microsoft.com/en-us/help/17479/windows-internet-explorer-11-change-security-privacy-settings', '_blank', 'fullscreen=1')");var a=document.createElement("span");if(Strings.OfficeOM.L_NewWindowCrossZone){var s=Strings.OfficeOM.L_NewWindowCrossZone.replace(/{1+}/gm,e.OUtil.getDomainForUrl(n)).split("{0}");a.appendChild(document.createTextNode(s[0])),a.appendChild(i),a.appendChild(document.createTextNode(s[1]))}return o.appendChild(a),r.appendChild(o),r}(a,t)).id="crossZoneNotification";var s=w(a),l=A(a,Strings.OfficeOM.L_DialogOK?Strings.OfficeOM.L_DialogOK:"OK");s.appendChild(l),i.appendChild(s),document.body.insertBefore(i,document.body.firstChild),c=!0,l.onclick=function(){R()},l.addEventListener("keydown",(function(e){9==e.keyCode?(document.getElementById(h).focus(),e.preventDefault(),e.stopPropagation()):13==e.keyCode&&(r=!0,e.preventDefault(),e.stopPropagation())}),!1),l.addEventListener("keyup",(function(e){13==e.keyCode&&r&&(r=!1,R(),e.preventDefault(),e.stopPropagation())}),!1),document.getElementById(h).addEventListener("keydown",(function(e){9==e.keyCode&&(l.focus(),e.preventDefault(),e.stopPropagation())}),!1),window.focus(),l.focus()}function _(t){if(t.source==n)try{var o=t.origin;if(!function(t,n,r){if(void 0===r&&(r=!0),!t||!n)return!1;var o=e.OUtil.parseUrl(t),i=e.OUtil.parseUrl(n),a=e._OfficeAppFactory.getOfficeAppContext().get_appDomains();if("https:"!==o.protocol)return!1;var s=o.protocol===i.protocol&&o.hostname===i.hostname&&o.port===i.port,c=e.XdmCommunicationManager.checkUrlWithAppDomains(a,t),l=s||c;return!l&&r&&(l=e.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(n,t)),l}(o,e._OfficeAppFactory.getOfficeAppContext().get_docUrl(),!0))throw new Error("Received a message from a dialog with an untrusted domain.");var i={};i[e.Marshaling.DialogMessageReceivedEventKeys.MessageType]=0,i[e.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=t.data,i[e.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=o,r(i)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during receive message handler."+t)}}function O(t){var n=e._OfficeAppFactory.getId()+u;if(t.key==n)try{var o={};o[e.Marshaling.DialogMessageReceivedEventKeys.MessageType]=0,o[e.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=t.newValue,o[e.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=t.origin,r(o)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during storage changed handler."+t)}}function S(t){var o=e._OfficeAppFactory.getHostInfo(),i=[o.hostType,o.hostPlatform,o.hostSpecificFileVersion,o.hostLocale,o.osfControlAppCorrelationId,"isDialog",o.disableLogging?"disableLogging":"",o.flags&e.HostInfoFlags.PublicAddin].join("$"),a=e._OfficeAppFactory.getOfficeAppContext();a.set_taskpaneUrl(window.location.origin),a.get_taskpaneUrl()||a.set_taskpaneUrl(window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:""));var c=t.url;t[e.ShowWindowDialogParameterKeys.UrlNoHostInfo]||(c=e.OUtil.addHostInfoAsQueryParam(c,i));var u=JSON.parse(window.name);u.hostInfo=i,u.appContext=a;var d=t[e.ShowWindowDialogParameterKeys.Width]*screen.width/100,f=t[e.ShowWindowDialogParameterKeys.Height]*screen.height/100,p="width="+d+", height="+f+", left="+(a.get_clientWindowWidth()/2-d/2)+", top="+(a.get_clientWindowHeight()/2-f/2)+",channelmode=no,directories=no,fullscreen=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,titlebar=yes,toolbar=no";if(null==(n=window.open(c,e.OUtil.serializeObjectToString(u),p)))return e.AppTelemetry.logAppCommonMessage("Encountered cross zone issue in displayDialogAsync api."),T(),C(c,o.hostType),void s(12011);e.OUtil.shouldUseLocalStorageToPassMessage()?window.addEventListener("storage",O):window.addEventListener("message",_),l=window.setInterval((function(){try{if(null==n||n.closed){window.clearInterval(l),e.OUtil.shouldUseLocalStorageToPassMessage()?window.removeEventListener("storage",O):window.removeEventListener("message",_);var t={};t[e.Marshaling.DialogMessageReceivedEventKeys.MessageType]=12006,r(t)}}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during check or handle window close."+t)}}),1e3),null!=s?s(0):e.AppTelemetry&&e.AppTelemetry.logAppException("showDialogCallback can not be null.")}function A(e,t){var n=document.createElement("input");n.setAttribute("type","button"),n.style.cssText=e.getDialogButtonCSS(),n.style.borderColor=f,n.style.backgroundColor=p,n.setAttribute("value",t);var r=function(){E(n)},o=function(){P(n)};return n.addEventListener("mouseover",r),n.addEventListener("focus",r),n.addEventListener("mouseout",o),n.addEventListener("focusout",o),n}function E(t){null!=d?(t.style.borderColor=d.HostButtonBorderColor,t.style.backgroundColor=d.HostButtonBackgroundColor):e.OUtil.getCommonUI()?(t.style.borderColor=e.OUtil.getCommonUI().HostButtonBorderColor,t.style.backgroundColor=e.OUtil.getCommonUI().HostButtonBackgroundColor):t.style.backgroundColor="#ccc"}function P(e){e.style.borderColor=f,e.style.backgroundColor=p}function R(){y.onCalling=function(e){T(),F(e)},e.WACDelegate.unregisterEventAsync(y)}function T(){null!=i&&(document.body.removeChild(i),i=null),null!=o&&(document.body.removeChild(o),o=null)}function I(e){var t=document.createElement("div");return t.style.cssText=e.getOverlayElementCSS(),t}function w(e){var t=document.createElement("div");return t.style.cssText=e.getDialogNotificationButtonPanelCSS(),"rtl"==document.documentElement.getAttribute("dir")?t.style.cssFloat="left":t.style.cssFloat="right",t}function F(t){if(0!=t){var n=document.querySelectorAll(e._OfficeAppFactory.getInitializationHelper().getTabbableElements());e.OUtil.focusToFirstTabbable(n,!1)}}function D(e){e.setAttribute("role","dialog"),e.setAttribute("aria-describedby",m)}t.setHostThemeButtonStyle=function(t){var n=t.input;null!=n&&(d={HostButtonBorderColor:n[e.OUtil.HostThemeButtonStyleKeys.ButtonBorderColor],HostButtonBackgroundColor:n[e.OUtil.HostThemeButtonStyleKeys.ButtonBackgroundColor]}),t.completed()},t.removeEventListenersForDialog=function(t){!function(t){var n=this,r=function(){e._OfficeAppFactory.getWebAppState().focused||(e._OfficeAppFactory.getWebAppState().focused=!0),e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.Select])},o=function(){e&&(e._OfficeAppFactory.getWebAppState().focused&&(e._OfficeAppFactory.getWebAppState().focused=!1),e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.UnSelect]))},i=function(t){if(t.preventDefault=t.preventDefault||function(){t.returnValue=!1},117==t.keyCode&&(t.ctrlKey||t.metaKey)){t.preventDefault();var r=e.AgaveHostAction.CtrlF6Exit;t.shiftKey&&(r=e.AgaveHostAction.CtrlF6ExitShift),e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,r])}else if(9==t.keyCode){t.preventDefault();var o=document.querySelectorAll(n._tabbableElements);e.OUtil.focusToNextTabbable(o,t.target||t.srcElement,t.shiftKey)||(n._hostInfo.isDialog?e.OUtil.focusToFirstTabbable(o,t.shiftKey):t.shiftKey?e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExitShift]):e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExit]))}else if(27==t.keyCode)t.preventDefault(),b(),e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.EscExit]);else if(113==t.keyCode)t.preventDefault(),e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.F2Exit]);else if((t.ctrlKey||t.metaKey||t.shiftKey||t.altKey)&&t.keyCode>=1&&t.keyCode<=255){var i={keyCode:t.keyCode,shiftKey:t.shiftKey,altKey:t.altKey,ctrlKey:t.ctrlKey,metaKey:t.metaKey};e.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.KeyboardShortcuts,i])}},a=function(e){117==e.keyCode&&e.ctrlKey&&(e.preventDefault?e.preventDefault():e.returnValue=!1)};t?(e.OUtil.addEventListener(window,"focus",r),e.OUtil.addEventListener(window,"blur",o),e.OUtil.addEventListener(window,"keydown",i),e.OUtil.addEventListener(window,"keypress",a)):(e.OUtil.removeEventListener(window,"focus",r),e.OUtil.removeEventListener(window,"blur",o),e.OUtil.removeEventListener(window,"keydown",i),e.OUtil.removeEventListener(window,"keypress",a))}(!1),t.completed()},t.handleNewWindowDialog=function(t){try{if(!function(t){var n=e._OfficeAppFactory.getOfficeAppContext().get_appDomains(),r=t.url,o=e.XdmCommunicationManager.checkUrlWithAppDomains(n,r);if(!o)return e._OfficeAppFactory.getOfficeAppContext().get_docUrl()&&e.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(e._OfficeAppFactory.getOfficeAppContext().get_docUrl(),r);return o}(t))return void s(12004);if(!t[e.ShowWindowDialogParameterKeys.PromptBeforeOpen])return void S(t);c=!1;var n=!1,r=e._OfficeAppFactory.getHostInfo(),a=e.WacCommonUICssManager.getDialogCssManager(r.hostType),l=e.OUtil.formatString(Strings.OfficeOM.L_ShowWindowDialogNotification,e._OfficeAppFactory.getOfficeAppContext().get_addinName());o=I(a),document.body.insertBefore(o,document.body.firstChild),(i=function(e,t){var n=document.createElement("div");n.style.cssText=e.getDialogNotificationPanelCSS(),D(n);var r=document.createElement("div");r.style.cssText=e.getNewWindowNotificationTextPanelCSS(),r.id=m,"rtl"==document.documentElement.getAttribute("dir")?r.style.paddingRight="30px":r.style.paddingLeft="30px";var o=document.createElement("span");return o.style.cssText=e.getNewWindowNotificationTextSpanCSS(),o.innerText=t,r.appendChild(o),n.appendChild(r),n}(a,l)).id=g;var u=w(a),d=A(a,Strings.OfficeOM.L_ShowWindowDialogNotificationAllow),f=A(a,Strings.OfficeOM.L_ShowWindowDialogNotificationIgnore);function p(t){y.onCalling=function(e){T(),F(e),s(12009)},e.WACDelegate.unregisterEventAsync(y),t.preventDefault(),t.stopPropagation()}u.appendChild(d),u.appendChild(f),i.appendChild(u),document.body.insertBefore(i,document.body.firstChild),d.onclick=function(e){S(t),c||R(),e.preventDefault(),e.stopPropagation()},f.onclick=p,d.addEventListener("keydown",(function(e){e.shiftKey&&9==e.keyCode&&(P(d),E(f),f.focus(),e.preventDefault(),e.stopPropagation())}),!1),f.addEventListener("keydown",(function(e){e.shiftKey||9!=e.keyCode?13==e.keyCode&&(n=!0,e.preventDefault(),e.stopPropagation()):(P(f),E(d),d.focus(),e.preventDefault(),e.stopPropagation())}),!1),f.addEventListener("keyup",(function(e){13==e.keyCode&&n&&(n=!1,p(e))}),!1),window.focus(),y.onCalling=function(e){d.focus()},e.WACDelegate.registerEventAsync(y)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception happens at new window dialog."+t),s(5001)}},t.closeDialog=function(t){try{if(null!=n){var r=e._OfficeAppFactory.getOfficeAppContext().get_appDomains();if(r)for(var o=0;o<r.length&&-1!==r[o].indexOf("://");o++)n.postMessage(a,r[o]);null==n||n.closed||n.close(),e.OUtil.shouldUseLocalStorageToPassMessage()?window.removeEventListener("storage",O):window.removeEventListener("message",_),window.clearInterval(l),n=null,t(0)}else t(5001)}catch(n){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception happens at close window dialog."+n),t(5001)}},t.messageParent=function(t){var n=t.hostCallArgs[e.ParameterNames.MessageToParent],r=t.hostCallArgs[e.ParameterNames.TargetOrigin]||null;if(e.OUtil.shouldUseLocalStorageToPassMessage())try{var o=e._OfficeAppFactory.getId()+u;window.localStorage.setItem(o,n)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during messageParent method:"+t)}else v(window.opener,{message:n,targetOrigin:r})},t.sendMessage=function(t){if(null!=n){var r=t.hostCallArgs,o=r[e.ParameterNames.TargetOrigin]||null;delete r[e.ParameterNames.TargetOrigin],"string"!=typeof r&&(r=JSON.stringify(r)),v(n,{message:r,targetOrigin:o})}},t.postDialogMessage=v,t.registerMessageReceivedEvent=function(){window.addEventListener("message",(function(t){var n=t.origin;if(t.source==window.opener&&(!0===window.office_disable_receive_dialog_message_prompt||e.WacDialogAction.validateTaskpaneDomain(n,!0)))if("string"==typeof t.data&&t.data.indexOf(a)>-1)window.close();else{var r=t.data,o=typeof r;if(r&&("object"==o||"string"==o)){var i="string"==o?JSON.parse(r):r,s={};s[e.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=i.messageContent,s[e.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=t.origin;var c=e.manufactureEventArgs(e.EventType.DialogParentMessageReceived,null,s);e.DialogParentMessageEventDispatch.fireEvent(c)}}}))},t.setHandlerAndShowDialogCallback=function(e,t){r=e,s=t},t.escDismissDialogNotification=b,t.showCrossZoneNotification=C,t.getWithExpiry=function(e,t){var n=e.getItem(t);if(!n)return"undefined";var r=JSON.parse(n);return r.expiry&&r.value?(new Date).getTime()>r.expiry?(e.removeItem(t),"undefined"):r.value:"undefined"},t.setWithExpiry=function(e,t,n){var r={value:n,expiry:(new Date).getTime()+864e5};e.setItem(t,JSON.stringify(r))},t.getLocalStorage=function(){return e.SafeStorage?new e.SafeStorage(window.localStorage):window.localStorage},t.getSessionStorage=function(){return e.SafeStorage?new e.SafeStorage(window.sessionStorage):window.sessionStorage},t.getUrlProtocolHostnamePort=function(e){var t=e.port?":"+e.port:"";return e.protocol+"//"+e.hostname+t},t.validateTaskpaneDomain=function(t,n){try{if(!t)return!1;n||(n=!0);var r=window.location.origin;r||(r=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:""));var o=e.OUtil.parseUrl(r,!0),i=e.OUtil.parseUrl(t,!0);if(!(o.protocol&&o.hostname&&i.protocol&&i.hostname&&void 0!==i.port))return!1;var a=(y=i,(m=o).hostname==y.hostname&&m.protocol==y.protocol&&function(e,t){var n="80",r="443";return e.port==t.port||""==e.port&&"http:"==e.protocol&&t.port==n||""==e.port&&"https:"==e.protocol&&t.port==r||""==t.port&&"http:"==t.protocol&&e.port==n||""==t.port&&"https:"==t.protocol&&e.port==r}(m,y)),s=!1;if(n&&(s=e.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(t,r)),a||s)return!0;var c=this.getLocalStorage(),l=this.getSessionStorage(),u="_trusts_"+(i.protocol+"//"+i.hostname+(i.port?":"+i.port:"")),d=this.getWithExpiry(c,u),f=this.getWithExpiry(l,u);if("true"===d)return!0;if("false"===f)return!1;var p=this.getUrlProtocolHostnamePort(i),g=this.getUrlProtocolHostnamePort(o),h='You are about to send and receive potentially sensitive information from "'+g+'". Only click OK if you trust the following website recieving the sensitive information: "'+p+'".';return Strings.OfficeOM.L_ConfirmDialogApiTrustsParent&&(h=Strings.OfficeOM.L_ConfirmDialogApiTrustsParent.replace("{0}",g).replace("{1}",p)),window.confirm(h)?(this.setWithExpiry(c,u,"true"),this.setWithExpiry(l,u,"true"),!0):(this.setWithExpiry(c,u,"false"),this.setWithExpiry(l,u,"false"),!1)}catch(t){return e.AppTelemetry&&e.AppTelemetry.logAppException("Error happened during validateTaskpaneDomain method:"+t),!1}var m,y}}(e.WacDialogAction||(e.WacDialogAction={}))}(OSF||(OSF={})),function(e){!function(t){t.openDialog=function(t){try{t.onCalling&&t.onCalling();var n=e.SafeArrayDelegate.getOnAfterRegisterEvent(!0,t);e._OfficeAppFactory.getClientHostController().openDialog(t.dispId,void 0,t.targetId,(function(n,r){t.onEvent&&t.onEvent(r),e.AppTelemetry&&e.AppTelemetry.onEventDone(t.dispId)}),n)}catch(n){e.SafeArrayDelegate.onException(n,t)}},t.closeDialog=function(t){t.onCalling&&t.onCalling();var n=e.SafeArrayDelegate.getOnAfterRegisterEvent(!1,t);try{e._OfficeAppFactory.getClientHostController().closeDialog(t.dispId,void 0,t.targetId,n)}catch(n){e.SafeArrayDelegate.onException(n,t)}},t.messageParent=function(t){try{t.onCalling&&t.onCalling();var n=(new Date).getTime(),r=e._OfficeAppFactory.getClientHostController().messageParent(t.hostCallArgs);return t.onReceiving&&t.onReceiving(),e.AppTelemetry&&e.AppTelemetry.onMethodDone(t.dispId,t.hostCallArgs,Math.abs((new Date).getTime()-n),r),r}catch(t){return e.SafeArrayDelegate.onExceptionSyncMethod(t)}},t.sendMessage=function(t){try{t.onCalling&&t.onCalling();(new Date).getTime();var n=e._OfficeAppFactory.getClientHostController().sendMessage(t.hostCallArgs);return t.onReceiving&&t.onReceiving(),n}catch(t){return e.SafeArrayDelegate.onExceptionSyncMethod(t)}}}(e.SafeArrayDelegate||(e.SafeArrayDelegate={}))}(OSF||(OSF={})),function(e){!function(t){t.openDialog=function(n){var r="https://",o="http://",i=JSON.parse(n.targetId),a=t.getOnAfterRegisterEvent(!0,n);function s(t){var n={Error:t};try{a(0,n)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception happens at showDialogCallback."+t)}}if(e.DialogShownStatus.hasDialogShown)s(12007);else{var c=i[e.ShowWindowDialogParameterKeys.Url].toLowerCase(),l=window.location.href.toLowerCase();if(e.AppTelemetry){var u=!1,d=!1,f=!1,p=!1,g="",h="";if(e.OUtil){var m=e.OUtil.parseUrl(c),y=e.OUtil.parseUrl(l);u=m.protocol===y.protocol&&m.hostname===y.hostname&&m.port===y.port,g=e.OUtil.getHostnamePortionForLogging(m.hostname),u?h=g:(h=e.OUtil.getHostnamePortionForLogging(y.hostname),d=e.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(c,l),f=e.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(l,c));var v=e._OfficeAppFactory.getOfficeAppContext().get_appDomains();p=e.XdmCommunicationManager.checkUrlWithAppDomains(v,c)}var b="openDialog isInline: "+i[e.ShowWindowDialogParameterKeys.DisplayInIframe].toString()+", taskpaneHostname: "+h+", dialogHostName: "+g+", isSameDomain: "+u.toString()+", parentIsSubdomain: "+d.toString()+", childIsSubdomain: "+f.toString()+", isAppDomain: "+p.toString();e.AppTelemetry.logAppCommonMessage(b)}null!=c&&c.substr(0,r.length)===r?i[e.ShowWindowDialogParameterKeys.DisplayInIframe]?(e.DialogShownStatus.isWindowDialog=!1,e.WACDelegate.registerEventAsync(n)):(e.DialogShownStatus.isWindowDialog=!0,e.WacDialogAction.setHandlerAndShowDialogCallback((function(t){n.onEvent&&n.onEvent(t),e.AppTelemetry&&e.AppTelemetry.onEventDone(n.dispId)}),s),e.WacDialogAction.handleNewWindowDialog(i)):c.substr(0,o.length)===o?s(12005):s(12003)}},t.validateTaskpaneDomain=function(t,n){return e.WacDialogAction.validateTaskpaneDomain(t,n)},t.messageParent=function(t){var n=t.hostCallArgs.targetOrigin,r=!!n;if(r&&"*"!=n){var o=e.WacDialogAction.getLocalStorage(),i=e.WacDialogAction.getSessionStorage(),a="_trusts_",s=e.OUtil.parseUrl(n,!0);a+=s.protocol+"//"+s.hostname+(s.port?":"+s.port:""),e.WacDialogAction.setWithExpiry(o,a,"true"),e.WacDialogAction.setWithExpiry(i,a,"true")}if(null!=window.opener){if(!r){var c=e._OfficeAppFactory.getOfficeAppContext().get_taskpaneUrl();if(c){if(!e.WacDialogAction.validateTaskpaneDomain(c,!0)){var l="messageParent called but the taskpane domain is untrusted: "+c;throw e.AppTelemetry&&e.AppTelemetry.logAppException(l),new Error(l)}}else c=window.location.origin;t.hostCallArgs.targetOrigin=c}e.WacDialogAction.messageParent(t)}else{var u=window.location.origin;u||(u=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"")),r||(t.hostCallArgs.targetOrigin=u),e.WACDelegate.executeAsync(t)}},t.sendMessage=function(t){e.DialogShownStatus.hasDialogShown&&(e.DialogShownStatus.isWindowDialog?e.WacDialogAction.sendMessage(t):e.WACDelegate.executeAsync(t))},t.closeDialog=function(n){var r=t.getOnAfterRegisterEvent(!1,n);function o(t){var n={Error:t};try{r(0,n)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception happens at closeDialogCallback."+t)}}e.DialogShownStatus.hasDialogShown?e.DialogShownStatus.isWindowDialog?(n.onCalling&&n.onCalling(),e.WacDialogAction.closeDialog(o)):e.WACDelegate.unregisterEventAsync(n):o(12006)}}(e.WACDelegate||(e.WACDelegate={}))}(OSF||(OSF={})),function(e){var t;t||(t={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDispId.dispidDocumentSelectionChangedEvent})},defineWebParameterMapFunc:function(){e.HostParameterMap.define({type:e.EventDispId.dispidDocumentSelectionChangedEvent})},initializeFunc:function(){var t=Office.context.document;e.DispIdHost.addEventSupport(t,new e.EventDispatch([e.EventType.DocumentSelectionChanged,e.EventType.ActiveViewChanged]))}})}(OSF||(OSF={})),function(e){var t;t||(t={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.AddHandlerAsync,requiredArguments:[{name:e.ParameterNames.EventType,enum:e.EventType,verify:function(e,t,n){return n.supportsEvent(e)}},{name:e.ParameterNames.Handler,types:["function"]}],supportedOptions:[],privateStateCallbacks:[]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.RemoveHandlerAsync,requiredArguments:[{name:e.ParameterNames.EventType,enum:e.EventType,verify:function(e,t,n){return n.supportsEvent(e)}}],supportedOptions:[{name:e.ParameterNames.Handler,value:{types:["function","object"],defaultValue:null}}],privateStateCallbacks:[]})}})}(OSF||(OSF={})),function(e){var t;!function(e){e.FeatureProperties="FeatureProperties",e.TcidEnabled="TcidEnabled",e.TcidVisible="TcidVisible"}(e.PropertyDescriptors||(e.PropertyDescriptors={})),function(t){function n(){e.HostParameterMap.define({type:e.PropertyDescriptors.FeatureProperties,fromHost:[{name:e.PropertyDescriptors.TcidEnabled,value:0},{name:e.PropertyDescriptors.TcidVisible,value:1}],isComplexType:!0}),e.HostParameterMap.define({type:146,toHost:[{name:e.ParameterNames.Tcid,value:0}]}),e.HostParameterMap.define({type:147,fromHost:[{name:e.PropertyDescriptors.FeatureProperties,value:e.HostParameterMap.self}],toHost:[{name:e.ParameterNames.Tcid,value:0}]})}e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.ExecuteFeature,requiredArguments:[{name:e.ParameterNames.Tcid,types:["number"]}],privateStateCallbacks:[]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.QueryFeature,requiredArguments:[{name:e.ParameterNames.Tcid,types:["number"]}],privateStateCallbacks:[]})},defineSafeArrayParameterMapFunc:n,defineWebParameterMapFunc:n,initializeFunc:function(){var t=Office.context.ui;e.DispIdHost.addAsyncMethods(t,[e.AsyncMethods.ExecuteFeature]),e.DispIdHost.addAsyncMethods(t,[e.AsyncMethods.QueryFeature])}})}(t||(t={}))}(OSF||(OSF={})),function(e){!function(e){!function(e){e.launchExtensionComponent=function(e,t,n,r,o){var i=OSF.OUtil.Guid.generateNewGuid();null==o&&(o={OptionalProperties:{},DevProperties:{}}),o.OptionalProperties.InstanceToken=i;var a={ExtId:e,ComponentType:t,ComponentId:n,HostProps:r,OptionalProps:o};if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web){var s=OSF._OfficeAppFactory.getWebAppState();return s.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[s.id,OSF.AgaveHostAction.LaunchExtensionComponent,a]),{Id:e,ComponentType:t,ComponentId:n,InstanceToken:i,LaunchProperties:o}}throw OSF.Utility.createNotImplementedException()}}(e.extensionLifeCycle||(e.extensionLifeCycle={}))}(e.context||(e.context={})),function(e){e.close=function(e){OSF._OfficeAppFactory.getClientHostController().closeSdxDialog(e)},e.resize=function(e,t){OSF._OfficeAppFactory.getClientHostController().resizeSdxDialog(e,t)}}(e.ExtensionLifeCycle||(e.ExtensionLifeCycle={}))}(Office||(Office={})),function(e){var t=function(){function e(e,t,n){this.m_fileSize=t,this.m_sliceSize=n,this.m_privateState={},this.m_privateState[OSF.FileProperties.Handle]=e,this.m_privateState[OSF.FileProperties.SliceSize]=n}return Object.defineProperty(e.prototype,"size",{get:function(){return this.m_fileSize},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"sliceCount",{get:function(){return Math.ceil(this.m_fileSize/this.m_sliceSize)},enumerable:!0,configurable:!0}),e.prototype.getSliceAsync=function(e,t){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetDocumentCopyChunkAsync,arguments,this,this.m_privateState)},e.prototype.closeAsync=function(e){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.ReleaseDocumentCopyAsync,arguments,this,this.m_privateState)},e}();e.File=t}(Office||(Office={})),function(e){!function(t){!function(t){t.getFileAsync=function(t,n,r){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetDocumentCopyAsync,arguments,e.context.document,void 0)}}(t.document||(t.document={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){e.FileProperties="FileProperties",e.FileSliceProperties="FileSliceProperties"}(e.PropertyDescriptors||(e.PropertyDescriptors={})),function(e){e.Handle="FileHandle",e.FileSize="FileSize",e.SliceSize="sliceSize"}(e.FileProperties||(e.FileProperties={})),function(e){e.FileSliceOffset="fileSliceoffset"}(e.additionalParameter||(e.additionalParameter={})),function(e){!function(e){!function(e){e[e.Handle=0]="Handle",e[e.FileSize=1]="FileSize"}(e.FilePropertiesKeys||(e.FilePropertiesKeys={})),function(e){e[e.Data=0]="Data",e[e.SliceSize=1]="SliceSize"}(e.SlicePropertiesKeys||(e.SlicePropertiesKeys={})),function(e){e[e.Text=0]="Text",e[e.Compressed=1]="Compressed",e[e.Pdf=2]="Pdf"}(e.FileType||(e.FileType={})),function(e){e[e.FileType=0]="FileType",e[e.SliceSize=1]="SliceSize",e[e.Handle=2]="Handle",e[e.SliceIndex=3]="SliceIndex"}(e.ParameterKeys||(e.ParameterKeys={}))}(e.File||(e.File={}))}(e.Marshaling||(e.Marshaling={})),e.File||(e.File={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.GetDocumentCopyAsync,requiredArguments:[{name:e.ParameterNames.FileType,enum:Office.FileType}],supportedOptions:[{name:e.ParameterNames.SliceSize,value:{types:["number"],defaultValue:e.OUtil.getHostPlatform()==e.HostInfoPlatform.ios?65536:4194304}}],checkCallArgs:function(t,n,r){var o=t[e.ParameterNames.SliceSize];if(o<=0||o>4194304)throw 11002;return t},onSucceeded:function(t,n,r){return new Office.File(t[e.FileProperties.Handle],t[e.FileProperties.FileSize],r[e.ParameterNames.SliceSize])}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.GetDocumentCopyChunkAsync,requiredArguments:[{name:e.ParameterNames.SliceIndex,types:["number"]}],privateStateCallbacks:[{name:e.FileProperties.Handle,value:function(t,n){return n[e.FileProperties.Handle]}},{name:e.FileProperties.SliceSize,value:function(t,n){return n[e.FileProperties.SliceSize]}}],checkCallArgs:function(t,n,r){var o=t[e.ParameterNames.SliceIndex];if(o<0||o>=n.sliceCount)throw 5008;return t[e.additionalParameter.FileSliceOffset]=parseInt((o*r[e.FileProperties.SliceSize]).toString()),t},onSucceeded:function(t,n,r){var o={};return e.OUtil.defineEnumerableProperties(o,{data:{value:e.OUtil.getHostPlatform()==e.HostInfoPlatform.mac?e.OUtil.shallowCopy(t[e.ParameterNames.Data]):t[e.ParameterNames.Data]},index:{value:r[e.ParameterNames.SliceIndex]},size:{value:t[e.FileProperties.SliceSize]}}),o}}),e.AsyncMethodCalls.define({method:e.AsyncMethods.ReleaseDocumentCopyAsync,privateStateCallbacks:[{name:e.FileProperties.Handle,value:function(t,n){return n[e.FileProperties.Handle]}}]})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.PropertyDescriptors.FileProperties,fromHost:[{name:e.FileProperties.Handle,value:0},{name:e.FileProperties.FileSize,value:1}],isComplexType:!0}),e.HostParameterMap.define({type:e.PropertyDescriptors.FileSliceProperties,fromHost:[{name:e.ParameterNames.Data,value:0},{name:e.FileProperties.SliceSize,value:1}],isComplexType:!0}),e.HostParameterMap.define({type:e.ParameterNames.FileType,toHost:[{name:Office.FileType.Text,value:0},{name:Office.FileType.Compressed,value:5},{name:Office.FileType.Pdf,value:6}]}),e.HostParameterMap.define({type:77,toHost:[{name:e.ParameterNames.FileType,value:0}],fromHost:[{name:e.PropertyDescriptors.FileProperties,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:80,toHost:[{name:e.FileProperties.Handle,value:0},{name:e.additionalParameter.FileSliceOffset,value:1},{name:e.FileProperties.SliceSize,value:2}],fromHost:[{name:e.PropertyDescriptors.FileSliceProperties,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:81,toHost:[{name:e.FileProperties.Handle,value:0}]})},defineWebParameterMapFunc:function(){e.HostParameterMap.addComplexType(e.PropertyDescriptors.FileProperties),e.HostParameterMap.addComplexType(e.PropertyDescriptors.FileSliceProperties),e.HostParameterMap.define({type:e.PropertyDescriptors.FileProperties,fromHost:[{name:e.FileProperties.Handle,value:e.Marshaling.File.FilePropertiesKeys.Handle},{name:e.FileProperties.FileSize,value:e.Marshaling.File.FilePropertiesKeys.FileSize}]}),e.HostParameterMap.define({type:e.PropertyDescriptors.FileSliceProperties,fromHost:[{name:e.ParameterNames.Data,value:e.Marshaling.File.SlicePropertiesKeys.Data},{name:e.FileProperties.SliceSize,value:e.Marshaling.File.SlicePropertiesKeys.SliceSize}]}),e.HostParameterMap.define({type:e.ParameterNames.FileType,toHost:[{name:Office.FileType.Text,value:e.Marshaling.File.FileType.Text},{name:Office.FileType.Compressed,value:e.Marshaling.File.FileType.Compressed},{name:Office.FileType.Pdf,value:e.Marshaling.File.FileType.Pdf}]}),e.HostParameterMap.define({type:77,toHost:[{name:e.ParameterNames.FileType,value:e.Marshaling.File.ParameterKeys.FileType},{name:e.ParameterNames.SliceSize,value:e.Marshaling.File.ParameterKeys.SliceSize}],fromHost:[{name:e.PropertyDescriptors.FileProperties,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:80,toHost:[{name:e.FileProperties.Handle,value:e.Marshaling.File.ParameterKeys.Handle},{name:e.ParameterNames.SliceIndex,value:e.Marshaling.File.ParameterKeys.SliceIndex}],fromHost:[{name:e.PropertyDescriptors.FileSliceProperties,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:81,toHost:[{name:e.FileProperties.Handle,value:e.Marshaling.File.ParameterKeys.Handle}]})}})}(OSF||(OSF={})),function(e){var t=function(e){OSF.OUtil.defineEnumerableProperties(this,{url:{value:e[OSF.FilePropertiesDescriptor.Url]}})};e.FileProperties=t}(OfficeExt||(OfficeExt={})),function(e){e.FilePropertiesDescriptor={Url:"Url"},function(e){e.FilePropertiesDescriptor="FilePropertiesDescriptor"}(e.PropertyDescriptors||(e.PropertyDescriptors={})),function(e){!function(e){e[e.Properties=0]="Properties",e[e.Url=1]="Url"}(e.FilePropertiesKeys||(e.FilePropertiesKeys={}))}(e.Marshaling||(e.Marshaling={})),e.FileProperties||(e.FileProperties={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.GetFilePropertiesAsync,fromHost:[{name:e.PropertyDescriptors.FilePropertiesDescriptor,value:0}],requiredArguments:[],supportedOptions:[],onSucceeded:function(e,t,n){return new OfficeExt.FileProperties(e)}})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.PropertyDescriptors.FilePropertiesDescriptor,fromHost:[{name:e.FilePropertiesDescriptor.Url,value:0}],isComplexType:!0}),e.HostParameterMap.define({type:86,fromHost:[{name:e.PropertyDescriptors.FilePropertiesDescriptor,value:e.HostParameterMap.self}]})},defineWebParameterMapFunc:function(){e.HostParameterMap.addComplexType(e.PropertyDescriptors.FilePropertiesDescriptor),e.HostParameterMap.define({type:e.PropertyDescriptors.FilePropertiesDescriptor,fromHost:[{name:e.FilePropertiesDescriptor.Url,value:e.Marshaling.FilePropertiesKeys.Url}]}),e.HostParameterMap.define({type:86,fromHost:[{name:e.PropertyDescriptors.FilePropertiesDescriptor,value:e.Marshaling.FilePropertiesKeys.Properties}]})},initializeFunc:function(){var t=Office.context.document;e.DispIdHost.addAsyncMethods(t,[e.AsyncMethods.GetFilePropertiesAsync])}})}(OSF||(OSF={})),function(e){var t;!function(t){function n(e){return e.id}e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.ClearFormatsAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.SetTableOptionsAsync,requiredArguments:[{name:e.ParameterNames.TableOptions,defaultValue:[]}],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.SetFormatsAsync,requiredArguments:[{name:e.ParameterNames.CellFormat,defaultValue:[]}],privateStateCallbacks:[{name:e.ParameterNames.Id,value:n}]})}})}(e.Internal||(e.Internal={})),function(e){!function(e){e.Id="BindingId",e.CellFormat="CellFormat",e.TableOptions="TableOptions"}(e.FormatKeys||(e.FormatKeys={})),function(e){e[e.headerRow=0]="headerRow",e[e.bandedRows=1]="bandedRows",e[e.firstColumn=2]="firstColumn",e[e.lastColumn=3]="lastColumn",e[e.bandedColumns=4]="bandedColumns",e[e.filterButton=5]="filterButton",e[e.style=6]="style",e[e.totalRow=7]="totalRow"}(e.TableOptionProperties||(e.TableOptionProperties={})),function(e){e[e.row=0]="row",e[e.column=1]="column"}(e.CellProperties||(e.CellProperties={})),function(e){e[e.alignHorizontal=1]="alignHorizontal",e[e.alignVertical=2]="alignVertical",e[e.backgroundColor=101]="backgroundColor",e[e.borderStyle=201]="borderStyle",e[e.borderColor=202]="borderColor",e[e.borderTopStyle=203]="borderTopStyle",e[e.borderTopColor=204]="borderTopColor",e[e.borderBottomStyle=205]="borderBottomStyle",e[e.borderBottomColor=206]="borderBottomColor",e[e.borderLeftStyle=207]="borderLeftStyle",e[e.borderLeftColor=208]="borderLeftColor",e[e.borderRightStyle=209]="borderRightStyle",e[e.borderRightColor=210]="borderRightColor",e[e.borderOutlineStyle=211]="borderOutlineStyle",e[e.borderOutlineColor=212]="borderOutlineColor",e[e.borderInlineStyle=213]="borderInlineStyle",e[e.borderInlineColor=214]="borderInlineColor",e[e.fontFamily=301]="fontFamily",e[e.fontStyle=302]="fontStyle",e[e.fontSize=303]="fontSize",e[e.fontUnderlineStyle=304]="fontUnderlineStyle",e[e.fontColor=305]="fontColor",e[e.fontDirection=306]="fontDirection",e[e.fontStrikethrough=307]="fontStrikethrough",e[e.fontSuperscript=308]="fontSuperscript",e[e.fontSubscript=309]="fontSubscript",e[e.fontNormal=310]="fontNormal",e[e.indentLeft=401]="indentLeft",e[e.indentRight=402]="indentRight",e[e.numberFormat=501]="numberFormat",e[e.width=701]="width",e[e.height=702]="height",e[e.wrapping=703]="wrapping"}(e.CellFormatProperties||(e.CellFormatProperties={})),function(e){e[e.none=0]="none",e[e.thin=1]="thin",e[e.medium=2]="medium",e[e.dashed=3]="dashed",e[e.dotted=4]="dotted",e[e.thick=5]="thick",e[e.double=6]="double",e[e.hair=7]="hair",e[e.mediumDashed=8]="mediumDashed",e[e.dashDot=9]="dashDot",e[e.mediumDashDot=10]="mediumDashDot",e[e.dashDotDot=11]="dashDotDot",e[e.mediumDashDotDot=12]="mediumDashDotDot",e[e.slantDashDot=13]="slantDashDot"}(e.BorderStyleType||(e.BorderStyleType={})),function(e){e[e.none=0]="none",e[e.black=1]="black",e[e.blue=2]="blue",e[e.gray=3]="gray",e[e.green=4]="green",e[e.orange=5]="orange",e[e.pink=6]="pink",e[e.purple=7]="purple",e[e.red=8]="red",e[e.teal=9]="teal",e[e.turquoise=10]="turquoise",e[e.violet=11]="violet",e[e.white=12]="white",e[e.yellow=13]="yellow",e[e.automatic=14]="automatic"}(e.ColorType||(e.ColorType={})),function(e){e[e.general=0]="general",e[e.left=1]="left",e[e.center=2]="center",e[e.right=3]="right",e[e.fill=4]="fill",e[e.justify=5]="justify",e[e.centerAcrossSelection=6]="centerAcrossSelection",e[e.distributed=7]="distributed"}(e.AlignHorizontalType||(e.AlignHorizontalType={})),function(e){e[e.top=0]="top",e[e.center=1]="center",e[e.bottom=2]="bottom",e[e.justify=3]="justify",e[e.distributed=4]="distributed"}(e.AlignVerticalType||(e.AlignVerticalType={})),function(e){e[e.regular=0]="regular",e[e.italic=1]="italic",e[e.bold=2]="bold",e[e.boldItalic=3]="boldItalic"}(e.FontStyleType||(e.FontStyleType={})),function(e){e[e.none=0]="none",e[e.single=1]="single",e[e.double=2]="double",e[e.singleAccounting=3]="singleAccounting",e[e.doubleAccounting=4]="doubleAccounting"}(e.FontUnderlineStyleType||(e.FontUnderlineStyleType={})),function(e){e[e.context=0]="context",e[e.leftToRight=1]="leftToRight",e[e.rightToLeft=2]="rightToLeft"}(e.FontDirectionType||(e.FontDirectionType={})),function(e){e[e.autoFit=-1]="autoFit"}(e.WidthType||(e.WidthType={})),function(e){e[e.autoFit=-1]="autoFit"}(e.HeightType||(e.HeightType={}))}(t=e.Marshaling||(e.Marshaling={})),function(n){var r,o;!function(e){e[e.headerRow=0]="headerRow",e[e.bandedRows=1]="bandedRows",e[e.firstColumn=2]="firstColumn",e[e.lastColumn=3]="lastColumn",e[e.bandedColumns=4]="bandedColumns",e[e.filterButton=5]="filterButton",e[e.style=6]="style",e[e.totalRow=7]="totalRow"}(r||(r={})),function(e){e[e.row=0]="row",e[e.column=1]="column"}(o||(o={}));var i={alignHorizontal:{text:"alignHorizontal",type:1},alignVertical:{text:"alignVertical",type:2},backgroundColor:{text:"backgroundColor",type:101},borderStyle:{text:"borderStyle",type:201},borderColor:{text:"borderColor",type:202},borderTopStyle:{text:"borderTopStyle",type:203},borderTopColor:{text:"borderTopColor",type:204},borderBottomStyle:{text:"borderBottomStyle",type:205},borderBottomColor:{text:"borderBottomColor",type:206},borderLeftStyle:{text:"borderLeftStyle",type:207},borderLeftColor:{text:"borderLeftColor",type:208},borderRightStyle:{text:"borderRightStyle",type:209},borderRightColor:{text:"borderRightColor",type:210},borderOutlineStyle:{text:"borderOutlineStyle",type:211},borderOutlineColor:{text:"borderOutlineColor",type:212},borderInlineStyle:{text:"borderInlineStyle",type:213},borderInlineColor:{text:"borderInlineColor",type:214},fontFamily:{text:"fontFamily",type:301},fontStyle:{text:"fontStyle",type:302},fontSize:{text:"fontSize",type:303},fontUnderlineStyle:{text:"fontUnderlineStyle",type:304},fontColor:{text:"fontColor",type:305},fontDirection:{text:"fontDirection",type:306},fontStrikethrough:{text:"fontStrikethrough",type:307},fontSuperscript:{text:"fontSuperscript",type:308},fontSubscript:{text:"fontSubscript",type:309},fontNormal:{text:"fontNormal",type:310},indentLeft:{text:"indentLeft",type:401},indentRight:{text:"indentRight",type:402},numberFormat:{text:"numberFormat",type:501},width:{text:"width",type:701},height:{text:"height",type:702},wrapping:{text:"wrapping",type:703}},a=[{name:"none",value:0},{name:"thin",value:1},{name:"medium",value:2},{name:"dashed",value:3},{name:"dotted",value:4},{name:"thick",value:5},{name:"double",value:6},{name:"hair",value:7},{name:"medium dashed",value:8},{name:"dash dot",value:9},{name:"medium dash dot",value:10},{name:"dash dot dot",value:11},{name:"medium dash dot dot",value:12},{name:"slant dash dot",value:13}],s=[{name:"none",value:0},{name:"black",value:1},{name:"blue",value:2},{name:"gray",value:3},{name:"green",value:4},{name:"orange",value:5},{name:"pink",value:6},{name:"purple",value:7},{name:"red",value:8},{name:"teal",value:9},{name:"turquoise",value:10},{name:"violet",value:11},{name:"white",value:12},{name:"yellow",value:13},{name:"automatic",value:14}];e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.SetDataAsync,requiredArguments:[{name:e.ParameterNames.Data,types:["string","object","number","boolean"]}],supportedOptions:[{name:e.ParameterNames.CoercionType,value:{enum:Office.CoercionType,calculate:function(t){return e.DataCoercion.determineCoercionType(t[e.ParameterNames.Data])}}},{name:e.ParameterNames.Rows,value:{types:["object","string"],defaultValue:null}},{name:e.ParameterNames.Columns,value:{types:["object"],defaultValue:null}},{name:e.ParameterNames.StartRow,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.StartColumn,value:{types:["number"],defaultValue:0}},{name:e.ParameterNames.CellFormat,value:{types:["object"],defaultValue:[]}},{name:e.ParameterNames.TableOptions,value:{types:["object"],defaultValue:[]}}],checkCallArgs:function(t,n,r){var o=e.ParameterNames;if(0==t[o.StartRow]&&0==t[o.StartColumn]&&e.OUtil.isArray(t[o.CellFormat])&&0===t[o.CellFormat].length&&e.OUtil.isArray(t[o.TableOptions])&&0===t[o.TableOptions].length&&(delete t[o.StartRow],delete t[o.StartColumn],delete t[o.CellFormat],delete t[o.TableOptions]),t[o.CoercionType]!=e.DataCoercion.getCoercionDefaultForBinding(n.type)&&(t[o.StartRow]&&0!=t[o.StartRow]||t[o.StartColumn]&&0!=t[o.StartColumn]||t[o.CellFormat]||t[o.TableOptions]))throw 1002;return t},privateStateCallbacks:[{name:e.ParameterNames.Id,value:function(e){return e.id}}]})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:87,toHost:[{name:e.ParameterNames.Id,value:0}]}),e.HostParameterMap.define({type:88,toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.TableOptions,value:1}]}),e.HostParameterMap.define({type:89,toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.CellFormat,value:1}]}),e.HostParameterMap.define({type:71,toHost:[{name:e.ParameterNames.Id,value:0},{name:e.ParameterNames.CoercionType,value:1},{name:e.ParameterNames.Data,value:2},{name:"offset",value:3},{name:e.ParameterNames.CellFormat,value:4},{name:e.ParameterNames.TableOptions,value:5}]}),e.HostParameterMap.define({type:i.alignHorizontal.text,toHost:[{name:"general",value:0},{name:"left",value:1},{name:"center",value:2},{name:"right",value:3},{name:"fill",value:4},{name:"justify",value:5},{name:"center across selection",value:6},{name:"distributed",value:7}]}),e.HostParameterMap.define({type:i.alignVertical.text,toHost:[{name:"top",value:0},{name:"center",value:1},{name:"bottom",value:2},{name:"justify",value:3},{name:"distributed",value:4}]}),e.HostParameterMap.define({type:i.backgroundColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderTopStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderTopColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderBottomStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderBottomColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderLeftStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderLeftColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderRightStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderRightColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderOutlineStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderOutlineColor.text,toHost:s}),e.HostParameterMap.define({type:i.borderInlineStyle.text,toHost:a}),e.HostParameterMap.define({type:i.borderInlineColor.text,toHost:s}),e.HostParameterMap.define({type:i.fontStyle.text,toHost:[{name:"regular",value:0},{name:"italic",value:1},{name:"bold",value:2},{name:"bold italic",value:3}]}),e.HostParameterMap.define({type:i.fontUnderlineStyle.text,toHost:[{name:"none",value:0},{name:"single",value:1},{name:"double",value:2},{name:"single accounting",value:3},{name:"double accounting",value:4}]}),e.HostParameterMap.define({type:i.fontColor.text,toHost:s}),e.HostParameterMap.define({type:i.fontDirection.text,toHost:[{name:"context",value:0},{name:"left-to-right",value:1},{name:"right-to-left",value:2}]}),e.HostParameterMap.define({type:i.width.text,toHost:[{name:"auto fit",value:-1}]}),e.HostParameterMap.define({type:i.height.text,toHost:[{name:"auto fit",value:-1}]}),e.HostParameterMap.define({type:e.ParameterNames.TableOptions,toHost:[{name:"headerRow",value:0},{name:"bandedRows",value:1},{name:"firstColumn",value:2},{name:"lastColumn",value:3},{name:"bandedColumns",value:4},{name:"filterButton",value:5},{name:"style",value:6},{name:"totalRow",value:7}]}),e.HostParameterMap.dynamicTypes[e.ParameterNames.CellFormat]={toHost:function(t){for(var n in t)t[n].format&&(t[n].format=e.HostParameterMap.doMapValues(t[n].format,"toHost"));return t},fromHost:function(e){return e}},e.HostParameterMap.setDynamicType(e.ParameterNames.CellFormat,{toHost:function(e){var t=[];for(var n in e){var r=e[n],a=[];if(void 0!==r.cells){var s,c=r.cells;if("object"==typeof r.cells)for(var l in s=[],c)void 0!==o[l]&&(s[o[l]]=c[l]);else s=c;a[0]=s}if(r.format){var u=r.format,d=[];for(var f in u)void 0!==i[f]&&d.push([i[f].type,u[f]]);a[1]=d}t[n]=a}return t},fromHost:function(e){return e}}),e.HostParameterMap.setDynamicType(e.ParameterNames.TableOptions,{toHost:function(e){var t=[];for(var n in e)void 0!==r[n]&&(t[r[n]]=e[n]);return t},fromHost:function(e){return e}})},defineWebParameterMapFunc:function(){var n=t.AlignHorizontalType,r=t.AlignVerticalType,o=t.BorderStyleType,i=t.CellProperties,a=(t.CellFormatProperties,t.ColorType),s=t.FontDirectionType,c=t.FontStyleType,l=t.FontUnderlineStyleType,u=t.HeightType,d=t.FormatKeys,f=t.TableOptionProperties,p=t.WidthType,g={alignHorizontal:{text:"alignHorizontal",type:t.CellFormatProperties.alignHorizontal},alignVertical:{text:"alignVertical",type:t.CellFormatProperties.alignVertical},backgroundColor:{text:"backgroundColor",type:t.CellFormatProperties.backgroundColor},borderStyle:{text:"borderStyle",type:t.CellFormatProperties.borderStyle},borderColor:{text:"borderColor",type:t.CellFormatProperties.borderColor},borderTopStyle:{text:"borderTopStyle",type:t.CellFormatProperties.borderTopStyle},borderTopColor:{text:"borderTopColor",type:t.CellFormatProperties.borderTopColor},borderBottomStyle:{text:"borderBottomStyle",type:t.CellFormatProperties.borderBottomStyle},borderBottomColor:{text:"borderBottomColor",type:t.CellFormatProperties.borderBottomColor},borderLeftStyle:{text:"borderLeftStyle",type:t.CellFormatProperties.borderLeftStyle},borderLeftColor:{text:"borderLeftColor",type:t.CellFormatProperties.borderLeftColor},borderRightStyle:{text:"borderRightStyle",type:t.CellFormatProperties.borderRightStyle},borderRightColor:{text:"borderRightColor",type:t.CellFormatProperties.borderRightColor},borderOutlineStyle:{text:"borderOutlineStyle",type:t.CellFormatProperties.borderOutlineStyle},borderOutlineColor:{text:"borderOutlineColor",type:t.CellFormatProperties.borderOutlineColor},borderInlineStyle:{text:"borderInlineStyle",type:t.CellFormatProperties.borderInlineStyle},borderInlineColor:{text:"borderInlineColor",type:t.CellFormatProperties.borderInlineColor},fontFamily:{text:"fontFamily",type:t.CellFormatProperties.fontFamily},fontStyle:{text:"fontStyle",type:t.CellFormatProperties.fontStyle},fontSize:{text:"fontSize",type:t.CellFormatProperties.fontSize},fontUnderlineStyle:{text:"fontUnderlineStyle",type:t.CellFormatProperties.fontUnderlineStyle},fontColor:{text:"fontColor",type:t.CellFormatProperties.fontColor},fontDirection:{text:"fontDirection",type:t.CellFormatProperties.fontDirection},fontStrikethrough:{text:"fontStrikethrough",type:t.CellFormatProperties.fontStrikethrough},fontSuperscript:{text:"fontSuperscript",type:t.CellFormatProperties.fontSuperscript},fontSubscript:{text:"fontSubscript",type:t.CellFormatProperties.fontSubscript},fontNormal:{text:"fontNormal",type:t.CellFormatProperties.fontNormal},indentLeft:{text:"indentLeft",type:t.CellFormatProperties.indentLeft},indentRight:{text:"indentRight",type:t.CellFormatProperties.indentRight},numberFormat:{text:"numberFormat",type:t.CellFormatProperties.numberFormat},width:{text:"width",type:t.CellFormatProperties.width},height:{text:"height",type:t.CellFormatProperties.height},wrapping:{text:"wrapping",type:t.CellFormatProperties.wrapping}},h=[{name:"none",value:o.none},{name:"thin",value:o.thin},{name:"medium",value:o.medium},{name:"dashed",value:o.dashed},{name:"dotted",value:o.dotted},{name:"thick",value:o.thick},{name:"double",value:o.double},{name:"hair",value:o.hair},{name:"medium dashed",value:o.mediumDashed},{name:"dash dot",value:o.dashDot},{name:"medium dash dot",value:o.mediumDashDot},{name:"dash dot dot",value:o.dashDotDot},{name:"medium dash dot dot",value:o.mediumDashDotDot},{name:"slant dash dot",value:o.slantDashDot}],m=[{name:"none",value:a.none},{name:"black",value:a.black},{name:"blue",value:a.blue},{name:"gray",value:a.gray},{name:"green",value:a.green},{name:"orange",value:a.orange},{name:"pink",value:a.pink},{name:"purple",value:a.purple},{name:"red",value:a.red},{name:"teal",value:a.teal},{name:"turquoise",value:a.turquoise},{name:"violet",value:a.violet},{name:"white",value:a.white},{name:"yellow",value:a.yellow},{name:"automatic",value:a.automatic}];e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.ClearFormats,toHost:[{name:e.ParameterNames.Id,value:t.FormatKeys.Id}]}),e.HostParameterMap.define({type:87,toHost:[{name:e.WACDelegate.UniqueArguments.ClearFormats,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.SetFormats,toHost:[{name:e.ParameterNames.Id,value:t.FormatKeys.Id},{name:e.ParameterNames.CellFormat,value:t.FormatKeys.CellFormat},{name:e.ParameterNames.TableOptions,value:t.FormatKeys.TableOptions}]}),e.HostParameterMap.define({type:88,toHost:[{name:e.WACDelegate.UniqueArguments.SetFormats,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:89,toHost:[{name:e.WACDelegate.UniqueArguments.SetFormats,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.WACDelegate.UniqueArguments.SetData,toHost:[{name:e.ParameterNames.Id,value:d.Id},{name:e.ParameterNames.CoercionType,value:"CoerceType"},{name:e.ParameterNames.Data,value:e.WACDelegate.UniqueArguments.Data},{name:e.ParameterNames.Rows,value:"Rows"},{name:e.ParameterNames.Columns,value:"Columns"},{name:e.ParameterNames.StartRow,value:"StartRow"},{name:e.ParameterNames.StartColumn,value:"StartCol"},{name:e.ParameterNames.CellFormat,value:d.CellFormat},{name:e.ParameterNames.TableOptions,value:d.TableOptions}]}),e.HostParameterMap.define({type:71,toHost:[{name:e.WACDelegate.UniqueArguments.SetData,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:g.alignHorizontal.text,toHost:[{name:"general",value:n.general},{name:"left",value:n.left},{name:"center",value:n.center},{name:"right",value:n.right},{name:"fill",value:n.fill},{name:"justify",value:n.justify},{name:"center across selection",value:n.centerAcrossSelection},{name:"distributed",value:n.distributed}]}),e.HostParameterMap.define({type:g.alignVertical.text,toHost:[{name:"top",value:r.top},{name:"center",value:r.center},{name:"bottom",value:r.bottom},{name:"justify",value:r.justify},{name:"distributed",value:r.distributed}]}),e.HostParameterMap.define({type:g.backgroundColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderTopStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderTopColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderBottomStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderBottomColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderLeftStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderLeftColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderRightStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderRightColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderOutlineStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderOutlineColor.text,toHost:m}),e.HostParameterMap.define({type:g.borderInlineStyle.text,toHost:h}),e.HostParameterMap.define({type:g.borderInlineColor.text,toHost:m}),e.HostParameterMap.define({type:g.fontStyle.text,toHost:[{name:"regular",value:c.regular},{name:"italic",value:c.italic},{name:"bold",value:c.bold},{name:"bold italic",value:c.boldItalic}]}),e.HostParameterMap.define({type:g.fontUnderlineStyle.text,toHost:[{name:"none",value:l.none},{name:"single",value:l.single},{name:"double",value:l.double},{name:"single accounting",value:l.singleAccounting},{name:"double accounting",value:l.doubleAccounting}]}),e.HostParameterMap.define({type:g.fontColor.text,toHost:m}),e.HostParameterMap.define({type:g.fontDirection.text,toHost:[{name:"context",value:s.context},{name:"left-to-right",value:s.leftToRight},{name:"right-to-left",value:s.rightToLeft}]}),e.HostParameterMap.define({type:g.width.text,toHost:[{name:"auto fit",value:p.autoFit}]}),e.HostParameterMap.define({type:g.height.text,toHost:[{name:"auto fit",value:u.autoFit}]}),e.HostParameterMap.define({type:e.ParameterNames.TableOptions,toHost:[{name:"headerRow",value:f.headerRow},{name:"bandedRows",value:f.bandedRows},{name:"firstColumn",value:f.firstColumn},{name:"lastColumn",value:f.lastColumn},{name:"bandedColumns",value:f.bandedColumns},{name:"filterButton",value:f.filterButton},{name:"style",value:f.style},{name:"totalRow",value:f.totalRow}]}),e.HostParameterMap.dynamicTypes[e.ParameterNames.CellFormat]={toHost:function(t){for(var n in t)t[n].format&&(t[n].format=e.HostParameterMap.doMapValues(t[n].format,"toHost"));return t},fromHost:function(e){return e}},e.HostParameterMap.setDynamicType(e.ParameterNames.CellFormat,{toHost:function(e){var t=[];for(var n in e){var r=e[n],o=[];if(void 0!==r.cells){var a,s=r.cells;if("object"==typeof r.cells)for(var c in a=[],s)void 0!==i[c]&&(a[i[c]]=s[c]);else a=s;o[0]=a}if(r.format){var l=r.format,u=[];for(var d in l)void 0!==g[d]&&u.push([g[d].type,l[d]]);o[1]=u}t[n]=o}return t},fromHost:function(e){return e}}),e.HostParameterMap.setDynamicType(e.ParameterNames.TableOptions,{toHost:function(e){var t=[];for(var n in e)void 0!==f[n]&&(t[f[n]]=e[n]);return t},fromHost:function(e){return e}}),n=null,r=null,o=null,null,a=null,s=null,c=null,l=null,u=null,d=null,p=null}})}(e.Formats||(e.Formats={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){function n(t){var n=0;switch(t){case e.CoercionType.Text:n=0;break;case e.CoercionType.Matrix:n=1;break;case e.CoercionType.Table:n=2;break;case e.CoercionType.Html:n=3;break;case e.CoercionType.Ooxml:n=4;break;case e.CoercionType.OoxmlPackage:n=5;break;case e.CoercionType.PdfFile:n=6;break;case e.CoercionType.SlideRange:n=7;break;case"image":n=8;break;case"xmlSvg":n=9}return n}function r(t){var n=0;switch(t){case e.ValueFormat.Unformatted:n=0;break;case e.ValueFormat.Formatted:n=1}return n}function o(t){var n=0;switch(t){case e.FilterType.All:n=0;break;case e.FilterType.OnlyVisible:n=1}return n}t.setSelectedDataAsync=function(t,r,o){var i=null==r.coercionType?OSF.DataCoercion.determineCoercionType(t):r.coercionType;"function"==typeof r&&(o=r);var a={toSafeArrayHost:function(){var o=OSF._OfficeAppFactory.getHostInfo();return o.hostType.toLowerCase()==e.HostType.Word.toLowerCase()||o.hostType.toLowerCase()==e.HostType.PowerPoint.toLowerCase()||o.hostType.toLowerCase()==e.HostType.OneNote.toLowerCase()||o.hostType.toLowerCase()==e.HostType.Visio.toLowerCase()||"image"==i||"xmlSvg"==i?[n(i),OSF.DataCoercion.serializeDynamicData(t),null!=r.imageLeft&&r.imageLeft,null!=r.imageTop&&r.imageTop,null!=r.imageWidth&&r.imageWidth,null!=r.imageHeight&&r.imageHeight]:o.hostType.toLowerCase()==e.HostType.Excel.toLowerCase()?[n(i),OSF.DataCoercion.serializeDynamicData(t),null==r.cellFormat?[]:r.cellFormat,null==r.tableOptions?[]:r.tableOptions,null!=r.imageWidth&&r.imageWidth,null!=r.imageHeight&&r.imageHeight]:[n(i),OSF.DataCoercion.serializeDynamicData(t),null==r.cellFormat?[]:r.cellFormat,null==r.tableOptions?[]:r.tableOptions]},fromSafeArrayHost:function(e){return e},toWebHost:function(){return{DdaSetBindingData:{CoerceType:i,Data:OSF.DataCoercion.serializeDynamicData(t),CellFormat:[],TableOptions:[]}}},fromWebHost:function(e){return e}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(65,a,o,null)},t.getSelectedDataAsync=function(t,i,a){var s,c=e.ValueFormat.Unformatted,l=e.FilterType.All;"function"==typeof i?a=i:void 0!==i&&(void 0!==i.valueFormat&&(c=i.valueFormat),void 0!==i.filterType&&(l=i.filterType),void 0!==i.asyncContext&&(s=i.asyncContext));var u={toSafeArrayHost:function(){return[n(t),r(c),o(l)]},fromSafeArrayHost:function(e){return OSF.DataCoercion.deserializeDynamicData(e,t)},toWebHost:function(){return{DdaGetBindingData:{CoerceType:t,ValueFormat:c,FilterType:l}}},fromWebHost:function(e){return OSF.DataCoercion.deserializeDynamicData(e.Data,t)}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(64,u,a,s)}}(t.document||(t.document={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){var t=function(){function e(e,t){this._rows=e,this._header=t}return Object.defineProperty(e.prototype,"headers",{get:function(){return this._header},set:function(e){this._header=this.fixData(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"rows",{get:function(){return this._rows},set:function(e){this._rows=null==e||OSF.OUtil.isArray(e)&&0==e.length?[]:this.fixData(e)},enumerable:!0,configurable:!0}),e.prototype.fixData=function(e){if(null==e||null==e)return null;try{for(var t=OSF.DataCoercion.findArrayDimensionality(e);t<2;t++)e=[e];return e}catch(e){}},e}();e.TableData=t,e.manufactureTableData=function(t){return new e.TableData(t[OSF.TableDataProperties.TableRows],t[OSF.TableDataProperties.TableHeaders])}}(Office||(Office={})),function(e){!function(t){!function(t){!function(e){e.OfficeThemeChangedEvent="OfficeThemeChangedEvent",e.DocumentThemeChangedEvent="DocumentThemeChangedEvent"}(t.EventDescriptors||(t.EventDescriptors={})),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.GetDocumentThemeAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[],onSucceeded:e.DDA.Theming.ConvertToDocumentTheme}),e.AsyncMethodCalls.define({method:e.AsyncMethods.GetOfficeThemeAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[],onSucceeded:e.DDA.Theming.ConvertToOfficeTheme})},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:85,fromHost:[{name:e.ParameterNames.OfficeTheme,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.ParameterNames.OfficeTheme,fromHost:[{name:e.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,value:0},{name:e.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,value:1},{name:e.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,value:2},{name:e.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,value:3},{name:e.DDA.Theming.OfficeThemeEnum.ThemeId,value:4}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidOfficeThemeChangedEvent,fromHost:[{name:e.DDA.Theming.EventDescriptors.OfficeThemeChangedEvent,value:e.HostParameterMap.self}],isComplexType:!0}),e.HostParameterMap.define({type:e.DDA.Theming.EventDescriptors.OfficeThemeChangedEvent,fromHost:[{name:e.ParameterNames.OfficeTheme,value:e.HostParameterMap.self}],isComplexType:!0})},defineWebParameterMapFunc:function(){e.HostParameterMap.addComplexType(e.ParameterNames.DocumentTheme),e.HostParameterMap.addComplexType(e.ParameterNames.OfficeTheme),e.HostParameterMap.define({type:e.EventDispId.dispidOfficeThemeChangedEvent,fromHost:[{name:e.ParameterNames.OfficeTheme,value:e.HostParameterMap.self}]}),e.HostParameterMap.define({type:e.ParameterNames.OfficeTheme,fromHost:[{name:e.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,value:e.DDA.Theming.OfficeThemeEnumWac.PrimaryFontColor},{name:e.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,value:e.DDA.Theming.OfficeThemeEnumWac.PrimaryBackgroundColor},{name:e.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,value:e.DDA.Theming.OfficeThemeEnumWac.SecondaryFontColor},{name:e.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,value:e.DDA.Theming.OfficeThemeEnumWac.SecondaryBackgroundColor}],isComplexType:!0})},initializeFunc:function(){var n=e._OfficeAppFactory.getHostInfo(),r=n.hostType.toLowerCase();if(n.hostPlatform==e.HostInfoPlatform.web&&(r==Office.HostType.Word.toLowerCase()||r==Office.HostType.PowerPoint.toLowerCase())&&Office.context.officeTheme){var o=t.GetIsDarkThemeFromCSSHexColor(Office.context.officeTheme.bodyBackgroundColor);Office.context.officeTheme[e.DDA.Theming.OfficeThemeEnum.IsDarkTheme]=o,Office.context.officeTheme[e.DDA.Theming.OfficeThemeEnum.ThemeId]=o?e.DDA.Theming.ThemeId.Black:e.DDA.Theming.ThemeId.White}Office.context&&Office.context.themeManager&&Office.context.themeManager.InitializeAndChangeOnce()}});var n=function(){function n(){this._eventTarget=null,this._previousDocumentThemeData=null,this._previousOfficeThemeData=null,this._officeCss=null,this._asyncCallsCompleted=null,this._onAsyncCallsCompleted=null}return n.prototype.InitializeThemeManager=function(){this._eventTarget=this,e.DispIdHost.addAsyncMethods(this,[e.AsyncMethods.GetOfficeThemeAsync,e.AsyncMethods.GetDocumentThemeAsync]),e.DispIdHost.addEventSupport(this,new e.EventDispatch([Microsoft.Office.WebExtension.EventType.OfficeThemeChanged,Microsoft.Office.WebExtension.EventType.DocumentThemeChanged]))},n.prototype.InitializeAndChangeOnce=function(t){var n=this;this._officeCss=this._getOfficeThemesCss(),this._officeCss?(this._onAsyncCallsCompleted=t,this._asyncCallsCompleted={},this._asyncCallsCompleted[e.AsyncMethods.GetOfficeThemeAsync]=!1,this._asyncCallsCompleted[e.AsyncMethods.GetDocumentThemeAsync]=!1,this._getAndProcessThemeData(this._eventTarget.getOfficeThemeAsync,(function(e){n._processOfficeThemeData(e)}),e.AsyncMethods.GetOfficeThemeAsync)):t&&t()},n.prototype.isDarkTheme=function(){var e=!1;if(Office.context&&Office.context.officeTheme&&Office.context.officeTheme.bodyBackgroundColor){var n=Office.context.officeTheme.bodyBackgroundColor;e=t.GetIsDarkThemeFromCSSHexColor(n)}return e},n.prototype._getOfficeThemesCss=function(){try{return function(){for(var t="officethemes.css",n=0;n<document.styleSheets.length;n++){var r=document.styleSheets[n];if(!r.disabled&&r.href&&t==r.href.substring(r.href.length-t.length,r.href.length).toLowerCase())return r.cssRules||r.rules?r:(e.AppTelemetry&&e.AppTelemetry.logAppException("Browser styleSheet object does not implement cssRules or rules property. Viloates browser's css access rule"),null)}}()}catch(t){return e.AppTelemetry&&e.AppTelemetry.logAppException("Exception thrown when trying to read officethems.css:["+t+"]"),null}},n.prototype._changeCss=function(e,t,n){for(var r=e.cssRules?e.cssRules.length:e.rules.length,o=0;o<r;o++){var i=(e.cssRules?e.cssRules[o]:e.rules[o]).selectorText;i&&i.toLowerCase()==t.toLowerCase()&&(e.cssRules?(e.deleteRule(o),e.insertRule(i+n,o)):(e.removeRule(o),e.addRule(i,n,o)))}},n.prototype._changeDocumentThemeData=function(t){for(var n=[{name:e.DDA.Theming.DocumentThemeEnum.PrimaryFontColor,cssSelector:".office-docTheme-primary-fontColor",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.PrimaryBackgroundColor,cssSelector:".office-docTheme-primary-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.SecondaryFontColor,cssSelector:".office-docTheme-secondary-fontColor",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.SecondaryBackgroundColor,cssSelector:".office-docTheme-secondary-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-color",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-borderColor",cssProperty:"border-color"},{name:e.DDA.Theming.DocumentThemeEnum.Hyperlink,cssSelector:".office-a",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.FollowedHyperlink,cssSelector:".office-a:visited",cssProperty:"color"},{name:e.DDA.Theming.DocumentThemeEnum.HeaderLatinFont,cssSelector:".office-headerFont-latin",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.HeaderEastAsianFont,cssSelector:".office-headerFont-eastAsian",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.HeaderScriptFont,cssSelector:".office-headerFont-script",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.HeaderLocalizedFont,cssSelector:".office-headerFont-localized",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.BodyLatinFont,cssSelector:".office-bodyFont-latin",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.BodyEastAsianFont,cssSelector:".office-bodyFont-eastAsian",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.BodyScriptFont,cssSelector:".office-bodyFont-script",cssProperty:"font-family"},{name:e.DDA.Theming.DocumentThemeEnum.BodyLocalizedFont,cssSelector:".office-bodyFont-localized",cssProperty:"font-family"}],r=t.type==e.EventType.DocumentThemeChanged?t.documentTheme:t,o=0;o<n.length;o++)if(null===this._previousDocumentThemeData||this._previousDocumentThemeData[n[o].name]!=r[n[o].name])if(null!=r[n[o].name]&&""!=r[n[o].name]){var i=r[n[o].name];"font-family"===n[o].cssProperty&&(i='"'+i.replace(new RegExp('"',"g"),'\\"')+'"'),this._changeCss(this._officeCss,n[o].cssSelector,"{"+n[o].cssProperty+":"+i+";}")}else this._changeCss(this._officeCss,n[o].cssSelector,"{}");this._previousDocumentThemeData=r},n.prototype._changeOfficeThemeData=function(t){for(var n=[{name:e.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,cssSelector:".office-officeTheme-primary-fontColor",cssProperty:"color"},{name:e.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,cssSelector:".office-officeTheme-primary-bgColor",cssProperty:"background-color"},{name:e.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,cssSelector:".office-officeTheme-secondary-fontColor",cssProperty:"color"},{name:e.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,cssSelector:".office-officeTheme-secondary-bgColor",cssProperty:"background-color"}],r=t.type==e.EventType.OfficeThemeChanged?t.officeTheme:t,o=0;o<n.length;o++)null!==this._previousOfficeThemeData&&this._previousOfficeThemeData[n[o].name]==r[n[o].name]||void 0!==r[n[o].name]&&this._changeCss(this._officeCss,n[o].cssSelector,"{"+n[o].cssProperty+":"+r[n[o].name]+";}");this._previousOfficeThemeData=r},n.prototype._getAndProcessThemeData=function(t,n,r){var o=this,i=e._OfficeAppFactory.getHostInfo();if(i&&i.hostPlatform==e.HostInfoPlatform.web){if(r==e.AsyncMethods.GetOfficeThemeAsync&&Office.context.officeTheme){var a={};a[e.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor]=Office.context.officeTheme.bodyBackgroundColor,a[e.DDA.Theming.OfficeThemeEnum.BodyForegroundColor]=Office.context.officeTheme.bodyForegroundColor,a[e.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor]=Office.context.officeTheme.controlBackgroundColor,a[e.DDA.Theming.OfficeThemeEnum.ControlForegroundColor]=Office.context.officeTheme.controlForegroundColor,a[e.DDA.Theming.OfficeThemeEnum.IsDarkTheme]=Office.context.officeTheme.isDarkTheme,a[e.DDA.Theming.OfficeThemeEnum.ThemeId]=Office.context.officeTheme.isDarkTheme?e.DDA.Theming.ThemeId.Black:e.DDA.Theming.ThemeId.White,n(a)}}else t((function(e){if("succeeded"==e.status){var t=e.value;n(t)}o._areAllCallsCompleted(r)&&o._onAsyncCallsCompleted&&(o._onAsyncCallsCompleted(),o._onAsyncCallsCompleted=null)}))},n.prototype._processOfficeThemeData=function(e){var t=this;this._changeOfficeThemeData(e),this._eventTarget.addHandlerAsync(Microsoft.Office.WebExtension.EventType.OfficeThemeChanged,(function(e){t._changeOfficeThemeData(e)}),null)},n.prototype._processDocumentThemeData=function(e){var t=this;this._changeDocumentThemeData(e),this._eventTarget.addHandlerAsync(Microsoft.Office.WebExtension.EventType.DocumentThemeChanged,(function(e){t._changeDocumentThemeData(e)}),null)},n.prototype._areAllCallsCompleted=function(e){var t;if(!(t=this._asyncCallsCompleted))return!0;for(var n in e&&t.hasOwnProperty(e)&&(t[e]=!0),t)if(!t.hasOwnProperty(n)||!t[n])return!1;return!0},n}();t.InternalThemeHandler=n}(t.Theming||(t.Theming={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){!function(e){var t;OSF.definePropertyOnNamespace(e,"themeManager",(function(){return t||(t=new OSF.DDA.Theming.InternalThemeHandler).InitializeThemeManager(),t}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){e.BootStrapExtension.prepareApiSurface=function(){return new Promise((function(){e.V10ApiFeatureRegistry.initialize()}))}}(OSF||(OSF={})),function(e){!function(e){function t(){try{if(void 0!==OSF&&void 0!==OSF.isOfficeReactNative&&OSF.isOfficeReactNative())return!0}catch(e){}return!1}function n(){var e="web";try{void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo&&(e=OSF._OfficeAppFactory.getHostInfo().hostPlatform)}catch(e){}return e}e.isNativeStorage=function(){var e=n();return!(function(){try{if(void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo&&OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp)return!0}catch(e){}return!1}()||!(t()||"win32"===e||"mac"===e&&window._useSDXSandbox))},e.isNativeApiInfomation=function(){var e=n();return!!(t()||"win32"===e||"mac"===e&&window._useSDXSandbox)},e.isNativeDialog=function(){var e=n();return!(!t()&&"win32"!==e)}}(e.ApiHelper||(e.ApiHelper={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){e.ApiHelper.isNativeApiInfomation()?e.apiInformation=t:e.apiInformation=n;var t={isSetSupported:function(e,t){if("string"!=typeof e)return!1;if(null==t&&(t="0.0.0"),void 0===global.__apiSets)return!1;var n=global.__apiSets,o=Object.keys(n).map((function(e){return e.toLowerCase()})).indexOf(e.toLowerCase());if(o>-1){var i=n[Object.keys(n)[o]];try{var a=r(t),s=void 0;if((s=Array.isArray(i)?function(e,t){for(var n=0;n<e.length;n++){var o=r(e[n]);if(o.major==t)return o}return{major:0,minor:0,patch:0}}(i,a.major):r(i)).major>0){if(s.major>a.major)return!0;if(s.major==a.major&&s.minor>a.minor)return!0;if(s.major==a.major&&s.minor==a.minor&&s.patch>=a.patch)return!0}}catch(e){return!1}}return!1}},n={isSetSupported:function(e,t){try{return!!(Office&&Office.context&&Office.context.requirements)&&Office.context.requirements.isSetSupported(e,Number(t))}catch(e){return!1}}};function r(e){var t=e.split("."),n=0,r=0,o=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),t.length>=2&&(r=Number(t[1])),t.length>=3&&(o=Number(t[2])),isNaN(n)||isNaN(r)||isNaN(o))throw"version format incorrect";return{major:n,minor:r,patch:o}}}(OfficeRuntime||(OfficeRuntime={}));var OfficeRuntime;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),o=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),i=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,function(e){this._dialogService=e});e.Dialog=s;var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.close=function(){return this._dialogService.close(),OfficeExtension.CoreUtility.Promise.resolve()},t}(s),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},t}(s);function u(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}function d(e){var t,n=((t={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},t[12003]={code:"InvalidUrl",message:"HTTPS is required."},t[12004]={code:"Untrusted",message:"Domain is not trusted."},t[12005]={code:"InvalidUrl",message:"HTTPS is required."},t[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},t);return n[e]?n[e]:{code:"Unknown",message:"An unknown error has occured with code: "+e}}e.displayWebDialog=function(t,n){return void 0===n&&(n={}),new OfficeExtension.CoreUtility.Promise((function(r,o){if(n.width&&n.height&&(!u(n.width)||!u(n.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var i={width:n.width?parseInt(n.width):50,height:n.height?parseInt(n.height):50,displayInIFrame:n.displayInIFrame};e.ApiHelper.isNativeDialog()?function(e,t,n,r,o){void 0===o&&(o={});var i=new OfficeExtension.ClientRequestContext,a=p.newObject(i),s=new l(a),c=a.onDialogMessage.add((function(e){switch(OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e)),e.type){case 17:e.error?n(e.error):t(s);break;case 12:o.onMessage&&o.onMessage(e.message,s);break;case 10:default:12006===e.originalErrorCode?(c&&(c.remove(),i.sync()),o.onClose&&o.onClose()):o.onRuntimeError&&(o.onRuntimeError(e.error,s),n(e.error))}return OfficeExtension.CoreUtility.Promise.resolve()}));i.sync().then((function(){return a.displayDialog(r,e),i.sync()})).catch((function(e){n(e)}))}(i,r,o,t,n):function(e,t,n,r,o){void 0===o&&(o={});var i;function a(e){"failed"===e.status?n(new OfficeExtension.Error(d(e.error.code))):((i=e.value).addEventHandler(Office.EventType.DialogMessageReceived,s),i.addEventHandler(Office.EventType.DialogEventReceived,l),t(new c(i)))}function s(e){o.onMessage&&o.onMessage(e.message,i,e.origin)}function l(e){12006===e.error?o.onClose&&o.onClose():o.onRuntimeError&&o.onRuntimeError(new OfficeExtension.Error(d(e.error)),i)}Office.context.ui.displayDialogAsync(r,e,a)}(i,r,o,t,n)}))};var f,p=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"DialogService"},enumerable:!0,configurable:!0}),c.prototype.close=function(){n(this,"Close",1,[],4,0)},c.prototype.displayDialog=function(e,t){n(this,"DisplayDialog",1,[e,t],4,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||i(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.DialogService,n,"Microsoft.Dialog.DialogService",!1,4)},Object.defineProperty(c.prototype,"onDialogMessage",{get:function(){return this.m_dialogMessage||(this.m_dialogMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"DialogMessage",{eventType:65536,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t;try{var n=JSON.parse(e.message),r=n.errorCode?new OfficeExtension.Error(d(n.errorCode)):null;t={originalErrorCode:n.errorCode,type:n.type,error:r,message:n.message,origin:n.origin}}catch(e){t={originalErrorCode:null,type:17,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"}),message:e.message}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_dialogMessage},enumerable:!0,configurable:!0}),c.prototype.toJSON=function(){return o(this,{},{})},c}(OfficeExtension.ClientObject);e.DialogService=p,function(e){e[e.dialogMessageReceived=0]="dialogMessageReceived",e[e.dialogEventReceived=1]="dialogEventReceived"}(f||(f={})),function(e){e.generalException="GeneralException"}(e.DialogErrorCodes||(e.DialogErrorCodes={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){!function(e){function t(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:"true"===n.toString().toLowerCase()}catch(e){return t}}function n(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates,r=parseInt(n[e]);return isNaN(r)?t:r}catch(e){return t}}function r(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:n}catch(e){return t}}e.getBooleanFeatureGate=t,e.getIntFeatureGate=n,e.getStringFeatureGate=r,e.getBooleanFeatureGateAsync=function(e,n){return Promise.resolve(t(e,n))},e.getIntFeatureGateAsync=function(e,t){return Promise.resolve(n(e,t))},e.getStringFeatureGateAsync=function(e,t){return Promise.resolve(r(e,t))}}(e.experimentation||(e.experimentation={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){!function(e){var n={};function r(e){var t=e.eventName,r=e.message;n.hasOwnProperty(t)&&n[t].call(r)}e.on=function(e,o){return function(e,o){n.hasOwnProperty(e)||(n[e]=new t,function(){Office&&Office.context&&Office.context.messaging&&!Office.context.messaging.onMessage&&(Office.context.messaging.onMessage=r.bind(this))}());n[e].add(o)}(e,o),new Promise((function(e){e()}))},e.off=function(e,t){return function(e,t){n.hasOwnProperty(e)&&(t?n[e].remove(t):delete n[e])}(e,t),new Promise((function(e){e()}))},e.emit=function(e,t){return function(e,t){var n={eventName:e,message:t};Office&&Office.context&&Office.context.messaging&&Office.context.messaging.sendMessage&&Office.context.messaging.sendMessage(n)}(e,t),new Promise((function(e){e()}))}}(e.message||(e.message={}));var t=function(){function e(){this.listeners=[]}return e.prototype.add=function(e){this.listeners.push(e)},e.prototype.remove=function(e){var t=this.listeners.lastIndexOf(e);-1!==t&&this.listeners.splice(t,1)},e.prototype.call=function(e){this.listeners.forEach((function(t){return t(e)}))},e}();e.ListenerManager=t}(OfficeRuntime||(OfficeRuntime={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),o=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),i=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,"_Office_AsyncStorage_"),c=s+"|_unusedKey_",l={getItem:function(e){return p((function(t,n){return t.multiGet(n,JSON.stringify([e]))}),(function(e){var t=JSON.parse(e);return t&&t[0]&&t[0][1]?t[0][1]:null}))},setItem:function(e,t){return p((function(n,r){return n.multiSet(r,JSON.stringify([[e,t]]))}),(function(){return null}))},removeItem:function(e){return p((function(t,n){return t.multiRemove(n,JSON.stringify([e]))}),(function(){return null}))},getItems:function(e){return p((function(t,n){return t.multiGet(n,JSON.stringify(e))}),(function(t){var n=JSON.parse(t),r={};return n&&n.forEach((function(e){var t=e[0],n=e[1];return r[t]=n,n})),e&&e.forEach((function(e){r[e]&&r[e]})),r}))},setItems:function(e){var t=[];for(var n in e)e.hasOwnProperty(n)&&t.push([n,e[n]]);return p((function(e,n){return e.multiSet(n,JSON.stringify(t))}),(function(){return null}))},removeItems:function(e){return p((function(t,n){return t.multiRemove(n,JSON.stringify(e))}),(function(){return null}))},getKeys:function(){return p((function(e,t){return e.getAllKeys(t)}),(function(e){return JSON.parse(e)}))}},u={getItem:function(e){return m((function(){return d(e)}))},setItem:function(e,t){return h((function(){return f(e,t)}))},removeItem:function(e){return h((function(){return window.localStorage.removeItem(s+e)}))},getItems:function(e){return new Promise((function(t,n){var r={},o=[];try{g()}catch(e){n(e)}e.forEach((function(e){try{var t=d(e);r[e]=t||null}catch(e){o.push(e)}})),o.length>0?n(new Error("Unknown error.")):t(r)}))},setItems:function(e){return y(e,(function(t){return f(t,e[t])}))},removeItems:function(e){return y(e,(function(e){return window.localStorage.removeItem(s+e)}))},getKeys:function(){return m((function(){return Object.keys(window.localStorage).filter((function(e){return 0===e.indexOf(s)})).map((function(e){return e.substr(s.length)}))}))}};function d(e){return window.localStorage.getItem(s+e)}function f(e,t){window.localStorage.setItem(s+e,t)}function p(e,t){return new OfficeExtension.CoreUtility.Promise((function(n,r){var o=v.getInstance(),i=o.setCallBack((function(e,o){if(o)r(o);else{var i=t(e);n(i)}}));o.ctx.sync().then((function(){var t=o.getPersistentKvStorageService();return e(t,i),o.ctx.sync()})).catch((function(e){r(e)}))}))}function g(){f(c,null),window.localStorage.removeItem(c)}function h(e,t){return void 0===t&&(t=function(){}),new Promise((function(n,r){try{g(),e(),t(null),n()}catch(e){t(e),r(e)}}))}function m(e,t){return void 0===t&&(t=function(){}),new Promise((function(n,r){try{g();var o=e();t(null,o),n(o)}catch(e){t(e,null),r(e)}}))}function y(e,t,n){return void 0===n&&(n=function(){}),new Promise((function(r,o){var i=[];try{g()}catch(e){i.push(e)}for(var a in e)if(e.hasOwnProperty(a)||Array.isArray(e))try{Array.isArray(e)?t(e[a]):t(a)}catch(e){i.push(e)}n(i),i.length>0?o(i):r()}))}e.ApiHelper.isNativeStorage()?e.storage=l:e.storage=u;var v=function(){function e(){var e=this;this._invokeId=0,this._callDict={},this.ctx=new OfficeExtension.ClientRequestContext,this._perkvstorService=b.newObject(this.ctx),this._eventResult=this._perkvstorService.onPersistentStorageMessage.add((function(t){OfficeExtension.Utility.log("persistentKvStoragegMessageHandler:"+JSON.stringify(t));var n=e._callDict[t.invokeId];n&&(n(t.message,t.error),delete e._callDict[t.invokeId])}))}return e.getInstance=function(){return void 0===e.instance?e.instance=new e:e.instance._perkvstorService=b.newObject(e.instance.ctx),e.instance},e.prototype.getPersistentKvStorageService=function(){return this._perkvstorService},e.prototype.getCallBack=function(e){return this._callDict[e]},e.prototype.setCallBack=function(e){var t=this._invokeId;return this._callDict[this._invokeId++]=e,t},e}(),b=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"PersistentKvStorageService"},enumerable:!0,configurable:!0}),c.prototype.clear=function(e){n(this,"Clear",1,[e],4,0)},c.prototype.getAllKeys=function(e){n(this,"GetAllKeys",1,[e],4,0)},c.prototype.multiGet=function(e,t){n(this,"MultiGet",1,[e,t],4,0)},c.prototype.multiRemove=function(e,t){n(this,"MultiRemove",1,[e,t],4,0)},c.prototype.multiSet=function(e,t){n(this,"MultiSet",1,[e,t],4,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||i(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.PersistentKvStorageService,n,"Microsoft.PersistentKvStorage.PersistentKvStorageService",!1,4)},Object.defineProperty(c.prototype,"onPersistentStorageMessage",{get:function(){return this.m_persistentStorageMessage||(this.m_persistentStorageMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"PersistentStorageMessage",{eventType:65537,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t,n,r,o;try{var i=JSON.parse(e.message),a=parseInt(i.errorCode),s=0!=a?new OfficeExtension.Error((n=a,(r={})[16389]={code:"GenericException",message:"Unknown error."},r[65535]={code:"Unexcepted",message:"Catastrophic failure."},r[14]={code:"OutOfMemory",message:"Ran out of memory."},r[87]={code:"InvalidArg",message:"One or more arguments are invalid."},r[16385]={code:"NotImplemented",message:"Not implemented."},r[6]={code:"BadHandle",message:"File Handle is not Set."},r[5]={code:"AccessDenied",message:"Can't read the Storage File."},(o=r)[n]?o[n]:{code:"Unknown",message:"An unknown error has occured"})):null;t={invokeId:i.invokeId,message:i.message,error:s}}catch(e){t={invokeId:-1,message:e.message,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"})}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_persistentStorageMessage},enumerable:!0,configurable:!0}),c.prototype.toJSON=function(){return o(this,{},{})},c}(OfficeExtension.ClientObject);e.PersistentKvStorageService=b,function(e){e.generalException="GeneralException"}(e.ErrorCodes||(e.ErrorCodes={}))}(OfficeRuntime||(OfficeRuntime={}));var Excel,OSF;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}(),__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};if(function(e){function t(e,t){var r=f("OfficeOnline")?new n:new g;return m(e,r),OfficeExtension.CoreUtility.Promise.resolve().then((function(){return t(r)})).then(r.sync)}!function(e){e.BMP="BMP",e.GIF="GIF",e.ICO="ICO",e.JPG="JPG",e.PNG="PNG",e.TIF="TIF",e.WEBP="WEBP"}(e.Base64EncodingType||(e.Base64EncodingType={})),function(e){e.unknown="Unknown",e.dataTypeRestrictedDomain="DataTypeRestrictedDomain",e.dataTypePrivacySetting="DataTypePrivacySetting",e.dataTypeUnsupportedApp="DataTypeUnsupportedApp",e.externalLinksGeneric="ExternalLinksGeneric",e.richDataLinkDisabled="RichDataLinkDisabled",e.signInError="SignInError",e.noLicense="NoLicense",e.xlmDisabledInTrustCenter="XlmDisabledInTrustCenter",e.xlmNotSupportedOnPlatform="XlmNotSupportedOnPlatform",e.imageDownloadBlocked="ImageDownloadBlocked",e.imageInvalidUrlNonHttps="ImageInvalidUrlNonHttps",e.imageExceedsSizeLimit="ImageExceedsSizeLimit",e.imageExceedsTotalSizeLimit="ImageExceedsTotalSizeLimit",e.environmentExceedsQuota="EnvironmentExceedsQuota",e.environmentExceedsQuotaDaily="EnvironmentExceedsQuotaDaily",e.environmentExceedsQuotaMonthly="EnvironmentExceedsQuotaMonthly",e.environmentExceedsTakerQuotaMonthly="EnvironmentExceedsTakerQuotaMonthly",e.wrongAccountType="WrongAccountType",e.environmentExceedsComputeResourceEver="EnvironmentExceedsComputeResourceEver",e.environmentExceedsComputeResourceCountDaily="EnvironmentExceedsComputeResourceCountDaily",e.pythonUnsupportedOnThisPlatform="PythonUnsupportedOnThisPlatform",e.unmetRequirements="UnmetRequirements",e.pythonFunction="PythonFunction",e.environmentConnectionExceedQuota="EnvironmentConnectionExceedQuota",e.unsupportedEnvironment="UnsupportedEnvironment",e.unsupportedInCalculationMode="UnsupportedInCalculationMode"}(e.BlockedErrorCellValueSubType||(e.BlockedErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.externalLinksGeneric="ExternalLinksGeneric",e.loadingImage="LoadingImage",e.placeholderInFormula="PlaceholderInFormula"}(e.BusyErrorCellValueSubType||(e.BusyErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.arrayOfArrays="ArrayOfArrays",e.arrayOfRanges="ArrayOfRanges",e.emptyArray="EmptyArray",e.unsupportedLifting="UnsupportedLifting",e.dataTableReferencedPendingFormula="DataTableReferencedPendingFormula",e.tooManyCells="TooManyCells",e.lambdaInCell="LambdaInCell",e.tooDeeplyNested="TooDeeplyNested",e.textOverflow="TextOverflow",e.requestTooLarge="RequestTooLarge",e.pythonGridQuery="PythonGridQuery",e.pythonPowerQueryDataUploadEtagChanged="PythonPowerQueryDataUploadEtagChanged",e.pythonPowerQueryDataUploadSizeLimitExceeded="PythonPowerQueryDataUploadSizeLimitExceeded",e.invalidPythonObject="InvalidPythonObject",e.queryInCell="QueryInCell",e.uninitializedPythonObject="UninitializedPythonObject",e.externalQueryRef="ExternalQueryRef",e.eRegexReplaceCharLimit="ERegexReplaceCharLimit",e.unexpectedReturnValue="UnexpectedReturnValue"}(e.CalcErrorCellValueSubType||(e.CalcErrorCellValueSubType={})),function(e){e.entity="Entity",e.array="Array"}(e.EntityCardLayoutType||(e.EntityCardLayoutType={})),function(e){e.javaScriptReference="JavaScriptReference"}(e.FunctionCellValueType||(e.FunctionCellValueType={})),function(e){e.generic="Generic",e.accessibility="Accessibility",e.airplane="Airplane",e.airplaneTakeOff="AirplaneTakeOff",e.album="Album",e.alert="Alert",e.alertUrgent="AlertUrgent",e.animal="Animal",e.animalCat="AnimalCat",e.animalDog="AnimalDog",e.animalRabbit="AnimalRabbit",e.animalTurtle="AnimalTurtle",e.appFolder="AppFolder",e.appGeneric="AppGeneric",e.apple="Apple",e.approvalsApp="ApprovalsApp",e.archive="Archive",e.archiveMultiple="ArchiveMultiple",e.arrowTrendingLines="ArrowTrendingLines",e.art="Art",e.atom="Atom",e.attach="Attach",e.automobile="Automobile",e.autosum="Autosum",e.backpack="Backpack",e.badge="Badge",e.balloon="Balloon",e.bank="Bank",e.barcodeScanner="BarcodeScanner",e.basketball="Basketball",e.battery0="Battery0",e.battery10="Battery10",e.beach="Beach",e.beaker="Beaker",e.bed="Bed",e.binFull="BinFull",e.bird="Bird",e.bluetooth="Bluetooth",e.board="Board",e.boardGames="BoardGames",e.book="Book",e.bookmark="Bookmark",e.bookmarkMultiple="BookmarkMultiple",e.bot="Bot",e.bowlChopsticks="BowlChopsticks",e.box="Box",e.boxMultiple="BoxMultiple",e.brainCircuit="BrainCircuit",e.branch="Branch",e.branchFork="BranchFork",e.branchRequest="BranchRequest",e.bridge="Bridge",e.briefcase="Briefcase",e.briefcaseMedical="BriefcaseMedical",e.broadActivityFeed="BroadActivityFeed",e.broom="Broom",e.bug="Bug",e.building="Building",e.buildingBank="BuildingBank",e.buildingFactory="BuildingFactory",e.buildingGovernment="BuildingGovernment",e.buildingHome="BuildingHome",e.buildingLighthouse="BuildingLighthouse",e.buildingMultiple="BuildingMultiple",e.buildingRetail="BuildingRetail",e.buildingRetailMore="BuildingRetailMore",e.buildingRetailToolbox="BuildingRetailToolbox",e.buildingShop="BuildingShop",e.buildingSkyscraper="BuildingSkyscraper",e.calculator="Calculator",e.calendarLtr="CalendarLtr",e.calendarRtl="CalendarRtl",e.call="Call",e.calligraphyPen="CalligraphyPen",e.camera="Camera",e.cameraDome="CameraDome",e.car="Car",e.cart="Cart",e.cat="Cat",e.certificate="Certificate",e.chartMultiple="ChartMultiple",e.chat="Chat",e.chatMultiple="ChatMultiple",e.chatVideo="ChatVideo",e.check="Check",e.checkboxChecked="CheckboxChecked",e.checkboxUnchecked="CheckboxUnchecked",e.checkmark="Checkmark",e.chess="Chess",e.city="City",e.class="Class",e.classification="Classification",e.clipboard="Clipboard",e.clipboardDataBar="ClipboardDataBar",e.clipboardPulse="ClipboardPulse",e.clipboardTask="ClipboardTask",e.clock="Clock",e.clockAlarm="ClockAlarm",e.cloud="Cloud",e.cloudWords="CloudWords",e.code="Code",e.collections="Collections",e.comment="Comment",e.commentMultiple="CommentMultiple",e.communication="Communication",e.compassNorthwest="CompassNorthwest",e.conferenceRoom="ConferenceRoom",e.connector="Connector",e.constellation="Constellation",e.contactCard="ContactCard",e.cookies="Cookies",e.couch="Couch",e.creditCardPerson="CreditCardPerson",e.creditCardToolbox="CreditCardToolbox",e.cube="Cube",e.cubeMultiple="CubeMultiple",e.cubeTree="CubeTree",e.currencyDollarEuro="CurrencyDollarEuro",e.currencyDollarRupee="CurrencyDollarRupee",e.dataArea="DataArea",e.database="Database",e.databaseMultiple="DatabaseMultiple",e.dataFunnel="DataFunnel",e.dataHistogram="DataHistogram",e.dataLine="DataLine",e.dataPie="DataPie",e.dataScatter="DataScatter",e.dataSunburst="DataSunburst",e.dataTreemap="DataTreemap",e.dataWaterfall="DataWaterfall",e.dataWhisker="DataWhisker",e.dentist="Dentist",e.designIdeas="DesignIdeas",e.desktop="Desktop",e.desktopMac="DesktopMac",e.developerBoard="DeveloperBoard",e.deviceMeetingRoom="DeviceMeetingRoom",e.diagram="Diagram",e.dialpad="Dialpad",e.diamond="Diamond",e.dinosaur="Dinosaur",e.directions="Directions",e.disaster="Disaster",e.diversity="Diversity",e.dNA="DNA",e.doctor="Doctor",e.document="Document",e.documentData="DocumentData",e.documentLandscape="DocumentLandscape",e.documentMultiple="DocumentMultiple",e.documentPdf="DocumentPdf",e.documentQueue="DocumentQueue",e.documentText="DocumentText",e.dog="Dog",e.door="Door",e.doorTag="DoorTag",e.drafts="Drafts",e.drama="Drama",e.drinkBeer="DrinkBeer",e.drinkCoffee="DrinkCoffee",e.drinkMargarita="DrinkMargarita",e.drinkToGo="DrinkToGo",e.drinkWine="DrinkWine",e.driveTrain="DriveTrain",e.drop="Drop",e.dualScreen="DualScreen",e.dumbbell="Dumbbell",e.earth="Earth",e.emoji="Emoji",e.emojiAngry="EmojiAngry",e.emojiHand="EmojiHand",e.emojiLaugh="EmojiLaugh",e.emojiMeh="EmojiMeh",e.emojiMultiple="EmojiMultiple",e.emojiSad="EmojiSad",e.emojiSadSlight="EmojiSadSlight",e.emojiSmileSlight="EmojiSmileSlight",e.emojiSparkle="EmojiSparkle",e.emojiSurprise="EmojiSurprise",e.engine="Engine",e.eraser="Eraser",e.eye="Eye",e.eyedropper="Eyedropper",e.fax="Fax",e.fingerprint="Fingerprint",e.firstAid="FirstAid",e.flag="Flag",e.flash="Flash",e.flashlight="Flashlight",e.flow="Flow",e.flowchart="Flowchart",e.folder="Folder",e.folderOpen="FolderOpen",e.folderOpenVertical="FolderOpenVertical",e.folderPerson="FolderPerson",e.folderZip="FolderZip",e.food="Food",e.foodApple="FoodApple",e.foodCake="FoodCake",e.foodEgg="FoodEgg",e.foodGrains="FoodGrains",e.foodPizza="FoodPizza",e.foodToast="FoodToast",e.galaxy="Galaxy",e.games="Games",e.ganttChart="GanttChart",e.gas="Gas",e.gasPump="GasPump",e.gauge="Gauge",e.gavel="Gavel",e.gift="Gift",e.giftCard="GiftCard",e.glasses="Glasses",e.globe="Globe",e.globeSurface="GlobeSurface",e.grid="Grid",e.gridDots="GridDots",e.gridKanban="GridKanban",e.guardian="Guardian",e.guest="Guest",e.guitar="Guitar",e.handLeft="HandLeft",e.handRight="HandRight",e.handshake="Handshake",e.hardDrive="HardDrive",e.hatGraduation="HatGraduation",e.headphones="Headphones",e.headphonesSoundWave="HeadphonesSoundWave",e.headset="Headset",e.headsetVr="HeadsetVr",e.heart="Heart",e.heartBroken="HeartBroken",e.heartCircle="HeartCircle",e.heartHuman="HeartHuman",e.heartPulse="HeartPulse",e.history="History",e.home="Home",e.homeMore="HomeMore",e.homePerson="HomePerson",e.icons="Icons",e.image="Image",e.imageGlobe="ImageGlobe",e.imageMultiple="ImageMultiple",e.iot="Iot",e.joystick="Joystick",e.justice="Justice",e.key="Key",e.keyboard="Keyboard",e.keyboardLayoutSplit="KeyboardLayoutSplit",e.keyMultiple="KeyMultiple",e.languages="Languages",e.laptop="Laptop",e.lasso="Lasso",e.launcherSettings="LauncherSettings",e.layer="Layer",e.leaf="Leaf",e.leafOne="LeafOne",e.leafThree="LeafThree",e.leafTwo="LeafTwo",e.library="Library",e.lightbulb="Lightbulb",e.lightbulbFilament="LightbulbFilament",e.likert="Likert",e.link="Link",e.localLanguage="LocalLanguage",e.location="Location",e.lockClosed="LockClosed",e.lockMultiple="LockMultiple",e.lockOpen="LockOpen",e.lottery="Lottery",e.luggage="Luggage",e.mail="Mail",e.mailInbox="MailInbox",e.mailMultiple="MailMultiple",e.map="Map",e.mapPin="MapPin",e.markdown="Markdown",e.mathFormula="MathFormula",e.mathSymbols="MathSymbols",e.max="Max",e.megaphone="Megaphone",e.megaphoneLoud="MegaphoneLoud",e.mention="Mention",e.mic="Mic",e.microscope="Microscope",e.midi="Midi",e.molecule="Molecule",e.money="Money",e.moneyHand="MoneyHand",e.mountain="Mountain",e.movieCamera="MovieCamera",e.moviesAndTv="MoviesAndTv",e.musicNote="MusicNote",e.musicNote1="MusicNote1",e.musicNote2="MusicNote2",e.myLocation="MyLocation",e.nByN="NByN",e.nByOne="NByOne",e.news="News",e.notablePeople="NotablePeople",e.note="Note",e.notebook="Notebook",e.notepad="Notepad",e.notepadPerson="NotepadPerson",e.oneByN="OneByN",e.oneByOne="OneByOne",e.options="Options",e.organization="Organization",e.organizationHorizontal="OrganizationHorizontal",e.oval="Oval",e.paintBrush="PaintBrush",e.paintBucket="PaintBucket",e.partlySunnyWeather="PartlySunnyWeather",e.password="Password",e.patch="Patch",e.patient="Patient",e.payment="Payment",e.pen="Pen",e.pentagon="Pentagon",e.people="People",e.peopleAudience="PeopleAudience",e.peopleCall="PeopleCall",e.peopleCommunity="PeopleCommunity",e.peopleMoney="PeopleMoney",e.peopleQueue="PeopleQueue",e.peopleTeam="PeopleTeam",e.peopleToolbox="PeopleToolbox",e.person="Person",e.personBoard="PersonBoard",e.personCall="PersonCall",e.personChat="PersonChat",e.personFeedback="PersonFeedback",e.personSupport="PersonSupport",e.personVoice="PersonVoice",e.phone="Phone",e.phoneDesktop="PhoneDesktop",e.phoneLaptop="PhoneLaptop",e.phoneShake="PhoneShake",e.phoneTablet="PhoneTablet",e.phoneVibrate="PhoneVibrate",e.photoFilter="PhotoFilter",e.pi="Pi",e.pictureInPicture="PictureInPicture",e.pilates="Pilates",e.pill="Pill",e.pin="Pin",e.pipeline="Pipeline",e.planet="Planet",e.playingCards="PlayingCards",e.plugConnected="PlugConnected",e.plugDisconnected="PlugDisconnected",e.pointScan="PointScan",e.poll="Poll",e.power="Power",e.predictions="Predictions",e.premium="Premium",e.presenter="Presenter",e.previewLink="PreviewLink",e.print="Print",e.production="Production",e.prohibited="Prohibited",e.projectionScreen="ProjectionScreen",e.protocolHandler="ProtocolHandler",e.pulse="Pulse",e.pulseSquare="PulseSquare",e.puzzlePiece="PuzzlePiece",e.qrCode="QrCode",e.radar="Radar",e.ram="Ram",e.readingList="ReadingList",e.realEstate="RealEstate",e.receipt="Receipt",e.reward="Reward",e.rhombus="Rhombus",e.ribbon="Ribbon",e.ribbonStar="RibbonStar",e.roadCone="RoadCone",e.rocket="Rocket",e.router="Router",e.rss="Rss",e.ruler="Ruler",e.run="Run",e.running="Running",e.satellite="Satellite",e.save="Save",e.savings="Savings",e.scales="Scales",e.scan="Scan",e.scratchpad="Scratchpad",e.screenPerson="ScreenPerson",e.screenshot="Screenshot",e.search="Search",e.serialPort="SerialPort",e.server="Server",e.serverMultiple="ServerMultiple",e.serviceBell="ServiceBell",e.settings="Settings",e.shapes="Shapes",e.shield="Shield",e.shieldTask="ShieldTask",e.shoppingBag="ShoppingBag",e.signature="Signature",e.sim="Sim",e.sleep="Sleep",e.smartwatch="Smartwatch",e.soundSource="SoundSource",e.soundWaveCircle="SoundWaveCircle",e.sparkle="Sparkle",e.speaker0="Speaker0",e.speaker2="Speaker2",e.sport="Sport",e.sportAmericanFootball="SportAmericanFootball",e.sportBaseball="SportBaseball",e.sportBasketball="SportBasketball",e.sportHockey="SportHockey",e.sportSoccer="SportSoccer",e.squareMultiple="SquareMultiple",e.squareShadow="SquareShadow",e.squaresNested="SquaresNested",e.stack="Stack",e.stackStar="StackStar",e.star="Star",e.starFilled="StarFilled",e.starHalf="StarHalf",e.starLineHorizontal3="StarLineHorizontal3",e.starOneQuarter="StarOneQuarter",e.starThreeQuarter="StarThreeQuarter",e.status="Status",e.steps="Steps",e.stethoscope="Stethoscope",e.sticker="Sticker",e.storage="Storage",e.stream="Stream",e.streamInput="StreamInput",e.streamInputOutput="StreamInputOutput",e.streamOutput="StreamOutput",e.styleGuide="StyleGuide",e.subGrid="SubGrid",e.subtitles="Subtitles",e.surfaceEarbuds="SurfaceEarbuds",e.surfaceHub="SurfaceHub",e.symbols="Symbols",e.syringe="Syringe",e.system="System",e.tabDesktop="TabDesktop",e.tabInprivateAccount="TabInprivateAccount",e.table="Table",e.tableImage="TableImage",e.tableMultiple="TableMultiple",e.tablet="Tablet",e.tabs="Tabs",e.tag="Tag",e.tagCircle="TagCircle",e.tagMultiple="TagMultiple",e.target="Target",e.targetArrow="TargetArrow",e.teddy="Teddy",e.temperature="Temperature",e.tent="Tent",e.tetrisApp="TetrisApp",e.textbox="Textbox",e.textQuote="TextQuote",e.thinking="Thinking",e.thumbDislike="ThumbDislike",e.thumbLike="ThumbLike",e.ticketDiagonal="TicketDiagonal",e.ticketHorizontal="TicketHorizontal",e.timeAndWeather="TimeAndWeather",e.timeline="Timeline",e.timer="Timer",e.toolbox="Toolbox",e.topSpeed="TopSpeed",e.translate="Translate",e.transmission="Transmission",e.treeDeciduous="TreeDeciduous",e.treeEvergreen="TreeEvergreen",e.trophy="Trophy",e.tv="Tv",e.tvUsb="TvUsb",e.umbrella="Umbrella",e.usbPlug="UsbPlug",e.usbStick="UsbStick",e.vault="Vault",e.vehicleBicycle="VehicleBicycle",e.vehicleBus="VehicleBus",e.vehicleCab="VehicleCab",e.vehicleCar="VehicleCar",e.vehicleCarCollision="VehicleCarCollision",e.vehicleCarProfileLtr="VehicleCarProfileLtr",e.vehicleCarProfileRtl="VehicleCarProfileRtl",e.vehicleShip="VehicleShip",e.vehicleSubway="VehicleSubway",e.vehicleTruck="VehicleTruck",e.vehicleTruckBag="VehicleTruckBag",e.vehicleTruckCube="VehicleTruckCube",e.vehicleTruckProfile="VehicleTruckProfile",e.video="Video",e.video360="Video360",e.videoChat="VideoChat",e.videoClip="VideoClip",e.videoClipMultiple="VideoClipMultiple",e.videoPerson="VideoPerson",e.videoRecording="VideoRecording",e.videoSecurity="VideoSecurity",e.viewDesktop="ViewDesktop",e.viewDesktopMobile="ViewDesktopMobile",e.violin="Violin",e.virtualNetwork="VirtualNetwork",e.voicemail="Voicemail",e.vote="Vote",e.walkieTalkie="WalkieTalkie",e.wallet="Wallet",e.walletCreditCard="WalletCreditCard",e.wallpaper="Wallpaper",e.wand="Wand",e.warning="Warning",e.weatherBlowingSnow="WeatherBlowingSnow",e.weatherCloudy="WeatherCloudy",e.weatherDrizzle="WeatherDrizzle",e.weatherDuststorm="WeatherDuststorm",e.weatherFog="WeatherFog",e.weatherHailDay="WeatherHailDay",e.weatherHailNight="WeatherHailNight",e.weatherHaze="WeatherHaze",e.weatherMoon="WeatherMoon",e.weatherPartlyCloudyDay="WeatherPartlyCloudyDay",e.weatherPartlyCloudyNight="WeatherPartlyCloudyNight",e.weatherRain="WeatherRain",e.weatherRainShowersDay="WeatherRainShowersDay",e.weatherRainShowersNight="WeatherRainShowersNight",e.weatherRainSnow="WeatherRainSnow",e.weatherSnow="WeatherSnow",e.weatherSnowflake="WeatherSnowflake",e.weatherSnowShowerDay="WeatherSnowShowerDay",e.weatherSnowShowerNight="WeatherSnowShowerNight",e.weatherSqualls="WeatherSqualls",e.weatherSunnyHigh="WeatherSunnyHigh",e.weatherSunnyLow="WeatherSunnyLow",e.weatherThunderstorm="WeatherThunderstorm",e.webAsset="WebAsset",e.whiteboard="Whiteboard",e.wifi1="Wifi1",e.wifi2="Wifi2",e.window="Window",e.windowMultiple="WindowMultiple",e.windowWrench="WindowWrench",e.wrench="Wrench",e.wrenchScrewdriver="WrenchScrewdriver",e.xray="Xray",e.yoga="Yoga"}(e.EntityCompactLayoutIcons||(e.EntityCompactLayoutIcons={})),function(e){e.array="Array",e.entity="Entity",e.root="Root",e.double="Double",e.string="String",e.boolean="Boolean"}(e.ReferenceValueType||(e.ReferenceValueType={})),function(e){e.array="Array",e.boolean="Boolean",e.double="Double",e.entity="Entity",e.empty="Empty",e.error="Error",e.externalCodeServiceObject="ExternalCodeServiceObject",e.formattedNumber="FormattedNumber",e.function="Function",e.lambda="Lambda",e.linkedEntity="LinkedEntity",e.localImage="LocalImage",e.reference="Reference",e.string="String",e.notAvailable="NotAvailable",e.webImage="WebImage"}(e.CellValueType||(e.CellValueType={})),function(e){e.unknown="Unknown",e.serviceError="ServiceError",e.externalLinks="ExternalLinks",e.externalLinksNonCloudLocation="ExternalLinksNonCloudLocation",e.dataTypeNoConnection="DataTypeNoConnection",e.dataTypeServiceError="DataTypeServiceError",e.missingContent="MissingContent",e.requestThrottle="RequestThrottle",e.externalLinksFailedToRefresh="ExternalLinksFailedToRefresh",e.externalLinksAccessFailed="ExternalLinksAccessFailed",e.externalLinksServerError="ExternalLinksServerError",e.externalLinksInvalidRequest="ExternalLinksInvalidRequest",e.externalLinksUnAuthenticated="ExternalLinksUnAuthenticated",e.externalLinksThrottledByHost="ExternalLinksThrottledByHost",e.externalLinksFileTooLarge="ExternalLinksFileTooLarge",e.outdatedLinkedEntity="OutdatedLinkedEntity",e.genericServerError="GenericServerError",e.imageUnableToRetrieve="ImageUnableToRetrieve",e.externalCodeServiceEnvironmentNotFound="ExternalCodeServiceEnvironmentNotFound",e.externalCodeServiceRuntimeNotFound="ExternalCodeServiceRuntimeNotFound",e.externalCodeServiceEnvironmentBadState="ExternalCodeServiceEnvironmentBadState",e.externalCodeServiceRuntimeBadState="ExternalCodeServiceRuntimeBadState",e.externalCodeServiceComputeResourceNotAvailable="ExternalCodeServiceComputeResourceNotAvailable",e.pythonPowerQueryDataUploadHasNotStarted="PythonPowerQueryDataUploadHasNotStarted",e.excelClientMisconfigurationError="ExcelClientMisconfigurationError"}(e.ConnectErrorCellValueSubType||(e.ConnectErrorCellValueSubType={})),function(e){e.blocked="Blocked",e.busy="Busy",e.calc="Calc",e.connect="Connect",e.div0="Div0",e.external="External",e.field="Field",e.gettingData="GettingData",e.notAvailable="NotAvailable",e.name="Name",e.null="Null",e.num="Num",e.placeholder="Placeholder",e.python="Python",e.ref="Ref",e.spill="Spill",e.timeout="Timeout",e.value="Value"}(e.ErrorCellValueType||(e.ErrorCellValueType={})),function(e){e.unknown="Unknown"}(e.ExternalErrorCellValueSubType||(e.ExternalErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.webImageMissingFilePart="WebImageMissingFilePart",e.dataProviderError="DataProviderError",e.richValueRelMissingFilePart="RichValueRelMissingFilePart"}(e.FieldErrorCellValueSubType||(e.FieldErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.vlookupValueNotFound="VlookupValueNotFound",e.hlookupValueNotFound="HlookupValueNotFound",e.stockHistoryInvalidProperty="StockHistoryInvalidProperty",e.stockHistoryNoData="StockHistoryNoData",e.pythonObjectUnknown="PythonObjectUnknown",e.eRegexMatchNoResult="ERegexMatchNoResult",e.eRegexReplaceOccurrenceNoResult="ERegexReplaceOccurrenceNoResult",e.eRegexMatchNoCapture="ERegexMatchNoCapture"}(e.NotAvailableErrorCellValueSubType||(e.NotAvailableErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.unsupportedFunction="UnsupportedFunction"}(e.NameErrorCellValueSubType||(e.NameErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.arrayTooLarge="ArrayTooLarge"}(e.NumErrorCellValueSubType||(e.NumErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.externalLinksStructuredRef="ExternalLinksStructuredRef",e.externalLinksCalculatedRef="ExternalLinksCalculatedRef",e.corruptCellRef="CorruptCellRef"}(e.RefErrorCellValueSubType||(e.RefErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.collision="Collision",e.indeterminateSize="IndeterminateSize",e.worksheetEdge="WorksheetEdge",e.outOfMemoryWhileCalc="OutOfMemoryWhileCalc",e.table="Table",e.mergedCell="MergedCell"}(e.SpillErrorCellValueSubType||(e.SpillErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.pythonTimeoutLimitReached="PythonTimeoutLimitReached"}(e.TimeoutErrorCellValueSubType||(e.TimeoutErrorCellValueSubType={})),function(e){e.unknown="Unknown",e.vlookupColumnIndexLessThanOne="VlookupColumnIndexLessThanOne",e.vlookupResultNotFound="VlookupResultNotFound",e.hlookupRowIndexLessThanOne="HlookupRowIndexLessThanOne",e.hlookupResultNotFound="HlookupResultNotFound",e.coerceStringToNumberInvalid="CoerceStringToNumberInvalid",e.coerceStringToBoolInvalid="CoerceStringToBoolInvalid",e.coerceStringToInvalidType="CoerceStringToInvalidType",e.subArrayStartRowMissingEndRowNot="SubArrayStartRowMissingEndRowNot",e.subArrayStartColumnMissingEndColumnNot="SubArrayStartColumnMissingEndColumnNot",e.invalidImageUrl="InvalidImageUrl",e.stockHistoryNonTradingDays="StockHistoryNonTradingDays",e.stockHistoryNotAStock="StockHistoryNotAStock",e.stockHistoryInvalidDate="StockHistoryInvalidDate",e.stockHistoryEndBeforeStart="StockHistoryEndBeforeStart",e.stockHistoryStartInFuture="StockHistoryStartInFuture",e.stockHistoryInvalidEnum="StockHistoryInvalidEnum",e.stockHistoryOnlyDateRequested="StockHistoryOnlyDateRequested",e.stockHistoryNotFound="StockHistoryNotFound",e.lambdaWrongParamCount="LambdaWrongParamCount",e.imageFormulaTooManyArgs="ImageFormulaTooManyArgs",e.imageFormulaInvalidImageFormat="ImageFormulaInvalidImageFormat",e.imageFormulaInvalidSource="ImageFormulaInvalidSource",e.imageFormulaInvalidAltText="ImageFormulaInvalidAltText",e.imageFormulaInvalidSizing="ImageFormulaInvalidSizing",e.imageFormulaNotEnoughArgs="ImageFormulaNotEnoughArgs",e.imageFormulaInvalidHeight="ImageFormulaInvalidHeight",e.imageFormulaInvalidWidth="ImageFormulaInvalidWidth",e.invalidCellValueTypeCoercion="InvalidCellValueTypeCoercion",e.cRegexErrorGeneric="CRegexErrorGeneric",e.cRegexEndBackslash="CRegexEndBackslash",e.cRegexEndBackslashC="CRegexEndBackslashC",e.cRegexUnknownEscape="CRegexUnknownEscape",e.cRegexQuantifierOutOfOrder="CRegexQuantifierOutOfOrder",e.cRegexQuantifierTooBig="CRegexQuantifierTooBig",e.cRegexMissingSquareBracket="CRegexMissingSquareBracket",e.cRegexEscapeInvalidInClass="CRegexEscapeInvalidInClass",e.cRegexQuantifierInvalid="CRegexQuantifierInvalid",e.cRegexInvalidAfterParensQuery="CRegexInvalidAfterParensQuery",e.cRegexPosixClassNotInClass="CRegexPosixClassNotInClass",e.cRegexPosixNoSupportCollating="CRegexPosixNoSupportCollating",e.cRegexMissingClosingParenthesis="CRegexMissingClosingParenthesis",e.cRegexBadSubpatternReference="CRegexBadSubpatternReference",e.cRegexMissingCommentClosing="CRegexMissingCommentClosing",e.cRegexParenthesesNestTooDeep="CRegexParenthesesNestTooDeep",e.cRegexPatternTooLarge="CRegexPatternTooLarge",e.cRegexUnmatchedClosingParenthesis="CRegexUnmatchedClosingParenthesis",e.cRegexMissingConditionClosing="CRegexMissingConditionClosing",e.cRegexLookbehindNotFixedLength="CRegexLookbehindNotFixedLength",e.cRegexZeroRelativeReference="CRegexZeroRelativeReference",e.cRegexTooManyConditionBranches="CRegexTooManyConditionBranches",e.cRegexBadRelativeReference="CRegexBadRelativeReference",e.cRegexUnknownPosixClass="CRegexUnknownPosixClass",e.cRegexCodePointTooBig="CRegexCodePointTooBig",e.cRegexLookbehindTooComplicated="CRegexLookbehindTooComplicated",e.cRegexUnsupportedEscapeSequence="CRegexUnsupportedEscapeSequence",e.cRegexCalloutNumberTooBig="CRegexCalloutNumberTooBig",e.cRegexMissingCalloutClosing="CRegexMissingCalloutClosing",e.cRegexEscapeInvalidInVerb="CRegexEscapeInvalidInVerb",e.cRegexUnrecognizedAfterQueryP="CRegexUnrecognizedAfterQueryP",e.cRegexMissingNameTerminator="CRegexMissingNameTerminator",e.cRegexDuplicateSubpatternName="CRegexDuplicateSubpatternName",e.cRegexInvalidSubpatternName="CRegexInvalidSubpatternName",e.cRegexUnicodePropertiesUnavailable="CRegexUnicodePropertiesUnavailable",e.cRegexMalformedUnicodeProperty="CRegexMalformedUnicodeProperty",e.cRegexUnknownUnicodeProperty="CRegexUnknownUnicodeProperty",e.cRegexSubpatternNameTooLong="CRegexSubpatternNameTooLong",e.cRegexTooManyNamedSubpatterns="CRegexTooManyNamedSubpatterns",e.cRegexClassInvalidRange="CRegexClassInvalidRange",e.cRegexDefineTooManyBranches="CRegexDefineTooManyBranches",e.cRegexBackslashOMissingBrace="CRegexBackslashOMissingBrace",e.cRegexBackslashGSyntax="CRegexBackslashGSyntax",e.cRegexParensQueryRMissingClosing="CRegexParensQueryRMissingClosing",e.cRegexVerbUnknown="CRegexVerbUnknown",e.cRegexSubpatternNumberTooBig="CRegexSubpatternNumberTooBig",e.cRegexSubpatternNameExpected="CRegexSubpatternNameExpected",e.cRegexInvalidOctal="CRegexInvalidOctal",e.cRegexSubpatternNamesMismatch="CRegexSubpatternNamesMismatch",e.cRegexMarkMissingArgument="CRegexMarkMissingArgument",e.cRegexInvalidHexadecimal="CRegexInvalidHexadecimal",e.cRegexBackslashCSyntax="CRegexBackslashCSyntax",e.cRegexBackslashNInClass="CRegexBackslashNInClass",e.cRegexCalloutStringTooLong="CRegexCalloutStringTooLong",e.cRegexUnicodeDisallowedCodePoint="CRegexUnicodeDisallowedCodePoint",e.cRegexVerbNameTooLong="CRegexVerbNameTooLong",e.cRegexBackslashUCodePointTooBig="CRegexBackslashUCodePointTooBig",e.cRegexMissingOctalOrHexDigits="CRegexMissingOctalOrHexDigits",e.cRegexVersionConditionSyntax="CRegexVersionConditionSyntax",e.cRegexCalloutNoStringDelimiter="CRegexCalloutNoStringDelimiter",e.cRegexCalloutBadStringDelimiter="CRegexCalloutBadStringDelimiter",e.cRegexQueryBarjxNestTooDeep="CRegexQueryBarjxNestTooDeep",e.cRegexPatternTooComplicated="CRegexPatternTooComplicated",e.cRegexLookbehindTooLong="CRegexLookbehindTooLong",e.cRegexPatternStringTooLong="CRegexPatternStringTooLong",e.cRegexInvalidHyphenInOptions="CRegexInvalidHyphenInOptions",e.cRegexAlphaAssertionUnknown="CRegexAlphaAssertionUnknown",e.cRegexTooManyCaptures="CRegexTooManyCaptures",e.cRegexConditionAtomicAssertionExpected="CRegexConditionAtomicAssertionExpected",e.cRegexBackslashKInLookaround="CRegexBackslashKInLookaround",e.mRegexErrorGeneric="MRegexErrorGeneric",e.mRegexBadreplacement="MRegexBadreplacement",e.mRegexMatchlimit="MRegexMatchlimit",e.mRegexNosubstring="MRegexNosubstring",e.mRegexNouniquesubstring="MRegexNouniquesubstring",e.mRegexDepthlimit="MRegexDepthlimit",e.mRegexBadrepescape="MRegexBadrepescape",e.mRegexRepmissingbrace="MRegexRepmissingbrace",e.mRegexBadsubstitution="MRegexBadsubstitution",e.mRegexBadsubspattern="MRegexBadsubspattern",e.mRegexRecurseLoop="MRegexRecurseLoop",e.eRegexErrorGeneric="ERegexErrorGeneric",e.eRegexNoCaptureGroups="ERegexNoCaptureGroups",e.translateStringTooLong="TranslateStringTooLong",e.translateUnsupportedSrcLanguage="TranslateUnsupportedSrcLanguage",e.translateUnsupportedTargetLanguage="TranslateUnsupportedTargetLanguage"}(e.ValueErrorCellValueSubType||(e.ValueErrorCellValueSubType={}));var n=function(e){function t(t){var n=e.call(this,t)||this;return n._customData="WacPartition",n.m_wacWorkbook=A(r,n),n._rootObject=n.m_wacWorkbook,n._rootObjectPropertyName="wacWorkbook",n}return __extends(t,e),Object.defineProperty(t.prototype,"wacWorkbook",{get:function(){return this.m_wacWorkbook},enumerable:!0,configurable:!0}),t}(OfficeCore.RequestContext),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.createAndOpenWorkbook=function(e){E(this,"CreateAndOpenWorkbook",0,[e],0,0)},t}(OfficeExtension.ClientObject);function o(e){return e[0].toLowerCase()+e.slice(1)}e.createWorkbook=function(e){return I("Excel.createWorkbook",O,"1.8",_),t({delayForCellEdit:!0},(function(t){t instanceof n?t.wacWorkbook.createAndOpenWorkbook(e):t.workbook.application.createWorkbook(e).open()}))};var i,a,s,c=[["RedDownArrow","YellowSideArrow","GreenUpArrow"],["GrayDownArrow","GraySideArrow","GrayUpArrow"],["RedFlag","YellowFlag","GreenFlag"],["RedCircleWithBorder","YellowCircle","GreenCircle"],["RedTrafficLight","YellowTrafficLight","GreenTrafficLight"],["RedDiamond","YellowTriangle","GreenCircle"],["RedCrossSymbol","YellowExclamationSymbol","GreenCheckSymbol"],["RedCross","YellowExclamation","GreenCheck"],["RedDownArrow","YellowDownInclineArrow","YellowUpInclineArrow","GreenUpArrow"],["GrayDownArrow","GrayDownInclineArrow","GrayUpInclineArrow","GrayUpArrow"],["BlackCircle","GrayCircle","PinkCircle","RedCircle"],["OneBar","TwoBars","ThreeBars","FourBars"],["BlackCircleWithBorder","RedCircleWithBorder","YellowCircle","GreenCircle"],["RedDownArrow","YellowDownInclineArrow","YellowSideArrow","YellowUpInclineArrow","GreenUpArrow"],["GrayDownArrow","GrayDownInclineArrow","GraySideArrow","GrayUpInclineArrow","GrayUpArrow"],["NoBars","OneBar","TwoBars","ThreeBars","FourBars"],["WhiteCircleAllWhiteQuarters","CircleWithThreeWhiteQuarters","CircleWithTwoWhiteQuarters","CircleWithOneWhiteQuarter","BlackCircle"],["SilverStar","HalfGoldStar","GoldStar"],["RedDownTriangle","YellowDash","GreenUpTriangle"],["NoFilledBoxes","OneFilledBox","TwoFilledBoxes","ThreeFilledBoxes","FourFilledBoxes"]];function l(e,t,n,r){if(Array.isArray(n)&&n.length>0&&Array.isArray(n[0])&&n.length*n[0].length>1500&&d()){var o=Math.max(1,Math.round(1500/n[0].length));e._ValidateArraySize(n.length,n[0].length);for(var i=0;i<n.length;i+=o){var a=o;i+a>n.length&&(a=n.length-i);var s=e.getRow(i).untrack().getBoundingRect(e.getRow(i+a-1).untrack()).untrack(),c=n.slice(i,i+a);P(s,t,c,null!=r?r:0)}return!0}return!1}function u(e){return OfficeExtension.Utility.isSetSupported("ExcelApi",e.toString())}function d(){return u(1.3)}function f(e){return!("undefined"==typeof window||!window.Office||!window.Office.context)&&window.Office.context.platform===e}e.icons={},["ThreeArrows","ThreeArrowsGray","ThreeFlags","ThreeTrafficLights1","ThreeTrafficLights2","ThreeSigns","ThreeSymbols","ThreeSymbols2","FourArrows","FourArrowsGray","FourRedToBlack","FourRating","FourTrafficLights","FiveArrows","FiveArrowsGray","FiveRating","FiveQuarters","ThreeStars","ThreeTriangles","FiveBoxes"].map((function(t,n){var r=o(t);e.icons[r]=[],c[n].map((function(n,i){n=o(n);var a={set:t,index:i};e.icons[r].push(a),e.icons[r][n]=a}))})),function(e){e.NotStarted="notStarted",e.Running="running",e.Succeeded="succeeded",e.Failed="failed"}(i||(i={})),function(e){e[e.OK=200]="OK",e[e.Created=201]="Created",e[e.Accepted=202]="Accepted",e[e.NoContent=204]="NoContent",e[e.HighestSuccessCode=299]="HighestSuccessCode",e[e.TooManyRequests=429]="TooManyRequests",e[e.InternalServerError=500]="InternalServerError",e[e.ServiceUnavailable=503]="ServiceUnavailable",e[e.GatewayTimeout=504]="GatewayTimeout"}(a||(a={})),function(e){e.Close="Session.close",e.CommitChanges="Session.commitChanges",e.Create="Session.resolveRequestUrlAndHeaderInfo",e.Refresh="Session.refreshSession"}(s=e.SessionOperation||(e.SessionOperation={}));var p=function(){function e(t,n,r){var o=void 0===r?{}:r,i=o.persistChanges,a=void 0===i||i,s=o.commitExplicitly,c=void 0===s||s;this.m_requestId="",this.m_workbookUrl=t?e.ensureUrlFormatEndWithSlash(t):"",this.m_requestHeaders=n||{},this.m_persistChanges=a,this.m_commitExplicitly=c}return Object.defineProperty(e.prototype,"requestId",{get:function(){return this.m_requestId},enumerable:!0,configurable:!0}),e.prototype.close=function(){var t=this;if(this.m_requestUrlAndHeaderInfo&&!OfficeExtension.Utility._isLocalDocumentUrl(this.m_requestUrlAndHeaderInfo.url)){var n={method:"POST",url:this.buildRestApiUrl(this.m_requestUrlAndHeaderInfo.url,e.CLOSE_SESSION),headers:this.m_requestUrlAndHeaderInfo.headers,body:""};return OfficeExtension.HttpUtility.sendRequest(n).then((function(n){if(n.statusCode!==a.NoContent)throw e.createErrorFromResponseInfo(n,s.Close);for(var r in t.m_requestUrlAndHeaderInfo=null,t.m_requestHeaders)if(r.toLowerCase()===e.WorkbookSessionIdHeaderNameLower){delete t.m_requestHeaders[r];break}}))}return OfficeExtension.Utility._createPromiseFromResult(null)},e.prototype.commitChanges=function(t){var n=this;if(void 0===t&&(t={}),!this.m_commitExplicitly)throw e.createError(a.InternalServerError,"Can not call commitChanges() if commitExplicitly is not set.",s.CommitChanges);if(!this.m_workbookUrl||OfficeExtension.Utility._isLocalDocumentUrl(this.m_workbookUrl))throw e.createError(a.InternalServerError,"Not supported for local documents.",s.CommitChanges);if(!this.m_requestUrlAndHeaderInfo)throw e.createError(a.InternalServerError,"Need to call this._resolveRequestUrlAndHeaderInfo() to get the session id first.",s.CommitChanges);var r=this.createCommitChangesRequestInfo(t);return OfficeExtension.HttpUtility.sendRequest(r).then((function(r){var o=r.statusCode;if(o===a.Accepted)return e.delay(e.POLL_DELAY).then((function(o){return n.pollResourceLocation(e.getHeaderIgnoreCase(r.headers,e.LOCATION_HEADER),s.CommitChanges,t)})).then((function(t){if(JSON.parse(t.body).status===i.Failed)throw e.createErrorFromResponseInfo(t,s.CommitChanges);return e.parseCooldownTime(t)}));if(o>=a.OK&&o<=a.HighestSuccessCode)return e.parseCooldownTime(r);throw e.createErrorFromResponseInfo(r,s.CommitChanges)}))},e.prototype._resolveRequestUrlAndHeaderInfo=function(t){var n=this;if(void 0===t&&(t={}),this.m_requestUrlAndHeaderInfo)return OfficeExtension.Utility._createPromiseFromResult(this.m_requestUrlAndHeaderInfo);if(!this.m_workbookUrl||OfficeExtension.Utility._isLocalDocumentUrl(this.m_workbookUrl))return this.m_requestUrlAndHeaderInfo={url:this.m_workbookUrl,headers:this.m_requestHeaders},OfficeExtension.Utility._createPromiseFromResult(this.m_requestUrlAndHeaderInfo);if(e.getHeaderIgnoreCase(this.m_requestHeaders,e.WorkbookSessionIdHeaderNameLower))return this.m_requestUrlAndHeaderInfo={url:this.m_workbookUrl,headers:this.m_requestHeaders},OfficeExtension.Utility._createPromiseFromResult(this.m_requestUrlAndHeaderInfo);var r=this.createAsyncGraphSessionRequestInfo(t);return OfficeExtension.HttpUtility.sendRequest(r).then((function(r){if(n.m_requestId=e.getHeaderIgnoreCase(r.headers,e.REQUEST_ID_HEADER),r.statusCode!==a.Accepted&&r.statusCode!==a.Created)throw e.createErrorFromResponseInfo(r,s.Create);return r.statusCode===a.Created?(n.formatRequestUrlAndHeaderInfo(r),r):e.delay(e.POLL_DELAY).then((function(o){return n.pollResourceLocation(e.getHeaderIgnoreCase(r.headers,e.LOCATION_HEADER),s.Create,t)})).then((function(o){var a=JSON.parse(o.body);if(a.status===i.Failed)throw e.createErrorFromResponseInfo(o,s.Create);var c={method:"GET",url:a.resourceLocation,headers:__assign({},t,{Authorization:e.getHeaderIgnoreCase(n.m_requestHeaders,e.AUTHORIZATION_HEADER)}),body:void 0};return OfficeExtension.HttpUtility.sendRequest(c).then((function(e){return n.formatRequestUrlAndHeaderInfo(e),r}))}))}))},e.prototype.refreshSession=function(){if(!this.m_workbookUrl||OfficeExtension.Utility._isLocalDocumentUrl(this.m_workbookUrl))throw e.createError(a.InternalServerError,"Not supported for local documents.",s.Refresh);if(!this.m_requestUrlAndHeaderInfo)throw e.createError(a.InternalServerError,"Need to call this._resolveRequestUrlAndHeaderInfo() to get the session id first.",s.Refresh);var t=this.createRefreshSessionRequestInfo();return OfficeExtension.HttpUtility.sendRequest(t).then((function(t){if(t.statusCode!=a.NoContent)throw e.createErrorFromResponseInfo(t,s.Refresh);return OfficeExtension.Utility._createPromiseFromResult(null)}))},e.getHeaderIgnoreCase=function(e,t){var n=Object.keys(e).filter((function(e){return e.toLowerCase()===t.toLowerCase()}));return n.length>0?e[n[0]]:void 0},e.prototype.createCommitChangesRequestInfo=function(t){void 0===t&&(t={});var n=this.buildRestApiUrl(this.m_workbookUrl,e.COMMIT_CHANGES),r={};return OfficeExtension.Utility._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,r),OfficeExtension.Utility._copyHeaders(t,r),r[e.PREFER_HEADER]=e.PREFER_HEADER_VAL,{url:n,method:"POST",headers:r,body:{}}},e.prototype.createAsyncGraphSessionRequestInfo=function(t){void 0===t&&(t={});var n=this.buildRestApiUrl(this.m_workbookUrl,e.CREATE_SESSION),r={};return OfficeExtension.Utility._copyHeaders(this.m_requestHeaders,r),OfficeExtension.Utility._copyHeaders(t,r),r[e.CONTENT_TYPE_HEADER]=e.CONTENT_TYPE_HEADER_VAL,r[e.PREFER_HEADER]=e.PREFER_HEADER_VAL,{url:n,method:"POST",headers:r,body:{persistChanges:this.m_persistChanges,commitExplicitly:this.m_commitExplicitly}}},e.prototype.createRefreshSessionRequestInfo=function(){var t=this.buildRestApiUrl(this.m_workbookUrl,e.REFRESH_SESSION),n={};return OfficeExtension.Utility._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,n),n[e.CONTENT_TYPE_HEADER]=e.CONTENT_TYPE_HEADER_VAL,{url:t,method:"POST",headers:n,body:{}}},e.getCorrectGraphVersionUrl=function(t){return t.replace(new RegExp("graph.microsoft.com/.*?/"),"graph.microsoft.com/"+e.ASYNC_API_GRAPH_VERSION+"/")},e.prototype.buildRestApiUrl=function(t,n,r){void 0===r&&(r={});var o={};switch(OfficeExtension.Utility._copyHeaders(r,o),OfficeExtension.Utility._copyHeaders(this.m_requestHeaders,o),this.m_requestUrlAndHeaderInfo&&this.m_requestUrlAndHeaderInfo.headers&&OfficeExtension.Utility._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,o),e.getHeaderIgnoreCase(o,OfficeExtension.CommonConstants.remoteEndpointTypeHeaderKey)){case OfficeExtension.RemoteEndpointType.graph.toString():var i=new URL(e.getCorrectGraphVersionUrl(t)),a=i.pathname.split("/");return n&&a.push(n),i.pathname=a.join("/"),i.toString();case OfficeExtension.RemoteEndpointType.wfe.toString():var s=new URL(t);n&&s.searchParams.set("wdRestPart","_api/"+n);var c=e.getHeaderIgnoreCase(o,e.WorkbookSessionIdHeaderNameLower);if(c=c||e.getHeaderIgnoreCase(o,e.WorkbookSessionIdHeaderNameLower)){var l=c.match(/cluster=(.*?[^\&]+)/);l&&s.searchParams.set("waccluster",l[1])}return s.toString();default:return t}},e.prototype.pollResourceLocation=function(t,n,r,o){var s=this;if(void 0===r&&(r={}),void 0===o&&(o=0),o>=e.MAX_POLL_ATTEMPTS)throw e.createError(a.InternalServerError,"Timout while polling for the resource location.",n);var c={method:"GET",url:t,headers:__assign({},r,{Authorization:e.getHeaderIgnoreCase(this.m_requestHeaders,e.AUTHORIZATION_HEADER)}),body:void 0};return OfficeExtension.HttpUtility.sendRequest(c).then((function(c){if(c.statusCode!==a.OK)return s.pollResourceLocation(t,n,r,o+1);switch(JSON.parse(c.body).status){case i.Succeeded:case i.Failed:return c;case i.NotStarted:case i.Running:return e.delay(e.POLL_DELAY).then((function(e){return s.pollResourceLocation(t,n,r,o+1)}));default:throw e.createErrorFromResponseInfo(c,n)}}))},e.parseCooldownTime=function(t){var n=e.getHeaderIgnoreCase(t.headers,e.RETRY_AFTER_HEADER);return n?1e3*parseInt(n):e.DEFAULT_COMMIT_CHANGES_RETRY_AFTER},e.prototype.formatRequestUrlAndHeaderInfo=function(t){if(t.statusCode!==a.OK&&t.statusCode!==a.Created)throw e.createErrorFromResponseInfo(t,s.Create);var n=JSON.parse(t.body).id,r={};OfficeExtension.Utility._copyHeaders(this.m_requestHeaders,r),r[e.WorkbookSessionIdHeaderName]=n,this.m_requestUrlAndHeaderInfo={url:this.buildRestApiUrl(this.m_workbookUrl,void 0,r),headers:r}},e.ensureUrlFormatEndWithSlash=function(e){return"/"!==e.charAt(e.length-1)&&(e+="/"),e},e.delay=function(e){return new OfficeExtension.CoreUtility.Promise((function(t,n){return setTimeout((function(){return t()}),e)}))},e.createErrorFromResponseInfo=function(t,n){var r=OfficeExtension.Utility._parseErrorResponse(t),o={retryAfter:e.getHeaderIgnoreCase(t.headers,e.RETRY_AFTER_HEADER),responseBody:OfficeExtension.Utility._parseErrorResponseBody(t)};return OfficeExtension.Utility.createRuntimeError(r.errorCode,r.errorMessage,n,t.statusCode,o)},e.createError=function(e,t,n){return OfficeExtension.Utility.createRuntimeError(""+e,t,n)},e.WorkbookSessionIdHeaderName="Workbook-Session-Id",e.WorkbookSessionIdHeaderNameLower="workbook-session-id",e.ASYNC_API_GRAPH_VERSION="beta",e.POLL_DELAY=1e4,e.MAX_POLL_ATTEMPTS=10,e.DEFAULT_COMMIT_CHANGES_RETRY_AFTER=1e4,e.LOCATION_HEADER="location",e.AUTHORIZATION_HEADER="authorization",e.REQUEST_ID_HEADER="request-id",e.RETRY_AFTER_HEADER="retry-after",e.PREFER_HEADER="Prefer",e.PREFER_HEADER_VAL="respond-async",e.CONTENT_TYPE_HEADER="Content-Type",e.CONTENT_TYPE_HEADER_VAL="application/json",e.CLOSE_SESSION="closeSession",e.COMMIT_CHANGES="commitChanges",e.CREATE_SESSION="createSession",e.REFRESH_SESSION="refreshSession",e}();e.Session=p;var g=function(t){function n(n){var r=t.call(this,n)||this;return r.m_workbook=A(e.Workbook,r),r._rootObject=r.m_workbook,r._rootObjectPropertyName="workbook",r}return __extends(n,t),n.prototype._processOfficeJsErrorResponse=function(e,t){5004===e&&(t.ErrorCode=W.invalidOperationInCellEditMode,t.HttpStatusCode=400,t.ErrorMessage=OfficeExtension.Utility._getResourceString(OfficeExtension.ResourceStrings.invalidOperationInCellEditMode))},Object.defineProperty(n.prototype,"workbook",{get:function(){return this.m_workbook},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"application",{get:function(){return this.workbook.application},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"runtime",{get:function(){return this.workbook._Runtime},enumerable:!0,configurable:!0}),n}(OfficeCore.RequestContext);e.RequestContext=g;var h=function(){function e(){}return e.enableMacroRecordingEvent=function(e){OfficeExtension._internalConfig.appendTypeNameToObjectPathInfo=!0;var t=function(e){return e.requestHeaders[OfficeExtension.Constants.officeScriptFireRecordingEvent]="true",e.workbook.onRecordingStateChangedEvent.add((function(e){return OfficeExtension._internalConfig.appendTypeNameToObjectPathInfo=e.recording,OfficeExtension.Utility._createPromiseFromResult(null)})),OfficeExtension.Utility._createPromiseFromResult(null)};return null!=e?t(e):y((function(e){return t(e)}))},e}();function m(e,t){var n=e;n.delayForCellEdit&&OfficeExtension.CommonUtility.isSetSupported("DelayForCellEdit")?t._requestFlagModifier|=64:t._requestFlagModifier&=-65,n._makerSafe&&(t._requestFlagModifier|=1024)}function y(t,n){return OfficeExtension.ClientRequestContext._runBatch("Excel.run",arguments,(function(t){return new e.RequestContext(t)}),m)}function v(e){var t={BindingColumnCount:e.bindingColumnCount,BindingId:e.bindingId,BindingRowCount:e.bindingRowCount,bindingType:e.bindingType,HasHeaders:e.hasHeaders};return window.OSF.DDA.OMFactory.manufactureBinding(t,window.Microsoft.Office.WebExtension.context.document)}function b(e,t){var n;return n=null==e.headers?e.rows:e,void 0===(n=window.OSF.DDA.DataCoercion.coerceData(n,t[window.Microsoft.Office.WebExtension.Parameters.CoercionType]))?null:n}function C(e){if(!("undefined"!=typeof window&&window.Office&&window.Office.context&&window.Office.context.diagnostics&&window.Office.context.diagnostics.version))return!1;var t=window.Office.context.diagnostics.platform.toLowerCase();if("officeonline"===t)return!1;var n=e[t];null==n&&(n=e.general);var r=window.Office.context.diagnostics.version,o=/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/.exec(r);if(o){var i=parseInt(o[1]),a=parseInt(o[2]),s=parseInt(o[3]);if(i<n.desiredMajor)return!0;if(i===n.desiredMajor&&a<n.desiredMinor)return!0;if(i===n.desiredMajor&&a===n.desiredMinor&&s<n.desiredBuild){var c=o[4];if(/^3\d\d\d+$/.exec(c))return!0}}return!1}e.Recorder=h,e.run=y,e.runBatch=function(t,n){return OfficeExtension.ClientRequestContext._runExplicitBatch("Excel.runBatch",arguments,(function(t){return new e.RequestContext(t)}),m)},e._RedirectV1APIs=!1,e._V1APIMap={GetDataAsync:{call:function(e,t){return e.workbook._V1Api.bindingGetData(t)},postprocess:b},GetSelectedDataAsync:{call:function(e,t){return e.workbook._V1Api.getSelectedData(t)},postprocess:b},GoToByIdAsync:{call:function(e,t){return e.workbook._V1Api.gotoById(t)}},AddColumnsAsync:{call:function(e,t){return e.workbook._V1Api.bindingAddColumns(t)}},AddFromSelectionAsync:{call:function(e,t){return e.workbook._V1Api.bindingAddFromSelection(t)},postprocess:v},AddFromNamedItemAsync:{call:function(e,t){return e.workbook._V1Api.bindingAddFromNamedItem(t)},postprocess:v},AddFromPromptAsync:{call:function(e,t){return C({ios:{desiredMajor:2,desiredMinor:20,desiredBuild:0}})&&OfficeExtension.CommonUtility.isSetSupported("DelayForCellEdit")&&(e._requestFlagModifier|=64),e.workbook._V1Api.bindingAddFromPrompt(t)},postprocess:v},AddRowsAsync:{call:function(e,t){return e.workbook._V1Api.bindingAddRows(t)}},GetByIdAsync:{call:function(e,t){return e.workbook._V1Api.bindingGetById(t)},postprocess:v},ReleaseByIdAsync:{call:function(e,t){return e.workbook._V1Api.bindingReleaseById(t)}},GetAllAsync:{call:function(e){return e.workbook._V1Api.bindingGetAll()},postprocess:function(e){return e.bindings.map((function(e){return v(e)}))}},DeleteAllDataValuesAsync:{call:function(e,t){return e.workbook._V1Api.bindingDeleteAllDataValues(t)}},SetSelectedDataAsync:{preprocess:function(e){var t=e.cellFormat;return"undefined"!=typeof window&&window.OSF.DDA.SafeArray?window.OSF.OUtil.listContainsKey(window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)):"undefined"!=typeof window&&window.OSF.DDA.WAC&&window.OSF.OUtil.listContainsKey(window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)),e},call:function(e,t){return e.workbook._V1Api.setSelectedData(t)}},SetDataAsync:{preprocess:function(e){var t=e.cellFormat;return"undefined"!=typeof window&&window.OSF.DDA.SafeArray?window.OSF.OUtil.listContainsKey(window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)):"undefined"!=typeof window&&window.OSF.DDA.WAC&&window.OSF.OUtil.listContainsKey(window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)),e},call:function(e,t){return e.workbook._V1Api.bindingSetData(t)}},SetFormatsAsync:{preprocess:function(e){var t=e.cellFormat;return"undefined"!=typeof window&&window.OSF.DDA.SafeArray?window.OSF.OUtil.listContainsKey(window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.SafeArray.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)):"undefined"!=typeof window&&window.OSF.DDA.WAC&&window.OSF.OUtil.listContainsKey(window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes,"cellFormat")&&(e.cellFormat=window.OSF.DDA.WAC.Delegate.ParameterMap.dynamicTypes.cellFormat.toHost(t)),e},call:function(e,t){return e.workbook._V1Api.bindingSetFormats(t)}},SetTableOptionsAsync:{call:function(e,t){return e.workbook._V1Api.bindingSetTableOptions(t)}},ClearFormatsAsync:{call:function(e,t){return e.workbook._V1Api.bindingClearFormats(t)}},GetFilePropertiesAsync:{call:function(e){return e.workbook._V1Api.getFilePropertiesAsync()}}};!function(e){e.office10EventIdBindingSelectionChangedEvent=3,e.office10EventIdBindingDataChangedEvent=4,e.office10EventIdDocumentSelectionChangedEvent=2,e.office10EventIdRichApiMessageEvent=5,e.office10EventIdSettingsChangedEvent=1}(e._CC||(e._CC={}));var _="Excel",O="ExcelApi",S=(OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject),A=(OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject),E=(OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),P=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty),R=OfficeExtension.Utility.isNullOrUndefined,T=OfficeExtension.Utility.isUndefined,I=(OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported),w=OfficeExtension.Utility.load,F=(OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags),D=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),e}();e.RangeValuesPreviewCustom=D,function(e){e.Application_SuspendApiCalculationUntilNextSync=function(e){return f("Mac")&&u(1.6)&&!u(1.7)?{handled:!0}:{handled:!1}}}(e._CC||(e._CC={})),function(t){t.Workbook_EnableOfficeScriptRecording=function(e,t){return this.context.eventId=t,{handled:!1}},t.Workbook_RecordAction=function(e,t){return this.context.sdxPayload=t,{handled:!1}},t.Workbook_SelectionChanged_EventArgsTransform=function(e,t){return{workbook:e}},t.Workbook_WACOperationEvent_EventArgsTransform=function(t,n){return{eventId:n.eventId,payload:n.payload,type:e.EventType.wacoperationEvent}},t.Workbook__Message_EventArgsTransform=function(e,t){return{entries:t.entries,workbook:e}}}(e._CC||(e._CC={})),function(t){t.Worksheet_Charts_Get=function(e,t){t._ParentObject=e},t.Worksheet_Comments_Get=function(e,t){t._ParentObject=e},t.Worksheet_Names_Get=function(e,t){t._ParentObject=e},t.Worksheet_PivotTables_Get=function(e,t){t._ParentObject=e},t.Worksheet_RangeValuesPreview_Get=function(e,t){t._ParentObject=e},t.Worksheet_Shapes_Get=function(e,t){t._ParentObject=e},t.Worksheet_ShowGridlines_Set=function(e,t){return e.m_showGridlines=t,P(e,"Gridlines",t,F(2,"ExcelApiUndo","1.16")),{handled:!0}},t.Worksheet_ShowHeadings_Set=function(e,t){return e.m_showHeadings=t,P(e,"Headings",t,F(2,"ExcelApiUndo","1.30")),{handled:!0}},t.Worksheet_Tables_Get=function(e,t){t._ParentObject=e},t.Worksheet_Visuals_Get=function(e,t){t._ParentObject=e},t.Worksheet_Changed_EventArgsTransform=function(t,n){var r,o,i,a,s=n;return null==s.valueBefore&&null==s.valueAfter||(r={valueBefore:s.valueBefore,valueAfter:s.valueAfter,valueTypeBefore:s.valueTypeBefore,valueTypeAfter:s.valueTypeAfter,valueAsJsonBefore:s.valueAsJsonBefore,valueAsJsonAfter:s.valueAsJsonAfter}),s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellLeft?o=e.DeleteShiftDirection.left:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellUp?o=e.DeleteShiftDirection.up:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellRight?i=e.InsertShiftDirection.right:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellDown&&(i=e.InsertShiftDirection.down),s.shiftDirection!=e.InsertDeleteCellsShiftDirection.none&&(a={deleteShiftDirection:o,insertShiftDirection:i}),{type:e.EventType.worksheetChanged,changeType:s.changeType,source:s.source,worksheetId:t.id,address:s.address,getRange:function(e){return I("WorksheetChangedEventArgs.getRange",O,"1.8",_),e.workbook._GetRangeForEventByReferenceId(s.referenceId)},getRangeOrNullObject:function(e){return I("WorksheetChangedEventArgs.getRangeOrNullObject",O,"1.8",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(s.referenceId)},details:r,triggerSource:s.triggerSource,changeDirectionState:a}},t.Worksheet_FormatChanged_EventArgsTransform=function(t,n){var r=n;return{type:e.EventType.worksheetFormatChanged,source:r.source,worksheetId:t.id,address:r.address,getRange:function(e){return I("WorksheetFormatChangedEventArgs.getRange",O,"1.9",_),e.workbook._GetRangeForEventByReferenceId(r.referenceId)},getRangeOrNullObject:function(e){return I("WorksheetFormatChangedEventArgs.getRangeOrNullObject",O,"1.9",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(r.referenceId)}}},t.Worksheet_FormulaChanged_EventArgsTransform=function(t,n){var r,o=n;return null!=o.formulaDetails&&(r=o.formulaDetails),{type:e.EventType.worksheetFormulaChanged,source:o.source,worksheetId:o.worksheetId,formulaDetails:r}}}(e._CC||(e._CC={})),function(t){function n(e,t,n){return!f("OfficeOnline")&&!u(1.12)||f("OfficeOnline")&&!u(1.11)?(I("WorksheetCollection."+t,O,n,_),E(e,t,0,[],0,0),{handled:!0}):{handled:!1}}t.WorksheetCollection__RegisterActivatedEvent=function(e){return u(1.9)?{handled:!1}:(I("WorksheetCollection._RegisterActivatedEvent",O,"1.7",_),E(e,"_RegisterActivatedEvent",0,[],0,0),{handled:!0})},t.WorksheetCollection__RegisterAddedEvent=function(e){return n(e,"_RegisterAddedEvent","1.7")},t.WorksheetCollection__RegisterColumnSortedEvent=function(e){return n(e,"_RegisterColumnSortedEvent","1.10")},t.WorksheetCollection__RegisterDataChangedEvent=function(e){return n(e,"_RegisterDataChangedEvent","1.9")},t.WorksheetCollection__RegisterDeletedEvent=function(e){return n(e,"_RegisterDeletedEvent","1.7")},t.WorksheetCollection__RegisterRowSortedEvent=function(e){return n(e,"_RegisterRowSortedEvent","1.10")},t.WorksheetCollection__UnregisterAddedEvent=function(e){return n(e,"_UnregisterAddedEvent","1.7")},t.WorksheetCollection__UnregisterColumnSortedEvent=function(e){return n(e,"_UnregisterColumnSortedEvent","1.10")},t.WorksheetCollection__UnregisterDataChangedEvent=function(e){return n(e,"_UnregisterDataChangedEvent","1.9")},t.WorksheetCollection__UnregisterDeletedEvent=function(e){return n(e,"_UnregisterDeletedEvent","1.7")},t.WorksheetCollection__UnregisterRowSortedEvent=function(e){return n(e,"_UnregisterRowSortedEvent","1.10")},t.WorksheetCollection_Changed_EventArgsTransform=function(t,n){var r,o,i,a,s=n;return null==s.valueBefore&&null==s.valueAfter||(r={valueBefore:s.valueBefore,valueAfter:s.valueAfter,valueTypeBefore:s.valueTypeBefore,valueTypeAfter:s.valueTypeAfter,valueAsJsonBefore:s.valueAsJsonBefore,valueAsJsonAfter:s.valueAsJsonAfter}),s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellLeft?o=e.DeleteShiftDirection.left:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellUp?o=e.DeleteShiftDirection.up:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellRight?i=e.InsertShiftDirection.right:s.shiftDirection==e.InsertDeleteCellsShiftDirection.shiftCellDown&&(i=e.InsertShiftDirection.down),s.shiftDirection!=e.InsertDeleteCellsShiftDirection.none&&(a={deleteShiftDirection:o,insertShiftDirection:i}),{type:e.EventType.worksheetChanged,changeType:s.changeType,source:s.source,worksheetId:s.worksheetId,address:s.address,getRange:function(e){return I("WorksheetChangedEventArgs.getRange",O,"1.9",_),e.workbook._GetRangeForEventByReferenceId(s.referenceId)},getRangeOrNullObject:function(e){return I("WorksheetChangedEventArgs.getRangeOrNullObject",O,"1.9",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(s.referenceId)},details:r,triggerSource:s.triggerSource,changeDirectionState:a}},t.WorksheetCollection_FormatChanged_EventArgsTransform=function(t,n){var r=n;return{type:e.EventType.worksheetFormatChanged,source:r.source,worksheetId:r.worksheetId,address:r.address,getRange:function(e){return I("WorksheetFormatChangedEventArgs.getRange",O,"1.9",_),e.workbook._GetRangeForEventByReferenceId(r.referenceId)},getRangeOrNullObject:function(e){return I("WorksheetFormatChangedEventArgs.getRangeOrNullObject",O,"1.9",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(r.referenceId)}}},t.WorksheetCollection_FormulaChanged_EventArgsTransform=function(t,n){var r,o=n;return null!=o.formulaDetails&&(r=o.formulaDetails),{type:e.EventType.worksheetFormulaChanged,source:o.source,worksheetId:o.worksheetId,formulaDetails:r}}}(e._CC||(e._CC={})),function(e){e.WorksheetProtection_Protect=function(e,t,n){return C({mac:{desiredMajor:16,desiredMinor:7,desiredBuild:17101600},ios:{desiredMajor:2,desiredMinor:7,desiredBuild:1016},general:{desiredMajor:16,desiredMinor:0,desiredBuild:8716}})?(E(e,"Protect",0,[t],0,0),{handled:!0}):{handled:!1}}}(e._CC||(e._CC={}));var x=function(){function t(){}return t.prototype._ensureInteger=function(t,n){"number"==typeof t&&isFinite(t)&&Math.floor(t)===t||OfficeExtension.Utility.throwError(e.ErrorCodes.invalidArgument,t,n)},t.prototype._getAdjacentRange=function(e,t,n,r,o){var i;null==t&&(t=1),this._ensureInteger(t,e);var a=0,s=0;return t>0?i=n.getOffsetRange(r,o):(i=n,a=r,s=o),1===Math.abs(t)?i:i.getBoundingRect(n.getOffsetRange(r*t+a,o*t+s))},t}();e.RangeCustom=x,function(t){t.Range_HandleResult=function(e,t){T(t.isEntireColumn)||(e.m_isEntireColumn=t.isEntireColumn),T(t.isEntireRow)||(e.m_isEntireRow=t.isEntireRow)},t.Range_GetColumnsAfter=function(t,n){return d()?{handled:!1,result:null}:(null==n&&(n=1),t._ensureInteger(n,"RowsAbove"),0===n&&OfficeExtension.Utility.throwError(e.ErrorCodes.invalidArgument,"count","RowsAbove"),{handled:!0,result:t._getAdjacentRange("getColumnsAfter",n,t.getLastColumn(),0,1)})},t.Range_GetColumnsBefore=function(t,n){return d()?{handled:!1,result:null}:(null==n&&(n=1),t._ensureInteger(n,"RowsAbove"),0===n&&OfficeExtension.Utility.throwError(e.ErrorCodes.invalidArgument,"count","RowsAbove"),{handled:!0,result:t._getAdjacentRange("getColumnsBefore",n,t.getColumn(0),0,-1)})},t.Range_GetResizedRange=function(e,t,n){return d()?{handled:!1,result:null}:(e._ensureInteger(t,"getResizedRange"),e._ensureInteger(n,"getResizedRange"),{handled:!0,result:(t>=0&&n>=0?e:e.getCell(0,0)).getBoundingRect(e.getLastCell().getOffsetRange(t,n))})},t.Range_GetRowsAbove=function(t,n){return d()?{handled:!1,result:null}:(null==n&&(n=1),t._ensureInteger(n,"RowsAbove"),0===n&&OfficeExtension.Utility.throwError(e.ErrorCodes.invalidArgument,"count","RowsAbove"),{handled:!0,result:t._getAdjacentRange("getRowsAbove",n,t.getRow(0),-1,0)})},t.Range_GetRowsBelow=function(t,n){return d()?{handled:!1,result:null}:(null==n&&(n=1),t._ensureInteger(n,"RowsAbove"),0===n&&OfficeExtension.Utility.throwError(e.ErrorCodes.invalidArgument,"count","RowsAbove"),{handled:!0,result:this._getAdjacentRange("getRowsBelow",n,t.getLastRow(),1,0)})},t.Range_Formulas_Set=function(e,t){return e.m_formulas=t,l(e,"Formulas",t)?{handled:!0}:{handled:!1}},t.Range_FormulasLocal_Set=function(e,t){return e.m_formulasLocal=t,l(e,"FormulasLocal",t)?{handled:!0}:{handled:!1}},t.Range_FormulasR1C1_Set=function(e,t){return e.m_formulasR1C1=t,l(e,"FormulasR1C1",t)?{handled:!0}:{handled:!1}},t.Range_NumberFormat_Set=function(e,t){return e.m_numberFormat=t,l(e,"NumberFormat",t,F(2,"ExcelApiUndo","1.7"))?{handled:!0}:{handled:!1}},t.Range_Values_Set=function(e,t){return e.m_values=t,l(e,"Values",t,F(2,"ExcelApiUndo","1.7"))?{handled:!0}:{handled:!1}},t.Range_ValuesAsJson_Set=function(e,t){return e.m_valuesAsJson=t,l(e,"ValuesAsJson",t,F(2,"ExcelApiUndo","1.7"))?{handled:!0}:{handled:!1}},t.Range_ValuesAsJsonLocal_Set=function(e,t){return e.m_valuesAsJsonLocal=t,l(e,"ValuesAsJsonLocal",t,F(2,"ExcelApiUndo","1.7"))?{handled:!0}:{handled:!1}}}(e._CC||(e._CC={})),function(t){t.SettingCollection_Add=function(n,r,o){return o=t._replaceDateWithStringDate(o),{handled:!0,result:S(e.Setting,n,"Add",0,[r,o],!1,!0,null,0)}},t.SettingCollection_SettingsChanged_EventArgsTransform=function(e,t){return{settings:e}}}(e._CC||(e._CC={})),function(e){var t="Date(";function n(e){var n=JSON.stringify(e,(function(e,n){return this[e]instanceof Date?t+this[e].getTime()+")":n}));return e=JSON.parse(n)}e._replaceDateWithStringDate=n,e.Setting_HandleResult=function(e,n){T(n.Value)||(n.Value=function(e){var n=JSON.stringify(e);return JSON.parse(n,(function(e,n){var r;return"string"==typeof n&&n&&n.length>6&&n.slice(0,5)===t&&")"===n.slice(-1)&&(r=new Date(parseInt(n.slice(5,-1))))?r:n}))}(n.Value))},e.Setting_Value_Set=function(e,t){if(!R(t)){e.m_value=t;var r=n(t);return P(e,"Value",r,0),{handled:!0}}return{handled:!1}}}(e._CC||(e._CC={}));var k=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_eventTargetId",{get:function(){return this._ParentObject?this._ParentObject.id:OfficeExtension.Constants.eventWorkbookId},enumerable:!0,configurable:!0}),e}();e.NamedItemCollectionCustom=k,function(e){e.Binding_DataChanged_EventArgsTransform=function(e,t){return{binding:e}},e.Binding_SelectionChanged_EventArgsTransform=function(e,t){return{binding:e,columnCount:t.columnCount,rowCount:t.rowCount,startColumn:t.startColumn,startRow:t.startRow}}}(e._CC||(e._CC={}));var N=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_eventTargetId",{get:function(){return this._ParentObject?this._ParentObject.id:OfficeExtension.Constants.eventWorkbookId},enumerable:!0,configurable:!0}),e}();e.TableCollectionCustom=N,function(t){t.TableCollection_Changed_EventArgsTransform=function(t,n){var r,o=n;return null==o.valueBefore&&null==o.valueAfter||(r={valueBefore:o.valueBefore,valueAfter:o.valueAfter,valueTypeBefore:o.valueTypeBefore,valueTypeAfter:o.valueTypeAfter,valueAsJsonBefore:o.valueAsJsonBefore,valueAsJsonAfter:o.valueAsJsonAfter}),{type:e.EventType.tableChanged,changeType:o.changeType,source:o.source,worksheetId:o.worksheetId,tableId:o.tableId,address:o.address,getRange:function(e){return I("TableChangedEventArgs.getRange",O,"1.8",_),e.workbook._GetRangeForEventByReferenceId(o.referenceId)},getRangeOrNullObject:function(e){return I("TableChangedEventArgs.getRangeOrNullObject",O,"1.8",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(o.referenceId)},details:r}}}(e._CC||(e._CC={})),function(t){t.Table_HandleIdResult=function(e,t){T(t.Id)||(t.Id=t.Id.toString())},t.Table_HandleResult=function(e,t){T(t.Id)||(t.Id=t.Id.toString())},t.Table_Changed_EventArgsTransform=function(t,n){var r,o=n;return null==o.valueBefore&&null==o.valueAfter||(r={valueBefore:o.valueBefore,valueAfter:o.valueAfter,valueTypeBefore:o.valueTypeBefore,valueTypeAfter:o.valueTypeAfter,valueAsJsonBefore:o.valueAsJsonBefore,valueAsJsonAfter:o.valueAsJsonAfter}),{type:e.EventType.tableChanged,changeType:o.changeType,source:o.source,worksheetId:o.worksheetId,tableId:o.tableId,address:o.address,getRange:function(e){return I("TableChangedEventArgs.getRange",O,"1.8",_),e.workbook._GetRangeForEventByReferenceId(o.referenceId)},getRangeOrNullObject:function(e){return I("TableChangedEventArgs.getRangeOrNullObject",O,"1.8",_),e.workbook._GetRangeOrNullObjectForEventByReferenceId(o.referenceId)},details:r}},t.Table_SelectionChanged_EventArgsTransform=function(t,n){var r=n,o=!r.address||0===r.address.length;return{type:e.EventType.tableSelectionChanged,isInsideTable:!o,worksheetId:r.worksheetId,tableId:t.id,address:r.address}}}(e._CC||(e._CC={}));var M=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),e}();e.ChartCollectionCustom=M,function(t){t.ChartCollection_Add=function(t,n,r,o){if(!(r instanceof e.Range))throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ResourceStrings.invalidArgument,"sourceData","Charts.Add");return{handled:!1,result:null}}}(e._CC||(e._CC={})),function(t){t.Chart_SetData=function(t,n,r){if(!(n instanceof e.Range))throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ResourceStrings.invalidArgument,"sourceData","Chart.setData");return{handled:!1}}}(e._CC||(e._CC={}));var H=function(){function e(){}return e.prototype.load=function(e){return w(this,e),this},e}();e.ChartFillCustom=H;var U=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),e}();e.VisualCollectionCustom=U,function(e){e.VisualCollection_AgaveVisualUpdate_EventArgsTransform=function(e,t){var n=t;return{type:n.type,payload:n.payload}}}(e._CC||(e._CC={})),function(t){t.Visual_ChangeNotification_EventArgsTransform=function(t,n){var r=n;return{targetId:r.targetId,changeType:r.changeType,payload:r.payload,type:e.EventType.visualChange}}}(e._CC||(e._CC={}));var j=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_eventTargetId",{get:function(){return this._ParentObject?this._ParentObject.id:OfficeExtension.Constants.eventWorkbookId},enumerable:!0,configurable:!0}),e}();e.PivotTableCollectionCustom=j,function(t){t.PivotLayout_GetColumnLabelRange=function(t){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:{handled:!0,result:S(e.Range,t,"GetColumnLabelRange",0,[],!1,!1,null,0)}},t.PivotLayout_GetDataBodyRange=function(t){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:{handled:!0,result:S(e.Range,t,"GetDataBodyRange",0,[],!1,!1,null,0)}},t.PivotLayout_GetDataHierarchy=function(t,n){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:(I("PivotLayout.getDataHierarchy",O,"1.9",_),{handled:!0,result:S(e.DataPivotHierarchy,t,"GetDataHierarchy",0,[n],!1,!1,null,0)})},t.PivotLayout_GetFilterAxisRange=function(t){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:{handled:!0,result:S(e.Range,t,"GetFilterAxisRange",0,[],!1,!1,null,0)}},t.PivotLayout_GetRange=function(t){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:{handled:!0,result:S(e.Range,t,"GetRange",0,[],!1,!1,null,0)}},t.PivotLayout_GetRowLabelRange=function(t){return OfficeExtension.Utility.isSetSupported("Pivot","1.5")?{handled:!1,result:void 0}:{handled:!0,result:S(e.Range,t,"GetRowLabelRange",0,[],!1,!1,null,0)}}}(e._CC||(e._CC={})),function(e){e.PivotField_SortByLabels=function(e,t){return"string"==typeof t&&(t="ascending"===t.toLowerCase()),E(e,"SortByLabels",0,[t],F(2,"ExcelApiUndo","1.1"),0),{handled:!0}}}(e._CC||(e._CC={})),function(t){t.NumberFormattingService_GetFormatter=function(t,n){return OfficeExtension.Utility.isSetSupported("NumberFormatting","1.2")?{handled:!1,result:void 0}:(I("NumberFormatting.GetFormatter","NumberFormatting","1.1",_),{handled:!0,result:S(e.NumberFormatter,t,"GetFormatter",0,[n],!1,!1,null,0)})}}(e._CC||(e._CC={})),function(e){e.NumberFormatter_Format=function(e,t){return OfficeExtension.Utility.isSetSupported("NumberFormatting","1.2")?{handled:!1,result:void 0}:(I("NumberFormatter.Format","NumberFormatting","1.1",_),{handled:!0,result:E(e,"Format",0,[t],0,0)})}}(e._CC||(e._CC={}));var L=function(){function n(){}return n.register=function(n,r){return I("CustomFunctionManager.register","CustomFunctions","1.3",_),t({delayForCellEdit:!0},(function(t){return e.CustomFunctionManager.newObject(t).register(n,r)}))},n.getStatus=function(){return I("CustomFunctionManager.register","CustomFunctions","1.3",_),t({delayForCellEdit:!0},(function(t){var n=e.CustomFunctionManager.newObject(t).load("status");return t.sync().then((function(){return n.status}))}))},n}();e.CustomFunctionManagerCustom=L,function(e){e.CustomFunctionManager_StaticCustomize=function(e){e.register=L.register,e.getStatus=L.getStatus}}(e._CC||(e._CC={})),function(e){e.Style_TextOrientation_Set=function(e,t){return e.m_textOrientation=t,P(e,"Orientation",t,0),{handled:!0}}}(e._CC||(e._CC={})),function(e){e.InternalTest_Test1Event_EventArgsTransform=function(e,t){var n=t;return{prop1:n.prop1,worksheet:e.context.workbook.worksheets.getItem(n.worksheetId)}},e.InternalTest_TestEvent_EventArgsTransform=function(e,t){var n=t;return{prop1:n.prop1,worksheet:e.context.workbook.worksheets.getItem(n.worksheetId)}}}(e._CC||(e._CC={}));var B=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_eventTargetId",{get:function(){return this._ParentObject?this._ParentObject.id:OfficeExtension.Constants.eventWorkbookId},enumerable:!0,configurable:!0}),e}();e.CommentCollectionCustom=B;var W,V=function(){function e(){}return Object.defineProperty(e.prototype,"_ParentObject",{get:function(){return this.m__ParentObject},set:function(e){this.m__ParentObject=e},enumerable:!0,configurable:!0}),e}();e.ShapeCollectionCustom=V,function(e){e.accessDenied="AccessDenied",e.apiNotFound="ApiNotFound",e.conflict="Conflict",e.emptyChartSeries="EmptyChartSeries",e.filteredRangeConflict="FilteredRangeConflict",e.formulaLengthExceedsLimit="FormulaLengthExceedsLimit",e.generalException="GeneralException",e.inactiveWorkbook="InactiveWorkbook",e.insertDeleteConflict="InsertDeleteConflict",e.invalidArgument="InvalidArgument",e.invalidBinding="InvalidBinding",e.invalidOperation="InvalidOperation",e.invalidReference="InvalidReference",e.invalidSelection="InvalidSelection",e.itemAlreadyExists="ItemAlreadyExists",e.itemNotFound="ItemNotFound",e.mergedRangeConflict="MergedRangeConflict",e.nonBlankCellOffSheet="NonBlankCellOffSheet",e.notImplemented="NotImplemented",e.openWorkbookLinksBlocked="OpenWorkbookLinksBlocked",e.operationCellsExceedLimit="OperationCellsExceedLimit",e.pivotTableRangeConflict="PivotTableRangeConflict",e.powerQueryRefreshResourceChallenge="PowerQueryRefreshResourceChallenge",e.rangeExceedsLimit="RangeExceedsLimit",e.refreshWorkbookLinksBlocked="RefreshWorkbookLinksBlocked",e.requestAborted="RequestAborted",e.responsePayloadSizeLimitExceeded="ResponsePayloadSizeLimitExceeded",e.unsupportedFeature="UnsupportedFeature",e.unsupportedFillType="UnsupportedFillType",e.unsupportedOperation="UnsupportedOperation",e.unsupportedSheet="UnsupportedSheet",e.invalidOperationInCellEditMode="InvalidOperationInCellEditMode"}(W=e.ErrorCodes||(e.ErrorCodes={})),e.Interfaces||(e.Interfaces={});new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"Excel",defaultApiSetName:"ExcelApi",hostName:"Excel",apiSets:[["1.19","ExcelApiUndo"],["1.1","Recorder"],["1.23","ExcelApiUndo"],["1.18"],["99.9"],["1.20","ExcelApiUndo"],["1.30","ExcelApiUndo"],["1.32","ExcelApiUndo"],["1.4","ExcelApiUndo"],["1.8"],["1.9"],["1.11"],["1.6"],["1.6","ExcelApiUndo"],["1.7"],["1.1","ExcelApiUndo"],["1.2"],["1.3"],["1.4"],["1.5"],["1.10"],["1.14"],["1.1","ExcelApiOnline"],["1.1","Experiment52"],["1.1","CustomFunctions"],["1.1","WACOperationEvents"],["1.3","ExcelApiUndo"],["1.13"],["1.16"],["1.3","Experiment52"],["1.8","ExcelApiUndo"],["1.16","ExcelApiUndo"],["1.12"],["1.2","ExcelApiOnline"],["1.26","ExcelApiUndo"],["1.2","ExcelApiUndo"],["1.17"],["1.34","ExcelApiUndo"],["1.7","ExcelApiUndo"],["1.10","ExcelApiUndo"],["1.14","ExcelApiUndo"],["1.31","ExcelApiUndo"],["1.15","ExcelApiUndo"],["1.22","ExcelApiUndo"],["1.15"],["1.24","ExcelApiUndo"],["1.17","ExcelApiUndo"],["99.99","ExcelApiUndo"],["1.2","Experiment52"],["1.25","ExcelApiUndo"],["1.9","ExcelApiUndo"],["1.11","ExcelApiUndo"],["1.35","ExcelApiUndo"],["1.21","ExcelApiUndo"],["1.12","ExcelApiUndo"],["1.13","ExcelApiUndo"],["1.27","ExcelApiUndo"],["1.18","ExcelApiUndo"],["1.28","ExcelApiUndo"],["1.29","ExcelApiUndo"],["1.33","ExcelApiUndo"]],strings:[],enumTypes:[["PowerQueryObjectType",["connectionOnly","table"]],["CurrencyNegative",["parenthesis","lead","internal","trail"]],["DateOrder",["monthDayYear","dayMonthYear","yearMonthDay","monthYearDay","dayYearMonth","yearDayMonth"]],["ExternalCodeServiceEnvironmentDefinitionUpdateReason",["userCommit","coAuth","automation","resetToDefault","initialChange"]],["ExternalCodeServiceInitializationResponseStatus",["success","failedWithLocalSave","fail"]],["ExternalCodeServiceAutoShowDiagnostics",["enabled","disabled"]],["UndoChangeType",["undoAction","redoAction","undoOrRedoCleared","undoGroupAdded"]],["SDX",["guidedReapply"]],["BusinessBarEntryType",[],{officeScriptsRunningStatus:0}],["FormulaReferenceStyle",["a1","r1C1"]],["NavigationObjectType",["table","pivotTable","chart","shape","namedRange"]],["UserActivityType",["none","insertSheet","deleteSheet","renameSheet","changeCell","insertRow","insertColumn","deleteRow","deleteColumn","insertPartialRow","insertPartialColumn","insertPartialColumnRightToLeft","deletePartialRow","deletePartialColumn","deletePartialColumnRightToLeft","move","sort","mergeCells","unmergeCells","unknownOperation","genericEdit"]],["LineageEndOfLogStatus",["loadInProgress","success","endOfLog","purged","trimmed","unsupported","cleared","error"]],["LineageLoadType",["new","next","previous","latest"]],["LoadToType",["connectionOnly","table","pivotTable","pivotChart"]],["QueryError",["unknown","none","failedLoadToWorksheet","failedLoadToDataModel","failedDownload","failedToCompleteDownload"]],["RangeOptimizationType",["other","numberFormat","textAlignment","textProperties","cellBorder","fillColor","sheetProtection","rowHeight","rowVisibility"]],["WorkbookLinksHardToFindMessages",["none","containsDefinedNames","hiddenOrVeryHiddenSheet","hiddenFloatingObjects","lockedFloatingObjectsThroughVba","protectedSheet","containsConditionalFormatting","containsDataValidation","hiddenRowsAndColumns"]],["WorkbookLinksIconState",["ok","moreInfo","warning"]],["WorkbookLinksRefreshSettings",["ask","always","never"]],["WorkbookConditionalFormattingRulesManagerScope",["defaultScope","selectedRange","activatedWorksheet","activatedTable","activatedPivotTable"]],["WorkbookLinksRefreshMode",["manual","automatic"]],["HelpTopic",["showChanges","guidedReapply","externalCodeServiceDiagnostics","pythonInExcelHelp","pythonInitializationHelp","pythonSupportedLibraries","guidedReapplyV2"]],["DocumentTaskChangeAction",[],{unknown:"unknown",create:"create",assign:"assign",unassign:"unassign",unassignAll:"unassignAll",setSchedule:"setSchedule",setPercentComplete:"setPercentComplete",setPriority:"setPriority",remove:"remove",restore:"restore",setTitle:"setTitle",undo:"undo"}],["DataSourceType",["unknown","cube","localRange","localTable","oledbDefault"]],["DateFilterCondition",["unknown","equals","before","beforeOrEqualTo","after","afterOrEqualTo","between","tomorrow","today","yesterday","nextWeek","thisWeek","lastWeek","nextMonth","thisMonth","lastMonth","nextQuarter","thisQuarter","lastQuarter","nextYear","thisYear","lastYear","yearToDate","allDatesInPeriodQuarter1","allDatesInPeriodQuarter2","allDatesInPeriodQuarter3","allDatesInPeriodQuarter4","allDatesInPeriodJanuary","allDatesInPeriodFebruary","allDatesInPeriodMarch","allDatesInPeriodApril","allDatesInPeriodMay","allDatesInPeriodJune","allDatesInPeriodJuly","allDatesInPeriodAugust","allDatesInPeriodSeptember","allDatesInPeriodOctober","allDatesInPeriodNovember","allDatesInPeriodDecember"]],["LabelFilterCondition",["unknown","equals","beginsWith","endsWith","contains","greaterThan","greaterThanOrEqualTo","lessThan","lessThanOrEqualTo","between"]],["PivotFilterType",["unknown","value","manual","label","date"]],["TopBottomSelectionType",["items","percent","sum"]],["ValueFilterCondition",["unknown","equals","greaterThan","greaterThanOrEqualTo","lessThan","lessThanOrEqualTo","between","topN","bottomN"]],["BuiltInPivotTableStyle",["none","light1","light2","light3","light4","light5","light6","light7","light8","light9","light10","light11","light12","light13","light14","light15","light16","light17","light18","light19","light20","light21","light22","light23","light24","light25","light26","light27","light28","medium1","medium2","medium3","medium4","medium5","medium6","medium7","medium8","medium9","medium10","medium11","medium12","medium13","medium14","medium15","medium16","medium17","medium18","medium19","medium20","medium21","medium22","medium23","medium24","medium25","medium26","medium27","medium28","dark1","dark2","dark3","dark4","dark5","dark6","dark7","dark8","dark9","dark10","dark11","dark12","dark13","dark14","dark15","dark16","dark17","dark18","dark19","dark20","dark21","dark22","dark23","dark24","dark25","dark26","dark27","dark28"]],["BuiltInSlicerStyle",["light1","light2","light3","light4","light5","light6","other1","other2","dark1","dark2","dark3","dark4","dark5","dark6"]],["BuiltInTableStyle",["light1","light2","light3","light4","light5","light6","light7","light8","light9","light10","light11","light12","light13","light14","light15","light16","light17","light18","light19","light20","light21","medium1","medium2","medium3","medium4","medium5","medium6","medium7","medium8","medium9","medium10","medium11","medium12","medium13","medium14","medium15","medium16","medium17","medium18","medium19","medium20","medium21","medium22","medium23","medium24","medium25","medium26","medium27","medium28","dark1","dark2","dark3","dark4","dark5","dark6","dark7","dark8","dark9","dark10","dark11"]],["ChartSeriesDimension",["categories","values","bubbleSizes"],{xvalues:"XValues",yvalues:"YValues"}],["CellControlType",["unknown","empty","mixed","checkbox"]],["PivotTableDateGroupBy",["invalid","bySeconds","byMinutes","byHours","byDays","byMonths","byQuarters","byYears"]],["PivotFilterTopBottomCriterion",["invalid","topItems","topPercent","topSum","bottomItems","bottomPercent","bottomSum"]],["SortBy",["ascending","descending"]],["AggregationFunction",["unknown","automatic","sum","count","average","max","min","product","countNumbers","standardDeviation","standardDeviationP","variance","varianceP"]],["ShowAsCalculation",["unknown","none","percentOfGrandTotal","percentOfRowTotal","percentOfColumnTotal","percentOfParentRowTotal","percentOfParentColumnTotal","percentOfParentTotal","percentOf","runningTotal","percentRunningTotal","differenceFrom","percentDifferenceFrom","rankAscending","rankDecending","index"]],["PivotAxis",["unknown","row","column","data","filter"]],["LinkedDataTypeRefreshMode",["unknown","manual","onLoad","periodic"]],["LinkedEntityDataDomainRefreshMode",["unknown","manual","onLoad","periodic"]],["AxisType",["invalid","category","value","series"]],["AxisGroup",["primary","secondary"]],["AxisScaleType",["linear","logarithmic"]],["AxisCrosses",["automatic","maximum","minimum","custom"]],["AxisTickMark",["none","cross","inside","outside"]],["AxisTickLabelPosition",["nextToAxis","high","low","none"]],["TrendlineType",["linear","exponential","logarithmic","movingAverage","polynomial","power"]],["ChartAxisType",["invalid","category","value","series"]],["ChartAxisGroup",["primary","secondary"]],["ChartAxisScaleType",["linear","logarithmic"]],["ChartAxisPosition",["automatic","maximum","minimum","custom"]],["ChartAxisTickMark",["none","cross","inside","outside"]],["CalculationState",["done","calculating","pending"]],["ChartAxisTickLabelPosition",["nextToAxis","high","low","none"]],["ChartAxisDisplayUnit",["none","hundreds","thousands","tenThousands","hundredThousands","millions","tenMillions","hundredMillions","billions","trillions","custom"]],["ChartAxisTimeUnit",["days","months","years"]],["ChartBoxQuartileCalculation",["inclusive","exclusive"]],["ChartAxisCategoryType",["automatic","textAxis","dateAxis"]],["ChartBinType",["category","auto","binWidth","binCount"]],["ChartLineStyle",["none","continuous","dash","dashDot","dashDotDot","dot","grey25","grey50","grey75","automatic","roundDot"]],["ChartDataLabelPosition",["invalid","none","center","insideEnd","insideBase","outsideEnd","left","right","top","bottom","bestFit","callout"]],["ChartErrorBarsInclude",["both","minusValues","plusValues"]],["ChartErrorBarsType",["fixedValue","percent","stDev","stError","custom"]],["ChartMapAreaLevel",["automatic","dataOnly","city","county","state","country","continent","world"]],["ChartGradientStyle",["twoPhaseColor","threePhaseColor"]],["ChartGradientStyleType",["extremeValue","number","percent"]],["ChartTitlePosition",["automatic","top","bottom","left","right"]],["ChartLegendPosition",["invalid","top","bottom","left","right","corner","custom"]],["ChartMarkerStyle",["invalid","automatic","none","square","diamond","triangle","star","dot","dash","circle","plus","picture"],{x:"X"}],["ChartPlotAreaPosition",["automatic","custom"]],["ChartMapLabelStrategy",["none","bestFit","showAll"]],["ChartMapProjectionType",["automatic","mercator","miller","robinson","albers"]],["ChartParentLabelStrategy",["none","banner","overlapping"]],["ChartSeriesBy",["auto","columns","rows"]],["ChartDataSourceType",["localRange","externalRange","list","unknown"]],["ChartTextHorizontalAlignment",["center","left","right","justify","distributed"]],["ChartTextVerticalAlignment",["center","bottom","top","justify","distributed"]],["ChartTickLabelAlignment",["center","left","right"]],["ChartType",["invalid","columnClustered","columnStacked","columnStacked100","barClustered","barStacked","barStacked100","lineStacked","lineStacked100","lineMarkers","lineMarkersStacked","lineMarkersStacked100","pieOfPie","pieExploded","barOfPie","areaStacked","areaStacked100","doughnutExploded","radarMarkers","radarFilled","surface","surfaceWireframe","surfaceTopView","surfaceTopViewWireframe","bubble","bubble3DEffect","stockHLC","stockOHLC","stockVHLC","stockVOHLC","cylinderColClustered","cylinderColStacked","cylinderColStacked100","cylinderBarClustered","cylinderBarStacked","cylinderBarStacked100","cylinderCol","coneColClustered","coneColStacked","coneColStacked100","coneBarClustered","coneBarStacked","coneBarStacked100","coneCol","pyramidColClustered","pyramidColStacked","pyramidColStacked100","pyramidBarClustered","pyramidBarStacked","pyramidBarStacked100","pyramidCol","line","pie","area","doughnut","radar","histogram","boxwhisker","pareto","regionMap","treemap","waterfall","sunburst","funnel"],{_3DColumnClustered:"3DColumnClustered",_3DColumnStacked:"3DColumnStacked",_3DColumnStacked100:"3DColumnStacked100",_3DBarClustered:"3DBarClustered",_3DBarStacked:"3DBarStacked",_3DBarStacked100:"3DBarStacked100",_3DPieExploded:"3DPieExploded",xyscatterSmooth:"XYScatterSmooth",xyscatterSmoothNoMarkers:"XYScatterSmoothNoMarkers",xyscatterLines:"XYScatterLines",xyscatterLinesNoMarkers:"XYScatterLinesNoMarkers",_3DAreaStacked:"3DAreaStacked",_3DAreaStacked100:"3DAreaStacked100",_3DColumn:"3DColumn",_3DLine:"3DLine",_3DPie:"3DPie",xyscatter:"XYScatter",_3DArea:"3DArea"}],["ChartUnderlineStyle",["none","single"]],["ChartDisplayBlanksAs",["notPlotted","zero","interplotted"]],["ChartPlotBy",["rows","columns"]],["ChartSplitType",["splitByPosition","splitByValue","splitByPercentValue","splitByCustomSplit"]],["ChartColorScheme",["colorfulPalette1","colorfulPalette2","colorfulPalette3","colorfulPalette4","monochromaticPalette1","monochromaticPalette2","monochromaticPalette3","monochromaticPalette4","monochromaticPalette5","monochromaticPalette6","monochromaticPalette7","monochromaticPalette8","monochromaticPalette9","monochromaticPalette10","monochromaticPalette11","monochromaticPalette12","monochromaticPalette13"]],["ChartTrendlineType",["linear","exponential","logarithmic","movingAverage","polynomial","power"]],["ShapeZOrder",["bringToFront","bringForward","sendToBack","sendBackward"]],["ShapeType",["unsupported","image","geometricShape","group","line"]],["ShapeScaleType",["currentSize","originalSize"]],["ShapeScaleFrom",["scaleFromTopLeft","scaleFromMiddle","scaleFromBottomRight"]],["ShapeFillType",["noFill","solid","gradient","pattern","pictureAndTexture","mixed"]],["ShapeFontUnderlineStyle",["none","single","double","heavy","dotted","dottedHeavy","dash","dashHeavy","dashLong","dashLongHeavy","dotDash","dotDashHeavy","dotDotDash","dotDotDashHeavy","wavy","wavyHeavy","wavyDouble"]],["PictureFormat",[],{unknown:"UNKNOWN",bmp:"BMP",jpeg:"JPEG",gif:"GIF",png:"PNG",svg:"SVG"}],["ShapeLineStyle",["single","thickBetweenThin","thickThin","thinThick","thinThin"]],["ShapeLineDashStyle",["dash","dashDot","dashDotDot","longDash","longDashDot","roundDot","solid","squareDot","longDashDotDot","systemDash","systemDot","systemDashDot"]],["ArrowheadLength",["short","medium","long"]],["ArrowheadStyle",["none","triangle","stealth","diamond","oval","open"]],["ArrowheadWidth",["narrow","medium","wide"]],["PremiumLicenseName",["python"]],["BindingType",["range","table","text"]],["BorderIndex",["edgeTop","edgeBottom","edgeLeft","edgeRight","insideVertical","insideHorizontal","diagonalDown","diagonalUp"]],["BorderLineStyle",["none","continuous","dash","dashDot","dashDotDot","dot","double","slantDashDot"]],["BorderWeight",["hairline","thin","medium","thick"]],["CalculationMode",["automatic","automaticExceptTables","manual"]],["RuntimeCalculationMode",[],{undefined:0,automatic:1,automaticExceptTables:2,manual:3}],["CalculationType",["recalculate","full","fullRebuild"]],["ClearApplyTo",["all","formats","contents","hyperlinks","removeHyperlinks","resetContents"]],["VisualCategory",["column","bar","line","area","pie","donut","scatter","bubble","statistical","stock","combo","hierarchy","surface","map","funnel","radar","waterfall","threeD","other"]],["VisualPropertyType",["object","collection","string","double","int","bool","enum","color"]],["VisualChangeType",["dataChange","propertyChange","genericChange","selectionChange"]],["BoolMetaPropertyType",["writeOnly","readOnly","hideEntireSubtreeUI","hideMeButShowChildrenUI","expandableUI","nextPropOnSameLine","hideLabel","showResetUI","hasOwnExpandableSection","nextPropOnSameLineFOTP","showResetUIFOTP","untransferable","ignoreDuringChangeChartType","notTriviallyUndoable","volatileEnum","exceptionCollection","metaOnly","showHideCollection","errorMessage","infoMessage"]],["ConditionalDataBarAxisFormat",["automatic","none","cellMidPoint"]],["ConditionalDataBarDirection",["context","leftToRight","rightToLeft"]],["ConditionalFormatDirection",["top","bottom"]],["ConditionalFormatType",["custom","dataBar","colorScale","iconSet","topBottom","presetCriteria","containsText","cellValue"]],["ConditionalFormatRuleType",["invalid","automatic","lowestValue","highestValue","number","percent","formula","percentile"]],["ConditionalFormatIconRuleType",["invalid","number","percent","formula","percentile"]],["ConditionalFormatColorCriterionType",["invalid","lowestValue","highestValue","number","percent","formula","percentile"]],["ConditionalTopBottomCriterionType",["invalid","topItems","topPercent","bottomItems","bottomPercent"]],["ConditionalFormatPresetCriterion",["invalid","blanks","nonBlanks","errors","nonErrors","yesterday","today","tomorrow","lastSevenDays","lastWeek","thisWeek","nextWeek","lastMonth","thisMonth","nextMonth","aboveAverage","belowAverage","equalOrAboveAverage","equalOrBelowAverage","oneStdDevAboveAverage","oneStdDevBelowAverage","twoStdDevAboveAverage","twoStdDevBelowAverage","threeStdDevAboveAverage","threeStdDevBelowAverage","uniqueValues","duplicateValues"]],["ConditionalTextOperator",["invalid","contains","notContains","beginsWith","endsWith"]],["ConditionalCellValueOperator",["invalid","between","notBetween","equalTo","notEqualTo","greaterThan","lessThan","greaterThanOrEqual","lessThanOrEqual"]],["ConditionalIconCriterionOperator",["invalid","greaterThan","greaterThanOrEqual"]],["ConditionalRangeBorderIndex",["edgeTop","edgeBottom","edgeLeft","edgeRight"]],["ConditionalRangeBorderLineStyle",["none","continuous","dash","dashDot","dashDotDot","dot"]],["ConditionalRangeFontUnderlineStyle",["none","single","double"]],["CustomFunctionType",["invalid","script","webService"]],["CustomFunctionMetadataFormat",["invalid","openApi"]],["DataValidationType",["none","wholeNumber","decimal","list","date","time","textLength","custom","inconsistent","mixedCriteria"]],["DataValidationOperator",["between","notBetween","equalTo","notEqualTo","greaterThan","lessThan","greaterThanOrEqualTo","lessThanOrEqualTo"]],["DataValidationAlertStyle",["stop","warning","information"]],["DeleteShiftDirection",["up","left"]],["DynamicFilterCriteria",["unknown","aboveAverage","allDatesInPeriodApril","allDatesInPeriodAugust","allDatesInPeriodDecember","allDatesInPeriodFebruray","allDatesInPeriodJanuary","allDatesInPeriodJuly","allDatesInPeriodJune","allDatesInPeriodMarch","allDatesInPeriodMay","allDatesInPeriodNovember","allDatesInPeriodOctober","allDatesInPeriodQuarter1","allDatesInPeriodQuarter2","allDatesInPeriodQuarter3","allDatesInPeriodQuarter4","allDatesInPeriodSeptember","belowAverage","lastMonth","lastQuarter","lastWeek","lastYear","nextMonth","nextQuarter","nextWeek","nextYear","thisMonth","thisQuarter","thisWeek","thisYear","today","tomorrow","yearToDate","yesterday"]],["FilterDatetimeSpecificity",["year","month","day","hour","minute","second"]],["FilterOn",["bottomItems","bottomPercent","cellColor","dynamic","fontColor","values","topItems","topPercent","icon","custom"]],["FilterOperator",["and","or"]],["HorizontalAlignment",["general","left","center","right","fill","justify","centerAcrossSelection","distributed"]],["IconSet",["invalid","threeArrows","threeArrowsGray","threeFlags","threeTrafficLights1","threeTrafficLights2","threeSigns","threeSymbols","threeSymbols2","fourArrows","fourArrowsGray","fourRedToBlack","fourRating","fourTrafficLights","fiveArrows","fiveArrowsGray","fiveRating","fiveQuarters","threeStars","threeTriangles","fiveBoxes"]],["ImageFittingMode",["fit","fitAndCenter","fill"]],["InsertShiftDirection",["down","right"]],["NamedItemScope",["worksheet","workbook"]],["NamedItemType",["string","integer","double","boolean","range","error","array"]],["RangeUnderlineStyle",["none","single","double","singleAccountant","doubleAccountant"]],["SheetVisibility",["visible","hidden","veryHidden"]],["EventTriggerSource",["unknown","thisLocalAddin"]],["RangeValueType",["unknown","empty","string","integer","double","boolean","error","richValue"]],["KeyboardDirection",["left","right","up","down"]],["SearchDirection",["forward","backwards"]],["SortOrientation",["rows","columns"]],["SortOn",["value","cellColor","fontColor","icon"]],["SortDataOption",["normal","textAsNumber"]],["SortMethod",["pinYin","strokeCount"]],["VerticalAlignment",["top","center","bottom","justify","distributed"]],["MessageCategory",[],{none:0,customFunction:1,action:2,event:65536}],["MessageType",[],{none:0,testEvent:1,test1Event:2,worksheetDataChangedEvent:10,worksheetActivatedEvent:11,worksheetDeactivatedEvent:12,worksheetAddedEvent:13,worksheetSelectionChangedEvent:14,worksheetDeletedEvent:15,worksheetCalculatedEvent:16,worksheetFilteredEvent:17,worksheetFormatChangedEvent:18,worksheetRowSortedEvent:19,worksheetColumnSortedEvent:20,worksheetSingleClickedEvent:21,worksheetRowHiddenChangedEvent:22,worksheetFormulaChangedEvent:23,worksheetProtectionChangedEvent:24,worksheetNameChangedEvent:25,worksheetVisibilityChangedEvent:26,worksheetMovedEvent:27,worksheetNavigationObjectChangedEvent:28,worksheetRowHeightChangedEvent:29,workbookFormulaReferenceStyleChangedEvent:30,chartAddedEvent:50,chartActivatedEvent:51,chartDeactivatedEvent:52,chartDeletedEvent:53,tableSelectionChangedEvent:100,tableDataChangedEvent:101,tableAddedEvent:102,tableDeletedEvent:103,tableFilteredEvent:104,agaveVisualUpdateEvent:150,customFunctionExecutionBeginEvent:200,customFunctionExecutionEndEvent:201,commentAddedEvent:250,commentDeletedEvent:251,commentChangedEvent:252,invocationMessage:1e3,cancellationMessage:1001,metadataMessage:1002,visualSelectionChangedEvent:2e3,visualChangeEvent:2001,visualTrackerModelChangedEvent:2002,shapeSelectionChangedEvent:2100,shapeActivatedEvent:2101,shapeDeactivatedEvent:2102,shapeAddedEvent:2103,shapeDeletedEvent:2104,workbookAutoSaveSettingChangedEvent:2200,wacoperationEvent:2201,recordingStateChangedEvent:2202,workbookActivatedEvent:2203,workbookNavigationObjectChangedEvent:2204,ribbonCommandExecutedEvent:2300,linkedDataTypeRefreshRequestCompletedEvent:2500,linkedDataTypeRefreshModeChangedEvent:2501,linkedDataTypeLinkedDataTypeAddedEvent:2502,linkedWorkbookWorkbookLinksChangedEvent:2600,linkedWorkbookRefreshCompletedEvent:2601,rangePickerSelectionChangedEvent:2700,rangePickerDeactivatedEvent:2701,lineageActivityUpdateAvailableEvent:2800,lineageActivityFilterUpdatedEvent:2801,lineageActivityLoadCompletedEvent:2802,pivotTableAddedEvent:2900,pivotTableDeletedEvent:2901,namedItemAddedEvent:3e3,namedItemDeletedEvent:3001,guidedReapplyManagerUpdateAvailableEvent:3100,vbaRecorderRecordingChangedEvent:3200,vbaRecorderRecordingChanged2Event:3202,workbookActionRecordedEvent:3201,externalCodeServiceDiagnosticsNewEntryEvent:3300,externalCodeServiceDiagnosticsFilterUpdatedEvent:3301,rangeValuesPreviewDismissedEvent:3400,applicationUndoChangedEvent:3500,linkedEntityDataDomainLinkedEntityDataDomainAddedEvent:3600,linkedEntityDataDomainRefreshCompletedEvent:3601,linkedEntityDataDomainRefreshModeChangedEvent:3602,externalCodeServiceInitializationSettingsEnvironmentDefinitionInitializationResponseReceivedEvent:3603,tableApplyPowerQueryTableUpdatePlanCompletedEvent:3604,externalCodeServiceInitializationSettingsEnvironmentDefinitionResponseReceivedEvent:3605,queryQueryRefreshCompletedEvent:3606,appRuntimeVisibilityChangedEvent:65539,beforeCloseNotifiactionCancelledEvent:65540,augmentationLoopAnnotationAddedEvent:65541,premiumLicenseChangedEvent:65542}],["InsertDeleteCellsShiftDirection",["none","shiftCellLeft","shiftCellUp","shiftCellRight","shiftCellDown"]],["DocumentPropertyType",["number","boolean","date","string","float"]],["EventSource",["local","remote"]],["DataChangeType",["unknown","rangeEdited","rowInserted","rowDeleted","columnInserted","columnDeleted","cellInserted","cellDeleted"]],["RowHiddenChangeType",["unhidden","hidden"]],["CommentChangeType",["commentEdited","commentResolved","commentReopened","replyAdded","replyDeleted","replyEdited"]],["EventType",["worksheetChanged","worksheetSelectionChanged","worksheetAdded","worksheetActivated","worksheetDeactivated","tableChanged","tableSelectionChanged","worksheetDeleted","chartAdded","chartActivated","chartDeactivated","chartDeleted","worksheetCalculated","visualSelectionChanged","agaveVisualUpdate","tableAdded","tableDeleted","tableFiltered","worksheetFiltered","shapeActivated","shapeDeactivated","visualChange","workbookAutoSaveSettingChanged","worksheetFormatChanged","ribbonCommandExecuted","worksheetRowSorted","worksheetColumnSorted","worksheetSingleClicked","worksheetRowHiddenChanged","recordingStateChangedEvent","commentAdded","commentDeleted","commentChanged","linkedDataTypeRefreshRequestCompleted","linkedDataTypeRefreshModeChanged","linkedDataTypeLinkedDataTypeAdded","worksheetFormulaChanged","workbookActivated","linkedWorkbookWorkbookLinksChanged","linkedWorkbookRefreshCompleted","worksheetProtectionChanged","worksheetNameChanged","worksheetVisibilityChanged","worksheetMoved","lineageActivityUpdateAvailable","lineageActivityFilterUpdated","lineageActivityLoadCompleted","shapeAdded","shapeDeleted","pivotTableAdded","pivotTableDeleted","namedItemAdded","namedItemDeleted","worksheetNavigationObjectChanged","workbookNavigationObjectChanged","worksheetRowHeightChanged","workbookFormulaReferenceStyleChanged","guidedReapplyManagerUpdateAvailable","vbaRecorderRecordingChanged","rangeValuesPreviewDismissed","annotationAdded","workbookActionRecorded","applicationUndoChanged","vbaRecorderRecordingChanged2","linkedEntityDataDomainLinkedEntityDataDomainAdded","linkedEntityDataDomainRefreshCompleted","linkedEntityDataDomainRefreshModeChanged","queryQueryRefreshCompleted"],{wacoperationEvent:"WACOperationEvent"}],["DocumentPropertyItem",["title","subject","author","keywords","comments","template","lastAuth","revision","appName","lastPrint","creation","lastSave","category","format","manager","company"]],["SubtotalLocationType",["atTop","atBottom","off"]],["PivotLayoutType",["compact","tabular","outline"]],["ProtectionSelectionMode",["normal","unlocked","none"]],["PageOrientation",["portrait","landscape"]],["PaperType",["letter","letterSmall","tabloid","ledger","legal","statement","executive","a3","a4","a4Small","a5","b4","b5","folio","quatro","paper10x14","paper11x17","note","envelope9","envelope10","envelope11","envelope12","envelope14","csheet","dsheet","esheet","envelopeDL","envelopeC5","envelopeC3","envelopeC4","envelopeC6","envelopeC65","envelopeB4","envelopeB5","envelopeB6","envelopeItaly","envelopeMonarch","envelopePersonal","fanfoldUS","fanfoldStdGerman","fanfoldLegalGerman"]],["ReadingOrder",["context","leftToRight","rightToLeft"]],["BuiltInStyle",["normal","comma","currency","percent","wholeComma","wholeDollar","hlink","hlinkTrav","note","warningText","emphasis1","emphasis2","emphasis3","sheetTitle","heading1","heading2","heading3","heading4","input","output","calculation","checkCell","linkedCell","total","good","bad","neutral","accent1","accent1_20","accent1_40","accent1_60","accent2","accent2_20","accent2_40","accent2_60","accent3","accent3_20","accent3_40","accent3_60","accent4","accent4_20","accent4_40","accent4_60","accent5","accent5_20","accent5_40","accent5_60","accent6","accent6_20","accent6_40","accent6_60","explanatoryText"]],["PrintErrorType",["asDisplayed","blank","dash","notAvailable"]],["WorksheetPositionType",["none","before","after","beginning","end"]],["PrintComments",["noComments","endSheet","inPlace"]],["PrintOrder",["downThenOver","overThenDown"]],["PrintMarginUnit",["points","inches","centimeters"]],["HeaderFooterState",["default","firstAndDefault","oddAndEven","firstOddAndEven"]],["AutoFillType",["fillDefault","fillCopy","fillSeries","fillFormats","fillValues","fillDays","fillWeekdays","fillMonths","fillYears","linearTrend","growthTrend","flashFill"]],["GroupOption",["byRows","byColumns"]],["RangeCopyType",["all","formulas","values","formats","link","columnWidths"]],["LinkedDataTypeState",["none","validLinkedData","disambiguationNeeded","brokenLinkedData","fetchingData"]],["GeometricShapeType",["lineInverse","triangle","rightTriangle","rectangle","diamond","parallelogram","trapezoid","nonIsoscelesTrapezoid","pentagon","hexagon","heptagon","octagon","decagon","dodecagon","star4","star5","star6","star7","star8","star10","star12","star16","star24","star32","roundRectangle","round1Rectangle","round2SameRectangle","round2DiagonalRectangle","snipRoundRectangle","snip1Rectangle","snip2SameRectangle","snip2DiagonalRectangle","plaque","ellipse","teardrop","homePlate","chevron","pieWedge","pie","blockArc","donut","noSmoking","rightArrow","leftArrow","upArrow","downArrow","stripedRightArrow","notchedRightArrow","bentUpArrow","leftRightArrow","upDownArrow","leftUpArrow","leftRightUpArrow","quadArrow","leftArrowCallout","rightArrowCallout","upArrowCallout","downArrowCallout","leftRightArrowCallout","upDownArrowCallout","quadArrowCallout","bentArrow","uturnArrow","circularArrow","leftCircularArrow","leftRightCircularArrow","curvedRightArrow","curvedLeftArrow","curvedUpArrow","curvedDownArrow","swooshArrow","cube","can","lightningBolt","heart","sun","moon","smileyFace","irregularSeal1","irregularSeal2","foldedCorner","bevel","frame","halfFrame","corner","diagonalStripe","chord","arc","leftBracket","rightBracket","leftBrace","rightBrace","bracketPair","bracePair","callout1","callout2","callout3","accentCallout1","accentCallout2","accentCallout3","borderCallout1","borderCallout2","borderCallout3","accentBorderCallout1","accentBorderCallout2","accentBorderCallout3","wedgeRectCallout","wedgeRRectCallout","wedgeEllipseCallout","cloudCallout","cloud","ribbon","ribbon2","ellipseRibbon","ellipseRibbon2","leftRightRibbon","verticalScroll","horizontalScroll","wave","doubleWave","plus","flowChartProcess","flowChartDecision","flowChartInputOutput","flowChartPredefinedProcess","flowChartInternalStorage","flowChartDocument","flowChartMultidocument","flowChartTerminator","flowChartPreparation","flowChartManualInput","flowChartManualOperation","flowChartConnector","flowChartPunchedCard","flowChartPunchedTape","flowChartSummingJunction","flowChartOr","flowChartCollate","flowChartSort","flowChartExtract","flowChartMerge","flowChartOfflineStorage","flowChartOnlineStorage","flowChartMagneticTape","flowChartMagneticDisk","flowChartMagneticDrum","flowChartDisplay","flowChartDelay","flowChartAlternateProcess","flowChartOffpageConnector","actionButtonBlank","actionButtonHome","actionButtonHelp","actionButtonInformation","actionButtonForwardNext","actionButtonBackPrevious","actionButtonEnd","actionButtonBeginning","actionButtonReturn","actionButtonDocument","actionButtonSound","actionButtonMovie","gear6","gear9","funnel","mathPlus","mathMinus","mathMultiply","mathDivide","mathEqual","mathNotEqual","cornerTabs","squareTabs","plaqueTabs","chartX","chartStar","chartPlus"]],["ConnectorType",["straight","elbow","curve"]],["ContentType",["plain","mention"]],["SpecialCellType",["conditionalFormats","dataValidations","blanks","constants","formulas","sameConditionalFormat","sameDataValidation","visible"]],["SpecialCellValueType",["all","errors","errorsLogical","errorsNumbers","errorsText","errorsLogicalNumber","errorsLogicalText","errorsNumberText","logical","logicalNumbers","logicalText","logicalNumbersText","numbers","numbersText","text"]],["Placement",["twoCell","oneCell","absolute"]],["FillPattern",["none","solid","gray50","gray75","gray25","horizontal","vertical","down","up","checker","semiGray75","lightHorizontal","lightVertical","lightDown","lightUp","grid","crissCross","gray16","gray8","linearGradient","rectangularGradient"]],["ShapeTextHorizontalAlignment",["left","center","right","justify","justifyLow","distributed","thaiDistributed"]],["ShapeTextVerticalAlignment",["top","middle","bottom","justified","distributed"]],["ShapeTextVerticalOverflow",["overflow","ellipsis","clip"]],["ShapeTextHorizontalOverflow",["overflow","clip"]],["ShapeTextReadingOrder",["leftToRight","rightToLeft"]],["ShapeTextOrientation",["horizontal","vertical","vertical270","wordArtVertical","eastAsianVertical","mongolianVertical","wordArtVerticalRTL"]],["ShapeAutoSize",["autoSizeNone","autoSizeTextToFitShape","autoSizeShapeToFitText","autoSizeMixed"]],["CloseBehavior",["save","skipSave"]],["SaveBehavior",["save","prompt"]],["SlicerSortType",["dataSourceOrder","ascending","descending"]],["RibbonTab",["others","home","insert","draw","pageLayout","formulas","data","review","view","developer","addIns","help"]],["NumberFormatCategory",["general","number","currency","accounting","date","time","percentage","fraction","scientific","text","special","custom"]]],clientObjectTypes:[["GridFoil",0,[["id",2],["options",2]],[["range","Range",2,0,0,4]],[["dismiss",0,2,0,4]]],["GridFoilCollection",1,0,0,[["removeAll",0,2,0,4]],[["add","GridFoil",2,10,0,4],["getItem","GridFoil",1,2,0,4]],0,"GridFoil"],["LocalImage",0,0,0,[["getBase64EncodedImageData",1,2,0,4]]],["PremiumLicense",0,[["details",2],["valid",2],["id",2]],0,[["_RegisterEventChanged"],["_UnregisterEventChanged"]],0,0,0,[["Changed",0,0,"MessageType.premiumLicenseChangedEvent","this.id","_RegisterEventChanged","_UnregisterEventChanged"]]],["FormulaCultureInfo",0,[["errorTypeNames",2],["falseName",2],["leftBrace",2],["leftBracket",2],["listSeparator",2],["rightBrace",2],["rightBracket",2],["specialRefNames",2],["trueName",2],["uppercaseColumnLetter",2],["uppercaseRowLetter",2],["worksheetFunctionNames",2],["columnSeparator",2],["rowSeparator",2]]],["ExternalCodeServiceInitializationSettings",0,[["id",2]],0,[["commitEnvironmentDefinition",1,0,0,2],["resetToDefaultEnvironmentDefinition",0,0,0,2],["_RegisterEventEnvironmentDefinitionInitializationResponseReceived",0,2,0,4],["_UnregisterEventEnvironmentDefinitionInitializationResponseReceived",0,2,0,4],["_RegisterEventEnvironmentDefinitionResponseReceived",0,2,0,4],["_UnregisterEventEnvironmentDefinitionResponseReceived",0,2,0,4],["getEnvironmentDefinition",0,2,0,4],["getResult",0,2,0,4]],0,0,0,[["EnvironmentDefinitionInitializationResponseReceived",0,0,"MessageType.externalCodeServiceInitializationSettingsEnvironmentDefinitionInitializationResponseReceivedEvent","this.id","_RegisterEventEnvironmentDefinitionInitializationResponseReceived","_UnregisterEventEnvironmentDefinitionInitializationResponseReceived"],["EnvironmentDefinitionResponseReceived",0,0,"MessageType.externalCodeServiceInitializationSettingsEnvironmentDefinitionResponseReceivedEvent","this.id","_RegisterEventEnvironmentDefinitionResponseReceived","_UnregisterEventEnvironmentDefinitionResponseReceived"]]],["UndoScope",0,0,0,[["close",0,0,0,2],["open",1,0,0,2]]],["RangeValuesPreview",4,0,0,[["_RegisterEventDismissed",0,0,0,2,0,1],["_UnregisterEventDismissed",0,0,0,2,0,1],["dismiss",0,2,0,4],["show",3,2,0,4]],0,0,0,[["Dismissed",0,0,"MessageType.rangeValuesPreviewDismissedEvent","this._ParentObject.id","_RegisterEventDismissed","_UnregisterEventDismissed"]]],["AugmentationLoop",0,0,0,[["_RegisterAnnotationAddedEvent",0,2,0,4],["_UnregisterAnnotationAddedEvent",0,2,0,4],["activateAnnotation",1,2,0,4],["submitSignal",1,2,0,4]],0,0,0,[["AnnotationAdded",0,0,"MessageType.augmentationLoopAnnotationAddedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterAnnotationAddedEvent","_UnregisterAnnotationAddedEvent"]]],["ExternalCodeService",0,[["autoShowDiagnostics"]],[["diagnostics","ExternalCodeServiceDiagnostics",2,0,0,4],["initializationSettings","ExternalCodeServiceInitializationSettings",2,0,0,4]]],["ExternalCodeServiceDiagnostics",0,[["id",2]],0,[["_RegisterEventNewEntry",0,0,0,2,0,1],["_UnregisterEventNewEntry",0,0,0,2,0,1],["clear",0,2,0,4],["fireStoredEntries",0,2,0,4],["_RegisterEventFilterUpdated",0,0,0,2,0,1],["_UnregisterEventFilterUpdated",0,0,0,2,0,1]],0,0,0,[["FilterUpdated",0,0,"MessageType.externalCodeServiceDiagnosticsFilterUpdatedEvent","this.id","_RegisterEventFilterUpdated","_UnregisterEventFilterUpdated"],["NewEntry",0,0,"MessageType.externalCodeServiceDiagnosticsNewEntryEvent","this.id","_RegisterEventNewEntry","_UnregisterEventNewEntry"]]],["VbaRecorder",0,[["id",2]],0,[["_RegisterEventRecordingChanged",0,0,0,2,0,1],["_UnregisterEventRecordingChanged",0,0,0,2,0,1],["_RegisterEventRecordingChanged2",0,2,2,4],["_UnregisterEventRecordingChanged2",0,2,2,4]],0,0,0,[["RecordingChanged",0,0,"MessageType.vbaRecorderRecordingChangedEvent","this.id","_RegisterEventRecordingChanged","_UnregisterEventRecordingChanged"],["RecordingChanged2",0,2,"MessageType.vbaRecorderRecordingChanged2Event","this.id","_RegisterEventRecordingChanged2","_UnregisterEventRecordingChanged2"]]],["WorksheetOptimizationScanResult",0,[["allocatedCells",2],["optimizableCells",2]],[["ranges","RangeOptimizationCollection",18,0,0,4]]],["UserActivityCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","UserActivity",1,2,0,4]],0,"UserActivity"],["GuidedReapplyManager",0,0,[["activities","UserActivityCollection",18,0,0,4],["summaryCardUserActivity","SummaryCardUserActivity",2,0,0,4],["unappliedActivities","UserActivityCollection",18,0,0,4],["reappliedActivities","UserActivityCollection",18,0,0,4],["reappliedSummaryCardUserActivity","SummaryCardUserActivity",2,0,0,4],["unappliedSummaryCardUserActivity","SummaryCardUserActivity",2,0,0,4]],[["openSavedFile",0,2,0,4],["updateActivities",0,2,0,4],["_RegisterEventUpdateAvailable",0,2,0,4],["_UnregisterEventUpdateAvailable",0,2,0,4],["discardActivites",0,2,0,4],["reapplyActivity",1,0,0,2,0,3],["saveActivities",0,2,0,4],["reapplyActivities",0,0,0,2,0,3]],[["getState","GuidedReapplyState",0,2,0,4]],0,0,[["UpdateAvailable",0,0,"MessageType.guidedReapplyManagerUpdateAvailableEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventUpdateAvailable","_UnregisterEventUpdateAvailable"]]],["GuidedReapplyState",0,[["dimOpenBackupButton",2],["dimApplyUnsavedChangesButton",2],["isInPostReloadState",2]]],["BusinessBar",0,0,0,[["hide",2],["show",2]]],["UserActivity",0,[["activityId",2],["activityType",2],["author",2],["createdDateTime",10],["guid",2],["rangeAddress",2],["sheetName",2],["valueChangeData",2],["authorEmail",2],["locationDeleted",2]],[["highlightRangeAreas","RangeAreas",2,0,0,4]]],["LineageActivityCollection",1,0,0,[["_RegisterEventUpdateAvailable",0,2,0,4],["_UnregisterEventUpdateAvailable",0,2,0,4],["clear",0,2,0,4],["getCount",0,2,0,4],["getState",0,2,0,4],["loadActivities",1,2,0,4],["loadLatestActivities",0,2,0,4],["loadNextActivities",0,2,0,4],["loadPreviousActivities",0,2,0,4],["updateActivities",0,2,0,4],["_RegisterEventFilterUpdated",0,2,0,4],["_RegisterEventLoadCompleted",0,2,0,4],["_UnregisterEventFilterUpdated",0,2,0,4],["_UnregisterEventLoadCompleted",0,2,0,4]],[["getItemAt","UserActivity",1,2,0,4]],0,"UserActivity",[["FilterUpdated",0,0,"MessageType.lineageActivityFilterUpdatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventFilterUpdated","_UnregisterEventFilterUpdated"],["LoadCompleted",0,0,"MessageType.lineageActivityLoadCompletedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventLoadCompleted","_UnregisterEventLoadCompleted"],["UpdateAvailable",0,0,"MessageType.lineageActivityUpdateAvailableEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventUpdateAvailable","_UnregisterEventUpdateAvailable"]]],["SummaryItemUserActivity",0,[["activityType",2],["rangeAddresses",2],["sheetName",2],["valueChangeData",2]]],["SummaryItemUserActivityCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","SummaryItemUserActivity",1,2,0,4]],0,"SummaryItemUserActivity"],["SummaryCardUserActivity",0,[["authors",2],["currentUser",2],["displayTime",10],["numberOfDetailedCard",2],["summaryUnviewableData",2]],[["summaryItemUserActivities","SummaryItemUserActivityCollection",18,0,0,4]]],["AllowEditRange",0,[["address",1],["isPasswordProtected",3],["title",1]],0,[["delete"],["pauseProtection",1],["setPassword",1]]],["AllowEditRangeCollection",1,0,0,[["add",3],["getCount",0,2,0,4],["pauseProtection",1]],[["getItem","AllowEditRange",1,18,0,4],["getItemAt","AllowEditRange",1,2,0,4],["getItemOrNullObject","AllowEditRange",1,2,0,4]],0,"AllowEditRange"],["Query",0,[["loadedTo",2],["loadedToDataModel",2],["name",2],["refreshDate",10],["rowsLoadedCount",2],["error",2]],0,[["delete",0,0,4],["refresh",0,0,4]]],["QueryCollection",1,0,0,[["getCount",0,2,0,4],["refreshAll",0,0,4],["_RegisterEventQueryRefreshCompleted",0,0,4],["_UnregisterEventQueryRefreshCompleted",0,0,4]],[["getItem","Query",1,18,0,4],["loadQuery","Query",3,0,4]],0,"Query",[["QueryRefreshCompleted",0,4,"MessageType.queryQueryRefreshCompletedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventQueryRefreshCompleted","_UnregisterEventQueryRefreshCompleted"]]],["VisualTracker",0,[["id",2]],0,[["_RegisterEventModelChanged",0,2],["_UnregisterEventModelChanged",0,2],["requestTrackingAlteration",2,2,0,4]],0,0,0,[["ModelChanged",0,0,"MessageType.visualTrackerModelChangedEvent","this.id","_RegisterEventModelChanged","_UnregisterEventModelChanged"]]],["NumberFormatProperty",0,[["key",3],["currency",3],["dateTime",3],["dateTimeHasDayOfWeek",3],["dateTimeHasMonth",3],["dateTimeHasYear",3],["numeric",3],["percent",3],["text",3]]],["NumberFormatPropertyCollection",1,0,0,0,[["getItemAt","NumberFormatProperty",1,2,0,4]],0,"NumberFormatProperty"],["RangeOptimization",0,[["optimizationTypes",2],["range",2]]],["RangeOptimizationCollection",1,[["allocatedCells",2],["optimizableCells",2]],0,[["getCount",0,2,0,4]],[["getItemAt","RangeOptimization",1,2,0,4]],0,"RangeOptimization"],["WorksheetOptimization",0,0,0,[["formatCellCounts",1,2,0,4]],[["optimize","WorksheetOptimizationResult",0,0,0,2],["scan","RangeOptimizationCollection",0,6,0,4],["scanExtended","WorksheetOptimizationScanResult",0,2,0,4]]],["WorksheetOptimizationResult",0,[["allocatedCells",2],["optimizedCells",2]]],["LinkedWorkbook",0,[["displayUrl",2,5],["fileName",3,5],["id",2],["longErrorDescription",2,5],["refreshEnabled",2,5],["refreshing",2,5],["statusMessage",2,5],["excelIconState",2,5],["hardToFindErrorMessages",2,5],["lastUpdated",10,5],["recentlyEdited",2,5]],0,[["_RegisterRefreshCompletedEvent",0,0,5,2,0,1],["_UnregisterRefreshCompletedEvent",0,0,5,2,0,1],["breakLinks",0,0,0,2,0,6],["changeSource",1,0,5,2,0,6],["findNextLink",0,2,5,4],["openWorkbook",0,2,5,4],["refresh"],["openChangeSourceDialog",0,0,5,2,0,6],["closeChangeSourceDialog",0,2,5,4]],0,0,0,[["RefreshCompleted",0,5,"MessageType.linkedWorkbookRefreshCompletedEvent","this.id","_RegisterRefreshCompletedEvent","_UnregisterRefreshCompletedEvent"]]],["LinkedWorkbookCollection",1,[["breakAllLinksEnabled",0,5],["refreshAllEnabled",0,5],["workbookLinksRefreshMode",0,0,0,2,7],["workbookLinksRefreshSettings",0,5],["containsNonWorkbookLinks",0,5]],0,[["_RegisterWorkbookLinksChangedEvent",0,2,5,4],["_UnregisterWorkbookLinksChangedEvent",0,2,5,4],["breakAllLinks",0,0,0,2,0,6],["getCount",0,2,5,4],["refreshAll"],["openEditLinksDialog",0,2,5,4],["breakCheckedWorkbooks",1,0,5],["openCheckedWorkbooks",1,0,5,2],["refreshCheckedWorkbooks",1,0,5]],[["getItem","LinkedWorkbook",1,18,0,4],["getItemAt","LinkedWorkbook",1,2,5,4],["getItemOrNullObject","LinkedWorkbook",1,0,0,2,0,0,8]],0,"LinkedWorkbook",[["WorkbookLinksChanged",0,5,"MessageType.linkedWorkbookWorkbookLinksChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterWorkbookLinksChangedEvent","_UnregisterWorkbookLinksChangedEvent"]]],["DocumentTaskChange",0,[["type",2],["changedBy",2],["commentId",2],["createdDateTime",10],["id",2],["assignee",2],["undoChangeId",2],["priority",2],["title",2],["percentComplete",2],["startDateTime",10],["dueDateTime",10]],0,0,0,0,0,0,"Microsoft.ExcelServices.DocumentTaskChange",4],["DocumentTaskChangeCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","DocumentTaskChange",1,2,0,4]],0,"DocumentTaskChange"],["RangePicker",0,0,0,[["activate",1,0,0,2,0,9],["deactivate",0,0,0,2,0,9],["updateSelection",1,0,0,2,0,9],["updateSelectionWithNavigation",4,0,0,2,0,9],["_RegisterEventSelectionChanged",0,0,0,2,0,9],["_UnregisterEventSelectionChanged",0,0,0,2,0,9],["_RegisterEventDeactivated",0,2,0,4],["_UnregisterEventDeactivated",0,2,0,4]],0,0,0,[["Deactivated",0,0,"MessageType.rangePickerDeactivatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventDeactivated","_UnregisterEventDeactivated"],["SelectionChanged",0,0,"MessageType.rangePickerSelectionChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventSelectionChanged","_UnregisterEventSelectionChanged"]]],["DocumentTask",0,[["startAndDueDateTime"],["id",2],["percentComplete"],["priority"],["title"],["assignees",2],["completedBy",2],["completedDateTime",10],["createdBy",2],["createdDateTime",10]],[["changes","DocumentTaskChangeCollection",18,0,0,4],["comment","Comment",2,0,0,4]],[["assign",1],["unassign",1],["unassignAll"]]],["DocumentTaskCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","DocumentTask",1,18,0,4],["getItemOrNullObject","DocumentTask",1,2,0,4],["getItemAt","DocumentTask",1,2,0,4]],0,"DocumentTask"],["DataConnection",0,[["connectionString",2],["name",2],["commandText",2],["dataSourceType",2]]],["Runtime",0,[["enableEvents",1,10,0,2,7]]],["Application",0,[["calculationMode",1],["calculationEngineVersion",3,11],["calculationState",3,11],["decimalSeparator",3,12],["thousandsSeparator",3,12],["useSystemSeparators",3,12],["formatStaleValues",1,4]],[["iterativeCalculation","IterativeCalculation",35,11,0,4],["ribbon","Ribbon",35,11,0,4],["cultureInfo","CultureInfo",3,12,0,4],["undoScope","UndoScope",3,5,0,4]],[["calculate",1],["suspendApiCalculationUntilNextSync",0,1,13,2,0,14],["suspendScreenUpdatingUntilNextSync",0,0,11,2,0,14],["hasLicense",1,2,4,4],["redo",0,0,5,2],["explorePremiumLicense",1,2,4,4],["undo",0,0,5,2],["_RegisterEventUndoChanged",0,2,5,4],["_UnregisterEventUndoChanged",0,2,5,4]],[["createWorkbook","WorkbookCreated",1,10,10,0,0,"_GetWorkbookCreatedById"],["_GetWorkbookCreatedById","WorkbookCreated",1,2,10,4],["getPremiumLicense","PremiumLicense",1,2,4,4]],0,0,[["UndoChanged",0,5,"MessageType.applicationUndoChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventUndoChanged","_UnregisterEventUndoChanged"]]],["IterativeCalculation",0,[["enabled",1],["maxIteration",1],["maxChange",1]]],["Workbook",0,[["name",3,15],["readOnly",3,10],["isDirty",1,11,0,2,8],["use1904DateSystem",1,4,0,2,8],["chartDataPointTrack",1,11,0,2,8],["usePrecisionAsDisplayed",1,11,0,2,8],["calculationEngineVersion",3,11],["autoSave",3,11],["previouslySaved",3,11],["showPivotFieldList",0,4,0,2,16],["formulaReferenceStyle",2,4],["externalCodeServiceTimeout",0,4,0,2]],[["worksheets","WorksheetCollection",19,0,0,4],["names","NamedItemCollection",19,0,0,4],["tables","TableCollection",19,0,0,4],["application","Application",2,0,0,4],["bindings","BindingCollection",19,0,0,4],["functions","Functions",2,17,0,4],["_V1Api","_V1Api",2,18,0,4],["pivotTables","PivotTableCollection",19,18,0,4],["settings","SettingCollection",19,19,0,4],["customXmlParts","CustomXmlPartCollection",19,20,0,4],["internalTest","InternalTest",2,13,0,4],["properties","DocumentProperties",35,15,0,4],["styles","StyleCollection",19,15,0,4],["protection","WorkbookProtection",3,15,0,4],["dataConnections","DataConnectionCollection",3,15,0,4],["_Runtime","Runtime",2,20,0,4],["comments","CommentCollection",19,21,0,4],["slicers","SlicerCollection",19,21,0,4],["tableStyles","TableStyleCollection",19,21,0,4],["pivotTableStyles","PivotTableStyleCollection",19,21,0,4],["slicerStyles","SlicerStyleCollection",19,21,0,4],["timelineStyles","TimelineStyleCollection",19,21,0,4],["tasks","DocumentTaskCollection",18,4,0,4],["linkedDataTypes","LinkedDataTypeCollection",18,4,0,4],["queries","QueryCollection",18,22,0,4],["linkedWorkbooks","LinkedWorkbookCollection",18,23,0,4],["rangePicker","RangePicker",2,4,0,4,0,9],["lineageActivities","LineageActivityCollection",18,5,0,4],["businessBar","BusinessBar",2,4,0,4],["guidedReapply","GuidedReapplyManager",2,5,0,4],["vbaRecorder","VbaRecorder",2,4,0,4],["externalCodeService","ExternalCodeService",2,4,0,4],["augmentationLoop","AugmentationLoop",2,4,0,4],["linkedEntityDataDomains","LinkedEntityDataDomainCollection",18,24,0,4],["localImage","LocalImage",2,4,0,4]],[["_RemoveReference",1,2],["_GetObjectByReferenceId",1,2,0,4],["_GetObjectTypeNameByReferenceId",1,2,0,4],["_RemoveAllReferences",0,2],["_GetReferenceCount",0,2,0,4],["getIsActiveCollabSession",0,0,11,2,0,8],["registerCustomFunctions",7,0,25,10,0,8],["_SetOsfControlContainerReadyForCustomFunctions",0,0,25,2,0,8],["close",1,0,12],["save",1,0,12],["_RegisterAutoSaveSettingChangedEvent",0,0,11,2,0,1],["_UnregisterAutoSaveSettingChangedEvent",0,0,11,2,0,1],["_RegisterWACOperationEvent",0,2,26,4],["_UnregisterWACOperationEvent",0,2,26,4],["_RegisterRecordingStateChangedEvent",0,0,26,2,0,27],["_UnregisterRecordingStateChangedEvent",0,0,26,2,0,27],["_RegisterActivatedEvent",0,2,28],["_UnregisterActivatedEvent",0,2,28],["insertWorksheetsFromBase64",2,0,28],["enableOfficeScriptRecording",1,1,23],["recordAction",1,3,0,4],["focus",0,2,5,4],["_RegisterNavigationObjectChangedEvent",0,0,5,2,0,1],["_UnregisterNavigationObjectChangedEvent",0,0,5,2,0,1],["showHelp",1,2,5,4],["getLinkedEntityCellValue",1,2,29,4],["getThemeColors",0,2,4,4],["_RegisterEventFormulaReferenceStyleChanged",0,2,4,4],["_UnregisterEventFormulaReferenceStyleChanged",0,2,4,4],["notifySDXLoaded",1,2,5,4],["openConditionalFormattingRulesManager",1,0,5],["openNameManager",0,0,5],["_RegisterEventActionRecorded",0,2,2,4],["_UnregisterEventActionRecorded",0,2,2,4]],[["getSelectedRange","Range",0,10,0,4],["getActiveCell","Range",0,10,15,4],["_GetRangeForEventByReferenceId","Range",1,2,0,4],["_GetRangeOrNullObjectForEventByReferenceId","Range",1,2,0,4],["getActiveChart","Chart",0,2,11,4],["getActiveChartOrNullObject","Chart",0,2,11,4],["getSelectedRanges","RangeAreas",0,10,11,4],["_GetRangesForEventByReferenceId","RangeAreas",1,2,11,4],["_GetRangesOrNullObjectForEventByReferenceId","RangeAreas",1,2,11,4],["getActiveSlicer","Slicer",0,2,21,4],["getActiveSlicerOrNullObject","Slicer",0,2,21,4],["getActiveShape","Shape",0,2,30,4],["getActiveShapeOrNullObject","Shape",0,2,30,4]],0,0,[["ActionRecorded",0,2,"MessageType.workbookActionRecordedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventActionRecorded","_UnregisterEventActionRecorded"],["Activated",0,28,"MessageType.workbookActivatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["AutoSaveSettingChanged",0,11,"MessageType.workbookAutoSaveSettingChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterAutoSaveSettingChangedEvent","_UnregisterAutoSaveSettingChangedEvent"],["FormulaReferenceStyleChanged",0,4,"MessageType.workbookFormulaReferenceStyleChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventFormulaReferenceStyleChanged","_UnregisterEventFormulaReferenceStyleChanged"],["NavigationObjectChanged",0,5,"MessageType.workbookNavigationObjectChangedEvent","this.id","_RegisterNavigationObjectChangedEvent","_UnregisterNavigationObjectChangedEvent"],["RecordingStateChangedEvent",0,26,"MessageType.recordingStateChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterRecordingStateChangedEvent","_UnregisterRecordingStateChangedEvent"],["SelectionChanged",3,18,"_CC.office10EventIdDocumentSelectionChangedEvent","","",""],["WACOperationEvent",2,26,"MessageType.wacoperationEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterWACOperationEvent","_UnregisterWACOperationEvent"],["_Message",3,15,"_CC.office10EventIdRichApiMessageEvent","","",""]]],["WorkbookProtection",0,[["protected",3]],0,[["protect",1],["unprotect",1]]],["WorkbookCreated",0,[["id",3]],0,[["open",0,2,0,4]]],["Worksheet",0,[["name",1],["id",3],["position",1],["visibility",1],["tabColor",1,15,0,2,31],["standardWidth",1,15],["standardHeight",3,15],["showGridlines",5,10,0,2,32],["showHeadings",5,10,0,2,7],["enableCalculation",1,11,0,2,7],["tabId",3,22],["showDataTypeIcons",0,24,0,2]],[["charts","ChartCollection",83,0,0,4],["tables","TableCollection",83,0,0,4],["protection","WorksheetProtection",3,17,0,4],["pivotTables","PivotTableCollection",83,18,0,4],["names","NamedItemCollection",83,19,0,4],["freezePanes","WorksheetFreezePanes",3,15,0,4],["pageLayout","PageLayout",35,11,0,4],["visuals","VisualCollection",83,21,0,4],["shapes","ShapeCollection",83,11,0,4],["horizontalPageBreaks","PageBreakCollection",19,11,0,4],["verticalPageBreaks","PageBreakCollection",19,11,0,4],["autoFilter","AutoFilter",3,11,0,4],["slicers","SlicerCollection",19,21,0,4],["comments","CommentCollection",83,21,0,4],["customProperties","WorksheetCustomPropertyCollection",19,33,0,4],["namedSheetViews","NamedSheetViewCollection",18,23,0,4],["optimization","WorksheetOptimization",2,4,0,4],["tasks","DocumentTaskCollection",18,4,0,4],["visualTracker","VisualTracker",2,34,0,4],["rangeValuesPreview","RangeValuesPreview",66,4,0,4],["gridFoils","GridFoilCollection",18,5,0,4]],[["delete"],["activate",0,2],["calculate",1,0,13,2,0,35],["_RegisterDataChangedEvent",0,0,15,2,0,14],["_UnregisterDataChangedEvent",0,0,15,2,0,14],["_RegisterActivatedEvent",0,0,15,2,0,1],["_UnregisterActivatedEvent",0,0,15,2,0,1],["_RegisterDeactivatedEvent",0,0,15,2,0,1],["_UnregisterDeactivatedEvent",0,0,15,2,0,1],["_RegisterSelectionChangedEvent",0,0,15,2,0,36],["_UnregisterSelectionChangedEvent",0,0,15,2,0,36],["_RegisterCalculatedEvent",0,0,10,2,0,1],["_UnregisterCalculatedEvent",0,0,10,2,0,1],["replaceAll",3,0,11,2,0,7],["_RegisterFilteredEvent",0,0,4,2,0,1],["_UnregisterFilteredEvent",0,0,4,2,0,1],["_RegisterFormatChangedEvent",0,0,11,2,0,1],["_UnregisterFormatChangedEvent",0,0,11,2,0,1],["_RegisterRowSortedEvent",0,0,21,2,0,1],["_UnregisterRowSortedEvent",0,0,21,2,0,1],["_RegisterColumnSortedEvent",0,0,21,2,0,1],["_UnregisterColumnSortedEvent",0,0,21,2,0,1],["_RegisterSingleClickedEvent",0,0,21,2,0,1],["_UnregisterSingleClickedEvent",0,0,21,2,0,1],["_RegisterRowHiddenChangedEvent",0,0,12,2,0,1],["_UnregisterRowHiddenChangedEvent",0,0,12,2,0,1],["showOutlineLevels",2,0,21,2,0,7],["_RegisterFormulaChangedEvent",0,2,28],["_UnregisterFormulaChangedEvent",0,2,28],["_RegisterProtectionChangedEvent",0,2,22],["_UnregisterProtectionChangedEvent",0,2,22],["_RegisterEventNameChanged",0,0,37,2,0,1],["_RegisterEventVisibilityChanged",0,0,37,2,0,1],["_UnregisterEventNameChanged",0,0,37,2,0,1],["_UnregisterEventVisibilityChanged",0,0,37,2,0,1],["_RegisterNavigationObjectChangedEvent",0,0,5,2,0,1],["_UnregisterNavigationObjectChangedEvent",0,0,5,2,0,1],["_RegisterEventRowHeightChanged",0,2,4],["_UnregisterEventRowHeightChanged",0,2,4]],[["getRange","Range",1,10,0,4],["getUsedRange","Range",1,10,0,4],["getCell","Range",2,10,0,4],["getUsedRangeOrNullObject","Range",1,10,19,4],["getRangeByIndexes","Range",4,10,15,4],["getPrevious","Worksheet",1,10,20,4,0,"_GetSheetById"],["getPreviousOrNullObject","Worksheet",1,10,20,4,0,"_GetSheetById"],["getNext","Worksheet",1,10,20,4,0,"_GetSheetById"],["getNextOrNullObject","Worksheet",1,10,20,4,0,"_GetSheetById"],["_GetSheetById","Worksheet",1,2,15,4],["copy","Worksheet",2,0,15,0,0,"_GetAnotherWorksheetById"],["_GetAnotherWorksheetById","Worksheet",1,0,15,2,0,0,7],["findAll","RangeAreas",2,10,11,4],["findAllOrNullObject","RangeAreas",2,10,11,4],["getRanges","RangeAreas",1,10,11,4],["getUsedRangeAreas","RangeAreas",1,0,5],["getRangeR1C1","Range",1,2,4,4],["getRangesR1C1","RangeAreas",1,2,4,4],["getUsedRangeAreasOrNullObject","RangeAreas",1,0,5]],"workbook.worksheets",0,[["Activated",0,15,"MessageType.worksheetActivatedEvent","this.id","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["Calculated",0,10,"MessageType.worksheetCalculatedEvent","this.id","_RegisterCalculatedEvent","_UnregisterCalculatedEvent"],["Changed",2,15,"MessageType.worksheetDataChangedEvent","this.id","_RegisterDataChangedEvent","_UnregisterDataChangedEvent"],["ColumnSorted",0,21,"MessageType.worksheetColumnSortedEvent","this.id","_RegisterColumnSortedEvent","_UnregisterColumnSortedEvent"],["Deactivated",0,15,"MessageType.worksheetDeactivatedEvent","this.id","_RegisterDeactivatedEvent","_UnregisterDeactivatedEvent"],["Filtered",0,4,"MessageType.worksheetFilteredEvent","this.id","_RegisterFilteredEvent","_UnregisterFilteredEvent"],["FormatChanged",2,11,"MessageType.worksheetFormatChangedEvent","this.id","_RegisterFormatChangedEvent","_UnregisterFormatChangedEvent"],["FormulaChanged",2,28,"MessageType.worksheetFormulaChangedEvent","this.id","_RegisterFormulaChangedEvent","_UnregisterFormulaChangedEvent"],["NameChanged",0,37,"MessageType.worksheetNameChangedEvent","this.id","_RegisterEventNameChanged","_UnregisterEventNameChanged"],["NavigationObjectChanged",0,5,"MessageType.worksheetNavigationObjectChangedEvent","this.id","_RegisterNavigationObjectChangedEvent","_UnregisterNavigationObjectChangedEvent"],["ProtectionChanged",0,22,"MessageType.worksheetProtectionChangedEvent","this.id","_RegisterProtectionChangedEvent","_UnregisterProtectionChangedEvent"],["RowHeightChanged",0,4,"MessageType.worksheetRowHeightChangedEvent","this.id","_RegisterEventRowHeightChanged","_UnregisterEventRowHeightChanged"],["RowHiddenChanged",0,12,"MessageType.worksheetRowHiddenChangedEvent","this.id","_RegisterRowHiddenChangedEvent","_UnregisterRowHiddenChangedEvent"],["RowSorted",0,21,"MessageType.worksheetRowSortedEvent","this.id","_RegisterRowSortedEvent","_UnregisterRowSortedEvent"],["SelectionChanged",0,15,"MessageType.worksheetSelectionChangedEvent","this.id","_RegisterSelectionChangedEvent","_UnregisterSelectionChangedEvent"],["SingleClicked",0,21,"MessageType.worksheetSingleClickedEvent","this.id","_RegisterSingleClickedEvent","_UnregisterSingleClickedEvent"],["VisibilityChanged",0,37,"MessageType.worksheetVisibilityChangedEvent","this.id","_RegisterEventVisibilityChanged","_UnregisterEventVisibilityChanged"]]],["WorksheetCollection",1,0,0,[["getCount",1,2,19,4],["_RegisterAddedEvent",0,3,15],["_UnregisterAddedEvent",0,3,15],["_RegisterActivatedEvent",0,3,15],["_UnregisterActivatedEvent",0,0,15,2,0,36],["_RegisterDeactivatedEvent",0,0,15,2,0,36],["_UnregisterDeactivatedEvent",0,0,15,2,0,36],["_RegisterDeletedEvent",0,3,15],["_UnregisterDeletedEvent",0,3,15],["_RegisterCalculatedEvent",0,0,10,2,0,1],["_UnregisterCalculatedEvent",0,0,10,2,0,1],["_RegisterDataChangedEvent",0,3,11],["_UnregisterDataChangedEvent",0,3,11],["_RegisterSelectionChangedEvent",0,0,11,2,0,36],["_UnregisterSelectionChangedEvent",0,0,11,2,0,36],["addFromBase64",4,0,4],["_RegisterFilteredEvent",0,0,4,2,0,1],["_UnregisterFilteredEvent",0,0,4,2,0,1],["_RegisterFormatChangedEvent",0,0,11,2,0,1],["_UnregisterFormatChangedEvent",0,0,11,2,0,1],["_RegisterRowSortedEvent",0,3,21],["_UnregisterRowSortedEvent",0,3,21],["_RegisterColumnSortedEvent",0,3,21],["_UnregisterColumnSortedEvent",0,3,21],["_RegisterSingleClickedEvent",0,0,21,2,0,36],["_UnregisterSingleClickedEvent",0,0,21,2,0,36],["_RegisterRowHiddenChangedEvent",0,0,12,2,0,1],["_UnregisterRowHiddenChangedEvent",0,0,12,2,0,1],["_RegisterFormulaChangedEvent",0,2,28],["_UnregisterFormulaChangedEvent",0,2,28],["_RegisterProtectionChangedEvent",0,2,22],["_UnregisterProtectionChangedEvent",0,2,22],["_RegisterEventNameChanged",0,2,37,4],["_RegisterEventVisibilityChanged",0,2,37,4],["_UnregisterEventNameChanged",0,2,37,4],["_UnregisterEventVisibilityChanged",0,2,37,4],["_RegisterEventMoved",0,0,37,2,0,1],["_UnregisterEventMoved",0,0,37,2,0,1],["_RegisterEventRowHeightChanged",0,2,4],["_UnregisterEventRowHeightChanged",0,2,4]],[["getItem","Worksheet",1,18,0,4],["add","Worksheet",1,8,0,2,0,0,36],["getActiveWorksheet","Worksheet",0,2,0,4],["getItemOrNullObject","Worksheet",1,2,19,4],["getFirst","Worksheet",1,10,20,4],["getLast","Worksheet",1,10,20,4]],0,"Worksheet",[["Activated",0,15,"MessageType.worksheetActivatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["Added",0,15,"MessageType.worksheetAddedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterAddedEvent","_UnregisterAddedEvent"],["Calculated",0,10,"MessageType.worksheetCalculatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterCalculatedEvent","_UnregisterCalculatedEvent"],["Changed",2,11,"MessageType.worksheetDataChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterDataChangedEvent","_UnregisterDataChangedEvent"],["ColumnSorted",0,21,"MessageType.worksheetColumnSortedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterColumnSortedEvent","_UnregisterColumnSortedEvent"],["Deactivated",0,15,"MessageType.worksheetDeactivatedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterDeactivatedEvent","_UnregisterDeactivatedEvent"],["Deleted",0,15,"MessageType.worksheetDeletedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterDeletedEvent","_UnregisterDeletedEvent"],["Filtered",0,4,"MessageType.worksheetFilteredEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterFilteredEvent","_UnregisterFilteredEvent"],["FormatChanged",2,11,"MessageType.worksheetFormatChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterFormatChangedEvent","_UnregisterFormatChangedEvent"],["FormulaChanged",2,28,"MessageType.worksheetFormulaChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterFormulaChangedEvent","_UnregisterFormulaChangedEvent"],["Moved",0,37,"MessageType.worksheetMovedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventMoved","_UnregisterEventMoved"],["NameChanged",0,37,"MessageType.worksheetNameChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventNameChanged","_UnregisterEventNameChanged"],["ProtectionChanged",0,22,"MessageType.worksheetProtectionChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterProtectionChangedEvent","_UnregisterProtectionChangedEvent"],["RowHeightChanged",0,4,"MessageType.worksheetRowHeightChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventRowHeightChanged","_UnregisterEventRowHeightChanged"],["RowHiddenChanged",0,12,"MessageType.worksheetRowHiddenChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterRowHiddenChangedEvent","_UnregisterRowHiddenChangedEvent"],["RowSorted",0,21,"MessageType.worksheetRowSortedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterRowSortedEvent","_UnregisterRowSortedEvent"],["SelectionChanged",0,11,"MessageType.worksheetSelectionChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterSelectionChangedEvent","_UnregisterSelectionChangedEvent"],["SingleClicked",0,21,"MessageType.worksheetSingleClickedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterSingleClickedEvent","_UnregisterSingleClickedEvent"],["VisibilityChanged",0,37,"MessageType.worksheetVisibilityChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventVisibilityChanged","_UnregisterEventVisibilityChanged"]]],["WorksheetProtection",0,[["protected",3],["options",3],["canPauseProtection",3,23],["isPasswordProtected",3,23],["isPaused",3,23],["savedOptions",3,23]],[["allowEditRanges","AllowEditRangeCollection",19,23,0,4]],[["protect",2,1],["unprotect",1],["checkPassword",1,2,23,4],["pauseProtection",1,0,23],["resumeProtection",0,0,23],["setPassword",1,0,23],["updateOptions",1,0,23]]],["WorksheetFreezePanes",0,0,0,[["unfreeze",0,0,0,2,0,38],["freezeAt",1,0,0,2,0,38],["freezeRows",1,0,0,2,0,38],["freezeColumns",1,0,0,2,0,38]],[["getLocation","Range",0,10,0,4],["getLocationOrNullObject","Range",0,10,0,4]]],["Range",14,[["numberFormat",5,0,0,2,39],["numberFormatLocal",1,15,0,2,39],["values",5,0,0,2,39],["text",3],["formulas",5,0,0,2,40],["formulasLocal",5,0,0,2,40],["rowIndex",3],["columnIndex",3],["rowCount",3],["columnCount",3],["address",3],["addressLocal",3],["cellCount",3],["_ReferenceId",2],["valueTypes",3],["formulasR1C1",5,17,0,2,7],["hidden",3,17],["rowHidden",1,17,0,2,40],["columnHidden",1,17,0,2,40],["isEntireColumn",3,15],["isEntireRow",3,15],["hyperlink",1,15,0,2,41],["style",1,15,0,2,40],["linkedDataTypeState",3,11],["hasSpill",3,33],["top",3,21],["left",3,21],["height",3,21],["width",3,21],["savedAsArray",3,33],["numberFormatCategories",3,33],["valuesAsJson",5,29,0,2,42],["valuesAsJsonLocal",5,29,0,2,42],["addressR1C1",2,4],["control",0,37,0,2,7]],[["format","RangeFormat",35,0,0,4],["worksheet","Worksheet",2,0,0,4],["sort","RangeSort",3,17,0,4],["conditionalFormats","ConditionalFormatCollection",19,13,0,4],["dataValidation","DataValidation",35,10,0,4]],[["clear",1,0,0,2,0,40],["delete",1,0,0,2,0,43],["select",0,2],["_KeepReference",0,2],["merge",1,0,17,2,0,40],["unmerge",0,0,17,2,0,42],["_ValidateArraySize",2,2,18,4],["calculate",0,0,13,2,0,35],["showCard",0,0,15,2,0,42],["getImage",0,2,15,4],["replaceAll",3,0,11,2,0,40],["copyFrom",4,0,11,2,0,32],["convertToLinkedDataType",2,0,11,2,0,38],["convertDataTypeToText",0,0,11,2,0,38],["setDirty",0,0,11,2,0,42],["getCellProperties",1,0,11,2,0,42],["getRowProperties",1,0,11,2,0,42],["getColumnProperties",1,0,11,2,0,42],["setCellProperties",1,0,11,2,0,42],["setRowProperties",1,0,11,2,0,42],["setColumnProperties",1,0,11,2,0,42],["autoFill",2,0,11,2,0,44],["showTeachingCallout",2,0,11,2,0,42],["flashFill",0,0,11,2,0,42],["group",1,0,21,2,0,42],["ungroup",1,0,21,2,0,42],["showGroupDetails",1,0,21,2,0,42],["hideGroupDetails",1,0,21,2,0,42],["moveTo",1,0,12,2,0,32],["getDataClassificationIds",0,2,23,4],["setExternalCodeServiceFormulasWithoutLicense",1,0,4,1],["getPythonObjectReferenceIds",0,0,4,3,0,42],["clearOrResetContents",0,0,37,2,0,7]],[["getCell","Range",2,10,0,4],["getUsedRange","Range",1,10,0,4],["insert","Range",1,8,0,2,0,0,43],["getEntireColumn","Range",0,10,0,4],["getEntireRow","Range",0,10,0,4],["getOffsetRange","Range",2,10,0,4],["getRow","Range",1,10,0,4],["getColumn","Range",1,10,0,4],["getIntersection","Range",1,10,0,4],["getBoundingRect","Range",1,10,0,4],["getLastCell","Range",0,10,0,4],["getLastColumn","Range",0,10,0,4],["getLastRow","Range",0,10,0,4],["getIntersectionOrNullObject","Range",1,10,19,4],["getRowsAbove","Range",1,11,18,4],["getRowsBelow","Range",1,11,18,4],["getColumnsBefore","Range",1,11,18,4],["getColumnsAfter","Range",1,11,18,4],["getResizedRange","Range",2,11,18,4],["getVisibleView","RangeView",0,2,18,4],["getUsedRangeOrNullObject","Range",1,10,19,4],["getSurroundingRegion","Range",0,10,15,4],["getAbsoluteResizedRange","Range",2,10,15,4],["getTables","TableScopedCollection",1,6,11,4],["find","Range",2,10,11,4],["findOrNullObject","Range",2,10,11,4],["removeDuplicates","RemoveDuplicatesResult",2,8,11,2,0,0,41],["getSpecialCells","RangeAreas",2,10,11,4],["getSpecialCellsOrNullObject","RangeAreas",2,10,11,4],["getSpillingToRange","Range",0,10,33,4],["getSpillParent","Range",0,10,33,4],["getSpillingToRangeOrNullObject","Range",0,10,33,4],["getSpillParentOrNullObject","Range",0,10,33,4],["getMergedAreas","RangeAreas",0,10,23,4],["getPivotTables","PivotTableScopedCollection",1,6,33,4],["getPrecedents","WorkbookRangeAreas",0,10,22,4],["getDirectPrecedents","WorkbookRangeAreas",0,10,33,4],["getDependents","WorkbookRangeAreas",0,10,45,4],["getDirectDependents","WorkbookRangeAreas",0,10,28,4],["getExtendedRange","Range",2,10,28,4],["getRangeEdge","Range",2,10,28,4],["getNumberFormatProperties","NumberFormatPropertyCollection",0,6,4,4],["getSurroundingDataRegion","Range",0,2,4,4],["getMergedAreasOrNullObject","RangeAreas",0,0,28,2,0,0,39]]],["RangeAreas",2,[["_ReferenceId",2],["address",3],["addressLocal",3],["areaCount",3],["cellCount",3],["isEntireColumn",3],["isEntireRow",3],["style",1,0,0,2,42],["addressR1C1",2,4]],[["areas","RangeCollection",19,0,0,4],["conditionalFormats","ConditionalFormatCollection",19,0,0,4],["format","RangeFormat",35,0,0,4],["dataValidation","DataValidation",35,0,0,4],["worksheet","Worksheet",2,0,0,4]],[["_KeepReference",0,2],["calculate",0,0,0,2,0,42],["clear",1,0,0,2,0,42],["setDirty",0,0,0,2,0,42],["copyFrom",4,0,0,2,0,42],["convertToLinkedDataType",2,0,0,2,0,38],["convertDataTypeToText",0,0,0,2,0,38],["select",0,2,4],["clearOrResetContents",0,0,37,2,0,7]],[["getEntireColumn","RangeAreas",0,10,0,4],["getEntireRow","RangeAreas",0,10,0,4],["getIntersection","RangeAreas",1,10,0,4],["getIntersectionOrNullObject","RangeAreas",1,10,0,4],["getOffsetRangeAreas","RangeAreas",2,10,0,4],["getUsedRangeAreas","RangeAreas",1,10,0,4],["getUsedRangeAreasOrNullObject","RangeAreas",1,10,0,4],["getTables","TableScopedCollection",1,6,0,4],["getSpecialCells","RangeAreas",2,10,0,4],["getSpecialCellsOrNullObject","RangeAreas",2,10,0,4]]],["WorkbookRangeAreas",2,[["_ReferenceId",2],["addresses",3]],[["ranges","RangeCollection",19,0,0,4],["areas","RangeAreasCollection",19,0,0,4]],[["_KeepReference",0,2]],[["getRangeAreasBySheet","RangeAreas",1,10,0,4],["getRangeAreasOrNullObjectBySheet","RangeAreas",1,10,0,4]]],["RangeView",0,[["numberFormat",1,0,0,2,42],["values",1,0,0,2,42],["text",3],["formulas",1,0,0,2,42],["formulasLocal",1,0,0,2,42],["formulasR1C1",1,0,0,2,42],["valueTypes",3],["rowCount",3],["columnCount",3],["cellAddresses",3],["index",3],["valuesAsJson",1,29,0,2,42],["valuesAsJsonLocal",1,29,0,2,42]],[["rows","RangeViewCollection",19,0,0,4]],0,[["getRange","Range",0,10,0,4]]],["RangeViewCollection",1,0,0,[["getCount",0,2,19,4]],[["getItemAt","RangeView",1,2,0,4]],0,"RangeView"],["SettingCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","Setting",1,18,0,4],["add","Setting",2,9],["getItemOrNullObject","Setting",1,2,0,4]],0,"Setting",[["SettingsChanged",3,0,"_CC.office10EventIdSettingsChangedEvent","","",""]]],["Setting",8,[["key",3],["value",5],["_Id",2]],0,[["delete"]]],["NamedItemCollection",5,0,0,[["getCount",0,2,19,4],["_RegisterAddedEvent",0,0,5,2,0,1],["_RegisterDeletedEvent",0,0,5,2,0,1],["_UnregisterAddedEvent",0,0,5,2,0,1],["_UnregisterDeletedEvent",0,0,5,2,0,1]],[["getItem","NamedItem",1,18,0,4],["getItemOrNullObject","NamedItem",1,2,19,4],["add","NamedItem",3,8,19,2,0,0,38],["addFormulaLocal","NamedItem",3,0,19,2,0,0,38]],0,"NamedItem",[["Added",0,5,"MessageType.namedItemAddedEvent","this._eventTargetId","_RegisterAddedEvent","_UnregisterAddedEvent"],["Deleted",0,5,"MessageType.namedItemDeletedEvent","this._eventTargetId","_RegisterDeletedEvent","_UnregisterDeletedEvent"]]],["NamedItem",0,[["name",3],["type",3],["value",3],["visible",1],["_Id",2],["comment",1,19],["scope",3,19],["formula",1,15,0,2,38],["valueAsJson",3,29],["valueAsJsonLocal",3,29]],[["worksheet","Worksheet",2,19,0,4],["worksheetOrNullObject","Worksheet",2,19,0,4],["arrayValues","NamedItemArrayValues",3,15,0,4]],[["delete",0,0,19,2,0,38]],[["getRange","Range",0,10,0,4],["getRangeOrNullObject","Range",0,10,19,4]]],["NamedItemArrayValues",0,[["values",3],["types",3],["valuesAsJson",3,29],["valuesAsJsonLocal",3,29]]],["Binding",0,[["id",3],["type",3]],0,[["getText",0,2,0,4],["delete",0,0,18,2,0,7]],[["getTable","Table",0,2,0,4],["getRange","Range",0,2,0,4]],0,0,[["DataChanged",3,18,"_CC.office10EventIdBindingDataChangedEvent","this.id","",""],["SelectionChanged",3,18,"_CC.office10EventIdBindingSelectionChangedEvent","this.id","",""]]],["BindingCollection",1,[["count",3]],0,[["getCount",0,2,19,4]],[["getItem","Binding",1,18,0,4],["getItemAt","Binding",1,2,0,4],["add","Binding",3,8,18,2,0,0,7],["addFromNamedItem","Binding",3,0,18,2,0,0,38],["addFromSelection","Binding",2,0,18,2,0,0,38],["getItemOrNullObject","Binding",1,2,19,4]],0,"Binding"],["TableCollection",5,[["count",3]],0,[["getCount",0,2,19,4],["_RegisterDataChangedEvent",0,0,15,2,0,1],["_UnregisterDataChangedEvent",0,0,15,2,0,1],["_RegisterAddedEvent",0,0,11,2,0,1],["_UnregisterAddedEvent",0,0,11,2,0,1],["_RegisterDeletedEvent",0,0,11,2,0,1],["_UnregisterDeletedEvent",0,0,11,2,0,1],["_RegisterFilteredEvent",0,0,4,2,0,1],["_UnregisterFilteredEvent",0,0,4,2,0,1]],[["getItem","Table",1,18,0,4],["getItemAt","Table",1,2,0,4],["add","Table",2,8,0,2,0,0,41],["getItemOrNullObject","Table",1,2,19,4],["addQueryTable","Table",2,0,4]],0,"Table",[["Added",0,11,"MessageType.tableAddedEvent","this._eventTargetId","_RegisterAddedEvent","_UnregisterAddedEvent"],["Changed",2,15,"MessageType.tableDataChangedEvent","this._eventTargetId","_RegisterDataChangedEvent","_UnregisterDataChangedEvent"],["Deleted",0,11,"MessageType.tableDeletedEvent","this._eventTargetId","_RegisterDeletedEvent","_UnregisterDeletedEvent"],["Filtered",0,4,"MessageType.tableFilteredEvent","this._eventTargetId","_RegisterFilteredEvent","_UnregisterFilteredEvent"]]],["TableScopedCollection",1,0,0,[["getCount",0,2,0,4]],[["getFirst","Table",0,10,0,4],["getItem","Table",1,18,0,4],["getItemOrNullObject","Table",1,2,22,4]],0,"Table"],["Table",24,[["id",3],["name",1,0,0,2,32],["showHeaders",1,0,0,2,41],["showTotals",1,0,0,2,41],["style",1,0,0,2,41],["highlightFirstColumn",1,18,0,2,41],["highlightLastColumn",1,18,0,2,41],["showBandedRows",1,18,0,2,41],["showBandedColumns",1,18,0,2,41],["showFilterButton",1,18,0,2,41],["legacyId",3,10],["isMsFormConnected",0,4],["maxMsFormResponseId",0,4],["msFormId",0,4],["latestMsFormEventMarker",0,4],["syncedQuestionIds",0,4]],[["columns","TableColumnCollection",19,0,0,4],["rows","TableRowCollection",19,0,0,4],["sort","TableSort",3,17,0,4],["worksheet","Worksheet",2,17,0,4],["autoFilter","AutoFilter",3,11,0,4],["tableStyle","TableStyle",35,4,0,4]],[["delete",0,0,0,2,0,32],["clearFilters",0,0,17,2,0,38],["reapplyFilters",0,0,17,2,0,32],["_RegisterSelectionChangedEvent",0,0,15,2,0,1],["_UnregisterSelectionChangedEvent",0,0,15,2,0,1],["_RegisterDataChangedEvent",0,0,15,2,0,1],["_UnregisterDataChangedEvent",0,0,15,2,0,1],["clearStyle",0,0,4],["_RegisterFilteredEvent",0,0,4,2,0,1],["_UnregisterFilteredEvent",0,0,4,2,0,1],["resize",1,0,28,2,0,32],["setStyle",1,0,4],["applyPowerQueryTableUpdatePlan",2,0,4,2],["addSyncedQuestionId",1,0,4],["_RegisterEventApplyPowerQueryTableUpdatePlanCompleted",0,2,4,4],["_UnregisterEventApplyPowerQueryTableUpdatePlanCompleted",0,2,4,4]],[["getRange","Range",0,10,0,4],["getHeaderRowRange","Range",0,10,0,4],["getDataBodyRange","Range",0,10,0,4],["getTotalRowRange","Range",0,10,0,4],["convertToRange","Range",0,8,17,2,0,0,32]],"workbook.tables",0,[["ApplyPowerQueryTableUpdatePlanCompleted",0,4,"MessageType.tableApplyPowerQueryTableUpdatePlanCompletedEvent","this.id","_RegisterEventApplyPowerQueryTableUpdatePlanCompleted","_UnregisterEventApplyPowerQueryTableUpdatePlanCompleted"],["Changed",2,15,"MessageType.tableDataChangedEvent","this.id","_RegisterDataChangedEvent","_UnregisterDataChangedEvent"],["Filtered",0,4,"MessageType.tableFilteredEvent","this.id","_RegisterFilteredEvent","_UnregisterFilteredEvent"],["SelectionChanged",2,15,"MessageType.tableSelectionChangedEvent","this.id","_RegisterSelectionChangedEvent","_UnregisterSelectionChangedEvent"]]],["TableColumnCollection",1,[["count",3]],0,[["getCount",0,2,19,4]],[["getItem","TableColumn",1,18,0,4],["getItemAt","TableColumn",1,2,0,4],["add","TableColumn",3,8,0,2,0,0,43],["getItemOrNullObject","TableColumn",1,2,19,4],["addAsJson","TableColumn",3,0,29,2,0,0,38]],0,"TableColumn"],["TableColumn",0,[["id",3],["index",3],["values",1,0,0,2,7],["name",1,0,0,2,7],["valuesAsJson",1,29,0,2,38],["valuesAsJsonLocal",1,29,0,2,38],["msFormQuestionId",0,4]],[["filter","Filter",3,17,0,4]],[["delete",0,0,0,2,0,43]],[["getRange","Range",0,10,0,4],["getHeaderRowRange","Range",0,10,0,4],["getDataBodyRange","Range",0,10,0,4],["getTotalRowRange","Range",0,10,0,4]]],["TableRowCollection",1,[["count",3]],0,[["getCount",0,2,19,4],["deleteRows",1,0,23,2,0,38],["deleteRowsAt",2,0,23,2,0,32]],[["getItemAt","TableRow",1,2,0,4],["add","TableRow",3,8,0,2,0,0,43],["addAsJson","TableRow",3,0,29,2,0,0,38]],0,"TableRow"],["TableRow",0,[["index",3],["values",1,0,0,2,7],["valuesAsJson",1,29,0,2,38],["valuesAsJsonLocal",1,29,0,2,38]],0,[["delete",0,0,0,2,0,43]],[["getRange","Range",0,10,0,4]]],["DataValidation",0,[["type",3],["rule",1,0,0,2,8],["prompt",1,0,0,2,8],["errorAlert",1,0,0,2,8],["ignoreBlanks",1,0,0,2,8],["valid",3]],0,[["clear",0,0,0,2,0,8]],[["getInvalidCells","RangeAreas",0,10,11,4],["getInvalidCellsOrNullObject","RangeAreas",0,10,11,4]]],["RemoveDuplicatesResult",0,[["removed",3],["uniqueRemaining",3]]],["RangeFormat",0,[["wrapText",1,0,0,2,40],["horizontalAlignment",1,0,0,2,40],["verticalAlignment",1,0,0,2,40],["columnWidth",1,17,0,2,40],["rowHeight",1,17,0,2,40],["textOrientation",1,15,0,2,40],["useStandardHeight",1,15,0,2,46],["useStandardWidth",1,15,0,2,46],["readingOrder",1,11],["shrinkToFit",1,11],["indentLevel",1,11,0,2,40],["autoIndent",1,11]],[["fill","RangeFill",35,0,0,4],["font","RangeFont",35,0,0,4],["borders","RangeBorderCollection",51,0,0,4],["protection","FormatProtection",35,17,0,4]],[["autofitColumns",0,0,17,2,0,40],["autofitRows",0,0,17,2,0,40],["adjustIndent",1,0,12,2,0,43]]],["FormatProtection",0,[["locked",1],["formulaHidden",1]]],["RangeFill",0,[["color",1,0,0,2,40],["tintAndShade",1,11],["patternTintAndShade",1,11],["pattern",1,11],["patternColor",1,11]],0,[["clear",0,0,0,2,0,40]]],["RangeBorder",0,[["sideIndex",3],["style",1,0,0,2,40],["weight",1,0,0,2,40],["color",1,0,0,2,40],["tintAndShade",1,11]]],["RangeBorderCollection",1,[["count",3],["tintAndShade",1,11]],0,0,[["getItem","RangeBorder",1,18,0,4],["getItemAt","RangeBorder",1,2,0,4]],0,"RangeBorder"],["RangeFont",0,[["name",1,0,0,2,40],["size",1,0,0,2,40],["color",1,0,0,2,16],["italic",1,0,0,2,40],["bold",1,0,0,2,40],["underline",1,0,0,2,40],["strikethrough",1,11,0,2,40],["subscript",1,11],["superscript",1,11],["tintAndShade",1,11]]],["ChartCollection",5,[["count",3]],0,[["getCount",0,2,19,4],["_RegisterAddedEvent",0,0,10,2,0,1],["_UnregisterAddedEvent",0,0,10,2,0,1],["_RegisterActivatedEvent",0,0,10,2,0,36],["_UnregisterActivatedEvent",0,0,10,2,0,36],["_RegisterDeactivatedEvent",0,0,10,2,0,36],["_UnregisterDeactivatedEvent",0,0,10,2,0,36],["_RegisterDeletedEvent",0,0,10,2,0,36],["_UnregisterDeletedEvent",0,0,10,2,0,36]],[["add","Chart",3,9,0,2,0,0,47],["getItemAt","Chart",1,2,0,4],["_GetItem","Chart",1,18,0,4],["getItem","Chart",1,2,0,4],["getItemOrNullObject","Chart",1,2,19,4]],0,"Chart",[["Activated",0,10,"MessageType.chartActivatedEvent","this._ParentObject.id","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["Added",0,10,"MessageType.chartAddedEvent","this._ParentObject.id","_RegisterAddedEvent","_UnregisterAddedEvent"],["Deactivated",0,10,"MessageType.chartDeactivatedEvent","this._ParentObject.id","_RegisterDeactivatedEvent","_UnregisterDeactivatedEvent"],["Deleted",0,10,"MessageType.chartDeletedEvent","this._ParentObject.id","_RegisterDeletedEvent","_UnregisterDeletedEvent"]]],["Chart",0,[["name",1,0,0,2,44],["top",1,0,0,2,47],["left",1,0,0,2,47],["width",1,0,0,2,47],["height",1,0,0,2,47],["id",3,15],["showAllFieldButtons",1,15,0,2,47],["chartType",1,15,0,2,44],["showDataLabelsOverMaximum",1,10,0,2,48],["categoryLabelLevel",1,10,0,2,48],["style",1,10,0,2,48],["displayBlanksAs",1,10,0,2,48],["plotBy",1,10,0,2,44],["plotVisibleOnly",1,10,0,2,48],["seriesNameLevel",1,10,0,2,48]],[["title","ChartTitle",35,0,0,4],["dataLabels","ChartDataLabels",35,0,0,4],["legend","ChartLegend",35,0,0,4],["series","ChartSeriesCollection",19,0,0,4],["axes","ChartAxes",35,0,0,4],["format","ChartAreaFormat",35,0,0,4],["worksheet","Worksheet",2,17,0,4],["plotArea","ChartPlotArea",35,10,0,4],["pivotOptions","ChartPivotOptions",35,11,0,4]],[["setData",2,1,0,2,0,47],["delete",0,0,0,2,0,47],["setPosition",2,0,0,2,0,47],["getImage",3,2,17,4],["_RegisterActivatedEvent",0,0,10,2,0,1],["_UnregisterActivatedEvent",0,0,10,2,0,1],["_RegisterDeactivatedEvent",0,0,10,2,0,1],["_UnregisterDeactivatedEvent",0,0,10,2,0,1],["activate",0,2,11],["getDataRange",0,0,34],["getDataRangeOrNullObject",0,0,34]],[["getDataTable","ChartDataTable",0,2,22,4],["getDataTableOrNullObject","ChartDataTable",0,2,22,4]],0,0,[["Activated",0,10,"MessageType.chartActivatedEvent","this.id","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["Deactivated",0,10,"MessageType.chartDeactivatedEvent","this.id","_RegisterDeactivatedEvent","_UnregisterDeactivatedEvent"]]],["ChartPivotOptions",0,[["showAxisFieldButtons",1,0,0,2,48],["showLegendFieldButtons",1,0,0,2,48],["showReportFilterFieldButtons",1,0,0,2,48],["showValueFieldButtons",1,0,0,2,48]]],["ChartAreaFormat",0,[["roundedCorners",1,11,0,2,44],["colorScheme",1,11,0,2,48]],[["fill","ChartFill",3,0,0,4],["font","ChartFont",35,0,0,4],["border","ChartBorder",35,15,0,4]]],["ChartSeriesCollection",1,[["count",3]],0,[["getCount",0,2,19,4]],[["getItemAt","ChartSeries",1,2,0,4],["add","ChartSeries",2,8,15,2,0,0,47]],0,"ChartSeries"],["ChartSeries",0,[["name",1,0,0,2,47],["chartType",1,15,0,2,14],["hasDataLabels",1,15,0,2,44],["filtered",1,15,0,2,48],["markerSize",1,15,0,2,47],["markerStyle",1,15,0,2,47],["showShadow",1,15,0,2,44],["markerBackgroundColor",1,15,0,2,47],["markerForegroundColor",1,15,0,2,47],["smooth",1,15,0,2,44],["plotOrder",1,15,0,2,44],["gapWidth",1,15,0,2,47],["doughnutHoleSize",1,15,0,2,47],["axisGroup",1,10,0,2,47],["explosion",1,10,0,2,44],["firstSliceAngle",1,10,0,2,44],["invertIfNegative",1,10,0,2,44],["bubbleScale",1,11,0,2,44],["secondPlotSize",1,10,0,2,44],["splitType",1,10,0,2,44],["splitValue",1,11,0,2,44],["varyByCategories",1,10,0,2,44],["showLeaderLines",1,11,0,2,48],["overlap",1,10,0,2,47],["gradientStyle",1,11,0,2,48],["gradientMinimumType",1,11,0,2,48],["gradientMidpointType",1,11,0,2,48],["gradientMaximumType",1,11,0,2,48],["gradientMinimumValue",1,11,0,2,48],["gradientMidpointValue",1,11,0,2,48],["gradientMaximumValue",1,11,0,2,48],["gradientMinimumColor",1,11,0,2,48],["gradientMidpointColor",1,11,0,2,48],["gradientMaximumColor",1,11,0,2,48],["parentLabelStrategy",1,11,0,2,44],["showConnectorLines",1,11,0,2,44],["invertColor",1,11,0,2,44]],[["points","ChartPointsCollection",19,0,0,4],["format","ChartSeriesFormat",35,0,0,4],["trendlines","ChartTrendlineCollection",19,15,0,4],["xErrorBars","ChartErrorBars",35,11,0,4],["yErrorBars","ChartErrorBars",35,11,0,4],["dataLabels","ChartDataLabels",35,10,0,4],["binOptions","ChartBinOptions",35,11,0,4],["mapOptions","ChartMapOptions",35,11,0,4],["boxwhiskerOptions","ChartBoxwhiskerOptions",35,11,0,4]],[["delete",0,0,15,2,0,47],["setXAxisValues",1,0,15,2,0,47],["setValues",1,0,15,2,0,47],["setBubbleSizes",1,0,15,2,0,48],["getDimensionValues",1,0,33,2,0,48],["getDimensionDataSourceString",1,0,45],["getDimensionDataSourceType",1,0,45]]],["ChartSeriesFormat",0,0,[["fill","ChartFill",3,0,0,4],["line","ChartLineFormat",35,0,0,4]]],["ChartPointsCollection",1,[["count",3]],0,[["getCount",0,2,19,4]],[["getItemAt","ChartPoint",1,2,0,4]],0,"ChartPoint"],["ChartPoint",0,[["value",3],["hasDataLabel",1,15,0,2,44],["markerStyle",1,15,0,2,47],["markerSize",1,15,0,2,47],["markerBackgroundColor",1,15,0,2,47],["markerForegroundColor",1,15,0,2,47]],[["format","ChartPointFormat",35,0,0,4],["dataLabel","ChartDataLabel",35,15,0,4]]],["ChartPointFormat",0,0,[["fill","ChartFill",3,0,0,4],["border","ChartBorder",35,15,0,4]]],["ChartAxes",0,0,[["categoryAxis","ChartAxis",35,0,0,4],["seriesAxis","ChartAxis",35,0,0,4],["valueAxis","ChartAxis",35,0,0,4]],0,[["getItem","ChartAxis",2,2,15,4]]],["ChartAxis",0,[["majorUnit",1,0,0,2,44],["maximum",1,0,0,2,47],["minimum",1,0,0,2,47],["minorUnit",1,0,0,2,44],["displayUnit",1,15,0,2,47],["showDisplayUnitLabel",1,15,0,2,44],["customDisplayUnit",3,15],["type",3,15],["minorTimeUnitScale",1,15,0,2,44],["majorTimeUnitScale",1,15,0,2,44],["baseTimeUnit",1,15,0,2,44],["categoryType",1,15,0,2,44],["axisGroup",3,15],["scaleType",1,15,0,2,44],["logBase",1,15,0,2,44],["left",3,15],["top",3,15],["height",3,15],["width",3,15],["reversePlotOrder",1,15,0,2,47],["crosses",1,15,0,2,47],["crossesAt",3,15],["visible",1,15,0,2,44],["isBetweenCategories",1,10,0,2,47],["majorTickMark",1,15,0,2,44],["minorTickMark",1,15,0,2,44],["tickMarkSpacing",1,15,0,2,44],["tickLabelPosition",1,15,0,2,47],["tickLabelSpacing",1,15,0,2,44],["alignment",1,10,0,2,44],["multiLevel",1,10,0,2,44],["numberFormat",1,10,0,2,44],["linkNumberFormat",1,11,0,2,44],["offset",1,10,0,2,44],["textOrientation",1,10,0,2,44],["position",1,10,0,2,47],["positionAt",3,10]],[["majorGridlines","ChartGridlines",35,0,0,4],["minorGridlines","ChartGridlines",35,0,0,4],["title","ChartAxisTitle",35,0,0,4],["format","ChartAxisFormat",35,0,0,4]],[["setCategoryNames",1,0,15,2,0,48],["setCustomDisplayUnit",1,0,15,2,0,48],["setCrossesAt",1,0,15,2,0,44],["setPositionAt",1,0,10,2,0,44]]],["ChartAxisFormat",0,0,[["font","ChartFont",35,0,0,4],["line","ChartLineFormat",35,0,0,4],["fill","ChartFill",3,10,0,4]]],["ChartAxisTitle",0,[["text",1,0,0,2,47],["visible",1,0,0,2,44],["textOrientation",1,33,0,2,44]],[["format","ChartAxisTitleFormat",35,0,0,4]],[["setFormula",1,0,10,2,0,44]]],["ChartAxisTitleFormat",0,0,[["font","ChartFont",35,0,0,4],["fill","ChartFill",3,10,0,4],["border","ChartBorder",35,10,0,4]]],["ChartDataLabels",0,[["position",1,0,0,2,44],["showValue",1,0,0,2,44],["showSeriesName",1,0,0,2,48],["showCategoryName",1,0,0,2,44],["showLegendKey",1,0,0,2,44],["showPercentage",1,0,0,2,44],["showBubbleSize",1,0,0,2,44],["separator",1,0,0,2,44],["numberFormat",1,10,0,2,44],["linkNumberFormat",1,11,0,2,44],["textOrientation",1,10,0,2,44],["autoText",1,10,0,2,44],["horizontalAlignment",1,10,0,2,44],["verticalAlignment",1,10,0,2,44],["showAsStickyCallout",3,49],["geometricShapeType",1,24,0,2,48],["showLeaderLines",1,49,0,2,48]],[["format","ChartDataLabelFormat",35,0,0,4],["leaderLines","ChartLeaderLines",35,49,0,4]]],["ChartDataLabel",0,[["position",1,0,0,2,44],["showValue",1,0,0,2,44],["showSeriesName",1,0,0,2,44],["showCategoryName",1,0,0,2,44],["showLegendKey",1,0,0,2,44],["showPercentage",1,0,0,2,44],["showBubbleSize",1,0,0,2,44],["separator",1,0,0,2,44],["top",1,10,0,2,44],["left",1,10,0,2,44],["width",3,10],["height",3,10],["formula",1,10,0,2,44],["textOrientation",1,10,0,2,44],["horizontalAlignment",1,10,0,2,44],["verticalAlignment",1,10,0,2,44],["text",1,10,0,2,44],["autoText",1,10,0,2,44],["numberFormat",1,10,0,2,44],["linkNumberFormat",1,11,0,2,44],["geometricShapeType",1,24,0,2,48],["showAsStickyCallout",3,49,0,2,48]],[["format","ChartDataLabelFormat",35,10,0,4]],[["setWidth",1,0,30,2,0,48],["setHeight",1,0,30,2,0,48]],[["getSubstring","ChartFormatString",2,2,24,4],["getTailAnchor","ChartDataLabelAnchor",0,2,49,4]]],["ChartDataLabelFormat",0,0,[["font","ChartFont",35,0,0,4],["fill","ChartFill",3,0,0,4],["border","ChartBorder",35,10,0,4]]],["ChartDataLabelAnchor",0,[["left",1,0,0,2,48],["top",1,0,0,2,48]]],["ChartDataTable",0,[["visible",1,0,0,2,44],["showLegendKey",1,0,0,2,44],["showHorizontalBorder",1,0,0,2,44],["showVerticalBorder",1,0,0,2,44],["showOutlineBorder",1,0,0,2,44]],[["format","ChartDataTableFormat",35,0,0,4]]],["ChartDataTableFormat",0,0,[["fill","ChartFill",3,0,0,4],["font","ChartFont",35,0,0,4],["border","ChartBorder",35,0,0,4]]],["ChartErrorBars",0,[["endStyleCap",1,0,0,2,44],["include",1,0,0,2,44],["type",1,0,0,2,44],["visible",1,0,0,2,44]],[["format","ChartErrorBarsFormat",35,0,0,4]]],["ChartErrorBarsFormat",0,0,[["line","ChartLineFormat",35,0,0,4]]],["ChartGridlines",0,[["visible",1,0,0,2,47]],[["format","ChartGridlinesFormat",35,0,0,4]]],["ChartGridlinesFormat",0,0,[["line","ChartLineFormat",35,0,0,4]]],["ChartLegend",0,[["visible",1,0,0,2,47],["position",1,0,0,2,47],["overlay",1,0,0,2,44],["left",1,15,0,2,44],["top",1,15,0,2,44],["width",1,15,0,2,44],["height",1,15,0,2,44],["showShadow",1,15,0,2,44]],[["format","ChartLegendFormat",35,0,0,4],["legendEntries","ChartLegendEntryCollection",19,15,0,4]]],["ChartLegendEntry",0,[["visible",1,0,0,2,44],["left",3,10],["top",3,10],["width",3,10],["height",3,10],["index",3,10]]],["ChartLegendEntryCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","ChartLegendEntry",1,2,0,4]],0,"ChartLegendEntry"],["ChartLegendFormat",0,0,[["font","ChartFont",35,0,0,4],["fill","ChartFill",3,0,0,4],["border","ChartBorder",35,10,0,4]]],["ChartMapOptions",0,[["level",1,0,0,2,48],["labelStrategy",1,0,0,2,48],["projectionType",1,0,0,2,48]]],["ChartTitle",0,[["visible",1,0,0,2,44],["text",1,0,0,2,47],["overlay",1,0,0,2,44],["horizontalAlignment",1,15,0,2,44],["top",1,15,0,2,44],["left",1,15,0,2,44],["width",3,15],["height",3,15],["verticalAlignment",1,15,0,2,44],["textOrientation",1,15,0,2,44],["position",1,15,0,2,44],["showShadow",1,15,0,2,44]],[["format","ChartTitleFormat",35,0,0,4]],[["setFormula",1,0,15,2,0,44]],[["getSubstring","ChartFormatString",2,2,15,4]]],["ChartFormatString",0,0,[["font","ChartFont",35,0,0,4]]],["ChartTitleFormat",0,0,[["font","ChartFont",35,0,0,4],["fill","ChartFill",3,0,0,4],["border","ChartBorder",35,15,0,4]]],["ChartFill",4,0,0,[["setSolidColor",1,0,0,2,0,47],["clear",0,0,0,2,0,44],["getSolidColor",0,0,29,2,0,47]]],["ChartBorder",0,[["color",1,0,0,2,47],["lineStyle",1,0,0,2,47],["weight",1,0,0,2,47]],0,[["clear",0,0,10,2,0,44]]],["ChartBinOptions",0,[["type",1,0,0,2,47],["width",1,0,0,2,47],["count",1,0,0,2,47],["allowOverflow",1,0,0,2,47],["allowUnderflow",1,0,0,2,47],["overflowValue",1,0,0,2,47],["underflowValue",1,0,0,2,47]]],["ChartBoxwhiskerOptions",0,[["showInnerPoints",1,0,0,2,44],["showOutlierPoints",1,0,0,2,44],["showMeanMarker",1,0,0,2,44],["showMeanLine",1,0,0,2,44],["quartileCalculation",1,0,0,2,44]]],["ChartLineFormat",0,[["color",1,0,0,2,47],["lineStyle",1,15,0,2,47],["weight",1,15,0,2,47]],0,[["clear",0,0,0,2,0,44]]],["ChartFont",0,[["bold",1,0,0,2,44],["color",1,0,0,2,47],["italic",1,0,0,2,44],["name",1,0,0,2,44],["size",1,0,0,2,44],["underline",1,0,0,2,44]]],["ChartTrendline",0,[["type",1,0,0,2,44],["polynomialOrder",1,0,0,2,44],["movingAveragePeriod",1,0,0,2,44],["_Id",2],["showEquation",1,10,0,2,44],["showRSquared",1,10,0,2,44],["forwardPeriod",1,10,0,2,44],["backwardPeriod",1,10,0,2,44],["name",1,0,0,2,44],["intercept",1,0,0,2,44]],[["format","ChartTrendlineFormat",35,0,0,4],["label","ChartTrendlineLabel",35,10,0,4]],[["delete",0,0,0,2,0,44]]],["ChartTrendlineCollection",1,0,0,[["getCount",0,2,0,4]],[["add","ChartTrendline",1,8,0,2,0,0,47],["getItem","ChartTrendline",1,18,0,4]],0,"ChartTrendline"],["ChartTrendlineFormat",0,0,[["line","ChartLineFormat",35,0,0,4]]],["ChartTrendlineLabel",0,[["top",1,0,0,2,44],["left",1,0,0,2,44],["width",3],["height",3],["formula",1,0,0,2,48],["textOrientation",1,0,0,2,44],["horizontalAlignment",1,0,0,2,44],["verticalAlignment",1,0,0,2,44],["text",1,0,0,2,48],["autoText",1,0,0,2,44],["numberFormat",1,0,0,2,44],["linkNumberFormat",1,11,0,2,44]],[["format","ChartTrendlineLabelFormat",35,0,0,4]]],["ChartTrendlineLabelFormat",0,0,[["fill","ChartFill",3,0,0,4],["border","ChartBorder",35,0,0,4],["font","ChartFont",35,0,0,4]]],["ChartPlotArea",0,[["left",1,0,0,2,44],["top",1,0,0,2,44],["width",1,0,0,2,44],["height",1,0,0,2,44],["insideLeft",1,0,0,2,44],["insideTop",1,0,0,2,44],["insideWidth",1,0,0,2,44],["insideHeight",1,0,0,2,44],["position",1,0,0,2,44]],[["format","ChartPlotAreaFormat",35,0,0,4]]],["ChartPlotAreaFormat",0,0,[["border","ChartBorder",35,0,0,4],["fill","ChartFill",3,0,0,4]]],["ChartLeaderLines",0,0,[["format","ChartLeaderLinesFormat",35,0,0,4,0,48]]],["ChartLeaderLinesFormat",0,0,[["line","ChartLineFormat",35,0,0,4,0,48]]],["VisualCollection",5,0,0,[["getDefinitions",0,2,0,4],["getPreview",4,2,0,4],["bootstrapAgaveVisual",0,0,0,2],["getCount",0,2,0,4],["_RegisterSelectionChangedEvent",0,2],["_UnregisterSelectionChangedEvent",0,2]],[["add","Visual",3,8,0,2],["_GetItem","Visual",1,18,0,4],["getSelectedOrNullObject","Visual",0,2,0,4]],0,"Visual",[["AgaveVisualUpdate",2,0,"MessageType.agaveVisualUpdateEvent","","null","null"],["SelectionChanged",0,0,"MessageType.visualSelectionChangedEvent","this._ParentObject.id","_RegisterSelectionChangedEvent","_UnregisterSelectionChangedEvent"]]],["Visual",0,[["id",3],["isSupportedInVisualTaskpane",3]],[["properties","VisualPropertyCollection",18,0,0,4]],[["delete",0,0,0,2],["getProperty",1,2,0,4],["setProperty",2,0,0,2],["changeDataSource",2,0,0,2],["getDataSource",0,2,0,4],["setPropertyToDefault",1,0,0,2],["_RegisterChangeEvent",0,2],["_UnregisterChangeEvent",0,2],["serializeProperties",0,2,0,4],["deserializeProperties",1,0,0,2],["addChildProperty",2,0,23,2],["removeChildProperty",2,0,23,2],["getDataFieldAssignments",0,0,5],["getDataConfig",0,2,5,4],["modifyDataConfig",1,0,5,2]],[["getChildProperties","VisualPropertyCollection",2,6,0,4],["getDataControllerClient","DataControllerClient",0,2,0,4],["getElementChildProperties","VisualPropertyCollection",3,6,0,4]],0,0,[["ChangeNotification",2,0,"MessageType.visualChangeEvent","this.id","_RegisterChangeEvent","_UnregisterChangeEvent"]]],["VisualProperty",0,[["type",3],["value",3],["id",3],["localizedName",3],["options",3],["localizedOptions",3],["hasDefault",3],["isDefault",3],["min",3],["max",3],["stepSize",3],["hideMeButShowChildrenUI",3],["expandableUI",3],["nextPropOnSameLine",3],["showResetUI",3],["size",3,23],["minSize",3,23],["maxSize",3,23],["index",3,23],["parentName",3,23]],0,[["getBoolMetaProperty",1,2,0,4]]],["VisualPropertyCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","VisualProperty",1,18,0,4],["getItemAt","VisualProperty",1,2,0,4]],0,"VisualProperty"],["DataControllerClient",0,0,0,[["getWells",0,2,0,4],["getAssociatedFields",1,2,0,4],["getAvailableFields",1,2,0,4],["addField",3,0,0,2],["removeField",2,0,0,2],["moveField",3,0,0,2]]],["RangeSort",0,0,0,[["apply",5,0,0,2,0,40]]],["TableSort",0,[["matchCase",3],["method",3],["fields",3]],0,[["apply",3,0,0,2,0,32],["clear"],["reapply",0,0,0,2,0,38]]],["Filter",0,[["criteria",3]],0,[["apply",1],["clear",0,0,0,2,0,43],["applyBottomItemsFilter",1,0,0,2,0,43],["applyBottomPercentFilter",1,0,0,2,0,43],["applyCellColorFilter",1,0,0,2,0,43],["applyDynamicFilter",1,0,0,2,0,43],["applyFontColorFilter",1,0,0,2,0,43],["applyValuesFilter",1,0,0,2,0,43],["applyTopItemsFilter",1,0,0,2,0,43],["applyTopPercentFilter",1,0,0,2,0,43],["applyIconFilter",1,0,0,2,0,43],["applyCustomFilter",3,0,0,2,0,43]]],["AutoFilter",0,[["enabled",3],["isDataFiltered",3],["criteria",3]],0,[["apply",3,0,0,2,0,41],["reapply",0,0,0,2,0,32],["remove",0,0,0,2,0,32],["clearCriteria",0,0,0,2,0,32],["clearColumnCriteria",1,0,22,2,0,50]],[["getRange","Range",0,10,0,4],["getRangeOrNullObject","Range",0,10,0,4]]],["CultureInfo",0,[["name",3]],[["numberFormat","NumberFormatInfo",3,0,0,4],["datetimeFormat","DatetimeFormatInfo",3,33,0,4],["formulaCulture","FormulaCultureInfo",2,4,0,4]]],["NumberFormatInfo",0,[["numberDecimalSeparator",3],["numberGroupSeparator",3],["currencySymbol",3,37],["currencyDecimals",2,4],["currencyNegative",2,4],["fractionSeparator",2,4],["isCurrencySeparatedBySpace",2,4],["isCurrencySymbolLeading",2,4],["nonCurrencyNumberDecimals",2,4],["numberGrouping",2,4],["spaceBeforePercentage",2,4],["spaceInScientificNotation",2,4]]],["DatetimeFormatInfo",0,[["dateSeparator",3],["longDatePattern",3],["shortDatePattern",3],["timeSeparator",3],["longTimePattern",3],["amSymbol",2,4],["dateOrder",2,4],["dateSeparatorAlternative",2,4],["dayNameLong",2,4],["dayNameShort",2,4],["isAmPmSeparatedBySpace",2,4],["isClock24Hour",2,4],["isDayTwoDigits",2,4],["isHourTwoDigits",2,4],["isLongDateFormat",2,4],["isMonthTwoDigits",2,4],["isYearFourDigits",2,4],["monthNameLong",2,4],["monthNameShort",2,4],["pmSymbol",2,4],["timeSeparatorAlternative",2,4],["shortDateTimePattern",3,4]]],["CustomXmlPartScopedCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","CustomXmlPart",1,18,0,4],["getItemOrNullObject","CustomXmlPart",1,2,0,4],["getOnlyItem","CustomXmlPart",0,2,0,4],["getOnlyItemOrNullObject","CustomXmlPart",0,2,0,4]],0,"CustomXmlPart"],["CustomXmlPartCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","CustomXmlPart",1,18,0,4],["add","CustomXmlPart",1,8,0,2,0,0,8],["getByNamespace","CustomXmlPartScopedCollection",1,6,0,4],["getItemOrNullObject","CustomXmlPart",1,2,0,4]],0,"CustomXmlPart"],["CustomXmlPart",0,[["id",3],["namespaceUri",3]],0,[["delete",0,0,0,2,0,38],["getXml",0,2,0,4],["setXml",1,0,0,2,0,8]]],["_V1Api",0,0,0,[["bindingGetData",1,2,0,4],["getSelectedData",1,2,0,4],["gotoById",1,2,0,4],["bindingAddFromSelection",1,2],["bindingGetById",1,2,0,4],["bindingReleaseById",1,2],["bindingGetAll",0,2,0,4],["bindingAddFromNamedItem",1,2],["bindingAddFromPrompt",1,2],["bindingDeleteAllDataValues",1],["setSelectedData",1],["bindingClearFormats",1],["bindingSetData",1],["bindingSetFormats",1],["bindingSetTableOptions",1],["bindingAddRows",1],["bindingAddColumns",1],["getFilePropertiesAsync",0,2,13,4]]],["PivotTableScopedCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","PivotTable",1,18,0,4],["getFirst","PivotTable",0,10,0,4],["getItemOrNullObject","PivotTable",1,2,0,4],["getFirstOrNullObject","PivotTable",0,2,45,4]],0,"PivotTable"],["PivotTableCollection",5,0,0,[["refreshAll",0,0,0,2,0,16],["getCount",0,2,19,4],["_RegisterAddedEvent",0,0,5,2,0,1],["_RegisterDeletedEvent",0,0,5,2,0,1],["_UnregisterAddedEvent",0,0,5,2,0,1],["_UnregisterDeletedEvent",0,0,5,2,0,1]],[["getItem","PivotTable",1,18,0,4],["getItemOrNullObject","PivotTable",1,2,19,4],["add","PivotTable",3,8,10,2,0,0,16]],0,"PivotTable",[["Added",0,5,"MessageType.pivotTableAddedEvent","this._eventTargetId","_RegisterAddedEvent","_UnregisterAddedEvent"],["Deleted",0,5,"MessageType.pivotTableDeletedEvent","this._eventTargetId","_RegisterDeletedEvent","_UnregisterDeletedEvent"]]],["PivotTable",0,[["name",1,0,0,2,16],["id",3,20],["useCustomSortLists",1,11,0,2,16],["enableDataValueEditing",1,11,0,2,16],["refreshOnOpen",0,28,0,2,36],["allowMultipleFiltersPerField",0,33,0,2,16]],[["worksheet","Worksheet",2,0,0,4],["hierarchies","PivotHierarchyCollection",19,10,0,4],["rowHierarchies","RowColumnPivotHierarchyCollection",19,10,0,4],["columnHierarchies","RowColumnPivotHierarchyCollection",19,10,0,4],["dataHierarchies","DataPivotHierarchyCollection",19,10,0,4],["filterHierarchies","FilterPivotHierarchyCollection",19,10,0,4],["layout","PivotLayout",2,10,0,4]],[["refresh",0,0,0,2,0,16],["delete",0,0,10,2,0,16],["getDataSourceString",0,2,45,4],["getDataSourceType",0,2,45,4]],[["addDateGroup","PivotHierarchy",2,0,4,2,0,0,51]]],["PivotLayout",0,[["showColumnGrandTotals",1,0,0,2,16],["showRowGrandTotals",1,0,0,2,16],["enableFieldList",1,21,0,2,16],["subtotalLocation",1,0,0,2,16],["layoutType",1,0,0,2,16],["autoFormat",1,11,0,2,16],["preserveFormatting",1,11,0,2,16],["altTextDescription",0,28,0,2,36],["altTextTitle",0,28,0,2,36],["emptyCellText",0,28,0,2,36],["fillEmptyCells",0,28,0,2,36],["showFieldHeaders",0,28,0,2,36],["tabularValues",3,4],["tabularText",3,4],["tabularNumberFormat",3,4],["tabularNumberFormatLocal",3,4]],[["pivotStyle","PivotTableStyle",35,4,0,4]],[["setAutoSortOnCell",2,0,11,2,0,16],["setStyle",1,0,4,2,0,16],["displayBlankLineAfterEachItem",1,0,28,2,0,36],["repeatAllItemLabels",1,0,28,2,0,36]],[["getRange","Range",0,3],["getRowLabelRange","Range",0,3],["getColumnLabelRange","Range",0,3],["getFilterAxisRange","Range",0,3],["getDataBodyRange","Range",0,3],["getCell","Range",3,2,4],["getPivotItems","PivotItemCollection",2,4,11],["getDataHierarchy","DataPivotHierarchy",1,3,11]]],["PivotHierarchyCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","PivotHierarchy",1,18,0,4],["getItemOrNullObject","PivotHierarchy",1,2,0,4]],0,"PivotHierarchy"],["PivotHierarchy",0,[["id",3],["name",1,0,0,2,16]],[["fields","PivotFieldCollection",19,0,0,4]]],["RowColumnPivotHierarchyCollection",1,0,0,[["getCount",0,2,0,4],["remove",1,0,0,2,0,16]],[["getItem","RowColumnPivotHierarchy",1,18,0,4],["getItemOrNullObject","RowColumnPivotHierarchy",1,2,0,4],["add","RowColumnPivotHierarchy",1,8,0,2,0,0,16]],0,"RowColumnPivotHierarchy"],["RowColumnPivotHierarchy",0,[["id",3],["name",1,0,0,2,16],["position",1,0,0,2,16]],[["fields","PivotFieldCollection",19,0,0,4]],[["setToDefault",0,0,0,2,0,16]]],["FilterPivotHierarchyCollection",1,0,0,[["getCount",0,2,0,4],["remove",1,0,0,2,0,16]],[["getItem","FilterPivotHierarchy",1,18,0,4],["getItemOrNullObject","FilterPivotHierarchy",1,2,0,4],["add","FilterPivotHierarchy",1,8,0,2,0,0,16]],0,"FilterPivotHierarchy"],["FilterPivotHierarchy",0,[["id",3],["name",1,0,0,2,16],["position",1,0,0,2,16],["enableMultipleFilterItems",1,0,0,2,16]],[["fields","PivotFieldCollection",19,0,0,4]],[["setToDefault",0,0,0,2,0,16]]],["DataPivotHierarchyCollection",1,0,0,[["getCount",0,2,0,4],["remove",1,0,0,2,0,16]],[["getItem","DataPivotHierarchy",1,18,0,4],["getItemOrNullObject","DataPivotHierarchy",1,2,0,4],["add","DataPivotHierarchy",1,8,0,2,0,0,16]],0,"DataPivotHierarchy"],["DataPivotHierarchy",0,[["id",3],["name",1,0,0,2,16],["position",1,0,0,2,16],["numberFormat",1,0,0,2,16],["summarizeBy",1,0,0,2,16],["showAs",1,0,0,2,16]],[["field","PivotField",35,0,0,4]],[["setToDefault",0,0,0,2,0,16]]],["PivotFieldCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","PivotField",1,18,0,4],["getItemOrNullObject","PivotField",1,2,0,4]],0,"PivotField"],["PivotField",0,[["id",3],["name",1,0,0,2,16],["subtotals",1,0,0,2,16],["showAllItems",1,0,0,2,16]],[["items","PivotItemCollection",19,0,0,4]],[["sortByLabels",1,1,0,2,0,16],["sortByValues",3,0,11,2,0,16],["applyFilter",1,0,33,2,0,16],["clearAllFilters",0,0,33,2,0,16],["clearFilter",1,0,33,2,0,16],["getFilters",0,0,33],["isFiltered",1,0,33]]],["PivotItemCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","PivotItem",1,18,0,4],["getItemOrNullObject","PivotItem",1,2,0,4]],0,"PivotItem"],["PivotItem",0,[["id",3],["name",1,0,0,2,16],["isExpanded",1,0,0,2,16],["visible",1,0,0,2,16]]],["WorksheetCustomProperty",0,[["key",3],["value",1,0,0,2,7],["_Id",2]],0,[["delete",0,0,0,2,0,7]]],["WorksheetCustomPropertyCollection",1,0,0,[["getCount",0,2,0,4]],[["getItem","WorksheetCustomProperty",1,18,0,4],["getItemOrNullObject","WorksheetCustomProperty",1,0,0,2,0,0,7],["add","WorksheetCustomProperty",2,8,0,2,0,0,7]],0,"WorksheetCustomProperty"],["DocumentProperties",0,[["title",1],["subject",1],["author",1],["keywords",1],["comments",1],["lastAuthor",3],["revisionNumber",1],["creationDate",11],["category",1],["manager",1],["company",1]],[["custom","CustomPropertyCollection",19,0,0,4]]],["CustomProperty",0,[["key",3],["value",1],["type",3]],0,[["delete"]]],["CustomPropertyCollection",1,0,0,[["getCount",0,2,0,4],["deleteAll"]],[["getItemOrNullObject","CustomProperty",1,2,0,4],["add","CustomProperty",2,8],["getItem","CustomProperty",1,18,0,4]],0,"CustomProperty"],["ConditionalFormatCollection",1,0,0,[["getCount",0,2,0,4],["clearAll",0,0,0,2,0,52]],[["getItemAt","ConditionalFormat",1,2,0,4],["add","ConditionalFormat",1,8,0,2,0,0,52],["getItem","ConditionalFormat",1,18,0,4],["getItemOrNullObject","ConditionalFormat",1,2,22,4]],0,"ConditionalFormat"],["ConditionalFormat",0,[["stopIfTrue",1,0,0,2,53],["priority",1,0,0,2,54],["type",3],["id",3]],[["dataBarOrNullObject","DataBarConditionalFormat",35,0,0,4],["dataBar","DataBarConditionalFormat",35,0,0,4],["customOrNullObject","CustomConditionalFormat",35,0,0,4],["custom","CustomConditionalFormat",35,0,0,4],["iconSet","IconSetConditionalFormat",35,0,0,4],["iconSetOrNullObject","IconSetConditionalFormat",35,0,0,4],["colorScale","ColorScaleConditionalFormat",35,0,0,4],["colorScaleOrNullObject","ColorScaleConditionalFormat",35,0,0,4],["topBottom","TopBottomConditionalFormat",35,0,0,4],["topBottomOrNullObject","TopBottomConditionalFormat",35,0,0,4],["preset","PresetCriteriaConditionalFormat",35,0,0,4],["presetOrNullObject","PresetCriteriaConditionalFormat",35,0,0,4],["textComparison","TextConditionalFormat",35,0,0,4],["textComparisonOrNullObject","TextConditionalFormat",35,0,0,4],["cellValue","CellValueConditionalFormat",35,0,0,4],["cellValueOrNullObject","CellValueConditionalFormat",35,0,0,4]],[["delete",0,0,0,2,0,55],["changeRuleToCellValue",1,0,37,2,0,53],["changeRuleToColorScale",0,0,37,2,0,53],["changeRuleToContainsText",1,0,37,2,0,53],["changeRuleToCustom",1,0,37,2,0,53],["changeRuleToDataBar",0,0,37,2,0,53],["changeRuleToIconSet",0,0,37,2,0,53],["changeRuleToPresetCriteria",1,0,37,2,0,53],["changeRuleToTopBottom",1,0,37,2,0,53],["setRanges",1,0,37,2,0,53]],[["getRange","Range",0,10,0,4],["getRangeOrNullObject","Range",0,10,0,4],["getRanges","RangeAreas",0,10,11,4]]],["DataBarConditionalFormat",0,[["showDataBarOnly",1,0,0,2,55],["barDirection",1,0,0,2,56],["axisFormat",1,0,0,2,56],["axisColor",1,0,0,2,56],["lowerBoundRule",1,0,0,2,56],["upperBoundRule",1,0,0,2,56]],[["positiveFormat","ConditionalDataBarPositiveFormat",35,0,0,4],["negativeFormat","ConditionalDataBarNegativeFormat",35,0,0,4]]],["ConditionalDataBarPositiveFormat",0,[["fillColor",1,0,0,2,55],["gradientFill",1,0,0,2,55],["borderColor",1,0,0,2,55]]],["ConditionalDataBarNegativeFormat",0,[["fillColor",1,0,0,2,55],["matchPositiveFillColor",1,0,0,2,55],["borderColor",1,0,0,2,55],["matchPositiveBorderColor",1,0,0,2,55]]],["CustomConditionalFormat",0,0,[["rule","ConditionalFormatRule",35,0,0,4],["format","ConditionalRangeFormat",35,0,0,4]]],["ConditionalFormatRule",0,[["formula",1,0,0,2,56],["formulaLocal",1,0,0,2,57],["formulaR1C1",1,0,0,2,53]]],["IconSetConditionalFormat",0,[["reverseIconOrder",1,0,0,2,56],["showIconOnly",1,0,0,2,56],["style",1,0,0,2,56],["criteria",1,0,0,2,56]]],["ColorScaleConditionalFormat",0,[["threeColorScale",3],["criteria",1,0,0,2,56]]],["TopBottomConditionalFormat",0,[["rule",1,0,0,2,56]],[["format","ConditionalRangeFormat",35,0,0,4]]],["PresetCriteriaConditionalFormat",0,[["rule",1,0,0,2,56]],[["format","ConditionalRangeFormat",35,0,0,4]]],["TextConditionalFormat",0,[["rule",1,0,0,2,56]],[["format","ConditionalRangeFormat",35,0,0,4]]],["CellValueConditionalFormat",0,[["rule",1,0,0,2,56]],[["format","ConditionalRangeFormat",35,0,0,4]]],["ConditionalRangeFormat",0,[["numberFormat",1,0,0,2,53]],[["fill","ConditionalRangeFill",35,0,0,4],["font","ConditionalRangeFont",35,0,0,4],["borders","ConditionalRangeBorderCollection",51,0,0,4]],[["clearFormat",0,0,37,2,0,53]]],["ConditionalRangeFont",0,[["color",1,0,0,2,58],["italic",1,0,0,2,58],["bold",1,0,0,2,58],["underline",1,0,0,2,58],["strikethrough",1,0,0,2,58]],0,[["clear",0,0,0,2,0,58]]],["ConditionalRangeFill",0,[["color",1,0,0,2,58]],0,[["clear",0,0,0,2,0,58]]],["ConditionalRangeBorder",0,[["sideIndex",3],["style",1,0,0,2,58],["color",1,0,0,2,58]]],["ConditionalRangeBorderCollection",1,[["count",3]],[["top","ConditionalRangeBorder",35,0,0,4],["bottom","ConditionalRangeBorder",35,0,0,4],["left","ConditionalRangeBorder",35,0,0,4],["right","ConditionalRangeBorder",35,0,0,4]],0,[["getItem","ConditionalRangeBorder",1,18,0,4],["getItemAt","ConditionalRangeBorder",1,2,0,4]],0,"ConditionalRangeBorder"],["NumberFormattingService",0,0,0,0,[["getFormatter","NumberFormatter",1,3]],0,0,0,"Microsoft.ExcelServices.NumberFormattingService",4],["NumberFormatter",0,[["isDateTime",3],["isPercent",3],["isCurrency",3],["isNumeric",3],["isText",3],["hasYear",3],["hasMonth",3],["hasDayOfWeek",3]],0,[["format",1,3]]],["CustomFunctionManager",36,[["status",2]],0,[["register",2]],0,0,0,0,"Microsoft.ExcelServices.CustomFunctionManager",4],["Style",0,[["builtIn",3],["formulaHidden",1],["horizontalAlignment",1],["includeAlignment",1],["includeBorder",1],["includeFont",1],["includeNumber",1],["includePatterns",1],["includeProtection",1],["indentLevel",1],["locked",1],["name",3],["numberFormat",1],["numberFormatLocal",1],["readingOrder",1],["shrinkToFit",1],["verticalAlignment",1],["wrapText",1],["textOrientation",5,10],["autoIndent",1,10]],[["borders","RangeBorderCollection",51,0,0,4],["font","RangeFont",35,0,0,4],["fill","RangeFill",35,0,0,4]],[["delete"]]],["StyleCollection",1,0,0,[["add",1],["getCount",0,2,11,4]],[["getItem","Style",1,18,0,4],["getItemAt","Style",1,2,11,4],["getItemOrNullObject","Style",1,2,22,4]],0,"Style"],["TableStyleCollection",1,0,0,[["getCount",0,2,0,4],["setDefault",1]],[["getItem","TableStyle",1,18,0,4],["getItemOrNullObject","TableStyle",1,2,0,4],["add","TableStyle",2,8],["getDefault","TableStyle"]],0,"TableStyle"],["TableStyle",0,[["name",1],["readOnly",3],["_Id",2]],0,[["delete"]],[["duplicate","TableStyle"]]],["PivotTableStyleCollection",1,0,0,[["getCount",0,2,0,4],["setDefault",1]],[["getItem","PivotTableStyle",1,18,0,4],["getItemOrNullObject","PivotTableStyle",1,2,0,4],["add","PivotTableStyle",2,8],["getDefault","PivotTableStyle"]],0,"PivotTableStyle"],["PivotTableStyle",0,[["name",1],["readOnly",3],["_Id",2]],0,[["delete"]],[["duplicate","PivotTableStyle"]]],["SlicerStyleCollection",1,0,0,[["getCount",0,2,0,4],["setDefault",1]],[["getItem","SlicerStyle",1,18,0,4],["getItemOrNullObject","SlicerStyle",1,2,0,4],["add","SlicerStyle",2,8],["getDefault","SlicerStyle"]],0,"SlicerStyle"],["SlicerStyle",0,[["name",1],["readOnly",3],["_Id",2]],0,[["delete"]],[["duplicate","SlicerStyle"]]],["TimelineStyleCollection",1,0,0,[["getCount",0,2,0,4],["setDefault",1]],[["getItem","TimelineStyle",1,18,0,4],["getItemOrNullObject","TimelineStyle",1,2,0,4],["add","TimelineStyle",2,8],["getDefault","TimelineStyle"]],0,"TimelineStyle"],["TimelineStyle",0,[["name",1],["readOnly",3],["_Id",2]],0,[["delete"]],[["duplicate","TimelineStyle"]]],["InternalTest",0,0,0,[["delay",1],["triggerMessage",4,0,15],["_RegisterTestEvent",0,0,15,2,0,1],["_UnregisterTestEvent",0,0,15,2,0,1],["triggerTestEvent",2,0,15],["triggerPostProcess",0,0,15],["_RegisterTest1Event",0,0,15,2,0,1],["_UnregisterTest1Event",0,0,15,2,0,1],["triggerTestEventWithFilter",3,0,15],["firstPartyMethod",0,2,15,5],["_RegisterCustomFunctionExecutionBeginEvent",0,0,25,2,0,1],["_UnregisterCustomFunctionExecutionBeginEvent",0,0,25,2,0,1],["_RegisterCustomFunctionExecutionEndEvent",0,0,25,2,0,1],["_UnregisterCustomFunctionExecutionEndEvent",0,0,25,2,0,1],["unregisterAllCustomFunctionExecutionEvents",0,0,25],["updateRangeValueOnCurrentSheet",2,0,5,2],["triggerUserUndo",0,2,5],["triggerUserRedo",0,2,5],["enterCellEdit",1,0,11],["installCustomFunctionsFromCache",0,0,11],["recalc",2,0,11],["recalcBySolutionId",1,0,11],["safeForCellEditModeMethod",1,0,11],["exitCellEdit",0,0,11],["noPermissionMethod",1,0,11],["verifyCustomFunctionListExist",0,0,11],["enableContentWorkbookLink",0,0,5],["previewExecutionMethod",1,0,4,16],["setRapidJsonEnabled",1,0,4],["triggerVbaRecorderRecordingChanged",2,0,4]],0,0,0,[["CustomFunctionExecutionBeginEvent",0,25,"MessageType.customFunctionExecutionBeginEvent","","_RegisterCustomFunctionExecutionBeginEvent","_UnregisterCustomFunctionExecutionBeginEvent"],["CustomFunctionExecutionEndEvent",0,25,"MessageType.customFunctionExecutionEndEvent","","_RegisterCustomFunctionExecutionEndEvent","_UnregisterCustomFunctionExecutionEndEvent"],["Test1Event",2,15,"MessageType.test1Event","","_RegisterTest1Event","_UnregisterTest1Event"],["TestEvent",2,15,"MessageType.testEvent","","_RegisterTestEvent","_UnregisterTestEvent"]],"Microsoft.ExcelServices.InternalTest",4],["PageLayout",0,[["orientation",1],["paperSize",1],["blackAndWhite",1],["printErrors",1],["zoom",1],["centerHorizontally",1],["centerVertically",1],["printHeadings",1],["printGridlines",1],["leftMargin",1],["rightMargin",1],["topMargin",1],["bottomMargin",1],["headerMargin",1],["footerMargin",1],["printComments",1],["draftMode",1],["firstPageNumber",1],["printOrder",1]],[["headersFooters","HeaderFooterGroup",35,0,0,4]],[["setPrintMargins",2],["setPrintArea",1],["setPrintTitleRows",1],["setPrintTitleColumns",1]],[["getPrintArea","RangeAreas",0,10,0,4],["getPrintAreaOrNullObject","RangeAreas",0,10,0,4],["getPrintTitleRows","Range",0,10,0,4],["getPrintTitleRowsOrNullObject","Range",0,10,0,4],["getPrintTitleColumns","Range",0,10,0,4],["getPrintTitleColumnsOrNullObject","Range",0,10,0,4]]],["HeaderFooter",0,[["leftHeader",1],["centerHeader",1],["rightHeader",1],["leftFooter",1],["centerFooter",1],["rightFooter",1]]],["HeaderFooterGroup",0,[["state",1],["useSheetMargins",1],["useSheetScale",1]],[["defaultForAllPages","HeaderFooter",35,0,0,4],["firstPage","HeaderFooter",35,0,0,4],["evenPages","HeaderFooter",35,0,0,4],["oddPages","HeaderFooter",35,0,0,4]]],["PageBreak",0,[["_Id",2],["columnIndex",3],["rowIndex",3]],0,[["delete"]],[["getCellAfterBreak","Range",0,10,0,4]]],["PageBreakCollection",1,0,0,[["removePageBreaks"],["getCount",0,2,0,4]],[["getItem","PageBreak",1,18,0,4],["add","PageBreak",1,8]],0,"PageBreak"],["DataConnectionCollection",0,0,0,[["refreshAll"]],[["add","DataConnection",4,8,4,2,0,0,16]]],["RangeCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","Range",1,2,0,4]],0,"Range"],["RangeAreasCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","RangeAreas",1,2,0,4]],0,"RangeAreas"],["CommentCollection",5,0,0,[["getCount",0,2,0,4],["_RegisterAddedEvent",0,2,33],["_UnregisterAddedEvent",0,2,33],["_RegisterDeletedEvent",0,2,33],["_UnregisterDeletedEvent",0,2,33],["_RegisterChangedEvent",0,2,33],["_UnregisterChangedEvent",0,2,33]],[["getItem","Comment",1,18,0,4],["getItemAt","Comment",1,2,0,4],["add","Comment",3,8,0,2,0,0,38],["getItemByReplyId","Comment",1,2,0,4],["getItemByCell","Comment",1,2,0,4],["getItemOrNullObject","Comment",1,2,22,4]],0,"Comment",[["Added",0,33,"MessageType.commentAddedEvent","this._eventTargetId","_RegisterAddedEvent","_UnregisterAddedEvent"],["Changed",0,33,"MessageType.commentChangedEvent","this._eventTargetId","_RegisterChangedEvent","_UnregisterChangedEvent"],["Deleted",0,33,"MessageType.commentDeletedEvent","this._eventTargetId","_RegisterDeletedEvent","_UnregisterDeletedEvent"]]],["Comment",0,[["id",3],["content",1,0,0,2,38],["authorName",3],["authorEmail",3],["creationDate",11],["resolved",1,12,0,2,38],["richContent",3,12],["mentions",3,12],["contentType",3,33]],[["replies","CommentReplyCollection",19,0,0,4]],[["delete",0,0,0,2,0,38],["updateMentions",1,0,12,2,0,38]],[["getLocation","Range",0,10,0,4],["assignTask","DocumentTask",1,0,4],["getTask","DocumentTask",0,10,4,4],["getTaskOrNullObject","DocumentTask",0,10,4,4]]],["CommentReplyCollection",1,0,0,[["getCount",0,2,0,4]],[["add","CommentReply",2,8,0,2,0,0,38],["getItem","CommentReply",1,18,0,4],["getItemAt","CommentReply",1,2,0,4],["getItemOrNullObject","CommentReply",1,2,22,4]],0,"CommentReply"],["CommentReply",0,[["id",3],["content",1,0,0,2,38],["authorName",3],["authorEmail",3],["creationDate",11],["resolved",3,12],["richContent",3,12],["mentions",3,12],["contentType",3,33]],0,[["delete",0,0,0,2,0,38],["updateMentions",1,0,12,2,0,38]],[["getLocation","Range",0,10,0,4],["getParentComment","Comment",0,0,0,2,0,0,38],["assignTask","DocumentTask",1,0,4],["getTask","DocumentTask",0,10,4,4],["getTaskOrNullObject","DocumentTask",0,10,4,4]]],["ShapeCollection",5,0,0,[["getCount",0,2,0,4],["_RegisterAddedEvent",0,0,5,2,0,1],["_RegisterDeletedEvent",0,0,5,2,0,1],["_UnregisterAddedEvent",0,0,5,2,0,1],["_UnregisterDeletedEvent",0,0,5,2,0,1]],[["addImage","Shape",1,0,0,2,0,0,7],["_GetItem","Shape",1,18,0,4],["addGeometricShape","Shape",1,0,0,2,0,0,7],["addTextBox","Shape",1,0,0,2,0,0,7],["addSvg","Shape",1,0,4,2,0,0,7],["addGroup","Shape",1,0,0,2,0,0,7],["getItemAt","Shape",1,2,0,4],["getItem","Shape",1,2,0,4],["addLine","Shape",5],["getItemOrNullObject","Shape",1,2,22,4],["addLocalImageReference","Shape",1,0,4,2]],0,"Shape",[["Added",0,5,"MessageType.shapeAddedEvent","this._ParentObject.id","_RegisterAddedEvent","_UnregisterAddedEvent"],["Deleted",0,5,"MessageType.shapeDeletedEvent","this._ParentObject.id","_RegisterDeletedEvent","_UnregisterDeletedEvent"]]],["Shape",0,[["id",3],["name",1,0,0,2,59],["left",1,0,0,2,59],["top",1,0,0,2,59],["width",1,0,0,2,59],["height",1,0,0,2,59],["rotation",1,0,0,2,59],["zOrderPosition",3],["altTextTitle",1,0,0,2,59],["altTextDescription",1,0,0,2,47],["type",3],["lockAspectRatio",1,0,0,2,35],["placement",1,21,0,2,59],["geometricShapeType",1,0,0,2,7],["visible",1,0,0,2,59],["level",3],["connectionSiteCount",3],["scriptLink",1,4,0,2,48],["displayName",3,45]],[["geometricShape","GeometricShape",2,0,0,4],["image","Image",2,0,0,4],["textFrame","TextFrame",2,0,0,4],["fill","ShapeFill",35,0,0,4],["group","ShapeGroup",2,0,0,4],["parentGroup","Shape",2,0,0,4],["line","Line",2,0,0,4],["lineFormat","ShapeLineFormat",35,0,0,4]],[["setZOrder",1,0,0,2,0,59],["incrementLeft",1,0,0,2,0,35],["incrementTop",1,0,0,2,0,35],["incrementRotation",1,0,0,2,0,59],["scaleHeight",3,0,0,2,0,35],["scaleWidth",3,0,0,2,0,35],["delete",0,0,0,2,0,59],["getAsImage",1],["_RegisterActivatedEvent",0,0,0,2,0,1],["_UnregisterActivatedEvent",0,0,0,2,0,1],["_RegisterDeactivatedEvent",0,0,0,2,0,1],["_UnregisterDeactivatedEvent",0,0,0,2,0,1],["activate",0,0,5]],[["copyTo","Shape",1,8,21,2,0,"_GetShapeById",59],["_GetShapeById","Shape",1,2,21,4]],0,0,[["Activated",0,0,"MessageType.shapeActivatedEvent","this.id","_RegisterActivatedEvent","_UnregisterActivatedEvent"],["Deactivated",0,0,"MessageType.shapeDeactivatedEvent","this.id","_RegisterDeactivatedEvent","_UnregisterDeactivatedEvent"]]],["GeometricShape",0,[["id",3]],[["shape","Shape",2,0,0,4]]],["Image",0,[["id",3],["format",3,0,"format"]],[["shape","Shape",2,0,0,4]]],["ShapeGroup",0,[["id",3]],[["shapes","GroupShapeCollection",19,0,0,4],["shape","Shape",2,0,0,4]],[["ungroup",0,0,0,2,0,7]]],["GroupShapeCollection",1,0,0,[["getCount",0,2,0,4]],[["_GetItem","Shape",1,18,0,4],["getItemAt","Shape",1,2,0,4],["getItem","Shape",1,2,0,4],["getItemOrNullObject","Shape",1,2,22,4]],0,"Shape"],["Line",0,[["id",3],["connectorType",1,0,"connectorType"],["beginArrowheadLength",1],["beginArrowheadStyle",1],["beginArrowheadWidth",1],["endArrowheadLength",1],["endArrowheadStyle",1],["endArrowheadWidth",1],["isBeginConnected",3],["beginConnectedSite",3],["isEndConnected",3],["endConnectedSite",3]],[["shape","Shape",2,0,0,4],["beginConnectedShape","Shape",2,0,0,4],["endConnectedShape","Shape",2,0,0,4]],[["connectBeginShape",2],["disconnectBeginShape"],["connectEndShape",2],["disconnectEndShape"]]],["ShapeFill",0,[["foregroundColor",1,0,0,2,7],["type",3],["transparency",1,0,0,2,7]],0,[["clear",0,0,0,2,0,7],["setSolidColor",1,0,0,2,0,7]]],["ShapeLineFormat",0,[["visible",1,0,0,2,7],["color",1,0,0,2,60],["style",1,0,0,2,7],["weight",1,0,0,2,7],["dashStyle",1,0,0,2,7],["transparency",1,0,0,2,7]]],["TextFrame",0,[["leftMargin",1],["rightMargin",1],["topMargin",1],["bottomMargin",1],["horizontalAlignment",1],["horizontalOverflow",1],["verticalAlignment",1],["verticalOverflow",1],["orientation",1],["readingOrder",1],["hasText",3],["autoSizeSetting",1]],[["textRange","TextRange",2,0,0,4]],[["deleteText"]]],["TextRange",0,[["text",1]],[["font","ShapeFont",35,0,0,4]],0,[["getSubstring","TextRange",2]]],["ShapeFont",0,[["size",1],["name",1],["color",1],["bold",1],["italic",1],["underline",1]]],["Slicer",0,[["id",3],["name",1],["caption",1],["left",1],["top",1],["width",1],["height",1],["nameInFormula",1,4],["isFilterCleared",3],["style",1],["sortBy",1],["sortUsingCustomLists",1,5],["columnCount",1,5],["disableMoveResizeUI",1,5],["displayHeader",1,5],["rowHeight",1,5],["shapeId",2,5]],[["slicerItems","SlicerItemCollection",19,0,0,4],["worksheet","Worksheet",35,0,0,4],["slicerStyle","SlicerStyle",35,4,0,4]],[["delete"],["clearFilters"],["getSelectedItems"],["selectItems",1],["activate",0,2,5],["setStyle",1,0,4]]],["SlicerCollection",1,0,0,[["getCount",0,2,0,4]],[["add","Slicer",3,8],["getItemAt","Slicer",1,2,0,4],["getItem","Slicer",1,18,0,4],["getItemOrNullObject","Slicer",1,2,0,4]],0,"Slicer"],["SlicerItem",0,[["key",3],["name",3],["isSelected",1],["hasData",3]]],["SlicerItemCollection",1,0,0,[["getCount",0,2,0,4]],[["getItemAt","SlicerItem",1,2,0,4],["getItem","SlicerItem",1,18,0,4],["getItemOrNullObject","SlicerItem",1,2,0,4]],0,"SlicerItem"],["Ribbon",0,[["activeTab",1,0,0,2,61]],0,[["executeCommand",2],["showTeachingCallout",3,0,0,2,0,61],["_RegisterCommandExecutedEvent",0,0,0,2,0,1],["_UnregisterCommandExecutedEvent",0,0,0,2,0,1],["showChartDialog",1,2,4,4]],0,0,0,[["CommandExecuted",0,0,"MessageType.ribbonCommandExecutedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterCommandExecutedEvent","_UnregisterCommandExecutedEvent"]]],["LinkedDataType",0,[["dataProvider",2],["serviceId",2],["lastRefreshed",10],["name",2],["periodicRefreshInterval",2],["refreshDataLoadWarnings",2],["refreshMode",2],["supportedRefreshModes",2],["refreshErrors",2]],0,[["requestRefresh",0,0,0,2],["requestSetRefreshMode",1,0,0,2]]],["LinkedDataTypeCollection",1,0,0,[["getCount",0,2,0,4],["requestRefreshAll",0,0,0,2],["_RegisterRefreshRequestCompletedEvent",0,2,0,4],["_UnregisterRefreshRequestCompletedEvent",0,2,0,4],["_RegisterRefreshModeChangedEvent",0,2,0,4],["_UnregisterRefreshModeChangedEvent",0,2,0,4],["_RegisterLinkedDataTypeAddedEvent",0,2,0,4],["_UnregisterLinkedDataTypeAddedEvent",0,2,0,4]],[["getItem","LinkedDataType",1,18,0,4],["getItemOrNullObject","LinkedDataType",1],["getItemAt","LinkedDataType",1,2,0,4]],0,"LinkedDataType",[["LinkedDataTypeAdded",0,0,"MessageType.linkedDataTypeLinkedDataTypeAddedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterLinkedDataTypeAddedEvent","_UnregisterLinkedDataTypeAddedEvent"],["RefreshModeChanged",0,0,"MessageType.linkedDataTypeRefreshModeChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterRefreshModeChangedEvent","_UnregisterRefreshModeChangedEvent"],["RefreshRequestCompleted",0,0,"MessageType.linkedDataTypeRefreshRequestCompletedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterRefreshRequestCompletedEvent","_UnregisterRefreshRequestCompletedEvent"]]],["LinkedEntityDataDomain",0,[["dataProvider",2],["id",2],["lastRefreshed",10],["loadFunctionId",2],["name",2],["periodicRefreshInterval",2],["refreshErrors",2],["refreshMode",0,0,0,2],["refreshModeWarnings",2],["serviceId",2],["supportedRefreshModes",2]],0,[["delete",0,0,0,2],["refresh",0,0,0,2]]],["LinkedEntityDataDomainCollection",1,0,0,[["_RegisterEventLinkedEntityDataDomainAdded",0,2,0,4],["_RegisterEventRefreshCompleted",0,2,0,4],["_RegisterEventRefreshModeChanged",0,2,0,4],["_UnregisterEventLinkedEntityDataDomainAdded",0,2,0,4],["_UnregisterEventRefreshCompleted",0,2,0,4],["_UnregisterEventRefreshModeChanged",0,2,0,4],["add",1,0,0,2],["getCount",0,2,0,4],["refreshAll",0,0,0,2]],[["getItem","LinkedEntityDataDomain",1,18,0,4],["getItemAt","LinkedEntityDataDomain",1,2,0,4],["getItemByName","LinkedEntityDataDomain",1,2,0,4],["getItemByNameOrNullObject","LinkedEntityDataDomain",1,2,0,4],["getItemOrNullObject","LinkedEntityDataDomain",1,2,0,4]],0,"LinkedEntityDataDomain",[["LinkedEntityDataDomainAdded",0,0,"MessageType.linkedEntityDataDomainLinkedEntityDataDomainAddedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventLinkedEntityDataDomainAdded","_UnregisterEventLinkedEntityDataDomainAdded"],["RefreshCompleted",0,0,"MessageType.linkedEntityDataDomainRefreshCompletedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventRefreshCompleted","_UnregisterEventRefreshCompleted"],["RefreshModeChanged",0,0,"MessageType.linkedEntityDataDomainRefreshModeChangedEvent","OfficeExtension.Constants.eventWorkbookId","_RegisterEventRefreshModeChanged","_UnregisterEventRefreshModeChanged"]]],["SheetView",0,[["name"]],0,[["activate"],["delete"]],[["duplicate","SheetView",1]]],["SheetViewCollection",1,0,0,[["getCount",0,2,0,4],["exit"]],[["add","SheetView",1,8],["enterTemporary","SheetView"],["getActive","SheetView"],["getItem","SheetView",1,18,0,4],["getItemAt","SheetView",1,2,0,4]],0,"SheetView"],["NamedSheetView",0,[["name"]],0,[["activate"],["delete"]],[["duplicate","NamedSheetView",1]]],["NamedSheetViewCollection",1,0,0,[["getCount",0,2,0,4],["exit"]],[["add","NamedSheetView",1,8],["enterTemporary","NamedSheetView"],["getActive","NamedSheetView"],["getItem","NamedSheetView",1,18,0,4],["getItemAt","NamedSheetView",1,2,0,4],["getItemOrNullObject","NamedSheetView",1,2,34,4]],0,"NamedSheetView"],["FunctionResult",0,[["error",3],["value",3]]],["Functions",0,0,0,0,[["count","FunctionResult",1,72],["if","FunctionResult",3,8],["isNA","FunctionResult",1,8],["isError","FunctionResult",1,8],["sum","FunctionResult",1,72],["average","FunctionResult",1,72],["min","FunctionResult",1,72],["max","FunctionResult",1,72],["na","FunctionResult",0,8],["npv","FunctionResult",2,72],["dollar","FunctionResult",2,8],["fixed","FunctionResult",3,8],["sin","FunctionResult",1,8],["cos","FunctionResult",1,8],["tan","FunctionResult",1,8],["atan","FunctionResult",1,8],["pi","FunctionResult",0,8],["sqrt","FunctionResult",1,8],["exp","FunctionResult",1,8],["ln","FunctionResult",1,8],["log10","FunctionResult",1,8],["abs","FunctionResult",1,8],["int","FunctionResult",1,8],["sign","FunctionResult",1,8],["round","FunctionResult",2,8],["lookup","FunctionResult",3,8],["rept","FunctionResult",2,8],["mid","FunctionResult",3,8],["len","FunctionResult",1,8],["value","FunctionResult",1,8],["true","FunctionResult",0,8],["false","FunctionResult",0,8],["and","FunctionResult",1,72],["or","FunctionResult",1,72],["not","FunctionResult",1,8],["mod","FunctionResult",2,8],["dcount","FunctionResult",3,8,0,0,"DCount"],["dsum","FunctionResult",3,8,0,0,"DSum"],["daverage","FunctionResult",3,8,0,0,"DAverage"],["dmin","FunctionResult",3,8,0,0,"DMin"],["dmax","FunctionResult",3,8,0,0,"DMax"],["dstDev","FunctionResult",3,8,0,0,"DStDev"],["dvar","FunctionResult",3,8,0,0,"DVar"],["text","FunctionResult",2,8],["pv","FunctionResult",5,8],["fv","FunctionResult",5,8],["nper","FunctionResult",5,8,0,0,"NPer"],["pmt","FunctionResult",5,8],["rate","FunctionResult",6,8],["mirr","FunctionResult",3,8,0,0,"MIrr"],["irr","FunctionResult",2,8],["rand","FunctionResult",0,8],["match","FunctionResult",3,8],["date","FunctionResult",3,8],["time","FunctionResult",3,8],["day","FunctionResult",1,8],["month","FunctionResult",1,8],["year","FunctionResult",1,8],["weekday","FunctionResult",2,8],["hour","FunctionResult",1,8],["minute","FunctionResult",1,8],["second","FunctionResult",1,8],["now","FunctionResult",0,8],["areas","FunctionResult",1,8],["rows","FunctionResult",1,8],["columns","FunctionResult",1,8],["type","FunctionResult",1,8],["atan2","FunctionResult",2,8],["asin","FunctionResult",1,8],["acos","FunctionResult",1,8],["choose","FunctionResult",2,72],["hlookup","FunctionResult",4,8,0,0,"HLookup"],["vlookup","FunctionResult",4,8,0,0,"VLookup"],["isref","FunctionResult",1,8],["log","FunctionResult",2,8],["char","FunctionResult",1,8],["lower","FunctionResult",1,8],["upper","FunctionResult",1,8],["proper","FunctionResult",1,8],["left","FunctionResult",2,8],["right","FunctionResult",2,8],["exact","FunctionResult",2,8],["trim","FunctionResult",1,8],["replace","FunctionResult",4,8],["substitute","FunctionResult",4,8],["code","FunctionResult",1,8],["find","FunctionResult",3,8],["isErr","FunctionResult",1,8],["isText","FunctionResult",1,8],["isNumber","FunctionResult",1,8],["t","FunctionResult",1,8,0,0,"T"],["n","FunctionResult",1,8,0,0,"N"],["datevalue","FunctionResult",1,8],["timevalue","FunctionResult",1,8],["sln","FunctionResult",3,8],["syd","FunctionResult",4,8],["ddb","FunctionResult",5,8],["clean","FunctionResult",1,8],["ipmt","FunctionResult",6,8],["ppmt","FunctionResult",6,8],["countA","FunctionResult",1,72],["product","FunctionResult",1,72],["fact","FunctionResult",1,8],["dproduct","FunctionResult",3,8,0,0,"DProduct"],["isNonText","FunctionResult",1,8],["dstDevP","FunctionResult",3,8,0,0,"DStDevP"],["dvarP","FunctionResult",3,8,0,0,"DVarP"],["trunc","FunctionResult",2,8],["isLogical","FunctionResult",1,8],["dcountA","FunctionResult",3,8,0,0,"DCountA"],["usdollar","FunctionResult",2,8,0,0,"USDollar"],["findB","FunctionResult",3,8],["replaceB","FunctionResult",4,8],["leftb","FunctionResult",2,8],["rightb","FunctionResult",2,8],["midb","FunctionResult",3,8],["lenb","FunctionResult",1,8],["roundUp","FunctionResult",2,8],["roundDown","FunctionResult",2,8],["asc","FunctionResult",1,8],["dbcs","FunctionResult",1,8],["days360","FunctionResult",3,8],["today","FunctionResult",0,8],["vdb","FunctionResult",7,8],["median","FunctionResult",1,72],["sinh","FunctionResult",1,8],["cosh","FunctionResult",1,8],["tanh","FunctionResult",1,8],["asinh","FunctionResult",1,8],["acosh","FunctionResult",1,8],["atanh","FunctionResult",1,8],["dget","FunctionResult",3,8,0,0,"DGet"],["db","FunctionResult",5,8],["error_Type","FunctionResult",1,8],["aveDev","FunctionResult",1,72],["gammaLn","FunctionResult",1,8],["combin","FunctionResult",2,8],["even","FunctionResult",1,8],["fisher","FunctionResult",1,8],["fisherInv","FunctionResult",1,8],["standardize","FunctionResult",3,8],["odd","FunctionResult",1,8],["permut","FunctionResult",2,8],["devSq","FunctionResult",1,72],["geoMean","FunctionResult",1,72],["harMean","FunctionResult",1,72],["sumSq","FunctionResult",1,72],["kurt","FunctionResult",1,72],["skew","FunctionResult",1,72],["large","FunctionResult",2,8],["small","FunctionResult",2,8],["trimMean","FunctionResult",2,8],["concatenate","FunctionResult",1,72],["power","FunctionResult",2,8],["radians","FunctionResult",1,8],["degrees","FunctionResult",1,8],["subtotal","FunctionResult",2,72],["sumIf","FunctionResult",3,8],["countIf","FunctionResult",2,8],["countBlank","FunctionResult",1,8],["ispmt","FunctionResult",4,8],["roman","FunctionResult",2,8],["hyperlink","FunctionResult",2,8],["averageA","FunctionResult",1,72],["maxA","FunctionResult",1,72],["minA","FunctionResult",1,72],["stDevPA","FunctionResult",1,72],["varPA","FunctionResult",1,72],["stDevA","FunctionResult",1,72],["varA","FunctionResult",1,72],["bahtText","FunctionResult",1,8],["hex2Bin","FunctionResult",2,8],["hex2Dec","FunctionResult",1,8],["hex2Oct","FunctionResult",2,8],["dec2Bin","FunctionResult",2,8],["dec2Hex","FunctionResult",2,8],["dec2Oct","FunctionResult",2,8],["oct2Bin","FunctionResult",2,8],["oct2Hex","FunctionResult",2,8],["oct2Dec","FunctionResult",1,8],["bin2Dec","FunctionResult",1,8],["bin2Oct","FunctionResult",2,8],["bin2Hex","FunctionResult",2,8],["imSub","FunctionResult",2,8],["imDiv","FunctionResult",2,8],["imPower","FunctionResult",2,8],["imAbs","FunctionResult",1,8],["imSqrt","FunctionResult",1,8],["imLn","FunctionResult",1,8],["imLog2","FunctionResult",1,8],["imLog10","FunctionResult",1,8],["imSin","FunctionResult",1,8],["imCos","FunctionResult",1,8],["imExp","FunctionResult",1,8],["imArgument","FunctionResult",1,8],["imConjugate","FunctionResult",1,8],["imaginary","FunctionResult",1,8],["imReal","FunctionResult",1,8],["complex","FunctionResult",3,8],["imSum","FunctionResult",1,72],["imProduct","FunctionResult",1,72],["seriesSum","FunctionResult",4,8],["factDouble","FunctionResult",1,8],["sqrtPi","FunctionResult",1,8],["quotient","FunctionResult",2,8],["delta","FunctionResult",2,8],["geStep","FunctionResult",2,8],["isEven","FunctionResult",1,8],["isOdd","FunctionResult",1,8],["mround","FunctionResult",2,8,0,0,"MRound"],["erf","FunctionResult",2,8],["erfC","FunctionResult",1,8],["besselJ","FunctionResult",2,8],["besselK","FunctionResult",2,8],["besselY","FunctionResult",2,8],["besselI","FunctionResult",2,8],["xirr","FunctionResult",3,8],["xnpv","FunctionResult",3,8],["priceMat","FunctionResult",6,8],["yieldMat","FunctionResult",6,8],["intRate","FunctionResult",5,8],["received","FunctionResult",5,8],["disc","FunctionResult",5,8],["priceDisc","FunctionResult",5,8],["yieldDisc","FunctionResult",5,8],["tbillEq","FunctionResult",3,8,0,0,"TBillEq"],["tbillPrice","FunctionResult",3,8,0,0,"TBillPrice"],["tbillYield","FunctionResult",3,8,0,0,"TBillYield"],["price","FunctionResult",7,8],["yield","FunctionResult",7,8],["dollarDe","FunctionResult",2,8],["dollarFr","FunctionResult",2,8],["nominal","FunctionResult",2,8],["effect","FunctionResult",2,8],["cumPrinc","FunctionResult",6,8],["cumIPmt","FunctionResult",6,8],["edate","FunctionResult",2,8,0,0,"EDate"],["eoMonth","FunctionResult",2,8],["yearFrac","FunctionResult",3,8],["coupDayBs","FunctionResult",4,8],["coupDays","FunctionResult",4,8],["coupDaysNc","FunctionResult",4,8],["coupNcd","FunctionResult",4,8],["coupNum","FunctionResult",4,8],["coupPcd","FunctionResult",4,8],["duration","FunctionResult",6,8],["mduration","FunctionResult",6,8,0,0,"MDuration"],["oddLPrice","FunctionResult",8,8],["oddLYield","FunctionResult",8,8],["oddFPrice","FunctionResult",9,8],["oddFYield","FunctionResult",9,8],["randBetween","FunctionResult",2,8],["weekNum","FunctionResult",2,8],["amorDegrc","FunctionResult",7,8],["amorLinc","FunctionResult",7,8],["convert","FunctionResult",3,8],["accrInt","FunctionResult",8,8],["accrIntM","FunctionResult",5,8],["workDay","FunctionResult",3,8],["networkDays","FunctionResult",3,8],["gcd","FunctionResult",1,72],["multiNomial","FunctionResult",1,72],["lcm","FunctionResult",1,72],["fvschedule","FunctionResult",2,8,0,0,"FVSchedule"],["countIfs","FunctionResult",1,72],["sumIfs","FunctionResult",2,72],["averageIf","FunctionResult",3,8],["averageIfs","FunctionResult",2,72],["binom_Dist","FunctionResult",4,8],["binom_Inv","FunctionResult",3,8],["confidence_Norm","FunctionResult",3,8],["confidence_T","FunctionResult",3,8],["expon_Dist","FunctionResult",3,8],["gamma_Dist","FunctionResult",4,8],["gamma_Inv","FunctionResult",3,8],["norm_Dist","FunctionResult",4,8],["norm_Inv","FunctionResult",3,8],["percentile_Exc","FunctionResult",2,8],["percentile_Inc","FunctionResult",2,8],["percentRank_Exc","FunctionResult",3,8],["percentRank_Inc","FunctionResult",3,8],["poisson_Dist","FunctionResult",3,8],["quartile_Exc","FunctionResult",2,8],["quartile_Inc","FunctionResult",2,8],["rank_Avg","FunctionResult",3,8],["rank_Eq","FunctionResult",3,8],["stDev_S","FunctionResult",1,72],["stDev_P","FunctionResult",1,72],["t_Dist","FunctionResult",3,8],["t_Dist_2T","FunctionResult",2,8],["t_Dist_RT","FunctionResult",2,8],["t_Inv","FunctionResult",2,8],["t_Inv_2T","FunctionResult",2,8],["var_S","FunctionResult",1,72],["var_P","FunctionResult",1,72],["weibull_Dist","FunctionResult",4,8],["networkDays_Intl","FunctionResult",4,8],["workDay_Intl","FunctionResult",4,8],["ecma_Ceiling","FunctionResult",2,8,0,0,"ECMA_Ceiling"],["iso_Ceiling","FunctionResult",2,8,0,0,"ISO_Ceiling"],["beta_Dist","FunctionResult",6,8],["beta_Inv","FunctionResult",5,8],["chiSq_Dist","FunctionResult",3,8],["chiSq_Dist_RT","FunctionResult",2,8],["chiSq_Inv","FunctionResult",2,8],["chiSq_Inv_RT","FunctionResult",2,8],["f_Dist","FunctionResult",4,8],["f_Dist_RT","FunctionResult",3,8],["f_Inv","FunctionResult",3,8],["f_Inv_RT","FunctionResult",3,8],["hypGeom_Dist","FunctionResult",5,8],["logNorm_Dist","FunctionResult",4,8],["logNorm_Inv","FunctionResult",3,8],["negBinom_Dist","FunctionResult",4,8],["norm_S_Dist","FunctionResult",2,8],["norm_S_Inv","FunctionResult",1,8],["z_Test","FunctionResult",3,8],["erf_Precise","FunctionResult",1,8],["erfC_Precise","FunctionResult",1,8],["gammaLn_Precise","FunctionResult",1,8],["ceiling_Precise","FunctionResult",2,8],["floor_Precise","FunctionResult",2,8],["acot","FunctionResult",1,8],["acoth","FunctionResult",1,8],["cot","FunctionResult",1,8],["coth","FunctionResult",1,8],["csc","FunctionResult",1,8],["csch","FunctionResult",1,8],["sec","FunctionResult",1,8],["sech","FunctionResult",1,8],["imTan","FunctionResult",1,8],["imCot","FunctionResult",1,8],["imCsc","FunctionResult",1,8],["imCsch","FunctionResult",1,8],["imSec","FunctionResult",1,8],["imSech","FunctionResult",1,8],["bitand","FunctionResult",2,8],["bitor","FunctionResult",2,8],["bitxor","FunctionResult",2,8],["bitlshift","FunctionResult",2,8],["bitrshift","FunctionResult",2,8],["permutationa","FunctionResult",2,8],["combina","FunctionResult",2,8],["xor","FunctionResult",1,72],["pduration","FunctionResult",3,8,0,0,"PDuration"],["base","FunctionResult",3,8],["decimal","FunctionResult",2,8],["days","FunctionResult",2,8],["binom_Dist_Range","FunctionResult",4,8],["gamma","FunctionResult",1,8],["skew_p","FunctionResult",1,72],["gauss","FunctionResult",1,8],["phi","FunctionResult",1,8],["rri","FunctionResult",3,8],["unichar","FunctionResult",1,8],["unicode","FunctionResult",1,8],["arabic","FunctionResult",1,8],["isoWeekNum","FunctionResult",1,8],["numberValue","FunctionResult",3,8],["sheet","FunctionResult",1,8],["sheets","FunctionResult",1,8],["isFormula","FunctionResult",1,8],["ceiling_Math","FunctionResult",3,8],["floor_Math","FunctionResult",3,8],["imSinh","FunctionResult",1,8],["imCosh","FunctionResult",1,8]]]]},targetNamespaceObject:e})}(Excel||(Excel={})),"undefined"!=typeof window&&window.OSF&&window.OSF._OfficeAppFactory&&window.OSF._OfficeAppFactory.getHostInfo&&window.OSF._OfficeAppFactory.getHostInfo()){var hostPlatform=window.OSF._OfficeAppFactory.getHostInfo().hostPlatform;"web"===hostPlatform&&(OfficeExtension._internalConfig.enablePreviewExecution=!0)}!function(e){if(!function(){try{return"object"==typeof process&&"[object process]"===String(process)}catch(e){return!1}}()&&!e.isOfficeReactNative()){try{e.Flights=e.OUtil.parseFlights(!0),e.DisabledChangeGates=e.OUtil.parseDisabledChangeGates(!0)}catch(e){}function t(){OSFPerformance.hostSpecificFileName=e.LoadScriptHelper.getHostBundleJsName(),Office.onReadyInternal((function(){OSFPerfUtil.sendPerformanceTelemetry()})),e._OfficeAppFactory.getHostInfo().hostLocale&&setTimeout((function(){e.OUtil.ensureOfficeStringsJs().catch((function(e){console.error(e)}))}),0)}e._OfficeAppFactory.bootstrap((function(){}),(function(e){e instanceof Error?console.warn(e.message):console.warn(JSON.stringify(e))})),"complete"===document.readyState||"interactive"===document.readyState?t():window.addEventListener("DOMContentLoaded",(function(e){t()}))}}(OSF||(OSF={})),OSFPerformance.hostInitializationEnd=OSFPerformance.now(),OSFPerformance.totalJSHeapSize=OSFPerformance.getTotalJSHeapSize(),OSFPerformance.usedJSHeapSize=OSFPerformance.getUsedJSHeapSize(),OSFPerformance.jsHeapSizeLimit=OSFPerformance.getJSHeapSizeLimit();