/*
 * Office JavaScript API library
 *
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 *
 * Your use of this file is governed by the license terms for the Microsoft Office JavaScript (Office.js) API library: https://github.com/OfficeDev/office-js/blob/release/LICENSE.md
 *
 * This file also contains the following Promise implementation (with a few small modifications):
 *      * @overview es6-promise - a tiny implementation of Promises/A+.
 *      * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 *      * @license   Licensed under MIT license
 *      *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
 *      * @version   2.3.0
 */
var OSFPerformance,CustomFunctionMappings,CustomFunctions,Strings;!function(e){e.now=function(){return"undefined"!=typeof performance&&performance.now?performance.now():0},e.getTotalJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.totalJSHeapSize:0},e.getUsedJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.usedJSHeapSize:0},e.getJSHeapSizeLimit=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.jsHeapSizeLimit:0},e.officeExecuteStartDate=e.officeExecuteStartDate||Date.now(),e.officeExecuteStart=e.officeExecuteStart||0,e.officeExecuteEnd=e.officeExecuteEnd||0,e.hostInitializationStart=0,e.hostInitializationEnd=0,e.totalJSHeapSize=0,e.usedJSHeapSize=0,e.jsHeapSizeLimit=0,e.createOMEnd=0,e.hostSpecificFileName="",e.getAppContextStart=0,e.getAppContextEnd=0,e.getAppContextXdmStart=0,e.getAppContextXdmEnd=0,e.officeOnReady=0}(OSFPerformance||(OSFPerformance={})),function(e){e.definePropertyOnNamespace=function(e,t,n){Object.defineProperty(e,t,{get:function(){return n()},configurable:!0,enumerable:!0})}}(OSF||(OSF={})),OSFPerformance.hostInitializationStart=OSFPerformance.now(),function(e){!function(e){function t(){return e.m_association||(e.m_association=new OSF.Association),e.m_association}e.m_association=e.m_association,e.associate=function(){t().associate.apply(t(),arguments)},OSF.definePropertyOnNamespace(e,"_association",t)}(e.actions||(e.actions={}))}(Office||(Office={})),function(e){!function(e){e[e.Select=0]="Select",e[e.UnSelect=1]="UnSelect",e[e.CancelDialog=2]="CancelDialog",e[e.InsertAgave=3]="InsertAgave",e[e.CtrlF6In=4]="CtrlF6In",e[e.CtrlF6Exit=5]="CtrlF6Exit",e[e.CtrlF6ExitShift=6]="CtrlF6ExitShift",e[e.SelectWithError=7]="SelectWithError",e[e.NotifyHostError=8]="NotifyHostError",e[e.RefreshAddinCommands=9]="RefreshAddinCommands",e[e.PageIsReady=10]="PageIsReady",e[e.TabIn=11]="TabIn",e[e.TabInShift=12]="TabInShift",e[e.TabExit=13]="TabExit",e[e.TabExitShift=14]="TabExitShift",e[e.EscExit=15]="EscExit",e[e.F2Exit=16]="F2Exit",e[e.ExitNoFocusable=17]="ExitNoFocusable",e[e.ExitNoFocusableShift=18]="ExitNoFocusableShift",e[e.MouseEnter=19]="MouseEnter",e[e.MouseLeave=20]="MouseLeave",e[e.UpdateTargetUrl=21]="UpdateTargetUrl",e[e.InstallCustomFunctions=22]="InstallCustomFunctions",e[e.SendTelemetryEvent=23]="SendTelemetryEvent",e[e.UninstallCustomFunctions=24]="UninstallCustomFunctions",e[e.SendMessage=25]="SendMessage",e[e.LaunchExtensionComponent=26]="LaunchExtensionComponent",e[e.StopExtensionComponent=27]="StopExtensionComponent",e[e.RestartExtensionComponent=28]="RestartExtensionComponent",e[e.EnableTaskPaneHeaderButton=29]="EnableTaskPaneHeaderButton",e[e.DisableTaskPaneHeaderButton=30]="DisableTaskPaneHeaderButton",e[e.TaskPaneHeaderButtonClicked=31]="TaskPaneHeaderButtonClicked",e[e.RemoveAppCommandsAddin=32]="RemoveAppCommandsAddin",e[e.RefreshRibbonGallery=33]="RefreshRibbonGallery",e[e.GetOriginalControlId=34]="GetOriginalControlId",e[e.OfficeJsReady=35]="OfficeJsReady",e[e.InsertDevManifest=36]="InsertDevManifest",e[e.InsertDevManifestError=37]="InsertDevManifestError",e[e.SendCustomerContent=38]="SendCustomerContent",e[e.KeyboardShortcuts=39]="KeyboardShortcuts",e[e.CloseSDXDialog=42]="CloseSDXDialog",e[e.ResizeSDXDialog=43]="ResizeSDXDialog",e[e.SendNonStandardEvent=44]="SendNonStandardEvent"}(e.AgaveHostAction||(e.AgaveHostAction={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){var t=this;this._processAppCommandInvocation=function(e){var n=t._verifyManifestCallback(e.callbackName);if(0==n.errorCode){var r=t._constructEventObjectForCallback(e);r?window.setTimeout((function(){n.callback(r)}),0):t._invokeAppCommandCompletedMethod(e.appCommandId,5001,"")}else t._invokeAppCommandCompletedMethod(e.appCommandId,n.errorCode,"")},this._eventDispatch=new e.EventDispatch([{type:e.EventType.AppCommandInvoked,id:e.EventDispId.dispidAppCommandInvokedEvent,getTargetId:function(){return""},fromSafeArrayHost:function(t){return{type:e.EventType.AppCommandInvoked,appCommandId:t[0],callbackName:t[1],eventObjStr:t[2]}},fromWebHost:function(t){return{type:e.EventType.AppCommandInvoked,appCommandId:t[0],callbackName:t[1],eventObjStr:t[2]}}}])}return t.prototype.initializeEventHandler=function(t){var n=this;this.addHandlerAsync(e.EventType.AppCommandInvoked,(function(e){n._processAppCommandInvocation(e)}),t)},t.prototype.appCommandInvocationCompletedAsync=function(t,n,r,i){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(94,{fromSafeArrayHost:function(e){return e},fromWebHost:function(e){return e},toSafeArrayHost:function(){return[t,n,r]},toWebHost:function(){var e={};return e[0]=t,e[1]=n,e[2]=r,e}},i)},t.prototype.addHandlerAsync=function(t,n,r){e.EventHelper.addEventHandler(t,n,r,this._eventDispatch,void 0,e.OUtil.isPopupWindow())},t.prototype._verifyManifestCallback=function(e){var t={callback:null,errorCode:11101};e=e.trim();try{var n=this._getCallbackFunc(e);if("function"!=typeof n)return t}catch(e){return t}return{callback:n,errorCode:0}},t.prototype._getCallbackFuncFromActionAssociateTable=function(e){var t=e.toUpperCase();return Office.actions._association.mappings[t]},t.prototype._getCallbackFunc=function(e){return this._getCallbackFuncFromActionAssociateTable(e)},t.prototype._invokeAppCommandCompletedMethod=function(e,t,n){this.appCommandInvocationCompletedAsync(e,t,n,(function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Failed to notify the host thta app command is completed")}))},t.prototype._constructEventObjectForCallback=function(e){var t,n,r=this;try{t=JSON.parse(e.eventObjStr),n=JSON.parse(e.eventObjStr)}catch(e){}return t||(t={}),n||(n={}),t.completed=function(t){n.completedContext=t;var i=JSON.stringify(n);r._invokeAppCommandCompletedMethod(e.appCommandId,0,i)},t},t.initialize=function(){null==t._instance&&(t._instance=new t,t._instance.initializeEventHandler((function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Cannot initialize app command: "+JSON.stringify(e))})))},t._instance=null,t}();e.AppCommandManager=t}(OSF||(OSF={})),function(e){!function(e){e[e.Unsupported=0]="Unsupported",e[e.Excel=1]="Excel",e[e.Word=2]="Word",e[e.PowerPoint=4]="PowerPoint",e[e.Outlook=8]="Outlook",e[e.ExcelWebApp=16]="ExcelWebApp",e[e.WordWebApp=32]="WordWebApp",e[e.OutlookWebApp=64]="OutlookWebApp",e[e.Project=128]="Project",e[e.AccessWebApp=256]="AccessWebApp",e[e.PowerpointWebApp=512]="PowerpointWebApp",e[e.ExcelIOS=1024]="ExcelIOS",e[e.Sway=2048]="Sway",e[e.WordIOS=4096]="WordIOS",e[e.PowerPointIOS=8192]="PowerPointIOS",e[e.Access=16384]="Access",e[e.Lync=32768]="Lync",e[e.OutlookIOS=65536]="OutlookIOS",e[e.OneNoteWebApp=131072]="OneNoteWebApp",e[e.OneNote=262144]="OneNote",e[e.ExcelWinRT=524288]="ExcelWinRT",e[e.WordWinRT=1048576]="WordWinRT",e[e.PowerpointWinRT=2097152]="PowerpointWinRT",e[e.OutlookAndroid=4194304]="OutlookAndroid",e[e.OneNoteWinRT=8388608]="OneNoteWinRT",e[e.ExcelAndroid=8388609]="ExcelAndroid",e[e.VisioWebApp=8388610]="VisioWebApp",e[e.OneNoteIOS=8388611]="OneNoteIOS",e[e.WordAndroid=8388613]="WordAndroid",e[e.PowerpointAndroid=8388614]="PowerpointAndroid",e[e.Visio=8388615]="Visio",e[e.OneNoteAndroid=4194305]="OneNoteAndroid"}(e.AppName||(e.AppName={}))}(OSF||(OSF={})),function(e){var t=function(){function e(){this.m_mappings={},this.m_onchangeHandlers=[]}return e.prototype.associate=function(e,t){function n(e){"undefined"!=typeof console&&console.warn&&console.warn(e)}if(1==arguments.length&&"object"==typeof arguments[0]&&arguments[0]){var r=arguments[0];for(var i in r)this.associate(i,r[i])}else if(2==arguments.length){var o=arguments[0],a=arguments[1];if("string"!=typeof o)return void n("[InvalidArg] Function=associate");if("function"!=typeof a)return void n("[InvalidArg] Function=associate");var s=o.toUpperCase();this.m_mappings[s]&&n("[DuplicatedName] Function="+o),this.m_mappings[s]=a;for(var c=0;c<this.m_onchangeHandlers.length;c++)this.m_onchangeHandlers[c]()}else n("[InvalidArg] Function=associate")},e.prototype.onchange=function(e){e&&this.m_onchangeHandlers.push(e)},Object.defineProperty(e.prototype,"mappings",{get:function(){return this.m_mappings},enumerable:!0,configurable:!0}),e}();e.Association=t}(OSF||(OSF={})),function(e){var t=function(){function e(){}return e.prototype.invokeCallback=function(e,t,n,r,i){if(0==n){var o={status:Office.AsyncResultStatus.Succeeded,value:r,asyncContext:i};"function"==typeof t&&t(o)}else{var a={status:Office.AsyncResultStatus.Failed,error:{code:n},asyncContext:i};"function"==typeof t&&t(a)}},e}();e.AsyncMethodExecutor=t}(OSF||(OSF={})),function(e){var t=function(){function t(e){this._asyncMethodExecutor=e}return t.prototype.handleSafeArrayHostResponse=function(t,n,r,i,o,a,s){var c,u;if("number"==typeof(t=e.Utility.fromSafeArray(t))?(c=[],u=t):u=(c=t)[0],1==u)return null!=(l=c[1])&&(r[l[0]]=l[1]),!1;if(i){var l;if(0==u){if(c.length>2){l=[];for(var f=1;f<c.length;f++)l[f-1]=c[f]}else l=c[1];if(r.length>0&&null!=l){var p=l[l.length-1];r.length==p?l[l.length-1]=r:u=5001}}else l=c[1];var d=null;0==u&&(d=o.fromSafeArrayHost(l)),this._asyncMethodExecutor.invokeCallback(a,i,u,d,s)}return!0},t.prototype.handleWebHostResponse=function(e,t,n,r,i,o){var a=null;0==t&&(a=r.fromWebHost(e)),this._asyncMethodExecutor.invokeCallback(i,n,t,a,o)},t}();e.AsyncMethodExecutorHelper=t}(OSF||(OSF={})),function(e){!function(e){!function(e){!function(e){e.Context="Context",e.Value="Value",e.Status="Status",e.Error="Error"}(e.Properties||(e.Properties={})),function(e){e[e.Success=0]="Success",e[e.Failed=1]="Failed"}(e.ErrorCode||(e.ErrorCode={})),function(e){e.Name="Name",e.Message="Message",e.Code="Code"}(e.ErrorProperties||(e.ErrorProperties={}))}(e.AsyncResultEnum||(e.AsyncResultEnum={}));var t=function(e,t){this.value=e.Value,this.status=t?Office.AsyncResultStatus.Failed:Office.AsyncResultStatus.Succeeded,e.Context&&(this.asyncContext=e.Context),t&&(this.error=new n(t.Name,t.Message,t.Code))};e.AsyncResult=t;var n=function(e,t,n){this.name=e,this.message=t,this.code=n};e.Error=n}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){!function(t){t.createWebClientHostControllerHelper=function(t,n){return new e.WebClientHostControllerHelper(t,n)},t.createAsyncMethodExecutorHelper=function(t){return new e.AsyncMethodExecutorHelper(t)}}(e.BootStrapExtension||(e.BootStrapExtension={}))}(OSF||(OSF={})),function(e){!function(e){e.DefaultLocale="en-us",e.OfficeJS="office.js",e.OfficeDebugJS="office.debug.js",e.OfficeStringsId="OFFICESTRINGS",e.OfficeJsId="OFFICEJS",e.HostFileId="HOST",e.OfficeStringJS="office_strings.js",e.OfficeStringDebugJS="office_strings.debug.js",e.FileVersion="16.0.18408.15020"}(e.ConstantNames||(e.ConstantNames={}))}(OSF||(OSF={})),function(e){var t=function(){function e(){}return e.NotificationConversationIdSuffix="_ntf",e}();e.Constants=t}(OSF||(OSF={})),CustomFunctionMappings||(CustomFunctionMappings={}),function(e){e.delayInitialization=function(){CustomFunctionMappings.__delay__=!0},e._association=e._association||new OSF.Association,e.associate=function(){e._association.associate.apply(e._association,arguments),delete CustomFunctionMappings.__delay__}}(CustomFunctions||(CustomFunctions={})),function(e){!function(e){!function(e){var t={},n=!1;e.getErrorArgs=function(e){var r;n||(r=Strings.OfficeOM,t[1e3]={name:r.L_InvalidCoercion,message:r.L_CoercionTypeNotSupported},t[1001]={name:r.L_DataReadError,message:r.L_GetSelectionNotSupported},t[1002]={name:r.L_InvalidCoercion,message:r.L_CoercionTypeNotMatchBinding},t[1003]={name:r.L_DataReadError,message:r.L_InvalidGetRowColumnCounts},t[1004]={name:r.L_DataReadError,message:r.L_SelectionNotSupportCoercionType},t[1005]={name:r.L_DataReadError,message:r.L_InvalidGetStartRowColumn},t[1006]={name:r.L_DataReadError,message:r.L_NonUniformPartialGetNotSupported},t[1008]={name:r.L_DataReadError,message:r.L_GetDataIsTooLarge},t[1009]={name:r.L_DataReadError,message:r.L_FileTypeNotSupported},t[1010]={name:r.L_DataReadError,message:r.L_GetDataParametersConflict},t[1011]={name:r.L_DataReadError,message:r.L_InvalidGetColumns},t[1012]={name:r.L_DataReadError,message:r.L_InvalidGetRows},t[1013]={name:r.L_DataReadError,message:r.L_InvalidReadForBlankRow},t[2e3]={name:r.L_DataWriteError,message:r.L_UnsupportedDataObject},t[2001]={name:r.L_DataWriteError,message:r.L_CannotWriteToSelection},t[2002]={name:r.L_DataWriteError,message:r.L_DataNotMatchSelection},t[2003]={name:r.L_DataWriteError,message:r.L_OverwriteWorksheetData},t[2004]={name:r.L_DataWriteError,message:r.L_DataNotMatchBindingSize},t[2005]={name:r.L_DataWriteError,message:r.L_InvalidSetStartRowColumn},t[2006]={name:r.L_InvalidFormat,message:r.L_InvalidDataFormat},t[2007]={name:r.L_InvalidDataObject,message:r.L_DataNotMatchCoercionType},t[2008]={name:r.L_InvalidDataObject,message:r.L_DataNotMatchBindingType},t[2009]={name:r.L_DataWriteError,message:r.L_SetDataIsTooLarge},t[2010]={name:r.L_DataWriteError,message:r.L_NonUniformPartialSetNotSupported},t[2011]={name:r.L_DataWriteError,message:r.L_InvalidSetColumns},t[2012]={name:r.L_DataWriteError,message:r.L_InvalidSetRows},t[2013]={name:r.L_DataWriteError,message:r.L_SetDataParametersConflict},t[3e3]={name:r.L_BindingCreationError,message:r.L_SelectionCannotBound},t[3002]={name:r.L_InvalidBindingError,message:r.L_BindingNotExist},t[3003]={name:r.L_BindingCreationError,message:r.L_BindingToMultipleSelection},t[3004]={name:r.L_BindingCreationError,message:r.L_InvalidSelectionForBindingType},t[3005]={name:r.L_InvalidBindingOperation,message:r.L_OperationNotSupportedOnThisBindingType},t[3006]={name:r.L_BindingCreationError,message:r.L_NamedItemNotFound},t[3007]={name:r.L_BindingCreationError,message:r.L_MultipleNamedItemFound},t[3008]={name:r.L_BindingCreationError,message:r.L_InvalidNamedItemForBindingType},t[3009]={name:r.L_InvalidBinding,message:r.L_UnknownBindingType},t[3010]={name:r.L_InvalidBindingOperation,message:r.L_OperationNotSupportedOnMatrixData},t[3011]={name:r.L_InvalidBinding,message:r.L_InvalidColumnsForBinding},t[4e3]={name:r.L_ReadSettingsError,message:r.L_SettingNameNotExist},t[4001]={name:r.L_SaveSettingsError,message:r.L_SettingsCannotSave},t[4002]={name:r.L_SettingsStaleError,message:r.L_SettingsAreStale},t[5e3]={name:r.L_HostError,message:r.L_OperationNotSupported},t[5001]={name:r.L_InternalError,message:r.L_InternalErrorDescription},t[5002]={name:r.L_PermissionDenied,message:r.L_DocumentReadOnly},t[5003]={name:r.L_EventRegistrationError,message:r.L_EventHandlerNotExist},t[5004]={name:r.L_InvalidAPICall,message:r.L_InvalidApiCallInContext},t[5005]={name:r.L_ShuttingDown,message:r.L_ShuttingDown},t[5007]={name:r.L_UnsupportedEnumeration,message:r.L_UnsupportedEnumerationMessage},t[5008]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[5009]={name:r.L_APINotSupported,message:r.L_BrowserAPINotSupported},t[5011]={name:r.L_APICallFailed,message:r.L_RequestTimeout},t[5012]={name:r.L_InvalidOrTimedOutSession,message:r.L_InvalidOrTimedOutSessionMessage},t[5013]={name:r.L_APICallFailed,message:r.L_InvalidApiArgumentsMessage},t[5015]={name:r.L_APICallFailed,message:r.L_WorkbookHiddenMessage},t[5016]={name:r.L_APICallFailed,message:r.L_WriteNotSupportedWhenModalDialogOpen},t[5017]={name:r.L_APICallFailed,message:r.L_UndoNotSupportedMessage},t[5100]={name:r.L_APICallFailed,message:r.L_TooManyIncompleteRequests},t[5101]={name:r.L_APICallFailed,message:r.L_RequestTokenUnavailable},t[5102]={name:r.L_APICallFailed,message:r.L_ActivityLimitReached},t[5103]={name:r.L_APICallFailed,message:r.L_RequestPayloadSizeLimitExceededMessage},t[5104]={name:r.L_APICallFailed,message:r.L_ResponsePayloadSizeLimitExceededMessage},t[6e3]={name:r.L_InvalidNode,message:r.L_CustomXmlNodeNotFound},t[6100]={name:r.L_CustomXmlError,message:r.L_CustomXmlError},t[6101]={name:r.L_CustomXmlExceedQuotaName,message:r.L_CustomXmlExceedQuotaMessage},t[6102]={name:r.L_CustomXmlOutOfDateName,message:r.L_CustomXmlOutOfDateMessage},t[7e3]={name:r.L_PermissionDenied,message:r.L_NoCapability},t[7001]={name:r.L_CannotNavigateTo,message:r.L_CannotNavigateTo},t[7002]={name:r.L_SpecifiedIdNotExist,message:r.L_SpecifiedIdNotExist},t[7004]={name:r.L_NavOutOfBound,message:r.L_NavOutOfBound},t[2014]={name:r.L_DataWriteReminder,message:r.L_CellDataAmountBeyondLimits},t[8e3]={name:r.L_MissingParameter,message:r.L_ElementMissing},t[8001]={name:r.L_PermissionDenied,message:r.L_NoCapability},t[8010]={name:r.L_InvalidValue,message:r.L_InvalidCellsValue},t[8011]={name:r.L_InvalidValue,message:r.L_InvalidTableOptionValue},t[8012]={name:r.L_InvalidValue,message:r.L_InvalidFormatValue},t[8020]={name:r.L_OutOfRange,message:r.L_RowIndexOutOfRange},t[8021]={name:r.L_OutOfRange,message:r.L_ColIndexOutOfRange},t[8022]={name:r.L_OutOfRange,message:r.L_FormatValueOutOfRange},t[8023]={name:r.L_FormattingReminder,message:r.L_CellFormatAmountBeyondLimits},t[1e4]={name:r.L_UserNotSignedIn,message:r.L_UserNotSignedIn},t[11e3]={name:r.L_MemoryLimit,message:r.L_CloseFileBeforeRetrieve},t[11001]={name:r.L_NetworkProblem,message:r.L_NetworkProblemRetrieveFile},t[11002]={name:r.L_InvalidValue,message:r.L_SliceSizeNotSupported},t[12007]={name:r.L_DisplayDialogError,message:r.L_DialogAlreadyOpened},t[12e3]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[12001]={name:r.L_IndexOutOfRange,message:r.L_IndexOutOfRange},t[12002]={name:r.L_DisplayDialogError,message:r.L_NetworkProblem},t[12003]={name:r.L_DialogNavigateError,message:r.L_DialogInvalidScheme},t[12004]={name:r.L_DisplayDialogError,message:r.L_DialogAddressNotTrusted},t[12005]={name:r.L_DisplayDialogError,message:r.L_DialogRequireHTTPS},t[12009]={name:r.L_DisplayDialogError,message:r.L_UserClickIgnore},t[12011]={name:r.L_DisplayDialogError,message:r.L_NewWindowCrossZoneErrorString},t[13e3]={name:r.L_APINotSupported,message:r.L_InvalidSSOAddinMessage},t[13001]={name:r.L_UserNotSignedIn,message:r.L_UserNotSignedIn},t[13002]={name:r.L_UserAborted,message:r.L_UserAbortedMessage},t[13003]={name:r.L_UnsupportedUserIdentity,message:r.L_UnsupportedUserIdentityMessage},t[13004]={name:r.L_InvalidResourceUrl,message:r.L_InvalidResourceUrlMessage},t[13005]={name:r.L_InvalidGrant,message:r.L_InvalidGrantMessage},t[13006]={name:r.L_SSOClientError,message:r.L_SSOClientErrorMessage},t[13007]={name:r.L_SSOServerError,message:r.L_SSOServerErrorMessage},t[13008]={name:r.L_AddinIsAlreadyRequestingToken,message:r.L_AddinIsAlreadyRequestingTokenMessage},t[13009]={name:r.L_SSOUserConsentNotSupportedByCurrentAddinCategory,message:r.L_SSOUserConsentNotSupportedByCurrentAddinCategoryMessage},t[13010]={name:r.L_SSOConnectionLostError,message:r.L_SSOConnectionLostErrorMessage},t[13012]={name:r.L_APINotSupported,message:r.L_SSOUnsupportedPlatform},t[13013]={name:r.L_APICallFailed,message:r.L_RequestTokenUnavailable},t[5014]={name:r.L_OperationCancelledError,message:r.L_OperationCancelledErrorMessage},n=!0);var i=t[e];return i?(i.name||(i.name=t[5001].name),i.message||(i.message=t[5001].message)):i=t[5001],i},e.addErrorMessage=function(e,n){t[e]=n}}(e.ErrorCodeManager||(e.ErrorCodeManager={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t=function(){function e(e){if(this._eventInfos={},this._queuedEventsArgs={},this._eventHandlers={},this._queuedEventsArgs={},null!=e)for(var t=0;t<e.length;t++)if("string"==typeof e[t]){var n=e[t];this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}else{n=e[t].type;this._eventInfos[n]=e[t],this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}}return e.prototype.getSupportedEvents=function(){var e=[];for(var t in this._eventHandlers)e.push(t);return e},e.prototype.supportsEvent=function(e){for(var t in this._eventHandlers)if(e==t)return!0;return!1},e.prototype.hasEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&n.length>0)for(var r=0;r<n.length;r++)if(n[r]===t)return!0;return!1},e.prototype.addEventHandler=function(e,t){if("function"!=typeof t)return!1;var n=this._eventHandlers[e];return!(!n||this.hasEventHandler(e,t))&&(n.push(t),!0)},e.prototype.addEventHandlerAndFireQueuedEvent=function(e,t){var n=this._eventHandlers[e],r=!n||0==n.length,i=this.addEventHandler(e,t);return r&&i&&this.fireQueuedEvent(e),i},e.prototype.removeEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&n.length>0)for(var r=0;r<n.length;r++)if(n[r]===t)return n.splice(r,1),!0;return!1},e.prototype.clearEventHandlers=function(e){return void 0!==this._eventHandlers[e]&&this._eventHandlers[e].length>0&&(this._eventHandlers[e]=[],!0)},e.prototype.getEventHandlerCount=function(e){return null!=this._eventHandlers[e]?this._eventHandlers[e].length:-1},e.prototype.getEventInfo=function(e){return this._eventInfos[e]},e.prototype.fireEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){for(var n=this._eventHandlers[t],r=0;r<n.length;r++)n[r](e);return!0}return!1},e.prototype.fireOrQueueEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){var n=this._eventHandlers[t],r=this._queuedEventsArgs[t];return 0==n.length?r.push(e):this.fireEvent(e),!0}return!1},e.prototype.fireQueuedEvent=function(e){if(e&&this._eventHandlers[e]){var t=this._eventHandlers[e],n=this._queuedEventsArgs[e];if(t.length>0){for(var r=t[0];n.length>0;){r(n.shift())}return!0}}return!1},e.prototype.clearQueuedEvent=function(e){e&&this._eventHandlers[e]&&(this._queuedEventsArgs[e]&&(this._queuedEventsArgs[e]=[]))},e}();e.EventDispatch=t}(OSF||(OSF={})),function(e){!function(e){e.dispidEventMin=0,e.dispidInitializeEvent=0,e.dispidSettingsChangedEvent=1,e.dispidDocumentSelectionChangedEvent=2,e.dispidBindingSelectionChangedEvent=3,e.dispidBindingDataChangedEvent=4,e.dispidDocumentOpenEvent=5,e.dispidDocumentCloseEvent=6,e.dispidActiveViewChangedEvent=7,e.dispidDocumentThemeChangedEvent=8,e.dispidOfficeThemeChangedEvent=9,e.dispidDialogMessageReceivedEvent=10,e.dispidDialogNotificationShownInAddinEvent=11,e.dispidDialogParentMessageReceivedEvent=12,e.dispidObjectDeletedEvent=13,e.dispidObjectSelectionChangedEvent=14,e.dispidObjectDataChangedEvent=15,e.dispidContentControlAddedEvent=16,e.dispidLiveShareStateChangedEvent=17,e.dispidActivationStatusChangedEvent=32,e.dispidRichApiMessageEvent=33,e.dispidAppCommandInvokedEvent=39,e.dispidOnSdxSendMessageEvent=40,e.dispidDataNodeAddedEvent=60,e.dispidDataNodeReplacedEvent=61,e.dispidDataNodeDeletedEvent=62}(e.EventDispId||(e.EventDispId={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.addEventHandler=function(n,r,i,o,a,s){var c=0;function u(t){0==t&&(o.hasEventHandler(n,r)||o.addEventHandler(n,r)||(t=5010));e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(c,i,t,null,a)}var l=o.getEventInfo(n);if(l)try{if(s)return void u(0);c=l.id;var f=l.getTargetId();if(0==o.getEventHandlerCount(n))e._OfficeAppFactory.getAsyncMethodExecutor().registerEventAsync(c,l.type,f,(function(e){o.fireEvent(e)}),l,(function(t){u(e.Utility.getErrorCodeFromAsyncResult(t))}),a);else u(0)}catch(e){t.onException(c,e,i)}else u(5010)},t.removeEventHandler=function(n,r,i,o,a,s){var c=0;function u(t){e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(c,i,t,null,a)}var l=o.getEventInfo(n);if(l)try{c=l.id;var f=l.getTargetId(),p=0,d=!0;null===r?(d=o.clearEventHandlers(n),p=0):p=(d=o.removeEventHandler(n,r))?0:5003;var h=o.getEventHandlerCount(n);if(d&&0==h)e._OfficeAppFactory.getAsyncMethodExecutor().unregisterEventAsync(c,l.type,f,(function(t){u(e.Utility.getErrorCodeFromAsyncResult(t))}),a);else u(p)}catch(e){t.onException(c,e,i)}else u(5010)},t.onException=function(t,n,r){if("number"!=typeof n)throw n;e._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(t,r,n,null)},t}();e.EventHelper=t}(OSF||(OSF={})),function(e){!function(e){e.ActiveViewChanged="activeViewChanged",e.AppCommandInvoked="appCommandInvoked",e.RichApiMessage="richApiMessage",e.DocumentSelectionChanged="documentSelectionChanged",e.BindingSelectionChanged="bindingSelectionChanged",e.BindingDataChanged="bindingDataChanged",e.OfficeThemeChanged="officeThemeChanged",e.DocumentThemeChanged="documentThemeChanged",e.LiveShareStateChanged="liveShareStateChanged",e.DataNodeDeleted="nodeDeleted",e.DataNodeInserted="nodeInserted",e.DataNodeReplaced="nodeReplaced",e.DialogMessageReceived="dialogMessageReceived",e.DialogParentMessageReceived="dialogParentMessageReceived",e.DialogParentEventReceived="dialogParentEventReceived",e.DialogEventReceived="dialogEventReceived",e.NodeDeleted="nodeDeleted",e.NodeInserted="nodeInserted",e.NodeReplaced="nodeReplaced",e.SettingsChanged="settingsChanged"}(e.EventType||(e.EventType={}))}(OSF||(OSF={})),function(e){!function(t){var n=function(){function t(){this.platformRemappings={web:Office.PlatformType.OfficeOnline,winrt:Office.PlatformType.Universal,win32:Office.PlatformType.PC,mac:Office.PlatformType.Mac,ios:Office.PlatformType.iOS,android:Office.PlatformType.Android},this.camelCaseMappings={powerpoint:Office.HostType.PowerPoint,onenote:Office.HostType.OneNote},this.hostInfo=e._OfficeAppFactory.getHostInfo()}return t.prototype.capitalizeFirstLetter=function(e){return e?e[0].toUpperCase()+e.slice(1).toLowerCase():e},t.getInstance=function(){return void 0===t.hostObj&&(t.hostObj=new t),t.hostObj},t.prototype.getPlatform=function(e){if(this.hostInfo&&this.hostInfo.hostPlatform){var t=this.hostInfo.hostPlatform.toLowerCase();if(this.platformRemappings[t])return this.platformRemappings[t]}return null},t.prototype.getHost=function(e){if(this.hostInfo&&this.hostInfo.hostType){var t=this.hostInfo.hostType.toLowerCase();if(this.camelCaseMappings[t])return this.camelCaseMappings[t];if(t=this.capitalizeFirstLetter(this.hostInfo.hostType),Office.HostType[t])return Office.HostType[t]}return null},t.prototype.getDefaultVersion=function(){return this.getHost()?"16.0.0000.0000":null},t.prototype.getDiagnostics=function(e){return{host:this.getHost(),version:e||this.getDefaultVersion(),platform:this.getPlatform()}},t}();t.Host=n}(e.HostName||(e.HostName={}))}(OSF||(OSF={})),function(e){!function(e){e[e.SharedApp=1]="SharedApp",e[e.CustomFunction=2]="CustomFunction",e[e.ProtectedDocDisable=4]="ProtectedDocDisable",e[e.ExperimentJsEnabled=8]="ExperimentJsEnabled",e[e.PublicAddin=16]="PublicAddin",e[e.BundleJsEnabled=32]="BundleJsEnabled",e[e.IsMos=64]="IsMos",e[e.IsMonarch=128]="IsMonarch"}(e.HostInfoFlags||(e.HostInfoFlags={}))}(OSF||(OSF={})),function(e){!function(e){e.excel="excel",e.word="word"}(e.HostInfoHostType||(e.HostInfoHostType={}))}(OSF||(OSF={})),function(e){!function(e){e.web="web",e.winrt="winrt",e.win32="win32",e.mac="mac",e.ios="ios",e.android="android"}(e.HostInfoPlatform||(e.HostInfoPlatform={}))}(OSF||(OSF={})),function(e){var t=function(){function t(e,t,n,r){this._hostInfo=e,this._webAppState=t,this._context=n,this._hostFacade=r}return t.prototype.saveAndSetDialogInfo=function(e){},t.prototype.setAgaveHostCommunication=function(){},t.prototype.createClientHostController=function(){return null},t.prototype.createAsyncMethodExecutor=function(){return null},t.prototype.createClientSettingsManager=function(){return null},t.prototype.createSettings=function(t){var n=e.OUtil.getSessionStorage();if(n){var r=n.getItem(e._OfficeAppFactory.getCachedSessionSettingsKey());r?t=JSON.parse(r):(r=JSON.stringify(t),n.setItem(e._OfficeAppFactory.getCachedSessionSettingsKey(),r))}var i=e.OUtil.deserializeSettings(t),o=this.createClientSettingsManager();return new Office.Settings(i,o)},t.prototype.prepareApiSurface=function(t){var n=t.get_featureGates();n&&(Microsoft.Office.WebExtension.FeatureGates=n),e.BootStrapExtension.prepareApiSurface&&e.BootStrapExtension.prepareApiSurface(),e.BootStrapExtension.prepareHostSpecificSurface&&e.BootStrapExtension.prepareHostSpecificSurface(),OSFPerformance.createOMEnd=OSFPerformance.now()},t.prototype.getTabbableElements=function(){return null},t}();e.InitializationHelper=t}(OSF||(OSF={})),function(e){!function(e){e.Inserted="inserted",e.DocumentOpened="documentOpened"}(e.InitializationReason||(e.InitializationReason={}))}(OSF||(OSF={})),OSF||(OSF={}),function(e){!function(t){var n,r=null,i=!1,o=["excel","word","powerpoint","outlook","office-common","office.common","office","officebase"],a=[".js",".debug.js"],s="_osfDisableHostCheck",c=function(){try{return document.currentScript}catch(e){return null}}();function u(){return l(),n.trustedTypesOptIn}function l(){if(!n){var e=function(e){var t=null!=e?e.src:null;if(!t)return null;for(var n=t.toLowerCase(),r=0;r<o.length;r++)for(var i=0;i<a.length;i++){var c=o[r]+a[i],u=n.indexOf(c);if(u>=0&&(0===u||"/"===t.charAt(u-1)||"\\"===t.charAt(u-1))&&(u+c.length===t.length||"?"===t.charAt(u+c.length))){var l=t.substring(0,u),f=n.indexOf(".debug.js",u)>0,p=e.getAttribute("data-is-sdx"),d="1"===p||"true"===p,h=e.getAttribute("data-enable-trusted-types"),g="1"===h||"true"===h;return{basePath:l,name:c,isDebugJs:f,isSdx:d,disableHostCheck:window.hasOwnProperty(s)&&!0===window._osfDisableHostCheck,trustedTypesOptIn:g}}}return null};if(!(n=e(c))){for(var t=document.getElementsByTagName("script"),r=t.length,i=0;i<r;i++)if(n=e(t[i]))return;n={basePath:"",name:"",isDebugJs:!1,isSdx:!1,disableHostCheck:!1,trustedTypesOptIn:!1}}}}t.getHostBundleJsBasePath=function(){return l(),n.basePath},t.getHostBundleJsName=function(){return l(),n.name},t.getOfficeStringJsName=function(){return l(),n.isDebugJs?e.ConstantNames.OfficeStringDebugJS:e.ConstantNames.OfficeStringJS},t.isSdx=function(){return l(),n.isSdx},t.disableHostCheck=function(){return l(),n.disableHostCheck},t.trustedTypesOptIn=u,t.loadScriptWithBasename=function(t,r,i){l();var o=t+(n.isDebugJs?".debug.js":".js");o=o.toLowerCase();var a=n.basePath+o;e.OUtil.loadScript(a,r,p())};var f=["https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js"];function p(){if(!i){i=!0;try{if(!u()||!window.trustedTypes||!window.trustedTypes.createPolicy)return null;var e=c.src,t=new URL(e).origin.toLowerCase();if(!t)return null;r=window.trustedTypes.createPolicy("officejs",{createScriptURL:function(e){var n=e.toLowerCase(),r=new URL(n).origin;if(t&&t===r)return e;for(var i=0,o=f;i<o.length;i++){if(n===o[i])return e}throw new Error("Untrusted script URL")}})}catch(e){}}return r}t.getTrustedTypesPolicy=p}(e.LoadScriptHelper||(e.LoadScriptHelper={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){t.getAuthContextAsync=function(t){function n(e){var t=e.userObjectId||"",n=e.tenantId||"",r=e.userPrincipalName||"";return{userObjectId:t,tenantId:n,userPrincipalName:r,authorityType:e.authorityType||"",authorityBaseUrl:e.authorityBaseUrl||"",puid:e.puid||"",loginHint:e.loginHint||r}}var r={toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){try{return n(JSON.parse(e))}catch(e){return null}},toWebHost:function(){return{}},fromWebHost:function(e){return n(e)}};e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(205,r,t)}}(t.Auth||(t.Auth={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t;!function(e){e[e.MaxLiveShareStateDataSizeInBytes=1024]="MaxLiveShareStateDataSizeInBytes"}(t=e.LiveShareStateParams||(e.LiveShareStateParams={}));var n=function(){function e(e){var t=this;e=e||null,this._liveShareState=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidLiveShareStateChangedEvent,type:OSF.EventType.LiveShareStateChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}},fromWebHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}}}])}return e.prototype.get=function(){return this._liveShareState},e.prototype.set=function(e){if((new TextEncoder).encode(e).length>t.MaxLiveShareStateDataSizeInBytes)throw new Error("State data size is limited to "+t.MaxLiveShareStateDataSizeInBytes+" bytes.");this._liveShareState=e},e.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},e.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},e}();e.LiveShareState=n}(Office||(Office={})),function(e){var t={"ar-sa":!0,"bg-bg":!0,"bn-in":!0,"ca-es":!0,"cs-cz":!0,"da-dk":!0,"de-de":!0,"el-gr":!0,"en-us":!0,"es-es":!0,"et-ee":!0,"eu-es":!0,"fa-ir":!0,"fi-fi":!0,"fr-fr":!0,"gl-es":!0,"he-il":!0,"hi-in":!0,"hr-hr":!0,"hu-hu":!0,"id-id":!0,"it-it":!0,"ja-jp":!0,"kk-kz":!0,"ko-kr":!0,"lo-la":!0,"lt-lt":!0,"lv-lv":!0,"ms-my":!0,"nb-no":!0,"nl-nl":!0,"nn-no":!0,"pl-pl":!0,"pt-br":!0,"pt-pt":!0,"ro-ro":!0,"ru-ru":!0,"sk-sk":!0,"sl-si":!0,"sr-cyrl-cs":!0,"sr-cyrl-rs":!0,"sr-latn-cs":!0,"sr-latn-rs":!0,"sv-se":!0,"th-th":!0,"tr-tr":!0,"uk-ua":!0,"ur-pk":!0,"vi-vn":!0,"zh-cn":!0,"zh-tw":!0},n={ar:"ar-sa",bg:"bg-bg",bn:"bn-in",ca:"ca-es",cs:"cs-cz",da:"da-dk",de:"de-de",el:"el-gr",en:"en-us",es:"es-es",et:"et-ee",eu:"eu-es",fa:"fa-ir",fi:"fi-fi",fr:"fr-fr",gl:"gl-es",he:"he-il",hi:"hi-in",hr:"hr-hr",hu:"hu-hu",id:"id-id",it:"it-it",ja:"ja-jp",kk:"kk-kz",ko:"ko-kr",lo:"lo-la",lt:"lt-lt",lv:"lv-lv",ms:"ms-my",nb:"nb-no",nl:"nl-nl",nn:"nn-no",pl:"pl-pl",pt:"pt-br",ro:"ro-ro",ru:"ru-ru",sk:"sk-sk",sl:"sl-si",sr:"sr-cyrl-cs",sv:"sv-se",th:"th-th",tr:"tr-tr",uk:"uk-ua",ur:"ur-pk",vi:"vi-vn",zh:"zh-cn"};e.getSupportedLocale=function(e,r){if(void 0===r&&(r="en-us"),!e)return r;var i;if((e=e.toLowerCase())in t)i=e;else{var o=e.split("-",1);o&&o.length>0&&(i=n[o[0]])}return i||(i=r),i}}(OSF||(OSF={})),function(e){e.OfficeOM||(e.OfficeOM={})}(Strings||(Strings={})),function(e){!function(t){var n;t.ensureOfficeStringsJs=function(){return n||(n=1==e.OUtil.getLibraryReleaseVehicle()?new Office.Promise((function(e,t){e()})):new Office.Promise((function(n,r){if(e._OfficeAppFactory.getHostInfo().hostLocale){var i=e.LoadScriptHelper.getHostBundleJsBasePath()+e._OfficeAppFactory.getHostInfo().hostLocale+"/"+e.LoadScriptHelper.getOfficeStringJsName();e.OUtil.loadScript(i,(function(i){if(i)n();else{var o=e.LoadScriptHelper.getHostBundleJsBasePath()+e.ConstantNames.DefaultLocale+"/"+e.LoadScriptHelper.getOfficeStringJsName();t.loadScript(o,(function(t){t?n():r(new Error("Cannot load "+e.ConstantNames.OfficeStringJS))}),e.LoadScriptHelper.getTrustedTypesPolicy())}}),e.LoadScriptHelper.getTrustedTypesPolicy())}else r(new Error("No host locale"))}))),n}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n;OSF.definePropertyOnNamespace(t,"url",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_docUrl()})),OSF.definePropertyOnNamespace(t,"mode",(function(){return 0==OSF._OfficeAppFactory.getOfficeAppContext().get_clientMode()?e.DocumentMode.ReadOnly:e.DocumentMode.ReadWrite})),OSF.definePropertyOnNamespace(t,"settings",(function(){if(!n){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_settingsFunc()();n=OSF._OfficeAppFactory.getInitializationHelper().createSettings(e)}return n})),t.goToByIdAsync=function(t,n,r,i){var o={};o[e.GoToType.Binding]=0,o[e.GoToType.NamedItem]=1,o[e.GoToType.Slide]=2,o[e.GoToType.Index]=3;var a={};a[e.SelectionMode.Default]=0,a[e.SelectionMode.Selected]=1,a[e.SelectionMode.None]=2;var s=o[n],c=0,u=i;"function"==typeof r?u=r:void 0!==r&&(c=a[r]);var l={toSafeArrayHost:function(){return[t,s,c]},fromSafeArrayHost:function(e){return e},toWebHost:function(){return{DdaGoToByIdMethod:{Id:t,GoToType:s,SelectionMode:c}}},fromWebHost:function(e){return e}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(82,l,u)}}(t.document||(t.document={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.sendMessage=function(e){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web){var t=OSF._OfficeAppFactory.getWebAppState();t.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t.id,OSF.AgaveHostAction.SendMessage,e])}else{var n=JSON.stringify(e);OSF._OfficeAppFactory.getClientHostController().execute(208,[n],null)}},e.registerOnMessageEventHandler=function(t){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web)e.onMessage=t;else{OSF._OfficeAppFactory.getClientHostController().registerEvent(OSF.EventDispId.dispidOnSdxSendMessageEvent,"","",(function(e,n){var r=n.toArray();t(JSON.parse(r[0]))}),null)}}}(e.messaging||(e.messaging={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(t){var n,r;OSF.definePropertyOnNamespace(t,"contentLanguage",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_dataLocale()})),OSF.definePropertyOnNamespace(t,"displayLanguage",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_appUILocale()})),OSF.definePropertyOnNamespace(t,"partitionKey",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_partitionKey()})),OSF.definePropertyOnNamespace(t,"isDialog",(function(){return OSF._OfficeAppFactory.getHostInfo().isDialog})),OSF.definePropertyOnNamespace(t,"touchEnabled",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_touchEnabled()})),OSF.definePropertyOnNamespace(t,"commerceAllowed",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_commerceAllowed()})),OSF.definePropertyOnNamespace(t,"host",(function(){return OSF.HostName.Host.getInstance().getHost()})),OSF.definePropertyOnNamespace(t,"platform",(function(){return OSF.HostName.Host.getInstance().getPlatform()})),OSF.definePropertyOnNamespace(t,"diagnostics",(function(){return OSF.HostName.Host.getInstance().getDiagnostics(OSF._OfficeAppFactory.getOfficeAppContext().get_hostFullVersion())})),OSF.definePropertyOnNamespace(t,"requirements",(function(){if(!n){var e=OSF._OfficeAppFactory.getOfficeAppContext();e&&(n=e.get_isDialog()?OSF.Requirement.RequirementsMatrixFactory.getDefaultDialogRequirementMatrix(e):OSF.Requirement.RequirementsMatrixFactory.getDefaultRequirementMatrix(e))}return n})),OSF.definePropertyOnNamespace(t,"officeTheme",(function(){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_officeThemeFunc();return e?"function"==typeof e?e():e:void 0})),OSF.definePropertyOnNamespace(t,"webAuth",(function(){if(OSF.DDA.WebAuth)return OSF.DDA.WebAuth})),OSF.definePropertyOnNamespace(t,"auth",(function(){if(OSF.DDA.Auth)return OSF.DDA.Auth})),OSF.definePropertyOnNamespace(t,"license",(function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_eToken()})),OSF.definePropertyOnNamespace(t,"hostSettings",(function(){if(!r){var t=OSF._OfficeAppFactory.getOfficeAppContext().get_hostSettingsFunc();if(void 0!==t){var n=t(),i=OSF.OUtil.deserializeSettings(n);r=new e.Settings(i,void 0)}}return r}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.refreshRibbon=function(e){OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[OSF._OfficeAppFactory.getWebAppState().id,OSF.AgaveHostAction.RefreshRibbonGallery,e])}}(e.ribbonGallery||(e.ribbonGallery={}))}(e.context||(e.context={}))}(Office||(Office={})),function(e){!function(e){!function(e){e.taskPaneAction||(e.taskPaneAction={})}(e.ui||(e.ui={}))}(e.context||(e.context={}))}(Office||(Office={}));var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)};!function(e){function t(){e._officeOnReadyState.officeOnReadyPromise||(e._officeOnReadyState.officeOnReadyPromise=new e.Promise((function(t,n){e._officeOnReadyState.officeOnReadyPromiseResolve=t})))}function n(n){return t(),n&&(e._officeOnReadyState.officeOnReadyFired?n(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo):e._officeOnReadyState.officeOnReadyCallbacks.push(n)),e._officeOnReadyState.officeOnReadyPromise}e._officeOnReadyState=e._officeOnReadyState||{isOfficeOnReadyCalled:!1,officeOnReadyPromise:null,officeOnReadyPromiseResolve:null,officeOnReadyCallbacks:[],officeOnReadyHostAndPlatformInfo:null,officeOnReadyFired:!1},e.initialize=e.initialize,e.onReadyInternal=n,e.onReady=function(t){return e._officeOnReadyState.isOfficeOnReadyCalled=!0,n(t)},e.fireOnReady=function(n){for(t(),e._officeOnReadyState.officeOnReadyHostAndPlatformInfo=__assign({},n),e._officeOnReadyState.officeOnReadyFired=!0,OSFPerformance.officeOnReady=OSFPerformance.now();e._officeOnReadyState.officeOnReadyCallbacks.length>0;)e._officeOnReadyState.officeOnReadyCallbacks.shift()(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo);e._officeOnReadyState.officeOnReadyPromiseResolve(e._officeOnReadyState.officeOnReadyHostAndPlatformInfo),e._officeOnReadyState.isOfficeOnReadyCalled||OSF.OUtil.waitForFunction((function(){return"function"==typeof e.initialize}),(function(t){t&&e.initialize(OSF._OfficeAppFactory.getOfficeAppContext().get_reason())}),400,50)}}(Office||(Office={})),function(e){var t=function(){function t(t,n,r,i,o,a,s,c,u,l,f,p,d,h,g,y,m,_,v,b,O,I,S,P,C,R,A,E,w,x,N,T,j){this._id=t,this._appName=n,this._appVersion=r,this._appUILocale=i,this._dataLocale=o,this._docUrl=a,this._clientMode=s,this._settingsFunc=c,this._reason=u,this._osfControlType=l,this._eToken=f,this._correlationId=p,this._appInstanceId=d,this._touchEnabled=h,this._commerceAllowed=g,this._appMinorVersion=y,this._requirementMatrix=m,this._hostCustomMessage=_,this._hostFullVersion=v,this._isDialog=e.OUtil.isDialog(),this._clientWindowHeight=b,this._clientWindowWidth=O,this._addinName=I,this._appDomains=S,this._dialogRequirementMatrix=P,this._featureGates=C,this._officeThemeFunc=R,this._initialDisplayMode=A,this._isFromWacAutomation=E,this._wopiHostOriginForSingleSignOn=w,this._hostSettingsFunc=x,this._isWeb=N,this._nestedAppAuthBridgeType=T,this._partitionKey=j}return t.prototype.get_id=function(){return this._id},t.prototype.get_appName=function(){return this._appName},t.prototype.get_appVersion=function(){return this._appVersion},t.prototype.get_appUILocale=function(){return this._appUILocale},t.prototype.get_dataLocale=function(){return this._dataLocale},t.prototype.get_docUrl=function(){return this._docUrl},t.prototype.get_clientMode=function(){return this._isWeb?this._clientMode:0==this._clientMode?Office.DocumentMode.ReadWrite:Office.DocumentMode.ReadOnly},t.prototype.get_settingsFunc=function(){return this._settingsFunc},t.prototype.get_reason=function(){return this._reason},t.prototype.get_osfControlType=function(){return this._osfControlType},t.prototype.get_eToken=function(){return this._eToken},t.prototype.get_correlationId=function(){return this._correlationId},t.prototype.get_appInstanceId=function(){return this._appInstanceId},t.prototype.get_touchEnabled=function(){return this._touchEnabled},t.prototype.get_commerceAllowed=function(){return this._commerceAllowed},t.prototype.get_appMinorVersion=function(){return this._appMinorVersion},t.prototype.get_requirementMatrix=function(){return this._requirementMatrix},t.prototype.get_dialogRequirementMatrix=function(){return this._dialogRequirementMatrix},t.prototype.get_hostCustomMessage=function(){return this._hostCustomMessage},t.prototype.get_hostFullVersion=function(){return this._hostFullVersion},t.prototype.get_isDialog=function(){return this._isDialog},t.prototype.get_clientWindowHeight=function(){return this._clientWindowHeight},t.prototype.get_clientWindowWidth=function(){return this._clientWindowWidth},t.prototype.get_addinName=function(){return this._addinName},t.prototype.get_appDomains=function(){return this._appDomains},t.prototype.get_taskpaneUrl=function(){return this._taskpaneUrl},t.prototype.set_taskpaneUrl=function(e){this._taskpaneUrl=e},t.prototype.get_featureGates=function(){return this._featureGates},t.prototype.get_officeThemeFunc=function(){return this._officeThemeFunc},t.prototype.get_initialDisplayMode=function(){return this._initialDisplayMode?this._initialDisplayMode:0},t.prototype.get_isFromWacAutomation=function(){return this._isFromWacAutomation},t.prototype.get_wopiHostOriginForSingleSignOn=function(){return this._wopiHostOriginForSingleSignOn},t.prototype.get_hostSettingsFunc=function(){return this._hostSettingsFunc},t.prototype.get_isWeb=function(){return this._isWeb},t.prototype.get_nestedAppAuthBridgeType=function(){return this._nestedAppAuthBridgeType},t.prototype.get_partitionKey=function(){return this._partitionKey},t}();e.OfficeAppContext=t}(OSF||(OSF={})),function(e){!function(t){t.retrieveHostInfo=function(){var t={isO15:!0,isRichClient:!0,hostType:"",hostPlatform:"",hostSpecificFileVersion:"",hostLocale:"",osfControlAppCorrelationId:"",isDialog:!1,disableLogging:!1,flags:0},n="_host_Info",r=null;try{if(window.external=window.external||{},"undefined"!=typeof agaveHost&&agaveHost.GetHostInfo&&(window.external.GetHostInfo=function(){return agaveHost.GetHostInfo()}),window.external.GetHostInfo){var i=window.external.GetHostInfo();if("isDialog"==i)t.isO15=!0,t.isDialog=!0;else{var o=i.split("_host_Info=");r=o.length>1?o[1]:i}}}catch(t){e.Utility.log(JSON.stringify(t))}if(!r)try{var a=window.name;if(a){var s=JSON.parse(a);r=s?s.hostInfo:null}}catch(t){e.Utility.log(JSON.stringify(t))}r||(r=e.Utility.getQueryStringValue(n));var c=e.OUtil.getSessionStorage();if(!r&&c.getItem("hostInfoValue")&&(r=c.getItem("hostInfoValue")),r){r=decodeURIComponent(r),t.isO15=!1;var u=r.split("$");void 0===u[2]&&(u=r.split("|")),t.hostType=void 0===u[0]?"":u[0].toLowerCase(),t.hostPlatform=void 0===u[1]?"":u[1].toLowerCase(),t.hostSpecificFileVersion=void 0===u[2]?"":u[2].toLowerCase(),t.hostLocale=void 0===u[3]?"":u[3].toLowerCase(),t.osfControlAppCorrelationId=void 0===u[4]?"":u[4],"telemetry"==t.osfControlAppCorrelationId&&(t.osfControlAppCorrelationId=""),t.isDialog=void 0!==u[5]&&"isDialog"==u[5],t.disableLogging=void 0!==u[6]&&"disableLogging"==u[6],t.flags="string"==typeof u[7]&&u[7].length>0?parseInt(u[7]):0,c.setItem("hostInfoValue",r)}else t.isO15=!0,t.hostLocale=e.Utility.getQueryStringValue("locale");return t}}(e._OfficeAppFactory||(e._OfficeAppFactory={}))}(OSF||(OSF={})),function(e){var t;!function(t){var n,r,i,o,a,s,c,u,l;"undefined"!=typeof window&&(window.location&&(n=window.location.hash,r=window.location.search),i=window.name);var f={0:"Unknown",1:"Hidden",2:"Taskpane",3:"Dialog"};function p(t,n){e.AppCommandManager.initialize();var r=t.get_appName(),i=null;0!=(o.flags&e.HostInfoFlags.SharedApp)&&(i={visibilityMode:f[t.get_initialDisplayMode()]}),Office.fireOnReady({host:e.HostName.Host.getInstance().getHost(r),platform:e.HostName.Host.getInstance().getPlatform(r),addin:i}),o.hostPlatform==e.HostInfoPlatform.web&&null!=a.clientEndPoint&&a.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[a.id,e.AgaveHostAction.OfficeJsReady,Date.now()]),n(t)}t.bootstrap=function(n,r){if(a={id:null,webAppUrl:null,conversationID:null,clientEndPoint:null,wnd:window.parent,focused:!1,serviceEndPoint:null},o=t.retrieveHostInfo(),function(){!0;try{if(o.disableLogging)return void!1;window.external=window.external||{},void 0===window.external.GetLoggingAllowed||window.external.GetLoggingAllowed()}catch(e){}}(),function(){if(o.hostPlatform===e.HostInfoPlatform.web)s=new e.WebInitializationHelper(o,a,null,null);else if(o.hostPlatform===e.HostInfoPlatform.win32)s=new e.RichClientInitializationHelper(o,a,null,null);else if(o.hostPlatform===e.HostInfoPlatform.ios||o.hostPlatform===e.HostInfoPlatform.mac){if(!(window.webkit&&window.webkit.messageHandlers&&window.webkit.messageHandlers.Agave))throw e.Utility.createNotImplementedException();s=new e.WebkitInitializationHelper(o,a,null,null)}else o.hostPlatform===e.HostInfoPlatform.android||o.hostPlatform===e.HostInfoPlatform.winrt?s=new e.WebViewInitializationHelper(o,a,null,null):console.warn("Office.js is loaded inside in unknown host or platform "+o.hostPlatform)}(),s){o.hostPlatform===e.HostInfoPlatform.web&&s.saveAndSetDialogInfo(e.Utility.getQueryStringValue("_host_Info")),s.setAgaveHostCommunication(),OSFPerformance.getAppContextStart=OSFPerformance.now();s.getAppContext(window,(function(t){OSFPerformance.getAppContextEnd=OSFPerformance.now(),e.AppTelemetry.initialize(t),u=t,l=s.createClientHostController(),c=s.createAsyncMethodExecutor(),s.prepareApiSurface(t),e.BootStrapExtension.onGetAppContext?e.BootStrapExtension.onGetAppContext(t,a.wnd).then((function(){p(t,n)})):p(t,n)}),(function(e){r(e)}))}else r(new Error("Office.js cannot be initialized."))},t.getWindowName=function(){return i},t.getWindowLocationHash=function(){return n},t.getWindowLocationSearch=function(){return r},t.getAsyncMethodExecutor=function(){return c},t.getOfficeAppContext=function(){return u},t.getHostInfo=function(){return o},t.getCachedSessionSettingsKey=function(){return(null!=a.conversationID?a.conversationID:u.get_appInstanceId())+"CachedSessionSettings"},t.getWebAppState=function(){return a},t.getId=function(){return a.id},t.getInitializationHelper=function(){return s},t.getClientHostController=function(){return l}}(t=e._OfficeAppFactory||(e._OfficeAppFactory={})),e.getClientEndPoint=function(){return t.getWebAppState().clientEndPoint}}(OSF||(OSF={})),function(e){!function(e){e.Succeeded="succeeded",e.Failed="failed"}(e.AsyncResultStatus||(e.AsyncResultStatus={})),function(e){e.ReadOnly="readOnly",e.ReadWrite="readWrite"}(e.DocumentMode||(e.DocumentMode={})),function(e){e.Word="Word",e.Excel="Excel",e.PowerPoint="PowerPoint",e.Outlook="Outlook",e.OneNote="OneNote",e.Project="Project",e.Access="Access",e.Visio="Visio"}(e.HostType||(e.HostType={})),function(e){e.Inserted="inserted",e.DocumentOpened="documentOpened"}(e.InitializationReason||(e.InitializationReason={})),function(e){e.PC="PC",e.OfficeOnline="OfficeOnline",e.Mac="Mac",e.iOS="iOS",e.Android="Android",e.Universal="Universal"}(e.PlatformType||(e.PlatformType={})),function(e){e.Binding="binding",e.NamedItem="namedItem",e.Slide="slide",e.Index="index"}(e.GoToType||(e.GoToType={})),function(e){e.Default="default",e.Selected="selected",e.None="none"}(e.SelectionMode||(e.SelectionMode={})),function(e){e.Unformatted="unformatted",e.Formatted="formatted"}(e.ValueFormat||(e.ValueFormat={})),function(e){e.Text="text",e.Compressed="compressed",e.Pdf="pdf"}(e.FileType||(e.FileType={})),e.CoercionType={Html:"html",Matrix:"matrix",Ooxml:"ooxml",OoxmlPackage:"ooxmlPackage",PdfFile:"pdfFile",SlideRange:"slideRange",Table:"table",Text:"text"},function(e){e.Table="table",e.Text="text",e.Matrix="matrix"}(e.BindingType||(e.BindingType={})),function(e){e.OnlyVisible="onlyVisible",e.All="all"}(e.FilterType||(e.FilterType={})),function(e){e[e.All=0]="All",e[e.Data=1]="Data",e[e.Headers=2]="Headers"}(e.Table||(e.Table={})),function(e){e.Read="read",e.Edit="edit"}(e.ActiveView||(e.ActiveView={}))}(Office||(Office={}));var OfficeExt,OSFPerfUtil,__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){e.appSpecificCheckOrigin=function(e,t,n,r){return!1}}(OfficeExt||(OfficeExt={})),function(e){var t=function(){function e(e,t,n){this._method=e,this._invokeType=t,this._blockingOthers=n}return e.prototype.getMethod=function(){return this._method},e.prototype.getInvokeType=function(){return this._invokeType},e.prototype.getBlockingFlag=function(){return this._blockingOthers},e}();e.XdmMethodObject=t;var n=function(){function e(e,t){this._registerMethodObject=e,this._unregisterMethodObject=t}return e.prototype.getRegisterMethodObject=function(){return this._registerMethodObject},e.prototype.getUnregisterMethodObject=function(){return this._unregisterMethodObject},e}();e.XdmEventMethodObject=n;var r=function(){function r(e){this._methodObjectList={},this._eventHandlerProxyList={},this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null,this._methodObjectList={},this._eventHandlerProxyList={},this._Id=e,this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null}return r.prototype.registerMethod=function(n,r,i,o){if(0!==i&&1!==i)throw e.Utility.createArgumentException("invokeType");var a=new t(r,i,o);this._methodObjectList[n]=a},r.prototype.unregisterMethod=function(e){delete this._methodObjectList[e]},r.prototype.registerEvent=function(e,r,i){var o=new n(new t(r,4,!1),new t(i,5,!1));this._methodObjectList[e]=o},r.prototype.registerEventEx=function(e,r,i,o,a){var s=new n(new t(r,i,!1),new t(o,a,!1));this._methodObjectList[e]=s},r.prototype.unregisterEvent=function(e){this.unregisterMethod(e)},r.prototype.registerConversation=function(t,n,r){if(e.Utility.xdmDebugLog("registerConversation: cId="+t+" Url="+n),r){if(!Array.isArray(r))throw e.Utility.createArgumentException("appDomains");this._appDomains[t]=r}this._conversations[t]={url:n}},r.prototype.unregisterConversation=function(e){delete this._conversations[e]},r.prototype.setPolicyManager=function(t){if(!t.checkPermission)throw e.Utility.createArgumentException("policyManager");this._policyManager=t},r.prototype.getPolicyManager=function(){return this._policyManager},r.prototype.dispose=function(){this._methodObjectList=null,this._eventHandlerProxyList=null,this._Id=null,this._conversations=null,this._policyManager=null,this._appDomains=null,this._onHandleRequestError=null},r}();e.XdmServiceEndPoint=r;var i,o=function(){function e(e,t,n){this._callbackList={},this._eventHandlerList={},this._hostTrustCheckStatus=0,this._checkStatusLogged=!1,this._fHostTrusted=!1,this._conversationId=e,this._targetWindow=t,this._targetUrl=n,this._callingIndex=0,this._callbackList={},this._eventHandlerList={},this._checkReceiverOriginAndRun=null}return Object.defineProperty(e.prototype,"targetUrl",{get:function(){return this._targetUrl},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hostTrustCheckStatus",{get:function(){return this._hostTrustCheckStatus},set:function(e){this._hostTrustCheckStatus=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fHostTrusted",{get:function(){return this._fHostTrusted},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"checkStatusLogged",{get:function(){return this._checkStatusLogged},set:function(e){this._checkStatusLogged=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"checkReceiverOriginAndRun",{get:function(){return this._checkReceiverOriginAndRun},set:function(e){this._checkReceiverOriginAndRun=e},enumerable:!0,configurable:!0}),e.prototype.invoke=function(e,t,n){var r=this,o=function(){var o=r._callingIndex++,a=new Date,c={callback:t,createdOn:a.getTime()};n&&"object"==typeof n&&"number"==typeof n.__timeout__&&(c.timeout=n.__timeout__,delete n.__timeout__),r._callbackList[o]=c;try{if(3!==r._hostTrustCheckStatus&&"ContextActivationManager_getAppContextAsync"!==e)throw"Access Denied";var l=new s(e,0,r._conversationId,o,n),f=u.envelope(l);r._targetWindow.postMessage(f,r._targetUrl),i._startMethodTimeoutTimer()}catch(e){try{null!==t&&t(-1,e)}finally{delete r._callbackList[o]}}};this._checkReceiverOriginAndRun?this._checkReceiverOriginAndRun(o):(this._hostTrustCheckStatus=3,o())},e.prototype.registerForEvent=function(e,t,n,r){var o=this._callingIndex++,a=new Date;this._callbackList[o]={callback:n,createdOn:a.getTime()};try{var c=new s(e,1,this._conversationId,o,r),l=u.envelope(c);this._targetWindow.postMessage(l,this._targetUrl),i._startMethodTimeoutTimer(),this._eventHandlerList[e]=t}catch(e){try{null!==n&&n(-1,e)}finally{delete this._callbackList[o]}}},e.prototype.unregisterForEvent=function(e,t,n){var r=this._callingIndex++,o=new Date;this._callbackList[r]={callback:t,createdOn:o.getTime()};try{var a=new s(e,2,this._conversationId,r,n),c=u.envelope(a);this._targetWindow.postMessage(c,this._targetUrl),i._startMethodTimeoutTimer()}catch(e){try{null!==t&&t(-1,e)}finally{delete this._callbackList[r]}}finally{delete this._eventHandlerList[e]}},e}();e.XdmClientEndPoint=o,function(t){var n=[],i=null,a=null,s=!1,l={},d={},h=!1;function g(){null!==a?s||(n.length>0?y(n.shift()):(clearInterval(a),a=null)):e.Utility.xdmDebugLog("channel is not ready.")}function y(e){s=e.getInvokeBlockingFlag(),e.invoke(),i=(new Date).getTime()}function m(){s=!1}function _(t,n){var r=!1;if(!(n&&"null"!==n&&n.length&&t&&t instanceof Array&&t.length))return r;for(var i=0;i<t.length&&!r;i++)if(-1!==t[i].indexOf("://")){var o=e.OUtil.parseUrl(n,!0);r=O(e.OUtil.parseUrl(t[i],!0),o)}return r}function v(t){if(!t||"null"===t)return!1;var n=new Array("^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.live\\.com$","^outlook-sdf\\.live\\.com$","^consumer\\.live-int\\.com$","^outlook-tdf\\.live\\.com$","^sdfpilot\\.live\\.com$","^outlook\\.office365\\.us$","^outlook\\.office365\\.com$","^exchangelabs\\.live-int\\.com$","^.*\\.dod\\.online\\.office365\\.us$","^.*\\.gov\\.online\\.office365\\.us$","^.*\\.officeapps\\.live\\.com$","^.*\\.officeapps-df\\.live\\.com$","^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$");return!0===e.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments&&n.push("^partner\\.outlook\\.cn$","^.*\\.partner\\.officewebapps\\.cn$"),new RegExp(n.join("|")).test(t)}function b(t,n){if(!t||!n||"null"===t||"null"===n)return!1;var r=e.OUtil.parseUrl(t,!0),i=e.OUtil.parseUrl(n,!0);if(null==r||null==i)return!1;var o=r.protocol===i.protocol,a=r.port===i.port,s=i.hostname,c=r.hostname,u=s===c,l=!1;return!u&&s.length>c.length+1&&(l=s.slice(-(c.length+1))==="."+c),a&&o&&(u||l)}function O(e,t){return e.hostname==t.hostname&&e.protocol==t.protocol&&e.port==t.port}function I(t){if(""!=t.data){var r,o=t.data;try{r=u.unenvelope(o)}catch(e){return}if(e.Utility.xdmDebugLog(o),0===r._messageType){var h=null==t.origin||"null"===t.origin?r._origin:t.origin;try{var I=function(t){for(var n in l)if(l[n]._conversations[t])return l[n];throw e.Utility.createArgumentException("conversationId")}(r._conversationId);e.Utility.xdmDebugLog("_receive: request, origin="+h+" sourceURL:"+I._conversations[r._conversationId]);var S=I._conversations[r._conversationId];e.Utility.xdmDebugLog("_receive: request, origin="+h+" sourceURL:"+S.url);var P=[S.url].concat(I._appDomains[r._conversationId]);if(!_(P,t.origin))if(!OfficeExt.appSpecificCheckOrigin(P,t,r._origin,_))if(!b(S.url,t.origin))throw"Failed origin check";var C=I.getPolicyManager();if(C&&!C.checkPermission(r._conversationId,r._actionName,r._data))throw"Access Denied";var R=function(t,n){var r=t._methodObjectList[n._actionName];if(!r)throw e.Utility.xdmDebugLog("The specified method is not registered on service endpoint:"+n._actionName),e.Utility.createArgumentException("messageObject");return 0===n._actionType?r:1===n._actionType?r.getRegisterMethodObject():r.getUnregisterMethodObject()}(I,r),A=new f(t.source,h,r._actionName,r._conversationId,r._correlationId,m),E=new p(R,r._data,A,I._eventHandlerProxyList,r._conversationId,r._actionName),w=!0;null==a&&((null==i||(new Date).getTime()-i>10)&&!s?(y(E),w=!1):a=setInterval(g,10)),w&&function(e){n.push(e)}(E)}catch(n){I&&I._onHandleRequestError&&I._onHandleRequestError(r,n);var x=-2;"Access Denied"==n&&(x=-5);var N=new c(r._actionName,r._conversationId,r._correlationId,x,0,n),T=u.envelope(N),j=!1;try{j=!(!t.source||!t.source.postMessage)}catch(e){}var k=!1;if(window.location.href&&t.origin&&"null"!==t.origin&&b(window.location.href,t.origin))k=!0;else if(t.origin&&"null"!==t.origin)k=v(e.OUtil.parseUrl(t.origin,!0).hostname);j&&k&&t.source.postMessage(T,h)}}else{if(1!==r._messageType)return;var F=function(t){var n=d[t];return n||e.Utility.xdmDebugLog("Unknown conversation Id."),n}(r._conversationId);if(!F)return;if(e.Utility.xdmDebugLog("_receive: response, origin="+t.origin+" targetURL:"+F._targetUrl),U=F._targetUrl,H=t.origin,!(U&&H&&"null"!==U&&"null"!==H&&U.length&&H.length&&O(e.OUtil.parseUrl(U,!0),e.OUtil.parseUrl(H,!0))))throw"Failed orgin check";if(3==F._hostTrustCheckStatus&&(F._fHostTrusted=!0),0===r._responseType){var M=F._callbackList[r._correlationId];if(M)try{M.callback&&M.callback(r._errorCode,r._data)}finally{delete F._callbackList[r._correlationId]}}else{var D=F._eventHandlerList[r._actionName];null!=D&&D(r._data)}}}var U,H}function S(){h||(!function(t){if(window.addEventListener)window.addEventListener("message",t,!1);else{if(!(navigator.userAgent.indexOf("MSIE")>-1&&window.attachEvent))throw e.Utility.xdmDebugLog("Browser doesn't support the required API."),e.Utility.createArgumentException("Browser");window.attachEvent("onmessage",t)}}(I),h=!0)}t.connect=function(e,t,n){var r=d[e];return r||(S(),r=new o(e,t,n),d[e]=r),r},t.getClientEndPoint=function(e){return d[e]},t.createServiceEndPoint=function(e){S();var t=new r(e);return l[e]=t,t},t.getServiceEndPoint=function(e){return l[e]},t.deleteClientEndPoint=function(e){delete d[e]},t.deleteServiceEndPoint=function(e){delete l[e]},t.checkUrlWithAppDomains=function(e,t){return _(e,t)},t.isTargetSubdomainOfSourceLocation=function(e,t){return b(e,t)},t._setMethodTimeout=function(e){e<=0?65e3:e},t._startMethodTimeoutTimer=function(){},t.isHostNameValidWacDomain=function(e){return v(e)}}(i=e.XdmCommunicationManager||(e.XdmCommunicationManager={}));var a=function(){function e(e,t,n,r,i){this._messageType=e,this._actionName=t,this._conversationId=n,this._correlationId=r,this._origin=window.location.origin,this._data=void 0===i?null:i}return e.prototype.getActionName=function(){return this._actionName},e.prototype.getConversationId=function(){return this._conversationId},e.prototype.getCorrelationId=function(){return this._correlationId},e.prototype.getOrigin=function(){return this._origin},e.prototype.getData=function(){return this._data},e.prototype.getMessageType=function(){return this._messageType},e}(),s=function(e){function t(t,n,r,i,o){var a=e.call(this,0,t,r,i,o)||this;return a._actionType=n,a}return __extends(t,e),t.prototype.getActionType=function(){return this._actionType},t}(a),c=function(e){function t(t,n,r,i,o,a){var s=e.call(this,1,t,n,r,a)||this;return s._errorCode=i,s._responseType=o,s}return __extends(t,e),t.prototype.getErrorCode=function(){return this._errorCode},t.prototype.getResponseType=function(){return this._responseType},t}(a),u=function(){function e(){}return e.envelope=function(e){return JSON.stringify(e)},e.unenvelope=function(e){return JSON.parse(e)},e}(),l=function(){function t(t,n,r,i,o,a){var s=this;this._invokeResultCode=0,this._requesterWindow=t,this._requesterUrl=n,this._actionName=r,this._conversationId=i,this._correlationId=o,this._invokeResultCode=0,this._responseType=a,this._send=function(t){try{var n=new c(s._actionName,s._conversationId,s._correlationId,s._invokeResultCode,s._responseType,t),r=u.envelope(n);s._requesterWindow.postMessage(r,s._requesterUrl),e.Utility.xdmDebugLog("_send: requestUrl="+s._requesterUrl+" _actionName:"+s._actionName)}catch(t){e.Utility.xdmDebugLog("ResponseSender._send error:"+t.message)}}}return t.prototype.getRequesterWindow=function(){return this._requesterWindow},t.prototype.getRequesterUrl=function(){return this._requesterUrl},t.prototype.getActionName=function(){return this._actionName},t.prototype.getConversationId=function(){return this._conversationId},t.prototype.getCorrelationId=function(){return this._correlationId},t.prototype.getSend=function(){return this._send},t.prototype.setResultCode=function(e){this._invokeResultCode=e},t}(),f=function(t){function n(n,r,i,o,a,s){var l=t.call(this,n,r,i,o,a,0)||this;return l._postCallbackHandler=s,l._send=function(t,n){null!=n&&(l._invokeResultCode=n);try{var r=new c(l._actionName,l._conversationId,l._correlationId,l._invokeResultCode,l._responseType,t),i=u.envelope(r);l._requesterWindow.postMessage(i,l._requesterUrl),l._postCallbackHandler()}catch(t){e.Utility.xdmDebugLog("InvokeCompleteCallback._send error:"+t.message)}},l}return __extends(n,t),n}(l),p=function(){function e(e,t,n,r,i,o){this._callerId="",this._methodObject=e,this._param=t,this._invokeCompleteCallback=n,this._eventHandlerProxyList=r,this._conversationId=i,this._eventName=o}return e.prototype.invoke=function(){try{var e;switch(this._methodObject.getInvokeType()){case 0:this._methodObject.getMethod()(this._param,this._invokeCompleteCallback.getSend());break;case 1:e=this._methodObject.getMethod()(this._param),this._invokeCompleteCallback.getSend()(e);break;case 4:var t=this._createEventHandlerProxyObject(this._invokeCompleteCallback);e=this._methodObject.getMethod()(t.getSend(),this._param),this._eventHandlerProxyList[this._conversationId+this._eventName]=t.getSend(),this._invokeCompleteCallback.getSend()(e);break;case 5:var n=this._eventHandlerProxyList[this._conversationId+this._eventName];e=this._methodObject.getMethod()(n,this._param),delete this._eventHandlerProxyList[this._conversationId+this._eventName],this._invokeCompleteCallback.getSend()(e);break;case 2:var r=this._createEventHandlerProxyObject(this._invokeCompleteCallback);this._methodObject.getMethod()(r.getSend(),this._invokeCompleteCallback.getSend(),this._param),this._eventHandlerProxyList[this._callerId+this._eventName]=r.getSend();break;case 3:var i=this._eventHandlerProxyList[this._callerId+this._eventName];this._methodObject.getMethod()(i,this._invokeCompleteCallback.getSend(),this._param),delete this._eventHandlerProxyList[this._callerId+this._eventName]}}catch(e){this._invokeCompleteCallback.setResultCode(-3),this._invokeCompleteCallback.getSend()(e)}},e.prototype.getInvokeBlockingFlag=function(){return this._methodObject.getBlockingFlag()},e.prototype._createEventHandlerProxyObject=function(e){return new l(e.getRequesterWindow(),e.getRequesterUrl(),e.getActionName(),e.getConversationId(),e.getCorrelationId(),1)},e}()}(OSF||(OSF={})),function(e){function t(e,t){return t+="_Resource",void 0!==oteljs?[oteljs.makeDoubleDataField(t+"_responseEnd",e.responseEnd),oteljs.makeDoubleDataField(t+"_responseStart",e.responseStart),oteljs.makeDoubleDataField(t+"_startTime",e.startTime),oteljs.makeDoubleDataField(t+"_transferSize",e.transferSize)]:[]}e.sendPerformanceTelemetry=function(){if(OSF.AppTelemetry.enableTelemetry&&"undefined"!=typeof performance&&performance.getEntriesByType){var e,n,r=OSF.LoadScriptHelper.getHostBundleJsName().toLowerCase();performance.getEntriesByType("resource").forEach((function(t){var i=t.name.toLowerCase();OSF.Utility.stringEndsWith(i,r)?e=t:(OSF.Utility.stringEndsWith(i,OSF.ConstantNames.OfficeDebugJS)||OSF.Utility.stringEndsWith(i,OSF.ConstantNames.OfficeJS))&&(n=t)})),OTel.OTelLogger.onTelemetryLoaded((function(){var r=[];e&&(r=r.concat(t(e,"HostJs"))),n&&(r=r.concat(t(n,"OfficeJs"))),r=r.concat([oteljs.makeDoubleDataField("officeExecuteStartDate",OSFPerformance.officeExecuteStartDate),oteljs.makeDoubleDataField("officeExecuteStart",OSFPerformance.officeExecuteStart),oteljs.makeDoubleDataField("officeExecuteEnd",OSFPerformance.officeExecuteEnd),oteljs.makeDoubleDataField("hostInitializationStart",OSFPerformance.hostInitializationStart),oteljs.makeDoubleDataField("hostInitializationEnd",OSFPerformance.hostInitializationEnd),oteljs.makeDoubleDataField("totalJSHeapSize",OSFPerformance.totalJSHeapSize),oteljs.makeDoubleDataField("usedJSHeapSize",OSFPerformance.usedJSHeapSize),oteljs.makeDoubleDataField("jsHeapSizeLimit",OSFPerformance.jsHeapSizeLimit),oteljs.makeDoubleDataField("getAppContextStart",OSFPerformance.getAppContextStart),oteljs.makeDoubleDataField("getAppContextEnd",OSFPerformance.getAppContextEnd),oteljs.makeDoubleDataField("getAppContextXdmStart",OSFPerformance.getAppContextXdmStart),oteljs.makeDoubleDataField("getAppContextXdmEnd",OSFPerformance.getAppContextXdmEnd),oteljs.makeDoubleDataField("createOMEnd",OSFPerformance.createOMEnd),oteljs.makeDoubleDataField("officeOnReady",OSFPerformance.officeOnReady),oteljs.makeBooleanDataField("isSharedRuntime",0!=(OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp))]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.JSPerformanceTelemetryV06",dataFields:r,eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}}}(OSFPerfUtil||(OSFPerfUtil={})),function(e){!function(t){var n,r,i={};!function(e){var t=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"];e.generateNewGuid=function(){for(var e="",n=(new Date).getTime(),r=0;r<32&&n>0;r++)8!=r&&12!=r&&16!=r&&20!=r||(e+="-"),e+=t[n%16],n=Math.floor(n/16);for(;r<32;r++)8!=r&&12!=r&&16!=r&&20!=r||(e+="-"),e+=t[Math.floor(16*Math.random())];return e}}(t.Guid||(t.Guid={})),t.loadScript=function(e,t,n,r){if(e&&t){var o=window.document,a=i[e];if(a)a.loaded?t(!0):a.pendingCallbacks.push(t);else{var s=o.createElement("script");s.type="text/javascript",a={loaded:!1,pendingCallbacks:[t],timer:null},i[e]=a;var c=function(){null!=a.timer&&(clearTimeout(a.timer),delete a.timer),a.loaded=!0;for(var e=a.pendingCallbacks.length,t=0;t<e;t++){a.pendingCallbacks.shift()(!0)}},u=function(){delete i[e],null!=a.timer&&(clearTimeout(a.timer),delete a.timer);for(var t=a.pendingCallbacks.length,n=0;n<t;n++){a.pendingCallbacks.shift()(!1)}};s.readyState?s.onreadystatechange=function(){"loaded"!=s.readyState&&"complete"!=s.readyState||(s.onreadystatechange=null,c())}:s.onload=c,s.onerror=u,r=r||3e4,a.timer=setTimeout(u,r),s.setAttribute("crossOrigin","anonymous"),s.src=n?n.createScriptURL(e):e,o.getElementsByTagName("head")[0].appendChild(s)}}},t.getSessionStorage=function(){if(!n){try{var t=window.sessionStorage}catch(e){t=null}n=new e.SafeStorage(t)}return n},t.getLocalStorage=function(){if(!r){try{var t=window.localStorage}catch(e){t=null}r=new e.SafeStorage(t)}return r},t.waitForFunction=function(e,t,n,r){var i,o=n,a=function(){o--,e()?t(!0):o>0?(i=window.setTimeout(a,r),o--):(window.clearTimeout(i),t(!1))};a()}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){e.Flights=[],e.DisabledChangeGates=[];e.FlightTreatmentNames={EnableMsal3SsoApi:"Microsoft.Office.SharedOnline.EnableMsal3SsoApi"},function(t){var n="&_flights=",r="&_disabledChangeGates=",i="_flights=",o="_disabledChangeGates=";function a(e,t){return e.substr(0,t.length)===t}function s(e,t,n,r){return a(e,t+"//"+n+":"+r)||a(e,n+":"+r)}t.isArray=function(e){return"[object Array]"===Object.prototype.toString.apply(e)},t.isFunction=function(e){return"[object Function]"===Object.prototype.toString.apply(e)},t.isDate=function(e){return"[object Date]"===Object.prototype.toString.apply(e)},t.addEventListener=function(e,t,n){if(e.addEventListener)e.addEventListener(t,n,!1);else{if(!e.attachEvent)throw new Error("Cannot attach event");e.attachEvent("on"+t,n)}},t.removeEventListener=function(e,t,n){if(e.removeEventListener)e.removeEventListener(t,n,!1);else{if(!e.detachEvent)throw new Error("Cannot remove event");e.detachEvent("on"+t,n)}};var c="Date(";function u(e){var t=[];try{t=JSON.parse(e)}catch(e){}return Array.isArray(t)||(t=[]),t}function l(e,n,r){try{var i=JSON.parse(n),o=null!=i?i[r]:null,a=t.getSessionStorage();if(!e&&a&&null!=i){var s=i.baseFrameName+r;o?a.setItem(s,o):o=a.getItem(s)}return o}catch(e){return null}}function f(e,n,r,i,o){var a=o.split(e),s=a.length>1?a[a.length-1]:null;r&&null!=s&&(s.indexOf("&")>=0&&(s=s.split("&")[0]),s=decodeURIComponent(s));var c=t.getSessionStorage();if(!i&&c){var u=window.name.indexOf(n);if(u>-1){var l=window.name.indexOf(";",u);-1==l&&(l=window.name.length);var f=window.name.substring(u,l);s?c.setItem(f,s):s=c.getItem(f)}}return s}function p(e,t){for(var n=0;n<e.length;n++)if(e.charAt(n)===t){if(n+1>=e.length)return this.removeChar(e,n);if("/"===t){if("?"===e.charAt(n+1)||"#"===e.charAt(n+1))return this.removeChar(e,n)}else if("?"===t&&"#"===e.charAt(n+1))return this.removeChar(e,n)}return e}function d(e){if(e=p(e,"/"),e=p(e,"?"),"https://"==(e=p(e,"#")).substr(0,8))-1!=(t=e.indexOf(":443"))&&(t!=e.length-4&&"/"!=e.charAt(t+4)&&"?"!=e.charAt(t+4)&&"#"!=e.charAt(t+4)||(e=e.substring(0,t)+e.substring(t+4)));else if("http://"==e.substr(0,7)){var t;-1!=(t=e.indexOf(":80"))&&(t!=e.length-3&&"/"!=e.charAt(t+3)&&"?"!=e.charAt(t+3)&&"#"!=e.charAt(t+3)||(e=e.substring(0,t)+e.substring(t+3)))}return e}function h(e){var t,n,r=[],i=[],o=e.length;for(t=0;t<o;t++)(n=e[t]).tabIndex?n.tabIndex>0?i.push(n):0===n.tabIndex&&r.push(n):r.push(n);return i=i.sort((function(e,t){var n=e.tabIndex-t.tabIndex;return 0===n&&(n=i.indexOf(e)-i.indexOf(t)),n})),[].concat(i,r)}t.serializeSettings=function(t){var n={};for(var r in t){var i=t[r];try{i=JSON.stringify(i,(function(t,n){return e.OUtil.isDate(this[t])?c+this[t].getTime()+")":n})),n[r]=i}catch(e){}}return n},t.deserializeSettings=function(e){var t={};for(var n in e=e||{}){var r=e[n];try{r=JSON.parse(r,(function(e,t){var n;return"string"==typeof t&&t&&t.length>6&&t.slice(0,5)===c&&")"===t.slice(-1)&&(n=new Date(parseInt(t.slice(5,-1))))?n:t})),t[n]=r}catch(e){}}return t},t.convertIntToCssHexColor=function(e){return"#"+(Number(e)+16777216).toString(16).slice(-6)},t.parseAppContextFromWindowName=function(e,n){return t.parseInfoFromWindowName(e,n,"appContext")},t.parseHostInfoFromWindowName=function(t,n){return e.OUtil.parseInfoFromWindowName(t,n,"hostInfo")},t.parseXdmInfo=function(e){var n=t.parseXdmInfoWithGivenFragment(e,window.location.hash);return n||(n=t.parseXdmInfoFromWindowName(e,window.name)),n},t.parseXdmInfoFromWindowName=function(t,n){return e.OUtil.parseInfoFromWindowName(t,n,"xdmInfo")},t.parseXdmInfoWithGivenFragment=function(t,n){return e.OUtil.parseInfoWithGivenFragment("&_xdm_Info=","_xdm_",!1,t,n)},t.parseFlights=function(e){var t=function(e,t){return u(f(n,i,!0,e,t))}(e,window.location.hash);return 0==t.length&&(t=function(e,t){return u(l(e,t,"flights"))}(e,window.name)),t},t.parseDisabledChangeGates=function(e){var t=function(e,t){return u(f(r,o,!0,e,t))}(e,window.location.hash);return 0==t.length&&(t=function(e,t){return u(l(e,t,"disabledChangeGates"))}(e,window.name)),t},t.checkFlight=function(t){return e.Flights&&e.Flights.indexOf(t)>=0},t.isChangeGateEnabled=function(t){return!e.DisabledChangeGates||-1===e.DisabledChangeGates.indexOf(t)},t.parseInfoFromWindowName=l,t.parseInfoWithGivenFragment=f,t.getConversationId=function(){var e=window.location.search,t=null;if(e){var n=e.indexOf("&");(t=n>0?e.substring(1,n):e.substr(1))&&"="===t.charAt(t.length-1)&&(t=t.substring(0,t.length-1))&&(t=decodeURIComponent(t))}return t},t.getInfoItems=function(e){var t=e.split("$");return void 0===t[1]&&(t=e.split("|")),void 0===t[1]&&(t=e.split("%7C")),t},t.getXdmFieldValue=function(t,n){var r="",i=e.OUtil.parseXdmInfo(n);if(i){var o=e.OUtil.getInfoItems(i);if(null!=o&&o.length>=3)switch(t){case"ConversationUrl":r=o[2];break;case"AppId":r=o[1]}}return r},t.parseUrl=function(t,n){if(void 0===n&&(n=!1),void 0!==t&&t){var r="NotHttps",i="undefined"!=typeof window&&void 0!==window.navigator&&window.navigator.userAgent.indexOf("Trident")>0,o=("undefined"!=typeof window&&void 0!==window.navigator&&window.navigator.userAgent.indexOf("Edge"),{protocol:void 0,hostname:void 0,host:void 0,port:void 0,pathname:void 0,search:void 0,hash:void 0,isPortPartOfUrl:void 0});try{if(i){var a=document.createElement("a");if(a.href=t,!(a&&a.protocol&&a.host&&a.hostname&&a.href&&d(a.href).toLowerCase()===d(t).toLowerCase()))throw"InvalidUrl";if(e.OUtil.checkFlight(2)&&n&&"https:"!=a.protocol)throw new Error(r);var c=function(e,t){return e&&t?"https:"==t.protocol&&s(e,"https:",t.hostname,"443")?":443":"http:"==t.protocol&&s(e,"http:",t.hostname,"80")?":80":"":""}(t,a);o.protocol=a.protocol,o.hostname=a.hostname,o.port=""==c?a.port:"",o.host=""!=c?a.hostname:a.host,o.pathname=(i?"/":"")+a.pathname,o.search=a.search,o.hash=a.hash,o.isPortPartOfUrl=s(t,a.protocol,a.hostname,a.port)}else{var u=new URL(t);if(u&&u.protocol&&u.host&&u.hostname){if(e.OUtil.checkFlight(2)&&n&&"https:"!=u.protocol)throw new Error(r);o.protocol=u.protocol,o.hostname=u.hostname,o.port=u.port,o.host=u.host,o.pathname=u.pathname,o.search=u.search,o.hash=u.hash,o.isPortPartOfUrl=u.host.lastIndexOf(":"+u.port)==u.host.length-u.port.length-1}}}catch(e){if(e.message===r)throw e}return o}},t.focusToFirstTabbable=function(e,t){var n,r,i=!1,o=function(e){i=!0},a=function(e,t,n){return t<0||t>e||0===t&&n?-1:t!==e-1||n?n?t-1:t+1:-1};if(e=h(e),n=t?e.length-1:0,0===e.length)return null;for(;!i&&n>=0&&n<e.length;)r=e[n],window.focus(),r.addEventListener("focus",o),r.focus(),r.removeEventListener("focus",o),n=a(e.length,n,t),i||r!==document.activeElement||(i=!0);return i?r:null},t.focusToNextTabbable=function(e,t,n){var r,i,o,a=!1,s=function(e){a=!0},c=function(e,t,n){return t<0||t>e||0===t&&n?-1:t!==e-1||n?n?t-1:t+1:-1};if(r=function(e,t){for(var n=0;n<e.length;n++)if(e[n]===t)return n;return-1}(e=h(e),t),(i=c(e.length,r,n))<0)return null;for(;!a&&i>=0&&i<e.length;)(o=e[i]).addEventListener("focus",s),o.focus(),o.removeEventListener("focus",s),i=c(e.length,i,n),a||o!==document.activeElement||(a=!0);return a?o:null},t.defineMethodOnNamespace=function(e,t,n){e[t]=n},t.isDialog=function(){return e._OfficeAppFactory.getHostInfo().isDialog},t.isPopupWindow=function(){return e.OUtil.isDialog()&&e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web&&null!=window.opener},t.getHostPlatform=function(){return e._OfficeAppFactory.getHostInfo().hostPlatform},t.getCustomOfficeInitializationSettings=function(){return"object"==typeof officeInitializationSettings?officeInitializationSettings:{}};var g=0;t.getLibraryReleaseVehicle=function(){return g},t.setLibraryReleaseVehicle=function(e){g=e}}(e.OUtil||(e.OUtil={}))}(OSF||(OSF={})),function(e){!function(e){e.Callback="callback",e.AsyncContext="asyncContext",e.Data="data",e.MessageToParent="messageToParent",e.MessageContent="messageContent",e.MessageOrigin="messageOrigin",e.TargetOrigin="targetOrigin",e.AppCommandInvocationCompletedData="appCommandInvocationCompletedData"}(e.ParameterNames||(e.ParameterNames={}))}(OSF||(OSF={})),function(e){!function(t){var n=function(){};t.RequirementVersion=n;var r=function(){function e(e){this._setMap=e}return e.prototype.isSetSupported=function(e,t){if(null==e)return!1;null==t&&(t=0);var n=this._setMap._sets;if(n.hasOwnProperty(e.toLowerCase())){var r=n[e.toLowerCase()];try{var i=this._getVersion(r+"");t+="";var o=this._getVersion(t);if(i.major>0&&i.major>o.major)return!0;if(i.major>0&&i.minor>=0&&i.major==o.major&&i.minor>=o.minor)return!0}catch(e){return!1}}return!1},e.prototype._getVersion=function(e){var t=(e+="").split("."),n=0,r=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),t.length>=2&&(r=Number(t[1])),isNaN(n)||isNaN(r))throw"version format incorrect";return{minor:r,major:n}},e}();t.RequirementMatrix=r;var i=function(){function e(e){this._sets=e}return e.prototype._addSetMap=function(e){for(var t in e)this._sets[t]=e[t]},e}();t.DefaultSetRequirement=i;var o=function(e){function t(){return e.call(this,{dialogapi:1.1})||this}return __extends(t,e),t}(i);t.DefaultRequiredDialogSetRequirement=o;var a=function(e){function t(){return e.call(this,{dialogorigin:1.1})||this}return __extends(t,e),t}(i);t.DefaultOptionalDialogSetRequirement=a;var s=function(){function t(){}return t.getDefaultRequirementMatrix=function(t){var n=void 0,o=t.get_requirementMatrix();if(null!=o&&o.length>0){var a=JSON.parse(t.get_requirementMatrix().toLowerCase());if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)try{var s="dialogorigin";a.hasOwnProperty(s)||(a[s]=1.1)}catch(e){}n=new r(new i(a))}else n=new r(new i({}));return n},t.getDefaultDialogRequirementMatrix=function(t){var n=void 0,s=t.get_dialogRequirementMatrix();if(null!=s&&s.length>0){var c=JSON.parse(t.get_requirementMatrix().toLowerCase());n=new i(c)}else{n=new o;var u=t.get_requirementMatrix();if(null!=u&&u.length>0&&"undefined"!=typeof JSON){c=JSON.parse(u.toLowerCase());for(var l in n._sets)c.hasOwnProperty(l)&&(n._sets[l]=c[l]);var f=new a;for(var l in f._sets)c.hasOwnProperty(l)&&(n._sets[l]=c[l])}}if(e._OfficeAppFactory.getHostInfo().hostPlatform==e.HostInfoPlatform.web)try{var p="dialogorigin";!n._sets.hasOwnProperty(p)&&window.opener&&(n._sets[p]=1.1)}catch(e){}return new r(n)},t}();t.RequirementsMatrixFactory=s}(e.Requirement||(e.Requirement={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n;t.executeRichApiRequestAsync=function(t,n){var r={toSafeArrayHost:function(){return[t]},fromSafeArrayHost:function(e){return{data:e}},toWebHost:function(){return{ArrayData:t}},fromWebHost:function(e){return{data:e.Data}}};e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(93,r,n)},Object.defineProperty(t,"richApiMessageManager",{get:function(){return n||(n=new e.RichApiMessageManager),n}})}(t.RichApi||(t.RichApi={}))}(e.DDA||(e.DDA={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){this._registerHandlers=[],this._eventDispatch=new e.EventDispatch([{type:e.EventType.RichApiMessage,id:e.EventDispId.dispidRichApiMessageEvent,getTargetId:function(){return""},fromSafeArrayHost:function(e){var n=e;return t.transferEventArgument(n)},fromWebHost:function(e){var n=e.ArrayData;return t.transferEventArgument(n)}}])}return t.transferEventArgument=function(t){var n=[];if(t)for(var r=0;r<t.length;r++){var i=t[r];i.toArray&&(i=i.toArray()),n.push({messageCategory:i[0],messageType:i[1],targetId:i[2],message:i[3],id:i[4],isRemoteOverride:i[5]})}return{type:e.EventType.RichApiMessage,entries:n}},t.prototype.addHandlerAsync=function(t,n,r){e.EventHelper.addEventHandler(t,n,r,this._eventDispatch)},t.prototype.removeHandlerAsync=function(t,n,r){e.EventHelper.removeEventHandler(t,n,r,this._eventDispatch)},t.prototype.register=function(t){var n=this;return this._registerPromise||(this._registerPromise=new Office.Promise((function(t,r){n.addHandlerAsync(e.EventType.RichApiMessage,(function(e){n._registerHandlers.forEach((function(t){t&&t(e)}))}),(function(e){"failed"==e.status?r(e.error):t()}))}))),this._registerPromise.then((function(){n._registerHandlers.push(t)}))},t}();e.RichApiMessageManager=t}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.prototype.execute=function(e,t,n){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.Execute(e,t,n,OsfOMToken):window.external.Execute(e,t,n)},t.prototype.registerEvent=function(e,t,n,r,i){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.RegisterEvent(e,n,r,i,OsfOMToken):window.external.RegisterEvent(e,n,r,i)},t.prototype.unregisterEvent=function(e,t,n,r){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.UnregisterEvent(e,n,r,OsfOMToken):window.external.UnregisterEvent(e,n,r)},t.prototype.closeSdxDialog=function(t){throw e.Utility.createNotImplementedException()},t.prototype.resizeSdxDialog=function(t,n){throw e.Utility.createNotImplementedException()},t}();e.RichClientHostController=t}(OSF||(OSF={})),function(e){var t=function(t){function n(){var e=null!==t&&t.apply(this,arguments)||this;return e.officeThemeTimeStamp=null,e.officeTheme=null,e}return __extends(n,t),n.prototype.getOsfControlContext=function(){if(!this._osfControlContext){var t="Warning: Office.js is loaded outside of Office client";try{if(!window.external)return console.error("There is no window.external."),e.Utility.trace(t),null;this._osfControlContext=window.external.GetContext()}catch(n){return console.error("Error when call window.external.GetContext() :"+JSON.stringify(n)),e.Utility.trace(t),null}}return this._osfControlContext},n.prototype.getAppContext=function(t,n,r){var i=this,o=this.getOsfControlContext();if(o){var a,s,c,u,l,f,p,d,h,g,y,m,_,v,b,O,I,S,P,C,R,A,E,w,x,N,T=0,j=!1;if((k=e.Utility.externalNativeFunctionExists)(typeof o.GetContextDataInJson))if("undefined"!=typeof OsfOMToken&&OsfOMToken)if((x=o.GetContextDataInJson(OsfOMToken))&&(N=JSON.parse(x)),N)a=N.appType,s=N.solutionRef,c=N.versionMajor,u=N.versionMinor,l=N.uiLocale,f=N.dataLocale,p=N.docUrl,d=N.clientMode,h=N.activationMode,y=N.controlType,m=N.eToken,_=N.correlationId,v=N.appInstanceId,b=N.touchEnabled,O=o.commerceAllowed,I=N.requirementMatrix,P=N.hostFullVersion,C=N.requirementMatrix,(F=N.featureGates)&&(R=JSON.parse(F)),T=N.initialDisplayMode,A=function(){var e,t=N.settings;t&&(e=JSON.parse(t));var n={};if(e)for(var r=e.names,i=e.values,o=0;o<r.length;o++)n[r[o]]=i[o];return n},E=function(){var e=N.themeInfo;return i.getOfficeThemeFromInfoString(e)};else j=!0;else j=!0;else j=!0;if(j){a=o.GetAppType(),s=o.GetSolutionRef(),c=o.GetAppVersionMajor(),u=o.GetAppVersionMinor(),l=o.GetAppUILocale(),f=o.GetAppDataLocale(),p=o.GetDocUrl(),d=o.GetAppCapabilities(),h=o.GetActivationMode(),y=o.GetControlIntegrationLevel();try{m=o.GetSolutionToken()}catch(e){}var k;if((k=e.Utility.externalNativeFunctionExists)(typeof o.GetCorrelationId)&&(_=o.GetCorrelationId()),k(typeof o.GetInstanceId)&&(v=o.GetInstanceId()),k(typeof o.GetTouchEnabled)&&(b=o.GetTouchEnabled()),k(typeof o.GetCommerceAllowed)&&(O=o.GetCommerceAllowed()),k(typeof o.GetSupportedMatrix)&&(I=o.GetSupportedMatrix()),k(typeof o.GetHostCustomMessage)&&(S=o.GetHostCustomMessage()),k(typeof o.GetHostFullVersion)&&(P=o.GetHostFullVersion()),k(typeof o.GetDialogRequirementMatrix)&&(C=o.GetDialogRequirementMatrix()),k(typeof o.GetFeaturesForSolution))try{var F;(F=o.GetFeaturesForSolution())&&(R=JSON.parse(F))}catch(t){e.Utility.trace("Exception while creating the SDX FeatureGates object. Details: "+t)}k(typeof o.GetInitialDisplayMode)&&(T=o.GetInitialDisplayMode()),A=function(){return i.getSerializedSettings()},E=function(){return i.getOfficeTheme()},w=function(){return i.getSerializedHostSettings()}}g=2===h?Office.InitializationReason.DocumentOpened:Office.InitializationReason.Inserted,m=m?m.toString():"",n(new e.OfficeAppContext(s,a,c,l,f,p,d,A,g,y,m,_,v,b,O,u,I,S,P,void 0,void 0,void 0,void 0,C,R,E,T,void 0,void 0,w,!1,void 0,void 0))}else r(new Error("The Office.js is loaded outside of Office client"))},n.prototype.createClientHostController=function(){if(!this._clientHostController){if(this._hostInfo.hostPlatform!==e.HostInfoPlatform.win32)throw e.Utility.createNotImplementedException();this._clientHostController=new e.Win32RichClientHostController}return this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this._clientHostController)},n.prototype.createClientSettingsManager=function(){return new e.RichClientSettingsManager(this.getOsfControlContext())},n.prototype.getSerializedSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).Read(t,n):e.GetSettings().Read(t,n);for(var r={},i=0;i<t.length;i++)r[t[i]]=n[i];return r},n.prototype.getOfficeTheme=function(){var e=this.getOsfControlContext();if(e){if(!(this.officeTheme&&this.officeThemeTimeStamp&&(new Date).getTime()-this.officeThemeTimeStamp<n.officeThemeCacheValidPeriod)){var t=e.GetOfficeThemeInfo();this.officeTheme=this.getOfficeThemeFromInfoString(t),this.officeThemeTimeStamp=(new Date).getTime()}return this.officeTheme}},n.prototype.getOfficeThemeFromInfoString=function(t){var n=null;if(t)try{n=JSON.parse(t)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+t)}var r={};if(n){var i={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var o in n){var a=!1,s=o;i[o]&&(s=i[o].name,a=i[o].convertToHex),r[s]=a?e.OUtil.convertIntToCssHexColor(n[o]):n[o]}}return r},n.prototype.getSerializedHostSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"function"==typeof e.GetSettings().ReadHost&&("undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).ReadHost(t,n):e.GetSettings().ReadHost(t,n));for(var r={},i=0;i<t.length;i++)r[t[i]]=n[i];return r},n.officeThemeCacheValidPeriod=5e3,n}(e.InitializationHelper);e.RichClientInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function e(e){this._osfClientContext=e}return e.prototype.read=function(e){var t,n=this._osfClientContext;t="undefined"!=typeof OsfOMToken&&OsfOMToken?n.GetSettings(OsfOMToken):n.GetSettings();var r=function(){var n=[],r=[];t.Read(n,r);for(var i={},o=0;o<n.length;o++)i[n[o]]=r[o];e&&e(0,i)};t.RefreshAsync?t.RefreshAsync((function(){r()})):r()},e.prototype.write=function(e,t){var n=[],r=[];for(var i in e)n.push(i),r.push(e[i]);var o,a=this._osfClientContext;void 0!==(o="undefined"!=typeof OsfOMToken&&OsfOMToken?a.GetSettings(OsfOMToken):a.GetSettings()).WriteAsync?o.WriteAsync(n,r,t):(o.Write(n,r),t(0))},e}();e.RichClientSettingsManager=t}(OSF||(OSF={})),function(e){var t=function(t){function n(n){var r=t.call(this)||this;return r._clientHostController=n,r._asyncMethodExecutorHelper=e.BootStrapExtension.createAsyncMethodExecutorHelper(r),r}return __extends(n,t),n.prototype.executeAsync=function(t,n,r,i){var o=this;try{var a=new Array;this._clientHostController.execute(t,n.toSafeArrayHost(),(function(s,c){var u=e.Utility.fromSafeArray(s);return o._asyncMethodExecutorHelper.handleSafeArrayHostResponse(u,c,a,r,n,t,i)}))}catch(e){this.onException(e,t,r)}},n.prototype.registerEventAsync=function(t,n,r,i,o,a,s){var c=this;try{this._clientHostController.registerEvent(t,n,r,(function(t,n){var r=e.Utility.fromSafeArray(n),a=o.fromSafeArrayHost(r);i(a)}),(function(n){var r,i=e.Utility.fromSafeArray(n);return"number"==typeof i?([],r=i):r=i[0],c.invokeCallback(t,a,r,null,s),!0}))}catch(e){this.onException(e,t,a)}},n.prototype.unregisterEventAsync=function(t,n,r,i,o){var a=this;try{this._clientHostController.unregisterEvent(t,n,r,(function(n,r){var s,c=e.Utility.fromSafeArray(n);return"number"==typeof c?([],s=c):s=c[0],a.invokeCallback(t,i,s,null,o),!0}))}catch(e){this.onException(e,t,i)}},n.prototype.onException=function(t,n,r){var i,o=t.number;if(o)switch(o){case-2146828218:i=7e3;break;case-2147467259:i=n==e.EventDispId.dispidDialogMessageReceivedEvent?12007:5001;break;case-2146828283:case-2147209089:i=5010;break;case-2147208704:i=5100;break;case-2146827850:default:i=5001}r&&this.invokeCallback(n,r,i||5001,null)},n}(e.AsyncMethodExecutor);e.SafeArrayAsyncMethodExecutor=t}(OSF||(OSF={})),function(e){var t=function(){function e(e){this._internalStorage=e}return e.prototype.getItem=function(e){try{return this._internalStorage&&this._internalStorage.getItem(e)}catch(e){return null}},e.prototype.setItem=function(e,t){try{this._internalStorage&&this._internalStorage.setItem(e,t)}catch(e){}},e.prototype.clear=function(){try{this._internalStorage&&this._internalStorage.clear()}catch(e){}},e.prototype.removeItem=function(e){try{this._internalStorage&&this._internalStorage.removeItem(e)}catch(e){}},e.prototype.getKeysWithPrefix=function(e){var t=[];try{for(var n=this._internalStorage&&this._internalStorage.length||0,r=0;r<n;r++){var i=this._internalStorage.key(r);0===i.indexOf(e)&&t.push(i)}}catch(e){}return t},e}();e.SafeStorage=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t){var n=this;this._clientSettingsManager=t,e=e||{},this._settings=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidSettingsChangedEvent,type:OSF.EventType.SettingsChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}},fromWebHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}}}])}return t.prototype.cacheSessionSettings=function(e){var t=OSF.OUtil.getSessionStorage();if(t){var n=OSF.OUtil.serializeSettings(e),r=JSON.stringify(n);t.setItem(OSF._OfficeAppFactory.getCachedSessionSettingsKey(),r)}},t.prototype.get=function(e){var t=this._settings[e];return void 0===t?null:t},t.prototype.set=function(e,t){this._settings[e]=t,this.cacheSessionSettings(this._settings)},t.prototype.remove=function(e){delete this._settings[e],this.cacheSessionSettings(this._settings)},t.prototype.saveAsync=function(e){var t=this._clientSettingsManager,n=OSF.OUtil.serializeSettings(this._settings);t.write(n,(function(t){var n=OSF.Utility.asyncResultFromErrorCode(t);e&&e(n)}))},t.prototype.refreshAsync=function(t){var n=this;this._clientSettingsManager.read((function(r,i){var o=OSF.Utility.asyncResultFromErrorCode(r);o.status===e.AsyncResultStatus.Succeeded&&(n._settings=OSF.OUtil.deserializeSettings(i),o.value=n),t&&t(o)}))},t.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},t.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},t.prototype.toJSON=function(){return this._settings},t}();e.Settings=t}(Office||(Office={}));var OSFWebkit,OTel,Microsoft,__awaiter=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(i,o){function a(e){try{c(r.next(e))}catch(e){o(e)}}function s(e){try{c(r.throw(e))}catch(e){o(e)}}function c(e){e.done?i(e.value):new n((function(t){t(e.value)})).then(a,s)}c((r=r.apply(e,t||[])).next())}))},__generator=this&&this.__generator||function(e,t){var n,r,i,o,a={label:0,sent:function(){if(1&i[0])throw i[1];return i[1]},trys:[],ops:[]};return o={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function s(o){return function(s){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;a;)try{if(n=1,r&&(i=2&o[0]?r.return:o[0]?r.throw||((i=r.return)&&i.call(r),0):r.next)&&!(i=i.call(r,o[1])).done)return i;switch(r=0,i&&(o=[2&o[0],i.value]),o[0]){case 0:case 1:i=o;break;case 4:return a.label++,{value:o[1],done:!1};case 5:a.label++,r=o[1],o=[0];continue;case 7:o=a.ops.pop(),a.trys.pop();continue;default:if(!(i=a.trys,(i=i.length>0&&i[i.length-1])||6!==o[0]&&2!==o[0])){a=0;continue}if(3===o[0]&&(!i||o[1]>i[0]&&o[1]<i[3])){a.label=o[1];break}if(6===o[0]&&a.label<i[1]){a.label=i[1],i=o;break}if(i&&a.label<i[2]){a.label=i[2],a.ops.push(o);break}i[2]&&a.ops.pop(),a.trys.pop();continue}o=t.call(e,a)}catch(e){o=[6,e],r=0}finally{n=i=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,s])}}};!function(e){var t=function(){function t(){}return t.isSovereignVersion=function(){return"undefined"!=typeof isOsfSovereignVersion&&!0===isOsfSovereignVersion},t.prototype.getEnvironmentName=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())&&e.envName?e.envName:null]}}))}))},t.prototype.getEnvironmentType=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())&&e.envType?e.envType:null]}}))}))},t.prototype.getTrustedHostOrigins=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(e=t.sent())?e.trustedHostOrigins:null]}}))}))},t.prototype.isConfigAvailable=function(){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,!!e.sent()]}}))}))},t.prototype.isSovereignHostTrusted=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return e?e===window.location.hostname?[2,!0]:[4,this.getTrustedHostOrigins()]:[2,!1];case 1:return(t=n.sent())&&0!=t.length?[2,new RegExp(t.join("|")).test(e)]:[2,!1]}}))}))},t.prototype.getConfigPath=function(){var t=e.LoadScriptHelper.getHostBundleJsBasePath();if(t){var n="/lib/",r=(t=t.toLowerCase()).indexOf(n);if(r>-1)return t.toLowerCase().substring(0,r+n.length)+"officeconfig.json"}return""},t.prototype.getConfig=function(){return this._configPromise||(this._configPromise=this.tryLoadConfig()),this._configPromise},t.prototype.tryLoadConfig=function(){return __awaiter(this,void 0,void 0,(function(){var t,n,r,i,o,a,s;return __generator(this,(function(c){switch(c.label){case 0:if(!(t=this.getConfigPath()))return[3,2];if(n=e.OUtil.getLocalStorage(),r=t+"_cache",i=n.getItem(r),o=null,i){try{o=JSON.parse(i)}catch(e){}if(864e5,a=(new Date).getTime(),o&&o.config&&o.createTime<=a&&o.createTime+864e5>=a)return[2,o.config]}return[4,this.downloadConfig(t)];case 1:return(s=c.sent())?(o={createTime:(new Date).getTime(),config:s},n.setItem(r,JSON.stringify(o))):o&&(s=o.config),[2,s];case 2:return[2,null]}}))}))},t.prototype.downloadConfig=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return t.trys.push([0,3,,4]),[4,fetch(e)];case 1:return[4,t.sent().json()];case 2:return[2,t.sent()];case 3:return t.sent(),[3,4];case 4:return[2,null]}}))}))},t}();e.SovereignHelper=t}(OSF||(OSF={})),function(e){!function(e){function t(e){return void 0===e||null===e}e.createParameterException=function(e){return new Error("Parameter count mismatch: "+e)},e.createArgumentException=function(e){return new Error("Invalid argument "+e)},e.createNotImplementedException=function(){return new Error("Not implemented yet")},e.log=function(e){console.log(e)},e.trace=function(e){console.log(e)},e.debugLog=function(e){console.log(e)},e.getQueryStringValue=function(e){if("undefined"!=typeof window&&window.location&&window.location.search){var t=new RegExp("[?&]"+e+"=([^&]*)").exec(window.location.search);if(t)return t[1]}return null},e.isNullOrUndefined=t,e.isNullOrEmpty=function(e){return!!t(e)||0===e.length},e.isInUnittest=function(){return"boolean"==typeof g_osfUnittest&&g_osfUnittest}}(e.Utility||(e.Utility={}))}(OSF||(OSF={})),function(e){e.isOfficeReactNative=function(){try{return"undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka}catch(e){return!1}},function(e){function t(e){return new Promise(e)}function n(e){var t=e,i=1;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray)if(e.dimensions&&(i=e.dimensions()),2===i)t=r(e);else{var o=e.toArray();t=new Array(o.length);for(var a=0;a<o.length;a++)t[a]=n(o[a])}return t}function r(e){var t;try{var n=e.ubound(1),r=e.ubound(2);if(e=e.toArray(),1==n&&1==r)t=[e];else{t=[];for(var i=0;i<n;i++){for(var o=[],a=0;a<r;a++){var s=e[i*r+a];"{66e7831f-81b2-42e2-823c-89e872d541b3}"!=s&&o.push(s)}o.length>0&&t.push(o)}}}catch(e){}return t}e.xdmDebugLog=function(t){e._DebugXdm&&console.log(t)},e.enableDebugXdm=function(){e._DebugXdm=!0},e.createPromiseFromResult=function(e){return Promise.resolve(e)},e.createPromise=t,e.promisify=function(e,n){return t((function(t,r){e((function(e){0===e?t():r()})),setTimeout((function(){r()}),n)}))},e.compareVersions=function(e,t){var n,r=e.split("."),i=t.split(".");for(n in r){if(parseInt(r[n])<parseInt(i[n]))return!1;if(parseInt(r[n])>parseInt(i[n]))return!0}return!1},e.getErrorCodeFromAsyncResult=function(e){return e.status===Office.AsyncResultStatus.Succeeded?0:e.error&&e.error.code?e.error.code:5001},e.externalNativeFunctionExists=function(e){return"unknown"===e||"undefined"!==e},e.stringEndsWith=function(t,n){if(e.isNullOrUndefined(t))throw e.createArgumentException("value");if(e.isNullOrUndefined(n))throw e.createArgumentException("subString");return!(n.length>t.length)&&t.substr(t.length-n.length)===n},e.fromSafeArray=function(e){var t=e;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray){var r=e.toArray();t=new Array(r.length);for(var i=0;i<r.length;i++)t[i]=n(r[i])}return t},e.twoDVBArrayToJaggedArray=r,e.asyncResultFromErrorCode=function(e){return Array.isArray(e)&&1===e.length&&(e=e[0]),0===e?{status:Office.AsyncResultStatus.Succeeded}:{status:Office.AsyncResultStatus.Failed,error:{code:e}}},e._DebugXdm=!1}(e.Utility||(e.Utility={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(n){var r=t.call(this)||this;return r._clientHostController=n,r._asyncMethodExecutorHelper=e.BootStrapExtension.createAsyncMethodExecutorHelper(r),r}return __extends(n,t),n.prototype.executeAsync=function(e,t,n,r){var i=this;this._clientHostController.execute(e,t.toWebHost(),(function(o,a){return n&&i._asyncMethodExecutorHelper.handleWebHostResponse(a,o,n,t,e,r),!0}))},n.prototype.registerEventAsync=function(e,t,n,r,i,o,a){var s=this;this._clientHostController.registerEvent(e,t,n,(function(e){var t=e,n=i.fromWebHost(t);r(n)}),(function(t,n){return o&&s.invokeCallback(e,o,t,null,a),!0}))},n.prototype.unregisterEventAsync=function(e,t,n,r,i){var o=this;this._clientHostController.unregisterEvent(e,t,n,(function(t,n){return r&&o.invokeCallback(e,r,t,null,i),!0}))},n}(e.AsyncMethodExecutor);e.WebAsyncMethodExecutor=t}(OSF||(OSF={})),function(e){!function(t){!function(t){t.getAuthContextAsync=function(t){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(99,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.authContext}},t)}}(t.WebAuth||(t.WebAuth={}))}(e.DDA||(e.DDA={})),function(t){var n;!function(e){e.AuthCode="authcode",e.Broker="broker",e.Implicit="implicit"}(n=t.AuthFlow||(t.AuthFlow={})),t.loadAttempts=0;var r="webauth/",i="webauth.browserauth.debug.js",o="webauth.browserauth.js",a=!1;t.load=function(){return t.config&&t.config.authFlow===n.AuthCode?(t.loadAttempts++,(a=t.config&&(!0===t.config.useMsal3||!1!==t.config.useMsal3&&e.OUtil.checkFlight(e.FlightTreatmentNames.EnableMsal3SsoApi)))&&(i="webauth.browserauth.msal3.debug.js",o="webauth.browserauth.msal3.js"),new Promise((function(n,s){var c=function(t,n,r){return new Promise((function(i,o){t?e.OUtil.loadScript(t,(function(e){if("boolean"!=typeof e||e)if(e instanceof Event&&e)o(new Event("loadScript: "+e.type+" '"+t+"'"));else if(r&&!n())var a=0,s=setInterval((function(){a+=500,!(n()||a>r)||(clearInterval(s),n())||o(new Event("Missing expected object after loaded."))}),500);else i(null);else o(new Event("loadScript: failed to load '"+t+"'"))}),e.LoadScriptHelper.getTrustedTypesPolicy(),r):i(null)}))},u=[c(t.config&&t.config.authVersion?e.LoadScriptHelper.getHostBundleJsBasePath()+r+t.config.authVersion+"/"+(t.config&&t.config.debugging?i:o):e.LoadScriptHelper.getHostBundleJsBasePath()+r+(t.config&&t.config.debugging?i:o),(function(){return!!BrowserAuth}),t.config.delayWebAuth)];a||u.push(c(t.config.msal,(function(){return!!msal}),t.config.delayMsal)),Promise.all(u).then((function(){t.config?BrowserAuth.Load(t.config,e._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId).then((function(e){n(e)}),(function(e){s(e)})):s(new Event("config is empty."))}),(function(e){s(e)}))}))):new Promise((function(e,t){return t(new Event("'authcode' as authFlow is only supported"))}))},t.getToken=function(e,r,i,o,s,c){return t.config&&t.config.authFlow===n.AuthCode?a?BrowserAuth.GetToken({resource:e,scopes:r,applicationId:i,correlationId:o,popup:!!s,claims:c}):BrowserAuth.GetToken(e,i,o,!!s,!!s,!1,c):Promise.reject(new Event("'authcode' as authFlow is only supported"))}}(e.WebAuth||(e.WebAuth={}))}(OSF||(OSF={})),function(e){var t=function(){function t(t){this._delegateVersion=1,this._webAppState=t,this._webClientHostControllerHelper=e.BootStrapExtension.createWebClientHostControllerHelper(this._webAppState,this._delegateVersion)}return t.prototype.execute=function(e,t,n){var r=this,i=this._webClientHostControllerHelper.getHostCallArgs(e,t),o=this._webClientHostControllerHelper.getTargetMethodName(e);this._webAppState.clientEndPoint.invoke(o,(function(t,i){var o=0;if(0==t)r._delegateVersion=i.Version,o=r._webClientHostControllerHelper.parseErrorFromPayload(e,i);else switch(t){case-5:o=7e3;break;default:o=5001}n&&n(o,i)}),i)},t.prototype.registerEvent=function(e,t,n,r,i){this._webAppState.clientEndPoint.registerForEvent(this.getXdmEventName(n,t),(function(e){r&&r(e)}),this._getOnAfterRegisterEvent(!0,e,i),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.unregisterEvent=function(e,t,n,r){this._webAppState.clientEndPoint.unregisterForEvent(this.getXdmEventName(n,t),this._getOnAfterRegisterEvent(!1,e,r),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.messageParent=function(t){throw e.Utility.createNotImplementedException()},t.prototype.openDialog=function(t,n,r,i,o){throw e.Utility.createNotImplementedException()},t.prototype.closeDialog=function(t,n,r,i){throw e.Utility.createNotImplementedException()},t.prototype.sendMessage=function(t){throw e.Utility.createNotImplementedException()},t.prototype.closeSdxDialog=function(t){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,e.AgaveHostAction.CloseSDXDialog,{InstanceId:this._webAppState.id,DialogCloseCallbackParam:t}])},t.prototype.resizeSdxDialog=function(t,n){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,e.AgaveHostAction.ResizeSDXDialog,{InstanceId:this._webAppState.id,DialogWidth:t+"px",DialogHeight:n+"px"}])},t.prototype.getXdmEventName=function(t,n){return n==e.EventType.BindingSelectionChanged||n==e.EventType.BindingDataChanged||n==e.EventType.DataNodeDeleted||n==e.EventType.DataNodeInserted||n==e.EventType.DataNodeReplaced?t+"_"+n:n},t.prototype._getOnAfterRegisterEvent=function(t,n,r){var i=(new Date).getTime();return function(o,a){var s;if(0!=o)switch(o){case-5:s=7e3;break;default:s=5001}else s=a?a.Error?a.Error:0:5001;r&&r(s),e.AppTelemetry&&e.AppTelemetry.onRegisterDone(t,n,Math.abs((new Date).getTime()-i),s)}},t}();e.WebClientHostController=t}(OSF||(OSF={})),function(e){var t=function(){function e(e,t){this._webAppState=e,this._delegateVersion=t}return e.prototype.getHostCallArgs=function(e,t){var n=t;return n||(n={}),n.DdaMethod={ControlId:this.getControlId(),DispatchId:e,Version:this._delegateVersion},n.__timeout__=-1,n},e.prototype.getTargetMethodName=function(e){return"executeMethod"},e.prototype.parseErrorFromPayload=function(e,t){return t.Error},e.prototype.getControlId=function(){return this._webAppState.id},e}();e.WebClientHostControllerHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.prototype.read=function(t){e._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(75,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.Properties.Settings}},(function(e){if(e.status===Office.AsyncResultStatus.Succeeded){for(var n={},r=0;r<e.value.length;r++){var i=e.value[r];Array.isArray(i)?n[i[0]]=i[1]:n[i.Name]=i.Value}t(0,n)}else{var o=e.error.code;t(o,{})}}))},t.prototype.write=function(t,n){var r=e._OfficeAppFactory.getAsyncMethodExecutor(),i=[];for(var o in t){var a=[];a.push(o),a.push(t[o]),i.push(a)}var s={toSafeArrayHost:function(){return null},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{DdaSettingsMethod:{OverwriteIfStale:!0,Properties:i}}},fromWebHost:function(e){return null}};r.executeAsync(76,s,(function(e){if(e.status===Office.AsyncResultStatus.Succeeded)n(0);else{var t=e.error.code;n(t)}}))},t}();e.WebClientSettingsManager=t}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,i){var o=t.call(this,e,n,r,i)||this;return o._appContext={},o._tabbableElements="a[href]:not([tabindex='-1']),area[href]:not([tabindex='-1']),button:not([disabled]):not([tabindex='-1']),input:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),textarea:not([disabled]):not([tabindex='-1']),*[tabindex]:not([tabindex='-1']),*[contenteditable]:not([disabled]):not([tabindex='-1'])",o}return __extends(n,t),Object.defineProperty(n.prototype,"isHostOriginTrusted",{get:function(){return this._isHostOriginTrustedFunc},set:function(e){this._isHostOriginTrustedFunc=e},enumerable:!0,configurable:!0}),n.prototype.saveAndSetDialogInfo=function(t){var n,r=e.OUtil.getSessionStorage();if(r){if(t||(t=e.OUtil.parseHostInfoFromWindowName(!0,e._OfficeAppFactory.getWindowName())),t&&t.indexOf("isDialog")>-1){var i=(n=e.OUtil.parseXdmInfo(!0))?n.split("|")[1]:null;return null!=i&&r.setItem(i+"IsDialog","true"),void(this._hostInfo.isDialog=!0)}this._hostInfo.isDialog=null!=r.getItem(e.OUtil.getXdmFieldValue("AppId",!1)+"IsDialog")}},n.prototype.checkReceiverOriginAndRun=function(t){return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a,s,c,u,l,f;return __generator(this,(function(p){switch(p.label){case 0:return 3===(n=this)._webAppState.clientEndPoint.hostTrustCheckStatus?(t(),[2]):(r=e.OUtil.parseUrl(n._webAppState.clientEndPoint.targetUrl,!1),i="https:"==r.protocol,o=r.hostname,a="NotHttps",0!==n._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(i||(n._webAppState.clientEndPoint.hostTrustCheckStatus=2),2==n._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(s=!1,(c=e.SovereignHelper.isSovereignVersion())&&!0!==e.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments||(s=e.XdmCommunicationManager.isHostNameValidWacDomain(o),n.isHostOriginTrusted&&(s=s||n.isHostOriginTrusted(o))),s||!c?[3,3]:(n._sovereignHelper||(n._sovereignHelper=new e.SovereignHelper),[4,(u=n._sovereignHelper).isConfigAvailable()]))));case 1:return p.sent()?[4,u.isSovereignHostTrusted(o)]:[2];case 2:s=p.sent(),p.label=3;case 3:s&&(n._webAppState.clientEndPoint.hostTrustCheckStatus=3),p.label=4;case 4:if(n._webAppState.clientEndPoint.checkStatusLogged||null==n._hostInfo||void 0===n._hostInfo||(e.AppTelemetry.onCheckWACHost(n._webAppState.clientEndPoint.hostTrustCheckStatus,n._webAppState.id,n._hostInfo.hostType,n._hostInfo.hostPlatform,n._webAppState.clientEndPoint.targetUrl),n._webAppState.clientEndPoint.checkStatusLogged=!0),3===n._webAppState.clientEndPoint.hostTrustCheckStatus||e.LoadScriptHelper.disableHostCheck())t();else{if(e.LoadScriptHelper.isSdx())throw new Error("Not supported host");l=function(){var r=e.LoadScriptHelper.getHostBundleJsBasePath().match(/^https?:\/\/[^:/?#]*(?::([0-9]+))?/);if(r&&r[0]){var s=e.LoadScriptHelper.getHostBundleJsBasePath()+"AgaveErrorUX/index.html#",c={error:"NotTrustedWAC",locale:e.getSupportedLocale(n._hostInfo.hostLocale,e.ConstantNames.DefaultLocale),hostname:o,noHttps:!i,validate:!1},u=document.createElement("iframe");u.style.visibility="hidden",u.style.height="0",u.style.width="0";var l=function(i){if(i.source==u.contentWindow&&i.origin==r[0])try{!0===JSON.parse(i.data).hostUserTrusted?(n._webAppState.clientEndPoint.hostTrustCheckStatus=3,e.OUtil.removeEventListener(window,"message",l),document.body.removeChild(u)):(c.validate=!1,window.location.replace(s+encodeURIComponent(JSON.stringify(c)))),t()}catch(t){e.OUtil.ensureOfficeStringsJs().then((function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC}))}};e.OUtil.addEventListener(window,"message",l),c.validate=!0,u.setAttribute("src",s+encodeURIComponent(JSON.stringify(c))),u.onload=function(){var e={hostname:o,noHttps:!i};u.contentWindow.postMessage(JSON.stringify(e),r[0])},document.body.appendChild(u)}else e.OUtil.ensureOfficeStringsJs().then((function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC}));if(e.OUtil.checkFlight(2)&&!i)throw new Error(a)},document.body?l():(f=!1,document.addEventListener("DOMContentLoaded",(function(){f||(f=!0,l())})))}return[2]}}))}))},n.prototype.setAgaveHostCommunication=function(){try{var t=this,n=e.OUtil.parseXdmInfoWithGivenFragment(!1,e._OfficeAppFactory.getWindowLocationHash());if(n||(n=e.OUtil.parseXdmInfoFromWindowName(!1,e._OfficeAppFactory.getWindowName())),n){var r=e.OUtil.getInfoItems(n);null!=r&&r.length>=3&&(t._webAppState.conversationID=r[0],t._webAppState.id=r[1],t._webAppState.webAppUrl=r[2].indexOf(":")>=0?r[2]:decodeURIComponent(r[2]))}if(t._webAppState.wnd=null!=window.opener?window.opener:window.parent,this._hostInfo.isDialog&&null!=window.opener)return;t._webAppState.clientEndPoint=e.XdmCommunicationManager.connect(t._webAppState.conversationID,t._webAppState.wnd,t._webAppState.webAppUrl),t._webAppState.serviceEndPoint=e.XdmCommunicationManager.createServiceEndPoint(t._webAppState.id),t._webAppState.clientEndPoint.checkReceiverOriginAndRun=function(e){t.checkReceiverOriginAndRun(e)};var i=t._webAppState.conversationID+e.Constants.NotificationConversationIdSuffix;t._webAppState.serviceEndPoint.registerConversation(i,t._webAppState.webAppUrl);t._webAppState.serviceEndPoint.registerMethod("Office_notifyAgave",(function(n){var r;switch(r="string"==typeof n?n:n[0]){case e.AgaveHostAction.Select:t._webAppState.focused=!0;break;case e.AgaveHostAction.UnSelect:t._webAppState.focused=!1;break;case e.AgaveHostAction.TabIn:case e.AgaveHostAction.CtrlF6In:window.focus();var i=document.querySelectorAll(t._tabbableElements);e.OUtil.focusToFirstTabbable(i,!1)||(window.blur(),t._webAppState.focused=!1,t._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t._webAppState.id,e.AgaveHostAction.ExitNoFocusable]));break;case e.AgaveHostAction.TabInShift:window.focus();i=document.querySelectorAll(t._tabbableElements);e.OUtil.focusToFirstTabbable(i,!0)||(window.blur(),t._webAppState.focused=!1,t._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t._webAppState.id,e.AgaveHostAction.ExitNoFocusableShift]));break;case e.AgaveHostAction.SendMessage:if(Office.context.messaging.onMessage){var o=n[1];Office.context.messaging.onMessage(o)}break;case e.AgaveHostAction.TaskPaneHeaderButtonClicked:Office.context.ui.taskPaneAction.onHeaderButtonClick&&Office.context.ui.taskPaneAction.onHeaderButtonClick();break;default:e.Utility.trace("actionId "+r+" notifyAgave is wrong.")}}),0,!1),t.addOrRemoveEventListenersForWindow(!0)}catch(t){throw e.AppTelemetry&&e.AppTelemetry.logAppException("Exception thrown in setAgaveHostCommunication. Exception:["+t+"]"),t}},n.prototype.getAppContext=function(t,n,r){var i=this,o=this,a=function(t,a){if(OSFPerformance.getAppContextXdmEnd=OSFPerformance.now(),a._appName===e.AppName.ExcelWebApp){var s=a._settings;i._serializedSettings={};for(var c=0,u=s;c<u.length;c++){var l=u[c],f=l[0],p=l[1];i._serializedSettings[f]=p}var d=a._hostSettings;i._serializedHostSettings={};for(var h=0,g=d;h<g.length;h++){var y=g[h];f=y[0],p=y[1];i._serializedHostSettings[f]=p}}else i._serializedSettings=a._settings,i._serializedHostSettings=a._hostSettings;if(!o._hostInfo.isDialog||null==window.opener){var m=window.location.href;o._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[o._webAppState.id,e.AgaveHostAction.UpdateTargetUrl,m])}if(0===t&&null!=a._id&&null!=a._appName&&null!=a._appVersion&&null!=a._appUILocale&&null!=a._dataLocale&&null!=a._docUrl&&null!=a._clientMode&&null!=a._reason){o._appContext=a;var _=a._appInstanceId?a._appInstanceId:a._id,v=0;null!=a._appMinorVersion&&(v=a._appMinorVersion);var b=void 0;null!=a._requirementMatrix&&(b=a._requirementMatrix),a.eToken=a.eToken?a.eToken:"";var O=new e.OfficeAppContext(a._id,a._appName,a._appVersion,a._appUILocale,a._dataLocale,a._docUrl,a._clientMode,(function(){return i._serializedSettings}),a._reason,a._osfControlType,a._eToken,a._correlationId,_,!1,!0,v,b,a._hostCustomMessage,a._hostFullVersion,a._clientWindowHeight,a._clientWindowWidth,a._addinName,a._appDomains,a._dialogRequirementMatrix,a._featureGates,a._officeTheme,a._initialDisplayMode,a._isFromWacAutomation,a._wopiHostOriginForSingleSignOn,(function(){return i._serializedHostSettings}),!0,a._nestedAppAuthBridgeType,a._partitionKey);O.set_taskpaneUrl(a._taskpaneUrl),n(O)}else{var I="Function ContextActivationManager_getAppContextAsync call failed. ErrorCode is "+t+", exception: "+a;e.AppTelemetry&&e.AppTelemetry.logAppException(I),r(I)}};try{var s=!0;this._hostInfo.isDialog&&null!=window.opener&&(s=!1);var c=e.OUtil.parseAppContextFromWindowName(s,e._OfficeAppFactory.getWindowName());c?a(0,c):(OSFPerformance.getAppContextXdmStart=OSFPerformance.now(),this._webAppState.clientEndPoint.invoke("ContextActivationManager_getAppContextAsync",a,this._webAppState.id))}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception thrown when trying to invoke getAppContextAsync. Exception:["+t+"]"),r(t)}},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.WebClientHostController(this._webAppState)),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.WebAsyncMethodExecutor(this._clientHostController)},n.prototype.createClientSettingsManager=function(){return new e.WebClientSettingsManager},n.prototype.addOrRemoveEventListenersForWindow=function(t){var n=this,r=function(){n._webAppState.focused||(n._webAppState.focused=!0),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.Select])},i=function(){e&&(n._webAppState.focused&&(n._webAppState.focused=!1),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.UnSelect]))},o=function(t){if(t.preventDefault=t.preventDefault||function(){t.returnValue=!1},117==t.keyCode&&(t.ctrlKey||t.metaKey)){t.preventDefault();var r=e.AgaveHostAction.CtrlF6Exit;t.shiftKey&&(r=e.AgaveHostAction.CtrlF6ExitShift),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,r])}else if(9==t.keyCode){t.preventDefault();var i=document.querySelectorAll(n._tabbableElements);e.OUtil.focusToNextTabbable(i,t.target||t.srcElement,t.shiftKey)||(n._hostInfo.isDialog?e.OUtil.focusToFirstTabbable(i,t.shiftKey):t.shiftKey?n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExitShift]):n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.TabExit]))}else if(27==t.keyCode)t.preventDefault(),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.EscExit]);else if(113==t.keyCode)t.preventDefault(),n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.F2Exit]);else if((t.ctrlKey||t.metaKey||t.shiftKey||t.altKey)&&t.keyCode>=1&&t.keyCode<=255){var o={keyCode:t.keyCode,shiftKey:t.shiftKey,altKey:t.altKey,ctrlKey:t.ctrlKey,metaKey:t.metaKey};n._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[n._webAppState.id,e.AgaveHostAction.KeyboardShortcuts,o])}},a=function(e){117==e.keyCode&&e.ctrlKey&&(e.preventDefault?e.preventDefault():e.returnValue=!1)};e.Utility._DebugXdm||(t?(e.OUtil.addEventListener(window,"focus",r),e.OUtil.addEventListener(window,"blur",i),e.OUtil.addEventListener(window,"keydown",o),e.OUtil.addEventListener(window,"keypress",a)):(e.OUtil.removeEventListener(window,"focus",r),e.OUtil.removeEventListener(window,"blur",i),e.OUtil.removeEventListener(window,"keydown",o),e.OUtil.removeEventListener(window,"keypress",a)))},n.prototype.getTabbableElements=function(){return this._tabbableElements},n}(e.InitializationHelper);e.WebInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(e,t){this._initializationHelper=e,this._scriptMessager=t}return t.prototype.read=function(e){this._initializationHelper.getAppContext(null,(function(t){if(e){var n=t.get_settingsFunc()();e(0,n)}}),(function(t){e&&e(5001,{})}))},t.prototype.write=function(t,n){var r={},i=[],o=[];for(var a in t)i.push(a),o.push(t[a]);r.keys=i,r.values=o;this._scriptMessager.invokeMethod(e.Webkit.MessageHandlerName,e.Webkit.MethodId.WriteSettings,r,(function(e){n&&n(e[0])}))},t}();e.WebkitClientSettingsManager=t}(OSF||(OSF={})),function(e){!function(t){t.MessageHandlerName="Agave",t.PopupMessageHandlerName="WefPopupHandler",function(e){e[e.Settings=0]="Settings",e[e.SolutionReferenceId=1]="SolutionReferenceId",e[e.AppType=2]="AppType",e[e.MajorVersion=3]="MajorVersion",e[e.MinorVersion=4]="MinorVersion",e[e.RevisionVersion=5]="RevisionVersion",e[e.APIVersionSequence=6]="APIVersionSequence",e[e.AppCapabilities=7]="AppCapabilities",e[e.APPUILocale=8]="APPUILocale",e[e.AppDataLocale=9]="AppDataLocale",e[e.BindingCount=10]="BindingCount",e[e.DocumentUrl=11]="DocumentUrl",e[e.ActivationMode=12]="ActivationMode",e[e.ControlIntegrationLevel=13]="ControlIntegrationLevel",e[e.SolutionToken=14]="SolutionToken",e[e.APISetVersion=15]="APISetVersion",e[e.CorrelationId=16]="CorrelationId",e[e.InstanceId=17]="InstanceId",e[e.TouchEnabled=18]="TouchEnabled",e[e.CommerceAllowed=19]="CommerceAllowed",e[e.RequirementMatrix=20]="RequirementMatrix",e[e.HostCustomMessage=21]="HostCustomMessage",e[e.HostFullVersion=22]="HostFullVersion",e[e.InitialDisplayMode=23]="InitialDisplayMode",e[e.FeatureGates=24]="FeatureGates",e[e.HostSettings=25]="HostSettings",e[e.OfficeThemeInfo=26]="OfficeThemeInfo"}(t.AppContextProperties||(t.AppContextProperties={})),function(e){e[e.Execute=1]="Execute",e[e.RegisterEvent=2]="RegisterEvent",e[e.UnregisterEvent=3]="UnregisterEvent",e[e.WriteSettings=4]="WriteSettings",e[e.GetContext=5]="GetContext",e[e.SendMessage=6]="SendMessage",e[e.MessageParent=7]="MessageParent",e[e.SendMessage2=8]="SendMessage2",e[e.MessageParent2=9]="MessageParent2",e[e.CloseSdxDialog=10]="CloseSdxDialog",e[e.ResizeSdxDialog=11]="ResizeSdxDialog"}(t.MethodId||(t.MethodId={}));var n=function(){function t(e){this.hostScriptProxy=e,this.useFullDialogAPI=!!window._enableFullDialogAPI,this.osfSupportsDialogOrigin=!!window._osfEnableDialogOrigin}return t.prototype.execute=function(t,n,r){var i={id:t,apiArgs:n};this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,e.Webkit.MethodId.Execute,i,(function(t){if(r){var n=[];if(e.OUtil.isArray(t))for(var i=0;i<t.length;i++){var o=t[i];e.OUtil.isArray(o)&&(o=new e.WebkitSafeArray(o)),n.unshift(o)}return r.apply(null,n)}}))},t.prototype.registerEvent=function(t,n,r,i,o){this.hostScriptProxy.registerEvent(e.Webkit.MessageHandlerName,e.Webkit.MethodId.RegisterEvent,t,r,(function(t){var n=t,r=0;e.OUtil.isArray(t)&&t.length>=2&&(n=t[0],r=t[1]),i&&i(r,new e.WebkitSafeArray(n))}),(function(t){if(o)return o(new e.WebkitSafeArray(t))}))},t.prototype.unregisterEvent=function(t,n,r,i){this.hostScriptProxy.unregisterEvent(e.Webkit.MessageHandlerName,e.Webkit.MethodId.UnregisterEvent,t,r,(function(t){return i(new e.WebkitSafeArray(t))}))},t.prototype.messageParent=function(t){var n,r;if(this.osfSupportsDialogOrigin&&t[e.ParameterNames.TargetOrigin]?(n=this.useFullDialogAPI?JSON.stringify(t):t[e.ParameterNames.MessageToParent],r=e.Webkit.MethodId.MessageParent2):(n=t[e.ParameterNames.MessageToParent],r=e.Webkit.MethodId.MessageParent),this.useFullDialogAPI)this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null);else{var i={dialogMessage:{messageType:0,messageContent:n}},o=r==e.Webkit.MethodId.MessageParent2?t[e.ParameterNames.TargetOrigin]:window.location.origin;window.opener.postMessage(JSON.stringify(i),o)}},t.prototype.openDialog=function(n,r,i,o,a){if(this.useFullDialogAPI)this.registerEvent(n,r,i,o,a);else if(!t.popup||t.popup.closed){t.OpenDialogCallback=void 0;var s=JSON.parse(i),c=s.url;if(c){var u=c.split("#"),l="?";u[0].indexOf("?")>-1&&(l="&");var f="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;u[0]=u[0].concat(l).concat("action=displayDialog");var p=u.join("#");t.popup=window.open(p,"",f),t.DialogEventListener=function(t){if(t.origin==window.location.origin)try{var r=JSON.parse(t.data);r.dialogMessage&&o(n,[0,r.dialogMessage.messageContent,t.origin])}catch(n){e.Utility.trace("messages received cannot be handlered. Message:"+t.data)}},t.OpenDialogCallback=function(e){0==e&&(window.addEventListener("message",t.DialogEventListener),t.interval=window.setInterval(d,1e3),t.NotifyError=function(e){o(n,[e])}),a(e)}}else a(12003)}else a(12007);function d(){try{(null==t.popup||t.popup.closed)&&(window.clearInterval(t.interval),window.removeEventListener("message",t.DialogEventListener),t.NotifyError=null,t.popup=null,o(n,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}},t.prototype.closeDialog=function(e,n,r,i){this.useFullDialogAPI?this.unregisterEvent(e,n,r,i):t.popup?(t.interval&&window.clearInterval(t.interval),t.popup.close(),t.popup=null,window.removeEventListener("message",t.DialogEventListener),t.NotifyError=null,i(0)):i(5001)},t.prototype.sendMessage=function(t){var n,r;this.osfSupportsDialogOrigin&&t[e.ParameterNames.TargetOrigin]?(n=JSON.stringify(t),r=e.Webkit.MethodId.SendMessage2):(n=t[e.ParameterNames.MessageContent],r=e.Webkit.MethodId.SendMessage,!isNaN(parseFloat(n))&&isFinite(n)&&(n=n.toString())),this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null)},t.prototype.closeSdxDialog=function(t){var n=[t],r=e.Webkit.MethodId.CloseSdxDialog;this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,r,n,null)},t.prototype.resizeSdxDialog=function(t,n){var r=[t,n],i=e.Webkit.MethodId.ResizeSdxDialog;this.hostScriptProxy.invokeMethod(e.Webkit.MessageHandlerName,i,r,null)},t}();t.WebkitHostController=n}(e.Webkit||(e.Webkit={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,i){var o=t.call(this,e,n,r,i)||this;return o.initializeWebkitMessaging(),o}return __extends(n,t),n.prototype.initializeWebkitMessaging=function(){e.ScriptMessaging=OSFWebkit.ScriptMessaging},n.prototype.getAppContext=function(t,n,r){var i,o=this;i=this._hostInfo.isDialog&&window.webkit.messageHandlers[e.Webkit.PopupMessageHandlerName]?e.Webkit.PopupMessageHandlerName:e.Webkit.MessageHandlerName,e.ScriptMessaging.GetScriptMessenger().invokeMethod(i,e.Webkit.MethodId.GetContext,[],(function(t){var r,i=e.Webkit.AppContextProperties,a=t[i.AppType],s=t[i.Settings];o._serializedSettings={};for(var c=s[0],u=s[1],l=0;l<c.length;l++)o._serializedSettings[c[l]]=u[l];var f=t[i.HostSettings];if(o._serializedHostSettings={},f){c=f[0],u=f[1];for(l=0;l<c.length;l++)o._serializedHostSettings[c[l]]=u[l]}var p=t[i.SolutionReferenceId],d=t[i.MajorVersion],h=t[i.MinorVersion],g=t[i.AppCapabilities],y=t[i.APPUILocale],m=t[i.AppDataLocale],_=t[i.DocumentUrl],v=t[i.ActivationMode],b=t[i.ControlIntegrationLevel],O=t[i.SolutionToken];O=O?O.toString():"";var I,S=t[i.CorrelationId],P=t[i.InstanceId],C=t[i.TouchEnabled],R=t[i.CommerceAllowed],A=t[i.RequirementMatrix],E=t[i.HostCustomMessage],w=t[i.HostFullVersion],x=t[i.InitialDisplayMode],N=t[i.FeatureGates];if(N)try{I=JSON.parse(N)}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception trying to parse FeatureGates."+t)}var T=null;if(t[i.OfficeThemeInfo])try{T=JSON.parse(t[i.OfficeThemeInfo])}catch(t){e.AppTelemetry&&e.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+t)}var j={};if(T){var k={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var F in T){var M=!1,D=F;k[F]&&(D=k[F].name,M=k[F].convertToHex),j[D]=M?e.OUtil.convertIntToCssHexColor(T[F]):T[F]}}r=new e.OfficeAppContext(p,a,d,y,m,_,g,(function(){return o._serializedSettings}),v,b,O,S,P,C,R,h,A,E,w,void 0,void 0,void 0,void 0,void 0,I,j,x,void 0,void 0,(function(){return o._serializedHostSettings}),!1,void 0,void 0),n(r)}))},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.Webkit.WebkitHostController(e.ScriptMessaging.GetScriptMessenger())),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this.createClientHostController())},n.prototype.createClientSettingsManager=function(){return new e.WebkitClientSettingsManager(this,e.ScriptMessaging.GetScriptMessenger())},n}(e.InitializationHelper);e.WebkitInitializationHelper=t}(OSF||(OSF={})),function(e){var t=function(){function t(e){this.data=e,this.safeArrayFlag=this.isSafeArray(e)}return t.prototype.dimensions=function(){var e=0;return this.safeArrayFlag?e=this.data[0][0]:this.isArray()&&(e=2),e},t.prototype.getItem=function(){var e=null;e=this.safeArrayFlag?this.toArray():this.data;for(var t=0;t<arguments.length;t++)e=e[arguments[t]];return e},t.prototype.lbound=function(e){return 0},t.prototype.ubound=function(t){var n=0;if(this.safeArrayFlag)n=this.data[0][t];else if(this.isArray()){if(1==t)return this.data.length;if(2==t){if(e.OUtil.isArray(this.data[0]))return this.data[0].length;if(null!=this.data[0])return 1}}return n},t.prototype.toArray=function(){if(0==this.isArray())return this.data;for(var e=[],n=this.safeArrayFlag?1:0;n<this.data.length;n++){var r=this.data[n];this.isSafeArray(r)?e.push(new t(r)):e.push(r)}return e},t.prototype.isArray=function(){return e.OUtil.isArray(this.data)},t.prototype.isSafeArray=function(t){var n=!1;if(e.OUtil.isArray(t)&&e.OUtil.isArray(t[0])){var r=t[0],i=r[0];if(r.length!=i+1)return!1;for(var o=1,a=1;a<r.length;a++){var s=r[a];if(0==isFinite(s))return!1;o*=s}n=++o==t.length}return n},t}();e.WebkitSafeArray=t}(OSF||(OSF={})),function(e){!function(e){var t=null;e.agaveHostCallback=function(e,n){t.agaveHostCallback(e,n)},e.agaveHostEventCallback=function(e,n){t.agaveHostEventCallback(e,n)},e.GetScriptMessenger=function(){return null==t&&(t=r.IsSupportedByHost()?new r:new i("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback")),t};var n=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},r=function(){function e(){this.eventHandlers=[]}return e.IsSupportedByHost=function(){return!!window._osfHostAPI},e.prototype.invokeMethod=function(e,t,n,r){window._osfHostAPI(e,this.constructMessagingArgs(t,n),(function(e){var t=r(e);return void 0===t||!0===t}))},e.prototype.registerEvent=function(e,t,n,r,i,o){var a={id:n,targetId:r},s=window._osfHostRegisterEvent(e,this.constructMessagingArgs(t,a),(function(e){return i(e),!1}),(function(e){return o(e),!0}));this.eventHandlers.push({targetId:r,dispId:n,callbackId:s.eventCallbackId})},e.prototype.unregisterEvent=function(e,t,n,r,i){var o={id:n,targetId:r};window._osfHostAPI(e,this.constructMessagingArgs(t,o),(function(e){return i(e),!0}));for(var a=this.eventHandlers.length-1;a>=0;a--){var s=this.eventHandlers[a];s.dispId===n&&s.targetId===r&&(this.eventHandlers.splice(a,1),window._osfHostUnregisterCallback(s.callbackId))}},e.prototype.agaveHostCallback=function(e,t){},e.prototype.agaveHostEventCallback=function(e,t){},e.prototype.constructMessagingArgs=function(e,t){return{params:t,methodId:e}},e}(),i=function(){function e(t,n){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=t,this.eventCallbackFunctionName=n,this.conversationId=e.getCurrentTimeMS().toString()}return e.prototype.invokeMethod=function(e,t,n,r){this.postWebkitMessage({},e,t,n,r)},e.prototype.registerEvent=function(e,t,r,i,o,a){var s={eventCallbackFunction:this.eventCallbackFunctionName},c={id:r,targetId:i},u=this.postWebkitMessage(s,e,t,c,a);this.eventHandlerList[u]=new n(r,i,o)},e.prototype.unregisterEvent=function(e,t,n,r,i){var o={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,o,i)},e.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},e.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},e.prototype.postWebkitMessage=function(t,n,r,i,o){t.methodId=r,t.params=i;var a="";o&&(a=this.generateCorrelationId(),this.callbackList[a]=o,t.callbackId=a,t.callbackFunction=this.asyncMethodCallbackFunctionName);var s=function(){window.webkit.messageHandlers[n].postMessage(JSON.stringify(t))},c=e.getCurrentTimeMS();return null==this.lastMessageTimestamp||c-this.lastMessageTimestamp>=e.MESSAGE_TIME_DELTA?(s(),this.lastMessageTimestamp=c):(this.lastMessageTimestamp+=e.MESSAGE_TIME_DELTA,setTimeout((function(){s()}),this.lastMessageTimestamp-c)),a},e.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},e.getCurrentTimeMS=function(){return(new Date).getTime()},e.MESSAGE_TIME_DELTA=10,e}()}(e.ScriptMessaging||(e.ScriptMessaging={}))}(OSFWebkit||(OSFWebkit={})),function(e){var t=function(){function t(e,t){this._initializationHelper=e,this._scriptMessager=t}return t.prototype.read=function(e){this._initializationHelper.getAppContext(null,(function(t){if(e){var n=t.get_settingsFunc()();e(0,n)}}),(function(t){e&&e(5001,{})}))},t.prototype.write=function(t,n){var r={},i=[],o=[];for(var a in t)i.push(a),o.push(t[a]);r.keys=i,r.values=o;this._scriptMessager.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.WriteSettings,r,(function(e){n&&n(e[0])}))},t}();e.WebViewClientSettingsManager=t}(OSF||(OSF={})),function(e){!function(t){t.MessageHandlerName="Agave",t.PopupMessageHandlerName="WefPopupHandler",function(e){e[e.Settings=0]="Settings",e[e.SolutionReferenceId=1]="SolutionReferenceId",e[e.AppType=2]="AppType",e[e.MajorVersion=3]="MajorVersion",e[e.MinorVersion=4]="MinorVersion",e[e.RevisionVersion=5]="RevisionVersion",e[e.APIVersionSequence=6]="APIVersionSequence",e[e.AppCapabilities=7]="AppCapabilities",e[e.APPUILocale=8]="APPUILocale",e[e.AppDataLocale=9]="AppDataLocale",e[e.BindingCount=10]="BindingCount",e[e.DocumentUrl=11]="DocumentUrl",e[e.ActivationMode=12]="ActivationMode",e[e.ControlIntegrationLevel=13]="ControlIntegrationLevel",e[e.SolutionToken=14]="SolutionToken",e[e.APISetVersion=15]="APISetVersion",e[e.CorrelationId=16]="CorrelationId",e[e.InstanceId=17]="InstanceId",e[e.TouchEnabled=18]="TouchEnabled",e[e.CommerceAllowed=19]="CommerceAllowed",e[e.RequirementMatrix=20]="RequirementMatrix",e[e.OfficeThemeInfo=21]="OfficeThemeInfo"}(t.AppContextProperties||(t.AppContextProperties={})),function(e){e[e.Execute=1]="Execute",e[e.RegisterEvent=2]="RegisterEvent",e[e.UnregisterEvent=3]="UnregisterEvent",e[e.WriteSettings=4]="WriteSettings",e[e.GetContext=5]="GetContext",e[e.OnKeydown=6]="OnKeydown",e[e.AddinInitialized=7]="AddinInitialized",e[e.OpenWindow=8]="OpenWindow",e[e.MessageParent=9]="MessageParent",e[e.SendMessage=10]="SendMessage"}(t.MethodId||(t.MethodId={}));var n=function(){function t(e){this.hostScriptProxy=e}return t.prototype.execute=function(t,n,r){var i=n;null==i&&(i=[]);var o={id:t,apiArgs:i};this.hostScriptProxy.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.Execute,o,(function(t){var n=t;if(e.OUtil.isArray(t)&&t.length>=2){t[0];n=t[1]}if(r)return r(new e.WebkitSafeArray(n))}))},t.prototype.registerEvent=function(t,n,r,i,o){this.hostScriptProxy.registerEvent(e.WebView.MessageHandlerName,e.WebView.MethodId.RegisterEvent,t,r,(function(t){var n=t,r=0;e.OUtil.isArray(t)&&t.length>=2&&(r=t[0],n=t[1]),i&&i(r,new e.WebkitSafeArray(n))}),(function(t){if(o)return o(new e.WebkitSafeArray(t))}))},t.prototype.unregisterEvent=function(t,n,r,i){this.hostScriptProxy.unregisterEvent(e.WebView.MessageHandlerName,e.WebView.MethodId.UnregisterEvent,t,r,(function(t){return i(new e.WebkitSafeArray(t))}))},t.prototype.messageParent=function(t){var n={dialogMessage:{messageType:0,messageContent:t[e.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(n),window.location.origin)},t.prototype.openDialog=function(n,r,i,o,a){var s=JSON.parse(i),c=s.url;if(c){var u=c.split("#"),l="?";c.indexOf("?")>-1&&(l="&");var f="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;u[0]=u[0].concat(l).concat("action=displayDialog");var p,d=u.join("#");t.popup=window.open(d,"",f),window.addEventListener("message",(function(r){if(r.source==t.popup)try{var i=JSON.parse(r.data);i.dialogMessage&&o(n,[0,i.dialogMessage.messageContent])}catch(t){e.Utility.trace("messages received cannot be handled. Message:"+r.data)}})),p=window.setInterval((function(){try{(null==t.popup||t.popup.closed)&&(window.clearInterval(p),o(n,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}),1e3),a(0)}},t.prototype.closeDialog=function(e,n,r,i){t.popup?(t.popup.close(),t.popup=null,i(0)):i(5001)},t.prototype.sendMessage=function(t){var n=t[e.ParameterNames.MessageContent];!isNaN(parseFloat(n))&&isFinite(n)&&(n=n.toString()),this.hostScriptProxy.invokeMethod(e.WebView.MessageHandlerName,e.WebView.MethodId.SendMessage,n,null)},t.prototype.closeSdxDialog=function(t){throw e.Utility.createNotImplementedException()},t.prototype.resizeSdxDialog=function(t,n){throw e.Utility.createNotImplementedException()},t}();t.WebViewHostController=n}(e.WebView||(e.WebView={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(e,n,r,i){var o=t.call(this,e,n,r,i)||this;return o.initializeWebViewMessaging(),o}return __extends(n,t),n.prototype.initializeWebViewMessaging=function(){e.ScriptMessaging=e.WebView.ScriptMessaging},n.prototype.getAppContext=function(t,n,r){var i,o=this;i=this._hostInfo.isDialog?e.WebView.PopupMessageHandlerName:e.WebView.MessageHandlerName,e.ScriptMessaging.GetScriptMessenger().invokeMethod(i,e.WebView.MethodId.GetContext,[],(function(t){var r,i=e.Webkit.AppContextProperties,a=t[i.AppType],s=t[i.Settings];o._serializedSettings={};for(var c=s[0],u=s[1],l=0;l<c.length;l++)o._serializedSettings[c[l]]=u[l];var f=t[i.SolutionReferenceId],p=t[i.MajorVersion],d=t[i.MinorVersion],h=t[i.AppCapabilities],g=t[i.APPUILocale],y=t[i.AppDataLocale],m=t[i.DocumentUrl],_=t[i.ActivationMode],v=t[i.ControlIntegrationLevel],b=t[i.SolutionToken];b=b?b.toString():"";var O=t[i.CorrelationId],I=t[i.InstanceId],S=t[i.TouchEnabled],P=t[i.CommerceAllowed],C=t[i.RequirementMatrix],R=t[i.HostCustomMessage],A=t[i.HostFullVersion],E=t[i.InitialDisplayMode];r=new e.OfficeAppContext(f,a,p,g,y,m,h,(function(){return o._serializedSettings}),_,v,b,O,I,S,P,d,C,R,A,void 0,void 0,void 0,void 0,void 0,void 0,void 0,E,void 0,void 0,void 0,!1,void 0,void 0),n(r)}))},n.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new e.WebView.WebViewHostController(e.ScriptMessaging.GetScriptMessenger())),this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new e.SafeArrayAsyncMethodExecutor(this.createClientHostController())},n.prototype.createClientSettingsManager=function(){return new e.WebViewClientSettingsManager(this,e.ScriptMessaging.GetScriptMessenger())},n}(e.InitializationHelper);e.WebViewInitializationHelper=t}(OSF||(OSF={})),function(e){var t;!function(e){!function(e){e[e.MethodCallback=0]="MethodCallback",e[e.EventCallback=1]="EventCallback"}(e.CallbackType||(e.CallbackType={}));var t=function(e,t,n){this.callbackType=e,this.callbackId=t,this.params=n};e.CallbackData=t}(t||(t={})),function(n){var r=function(){function n(){}return n.getInstance=function(){return null==n.uniqueInstance&&(n.uniqueInstance=new n),n.uniqueInstance},n.prototype.postMessage=function(e,t){agaveHost.postMessage(t)},n.prototype.ReceiveMessage=function(n){switch(n.callbackType){case t.CallbackType.MethodCallback:e.WebView.ScriptMessaging.agaveHostCallback(n.callbackId,n.params);break;case t.CallbackType.EventCallback:e.WebView.ScriptMessaging.agaveHostEventCallback(n.callbackId,n.params)}},n}();n.Poster=r}(e.Android||(e.Android={})),function(n){var r=function(){function n(){window.addEventListener("message",this.OnReceiveMessage.bind(this))}return n.prototype.postMessage=function(e,t){window.parent.postMessage(t,"*")},n.prototype.OnReceiveMessage=function(n){if(n.source==window.parent&&window.parent==window.top&&n.origin.startsWith("ms-appx-web://")){var r;try{r=JSON.parse(n.data)}catch(e){return}switch(r.callbackType){case t.CallbackType.MethodCallback:e.WebView.ScriptMessaging.agaveHostCallback(r.callbackId,JSON.parse(r.params));break;case t.CallbackType.EventCallback:e.WebView.ScriptMessaging.agaveHostEventCallback(r.callbackId,JSON.parse(r.params))}}},n}();n.Poster=r}(e.WinRT||(e.WinRT={}))}(OSF||(OSF={})),function(e){!function(t){!function(t){var n=null;t.agaveHostCallback=function(e,t){n.agaveHostCallback(e,t)},t.agaveHostEventCallback=function(e,t){n.agaveHostEventCallback(e,t)},t.GetScriptMessenger=function(){if(null==n){var t=e._OfficeAppFactory.getHostInfo().hostPlatform;if(t===e.HostInfoPlatform.android)n=new i("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback",e.Android.Poster.getInstance());else{if(t!==e.HostInfoPlatform.winrt)throw e.Utility.createNotImplementedException();n=new i("agaveHostCallback","agaveHostEventCallback",new e.WinRT.Poster)}}return n};var r=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},i=function(){function e(t,n,r){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=t,this.eventCallbackFunctionName=n,this.poster=r,this.conversationId=e.getCurrentTimeMS().toString()}return e.prototype.invokeMethod=function(e,t,n,r){this.postMessage({},e,t,n,r)},e.prototype.registerEvent=function(e,t,n,i,o,a){var s={eventCallbackFunction:this.eventCallbackFunctionName},c={id:n,targetId:i},u=this.postMessage(s,e,t,c,a);this.eventHandlerList[u]=new r(n,i,o)},e.prototype.unregisterEvent=function(e,t,n,r,i){var o={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,o,i)},e.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},e.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},e.prototype.postMessage=function(e,t,n,r,i){var o=this.generateCorrelationId();return this.callbackList[o]=i,e.methodId=n,e.params=r,e.callbackId=o,e.callbackFunction=this.asyncMethodCallbackFunctionName,this.poster.postMessage(t,JSON.stringify(e)),o},e.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},e.getCurrentTimeMS=function(){return(new Date).getTime()},e.MESSAGE_TIME_DELTA=10,e}()}(t.ScriptMessaging||(t.ScriptMessaging={}))}(e.WebView||(e.WebView={}))}(OSF||(OSF={})),function(e){var t=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.prototype.messageParent=function(t){if(e.Utility.externalNativeFunctionExists(typeof window.external.MessageParent2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageParent2(JSON.stringify(t),OsfOMToken):window.external.MessageParent2(JSON.stringify(t));else{var n=t[e.ParameterNames.MessageToParent];window.external.MessageParent(n)}},n.prototype.openDialog=function(e,t,n,r,i){this.registerEvent(e,t,n,r,i)},n.prototype.closeDialog=function(e,t,n,r){this.unregisterEvent(e,t,n,r)},n.prototype.sendMessage=function(t){if(e.Utility.externalNativeFunctionExists(typeof window.external.MessageChild2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageChild2(JSON.stringify(t),OsfOMToken):window.external.MessageChild2(JSON.stringify(t));else{var n=t[e.ParameterNames.MessageContent];window.external.MessageChild(n)}},n.prototype.closeSdxDialog=function(t){e.Utility.externalNativeFunctionExists(typeof window.external.closeSdxDialog)&&window.external.closeSdxDialog(t)},n.prototype.resizeSdxDialog=function(t,n){e.Utility.externalNativeFunctionExists(typeof window.external.resizeSdxDialog)&&window.external.resizeSdxDialog(t,n)},n}(e.RichClientHostController);e.Win32RichClientHostController=t}(OSF||(OSF={})),function(e){var t=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.prototype.openDialog=function(t,r,i,o,a){if(!n.popup||n.popup.closed){window.dialogAPIErrorCode=void 0;var s=JSON.parse(i),c=s.url;if(c){var u=c.split("#"),l="?";u[0].indexOf("?")>-1&&(l="&");var f="width="+screen.width*s.width/100+", height="+screen.height*s.height/100;u[0]=u[0].concat(l).concat("action=displayDialog");var p=u.join("#");if(n.popup=window.open(p,"",f),n.DialogEventListener=function(r){if(r.source==n.popup)try{var i=JSON.parse(r.data);i.dialogMessage&&o(t,[0,i.dialogMessage.messageContent])}catch(t){e.Utility.trace("messages received cannot be handlered. Message:"+r.data)}},null!=n.popup&&null==window.dialogAPIErrorCode)window.addEventListener("message",n.DialogEventListener),n.interval=window.setInterval((function(){try{(null==n.popup||n.popup.closed)&&(window.clearInterval(n.interval),window.removeEventListener("message",n.DialogEventListener),n.NotifyError=null,o(t,[12006]))}catch(t){e.Utility.trace("Error happened when popup window closed.")}}),500),n.NotifyError=function(e){o(t,[e])},a(0);else{var d=5001;window.dialogAPIErrorCode&&(d=window.dialogAPIErrorCode),a(d)}}else a(12003)}else a(12007)},n.prototype.messageParent=function(t){var n={dialogMessage:{messageType:0,messageContent:t[e.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(n),window.location.origin)},n.prototype.closeDialog=function(e,t,r,i){n.popup?(n.interval&&window.clearInterval(n.interval),n.popup.close(),n.popup=null,window.removeEventListener("message",n.DialogEventListener),n.NotifyError=null,i(0)):i(5001)},n}(e.Webkit.WebkitHostController);e.MacRichClientHostController=t}(OSF||(OSF={})),function(e){var t;!function(e){!function(e){e.Init=function(){return function(){"use strict";function e(e){return"function"==typeof e}var t,n=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},r=0,i=function(e,n){p[r]=e,p[r+1]=n,2===(r+=2)&&(t?t(d):c())};var o=("undefined"!=typeof window?window:void 0)||{},a=(o.MutationObserver||o.WebKitMutationObserver,"undefined"!=typeof process&&"[object process]"==={}.toString.call(process)),s="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;var c,u,l,f,p=new Array(1e3);function d(){for(var e=0;e<r;e+=2){(0,p[e])(p[e+1]),p[e]=void 0,p[e+1]=void 0}r=0}function h(){}a?(l=process.nextTick,f=process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/),Array.isArray(f)&&"0"===f[1]&&"10"===f[2]&&(l=setImmediate),c=function(){l(d)}):s?((u=new MessageChannel).port1.onmessage=d,c=function(){u.port2.postMessage(0)}):c=function(){setTimeout(d,1)};var g=void 0,y=new P;function m(t,n){if(n.constructor===t.constructor)!function(e,t){1===t._state?b(e,t._result):2===t._state?O(e,t._result):I(t,void 0,(function(t){_(e,t)}),(function(t){O(e,t)}))}(t,n);else{var r=function(e){try{return e.then}catch(e){return y.error=e,y}}(n);r===y?O(t,y.error):void 0===r?b(t,n):e(r)?function(e,t,n){i((function(e){var r=!1,i=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(n,t,(function(n){r||(r=!0,t!==n?_(e,n):b(e,n))}),(function(t){r||(r=!0,O(e,t))}),e._label);!r&&i&&(r=!0,O(e,i))}),e)}(t,n,r):b(t,n)}}function _(e,t){var n;e===t?O(e,new TypeError("You cannot resolve a promise with itself")):"function"==typeof(n=t)||"object"==typeof n&&null!==n?m(e,t):b(e,t)}function v(e){e._onerror&&e._onerror(e._result),S(e)}function b(e,t){e._state===g&&(e._result=t,e._state=1,0!==e._subscribers.length&&i(S,e))}function O(e,t){e._state===g&&(e._state=2,e._result=t,i(v,e))}function I(e,t,n,r){var o=e._subscribers,a=o.length;e._onerror=null,o[a]=t,o[a+1]=n,o[a+2]=r,0===a&&e._state&&i(S,e)}function S(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,i,o=e._result,a=0;a<t.length;a+=3)r=t[a],i=t[a+n],r?R(n,r,i,o):i(o);e._subscribers.length=0}}function P(){this.error=null}var C=new P;function R(t,n,r,i){var o,a,s,c,u=e(r);if(u){if((o=function(e,t){try{return e(t)}catch(e){return C.error=e,C}}(r,i))===C?(c=!0,a=o.error,o=null):s=!0,n===o)return void O(n,new TypeError("A promises callback cannot return that same promise."))}else o=i,s=!0;n._state!==g||(u&&s?_(n,o):c?O(n,a):1===t?b(n,o):2===t&&O(n,o))}function A(e,t){var n=this;n._instanceConstructor=e,n.promise=new e(h),n._validateInput(t)?(n._input=t,n.length=t.length,n._remaining=t.length,n._init(),0===n.length?b(n.promise,n._result):(n.length=n.length||0,n._enumerate(),0===n._remaining&&b(n.promise,n._result))):O(n.promise,n._validationError())}A.prototype._validateInput=function(e){return n(e)},A.prototype._validationError=function(){return new Error("Array Methods must be provided an Array")},A.prototype._init=function(){this._result=new Array(this.length)};var E=A;A.prototype._enumerate=function(){for(var e=this,t=e.length,n=e.promise,r=e._input,i=0;n._state===g&&i<t;i++)e._eachEntry(r[i],i)},A.prototype._eachEntry=function(e,t){var n,r=this,i=r._instanceConstructor;"object"==typeof(n=e)&&null!==n?e.constructor===i&&e._state!==g?(e._onerror=null,r._settledAt(e._state,t,e._result)):r._willSettleAt(i.resolve(e),t):(r._remaining--,r._result[t]=e)},A.prototype._settledAt=function(e,t,n){var r=this,i=r.promise;i._state===g&&(r._remaining--,2===e?O(i,n):r._result[t]=n),0===r._remaining&&b(i,r._result)},A.prototype._willSettleAt=function(e,t){var n=this;I(e,void 0,(function(e){n._settledAt(1,t,e)}),(function(e){n._settledAt(2,t,e)}))};var w=function(e){return new E(this,e).promise};var x=function(e){var t=new this(h);if(!n(e))return O(t,new TypeError("You must pass an array to race.")),t;var r=e.length;function i(e){_(t,e)}function o(e){O(t,e)}for(var a=0;t._state===g&&a<r;a++)I(this.resolve(e[a]),void 0,i,o);return t};var N=function(e){if(e&&"object"==typeof e&&e.constructor===this)return e;var t=new this(h);return _(t,e),t};var T=function(e){var t=new this(h);return O(t,e),t},j=0;var k=F;function F(t){this._id=j++,this._state=void 0,this._result=void 0,this._subscribers=[],h!==t&&(e(t)||function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof F||function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}(),function(e,t){try{t((function(t){_(e,t)}),(function(t){O(e,t)}))}catch(t){O(e,t)}}(this,t))}return F.all=w,F.race=x,F.resolve=N,F.reject=T,F._setScheduler=function(e){t=e},F._setAsap=function(e){i=e},F._asap=i,F.prototype={constructor:F,then:function(e,t){var n=this,r=n._state;if(1===r&&!e||2===r&&!t)return this;var o=new this.constructor(h),a=n._result;if(r){var s=arguments[r-1];i((function(){R(r,o,s,a)}))}else I(n,o,e,t);return o},catch:function(e){return this.then(null,e)}},k}.call(this)}}(e.PromiseImpl||(e.PromiseImpl={}))}(e._Internal||(e._Internal={})),function(e){e.OfficePromise=function(){if("undefined"==typeof window&&"function"==typeof Promise)return Promise;if("undefined"!=typeof window){if(window.Promise)return window.Promise;var t=e.PromiseImpl.Init();return window.Promise=t,t}}()}(t=e._Internal||(e._Internal={})),e.OfficePromise=t.OfficePromise,e.Promise=e.OfficePromise}(Office||(Office={})),function(e){!function(t){var n,r=e.OUtil.Guid.generateNewGuid(),i=new RegExp("^https?://store\\.office(ppe|-int)?\\.com/","i"),o=!1,a="PRIVATE";t.enableTelemetry=!0;var s=function(){};t.AppInfo=s;var c=function(){function t(){this.clientIDKey="Office API client",this.logIdSetKey="Office App Log Id Set"}return t.prototype.getClientId=function(){var t=this.getValue(this.clientIDKey);return(!t||t.length<=0||t.length>40)&&(t=e.OUtil.Guid.generateNewGuid(),this.setValue(this.clientIDKey,t)),t},t.prototype.getValue=function(t){var n=e.OUtil.getLocalStorage(),r="";return n&&(r=n.getItem(t)),r},t.prototype.setValue=function(t,n){var r=e.OUtil.getLocalStorage();r&&r.setItem(t,n)},t}();function u(e){return e&&(e=e.replace(/[{}]/g,"").toLowerCase()),e||""}function l(){n&&(o||OTel.OTelLogger.onTelemetryLoaded((function(){var e=[],t=n.isMos?1:0;e=e.concat([oteljs.makeStringDataField("Browser",n.browser),oteljs.makeInt64DataField("AppSizeWidth",window.innerWidth),oteljs.makeInt64DataField("AppSizeHeight",window.innerHeight),oteljs.makeInt64DataField("IsMOS",t)]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AppActivatedX",dataFields:e,eventFlags:{dataCategories:2,diagnosticLevel:110,samplingPolicy:191}})})))}function f(e,t){}function p(){var t=0!=(e._OfficeAppFactory.getHostInfo().flags&e.HostInfoFlags.PublicAddin);return t||!!n&&h(e._OfficeAppFactory.getHostInfo().hostPlatform,n.hostVersion)}function d(e,t){return p()||t!==e?t:a}function h(t,n){var r=!1,i=/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/.exec(n);if(i){var o=parseInt(i[1]),a=parseInt(i[2]),s=parseInt(i[3]);t==e.HostInfoPlatform.win32?(o<16||16==o&&s<14225)&&(r=!0):t==e.HostInfoPlatform.mac&&(o<16||16==o&&(a<52||52==a&&s<808))&&(r=!0)}return r}function g(){return 0!=(e._OfficeAppFactory.getHostInfo().flags&e.HostInfoFlags.IsMos)}t.initialize=function(l){if(t.enableTelemetry&&!n){n=new s,l.get_hostFullVersion()?n.hostVersion=l.get_hostFullVersion():n.hostVersion=l.get_appVersion(),n.appId=p()?l.get_id():a,n.marketplaceType=l._marketplaceType,n.host=""+l.get_appName(),n.browser=window.navigator.userAgent,n.correlationId=u(l.get_correlationId()),n.clientId=(new c).getClientId(),n.appInstanceId=l.get_appInstanceId(),n.appInstanceId&&(n.appInstanceId=u(n.appInstanceId),n.appInstanceId=d(l.get_id(),n.appInstanceId)),n.message=l.get_hostCustomMessage(),n.officeJSVersion=e.ConstantNames.FileVersion,n.hostJSVersion="NA",l._wacHostEnvironment&&(n.wacHostEnvironment=l._wacHostEnvironment);var f=l.get_isFromWacAutomation();null!=f&&(n.isFromWacAutomation=f.toString().toLowerCase());var h=l.get_docUrl();n.docUrl=i.test(h)?h:"";var y=location.href;y&&(n.isPreload=-1!==y.indexOf("preload=1"),y=y.split("?")[0].split("#")[0]),n.isMos=g(),function(t,n){n.assetId="",n.userId="";try{if(!e.Utility.isNullOrEmpty(t)){var r=decodeURIComponent(t),i=new DOMParser,o=void 0;if(e.LoadScriptHelper.trustedTypesOptIn()&&window.trustedTypes&&window.trustedTypes.createPolicy)o=window.trustedTypes.createPolicy("officejs-domparser",{createHTML:function(e){return e}}).createHTML(r);else o=r;var a=i.parseFromString(o,"text/xml"),s=a.getElementsByTagName("t")[0].attributes.getNamedItem("cid"),c=a.getElementsByTagName("t")[0].attributes.getNamedItem("oid");s&&s.nodeValue?n.userId=s.nodeValue:c&&c.nodeValue&&(n.userId=c.nodeValue),n.assetId=a.getElementsByTagName("t")[0].attributes.getNamedItem("aid").nodeValue}}catch(e){}}(l.get_eToken(),n),n.sessionId=r,OTel.OTelLogger.initialize(n),n.isPreload?o=!0:t.onAppActivated()}},t.onAppActivated=l,t.onScriptDone=function(e,t,n,r){},t.onCallDone=function(e,t,n,r,i){},t.onMethodDone=function(e,t,n,r){},t.onPropertyDone=function(t,n){e.AppTelemetry.onCallDone("property",-1,t,n,0)},t.onCheckWACHost=function(e,t,n,r,i){},t.onEventDone=function(t,n){e.AppTelemetry.onCallDone("event",t,null,0,n)},t.onRegisterDone=function(t,n,r,i){e.AppTelemetry.onCallDone(t?"registerevent":"unregisterevent",n,null,r,i)},t.onAppClosed=function(e,t){},t.setOsfControlAppCorrelationId=function(e){u(e)},t.doAppInitializationLogging=f,t.logAppCommonMessage=function(e){},t.logAppException=function(e){},t.CallOnAppActivatedIfPending=function(){o&&(o=!1,l())},t.canSendAddinId=p,t.getCompliantAppInstanceId=d,t._isComplianceExceptedHost=h,t.isMos=g}(e.AppTelemetry||(e.AppTelemetry={}))}(OSF||(OSF={})),function(e){var t=function(){function t(){}return t.loaded=function(){return!(void 0===t.logger)},t.create=function(t){var n,r={id:t.appId,marketplaceType:t.marketplaceType,assetId:t.assetId,officeJsVersion:t.officeJSVersion,hostJsVersion:t.hostJSVersion,browserToken:t.clientId,instanceId:t.appInstanceId,sessionId:t.sessionId},i=oteljs.Contracts.Office.System.SDX.getFields("SDX",r);if("web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform)n=new e.SdxWacSink;else{if(!Office.context.requirements.isSetSupported("Telemetry","1.2"))return console.error("Cannot create telemetry sink successfully"),null;n=new e.RichApiSink,this.richApiSink=n}var o=new oteljs.SimpleTelemetryLogger(void 0,i);return o.addSink(n),o.setTenantToken("Office.Extensibility.OfficeJs","db334b301e7b474db5e0f02f07c51a47-a1b5bc36-1bbe-482f-a64a-c2d9cb606706-7439",1755),oteljs.onNotification().addListener((function(e){OSF.Utility.debugLog(e.message())})),o},t.checkAndResolvePromises=function(){t.loaded()&&(t.promises.forEach((function(e){e()})),t.promises=[])},t.initialize=function(e){t.Enabled?Office.onReadyInternal().then((function(){t.loaded()||(OSF.Utility.debugLog("Creating OTelLogger"),t.logger=t.create(e),t.checkAndResolvePromises())})):t.promises=[]},t.sendTelemetryEvent=function(e){t.onTelemetryLoaded((function(){try{t.logger.sendTelemetryEvent(e),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}}))},t.sendNonStandardEvent=function(e,n){t.onTelemetryLoaded((function(){try{t.logger.sendNonStandardEvent(e,n),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}}))},t.flushTelemetryQueue=function(){var e=this;return new Office.Promise((function(n){t.onTelemetryLoaded((function(){e.richApiSink?e.richApiSink.flushTelemetryQueue().then((function(){n()})):n()}))}))},t.onTelemetryLoaded=function(e){t.Enabled&&(t.loaded()?e():t.promises.push(e))},t.promises=[],t.Enabled=!0,t}();e.OTelLogger=t}(OTel||(OTel={})),function(e){var t=function(){function e(){var e=this;this._requestIsPending=!0,this._telemetryQueue=[],this.pause(1e3).then((function(){var t=e._telemetryQueue;e._telemetryQueue=[],e._requestIsPending=!1,e.processTelemetryEvents(t)}))}return e.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push([e,1]),this._requestIsPending||this.processWorkBacklog()},e.prototype.sendNonStandardEvent=function(e,t){this._telemetryQueue.push([e,t]),this._requestIsPending||this.processWorkBacklog()},e.prototype.flushTelemetryQueue=function(){var e=this;return new Office.Promise((function(t){var n=e._telemetryQueue;e._telemetryQueue=[],e.processTelemetryEvents(n).then((function(){t()}))}))},e.prototype.processWorkBacklog=function(){var e=this;this._requestIsPending=!0;var t=this._telemetryQueue;this._telemetryQueue=[],this.processTelemetryEvents(t).then(this.waitAndProcessMore.bind(this)).catch((function(t){oteljs.logError(1,"RichApiSink Error",t),e.waitAndProcessMore.bind(e)()}))},e.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then((function(){e._telemetryQueue.length>0&&setTimeout((function(){return e.processWorkBacklog()}),0),e._requestIsPending=!1})).catch((function(){}))},e.prototype.processTelemetryEvents=function(e){var t=this,n=new OfficeCore.RequestContext;return e.forEach((function(e){var r=e[0],i=e[1];if(r.telemetryProperties){var o=[];t.addDataFields(o,r.dataFields);var a=r.eventContract?r.eventContract.name:"";r.eventContract&&t.addDataFields(o,r.eventContract.dataFields),1===i?n.telemetry.sendTelemetryEvent(r.telemetryProperties,r.eventName,a,oteljs.getEffectiveEventFlags(r),o):n.telemetry.sendNonStandardEvent(r.telemetryProperties,r.eventName,a,oteljs.getEffectiveEventFlags(r),o,i)}})),n.sync().catch((function(){oteljs.logNotification(2,1,(function(){return"RichApi telemetry call failed."}))}))},e.prototype.addDataFields=function(e,t){t&&t.forEach((function(t){e.push({name:t.name,value:t.value,classification:t.classification?t.classification:4,type:t.dataType})}))},e.prototype.pause=function(e){return new Office.Promise((function(t){return setTimeout(t,e)}))},e}();e.RichApiSink=t}(OTel||(OTel={})),function(e){var t=function(){function e(){}return e.prototype.sendTelemetryEvent=function(e,t){try{if(e.dataFields&&e.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t})).length>0)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},e.prototype.sendNonStandardEvent=function(e,t){try{if(1===t)throw new Error("Please call sendTelemetryEvent for events of type "+t);if(e.dataFields&&e.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t&&2048!==t})).length>0)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendNonStandardEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},e}();e.SdxWacSink=t}(OTel||(OTel={})),function(e){var t,n=[];function r(e,t,n){OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionRequest",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeStringDataField("methodPath",t),oteljs.makeStringDataField("params",n)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}function i(e,t,n){OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionResponse",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeBooleanDataField("isSuccessful",t),oteljs.makeStringDataField("error",n?JSON.stringify({name:n.name,code:n.code,message:n.message}):void 0)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}try{for(var o=0,a=function(e){var t=Navigator.prototype[e];t&&(Navigator.prototype[e]=function(n,a,s){if(3===arguments.length&&Function.prototype.isPrototypeOf(a)&&Function.prototype.isPrototypeOf(s)){var c=(o++).toString();return r(c,"Navigator.prototype."+e,JSON.stringify([{audio:!!n.audio,video:!!n.video}])),t.apply(this,[n,function(){return i(c,!0),a.apply(this,arguments)},function(){return i(c,!1,arguments[0]),s.apply(this,arguments)}])}return t.apply(this,arguments)},n.push("Navigator.prototype."+e))},s=0,c=["getUserMedia","webkitGetUserMedia","mozGetUserMedia"];s<c.length;s++){a(c[s])}var u=MediaDevices.prototype.getUserMedia;u&&(MediaDevices.prototype.getUserMedia=function(e){var t=(o++).toString();return 1===arguments.length&&void 0!==e?(r(t,"MediaDevices.prototype.getUserMedia",JSON.stringify([{audio:!!e.audio,video:!!e.video}])),u.apply(this,arguments).then((function(){return i(t,!0),arguments[0]}),(function(){throw i(t,!1,arguments[0]),arguments[0]}))):u.apply(this,arguments)},n.push("MediaDevices.prototype.getUserMedia"));for(var l=function(e){var t=Geolocation.prototype[e];t&&(Geolocation.prototype[e]=function(n,a,s){for(var c=[],u=3;u<arguments.length;u++)c[u-3]=arguments[u];var l=(o++).toString(),f=!1;r(l,"Geolocation.prototype."+e,JSON.stringify([]));var p=Function.prototype.isPrototypeOf(n)?function(){return f||(i(l,!0),f=!0),n.apply(this,arguments)}:n,d=Function.prototype.isPrototypeOf(a)?function(){return f||(i(l,!1,arguments[0]),f=!0),a.apply(this,arguments)}:a;return t.apply(this,[p,d,s].concat(c))},n.push("Geolocation.prototype."+e))},f=0,p=["getCurrentPosition","watchPosition"];f<p.length;f++){l(p[f])}}catch(e){t=e.toString()}OTel.OTelLogger.onTelemetryLoaded((function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionHookInstall",dataFields:[oteljs.makeStringDataField("hooksInstalled",JSON.stringify(n)),oteljs.makeStringDataField("error",t)],eventFlags:{dataCategories:2,diagnosticLevel:110}})}))}(Office||(Office={})),function(e){!function(e){!function(e){e.FeatureGates={},e.EventType=OSF.EventType,e.sendTelemetryEvent=function(e){OTel.OTelLogger.sendTelemetryEvent(e)},e.sendNonStandardEvent=function(e,t){OTel.OTelLogger.sendNonStandardEvent(e,t)},e.flushTelemetryQueue=function(){return OTel.OTelLogger.flushTelemetryQueue()},e.telemetrySink=OTel.OTelLogger}(e.WebExtension||(e.WebExtension={}))}(e.Office||(e.Office={}))}(Microsoft||(Microsoft={})),function(e){e.sendTelemetryEvent=function(e){Microsoft.Office.WebExtension.sendTelemetryEvent(e)},e.sendNonStandardEvent=function(e,t){Microsoft.Office.WebExtension.sendNonStandardEvent(e,t)},e.flushTelemetryQueue=function(){return Microsoft.Office.WebExtension.flushTelemetryQueue()},e.telemetrySink=Microsoft.Office.WebExtension.telemetrySink,e.isTrustedHost=function(){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(i){switch(i.label){case 0:return i.trys.push([0,6,,7]),OSF._OfficeAppFactory.getHostInfo().hostPlatform===OSF.HostInfoPlatform.web?[3,2]:[4,e.onReady()];case 1:return i.sent(),[2,!0];case 2:return null!=(t=OSF._OfficeAppFactory.getWebAppState().clientEndPoint)&&t.fHostTrusted||null!=document.referrer&&(n=OSF.OUtil.parseUrl(document.referrer,!1),"https:"==n.protocol&&OSF.XdmCommunicationManager.isHostNameValidWacDomain(n.hostname)&&!new RegExp("^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$").test(n.hostname))?[2,!0]:null==t?[3,4]:[4,OSF.Utility.promisify((function(e){t.invoke("ContextActivationManager_getAppContextAsync",e,OSF._OfficeAppFactory.getWebAppState().id)}),1e4)];case 3:return i.sent(),[2,!0];case 4:return[2,!1];case 5:return[3,7];case 6:return r=i.sent(),OSF.AppTelemetry&&OSF.AppTelemetry.logAppException("Exception happens at Office.isTrustedHost."+r),[2,!1];case 7:return[2]}}))}))},Microsoft.Office.WebExtension.onReadyInternal=e.onReadyInternal}(Office||(Office={}));var OfficeExtension;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){var t;!function(e){e.graph="graph",e.wfe="wfe"}(t=e.RemoteEndpointType||(e.RemoteEndpointType={}));var n=function(){function e(){}return e.prototype._resolveRequestUrlAndHeaderInfo=function(){return l._createPromiseFromResult(null)},e.prototype._createRequestExecutorOrNull=function(){return null},e.prototype.getEventRegistration=function(e){return null},e}();e.SessionBase=n;var r=function(){function e(){}return e.setCustomSendRequestFunc=function(t){e.s_customSendRequestFunc=t},e.xhrSendRequestFunc=function(e){return l.createPromise((function(t,n){var r=new XMLHttpRequest;if(r.open(e.method,e.url),r.onload=function(){var e={statusCode:r.status,headers:l._parseHttpResponseHeaders(r.getAllResponseHeaders()),body:r.responseText};t(e)},r.onerror=function(){n(new i.RuntimeError({code:a.connectionFailure,httpStatusCode:r.status,message:l._getResourceString(s.connectionFailureWithStatus,r.statusText)}))},e.headers)for(var o in e.headers)r.setRequestHeader(o,e.headers[o]);r.send(l._getRequestBodyText(e))}))},e.fetchSendRequestFunc=function(e){var t=l._getRequestBodyText(e);return""===t&&(t=void 0),fetch(e.url,{method:e.method,headers:e.headers,body:t}).then((function(e){return e.text().then((function(t){var n=e.status,r={};return e.headers.forEach((function(e,t){r[t]=e})),{statusCode:n,headers:r,body:t}}))}))},e.sendRequest=function(t){e.validateAndNormalizeRequest(t);var n=e.s_customSendRequestFunc;return n||(n="undefined"!=typeof fetch?e.fetchSendRequestFunc:e.xhrSendRequestFunc),n(t)},e.setCustomSendLocalDocumentRequestFunc=function(t){e.s_customSendLocalDocumentRequestFunc=t},e.sendLocalDocumentRequest=function(t){return e.validateAndNormalizeRequest(t),(e.s_customSendLocalDocumentRequestFunc||e.officeJsSendLocalDocumentRequestFunc)(t)},e.officeJsSendLocalDocumentRequestFunc=function(e){e=l._validateLocalDocumentRequest(e);var t=l._buildRequestMessageSafeArray(e);return l.createPromise((function(e,n){OSF.DDA.RichApi.executeRichApiRequestAsync(t,(function(t){var n;n="succeeded"==t.status?{statusCode:u.getResponseStatusCode(t),headers:u.getResponseHeaders(t),body:u.getResponseBody(t)}:u.buildHttpResponseFromOfficeJsError(t.error.code,t.error.message),l.log("Response:"),l.log(JSON.stringify(n)),e(n)}))}))},e.validateAndNormalizeRequest=function(e){if(l.isNullOrUndefined(e))throw i.RuntimeError._createInvalidArgError({argumentName:"request"});l.isNullOrEmptyString(e.method)&&(e.method="GET"),e.method=e.method.toUpperCase();var t=!1;if("object"==typeof e.headers&&e.headers[c.testRequestNameHeader]&&(t=!0),!t){var n=f._getCurrentTestNameWithSequenceId();n&&(e.headers||(e.headers={}),e.headers[c.testRequestNameHeader]=n)}},e.logRequest=function(t){if(l._logEnabled){if(l.log("---HTTP Request---"),l.log(t.method+" "+t.url),t.headers)for(var n in t.headers)l.log(n+": "+t.headers[n]);e._logBodyEnabled&&l.log(l._getRequestBodyText(t))}},e.logResponse=function(t){if(l._logEnabled){if(l.log("---HTTP Response---"),l.log(""+t.statusCode),t.headers)for(var n in t.headers)l.log(n+": "+t.headers[n]);e._logBodyEnabled&&l.log(t.body)}},e._logBodyEnabled=!1,e}();e.HttpUtility=r;var i,o=function(){function e(e){var t=this;this.m_bridge=e,this.m_promiseResolver={},this.m_handlers=[],this.m_bridge.onMessageFromHost=function(e){var n=JSON.parse(e);if(3==n.type){var r=n.message;if(r&&r.entries)for(var i=0;i<r.entries.length;i++){var o=r.entries[i];if(Array.isArray(o)){var a={messageCategory:o[0],messageType:o[1],targetId:o[2],message:o[3],id:o[4]};r.entries[i]=a}}}t.dispatchMessage(n)}}return e.init=function(t){if("object"==typeof t&&t){var n=new e(t);e.s_instance=n,r.setCustomSendLocalDocumentRequestFunc((function(t){t=l._validateLocalDocumentRequest(t);var r=0;l.isReadonlyRestRequest(t.method)||(r=1);var i=t.url.indexOf("?");if(i>=0){var o=t.url.substr(i+1),a=l._parseRequestFlagsAndCustomDataFromQueryStringIfAny(o);a.flags>=0&&(r=a.flags)}"string"==typeof t.body&&(t.body=JSON.parse(t.body));var s={id:e.nextId(),type:1,flags:r,message:t};return n.sendMessageToHostAndExpectResponse(s).then((function(e){return e.message}))}));for(var i=0;i<e.s_onInitedHandlers.length;i++)e.s_onInitedHandlers[i](n)}},Object.defineProperty(e,"instance",{get:function(){return e.s_instance},enumerable:!0,configurable:!0}),e.prototype.sendMessageToHost=function(e){this.m_bridge.sendMessageToHost(JSON.stringify(e))},e.prototype.sendMessageToHostAndExpectResponse=function(e){var t=this,n=l.createPromise((function(n,r){t.m_promiseResolver[e.id]=n}));return this.m_bridge.sendMessageToHost(JSON.stringify(e)),n},e.prototype.addHostMessageHandler=function(e){this.m_handlers.push(e)},e.prototype.removeHostMessageHandler=function(e){var t=this.m_handlers.indexOf(e);t>=0&&this.m_handlers.splice(t,1)},e.onInited=function(t){e.s_onInitedHandlers.push(t),e.s_instance&&t(e.s_instance)},e.prototype.dispatchMessage=function(e){if("number"==typeof e.id){var t=this.m_promiseResolver[e.id];if(t)return t(e),void delete this.m_promiseResolver[e.id]}for(var n=0;n<this.m_handlers.length;n++)this.m_handlers[n](e)},e.nextId=function(){return e.s_nextId++},e.s_onInitedHandlers=[],e.s_nextId=1,e}();e.HostBridge=o,"object"==typeof _richApiNativeBridge&&_richApiNativeBridge&&o.init(_richApiNativeBridge),function(e){var t=function(t){function n(e){var r=t.call(this,"string"==typeof e?e:e.message)||this;if(Object.setPrototypeOf(r,n.prototype),r.name="RichApi.Error","string"==typeof e?r.message=e:(r.code=e.code,r.message=e.message,r.traceMessages=e.traceMessages||[],r.innerError=e.innerError||null,r.debugInfo=r._createDebugInfo(e.debugInfo||{}),r.httpStatusCode=e.httpStatusCode,r.data=e.data),l.isNullOrUndefined(r.httpStatusCode)||200===r.httpStatusCode){var i={};i[a.accessDenied]=401,i[a.connectionFailure]=500,i[a.generalException]=500,i[a.invalidArgument]=400,i[a.invalidObjectPath]=400,i[a.invalidOrTimedOutSession]=408,i[a.invalidRequestContext]=400,i[a.timeout]=408,i[a.valueNotLoaded]=400,r.httpStatusCode=i[r.code]}return l.isNullOrUndefined(r.httpStatusCode)&&(r.httpStatusCode=500),r}return __extends(n,t),n.prototype.toString=function(){return this.code+": "+this.message},n.prototype._createDebugInfo=function(t){var n={code:this.code,message:this.message,toString:function(){return JSON.stringify(this)}};for(var r in t)n[r]=t[r];return this.innerError&&(this.innerError instanceof e.RuntimeError?n.innerError=this.innerError.debugInfo:n.innerError=this.innerError),n},n._createInvalidArgError=function(t){return new e.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l.isNullOrEmptyString(t.argumentName)?l._getResourceString(s.invalidArgumentGeneric):l._getResourceString(s.invalidArgument,t.argumentName),debugInfo:t.errorLocation?{errorLocation:t.errorLocation}:{},innerError:t.innerError})},n}(Error);e.RuntimeError=t}(i=e._Internal||(e._Internal={})),e.Error=i.RuntimeError;var a=function(){function e(){}return e.apiNotFound="ApiNotFound",e.accessDenied="AccessDenied",e.generalException="GeneralException",e.activityLimitReached="ActivityLimitReached",e.invalidArgument="InvalidArgument",e.connectionFailure="ConnectionFailure",e.timeout="Timeout",e.invalidOrTimedOutSession="InvalidOrTimedOutSession",e.invalidObjectPath="InvalidObjectPath",e.invalidRequestContext="InvalidRequestContext",e.valueNotLoaded="ValueNotLoaded",e.requestPayloadSizeLimitExceeded="RequestPayloadSizeLimitExceeded",e.responsePayloadSizeLimitExceeded="ResponsePayloadSizeLimitExceeded",e.writeNotSupportedWhenModalDialogOpen="WriteNotSupportedWhenModalDialogOpen",e.undoNotSupported="UndoNotSupported",e}();e.CoreErrorCodes=a;var s=function(){function e(){}return e.apiNotFoundDetails="ApiNotFoundDetails",e.connectionFailureWithStatus="ConnectionFailureWithStatus",e.connectionFailureWithDetails="ConnectionFailureWithDetails",e.invalidArgument="InvalidArgument",e.invalidArgumentGeneric="InvalidArgumentGeneric",e.timeout="Timeout",e.invalidOrTimedOutSessionMessage="InvalidOrTimedOutSessionMessage",e.invalidSheetName="InvalidSheetName",e.invalidObjectPath="InvalidObjectPath",e.invalidRequestContext="InvalidRequestContext",e.valueNotLoaded="ValueNotLoaded",e}();e.CoreResourceStrings=s;var c=function(){function e(){}return e.flags="flags",e.sourceLibHeader="SdkVersion",e.processQuery="ProcessQuery",e.localDocument="http://document.localhost/",e.localDocumentApiPrefix="http://document.localhost/_api/",e.customData="customdata",e.testRequestNameHeader="x-test-request-name",e}();e.CoreConstants=c;var u=function(){function e(){}return e.buildMessageArrayForIRequestExecutor=function(t,n,r,i){var o=JSON.stringify(r.Body);l.log("Request:"),l.log(o);var a={};return l._copyHeaders(r.Headers,a),a[c.sourceLibHeader]=i,e.buildRequestMessageSafeArray(t,n,"POST",c.processQuery,a,o)},e.buildResponseOnSuccess=function(e,t){var n={HttpStatusCode:200,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return n.Body=JSON.parse(e),n.Headers=t,n},e.buildResponseOnError=function(t,n){var r={HttpStatusCode:500,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return r.ErrorCode=a.generalException,r.ErrorMessage=n,t==e.OfficeJsErrorCode_ooeNoCapability?(r.ErrorCode=a.accessDenied,r.HttpStatusCode=401):t==e.OfficeJsErrorCode_ooeActivityLimitReached?(r.ErrorCode=a.activityLimitReached,r.HttpStatusCode=429):t==e.OfficeJsErrorCode_ooeInvalidOrTimedOutSession?(r.ErrorCode=a.invalidOrTimedOutSession,r.HttpStatusCode=408,r.ErrorMessage=l._getResourceString(s.invalidOrTimedOutSessionMessage)):t==e.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded?(r.ErrorCode=a.requestPayloadSizeLimitExceeded,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded?(r.ErrorCode=a.responsePayloadSizeLimitExceeded,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen?(r.ErrorCode=a.writeNotSupportedWhenModalDialogOpen,r.HttpStatusCode=400):t==e.OfficeJsErrorCode_ooeInvalidSheetName?(r.ErrorCode=a.invalidRequestContext,r.HttpStatusCode=400,r.ErrorMessage=l._getResourceString(s.invalidSheetName)):t==e.OfficeJsErrorCode_ooeUndoNotSupported&&(r.ErrorCode=a.undoNotSupported,r.HttpStatusCode=400),r},e.buildHttpResponseFromOfficeJsError=function(t,n){var r=500,i={error:{}};return i.error.code=a.generalException,i.error.message=n,t===e.OfficeJsErrorCode_ooeNoCapability?(r=403,i.error.code=a.accessDenied):t===e.OfficeJsErrorCode_ooeActivityLimitReached&&(r=429,i.error.code=a.activityLimitReached),{statusCode:r,headers:{},body:JSON.stringify(i)}},e.buildRequestMessageSafeArray=function(e,t,n,r,i,o){var a=[];if(i)for(var s in i)a.push(s),a.push(i[s]);return[e,n,r,a,o,0,t,"","","","","",""]},e.getResponseBody=function(t){return e.getResponseBodyFromSafeArray(t.value.data)},e.getResponseHeaders=function(t){return e.getResponseHeadersFromSafeArray(t.value.data)},e.getResponseBodyFromSafeArray=function(e){var t=e[2];return"string"==typeof t?t:t.join("")},e.getResponseHeadersFromSafeArray=function(e){var t=e[1];if(!t)return null;for(var n={},r=0;r<t.length-1;r+=2)n[t[r]]=t[r+1];return n},e.getResponseStatusCode=function(t){return e.getResponseStatusCodeFromSafeArray(t.value.data)},e.getResponseStatusCodeFromSafeArray=function(e){return e[0]},e.OfficeJsErrorCode_ooeInvalidOrTimedOutSession=5012,e.OfficeJsErrorCode_ooeActivityLimitReached=5102,e.OfficeJsErrorCode_ooeNoCapability=7e3,e.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded=5103,e.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded=5104,e.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen=5016,e.OfficeJsErrorCode_ooeInvalidSheetName=1014,e.OfficeJsErrorCode_ooeUndoNotSupported=5017,e}();e.RichApiMessageUtility=u,function(e){e.getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;if(void 0!==OfficeExtension&&OfficeExtension.Promise)return OfficeExtension.Promise;throw new e.Error("No Promise implementation found")}}(i=e._Internal||(e._Internal={}));var l=function(){function e(){}return e.log=function(t){e._logEnabled&&"undefined"!=typeof console&&console.log&&console.log(t)},e.checkArgumentNull=function(t,n){if(e.isNullOrUndefined(t))throw i.RuntimeError._createInvalidArgError({argumentName:n})},e.isNullOrUndefined=function(e){return null===e||void 0===e},e.isUndefined=function(e){return void 0===e},e.isNullOrEmptyString=function(e){return null===e||(void 0===e||0==e.length)},e.isPlainJsonObject=function(t){if(e.isNullOrUndefined(t))return!1;if("object"!=typeof t)return!1;if("[object Object]"!==Object.prototype.toString.apply(t))return!1;if(t.constructor&&!Object.prototype.hasOwnProperty.call(t,"constructor")&&!Object.prototype.hasOwnProperty.call(t.constructor.prototype,"hasOwnProperty"))return!1;for(var n in t)if(!Object.prototype.hasOwnProperty.call(t,n))return!1;return!0},e.trim=function(e){return e.replace(new RegExp("^\\s+|\\s+$","g"),"")},e.caseInsensitiveCompareString=function(t,n){return e.isNullOrUndefined(t)?e.isNullOrUndefined(n):!e.isNullOrUndefined(n)&&t.toUpperCase()==n.toUpperCase()},e.isReadonlyRestRequest=function(t){return e.caseInsensitiveCompareString(t,"GET")},e._getResourceString=function(t,n){var r;if("undefined"!=typeof window&&window.Strings&&window.Strings.OfficeOM){var i="L_"+t,o=window.Strings.OfficeOM[i];o&&(r=o)}if(r||(r=e.s_resourceStringValues[t]),r||(r=t),!e.isNullOrUndefined(n))if(Array.isArray(n)){var a=n;r=e._formatString(r,a)}else r=r.replace("{0}",n);return r},e._formatString=function(e,t){return e.replace(/\{\d\}/g,(function(e){var n=parseInt(e.substr(1,e.length-2));if(n<t.length)return t[n];throw i.RuntimeError._createInvalidArgError({argumentName:"format"})}))},Object.defineProperty(e,"Promise",{get:function(){return i.getPromiseType()},enumerable:!0,configurable:!0}),e.createPromise=function(t){return new e.Promise(t)},e._createPromiseFromResult=function(t){return e.createPromise((function(e,n){e(t)}))},e._createPromiseFromException=function(t){return e.createPromise((function(e,n){n(t)}))},e._createTimeoutPromise=function(t){return e.createPromise((function(e,n){setTimeout((function(){e(null)}),t)}))},e._createInvalidArgError=function(e){return i.RuntimeError._createInvalidArgError(e)},e._isLocalDocumentUrl=function(t){return e._getLocalDocumentUrlPrefixLength(t)>0},e._getLocalDocumentUrlPrefixLength=function(e){for(var t=["http://document.localhost","https://document.localhost","//document.localhost"],n=e.toLowerCase().trim(),r=0;r<t.length;r++){if(n===t[r])return t[r].length;if(n.substr(0,t[r].length+1)===t[r]+"/")return t[r].length+1}return 0},e._validateLocalDocumentRequest=function(t){var n=e._getLocalDocumentUrlPrefixLength(t.url);if(n<=0)throw i.RuntimeError._createInvalidArgError({argumentName:"request"});var r=t.url.substr(n),o=r.toLowerCase();return"_api"===o?r="":"_api/"===o.substr(0,"_api/".length)&&(r=r.substr("_api/".length)),{method:t.method,url:r,headers:t.headers,body:t.body}},e._parseRequestFlagsAndCustomDataFromQueryStringIfAny=function(e){for(var t={flags:-1,customData:""},n=e.split("&"),r=0;r<n.length;r++){var i=n[r].split("=");if(i[0].toLowerCase()===c.flags){var o=parseInt(i[1]);o&=32767,t.flags=o}else i[0].toLowerCase()===c.customData&&(t.customData=decodeURIComponent(i[1]))}return t},e._getRequestBodyText=function(e){var t="";return"string"==typeof e.body?t=e.body:e.body&&"object"==typeof e.body&&(t=JSON.stringify(e.body)),t},e._parseResponseBody=function(t){if("string"==typeof t.body){var n=e.trim(t.body);return JSON.parse(n)}return t.body},e._buildRequestMessageSafeArray=function(t){var n=0;e.isReadonlyRestRequest(t.method)||(n=1);var r="";if(t.url.substr(0,c.processQuery.length).toLowerCase()===c.processQuery.toLowerCase()){var i=t.url.indexOf("?");if(i>0){var o=t.url.substr(i+1),a=e._parseRequestFlagsAndCustomDataFromQueryStringIfAny(o);a.flags>=0&&(n=a.flags),r=a.customData}}return u.buildRequestMessageSafeArray(r,n,t.method,t.url,t.headers,e._getRequestBodyText(t))},e._parseHttpResponseHeaders=function(t){var n={};if(!e.isNullOrEmptyString(t))for(var r=new RegExp("\r?\n"),i=t.split(r),o=0;o<i.length;o++){var a=i[o];if(null!=a){var s=a.indexOf(":");if(s>0){var c=a.substr(0,s),u=a.substr(s+1);c=e.trim(c),u=e.trim(u),n[c.toUpperCase()]=u}}}return n},e._parseErrorResponse=function(t){var n=e._parseErrorResponseBody(t),r=t.statusCode.toString();if(e.isNullOrUndefined(n)||"object"!=typeof n||!n.error)return e._createDefaultErrorResponse(r);var i=n.error,o=i.innerError;return o&&o.code?e._createErrorResponse(o.code,r,o.message):i.code?e._createErrorResponse(i.code,r,i.message):e._createDefaultErrorResponse(r)},e._parseErrorResponseBody=function(t){if(e.isPlainJsonObject(t.body))return t.body;if(!e.isNullOrEmptyString(t.body)){var n=e.trim(t.body);try{return JSON.parse(n)}catch(t){e.log("Error when parse "+n)}}},e._createDefaultErrorResponse=function(t){return{errorCode:a.connectionFailure,errorMessage:e._getResourceString(s.connectionFailureWithStatus,t)}},e._createErrorResponse=function(t,n,r){return{errorCode:t,errorMessage:e._getResourceString(s.connectionFailureWithDetails,[n,t,r])}},e._copyHeaders=function(e,t){if(e&&t)for(var n in e)t[n]=e[n]},e.addResourceStringValues=function(t){for(var n in t)e.s_resourceStringValues[n]=t[n]},e._logEnabled=!1,e.s_resourceStringValues={ApiNotFoundDetails:"The method or property {0} is part of the {1} requirement set, which is not available in your version of {2}.",ConnectionFailureWithStatus:"The request failed with status code of {0}.",ConnectionFailureWithDetails:"The request failed with status code of {0}, error code {1} and the following error message: {2}",InvalidArgument:"The argument '{0}' doesn't work for this situation, is missing, or isn't in the right format.",InvalidObjectPath:'The object path \'{0}\' isn\'t working for what you\'re trying to do. If you\'re using the object across multiple "context.sync" calls and outside the sequential execution of a ".run" batch, please use the "context.trackedObjects.add()" and "context.trackedObjects.remove()" methods to manage the object\'s lifetime.',InvalidRequestContext:"Cannot use the object across different request contexts.",Timeout:"The operation has timed out.",ValueNotLoaded:'The value of the result object has not been loaded yet. Before reading the value property, call "context.sync()" on the associated request context.'},e}();e.CoreUtility=l;var f=function(){function e(){}return e.setMock=function(t){e.s_isMock=t},e.isMock=function(){return e.s_isMock},e._setCurrentTestName=function(t){e.s_currentTestName=t,e.s_currentTestSequenceId=0},e._getCurrentTestNameWithSequenceId=function(){return e.s_currentTestName?(e.s_currentTestSequenceId++,e.s_currentTestName+"."+e.s_currentTestSequenceId):null},e}();e.TestUtility=f,e._internalConfig={showDisposeInfoInDebugInfo:!1,showInternalApiInDebugInfo:!1,enableEarlyDispose:!0,alwaysPolyfillClientObjectUpdateMethod:!1,alwaysPolyfillClientObjectRetrieveMethod:!1,enableConcurrentFlag:!0,enableUndoableFlag:!0,appendTypeNameToObjectPathInfo:!1,enablePreviewExecution:!1},e.config={extendedErrorLogging:!1};var p=function(){function t(){}return t.createSetPropertyAction=function(t,n,r,i,o){S.validateObjectPath(n);var a={Id:t._nextId(),ActionType:4,Name:r,ObjectPathId:n._objectPath.objectPathInfo.Id,ArgumentInfo:{}},s=[i],c=S.setMethodArguments(t,a.ArgumentInfo,s);S.validateReferencedObjectPaths(c);var u=new h(a,0,o);if(u.referencedObjectPath=n._objectPath,u.referencedArgumentObjectPaths=c,e._internalConfig.enablePreviewExecution&&0!=(16&o)){var l={Id:t._nextId(),ActionType:4,Name:r,ObjectId:"",ObjectType:"",Arguments:[i]};n._addPreviewExecutionAction(l)}return n._addAction(u)},t.createQueryAction=function(e,t,n,r){S.validateObjectPath(t);var i={Id:e._nextId(),ActionType:2,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},o=new h(i,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o,r)},t.createQueryAsJsonAction=function(e,t,n,r){S.validateObjectPath(t);var i={Id:e._nextId(),ActionType:7,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},o=new h(i,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o,r)},t.createUpdateAction=function(e,t,n){S.validateObjectPath(t);var r={Id:e._nextId(),ActionType:9,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},i=new h(r,0,0);return i.referencedObjectPath=t._objectPath,t._addAction(i)},t}();e.CommonActionFactory=p;var d=function(){function t(e,t){this.m_contextBase=e,this.m_objectPath=t}return Object.defineProperty(t.prototype,"_objectPath",{get:function(){return this.m_objectPath},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_context",{get:function(){return this.m_contextBase},enumerable:!0,configurable:!0}),t.prototype._addAction=function(e,t){var n=this;return void 0===t&&(t=null),l.createPromise((function(r,i){n._context._addServiceApiAction(e,t,r,i)}))},t.prototype._addPreviewExecutionAction=function(e){},t.prototype._retrieve=function(t,n){var r=e._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;r||(r=!S.isSetSupported("RichApiRuntime","1.1"));var i=y._parseQueryOption(t);return r?p.createQueryAction(this._context,this,i,n):p.createQueryAsJsonAction(this._context,this,i,n)},t.prototype._recursivelyUpdate=function(t){var n=e._internalConfig.alwaysPolyfillClientObjectUpdateMethod;n||(n=!S.isSetSupported("RichApiRuntime","1.2"));try{var r=this[I.scalarPropertyNames];r||(r=[]);var o=this[I.scalarPropertyUpdateable];if(!o){o=[];for(var c=0;c<r.length;c++)o.push(!1)}var u=this[I.navigationPropertyNames];u||(u=[]);var f={},d={},h=0;for(var g in t){var y=r.indexOf(g);if(y>=0){if(!o[y])throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(P.attemptingToSetReadOnlyProperty,g),debugInfo:{errorLocation:g}});f[g]=t[g],++h}else{if(!(u.indexOf(g)>=0))throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(P.propertyDoesNotExist,g),debugInfo:{errorLocation:g}});d[g]=t[g]}}if(h>0)if(n)for(c=0;c<r.length;c++){var m=f[g=r[c]];S.isUndefined(m)||p.createSetPropertyAction(this._context,this,g,m)}else p.createUpdateAction(this._context,this,f);for(var g in d){var _=this[g],v=d[g];_._recursivelyUpdate(v)}}catch(e){throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(s.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".update"},innerError:e})}},t}();e.ClientObjectBase=d;var h=function(){function e(e,t,n){this.m_actionInfo=e,this.m_operationType=t,this.m_flags=n}return Object.defineProperty(e.prototype,"actionInfo",{get:function(){return this.m_actionInfo},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),e}();e.Action=h;var g=function(){function t(e,t,n,r,i,o){this.m_objectPathInfo=e,this.m_parentObjectPath=t,this.m_isCollection=n,this.m_isInvalidAfterRequest=r,this.m_isValid=!0,this.m_operationType=i,this.m_flags=o}return Object.defineProperty(t.prototype,"id",{get:function(){var e=this.m_objectPathInfo.ArgumentInfo;if(e){var t=e.Arguments;if(t)return t[0]}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parent",{get:function(){var e=this.m_parentObjectPath;if(e)return e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parentId",{get:function(){return this.parent?this.parent.id:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"objectPathInfo",{get:function(){return this.m_objectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isCollection",{get:function(){return this.m_isCollection},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isInvalidAfterRequest",{get:function(){return this.m_isInvalidAfterRequest},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"parentObjectPath",{get:function(){return this.m_parentObjectPath},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"argumentObjectPaths",{get:function(){return this.m_argumentObjectPaths},set:function(e){this.m_argumentObjectPaths=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isValid",{get:function(){return this.m_isValid},set:function(e){this.m_isValid=e,!e&&6===this.m_objectPathInfo.ObjectPathType&&this.m_savedObjectPathInfo&&(t.copyObjectPathInfo(this.m_savedObjectPathInfo.pathInfo,this.m_objectPathInfo),this.m_parentObjectPath=this.m_savedObjectPathInfo.parent,this.m_isValid=!0,this.m_savedObjectPathInfo=null)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"originalObjectPathInfo",{get:function(){return this.m_originalObjectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"getByIdMethodName",{get:function(){return this.m_getByIdMethodName},set:function(e){this.m_getByIdMethodName=e},enumerable:!0,configurable:!0}),t.prototype._updateAsNullObject=function(){this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=7,this.m_objectPathInfo.Name="",this.m_parentObjectPath=null},t.prototype.saveOriginalObjectPathInfo=function(){e.config.extendedErrorLogging&&!this.m_originalObjectPathInfo&&(this.m_originalObjectPathInfo={},t.copyObjectPathInfo(this.m_objectPathInfo,this.m_originalObjectPathInfo))},t.prototype.updateUsingObjectData=function(e,n){var r=e[I.referenceId];if(!l.isNullOrEmptyString(r)){if(!this.m_savedObjectPathInfo&&!this.isInvalidAfterRequest&&t.isRestorableObjectPath(this.m_objectPathInfo.ObjectPathType)){var i={};t.copyObjectPathInfo(this.m_objectPathInfo,i),this.m_savedObjectPathInfo={pathInfo:i,parent:this.m_parentObjectPath}}return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=6,this.m_objectPathInfo.Name=r,delete this.m_objectPathInfo.ParentObjectPathId,void(this.m_parentObjectPath=null)}if(n){var o=n[I.collectionPropertyPath];if(!l.isNullOrEmptyString(o)&&n.context){var a=S.tryGetObjectIdFromLoadOrRetrieveResult(e);if(!l.isNullOrUndefined(a)){for(var s=o.split("."),c=n.context[s[0]],u=1;u<s.length;u++)c=c[s[u]];return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_parentObjectPath=c._objectPath,this.m_objectPathInfo.ParentObjectPathId=this.m_parentObjectPath.objectPathInfo.Id,this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name="",void(this.m_objectPathInfo.ArgumentInfo.Arguments=[a])}}}var f=this.parentObjectPath&&this.parentObjectPath.isCollection,p=this.getByIdMethodName;if(f||!l.isNullOrEmptyString(p)){a=S.tryGetObjectIdFromLoadOrRetrieveResult(e);if(!l.isNullOrUndefined(a))return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),l.isNullOrEmptyString(p)?(this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name=""):(this.m_objectPathInfo.ObjectPathType=3,this.m_objectPathInfo.Name=p),void(this.m_objectPathInfo.ArgumentInfo.Arguments=[a])}},t.prototype.resetForUpdateUsingObjectData=function(){this.m_isInvalidAfterRequest=!1,this.m_isValid=!0,this.m_operationType=1,this.m_flags=4,this.m_objectPathInfo.ArgumentInfo={},this.m_argumentObjectPaths=null,this.m_getByIdMethodName=null},t.isRestorableObjectPath=function(e){return 1===e||5===e||3===e||4===e},t.copyObjectPathInfo=function(e,t){t.Id=e.Id,t.ArgumentInfo=e.ArgumentInfo,t.Name=e.Name,t.ObjectPathType=e.ObjectPathType,t.ParentObjectPathId=e.ParentObjectPathId},t}();e.ObjectPath=g;var y=function(){function e(){this.m_nextId=0}return e.prototype._nextId=function(){return++this.m_nextId},e.prototype._addServiceApiAction=function(e,t,n,r){this.m_serviceApiQueue||(this.m_serviceApiQueue=new b(this)),this.m_serviceApiQueue.add(e,t,n,r)},e._parseQueryOption=function(t){var n={};if("string"==typeof t){var r=t;n.Select=S._parseSelectExpand(r)}else if(Array.isArray(t))n.Select=t;else if("object"==typeof t){var o=t;if(e.isLoadOption(o)){if("string"==typeof o.select)n.Select=S._parseSelectExpand(o.select);else if(Array.isArray(o.select))n.Select=o.select;else if(!S.isNullOrUndefined(o.select))throw i.RuntimeError._createInvalidArgError({argumentName:"option.select"});if("string"==typeof o.expand)n.Expand=S._parseSelectExpand(o.expand);else if(Array.isArray(o.expand))n.Expand=o.expand;else if(!S.isNullOrUndefined(o.expand))throw i.RuntimeError._createInvalidArgError({argumentName:"option.expand"});if("number"==typeof o.top)n.Top=o.top;else if(!S.isNullOrUndefined(o.top))throw i.RuntimeError._createInvalidArgError({argumentName:"option.top"});if("number"==typeof o.skip)n.Skip=o.skip;else if(!S.isNullOrUndefined(o.skip))throw i.RuntimeError._createInvalidArgError({argumentName:"option.skip"})}else n=e.parseStrictLoadOption(t)}else if(!S.isNullOrUndefined(t))throw i.RuntimeError._createInvalidArgError({argumentName:"option"});return n},e.isLoadOption=function(e){if(!S.isUndefined(e.select)&&("string"==typeof e.select||Array.isArray(e.select)))return!0;if(!S.isUndefined(e.expand)&&("string"==typeof e.expand||Array.isArray(e.expand)))return!0;if(!S.isUndefined(e.top)&&"number"==typeof e.top)return!0;if(!S.isUndefined(e.skip)&&"number"==typeof e.skip)return!0;for(var t in e)return!1;return!0},e.parseStrictLoadOption=function(t){var n={Select:[]};return e.parseStrictLoadOptionHelper(n,"","option",t),n},e.combineQueryPath=function(e,t,n){return 0===e.length?t:e+n+t},e.parseStrictLoadOptionHelper=function(t,n,r,o){for(var a in o){var s=o[a];if("$all"===a){if("boolean"!=typeof s)throw i.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});s&&t.Select.push(e.combineQueryPath(n,"*","/"))}else if("$top"===a){if("number"!=typeof s||n.length>0)throw i.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});t.Top=s}else if("$skip"===a){if("number"!=typeof s||n.length>0)throw i.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});t.Skip=s}else if("boolean"==typeof s)s&&t.Select.push(e.combineQueryPath(n,a,"/"));else{if("object"!=typeof s)throw i.RuntimeError._createInvalidArgError({argumentName:e.combineQueryPath(r,a,".")});e.parseStrictLoadOptionHelper(t,e.combineQueryPath(n,a,"/"),e.combineQueryPath(r,a,"."),s)}}},e}();e.ClientRequestContextBase=y;var m=function(){function e(e){this.m_objectPath=e}return e.prototype._handleResult=function(e){l.isNullOrUndefined(e)?this.m_objectPath._updateAsNullObject():this.m_objectPath.updateUsingObjectData(e,null)},e}(),_=function(){function t(e){this.m_contextBase=e,this.m_actions=[],this.m_actionResultHandler={},this.m_referencedObjectPaths={},this.m_instantiatedObjectPaths={},this.m_preSyncPromises=[],this.m_previewExecutionActions=[]}return t.prototype.addAction=function(e){this.m_actions.push(e),1==e.actionInfo.ActionType&&(this.m_instantiatedObjectPaths[e.actionInfo.ObjectPathId]=e)},t.prototype.addPreviewExecutionAction=function(e){this.m_previewExecutionActions.push(e)},Object.defineProperty(t.prototype,"hasActions",{get:function(){return this.m_actions.length>0},enumerable:!0,configurable:!0}),t.prototype._getLastAction=function(){return this.m_actions[this.m_actions.length-1]},t.prototype.ensureInstantiateObjectPath=function(e){if(e){if(this.m_instantiatedObjectPaths[e.objectPathInfo.Id])return;if(this.ensureInstantiateObjectPath(e.parentObjectPath),this.ensureInstantiateObjectPaths(e.argumentObjectPaths),!this.m_instantiatedObjectPaths[e.objectPathInfo.Id]){var t={Id:this.m_contextBase._nextId(),ActionType:1,Name:"",ObjectPathId:e.objectPathInfo.Id},n=new h(t,1,4);n.referencedObjectPath=e,this.addReferencedObjectPath(e),this.addAction(n);var r=new m(e);this.addActionResultHandler(n,r)}}},t.prototype.ensureInstantiateObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.ensureInstantiateObjectPath(e[t])},t.prototype.addReferencedObjectPath=function(e){if(e&&!this.m_referencedObjectPaths[e.objectPathInfo.Id]){if(!e.isValid)throw new i.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:l._getResourceString(s.invalidObjectPath,S.getObjectPathExpression(e)),debugInfo:{errorLocation:S.getObjectPathExpression(e)}});for(;e;)this.m_referencedObjectPaths[e.objectPathInfo.Id]=e,3==e.objectPathInfo.ObjectPathType&&this.addReferencedObjectPaths(e.argumentObjectPaths),e=e.parentObjectPath}},t.prototype.addReferencedObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.addReferencedObjectPath(e[t])},t.prototype.addActionResultHandler=function(e,t){this.m_actionResultHandler[e.actionInfo.Id]=t},t.prototype.aggregrateRequestFlags=function(e,t,n){return 0===t&&(e|=1,0==(2&n)&&(e&=-17),0==(8&n)&&(e&=-257),e&=-5),1&n&&(e|=2),0==(4&n)&&(e&=-5),e},t.prototype.finallyNormalizeFlags=function(t){return 0==(1&t)&&(t&=-17,t&=-257),e._internalConfig.enableConcurrentFlag||(t&=-5),e._internalConfig.enableUndoableFlag||(t&=-17),S.isSetSupported("RichApiRuntimeFlag","1.1")||(t&=-5,t&=-17),S.isSetSupported("RichApiRuntimeFlag","1.2")||(t&=-257),"number"==typeof this.m_flagsForTesting&&(t=this.m_flagsForTesting),t},t.prototype.buildRequestMessageBodyAndRequestFlags=function(){e._internalConfig.enableEarlyDispose&&t._calculateLastUsedObjectPathIds(this.m_actions);var n=276,r={};for(var i in this.m_referencedObjectPaths)n=this.aggregrateRequestFlags(n,this.m_referencedObjectPaths[i].operationType,this.m_referencedObjectPaths[i].flags),r[i]=this.m_referencedObjectPaths[i].objectPathInfo;for(var o=[],a=!1,s=0;s<this.m_actions.length;s++){var c=this.m_actions[s];3===c.actionInfo.ActionType&&c.actionInfo.Name===I.keepReference&&(a=!0),n=this.aggregrateRequestFlags(n,c.operationType,c.flags),o.push(c.actionInfo)}n=this.finallyNormalizeFlags(n);var u={AutoKeepReference:this.m_contextBase._autoCleanup&&a,Actions:o,ObjectPaths:r};return this.m_previewExecutionActions.length>0&&(u.PreviewExecutionActions=this.m_previewExecutionActions,n|=4096),{body:u,flags:n}},t.prototype.processResponse=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t],r=this.m_actionResultHandler[n.ActionId];r&&r._handleResult(n.Value)}},t.prototype.invalidatePendingInvalidObjectPaths=function(){for(var e in this.m_referencedObjectPaths)this.m_referencedObjectPaths[e].isInvalidAfterRequest&&(this.m_referencedObjectPaths[e].isValid=!1)},t.prototype._addPreSyncPromise=function(e){this.m_preSyncPromises.push(e)},Object.defineProperty(t.prototype,"_preSyncPromises",{get:function(){return this.m_preSyncPromises},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_actions",{get:function(){return this.m_actions},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_objectPaths",{get:function(){return this.m_referencedObjectPaths},enumerable:!0,configurable:!0}),t.prototype._removeKeepReferenceAction=function(e){for(var t=this.m_actions.length-1;t>=0;t--){var n=this.m_actions[t].actionInfo;if(n.ObjectPathId===e&&3===n.ActionType&&n.Name===I.keepReference){this.m_actions.splice(t,1);break}}},t._updateLastUsedActionIdOfObjectPathId=function(e,n,r){for(;n;){if(e[n.objectPathInfo.Id])return;e[n.objectPathInfo.Id]=r;var i=n.argumentObjectPaths;if(i)for(var o=i.length,a=0;a<o;a++)t._updateLastUsedActionIdOfObjectPathId(e,i[a],r);n=n.parentObjectPath}},t._calculateLastUsedObjectPathIds=function(e){for(var n={},r=e.length,i=r-1;i>=0;--i){var o=(p=e[i]).actionInfo.Id;p.referencedObjectPath&&t._updateLastUsedActionIdOfObjectPathId(n,p.referencedObjectPath,o);var a=p.referencedArgumentObjectPaths;if(a)for(var s=a.length,c=0;c<s;c++)t._updateLastUsedActionIdOfObjectPathId(n,a[c],o)}var u={};for(var l in n){var f=u[o=n[l]];f||(f=[],u[o]=f),f.push(parseInt(l))}for(i=0;i<r;i++){var p,d=u[(p=e[i]).actionInfo.Id];d&&d.length>0?p.actionInfo.L=d:p.actionInfo.L&&delete p.actionInfo.L}},t}();e.ClientRequestBase=_;var v=function(){function e(e){this.m_type=e}return Object.defineProperty(e.prototype,"value",{get:function(){if(!this.m_isLoaded)throw new i.RuntimeError({code:a.valueNotLoaded,httpStatusCode:400,message:l._getResourceString(s.valueNotLoaded),debugInfo:{errorLocation:"clientResult.value"}});return this.m_value},enumerable:!0,configurable:!0}),e.prototype._handleResult=function(e){this.m_isLoaded=!0,"object"==typeof e&&e&&e._IsNull||(1===this.m_type?this.m_value=S.adjustToDateTime(e):this.m_value=e)},e}();e.ClientResult=v;var b=function(){function e(e){this.m_context=e,this.m_actions=[]}return e.prototype.add=function(e,t,n,r){var i=this;this.m_actions.push({action:e,resultHandler:t,resolve:n,reject:r}),1===this.m_actions.length&&setTimeout((function(){return i.processActions()}),0)},e.prototype.processActions=function(){var e=this;if(0!==this.m_actions.length){var t=this.m_actions;this.m_actions=[];for(var n=new _(this.m_context),r=0;r<t.length;r++){var i=t[r];n.ensureInstantiateObjectPath(i.action.referencedObjectPath),n.ensureInstantiateObjectPaths(i.action.referencedArgumentObjectPaths),n.addAction(i.action),n.addReferencedObjectPath(i.action.referencedObjectPath),n.addReferencedObjectPaths(i.action.referencedArgumentObjectPaths)}var o=n.buildRequestMessageBodyAndRequestFlags(),a=o.body,s=o.flags,u={Url:c.localDocumentApiPrefix,Headers:null,Body:a};l.log("Request:"),l.log(JSON.stringify(a)),(new O).executeAsync(this.m_context._customData,s,u).then((function(r){e.processResponse(n,t,r)})).catch((function(e){for(var n=0;n<t.length;n++){t[n].reject(e)}}))}},e.prototype.processResponse=function(e,t,n){var r=this.getErrorFromResponse(n),i=null;n.Body.Results?i=n.Body.Results:n.Body.ProcessedResults&&n.Body.ProcessedResults.Results&&(i=n.Body.ProcessedResults.Results),i||(i=[]),this.processActionResults(e,t,i,r)},e.prototype.getErrorFromResponse=function(e){return l.isNullOrEmptyString(e.ErrorCode)?e.Body&&e.Body.Error?new i.RuntimeError({code:e.Body.Error.Code,httpStatusCode:e.Body.Error.HttpStatusCode,message:e.Body.Error.Message}):null:new i.RuntimeError({code:e.ErrorCode,httpStatusCode:e.HttpStatusCode,message:e.ErrorMessage})},e.prototype.processActionResults=function(e,t,n,r){e.processResponse(n);for(var i=0;i<t.length;i++){for(var o=t[i],a=o.action.actionInfo.Id,s=!1,c=0;c<n.length;c++)if(a==n[c].ActionId){var u=n[c].Value;o.resultHandler&&(o.resultHandler._handleResult(u),u=o.resultHandler.value),o.resolve&&o.resolve(u),s=!0;break}!s&&o.reject&&(r?o.reject(r):o.reject("No response for the action."))}},e}(),O=function(){function e(){}return e.prototype.getRequestUrl=function(e,n,r){void 0===r&&(r=t.graph.toString());var i=c.flags+"="+n.toString();switch(r){case t.graph.toString():"/"!=e.charAt(e.length-1)&&(e+="/"),e=(e+=c.processQuery)+"?"+i;break;case t.wfe.toString():e=(e=e+"&"+i)+"&wdRestPart=_api/"+c.processQuery}return e},e.prototype.executeAsync=function(n,i,o){var a=o.Headers?o.Headers[I.remoteEndpointTypeHeaderKey]:t.graph.toString(),s={method:"POST",url:this.getRequestUrl(o.Url,i,a),headers:{},body:o.Body};if(s.headers[c.sourceLibHeader]=e.SourceLibHeaderValue,s.headers["CONTENT-TYPE"]="application/json",o.Headers)for(var u in o.Headers)s.headers[u]=o.Headers[u];return(l._isLocalDocumentUrl(s.url)?r.sendLocalDocumentRequest:r.sendRequest)(s).then((function(e){var t;if(200===e.statusCode)t={HttpStatusCode:e.statusCode,ErrorCode:null,ErrorMessage:null,Headers:e.headers,Body:l._parseResponseBody(e)};else{l.log("Error Response:"+e.body);var n=l._parseErrorResponse(e);t={HttpStatusCode:e.statusCode,ErrorCode:n.errorCode,ErrorMessage:n.errorMessage,Headers:e.headers,Body:null,RawErrorResponseBody:l._parseErrorResponseBody(e)}}return t}))},e.SourceLibHeaderValue="officejs-rest",e}();e.HttpRequestExecutor=O;var I=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.collectionPropertyPath="_collectionPropertyPath",t.id="Id",t.idLowerCase="id",t.idPrivate="_Id",t.keepReference="_KeepReference",t.objectPathIdPrivate="_ObjectPathId",t.referenceId="_ReferenceId",t.items="_Items",t.itemsLowerCase="items",t.scalarPropertyNames="_scalarPropertyNames",t.scalarPropertyOriginalNames="_scalarPropertyOriginalNames",t.navigationPropertyNames="_navigationPropertyNames",t.scalarPropertyUpdateable="_scalarPropertyUpdateable",t.previewExecutionObjectId="_previewExecutionObjectId",t.remoteEndpointTypeHeaderKey="X-EndpointType",t}(c);e.CommonConstants=I;var S=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.validateObjectPath=function(e){for(var n=e._objectPath;n;){if(!n.isValid)throw new i.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:l._getResourceString(s.invalidObjectPath,t.getObjectPathExpression(n)),debugInfo:{errorLocation:t.getObjectPathExpression(n)}});n=n.parentObjectPath}},t.validateReferencedObjectPaths=function(e){if(e)for(var n=0;n<e.length;n++)for(var r=e[n];r;){if(!r.isValid)throw new i.RuntimeError({code:a.invalidObjectPath,httpStatusCode:400,message:l._getResourceString(s.invalidObjectPath,t.getObjectPathExpression(r))});r=r.parentObjectPath}},t._toCamelLowerCase=function(e){if(l.isNullOrEmptyString(e))return e;for(var t=0;t<e.length&&e.charCodeAt(t)>=65&&e.charCodeAt(t)<=90;)t++;return t<e.length?e.substr(0,t).toLowerCase()+e.substr(t):e.toLowerCase()},t.adjustToDateTime=function(e){if(l.isNullOrUndefined(e))return null;if("string"==typeof e)return new Date(e);if(Array.isArray(e)){for(var n=e,r=0;r<n.length;r++)n[r]=t.adjustToDateTime(n[r]);return n}throw l._createInvalidArgError({argumentName:"date"})},t.tryGetObjectIdFromLoadOrRetrieveResult=function(e){var t=e[I.id];return l.isNullOrUndefined(t)&&(t=e[I.idLowerCase]),l.isNullOrUndefined(t)&&(t=e[I.idPrivate]),t},t.getObjectPathExpression=function(e){for(var n="";e;){switch(e.objectPathInfo.ObjectPathType){case 1:n=n;break;case 2:n="new()"+(n.length>0?".":"")+n;break;case 3:n=t.normalizeName(e.objectPathInfo.Name)+"()"+(n.length>0?".":"")+n;break;case 4:n=t.normalizeName(e.objectPathInfo.Name)+(n.length>0?".":"")+n;break;case 5:n="getItem()"+(n.length>0?".":"")+n;break;case 6:n="_reference()"+(n.length>0?".":"")+n}e=e.parentObjectPath}return n},t.setMethodArguments=function(e,n,r){if(l.isNullOrUndefined(r))return null;var i=new Array,o=new Array,a=t.collectObjectPathInfos(e,r,i,o);return n.Arguments=r,a&&(n.ReferencedObjectPathIds=o),i},t.validateContext=function(e,t){if(e&&t&&t._context!==e)throw new i.RuntimeError({code:a.invalidRequestContext,httpStatusCode:400,message:l._getResourceString(s.invalidRequestContext)})},t.isSetSupported=function(e,n){return"function"==typeof t.isSetSupportedOverride?t.isSetSupportedOverride(e,n):!("undefined"!=typeof window&&window.Office&&window.Office.context&&window.Office.context.requirements)||window.Office.context.requirements.isSetSupported(e,n)},t.throwIfApiNotSupported=function(e,n,r,o){if(t._doApiNotSupportedCheck&&!t.isSetSupported(n,r)){var c=l._getResourceString(s.apiNotFoundDetails,[e,n+" "+r,o]);throw new i.RuntimeError({code:a.apiNotFound,httpStatusCode:404,message:c,debugInfo:{errorLocation:e}})}},t.calculateApiFlags=function(e,n,r){var i=window&&window.location&&window.location.href&&-1!==window.location.href.indexOf("eed0a086-3498-4f91-a377-1e0265ecc0cc");return("function"==typeof t.isSetSupportedOverride?t.isSetSupportedOverride(n,r):!i&&t.isSetSupported(n,r))||(e&=-3),e},t._parseSelectExpand=function(e){var t=[];if(!l.isNullOrEmptyString(e))for(var n=e.split(","),r=0;r<n.length;r++){var i=n[r];(i=o(i.trim())).length>0&&t.push(i)}return t;function o(e){var t=e.toLowerCase();if("items"===t||"items/"===t)return"*";return("items/"===t.substr(0,6)||"items."===t.substr(0,6))&&(e=e.substr(6)),e.replace(new RegExp("[/.]items[/.]","gi"),"/")}},t.changePropertyNameToCamelLowerCase=function(e){if(Array.isArray(e)){for(var n=[],r=0;r<e.length;r++)n.push(this.changePropertyNameToCamelLowerCase(e[r]));return n}if("object"==typeof e&&null!==e){n={};for(var i in e){var o=e[i];if(i===I.items){(n={})[I.itemsLowerCase]=this.changePropertyNameToCamelLowerCase(o);break}n[t._toCamelLowerCase(i)]=this.changePropertyNameToCamelLowerCase(o)}return n}return e},t.purifyJson=function(e){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(this.purifyJson(e[n]));return t}if("object"==typeof e&&null!==e){t={};for(var r in e)if(95!==r.charCodeAt(0)){var i=e[r];"object"==typeof i&&null!==i&&Array.isArray(i.items)&&(i=i.items),t[r]=this.purifyJson(i)}return t}return e},t.collectObjectPathInfos=function(e,n,r,i){for(var o=!1,a=0;a<n.length;a++)if(n[a]instanceof d){var s=n[a];t.validateContext(e,s),n[a]=s._objectPath.objectPathInfo.Id,i.push(s._objectPath.objectPathInfo.Id),r.push(s._objectPath),o=!0}else if(Array.isArray(n[a])){var c=new Array;t.collectObjectPathInfos(e,n[a],r,c)?(i.push(c),o=!0):i.push(0)}else l.isPlainJsonObject(n[a])?(i.push(0),t.replaceClientObjectPropertiesWithObjectPathIds(n[a],r)):i.push(0);return o},t.replaceClientObjectPropertiesWithObjectPathIds=function(e,n){var r,i;for(var o in e){var a=e[o];if(a instanceof d)n.push(a._objectPath),e[o]=((r={})[I.objectPathIdPrivate]=a._objectPath.objectPathInfo.Id,r);else if(Array.isArray(a))for(var s=0;s<a.length;s++)if(a[s]instanceof d){var c=a[s];n.push(c._objectPath),a[s]=((i={})[I.objectPathIdPrivate]=c._objectPath.objectPathInfo.Id,i)}else l.isPlainJsonObject(a[s])&&t.replaceClientObjectPropertiesWithObjectPathIds(a[s],n);else l.isPlainJsonObject(a)&&t.replaceClientObjectPropertiesWithObjectPathIds(a,n)}},t.normalizeName=function(e){return e.substr(0,1).toLowerCase()+e.substr(1)},t._doApiNotSupportedCheck=!1,t}(l);e.CommonUtility=S;var P=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.propertyDoesNotExist="PropertyDoesNotExist",t.attemptingToSetReadOnlyProperty="AttemptingToSetReadOnlyProperty",t}(s);e.CommonResourceStrings=P;var C=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.propertyNotLoaded="PropertyNotLoaded",t.runMustReturnPromise="RunMustReturnPromise",t.cannotRegisterEvent="CannotRegisterEvent",t.invalidOrTimedOutSession="InvalidOrTimedOutSession",t.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",t}(a);e.ErrorCodes=C;var R=function(){function e(e){this.m_callback=e}return e.prototype._handleResult=function(e){this.m_callback&&this.m_callback()},e}(),A=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.createMethodAction=function(t,n,r,i,o,a){J.validateObjectPath(n);var s={Id:t._nextId(),ActionType:3,Name:r,ObjectPathId:n._objectPath.objectPathInfo.Id,ArgumentInfo:{}},c=J.setMethodArguments(t,s.ArgumentInfo,o);J.validateReferencedObjectPaths(c);var u=J._fixupApiFlags(a),l=new h(s,i,u);if(l.referencedObjectPath=n._objectPath,l.referencedArgumentObjectPaths=c,n._addAction(l),e._internalConfig.enablePreviewExecution&&0!=(16&u)){var f={Id:t._nextId(),ActionType:3,Name:r,Arguments:o,ObjectId:"",ObjectType:""};n._addPreviewExecutionAction(f)}return l},n.createRecursiveQueryAction=function(e,t,n){J.validateObjectPath(t);var r={Id:e._nextId(),ActionType:6,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,RecursiveQueryInfo:n},i=new h(r,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i),i},n.createEnsureUnchangedAction=function(e,t,n){J.validateObjectPath(t);var r={Id:e._nextId(),ActionType:8,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},i=new h(r,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i),i},n.createInstantiateAction=function(e,t){J.validateObjectPath(t),e._pendingRequest.ensureInstantiateObjectPath(t._objectPath.parentObjectPath),e._pendingRequest.ensureInstantiateObjectPaths(t._objectPath.argumentObjectPaths);var n={Id:e._nextId(),ActionType:1,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id},r=new h(n,1,4);return r.referencedObjectPath=t._objectPath,t._addAction(r,new L(t),!0),r},n.createTraceAction=function(e,t,n){var r={Id:e._nextId(),ActionType:5,Name:"Trace",ObjectPathId:0},i=new h(r,1,4);return e._pendingRequest.addAction(i),n&&e._pendingRequest.addTrace(r.Id,t),i},n.createTraceMarkerForCallback=function(e,t){var r=n.createTraceAction(e,null,!1);e._pendingRequest.addActionResultHandler(r,new R(t))},n}(p);e.ActionFactory=A;var E=function(t){function n(n,r){var i=t.call(this,n,r)||this;return J.checkArgumentNull(n,"context"),i.m_context=n,i._objectPath&&(!n._processingResult&&n._pendingRequest&&(A.createInstantiateAction(n,i),n._autoCleanup&&i._KeepReference&&n.trackedObjects._autoAdd(i)),e._internalConfig.appendTypeNameToObjectPathInfo&&i._objectPath.objectPathInfo&&i._className&&(i._objectPath.objectPathInfo.T=i._className)),i}return __extends(n,t),Object.defineProperty(n.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isNull",{get:function(){return(void 0!==this.m_isNull||!f.isMock())&&(J.throwIfNotLoaded("isNull",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"isNullObject",{get:function(){return(void 0!==this.m_isNull||!f.isMock())&&(J.throwIfNotLoaded("isNullObject",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isNull",{get:function(){return this.m_isNull},set:function(e){this.m_isNull=e,e&&this._objectPath&&this._objectPath._updateAsNullObject()},enumerable:!0,configurable:!0}),n.prototype._addAction=function(e,t,n){return void 0===t&&(t=null),n||(this.context._pendingRequest.ensureInstantiateObjectPath(this._objectPath),this.context._pendingRequest.ensureInstantiateObjectPaths(e.referencedArgumentObjectPaths)),this.context._pendingRequest.addAction(e),this.context._pendingRequest.addReferencedObjectPath(this._objectPath),this.context._pendingRequest.addReferencedObjectPaths(e.referencedArgumentObjectPaths),this.context._pendingRequest.addActionResultHandler(e,t),l._createPromiseFromResult(null)},n.prototype._addPreviewExecutionAction=function(e){if(!J.isUndefined(this._className)){e.ObjectType=this._className;var t=J._getPropertyValueWithoutCheckLoaded(this,j.idLowerCase);J.isUndefined(t)&&(t=J._getPropertyValueWithoutCheckLoaded(this,j.idPrivate)),J.isUndefined(t)&&(t=J._getPropertyValueWithoutCheckLoaded(this,j.previewExecutionObjectId)),e.ObjectId=t,this.context._pendingRequest.addPreviewExecutionAction(e)}},n.prototype._handleResult=function(e){this._isNull=J.isNullOrUndefined(e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},n.prototype._handleIdResult=function(e){this._isNull=J.isNullOrUndefined(e),J.fixObjectPathIfNecessary(this,e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},n.prototype._handleRetrieveResult=function(e,t){this._handleIdResult(e)},n.prototype._recursivelySet=function(e,t,r,o,c){var u=e instanceof n,f=e;if(u){if(Object.getPrototypeOf(this)!==Object.getPrototypeOf(e))throw i.RuntimeError._createInvalidArgError({argumentName:"properties",errorLocation:this._className+".set"});e=JSON.parse(JSON.stringify(e))}try{for(var p,d=0;d<r.length;d++)p=r[d],e.hasOwnProperty(p)&&void 0!==e[p]&&(this[p]=e[p]);for(d=0;d<o.length;d++)if(p=o[d],e.hasOwnProperty(p)&&void 0!==e[p]){var h=u?f[p]:e[p];this[p].set(h,t)}var g=!u;t&&!J.isNullOrUndefined(g)&&(g=t.throwOnReadOnly);for(d=0;d<c.length;d++)if(p=c[d],e.hasOwnProperty(p)&&void 0!==e[p]&&g)throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(V.cannotApplyPropertyThroughSetMethod,p),debugInfo:{errorLocation:p}});for(p in e)if(r.indexOf(p)<0&&o.indexOf(p)<0){var y=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(this),p);if(!y)throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(P.propertyDoesNotExist,p),debugInfo:{errorLocation:p}});if(g&&!y.set)throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(P.attemptingToSetReadOnlyProperty,p),debugInfo:{errorLocation:p}})}}catch(e){throw new i.RuntimeError({code:a.invalidArgument,httpStatusCode:400,message:l._getResourceString(s.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".set"},innerError:e})}},n}(d);e.ClientObject=E;var w=function(){function e(e){this.m_session=e}return e.prototype.executeAsync=function(e,t,n){var r={url:c.processQuery,method:"POST",headers:n.Headers,body:n.Body},i="";n.Headers&&(i=n.Headers[j.officeControlId]);var a={id:o.nextId(),type:1,flags:t,controlId:i,message:r,customData:e};return l.log(JSON.stringify(a)),this.m_session.sendMessageToHost(a).then((function(e){l.log("Received response: "+JSON.stringify(e));var t,n=e.message;if(200===n.statusCode)t={HttpStatusCode:n.statusCode,ErrorCode:null,ErrorMessage:null,Headers:n.headers,Body:l._parseResponseBody(n)};else{l.log("Error Response:"+n.body);var r=l._parseErrorResponse(n);t={HttpStatusCode:n.statusCode,ErrorCode:r.errorCode,ErrorMessage:r.errorMessage,Headers:n.headers,Body:null}}return t}))},e}(),x=function(e){function t(t){var n=e.call(this)||this;return n.m_bridge=t,n.m_bridge.addHostMessageHandler((function(e){if(3===e.type){var t=e.controlId;if(l.isNullOrEmptyString(t))U.getGenericEventRegistration(t)._handleRichApiMessage(e.message);else{var n=U.peekGenericEventRegistrationOrNull(t);n&&n._handleRichApiMessage(e.message),(n=U.peekGenericEventRegistrationOrNull(""))&&n._handleRichApiMessage(e.message)}}})),n}return __extends(t,e),t.getInstanceIfHostBridgeInited=function(){return o.instance?((l.isNullOrUndefined(t.s_instance)||t.s_instance.m_bridge!==o.instance)&&(t.s_instance=new t(o.instance)),t.s_instance):null},t.prototype._resolveRequestUrlAndHeaderInfo=function(){return l._createPromiseFromResult(null)},t.prototype._createRequestExecutorOrNull=function(){return l.log("NativeBridgeSession::CreateRequestExecutor"),new w(this)},t.prototype.getEventRegistration=function(e){return U.getGenericEventRegistration(e)},t.prototype.sendMessageToHost=function(e){return this.m_bridge.sendMessageToHostAndExpectResponse(e)},t}(n);e.HostBridgeSession=x;var N=function(t){function r(e){var o=t.call(this)||this;if(o.m_customRequestHeaders={},o.m_batchMode=0,o._onRunFinishedNotifiers=[],n._overrideSession)o.m_requestUrlAndHeaderInfoResolver=n._overrideSession;else if((J.isNullOrUndefined(e)||"string"==typeof e&&0===e.length)&&((e=r.defaultRequestUrlAndHeaders)||(e={url:c.localDocument,headers:{}})),"string"==typeof e)o.m_requestUrlAndHeaderInfo={url:e,headers:{}};else if(r.isRequestUrlAndHeaderInfoResolver(e))o.m_requestUrlAndHeaderInfoResolver=e;else{if(!r.isRequestUrlAndHeaderInfo(e))throw i.RuntimeError._createInvalidArgError({argumentName:"url"});var a=e;o.m_requestUrlAndHeaderInfo={url:a.url,headers:{}},l._copyHeaders(a.headers,o.m_requestUrlAndHeaderInfo.headers)}return!o.m_requestUrlAndHeaderInfoResolver&&o.m_requestUrlAndHeaderInfo&&l._isLocalDocumentUrl(o.m_requestUrlAndHeaderInfo.url)&&x.getInstanceIfHostBridgeInited()&&(o.m_requestUrlAndHeaderInfo=null,o.m_requestUrlAndHeaderInfoResolver=x.getInstanceIfHostBridgeInited()),o.m_requestUrlAndHeaderInfoResolver instanceof n&&(o.m_session=o.m_requestUrlAndHeaderInfoResolver),o._processingResult=!1,o._customData=j.iterativeExecutor,o.sync=o.sync.bind(o),o}return __extends(r,t),Object.defineProperty(r.prototype,"session",{get:function(){return this.m_session},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"eventRegistration",{get:function(){return this.m_session?this.m_session.getEventRegistration(this._controlId):i.officeJsEventRegistration},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_url",{get:function(){return this.m_requestUrlAndHeaderInfo?this.m_requestUrlAndHeaderInfo.url:null},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_pendingRequest",{get:function(){return null==this.m_pendingRequest&&(this.m_pendingRequest=new k(this)),this.m_pendingRequest},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_controlId",{get:function(){var e=this.m_customRequestHeaders[j.officeControlId];return l.isNullOrUndefined(e)&&(e=""),e},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"debugInfo",{get:function(){return{pendingStatements:new q(this._rootObjectPropertyName,this._pendingRequest._objectPaths,this._pendingRequest._actions,e._internalConfig.showDisposeInfoInDebugInfo).process()}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"trackedObjects",{get:function(){return this.m_trackedObjects||(this.m_trackedObjects=new G(this)),this.m_trackedObjects},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"requestHeaders",{get:function(){return this.m_customRequestHeaders},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"batchMode",{get:function(){return this.m_batchMode},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"getAdditionalHeaders",{set:function(e){this.m_getAdditionalHeaders=e},enumerable:!0,configurable:!0}),r.prototype.ensureInProgressBatchIfBatchMode=function(){if(1===this.m_batchMode&&!this.m_explicitBatchInProgress)throw J.createRuntimeError(a.generalException,l._getResourceString(V.notInsideBatch),null)},r.prototype.load=function(e,t){J.validateContext(this,e);var n=r._parseQueryOption(t);p.createQueryAction(this,e,n,e)},r.prototype.loadRecursive=function(e,t,n){if(!J.isPlainJsonObject(t))throw i.RuntimeError._createInvalidArgError({argumentName:"options"});var o={};for(var a in t)o[a]=r._parseQueryOption(t[a]);var s=A.createRecursiveQueryAction(this,e,{Queries:o,MaxDepth:n});this._pendingRequest.addActionResultHandler(s,e)},r.prototype.trace=function(e){A.createTraceAction(this,e,!0)},r.prototype._processOfficeJsErrorResponse=function(e,t){},r.prototype.ensureRequestUrlAndHeaderInfo=function(){var e=this;return J._createPromiseFromResult(null).then((function(){if(!e.m_requestUrlAndHeaderInfo)return e.m_requestUrlAndHeaderInfoResolver._resolveRequestUrlAndHeaderInfo().then((function(t){if(e.m_requestUrlAndHeaderInfo=t,e.m_requestUrlAndHeaderInfo||(e.m_requestUrlAndHeaderInfo={url:c.localDocument,headers:{}}),J.isNullOrEmptyString(e.m_requestUrlAndHeaderInfo.url)&&(e.m_requestUrlAndHeaderInfo.url=c.localDocument),e.m_requestUrlAndHeaderInfo.headers||(e.m_requestUrlAndHeaderInfo.headers={}),"function"==typeof e.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull){var n=e.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull();n&&(e._requestExecutor=n)}}))}))},r.prototype.syncPrivateMain=function(){var e=this;return this.ensureRequestUrlAndHeaderInfo().then((function(){var t=e._pendingRequest;return e.m_pendingRequest=null,e.processPreSyncPromises(t).then((function(){return e.syncPrivate(t)}))}))},r.prototype.syncPrivate=function(t){var n=this;if(f.isMock())return l._createPromiseFromResult(null);if(!t.hasActions)return this.processPendingEventHandlers(t);var r=t.buildRequestMessageBodyAndRequestFlags(),o=r.body,a=r.flags;this._requestFlagModifier&&(a|=this._requestFlagModifier),this._requestExecutor||(l._isLocalDocumentUrl(this.m_requestUrlAndHeaderInfo.url)?this._requestExecutor=new W(this):this._requestExecutor=new O);var s=this._requestExecutor,u={};l._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,u),l._copyHeaders(this.m_customRequestHeaders,u),delete this.m_customRequestHeaders[j.officeScriptEventId],this.m_getAdditionalHeaders&&l._copyHeaders(this.m_getAdditionalHeaders(),u);var p=f._getCurrentTestNameWithSequenceId();p&&(u[c.testRequestNameHeader]=p);var d={Url:this.m_requestUrlAndHeaderInfo.url,Headers:u,Body:o};t.invalidatePendingInvalidObjectPaths();var h=null,g=null;return this._lastSyncStart="undefined"==typeof performance?Date.now():performance.now(),this._lastRequestFlags=a,s.executeAsync(this._customData,a,d).then((function(r){return n._lastSyncEnd="undefined"==typeof performance?Date.now():performance.now(),e.config.executePerfLogFunc&&e.config.executePerfLogFunc({syncStart:n._lastSyncStart,syncEnd:n._lastSyncEnd}),h=n.processRequestExecutorResponseMessage(t,r),n.processPendingEventHandlers(t).catch((function(e){l.log("Error in processPendingEventHandlers"),l.log(JSON.stringify(e)),g=e}))})).then((function(){if(h)throw l.log("Throw error from response: "+JSON.stringify(h)),h;if(g){l.log("Throw error from ProcessEventHandler: "+JSON.stringify(g));var e=null;if(g instanceof i.RuntimeError)(e=g).traceMessages=t._responseTraceMessages;else{var n=null;n="string"==typeof g?g:g.message,J.isNullOrEmptyString(n)&&(n=l._getResourceString(V.cannotRegisterEvent)),e=new i.RuntimeError({code:C.cannotRegisterEvent,httpStatusCode:400,message:n,traceMessages:t._responseTraceMessages})}throw e}}))},r.prototype.processRequestExecutorResponseMessage=function(t,n){n.Body&&n.Body.TraceIds&&t._setResponseTraceIds(n.Body.TraceIds);var r=t._responseTraceMessages,o=null;if(n.Body){if(n.Body.Error&&n.Body.Error.ActionIndex>=0){var a=new q(this._rootObjectPropertyName,t._objectPaths,t._actions,!1,!0),s=a.processForDebugStatementInfo(n.Body.Error.ActionIndex);o={statement:s.statement,surroundingStatements:s.surroundingStatements,fullStatements:["Please enable config.extendedErrorLogging to see full statements."]},e.config.extendedErrorLogging&&(a=new q(this._rootObjectPropertyName,t._objectPaths,t._actions,!1,!1),o.fullStatements=a.process())}var c=null;if(n.Body.Results?c=n.Body.Results:n.Body.ProcessedResults&&n.Body.ProcessedResults.Results&&(c=n.Body.ProcessedResults.Results),c){this._processingResult=!0;try{t.processResponse(c)}finally{this._processingResult=!1}}}if(!J.isNullOrEmptyString(n.ErrorCode))return new i.RuntimeError({code:n.ErrorCode,httpStatusCode:n.HttpStatusCode,message:n.ErrorMessage,traceMessages:r,data:{responseBody:n.RawErrorResponseBody}});if(n.Body&&n.Body.Error){var u={errorLocation:n.Body.Error.Location};return o&&(u.statement=o.statement,u.surroundingStatements=o.surroundingStatements,u.fullStatements=o.fullStatements),new i.RuntimeError({code:n.Body.Error.Code,httpStatusCode:n.Body.Error.HttpStatusCode,message:n.Body.Error.Message,traceMessages:r,debugInfo:u})}return null},r.prototype.processPendingEventHandlers=function(e){for(var t=J._createPromiseFromResult(null),n=0;n<e._pendingProcessEventHandlers.length;n++){var r=e._pendingProcessEventHandlers[n];t=t.then(this.createProcessOneEventHandlersFunc(r,e))}return t},r.prototype.createProcessOneEventHandlersFunc=function(e,t){return function(){return e._processRegistration(t)}},r.prototype.processPreSyncPromises=function(e){for(var t=J._createPromiseFromResult(null),n=0;n<e._preSyncPromises.length;n++){var r=e._preSyncPromises[n];t=t.then(this.createProcessOneProSyncFunc(r))}return t},r.prototype.createProcessOneProSyncFunc=function(e){return function(){return e}},r.prototype.sync=function(e){return f.isMock()?l._createPromiseFromResult(e):this.syncPrivateMain().then((function(){return e}))},r.prototype.batch=function(e){var t=this;if(1!==this.m_batchMode)return l._createPromiseFromException(J.createRuntimeError(a.generalException,null,null));if(this.m_explicitBatchInProgress)return l._createPromiseFromException(J.createRuntimeError(a.generalException,l._getResourceString(V.pendingBatchInProgress),null));if(J.isNullOrUndefined(e))return J._createPromiseFromResult(null);this.m_explicitBatchInProgress=!0;var n,r,i,o=this.m_pendingRequest;this.m_pendingRequest=new k(this);try{n=e(this._rootObject,this)}catch(e){return this.m_explicitBatchInProgress=!1,this.m_pendingRequest=o,l._createPromiseFromException(e)}return"object"==typeof n&&n&&"function"==typeof n.then?i=J._createPromiseFromResult(null).then((function(){return n})).then((function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=o,e})).catch((function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=o,l._createPromiseFromException(e)})):(this.m_explicitBatchInProgress=!1,r=this.m_pendingRequest,this.m_pendingRequest=o,i=J._createPromiseFromResult(n)),i.then((function(e){return t.ensureRequestUrlAndHeaderInfo().then((function(){return t.syncPrivate(r)})).then((function(){return e}))}))},r._run=function(e,t,n,i,o,a){return void 0===n&&(n=3),void 0===i&&(i=5e3),r._runCommon("run",null,e,0,t,n,i,null,o,a)},r.isValidRequestInfo=function(e){return"string"==typeof e||r.isRequestUrlAndHeaderInfo(e)||r.isRequestUrlAndHeaderInfoResolver(e)},r.isRequestUrlAndHeaderInfo=function(e){return"object"==typeof e&&null!==e&&Object.getPrototypeOf(e)===Object.getPrototypeOf({})&&!J.isNullOrUndefined(e.url)},r.isRequestUrlAndHeaderInfoResolver=function(e){return"object"==typeof e&&null!==e&&"function"==typeof e._resolveRequestUrlAndHeaderInfo},r._runBatch=function(e,t,n,i,o,a,s,c){return void 0===o&&(o=3),void 0===a&&(a=5e3),r._runBatchCommon(0,e,t,n,o,a,i,s,c)},r._runExplicitBatch=function(e,t,n,i,o,a,s,c){return void 0===o&&(o=3),void 0===a&&(a=5e3),r._runBatchCommon(1,e,t,n,o,a,i,s,c)},r._runBatchCommon=function(e,t,n,i,o,a,s,c,u){var l,f;void 0===o&&(o=3),void 0===a&&(a=5e3);var p=null,d=null,h=null,g=0,y=null;if(n.length>0)if(r.isValidRequestInfo(n[0]))p=n[0],g=1;else if(J.isPlainJsonObject(n[0])){if(null!=(p=(y=n[0]).session)&&!r.isValidRequestInfo(p))return r.createErrorPromise(t);d=y.getAdditionalHeaders,h=y.previousObjects,g=1}if(n.length==g+1)f=n[g+0];else{if(null!=y||n.length!=g+2)return r.createErrorPromise(t);h=n[g+0],f=n[g+1]}if(null!=h)if(h instanceof E)l=function(){return h.context};else if(h instanceof r)l=function(){return h};else{if(!Array.isArray(h))return r.createErrorPromise(t);var m=h;if(0==m.length)return r.createErrorPromise(t);for(var _=0;_<m.length;_++){if(!(m[_]instanceof E))return r.createErrorPromise(t);if(m[_].context!=m[0].context)return r.createErrorPromise(t,V.invalidRequestContext)}l=function(){return m[0].context}}else l=i;var v=null;return s&&(v=function(e){return s(y||{},e)}),r._runCommon(t,p,l,e,f,o,a,v,c,u,d)},r.createErrorPromise=function(e,t){return void 0===t&&(t=s.invalidArgument),l._createPromiseFromException(J.createRuntimeError(t,l._getResourceString(t),e))},r._runCommon=function(t,i,o,a,s,c,u,f,p,d,h){n._overrideSession&&(i=n._overrideSession);var g,y,m,_=l.createPromise((function(e,t){e()})),v=!1;return _.then((function(){if((g=o(i)).getAdditionalHeaders=h,g._autoCleanup)return new e.Promise((function(e,t){g._onRunFinishedNotifiers.push((function(){g._autoCleanup=!0,e()}))}));g._autoCleanup=!0})).then((function(){return"function"!=typeof s?r.createErrorPromise(t):(m=g.m_batchMode,g.m_batchMode=a,f&&f(g),e=s(1==a?g.batch.bind(g):g),(J.isNullOrUndefined(e)||"function"!=typeof e.then)&&J.throwError(V.runMustReturnPromise),e);var e})).then((function(e){return 1===a?e:g.sync(e)})).then((function(e){v=!0,y=e})).catch((function(e){y=e})).then((function(){var e=g.trackedObjects._retrieveAndClearAutoCleanupList();for(var t in g._autoCleanup=!1,g.m_batchMode=m,e)e[t]._objectPath.isValid=!1;var n=0;if(J._synchronousCleanup||r.isRequestUrlAndHeaderInfoResolver(i))return o();function o(){n++;var t=g.m_pendingRequest,r=g.m_batchMode,i=new k(g);g.m_pendingRequest=i,g.m_batchMode=0;try{for(var a in e)g.trackedObjects.remove(e[a])}finally{g.m_batchMode=r,g.m_pendingRequest=t}return g.syncPrivate(i).then((function(){p&&p(n)})).catch((function(){d&&d(n),n<c&&setTimeout((function(){o()}),u)}))}o()})).then((function(){g._onRunFinishedNotifiers&&g._onRunFinishedNotifiers.length>0&&g._onRunFinishedNotifiers.shift()();if(v)return y;throw y}))},r}(y);e.ClientRequestContext=N;var T=function(){function e(e,t){this.m_proxy=e,this.m_shouldPolyfill=t;var n=e[j.scalarPropertyNames],r=e[j.navigationPropertyNames],i=e[j.className],o=e[j.isCollection];if(n)for(var a=0;a<n.length;a++)J.definePropertyThrowUnloadedException(this,i,n[a]);if(r)for(a=0;a<r.length;a++)J.definePropertyThrowUnloadedException(this,i,r[a]);o&&J.definePropertyThrowUnloadedException(this,i,j.itemsLowerCase)}return Object.defineProperty(e.prototype,"$proxy",{get:function(){return this.m_proxy},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"$isNullObject",{get:function(){if(!this.m_isLoaded)throw new i.RuntimeError({code:C.valueNotLoaded,httpStatusCode:400,message:l._getResourceString(V.valueNotLoaded),debugInfo:{errorLocation:"retrieveResult.$isNullObject"}});return this.m_isNullObject},enumerable:!0,configurable:!0}),e.prototype.toJSON=function(){if(this.m_isLoaded)return this.m_isNullObject?null:(J.isUndefined(this.m_json)&&(this.m_json=J.purifyJson(this.m_value)),this.m_json)},e.prototype.toString=function(){return JSON.stringify(this.toJSON())},e.prototype._handleResult=function(e){this.m_isLoaded=!0,null===e||"object"==typeof e&&e&&e._IsNull?(this.m_isNullObject=!0,e=null):this.m_isNullObject=!1,this.m_shouldPolyfill&&(e=J.changePropertyNameToCamelLowerCase(e)),this.m_value=e,this.m_proxy._handleRetrieveResult(e,this)},e}(),j=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.getItemAt="GetItemAt",t.index="_Index",t.iterativeExecutor="IterativeExecutor",t.isTracked="_IsTracked",t.eventMessageCategory=65536,t.eventWorkbookId="Workbook",t.eventSourceRemote="Remote",t.proxy="$proxy",t.className="_className",t.isCollection="_isCollection",t.collectionPropertyPath="_collectionPropertyPath",t.objectPathInfoDoNotKeepReferenceFieldName="D",t.officeScriptEventId="X-OfficeScriptEventId",t.officeScriptFireRecordingEvent="X-OfficeScriptFireRecordingEvent",t.officeControlId="X-OfficeControlId",t}(I);e.Constants=j;var k=function(e){function t(t){var n=e.call(this,t)||this;return n.m_context=t,n.m_pendingProcessEventHandlers=[],n.m_pendingEventHandlerActions={},n.m_traceInfos={},n.m_responseTraceIds={},n.m_responseTraceMessages=[],n}return __extends(t,e),Object.defineProperty(t.prototype,"traceInfos",{get:function(){return this.m_traceInfos},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_responseTraceMessages",{get:function(){return this.m_responseTraceMessages},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_responseTraceIds",{get:function(){return this.m_responseTraceIds},enumerable:!0,configurable:!0}),t.prototype._setResponseTraceIds=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t];this.m_responseTraceIds[n]=n;var r=this.m_traceInfos[n];l.isNullOrUndefined(r)||this.m_responseTraceMessages.push(r)}},t.prototype.addTrace=function(e,t){this.m_traceInfos[e]=t},t.prototype._addPendingEventHandlerAction=function(e,t){this.m_pendingEventHandlerActions[e._id]||(this.m_pendingEventHandlerActions[e._id]=[],this.m_pendingProcessEventHandlers.push(e)),this.m_pendingEventHandlerActions[e._id].push(t)},Object.defineProperty(t.prototype,"_pendingProcessEventHandlers",{get:function(){return this.m_pendingProcessEventHandlers},enumerable:!0,configurable:!0}),t.prototype._getPendingEventHandlerActions=function(e){return this.m_pendingEventHandlerActions[e._id]},t}(_);e.ClientRequest=k;var F=function(){function e(e,t,n,r){var i=this;this.m_id=e._nextId(),this.m_context=e,this.m_name=n,this.m_handlers=[],this.m_registered=!1,this.m_eventInfo=r,this.m_callback=function(e){i.m_eventInfo.eventArgsTransformFunc(e).then((function(e){return i.fireEvent(e)}))}}return Object.defineProperty(e.prototype,"_registered",{get:function(){return this.m_registered},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_handlers",{get:function(){return this.m_handlers},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_callback",{get:function(){return this.m_callback},enumerable:!0,configurable:!0}),e.prototype.add=function(e){var t=A.createTraceAction(this.m_context,null,!1);return this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:0}),new M(this.m_context,this,e)},e.prototype.remove=function(e){var t=A.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:1})},e.prototype.removeAll=function(){var e=A.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:e.actionInfo.Id,handler:null,operation:2})},e.prototype._processRegistration=function(e){var t=this,n=l._createPromiseFromResult(null),r=e._getPendingEventHandlerActions(this);if(!r)return n;for(var i=[],o=0;o<this.m_handlers.length;o++)i.push(this.m_handlers[o]);var a=!1;for(o=0;o<r.length;o++)if(e._responseTraceIds[r[o].id])switch(a=!0,r[o].operation){case 0:i.push(r[o].handler);break;case 1:for(var s=i.length-1;s>=0;s--)if(i[s]===r[o].handler){i.splice(s,1);break}break;case 2:i=[]}return a&&(!this.m_registered&&i.length>0?n=n.then((function(){return t.m_eventInfo.registerFunc(t.m_callback)})).then((function(){return t.m_registered=!0})):this.m_registered&&0==i.length&&(n=n.then((function(){return t.m_eventInfo.unregisterFunc(t.m_callback)})).catch((function(e){l.log("Error when unregister event: "+JSON.stringify(e))})).then((function(){return t.m_registered=!1}))),n=n.then((function(){return t.m_handlers=i}))),n},e.prototype.fireEvent=function(e){for(var t=[],n=0;n<this.m_handlers.length;n++){var r=this.m_handlers[n],i=l._createPromiseFromResult(null).then(this.createFireOneEventHandlerFunc(r,e)).catch((function(e){l.log("Error when invoke handler: "+JSON.stringify(e))}));t.push(i)}l.Promise.all(t)},e.prototype.createFireOneEventHandlerFunc=function(e,t){return function(){return e(t)}},e}();e.EventHandlers=F;var M=function(){function e(e,t,n){this.m_context=e,this.m_allHandlers=t,this.m_handler=n}return Object.defineProperty(e.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),e.prototype.remove=function(){this.m_allHandlers&&this.m_handler&&(this.m_allHandlers.remove(this.m_handler),this.m_allHandlers=null,this.m_handler=null)},e}();e.EventHandlerResult=M,function(e){var t=function(){function t(){}return t.prototype.register=function(t,n,r){switch(t){case 4:return J.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return J.promisify((function(t){return e.addHandlerAsync(Office.EventType.BindingDataChanged,r,t)}))}));case 3:return J.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return J.promisify((function(t){return e.addHandlerAsync(Office.EventType.BindingSelectionChanged,r,t)}))}));case 2:return J.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.DocumentSelectionChanged,r,e)}));case 1:return J.promisify((function(e){return Office.context.document.settings.addHandlerAsync(Office.EventType.SettingsChanged,r,e)}));case 5:return OSF.DDA.RichApi.richApiMessageManager.register(r);case 13:return J.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDeleted,r,{id:n},e)}));case 14:return J.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectSelectionChanged,r,{id:n},e)}));case 15:return J.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDataChanged,r,{id:n},e)}));case 16:return J.promisify((function(e){return Office.context.document.addHandlerAsync(Office.EventType.ContentControlAdded,r,{id:n},e)}));default:throw e.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},t.prototype.unregister=function(t,n,r){switch(t){case 4:return J.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return J.promisify((function(t){return e.removeHandlerAsync(Office.EventType.BindingDataChanged,{handler:r},t)}))}));case 3:return J.promisify((function(e){return Office.context.document.bindings.getByIdAsync(n,e)})).then((function(e){return J.promisify((function(t){return e.removeHandlerAsync(Office.EventType.BindingSelectionChanged,{handler:r},t)}))}));case 2:return J.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.DocumentSelectionChanged,{handler:r},e)}));case 1:return J.promisify((function(e){return Office.context.document.settings.removeHandlerAsync(Office.EventType.SettingsChanged,{handler:r},e)}));case 5:return J.promisify((function(e){return OSF.DDA.RichApi.richApiMessageManager.removeHandlerAsync("richApiMessage",{handler:r},e)}));case 13:return J.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDeleted,{id:n,handler:r},e)}));case 14:return J.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectSelectionChanged,{id:n,handler:r},e)}));case 15:return J.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDataChanged,{id:n,handler:r},e)}));case 16:return J.promisify((function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ContentControlAdded,{id:n,handler:r},e)}));default:throw e.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},t}();e.officeJsEventRegistration=new t}(i=e._Internal||(e._Internal={}));var D=function(){function e(e,t){this.m_handlersByEventByTarget={},this.m_registerEventImpl=e,this.m_unregisterEventImpl=t}return e.getTargetIdOrDefault=function(e){return J.isNullOrUndefined(e)?"":e},e.prototype.getHandlers=function(t,n){n=e.getTargetIdOrDefault(n);var r=this.m_handlersByEventByTarget[t];r||(r={},this.m_handlersByEventByTarget[t]=r);var i=r[n];return i||(i=[],r[n]=i),i},e.prototype.callHandlers=function(e,t,n){for(var r=this.getHandlers(e,t),i=0;i<r.length;i++)r[i](n)},e.prototype.hasHandlers=function(e,t){return this.getHandlers(e,t).length>0},e.prototype.register=function(e,t,n){if(!n)throw i.RuntimeError._createInvalidArgError({argumentName:"handler"});var r=this.getHandlers(e,t);return r.push(n),1===r.length?this.m_registerEventImpl(e,t):J._createPromiseFromResult(null)},e.prototype.unregister=function(e,t,n){if(!n)throw i.RuntimeError._createInvalidArgError({argumentName:"handler"});for(var r=this.getHandlers(e,t),o=r.length-1;o>=0;o--)if(r[o]===n){r.splice(o,1);break}return 0===r.length?this.m_unregisterEventImpl(e,t):J._createPromiseFromResult(null)},e}();e.EventRegistration=D;var U=function(){function e(){this.m_eventRegistration=new D(this._registerEventImpl.bind(this),this._unregisterEventImpl.bind(this)),this.m_richApiMessageHandler=this._handleRichApiMessage.bind(this)}return e.prototype.ready=function(){var t=this;return this.m_ready||(e._testReadyImpl?this.m_ready=e._testReadyImpl().then((function(){t.m_isReady=!0})):o.instance?this.m_ready=J._createPromiseFromResult(null).then((function(){t.m_isReady=!0})):this.m_ready=i.officeJsEventRegistration.register(5,"",this.m_richApiMessageHandler).then((function(){t.m_isReady=!0}))),this.m_ready},Object.defineProperty(e.prototype,"isReady",{get:function(){return this.m_isReady},enumerable:!0,configurable:!0}),e.prototype.register=function(e,t,n){var r=this;return this.ready().then((function(){return r.m_eventRegistration.register(e,t,n)}))},e.prototype.unregister=function(e,t,n){var r=this;return this.ready().then((function(){return r.m_eventRegistration.unregister(e,t,n)}))},e.prototype._registerEventImpl=function(e,t){return J._createPromiseFromResult(null)},e.prototype._unregisterEventImpl=function(e,t){return J._createPromiseFromResult(null)},e.prototype._handleRichApiMessage=function(e){if(e&&e.entries)for(var t=0;t<e.entries.length;t++){var n=e.entries[t];if(n.messageCategory==j.eventMessageCategory){l._logEnabled&&l.log(JSON.stringify(n));var r=n.messageType,i=n.targetId;if(this.m_eventRegistration.hasHandlers(r,i)){var o=JSON.parse(n.message);n.isRemoteOverride&&(o.source=j.eventSourceRemote),this.m_eventRegistration.callHandlers(r,i,o)}}}},e.getGenericEventRegistration=function(t){l.isNullOrUndefined(t)&&(t="");var n=e.s_genericEventRegistrations[t];return n||(n=new e,e.s_genericEventRegistrations[t]=n),n},e.peekGenericEventRegistrationOrNull=function(t){return l.isNullOrUndefined(t)&&(t=""),e.s_genericEventRegistrations[t]},e.richApiMessageEventCategory=65536,e.s_genericEventRegistrations={},e}();e.GenericEventRegistration=U,e._testSetRichApiMessageReadyImpl=function(e){U._testReadyImpl=e},e._testTriggerRichApiMessageEvent=function(e){U.getGenericEventRegistration("")._handleRichApiMessage(e)};var H=function(e){function t(t,n,r,i){var o=e.call(this,t,n,r,i)||this;return o.m_genericEventInfo=i,o}return __extends(t,e),t.prototype.add=function(e){var t=this;0==this._handlers.length&&this.m_genericEventInfo.registerFunc&&this.m_genericEventInfo.registerFunc();var n=this._context._controlId;return U.getGenericEventRegistration(n).isReady||this._context._pendingRequest._addPreSyncPromise(U.getGenericEventRegistration(n).ready()),A.createTraceMarkerForCallback(this._context,(function(){t._handlers.push(e),1==t._handlers.length&&U.getGenericEventRegistration(n).register(t.m_genericEventInfo.eventType,t.m_genericEventInfo.getTargetIdFunc(),t._callback)})),new M(this._context,this,e)},t.prototype.remove=function(e){var t=this;1==this._handlers.length&&this.m_genericEventInfo.unregisterFunc&&this.m_genericEventInfo.unregisterFunc();var n=this._context._controlId;A.createTraceMarkerForCallback(this._context,(function(){for(var r=t._handlers,i=r.length-1;i>=0;i--)if(r[i]===e){r.splice(i,1);break}0==r.length&&U.getGenericEventRegistration(n).unregister(t.m_genericEventInfo.eventType,t.m_genericEventInfo.getTargetIdFunc(),t._callback)}))},t.prototype.removeAll=function(){},t}(F);e.GenericEventHandlers=H;var L=function(){function e(e){this.m_clientObject=e}return e.prototype._handleResult=function(e){this.m_clientObject._handleIdResult(e)},e}(),B=function(){function e(){}return e.createGlobalObjectObjectPath=function(e){var t={Id:e._nextId(),ObjectPathType:1,Name:""};return new g(t,null,!1,!1,1,4)},e.createNewObjectObjectPath=function(e,t,n,r){var i={Id:e._nextId(),ObjectPathType:2,Name:t};return new g(i,null,n,!1,1,J._fixupApiFlags(r))},e.createPropertyObjectPath=function(e,t,n,r,i,o){var a={Id:e._nextId(),ObjectPathType:4,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id};return new g(a,t._objectPath,r,i,1,J._fixupApiFlags(o))},e.createIndexerObjectPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new g(r,t._objectPath,!1,!1,1,4)},e.createIndexerObjectPathUsingParentPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new g(r,t,!1,!1,1,4)},e.createMethodObjectPath=function(e,t,n,r,i,o,a,s,c){var u={Id:e._nextId(),ObjectPathType:3,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}},l=J.setMethodArguments(e,u.ArgumentInfo,i),f=new g(u,t._objectPath,o,a,r,J._fixupApiFlags(c));return f.argumentObjectPaths=l,f.getByIdMethodName=s,f},e.createReferenceIdObjectPath=function(e,t){var n={Id:e._nextId(),ObjectPathType:6,Name:t,ArgumentInfo:{}};return new g(n,null,!1,!1,1,4)},e.createChildItemObjectPathUsingIndexerOrGetItemAt=function(t,n,r,i,o){var a=J.tryGetObjectIdFromLoadOrRetrieveResult(i);return t&&!J.isNullOrUndefined(a)?e.createChildItemObjectPathUsingIndexer(n,r,i):e.createChildItemObjectPathUsingGetItemAt(n,r,i,o)},e.createChildItemObjectPathUsingIndexer=function(e,t,n){var r=J.tryGetObjectIdFromLoadOrRetrieveResult(n),i=i={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return i.ArgumentInfo.Arguments=[r],new g(i,t._objectPath,!1,!1,1,4)},e.createChildItemObjectPathUsingGetItemAt=function(e,t,n,r){var i=n[j.index];i&&(r=i);var o={Id:e._nextId(),ObjectPathType:3,Name:j.getItemAt,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return o.ArgumentInfo.Arguments=[r],new g(o,t._objectPath,!1,!1,1,4)},e}();e.ObjectPathFactory=B;var W=function(){function t(e){this.m_context=e}return t.prototype.executeAsync=function(n,r,i){var o=this,a=u.buildMessageArrayForIRequestExecutor(n,r,i,t.SourceLibHeaderValue);return new e.Promise((function(e,t){OSF.DDA.RichApi.executeRichApiRequestAsync(a,(function(t){var n;l.log("Response:"),l.log(JSON.stringify(t)),"succeeded"==t.status?n=u.buildResponseOnSuccess(u.getResponseBody(t),u.getResponseHeaders(t)):(n=u.buildResponseOnError(t.error.code,t.error.message),o.m_context._processOfficeJsErrorResponse(t.error.code,n)),e(n)}))}))},t.SourceLibHeaderValue="officejs",t}(),G=function(){function e(e){this._autoCleanupList={},this.m_context=e}return e.prototype.add=function(e){var t=this;Array.isArray(e)?e.forEach((function(e){return t._addCommon(e,!0)})):this._addCommon(e,!0)},e.prototype._autoAdd=function(e){this._addCommon(e,!1),this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e},e.prototype._autoTrackIfNecessaryWhenHandleObjectResultValue=function(e,t){this.m_context._autoCleanup&&!e[j.isTracked]&&e!==this.m_context._rootObject&&t&&!J.isNullOrEmptyString(t[j.referenceId])&&(this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e,e[j.isTracked]=!0)},e.prototype._addCommon=function(e,t){if(e[j.isTracked])t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id];else{var n=e[j.referenceId];if(e._objectPath.objectPathInfo[j.objectPathInfoDoNotKeepReferenceFieldName])throw J.createRuntimeError(a.generalException,l._getResourceString(V.objectIsUntracked),null);J.isNullOrEmptyString(n)&&e._KeepReference&&(e._KeepReference(),A.createInstantiateAction(this.m_context,e),t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id],e[j.isTracked]=!0)}},e.prototype.remove=function(e){var t=this;Array.isArray(e)?e.forEach((function(e){return t._removeCommon(e)})):this._removeCommon(e)},e.prototype._removeCommon=function(e){e._objectPath.objectPathInfo[j.objectPathInfoDoNotKeepReferenceFieldName]=!0,e.context._pendingRequest._removeKeepReferenceAction(e._objectPath.objectPathInfo.Id);var t=e[j.referenceId];if(!J.isNullOrEmptyString(t)){var n=this.m_context._rootObject;n._RemoveReference&&n._RemoveReference(t)}delete e[j.isTracked]},e.prototype._retrieveAndClearAutoCleanupList=function(){var e=this._autoCleanupList;return this._autoCleanupList={},e},e}();e.TrackedObjects=G;var q=function(){function t(e,t,n,r,i){e||(e="root"),this.m_globalObjName=e,this.m_referencedObjectPaths=t,this.m_actions=n,this.m_statements=[],this.m_variableNameForObjectPathMap={},this.m_variableNameToObjectPathMap={},this.m_declaredObjectPathMap={},this.m_showDispose=r,this.m_removePII=i}return t.prototype.process=function(){this.m_showDispose&&k._calculateLastUsedObjectPathIds(this.m_actions);for(var e=0;e<this.m_actions.length;e++)this.processOneAction(this.m_actions[e]);return this.m_statements},t.prototype.processForDebugStatementInfo=function(e){this.m_showDispose&&k._calculateLastUsedObjectPathIds(this.m_actions);this.m_statements=[];for(var t=-1,n=0;n<this.m_actions.length&&(this.processOneAction(this.m_actions[n]),e==n&&(t=this.m_statements.length-1),!(t>=0&&this.m_statements.length>t+5+1));n++);if(t<0)return null;var r=t-5;r<0&&(r=0);var i=t+1+5;i>this.m_statements.length&&(i=this.m_statements.length);var o=[];0!=r&&o.push("...");for(var a=r;a<t;a++)o.push(this.m_statements[a]);o.push("// >>>>>"),o.push(this.m_statements[t]),o.push("// <<<<<");for(var s=t+1;s<i;s++)o.push(this.m_statements[s]);return i<this.m_statements.length&&o.push("..."),{statement:this.m_statements[t],surroundingStatements:o}},t.prototype.processOneAction=function(e){switch(e.actionInfo.ActionType){case 1:this.processInstantiateAction(e);break;case 3:this.processMethodAction(e);break;case 2:this.processQueryAction(e);break;case 7:this.processQueryAsJsonAction(e);break;case 6:this.processRecursiveQueryAction(e);break;case 4:this.processSetPropertyAction(e);break;case 5:this.processTraceAction(e);break;case 8:this.processEnsureUnchangedAction(e);break;case 9:this.processUpdateAction(e)}},t.prototype.processInstantiateAction=function(e){var t=e.actionInfo.ObjectPathId,n=this.m_referencedObjectPaths[t],r=this.getObjVarName(t);if(this.m_declaredObjectPathMap[t]){i="// Instantiate {"+r+"}";i=this.appendDisposeCommentIfRelevant(i,e),this.m_statements.push(i)}else{var i="var "+r+" = "+this.buildObjectPathExpressionWithParent(n)+";";i=this.appendDisposeCommentIfRelevant(i,e),this.m_statements.push(i),this.m_declaredObjectPathMap[t]=r}},t.prototype.processMethodAction=function(t){var n=t.actionInfo.Name;if("_KeepReference"===n){if(!e._internalConfig.showInternalApiInDebugInfo)return;n="track"}var r=this.getObjVarName(t.actionInfo.ObjectPathId)+"."+J._toCamelLowerCase(n)+"("+this.buildArgumentsExpression(t.actionInfo.ArgumentInfo)+");";r=this.appendDisposeCommentIfRelevant(r,t),this.m_statements.push(r)},t.prototype.processQueryAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".load("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processQueryAsJsonAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".retrieve("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processRecursiveQueryAction=function(e){var t="";e.actionInfo.RecursiveQueryInfo&&(t=JSON.stringify(e.actionInfo.RecursiveQueryInfo));var n=this.getObjVarName(e.actionInfo.ObjectPathId)+".loadRecursive("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},t.prototype.processSetPropertyAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+"."+J._toCamelLowerCase(e.actionInfo.Name)+" = "+this.buildArgumentsExpression(e.actionInfo.ArgumentInfo)+";";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processTraceAction=function(e){var t="context.trace();";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processEnsureUnchangedAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".ensureUnchanged("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.processUpdateAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".update("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},t.prototype.appendDisposeCommentIfRelevant=function(e,t){var n=this;if(this.m_showDispose){var r=t.actionInfo.L;if(r&&r.length>0)return e+" // And then dispose {"+r.map((function(e){return n.getObjVarName(e)})).join(", ")+"}"}return e},t.prototype.buildQueryExpression=function(e){if(e.actionInfo.QueryInfo){var t={};return t.select=e.actionInfo.QueryInfo.Select,t.expand=e.actionInfo.QueryInfo.Expand,t.skip=e.actionInfo.QueryInfo.Skip,t.top=e.actionInfo.QueryInfo.Top,void 0===t.top&&void 0===t.skip&&void 0===t.expand?void 0===t.select?"":JSON.stringify(t.select):JSON.stringify(t)}return""},t.prototype.buildObjectPathExpressionWithParent=function(e){return(5==e.objectPathInfo.ObjectPathType||3==e.objectPathInfo.ObjectPathType||4==e.objectPathInfo.ObjectPathType)&&e.objectPathInfo.ParentObjectPathId?this.getObjVarName(e.objectPathInfo.ParentObjectPathId)+"."+this.buildObjectPathExpression(e):this.buildObjectPathExpression(e)},t.prototype.buildObjectPathExpression=function(e){var t=this.buildObjectPathInfoExpression(e.objectPathInfo),n=e.originalObjectPathInfo;return n&&(t=t+" /* originally "+this.buildObjectPathInfoExpression(n)+" */"),t},t.prototype.buildObjectPathInfoExpression=function(e){switch(e.ObjectPathType){case 1:return"context."+this.m_globalObjName;case 5:return"getItem("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 3:return J._toCamelLowerCase(e.Name)+"("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 2:return e.Name+".newObject()";case 7:return"null";case 4:return J._toCamelLowerCase(e.Name);case 6:return"context."+this.m_globalObjName+"._getObjectByReferenceId("+JSON.stringify(e.Name)+")"}},t.prototype.buildArgumentsExpression=function(e){var t="";if(!e.Arguments||0===e.Arguments.length)return t;if(this.m_removePII)return void 0===e.Arguments[0]?t:"...";for(var n=0;n<e.Arguments.length;n++)n>0&&(t+=", "),t+=this.buildArgumentLiteral(e.Arguments[n],e.ReferencedObjectPathIds?e.ReferencedObjectPathIds[n]:null);return"undefined"===t&&(t=""),t},t.prototype.buildArgumentLiteral=function(e,t){return"number"==typeof e&&e===t?this.getObjVarName(t):JSON.stringify(e)},t.prototype.getObjVarNameBase=function(e){var t="v",n=this.m_referencedObjectPaths[e];if(n)switch(n.objectPathInfo.ObjectPathType){case 1:t=this.m_globalObjName;break;case 4:t=J._toCamelLowerCase(n.objectPathInfo.Name);break;case 3:var r=n.objectPathInfo.Name;r.length>3&&"Get"===r.substr(0,3)&&(r=r.substr(3)),t=J._toCamelLowerCase(r);break;case 5:var i=this.getObjVarNameBase(n.objectPathInfo.ParentObjectPathId);t="s"===i.charAt(i.length-1)?i.substr(0,i.length-1):i+"Item"}return t},t.prototype.getObjVarName=function(e){if(this.m_variableNameForObjectPathMap[e])return this.m_variableNameForObjectPathMap[e];var t=this.getObjVarNameBase(e);if(!this.m_variableNameToObjectPathMap[t])return this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t;for(var n=1;this.m_variableNameToObjectPathMap[t+n.toString()];)n++;return t+=n.toString(),this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t},t}(),V=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.cannotRegisterEvent="CannotRegisterEvent",t.connectionFailureWithStatus="ConnectionFailureWithStatus",t.connectionFailureWithDetails="ConnectionFailureWithDetails",t.propertyNotLoaded="PropertyNotLoaded",t.runMustReturnPromise="RunMustReturnPromise",t.moreInfoInnerError="MoreInfoInnerError",t.cannotApplyPropertyThroughSetMethod="CannotApplyPropertyThroughSetMethod",t.invalidOperationInCellEditMode="InvalidOperationInCellEditMode",t.objectIsUntracked="ObjectIsUntracked",t.customFunctionDefintionMissing="CustomFunctionDefintionMissing",t.customFunctionImplementationMissing="CustomFunctionImplementationMissing",t.customFunctionNameContainsBadChars="CustomFunctionNameContainsBadChars",t.customFunctionNameCannotSplit="CustomFunctionNameCannotSplit",t.customFunctionUnexpectedNumberOfEntriesInResultBatch="CustomFunctionUnexpectedNumberOfEntriesInResultBatch",t.customFunctionCancellationHandlerMissing="CustomFunctionCancellationHandlerMissing",t.customFunctionInvalidFunction="CustomFunctionInvalidFunction",t.customFunctionInvalidFunctionMapping="CustomFunctionInvalidFunctionMapping",t.customFunctionWindowMissing="CustomFunctionWindowMissing",t.customFunctionDefintionMissingOnWindow="CustomFunctionDefintionMissingOnWindow",t.pendingBatchInProgress="PendingBatchInProgress",t.notInsideBatch="NotInsideBatch",t.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",t}(P);e.ResourceStrings=V,l.addResourceStringValues({CannotRegisterEvent:"The event handler cannot be registered.",PropertyNotLoaded:"The property '{0}' is not available. Before reading the property's value, call the load method on the containing object and call \"context.sync()\" on the associated request context.",RunMustReturnPromise:'The batch function passed to the ".run" method didn\'t return a promise. The function must return a promise, so that any automatically-tracked objects can be released at the completion of the batch operation. Typically, you return a promise by returning the response from "context.sync()".',InvalidOrTimedOutSessionMessage:"Your Office Online session has expired or is invalid. To continue, refresh the page.",InvalidOperationInCellEditMode:"Excel is in cell-editing mode. Please exit the edit mode by pressing ENTER or TAB or selecting another cell, and then try again.",InvalidSheetName:"The request cannot be processed because the specified worksheet cannot be found. Please try again.",CustomFunctionDefintionMissing:"A property with the name '{0}' that represents the function's definition must exist on Excel.Script.CustomFunctions.",CustomFunctionDefintionMissingOnWindow:"A property with the name '{0}' that represents the function's definition must exist on the window object.",CustomFunctionImplementationMissing:"The property with the name '{0}' on Excel.Script.CustomFunctions that represents the function's definition must contain a 'call' property that implements the function.",CustomFunctionNameContainsBadChars:"The function name may only contain letters, digits, underscores, and periods.",CustomFunctionNameCannotSplit:"The function name must contain a non-empty namespace and a non-empty short name.",CustomFunctionUnexpectedNumberOfEntriesInResultBatch:"The batching function returned a number of results that doesn't match the number of parameter value sets that were passed into it.",CustomFunctionCancellationHandlerMissing:"The cancellation handler onCanceled is missing in the function. The handler must be present as the function is defined as cancelable.",CustomFunctionInvalidFunction:"The property with the name '{0}' that represents the function's definition is not a valid function.",CustomFunctionInvalidFunctionMapping:"The property with the name '{0}' on CustomFunctionMappings that represents the function's definition is not a valid function.",CustomFunctionWindowMissing:"The window object was not found.",PendingBatchInProgress:"There is a pending batch in progress. The batch method may not be called inside another batch, or simultaneously with another batch.",NotInsideBatch:"Operations may not be invoked outside of a batch method.",CannotUpdateReadOnlyProperty:"The property '{0}' is read-only and it cannot be updated.",ObjectIsUntracked:"The object is untracked."});var J=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),n.fixObjectPathIfNecessary=function(e,t){e&&e._objectPath&&t&&e._objectPath.updateUsingObjectData(t,e)},n.load=function(e,t){return e.context.load(e,t),e},n.loadAndSync=function(e,t){return e.context.load(e,t),e.context.sync().then((function(){return e}))},n.retrieve=function(t,r){var i=e._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;i||(i=!n.isSetSupported("RichApiRuntime","1.1"));var o=new T(t,i);return t._retrieve(r,o),o},n.retrieveAndSync=function(e,t){var r=n.retrieve(e,t);return e.context.sync().then((function(){return r}))},n.toJson=function(e,t,r,i){var o={};for(var a in t){void 0!==(s=t[a])&&(o[a]=s)}for(var a in r){var s;void 0!==(s=r[a])&&(s[n.fieldName_isCollection]&&void 0!==s[n.fieldName_m__items]?o[a]=s.toJSON().items:o[a]=s.toJSON())}return i&&(o.items=i.map((function(e){return e.toJSON()}))),o},n.throwError=function(e,t,n){throw new i.RuntimeError({code:e,httpStatusCode:400,message:l._getResourceString(e,t),debugInfo:n?{errorLocation:n}:void 0})},n.createRuntimeError=function(e,t,n,r,o){return new i.RuntimeError({code:e,httpStatusCode:r,message:t,debugInfo:{errorLocation:n},data:o})},n.throwIfNotLoaded=function(e,t,r,i){if(!i&&l.isUndefined(t)&&e.charCodeAt(0)!=n.s_underscoreCharCode&&!n.s_suppressPropertyNotLoadedException)throw n.createPropertyNotLoadedException(r,e)},n._getPropertyValueWithoutCheckLoaded=function(e,t){n.s_suppressPropertyNotLoadedException=!0;try{return e[t]}finally{n.s_suppressPropertyNotLoadedException=!1}},n.createPropertyNotLoadedException=function(e,t){return new i.RuntimeError({code:C.propertyNotLoaded,httpStatusCode:400,message:l._getResourceString(V.propertyNotLoaded,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},n.createCannotUpdateReadOnlyPropertyException=function(e,t){return new i.RuntimeError({code:C.cannotUpdateReadOnlyProperty,httpStatusCode:400,message:l._getResourceString(V.cannotUpdateReadOnlyProperty,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},n.promisify=function(t){return new e.Promise((function(e,n){t((function(t){"failed"==t.status?n(t.error):e(t.value)}))}))},n._addActionResultHandler=function(e,t,n){e.context._pendingRequest.addActionResultHandler(t,n)},n._handleNavigationPropertyResults=function(e,t,n){for(var r=0;r<n.length-1;r+=2)l.isUndefined(t[n[r+1]])||e[n[r]]._handleResult(t[n[r+1]])},n._fixupApiFlags=function(e){return"boolean"==typeof e&&(e=e?1:0),e},n.definePropertyThrowUnloadedException=function(e,t,r){Object.defineProperty(e,r,{configurable:!0,enumerable:!0,get:function(){throw n.createPropertyNotLoadedException(t,r)},set:function(){throw n.createCannotUpdateReadOnlyPropertyException(t,r)}})},n.defineReadOnlyPropertyWithValue=function(e,t,r){Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:function(){return r},set:function(){throw n.createCannotUpdateReadOnlyPropertyException(null,t)}})},n.processRetrieveResult=function(e,t,r,i){if(!l.isNullOrUndefined(t))if(i){var o=t[j.itemsLowerCase];if(Array.isArray(o)){for(var a=[],s=0;s<o.length;s++){var c=i(o[s],s),u={};u[j.proxy]=c,c._handleRetrieveResult(o[s],u),a.push(u)}n.defineReadOnlyPropertyWithValue(r,j.itemsLowerCase,a)}}else{var f=e[j.scalarPropertyNames],p=e[j.navigationPropertyNames],d=e[j.className];if(f)for(s=0;s<f.length;s++){var h=t[g=f[s]];l.isUndefined(h)?n.definePropertyThrowUnloadedException(r,d,g):n.defineReadOnlyPropertyWithValue(r,g,h)}if(p)for(s=0;s<p.length;s++){var g;h=t[g=p[s]];if(l.isUndefined(h))n.definePropertyThrowUnloadedException(r,d,g);else{var y=e[g],m={};y._handleRetrieveResult(h,m),m[j.proxy]=y,Array.isArray(m[j.itemsLowerCase])&&(m=m[j.itemsLowerCase]),n.defineReadOnlyPropertyWithValue(r,g,m)}}}},n.setMockData=function(e,t,r,i){if(l.isNullOrUndefined(t))e._handleResult(t);else{if(e[j.scalarPropertyOriginalNames]){for(var o={},a=e[j.scalarPropertyOriginalNames],s=e[j.scalarPropertyNames],c=0;c<s.length;c++)void 0!==t[s[c]]&&(o[a[c]]=t[s[c]]);e._handleResult(o)}if(e[j.navigationPropertyNames]){var u=e[j.navigationPropertyNames];for(c=0;c<u.length;c++)if(void 0!==t[u[c]]){var f=e[u[c]];f.setMockData&&f.setMockData(t[u[c]])}}if(e[j.isCollection]&&r){var p=Array.isArray(t)?t:t[j.itemsLowerCase];if(Array.isArray(p)){var d=[];for(c=0;c<p.length;c++){var h=r(p,c);n.setMockData(h,p[c]),d.push(h)}i(d)}}}},n.applyMixin=function(e,t){Object.getOwnPropertyNames(t.prototype).forEach((function(n){"constructor"!==n&&Object.defineProperty(e.prototype,n,Object.getOwnPropertyDescriptor(t.prototype,n))}))},n.ensureTypeInitialized=function(e){var t=new N;new e(t,B.createNewObjectObjectPath(t,"Temp",!1,0))},n.fieldName_m__items="m__items",n.fieldName_isCollection="_isCollection",n._synchronousCleanup=!1,n.s_underscoreCharCode="_".charCodeAt(0),n.s_suppressPropertyNotLoadedException=!1,n}(S);e.Utility=J;var z=function(){function e(){}return e.invokeMethod=function(e,t,n,r,i,o){var a=A.createMethodAction(e.context,e,t,n,r,i),s=new v(o);return J._addActionResultHandler(e,a,s),s},e.invokeEnsureUnchanged=function(e,t){A.createEnsureUnchangedAction(e.context,e,t)},e.invokeSetProperty=function(e,t,n,r){A.createSetPropertyAction(e.context,e,t,n,r)},e.createRootServiceObject=function(e,t){return new e(t,B.createGlobalObjectObjectPath(t))},e.createObjectFromReferenceId=function(e,t,n){return new e(t,B.createReferenceIdObjectPath(t,n))},e.createTopLevelServiceObject=function(e,t,n,r,i){return new e(t,B.createNewObjectObjectPath(t,n,r,i))},e.createPropertyObject=function(e,t,n,r,i){var o=B.createPropertyObjectPath(t.context,t,n,r,!1,i);return new e(t.context,o)},e.createIndexerObject=function(e,t,n){var r=B.createIndexerObjectPath(t.context,t,n);return new e(t.context,r)},e.createMethodObject=function(e,t,n,r,i,o,a,s,c){var u=B.createMethodObjectPath(t.context,t,n,r,i,o,a,s,c);return new e(t.context,u)},e.createChildItemObject=function(e,t,n,r,i){var o=B.createChildItemObjectPathUsingIndexerOrGetItemAt(t,n.context,n,r,i);return new e(n.context,o)},e}();e.BatchApiHelper=z;var K=function(){function t(e){if(this.m_namespaceMap={},this.m_namespace=e.metadata.name,this.m_targetNamespaceObject=e.targetNamespaceObject,this.m_namespaceMap[this.m_namespace]=e.targetNamespaceObject,e.namespaceMap)for(var t in e.namespaceMap)this.m_namespaceMap[t]=e.namespaceMap[t];this.m_defaultApiSetName=e.metadata.defaultApiSetName,this.m_hostName=e.metadata.hostName;var n=e.metadata;if(n.enumTypes)for(var r=0;r<n.enumTypes.length;r++)this.buildEnumType(n.enumTypes[r]);if(n.apiSets){for(r=0;r<n.apiSets.length;r++){var i=n.apiSets[r];Array.isArray(i)&&(n.apiSets[r]={version:i[0],name:i[1]||this.m_defaultApiSetName})}this.m_apiSets=n.apiSets}if(this.m_strings=n.strings,n.clientObjectTypes)for(r=0;r<n.clientObjectTypes.length;r++){i=n.clientObjectTypes[r];Array.isArray(i)&&(this.ensureArraySize(i,11),n.clientObjectTypes[r]={name:this.getString(i[0]),behaviorFlags:i[1],collectionPropertyPath:this.getString(i[6]),newObjectServerTypeFullName:this.getString(i[9]),newObjectApiFlags:i[10],childItemTypeFullName:this.getString(i[7]),scalarProperties:i[2],navigationProperties:i[3],scalarMethods:i[4],navigationMethods:i[5],events:i[8]}),this.buildClientObjectType(n.clientObjectTypes[r],e.fullyInitialize)}}return t.prototype.ensureArraySize=function(e,t){for(var n=t-e.length;n>0;)e.push(0),n--},t.prototype.getString=function(e){return"number"==typeof e?e>0?this.m_strings[e-1]:null:e},t.prototype.buildEnumType=function(e){var t;if(Array.isArray(e)){(t={name:e[0],fields:e[2]}).fields||(t.fields={});var n=e[1];if(Array.isArray(n))for(var r=0;r<n.length;r++)t.fields[n[r]]=this.toSimpleCamelUpperCase(n[r])}else t=e;this.m_targetNamespaceObject[t.name]=t.fields},t.prototype.buildClientObjectType=function(n,r){var i=this,o=function(t,r){E.apply(this,arguments),i.m_targetNamespaceObject[n.name]._typeInited||(i.buildPrototype(i.m_targetNamespaceObject[n.name],n),i.m_targetNamespaceObject[n.name]._typeInited=!0),e._internalConfig.appendTypeNameToObjectPathInfo&&this._objectPath&&this._objectPath.objectPathInfo&&this._className&&(this._objectPath.objectPathInfo.T=this._className)};(this.m_targetNamespaceObject[n.name]=o,this.extendsType(o,E),this.buildNewObject(o,n),0!=(2&n.behaviorFlags)&&(o.prototype._KeepReference=function(){z.invokeMethod(this,"_KeepReference",1,[],0,0)}),0!=(32&n.behaviorFlags))&&this.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_StaticCustomize").call(null,o);r&&(this.buildPrototype(o,n),o._typeInited=!0)},t.prototype.extendsType=function(e,t){function n(){this.constructor=e}e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)},t.prototype.findObjectUnderPath=function(t,n,r){for(var i=t,o=r;o<n.length;o++){if("object"!=typeof i)throw new e.Error("Cannot find "+n.join("."));i=i[n[o]]}return i},t.prototype.getFunction=function(t){var n=this.resolveObjectByFullName(t);if("function"!=typeof n)throw new e.Error("Cannot find function or type: "+t);return n},t.prototype.resolveObjectByFullName=function(e){var t=e.split(".");if(1===t.length)return this.m_targetNamespaceObject[t[0]];var n=t[0];return n===this.m_namespace?this.findObjectUnderPath(this.m_targetNamespaceObject,t,1):this.m_namespaceMap[n]?this.findObjectUnderPath(this.m_namespaceMap[n],t,1):this.findObjectUnderPath(this.m_targetNamespaceObject,t,0)},t.prototype.evaluateSimpleExpression=function(t,n){if(J.isNullOrUndefined(t))return null;var r=t.split(".");if(3===r.length&&"OfficeExtension"===r[0]&&"Constants"===r[1])return j[r[2]];if("this"===r[0]){for(var i=n,o=1;o<r.length;o++)i="toString()"==r[o]?i.toString():"()"===r[o].substr(r[o].length-2)?i[r[o].substr(0,r[o].length-2)]():i[r[o]];return i}throw new e.Error("Cannot evaluate: "+t)},t.prototype.evaluateEventTargetId=function(e,t){return J.isNullOrEmptyString(e)?"":this.evaluateSimpleExpression(e,t)},t.prototype.isAllDigits=function(e){for(var t="0".charCodeAt(0),n="9".charCodeAt(0),r=0;r<e.length;r++)if(e.charCodeAt(r)<t||e.charCodeAt(r)>n)return!1;return!0},t.prototype.evaluateEventType=function(t){if(J.isNullOrEmptyString(t))return 0;if(this.isAllDigits(t))return parseInt(t);var n=this.resolveObjectByFullName(t);if("number"!=typeof n)throw new e.Error("Invalid event type: "+t);return n},t.prototype.buildPrototype=function(e,t){this.buildScalarProperties(e,t),this.buildNavigationProperties(e,t),this.buildScalarMethods(e,t),this.buildNavigationMethods(e,t),this.buildEvents(e,t),this.buildHandleResult(e,t),this.buildHandleIdResult(e,t),this.buildHandleRetrieveResult(e,t),this.buildLoad(e,t),this.buildRetrieve(e,t),this.buildSetMockData(e,t),this.buildEnsureUnchanged(e,t),this.buildUpdate(e,t),this.buildSet(e,t),this.buildToJSON(e,t),this.buildItems(e,t),this.buildTypeMetadataInfo(e,t),this.buildTrackUntrack(e,t),this.buildMixin(e,t)},t.prototype.toSimpleCamelUpperCase=function(e){return e.substr(0,1).toUpperCase()+e.substr(1)},t.prototype.ensureOriginalName=function(e){null===e.originalName&&(e.originalName=this.toSimpleCamelUpperCase(e.name))},t.prototype.getFieldName=function(e){return"m_"+e.name},t.prototype.throwIfApiNotSupported=function(e,t){if(this.m_apiSets&&t.apiSetInfoOrdinal>0){var n=this.m_apiSets[t.apiSetInfoOrdinal-1];n&&J.throwIfApiNotSupported(e.name+"."+t.name,n.name,n.version,this.m_hostName)}},t.prototype.buildScalarProperties=function(e,t){if(Array.isArray(t.scalarProperties))for(var n=0;n<t.scalarProperties.length;n++){var r=t.scalarProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,6),t.scalarProperties[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],originalName:this.getString(r[3]),setMethodApiFlags:r[4],undoableApiSetInfoOrdinal:r[5]}),this.buildScalarProperty(e,t,t.scalarProperties[n])}},t.prototype.calculateApiFlags=function(e,t){if(t>0){var n=this.m_apiSets[t-1];n&&(e=S.calculateApiFlags(e,n.name,n.version))}return e},t.prototype.buildScalarProperty=function(e,n,r){this.ensureOriginalName(r);var i=this,o=this.getFieldName(r),a={get:function(){return J.throwIfNotLoaded(r.name,this[o],n.name,this._isNull),i.throwIfApiNotSupported(n,r),this[o]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(a.set=function(e){if(4&r.behaviorFlags&&i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)return;this[o]=e;var a=i.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);z.invokeSetProperty(this,r.originalName,e,a)}),Object.defineProperty(e.prototype,r.name,a)},t.prototype.buildNavigationProperties=function(e,t){if(Array.isArray(t.navigationProperties))for(var n=0;n<t.navigationProperties.length;n++){var r=t.navigationProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,8),t.navigationProperties[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[4]),getMethodApiFlags:r[5],setMethodApiFlags:r[6],propertyTypeFullName:this.getString(r[1]),undoableApiSetInfoOrdinal:r[7]}),this.buildNavigationProperty(e,t,t.navigationProperties[n])}},t.prototype.buildNavigationProperty=function(e,n,r){this.ensureOriginalName(r);var i=this,o=this.getFieldName(r),a={get:function(){(this[i.getFieldName(r)]||(i.throwIfApiNotSupported(n,r),this[o]=z.createPropertyObject(i.getFunction(r.propertyTypeFullName),this,r.originalName,0!=(16&r.behaviorFlags),r.getMethodApiFlags)),64&r.behaviorFlags)&&i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Get").call(this,this,this[o]);return this[o]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(a.set=function(e){if(4&r.behaviorFlags&&i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)return;this[o]=e;var a=i.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);z.invokeSetProperty(this,r.originalName,e,a)}),Object.defineProperty(e.prototype,r.name,a)},t.prototype.buildScalarMethods=function(e,t){if(Array.isArray(t.scalarMethods))for(var n=0;n<t.scalarMethods.length;n++){var r=t.scalarMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.scalarMethods[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[5]),apiFlags:r[4],parameterCount:r[1],undoableApiSetInfoOrdinal:r[6]}),this.buildScalarMethod(e,t,t.scalarMethods[n])}},t.prototype.buildScalarMethod=function(e,n,r){this.ensureOriginalName(r);var i=this;e.prototype[r.name]=function(){var e=[];if(64&r.behaviorFlags&&r.parameterCount>0){for(var o=0;o<r.parameterCount-1;o++)e.push(arguments[o]);var a=[];for(o=r.parameterCount-1;o<arguments.length;o++)a.push(arguments[o]);e.push(a)}else for(o=0;o<arguments.length;o++)e.push(arguments[o]);if(1&r.behaviorFlags){var s=i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName),c=[this];for(o=0;o<e.length;o++)c.push(e[o]);var u=s.apply(this,c),l=u.handled,f=u.result;if(l)return f}i.throwIfApiNotSupported(n,r);var p=0;32&r.behaviorFlags&&(p=1);var d=0;2&r.behaviorFlags&&(d=1);var h=i.calculateApiFlags(r.apiFlags,r.undoableApiSetInfoOrdinal);return z.invokeMethod(this,r.originalName,d,e,h,p)}},t.prototype.buildNavigationMethods=function(e,t){if(Array.isArray(t.navigationMethods))for(var n=0;n<t.navigationMethods.length;n++){var r=t.navigationMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,9),t.navigationMethods[n]={name:this.getString(r[0]),behaviorFlags:r[3],apiSetInfoOrdinal:r[4],originalName:this.getString(r[6]),apiFlags:r[5],parameterCount:r[2],returnTypeFullName:this.getString(r[1]),returnObjectGetByIdMethodName:this.getString(r[7]),undoableApiSetInfoOrdinal:r[8]}),this.buildNavigationMethod(e,t,t.navigationMethods[n])}},t.prototype.buildNavigationMethod=function(e,n,r){this.ensureOriginalName(r);var i=this;e.prototype[r.name]=function(){var e=[];if(64&r.behaviorFlags&&r.parameterCount>0){for(var o=0;o<r.parameterCount-1;o++)e.push(arguments[o]);var a=[];for(o=r.parameterCount-1;o<arguments.length;o++)a.push(arguments[o]);e.push(a)}else for(o=0;o<arguments.length;o++)e.push(arguments[o]);if(1&r.behaviorFlags){var s=i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName),c=[this];for(o=0;o<e.length;o++)c.push(e[o]);var u=s.apply(this,c),l=u.handled,f=u.result;if(l)return f}if(i.throwIfApiNotSupported(n,r),0!=(16&r.behaviorFlags))return z.createIndexerObject(i.getFunction(r.returnTypeFullName),this,e);var p=0;2&r.behaviorFlags&&(p=1);var d=i.calculateApiFlags(r.apiFlags,r.undoableApiSetInfoOrdinal);return z.createMethodObject(i.getFunction(r.returnTypeFullName),this,r.originalName,p,e,0!=(4&r.behaviorFlags),0!=(8&r.behaviorFlags),r.returnObjectGetByIdMethodName,d)}},t.prototype.buildHandleResult=function(e,n){var r=this;e.prototype._handleResult=function(e){if(E.prototype._handleResult.call(this,e),!J.isNullOrUndefined(e)){if(J.fixObjectPathIfNecessary(this,e),8&n.behaviorFlags)r.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_HandleResult").call(this,this,e);if(n.scalarProperties)for(var i=0;i<n.scalarProperties.length;i++)J.isUndefined(e[n.scalarProperties[i].originalName])||(0!=(8&n.scalarProperties[i].behaviorFlags)?this[r.getFieldName(n.scalarProperties[i])]=J.adjustToDateTime(e[n.scalarProperties[i].originalName]):this[r.getFieldName(n.scalarProperties[i])]=e[n.scalarProperties[i].originalName]);if(n.navigationProperties){for(var o=[],a=0;a<n.navigationProperties.length;a++)o.push(n.navigationProperties[a].name),o.push(n.navigationProperties[a].originalName);J._handleNavigationPropertyResults(this,e,o)}if(0!=(1&n.behaviorFlags)){var s=r.hasIndexMethod(n);if(!J.isNullOrUndefined(e[j.items])){this.m__items=[];for(var c=e[j.items],u=r.getFunction(n.childItemTypeFullName),l=0;l<c.length;l++){var f=z.createChildItemObject(u,s,this,c[l],l);f._handleResult(c[l]),this.m__items.push(f)}}}}}},t.prototype.buildHandleRetrieveResult=function(e,t){var n=this;e.prototype._handleRetrieveResult=function(e,r){if(E.prototype._handleRetrieveResult.call(this,e,r),!J.isNullOrUndefined(e)){if(t.scalarProperties)for(var i=0;i<t.scalarProperties.length;i++)8&t.scalarProperties[i].behaviorFlags&&(J.isNullOrUndefined(e[t.scalarProperties[i].name])||(e[t.scalarProperties[i].name]=J.adjustToDateTime(e[t.scalarProperties[i].name])));if(1&t.behaviorFlags){var o=n.hasIndexMethod(t),a=n.getFunction(t.childItemTypeFullName),s=this;J.processRetrieveResult(s,e,r,(function(e,t){return z.createChildItemObject(a,o,s,e,t)}))}else J.processRetrieveResult(this,e,r)}}},t.prototype.buildHandleIdResult=function(e,n){var r=this;e.prototype._handleIdResult=function(e){if(E.prototype._handleIdResult.call(this,e),!J.isNullOrUndefined(e)){if(16&n.behaviorFlags)r.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_HandleIdResult").call(this,this,e);if(n.scalarProperties)for(var i=0;i<n.scalarProperties.length;i++){var o=n.scalarProperties[i].originalName;"Id"!==o&&"_Id"!==o&&"_ReferenceId"!==o||J.isNullOrUndefined(e[n.scalarProperties[i].originalName])||(this[r.getFieldName(n.scalarProperties[i])]=e[n.scalarProperties[i].originalName])}}}},t.prototype.buildLoad=function(e,t){e.prototype.load=function(e){return J.load(this,e)}},t.prototype.buildRetrieve=function(e,t){e.prototype.retrieve=function(e){return J.retrieve(this,e)}},t.prototype.buildNewObject=function(e,t){J.isNullOrEmptyString(t.newObjectServerTypeFullName)||(e.newObject=function(n){return z.createTopLevelServiceObject(e,n,t.newObjectServerTypeFullName,0!=(1&t.behaviorFlags),t.newObjectApiFlags)})},t.prototype.buildSetMockData=function(e,t){var n=this;if(1&t.behaviorFlags){var r=n.hasIndexMethod(t);e.prototype.setMockData=function(e){var i=this;J.setMockData(i,e,(function(e,o){return z.createChildItemObject(n.getFunction(t.childItemTypeFullName),r,i,e,o)}),(function(e){i.m__items=e}))}}else e.prototype.setMockData=function(e){J.setMockData(this,e)}},t.prototype.buildEnsureUnchanged=function(e,t){e.prototype.ensureUnchanged=function(e){z.invokeEnsureUnchanged(this,e)}},t.prototype.buildUpdate=function(e,t){e.prototype.update=function(e){this._recursivelyUpdate(e)}},t.prototype.buildSet=function(e,t){if(0==(1&t.behaviorFlags)){var n=[],r=[];if(t.scalarProperties)for(var i=0;i<t.scalarProperties.length;i++)0==(2&t.scalarProperties[i].behaviorFlags)&&0!=(1&t.scalarProperties[i].behaviorFlags)?r.push(t.scalarProperties[i].name):n.push(t.scalarProperties[i].name);var o=[];if(t.navigationProperties)for(i=0;i<t.navigationProperties.length;i++)0!=(16&t.navigationProperties[i].behaviorFlags)||0==(1&t.navigationProperties[i].behaviorFlags)||0==(32&t.navigationProperties[i].behaviorFlags)?n.push(t.navigationProperties[i].name):o.push(t.navigationProperties[i].name);0===o.length&&0===r.length||(e.prototype.set=function(e,t){this._recursivelySet(e,t,r,o,n)})}},t.prototype.buildItems=function(e,t){0!=(1&t.behaviorFlags)&&Object.defineProperty(e.prototype,"items",{get:function(){return J.throwIfNotLoaded("items",this.m__items,t.name,this._isNull),this.m__items},enumerable:!0,configurable:!0})},t.prototype.buildToJSON=function(e,t){var n=this;0==(1&t.behaviorFlags)?e.prototype.toJSON=function(){var e={};if(t.scalarProperties)for(var r=0;r<t.scalarProperties.length;r++)0!=(1&t.scalarProperties[r].behaviorFlags)&&(e[t.scalarProperties[r].name]=this[n.getFieldName(t.scalarProperties[r])]);var i={};if(t.navigationProperties)for(r=0;r<t.navigationProperties.length;r++)0!=(1&t.navigationProperties[r].behaviorFlags)&&(i[t.navigationProperties[r].name]=this[n.getFieldName(t.navigationProperties[r])]);return J.toJson(this,e,i)}:e.prototype.toJSON=function(){return J.toJson(this,{},{},this.m__items)}},t.prototype.buildTypeMetadataInfo=function(e,t){Object.defineProperty(e.prototype,"_className",{get:function(){return t.name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_isCollection",{get:function(){return 0!=(1&t.behaviorFlags)},enumerable:!0,configurable:!0}),J.isNullOrEmptyString(t.collectionPropertyPath)||Object.defineProperty(e.prototype,"_collectionPropertyPath",{get:function(){return t.collectionPropertyPath},enumerable:!0,configurable:!0}),t.scalarProperties&&t.scalarProperties.length>0&&(Object.defineProperty(e.prototype,"_scalarPropertyNames",{get:function(){return this.m__scalarPropertyNames||(this.m__scalarPropertyNames=t.scalarProperties.map((function(e){return e.name}))),this.m__scalarPropertyNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyOriginalNames",{get:function(){return this.m__scalarPropertyOriginalNames||(this.m__scalarPropertyOriginalNames=t.scalarProperties.map((function(e){return e.originalName}))),this.m__scalarPropertyOriginalNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyUpdateable",{get:function(){return this.m__scalarPropertyUpdateable||(this.m__scalarPropertyUpdateable=t.scalarProperties.map((function(e){return 0==(2&e.behaviorFlags)}))),this.m__scalarPropertyUpdateable},enumerable:!0,configurable:!0})),t.navigationProperties&&t.navigationProperties.length>0&&Object.defineProperty(e.prototype,"_navigationPropertyNames",{get:function(){return this.m__navigationPropertyNames||(this.m__navigationPropertyNames=t.navigationProperties.map((function(e){return e.name}))),this.m__navigationPropertyNames},enumerable:!0,configurable:!0})},t.prototype.buildTrackUntrack=function(e,t){2&t.behaviorFlags&&(e.prototype.track=function(){return this.context.trackedObjects.add(this),this},e.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this})},t.prototype.buildMixin=function(e,t){if(4&t.behaviorFlags){var n=this.getFunction(t.name+"Custom");J.applyMixin(e,n)}},t.prototype.getOnEventName=function(e){return"_"===e[0]?"_on"+e.substr(1):"on"+e},t.prototype.buildEvents=function(e,t){if(t.events)for(var n=0;n<t.events.length;n++){var r=t.events[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.events[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],typeExpression:this.getString(r[3]),targetIdExpression:this.getString(r[4]),register:this.getString(r[5]),unregister:this.getString(r[6])}),this.buildEvent(e,t,t.events[n])}},t.prototype.buildEvent=function(e,t,n){1&n.behaviorFlags?this.buildV0Event(e,t,n):this.buildV2Event(e,t,n)},t.prototype.buildV2Event=function(e,n,r){var i=this,o=this.getOnEventName(r.name),a=this.getFieldName(r);Object.defineProperty(e.prototype,o,{get:function(){if(!this[a]){i.throwIfApiNotSupported(n,r);var e=this,o=null;"null"!==r.register&&(o=this[r.register].bind(this));var s=null;"null"!==r.unregister&&(s=this[r.unregister].bind(this));var c=null;2&r.behaviorFlags&&(c=i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.name+"_EventArgsTransform"));var u=i.evaluateEventType(r.typeExpression);this[a]=new H(this.context,this,r.name,{eventType:u,getTargetIdFunc:function(){return i.evaluateEventTargetId(r.targetIdExpression,e)},registerFunc:o,unregisterFunc:s,eventArgsTransformFunc:function(t){return c&&(t=c.call(e,e,t)),J._createPromiseFromResult(t)}})}return this[a]},enumerable:!0,configurable:!0})},t.prototype.buildV0Event=function(e,n,r){var i=this,o=this.getOnEventName(r.name),a=this.getFieldName(r);Object.defineProperty(e.prototype,o,{get:function(){if(!this[a]){i.throwIfApiNotSupported(n,r);var e=this,o=null;if(J.isNullOrEmptyString(r.register)){var s=i.evaluateEventType(r.typeExpression);o=function(t){var n=i.evaluateEventTargetId(r.targetIdExpression,e);return e.context.eventRegistration.register(s,n,t)}}else if("null"!==r.register){var c=i.getFunction(r.register);o=function(t){return c.call(e,e,t)}}var u=null;if(J.isNullOrEmptyString(r.unregister)){var l=i.evaluateEventType(r.typeExpression);u=function(t){var n=i.evaluateEventTargetId(r.targetIdExpression,e);return e.context.eventRegistration.unregister(l,n,t)}}else if("null"!==r.unregister){var f=i.getFunction(r.unregister);u=function(t){return f.call(e,e,t)}}var p=null;2&r.behaviorFlags&&(p=i.getFunction(t.CustomizationCodeNamespace+"."+n.name+"_"+r.name+"_EventArgsTransform"));this[a]=new F(this.context,this,r.name,{registerFunc:o,unregisterFunc:u,eventArgsTransformFunc:function(t){return p&&(t=p.call(e,e,t)),J._createPromiseFromResult(t)}})}return this[a]},enumerable:!0,configurable:!0})},t.prototype.hasIndexMethod=function(e){var t=!1;if(e.navigationMethods)for(var n=0;n<e.navigationMethods.length;n++)if(0!=(16&e.navigationMethods[n].behaviorFlags)){t=!0;break}return t},t.CustomizationCodeNamespace="_CC",t}();e.LibraryBuilder=K}(OfficeExtension||(OfficeExtension={})),function(e){var t;!function(t){t.getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;throw new e.Error("No Promise implementation found")}}(t||(t={})),Object.defineProperty(e,"Promise",{get:function(){return t.getPromiseType()},enumerable:!0,configurable:!0})}(OfficeExtension||(OfficeExtension={}));try{if("undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka){var RichApiBridgeImpl=function(){function e(){}return e.prototype.sendMessageToHost=function(e){OfficePlatformGlobal.ReactNativeReka.RekaInstance.InvokeNative("RichApiDataService","ProcessMessageToHost",e)},e}(),RichApiBridge_1=new RichApiBridgeImpl,RichApiDataService_1=function(){function e(){}return e.prototype.Invoke=function(e,t){"ProcessMessageFromHost"===e&&RichApiBridge_1.onMessageFromHost&&RichApiBridge_1.onMessageFromHost(t)},e}();OfficePlatformGlobal.ReactNativeReka.initReka(),OfficePlatformGlobal.ReactNativeReka.RekaInstance.RegisterService("RichApiDataService",(function(){return new RichApiDataService_1})),OfficeExtension.HostBridge.init(RichApiBridge_1),OfficeExtension.HostBridgeSession.getInstanceIfHostBridgeInited()}}catch(e){}var oteljs;__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)};!function(e){function t(e,t,n,r){return{name:e,dataType:t,value:n,classification:r||4}}e.makeBooleanDataField=function(e,n,r){return t(e,1,n,r)},e.makeInt64DataField=function(e,n,r){return t(e,2,n,r)},e.makeDoubleDataField=function(e,n,r){return t(e,3,n,r)},e.makeStringDataField=function(e,n,r){return t(e,0,n,r)},e.makeGuidDataField=function(e,n,r){return t(e,4,n,r)}}(oteljs||(oteljs={})),function(e){!function(e){e[e.EssentialServiceMetadata=1]="EssentialServiceMetadata",e[e.AccountData=2]="AccountData",e[e.SystemMetadata=4]="SystemMetadata",e[e.OrganizationIdentifiableInformation=8]="OrganizationIdentifiableInformation",e[e.EndUserIdentifiableInformation=16]="EndUserIdentifiableInformation",e[e.CustomerContent=32]="CustomerContent",e[e.AccessControl=64]="AccessControl",e[e.PublicNonPersonalData=128]="PublicNonPersonalData",e[e.EndUserPseudonymousInformation=256]="EndUserPseudonymousInformation",e[e.PublicPersonalData=512]="PublicPersonalData",e[e.SupportData=1024]="SupportData",e[e.DirectMeasurementData=2048]="DirectMeasurementData",e[e.Everything=65535]="Everything"}(e.DataClassification||(e.DataClassification={})),function(e){e[e.String=0]="String",e[e.Boolean=1]="Boolean",e[e.Int64=2]="Int64",e[e.Double=3]="Double",e[e.Guid=4]="Guid"}(e.DataFieldType||(e.DataFieldType={})),function(e){e[e.NotSet=0]="NotSet",e[e.Measure=1]="Measure",e[e.Diagnostics=2]="Diagnostics",e[e.CriticalBusinessImpact=191]="CriticalBusinessImpact",e[e.CriticalCensus=192]="CriticalCensus",e[e.CriticalExperimentation=193]="CriticalExperimentation",e[e.CriticalUsage=194]="CriticalUsage"}(e.SamplingPolicy||(e.SamplingPolicy={})),function(e){e[e.NotSet=0]="NotSet",e[e.Normal=1]="Normal",e[e.High=2]="High"}(e.PersistencePriority||(e.PersistencePriority={})),function(e){e[e.NotSet=0]="NotSet",e[e.Normal=1]="Normal",e[e.High=2]="High"}(e.CostPriority||(e.CostPriority={})),function(e){e[e.NotSet=0]="NotSet",e[e.SoftwareSetup=1]="SoftwareSetup",e[e.ProductServiceUsage=2]="ProductServiceUsage",e[e.ProductServicePerformance=4]="ProductServicePerformance",e[e.DeviceConfiguration=8]="DeviceConfiguration",e[e.InkingTypingSpeech=16]="InkingTypingSpeech"}(e.DataCategories||(e.DataCategories={})),function(e){e[e.ReservedDoNotUse=0]="ReservedDoNotUse",e[e.Required=10]="Required",e[e.BasicEvent=10]="BasicEvent",e[e.Optional=100]="Optional",e[e.FullEvent=100]="FullEvent",e[e.RequiredServiceData=110]="RequiredServiceData",e[e.NecessaryServiceDataEvent=110]="NecessaryServiceDataEvent",e[e.RequiredServiceDataForEssentialServices=120]="RequiredServiceDataForEssentialServices",e[e.AlwaysOnNecessaryServiceDataEvent=120]="AlwaysOnNecessaryServiceDataEvent"}(e.DiagnosticLevel||(e.DiagnosticLevel={})),function(e){e[e.None=0]="None",e[e.MocaAddIn=1]="MocaAddIn"}(e.CustomerContentType||(e.CustomerContentType={})),function(e){e[e.Error=0]="Error",e[e.Warning=1]="Warning",e[e.Info=2]="Info",e[e.Verbose=3]="Verbose"}(e.LogLevel||(e.LogLevel={})),function(e){e[e.Core=0]="Core",e[e.Sink=1]="Sink",e[e.Transport=2]="Transport"}(e.Category||(e.Category={})),function(e){e[e.Hourly=1]="Hourly",e[e.Daily=2]="Daily"}(e.DnmInterval||(e.DnmInterval={})),function(e){e[e.ReleaseAudienceGroup=1]="ReleaseAudienceGroup",e[e.WacRing=2]="WacRing",e[e.AppName=3]="AppName",e[e.AppPlatform=4]="AppPlatform",e[e.AppVersion=5]="AppVersion"}(e.AllowedPartA||(e.AllowedPartA={})),function(e){e[e.SendTelemetryEvent=1]="SendTelemetryEvent",e[e.CustomerContent=2]="CustomerContent",e[e.DirectNumericEvent=3]="DirectNumericEvent"}(e.EventType||(e.EventType={}))}(oteljs||(oteljs={})),function(e){e.getEffectiveEventFlags=function(t){var n={costPriority:1,samplingPolicy:1,persistencePriority:1,dataCategories:0,diagnosticLevel:100};return t.eventFlags&&t.eventFlags.dataCategories||e.logNotification(0,0,(function(){return"DataCategories"})),t.eventFlags?(t.eventFlags.costPriority&&(n.costPriority=t.eventFlags.costPriority),t.eventFlags.samplingPolicy&&(n.samplingPolicy=t.eventFlags.samplingPolicy),t.eventFlags.persistencePriority&&(n.persistencePriority=t.eventFlags.persistencePriority),t.eventFlags.dataCategories&&(n.dataCategories=t.eventFlags.dataCategories),t.eventFlags.diagnosticLevel&&(n.diagnosticLevel=t.eventFlags.diagnosticLevel),n):n}}(oteljs||(oteljs={})),function(e){var t,n=(t=[],{fireEvent:function(e){t.forEach((function(t){return t(e)}))},addListener:function(e){e&&t.push(e)}});function r(e,t,r){n.fireEvent({level:e,category:t,message:r})}e.onNotification=function(){return n},e.logNotification=r,e.logError=function(e,t,n){r(0,e,(function(){var e=n instanceof Error?n.message:"";return"".concat(t,": ").concat(e)}))}}(oteljs||(oteljs={})),function(e){var t;function n(e){var t={eventName:e.eventName,eventFlags:e.eventFlags||{},telemetryProperties:e.telemetryProperties?__assign({},e.telemetryProperties):{},dataFields:e.dataFields?e.dataFields.slice():[],timestamp:e.timestamp||(new Date).getTime()};return e.eventContract&&(t.eventContract={name:e.eventContract.name,dataFields:e.eventContract.dataFields.slice()}),t}!function(e){e[e.TelemetryData=0]="TelemetryData",e[e.AnonymousData=1]="AnonymousData",e[e.CustomerContent=2]="CustomerContent"}(t||(t={})),e.SuppressNexus=-1,e.cloneEvent=n;var r=function(){function t(e,t,n){var r,i,o;this.telemetrySinks=[],this.persistentDataFields=[],this.partAFields=[],this.eventQueue=[],this.config=n||{},e&&(this.telemetrySinks=e.telemetrySinks,(r=this.persistentDataFields).push.apply(r,e.persistentDataFields),this.config=__assign(__assign({},e.getConfig()),this.config),(i=this.partAFields).push.apply(i,e.partAFields)),t&&(o=this.persistentDataFields).push.apply(o,t)}return t.prototype.addEventContentType=function(t,n){t.push(e.makeInt64DataField("EventContent.Type",n))},t.prototype.sendTelemetryEvent=function(t){var r=n(t),i=r.telemetryProperties;i.nexusTenantToken=e.SuppressNexus;var o=i.ariaTenantToken;if(!o&&(!e.fillTenantTokens(r.eventName,i)&&!o))return void e.logNotification(0,0,(function(){return"No tenant token: "+t.eventName}));this.sendTelemetryEventInternal(r,1)},t.prototype.sendNonStandardEvent=function(e,t){var r=n(e);this.sendTelemetryEventInternal(r,t)},t.prototype.sendCustomerContent=function(e){var t=n(e),r=t.telemetryProperties,i=r.customerContentVersion;return(!i||i>2)&&(r.customerContentVersion=2),r.ariaTenantToken=void 0,r.nexusTenantToken=void 0,r.dnmToken=void 0,this.addEventContentType(t.dataFields,2),this.sendTelemetryEventInternal(t,2)},t.prototype.sendDirectNumericEvent=function(t){var r=n(t),i=r.telemetryProperties;if(!i.dnmToken&&(!e.fillTenantTokens(r.eventName,i)&&!i.dnmToken))return void e.logNotification(0,0,(function(){return"No dnm token: "+r.eventName}));this.addEventContentType(r.dataFields,1),this.sendTelemetryEventInternal(r,3)},t.prototype.sendTelemetryEventInternal=function(t,n){if(2===n||!t.telemetryProperties.customerContentVersion&&!t.telemetryProperties.customerContentType){try{if(0===this.telemetrySinks.length)return void(this.config.enableQueue&&this.eventQueue.length<1e3?this.eventQueue.push([t,n]):e.logNotification(1,0,(function(){return"No telemetry sinks are attached."})));this.processTelemetryEvent(t,n)}catch(t){return void e.logError(0,"SendTelemetryEvent",t)}this.telemetrySinks.forEach((function(e){try{3===n||2===n?e.sendNonStandardEvent&&e.sendNonStandardEvent(t,n):e.sendTelemetryEvent(t)}catch(e){}}))}else e.logNotification(0,0,(function(){return"Customer content"}))},t.prototype.processTelemetryEvent=function(t,n){var r,i,o;if(t.dataFields&&(null===(o=t.dataFields)||void 0===o||o.unshift(e.makeStringDataField("OTelJS.Version",e.oteljsVersion)),3!==n&&this.persistentDataFields&&(r=t.dataFields).unshift.apply(r,this.persistentDataFields)),this.partAFields.length>0){var a=t.eventContract||{name:"",dataFields:[]};(i=a.dataFields).push.apply(i,this.partAFields),t.eventContract=a}this.config.disableValidation||e.validateTelemetryEvent(t)},t.prototype.addSink=function(e){this.telemetrySinks.push(e),this.flushQueue()},t.prototype.flushQueue=function(){var e=this.eventQueue;if(this.eventQueue=[],this.telemetrySinks.length>0)for(var t=0,n=e;t<n.length;t++){var r=n[t],i=r[0],o=r[1];this.sendTelemetryEventInternal(i,o)}},t.prototype.setTenantToken=function(t,n,r){e.setTenantTokens(t,{ariaTenantToken:n,nexusTenantToken:r})},t.prototype.setDNMToken=function(t,n){e.setTenantTokens(t,{dnmToken:n})},t.prototype.cloneEvent=function(e){return n(e)},t.prototype.getConfig=function(){return this.config},t}();e.SimpleTelemetryLogger=r}(oteljs||(oteljs={})),function(e){var t=9007199254740991,n=/^Office(\.[A-Z][a-zA-Z0-9]*){2,}$/,r=/^[a-zA-Z0-9_\.]{1,95}$/;function i(e){return r.test(e)}function o(e){e&&e.forEach((function(e){if("string"!=typeof e.name||!i(e.name))throw new Error("Invalid dataField name");2===e.dataType&&a(e.value)}))}function a(e){if("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e<-9007199254740991||e>t)throw new Error("Invalid integer ".concat(JSON.stringify(e)))}e.validateTelemetryEvent=function(e){if(!function(e){if(!e||e.length>98)return!1;return n.test(e)}(e.eventName))throw new Error("Invalid eventName");var t=e.eventContract;if(t){if(t.name&&!i(t.name))throw new Error("Invalid eventContract");o(t.dataFields)}o(e.dataFields)},e.validateInt=a}(oteljs||(oteljs={})),function(e){var t={};e.setTenantTokens=function(n,r){"Office."===n.substring(0,7)&&"."!==n[n.length-1]?t[n]?(r.ariaTenantToken&&(t[n].ariaTenantToken=r.ariaTenantToken),r.dnmToken&&(t[n].dnmToken=r.dnmToken)):t[n]=r:e.logNotification(0,0,(function(){return"Namespace: ".concat(n)}))},e.fillTenantTokens=function(e,n){for(var r=e.length;r>0;){var i=e.substr(0,r);if(t[i]){var o=t[i];return n.ariaTenantToken=o.ariaTenantToken,n.dnmToken=o.dnmToken,!0}r=e.lastIndexOf(".",r-1)}return!1},e.clear=function(){t={}}}(oteljs||(oteljs={})),function(e){e.oteljsVersion="4.18.0"}(oteljs||(oteljs={})),function(e){var t=function(){function t(){var e=this;this._requestIsPending=!0,this._telemetryQueue=[],this._customerContentQueue=[],this.pause(1e3).then((function(){return e._requestIsPending=!1,e.processTelemetryEvents()})).catch()}return t.isSupportedByDeclaration=function(){return t.isSupportedVersion("1.2")},t.isSupportedVersion=function(e){return Office.context.requirements.isSetSupported("Telemetry",e)},t.prototype.sendCustomerContent=function(e){t.isSupportedVersion("1.3")&&(this._customerContentQueue.push(e),this.processWorkBacklog())},t.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push(e),this.processWorkBacklog()},t.prototype.processWorkBacklog=function(){var t=this;this._requestIsPending||(this._requestIsPending=!0,this.processTelemetryEvents().then((function(){t.waitAndProcessMore()})).catch((function(n){e.logError(1,"RichApiSink Error",n),t.waitAndProcessMore()})))},t.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then((function(){e._requestIsPending=!1,e._telemetryQueue.length>0&&setTimeout((function(){return e.processWorkBacklog()}),0)})).catch((function(){e._requestIsPending=!1}))},t.prototype.processTelemetryEvents=function(){var t=this,n=this._telemetryQueue;this._telemetryQueue=[];var r=this._customerContentQueue;this._customerContentQueue=[];var i=new OfficeCore.RequestContext,o=function(n,r){if(n.telemetryProperties){var i=[];t.addDataFields(i,n.dataFields);var o=n.eventContract?n.eventContract.name:"";n.eventContract&&t.addDataFields(i,n.eventContract.dataFields),r(n.telemetryProperties,n.eventName,o,e.getEffectiveEventFlags(n),i)}};return n.forEach((function(e){o(e,(function(e,t,n,r,o){i.telemetry.sendTelemetryEvent(e,t,n,r,o)}))})),r.forEach((function(e){o(e,(function(e,t,n,r,o){i.telemetry.sendCustomerContent(e,t,n,r,o)}))})),i.sync().catch((function(t){e.logError(1,"RichApi telemetry failed.",t)}))},t.prototype.addDataFields=function(e,t){t&&t.forEach((function(t){e.push({name:t.name,value:t.value,classification:t.classification?t.classification:4,type:4===t.dataType?0:t.dataType})}))},t.prototype.pause=function(e){return new Office.Promise((function(t){return setTimeout(t,e)}))},t}();e.RichApiSink=t}(oteljs||(oteljs={})),function(e){!function(t){!function(t){!function(t){!function(t){t.getFields=function(t,n){var r=[];return void 0!==n.id&&r.push(e.makeStringDataField("".concat(t,".Id"),n.id)),void 0!==n.version&&r.push(e.makeStringDataField("".concat(t,".Version"),n.version)),void 0!==n.instanceId&&r.push(e.makeStringDataField("".concat(t,".InstanceId"),n.instanceId)),void 0!==n.name&&r.push(e.makeStringDataField("".concat(t,".Name"),n.name)),void 0!==n.marketplaceType&&r.push(e.makeStringDataField("".concat(t,".MarketplaceType"),n.marketplaceType)),void 0!==n.sessionId&&r.push(e.makeStringDataField("".concat(t,".SessionId"),n.sessionId)),void 0!==n.browserToken&&r.push(e.makeStringDataField("".concat(t,".BrowserToken"),n.browserToken)),void 0!==n.osfRuntimeVersion&&r.push(e.makeStringDataField("".concat(t,".OsfRuntimeVersion"),n.osfRuntimeVersion)),void 0!==n.officeJsVersion&&r.push(e.makeStringDataField("".concat(t,".OfficeJsVersion"),n.officeJsVersion)),void 0!==n.hostJsVersion&&r.push(e.makeStringDataField("".concat(t,".HostJsVersion"),n.hostJsVersion)),void 0!==n.assetId&&r.push(e.makeStringDataField("".concat(t,".AssetId"),n.assetId)),void 0!==n.providerName&&r.push(e.makeStringDataField("".concat(t,".ProviderName"),n.providerName)),void 0!==n.type&&r.push(e.makeStringDataField("".concat(t,".Type"),n.type)),r}}(t.SDX||(t.SDX={}))}(t.System||(t.System={}))}(t.Office||(t.Office={}))}(e.Contracts||(e.Contracts={}))}(oteljs||(oteljs={})),function(e){var t=function(){function t(){}return t.isSupported=function(){return Office.context&&Office.context.platform?Office.context.platform===Office.PlatformType.OfficeOnline:OfficeExt&&OfficeExt.HostName&&OfficeExt.HostName.Host&&OfficeExt.HostName.Host.getInstance().getPlatform()===Office.PlatformType.OfficeOnline},t.prototype.sendTelemetryEvent=function(t,n){try{if(t.dataFields&&t.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t})).length>0)return;var r=OSF._OfficeAppFactory.getId(),i=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[r,i,t])}catch(t){e.logError(1,"AgaveWacSink",t)}},t.prototype.sendCustomerContent=function(t,n){try{if(t.dataFields&&t.dataFields.filter((function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t})).length>0)return;var r=OSF._OfficeAppFactory.getId(),i=OSF.AgaveHostAction.SendCustomerContent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[r,i,t])}catch(t){e.logError(1,"AgaveWacSink",t)}},t}();e.SdxWacSink=t}(oteljs||(oteljs={})),function(e){!function(e){function t(){try{if(void 0!==OSF&&void 0!==OSF.isOfficeReactNative&&OSF.isOfficeReactNative())return!0}catch(e){}return!1}function n(){var e="web";try{void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo&&(e=OSF._OfficeAppFactory.getHostInfo().hostPlatform)}catch(e){}return e}e.isNativeStorage=function(){var e=n();return!(function(){try{if(void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo&&OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp)return!0}catch(e){}return!1}()||!(t()||"win32"===e||"mac"===e&&window._useSDXSandbox))},e.isNativeApiInfomation=function(){var e=n();return!!(t()||"win32"===e||"mac"===e&&window._useSDXSandbox)},e.isNativeDialog=function(){var e=n();return!(!t()&&"win32"!==e)}}(e.ApiHelper||(e.ApiHelper={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){e.ApiHelper.isNativeApiInfomation()?e.apiInformation=t:e.apiInformation=n;var t={isSetSupported:function(e,t){if("string"!=typeof e)return!1;if(null==t&&(t="0.0.0"),void 0===global.__apiSets)return!1;var n=global.__apiSets,i=Object.keys(n).map((function(e){return e.toLowerCase()})).indexOf(e.toLowerCase());if(i>-1){var o=n[Object.keys(n)[i]];try{var a=r(t),s=void 0;if((s=Array.isArray(o)?function(e,t){for(var n=0;n<e.length;n++){var i=r(e[n]);if(i.major==t)return i}return{major:0,minor:0,patch:0}}(o,a.major):r(o)).major>0){if(s.major>a.major)return!0;if(s.major==a.major&&s.minor>a.minor)return!0;if(s.major==a.major&&s.minor==a.minor&&s.patch>=a.patch)return!0}}catch(e){return!1}}return!1}},n={isSetSupported:function(e,t){try{return!!(Office&&Office.context&&Office.context.requirements)&&Office.context.requirements.isSetSupported(e,Number(t))}catch(e){return!1}}};function r(e){var t=e.split("."),n=0,r=0,i=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),t.length>=2&&(r=Number(t[1])),t.length>=3&&(i=Number(t[2])),isNaN(n)||isNaN(r)||isNaN(i))throw"version format incorrect";return{major:n,minor:r,patch:i}}}(OfficeRuntime||(OfficeRuntime={}));var OfficeRuntime;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),i=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),o=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,function(e){this._dialogService=e});e.Dialog=s;var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.close=function(){return this._dialogService.close(),OfficeExtension.CoreUtility.Promise.resolve()},t}(s),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},t}(s);function l(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}function f(e){var t,n=((t={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},t[12003]={code:"InvalidUrl",message:"HTTPS is required."},t[12004]={code:"Untrusted",message:"Domain is not trusted."},t[12005]={code:"InvalidUrl",message:"HTTPS is required."},t[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},t);return n[e]?n[e]:{code:"Unknown",message:"An unknown error has occured with code: "+e}}e.displayWebDialog=function(t,n){return void 0===n&&(n={}),new OfficeExtension.CoreUtility.Promise((function(r,i){if(n.width&&n.height&&(!l(n.width)||!l(n.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var o={width:n.width?parseInt(n.width):50,height:n.height?parseInt(n.height):50,displayInIFrame:n.displayInIFrame};e.ApiHelper.isNativeDialog()?function(e,t,n,r,i){void 0===i&&(i={});var o=new OfficeExtension.ClientRequestContext,a=d.newObject(o),s=new u(a),c=a.onDialogMessage.add((function(e){switch(OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e)),e.type){case 17:e.error?n(e.error):t(s);break;case 12:i.onMessage&&i.onMessage(e.message,s);break;case 10:default:12006===e.originalErrorCode?(c&&(c.remove(),o.sync()),i.onClose&&i.onClose()):i.onRuntimeError&&(i.onRuntimeError(e.error,s),n(e.error))}return OfficeExtension.CoreUtility.Promise.resolve()}));o.sync().then((function(){return a.displayDialog(r,e),o.sync()})).catch((function(e){n(e)}))}(o,r,i,t,n):function(e,t,n,r,i){void 0===i&&(i={});var o;function a(e){"failed"===e.status?n(new OfficeExtension.Error(f(e.error.code))):((o=e.value).addEventHandler(Office.EventType.DialogMessageReceived,s),o.addEventHandler(Office.EventType.DialogEventReceived,u),t(new c(o)))}function s(e){i.onMessage&&i.onMessage(e.message,o,e.origin)}function u(e){12006===e.error?i.onClose&&i.onClose():i.onRuntimeError&&i.onRuntimeError(new OfficeExtension.Error(f(e.error)),o)}Office.context.ui.displayDialogAsync(r,e,a)}(o,r,i,t,n)}))};var p,d=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"DialogService"},enumerable:!0,configurable:!0}),c.prototype.close=function(){n(this,"Close",1,[],4,0)},c.prototype.displayDialog=function(e,t){n(this,"DisplayDialog",1,[e,t],4,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||o(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.DialogService,n,"Microsoft.Dialog.DialogService",!1,4)},Object.defineProperty(c.prototype,"onDialogMessage",{get:function(){return this.m_dialogMessage||(this.m_dialogMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"DialogMessage",{eventType:65536,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t;try{var n=JSON.parse(e.message),r=n.errorCode?new OfficeExtension.Error(f(n.errorCode)):null;t={originalErrorCode:n.errorCode,type:n.type,error:r,message:n.message,origin:n.origin}}catch(e){t={originalErrorCode:null,type:17,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"}),message:e.message}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_dialogMessage},enumerable:!0,configurable:!0}),c.prototype.toJSON=function(){return i(this,{},{})},c}(OfficeExtension.ClientObject);e.DialogService=d,function(e){e[e.dialogMessageReceived=0]="dialogMessageReceived",e[e.dialogEventReceived=1]="dialogEventReceived"}(p||(p={})),function(e){e.generalException="GeneralException"}(e.DialogErrorCodes||(e.DialogErrorCodes={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){!function(e){function t(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:"true"===n.toString().toLowerCase()}catch(e){return t}}function n(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates,r=parseInt(n[e]);return isNaN(r)?t:r}catch(e){return t}}function r(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:n}catch(e){return t}}e.getBooleanFeatureGate=t,e.getIntFeatureGate=n,e.getStringFeatureGate=r,e.getBooleanFeatureGateAsync=function(e,n){return Promise.resolve(t(e,n))},e.getIntFeatureGateAsync=function(e,t){return Promise.resolve(n(e,t))},e.getStringFeatureGateAsync=function(e,t){return Promise.resolve(r(e,t))}}(e.experimentation||(e.experimentation={}))}(OfficeRuntime||(OfficeRuntime={})),function(e){!function(e){var n={};function r(e){var t=e.eventName,r=e.message;n.hasOwnProperty(t)&&n[t].call(r)}e.on=function(e,i){return function(e,i){n.hasOwnProperty(e)||(n[e]=new t,function(){Office&&Office.context&&Office.context.messaging&&!Office.context.messaging.onMessage&&(Office.context.messaging.onMessage=r.bind(this))}());n[e].add(i)}(e,i),new Promise((function(e){e()}))},e.off=function(e,t){return function(e,t){n.hasOwnProperty(e)&&(t?n[e].remove(t):delete n[e])}(e,t),new Promise((function(e){e()}))},e.emit=function(e,t){return function(e,t){var n={eventName:e,message:t};Office&&Office.context&&Office.context.messaging&&Office.context.messaging.sendMessage&&Office.context.messaging.sendMessage(n)}(e,t),new Promise((function(e){e()}))}}(e.message||(e.message={}));var t=function(){function e(){this.listeners=[]}return e.prototype.add=function(e){this.listeners.push(e)},e.prototype.remove=function(e){var t=this.listeners.lastIndexOf(e);-1!==t&&this.listeners.splice(t,1)},e.prototype.call=function(e){this.listeners.forEach((function(t){return t(e)}))},e}();e.ListenerManager=t}(OfficeRuntime||(OfficeRuntime={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),i=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),o=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,"_Office_AsyncStorage_"),c=s+"|_unusedKey_",u={getItem:function(e){return d((function(t,n){return t.multiGet(n,JSON.stringify([e]))}),(function(e){var t=JSON.parse(e);return t&&t[0]&&t[0][1]?t[0][1]:null}))},setItem:function(e,t){return d((function(n,r){return n.multiSet(r,JSON.stringify([[e,t]]))}),(function(){return null}))},removeItem:function(e){return d((function(t,n){return t.multiRemove(n,JSON.stringify([e]))}),(function(){return null}))},getItems:function(e){return d((function(t,n){return t.multiGet(n,JSON.stringify(e))}),(function(t){var n=JSON.parse(t),r={};return n&&n.forEach((function(e){var t=e[0],n=e[1];return r[t]=n,n})),e&&e.forEach((function(e){r[e]&&r[e]})),r}))},setItems:function(e){var t=[];for(var n in e)e.hasOwnProperty(n)&&t.push([n,e[n]]);return d((function(e,n){return e.multiSet(n,JSON.stringify(t))}),(function(){return null}))},removeItems:function(e){return d((function(t,n){return t.multiRemove(n,JSON.stringify(e))}),(function(){return null}))},getKeys:function(){return d((function(e,t){return e.getAllKeys(t)}),(function(e){return JSON.parse(e)}))}},l={getItem:function(e){return y((function(){return f(e)}))},setItem:function(e,t){return g((function(){return p(e,t)}))},removeItem:function(e){return g((function(){return window.localStorage.removeItem(s+e)}))},getItems:function(e){return new Promise((function(t,n){var r={},i=[];try{h()}catch(e){n(e)}e.forEach((function(e){try{var t=f(e);r[e]=t||null}catch(e){i.push(e)}})),i.length>0?n(new Error("Unknown error.")):t(r)}))},setItems:function(e){return m(e,(function(t){return p(t,e[t])}))},removeItems:function(e){return m(e,(function(e){return window.localStorage.removeItem(s+e)}))},getKeys:function(){return y((function(){return Object.keys(window.localStorage).filter((function(e){return 0===e.indexOf(s)})).map((function(e){return e.substr(s.length)}))}))}};function f(e){return window.localStorage.getItem(s+e)}function p(e,t){window.localStorage.setItem(s+e,t)}function d(e,t){return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=_.getInstance(),o=i.setCallBack((function(e,i){if(i)r(i);else{var o=t(e);n(o)}}));i.ctx.sync().then((function(){var t=i.getPersistentKvStorageService();return e(t,o),i.ctx.sync()})).catch((function(e){r(e)}))}))}function h(){p(c,null),window.localStorage.removeItem(c)}function g(e,t){return void 0===t&&(t=function(){}),new Promise((function(n,r){try{h(),e(),t(null),n()}catch(e){t(e),r(e)}}))}function y(e,t){return void 0===t&&(t=function(){}),new Promise((function(n,r){try{h();var i=e();t(null,i),n(i)}catch(e){t(e,null),r(e)}}))}function m(e,t,n){return void 0===n&&(n=function(){}),new Promise((function(r,i){var o=[];try{h()}catch(e){o.push(e)}for(var a in e)if(e.hasOwnProperty(a)||Array.isArray(e))try{Array.isArray(e)?t(e[a]):t(a)}catch(e){o.push(e)}n(o),o.length>0?i(o):r()}))}e.ApiHelper.isNativeStorage()?e.storage=u:e.storage=l;var _=function(){function e(){var e=this;this._invokeId=0,this._callDict={},this.ctx=new OfficeExtension.ClientRequestContext,this._perkvstorService=v.newObject(this.ctx),this._eventResult=this._perkvstorService.onPersistentStorageMessage.add((function(t){OfficeExtension.Utility.log("persistentKvStoragegMessageHandler:"+JSON.stringify(t));var n=e._callDict[t.invokeId];n&&(n(t.message,t.error),delete e._callDict[t.invokeId])}))}return e.getInstance=function(){return void 0===e.instance?e.instance=new e:e.instance._perkvstorService=v.newObject(e.instance.ctx),e.instance},e.prototype.getPersistentKvStorageService=function(){return this._perkvstorService},e.prototype.getCallBack=function(e){return this._callDict[e]},e.prototype.setCallBack=function(e){var t=this._invokeId;return this._callDict[this._invokeId++]=e,t},e}(),v=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"PersistentKvStorageService"},enumerable:!0,configurable:!0}),c.prototype.clear=function(e){n(this,"Clear",1,[e],4,0)},c.prototype.getAllKeys=function(e){n(this,"GetAllKeys",1,[e],4,0)},c.prototype.multiGet=function(e,t){n(this,"MultiGet",1,[e,t],4,0)},c.prototype.multiRemove=function(e,t){n(this,"MultiRemove",1,[e,t],4,0)},c.prototype.multiSet=function(e,t){n(this,"MultiSet",1,[e,t],4,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||o(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.PersistentKvStorageService,n,"Microsoft.PersistentKvStorage.PersistentKvStorageService",!1,4)},Object.defineProperty(c.prototype,"onPersistentStorageMessage",{get:function(){return this.m_persistentStorageMessage||(this.m_persistentStorageMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"PersistentStorageMessage",{eventType:65537,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t,n,r,i;try{var o=JSON.parse(e.message),a=parseInt(o.errorCode),s=0!=a?new OfficeExtension.Error((n=a,(r={})[16389]={code:"GenericException",message:"Unknown error."},r[65535]={code:"Unexcepted",message:"Catastrophic failure."},r[14]={code:"OutOfMemory",message:"Ran out of memory."},r[87]={code:"InvalidArg",message:"One or more arguments are invalid."},r[16385]={code:"NotImplemented",message:"Not implemented."},r[6]={code:"BadHandle",message:"File Handle is not Set."},r[5]={code:"AccessDenied",message:"Can't read the Storage File."},(i=r)[n]?i[n]:{code:"Unknown",message:"An unknown error has occured"})):null;t={invokeId:o.invokeId,message:o.message,error:s}}catch(e){t={invokeId:-1,message:e.message,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"})}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_persistentStorageMessage},enumerable:!0,configurable:!0}),c.prototype.toJSON=function(){return i(this,{},{})},c}(OfficeExtension.ClientObject);e.PersistentKvStorageService=v,function(e){e.generalException="GeneralException"}(e.ErrorCodes||(e.ErrorCodes={}))}(OfficeRuntime||(OfficeRuntime={}));var OfficeFirstPartyDialog,OfficeFirstPartyAuth,OfficeCore,OfficeFirstParty,Office;__extends=this&&this.__extends||function(){var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(t,n)};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}(),__awaiter=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(i,o){function a(e){try{c(r.next(e))}catch(e){o(e)}}function s(e){try{c(r.throw(e))}catch(e){o(e)}}function c(e){e.done?i(e.value):new n((function(t){t(e.value)})).then(a,s)}c((r=r.apply(e,t||[])).next())}))},__generator=this&&this.__generator||function(e,t){var n,r,i,o,a={label:0,sent:function(){if(1&i[0])throw i[1];return i[1]},trys:[],ops:[]};return o={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function s(o){return function(s){return function(o){if(n)throw new TypeError("Generator is already executing.");for(;a;)try{if(n=1,r&&(i=2&o[0]?r.return:o[0]?r.throw||((i=r.return)&&i.call(r),0):r.next)&&!(i=i.call(r,o[1])).done)return i;switch(r=0,i&&(o=[2&o[0],i.value]),o[0]){case 0:case 1:i=o;break;case 4:return a.label++,{value:o[1],done:!1};case 5:a.label++,r=o[1],o=[0];continue;case 7:o=a.ops.pop(),a.trys.pop();continue;default:if(!(i=a.trys,(i=i.length>0&&i[i.length-1])||6!==o[0]&&2!==o[0])){a=0;continue}if(3===o[0]&&(!i||o[1]>i[0]&&o[1]<i[3])){a.label=o[1];break}if(6===o[0]&&a.label<i[1]){a.label=i[1],i=o;break}if(i&&a.label<i[2]){a.label=i[2],a.ops.push(o);break}i[2]&&a.ops.pop(),a.trys.pop();continue}o=t.call(e,a)}catch(e){o=[6,e],r=0}finally{n=i=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,s])}}},__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)};!function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),i=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),o=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=function(s){function c(){return null!==s&&s.apply(this,arguments)||this}return __extends(c,s),Object.defineProperty(c.prototype,"_className",{get:function(){return"BiShim"},enumerable:!0,configurable:!0}),c.prototype.initialize=function(e){n(this,"Initialize",0,[e],0,0)},c.prototype.getData=function(){return n(this,"getData",1,[],4,0)},c.prototype.setVisualObjects=function(e){n(this,"setVisualObjects",0,[e],2,0)},c.prototype.setVisualObjectsToPersist=function(e){n(this,"setVisualObjectsToPersist",0,[e],2,0)},c.prototype._handleResult=function(e){(s.prototype._handleResult.call(this,e),r(e))||o(this,e)},c.prototype._handleRetrieveResult=function(e,t){s.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},c.newObject=function(n){return t(e.BiShim,n,"Microsoft.AgaveVisual.BiShim",!1,4)},c.prototype.toJSON=function(){return i(this,{},{})},c}(OfficeExtension.ClientObject);e.BiShim=s,function(e){e.generalException1="GeneralException"}(e.AgaveVisualErrorCodes||(e.AgaveVisualErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject;var t=OfficeExtension.BatchApiHelper.createMethodObject,n=(OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject),r=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),i=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,o=(OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),a=OfficeExtension.Utility.isUndefined,s=OfficeExtension.Utility.throwIfNotLoaded,c=(OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load),u=OfficeExtension.Utility.retrieve,l=OfficeExtension.Utility.toJson,f=OfficeExtension.Utility.fixObjectPathIfNecessary,p=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),d=function(i){function a(){return null!==i&&i.apply(this,arguments)||this}return __extends(a,i),Object.defineProperty(a.prototype,"_className",{get:function(){return"FlightingService"},enumerable:!0,configurable:!0}),a.prototype.getClientSessionId=function(){return r(this,"GetClientSessionId",1,[],4,0)},a.prototype.getDeferredFlights=function(){return r(this,"GetDeferredFlights",1,[],4,0)},a.prototype.getFeature=function(n,r,i,o){return t(e.ABType,this,"GetFeature",1,[n,r,i,o],!1,!1,null,4)},a.prototype.getFeatureGate=function(n,r){return t(e.ABType,this,"GetFeatureGate",1,[n,r],!1,!1,null,4)},a.prototype.resetOverride=function(e){r(this,"ResetOverride",0,[e],0,0)},a.prototype.setOverride=function(e,t,n){r(this,"SetOverride",0,[e,t,n],0,0)},a.prototype._handleResult=function(e){(i.prototype._handleResult.call(this,e),o(e))||f(this,e)},a.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),p(this,e,t)},a.newObject=function(t){return n(e.FlightingService,t,"Microsoft.Experiment.FlightingService",!1,4)},a.prototype.toJSON=function(){return l(this,{},{})},a}(OfficeExtension.ClientObject);e.FlightingService=d;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"ABType"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["value"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return s("value",this._V,"ABType",this._isNull),this._V},enumerable:!0,configurable:!0}),t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!o(t)){var n=t;f(this,n),a(n.Value)||(this._V=n.Value)}},t.prototype.load=function(e){return c(this,e)},t.prototype.retrieve=function(e){return u(this,e)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),p(this,t,n)},t.prototype.toJSON=function(){return l(this,{value:this._V},{})},t.prototype.ensureUnchanged=function(e){i(this,e)},t}(OfficeExtension.ClientObject);e.ABType=h,function(e){e.boolean="Boolean",e.integer="Integer",e.string="String"}(e.FeatureType||(e.FeatureType={})),function(e){e.generalException="GeneralException"}(e.ExperimentErrorCodes||(e.ExperimentErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){var t,n=function(){function e(e){this._dialogService=e}return e.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},e.prototype.messageChild=function(e,t){DialogApiManager&&DialogApiManager.messageChildRichApiBridge&&DialogApiManager.messageChildRichApiBridge(e,t)},e}();e.Dialog=n,e.displayWebDialog=function(t,n){return void 0===n&&(n={}),new OfficeExtension.CoreUtility.Promise((function(i,o){if(n.width&&n.height&&(!r(n.width)||!r(n.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var a=new OfficeExtension.ClientRequestContext,s=OfficeCore.FirstPartyDialogService.newObject(a),c=new e.Dialog(s),u=s.onDialogMessage.add((function(e){OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e));var t,r,s,l=JSON.parse(e.message),f=l.errorCode?new OfficeExtension.Error((t=l.errorCode,(r={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},r[12003]={code:"InvalidUrl",message:"HTTPS is required."},r[12004]={code:"Untrusted",message:"Domain is not trusted."},r[12005]={code:"InvalidUrl",message:"HTTPS is required."},r[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},(s=r)[t]?s[t]:{code:"Unknown",message:"An unknown error has occured with code: "+t})):null,p=l.type,d=l.origin,h=l.message;switch(p){case 17:f?o(f):i(c);break;case 12:n.onMessage&&n.onMessage(h,c,d);break;case 10:default:12006===l.errorCode?(u&&(u.remove(),a.sync()),n.onClose&&n.onClose()):n.onRuntimeError&&(n.onRuntimeError(f,c),o(f))}return OfficeExtension.CoreUtility.Promise.resolve()}));return a.sync().then((function(){var e={width:n.width?parseInt(n.width):50,height:n.height?parseInt(n.height):50,displayInIFrame:n.displayInIFrame,dialogTitle:n.dialogTitle,disableESCKeyCloseDialog:void 0!==n.disableESCKeyCloseDialog&&n.disableESCKeyCloseDialog};return s.displayDialog(t,e),a.sync()})).catch((function(e){o(e)}))}));function r(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}},function(e){e[e.dialogMessageReceived=0]="dialogMessageReceived",e[e.dialogEventReceived=1]="dialogEventReceived"}(t||(t={}))}(OfficeFirstPartyDialog||(OfficeFirstPartyDialog={})),function(e){e.OfficeOnlineDomainList=["*.dod.online.office365.us","*.gov.online.office365.us","*.officeapps-df.live.com","*.officeapps.live.com","*.online.office.de","*.partner.officewebapps.cn"],e.isHostOriginTrusted=function(){if(void 0===window.external||void 0===window.external.GetContext){var t=OSF.getClientEndPoint()._targetUrl,n=t.split("/")[2].split(":")[0].split("?")[0];return 0!=t.indexOf("https:")||e.OfficeOnlineDomainList.forEach((function(e){if(0==e.indexOf("*.")&&(e=e.substring(2)),n.indexOf(e)==n.length-e.length)return!0})),!1}return!0}}(OfficeCore||(OfficeCore={})),function(e){var t=function(){function t(e){this.context=e}return Object.defineProperty(t.prototype,"roamingSettings",{get:function(){return this.m_roamingSettings||(this.m_roamingSettings=e.AuthenticationService.newObject(this.context).roamingSettings),this.m_roamingSettings},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tap",{get:function(){return this.m_tap||(this.m_tap=e.Tap.newObject(this.context)),this.m_tap},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skill",{get:function(){return this.m_skill||(this.m_skill=e.Skill.newObject(this.context)),this.m_skill},enumerable:!0,configurable:!0}),t}();e.FirstPartyApis=t;var n=function(n){function r(e){return n.call(this,e)||this}return __extends(r,n),Object.defineProperty(r.prototype,"firstParty",{get:function(){return this.m_firstPartyApis||(this.m_firstPartyApis=new t(this)),this.m_firstPartyApis},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"flighting",{get:function(){return this.flightingService},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"telemetry",{get:function(){return this.m_telemetry||(this.m_telemetry=e.TelemetryService.newObject(this)),this.m_telemetry},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"ribbon",{get:function(){return this.m_ribbon||(this.m_ribbon=e.DynamicRibbon.newObject(this)),this.m_ribbon},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"bi",{get:function(){return this.m_biShim||(this.m_biShim=e.BiShim.newObject(this)),this.m_biShim},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"flightingService",{get:function(){return this.m_flightingService||(this.m_flightingService=e.FlightingService.newObject(this)),this.m_flightingService},enumerable:!0,configurable:!0}),r}(OfficeExtension.ClientRequestContext);e.RequestContext=n,e.run=function(t,n){return OfficeExtension.ClientRequestContext._runBatch("OfficeCore.run",arguments,(function(t){return new e.RequestContext(t)}))}}(OfficeCore||(OfficeCore={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}e.isFeatureEnabled=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,i,o;return __generator(this,(function(a){switch(a.label){case 0:return r=t(),i=OfficeCore.License.newObject(r),o=i.isFeatureEnabled(e,n),[4,r.sync()];case 1:return a.sent(),[2,o.value]}}))}))},e.getFeatureTier=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,i,o;return __generator(this,(function(a){switch(a.label){case 0:return r=t(),i=OfficeCore.License.newObject(r),o=i.getFeatureTier(e,n),[4,r.sync()];case 1:return a.sent(),[2,o.value]}}))}))},e.isFreemiumUpsellEnabled=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(i){switch(i.label){case 0:return e=t(),n=OfficeCore.License.newObject(e),r=n.isFreemiumUpsellEnabled(),[4,e.sync()];case 1:return i.sent(),[2,r.value]}}))}))},e.launchUpsellExperience=function(e){return __awaiter(this,void 0,void 0,(function(){var n;return __generator(this,(function(r){switch(r.label){case 0:return n=t(),OfficeCore.License.newObject(n).launchUpsellExperience(e),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.onFeatureStateChanged=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,i,o,a;return __generator(this,(function(s){switch(s.label){case 0:return r=t(),i=OfficeCore.License.newObject(r),(o=i.getLicenseFeature(e)).onStateChanged.add(n),a=function(){return o.onStateChanged.remove(n),null},[4,r.sync()];case 1:return s.sent(),[2,a]}}))}))},e.getMsaDeviceTicket=function(e,n,r){return __awaiter(this,void 0,void 0,(function(){var i,o,a;return __generator(this,(function(s){switch(s.label){case 0:return i=t(),o=OfficeCore.License.newObject(i),a=o.getMsaDeviceTicket(e,n,r),[4,i.sync()];case 1:return s.sent(),[2,a.value]}}))}))}}(e.license||(e.license={}))}(Office||(Office={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;!function(e){e.Skill_HostSkillEvent_EventArgsTransform=function(e,t){return{type:t.type,data:t.data}}}(e._CC||(e._CC={})),function(e){e.generalException="GeneralException"}(e.SkillErrorCodes||(e.SkillErrorCodes={}));new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[["1.1","SharedApiUndo"]],strings:["Skill","registerHostSkillEvent","unregisterHostSkillEvent"],enumTypes:[],clientObjectTypes:[[1,0,0,0,[["executeAction",3,2,0,5],["notifyPaneEvent",2,2,0,5],[2,0,0,0,3,0,1],[3,0,0,0,3,0,1],["testFireEvent",0,0,0,3,0,1]],0,0,0,[["HostSkillEvent",2,0,"65538","",2,3]],"Microsoft.SkillApi.Skill",4]]},targetNamespaceObject:e})}(OfficeCore||(OfficeCore={})),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),i=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported),o=(OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),a=OfficeExtension.Utility.fixObjectPathIfNecessary,s=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),c=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,function(c){function u(){return null!==c&&c.apply(this,arguments)||this}return __extends(u,c),Object.defineProperty(u.prototype,"_className",{get:function(){return"TelemetryService"},enumerable:!0,configurable:!0}),u.prototype.sendNonStandardEvent=function(e,t,r,o,a,s){i("TelemetryService.sendNonStandardEvent","Telemetry","1.4","OfficeCore"),n(this,"SendNonStandardEvent",1,[e,t,r,o,a,s],4,0)},u.prototype.sendTelemetryEvent=function(e,t,r,i,o){n(this,"SendTelemetryEvent",1,[e,t,r,i,o],4,0)},u.prototype._handleResult=function(e){(c.prototype._handleResult.call(this,e),r(e))||a(this,e)},u.prototype._handleRetrieveResult=function(e,t){c.prototype._handleRetrieveResult.call(this,e,t),s(this,e,t)},u.newObject=function(n){return t(e.TelemetryService,n,"Microsoft.Telemetry.TelemetryService",!1,4)},u.prototype.toJSON=function(){return o(this,{},{})},u}(OfficeExtension.ClientObject));e.TelemetryService=c,function(e){e.unset="Unset",e.string="String",e.boolean="Boolean",e.int64="Int64",e.double="Double"}(e.DataFieldType||(e.DataFieldType={})),function(e){e.sendTelemetryEvent="SendTelemetryEvent",e.customerContent="CustomerContent",e.directNumericEvent="DirectNumericEvent"}(e.EventType||(e.EventType={})),function(e){e.generalException="GeneralException"}(e.TelemetryErrorCodes||(e.TelemetryErrorCodes={}))}(OfficeCore||(OfficeCore={})),function(e){var t="officeWebAuthReplyUrls",n=!1,r=null;function i(e){var t=null,n=null,r=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return t=e.apply(void 0,n)};return{immediateCall:r,delayCall:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];n=function(){return r.apply(void 0,e)}},waitForPromise:function(){return n&&(n(),n=null),t||OfficeExtension.CoreUtility.Promise.resolve()}}}function o(t){var n=!1;return r&&(r.supportsAuthToken?n=!0:t&&r.authenticationApiEnabled&&(n=!r.hostPageSupportsAuth||e.supportsTeamsTokenFlow)),n}e.authFlow="authcode",e.autoPopup=!1,e.upnCheck=!0,e.timeout=void 0,e.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",e.debugging=!1,e.useMsal3=void 0,e.delay=0,e.delayMsal=0,e.supportsOauthManager=!1,e.supportsTeamsTokenFlow=!0,e.supportsBrowserAuth=!0;var a=i((function(r,i,o){return e.supportsBrowserAuth?new OfficeExtension.CoreUtility.Promise((function(a,s){try{var c="msa"===r.authorityType.toLowerCase();if(OSF.WebAuth.config={authFlow:e.authFlow,authVersion:e.authVersion?e.authVersion:null,msal:e.msal,delayWebAuth:e.delay,delayMsal:e.delayMsal,debugging:e.debugging,useMsal3:e.useMsal3,authority:e.authorityOverride?e.authorityOverride:r.authority,idp:r.authorityType.toLowerCase(),appIds:[c&&r.msaAppId?r.msaAppId:r.appId],redirectUri:i||null,upn:r.upn,puid:r.userId,prefetch:o,telemetryInstance:"otel",autoPopup:e.autoPopup,enableUpnCheck:e.upnCheck,enableConsoleLogging:e.debugging,tenantId:r.tenantId,timeout:e.timeout},OSF.WebAuth.load().then((function(e){u(e,n=!0),a()})).catch((function(e){u(e,n),s({code:"PackageNotLoaded",message:e instanceof Event?e.type:e})})),"implicit"===e.authFlow){var l=i||window.location.href.split("?")[0],f=sessionStorage.getItem(t);f||""===f?f=l:f+=", "+l,f&&sessionStorage.setItem(t,f)}}catch(e){OSF.WebAuth.config=null,OSF.WebAuth.load().then((function(){a()})).catch((function(){s({code:"FailedToLoad",message:e})}))}})):OfficeExtension.CoreUtility.Promise.reject({code:"PackageNotLoaded"})}));var s=i((function(t,n){return OSF.WebAuth&&"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform?(Office&&Office.context&&Office.context.webAuth?new OfficeExtension.CoreUtility.Promise((function(e,t){Office.context.webAuth.getAuthContextAsync((function(n){if("succeeded"===n.status){if(!(r=n.value)||r.isAnonymous)return void t({code:"CannotGetAuthContext",message:r?r.Error:void 0});if(!r.appId)return void t({code:"CannotGetAuthContext",message:"App ID is missing from getAuthContextAsync. Please verify the WebApplicationInfo node in app manifest."});e(r)}else t({code:"CannotGetAuthContext",message:n.status})}))})):OfficeExtension.CoreUtility.Promise.reject({code:"GetAuthContextAsyncMissing",message:"Office:["+!Office+"],Office.context:["+!Office.context+"],Office.context.webAuth:["+!Office.context.webAuth+"]"})).then((function(r){if(a.delayCall(r,t,n),!o(e.supportsOauthManager))return a.waitForPromise()})):OfficeExtension.CoreUtility.Promise.resolve()}));function c(e,t){return s.immediateCall(e,t)}function u(e,t){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var n=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Result",t),oteljs.makeStringDataField("Error",e instanceof Event?e.type:"")];if(e&&!(e instanceof Event)&&e.Telemetry)for(var r in e.Telemetry)if(e.Telemetry[r])switch(r){case"succeeded":n.push(oteljs.makeBooleanDataField(r,e.Telemetry[r]));break;case"loadedApplicationCount":case"timeToLoad":n.push(oteljs.makeInt64DataField(r,e.Telemetry[r]));break;default:n.push(oteljs.makeStringDataField(r,e.Telemetry[r]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.Load",dataFields:n,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}function l(e,t,n){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var r=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Popup","boolean"==typeof n&&n),oteljs.makeBooleanDataField("Result",t),oteljs.makeStringDataField("Error",e instanceof Event?e.type:e.ErrorCode)];if(e&&!(e instanceof Event)&&e.Telemetry)for(var i in e.Telemetry)if(e.Telemetry[i])switch(i){case"succeeded":r.push(oteljs.makeBooleanDataField(i,e.Telemetry[i]));break;case"timeToGetToken":r.push(oteljs.makeInt64DataField(i,e.Telemetry[i]));break;default:r.push(oteljs.makeStringDataField(i,e.Telemetry[i]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.GetAccessToken",dataFields:r,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}e.load=c,e.getAccessToken=function(e,t){return s.waitForPromise().then((function(){return new OfficeExtension.CoreUtility.Promise((function(r,i){if("web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform)if(o(!!e.appName)){var s=new OfficeCore.RequestContext,c=OfficeCore.AuthenticationService.newObject(s);s._customData="WacPartition";var u=c.getAccessToken(e,null);s.sync().then((function(){r(u.value)})).catch((function(e){return i(e)}))}else a.waitForPromise().then((function(){var o,a;OSF.WebAuth&&n?OSF.WebAuth.config.appIds[0]&&OSF.WebAuth.getToken(e.resource,null,OSF.WebAuth.config.appIds[0],OSF._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId,t&&t.popup?t.popup:null,e&&e.authChallenge?e.authChallenge:null).then((function(e){l(e,!0,!(!t||!t.popup)&&t.popup),r({accessToken:e.Token,tokenIdenityType:"msa"==OSF.WebAuth.config.idp.toLowerCase()?OfficeCore.IdentityType.microsoftAccount:OfficeCore.IdentityType.organizationAccount})})).catch((function(e){l(e,!1,!(!t||!t.popup)&&t.popup),i({code:e.ErrorCode,message:e instanceof Event?e.type:e.ErrorMessage})})):(o=n,a=OSF.WebAuth.loadAttempts,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var e=[oteljs.makeBooleanDataField("Loaded",o),oteljs.makeInt64DataField("LoadAttempts","number"==typeof a?a:0)];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.UnexpectedAcquire",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})})))})).catch((function(e){return i(e)}));else{var f=new OfficeCore.RequestContext,p=OfficeCore.AuthenticationService.newObject(f),d=p.onTokenReceived.add((function(e){if(!OfficeExtension.CoreUtility.isNullOrUndefined(e))if(d.remove(),f.sync().catch((function(){})),0==e.code)r(e.tokenValue);else if(OfficeExtension.CoreUtility.isNullOrUndefined(e.errorInfo))i({code:e.code});else try{i(JSON.parse(e.errorInfo))}catch(t){i({code:e.code,message:e.errorInfo})}return null}));f.sync().then((function(){var t=p.getAccessToken(e,p._targetId);return f.sync().then((function(){if(OfficeExtension.CoreUtility.isNullOrUndefined(t.value))return null;var e=t.value.accessToken;OfficeExtension.CoreUtility.isNullOrUndefined(e)||r(t.value)}))})).catch((function(e){i(e)}))}}))}))},e.getPrimaryIdentityInfo=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e);e._customData="WacPartition";var n=t.getPrimaryIdentityInfo();return e.sync().then((function(){return n.value}))},e.getIdentities=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e).getIdentities();return e.sync().then((function(){return t.value}))},e.onIdentityChanged=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r=this;return __generator(this,(function(i){switch(i.label){case 0:return i.trys.push([0,3,,4]),"web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform?[3,2]:(t=new OfficeCore.RequestContext,n=OfficeCore.AuthenticationService.newObject(t),n.onIdentityChanged.add(e),[4,t.sync()]);case 1:return i.sent(),[2,function(){return __awaiter(r,void 0,void 0,(function(){return __generator(this,(function(r){switch(r.label){case 0:return n.onIdentityChanged.remove(e),[4,t.sync()];case 1:return r.sent(),[2]}}))}))}];case 2:return[3,4];case 3:return i.sent(),[3,4];case 4:return[2,function(){return Promise.resolve()}]}}))}))},"undefined"!=typeof window&&window.OSF&&function(){try{if("undefined"==typeof window||!window.sessionStorage)return;var e=sessionStorage.getItem(t);null!==e&&-1!==e.indexOf(window.location.origin+window.location.pathname)&&c()}catch(e){console.error(e)}}()}(OfficeFirstPartyAuth||(OfficeFirstPartyAuth={})),function(e){!function(e){var t,n;!function(e){e[e.None=0]="None",e[e.Auto=1]="Auto",e[e.Force=2]="Force"}(t=e.PopupOptions||(e.PopupOptions={})),function(e){e[e.UnsupportedUserIdentity=13003]="UnsupportedUserIdentity",e[e.UserAborted=13004]="UserAborted",e[e.InteractionRequired=13005]="InteractionRequired",e[e.ClientError=13006]="ClientError",e[e.ServerError=13007]="ServerError",e[e.NotAvailable=13012]="NotAvailable",e[e.InternalError=5001]="InternalError",e[e.InvalidApiArguments=5013]="InvalidApiArguments"}(n=e.AuthErrorCode||(e.AuthErrorCode={}));var r={ACCOUNT_UNAVAILABLE:n.UnsupportedUserIdentity,USER_CANCEL:n.UserAborted,USER_INTERACTION_REQUIRED:n.InteractionRequired,PERSISTENT_ERROR:n.ClientError,NO_NETWORK:n.ServerError,TRANSIENT_ERROR:n.ServerError,NESTED_APP_AUTH_UNAVAILABLE:n.NotAvailable},i={POPUP_WINDOW_ERROR:n.ClientError,USER_CANCELLED:n.UserAborted},o="access_token",a="xms_cc",s=0,c=!1,u=!1,l=void 0,f=null,p=void 0;e.clientCapabilities=[],e.upnCheck=!0,e.timeout=void 0,e.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",e.debugging=!1,e.delay=0,e.delayMsal=0,e.useMsal3=void 0;var d={},h=function(e){try{var t="string"==typeof e?e:e.data,i=JSON.parse(t);if(i.requestId){var o=i.requestId;if(d.hasOwnProperty(o)){var a=n.InternalError,s=d[o],c=s[0],u=s[1];delete d[o];var l=i.token;if(l&&!0===i.success&&l.access_token&&"number"==typeof l.expires_in)return void c({accessToken:l.access_token,expiresOn:new Date(Date.now()+1e3*l.expires_in)});var f=i.error;if(f){var p=f.status;r[p]&&(a=r[p])}u({code:a})}}}catch(e){}},g={code:n.NotAvailable};function y(t){if(0===e.clientCapabilities.length)return t;var n={};if(t)try{n=JSON.parse(t)}catch(e){}return n.hasOwnProperty(o)||(n[o]={}),n[o][a]={values:e.clientCapabilities},JSON.stringify(n)}function m(e,t){var r=e.clientId||p,o=e.correlationId||OSF.OUtil.Guid.generateNewGuid(),a=Date.now(),f=function(e){var n=function(e,n){var i=Date.now()-a;!function(e,t,n,r,i,o){if(s>0&&!n)return;s++,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded((function(){var i=[oteljs.makeStringDataField("AppId",e),oteljs.makeStringDataField("CorrelationId",t),oteljs.makeBooleanDataField("Popup",n),oteljs.makeInt64DataField("Duration",r),oteljs.makeInt64DataField("ErrorCode",o?o.code:0),oteljs.makeBooleanDataField("BridgeAvailable",_())];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.NestedAppAuth.GetAccessToken",dataFields:i,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}(r,o,t,i,0,n)};return e.then((function(e){n(0,null)})).catch((function(e){n(0,e)})),e};return _()?f(new Promise((function(n,i){var a=OSF.OUtil.Guid.generateNewGuid(),s=e.scopes.join(" "),u={messageType:"NestedAppAuthRequest",method:t?"GetTokenPopup":"GetToken",requestId:a,clientLibrary:"officejs",sendTime:Date.now(),tokenParams:{clientId:r,scope:s,correlationId:o,claims:y(e.claims)}};c||(nestedAppAuthBridge.addEventListener("message",h),c=!0),d[a]=[n,i],nestedAppAuthBridge.postMessage(JSON.stringify(u))}))):f(l?l.then((function(){if(!u)return Promise.reject(g);var a=e.scopes.join(" ");return a=a.replace(/(\/.default)$/,""),OSF.WebAuth.getToken(a,e.scopes,r,o,t,e.claims).then((function(e){return{accessToken:e.Token,expiresOn:e.MsalResult?e.MsalResult.expiresOn:void 0}})).catch((function(e){var t=n.InternalError,r=void 0;if(e)if(r=e.ErrorMessage,e.MsalResult&&"InteractionRequiredAuthError"===e.MsalResult.name)t=n.InteractionRequired;else if(e.ErrorCode){var o=e.ErrorCode.toUpperCase();i[o]&&(t=i[o])}return Promise.reject({code:t,description:r})}))})):Promise.reject(g))}function _(){return"undefined"!=typeof nestedAppAuthBridge}e.isBridgeAvailable=_,e.load=function(t,n,r,i){return p=t,i&&(e.clientCapabilities=i),l||(l=new Promise((function(o,a){if(_())o();else if(Office&&Office.context&&Office.context.auth&&OSF.WebAuth)try{Office.context.auth.getAuthContextAsync((function(s){if("succeeded"===s.status){if(!(f=s.value))return void a(g);OSF.WebAuth.config={authFlow:"authcode",authVersion:e.authVersion?e.authVersion:null,msal:e.msal,delayWebAuth:e.delay,delayMsal:e.delayMsal,debugging:e.debugging,useMsal3:e.useMsal3,authority:e.authorityOverride?e.authorityOverride:f.authorityBaseUrl,idp:"msa"===f.authorityType.toLowerCase()?"msa":"aad",appIds:[t],redirectUri:n||null,upn:f.userPrincipalName,prefetch:r,telemetryInstance:"otel",enableUpnCheck:e.upnCheck,enableConsoleLogging:e.debugging,checkActiveAccount:!0,tenantId:f.tenantId,timeout:e.timeout,clientCapabilities:i},OSF.WebAuth.load().then((function(e){u=!0,o()})).catch((function(e){a(__assign({},g,{description:e instanceof Event?e.type:void 0}))}))}else a(g)}))}catch(e){a(g)}else a(g)})))},e.getAccessToken=function(e){var r=null==e.popup?t.None:e.popup;if(r===t.Auto&&!e.directUserActionCallback)throw{code:n.InvalidApiArguments};return m(e,r===t.Force).catch((function(i){if(i.code==n.InteractionRequired&&r===t.Auto&&e.directUserActionCallback)return e.directUserActionCallback().then((function(t){if(t)return m(e,!0);throw{code:n.UserAborted}})).catch((function(){throw{code:n.UserAborted}}));throw i}))}}(e.NestedAppAuth||(e.NestedAppAuth={}))}(OfficeFirstPartyAuth||(OfficeFirstPartyAuth={})),function(e){var t;OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;!function(e){e.LicenseFeature_StateChanged_EventArgsTransform=function(e,t){var n={feature:t.featureName,isEnabled:t.isEnabled,tier:t.tierName};return t.tierName&&(n.tier=0==t.tierName?LicenseFeatureTier.unknown:1==t.tierName?LicenseFeatureTier.basic:2==t.tierName?LicenseFeatureTier.premium:t.tierName),n}}(e._CC||(e._CC={})),function(e){e.ThemeService_OfficeThemeChanged_EventArgsTransform=function(e,t){return{bodyBackgroundColor:t.bodyBackgroundColor,bodyForegroundColor:t.bodyForegroundColor,controlBackgroundColor:t.controlBackgroundColor,controlForegroundColor:t.controlForegroundColor}}}(e._CC||(e._CC={})),function(e){e[e.immediate=0]="immediate",e[e.load=3]="load"}(t=e.PersonaPromiseType||(e.PersonaPromiseType={}));var n=function(){};e.PersonaInfoAndSource=n;var r=function(){function r(){}return r.prototype.performAsyncOperation=function(e,n,r,i){var o=this;e!=t.immediate?i().then((function(e){if(e)r();else{var t=o;t.load("hostId"),t.context.sync().then((function(){var e=t.hostId;o.getPersonaLifetime().then((function(o){var a=function(s){return new OfficeExtension.CoreUtility.Promise((function(c,u){if(s.sendingPersonaHostId==e)for(var l=0;l<s.dataUpdated.length;++l){var f=s.dataUpdated[l];if(n==f)return void i().then((function(e){e&&(r(),o.onPersonaUpdated.remove(a),t.context.sync()),c(e)}))}c(!1)}))};o.onPersonaUpdated.add(a),t.context.sync()}))}))}})):r()},r.prototype.getOrganizationAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.organization,(function(){var e=i.organization;e.load("*"),i.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e,t){var n=i.organization;n.load("isWarmedUp"),i.context.sync().then((function(){e(n.isWarmedUp)}))}))}))}))},r.prototype.getIsPersonaInfoResolvedCheck=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.personaInfo;r.load("isPersonResolved"),e.context.sync().then((function(){t(r.isPersonResolved)}))}))},r.prototype.getPersonaInfoAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.personaInfo,(function(){var e=i.personaInfo;e.load(),i.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getPersonaInfoWithSourceAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(r,i){var o=t;t.performAsyncOperation(e,PersonaDataUpdated.personaInfo,(function(){var e=new n;e.info=o.personaInfo,e.info.load(),e.source=o.personaInfo.sources,e.source.load(),o.context.sync().then((function(){r(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getUnifiedCommunicationInfo=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.personaInfo,(function(){var e=i.unifiedCommunicationInfo;e.load("*"),i.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getUnifiedGroupInfoAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.personaInfo,(function(){var e=i.unifiedGroupInfo;e.load("*"),i.context.sync().then((function(){n(e)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getTypeAsync=function(t){var n=this;return new OfficeExtension.CoreUtility.Promise((function(r,i){var o=n;n.performAsyncOperation(t,PersonaDataUpdated.personaInfo,(function(){o.load("type"),o.context.sync().then((function(){r(e.PersonaType[o.type.valueOf()])}))}),(function(){return n.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getCustomizationsAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.personaInfo,(function(){var e=i.getCustomizations();i.context.sync().then((function(){n(e.value)}))}),(function(){return t.getIsPersonaInfoResolvedCheck()}))}))},r.prototype.getMembersAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.members,(function(){var e=i.getMembers();e.load("isWarmedUp"),i.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e,t){var n=i.getMembers();n.load("isWarmedUp"),i.context.sync().then((function(){e(n.isWarmedUp)}))}))}))}))},r.prototype.getMembershipAsync=function(e){var t=this;return new OfficeExtension.CoreUtility.Promise((function(n,r){var i=t;t.performAsyncOperation(e,PersonaDataUpdated.membership,(function(){var e=i.getMembership();e.load("*"),i.context.sync().then((function(){n(e)}))}),(function(){return new OfficeExtension.CoreUtility.Promise((function(e){var t=i.getMembership();t.load("isWarmedUp"),i.context.sync().then((function(){e(t.isWarmedUp)}))}))}))}))},r.prototype.getPersonaLifetime=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e;r.load("instanceId"),r.context.sync().then((function(){new i(r.context,r.instanceId).getPersonaLifetime().then((function(e){t(e)}))}))}))},r}();e.PersonaCustom=r;var i=function(){function t(e,t){this.context=e,this.instanceId=t}return Object.defineProperty(t.prototype,"serviceContext",{get:function(){return this.m_serviceConext||(this.m_serviceConext=e.ServiceContext.newObject(this.context)),this.m_serviceConext},enumerable:!0,configurable:!0}),t.prototype.getPersonaLifetime=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getPersonaLifetime(e.instanceId);e.context.sync().then((function(){r.load("instanceId"),e.context.sync().then((function(){t(r)}))}))}))},t.prototype.getInitialPersona=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getInitialPersona(e.instanceId);e.context.sync().then((function(){t(r)}))}))},t.prototype.getLokiTokenProvider=function(){var e=this;return new OfficeExtension.CoreUtility.Promise((function(t,n){var r=e.serviceContext.getLokiTokenProvider(e.instanceId);e.context.sync().then((function(){r.load("instanceId"),e.context.sync().then((function(){t(r)}))}))}))},t}();e.PeopleApiContext=i,function(e){e.FirstPartyDialogService_DialogMessage_EventArgsTransform=function(e,t){return{message:t.message}}}(e._CC||(e._CC={}));var o=function(){function e(){}return Object.defineProperty(e.prototype,"_targetId",{get:function(){return null==this.m_targetId&&(void 0!==OSF&&OSF.OUtil?this.m_targetId=OSF.OUtil.Guid.generateNewGuid():this.m_targetId=""+this.context._nextId()),this.m_targetId},enumerable:!0,configurable:!0}),e}();e.AuthenticationServiceCustom=o,function(e){e.AuthenticationService_TokenReceived_EventArgsTransform=function(e,t){var n=t;return{tokenValue:n.tokenValue,code:n.code,errorInfo:n.errorInfo}}}(e._CC||(e._CC={})),function(e){e.ExternalCodeService_ExternalCodeExecutionCompleted_EventArgsTransform=function(e,t){return{result:t.result}},e.ExternalCodeService_ExternalCodeServiceRequestCompleted_EventArgsTransform=function(e,t){return t},e.ExternalCodeService_ExternalCodeServiceResult_EventArgsTransform=function(e,t){return t}}(e._CC||(e._CC={})),function(e){e.AddinSkillActionService_ReplyReceived_EventArgsTransform=function(e,t){return{actionCorrelationId:t.actionCorrelationId,replyMessage:t.replyMessage,resultCode:t.resultCode}}}(e._CC||(e._CC={})),function(e){e.apiNotAvailable="ApiNotAvailable",e.clientError="ClientError",e.clpSessionError="ClpSessionError",e.controlIdNotFound="ControlIdNotFound",e.docCookieError="DocCookieError",e.entryIdRequired="EntryIdRequired",e.errorPointer="ErrorPointer",e.generalException="GeneralException",e.hostIntegrationManagerError="HostIntegrationManagerError",e.hostRestartNeeded="HostRestartNeeded",e.instanceNotFound="InstanceNotFound",e.interactiveFlowAborted="InteractiveFlowAborted",e.invalidArgument="InvalidArgument",e.invalidGrant="InvalidGrant",e.invalidResourceUrl="InvalidResourceUrl",e.invalidRibbonDefinition="InvalidRibbonDefinition",e.labelingDisabledAppguard="LabelingDisabledAppguard",e.labelingDisabledNoSignedInClpCompatibleUsers="LabelingDisabledNoSignedInClpCompatibleUsers",e.labelingDisabledPrivacySettings="LabelingDisabledPrivacySettings",e.labelingDisabledProtectedView="LabelingDisabledProtectedView",e.labelingDisabledUnsupportedLabelClient="LabelingDisabledUnsupportedLabelClient",e.msoOLDocumentError="MsoOLDocumentError",e.notImplement="NotImplement",e.objectNotFound="ObjectNotFound",e.officeJSItemLabelForIdentityError="OfficeJSItemLabelForIdentityError",e.officeJSRMSLicenseError="OfficeJSRMSLicenseError",e.officeJSSessionOrDocError="OfficeJSSessionOrDocError",e.officeSolutionFrameworkHostError="OfficeSolutionFrameworkHostError",e.omworkflowUserNotFound="OMWorkflowUserNotFound",e.osfControlContainerError="OsfControlContainerError",e.outOfMemory="OutOfMemory",e.resourceNotSupported="ResourceNotSupported",e.sensitivityDocumentReadOnly="SensitivityDocumentReadOnly",e.sensitivityInsufficientPermission="SensitivityInsufficientPermission",e.sensitivityLabelDisabled="SensitivityLabelDisabled",e.sensitivityLabelingDisabled="SensitivityLabelingDisabled",e.sensitivityLabelNotFound="SensitivityLabelNotFound",e.sensitivityNewLabelSensitivityOrder="SensitivityNewLabelSensitivityOrder",e.sensitivityUnsupportedContentType="SensitivityUnsupportedContentType",e.sensitivityUnsupportedCrossTenant="SensitivityUnsupportedCrossTenant",e.sensitivityUnsupportedDke="SensitivityUnsupportedDke",e.sensitivityUnsupportedUdp="SensitivityUnsupportedUdp",e.serverError="ServerError",e.serviceUrlNotFound="ServiceUrlNotFound",e.sharedRuntimeNotAvailable="SharedRuntimeNotAvailable",e.ticketInvalidParams="TicketInvalidParams",e.ticketNetworkError="TicketNetworkError",e.ticketUnauthorized="TicketUnauthorized",e.ticketUninitialized="TicketUninitialized",e.ticketUnknownError="TicketUnknownError",e.unexpectedError="UnexpectedError",e.unsupportedUserIdentity="UnsupportedUserIdentity",e.userNotSignedIn="UserNotSignedIn"}(e.ErrorCodes||(e.ErrorCodes={})),e.Interfaces||(e.Interfaces={});new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[["1.2","SharedApiUndo"],["1.2","SharedRuntimeInternal"],["1.1","SnapshotControl"],["1.1","SharedApiUndo"],["1.2","DynamicRibbon"],["1.1","DynamicRibbonUndo"],["1.2","FirstPartyAuthentication"],["1.3","FirstPartyAuthentication"],["1.5","FirstPartyAuthentication"],["1.1","SensitivityUndo"],["1.2","SensitivityService"],["1.2","SensitivityUndo"],["1.3","SensitivityService"],["1.3","SensitivityUndo"],["1.1","PrivateAPI"],["1.1","ExternalCodeServiceUndo"],["1.1","TaskpaneAPI"]],strings:["DialogPage","License","LicenseFeature","MsaDeviceTicketOptions","AppRuntimePersistenceService","AppRuntimeService","ThemeService","Tap","MemberInfoList","PersonaActions","PersonaInfoSource","PersonaInfo","PersonaUnifiedCommunicationInfo","PersonaPhotoInfo","PersonaCollection","PersonaOrganizationInfo","UnifiedGroupInfo","Persona","PersonaLifetime","LokiTokenProvider","LokiTokenProviderFactory","ServiceContext","RichapiPcxFeatureChecks","Comment","CommentCollection","ExtensionLifeCycle","OfficeServicesManagerApi","LocaleApi","FirstPartyDialogService","DynamicRibbon","RibbonTab","RibbonButton","RibbonButtonCollection","ServiceUrlProvider","LinkedIn","NetworkUsage","BeforeDocumentCloseNotification","AuthenticationService","RoamingSetting","RoamingSettingCollection","SharedFilePicker","ActionService","Auth","AugLoopEventService","UndoService","UserFeedbackService","NotificationService","SensitivityService","CopilotService","PrivateApiService","ExternalCodeService","BusinessBarService","ShowSimpleDialog","DispatchApiService","DevicePermissionService","TaskpaneService","AddinSkillActionService","UnifiedStoreService","close","registerOnShow","unregisterOnShow","id","_RegisterStateChange","_UnregisterStateChange","","null","registerOfficeThemeChangedEvent","unregisterOfficeThemeChangedEvent","isWarmedUp","isWarmingUp","displayName","email","emailAddresses","sipAddresses","birthday","birthdays","title","jobInfoDepartment","companyName","office","linkedTitles","linkedDepartments","linkedCompanyNames","linkedOffices","webSites","notes","getImageUri","setPlaceholderColor","getPlaceholderUri","getImageUriWithMetadata","getCount","getItem","instanceId","dispose","_RegisterPersonaUpdatedEvent","_UnregisterPersonaUpdatedEvent","this.instanceId","_RegisterLokiTokenAvailableEvent","_UnregisterLokiTokenAvailableEvent","_RegisterIdentityUniqueIdAvailableEvent","_UnregisterIdentityUniqueIdAvailableEvent","_RegisterClientAccessTokenAvailableEvent","_UnregisterClientAccessTokenAvailableEvent","getLokiTokenProvider","registerIdentityChangedEvent","unregisterIdentityChangedEvent","_RegisterHostMessageReceivedEvent","_UnregisterHostMessageReceivedEvent","_RegisterUndoStackChangedEvent","_UnregisterUndoStackChangedEvent","_RegisterUserFeedbackUIDismissedEvent","_UnregisterUserFeedbackUIDismissedEvent","_RegisterUserFeedbackResponseEvent","_UnregisterUserFeedbackResponseEvent","_RegisterSensitivityLabelChangedEvent","_UnregisterSensitivityLabelChangedEvent","execute","_RegisterPrivateApiEvent","_UnregisterPrivateApiEvent","registerExternalCodeExecutionCompletedEvent","unregisterExternalCodeExecutionCompletedEvent","registerExternalCodeServiceRequestCompletedEvent","unregisterExternalCodeServiceRequestCompletedEvent","registerExternalCodeServiceResultEvent","unregisterExternalCodeServiceResultEvent","_RegisterCopilotAgentEvent","_UnregisterCopilotAgentEvent"],enumTypes:[["DialogPageEventType",[],{onShow:1}],["LicenseFeatureTier",["unknown","basic","premium"]],["LicenseEventType",[],{featureStateChanged:1}],["AppRuntimeState",["inactive","background","visible"]],["Visibility",["hidden","visible"]],["ObjectType",["unknown","chart","smartArt","table","image","slide","text"],{ole:"OLE"}],["PersonaCardPerfPoint",["placeHolderRendered","initialCardRendered"]],["MessageType",[],{personaLifetimePersonaUpdatedEvent:3502,lokiTokenProviderLokiTokenAvailableEvent:3503,lokiTokenProviderIdentityUniqueIdAvailableEvent:3504,lokiTokenProviderClientAccessTokenAvailableEvent:3505}],["UnifiedCommunicationAvailability",["notSet","free","idle","busy","idleBusy","doNotDisturb","unalertable","unavailable"]],["UnifiedCommunicationStatus",["online","notOnline","away","busy","beRightBack","onThePhone","outToLunch","inAMeeting","outOfOffice","doNotDisturb","inAConference","getting","notABuddy","disconnected","notInstalled","urgentInterruptionsOnly","mayBeAvailable","idle","inPresentation"]],["UnifiedCommunicationPresence",["free","busy","idle","doNotDistrub","blocked","notSet","outOfOffice"]],["FreeBusyCalendarState",["unknown","free","busy","elsewhere","tentative","outOfOffice"]],["PersonaType",["unknown","enterprise","contact","bot","phoneOnly","oneOff","distributionList","personalDistributionList","anonymous","unifiedGroup"]],["PhoneType",["workPhone","homePhone","mobilePhone","businessFax","otherPhone"]],["AddressType",["workAddress","homeAddress","otherAddress"]],["MemberType",["unknown","individual","group"]],["PersonaDataUpdated",["hostId","type","photo","personaInfo","unifiedCommunicationInfo","organization","unifiedGroupInfo","members","membership","capabilities","customizations","viewableSources","placeholder"]],["CustomizedData",["email","workPhone","workPhone2","workFax","mobilePhone","homePhone","homePhone2","otherPhone","sipAddress","profile","office","company","workAddress","homeAddress","otherAddress","birthday"]],["CommentTextFormat",["plain","markdown","delta"]],["TimeStringFormat",["shortTime","longTime","shortDate","longDate"]],["ServiceProvider",["ariaBrowserPipeUrl","ariaUploadUrl","ariaVNextUploadUrl","lokiAutoDiscoverUrl"]],["IdentityType",["organizationAccount","microsoftAccount","unsupported"]],["AugLoopEventType",[],{onHostMessageReceivedEvent:65542}],["UndoType",[],{onUndoStackChangedEvent:65543,onCopilotOperationStartedEvent:65544}],["TriStateOption",["notSet","true","false"]],["UserFeedbackType",["like","dislike","idea","unclassified"]],["UserFeedbackUIType",["modalDialog","taskpane"]],["UserFeedbackEventType",[],{onUserFeedbackUIDismissedEvent:65546,onUserFeedbackResponseEvent:65550}],["UserFeedbackScreenshotInfoSourceType",["autoCapture","autoCaptureWithHtml2Canvas","providedAtInitialization","dynamicallyProvided"]],["UserFeedbackScreenshotInfoImageFormat",[],{jpeg:"jpeg",png:"png"}],["LabelMessageContext",[],{generic:0,firstPerson:1}],["LabelResultSeverity",[],{info:0,warning:1,error:2}],["SensitivityLabelEventType",[],{onLabelChangedEvent:65549}],["EncryptionType",[],{none:0,irmtemplate:1,irmuserDefinedPermission:2,irmencryptOnly:3,irmdoNotForward:4}],["TryUpgradeLabelError",[],{s_APPLYLABEL_OK:0,e_APPLYLABEL_FAIL:2147467259,e_APPLYLABEL_UNSUPPORTED_CROSSTENANT:2147205120,e_APPLYLABEL_DOCUMENT_READONLY:2147205119,e_APPLYLABEL_INSUFFICIENTPERMISSION:2147205118,e_APPLYLABEL_LABELDISABLED:2147205117,e_APPLYLABEL_UNSUPPORTED_UDP:2147205116,e_APPLYLABEL_LABELING_DISABLED:2147205115,e_APPLYLABEL_UNSUPPORTED_CONTENTTYPE:2147205114,e_APPLYLABEL_UNSUPPORTED_DKE:2147205113,e_APPLYLABEL_LABELNOTFOUND:2147205112,e_APPLYLABEL_USERNOTFOUND:2147220727,e_APPLYLABEL_NEWLABELSENSITIVITYORDER:2147205105}],["PrivateApiEventType",[],{onPrivateEvent:65552}],["RequestMethod",["get","post","patch","delete"]],["ResultType",["executionResult","runtimeInfo","serviceResponse"]],["ErrorCategory",["other","environment","runtime","license","user","auth","billing","invalidArg","python","service","unsupported","dataUpload"]],["BusinessBarType",["info","error","blocked","severeWarning","success","warning"]],["SimpleDialogState",[],{cancel:0,confirm:1,checkedConfirm:2}],["SimpleDialogCategory",[],{information:"information",error:"error",warning:"warning",question:"question",other:"other"}],["DevicePermissionType",[],{camera:"camera",microphone:"microphone",geolocation:"geolocation"}],["CopilotAgentEventType",[],{onCopilotAgentEvent:65556}]],clientObjectTypes:[[1,0,[["_Id",2]],0,[[59,0,2,0,4],["readyToShow",0,2,0,4],[60,0,2,0,4],[61,0,2,0,4],["sendMessageToHost",1,2,0,4]],0,0,0,[["OnShowEvent",0,0,"DialogPageEventType.onShow","this._Id",60,61]],"Microsoft.Office.DialogPage.DialogPage",4],[2,0,0,0,[["isFeatureEnabled",2,2,0,4],["getFeatureTier",2,2,0,4],["isFreemiumUpsellEnabled",0,2,0,4],["launchUpsellExperience",1,2,0,4],["_TestFireStateChangedEvent",1,0,0,3,0,1],["getMsaDeviceTicket",3,2,0,5]],[["getLicenseFeature",3,1,2,0,4]],0,0,0,"Microsoft.Office.Licensing.License",4],[3,0,[[62,3]],0,[[63,0,2,0,4],[64,0,2,0,4]],0,0,0,[["StateChanged",2,0,"LicenseEventType.featureStateChanged","this.id",63,64]]],[4,0,[["scopes",1,0,0,2,1]],0,0,0,0,0,0,"Microsoft.Office.Licensing.MsaDeviceTicketOptions",4],[5,0,0,0,[["setAppRuntimeStartState",1,0,0,2,0,2],["getAppRuntimeStartState",0,2,0,4]],0,0,0,0,"Microsoft.AppRuntime.AppRuntimePersistenceService",4],[6,0,0,0,[["setAppRuntimeState",1,0,0,2,0,2],["getAppRuntimeState",0,2,0,4],["setSnapshotEnabled",1,2,3,4],["getSnapshotEnabled",0,2,3,4],["getContentSnapshotAsBase64",0,2,3,4]],0,0,0,[["SnapshotImageReady",0,3,"65547",65,66,66],["VisibilityChanged",0,0,"65539",65,66,66]],"Microsoft.AppRuntime.AppRuntimeService",4],[7,0,0,0,[[67,0,0,0,2,0,4],[68,0,0,0,2,0,4]],0,0,0,[["OfficeThemeChanged",2,0,"65548",65,67,68]],"Microsoft.Theme.ThemeService",4],[8,0,0,0,[["getEnterpriseUserInfo",0,2,0,5],["getMruFriendlyPath",1,2,0,5],["launchFileUrlInOfficeApp",2,2,0,5],["performLocalSearch",4,2,0,5],["readSearchCache",3,2,0,5],["writeSearchCache",3,2,0,5]],0,0,0,0,"Microsoft.TapRichApi.Tap",4],[9,0,[[69,3],[70,3]],0,[["items",0,2,0,4]],[["getPersonaForMember",18,1,2,0,4]]],[10,0,0,0,[["addContact"],["editContact"],["composeEmail",1],["composeInstantMessage",1],["callPhoneNumber",1],["pinPersonaToQuickContacts"],["toggleTagForAlerts"],["scheduleMeeting"],["openLinkContactUx"],["editContactByIdentifier",1],["showHoverCardForPersona",6],["hideHoverCardForPersona"],["showContextMenu",6],["showContactCard",6],["showExpandedCard",6],["openGroupCalendar"],["subscribeToGroup"],["unsubscribeFromGroup"],["getChangePhotoUrlAndOpenInBrowser"],["startAudioCall"],["startVideoCall"],["openOutlookProperties"],["editUnifiedGroup"],["joinUnifiedGroup"],["leaveUnifiedGroup"]]],[11,0,[[71,3],[72,3],[73,3],[74,3],[75,3],[76,3],[77,3],[78,3],[79,3],[80,3],[81,3],[82,3],[83,3],[84,3],["phones",3],["addresses",3],[85,3],[86,3]]],[12,0,[[71,3],[72,3],[73,3],[74,3],[75,11],[76,11],[77,3],[78,3],[79,3],[80,3],[81,3],[82,3],[83,3],[84,3],[85,3],[86,3],["isPersonResolved",3]],[["sources",11,3,0,0,4]],[["getPhones",0,2,0,4],["getAddresses",0,2,0,4]]],[13,0,[["availability",3],["status",3],["isSelf",3],["isTagged",3],["customStatusString",3],["isBlocked",3],["presenceTooltip",3],["isOutOfOffice",3],["outOfOfficeNote",3],["timezone",3],["meetingLocation",3],["meetingSubject",3],["timezoneBias",3],["idleStartTime",11],["overallCapability",3],["isOnBuddyList",3],["presenceNote",3],["voiceMailUri",3],["availabilityText",3],["availabilityTooltip",3],["isDurationInAvailabilityText",3],["freeBusyStatus",3],["calendarState",3],["presence",3]]],[14,0,0,0,[[87,1,2,0,4,87],[88,1,0,0,0,88],[89,1,2,0,4,89],[90,1,2,0,4,90]]],[15,1,0,0,[[91,0,2,0,4]],[[92,18,1,18,0,4]],0,18],[16,0,[[69,3],[70,3]],[["hierarchy",15,18,0,0,4],["manager",18,2,0,0,4],["directReports",15,18,0,0,4]]],[17,0,[["description",1],["oneDrive",1],["oneNote",1],["isPublic",1],["amIOwner",1],["amIMember",1],["amISubscribed",1],["memberCount",1],["ownerCount",1],["hasGuests",1],["site",1],["planner",1],["classification",1],["subscriptionEnabled",1]]],[18,4,[["hostId",3],["type",3],["capabilities",3],["diagnosticId",3],[93,3]],[["photo",14,3,0,0,4],["personaInfo",12,3,0,0,4],["unifiedCommunicationInfo",13,3,0,0,4],["organization",16,3,0,0,4],["unifiedGroupInfo",17,35,0,0,4],["actions",10,2,0,0,4]],[["getCustomizations",0,2,0,4],["warmup",1],[94],["getViewableSources",0,2,0,4],["reportTimeForRender",2]],[["getMembers",9,0,2,0,4],["getMembership",9,0,2,0,4]]],[19,0,[[93,3]],0,[["getPolicies",0,2,0,4],[95],[96],["getTextScaleFactor",0,2,0,4]],[["getPersona",18,1,2,0,4],["getPersonaForOrgEntry",18,4,2,0,4],["getPersonaForOrgByEntryId",18,4,2,0,4]],0,0,[["PersonaUpdated",0,0,"MessageType.personaLifetimePersonaUpdatedEvent",97,95,96]]],[20,0,[["emailOrUpn",3],[93,3]],0,[["requestToken"],[98],[99],["requestIdentityUniqueId"],[100],[101],["requestClientAccessToken"],[102],[103]],0,0,0,[["ClientAccessTokenAvailable",0,0,"MessageType.lokiTokenProviderClientAccessTokenAvailableEvent",97,102,103],["IdentityUniqueIdAvailable",0,0,"MessageType.lokiTokenProviderIdentityUniqueIdAvailableEvent",97,100,101],["LokiTokenAvailable",0,0,"MessageType.lokiTokenProviderLokiTokenAvailableEvent",97,98,99]]],[21,0,0,0,0,[[104,20,1,2,0,4]],0,0,0,"Microsoft.People.LokiTokenProviderFactory",4],[22,0,0,0,[[94,1],["accountEmailOrUpn",1,2,0,4],["getPersonaPolicies",0,2,0,4]],[[104,20,1,2,0,4],["getPersonaLifetime",19,1,2,0,4],["getInitialPersona",18,1,2,0,4]],0,0,0,"Microsoft.People.ServiceContext",4],[23,0,0,0,[["isAddChangePhotoLinkOnLpcPersonaImageFlightEnabled",0,2,0,4]],0,0,0,0,"Microsoft.People.RichapiPcxFeatureChecks",4],[24,0,[[62,3],["text",1],["created",11],["level",3],["resolved",1],["author",3],["mentions",3]],[["parent",24,2,0,0,4],["parentOrNullObject",24,2,0,0,4],["replies",25,19,0,0,4]],[["getRichText",1,2,0,4],["setRichText",2],["delete"]],[["getParentOrSelf",24,0,2,0,4],["reply",24,2]]],[25,1,0,0,[[91,0,2,0,4]],[[92,24,1,18,0,4]],0,24],[26,0,0,0,[["launchExtensionComponent",3,2,0,5]],0,0,0,0,"Microsoft.OfficeSharedApi.ExtensionLifeCycle",4],[27,0,0,0,[["bindServiceToProfile",3]],0,0,0,0,"Microsoft.OfficeServicesManager.OfficeServicesManagerApi",4],[28,0,0,0,[["getLocaleDateTimeFormattingInfo",1,2,0,4],["formatDateTimeString",3,2,0,4]],0,0,0,0,"Microsoft.LocaleApi.LocaleApi",4],[29,0,0,0,[["displayDialog",2,2,0,5],[59,0,2,0,5]],0,0,0,[["DialogMessage",2,0,"65536",65,66,66]],"Microsoft.FirstPartyDialog.FirstPartyDialogService",4],[30,0,0,[["buttons",33,19,0,0,4]],[["executeRequestUpdate",1,2,0,4],["executeRequestCreate",1,2,5,4]],[["getButton",32,1,2,0,4],["getTab",31,1,2,0,4]],0,0,0,"Microsoft.DynamicRibbon.DynamicRibbon",4],[31,0,[[62,3]],0,[["setVisibility",1,0,0,2,0,6]]],[32,0,[[62,3],["enabled",1,0,0,2,6],["label",3]],0,[["setEnabled",1,0,0,2,0,6]]],[33,1,0,0,[[91,0,2,0,4]],[[92,32,1,18,0,4]],0,32],[34,0,0,0,[["getServiceUrl",2,2,0,4]],0,0,0,0,"Microsoft.DesktopCompliance.ServiceUrlProvider",4],[35,0,0,0,[["isEnabledForOffice",0,2,0,4],["recordLinkedInSettingsCompliance",2]],0,0,0,0,"Microsoft.DesktopCompliance.LinkedIn",4],[36,0,0,0,[["isInOnlineMode",0,2,0,4],["isInDisconnectedMode",0,2,0,4]],0,0,0,0,"Microsoft.DesktopCompliance.NetworkUsage",4],[37,0,0,0,[["enable",0,2,0,4],["disable",0,2,0,4]],0,0,0,[["BeforeCloseNotificationCancelled",0,0,"65540",65,66,66]],"Microsoft.BeforeDocumentCloseNotification.BeforeDocumentCloseNotification",4],[38,4,0,[["roamingSettings",40,2,0,0,4]],[["getAccessToken",2,2,0,5],["getPrimaryIdentityInfo",0,2,7,5],["getIdentities",0,2,8,5],[105,0,0,9,3,0,4],[106,0,0,9,3,0,4]],0,0,0,[["IdentityChanged",0,9,"65545",65,105,106],["TokenReceived",2,7,"3001","this._targetId",66,66]],"Microsoft.Authentication.AuthenticationService",4],[39,0,[[62,3],["value",1,0,0,2,4]]],[40,0,0,0,0,[[92,39,1,2,0,4],["getItemOrNullObject",39,1,2,0,4]]],[41,0,0,0,[["getSharedFilePickerResponse",1,2,0,4]],0,0,0,0,"Microsoft.Office.SharedFilePicker",4],[42,0,0,0,[["getShortcuts",0,2,0,4],["replaceShortcuts",1,0,0,2,0,4],["areShortcutsInUse",1,0,0,2,0,4]],0,0,0,0,"Microsoft.Office.ActionService",4],[43,0,0,0,[["getAccessTokenFirstPartyOAuth",2,2,0,5]],0,0,0,0,"Microsoft.Office.Auth",5],[44,0,0,0,[["sendMessage",1,2,0,5],[107,0,2,0,5],[108,0,2,0,5]],0,0,0,[["HostMessageReceived",0,0,"AugLoopEventType.onHostMessageReceivedEvent",65,107,108]],"Microsoft.Office.AugLoopEventService",5],[45,0,0,0,[["undo",0,0,0,1],[109,0,2,0,5],[110,0,2,0,5],["startCopilotOperation",1,0,0,1],["endCopilotOperation",1,0,0,1]],0,0,0,[["CopilotOperationStarted",0,0,"UndoType.onCopilotOperationStartedEvent",65,66,66],["UndoStackChanged",0,0,"UndoType.onUndoStackChangedEvent",65,109,110]],"Microsoft.Office.UndoService",5],[46,0,0,0,[["collectUserFeedback",4,2,0,5],[111,0,2,0,5],[112,0,2,0,5],["canCollectUserFeedback",0,2,0,5],[113,0,2,0,5],[114,0,2,0,5],["getInitializationData",0,2,0,5],["getHostScreenshot",0,2,0,5],["invokeDiagnosticsLogsUpload",1,2,0,5],["canCollectCopilotFeedback",0,2,0,5]],0,0,0,[["UserFeedbackResponse",0,0,"UserFeedbackEventType.onUserFeedbackResponseEvent",65,113,114],["UserFeedbackUIDismissed",0,0,"UserFeedbackEventType.onUserFeedbackUIDismissedEvent",65,111,112]],"Microsoft.Office.UserFeedbackService",5],[47,0,0,0,[["addNotification",2,0,0,3,0,1],["updateNotification",2,0,0,3,0,1],["removeNotification",1,0,0,3,0,1]],0,0,0,0,"Microsoft.Office.NotificationService",5],[48,0,0,0,[["getLabel",0,0,0,3,0,10],["tryUpgradeLabel",2,0,0,3,0,10],["getHighestSensitivityLabel",1,0,0,3,0,10],[115,0,2,0,5],[116,0,2,0,5],["getSensitivityResultDetails",2,0,11,3,0,12],["getSensitivityResultDetailsByStringErrorCode",2,0,13,3,0,14]],0,0,0,[["LabelChanged",0,0,"SensitivityLabelEventType.onLabelChangedEvent",65,115,116]],"Microsoft.Office.SensitivityService",5],[49,0,0,0,[["launchHelpPaneByQuery",1,0,0,1],["launchHelpPaneByArticleId",1,0,0,1],["launchHelpPaneByArticleIdString",1,0,0,1]],0,0,0,0,"Microsoft.Office.CopilotService",5],[50,0,0,0,[[117,1,0,0,3,0,15],[118,0,2,0,5],[119,0,2,0,5]],0,0,0,[["OnPrivateEvent",0,0,"PrivateApiEventType.onPrivateEvent",65,118,119]],"Microsoft.Office.PrivateApiService",5],[51,0,0,0,[["executePythonCode",1,0,0,3,0,16],["executePythonCodeAsync",1,0,0,3,0,16],[120,0,0,0,3,0,16],[121,0,0,0,3,0,16],["executePythonCodeAsync2",2,0,0,3,0,16],["sendRequestAsync",4,2,0,5],[122,0,2,0,5],[123,0,2,0,5],["getRuntimeInfoAsync",0,2,0,5],[124,0,0,0,3,0,16],[125,0,0,0,3,0,16],["getRuntimeInfoAsync2",1,2,0,5]],0,0,0,[["ExternalCodeExecutionCompleted",2,0,"65551",65,120,121],["ExternalCodeServiceRequestCompleted",2,0,"65553",65,122,123],["ExternalCodeServiceResult",2,0,"65554",65,124,125]],"Microsoft.Office.ExternalCodeService",5],[52,0,0,0,[["show",2,0,0,3,0,4],["hide",1,0,0,3,0,4]],0,0,0,0,"Microsoft.Office.BusinessBarService",5],[53,0,0,0,[["launchSimpleDialog",8,0,0,3]],0,0,0,0,"Microsoft.Office.ShowSimpleDialog",5],[54,0,0,0,[[117,2,2,0,5]],0,0,0,0,"Microsoft.Office.DispatchApiService",5],[55,0,0,0,[["requestPermissions",1,2,0,5]],0,0,0,0,"Microsoft.Office.DevicePermissionService",5],[56,0,0,0,[["notifyHeaderLoaded",0,0,0,3,0,17],[59,0,0,0,3,0,17],["move",0,0,0,3,0,17]],0,0,0,0,"Microsoft.Office.TaskpaneService",5],[57,0,0,0,[["invokeAction",4,2,0,5]],0,0,0,[["ReplyReceived",2,0,"65555",65,66,66]],"Microsoft.Office.AddinSkillActionService",5],[58,0,0,0,[["launchStoreDialogWithCopilotAgentPageShown",0,0,0,3],[126,0,2,0,5],[127,0,2,0,5]],0,0,0,[["CopilotAgentEvent",0,0,"CopilotAgentEventType.onCopilotAgentEvent",65,126,127]],"Microsoft.Office.UnifiedStoreService",5]]},targetNamespaceObject:e})}(OfficeCore||(OfficeCore={})),function(e){var t,n;!function(e){e.hidden="Hidden",e.taskpane="Taskpane"}(t=e.VisibilityMode||(e.VisibilityMode={})),function(e){e.none="None",e.load="Load"}(n=e.StartupBehavior||(e.StartupBehavior={})),function(e){function r(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}function i(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=r(!0),OfficeCore.AppRuntimeService.newObject(t).setAppRuntimeState(e),[4,t.sync()];case 1:return n.sent(),[2]}}))}))}var o;e.setStartupBehavior=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i;return __generator(this,(function(o){switch(o.label){case 0:if(e!==n.load&&e!==n.none)throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.invalidArgument,null,null);return t=e==n.load?OfficeCore.AppRuntimeState.background:OfficeCore.AppRuntimeState.inactive,i=r(!1),OfficeCore.AppRuntimePersistenceService.newObject(i).setAppRuntimeStartState(t),[4,i.sync()];case 1:return o.sent(),[2]}}))}))},e.getStartupBehavior=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,i,o;return __generator(this,(function(a){switch(a.label){case 0:return e=r(!1),t=OfficeCore.AppRuntimePersistenceService.newObject(e),i=t.getAppRuntimeStartState(),[4,e.sync()];case 1:return a.sent(),o=i.value,[2,o==OfficeCore.AppRuntimeState.inactive?n.none:n.load]}}))}))},e.setSnapshotEnabled=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=r(!0),OfficeCore.AppRuntimeService.newObject(t).setSnapshotEnabled(e),[4,t.sync()];case 1:return n.sent(),[2,Promise.resolve()]}}))}))},e.getSnapshotEnabled=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(i){switch(i.label){case 0:return e=r(!0),t=OfficeCore.AppRuntimeService.newObject(e),n=t.getSnapshotEnabled(),[4,e.sync()];case 1:return i.sent(),[2,n.value]}}))}))},e.getContentSnapshotAsBase64=function(){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(e){return[2,new OfficeExtension.CoreUtility.Promise((function(e,t){var n=r(!0),i=OfficeCore.AppRuntimeService.newObject(n),o=setTimeout((function(){a.remove(),n.sync().catch((function(){})),t(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"timeout","getContentSnapshotAsBase64"))}),7e3),a=i.onSnapshotImageReady.add((function(r){return clearTimeout(o),a.remove(),OfficeExtension.CoreUtility.isNullOrUndefined(r)?(n.sync().catch((function(){})),t(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"execution failed","getContentSnapshotAsBase64"))):(n.sync().catch((function(){})),e(r.imageBase64)),null}));n.sync().then((function(){i.getContentSnapshotAsBase64();return n.sync().then((function(){return null}))})).catch((function(e){t(e)}))}))]}))}))},e._getState=function(){return __awaiter(this,void 0,void 0,(function(){var e,t,n;return __generator(this,(function(i){switch(i.label){case 0:return e=r(!0),t=OfficeCore.AppRuntimeService.newObject(e),n=t.getAppRuntimeState(),[4,e.sync()];case 1:return i.sent(),[2,n.value]}}))}))},e.showAsTaskpane=function(){return i(OfficeCore.AppRuntimeState.visible)},e.hide=function(){return i(OfficeCore.AppRuntimeState.background)},e.onVisibilityModeChanged=function(e){return __awaiter(this,void 0,void 0,(function(){var n,i,a=this;return __generator(this,(function(s){switch(s.label){case 0:return n=function(){if(!o){var e=r(!0);o=OfficeCore.AppRuntimeService.newObject(e)}return o}(),i=n.onVisibilityChanged.add((function(n){if(e){var r={visibilityMode:(i=n.visibility,i===OfficeCore.Visibility.visible?t.taskpane:t.hidden)};e(r)}var i;return null})),[4,n.context.sync()];case 1:return s.sent(),[2,function(){return __awaiter(a,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.remove(),[4,n.context.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},function(e){function t(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}e.enable=function(){return __awaiter(this,void 0,void 0,(function(){var e,n;return __generator(this,(function(r){switch(r.label){case 0:return e=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e=!0),n=t(e),OfficeCore.BeforeDocumentCloseNotification.newObject(n).enable(),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.disable=function(){return __awaiter(this,void 0,void 0,(function(){var e,n;return __generator(this,(function(r){switch(r.label){case 0:return e=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e=!0),n=t(e),OfficeCore.BeforeDocumentCloseNotification.newObject(n).disable(),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.onCloseActionCancelled=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a=this;return __generator(this,(function(s){switch(s.label){case 0:return n=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(n=!0),r=t(n),i=OfficeCore.BeforeDocumentCloseNotification.newObject(r),o=i.onBeforeCloseNotificationCancelled.add((function(t){return e&&e(),null})),[4,r.sync()];case 1:return s.sent(),[2,function(){return __awaiter(a,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.remove(),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.beforeDocumentCloseNotification||(e.beforeDocumentCloseNotification={}))}(e.addin||(e.addin={}))}(Office||(Office={})),function(e){var t,n;!function(e){e.taskpane="Taskpane",e.dialog="Dialog"}(t||(t={})),function(n){function r(e){return new OfficeCore.RequestContext}!function(e){function t(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}e.close=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).close(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))},e.move=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).move(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))},e.notifyHeaderLoaded=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(n){switch(n.label){case 0:return e=t(),OfficeCore.TaskpaneService.newObject(e).notifyHeaderLoaded(),[4,e.sync()];case 1:return n.sent(),[2]}}))}))}}(n.taskpane||(n.taskpane={})),n.launchTaskpane=function(n){return __awaiter(this,void 0,void 0,(function(){var i,o,a,s,c;return __generator(this,(function(u){switch(u.label){case 0:return e.context.platform&&"OfficeOnline"===e.context.platform?(i={SharedRuntimeId:n.sharedRuntimeId,SourceLocationOverrideResourceId:n.sourceLocationOverride,TaskPaneTitle:n.taskpaneTitle,TaskPaneWidth:n.taskpaneWidth},o={OptionalProperties:i,DevProperties:n.settings},e.context.extensionLifeCycle.launchExtensionComponent(null,"Taskpane",null,null,o),[3,3]):[3,1];case 1:return a=r(),s=OfficeCore.ExtensionLifeCycle.newObject(a),c=n.settings,n.settings=c&&OSF.OUtil.serializeSettings(c),s.launchExtensionComponent("",t.taskpane,n),[4,a.sync()];case 2:u.sent(),u.label=3;case 3:return[2]}}))}))},n.launchDialog=function(n){return __awaiter(this,void 0,void 0,(function(){var i,o,a,s,c;return __generator(this,(function(u){switch(u.label){case 0:return e.context.platform&&"OfficeOnline"===e.context.platform?(i={SharedRuntimeId:n.sharedRuntimeId,SourceLocationOverrideResourceId:n.sourceLocationOverride},o={OptionalProperties:i,DevProperties:n.settings},e.context.extensionLifeCycle.launchExtensionComponent(null,"SDXDialog",null,null,o),[3,3]):[3,1];case 1:return a=r(),s=OfficeCore.ExtensionLifeCycle.newObject(a),c=n.settings,n.settings=c&&OSF.OUtil.serializeSettings(c),s.launchExtensionComponent("",t.dialog,n),[4,a.sync()];case 2:u.sent(),u.label=3;case 3:return[2]}}))}))}}(n=e.ExtensionLifeCycle||(e.ExtensionLifeCycle={})),e.extensionLifeCycle=n}(Office||(Office={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}e.requestUpdate=function(e){var n=t(),r=n.ribbon;function i(e){void 0!==e.controls&&void 0!==e.controls.length&&e.controls.length&&e.controls.filter((function(e){return!!e.id})).forEach((function(e){var t=r.getButton(e.id);void 0!==e.enabled&&null!==e.enabled&&(t.enabled=e.enabled)}))}return e.tabs.filter((function(e){return!!e.id})).forEach((function(e){var t=r.getTab(e.id);void 0!==e.visible&&null!==e.visible&&t.setVisibility(e.visible),e.groups&&e.groups.length?e.groups.filter((function(e){return!!e.id})).forEach((function(e){i(e)})):i(e)})),n.sync()},e.requestCreateControls=function(e){var n,r=t();return r.ribbon.executeRequestCreate(JSON.stringify(e)),(n=250,new Promise((function(e,t){return setTimeout((function(){return e()}),n)}))).then((function(){return r.sync()}))}}(e.ribbon||(e.ribbon={}))}(Office||(Office={})),function(e){var t;OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;!function(e){e.generalException="GeneralException"}(t||(t={}));new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[],strings:["AddinInternalService"],enumTypes:[],clientObjectTypes:[[1,0,0,0,[["notifyActionHandlerReady",0,2,0,4]],0,0,0,0,"Microsoft.InternalService.AddinInternalService",4]]},targetNamespaceObject:e})}(OfficeCore||(OfficeCore={})),function(e){var t;!function(t){var n,r,i=OfficeExtension.Utility.isNullOrUndefined;function o(e){if(e){var t=e.toUpperCase(),r=n.mappings[t];if(!i(r)&&"function"==typeof r)return r}throw OfficeExtension.Utility.createRuntimeError("invalidOperation","sourceData","ActionProxy._getFunction")}function a(e){try{OfficeExtension.Utility.log("ActionProxy._handleMessage"),OfficeExtension.Utility.checkArgumentNull(e,"args");for(var t=e.entries,n=function(e){if(2!==t[e].messageCategory)return"continue";if("string"==typeof t[e].message&&(t[e].message=JSON.parse(t[e].message)),1e3===t[e].messageType){var n=null,r=o(c=t[e].message[0]);if(t[e].message.length>=2){var a=t[e].message[1];a&&(n=function(e){if("string"==typeof e&&"{"===e[0])return!0;return!1}(a)?JSON.parse(a):a)}void 0!==OSF&&OSF.AppTelemetry&&OSF.AppTelemetry.CallOnAppActivatedIfPending&&OSF.AppTelemetry.CallOnAppActivatedIfPending(),r.apply(null,[n])}else if(1001===t[e].messageType){if(i(window.external))throw new OfficeExtension.Error({code:"GenericException",message:"API currently unsupported."});n=null;var c=t[e].message[0],u=t[e].message[1],l=JSON.parse(u);n=l.message;var f=l.replyId,p=0;r=null;try{r=o(c)}catch(e){s(e),p=4}var d=null;if(0==p)try{d=r.apply(null,[n])}catch(e){s(e),p=1}0==p&&i(d)?p=2:0!=p||"object"==typeof d&&"function"==typeof d.then||(p=3);var h=i(OSF.MethodDispId)?OSF.DDA.MethodDispId.dispidAddinSkillActionReply:OSF.MethodDispId.dispidAddinSkillActionReply;if(0==p)try{d.then((function(e){"string"!=typeof e&&(e="",p=3),window.external.Execute(h,[f,e,p],null)}),(function(e){var t="";p=1,"string"==typeof e?t=e:s(e),window.external.Execute(h,[f,t,p],null)}))}catch(e){p=3,s(e),window.external.Execute(h,[f,"",p],null)}else try{window.external.Execute(h,[f,"",p],null)}catch(e){s(e)}}else OfficeExtension.Utility.log("ActionProxy._handleMessage unknown message type "+t[e].messageType)},r=0;r<t.length;r++)n(r)}catch(e){throw s(e),e}return OfficeExtension.Utility._createPromiseFromResult(null)}function s(e){var t=function(e){var t="Unknown Error";if(e)try{e.toString&&(t=e.toString()),t=t+" "+JSON.stringify(e)}catch(e){t="Unexpected Error"}return t}(e);OfficeExtension.Utility.log(t)}function c(){try{Microsoft.Office.WebExtension.onReadyInternal().then((function(){return function(){if(void 0!==OSF&&OSF.DDA&&OSF.DDA.RichApi&&OSF.DDA.RichApi.richApiMessageManager)return(new OfficeExtension.ClientRequestContext).eventRegistration.register(5,"",a)}()})).then((function(){var e,t,n=OSF._OfficeAppFactory.getHostInfo();return!0===n.isDialog||"web"===n.hostPlatform&&"word"!==n.hostType&&"excel"!==n.hostType?void 0:(e=new OfficeExtension.ClientRequestContext,t=OfficeCore.AddinInternalService.newObject(e),e._customData="WacPartition",t.notifyActionHandlerReady(),e.sync())}))}catch(e){}}OfficeExtension.Utility.log("ActionProxy.initOnce"),void 0!==e.actions&&(r=e.actions._association,n=r),"undefined"!=typeof document&&(document.readyState&&"loading"!==document.readyState?(OfficeExtension.Utility.log("ActionProxy.initOnce: document.readyState is not loading state"),c()):document.addEventListener&&document.addEventListener("DOMContentLoaded",(function(){OfficeExtension.Utility.log("ActionProxy.initOnce: DOMContentLoaded event triggered"),c()}))),OfficeExtension.HostBridge.onInited((function(e){!function(e){e.addHostMessageHandler((function(e){3===e.type&&a(e.message)}))}(e)}))}(t||(t={}))}(Office||(Office={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}e.SendMessage=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,i;return __generator(this,(function(o){switch(o.label){case 0:return r=void 0!==n?n:e,i=t(void 0!==n?e:void 0),OfficeCore.AugLoopEventService.newObject(i).sendMessage(r),[4,i.sync()];case 1:return o.sent(),[2]}}))}))},e.onHostMessageReceived=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r,i,o,a,s=this;return __generator(this,(function(c){switch(c.label){case 0:return r=void 0!==n?n:e,i=t(void 0!==n?e:void 0),o=OfficeCore.AugLoopEventService.newObject(i),a=function(e){if(r){var t=e.data;r(t)}return null},o.onHostMessageReceived.add(a),[4,o.context.sync()];case 1:return c.sent(),[2,function(){return __awaiter(s,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return o.onHostMessageReceived.remove(a),[4,i.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.AugLoop||(e.AugLoop={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){return"object"==typeof e&&"string"==typeof e.controlId?e.controlId:void 0}function n(e){var t=new OfficeCore.RequestContext;return e&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e),t._customData="SkipUndoRecording",t}var r,i={};e.undo=function(e){return __awaiter(this,void 0,void 0,(function(){var r,i,o;return __generator(this,(function(a){switch(a.label){case 0:return r=n(t(e)),i=OfficeCore.UndoService.newObject(r),o=i.undo(),[4,r.sync()];case 1:return a.sent(),[2,o.value]}}))}))},e.onUndoStackChanged=function(e,r){return __awaiter(this,void 0,void 0,(function(){var i,o,a,s=this;return __generator(this,(function(c){switch(c.label){case 0:return i=r||e,o=n(t(r?e:void 0)),(a=OfficeCore.UndoService.newObject(o)).onUndoStackChanged.add(i),[4,o.sync()];case 1:return c.sent(),[2,function(){return __awaiter(s,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return a.onUndoStackChanged.remove(i),[4,o.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.startCopilotOperation=function(e){return __awaiter(this,void 0,void 0,(function(){var o,a,s,c,u,l,f,p;return __generator(this,(function(d){switch(d.label){case 0:if(void 0===(o=t(e))){if(void 0!==r)throw new Error("startCopilotOperation is already inprogress")}else if(i[o])throw new Error("startCopilotOperation is already in progress");a=function(){},s=new Promise((function(e){void 0===o?r=e:i[o]=e})),d.label=1;case 1:return d.trys.push([1,4,,5]),c=n(o),u=OfficeCore.UndoService.newObject(c),l=function(){return function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){return void 0===e?void 0!==r&&(r(),r=void 0):i[e]&&(i[e](),delete i[e]),[2]}))}))}(o)},a=function(){try{u.onCopilotOperationStarted.remove(l),c.sync()}catch(e){}},u.onCopilotOperationStarted.add(l),[4,c.sync()];case 2:return d.sent(),f=u.startCopilotOperation(""),[4,c.sync()];case 3:return d.sent(),f.value?(void 0!==o&&s.then((function(){a()})),[2,s]):(void 0===o?r=void 0:(a(),delete i[o]),[3,5]);case 4:throw p=d.sent(),void 0===o?r=void 0:(a(),delete i[o]),p;case 5:return[2]}}))}))},e.endCopilotOperation=function(e){return __awaiter(this,void 0,void 0,(function(){var r;return __generator(this,(function(i){switch(i.label){case 0:return r=n(t(e)),OfficeCore.UndoService.newObject(r).endCopilotOperation(""),[4,r.sync()];case 1:return i.sent(),[2]}}))}))}}(e.Undo||(e.Undo={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){var t;(t=e.dialogPage||(e.dialogPage={})).close=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return e=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(e).close(),[4,e.sync()];case 1:return t.sent(),[2]}}))}))},t.readyToShow=function(){return __awaiter(this,void 0,void 0,(function(){var e;return __generator(this,(function(t){switch(t.label){case 0:return e=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(e).readyToShow(),[4,e.sync()];case 1:return t.sent(),[2]}}))}))},t.onShow=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(i){switch(i.label){case 0:return t=new OfficeCore.RequestContext,(n=OfficeCore.DialogPage.newObject(t)).onOnShowEvent.add(e),r=function(){return n.onOnShowEvent.remove(e),null},[4,t.sync()];case 1:return i.sent(),[2,r]}}))}))},t.sendMessageToHost=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(n){switch(n.label){case 0:return t=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(t).sendMessageToHost(e),[4,t.sync()];case 1:return n.sent(),[2]}}))}))}}(Office||(Office={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.CollectUserFeedback=function(e,n,r,i){return __awaiter(this,void 0,void 0,(function(){var o;return __generator(this,(function(a){switch(a.label){case 0:return o=t(),OfficeCore.UserFeedbackService.newObject(o).collectUserFeedback(e,n,r,i),[4,o.sync()];case 1:return a.sent(),[2]}}))}))},e.onUserFeedbackUIDismissed=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i,o=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.isFeedbackSent;e(n)}return null},r=t(),(i=OfficeCore.UserFeedbackService.newObject(r)).onUserFeedbackUIDismissed.add(n),[4,i.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(o,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.onUserFeedbackUIDismissed.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.CanCollectUserFeedback=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(i){switch(i.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.canCollectUserFeedback(),[4,e.sync()];case 1:return i.sent(),[2,r.value]}}))}))},e.onUserFeedbackResponse=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i,o=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.responseData;e(n)}return null},r=t(),(i=OfficeCore.UserFeedbackService.newObject(r)).onUserFeedbackResponse.add(n),[4,i.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(o,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.onUserFeedbackResponse.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))},e.InvokeDiagnosticsLogsUpload=function(e){return __awaiter(this,void 0,void 0,(function(){var n;return __generator(this,(function(r){switch(r.label){case 0:return n=t(),OfficeCore.UserFeedbackService.newObject(n).invokeDiagnosticsLogsUpload(e),[4,n.sync()];case 1:return r.sent(),[2]}}))}))},e.GetInitializationData=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(i){switch(i.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.getInitializationData(),[4,e.sync()];case 1:return i.sent(),[2,r.value]}}))}))},e.GetHostScreenshot=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(i){switch(i.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.getHostScreenshot(),[4,e.sync()];case 1:return i.sent(),[2,r.value]}}))}))},e.CanCollectCopilotFeedback=function(){return __awaiter(this,void 0,void 0,(function(){var e,n,r;return __generator(this,(function(i){switch(i.label){case 0:return e=t(),n=OfficeCore.UserFeedbackService.newObject(e),r=n.canCollectCopilotFeedback(),[4,e.sync()];case 1:return i.sent(),[2,r.value]}}))}))}}(e.UserFeedback||(e.UserFeedback={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){var t=function(){};function n(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}function r(e){return JSON.stringify(e instanceof t?{type:"callout",params:e.params}:{type:"custom",props:e})}e.callout=function(e){var n=new t;return n.params=e,n},e.addNotification=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,o,a;return __generator(this,(function(s){switch(s.label){case 0:return i=n(),o=OfficeCore.NotificationService.newObject(i),a=o.addNotification(r(e),function(e){return JSON.stringify(e)}(t)),[4,i.sync()];case 1:return s.sent(),[2,a.value]}}))}))},e.updateNotification=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i;return __generator(this,(function(o){switch(o.label){case 0:return i=n(),OfficeCore.NotificationService.newObject(i).updateNotification(e,r(t)),[4,i.sync()];case 1:return o.sent(),[2]}}))}))},e.removeNotification=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(r){switch(r.label){case 0:return t=n(),OfficeCore.NotificationService.newObject(t).removeNotification(e),[4,t.sync()];case 1:return r.sent(),[2]}}))}))}}(e.Notification||(e.Notification={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}e.getLabel=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i;return __generator(this,(function(o){switch(o.label){case 0:return n=t(e),r=OfficeCore.SensitivityService.newObject(n),i=r.getLabel(),[4,n.sync()];case 1:return o.sent(),[2,i.value]}}))}))},e.tryUpgradeLabel=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a;return __generator(this,(function(s){switch(s.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("tryUpgradeLabel: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,i=n?e[1]:e[0],o=n?e[2]:e[1],a=t(r),OfficeCore.SensitivityService.newObject(a).tryUpgradeLabel(i,o),[4,a.sync()];case 1:return s.sent(),[2]}}))}))},e.getHighestSensitivityLabel=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a,s;return __generator(this,(function(c){switch(c.label){case 0:if(n=2===e.length,1!==e.length&&2!==e.length)throw new Error("getHighestSensitivityLabel: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,i=n?e[1]:e[0],o=t(r),a=OfficeCore.SensitivityService.newObject(o),s=a.getHighestSensitivityLabel(i),[4,o.sync()];case 1:return c.sent(),[2,s.value]}}))}))},e.getSensitivityResultDetails=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a,s,c;return __generator(this,(function(u){switch(u.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,i=n?e[1]:e[0],o=n?e[2]:e[1],a=t(r),s=OfficeCore.SensitivityService.newObject(a),c=s.getSensitivityResultDetails(i,o),[4,a.sync()];case 1:return u.sent(),[2,c.value]}}))}))},e.getSensitivityResultDetailsByStringErrorCode=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a,s,c;return __generator(this,(function(u){switch(u.label){case 0:if(n=3===e.length,2!==e.length&&3!==e.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,i=n?e[1]:e[0],o=n?e[2]:e[1],a=t(r),s=OfficeCore.SensitivityService.newObject(a),c=s.getSensitivityResultDetailsByStringErrorCode(i,o),[4,a.sync()];case 1:return u.sent(),[2,c.value]}}))}))},e.onLabelChangedEvent=function(){for(var e=[],n=0;n<arguments.length;n++)e[n]=arguments[n];return __awaiter(this,void 0,void 0,(function(){var n,r,i,o,a,s,c=this;return __generator(this,(function(u){switch(u.label){case 0:if(n=2===e.length,1!==e.length&&2!==e.length)throw new Error("onLabelChangedEvent: Invalid number of parameters ("+e.length+")");return r=n?e[0]:void 0,i=n?e[1]:e[0],o=function(e){if(i){var t=e.previousLabel,n=e.newLabel,r=e.context,o=e.error;i(t,n,r,o)}return null},a=t(r),(s=OfficeCore.SensitivityService.newObject(a)).onLabelChanged.add(o),[4,s.context.sync()];case 1:return u.sent(),[2,function(){return __awaiter(c,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return s.onLabelChanged.remove(o),[4,a.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.Sensitivity||(e.Sensitivity={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.launchHelpPaneByQuery=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(i){switch(i.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByQuery(e),[4,n.sync()];case 1:return i.sent(),[2]}}))}))},e.launchHelpPaneByArticleId=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(i){switch(i.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByArticleId(e),[4,n.sync()];case 1:return i.sent(),[2]}}))}))},e.launchHelpPaneByArticleIdString=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(i){switch(i.label){case 0:return n=t(),r=OfficeCore.CopilotService.newObject(n),r.launchHelpPaneByArticleIdString(e),[4,n.sync()];case 1:return i.sent(),[2]}}))}))}}(e.Copilot||(e.Copilot={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}e.execute=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i;return __generator(this,(function(o){switch(o.label){case 0:return n=t(),r=OfficeCore.PrivateApiService.newObject(n),i=r.execute(e),[4,n.sync()];case 1:return o.sent(),[2,i.value]}}))}))},e.onPrivateEvent=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r,i,o=this;return __generator(this,(function(a){switch(a.label){case 0:return n=function(t){if(e){var n=t.messageData;e(n)}return null},r=t(),(i=OfficeCore.PrivateApiService.newObject(r)).onOnPrivateEvent.add(n),[4,i.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(o,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.onOnPrivateEvent.remove(n),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.PrivateApi||(e.PrivateApi={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){var t;function n(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}!function(e){e.copilotAgentsPage="CopilotAgentsPage"}(t=e.DefaultPageType||(e.DefaultPageType={})),function(e){e.activated="Activated",e.removed="Removed"}(e.CopilotAgentActionType||(e.CopilotAgentActionType={})),e.launchStore=function(e){return __awaiter(this,void 0,void 0,(function(){var r,i,o;return __generator(this,(function(a){switch(a.label){case 0:if(e!==t.copilotAgentsPage)throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.invalidArgument,null,null);return r=n(),i=OfficeCore.UnifiedStoreService.newObject(r),e!=t.copilotAgentsPage?[3,2]:(o=i.launchStoreDialogWithCopilotAgentPageShown(),[4,r.sync()]);case 1:return a.sent(),[2,o];case 2:return[2]}}))}))},e.onCopilotAgentEvent=function(e){return __awaiter(this,void 0,void 0,(function(){var t,r,i,o=this;return __generator(this,(function(a){switch(a.label){case 0:return t=function(t){if(e){var n=JSON.parse(t.messageData),r=n.actionType,i=n.titleId;e({actionType:r,titleId:i})}return null},r=n(),(i=OfficeCore.UnifiedStoreService.newObject(r)).onCopilotAgentEvent.add(t),[4,i.context.sync()];case 1:return a.sent(),[2,function(){return __awaiter(o,void 0,void 0,(function(){return __generator(this,(function(e){switch(e.label){case 0:return i.onCopilotAgentEvent.remove(t),[4,r.sync()];case 1:return e.sent(),[2]}}))}))}]}}))}))}}(e.UnifiedStore||(e.UnifiedStore={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){function t(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}e.hide=function(e){return __awaiter(this,void 0,void 0,(function(){var n,r;return __generator(this,(function(i){switch(i.label){case 0:return n=t(),r=OfficeCore.BusinessBarService.newObject(n),r.hide(e),[4,n.sync()];case 1:return i.sent(),[2]}}))}))},e.show=function(e,n){return __awaiter(this,void 0,void 0,(function(){var r;return __generator(this,(function(i){switch(i.label){case 0:return r=t(),OfficeCore.BusinessBarService.newObject(r).show(e,n),[4,r.sync()];case 1:return i.sent(),[2]}}))}))}}(e.BusinessBar||(e.BusinessBar={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.launchSimpleDialog=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(i){switch(i.label){case 0:return t=function(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(),n=OfficeCore.ShowSimpleDialog.newObject(t),r=n.launchSimpleDialog(e.title,e.description,e.telemetryid,e.category,e.hasButton,e.buttonLabel,e.hasCheckbox,e.checkboxLabel),[4,t.sync()];case 1:return i.sent(),[2,r.value]}}))}))}}(e.SimpleDialog||(e.SimpleDialog={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.execute=function(e,t){return __awaiter(this,void 0,void 0,(function(){var n,r,i;return __generator(this,(function(o){switch(o.label){case 0:return n=function(e){var t=new OfficeCore.RequestContext;return t._customData="WacPartition",t}(),r=OfficeCore.DispatchApiService.newObject(n),i=r.execute(e,t),[4,n.sync()];case 1:return o.sent(),[2,i.value]}}))}))}}(e.DispatchApi||(e.DispatchApi={}))}(OfficeFirstParty||(OfficeFirstParty={})),function(e){!function(e){e.camera="camera",e.microphone="microphone",e.geolocation="geolocation"}(e.DevicePermissionType||(e.DevicePermissionType={})),function(e){e.requestPermissions=function(e){return __awaiter(this,void 0,void 0,(function(){var t,n,r;return __generator(this,(function(i){switch(i.label){case 0:return t=function(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(),n=OfficeCore.DevicePermissionService.newObject(t),r=n.requestPermissions(e),[4,t.sync()];case 1:return i.sent(),[2,r.value]}}))}))}}(e.devicePermission||(e.devicePermission={}))}(Office||(Office={}));var OneNote,OSF;__extends=this&&this.__extends||function(){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)}}();!function(e){var t="OneNote",n="OneNoteApi",r=OfficeExtension.BatchApiHelper.createPropertyObject,i=OfficeExtension.BatchApiHelper.createMethodObject,o=OfficeExtension.BatchApiHelper.createIndexerObject,a=(OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject),s=OfficeExtension.BatchApiHelper.invokeMethod,c=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,u=OfficeExtension.BatchApiHelper.invokeSetProperty,l=OfficeExtension.Utility.isNullOrUndefined,f=OfficeExtension.Utility.isUndefined,p=OfficeExtension.Utility.throwIfNotLoaded,d=OfficeExtension.Utility.throwIfApiNotSupported,h=OfficeExtension.Utility.load,g=OfficeExtension.Utility.retrieve,y=OfficeExtension.Utility.toJson,m=OfficeExtension.Utility.fixObjectPathIfNecessary,_=OfficeExtension.Utility._handleNavigationPropertyResults,v=(OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),b=OfficeExtension.Utility.setMockData,O=(OfficeExtension.CommonUtility.calculateApiFlags,function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Application"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["_platform"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_platform"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["notebooks","noteTagManager","mathAssistantManager"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"mathAssistantManager",{get:function(){return d("Application.mathAssistantManager",n,"1.9",t),this._M||(this._M=r(e.MathAssistantManager,this,"MathAssistantManager",!1,4)),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"noteTagManager",{get:function(){return d("Application.noteTagManager",n,"1.3",t),this._No||(this._No=r(e.NoteTagManager,this,"NoteTagManager",!1,4)),this._No},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"notebooks",{get:function(){return this._N||(this._N=r(e.NotebookCollection,this,"Notebooks",!0,4)),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_platform",{get:function(){return p("_platform",this.__p,"Application",this._isNull),this.__p},enumerable:!0,configurable:!0}),a.prototype.set=function(e,t){this._recursivelySet(e,t,[],["mathAssistantManager"],["notebooks","noteTagManager"])},a.prototype.update=function(e){this._recursivelyUpdate(e)},a.prototype.getActiveNotebook=function(){return i(e.Notebook,this,"GetActiveNotebook",1,[],!1,!1,null,4)},a.prototype.getActiveNotebookOrNull=function(){return i(e.Notebook,this,"GetActiveNotebookOrNull",1,[],!1,!1,null,4)},a.prototype.getActiveOutline=function(){return i(e.Outline,this,"GetActiveOutline",1,[],!1,!1,null,4)},a.prototype.getActiveOutlineOrNull=function(){return i(e.Outline,this,"GetActiveOutlineOrNull",1,[],!1,!1,null,4)},a.prototype.getActivePage=function(){return i(e.Page,this,"GetActivePage",1,[],!1,!1,null,4)},a.prototype.getActivePageOrNull=function(){return i(e.Page,this,"GetActivePageOrNull",1,[],!1,!1,null,4)},a.prototype.getActiveParagraph=function(){return i(e.Paragraph,this,"GetActiveParagraph",1,[],!1,!1,null,4)},a.prototype.getActiveParagraphOrNull=function(){return i(e.Paragraph,this,"GetActiveParagraphOrNull",1,[],!1,!1,null,4)},a.prototype.getActiveSection=function(){return i(e.Section,this,"GetActiveSection",1,[],!1,!1,null,4)},a.prototype.getActiveSectionOrNull=function(){return i(e.Section,this,"GetActiveSectionOrNull",1,[],!1,!1,null,4)},a.prototype.getDecimalSeparator=function(){return d("Application.getDecimalSeparator",n,"1.17",t),s(this,"GetDecimalSeparator",0,[],0,0)},a.prototype.getMathQuizContext=function(){return d("Application.getMathQuizContext",n,"1.6",t),s(this,"GetMathQuizContext",1,[],4,0)},a.prototype.getSelectedInkStrokes=function(){return d("Application.getSelectedInkStrokes",n,"1.9",t),i(e.InkStrokeCollection,this,"GetSelectedInkStrokes",1,[],!0,!1,null,4)},a.prototype.getSelectedPages=function(){return i(e.PageCollection,this,"GetSelectedPages",1,[],!0,!1,null,4)},a.prototype.getWindowSize=function(){return s(this,"GetWindowSize",0,[],0,0)},a.prototype.insertAndEmbedLinkAtCurrentPosition=function(e){d("Application.insertAndEmbedLinkAtCurrentPosition",n,"1.12",t),s(this,"InsertAndEmbedLinkAtCurrentPosition",0,[e],0,0)},a.prototype.insertHtmlAtCurrentPosition=function(e){s(this,"InsertHtmlAtCurrentPosition",0,[e],0,0)},a.prototype.isHighContrast=function(){return d("Application.isHighContrast",n,"1.3",t),s(this,"IsHighContrast",1,[],4,0)},a.prototype.isViewingDeletedNotes=function(){return d("Application.isViewingDeletedNotes",n,"1.2",t),s(this,"IsViewingDeletedNotes",1,[],4,0)},a.prototype.navigateToPage=function(e){s(this,"NavigateToPage",1,[e],4,0)},a.prototype.navigateToPageWithClientUrl=function(t){return i(e.Page,this,"NavigateToPageWithClientUrl",1,[t],!1,!1,null,4)},a.prototype._ClientLog=function(e,t,n,r){s(this,"_ClientLog",1,[e,t,n,r],4,0)},a.prototype._CreateNotebook=function(e,r){return d("Application._CreateNotebook",n,"1.5",t),s(this,"_CreateNotebook",1,[e,r],4,0)},a.prototype._EnableControl=function(e,t){s(this,"_EnableControl",0,[e,t],0,0)},a.prototype._EnterFullScreen=function(){s(this,"_EnterFullScreen",0,[],0,0)},a.prototype._ExitFullScreen=function(){s(this,"_ExitFullScreen",0,[],0,0)},a.prototype._FocusCanvas=function(){s(this,"_FocusCanvas",0,[],0,0)},a.prototype._GetAccountInfo=function(){return s(this,"_GetAccountInfo",1,[],4,0)},a.prototype._GetAccountInfoByType=function(e){return s(this,"_GetAccountInfoByType",1,[e],4,0)},a.prototype._GetAccountInfoCollection=function(){return d("Application._GetAccountInfoCollection",n,"1.3",t),s(this,"_GetAccountInfoCollection",1,[],4,0)},a.prototype._GetControlVisibility=function(e){return s(this,"_GetControlVisibility",1,[e],4,0)},a.prototype._GetLoggingInfo=function(){return s(this,"_GetLoggingInfo",1,[],4,0)},a.prototype._GetMathPaneContent=function(){return s(this,"_GetMathPaneContent",1,[],4,0)},a.prototype._GetNodeInternalProperties=function(e){return d("Application._GetNodeInternalProperties",n,"1.3",t),s(this,"_GetNodeInternalProperties",1,[e],4,0)},a.prototype._GetObjectByReferenceId=function(e){return s(this,"_GetObjectByReferenceId",1,[e],4,0)},a.prototype._GetObjectTypeNameByReferenceId=function(e){return s(this,"_GetObjectTypeNameByReferenceId",1,[e],4,0)},a.prototype._GetRoamingSetting=function(e,t){return s(this,"_GetRoamingSetting",0,[e,t],0,0)},a.prototype._GetServiceTokenByUrl=function(e){return s(this,"_GetServiceTokenByUrl",1,[e],4,0)},a.prototype._GetServiceTokenByUserEmail=function(e,r,i){return d("Application._GetServiceTokenByUserEmail",n,"1.3",t),s(this,"_GetServiceTokenByUserEmail",1,[e,r,i],4,0)},a.prototype._GetServiceTokens=function(e){return s(this,"_GetServiceTokens",1,[e],4,0)},a.prototype._GetServiceTokensExt=function(e,t){return s(this,"_GetServiceTokensExt",1,[e,t],4,0)},a.prototype._GetServiceUrl=function(e){return s(this,"_GetServiceUrl",1,[e],4,0)},a.prototype._IsAccountEdpManaged=function(e){return d("Application._IsAccountEdpManaged",n,"1.3",t),s(this,"_IsAccountEdpManaged",1,[e],4,0)},a.prototype._IsControlEnabled=function(e){return s(this,"_IsControlEnabled",1,[e],4,0)},a.prototype._IsImmersiveReaderUwpInstalled=function(){return s(this,"_IsImmersiveReaderUwpInstalled",0,[],0,0)},a.prototype._LaunchImmersiveReaderUwp=function(e){return s(this,"_LaunchImmersiveReaderUwp",0,[e],0,0)},a.prototype._OpenKRD=function(e){d("Application._OpenKRD",n,"1.19",t),s(this,"_OpenKRD",1,[e],4,0)},a.prototype._OpenKRDV2=function(e,r){d("Application._OpenKRDV2",n,"1.22",t),s(this,"_OpenKRDV2",1,[e,r],4,0)},a.prototype._RemoveAllReferences=function(){s(this,"_RemoveAllReferences",1,[],4,0)},a.prototype._RemoveReference=function(e){s(this,"_RemoveReference",1,[e],4,0)},a.prototype._SaveRoamingSetting=function(e,t){return s(this,"_SaveRoamingSetting",0,[e,t],0,0)},a.prototype._SendDataToLearningTools=function(e,t){return s(this,"_SendDataToLearningTools",0,[e,t],0,0)},a.prototype._SendDataToLearningToolsV2=function(e,t){return s(this,"_SendDataToLearningToolsV2",0,[e,t],0,0)},a.prototype._SetControlVisibility=function(e,t){s(this,"_SetControlVisibility",0,[e,t],0,0)},a.prototype._UploadToUserInfoService=function(e,t){s(this,"_UploadToUserInfoService",1,[e,t],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t._platform)||(this.__p=t._platform),_(this,t,["mathAssistantManager","MathAssistantManager","noteTagManager","NoteTagManager","notebooks","Notebooks"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.toJSON=function(){return y(this,{},{mathAssistantManager:this._M,notebooks:this._N,noteTagManager:this._No})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject));e.Application=O;var I="InkAnalysis",S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysis"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["paragraphs","page"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"page",{get:function(){return this._P||(this._P=r(e.Page,this,"Page",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"paragraphs",{get:function(){return this._Pa||(this._Pa=r(e.InkAnalysisParagraphCollection,this,"Paragraphs",!0,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,I,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,I,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["page"],["paragraphs"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["page","Page","paragraphs","Paragraphs"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I},{page:this._P,paragraphs:this._Pa})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.InkAnalysis=S;var P="InkAnalysisParagraph",C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisParagraph"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["lines","inkAnalysis"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"inkAnalysis",{get:function(){return this._In||(this._In=r(e.InkAnalysis,this,"InkAnalysis",!1,4)),this._In},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"lines",{get:function(){return this._L||(this._L=r(e.InkAnalysisLineCollection,this,"Lines",!0,4)),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,P,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,P,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["inkAnalysis"],["lines"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["inkAnalysis","InkAnalysis","lines","Lines"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I},{inkAnalysis:this._In,lines:this._L})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.InkAnalysisParagraph=C;var R="InkAnalysisParagraphCollection",A=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisParagraphCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,R,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,R,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,R,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.InkAnalysisParagraph,this,[t])},n.prototype.getItemAt=function(t){return i(e.InkAnalysisParagraph,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.InkAnalysisParagraph,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.InkAnalysisParagraph,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.InkAnalysisParagraph,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.InkAnalysisParagraphCollection=A;var E="InkAnalysisLine",w=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisLine"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["words","paragraph"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"paragraph",{get:function(){return this._P||(this._P=r(e.InkAnalysisParagraph,this,"Paragraph",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"words",{get:function(){return this._W||(this._W=r(e.InkAnalysisWordCollection,this,"Words",!0,4)),this._W},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,E,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,E,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["paragraph"],["words"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["paragraph","Paragraph","words","Words"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I},{paragraph:this._P,words:this._W})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.InkAnalysisLine=w;var x="InkAnalysisLineCollection",N=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisLineCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,x,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,x,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,x,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.InkAnalysisLine,this,[t])},n.prototype.getItemAt=function(t){return i(e.InkAnalysisLine,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.InkAnalysisLine,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.InkAnalysisLine,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.InkAnalysisLine,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.InkAnalysisLineCollection=N;var T="InkAnalysisWord",j=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisWord"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","wordAlternates","strokePointers","languageId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","WordAlternates","StrokePointers","LanguageId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["line"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"line",{get:function(){return this._Li||(this._Li=r(e.InkAnalysisLine,this,"Line",!1,4)),this._Li},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,T,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return p("languageId",this._L,T,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"strokePointers",{get:function(){return p("strokePointers",this._S,T,this._isNull),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"wordAlternates",{get:function(){return p("wordAlternates",this._W,T,this._isNull),this._W},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,T,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["line"],[])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n.LanguageId)||(this._L=n.LanguageId),f(n.StrokePointers)||(this._S=n.StrokePointers),f(n.WordAlternates)||(this._W=n.WordAlternates),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["line","Line"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I,languageId:this._L,strokePointers:this._S,wordAlternates:this._W},{line:this._Li})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.InkAnalysisWord=j;var k="InkAnalysisWordCollection",F=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkAnalysisWordCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,k,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,k,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,k,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.InkAnalysisWord,this,[t])},n.prototype.getItemAt=function(t){return i(e.InkAnalysisWord,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.InkAnalysisWord,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.InkAnalysisWord,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.InkAnalysisWord,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.InkAnalysisWordCollection=F;var M="FloatingInk",D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"FloatingInk"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["inkStrokes","pageContent"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"inkStrokes",{get:function(){return this._In||(this._In=r(e.InkStrokeCollection,this,"InkStrokes",!0,4)),this._In},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"pageContent",{get:function(){return this._P||(this._P=r(e.PageContent,this,"PageContent",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,M,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,M,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["inkStrokes","InkStrokes","pageContent","PageContent"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I},{inkStrokes:this._In})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.FloatingInk=D;var U=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"Meeting"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["container"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"container",{get:function(){return this._C||(this._C=r(e.Paragraph,this,"Container",!1,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,"Meeting",this._isNull),this._I},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,[],["container"],[])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),_(this,n,["container","Container"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e.Id)||(this._I=e.Id)},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.toJSON=function(){return y(this,{id:this._I},{container:this._C})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.Meeting=U;var H="MeetingCollection",L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"MeetingCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,H,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,H,this._isNull),this._C},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.Meeting,this,[t])},n.prototype.getItemAt=function(t){return i(e.Meeting,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Meeting,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Meeting,!0,i,t,n)}))},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Meeting,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.MeetingCollection=L;var B="InkStroke",W=function(i){function o(){return null!==i&&i.apply(this,arguments)||this}return __extends(o,i),Object.defineProperty(o.prototype,"_className",{get:function(){return"InkStroke"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["floatingInk","points"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"floatingInk",{get:function(){return this._F||(this._F=r(e.FloatingInk,this,"FloatingInk",!1,4)),this._F},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"points",{get:function(){return d("InkStroke.points",n,"1.9",t),this._P||(this._P=r(e.PointCollection,this,"Points",!0,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"id",{get:function(){return p("id",this._I,B,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,B,this._isNull),this.__R},enumerable:!0,configurable:!0}),o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(i.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.Id)||(this._I=t.Id),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["floatingInk","FloatingInk","points","Points"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleIdResult=function(e){i.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},o.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{id:this._I},{floatingInk:this._F,points:this._P})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.InkStroke=W;var G="InkStrokeCollection",q=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkStrokeCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,G,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,G,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,G,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.InkStroke,this,[t])},n.prototype.getItemAt=function(t){return i(e.InkStroke,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.InkStroke,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.InkStroke,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.InkStroke,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.InkStrokeCollection=q;var V="Point",J=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"Point"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","x","y"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","X","Y"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,V,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return p("x",this._X,V,this._isNull),this._X},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return p("y",this._Y,V,this._isNull),this._Y},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,V,this._isNull),this.__R},enumerable:!0,configurable:!0}),t.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!l(t)){var n=t;m(this,n),f(n.Id)||(this._I=n.Id),f(n.X)||(this._X=n.X),f(n.Y)||(this._Y=n.Y),f(n._ReferenceId)||(this.__R=n._ReferenceId)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return g(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),l(t)||(f(t._ReferenceId)||(this.__R=t._ReferenceId),f(t.Id)||(this._I=t.Id))},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),v(this,t,n)},t.prototype.track=function(){return this.context.trackedObjects.add(this),this},t.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},t.prototype.toJSON=function(){return y(this,{id:this._I,x:this._X,y:this._Y},{})},t.prototype.setMockData=function(e){b(this,e)},t.prototype.ensureUnchanged=function(e){c(this,e)},t}(OfficeExtension.ClientObject);e.Point=J;var z="PointCollection",K=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PointCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,z,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,z,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,z,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.Point,this,[t])},n.prototype.getItemAt=function(t){return i(e.Point,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Point,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Point,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Point,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.PointCollection=K;var Q="InkWord",X=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkWord"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","wordAlternates","languageId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","WordAlternates","LanguageId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["paragraph"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"paragraph",{get:function(){return this._P||(this._P=r(e.Paragraph,this,"Paragraph",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,Q,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return p("languageId",this._L,Q,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"wordAlternates",{get:function(){return p("wordAlternates",this._W,Q,this._isNull),this._W},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Q,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n.LanguageId)||(this._L=n.LanguageId),f(n.WordAlternates)||(this._W=n.WordAlternates),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["paragraph","Paragraph"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I,languageId:this._L,wordAlternates:this._W},{})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.InkWord=X;var $="InkWordCollection",Y=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"InkWordCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,$,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,$,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,$,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.InkWord,this,[t])},n.prototype.getItemAt=function(t){return i(e.InkWord,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.InkWord,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.InkWord,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.InkWord,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.InkWordCollection=Y;var Z="Notebook",ee=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Notebook"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","name","_ReferenceId","clientUrl","baseUrl","isVirtual","isForEducation","isReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Name","_ReferenceId","ClientUrl","BaseUrl","IsVirtual","IsForEducation","IsReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["sections","sectionGroups","accessibilityViolations"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"accessibilityViolations",{get:function(){return d("Notebook.accessibilityViolations",n,"1.2",t),this._A||(this._A=r(e.AccessibilityViolationsByEntityCollection,this,"AccessibilityViolations",!0,4)),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"sectionGroups",{get:function(){return this._S||(this._S=r(e.SectionGroupCollection,this,"SectionGroups",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"sections",{get:function(){return this._Se||(this._Se=r(e.SectionCollection,this,"Sections",!0,4)),this._Se},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"baseUrl",{get:function(){return p("baseUrl",this._B,Z,this._isNull),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"clientUrl",{get:function(){return p("clientUrl",this._C,Z,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,Z,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isForEducation",{get:function(){return p("isForEducation",this._Is,Z,this._isNull),d("Notebook.isForEducation",n,"1.11",t),this._Is},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isReadOnly",{get:function(){return p("isReadOnly",this._IsR,Z,this._isNull),d("Notebook.isReadOnly",n,"1.11",t),this._IsR},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isVirtual",{get:function(){return p("isVirtual",this._IsV,Z,this._isNull),d("Notebook.isVirtual",n,"1.2",t),this._IsV},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"name",{get:function(){return p("name",this._N,Z,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Z,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.addSection=function(t){return i(e.Section,this,"AddSection",0,[t],!1,!0,null,0)},a.prototype.addSectionGroup=function(t){return i(e.SectionGroup,this,"AddSectionGroup",0,[t],!1,!0,null,0)},a.prototype.canCopyDataFromAccount=function(e){return d("Notebook.canCopyDataFromAccount",n,"1.3",t),s(this,"CanCopyDataFromAccount",1,[e],4,0)},a.prototype.canCopyDataToAccount=function(e){return d("Notebook.canCopyDataToAccount",n,"1.3",t),s(this,"CanCopyDataToAccount",1,[e],4,0)},a.prototype.getRestApiId=function(){return s(this,"GetRestApiId",1,[],4,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._Sync=function(){s(this,"_Sync",0,[],0,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.BaseUrl)||(this._B=t.BaseUrl),f(t.ClientUrl)||(this._C=t.ClientUrl),f(t.Id)||(this._I=t.Id),f(t.IsForEducation)||(this._Is=t.IsForEducation),f(t.IsReadOnly)||(this._IsR=t.IsReadOnly),f(t.IsVirtual)||(this._IsV=t.IsVirtual),f(t.Name)||(this._N=t.Name),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["accessibilityViolations","AccessibilityViolations","sectionGroups","SectionGroups","sections","Sections"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{baseUrl:this._B,clientUrl:this._C,id:this._I,isForEducation:this._Is,isReadOnly:this._IsR,isVirtual:this._IsV,name:this._N},{accessibilityViolations:this._A,sectionGroups:this._S,sections:this._Se})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Notebook=ee;var te="NotebookCollection",ne=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"NotebookCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,te,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,te,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,te,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getByName=function(t){return i(e.NotebookCollection,this,"GetByName",1,[t],!0,!1,null,4)},n.prototype.getItem=function(t){return o(e.Notebook,this,[t])},n.prototype.getItemAt=function(t){return i(e.Notebook,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Notebook,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Notebook,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Notebook,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.NotebookCollection=ne;var re="SectionGroup",ie=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"SectionGroup"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","name","_ReferenceId","clientUrl","isReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Name","_ReferenceId","ClientUrl","IsReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["notebook","parentSectionGroup","parentSectionGroupOrNull","sections","sectionGroups"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"notebook",{get:function(){return this._No||(this._No=r(e.Notebook,this,"Notebook",!1,4)),this._No},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentSectionGroup",{get:function(){return this._P||(this._P=r(e.SectionGroup,this,"ParentSectionGroup",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentSectionGroupOrNull",{get:function(){return this._Pa||(this._Pa=r(e.SectionGroup,this,"ParentSectionGroupOrNull",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"sectionGroups",{get:function(){return this._S||(this._S=r(e.SectionGroupCollection,this,"SectionGroups",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"sections",{get:function(){return this._Se||(this._Se=r(e.SectionCollection,this,"Sections",!0,4)),this._Se},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"clientUrl",{get:function(){return p("clientUrl",this._C,re,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,re,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isReadOnly",{get:function(){return p("isReadOnly",this._Is,re,this._isNull),d("SectionGroup.isReadOnly",n,"1.23",t),this._Is},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"name",{get:function(){return p("name",this._N,re,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,re,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.addSection=function(t){return i(e.Section,this,"AddSection",0,[t],!1,!0,null,0)},a.prototype.addSectionGroup=function(t){return i(e.SectionGroup,this,"AddSectionGroup",0,[t],!1,!0,null,0)},a.prototype.getRestApiId=function(){return s(this,"GetRestApiId",1,[],4,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.ClientUrl)||(this._C=t.ClientUrl),f(t.Id)||(this._I=t.Id),f(t.IsReadOnly)||(this._Is=t.IsReadOnly),f(t.Name)||(this._N=t.Name),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["notebook","Notebook","parentSectionGroup","ParentSectionGroup","parentSectionGroupOrNull","ParentSectionGroupOrNull","sectionGroups","SectionGroups","sections","Sections"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{clientUrl:this._C,id:this._I,isReadOnly:this._Is,name:this._N},{sectionGroups:this._S,sections:this._Se})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.SectionGroup=ie;var oe="SectionGroupCollection",ae=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"SectionGroupCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,oe,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,oe,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,oe,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getByName=function(t){return i(e.SectionGroupCollection,this,"GetByName",1,[t],!0,!1,null,4)},n.prototype.getItem=function(t){return o(e.SectionGroup,this,[t])},n.prototype.getItemAt=function(t){return i(e.SectionGroup,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.SectionGroup,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.SectionGroup,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.SectionGroup,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.SectionGroupCollection=ae;var se="Section",ce=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Section"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","name","_ReferenceId","clientUrl","webUrl","isEncrypted","isLocked","isForQuickNotes","isReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Name","_ReferenceId","ClientUrl","WebUrl","IsEncrypted","IsLocked","IsForQuickNotes","IsReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["notebook","parentSectionGroup","parentSectionGroupOrNull","pages"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"notebook",{get:function(){return this._No||(this._No=r(e.Notebook,this,"Notebook",!1,4)),this._No},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"pages",{get:function(){return this._P||(this._P=r(e.PageCollection,this,"Pages",!0,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentSectionGroup",{get:function(){return this._Pa||(this._Pa=r(e.SectionGroup,this,"ParentSectionGroup",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentSectionGroupOrNull",{get:function(){return this._Par||(this._Par=r(e.SectionGroup,this,"ParentSectionGroupOrNull",!1,4)),this._Par},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"clientUrl",{get:function(){return p("clientUrl",this._C,se,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,se,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isEncrypted",{get:function(){return p("isEncrypted",this._Is,se,this._isNull),d("Section.isEncrypted",n,"1.2",t),this._Is},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isForQuickNotes",{get:function(){return p("isForQuickNotes",this._IsF,se,this._isNull),d("Section.isForQuickNotes",n,"1.20",t),this._IsF},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isLocked",{get:function(){return p("isLocked",this._IsL,se,this._isNull),d("Section.isLocked",n,"1.2",t),this._IsL},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isReadOnly",{get:function(){return p("isReadOnly",this._IsR,se,this._isNull),d("Section.isReadOnly",n,"1.23",t),this._IsR},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"name",{get:function(){return p("name",this._N,se,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"webUrl",{get:function(){return p("webUrl",this._W,se,this._isNull),this._W},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,se,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.addPage=function(t){return i(e.Page,this,"AddPage",0,[t],!1,!0,null,0)},a.prototype.applyPageTemplate=function(t){return i(e.Page,this,"ApplyPageTemplate",0,[t],!1,!1,null,0)},a.prototype.copyToNotebook=function(t){return i(e.Section,this,"CopyToNotebook",0,[t],!1,!0,null,0)},a.prototype.copyToSectionGroup=function(t){return i(e.Section,this,"CopyToSectionGroup",0,[t],!1,!0,null,0)},a.prototype.delete=function(){d("Section.delete",n,"1.19",t),s(this,"Delete",0,[],0,0)},a.prototype.getDefaultTemplateName=function(){return d("Section.getDefaultTemplateName",n,"1.7",t),s(this,"GetDefaultTemplateName",0,[],0,0)},a.prototype.getRestApiId=function(){return s(this,"GetRestApiId",1,[],4,0)},a.prototype.insertSectionAsSibling=function(t,n){return i(e.Section,this,"InsertSectionAsSibling",0,[t,n],!1,!0,null,0)},a.prototype.removeDefaultTemplate=function(){d("Section.removeDefaultTemplate",n,"1.7",t),s(this,"RemoveDefaultTemplate",0,[],0,0)},a.prototype.reorderPage=function(e,r,i){d("Section.reorderPage",n,"1.24",t),s(this,"ReorderPage",0,[e,r,i],0,0)},a.prototype.setDefaultTemplate=function(e){return d("Section.setDefaultTemplate",n,"1.7",t),s(this,"SetDefaultTemplate",0,[e],0,0)},a.prototype._GetDefaultTemplateThumbnailAsync=function(e,r,i){return d("Section._GetDefaultTemplateThumbnailAsync",n,"1.7",t),s(this,"_GetDefaultTemplateThumbnailAsync",0,[e,r,i],0,0)},a.prototype._GetGeoInfo=function(){return s(this,"_GetGeoInfo",1,[],4,0)},a.prototype._GetGeoInfoAsync=function(){return s(this,"_GetGeoInfoAsync",1,[],4,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.ClientUrl)||(this._C=t.ClientUrl),f(t.Id)||(this._I=t.Id),f(t.IsEncrypted)||(this._Is=t.IsEncrypted),f(t.IsForQuickNotes)||(this._IsF=t.IsForQuickNotes),f(t.IsLocked)||(this._IsL=t.IsLocked),f(t.IsReadOnly)||(this._IsR=t.IsReadOnly),f(t.Name)||(this._N=t.Name),f(t.WebUrl)||(this._W=t.WebUrl),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["notebook","Notebook","pages","Pages","parentSectionGroup","ParentSectionGroup","parentSectionGroupOrNull","ParentSectionGroupOrNull"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{clientUrl:this._C,id:this._I,isEncrypted:this._Is,isForQuickNotes:this._IsF,isLocked:this._IsL,isReadOnly:this._IsR,name:this._N,webUrl:this._W},{pages:this._P})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Section=ce;var ue="SectionCollection",le=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"SectionCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,ue,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,ue,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,ue,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getByName=function(t){return i(e.SectionCollection,this,"GetByName",1,[t],!0,!1,null,4)},n.prototype.getItem=function(t){return o(e.Section,this,[t])},n.prototype.getItemAt=function(t){return i(e.Section,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Section,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Section,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Section,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.SectionCollection=le;var fe="Page",pe=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Page"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","title","pageLevel","_ReferenceId","clientUrl","webUrl","classNotebookPageSource","isReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Title","PageLevel","_ReferenceId","ClientUrl","WebUrl","ClassNotebookPageSource","IsReadOnly"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0,!0,!1,!1,!1,!1,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["parentSection","contents","inkAnalysisOrNull","accessibilityViolations","transcription","meetings"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"accessibilityViolations",{get:function(){return d("Page.accessibilityViolations",n,"1.2",t),this._A||(this._A=r(e.AccessibilityViolationCollection,this,"AccessibilityViolations",!0,4)),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"contents",{get:function(){return this._Co||(this._Co=r(e.PageContentCollection,this,"Contents",!0,4)),this._Co},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"inkAnalysisOrNull",{get:function(){return this._In||(this._In=r(e.InkAnalysis,this,"InkAnalysisOrNull",!1,4)),this._In},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"meetings",{get:function(){return d("Page.meetings",n,"1.23",t),this._M||(this._M=r(e.MeetingCollection,this,"Meetings",!0,4)),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentSection",{get:function(){return this._Pa||(this._Pa=r(e.Section,this,"ParentSection",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"transcription",{get:function(){return d("Page.transcription",n,"1.13",t),this._Tr||(this._Tr=r(e.Transcription,this,"Transcription",!1,4)),this._Tr},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"classNotebookPageSource",{get:function(){return p("classNotebookPageSource",this._C,fe,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"clientUrl",{get:function(){return p("clientUrl",this._Cl,fe,this._isNull),this._Cl},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,fe,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"isReadOnly",{get:function(){return p("isReadOnly",this._Is,fe,this._isNull),d("Page.isReadOnly",n,"1.23",t),this._Is},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"pageLevel",{get:function(){return p("pageLevel",this._P,fe,this._isNull),this._P},set:function(e){this._P=e,u(this,"PageLevel",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"title",{get:function(){return p("title",this._T,fe,this._isNull),this._T},set:function(e){this._T=e,u(this,"Title",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"webUrl",{get:function(){return p("webUrl",this._W,fe,this._isNull),this._W},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,fe,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.set=function(e,t){this._recursivelySet(e,t,["title","pageLevel"],["inkAnalysisOrNull"],["accessibilityViolations","contents","meetings","parentSection","transcription"])},a.prototype.update=function(e){this._recursivelyUpdate(e)},a.prototype.addOutline=function(t,n,r){return i(e.Outline,this,"AddOutline",0,[t,n,r],!1,!0,null,0)},a.prototype.analyzePage=function(){return s(this,"AnalyzePage",1,[],4,0)},a.prototype.applyTranslation=function(e){s(this,"ApplyTranslation",0,[e],0,0)},a.prototype.copyToSection=function(t){return i(e.Page,this,"CopyToSection",0,[t],!1,!0,null,0)},a.prototype.copyToSectionAndSetClassNotebookPageSource=function(t){return i(e.Page,this,"CopyToSectionAndSetClassNotebookPageSource",0,[t],!1,!0,null,0)},a.prototype.delete=function(){d("Page.delete",n,"1.19",t),s(this,"Delete",0,[],0,0)},a.prototype.getRestApiId=function(){return s(this,"GetRestApiId",1,[],4,0)},a.prototype.hasTitleContent=function(){return s(this,"HasTitleContent",1,[],4,0)},a.prototype.insertPageAsSibling=function(t,n){return i(e.Page,this,"InsertPageAsSibling",0,[t,n],!1,!0,null,0)},a.prototype._GetInternalHierarchy=function(){return d("Page._GetInternalHierarchy",n,"1.3",t),s(this,"_GetInternalHierarchy",1,[],4,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._Sync=function(){s(this,"_Sync",0,[],0,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.ClassNotebookPageSource)||(this._C=t.ClassNotebookPageSource),f(t.ClientUrl)||(this._Cl=t.ClientUrl),f(t.Id)||(this._I=t.Id),f(t.IsReadOnly)||(this._Is=t.IsReadOnly),f(t.PageLevel)||(this._P=t.PageLevel),f(t.Title)||(this._T=t.Title),f(t.WebUrl)||(this._W=t.WebUrl),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["accessibilityViolations","AccessibilityViolations","contents","Contents","inkAnalysisOrNull","InkAnalysisOrNull","meetings","Meetings","parentSection","ParentSection","transcription","Transcription"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{classNotebookPageSource:this._C,clientUrl:this._Cl,id:this._I,isReadOnly:this._Is,pageLevel:this._P,title:this._T,webUrl:this._W},{accessibilityViolations:this._A,contents:this._Co,inkAnalysisOrNull:this._In})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Page=pe;var de="PageCollection",he=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PageCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,de,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,de,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,de,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getByTitle=function(t){return i(e.PageCollection,this,"GetByTitle",1,[t],!0,!1,null,4)},n.prototype.getItem=function(t){return o(e.Page,this,[t])},n.prototype.getItemAt=function(t){return i(e.Page,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Page,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Page,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Page,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.PageCollection=he;var ge="PageContent",ye=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PageContent"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","type","_ReferenceId","left","top"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Type","_ReferenceId","Left","Top"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!1,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["parentPage","image","outline","ink"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"image",{get:function(){return this._Im||(this._Im=r(e.Image,this,"Image",!1,4)),this._Im},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"ink",{get:function(){return this._In||(this._In=r(e.FloatingInk,this,"Ink",!1,4)),this._In},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"outline",{get:function(){return this._O||(this._O=r(e.Outline,this,"Outline",!1,4)),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentPage",{get:function(){return this._P||(this._P=r(e.Page,this,"ParentPage",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,ge,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"left",{get:function(){return p("left",this._L,ge,this._isNull),this._L},set:function(e){this._L=e,u(this,"Left",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"top",{get:function(){return p("top",this._T,ge,this._isNull),this._T},set:function(e){this._T=e,u(this,"Top",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"type",{get:function(){return p("type",this._Ty,ge,this._isNull),this._Ty},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,ge,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,["left","top"],["image"],["ink","outline","parentPage"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype.delete=function(){s(this,"Delete",0,[],0,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.Id)||(this._I=n.Id),f(n.Left)||(this._L=n.Left),f(n.Top)||(this._T=n.Top),f(n.Type)||(this._Ty=n.Type),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["image","Image","ink","Ink","outline","Outline","parentPage","ParentPage"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{id:this._I,left:this._L,top:this._T,type:this._Ty},{image:this._Im,ink:this._In,outline:this._O})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.PageContent=ye;var me="PageContentCollection",_e=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"PageContentCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,me,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,me,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,me,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.PageContent,this,[t])},n.prototype.getItemAt=function(t){return i(e.PageContent,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.PageContent,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.PageContent,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.PageContent,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.PageContentCollection=_e;var ve="Outline",be=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Outline"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["pageContent","paragraphs"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"pageContent",{get:function(){return this._P||(this._P=r(e.PageContent,this,"PageContent",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"paragraphs",{get:function(){return this._Pa||(this._Pa=r(e.ParagraphCollection,this,"Paragraphs",!0,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,ve,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,ve,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.appendHtml=function(e){s(this,"AppendHtml",0,[e],0,0)},a.prototype.appendImage=function(t,n,r){return i(e.Image,this,"AppendImage",0,[t,n,r],!1,!0,null,0)},a.prototype.appendRichText=function(t){return i(e.RichText,this,"AppendRichText",0,[t],!1,!0,null,0)},a.prototype.appendTable=function(t,n,r){return i(e.Table,this,"AppendTable",0,[t,n,r],!1,!0,null,0)},a.prototype.delete=function(){d("Outline.delete",n,"1.19",t),s(this,"Delete",0,[],0,0)},a.prototype.isTitle=function(){return s(this,"IsTitle",0,[],0,0)},a.prototype.select=function(e){d("Outline.select",n,"1.19",t),s(this,"Select",0,[e],0,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.Id)||(this._I=t.Id),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["pageContent","PageContent","paragraphs","Paragraphs"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{id:this._I},{paragraphs:this._Pa})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Outline=be;var Oe="Paragraph",Ie=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Paragraph"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","type","_ReferenceId","clientUrl"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Type","_ReferenceId","ClientUrl"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["outline","parentTableCell","parentTableCellOrNull","richText","image","table","parentParagraph","parentParagraphOrNull","paragraphs","inkWords"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"image",{get:function(){return this._Im||(this._Im=r(e.Image,this,"Image",!1,4)),this._Im},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"inkWords",{get:function(){return this._In||(this._In=r(e.InkWordCollection,this,"InkWords",!0,4)),this._In},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"outline",{get:function(){return this._O||(this._O=r(e.Outline,this,"Outline",!1,4)),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"paragraphs",{get:function(){return this._P||(this._P=r(e.ParagraphCollection,this,"Paragraphs",!0,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentParagraph",{get:function(){return this._Pa||(this._Pa=r(e.Paragraph,this,"ParentParagraph",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentParagraphOrNull",{get:function(){return this._Par||(this._Par=r(e.Paragraph,this,"ParentParagraphOrNull",!1,4)),this._Par},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentTableCell",{get:function(){return this._Pare||(this._Pare=r(e.TableCell,this,"ParentTableCell",!1,4)),this._Pare},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"parentTableCellOrNull",{get:function(){return this._Paren||(this._Paren=r(e.TableCell,this,"ParentTableCellOrNull",!1,4)),this._Paren},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"richText",{get:function(){return this._R||(this._R=r(e.RichText,this,"RichText",!1,4)),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"table",{get:function(){return this._T||(this._T=r(e.Table,this,"Table",!1,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"clientUrl",{get:function(){return p("clientUrl",this._C,Oe,this._isNull),d("Paragraph.clientUrl",n,"1.22",t),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,Oe,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"type",{get:function(){return p("type",this._Ty,Oe,this._isNull),this._Ty},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Oe,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.set=function(e,t){this._recursivelySet(e,t,[],["richText","image","table"],["inkWords","outline","paragraphs","parentParagraph","parentParagraphOrNull","parentTableCell","parentTableCellOrNull"])},a.prototype.update=function(e){this._recursivelyUpdate(e)},a.prototype.addNoteTag=function(t,n){return i(e.NoteTag,this,"AddNoteTag",0,[t,n],!1,!0,null,0)},a.prototype.delete=function(){s(this,"Delete",0,[],0,0)},a.prototype.getParagraphInfo=function(){return s(this,"GetParagraphInfo",0,[],0,0)},a.prototype.insertHtmlAsSibling=function(e,t){s(this,"InsertHtmlAsSibling",0,[e,t],0,0)},a.prototype.insertImageAsSibling=function(t,n,r,o){return i(e.Image,this,"InsertImageAsSibling",0,[t,n,r,o],!1,!0,null,0)},a.prototype.insertRichTextAsSibling=function(t,n){return i(e.RichText,this,"InsertRichTextAsSibling",0,[t,n],!1,!0,null,0)},a.prototype.insertTableAsSibling=function(t,n,r,o){return i(e.Table,this,"InsertTableAsSibling",0,[t,n,r,o],!1,!0,null,0)},a.prototype.select=function(e){d("Paragraph.select",n,"1.19",t),s(this,"Select",0,[e],0,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.ClientUrl)||(this._C=t.ClientUrl),f(t.Id)||(this._I=t.Id),f(t.Type)||(this._Ty=t.Type),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["image","Image","inkWords","InkWords","outline","Outline","paragraphs","Paragraphs","parentParagraph","ParentParagraph","parentParagraphOrNull","ParentParagraphOrNull","parentTableCell","ParentTableCell","parentTableCellOrNull","ParentTableCellOrNull","richText","RichText","table","Table"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{clientUrl:this._C,id:this._I,type:this._Ty},{image:this._Im,inkWords:this._In,paragraphs:this._P,richText:this._R,table:this._T})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Paragraph=Ie;var Se="ParagraphCollection",Pe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"ParagraphCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,Se,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,Se,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Se,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.Paragraph,this,[t])},n.prototype.getItemAt=function(t){return i(e.Paragraph,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.Paragraph,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.Paragraph,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.Paragraph,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.ParagraphCollection=Pe;var Ce="NoteTag",Re=function(i){function o(){return null!==i&&i.apply(this,arguments)||this}return __extends(o,i),Object.defineProperty(o.prototype,"_className",{get:function(){return"NoteTag"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyNames",{get:function(){return["id","type","status"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Type","Status"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["tagIcon"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"tagIcon",{get:function(){return d("NoteTag.tagIcon",n,"1.3",t),this._T||(this._T=r(e.TagIcon,this,"TagIcon",!1,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"id",{get:function(){return p("id",this._I,Ce,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"status",{get:function(){return p("status",this._S,Ce,this._isNull),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"type",{get:function(){return p("type",this._Ty,Ce,this._isNull),this._Ty},enumerable:!0,configurable:!0}),o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(i.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.Id)||(this._I=t.Id),f(t.Status)||(this._S=t.Status),f(t.Type)||(this._Ty=t.Type),_(this,t,["tagIcon","TagIcon"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleIdResult=function(e){i.prototype._handleIdResult.call(this,e),l(e)||f(e.Id)||(this._I=e.Id)},o.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{id:this._I,status:this._S,type:this._Ty},{tagIcon:this._T})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.NoteTag=Re;var Ae="NoteTagCollection",Ee=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"NoteTagCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,Ae,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,Ae,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Ae,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.NoteTag,this,[t])},n.prototype.getItemAt=function(t){return i(e.NoteTag,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.NoteTag,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.NoteTag,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.NoteTag,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.NoteTagCollection=Ee;var we="RichText",xe=function(i){function o(){return null!==i&&i.apply(this,arguments)||this}return __extends(o,i),Object.defineProperty(o.prototype,"_className",{get:function(){return"RichText"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyNames",{get:function(){return["text","_ReferenceId","id","languageId","style"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Text","_ReferenceId","Id","LanguageId","Style"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!1,!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["paragraph"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"paragraph",{get:function(){return this._P||(this._P=r(e.Paragraph,this,"Paragraph",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"id",{get:function(){return p("id",this._I,we,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"languageId",{get:function(){return p("languageId",this._L,we,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"style",{get:function(){return p("style",this._S,we,this._isNull),d("RichText.style",n,"1.8",t),this._S},set:function(e){this._S=e,u(this,"Style",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"text",{get:function(){return p("text",this._T,we,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,we,this._isNull),this.__R},enumerable:!0,configurable:!0}),o.prototype.set=function(e,t){this._recursivelySet(e,t,["style"],[],["paragraph"])},o.prototype.update=function(e){this._recursivelyUpdate(e)},o.prototype.getHtml=function(){return s(this,"GetHtml",1,[],4,0)},o.prototype.select=function(e){d("RichText.select",n,"1.19",t),s(this,"Select",0,[e],0,0)},o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(i.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.Id)||(this._I=t.Id),f(t.LanguageId)||(this._L=t.LanguageId),f(t.Style)||(this._S=t.Style),f(t.Text)||(this._T=t.Text),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["paragraph","Paragraph"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleIdResult=function(e){i.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},o.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{id:this._I,languageId:this._L,style:this._S,text:this._T},{})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.RichText=xe;var Ne="Image",Te=function(i){function o(){return null!==i&&i.apply(this,arguments)||this}return __extends(o,i),Object.defineProperty(o.prototype,"_className",{get:function(){return"Image"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyNames",{get:function(){return["description","height","hyperlink","width","_ReferenceId","id","ocrData"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Description","Height","Hyperlink","Width","_ReferenceId","Id","OcrData"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!1,!1,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["paragraph","pageContent"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"pageContent",{get:function(){return this._P||(this._P=r(e.PageContent,this,"PageContent",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"paragraph",{get:function(){return this._Pa||(this._Pa=r(e.Paragraph,this,"Paragraph",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"description",{get:function(){return p("description",this._D,Ne,this._isNull),this._D},set:function(e){this._D=e,u(this,"Description",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"height",{get:function(){return p("height",this._H,Ne,this._isNull),this._H},set:function(e){this._H=e,u(this,"Height",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"hyperlink",{get:function(){return p("hyperlink",this._Hy,Ne,this._isNull),this._Hy},set:function(e){this._Hy=e,u(this,"Hyperlink",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"id",{get:function(){return p("id",this._I,Ne,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"ocrData",{get:function(){return p("ocrData",this._O,Ne,this._isNull),this._O},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"width",{get:function(){return p("width",this._W,Ne,this._isNull),this._W},set:function(e){this._W=e,u(this,"Width",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Ne,this._isNull),this.__R},enumerable:!0,configurable:!0}),o.prototype.set=function(e,t){this._recursivelySet(e,t,["description","height","hyperlink","width"],[],["pageContent","paragraph"])},o.prototype.update=function(e){this._recursivelyUpdate(e)},o.prototype.delete=function(){d("Image.delete",n,"1.18",t),s(this,"Delete",0,[],0,0)},o.prototype.getBase64Image=function(){return s(this,"GetBase64Image",1,[],4,0)},o.prototype.select=function(e){d("Image.select",n,"1.19",t),s(this,"Select",0,[e],0,0)},o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(i.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.Description)||(this._D=t.Description),f(t.Height)||(this._H=t.Height),f(t.Hyperlink)||(this._Hy=t.Hyperlink),f(t.Id)||(this._I=t.Id),f(t.OcrData)||(this._O=t.OcrData),f(t.Width)||(this._W=t.Width),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["pageContent","PageContent","paragraph","Paragraph"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleIdResult=function(e){i.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},o.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{description:this._D,height:this._H,hyperlink:this._Hy,id:this._I,ocrData:this._O,width:this._W},{})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.Image=Te;var je="Table",ke=function(o){function a(){return null!==o&&o.apply(this,arguments)||this}return __extends(a,o),Object.defineProperty(a.prototype,"_className",{get:function(){return"Table"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","rowCount","columnCount","borderVisible"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","RowCount","ColumnCount","BorderVisible"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!1,!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_navigationPropertyNames",{get:function(){return["paragraph","rows"]},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"paragraph",{get:function(){return this._P||(this._P=r(e.Paragraph,this,"Paragraph",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"rows",{get:function(){return this._Ro||(this._Ro=r(e.TableRowCollection,this,"Rows",!0,4)),this._Ro},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"borderVisible",{get:function(){return p("borderVisible",this._B,je,this._isNull),this._B},set:function(e){this._B=e,u(this,"BorderVisible",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"columnCount",{get:function(){return p("columnCount",this._C,je,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"id",{get:function(){return p("id",this._I,je,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"rowCount",{get:function(){return p("rowCount",this._R,je,this._isNull),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,je,this._isNull),this.__R},enumerable:!0,configurable:!0}),a.prototype.set=function(e,t){this._recursivelySet(e,t,["borderVisible"],[],["paragraph","rows"])},a.prototype.update=function(e){this._recursivelyUpdate(e)},a.prototype.appendColumn=function(e){s(this,"AppendColumn",0,[e],0,0)},a.prototype.appendRow=function(t){return i(e.TableRow,this,"AppendRow",0,[t],!1,!0,null,0)},a.prototype.clear=function(){s(this,"Clear",0,[],0,0)},a.prototype.delete=function(){d("Table.delete",n,"1.19",t),s(this,"Delete",0,[],0,0)},a.prototype.getCell=function(t,n){return i(e.TableCell,this,"GetCell",1,[t,n],!1,!1,null,4)},a.prototype.insertColumn=function(e,t){s(this,"InsertColumn",0,[e,t],0,0)},a.prototype.insertRow=function(t,n){return i(e.TableRow,this,"InsertRow",0,[t,n],!1,!0,null,0)},a.prototype.select=function(e){d("Table.select",n,"1.19",t),s(this,"Select",0,[e],0,0)},a.prototype.setShadingColor=function(e){s(this,"SetShadingColor",0,[e],0,0)},a.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},a.prototype._handleResult=function(e){if(o.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.BorderVisible)||(this._B=t.BorderVisible),f(t.ColumnCount)||(this._C=t.ColumnCount),f(t.Id)||(this._I=t.Id),f(t.RowCount)||(this._R=t.RowCount),f(t._ReferenceId)||(this.__R=t._ReferenceId),_(this,t,["paragraph","Paragraph","rows","Rows"])}},a.prototype.load=function(e){return h(this,e)},a.prototype.retrieve=function(e){return g(this,e)},a.prototype._handleIdResult=function(e){o.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},a.prototype._handleRetrieveResult=function(e,t){o.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},a.prototype.track=function(){return this.context.trackedObjects.add(this),this},a.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},a.prototype.toJSON=function(){return y(this,{borderVisible:this._B,columnCount:this._C,id:this._I,rowCount:this._R},{rows:this._Ro})},a.prototype.setMockData=function(e){b(this,e)},a.prototype.ensureUnchanged=function(e){c(this,e)},a}(OfficeExtension.ClientObject);e.Table=ke;var Fe="TableRow",Me=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"TableRow"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","cellCount","rowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","CellCount","RowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["cells","parentTable"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"cells",{get:function(){return this._Ce||(this._Ce=r(e.TableCellCollection,this,"Cells",!0,4)),this._Ce},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentTable",{get:function(){return this._P||(this._P=r(e.Table,this,"ParentTable",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"cellCount",{get:function(){return p("cellCount",this._C,Fe,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,Fe,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"rowIndex",{get:function(){return p("rowIndex",this._R,Fe,this._isNull),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Fe,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.clear=function(){s(this,"Clear",0,[],0,0)},n.prototype.insertRowAsSibling=function(t,n){return i(e.TableRow,this,"InsertRowAsSibling",0,[t,n],!1,!0,null,0)},n.prototype.setShadingColor=function(e){s(this,"SetShadingColor",0,[e],0,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.CellCount)||(this._C=n.CellCount),f(n.Id)||(this._I=n.Id),f(n.RowIndex)||(this._R=n.RowIndex),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["cells","Cells","parentTable","ParentTable"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{cellCount:this._C,id:this._I,rowIndex:this._R},{cells:this._Ce})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.TableRow=Me;var De="TableRowCollection",Ue=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"TableRowCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,De,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,De,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,De,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.TableRow,this,[t])},n.prototype.getItemAt=function(t){return i(e.TableRow,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.TableRow,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.TableRow,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.TableRow,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.TableRowCollection=Ue;var He="TableCell",Le=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"TableCell"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","_ReferenceId","rowIndex","cellIndex","shadingColor"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","_ReferenceId","RowIndex","CellIndex","ShadingColor"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!1,!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["parentRow","paragraphs"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"paragraphs",{get:function(){return this._P||(this._P=r(e.ParagraphCollection,this,"Paragraphs",!0,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentRow",{get:function(){return this._Pa||(this._Pa=r(e.TableRow,this,"ParentRow",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"cellIndex",{get:function(){return p("cellIndex",this._C,He,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,He,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"rowIndex",{get:function(){return p("rowIndex",this._R,He,this._isNull),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"shadingColor",{get:function(){return p("shadingColor",this._S,He,this._isNull),this._S},set:function(e){this._S=e,u(this,"ShadingColor",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,He,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.set=function(e,t){this._recursivelySet(e,t,["shadingColor"],[],["paragraphs","parentRow"])},n.prototype.update=function(e){this._recursivelyUpdate(e)},n.prototype.appendHtml=function(e){s(this,"AppendHtml",0,[e],0,0)},n.prototype.appendImage=function(t,n,r){return i(e.Image,this,"AppendImage",0,[t,n,r],!1,!0,null,0)},n.prototype.appendRichText=function(t){return i(e.RichText,this,"AppendRichText",0,[t],!1,!0,null,0)},n.prototype.appendTable=function(t,n,r){return i(e.Table,this,"AppendTable",0,[t,n,r],!1,!0,null,0)},n.prototype.clear=function(){s(this,"Clear",0,[],0,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.CellIndex)||(this._C=n.CellIndex),f(n.Id)||(this._I=n.Id),f(n.RowIndex)||(this._R=n.RowIndex),f(n.ShadingColor)||(this._S=n.ShadingColor),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["paragraphs","Paragraphs","parentRow","ParentRow"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{cellIndex:this._C,id:this._I,rowIndex:this._R,shadingColor:this._S},{paragraphs:this._P})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.TableCell=Le;var Be="TableCellCollection",We=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"TableCellCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Count"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,Be,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return p("count",this._C,Be,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Be,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getItem=function(t){return o(e.TableCell,this,[t])},n.prototype.getItemAt=function(t){return i(e.TableCell,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r.Count)||(this._C=r.Count),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.TableCell,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.TableCell,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{count:this._C},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.TableCell,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.TableCellCollection=We;var Ge="AccessibilityViolation",qe=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"AccessibilityViolation"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["id","type","location","name","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Type","Location","Name","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"id",{get:function(){return p("id",this._I,Ge,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"location",{get:function(){return p("location",this._L,Ge,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"name",{get:function(){return p("name",this._N,Ge,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return p("type",this._T,Ge,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Ge,this._isNull),this.__R},enumerable:!0,configurable:!0}),t.prototype.show=function(e){s(this,"Show",0,[e],0,0)},t.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!l(t)){var n=t;m(this,n),f(n.Id)||(this._I=n.Id),f(n.Location)||(this._L=n.Location),f(n.Name)||(this._N=n.Name),f(n.Type)||(this._T=n.Type),f(n._ReferenceId)||(this.__R=n._ReferenceId)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return g(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),l(t)||(f(t._ReferenceId)||(this.__R=t._ReferenceId),f(t.Id)||(this._I=t.Id))},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),v(this,t,n)},t.prototype.track=function(){return this.context.trackedObjects.add(this),this},t.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},t.prototype.toJSON=function(){return y(this,{id:this._I,location:this._L,name:this._N,type:this._T},{})},t.prototype.setMockData=function(e){b(this,e)},t.prototype.ensureUnchanged=function(e){c(this,e)},t}(OfficeExtension.ClientObject);e.AccessibilityViolation=qe;var Ve="AccessibilityViolationCollection",Je=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"AccessibilityViolationCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,Ve,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Ve,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getCount=function(){return s(this,"GetCount",1,[],4,0)},n.prototype.getItem=function(t){return o(e.AccessibilityViolation,this,[t])},n.prototype.getItemAt=function(t){return i(e.AccessibilityViolation,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype.isScanCompleted=function(){return s(this,"IsScanCompleted",1,[],4,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.AccessibilityViolation,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.AccessibilityViolation,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.AccessibilityViolation,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.AccessibilityViolationCollection=Je;var ze="AccessibilityViolationsByEntity",Ke=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"AccessibilityViolationsByEntity"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["id","entityType","entityName","violationsCount","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","EntityType","EntityName","ViolationsCount","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_navigationPropertyNames",{get:function(){return["parentSectionOrNull","parentSectionGroupOrNull"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentSectionGroupOrNull",{get:function(){return this._P||(this._P=r(e.SectionGroup,this,"ParentSectionGroupOrNull",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"parentSectionOrNull",{get:function(){return this._Pa||(this._Pa=r(e.Section,this,"ParentSectionOrNull",!1,4)),this._Pa},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"entityName",{get:function(){return p("entityName",this._E,ze,this._isNull),this._E},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"entityType",{get:function(){return p("entityType",this._En,ze,this._isNull),this._En},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"id",{get:function(){return p("id",this._I,ze,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"violationsCount",{get:function(){return p("violationsCount",this._V,ze,this._isNull),this._V},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,ze,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.navigate=function(){s(this,"Navigate",0,[],0,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(e){if(t.prototype._handleResult.call(this,e),!l(e)){var n=e;m(this,n),f(n.EntityName)||(this._E=n.EntityName),f(n.EntityType)||(this._En=n.EntityType),f(n.Id)||(this._I=n.Id),f(n.ViolationsCount)||(this._V=n.ViolationsCount),f(n._ReferenceId)||(this.__R=n._ReferenceId),_(this,n,["parentSectionGroupOrNull","ParentSectionGroupOrNull","parentSectionOrNull","ParentSectionOrNull"])}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||(f(e._ReferenceId)||(this.__R=e._ReferenceId),f(e.Id)||(this._I=e.Id))},n.prototype._handleRetrieveResult=function(e,n){t.prototype._handleRetrieveResult.call(this,e,n),v(this,e,n)},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{entityName:this._E,entityType:this._En,id:this._I,violationsCount:this._V},{parentSectionGroupOrNull:this._P,parentSectionOrNull:this._Pa})},n.prototype.setMockData=function(e){b(this,e)},n.prototype.ensureUnchanged=function(e){c(this,e)},n}(OfficeExtension.ClientObject);e.AccessibilityViolationsByEntity=Ke;var Qe="AccessibilityViolationsByEntityCollection",Xe=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return __extends(n,t),Object.defineProperty(n.prototype,"_className",{get:function(){return"AccessibilityViolationsByEntityCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"items",{get:function(){return p("items",this.m__items,Qe,this._isNull),this.m__items},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,Qe,this._isNull),this.__R},enumerable:!0,configurable:!0}),n.prototype.getCount=function(){return s(this,"GetCount",1,[],4,0)},n.prototype.getItem=function(t){return o(e.AccessibilityViolationsByEntity,this,[t])},n.prototype.getItemAt=function(t){return i(e.AccessibilityViolationsByEntity,this,"GetItemAt",1,[t],!1,!1,null,4)},n.prototype.isScanCompleted=function(){return s(this,"IsScanCompleted",1,[],4,0)},n.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},n.prototype._handleResult=function(n){if(t.prototype._handleResult.call(this,n),!l(n)){var r=n;if(m(this,r),f(r._ReferenceId)||(this.__R=r._ReferenceId),!l(r[OfficeExtension.Constants.items])){this.m__items=[];for(var i=r[OfficeExtension.Constants.items],o=0;o<i.length;o++){var s=a(e.AccessibilityViolationsByEntity,!0,this,i[o],o);s._handleResult(i[o]),this.m__items.push(s)}}}},n.prototype.load=function(e){return h(this,e)},n.prototype.retrieve=function(e){return g(this,e)},n.prototype._handleIdResult=function(e){t.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},n.prototype._handleRetrieveResult=function(n,r){var i=this;t.prototype._handleRetrieveResult.call(this,n,r),v(this,n,r,(function(t,n){return a(e.AccessibilityViolationsByEntity,!0,i,t,n)}))},n.prototype.track=function(){return this.context.trackedObjects.add(this),this},n.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},n.prototype.toJSON=function(){return y(this,{},{},this.m__items)},n.prototype.setMockData=function(t){var n=this;b(this,t,(function(t,r){return a(e.AccessibilityViolationsByEntity,!0,n,t,r)}),(function(e){return n.m__items=e}))},n}(OfficeExtension.ClientObject);e.AccessibilityViolationsByEntityCollection=Xe;var $e="TagIcon",Ye=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"TagIcon"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["name","type","bitmaps","noteTagShape","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Name","Type","Bitmaps","NoteTagShape","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"bitmaps",{get:function(){return p("bitmaps",this._B,$e,this._isNull),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"name",{get:function(){return p("name",this._N,$e,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"noteTagShape",{get:function(){return p("noteTagShape",this._No,$e,this._isNull),this._No},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return p("type",this._T,$e,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,$e,this._isNull),this.__R},enumerable:!0,configurable:!0}),t.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!l(t)){var n=t;m(this,n),f(n.Bitmaps)||(this._B=n.Bitmaps),f(n.Name)||(this._N=n.Name),f(n.NoteTagShape)||(this._No=n.NoteTagShape),f(n.Type)||(this._T=n.Type),f(n._ReferenceId)||(this.__R=n._ReferenceId)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return g(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),l(t)||f(t._ReferenceId)||(this.__R=t._ReferenceId)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),v(this,t,n)},t.prototype.track=function(){return this.context.trackedObjects.add(this),this},t.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},t.prototype.toJSON=function(){return y(this,{bitmaps:this._B,name:this._N,noteTagShape:this._No,type:this._T},{})},t.prototype.setMockData=function(e){b(this,e)},t.prototype.ensureUnchanged=function(e){c(this,e)},t}(OfficeExtension.ClientObject);e.TagIcon=Ye;var Ze=function(i){function o(){return null!==i&&i.apply(this,arguments)||this}return __extends(o,i),Object.defineProperty(o.prototype,"_className",{get:function(){return"NoteTagManager"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_navigationPropertyNames",{get:function(){return["allNoteTags","featuredNoteTags"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"allNoteTags",{get:function(){return d("NoteTagManager.allNoteTags",n,"1.4",t),this._A||(this._A=r(e.NoteTagCollection,this,"AllNoteTags",!0,4)),this._A},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"featuredNoteTags",{get:function(){return d("NoteTagManager.featuredNoteTags",n,"1.4",t),this._F||(this._F=r(e.NoteTagCollection,this,"FeaturedNoteTags",!0,4)),this._F},enumerable:!0,configurable:!0}),o.prototype.getModificationResult=function(e){return s(this,"GetModificationResult",1,[e],4,0)},o.prototype.setCustomTag=function(e,t,n){return s(this,"SetCustomTag",1,[e,t,n],4,0)},o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(i.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),_(this,t,["allNoteTags","AllNoteTags","featuredNoteTags","FeaturedNoteTags"])}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleRetrieveResult=function(e,t){i.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{},{allNoteTags:this._A,featuredNoteTags:this._F})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.NoteTagManager=Ze;var et="MathAssistantManager",tt=function(r){function o(){return null!==r&&r.apply(this,arguments)||this}return __extends(o,r),Object.defineProperty(o.prototype,"_className",{get:function(){return"MathAssistantManager"},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyNames",{get:function(){return["selectAndCorrectMode","settingsNumberField","settingsTrigUnitMode","sessionId","version","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyOriginalNames",{get:function(){return["SelectAndCorrectMode","SettingsNumberField","SettingsTrigUnitMode","SessionId","Version","_ReferenceId"]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!0,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"selectAndCorrectMode",{get:function(){return p("selectAndCorrectMode",this._S,et,this._isNull),this._S},set:function(e){this._S=e,u(this,"SelectAndCorrectMode",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"sessionId",{get:function(){return p("sessionId",this._Se,et,this._isNull),d("MathAssistantManager.sessionId",n,"1.16",t),this._Se},set:function(e){this._Se=e,u(this,"SessionId",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"settingsNumberField",{get:function(){return p("settingsNumberField",this._Set,et,this._isNull),d("MathAssistantManager.settingsNumberField",n,"1.10",t),this._Set},set:function(e){this._Set=e,u(this,"SettingsNumberField",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"settingsTrigUnitMode",{get:function(){return p("settingsTrigUnitMode",this._Sett,et,this._isNull),d("MathAssistantManager.settingsTrigUnitMode",n,"1.10",t),this._Sett},set:function(e){this._Sett=e,u(this,"SettingsTrigUnitMode",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"version",{get:function(){return p("version",this._V,et,this._isNull),d("MathAssistantManager.version",n,"1.16",t),this._V},set:function(e){this._V=e,u(this,"Version",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,et,this._isNull),d("MathAssistantManager._ReferenceId",n,"1.21",t),this.__R},enumerable:!0,configurable:!0}),o.prototype.set=function(e,t){this._recursivelySet(e,t,["selectAndCorrectMode","settingsNumberField","settingsTrigUnitMode","sessionId","version"],[],[])},o.prototype.update=function(e){this._recursivelyUpdate(e)},o.prototype.convertInkStrokesToTypesetMath=function(e){s(this,"ConvertInkStrokesToTypesetMath",1,[e],4,0)},o.prototype.getActiveInkStrokes=function(){return i(e.InkStrokeCollection,this,"GetActiveInkStrokes",1,[],!0,!1,null,4)},o.prototype.getActiveMathMLs=function(){return s(this,"GetActiveMathMLs",1,[],4,0)},o.prototype.getAlternateInkStrokes=function(){return i(e.InkStrokeCollection,this,"GetAlternateInkStrokes",1,[],!0,!1,null,4)},o.prototype.getFeatureStates=function(){return d("MathAssistantManager.getFeatureStates",n,"1.14",t),s(this,"GetFeatureStates",1,[],4,0)},o.prototype.initialize=function(){s(this,"Initialize",1,[],4,0)},o.prototype.onClosing=function(){s(this,"OnClosing",1,[],4,0)},o.prototype.registerAlterationSelectedEvent=function(){s(this,"RegisterAlterationSelectedEvent",0,[],0,0)},o.prototype.registerInkSelectedForCorrectionEvent=function(){s(this,"RegisterInkSelectedForCorrectionEvent",0,[],0,0)},o.prototype.registerResetEvent=function(){s(this,"RegisterResetEvent",0,[],0,0)},o.prototype.registerRestrictionsCalculatedEvent=function(){s(this,"RegisterRestrictionsCalculatedEvent",0,[],0,0)},o.prototype.runMathImmersiveReader=function(e){d("MathAssistantManager.runMathImmersiveReader",n,"1.15",t),s(this,"RunMathImmersiveReader",1,[e],4,0)},o.prototype.showAlternatesMenu=function(e,t){s(this,"ShowAlternatesMenu",1,[e,t],4,0)},o.prototype.unregisterAlterationSelectedEvent=function(){s(this,"UnregisterAlterationSelectedEvent",0,[],0,0)},o.prototype.unregisterInkSelectedForCorrectionEvent=function(){s(this,"UnregisterInkSelectedForCorrectionEvent",0,[],0,0)},o.prototype.unregisterResetEvent=function(){s(this,"UnregisterResetEvent",0,[],0,0)},o.prototype.unregisterRestrictionsCalculatedEvent=function(){s(this,"UnregisterRestrictionsCalculatedEvent",0,[],0,0)},o.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},o.prototype._handleResult=function(e){if(r.prototype._handleResult.call(this,e),!l(e)){var t=e;m(this,t),f(t.SelectAndCorrectMode)||(this._S=t.SelectAndCorrectMode),f(t.SessionId)||(this._Se=t.SessionId),f(t.SettingsNumberField)||(this._Set=t.SettingsNumberField),f(t.SettingsTrigUnitMode)||(this._Sett=t.SettingsTrigUnitMode),f(t.Version)||(this._V=t.Version),f(t._ReferenceId)||(this.__R=t._ReferenceId)}},o.prototype.load=function(e){return h(this,e)},o.prototype.retrieve=function(e){return g(this,e)},o.prototype._handleIdResult=function(e){r.prototype._handleIdResult.call(this,e),l(e)||f(e._ReferenceId)||(this.__R=e._ReferenceId)},o.prototype._handleRetrieveResult=function(e,t){r.prototype._handleRetrieveResult.call(this,e,t),v(this,e,t)},Object.defineProperty(o.prototype,"onAlterationSelected",{get:function(){var e=this;return this.m_alterationSelected||(this.m_alterationSelected=new OfficeExtension.GenericEventHandlers(this.context,this,"AlterationSelected",{eventType:14,registerFunc:function(){return e.registerAlterationSelectedEvent()},unregisterFunc:function(){return e.unregisterAlterationSelectedEvent()},getTargetIdFunc:function(){return e._ReferenceId},eventArgsTransformFunc:function(e){var t={firstLevelIndex:e.firstLevelIndex,mathML:e.mathML,secondLevelIndex:e.secondLevelIndex,strokeIds:e.strokeIds};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_alterationSelected},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"onInkSelectedForCorrection",{get:function(){var e=this;return this.m_inkSelectedForCorrection||(this.m_inkSelectedForCorrection=new OfficeExtension.GenericEventHandlers(this.context,this,"InkSelectedForCorrection",{eventType:15,registerFunc:function(){return e.registerInkSelectedForCorrectionEvent()},unregisterFunc:function(){return e.unregisterInkSelectedForCorrectionEvent()},getTargetIdFunc:function(){return e._ReferenceId},eventArgsTransformFunc:function(e){var t={isInSnCMode:e.isInSnCMode};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_inkSelectedForCorrection},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"onReset",{get:function(){var e=this;return this.m_reset||(this.m_reset=new OfficeExtension.GenericEventHandlers(this.context,this,"Reset",{eventType:17,registerFunc:function(){return e.registerResetEvent()},unregisterFunc:function(){return e.unregisterResetEvent()},getTargetIdFunc:function(){return e._ReferenceId},eventArgsTransformFunc:function(e){return OfficeExtension.Utility._createPromiseFromResult({})}})),this.m_reset},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"onRestrictionsCalculated",{get:function(){var e=this;return this.m_restrictionsCalculated||(this.m_restrictionsCalculated=new OfficeExtension.GenericEventHandlers(this.context,this,"RestrictionsCalculated",{eventType:16,registerFunc:function(){return e.registerRestrictionsCalculatedEvent()},unregisterFunc:function(){return e.unregisterRestrictionsCalculatedEvent()},getTargetIdFunc:function(){return e._ReferenceId},eventArgsTransformFunc:function(e){var t={isGraphingEnabled:e.isGraphingEnabled,isKeyGraphFeaturesEnabled:e.isKeyGraphFeaturesEnabled,isSolvingEnabled:e.isSolvingEnabled,isStepByStepEnabled:e.isStepByStepEnabled};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_restrictionsCalculated},enumerable:!0,configurable:!0}),o.prototype.track=function(){return this.context.trackedObjects.add(this),this},o.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},o.prototype.toJSON=function(){return y(this,{selectAndCorrectMode:this._S,sessionId:this._Se,settingsNumberField:this._Set,settingsTrigUnitMode:this._Sett,version:this._V},{})},o.prototype.setMockData=function(e){b(this,e)},o.prototype.ensureUnchanged=function(e){c(this,e)},o}(OfficeExtension.ClientObject);e.MathAssistantManager=tt;var nt="Transcription",rt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),Object.defineProperty(t.prototype,"_className",{get:function(){return"Transcription"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyNames",{get:function(){return["_ReferenceId","data"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyOriginalNames",{get:function(){return["_ReferenceId","Data"]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"data",{get:function(){return p("data",this._D,nt,this._isNull),this._D},set:function(e){this._D=e,u(this,"Data",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_ReferenceId",{get:function(){return p("_ReferenceId",this.__R,nt,this._isNull),this.__R},enumerable:!0,configurable:!0}),t.prototype.set=function(e,t){this._recursivelySet(e,t,["data"],[],[])},t.prototype.update=function(e){this._recursivelyUpdate(e)},t.prototype.exists=function(){return s(this,"Exists",1,[],4,0)},t.prototype.notify=function(e,t){s(this,"Notify",1,[e,t],4,0)},t.prototype._KeepReference=function(){s(this,"_KeepReference",1,[],4,0)},t.prototype._handleResult=function(t){if(e.prototype._handleResult.call(this,t),!l(t)){var n=t;m(this,n),f(n.Data)||(this._D=n.Data),f(n._ReferenceId)||(this.__R=n._ReferenceId)}},t.prototype.load=function(e){return h(this,e)},t.prototype.retrieve=function(e){return g(this,e)},t.prototype._handleIdResult=function(t){e.prototype._handleIdResult.call(this,t),l(t)||f(t._ReferenceId)||(this.__R=t._ReferenceId)},t.prototype._handleRetrieveResult=function(t,n){e.prototype._handleRetrieveResult.call(this,t,n),v(this,t,n)},t.prototype.track=function(){return this.context.trackedObjects.add(this),this},t.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this},t.prototype.toJSON=function(){return y(this,{data:this._D},{})},t.prototype.setMockData=function(e){b(this,e)},t.prototype.ensureUnchanged=function(e){c(this,e)},t}(OfficeExtension.ClientObject);e.Transcription=rt,function(e){e.notebook="Notebook",e.sectionGroup="SectionGroup",e.section="Section",e.page="Page",e.pageContent="PageContent"}(e.EntityType||(e.EntityType={})),function(e){e.before="Before",e.after="After"}(e.InsertLocation||(e.InsertLocation={})),function(e){e.other="Other",e.web="Web",e.uwp="UWP",e.win32="Win32",e.mac="Mac",e.ios="IOS"}(e.Platform||(e.Platform={})),function(e){e.outline="Outline",e.image="Image",e.ink="Ink",e.other="Other"}(e.PageContentType||(e.PageContentType={})),function(e){e.richText="RichText",e.image="Image",e.table="Table",e.ink="Ink",e.other="Other"}(e.ParagraphType||(e.ParagraphType={})),function(e){e.unknown="Unknown",e.toDo="ToDo",e.important="Important",e.question="Question",e.contact="Contact",e.address="Address",e.phoneNumber="PhoneNumber",e.website="Website",e.idea="Idea",e.critical="Critical",e.toDoPriority1="ToDoPriority1",e.toDoPriority2="ToDoPriority2"}(e.NoteTagType||(e.NoteTagType={})),function(e){e.unknown="Unknown",e.normal="Normal",e.completed="Completed",e.disabled="Disabled",e.outlookTask="OutlookTask",e.taskNotSyncedYet="TaskNotSyncedYet",e.taskRemoved="TaskRemoved"}(e.NoteTagStatus||(e.NoteTagStatus={})),function(e){e.form="Form",e.entity="Entity",e.graph="Graph",e.oneService="OneService",e.classNotebooks="ClassNotebooks",e.mathSolver="MathSolver",e.mathRecognizer="MathRecognizer",e.roamingSettings="RoamingSettings"}(e.ServiceId||(e.ServiceId={})),function(e){e.selection="Selection",e.activeProfile="ActiveProfile",e.liveId="LiveId",e.orgId="OrgId",e.adal="ADAL",e.notebook="Notebook"}(e.IdentityFilter||(e.IdentityFilter={})),function(e){e.none="None",e.number="Number",e.bullet="Bullet"}(e.ListType||(e.ListType={})),function(e){e.other="Other",e.liveId="LiveId",e.orgId="OrgId",e.adal="ADAL"}(e.AccountType||(e.AccountType={})),function(e){e.trace="Trace",e.data="Data",e.exception="Exception",e.warning="Warning"}(e.LogLevel||(e.LogLevel={})),function(e){e.defaultFlag="DefaultFlag",e.criticalFlag="CriticalFlag",e.measureFlag="MeasureFlag"}(e.EventFlag||(e.EventFlag={})),function(e){e.none="None",e.arabic="Arabic",e.ucroman="UCRoman",e.lcroman="LCRoman",e.ucletter="UCLetter",e.lcletter="LCLetter",e.ordinal="Ordinal",e.cardtext="Cardtext",e.ordtext="Ordtext",e.hex="Hex",e.chiManSty="ChiManSty",e.dbNum1="DbNum1",e.dbNum2="DbNum2",e.aiueo="Aiueo",e.iroha="Iroha",e.dbChar="DbChar",e.sbChar="SbChar",e.dbNum3="DbNum3",e.dbNum4="DbNum4",e.circlenum="Circlenum",e.darabic="DArabic",e.daiueo="DAiueo",e.diroha="DIroha",e.arabicLZ="ArabicLZ",e.bullet="Bullet",e.ganada="Ganada",e.chosung="Chosung",e.gb1="GB1",e.gb2="GB2",e.gb3="GB3",e.gb4="GB4",e.zodiac1="Zodiac1",e.zodiac2="Zodiac2",e.zodiac3="Zodiac3",e.tpeDbNum1="TpeDbNum1",e.tpeDbNum2="TpeDbNum2",e.tpeDbNum3="TpeDbNum3",e.tpeDbNum4="TpeDbNum4",e.chnDbNum1="ChnDbNum1",e.chnDbNum2="ChnDbNum2",e.chnDbNum3="ChnDbNum3",e.chnDbNum4="ChnDbNum4",e.korDbNum1="KorDbNum1",e.korDbNum2="KorDbNum2",e.korDbNum3="KorDbNum3",e.korDbNum4="KorDbNum4",e.hebrew1="Hebrew1",e.arabic1="Arabic1",e.hebrew2="Hebrew2",e.arabic2="Arabic2",e.hindi1="Hindi1",e.hindi2="Hindi2",e.hindi3="Hindi3",e.thai1="Thai1",e.thai2="Thai2",e.numInDash="NumInDash",e.lcrus="LCRus",e.ucrus="UCRus",e.lcgreek="LCGreek",e.ucgreek="UCGreek",e.lim="Lim",e.custom="Custom"}(e.NumberType||(e.NumberType={})),function(e){e.preinstallClassNotebook="PreinstallClassNotebook",e.distributePageId="DistributePageId",e.distributeSection="DistributeSection",e.reviewStudentWork="ReviewStudentWork",e.openTabForCreateClassNotebook="OpenTabForCreateClassNotebook",e.openTabForManageStudent="OpenTabForManageStudent",e.openTabForManageTeacher="OpenTabForManageTeacher",e.openTabForGetNotebookLink="OpenTabForGetNotebookLink",e.openTabForTeacherTraining="OpenTabForTeacherTraining",e.openTabForAddinGuide="OpenTabForAddinGuide",e.openTabForEducationBlog="OpenTabForEducationBlog",e.openTabForEducatorCommunity="OpenTabForEducatorCommunity",e.openTabToSendFeedback="OpenTabToSendFeedback",e.openTabForViewKnowledgeBase="OpenTabForViewKnowledgeBase",e.openTabForSuggestingFeature="OpenTabForSuggestingFeature",e.manageClasses="ManageClasses",e.distributePageMenu="DistributePageMenu",e.distributeSectionMenu="DistributeSectionMenu",e.reviewStudentWorkMenu="ReviewStudentWorkMenu"}(e.ControlId||(e.ControlId={})),function(e){e.none="None",e.missingAltText="MissingAltText",e.tableWithNoHeaderRow="TableWithNoHeaderRow",e.untitledPage="UntitledPage",e.unnamedSection="UnnamedSection",e.unnamedSectionGroup="UnnamedSectionGroup",e.nonDescriptiveAltText="NonDescriptiveAltText",e.nestedTable="NestedTable",e.headingOutOfOrder="HeadingOutOfOrder",e.extraOutline="ExtraOutline",e.extraWhitespace="ExtraWhitespace",e.noHeadingsInALongDocument="NoHeadingsInALongDocument",e.insufficientTextContrast="InsufficientTextContrast"}(e.AccessibilityViolationType||(e.AccessibilityViolationType={})),function(e){e.none="None",e.onHighlight="OnHighlight",e.onMultipleParagraphs="OnMultipleParagraphs",e.onOutline="OnOutline",e.onPage="OnPage",e.onParagraph="OnParagraph",e.onParagraphBegin="OnParagraphBegin",e.onParagraphEnd="OnParagraphEnd",e.onTable="OnTable",e.withinParagraph="WithinParagraph"}(e.AccessibilityViolationLocation||(e.AccessibilityViolationLocation={})),function(e){e.static="Static",e.interactive="Interactive"}(e.TagIconType||(e.TagIconType={})),function(e){e.success="Success",e.pending="Pending",e.invalidIdentity="InvalidIdentity",e.previousStorageError="PreviousStorageError",e.storageError="StorageError",e.alreadyExists="AlreadyExists",e.invalidGUID="InvalidGUID",e.invalidLabel="InvalidLabel"}(e.TagModificationResult||(e.TagModificationResult={})),function(e){e.accessDenied="AccessDenied",e.corruptedContent="CorruptedContent",e.generalException="GeneralException",e.invalidArgument="InvalidArgument",e.invalidOperation="InvalidOperation",e.invalidState="InvalidState",e.itemNotFound="ItemNotFound",e.notImplemented="NotImplemented",e.notSupported="NotSupported",e.operationAborted="OperationAborted"}(e.ErrorCodes||(e.ErrorCodes={})),e.Interfaces||(e.Interfaces={})}(OneNote||(OneNote={})),function(e){var t=function(t){function n(n){var r=t.call(this,n)||this;return r.m_onenote=new e.Application(r,OfficeExtension.ObjectPathFactory.createGlobalObjectObjectPath(r)),r._rootObject=r.m_onenote,r}return __extends(n,t),Object.defineProperty(n.prototype,"application",{get:function(){return this.m_onenote},enumerable:!0,configurable:!0}),n}(OfficeCore.RequestContext);e.RequestContext=t,e.run=function(t,n){return OfficeExtension.ClientRequestContext._runBatch("OneNote.run",arguments,(function(){return new e.RequestContext}))}}(OneNote||(OneNote={})),function(e){if(!function(){try{return"object"==typeof process&&"[object process]"===String(process)}catch(e){return!1}}()&&!e.isOfficeReactNative()){try{e.Flights=e.OUtil.parseFlights(!0),e.DisabledChangeGates=e.OUtil.parseDisabledChangeGates(!0)}catch(e){}function t(){OSFPerformance.hostSpecificFileName=e.LoadScriptHelper.getHostBundleJsName(),Office.onReadyInternal((function(){OSFPerfUtil.sendPerformanceTelemetry()})),e._OfficeAppFactory.getHostInfo().hostLocale&&setTimeout((function(){e.OUtil.ensureOfficeStringsJs().catch((function(e){console.error(e)}))}),0)}e._OfficeAppFactory.bootstrap((function(){}),(function(e){e instanceof Error?console.warn(e.message):console.warn(JSON.stringify(e))})),"complete"===document.readyState||"interactive"===document.readyState?t():window.addEventListener("DOMContentLoaded",(function(e){t()}))}}(OSF||(OSF={})),OSFPerformance.hostInitializationEnd=OSFPerformance.now(),OSFPerformance.totalJSHeapSize=OSFPerformance.getTotalJSHeapSize(),OSFPerformance.usedJSHeapSize=OSFPerformance.getUsedJSHeapSize(),OSFPerformance.jsHeapSizeLimit=OSFPerformance.getJSHeapSizeLimit();