import { RegionRequestOptions, Region } from './region';
import { AdapterOption } from './adapter';
export interface S3IdEndpoint {
    s3Id: string;
    s3Endpoint: string;
}
export declare type GetAllRegionsOptions = RegionRequestOptions;
export declare class RegionService {
    private readonly adapterOption;
    private allRegions;
    private readonly allRegionsLock;
    constructor(adapterOption: AdapterOption);
    getAllRegions(options?: GetAllRegionsOptions): Promise<Array<Region>>;
    clearCache(): void;
    getS3Endpoint(s3RegionId?: string, options?: GetAllRegionsOptions): Promise<S3IdEndpoint>;
    fromKodoRegionIdToS3Id(regionId: string, options?: GetAllRegionsOptions): Promise<string>;
    fromS3IdToKodoRegionId(s3Id: string, options?: GetAllRegionsOptions): Promise<string>;
}
//# sourceMappingURL=region_service.d.ts.map