/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.UIAwareIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class DarkUIAwareIcon
implements UIAwareIcon,
UIResource,
Serializable {
    private final DarkUIAwareIcon dual;
    private final String darkKey;
    private final String lightKey;
    private final int w;
    private final int h;
    private final Class<?> parentClass;
    private transient boolean loaded;
    private transient Icon icon;
    private AwareIconStyle currentStyle;

    public DarkUIAwareIcon(String darkKey, String lightKey, int w, int h, Class<?> parentClass) {
        this.darkKey = darkKey;
        this.lightKey = lightKey;
        this.w = w;
        this.h = h;
        this.parentClass = parentClass;
        this.dual = new DarkUIAwareIcon(this);
    }

    private DarkUIAwareIcon(DarkUIAwareIcon dual) {
        this.darkKey = dual.lightKey;
        this.lightKey = dual.darkKey;
        this.dual = dual;
        this.w = dual.w;
        this.h = dual.h;
        this.parentClass = dual.parentClass;
    }

    public void paintIcon(Component c, Graphics g2, int x, int y, double scale) {
        this.ensureLoaded();
        Graphics2D g = (Graphics2D)g2.create();
        g.translate(x, y);
        g.scale(scale, scale);
        this.icon.paintIcon(c, g, 0, 0);
        g2.dispose();
    }

    private void ensureLoaded() {
        if (!this.isLoaded()) {
            this.loadIcon();
        }
    }

    private boolean isLoaded() {
        return this.loaded && this.currentStyle == IconLoader.getAwareStyle();
    }

    private void loadIcon() {
        this.currentStyle = IconLoader.getAwareStyle();
        this.icon = this.currentStyle == AwareIconStyle.DARK ? IconLoader.get(this.parentClass).getIcon(this.darkKey, this.w, this.h) : IconLoader.get(this.parentClass).getIcon(this.lightKey, this.w, this.h);
        this.loaded = true;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        this.icon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        this.ensureLoaded();
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        this.ensureLoaded();
        return this.icon.getIconHeight();
    }

    @Override
    public DarkUIAwareIcon getDual() {
        return this.dual;
    }
}

