/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSRGBA;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRGB
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSRGB> {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;

    public CSSRGB(@Nonnull CSSRGB cSSRGB) {
        this(cSSRGB.getRed(), cSSRGB.getGreen(), cSSRGB.getBlue());
    }

    public CSSRGB(int n, int n2, int n3) {
        this(Integer.toString(CSSColorHelper.getRGBValue(n)), Integer.toString(CSSColorHelper.getRGBValue(n2)), Integer.toString(CSSColorHelper.getRGBValue(n3)));
    }

    public CSSRGB(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this.setRed(string);
        this.setGreen(string2);
        this.setBlue(string3);
    }

    @Nonnull
    @Nonempty
    public String getRed() {
        return this.m_sRed;
    }

    @Nonnull
    public CSSRGB setRed(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Red");
        this.m_sRed = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getGreen() {
        return this.m_sGreen;
    }

    @Nonnull
    public CSSRGB setGreen(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Green");
        this.m_sGreen = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBlue() {
        return this.m_sBlue;
    }

    @Nonnull
    public CSSRGB setBlue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Blue");
        this.m_sBlue = string;
        return this;
    }

    @Nonnull
    public CSSRGBA getAsRGBA(float f) {
        return new CSSRGBA(this, f);
    }

    @Nonnull
    public CSSRGBA getAsRGBA(@Nonnull @Nonempty String string) {
        return new CSSRGBA(this, string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "rgb(" + this.m_sRed + ',' + this.m_sGreen + ',' + this.m_sBlue + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    @Nonnull
    public CSSRGB getClone() {
        return new CSSRGB(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRGB cSSRGB = (CSSRGB)object;
        return this.m_sRed.equals(cSSRGB.m_sRed) && this.m_sGreen.equals(cSSRGB.m_sGreen) && this.m_sBlue.equals(cSSRGB.m_sBlue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).getToString();
    }
}

