/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos.ui;

import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.macos.JNIDecorationsMacOS;
import com.github.weisj.darklaf.platform.macos.ui.DecorationInformation;
import com.github.weisj.darklaf.platform.macos.ui.MacOSDecorationsUtil;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.UIManager;

public class MacOSTitlePane
extends CustomTitlePane {
    private final JRootPane rootPane;
    private final Window window;
    private WindowListener windowListener;
    private Color inactiveBackground;
    private Color activeBackground;
    private Color inactiveForeground;
    private Color activeForeground;
    private Color border;
    private DecorationInformation decorationInformation;
    private JLabel titleLabel;
    private PropertyChangeHandler propertyChangeListener;
    private boolean hideTitleBar = false;

    public MacOSTitlePane(JRootPane rootPane, Window window) {
        this.rootPane = rootPane;
        this.window = window;
        this.determineColors();
    }

    protected void determineColors() {
        switch (this.getDecorationStyle()) {
            case 4: {
                this.activeBackground = UIManager.getColor("MacOS.OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("MacOS.OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("MacOS.OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("MacOS.OptionPane.questionDialog.titlePane.foreground");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("MacOS.OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("MacOS.OptionPane.warningDialog.titlePane.foreground");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("MacOS.TitlePane.background");
                this.activeForeground = UIManager.getColor("MacOS.TitlePane.foreground");
            }
        }
        this.inactiveBackground = UIManager.getColor("MacOS.TitlePane.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("MacOS.TitlePane.inactiveForeground");
        this.border = UIManager.getColor("MacOS.TitlePane.borderColor");
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public void paintComponent(Graphics g) {
        Window window = this.getWindow();
        boolean active = window == null || window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = active ? this.activeBackground : this.inactiveBackground;
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        if (!this.hideTitleBar()) {
            g.setColor(this.border);
            g.fillRect(0, height - 1, width, 1);
        }
    }

    public Window getWindow() {
        return this.window;
    }

    public void install() {
        this.determineColors();
        JRootPane rootPane = this.getRootPane();
        this.decorationInformation = MacOSDecorationsUtil.installDecorations(rootPane);
        this.installListeners();
        if (!this.decorationInformation.titleVisible) {
            this.titleLabel = new JLabel();
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.decorationInformation.titleFontSize));
            this.titleLabel.setForeground(this.activeForeground);
            this.titleLabel.setText(this.getTitle());
            this.add(this.titleLabel);
        }
    }

    private String getTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return "";
    }

    public void uninstall() {
        if (this.titleLabel != null) {
            this.remove(this.titleLabel);
            this.titleLabel = null;
        }
        this.uninstallListeners();
        MacOSDecorationsUtil.uninstallDecorations(this.decorationInformation);
        this.decorationInformation = null;
    }

    private void installListeners() {
        if (this.window != null && this.useCustomTitle()) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.decorationInformation == null) {
            return new Dimension(0, 0);
        }
        int height = this.decorationInformation.titleBarHeight;
        if (this.hideTitleBar()) {
            height = 0;
        } else if (this.useCustomTitle()) {
            height = Math.max(height, this.titleLabel.getPreferredSize().height);
        }
        return new Dimension(0, height);
    }

    private boolean hideTitleBar() {
        return this.decorationInformation.windowHandle == 0L || JNIDecorationsMacOS.isFullscreen(this.decorationInformation.windowHandle) || this.getDecorationStyle() == 0;
    }

    private boolean useCustomTitle() {
        return this.titleLabel != null && this.decorationInformation != null && !this.decorationInformation.titleVisible;
    }

    public void doLayout() {
        boolean hide = this.hideTitleBar();
        if (this.useCustomTitle() && !hide) {
            int width = this.getWidth();
            int height = this.getHeight();
            int labelWidth = this.titleLabel.getPreferredSize().width;
            int x = (width - labelWidth) / 2;
            this.titleLabel.setBounds(x, 0, labelWidth, height);
        }
        if (hide != this.hideTitleBar) {
            this.hideTitleBar = hide;
            this.getParent().doLayout();
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("title".equals(name)) {
                MacOSTitlePane.this.titleLabel.setText(pce.getNewValue() == null ? "" : pce.getNewValue().toString());
                MacOSTitlePane.this.repaint();
            }
        }
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            MacOSTitlePane.this.titleLabel.setForeground(MacOSTitlePane.this.activeForeground);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            MacOSTitlePane.this.titleLabel.setForeground(MacOSTitlePane.this.inactiveForeground);
        }
    }
}

