/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

@GUIMenuSortOrder(value=1)
@TestElementMetadata(labelResource="test_action_title")
public class TestActionGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JComboBox<String> targetBox;
    private JRadioButton pauseButton;
    private JRadioButton stopButton;
    private JRadioButton stopNowButton;
    private JRadioButton breakLoopButton;
    private JRadioButton restartNextThreadLoopButton;
    private JRadioButton startNextIterationOfCurrentLoopButton;
    private JLabeledTextField durationField;
    private int target = 0;
    private int action = 1;
    private static final String TARGET_LABEL = JMeterUtils.getResString((String)"test_action_target");
    private static final String THREAD_TARGET_LABEL = JMeterUtils.getResString((String)"test_action_target_thread");
    private static final String TEST_TARGET_LABEL = JMeterUtils.getResString((String)"test_action_target_test");
    private static final String ACTION_ON_THREAD_LABEL = JMeterUtils.getResString((String)"test_action_action_thread");
    private static final String ACTION_ON_THREAD_TEST_LABEL = JMeterUtils.getResString((String)"test_action_action_test_thread");
    private static final String PAUSE_ACTION_LABEL = JMeterUtils.getResString((String)"test_action_pause");
    private static final String STOP_ACTION_LABEL = JMeterUtils.getResString((String)"test_action_stop");
    private static final String STOP_NOW_ACTION_LABEL = JMeterUtils.getResString((String)"test_action_stop_now");
    private static final String RESTART_NEXT_THREAD_LOOP_LABEL = JMeterUtils.getResString((String)"test_action_restart_next_loop");
    private static final String START_NEXT_ITERATION_CURRENT_LOOP_ACTION = JMeterUtils.getResString((String)"test_action_continue_current_loop");
    private static final String BREAK_CURRENT_LOOP_ACTION = JMeterUtils.getResString((String)"test_action_break_current_loop");
    private static final String DURATION_LABEL = JMeterUtils.getResString((String)"test_action_duration");

    public TestActionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "test_action_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        TestAction ta = (TestAction)element;
        this.target = ta.getTarget();
        if (this.target == 0) {
            this.targetBox.setSelectedItem(THREAD_TARGET_LABEL);
        } else {
            this.targetBox.setSelectedItem(TEST_TARGET_LABEL);
        }
        this.action = ta.getAction();
        switch (this.action) {
            case 1: {
                this.pauseButton.setSelected(true);
                break;
            }
            case 2: {
                this.stopNowButton.setSelected(true);
                break;
            }
            case 0: {
                this.stopButton.setSelected(true);
                break;
            }
            case 3: {
                this.restartNextThreadLoopButton.setSelected(true);
                break;
            }
            case 4: {
                this.startNextIterationOfCurrentLoopButton.setSelected(true);
                break;
            }
            case 5: {
                this.breakLoopButton.setSelected(true);
                break;
            }
        }
        this.durationField.setText(ta.getDurationAsString());
    }

    public TestElement createTestElement() {
        TestAction ta = new TestAction();
        this.modifyTestElement((TestElement)ta);
        return ta;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        TestAction ta = (TestAction)element;
        ta.setAction(this.action);
        ta.setTarget(this.target);
        ta.setDuration(this.durationField.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.targetBox.setSelectedIndex(0);
        this.durationField.setText("0");
        this.pauseButton.setSelected(true);
        this.action = 1;
        this.target = 0;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        ButtonGroup actionButtons = new ButtonGroup();
        this.pauseButton = new JRadioButton(PAUSE_ACTION_LABEL, true);
        this.pauseButton.addChangeListener(evt -> {
            if (this.pauseButton.isSelected()) {
                this.action = 1;
                this.durationField.setEnabled(true);
                this.targetBox.setEnabled(false);
            }
        });
        this.stopButton = new JRadioButton(STOP_ACTION_LABEL, false);
        this.stopButton.addChangeListener(evt -> {
            if (this.stopButton.isSelected()) {
                this.action = 0;
                this.durationField.setEnabled(false);
                this.targetBox.setEnabled(true);
            }
        });
        this.stopNowButton = new JRadioButton(STOP_NOW_ACTION_LABEL, false);
        this.stopNowButton.addChangeListener(evt -> {
            if (this.stopNowButton.isSelected()) {
                this.action = 2;
                this.durationField.setEnabled(false);
                this.targetBox.setEnabled(true);
            }
        });
        this.restartNextThreadLoopButton = new JRadioButton(RESTART_NEXT_THREAD_LOOP_LABEL, false);
        this.restartNextThreadLoopButton.addChangeListener(evt -> {
            if (this.restartNextThreadLoopButton.isSelected()) {
                this.action = 3;
                this.durationField.setEnabled(false);
                this.targetBox.setSelectedIndex(0);
                this.targetBox.setEnabled(false);
            }
        });
        this.startNextIterationOfCurrentLoopButton = new JRadioButton(START_NEXT_ITERATION_CURRENT_LOOP_ACTION, false);
        this.startNextIterationOfCurrentLoopButton.addChangeListener(evt -> {
            if (this.startNextIterationOfCurrentLoopButton.isSelected()) {
                this.action = 4;
                this.durationField.setEnabled(false);
                this.targetBox.setSelectedIndex(0);
                this.targetBox.setEnabled(false);
            }
        });
        this.breakLoopButton = new JRadioButton(BREAK_CURRENT_LOOP_ACTION, false);
        this.breakLoopButton.addChangeListener(evt -> {
            if (this.breakLoopButton.isSelected()) {
                this.action = 5;
                this.durationField.setEnabled(false);
                this.targetBox.setSelectedIndex(0);
                this.targetBox.setEnabled(false);
            }
        });
        this.durationField = new JLabeledTextField(DURATION_LABEL, 15);
        this.durationField.setText("");
        actionButtons.add(this.pauseButton);
        actionButtons.add(this.stopButton);
        actionButtons.add(this.stopNowButton);
        actionButtons.add(this.restartNextThreadLoopButton);
        actionButtons.add(this.startNextIterationOfCurrentLoopButton);
        actionButtons.add(this.breakLoopButton);
        JPanel actionOnThreadPanel = new JPanel(new GridLayout(3, 2));
        actionOnThreadPanel.setBorder(BorderFactory.createTitledBorder(ACTION_ON_THREAD_LABEL));
        actionOnThreadPanel.add(this.pauseButton);
        actionOnThreadPanel.add((Component)this.durationField);
        actionOnThreadPanel.add(this.restartNextThreadLoopButton);
        actionOnThreadPanel.add(this.startNextIterationOfCurrentLoopButton);
        actionOnThreadPanel.add(this.breakLoopButton);
        JPanel actionOnTestOrThreadPanel = new JPanel(new GridLayout(2, 2));
        actionOnTestOrThreadPanel.setBorder(BorderFactory.createTitledBorder(ACTION_ON_THREAD_TEST_LABEL));
        actionOnTestOrThreadPanel.add(this.stopButton);
        actionOnTestOrThreadPanel.add(this.stopNowButton);
        actionOnTestOrThreadPanel.add(new JLabel(TARGET_LABEL));
        DefaultComboBoxModel<String> targetModel = new DefaultComboBoxModel<String>();
        targetModel.addElement(THREAD_TARGET_LABEL);
        targetModel.addElement(TEST_TARGET_LABEL);
        this.targetBox = new JComboBox(targetModel);
        this.targetBox.addActionListener(evt -> {
            this.target = ((String)this.targetBox.getSelectedItem()).equals(THREAD_TARGET_LABEL) ? 0 : 2;
        });
        actionOnTestOrThreadPanel.add(this.targetBox);
        this.add(actionOnThreadPanel);
        this.add(actionOnTestOrThreadPanel);
    }
}

