/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.sql.Date;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.exparity.hamcrest.date.DayMonthYear;
import org.exparity.hamcrest.date.Months;
import org.exparity.hamcrest.date.Weekdays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMillisecond;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConversionException;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.function.DateFunction;
import org.exparity.hamcrest.date.core.types.Interval;

public abstract class DateMatchers {
    public static final String UNSUPPORTED_SQL_DATE_UNIT = "java.sql.Date does not support time-based comparisons. Prefer SqlDateMatchers for java.sql.Date appropriate matchers";

    public static TemporalMatcher<java.util.Date> after(java.util.Date date) {
        return new IsAfter<java.util.Date, java.util.Date>(TemporalConverters.JAVADATE_AS_JAVADATE, TemporalProviders.javaDate(date), new DateFunction());
    }

    public static TemporalMatcher<java.util.Date> after(Date date) {
        return new IsAfter<java.util.Date, Date>(TemporalConverters.JAVADATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> after(DayMonthYear date) {
        return DateMatchers.after(date.toLocalDate());
    }

    public static TemporalMatcher<java.util.Date> after(LocalDate date) {
        return new IsAfter<java.util.Date, LocalDate>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<java.util.Date> after(LocalDateTime date) {
        return new IsAfter<java.util.Date, LocalDateTime>(TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<java.util.Date> after(Instant date) {
        return new IsAfter<java.util.Date, Instant>(TemporalConverters.JAVADATE_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> after(int year, Months month, int day) {
        return DateMatchers.after(year, month.month(), day);
    }

    public static TemporalMatcher<java.util.Date> after(int year, Month month, int day) {
        return DateMatchers.after(LocalDate.of(year, month, day));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> after(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.after(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static TemporalMatcher<java.util.Date> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.after(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static TemporalMatcher<java.util.Date> before(java.util.Date date) {
        return new IsBefore<java.util.Date, java.util.Date>(TemporalConverters.JAVADATE_AS_JAVADATE, TemporalProviders.javaDate(date), new DateFunction());
    }

    public static TemporalMatcher<java.util.Date> before(Date date) {
        return new IsBefore<java.util.Date, Date>(TemporalConverters.JAVADATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> before(DayMonthYear date) {
        return DateMatchers.before(date.toLocalDate());
    }

    public static TemporalMatcher<java.util.Date> before(LocalDate date) {
        return new IsBefore<java.util.Date, LocalDate>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<java.util.Date> before(LocalDateTime date) {
        return new IsBefore<java.util.Date, LocalDateTime>(TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<java.util.Date> before(Instant date) {
        return new IsBefore<java.util.Date, Instant>(TemporalConverters.JAVADATE_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> before(int year, Months month, int day) {
        return DateMatchers.before(year, month.month(), day);
    }

    public static TemporalMatcher<java.util.Date> before(int year, Month month, int day) {
        return DateMatchers.before(LocalDate.of(year, month, day));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> before(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.before(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static TemporalMatcher<java.util.Date> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.before(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static TemporalMatcher<java.util.Date> sameDayOfWeek(java.util.Date date) {
        return DateMatchers.isDayOfWeek(DateMatchers.toDayOfWeek(date, ZoneId.systemDefault()));
    }

    public static TemporalMatcher<java.util.Date> sameDayOfWeek(Date date) {
        return DateMatchers.isDayOfWeek(date.toLocalDate().getDayOfWeek());
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> isDayOfWeek(Weekdays dayOfWeek) {
        return DateMatchers.isDayOfWeek(dayOfWeek.getAsDayOfWeek());
    }

    public static TemporalMatcher<java.util.Date> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<java.util.Date>(TemporalConverters.JAVADATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<java.util.Date> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<java.util.Date>(TemporalConverters.JAVADATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<java.util.Date> sameDayOfMonth(java.util.Date date) {
        return new IsDayOfMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<java.util.Date> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<java.util.Date> sameDay(java.util.Date date) {
        return new IsSameDay<java.util.Date>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    public static TemporalMatcher<java.util.Date> sameDay(Date date) {
        return new IsSameDay<java.util.Date>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameDay(DayMonthYear date) {
        return DateMatchers.sameDay(date.toLocalDate());
    }

    public static TemporalMatcher<java.util.Date> sameDay(LocalDate date) {
        return new IsSameDay<java.util.Date>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameDay(int year, Months month, int day) {
        return DateMatchers.isDay(year, month.month(), day);
    }

    public static TemporalMatcher<java.util.Date> isDay(int year, Month month, int dayOfMonth) {
        return DateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameHour(java.util.Date date) {
        return DateMatchers.sameHourOfDay(date);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameHour(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    public static TemporalMatcher<java.util.Date> sameHourOfDay(java.util.Date date) {
        return new IsHour<java.util.Date>(TemporalConverters.JAVADATE_AS_HOUR, TemporalProviders.hour(date));
    }

    public static TemporalMatcher<java.util.Date> sameHourOfDay(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameHour(int hour) {
        return DateMatchers.isHour(hour);
    }

    public static TemporalMatcher<java.util.Date> isHour(int hour) {
        return new IsHour<java.util.Date>(TemporalConverters.JAVADATE_AS_HOUR, TemporalProviders.hour(hour));
    }

    public static TemporalMatcher<java.util.Date> sameInstant(java.util.Date date) {
        return new IsSame<java.util.Date, Instant>(TemporalConverters.JAVADATE_AS_INSTANT, TemporalProviders.instant(date), TemporalFunctions.INSTANT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameInstant(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    public static TemporalMatcher<java.util.Date> sameInstant(Instant instant) {
        return new IsSame<java.util.Date, Instant>(TemporalConverters.JAVADATE_AS_INSTANT, TemporalProviders.instant(instant), TemporalFunctions.INSTANT);
    }

    public static TemporalMatcher<java.util.Date> sameInstant(long timestamp) {
        return DateMatchers.sameInstant(Instant.ofEpochMilli(timestamp));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameInstant(int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.isInstant(year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static TemporalMatcher<java.util.Date> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return new IsSame<java.util.Date, LocalDateTime>(TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, milliseconds * 1000000)), TemporalFunctions.LOCALDATETIME);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(java.util.Date date) {
        return new IsSameOrBefore<java.util.Date, java.util.Date>(TemporalConverters.JAVADATE_AS_JAVADATE, TemporalProviders.javaDate(date), TemporalFunctions.JAVADATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(Date date) {
        return new IsSameOrBefore<java.util.Date, Date>(TemporalConverters.JAVADATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<java.util.Date, LocalDate>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(LocalDateTime date) {
        return new IsSameOrBefore<java.util.Date, LocalDateTime>(TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrBefore(DayMonthYear date) {
        return DateMatchers.sameOrBefore(date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrBefore(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(int year, Month month, int dayOfMonth) {
        return DateMatchers.sameOrBefore(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrBefore(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static TemporalMatcher<java.util.Date> sameOrBefore(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrBefore(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(java.util.Date date) {
        return new IsSameOrAfter<java.util.Date, java.util.Date>(TemporalConverters.JAVADATE_AS_JAVADATE, TemporalProviders.javaDate(date), TemporalFunctions.JAVADATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(Date date) {
        return new IsSameOrAfter<java.util.Date, Date>(TemporalConverters.JAVADATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<java.util.Date, LocalDate>(TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(LocalDateTime date) {
        return new IsSameOrAfter<java.util.Date, LocalDateTime>(TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrAfter(DayMonthYear date) {
        return DateMatchers.sameOrAfter(date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrAfter(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(int year, Month month, int dayOfMonth) {
        return DateMatchers.sameOrAfter(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameOrAfter(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static TemporalMatcher<java.util.Date> sameOrAfter(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrAfter(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMinute(java.util.Date date) {
        return DateMatchers.sameMinuteOfHour(date);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMinute(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    public static TemporalMatcher<java.util.Date> sameMinuteOfHour(java.util.Date date) {
        return new IsMinute<java.util.Date>(TemporalConverters.JAVADATE_AS_MINUTE, TemporalProviders.minute(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMinuteOfHour(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMinute(int minute) {
        return DateMatchers.isMinute(minute);
    }

    public static TemporalMatcher<java.util.Date> isMinute(int minute) {
        return new IsMinute<java.util.Date>(TemporalConverters.JAVADATE_AS_MINUTE, TemporalProviders.minute(minute));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMonth(java.util.Date date) {
        return DateMatchers.sameMonthOfYear(date);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMonth(Date date) {
        return DateMatchers.sameMonthOfYear(date);
    }

    public static TemporalMatcher<java.util.Date> sameMonthOfYear(java.util.Date date) {
        return new IsMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<java.util.Date> sameMonthOfYear(Date date) {
        return new IsMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_MONTH, TemporalProviders.month(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMonth(Months month) {
        return DateMatchers.sameMonthOfYear(month);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMonthOfYear(Months month) {
        return DateMatchers.isMonth(month.month());
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameSecond(java.util.Date date) {
        return DateMatchers.sameSecondOfMinute(date);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameSecond(Date date) {
        return DateMatchers.sameSecondOfMinute(date);
    }

    public static TemporalMatcher<java.util.Date> sameSecondOfMinute(java.util.Date date) {
        return new IsSecond<java.util.Date>(TemporalConverters.JAVADATE_AS_SECOND, TemporalProviders.second(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameSecondOfMinute(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameSecond(int second) {
        return DateMatchers.isSecond(second);
    }

    public static TemporalMatcher<java.util.Date> isSecond(int second) {
        return new IsSecond<java.util.Date>(TemporalConverters.JAVADATE_AS_SECOND, TemporalProviders.second(second));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMillisecond(java.util.Date date) {
        return DateMatchers.sameMillisecondOfSecond(date);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMillisecond(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    public static TemporalMatcher<java.util.Date> sameMillisecondOfSecond(java.util.Date date) {
        return new IsMillisecond<java.util.Date>(TemporalConverters.JAVADATE_AS_MILLISECOND, TemporalProviders.millisecondOfMinute(date));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMillisecondOfSecond(Date date) {
        throw new TemporalConversionException(UNSUPPORTED_SQL_DATE_UNIT);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> sameMillisecond(int millisecond) {
        return DateMatchers.isMillisecond(millisecond);
    }

    public static TemporalMatcher<java.util.Date> isMillisecond(int millisecond) {
        return new IsMillisecond<java.util.Date>(TemporalConverters.JAVADATE_AS_MILLISECOND, TemporalProviders.millisecondOfMinute(millisecond));
    }

    public static TemporalMatcher<java.util.Date> sameYear(java.util.Date date) {
        return new IsYear<java.util.Date>(TemporalConverters.JAVADATE_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<java.util.Date> sameYear(Date date) {
        return new IsYear<java.util.Date>(TemporalConverters.JAVADATE_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<java.util.Date> isYear(int year) {
        return new IsYear<java.util.Date>(TemporalConverters.JAVADATE_AS_YEAR, TemporalProviders.year(year));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> within(long period, TimeUnit unit, java.util.Date date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, java.util.Date date) {
        return new IsWithin<java.util.Date, java.util.Date>(Interval.of(period, unit), TemporalConverters.JAVADATE_AS_JAVADATE, TemporalProviders.javaDate(date), TemporalFunctions.JAVADATE);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> within(long period, TimeUnit unit, Date date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, Date date) {
        return new IsWithin<java.util.Date, Date>(Interval.of(period, unit), TemporalConverters.JAVADATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<java.util.Date, LocalDate>(Interval.of(period, unit), TemporalConverters.JAVADATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, LocalDateTime date) {
        return new IsWithin<java.util.Date, LocalDateTime>(Interval.of(period, unit), TemporalConverters.JAVADATE_AS_LOCALDATETIME, TemporalProviders.localDateTime(date), TemporalFunctions.LOCALDATETIME);
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth) {
        return DateMatchers.within(period, unit, LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static TemporalMatcher<java.util.Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static TemporalMatcher<java.util.Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.within(period, unit, LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, milliseconds * 1000000));
    }

    public static TemporalMatcher<java.util.Date> isYesterday() {
        return DateMatchers.sameDay(LocalDate.now().minusDays(1L));
    }

    public static TemporalMatcher<java.util.Date> isToday() {
        return DateMatchers.sameDay(LocalDate.now());
    }

    public static TemporalMatcher<java.util.Date> isTomorrow() {
        return DateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static TemporalMatcher<java.util.Date> isMonday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<java.util.Date> isTuesday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<java.util.Date> isWednesday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<java.util.Date> isThursday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<java.util.Date> isFriday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<java.util.Date> isSaturday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<java.util.Date> isSunday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<java.util.Date> isWeekday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<java.util.Date> isWeekend() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<java.util.Date> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_TEMPORAL);
    }

    public static TemporalMatcher<java.util.Date> isMinimum(ChronoField field) {
        return new IsMinimum<java.util.Date>(TemporalConverters.JAVADATE_AS_TEMPORAL, field);
    }

    public static TemporalMatcher<java.util.Date> isLastDayOfMonth() {
        return new IsLastDayOfMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_TEMPORAL);
    }

    public static TemporalMatcher<java.util.Date> isMaximum(ChronoField field) {
        return new IsMaximum<java.util.Date>(TemporalConverters.JAVADATE_AS_TEMPORAL, field);
    }

    public static TemporalMatcher<java.util.Date> isMonth(Month month) {
        return new IsMonth<java.util.Date>(TemporalConverters.JAVADATE_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<java.util.Date> isJanuary() {
        return DateMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<java.util.Date> isFebruary() {
        return DateMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<java.util.Date> isMarch() {
        return DateMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<java.util.Date> isApril() {
        return DateMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<java.util.Date> isMay() {
        return DateMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<java.util.Date> isJune() {
        return DateMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<java.util.Date> isJuly() {
        return DateMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<java.util.Date> isAugust() {
        return DateMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<java.util.Date> isSeptember() {
        return DateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<java.util.Date> isOctober() {
        return DateMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<java.util.Date> isNovember() {
        return DateMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<java.util.Date> isDecember() {
        return DateMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<java.util.Date> isLeapYear() {
        return new IsLeapYear<java.util.Date>(TemporalConverters.JAVADATE_AS_YEAR);
    }

    private static ChronoUnit convertUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit '" + (Object)((Object)unit) + "'");
    }

    private static DayOfWeek toDayOfWeek(java.util.Date date, ZoneId zone) {
        if (date instanceof Date) {
            return ((Date)date).toLocalDate().getDayOfWeek();
        }
        return date.toInstant().atZone(zone).getDayOfWeek();
    }
}

