/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.icons.RotatableIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.Timer;

public class RotatableIconAnimator
extends Timer {
    private final RotatableIcon icon;
    private final JComponent parent;
    private final int frameCount;
    private int frame;

    public RotatableIconAnimator(RotatableIcon icon, JComponent parent) {
        this(Alignment.values().length, icon, parent);
    }

    public RotatableIconAnimator(int frames, RotatableIcon icon, JComponent parent) {
        super(100, null);
        if (icon == null) {
            throw new IllegalArgumentException("Icon is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Component is null");
        }
        this.addActionListener(this::onAction);
        this.setRepeats(true);
        this.icon = icon;
        this.frameCount = frames;
        this.parent = parent;
    }

    public void resume() {
        this.start();
    }

    public void onAction(ActionEvent e) {
        this.icon.setRotation(Math.PI * 2 * ((double)this.frame / (double)this.frameCount));
        this.parent.repaint();
        this.frame = (this.frame + 1) % this.frameCount;
    }

    public void suspend() {
        this.stop();
    }
}

