/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.color.DarkColorModelHSL;
import com.github.weisj.darklaf.color.DarkColorModelRGB;
import com.github.weisj.darklaf.components.DefaultColorPipette;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.colorchooser.ColorPreviewComponent;
import com.github.weisj.darklaf.ui.colorchooser.ColorTriangle;
import com.github.weisj.darklaf.ui.colorchooser.ColorValueFormatter;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class SmallColorChooser
extends JPanel {
    private static final DarkColorModel[] COLOR_MODELS = new DarkColorModel[]{DarkColorModelRGB.getInstance(), DarkColorModelHSB.getInstance(), DarkColorModelHSL.getInstance()};
    protected ColorTriangle colorTriangle;
    protected ColorPreviewComponent previewComponent;
    protected Color color;
    private Consumer<Color> callback;
    protected boolean valueChanging;
    protected JTabbedPane colorModelTabbedPane;
    protected JFormattedTextField hexField;
    protected Map<DarkColorModel, Runnable> updateMap = new HashMap<DarkColorModel, Runnable>();
    protected ColorValueFormatter hexFormatter;

    public SmallColorChooser(Color initial, Consumer<Color> callback) {
        this.color = initial;
        this.setValueChanging(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.createTopComponent(), constraints);
        constraints.gridy = 1;
        this.add((Component)this.createCenterComponent(), constraints);
        constraints.gridy = 2;
        this.add((Component)this.createBottomComponent(), constraints);
        this.setValueChanging(false);
        this.initListeners();
        this.reset(initial, callback);
    }

    public void reset(Color initial, Consumer<Color> callback) {
        this.callback = callback;
        this.colorTriangle.setColor(this, initial);
    }

    protected void initListeners() {
        this.colorModelTabbedPane.addChangeListener(e -> {
            this.hexFormatter.setModel(this.getDarkColorModel());
            this.colorTriangle.setColorModel(this.getDarkColorModel());
        });
        this.colorTriangle.addListener((c, o) -> {
            this.previewComponent.setColor(c);
            for (DarkColorModel model : COLOR_MODELS) {
                if (o == model) continue;
                this.updateMap.get(model).run();
            }
            if (o != this.hexField) {
                this.hexField.setText(ColorUtil.toHex((Color)c));
            }
        });
        this.hexField.getDocument().addDocumentListener(() -> {
            try {
                String hexStr = String.format("%1$-8s", this.hexField.getText()).replaceAll(" ", "F");
                int[] rgb = new int[]{Integer.valueOf(hexStr.substring(0, 2), 16), Integer.valueOf(hexStr.substring(2, 4), 16), Integer.valueOf(hexStr.substring(4, 6), 16)};
                this.setColor(this.hexField, DarkColorModelRGB.getInstance(), rgb);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        });
    }

    protected void setColor(DarkColorModel source, int ... values) {
        this.setColor((Object)source, source, values);
    }

    protected void setColor(Object source, DarkColorModel model, int ... values) {
        if (this.isValueChanging()) {
            return;
        }
        this.setValueChanging(true);
        if (model != null) {
            this.colorTriangle.setColorFromModel(source, model, values);
        }
        if (this.callback != null) {
            this.callback.accept(this.colorTriangle.getColor());
        }
        this.setValueChanging(false);
    }

    public boolean isValueChanging() {
        return this.valueChanging;
    }

    public void setValueChanging(boolean valueChanging) {
        this.valueChanging = valueChanging;
    }

    protected JComponent createTopComponent() {
        this.colorTriangle = this.createColorWheel();
        JPanel holder = new JPanel(new BorderLayout());
        holder.setOpaque(false);
        holder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        holder.add((Component)this.colorTriangle, "Center");
        return holder;
    }

    protected JComponent createCenterComponent() {
        this.colorModelTabbedPane = new JTabbedPane();
        this.colorModelTabbedPane.putClientProperty("JTabbedPane.centerTabs", true);
        this.colorModelTabbedPane.setOpaque(false);
        this.colorModelTabbedPane.setBackground(PaintUtil.TRANSPARENT_COLOR);
        this.addColorModels(this.colorModelTabbedPane, COLOR_MODELS);
        this.colorModelTabbedPane.setBorder(DarkBorders.createLineBorder(1, 0, 1, 0));
        return this.colorModelTabbedPane;
    }

    protected JComponent createBottomComponent() {
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.previewComponent = this.createPreviewComponent();
        JPanel hexFieldHolder = new JPanel(new GridBagLayout());
        hexFieldHolder.setOpaque(false);
        Box hexBox = Box.createHorizontalBox();
        hexBox.add(new JLabel("#"));
        hexBox.add(this.createHexField());
        hexFieldHolder.add(hexBox);
        box.add(this.previewComponent);
        box.add(Box.createGlue());
        box.add(hexFieldHolder);
        box.add(Box.createGlue());
        box.add(this.createPipetteButton());
        return box;
    }

    private JButton createPipetteButton() {
        Icon pipetteIcon = UIManager.getIcon("ColorChooser.pipette.icon");
        Icon pipetteHoverIcon = UIManager.getIcon("ColorChooser.pipetteRollover.icon");
        JButton pipetteButton = new JButton();
        DefaultColorPipette pipette = new DefaultColorPipette(this, (c, o) -> this.setColor(pipetteButton, DarkColorModelRGB.getInstance(), c.getRed(), c.getGreen(), c.getBlue()));
        pipetteButton.putClientProperty("JButton.thin", Boolean.TRUE);
        pipetteButton.putClientProperty("JButton.square", Boolean.TRUE);
        pipetteButton.putClientProperty("JButton.alternativeArc", Boolean.TRUE);
        pipetteButton.setRolloverEnabled(true);
        pipetteButton.setFocusable(false);
        pipetteButton.setIcon(pipetteIcon);
        pipetteButton.setRolloverIcon(pipetteHoverIcon);
        pipetteButton.setDisabledIcon(pipetteHoverIcon);
        pipetteButton.setPressedIcon(pipetteHoverIcon);
        pipetteButton.addActionListener(e -> {
            pipetteButton.setEnabled(false);
            pipette.setInitialColor(this.getColor());
            pipette.show();
        });
        pipette.setCloseAction(() -> pipetteButton.setEnabled(true));
        return pipetteButton;
    }

    protected JComponent createHexField() {
        this.hexField = new JFormattedTextField();
        this.hexField.setColumns(6);
        this.hexField.putClientProperty("JTextComponent.roundedSelection", false);
        this.hexField.setFocusLostBehavior(1);
        this.hexFormatter = ColorValueFormatter.init(null, 0, true, this.hexField);
        this.hexFormatter.setModel(this.getDarkColorModel());
        return this.hexField;
    }

    public Color getColor() {
        return this.color;
    }

    public DarkColorModel getDarkColorModel() {
        return COLOR_MODELS[this.colorModelTabbedPane.getSelectedIndex()];
    }

    protected void addColorModels(JTabbedPane tabbedPane, DarkColorModel ... colorModels) {
        if (colorModels == null || colorModels.length == 0) {
            throw new IllegalArgumentException("Must pass at least one valid colorModel");
        }
        for (DarkColorModel model : colorModels) {
            tabbedPane.addTab(model.toString(), this.createColorModelComponent(model));
        }
    }

    protected JComponent createColorModelComponent(DarkColorModel model) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        String[] descriptors = model.getFullLabelDescriptorsBefore();
        char[] descriptorsAfter = model.getLabelDescriptorsAfter();
        int count = model.getCount();
        JSlider[] sliders = new JSlider[count];
        Descriptor[] labels = new Descriptor[count];
        for (int i = 0; i < count; ++i) {
            Descriptor label = new Descriptor(descriptors[i], String.valueOf(descriptorsAfter[i]));
            JSlider slider = new JSlider(model.getMinimum(i), model.getMaximum(i));
            slider.putClientProperty("JSlider.instantScrollEnabled", true);
            slider.setValue(model.getDefault(i));
            slider.setSnapToTicks(false);
            slider.setPaintLabels(false);
            label.setLabelFor(slider);
            label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            JPanel holder = new JPanel(new BorderLayout());
            holder.setOpaque(false);
            holder.add((Component)label, "First");
            holder.add((Component)slider, "Center");
            box.add(holder);
            sliders[i] = slider;
            labels[i] = label;
            label.setValue(String.valueOf(slider.getValue()));
            slider.addChangeListener(e -> {
                if (this.isValueChanging()) {
                    return;
                }
                int[] values = new int[count];
                for (int j = 0; j < count; ++j) {
                    values[j] = sliders[j].getValue();
                }
                label.setValue(String.valueOf(slider.getValue()));
                this.setColor(model, values);
            });
        }
        this.updateMap.put(model, () -> {
            int[] values = this.colorTriangle.getValuesForModel(model);
            for (int i = 0; i < count; ++i) {
                sliders[i].setValue(values[i]);
                labels[i].setValue(String.valueOf(values[i]));
            }
        });
        return box;
    }

    protected ColorTriangle createColorWheel() {
        ColorTriangle wheel = new ColorTriangle();
        wheel.setMinimumSize(150);
        wheel.setOpaque(false);
        return wheel;
    }

    protected ColorPreviewComponent createPreviewComponent() {
        return new ColorPreviewComponent(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = SmallColorChooser.this.hexField.getPreferredSize();
                size.height = size.width = size.height - 2 * UIManager.getInt("TextField.borderThickness");
                return size;
            }
        };
    }

    protected static class Descriptor
    extends JLabel {
        protected final String before;
        protected final String after;
        protected String value;

        public Descriptor(String before, String after) {
            this.before = before;
            this.after = after;
            this.setValue(null);
        }

        public void setValue(String value) {
            this.value = value;
            if (this.value == null) {
                this.value = "";
            }
            this.setText(this.before + ": " + value + this.after);
        }
    }
}

