/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.uiresource.DarkFontUIResource;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;

public class FontDefaultsInitTask
implements DefaultsInitTask {
    private static final Logger LOGGER = LogUtil.getLogger(FontDefaultsInitTask.class);
    private static final String FONT_PROPERTY_PATH = "properties/";
    private static final String FONT_SIZE_DEFAULTS_NAME = "font_sizes";
    private static final String FONT_DEFAULTS_NAME = "font";
    private static final Map<AttributedCharacterIterator.Attribute, Integer> ENABLE_KERNING = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    private static final Map<AttributedCharacterIterator.Attribute, Integer> DISABLE_KERNING = Collections.singletonMap(TextAttribute.KERNING, null);
    private static final String MAC_OS_CATALINA_FONT_NAME = ".AppleSystemUIFont";
    private static final String MAC_OS_FONT_NAME = ".SF NS Text";

    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.loadFontProperties(defaults);
        if (SystemInfo.isMac) {
            this.patchMacOSFonts(defaults);
        }
        this.applyFontRule(currentTheme, defaults);
        this.setupRenderingHints(defaults);
    }

    private void setupRenderingHints(UIDefaults defaults) {
        if (!SystemInfo.isMacOSMojave) {
            Object aaHint;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            Object v0 = aaHint = desktopHints == null ? null : desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                defaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, (Object)aaHint);
                defaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, desktopHints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
        }
    }

    private void loadFontProperties(UIDefaults defaults) {
        Properties fontSizeProps = PropertyLoader.loadProperties(DarkLaf.class, (String)FONT_SIZE_DEFAULTS_NAME, (String)FONT_PROPERTY_PATH);
        PropertyLoader.putProperties((Properties)fontSizeProps, (UIDefaults)defaults);
        Properties fontProps = PropertyLoader.loadProperties(DarkLaf.class, (String)FONT_DEFAULTS_NAME, (String)FONT_PROPERTY_PATH);
        PropertyLoader.putProperties((Properties)fontProps, (UIDefaults)defaults);
    }

    private void patchMacOSFonts(UIDefaults defaults) {
        PropertyLoader.replacePropertiesOfType(Font.class, (Map)defaults, this::macOSFontFromFont);
    }

    private Font macOSFontFromFont(Font font) {
        String fontName = SystemInfo.isMacOSCatalina ? MAC_OS_CATALINA_FONT_NAME : MAC_OS_FONT_NAME;
        Font macFont = new Font(fontName, font.getStyle(), font.getSize());
        if (SystemInfo.isMacOSMojave) {
            macFont = macFont.deriveFont(ENABLE_KERNING);
        }
        if (font instanceof UIResource) {
            macFont = new DarkFontUIResource(macFont);
        }
        return macFont == null ? font : macFont;
    }

    private void applyFontRule(Theme currentTheme, UIDefaults defaults) {
        FontSizeRule rule = currentTheme.getFontSizeRule();
        if (rule == null || rule.getType() == FontSizeRule.AdjustmentType.NO_ADJUSTMENT) {
            return;
        }
        PropertyLoader.replacePropertiesOfType(Font.class, (Map)defaults, f -> this.fontWithRule((Font)f, rule));
    }

    private Font fontWithRule(Font font, FontSizeRule rule) {
        if (font == null) {
            return null;
        }
        float size = font.getSize2D();
        float newSize = rule.adjustFontSize(size);
        if (newSize == size) {
            return font;
        }
        if (newSize <= 0.0f) {
            LOGGER.warning("Font " + font + " would be invisible after applying " + rule + ". Font won't be changed!");
            return font;
        }
        Font withRule = font.deriveFont(newSize);
        if (font instanceof UIResource && !(withRule instanceof UIResource)) {
            withRule = new DarkFontUIResource(withRule);
        }
        return withRule;
    }
}

