/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public interface ButtonConstants {
    public static final String KEY_VARIANT = "JButton.variant";
    public static final String KEY_HOVER_COLOR = "JButton.borderless.hover";
    public static final String KEY_CLICK_COLOR = "JButton.borderless.click";
    public static final String KEY_ALT_ARC = "JButton.alternativeArc";
    public static final String KEY_NO_ARC = "JButton.noArc";
    public static final String KEY_SQUARE = "JButton.square";
    public static final String KEY_THIN = "JButton.thin";
    public static final String KEY_NO_BORDERLESS_OVERWRITE = "JButton.noBorderlessOverwrite";
    public static final String KEY_CORNER = "JButton.cornerFlag";
    public static final String KEY_LEFT_NEIGHBOUR = "JButton.leftNeighbour";
    public static final String KEY_RIGHT_NEIGHBOUR = "JButton.rightNeighbour";
    public static final String KEY_TOP_NEIGHBOUR = "JButton.topNeighbour";
    public static final String KEY_BOTTOM_NEIGHBOUR = "JButton.bottomNeighbour";
    public static final String VARIANT_ONLY_LABEL = "onlyLabel";
    public static final String VARIANT_BORDERLESS_RECTANGULAR = "borderlessRectangular";
    public static final String VARIANT_BORDERLESS = "borderless";
    public static final String VARIANT_NONE = "none";

    public static boolean chooseAlternativeArc(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_ALT_ARC);
    }

    public static boolean isLabelButton(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_VARIANT);
    }

    public static boolean isNoArc(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_NO_ARC);
    }

    public static boolean isSquare(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_SQUARE);
    }

    public static boolean isThin(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_THIN) || c instanceof AbstractButton && ButtonConstants.doConvertToBorderless((AbstractButton)c);
    }

    public static boolean isBorderlessVariant(Component c) {
        if (ButtonConstants.isBorderlessRectangular(c)) {
            return true;
        }
        if (c instanceof JButton) {
            return PropertyUtil.isPropertyEqual((Component)c, (String)KEY_VARIANT, (Object)VARIANT_BORDERLESS) || ButtonConstants.doConvertToBorderless((AbstractButton)c);
        }
        return false;
    }

    public static boolean isBorderlessRectangular(Component c) {
        return PropertyUtil.isPropertyEqual((Component)c, (String)KEY_VARIANT, (Object)VARIANT_BORDERLESS_RECTANGULAR);
    }

    public static boolean doConvertToBorderless(AbstractButton b) {
        return ButtonConstants.isIconOnly(b) && !b.isFocusable() && ButtonConstants.convertIconButtonToBorderless(b) && b instanceof JButton;
    }

    public static boolean convertIconButtonToBorderless(AbstractButton b) {
        return !(b instanceof UIResource) && UIManager.getBoolean("Button.convertIconOnlyToBorderless") && !PropertyUtil.getBooleanProperty((JComponent)b, (String)KEY_NO_BORDERLESS_OVERWRITE);
    }

    public static boolean isIconOnly(AbstractButton b) {
        return b.getIcon() != null && (b.getText() == null || b.getText().isEmpty());
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    public static JComponent getNeighbour(String key, Component comp) {
        return (JComponent)PropertyUtil.getObject((Component)comp, (String)key, JComponent.class);
    }
}

