/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.delegate.LayoutManagerDelegate;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.combobox.ComboBoxConstants;
import com.github.weisj.darklaf.ui.combobox.ComboIcon;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxBorder;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxListener;
import com.github.weisj.darklaf.ui.combobox.DarkComboPopup;
import com.github.weisj.darklaf.ui.list.DarkListCellRenderer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class DarkComboBoxUI
extends BasicComboBoxUI
implements ComboBoxConstants {
    protected DarkComboBoxListener comboBoxListener;
    protected int arcSize;
    protected int borderSize;
    protected Color background;
    protected Color editBackground;
    protected Color inactiveBackground;
    protected Color inactiveForeground;
    protected Color arrowBackground;
    private Insets boxPadding;

    public static ComponentUI createUI(JComponent c) {
        return new DarkComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.comboBox, "opaque", false);
        this.installBorder(this.comboBox);
        this.arcSize = UIManager.getInt("ComboBox.arc");
        this.boxPadding = UIManager.getInsets("ComboBox.insets");
        this.borderSize = UIManager.getInt("ComboBox.borderThickness");
        this.background = UIManager.getColor("ComboBox.activeBackground");
        this.editBackground = UIManager.getColor("ComboBox.editBackground");
        this.inactiveBackground = UIManager.getColor("ComboBox.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.arrowBackground = UIManager.getColor("ComboBox.arrowBackground");
        if (this.boxPadding == null) {
            this.boxPadding = new Insets(0, 0, 0, 0);
        }
    }

    protected void installBorder(JComponent c) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            c.setBorder(this.createBorder());
        }
    }

    protected Border createBorder() {
        return new DarkComboBoxBorder(this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBoxListener = this.createComboBoxListener();
        this.comboBox.addMouseListener(this.comboBoxListener);
        this.comboBox.addPropertyChangeListener(this.comboBoxListener);
    }

    protected DarkComboBoxListener createComboBoxListener() {
        return new DarkComboBoxListener(this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.comboBoxListener);
        this.comboBox.removePropertyChangeListener(this.comboBoxListener);
        this.comboBoxListener = null;
    }

    public JComboBox<?> getComboBox() {
        return this.comboBox;
    }

    public AbstractButton getArrowButton() {
        return this.arrowButton;
    }

    public boolean getHasFocus() {
        return this.hasFocus;
    }

    @Override
    protected ComboPopup createPopup() {
        return new DarkComboPopup(this.comboBox, this.borderSize);
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new DarkListCellRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component comp = comboBoxEditor.getEditorComponent();
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.process(e);
            }

            private void process(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 38 || code == 40) && e.getModifiersEx() == 0) {
                    DarkComboBoxUI.this.comboBox.dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.process(e);
            }
        });
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }
        });
        return comboBoxEditor;
    }

    @Override
    protected JButton createArrowButton() {
        int buttonPad = UIManager.getInt("ComboBox.buttonPad");
        JButton button = ArrowButton.createUpDownArrow(this.comboBox, new ComboIcon(this.comboBox, UIManager.getIcon("ComboBox.arrowEditable.icon"), UIManager.getIcon("ComboBox.arrow.icon")), UIManager.getIcon("ComboBox.arrowInactive.icon"), 5, true, false, new Insets(0, buttonPad, 0, buttonPad));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g, c, c.getWidth(), c.getHeight());
        Rectangle r = this.rectangleForCurrentValue();
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    private void paintBackground(Graphics g, JComponent c, int width, int height) {
        Container parent = c.getParent();
        if (parent != null && parent.isOpaque() && !c.isEnabled()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            return;
        }
        boolean isCellEditor = ComboBoxConstants.isTreeOrTableCellEditor(c);
        if (this.comboBox.isEditable() && this.comboBox.getEditor() != null) {
            Component editorComp = this.comboBox.getEditor().getEditorComponent();
            if (this.comboBox.isEnabled()) {
                g.setColor(editorComp.getBackground());
            } else {
                g.setColor(this.inactiveBackground);
            }
        } else {
            g.setColor(this.getBackground(this.comboBox));
        }
        if (!isCellEditor) {
            PaintUtil.fillRoundRect((Graphics2D)g, this.borderSize, this.borderSize, width - 2 * this.borderSize, height - 2 * this.borderSize, this.arcSize);
        } else {
            g.fillRect(0, 0, width, height);
        }
        if (this.comboBox.isEditable()) {
            int bSize = !isCellEditor ? this.borderSize : 0;
            this.paintArrowBackground(width, height, this.comboBox, this.arrowButton, isCellEditor, bSize, this.arcSize, (Graphics2D)g);
        }
    }

    public void paintArrowBackground(int width, int height, JComboBox<?> comboBox, AbstractButton arrowButton, boolean isCellEditor, int bSize, int arc, Graphics2D g) {
        Rectangle arrowBounds = arrowButton.getBounds();
        boolean leftToRight = comboBox.getComponentOrientation().isLeftToRight();
        int off = leftToRight ? arrowBounds.x : arrowBounds.x + arrowBounds.width;
        Area iconRect = new Area(new Rectangle(off, 0, width, height));
        Area rect = !isCellEditor ? new Area(new RoundRectangle2D.Double(bSize, bSize, width - 2 * bSize, height - 2 * bSize, arc, arc)) : new Area(new Rectangle(0, 0, width, height));
        if (leftToRight) {
            rect.intersect(iconRect);
        } else {
            rect.subtract(iconRect);
        }
        g.setPaint(this.getArrowBackground(comboBox));
        g.fill(rect);
    }

    protected Color getBackground(JComboBox<?> c) {
        if (!c.isEnabled()) {
            return this.inactiveBackground;
        }
        if (c.isEditable()) {
            return this.editBackground;
        }
        return this.background;
    }

    protected Color getArrowBackground(JComboBox<?> c) {
        if (!c.isEnabled()) {
            return this.inactiveBackground;
        }
        if (c.isEditable()) {
            return this.arrowBackground;
        }
        return this.background;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManagerDelegate(super.createLayoutManager()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (ComboBoxConstants.isTreeOrTableCellEditor(DarkComboBoxUI.this.comboBox)) {
                    int adj = DarkComboBoxUI.this.borderSize / 2;
                    if (!DarkComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight()) {
                        adj *= -1;
                    }
                    Rectangle bounds = DarkComboBoxUI.this.arrowButton.getBounds();
                    bounds.x += adj;
                    DarkComboBoxUI.this.arrowButton.setBounds(bounds);
                }
            }
        };
    }

    private Color getForeground(Component c) {
        return c.isEnabled() ? c.getForeground() : this.inactiveForeground;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        int buttonHeight = size.height;
        int buttonWidth = this.squareButton ? buttonHeight : this.arrowButton.getPreferredSize().width + this.arrowButton.getInsets().left + this.arrowButton.getInsets().right;
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right + buttonWidth;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = super.rectangleForCurrentValue();
        if (this.comboBox.isEditable()) {
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                rect.x += this.boxPadding.left;
                rect.width -= this.boxPadding.left;
            } else {
                rect.width -= this.borderSize + 1;
                ++rect.x;
            }
        }
        return rect;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else {
            c.setForeground(this.getForeground(this.comboBox));
            c.setBackground(this.getBackground(this.comboBox));
        }
        boolean bl = changeOpaque = c.isOpaque() && (!this.comboBox.isEnabled() || ComboBoxConstants.isTreeOrTableCellEditor(this.comboBox));
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = c instanceof JPanel;
        Rectangle r = new Rectangle(bounds);
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    public void checkFocus() {
        this.hasFocus = DarkUIUtil.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        Component component = this.editor = ed == null ? null : ed.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarkUIUtil.hasFocus(this.editor);
        }
    }

    public void resetPopup() {
        ((DarkComboPopup)this.popup).reset();
    }
}

