/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.filechooser;

import com.github.weisj.darklaf.ui.filechooser.DarkFilePaneUIBridge;
import com.github.weisj.darklaf.ui.filechooser.MetalUIDefaults;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;

public abstract class DarkFileChooserUIBridge
extends BasicFileChooserUI {
    protected static final Dimension hstrut5 = new Dimension(5, 1);
    protected static final Dimension vstrut5 = new Dimension(1, 5);
    static final int space = 10;
    protected static final int PREF_WIDTH = 500;
    protected static final int PREF_HEIGHT = 326;
    protected static final Dimension PREF_SIZE = new Dimension(500, 326);
    protected static final int MIN_WIDTH = 500;
    protected static final int MIN_HEIGHT = 326;
    protected static final int LIST_PREF_WIDTH = 405;
    protected static final int LIST_PREF_HEIGHT = 135;
    protected static final Dimension LIST_PREF_SIZE = new Dimension(405, 135);
    protected JLabel lookInLabel;
    protected JComboBox<Object> directoryComboBox;
    protected DirectoryComboBoxModel directoryComboBoxModel;
    protected final Action directoryComboBoxAction = new DirectoryComboBoxAction();
    protected FilterComboBoxModel filterComboBoxModel;
    protected JTextField fileNameTextField;
    protected DarkFilePaneUIBridge filePane;
    protected JToggleButton listViewButton;
    protected JToggleButton detailsViewButton;
    protected JButton approveButton;
    protected JButton cancelButton;
    protected JPanel buttonPanel;
    protected JPanel bottomPanel;
    protected JComboBox<?> filterComboBox;
    protected int lookInLabelMnemonic = 0;
    protected String lookInLabelText = null;
    protected String saveInLabelText = null;
    protected int fileNameLabelMnemonic = 0;
    protected String fileNameLabelText = null;
    protected int folderNameLabelMnemonic = 0;
    protected String folderNameLabelText = null;
    protected int filesOfTypeLabelMnemonic = 0;
    protected String filesOfTypeLabelText = null;
    protected String upFolderToolTipText = null;
    protected String upFolderAccessibleName = null;
    protected String homeFolderToolTipText = null;
    protected String homeFolderAccessibleName = null;
    protected String newFolderToolTipText = null;
    protected String newFolderAccessibleName = null;
    protected String listViewButtonToolTipText = null;
    protected String listViewButtonAccessibleName = null;
    protected String detailsViewButtonToolTipText = null;
    protected String detailsViewButtonAccessibleName = null;
    protected AlignedLabel fileNameLabel;

    public DarkFileChooserUIBridge(JFileChooser filechooser) {
        super(filechooser);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(c);
    }

    @Override
    public abstract void installComponents(JFileChooser var1);

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        UIDefaults defaults = MetalUIDefaults.get();
        this.lookInLabelMnemonic = this.getMnemonic(defaults, "FileChooser.lookInLabelMnemonic", l);
        this.lookInLabelText = defaults.getString("FileChooser.lookInLabelText", l);
        this.saveInLabelText = defaults.getString("FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = this.getMnemonic(defaults, "FileChooser.fileNameLabelMnemonic", l);
        this.fileNameLabelText = defaults.getString("FileChooser.fileNameLabelText", l);
        this.folderNameLabelMnemonic = this.getMnemonic(defaults, "FileChooser.folderNameLabelMnemonic", l);
        this.folderNameLabelText = defaults.getString("FileChooser.folderNameLabelText", l);
        this.filesOfTypeLabelMnemonic = this.getMnemonic(defaults, "FileChooser.filesOfTypeLabelMnemonic", l);
        this.filesOfTypeLabelText = defaults.getString("FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = defaults.getString("FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = defaults.getString("FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = defaults.getString("FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = defaults.getString("FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = defaults.getString("FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = defaults.getString("FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = defaults.getString("FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = defaults.getString("FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = defaults.getString("FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = defaults.getString("FileChooser.detailsViewButtonAccessibleName", l);
    }

    protected Integer getMnemonic(UIDefaults defaults, String key, Locale l) {
        Object value = defaults.get(key, l);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return 0;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return e -> {
            String s;
            switch (s = e.getPropertyName()) {
                case "SelectedFileChangedProperty": {
                    this.doSelectedFileChanged(e);
                    break;
                }
                case "SelectedFilesChangedProperty": {
                    this.doSelectedFilesChanged(e);
                    break;
                }
                case "directoryChanged": 
                case "FileChooser.useShellFolder": {
                    this.doDirectoryChanged(e);
                    break;
                }
                case "fileFilterChanged": {
                    this.doFilterChanged(e);
                    break;
                }
                case "fileSelectionChanged": {
                    this.doFileSelectionModeChanged(e);
                    break;
                }
                case "AccessoryChangedProperty": {
                    this.doAccessoryChanged(e);
                    break;
                }
                case "ApproveButtonTextChangedProperty": 
                case "ApproveButtonToolTipTextChangedProperty": {
                    this.doApproveButtonTextChanged(e);
                    break;
                }
                case "DialogTypeChangedProperty": {
                    this.doDialogTypeChanged(e);
                    break;
                }
                case "ApproveButtonMnemonicChangedProperty": {
                    this.doApproveButtonMnemonicChanged(e);
                    break;
                }
                case "ControlButtonsAreShownChangedProperty": {
                    this.doControlButtonsChanged(e);
                    break;
                }
                case "componentOrientation": {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o == e.getOldValue()) break;
                    cc.applyComponentOrientation(o);
                    break;
                }
                case "ancestor": {
                    if (e.getOldValue() != null || e.getNewValue() == null) break;
                    this.fileNameTextField.selectAll();
                    this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
    }

    protected void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    protected void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent e) {
        if (this.fileNameLabel != null) {
            this.populateFileNameLabel();
        }
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    protected void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    protected void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    protected void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    protected void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    protected void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.filePane.ensureFileIsVisible(fc, f);
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return super.createListSelectionListener(fc);
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            if (this.approveButton != null) {
                this.approveButton.setText(this.directoryOpenButtonText);
                this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            }
        } else if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        FilePane.addActionsToMap(map, this.filePane.getActions());
        return map;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected DefaultListCellRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    protected String fileNameString(File[] files) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            if (files.length > 1) {
                sb.append("\"");
            }
            sb.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            sb.append("\"");
        }
        return sb.toString();
    }

    protected String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() || fc.isDirectorySelectionEnabled() && fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected ListCellRenderer<Object> createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    protected static void groupLabels(AlignedLabel[] group) {
        for (AlignedLabel alignedLabel : group) {
            alignedLabel.group = group;
        }
    }

    protected JPanel createList(JFileChooser fc) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        return this.filePane.createDetailsView();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = DarkFileChooserUIBridge.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(Math.max(d.width, prefWidth), Math.max(d.height, DarkFileChooserUIBridge.PREF_SIZE.height));
        }
        return new Dimension(prefWidth, DarkFileChooserUIBridge.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(500, 326);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected static class AlignedLabel
    extends JLabel {
        protected AlignedLabel[] group;
        protected int maxWidth = 0;

        AlignedLabel() {
            this.setAlignmentX(0.0f);
        }

        AlignedLabel(String text) {
            super(text);
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        protected int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int max = 0;
                for (AlignedLabel label : this.group) {
                    max = Math.max(label.getSuperPreferredWidth(), max);
                }
                for (AlignedLabel alignedLabel : this.group) {
                    alignedLabel.maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        protected int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarkFileChooserUIBridge.this.directoryComboBox.hidePopup();
            File f = (File)DarkFileChooserUIBridge.this.directoryComboBox.getSelectedItem();
            if (!DarkFileChooserUIBridge.this.getFileChooser().getCurrentDirectory().equals(f)) {
                DarkFileChooserUIBridge.this.getFileChooser().setCurrentDirectory(f);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object>,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = DarkFileChooserUIBridge.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (Objects.equals(prop, "ChoosableFileFilterChangedProperty")) {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (Objects.equals(prop, "fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                DarkFileChooserUIBridge.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = DarkFileChooserUIBridge.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    DarkFileChooserUIBridge.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return DarkFileChooserUIBridge.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return DarkFileChooserUIBridge.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object> {
        final Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        final JFileChooser chooser = DarkFileChooserUIBridge.this.getFileChooser();
        final FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = DarkFileChooserUIBridge.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        protected void addItem(File directory) {
            File canonical;
            if (directory == null) {
                return;
            }
            boolean useShellFolder = FilePane.usesShellFolder(this.chooser);
            this.directories.clear();
            File[] baseFolders = useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            try {
                canonical = ShellFolder.getNormalizedFile(directory);
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                File sf;
                File f = sf = useShellFolder ? ShellFolder.getShellFolder(canonical) : canonical;
                Vector<File> path = new Vector<File>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        protected void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }
    }

    static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        final IndentIcon ii = new IndentIcon();

        DirectoryComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(DarkFileChooserUIBridge.this.getFileChooser().getName(directory));
            this.ii.icon = DarkFileChooserUIBridge.this.getFileChooser().getIcon(directory);
            this.ii.depth = DarkFileChooserUIBridge.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected static class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }
    }

    protected static class SingleClickListener
    extends MouseAdapter {
        public SingleClickListener(JList<?> list) {
        }
    }

    protected class MetalFileChooserUIAccessor
    implements DarkFilePaneUIBridge.FileChooserUIAccessor {
        protected MetalFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return DarkFileChooserUIBridge.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return DarkFileChooserUIBridge.this.getModel();
        }

        @Override
        public JPanel createList() {
            return DarkFileChooserUIBridge.this.createList(this.getFileChooser());
        }

        @Override
        public JPanel createDetailsView() {
            return DarkFileChooserUIBridge.this.createDetailsView(this.getFileChooser());
        }

        @Override
        public boolean isDirectorySelected() {
            return DarkFileChooserUIBridge.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return DarkFileChooserUIBridge.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return DarkFileChooserUIBridge.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return DarkFileChooserUIBridge.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return DarkFileChooserUIBridge.this.getNewFolderAction();
        }

        @Override
        public MouseListener createDoubleClickListener(JList<?> list) {
            return DarkFileChooserUIBridge.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return DarkFileChooserUIBridge.this.createListSelectionListener(this.getFileChooser());
        }
    }

    protected static class ButtonAreaLayout
    implements LayoutManager {
        protected final int hGap = 5;
        protected int topMargin = 17;

        protected ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (Component child : children) {
                    Dimension aSize = child.getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * 5, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = 5 + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(5 + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }
    }

    public static class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            this.setOpaque(false);
            return this;
        }
    }
}

