/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkSpinnerBorder
implements Border,
UIResource {
    protected final Color focusBorderColor = UIManager.getColor("Spinner.focusBorderColor");
    protected final Color borderColor = UIManager.getColor("Spinner.activeBorderColor");
    protected final Color inactiveBorderColor = UIManager.getColor("Spinner.inactiveBorderColor");
    protected final int arc = UIManager.getInt("Spinner.arc");
    protected final int borderSize = UIManager.getInt("Spinner.borderThickness");
    protected Insets insets;
    protected Insets cellInsets = UIManager.getInsets("Spinner.cellEditorInsets");

    public DarkSpinnerBorder() {
        this.insets = UIManager.getInsets("Spinner.insets");
        if (this.insets == null) {
            this.insets = new Insets(0, 0, 0, 0);
        }
        if (this.cellInsets == null) {
            this.cellInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        JSpinner spinner;
        JComponent editor;
        int size;
        boolean tableCellEditor = SpinnerConstants.isTableCellEditor(c);
        boolean treeCellEditor = !tableCellEditor && SpinnerConstants.isTreeCellEditor(c);
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = new GraphicsContext(g);
        g.translate(x, y);
        int n = size = tableCellEditor ? 0 : this.borderSize;
        if (c instanceof JSpinner && (editor = (spinner = (JSpinner)c).getEditor()) != null) {
            int off = spinner.getComponentOrientation().isLeftToRight() ? editor.getBounds().x + editor.getWidth() : editor.getBounds().x - 1 - this.borderSize;
            g.setColor(this.getBorderColor(spinner));
            if (!treeCellEditor) {
                g.fillRect(off, size, 1, height - 2 * size);
            } else {
                g.fillRect(off, 0, 1, height);
            }
        }
        if (!tableCellEditor && !treeCellEditor && DarkUIUtil.hasFocus(c)) {
            PaintUtil.paintFocusBorder(g, width, height, this.arc, this.borderSize);
        }
        g.setColor(this.getBorderColor(c));
        if (!tableCellEditor && !treeCellEditor) {
            if (DarkUIUtil.hasFocus(c)) {
                g.setColor(this.focusBorderColor);
            }
            PaintUtil.paintLineBorder(g, size, size, width - 2 * size, height - 2 * size, this.arc);
        } else if (tableCellEditor && c.getParent() instanceof JTable) {
            JTable table = (JTable)c.getParent();
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect(g, 0, 0, width, height, 1);
        }
        g.translate(-x, -y);
        config.restore();
    }

    protected Color getBorderColor(Component c) {
        return c.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (SpinnerConstants.isTreeOrTableCellEditor(c)) {
            return CellUtil.adjustEditorInsets(new InsetsUIResource(this.cellInsets.top, this.cellInsets.left, this.cellInsets.bottom, this.cellInsets.right), c);
        }
        return new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

