/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.samplers.StatisticalSampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.reflect.Functor;
import org.apache.jorphan.util.JMeterError;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSVSaveService {
    private static final Logger log = LoggerFactory.getLogger(CSVSaveService.class);
    public static final String DATA_TYPE = "dataType";
    public static final String FAILURE_MESSAGE = "failureMessage";
    public static final String LABEL = "label";
    public static final String RESPONSE_CODE = "responseCode";
    public static final String RESPONSE_MESSAGE = "responseMessage";
    public static final String SUCCESSFUL = "success";
    public static final String THREAD_NAME = "threadName";
    public static final String TIME_STAMP = "timeStamp";
    public static final String CSV_ELAPSED = "elapsed";
    public static final String CSV_BYTES = "bytes";
    public static final String CSV_SENT_BYTES = "sentBytes";
    public static final String CSV_THREAD_COUNT1 = "grpThreads";
    public static final String CSV_THREAD_COUNT2 = "allThreads";
    public static final String CSV_SAMPLE_COUNT = "SampleCount";
    public static final String CSV_ERROR_COUNT = "ErrorCount";
    public static final String CSV_URL = "URL";
    public static final String CSV_FILENAME = "Filename";
    public static final String CSV_LATENCY = "Latency";
    public static final String CSV_CONNECT_TIME = "Connect";
    public static final String CSV_ENCODING = "Encoding";
    public static final String CSV_HOSTNAME = "Hostname";
    public static final String CSV_IDLETIME = "IdleTime";
    public static final String VARIABLE_NAME_QUOTE_CHAR = "\"";
    private static final SampleSaveConfiguration _saveConfig = SampleSaveConfiguration.staticConfig();
    private static final String[] DATE_FORMAT_STRINGS = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "MM/dd/yy HH:mm:ss"};
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final LinkedMap headerLabelMethods = new LinkedMap();
    public static final char QUOTING_CHAR = '\"';

    private CSVSaveService() {
    }

    public static void processSamples(String filename, Visualizer visualizer, ResultCollector resultCollector) throws IOException {
        boolean errorsOnly = resultCollector.isErrorLogging();
        boolean successOnly = resultCollector.isSuccessOnlyLogging();
        try (FileInputStream inStream = new FileInputStream(filename);
             InputStreamReader inReader = new InputStreamReader((InputStream)inStream, SaveService.getFileEncoding(StandardCharsets.UTF_8.name()));
             BufferedReader dataReader = new BufferedReader(inReader);){
            String[] parts;
            dataReader.mark(400);
            String line = dataReader.readLine();
            if (line == null) {
                throw new IOException(filename + ": unable to read header line");
            }
            long lineNumber = 1L;
            SampleSaveConfiguration saveConfig = CSVSaveService.getSampleSaveConfiguration(line, filename);
            if (saveConfig == null) {
                log.info("{} does not appear to have a valid header. Using default configuration.", (Object)filename);
                saveConfig = (SampleSaveConfiguration)resultCollector.getSaveConfig().clone();
                dataReader.reset();
                lineNumber = 0L;
            }
            char delim = saveConfig.getDelimiter().charAt(0);
            while ((parts = CSVSaveService.csvReadFile(dataReader, delim)).length != 0) {
                SampleResult result;
                SampleEvent event;
                if ((event = CSVSaveService.makeResultFromDelimitedString(parts, saveConfig, ++lineNumber)) == null || !ResultCollector.isSampleWanted((result = event.getResult()).isSuccessful(), errorsOnly, successOnly)) continue;
                visualizer.add(result);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static SampleEvent makeResultFromDelimitedString(String[] parts, SampleSaveConfiguration saveConfig, long lineNumber) {
        result = null;
        hostname = "";
        timeStamp = 0L;
        elapsed = 0L;
        text = null;
        field = null;
        i = 0;
        try {
            if (saveConfig.saveTimestamp()) {
                field = "timeStamp";
                text = parts[i++];
                if (saveConfig.printMilliseconds()) {
                    try {
                        timeStamp = Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        CSVSaveService.log.warn("Cannot parse timestamp: '{}', will try following formats {}", (Object)text, Arrays.asList(CSVSaveService.DATE_FORMAT_STRINGS));
                        foundMatch = false;
                        for (String fmt : CSVSaveService.DATE_FORMAT_STRINGS) {
                            dateFormat = new SimpleDateFormat(fmt);
                            dateFormat.setLenient(false);
                            try {
                                stamp = dateFormat.parse(text);
                                timeStamp = stamp.getTime();
                                CSVSaveService.log.warn("Setting date format to: {}", (Object)fmt);
                                saveConfig.setDateFormat(fmt);
                                foundMatch = true;
                                break;
                            }
                            catch (ParseException pe) {
                                CSVSaveService.log.info("{} did not match {}, trying next date format", (Object)text, (Object)fmt);
                            }
                        }
                        if (foundMatch) ** GOTO lbl41
                        throw new ParseException("No date-time format found matching " + text, -1);
                    }
                } else if (saveConfig.strictDateFormatter() != null) {
                    stamp = saveConfig.strictDateFormatter().parse(text);
                    timeStamp = stamp.getTime();
                } else {
                    msg = "Unknown timestamp format";
                    CSVSaveService.log.warn("Unknown timestamp format");
                    throw new JMeterError("Unknown timestamp format");
                }
            }
lbl41:
            // 5 sources

            if (saveConfig.saveTime()) {
                field = "elapsed";
                text = parts[i++];
                elapsed = Long.parseLong(text);
            }
            result = saveConfig.saveSampleCount() != false ? new StatisticalSampleResult(timeStamp, elapsed) : new SampleResult(timeStamp, elapsed);
            if (saveConfig.saveLabel()) {
                field = "label";
                text = parts[i++];
                result.setSampleLabel(text);
            }
            if (saveConfig.saveCode()) {
                field = "responseCode";
                text = parts[i++];
                result.setResponseCode(text);
            }
            if (saveConfig.saveMessage()) {
                field = "responseMessage";
                text = parts[i++];
                result.setResponseMessage(text);
            }
            if (saveConfig.saveThreadName()) {
                field = "threadName";
                text = parts[i++];
                result.setThreadName(text);
            }
            if (saveConfig.saveDataType()) {
                field = "dataType";
                text = parts[i++];
                result.setDataType(text);
            }
            if (saveConfig.saveSuccess()) {
                field = "success";
                text = parts[i++];
                result.setSuccessful(Boolean.valueOf(text));
            }
            if (saveConfig.saveAssertionResultsFailureMessage()) {
                ++i;
            }
            if (saveConfig.saveBytes()) {
                field = "bytes";
                text = parts[i++];
                result.setBytes(Long.parseLong(text));
            }
            if (saveConfig.saveSentBytes()) {
                field = "sentBytes";
                text = parts[i++];
                result.setSentBytes(Long.parseLong(text));
            }
            if (saveConfig.saveThreadCounts()) {
                field = "grpThreads";
                text = parts[i++];
                result.setGroupThreads(Integer.parseInt(text));
                field = "allThreads";
                text = parts[i++];
                result.setAllThreads(Integer.parseInt(text));
            }
            if (saveConfig.saveUrl()) {
                ++i;
            }
            if (saveConfig.saveFileName()) {
                field = "Filename";
                text = parts[i++];
                result.setResultFileName(text);
            }
            if (saveConfig.saveLatency()) {
                field = "Latency";
                text = parts[i++];
                result.setLatency(Long.parseLong(text));
            }
            if (saveConfig.saveEncoding()) {
                field = "Encoding";
                text = parts[i++];
                result.setEncodingAndType(text);
            }
            if (saveConfig.saveSampleCount()) {
                field = "SampleCount";
                text = parts[i++];
                result.setSampleCount(Integer.parseInt(text));
                field = "ErrorCount";
                text = parts[i++];
                result.setErrorCount(Integer.parseInt(text));
            }
            if (saveConfig.saveHostname()) {
                field = "Hostname";
                hostname = parts[i++];
            }
            if (saveConfig.saveIdleTime()) {
                field = "IdleTime";
                text = parts[i++];
                result.setIdleTime(Long.parseLong(text));
            }
            if (saveConfig.saveConnectTime()) {
                field = "Connect";
                text = parts[i++];
                result.setConnectTime(Long.parseLong(text));
            }
            if (i + saveConfig.getVarCount() < parts.length) {
                CSVSaveService.log.warn("Line: {}. Found {} fields, expected {}. Extra fields have been ignored.", new Object[]{lineNumber, parts.length, i});
            }
        }
        catch (NumberFormatException | ParseException e) {
            if (CSVSaveService.log.isWarnEnabled()) {
                CSVSaveService.log.warn("Error parsing field '{}' at line {}. {}", new Object[]{field, lineNumber, e.toString()});
            }
            throw new JMeterError((Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CSVSaveService.log.warn("Insufficient columns to parse field '{}' at line {}", (Object)field, (Object)lineNumber);
            throw new JMeterError((Throwable)e);
        }
        return new SampleEvent(result, "", hostname);
    }

    public static String printableFieldNamesToString() {
        return CSVSaveService.printableFieldNamesToString(_saveConfig);
    }

    public static String printableFieldNamesToString(SampleSaveConfiguration saveConfig) {
        int delSize;
        StringBuilder text = new StringBuilder();
        String delim = saveConfig.getDelimiter();
        CSVSaveService.appendFields(saveConfig.saveTimestamp(), text, delim, TIME_STAMP);
        CSVSaveService.appendFields(saveConfig.saveTime(), text, delim, CSV_ELAPSED);
        CSVSaveService.appendFields(saveConfig.saveLabel(), text, delim, LABEL);
        CSVSaveService.appendFields(saveConfig.saveCode(), text, delim, RESPONSE_CODE);
        CSVSaveService.appendFields(saveConfig.saveMessage(), text, delim, RESPONSE_MESSAGE);
        CSVSaveService.appendFields(saveConfig.saveThreadName(), text, delim, THREAD_NAME);
        CSVSaveService.appendFields(saveConfig.saveDataType(), text, delim, DATA_TYPE);
        CSVSaveService.appendFields(saveConfig.saveSuccess(), text, delim, SUCCESSFUL);
        CSVSaveService.appendFields(saveConfig.saveAssertionResultsFailureMessage(), text, delim, FAILURE_MESSAGE);
        CSVSaveService.appendFields(saveConfig.saveBytes(), text, delim, CSV_BYTES);
        CSVSaveService.appendFields(saveConfig.saveSentBytes(), text, delim, CSV_SENT_BYTES);
        CSVSaveService.appendFields(saveConfig.saveThreadCounts(), text, delim, CSV_THREAD_COUNT1, CSV_THREAD_COUNT2);
        CSVSaveService.appendFields(saveConfig.saveUrl(), text, delim, CSV_URL);
        CSVSaveService.appendFields(saveConfig.saveFileName(), text, delim, CSV_FILENAME);
        CSVSaveService.appendFields(saveConfig.saveLatency(), text, delim, CSV_LATENCY);
        CSVSaveService.appendFields(saveConfig.saveEncoding(), text, delim, CSV_ENCODING);
        CSVSaveService.appendFields(saveConfig.saveSampleCount(), text, delim, CSV_SAMPLE_COUNT, CSV_ERROR_COUNT);
        CSVSaveService.appendFields(saveConfig.saveHostname(), text, delim, CSV_HOSTNAME);
        CSVSaveService.appendFields(saveConfig.saveIdleTime(), text, delim, CSV_IDLETIME);
        CSVSaveService.appendFields(saveConfig.saveConnectTime(), text, delim, CSV_CONNECT_TIME);
        for (int i = 0; i < SampleEvent.getVarCount(); ++i) {
            text.append(VARIABLE_NAME_QUOTE_CHAR);
            text.append(SampleEvent.getVarName(i));
            text.append(VARIABLE_NAME_QUOTE_CHAR);
            text.append(delim);
        }
        int size = text.length();
        String resultString = size >= (delSize = delim.length()) ? text.substring(0, size - delSize) : text.toString();
        return resultString;
    }

    private static void appendFields(boolean condition, StringBuilder textBuffer, String delim, String ... fieldNames) {
        if (condition) {
            for (String name : fieldNames) {
                textBuffer.append(name);
                textBuffer.append(delim);
            }
        }
    }

    public static SampleSaveConfiguration getSampleSaveConfiguration(String headerLine, String filename) {
        Pattern pattern;
        PatternMatcherInput input;
        Perl5Matcher matcher;
        String[] parts = CSVSaveService.splitHeader(headerLine, _saveConfig.getDelimiter());
        String delim = null;
        if (parts == null && (matcher = JMeterUtils.getMatcher()).matches(input = new PatternMatcherInput(headerLine), pattern = JMeterUtils.getPatternCache().getPattern("\\w+((\\W)\\w+)?(\\2\\w+)*(\\2\"\\w+\")*", 32768))) {
            delim = matcher.getMatch().group(2);
            parts = CSVSaveService.splitHeader(headerLine, delim);
        }
        if (parts == null) {
            return null;
        }
        SampleSaveConfiguration saveConfig = new SampleSaveConfiguration(false);
        int varCount = 0;
        for (String label : parts) {
            if (CSVSaveService.isVariableName(label)) {
                ++varCount;
                continue;
            }
            Functor set = (Functor)headerLabelMethods.get((Object)label);
            set.invoke((Object)saveConfig, (Object[])new Boolean[]{Boolean.TRUE});
        }
        if (delim != null) {
            if (log.isWarnEnabled()) {
                log.warn("Default delimiter '{}' did not work; using alternate '{}' for reading {}", new Object[]{_saveConfig.getDelimiter(), delim, filename});
            }
            saveConfig.setDelimiter(delim);
        }
        saveConfig.setVarCount(varCount);
        return saveConfig;
    }

    private static String[] splitHeader(String headerLine, String delim) {
        String[] parts = headerLine.split("\\Q" + delim);
        int previous = -1;
        for (int i = 0; i < parts.length; ++i) {
            String label = parts[i];
            if (CSVSaveService.isVariableName(label)) {
                previous = Integer.MAX_VALUE;
                continue;
            }
            int current = headerLabelMethods.indexOf((Object)label);
            if (current == -1) {
                log.warn("Unknown column name {}", (Object)label);
                return null;
            }
            if (current <= previous) {
                log.warn("Column header number {} name {} is out of order.", (Object)(i + 1), (Object)label);
                return null;
            }
            previous = current;
        }
        return parts;
    }

    private static boolean isVariableName(String label) {
        return label.length() > 2 && label.startsWith(VARIABLE_NAME_QUOTE_CHAR) && label.endsWith(VARIABLE_NAME_QUOTE_CHAR);
    }

    public static void saveCSVStats(List<?> data, Writer writer) throws IOException {
        CSVSaveService.saveCSVStats(data, writer, null);
    }

    public static void saveCSVStats(List<?> data, Writer writer, String[] headers) throws IOException {
        int DELIM = 44;
        char[] SPECIALS = new char[]{',', '\"'};
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(CSVSaveService.quoteDelimiters(headers[i], SPECIALS));
            }
            writer.write(LINE_SEP);
        }
        for (Object o : data) {
            List row = (List)o;
            for (int idy = 0; idy < row.size(); ++idy) {
                if (idy > 0) {
                    writer.write(44);
                }
                Object item = row.get(idy);
                writer.write(CSVSaveService.quoteDelimiters(String.valueOf(item), SPECIALS));
            }
            writer.write(LINE_SEP);
        }
    }

    public static void saveCSVStats(DefaultTableModel model, FileWriter writer) throws IOException {
        CSVSaveService.saveCSVStats(model, writer, true);
    }

    public static void saveCSVStats(DefaultTableModel model, FileWriter writer, boolean saveHeaders) throws IOException {
        int DELIM = 44;
        char[] SPECIALS = new char[]{',', '\"'};
        int columns = model.getColumnCount();
        int rows = model.getRowCount();
        if (saveHeaders) {
            for (int i = 0; i < columns; ++i) {
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(CSVSaveService.quoteDelimiters(model.getColumnName(i), SPECIALS));
            }
            writer.write(LINE_SEP);
        }
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                if (column > 0) {
                    writer.write(44);
                }
                Object item = model.getValueAt(row, column);
                writer.write(CSVSaveService.quoteDelimiters(String.valueOf(item), SPECIALS));
            }
            writer.write(LINE_SEP);
        }
    }

    public static String resultToDelimitedString(SampleEvent event) {
        return CSVSaveService.resultToDelimitedString(event, event.getResult().getSaveConfig().getDelimiter());
    }

    public static String resultToDelimitedString(SampleEvent event, String delimiter) {
        return CSVSaveService.resultToDelimitedString(event, event.getResult(), event.getResult().getSaveConfig(), delimiter);
    }

    public static String resultToDelimitedString(SampleEvent event, SampleResult sample, SampleSaveConfiguration saveConfig, String delimiter) {
        StringQuoter text = new StringQuoter(delimiter.charAt(0));
        if (saveConfig.saveTimestamp()) {
            if (saveConfig.printMilliseconds()) {
                text.append(sample.getTimeStamp());
            } else if (saveConfig.threadSafeLenientFormatter() != null) {
                String stamp = saveConfig.threadSafeLenientFormatter().format(new Date(sample.getTimeStamp()));
                text.append(stamp);
            }
        }
        if (saveConfig.saveTime()) {
            text.append(sample.getTime());
        }
        if (saveConfig.saveLabel()) {
            text.append(sample.getSampleLabel());
        }
        if (saveConfig.saveCode()) {
            text.append(sample.getResponseCode());
        }
        if (saveConfig.saveMessage()) {
            text.append(sample.getResponseMessage());
        }
        if (saveConfig.saveThreadName()) {
            text.append(sample.getThreadName());
        }
        if (saveConfig.saveDataType()) {
            text.append(sample.getDataType());
        }
        if (saveConfig.saveSuccess()) {
            text.append(sample.isSuccessful());
        }
        if (saveConfig.saveAssertionResultsFailureMessage()) {
            String message = sample.getFirstAssertionFailureMessage();
            if (message != null) {
                text.append(message);
            } else {
                text.append("");
            }
        }
        if (saveConfig.saveBytes()) {
            text.append(sample.getBytesAsLong());
        }
        if (saveConfig.saveSentBytes()) {
            text.append(sample.getSentBytes());
        }
        if (saveConfig.saveThreadCounts()) {
            text.append(sample.getGroupThreads());
            text.append(sample.getAllThreads());
        }
        if (saveConfig.saveUrl()) {
            text.append(sample.getURL());
        }
        if (saveConfig.saveFileName()) {
            text.append(sample.getResultFileName());
        }
        if (saveConfig.saveLatency()) {
            text.append(sample.getLatency());
        }
        if (saveConfig.saveEncoding()) {
            text.append(sample.getDataEncodingWithDefault());
        }
        if (saveConfig.saveSampleCount()) {
            text.append(sample.getSampleCount());
            text.append(sample.getErrorCount());
        }
        if (saveConfig.saveHostname()) {
            text.append(event.getHostname());
        }
        if (saveConfig.saveIdleTime()) {
            text.append(sample.getIdleTime());
        }
        if (saveConfig.saveConnectTime()) {
            text.append(sample.getConnectTime());
        }
        for (int i = 0; i < SampleEvent.getVarCount(); ++i) {
            text.append(event.getVarValue(i));
        }
        return text.toString();
    }

    public static String quoteDelimiters(String input, char[] specialChars) {
        if (StringUtils.containsNone((CharSequence)input, (char[])specialChars)) {
            return input;
        }
        StringBuilder buffer = new StringBuilder(input.length() + 10);
        char quote = specialChars[1];
        buffer.append(quote);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == quote) {
                buffer.append(quote);
            }
            buffer.append(c);
        }
        buffer.append(quote);
        return buffer.toString();
    }

    public static String[] csvReadFile(BufferedReader infile, char delim) throws IOException {
        int ch;
        ParserState state = ParserState.INITIAL;
        ArrayList<String> list = new ArrayList<String>();
        CharArrayWriter baos = new CharArrayWriter(200);
        boolean push = false;
        while (-1 != (ch = infile.read())) {
            push = false;
            switch (state) {
                case INITIAL: {
                    if (ch == 34) {
                        state = ParserState.QUOTED;
                        break;
                    }
                    if (CSVSaveService.isDelimOrEOL(delim, ch)) {
                        push = true;
                        break;
                    }
                    baos.write(ch);
                    state = ParserState.PLAIN;
                    break;
                }
                case PLAIN: {
                    if (ch == 34) {
                        baos.write(ch);
                        throw new IOException("Cannot have quote-char in plain field:[" + baos.toString() + "]");
                    }
                    if (CSVSaveService.isDelimOrEOL(delim, ch)) {
                        push = true;
                        state = ParserState.INITIAL;
                        break;
                    }
                    baos.write(ch);
                    break;
                }
                case QUOTED: {
                    if (ch == 34) {
                        state = ParserState.EMBEDDEDQUOTE;
                        break;
                    }
                    baos.write(ch);
                    break;
                }
                case EMBEDDEDQUOTE: {
                    if (ch == 34) {
                        baos.write(34);
                        state = ParserState.QUOTED;
                        break;
                    }
                    if (CSVSaveService.isDelimOrEOL(delim, ch)) {
                        push = true;
                        state = ParserState.INITIAL;
                        break;
                    }
                    baos.write(34);
                    throw new IOException("Cannot have single quote-char in quoted field:[" + baos.toString() + "]");
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + (Object)((Object)state));
                }
            }
            if (push) {
                if (ch == 13) {
                    infile.mark(1);
                    if (infile.read() != 10) {
                        infile.reset();
                    }
                }
                String s = baos.toString();
                list.add(s);
                baos.reset();
            }
            if (ch != 10 && ch != 13 || state == ParserState.QUOTED) continue;
        }
        if (ch == -1) {
            if (state == ParserState.QUOTED) {
                throw new IOException("Missing trailing quote-char in quoted field:[\"" + baos.toString() + "]");
            }
            if (baos.size() > 0 || push || state == ParserState.EMBEDDEDQUOTE) {
                list.add(baos.toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean isDelimOrEOL(char delim, int ch) {
        return ch == delim || ch == 10 || ch == 13;
    }

    public static String[] csvSplitString(String line, char delim) throws IOException {
        return CSVSaveService.csvReadFile(new BufferedReader(new StringReader(line)), delim);
    }

    public static void saveSampleResult(SampleEvent event, PrintWriter out) {
        SampleSaveConfiguration saveConfiguration = event.getResult().getSaveConfig();
        String delimiter = saveConfiguration.getDelimiter();
        String formattedResult = CSVSaveService.resultToDelimitedString(event, event.getResult(), saveConfiguration, delimiter);
        out.println(formattedResult);
        if (saveConfiguration.saveSubresults()) {
            SampleResult result = event.getResult();
            for (SampleResult subResult : result.getSubResults()) {
                formattedResult = CSVSaveService.resultToDelimitedString(event, subResult, saveConfiguration, delimiter);
                out.println(formattedResult);
            }
        }
    }

    static {
        headerLabelMethods.put((Object)TIME_STAMP, (Object)new Functor("setTimestamp"));
        headerLabelMethods.put((Object)CSV_ELAPSED, (Object)new Functor("setTime"));
        headerLabelMethods.put((Object)LABEL, (Object)new Functor("setLabel"));
        headerLabelMethods.put((Object)RESPONSE_CODE, (Object)new Functor("setCode"));
        headerLabelMethods.put((Object)RESPONSE_MESSAGE, (Object)new Functor("setMessage"));
        headerLabelMethods.put((Object)THREAD_NAME, (Object)new Functor("setThreadName"));
        headerLabelMethods.put((Object)DATA_TYPE, (Object)new Functor("setDataType"));
        headerLabelMethods.put((Object)SUCCESSFUL, (Object)new Functor("setSuccess"));
        headerLabelMethods.put((Object)FAILURE_MESSAGE, (Object)new Functor("setAssertionResultsFailureMessage"));
        headerLabelMethods.put((Object)CSV_BYTES, (Object)new Functor("setBytes"));
        headerLabelMethods.put((Object)CSV_SENT_BYTES, (Object)new Functor("setSentBytes"));
        headerLabelMethods.put((Object)CSV_THREAD_COUNT1, (Object)new Functor("setThreadCounts"));
        headerLabelMethods.put((Object)CSV_THREAD_COUNT2, (Object)new Functor("setThreadCounts"));
        headerLabelMethods.put((Object)CSV_URL, (Object)new Functor("setUrl"));
        headerLabelMethods.put((Object)CSV_FILENAME, (Object)new Functor("setFileName"));
        headerLabelMethods.put((Object)CSV_LATENCY, (Object)new Functor("setLatency"));
        headerLabelMethods.put((Object)CSV_ENCODING, (Object)new Functor("setEncoding"));
        headerLabelMethods.put((Object)CSV_SAMPLE_COUNT, (Object)new Functor("setSampleCount"));
        headerLabelMethods.put((Object)CSV_ERROR_COUNT, (Object)new Functor("setSampleCount"));
        headerLabelMethods.put((Object)CSV_HOSTNAME, (Object)new Functor("setHostname"));
        headerLabelMethods.put((Object)CSV_IDLETIME, (Object)new Functor("setIdleTime"));
        headerLabelMethods.put((Object)CSV_CONNECT_TIME, (Object)new Functor("setConnectTime"));
    }

    private static enum ParserState {
        INITIAL,
        PLAIN,
        QUOTED,
        EMBEDDEDQUOTE;

    }

    static final class StringQuoter {
        private final StringBuilder sb = new StringBuilder(150);
        private final char[] specials;
        private boolean addDelim;

        public StringQuoter(char delim) {
            this.specials = new char[]{delim, '\"', '\r', '\n'};
            this.addDelim = false;
        }

        private void addDelim() {
            if (this.addDelim) {
                this.sb.append(this.specials[0]);
            } else {
                this.addDelim = true;
            }
        }

        public void append(String s) {
            this.addDelim();
            this.sb.append(CSVSaveService.quoteDelimiters(s, this.specials));
        }

        public void append(Object obj) {
            this.append(String.valueOf(obj));
        }

        public void append(int i) {
            this.addDelim();
            this.sb.append(i);
        }

        public void append(long l) {
            this.addDelim();
            this.sb.append(l);
        }

        public void append(boolean b) {
            this.addDelim();
            this.sb.append(b);
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

