/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;

public abstract class AbstractThreadGroupGui
extends AbstractJMeterGuiComponent {
    private static final long serialVersionUID = 240L;
    private JRadioButton continueBox;
    private JRadioButton startNextLoop;
    private JRadioButton stopThreadBox;
    private JRadioButton stopTestBox;
    private JRadioButton stopTestNowBox;

    public AbstractThreadGroupGui() {
        this.init();
        this.initGui();
    }

    @Override
    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_threads");
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(this.createAddMenu());
        if (this.isEnabled() && !JMeterUtils.isTestRunning()) {
            pop.addSeparator();
            pop.add(this.createMenuItem("add_think_times", "Add Think Time between each step"));
            pop.add(this.createMenuItem("run_threadgroup", "run_tg"));
            pop.add(this.createMenuItem("run_threadgroup_no_timers", "run_tg_no_timers"));
            pop.add(this.createMenuItem("validate_threadgroup", "validate_tg"));
        }
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop, false);
        return pop;
    }

    private JMenuItem createMenuItem(String name, String actionCommand) {
        JMenuItem addThinkTimesToChildren = new JMenuItem(JMeterUtils.getResString(name));
        addThinkTimesToChildren.setName(name);
        addThinkTimesToChildren.addActionListener(ActionRouter.getInstance());
        addThinkTimesToChildren.setActionCommand(actionCommand);
        return addThinkTimesToChildren;
    }

    private JMenu createAddMenu() {
        String addAction = "Add";
        JMenu addMenu = new JMenu(JMeterUtils.getResString("add"));
        addMenu.add(MenuFactory.makeMenu("menu_generative_controller", addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_logic_controller", addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_pre_processors", addAction));
        addMenu.add(MenuFactory.makeMenu("menu_post_processors", addAction));
        addMenu.add(MenuFactory.makeMenu("menu_assertions", addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_timer", addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_fragments", addAction));
        addMenu.addSeparator();
        addMenu.add(MenuFactory.makeMenu("menu_config_element", addAction));
        addMenu.add(MenuFactory.makeMenu("menu_listener", addAction));
        return addMenu;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        VerticalPanel box = new VerticalPanel();
        box.add(this.makeTitlePanel());
        box.add(this.createOnErrorPanel());
        this.add((Component)box, "North");
    }

    private void initGui() {
        this.continueBox.setSelected(true);
    }

    private JPanel createOnErrorPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("sampler_on_error_action")));
        ButtonGroup group = new ButtonGroup();
        this.continueBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_continue"));
        group.add(this.continueBox);
        panel.add(this.continueBox);
        this.startNextLoop = new JRadioButton(JMeterUtils.getResString("sampler_on_error_start_next_loop"));
        group.add(this.startNextLoop);
        panel.add(this.startNextLoop);
        this.stopThreadBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_thread"));
        group.add(this.stopThreadBox);
        panel.add(this.stopThreadBox);
        this.stopTestBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test"));
        group.add(this.stopTestBox);
        panel.add(this.stopTestBox);
        this.stopTestNowBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test_now"));
        group.add(this.stopTestNowBox);
        panel.add(this.stopTestNowBox);
        return panel;
    }

    private void setSampleErrorBoxes(AbstractThreadGroup te) {
        if (te.getOnErrorStopTest()) {
            this.stopTestBox.setSelected(true);
        } else if (te.getOnErrorStopTestNow()) {
            this.stopTestNowBox.setSelected(true);
        } else if (te.getOnErrorStopThread()) {
            this.stopThreadBox.setSelected(true);
        } else if (te.getOnErrorStartNextLoop()) {
            this.startNextLoop.setSelected(true);
        } else {
            this.continueBox.setSelected(true);
        }
    }

    private String onSampleError() {
        if (this.stopTestBox.isSelected()) {
            return "stoptest";
        }
        if (this.stopTestNowBox.isSelected()) {
            return "stoptestnow";
        }
        if (this.stopThreadBox.isSelected()) {
            return "stopthread";
        }
        if (this.startNextLoop.isSelected()) {
            return "startnextloop";
        }
        return "continue";
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        this.setSampleErrorBoxes((AbstractThreadGroup)tg);
    }

    @Override
    protected void configureTestElement(TestElement tg) {
        super.configureTestElement(tg);
        tg.setProperty(new StringProperty("ThreadGroup.on_sample_error", this.onSampleError()));
    }
}

