/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.jmeter.report.processor.MeanAggregator;
import org.apache.jmeter.report.processor.PercentileAggregator;

public class StatisticsSummaryData {
    private long firstTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private long bytes = 0L;
    private long sentBytes = 0L;
    private long errors = 0L;
    private long total = 0L;
    private final MeanAggregator mean;
    private final PercentileAggregator median;
    private final PercentileAggregator percentile1;
    private final PercentileAggregator percentile2;
    private final PercentileAggregator percentile3;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public long getElapsedTime() {
        return this.endTime - this.firstTime;
    }

    public final long getFirstTime() {
        return this.firstTime;
    }

    public final void setFirstTime(long firstTime) {
        this.firstTime = Math.min(this.firstTime, firstTime);
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(long endTime) {
        this.endTime = Math.max(this.endTime, endTime);
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public final long getErrors() {
        return this.errors;
    }

    public final void setErrors(long errors) {
        this.errors = errors;
    }

    public final long getTotal() {
        return this.total;
    }

    public final void setTotal(long total) {
        this.total = total;
    }

    public final long getMin() {
        return this.min;
    }

    public final void setMin(long min) {
        this.min = Math.min(this.min, min);
    }

    public final long getMax() {
        return this.max;
    }

    public final void setMax(long max) {
        this.max = Math.max(this.max, max);
    }

    public final PercentileAggregator getPercentile1() {
        return this.percentile1;
    }

    public final PercentileAggregator getPercentile2() {
        return this.percentile2;
    }

    public final PercentileAggregator getPercentile3() {
        return this.percentile3;
    }

    public StatisticsSummaryData(double percentileIndex1, double percentileIndex2, double percentileIndex3) {
        this.percentile1 = new PercentileAggregator(percentileIndex1);
        this.percentile2 = new PercentileAggregator(percentileIndex2);
        this.percentile3 = new PercentileAggregator(percentileIndex3);
        this.mean = new MeanAggregator();
        this.median = new PercentileAggregator(50.0);
    }

    public double getBytesPerSecond() {
        return (double)this.bytes / ((double)this.getElapsedTime() / 1000.0);
    }

    public double getKBytesPerSecond() {
        return this.getBytesPerSecond() / 1024.0;
    }

    public double getThroughput() {
        return (double)this.total / (double)this.getElapsedTime() * 1000.0;
    }

    public void incTotal() {
        ++this.total;
    }

    public void incBytes(long value) {
        this.bytes += value;
    }

    public void incSentBytes(long value) {
        this.sentBytes += value;
    }

    public void incErrors() {
        ++this.errors;
    }

    public MeanAggregator getMean() {
        return this.mean;
    }

    public PercentileAggregator getMedian() {
        return this.median;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    public double getSentBytesPerSecond() {
        return (double)this.sentBytes / ((double)this.getElapsedTime() / 1000.0);
    }

    public double getSentKBytesPerSecond() {
        return this.getSentBytesPerSecond() / 1024.0;
    }
}

