/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShellServer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BeanShellServer.class);
    private final int serverport;
    private final String serverfile;

    public BeanShellServer(int port, String file) {
        this.serverfile = file;
        this.serverport = port;
    }

    static String getprop(String s) {
        return JMeterUtils.getPropDefault(s, s);
    }

    static void setprop(String s, String v) {
        JMeterUtils.getJMeterProperties().setProperty(s, v);
    }

    @Override
    public void run() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Method eval;
            Object instance;
            block7: {
                Class<?> interpreter = loader.loadClass("bsh.Interpreter");
                instance = interpreter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Class<String> string = String.class;
                Class<Object> object = Object.class;
                eval = interpreter.getMethod("eval", string);
                Method setObj = interpreter.getMethod("set", string, object);
                Method setInt = interpreter.getMethod("set", string, Integer.TYPE);
                Method source = interpreter.getMethod("source", string);
                setObj.invoke(instance, "t", this);
                setInt.invoke(instance, "portnum", this.serverport);
                if (this.serverfile.length() > 0) {
                    try {
                        source.invoke(instance, this.serverfile);
                    }
                    catch (InvocationTargetException ite) {
                        Throwable cause = ite.getCause();
                        if (log.isWarnEnabled()) {
                            log.warn("Could not source, {}. {}", (Object)this.serverfile, (Object)(cause != null ? cause.toString() : ite.toString()));
                        }
                        if (!(cause instanceof Error)) break block7;
                        throw (Error)cause;
                    }
                }
            }
            eval.invoke(instance, "setAccessibility(true);");
            eval.invoke(instance, "server(portnum);");
        }
        catch (ClassNotFoundException e) {
            log.error("Beanshell Interpreter not found");
        }
        catch (Exception e) {
            log.error("Problem starting BeanShell server", (Throwable)e);
        }
    }
}

