/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;

public abstract class SecurityContext
extends Context {
    private static volatile SecurityContext _Default = new Default();
    public static final Configurable<Class<? extends SecurityContext>> DEFAULT = new Configurable(Default.class){

        protected void notifyChange(Object oldValue, Object newValue) {
            _Default = (SecurityContext)ObjectFactory.getInstance((Class)newValue).object();
        }
    };

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
    }

    protected SecurityContext() {
    }

    public static Context getCurrent() {
        Context ctx = Context.getCurrent();
        while (ctx != null) {
            if (ctx instanceof SecurityContext) {
                return (SecurityContext)ctx;
            }
            ctx = ctx.getOuter();
        }
        return _Default;
    }

    public static SecurityContext getDefault() {
        return _Default;
    }

    protected final void enterAction() {
        SecurityContext previousPolicy = _Default;
        Context ctx = this.getOuter();
        while (ctx != null) {
            if (ctx instanceof SecurityContext) {
                previousPolicy = (SecurityContext)ctx;
                break;
            }
            ctx = ctx.getOuter();
        }
        if (!previousPolicy.isReplaceable()) {
            throw new SecurityException("Current Security Context not Replaceable");
        }
    }

    protected final void exitAction() {
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isConfigurable(Configurable cfg) {
        return true;
    }

    private static class Default
    extends SecurityContext {
        private Default() {
        }
    }
}

