/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.util.FastMap;
import javolution.util.FastTable;

public abstract class StackContext
extends AllocatorContext {
    public static final Configurable<Class<? extends StackContext>> DEFAULT = new Configurable(Default.class){};

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
    }

    public static void enter() {
        Context.enter(DEFAULT.get());
    }

    public static void exit() {
        Context.exit(StackContext.class);
    }

    private static final class Default
    extends StackContext {
        private final ThreadLocal _factoryToAllocator = new ThreadLocal(){

            protected Object initialValue() {
                return new FastMap();
            }
        };
        private final ThreadLocal _activeAllocators = new ThreadLocal(){

            protected Object initialValue() {
                return new FastTable();
            }
        };
        private final FastTable _ownerUsedAllocators = new FastTable();
        private final FastTable _nonOwnerUsedAllocators = new FastTable();

        private Default() {
        }

        protected void deactivate() {
            FastTable allocators = (FastTable)this._activeAllocators.get();
            int i = 0;
            int n = allocators.size();
            while (i < n) {
                ((Allocator)allocators.get((int)i++)).user = null;
            }
            allocators.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Allocator getAllocator(ObjectFactory factory) {
            FastMap factoryToAllocator = (FastMap)this._factoryToAllocator.get();
            StackAllocator allocator = (StackAllocator)factoryToAllocator.get(factory);
            if (allocator == null) {
                allocator = new StackAllocator(factory);
                factoryToAllocator.put(factory, allocator);
            }
            if (allocator.user == null) {
                allocator.user = Thread.currentThread();
                FastTable activeAllocators = (FastTable)this._activeAllocators.get();
                activeAllocators.add(allocator);
            }
            if (!allocator._inUse) {
                allocator._inUse = true;
                if (Thread.currentThread() == this.getOwner()) {
                    this._ownerUsedAllocators.add(allocator);
                } else {
                    FastTable fastTable = this._nonOwnerUsedAllocators;
                    synchronized (fastTable) {
                        this._nonOwnerUsedAllocators.add(allocator);
                    }
                }
            }
            return allocator;
        }

        protected void enterAction() {
            this.getOuter().getAllocatorContext().deactivate();
        }

        protected void exitAction() {
            StackAllocator allocator;
            this.deactivate();
            int i = 0;
            while (i < this._ownerUsedAllocators.size()) {
                allocator = (StackAllocator)this._ownerUsedAllocators.get(i);
                allocator.reset();
                ++i;
            }
            this._ownerUsedAllocators.clear();
            i = 0;
            while (i < this._nonOwnerUsedAllocators.size()) {
                allocator = (StackAllocator)this._nonOwnerUsedAllocators.get(i);
                allocator.reset();
                ++i;
            }
            this._nonOwnerUsedAllocators.clear();
        }
    }

    private static final class StackAllocator
    extends Allocator {
        private final ObjectFactory _factory;
        private boolean _inUse;
        private int _queueLimit;

        public StackAllocator(ObjectFactory factory) {
            this._factory = factory;
        }

        protected Object allocate() {
            if (this._queueLimit >= this.queue.length) {
                this.resize();
            }
            Object obj = this._factory.create();
            this.queue[this._queueLimit++] = obj;
            return obj;
        }

        protected void recycle(Object object) {
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            int i = this.queueSize;
            while (i < this._queueLimit) {
                if (this.queue[i] == object) {
                    this.queue[i] = this.queue[this.queueSize];
                    this.queue[this.queueSize++] = object;
                    return;
                }
                ++i;
            }
            throw new UnsupportedOperationException("Cannot recycle to the stack an object which has not been allocated from the stack");
        }

        protected void reset() {
            this._inUse = false;
            while (this._factory.doCleanup() && this.queueSize != this._queueLimit) {
                Object obj = this.queue[this.queueSize++];
                this._factory.cleanup(obj);
            }
            this.queueSize = this._queueLimit;
        }

        public String toString() {
            return "Stack allocator for " + this._factory.getClass();
        }
    }
}

