/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import javolution.Javolution;
import javolution.context.LogContext;
import javolution.context.SecurityContext;
import javolution.lang.Reflection;
import javolution.text.TextFormat;
import javolution.util.FastTable;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configurable<T> {
    private volatile T _value;
    private final T _default;

    public Configurable(T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value cannot be null");
        }
        this._default = defaultValue;
        this._value = defaultValue;
    }

    public T get() {
        return this._value;
    }

    public T getDefault() {
        return this._default;
    }

    protected void notifyChange(T oldValue, T newValue) throws UnsupportedOperationException {
    }

    public String toString() {
        return String.valueOf(this._value);
    }

    public String getName() {
        Class<?> cfgClass = this.getClass();
        Class<?> cls = cfgClass.getEnclosingClass();
        Field[] fields = cls.getDeclaredFields();
        try {
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.get(null) == this) {
                    return String.valueOf(cls.getName()) + '#' + field.getName();
                }
                ++i;
            }
        }
        catch (IllegalAccessException ex) {
            LogContext.error(ex);
        }
        return null;
    }

    public static Configurable getInstance(String name) {
        int sep = name.lastIndexOf(35);
        if (sep < 0) {
            return null;
        }
        String className = name.substring(0, sep);
        String fieldName = name.substring(sep + 1);
        Class cls = Reflection.getInstance().getClass(className);
        if (cls == null) {
            return null;
        }
        try {
            Configurable cfg = (Configurable)cls.getDeclaredField(fieldName).get(null);
            return cfg;
        }
        catch (Exception ex) {
            LogContext.error(ex);
            return null;
        }
    }

    public static <T> void configure(Configurable<T> cfg, T newValue) throws SecurityException {
        if (newValue == null) {
            throw new IllegalArgumentException("Default value cannot be null");
        }
        SecurityContext policy = (SecurityContext)SecurityContext.getCurrent();
        if (!policy.isConfigurable(cfg)) {
            throw new SecurityException("Configuration disallowed by SecurityContext");
        }
        T oldValue = cfg._value;
        if (!newValue.equals(oldValue)) {
            LogContext.info("Configurable " + cfg.getName() + " set to " + newValue);
            cfg._value = newValue;
            cfg.notifyChange(oldValue, newValue);
        }
    }

    public static void read(Properties properties) {
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String textValue = properties.getProperty(name);
            Configurable cfg = Configurable.getInstance(name);
            if (cfg == null) continue;
            Class<?> type = cfg.getDefault().getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            if (format == null) {
                LogContext.error("Cannot find TextFormat for instance of " + type);
                continue;
            }
            Object newValue = format.parse(Javolution.j2meToCharSeq(textValue));
            Configurable.configure(cfg, newValue);
        }
    }

    public static void read(InputStream inputStream) {
        try {
            XMLObjectReader reader = XMLObjectReader.newInstance(inputStream);
            XMLBinding binding = new XMLBinding();
            binding.setAlias(Configurable.class, "Configurable");
            reader.setBinding(binding);
            reader.read("Configuration", FastTable.class);
        }
        catch (Exception ex) {
            LogContext.error(ex);
        }
    }
}

