/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import javolution.lang.Immutable;
import javolution.lang.MathLib;
import javolution.text.TextBuilder;

public final class CharSet
implements Immutable {
    public static final CharSet EMPTY = new CharSet(new long[0]);
    public static final CharSet WHITESPACES = CharSet.valueOf('\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u205f', '\u3000');
    public static final CharSet SPACES = CharSet.valueOf(' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000');
    public static final CharSet ISO_CONTROLS;
    private final long[] _mapping;

    static {
        char[] cArray = new char[65];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 127;
        cArray[33] = 128;
        cArray[34] = 129;
        cArray[35] = 130;
        cArray[36] = 131;
        cArray[37] = 132;
        cArray[38] = 133;
        cArray[39] = 134;
        cArray[40] = 135;
        cArray[41] = 136;
        cArray[42] = 137;
        cArray[43] = 138;
        cArray[44] = 139;
        cArray[45] = 140;
        cArray[46] = 141;
        cArray[47] = 142;
        cArray[48] = 143;
        cArray[49] = 144;
        cArray[50] = 145;
        cArray[51] = 146;
        cArray[52] = 147;
        cArray[53] = 148;
        cArray[54] = 149;
        cArray[55] = 150;
        cArray[56] = 151;
        cArray[57] = 152;
        cArray[58] = 153;
        cArray[59] = 154;
        cArray[60] = 155;
        cArray[61] = 156;
        cArray[62] = 157;
        cArray[63] = 158;
        cArray[64] = 159;
        ISO_CONTROLS = CharSet.valueOf(cArray);
    }

    private CharSet(long[] mapping) {
        this._mapping = mapping;
    }

    public static CharSet valueOf(char ... chars) {
        char maxChar = '\u0000';
        int i = chars.length;
        while (--i >= 0) {
            if (chars[i] <= maxChar) continue;
            maxChar = chars[i];
        }
        CharSet charSet = new CharSet(new long[(maxChar >> 6) + 1]);
        int i2 = chars.length;
        while (--i2 >= 0) {
            char c = chars[i2];
            int n = c >> 6;
            charSet._mapping[n] = charSet._mapping[n] | 1L << (c & 0x3F);
        }
        return charSet;
    }

    public static CharSet rangeOf(char first, char last) {
        if (first > last) {
            throw new IllegalArgumentException("first should be less or equal to last");
        }
        CharSet charSet = new CharSet(new long[(last >> 6) + 1]);
        char c = first;
        while (c <= last) {
            int n = c >> 6;
            charSet._mapping[n] = charSet._mapping[n] | 1L << (c & 0x3F);
            c = (char)(c + '\u0001');
        }
        return charSet;
    }

    public boolean contains(char c) {
        int i = c >> 6;
        return i < this._mapping.length ? (this._mapping[i] & 1L << (c & 0x3F)) != 0L : false;
    }

    public int indexIn(CharSequence csq) {
        return this.indexIn(csq, 0);
    }

    public int indexIn(CharSequence csq, int fromIndex) {
        int i = fromIndex;
        int n = csq.length();
        while (i < n) {
            if (this.contains(csq.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexIn(char[] chars) {
        return this.indexIn(chars, 0);
    }

    public int indexIn(char[] chars, int fromIndex) {
        int i = fromIndex;
        int n = chars.length;
        while (i < n) {
            if (this.contains(chars[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence csq) {
        return this.lastIndexIn(csq, csq.length() - 1);
    }

    public int lastIndexIn(CharSequence csq, int fromIndex) {
        int i = fromIndex;
        while (i >= 0) {
            if (this.contains(csq.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int lastIndexIn(char[] chars) {
        return this.lastIndexIn(chars, chars.length - 1);
    }

    public int lastIndexIn(char[] chars, int fromIndex) {
        int i = fromIndex;
        while (i >= 0) {
            if (this.contains(chars[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public CharSet plus(CharSet that) {
        if (that._mapping.length > this._mapping.length) {
            return that.plus(this);
        }
        CharSet result = this.copy();
        int i = that._mapping.length;
        while (--i >= 0) {
            int n = i;
            result._mapping[n] = result._mapping[n] | that._mapping[i];
        }
        return result;
    }

    public CharSet minus(CharSet that) {
        CharSet result = this.copy();
        int i = MathLib.min(this._mapping.length, that._mapping.length);
        while (--i >= 0) {
            int n = i;
            result._mapping[n] = result._mapping[n] & (that._mapping[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    public String toString() {
        TextBuilder tb = TextBuilder.newInstance();
        tb.append('{');
        int length = this._mapping.length << 6;
        int i = 0;
        while (i < length) {
            if (this.contains((char)i)) {
                if (tb.length() > 1) {
                    tb.append(',');
                    tb.append(' ');
                }
                tb.append('\'');
                tb.append((char)i);
                tb.append('\'');
            }
            ++i;
        }
        tb.append('}');
        return tb.toString();
    }

    private CharSet copy() {
        CharSet charSet = new CharSet(new long[this._mapping.length]);
        int i = this._mapping.length;
        while (--i >= 0) {
            charSet._mapping[i] = this._mapping[i];
        }
        return charSet;
    }
}

