/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.Javolution;
import javolution.lang.MathLib;
import javolution.text.Cursor;
import javolution.text.TextBuilder;

public final class TypeFormat {
    private static final CharSequence TRUE = Javolution.j2meToCharSeq("true");
    private static final CharSequence FALSE = Javolution.j2meToCharSeq("false");

    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence csq) {
        return TypeFormat.parseBoolean(csq, null);
    }

    public static boolean parseBoolean(String str) {
        return TypeFormat.parseBoolean(Javolution.j2meToCharSeq(str));
    }

    public static boolean parseBoolean(CharSequence csq, Cursor cursor) {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        if (end >= start + 5 && (csq.charAt(start) == 'f' || csq.charAt(start) == 'F')) {
            if (!(csq.charAt(++start) != 'a' && csq.charAt(start) != 'A' || csq.charAt(++start) != 'l' && csq.charAt(start) != 'L' || csq.charAt(++start) != 's' && csq.charAt(start) != 'S' || csq.charAt(++start) != 'e' && csq.charAt(start) != 'E')) {
                TypeFormat.increment(cursor, 5, end, csq);
                return false;
            }
        } else if (!(end < start + 4 || csq.charAt(start) != 't' && csq.charAt(start) != 'T' || csq.charAt(++start) != 'r' && csq.charAt(start) != 'R' || csq.charAt(++start) != 'u' && csq.charAt(start) != 'U' || csq.charAt(++start) != 'e' && csq.charAt(start) != 'E')) {
            TypeFormat.increment(cursor, 4, end, csq);
            return true;
        }
        throw new IllegalArgumentException("Invalid boolean representation");
    }

    public static byte parseByte(CharSequence csq) {
        return TypeFormat.parseByte(csq, 10);
    }

    public static byte parseByte(CharSequence csq, int radix) {
        int i = TypeFormat.parseInt(csq, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)i;
    }

    public static byte parseByte(CharSequence csq, int radix, Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)i;
    }

    public static short parseShort(CharSequence csq) {
        return TypeFormat.parseShort(csq, 10);
    }

    public static short parseShort(CharSequence csq, int radix) {
        int i = TypeFormat.parseInt(csq, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)i;
    }

    public static short parseShort(CharSequence csq, int radix, Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)i;
    }

    public static int parseInt(CharSequence csq) {
        return TypeFormat.parseInt(csq, 10);
    }

    public static int parseInt(String str) {
        return TypeFormat.parseInt(Javolution.j2meToCharSeq(str));
    }

    public static int parseInt(CharSequence csq, int radix) {
        return TypeFormat.parseInt(csq, radix, null);
    }

    public static int parseInt(String str, int radix) {
        return TypeFormat.parseInt(Javolution.j2meToCharSeq(str), radix);
    }

    public static int parseInt(CharSequence csq, int radix, Cursor cursor) {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        boolean isNegative = false;
        int result = 0;
        int i = start;
        while (i < end) {
            int digit;
            char c = csq.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit >= 0 && digit < radix) {
                int newResult = result * radix - digit;
                if (newResult > result) {
                    throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
                }
                result = newResult;
            } else if (c == '-' && i == start) {
                isNegative = true;
            } else if (c != '+' || i != start) break;
            ++i;
        }
        if (result == 0 && (end == 0 || csq.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
        }
        if (result == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
        }
        TypeFormat.increment(cursor, i - start, end, csq);
        return isNegative ? result : -result;
    }

    public static long parseLong(CharSequence csq) {
        return TypeFormat.parseLong(csq, 10);
    }

    public static long parseLong(String str) {
        return TypeFormat.parseLong(Javolution.j2meToCharSeq(str), 10);
    }

    public static long parseLong(CharSequence csq, int radix) {
        return TypeFormat.parseLong(csq, radix, null);
    }

    public static long parseLong(String str, int radix) {
        return TypeFormat.parseLong(Javolution.j2meToCharSeq(str), radix);
    }

    public static long parseLong(CharSequence csq, int radix, Cursor cursor) {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        boolean isNegative = false;
        long result = 0L;
        int i = start;
        while (i < end) {
            int digit;
            char c = csq.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit >= 0 && digit < radix) {
                long newResult = result * (long)radix - (long)digit;
                if (newResult > result) {
                    throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
                }
                result = newResult;
            } else if (c == '-' && i == start) {
                isNegative = true;
            } else if (c != '+' || i != start) break;
            ++i;
        }
        if (result == 0L && (end == 0 || csq.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
        }
        if (result == Long.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
        }
        TypeFormat.increment(cursor, i - start, end, csq);
        return isNegative ? result : -result;
    }

    public static float parseFloat(CharSequence csq) {
        return (float)TypeFormat.parseDouble(csq);
    }

    public static float parseFloat(String str) {
        return TypeFormat.parseFloat(Javolution.j2meToCharSeq(str));
    }

    public static float parseFloat(CharSequence csq, Cursor cursor) {
        return (float)TypeFormat.parseDouble(csq, cursor);
    }

    public static double parseDouble(CharSequence csq) throws NumberFormatException {
        return TypeFormat.parseDouble(csq, null);
    }

    public static double parseDouble(String str) {
        return TypeFormat.parseDouble(Javolution.j2meToCharSeq(str));
    }

    public static double parseDouble(CharSequence csq, Cursor cursor) throws NumberFormatException {
        boolean isNegative;
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        int i = start;
        char c = csq.charAt(i);
        if (c == 'N' && TypeFormat.match("NaN", csq, i, end)) {
            TypeFormat.increment(cursor, 3, end, csq);
            return Double.NaN;
        }
        boolean bl = isNegative = c == '-';
        if ((isNegative || c == '+') && ++i < end) {
            c = csq.charAt(i);
        }
        if (c == 'I' && TypeFormat.match("Infinity", csq, i, end)) {
            TypeFormat.increment(cursor, i + 8 - start, end, csq);
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if ((c < '0' || c > '9') && c != '.') {
            throw new NumberFormatException("Digit or '.' required");
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = c - 48) >= 0 && digit < 10) {
                long tmp = decimal * 10L + (long)digit;
                if (tmp < decimal) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                decimal = tmp;
            } else {
                if (c != '.' || decimalPoint >= 0) break;
                decimalPoint = i;
            }
            if (++i >= end) break;
            c = csq.charAt(i);
        }
        if (isNegative) {
            decimal = -decimal;
        }
        int fractionLength = decimalPoint >= 0 ? i - decimalPoint - 1 : 0;
        int exp = 0;
        if (i < end && (c == 'E' || c == 'e')) {
            int digit;
            boolean isNegativeExp;
            boolean bl2 = isNegativeExp = (c = csq.charAt(++i)) == '-';
            if ((isNegativeExp || c == '+') && ++i < end) {
                c = csq.charAt(i);
            }
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Invalid exponent");
            }
            while ((digit = c - 48) >= 0 && digit < 10) {
                int tmp = exp * 10 + digit;
                if (tmp < exp) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                exp = tmp;
                if (++i >= end) break;
                c = csq.charAt(i);
            }
            if (isNegativeExp) {
                exp = -exp;
            }
        }
        TypeFormat.increment(cursor, i - start, end, csq);
        return MathLib.toDoublePow10(decimal, exp - fractionLength);
    }

    static boolean match(String str, CharSequence csq, int start, int length) {
        int i = 0;
        while (i < str.length()) {
            if (start + i >= length || csq.charAt(start + i) != str.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean match(String str, String csq, int start, int length) {
        int i = 0;
        while (i < str.length()) {
            if (start + i >= length || csq.charAt(start + i) != str.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Appendable format(boolean b, Appendable a) throws IOException {
        return b ? a.append(TRUE) : a.append(FALSE);
    }

    public static Appendable format(int i, Appendable a) throws IOException {
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(i);
        }
        TextBuilder tb = TextBuilder.newInstance();
        try {
            tb.append(i);
            Appendable appendable = a.append(tb);
            return appendable;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public static Appendable format(int i, int radix, Appendable a) throws IOException {
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(i, radix);
        }
        TextBuilder tb = TextBuilder.newInstance();
        try {
            tb.append(i, radix);
            Appendable appendable = a.append(tb);
            return appendable;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public static Appendable format(long l, Appendable a) throws IOException {
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(l);
        }
        TextBuilder tb = TextBuilder.newInstance();
        try {
            tb.append(l);
            Appendable appendable = a.append(tb);
            return appendable;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public static Appendable format(long l, int radix, Appendable a) throws IOException {
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(l, radix);
        }
        TextBuilder tb = TextBuilder.newInstance();
        try {
            tb.append(l, radix);
            Appendable appendable = a.append(tb);
            return appendable;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    public static Appendable format(float f, Appendable a) throws IOException {
        return TypeFormat.format(f, 10, (double)MathLib.abs(f) >= 1.0E7 || (double)MathLib.abs(f) < 0.001, false, a);
    }

    public static Appendable format(double d, Appendable a) throws IOException {
        return TypeFormat.format(d, -1, MathLib.abs(d) >= 1.0E7 || MathLib.abs(d) < 0.001, false, a);
    }

    public static Appendable format(double d, int digits, boolean scientific, boolean showZero, Appendable a) throws IOException {
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(d, digits, scientific, showZero);
        }
        TextBuilder tb = TextBuilder.newInstance();
        try {
            tb.append(d, digits, scientific, showZero);
            Appendable appendable = a.append(tb);
            return appendable;
        }
        finally {
            TextBuilder.recycle(tb);
        }
    }

    private static void increment(Cursor cursor, int inc, int endIndex, CharSequence csq) throws NumberFormatException {
        if (cursor != null) {
            cursor.increment(inc);
        } else if (inc != endIndex) {
            throw new NumberFormatException("Extraneous character: '" + csq.charAt(inc) + "'");
        }
    }
}

