/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.LRUCache;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionTrackerValve;
import de.javakaffee.web.msm.Statistics;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClient;
import org.apache.catalina.connector.Request;

public class LockingStrategyUriPattern
extends LockingStrategy {
    private final Pattern _uriPattern;

    public LockingStrategyUriPattern(@Nonnull MemcachedSessionService manager, @Nonnull Pattern uriPattern, @Nonnull MemcachedClient memcached, @Nonnull LRUCache<String, Boolean> missingSessionsCache, boolean storeSecondaryBackup, @Nonnull Statistics stats) {
        super(manager, memcached, missingSessionsCache, storeSecondaryBackup, stats);
        if (uriPattern == null) {
            throw new IllegalArgumentException("The uriPattern is null");
        }
        this._uriPattern = uriPattern;
    }

    @Override
    protected MemcachedSessionService.LockStatus onBeforeLoadFromMemcached(String sessionId) throws InterruptedException, ExecutionException {
        Request request = (Request)this._requestsThreadLocal.get();
        if (request == null) {
            throw new RuntimeException("There's no request set, this indicates that this findSessionwas triggered by the container which should already be handled in findSession.");
        }
        if (this._uriPattern.matcher(SessionTrackerValve.getURIWithQueryString(request)).matches()) {
            this._log.info((Object)("Lock request for request " + SessionTrackerValve.getURIWithQueryString(request)));
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Lock request for request " + SessionTrackerValve.getURIWithQueryString(request)));
            }
            return this.lock(sessionId);
        }
        this._log.info((Object)("Not lock request for request " + SessionTrackerValve.getURIWithQueryString(request)));
        this._stats.nonStickySessionsReadOnlyRequest();
        return MemcachedSessionService.LockStatus.LOCK_NOT_REQUIRED;
    }
}

