/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseMemcachedConnection;
import com.couchbase.client.vbucket.ConfigurationException;
import com.couchbase.client.vbucket.ConfigurationProvider;
import com.couchbase.client.vbucket.ConfigurationProviderHTTP;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;

public class CouchbaseConnectionFactory
extends BinaryConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Retry;
    public static final HashAlgorithm DEFAULT_HASH = DefaultHashAlgorithm.KETAMA_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_MIN_RECONNECT_INTERVAL = 1100L;
    private volatile ConfigurationProvider configurationProvider;
    private final String bucket;
    private final String pass;
    private final List<URI> storedBaseList;
    private static final Logger LOGGER = Logger.getLogger(CouchbaseConnectionFactory.class.getName());
    private volatile boolean needsReconnect;
    private AtomicBoolean doingResubscribe = new AtomicBoolean(false);
    private volatile long thresholdLastCheck = System.nanoTime();
    private volatile int configThresholdCount = 0;
    private final int maxConfigCheck = 10;
    private volatile long configProviderLastUpdateTimestamp;
    private long minReconnectInterval = 1100L;
    private ExecutorService resubExec = Executors.newSingleThreadExecutor();

    public CouchbaseConnectionFactory(List<URI> baseList, String bucketName, String password) throws IOException {
        this.storedBaseList = new ArrayList<URI>();
        for (URI bu : baseList) {
            if (!bu.isAbsolute()) {
                throw new IllegalArgumentException("The base URI must be absolute");
            }
            this.storedBaseList.add(bu);
        }
        this.bucket = bucketName;
        this.pass = password;
        this.configurationProvider = new ConfigurationProviderHTTP(baseList, bucketName, password);
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        Config config = this.getVBucketConfig();
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new CouchbaseMemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new CouchbaseConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        throw new IOException("No ConnectionFactory for bucket type " + (Object)((Object)config.getConfigType()));
    }

    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        Config config = this.getVBucketConfig();
        if (config == null) {
            throw new IllegalStateException("Couldn't get config");
        }
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new KetamaNodeLocator(nodes, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new VBucketNodeLocator(nodes, this.getVBucketConfig());
        }
        throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)config.getConfigType()));
    }

    public boolean shouldOptimize() {
        return false;
    }

    public AuthDescriptor getAuthDescriptor() {
        if (!this.configurationProvider.getAnonymousAuthBucket().equals(this.bucket) && this.bucket != null) {
            return new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(this.bucket, this.pass));
        }
        return null;
    }

    public String getBucketName() {
        return this.bucket;
    }

    public Config getVBucketConfig() {
        try {
            if (this.configurationProvider.getBucketConfiguration(this.bucket).isNotUpdating()) {
                LOGGER.warning("Noticed bucket configuration to be disconnected, will attempt to reconnect");
                this.setConfigurationProvider(new ConfigurationProviderHTTP(this.storedBaseList, this.bucket, this.pass));
            }
            return this.configurationProvider.getBucketConfiguration(this.bucket).getConfig();
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected void requestConfigReconnect(String bucketName, Reconfigurable rec) {
        this.configurationProvider.markForResubscribe(bucketName, rec);
        this.needsReconnect = true;
    }

    void setConfigurationProvider(ConfigurationProvider configProvider) {
        this.configProviderLastUpdateTimestamp = System.currentTimeMillis();
        this.configurationProvider = configProvider;
    }

    void setMinReconnectInterval(long reconnIntervalMsecs) {
        this.minReconnectInterval = reconnIntervalMsecs;
    }

    void checkConfigUpdate() {
        if (this.needsReconnect || this.pastReconnThreshold()) {
            long now = System.currentTimeMillis();
            long intervalWaited = now - this.configProviderLastUpdateTimestamp;
            if (intervalWaited < this.getMinReconnectInterval()) {
                LOGGER.log(Level.FINE, "Ignoring config update check. Only {0}ms out of a threshold of {1}ms since last update.", new Object[]{intervalWaited, this.getMinReconnectInterval()});
                return;
            }
            if (this.doingResubscribe.compareAndSet(false, true)) {
                this.resubConfigUpdate();
            } else {
                LOGGER.log(Level.CONFIG, "Duplicate resubscribe for config updates suppressed.");
            }
        } else {
            LOGGER.log(Level.FINE, "No reconnect required, though check requested. Current config check is {0} out of a threshold of {1}.", new Object[]{this.configThresholdCount, 10});
        }
    }

    private synchronized void resubConfigUpdate() {
        LOGGER.log(Level.INFO, "Attempting to resubscribe for cluster config updates.");
        this.resubExec.execute(new Resubscriber());
    }

    private boolean pastReconnThreshold() {
        long currentTime = System.nanoTime();
        if (currentTime - this.thresholdLastCheck > 100000000L) {
            this.configThresholdCount = 0;
        }
        ++this.configThresholdCount;
        this.thresholdLastCheck = currentTime;
        return this.configThresholdCount >= 10;
    }

    public long getMinReconnectInterval() {
        return this.minReconnectInterval;
    }

    private class Resubscriber
    implements Runnable {
        private Resubscriber() {
        }

        @Override
        public void run() {
            String threadNameBase = "couchbase cluster resubscriber - ";
            Thread.currentThread().setName(threadNameBase + "running");
            LOGGER.log(Level.CONFIG, "Starting resubscription for bucket {0}", CouchbaseConnectionFactory.this.bucket);
            LOGGER.log(Level.CONFIG, "Resubscribing for {0} using base list {1}", new Object[]{CouchbaseConnectionFactory.this.bucket, CouchbaseConnectionFactory.this.storedBaseList});
            ConfigurationProvider oldConfigProvider = CouchbaseConnectionFactory.this.configurationProvider;
            CouchbaseConnectionFactory.this.setConfigurationProvider(new ConfigurationProviderHTTP(CouchbaseConnectionFactory.this.storedBaseList, CouchbaseConnectionFactory.this.bucket, CouchbaseConnectionFactory.this.pass));
            CouchbaseConnectionFactory.this.configurationProvider.finishResubscribe();
            if (null != oldConfigProvider) {
                oldConfigProvider.shutdown();
            }
            if (!CouchbaseConnectionFactory.this.doingResubscribe.compareAndSet(true, false)) assert (false) : "Could not reset from doing a resubscribe.";
            Thread.currentThread().setName(threadNameBase + "complete");
        }
    }
}

