/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import java.util.Date;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.BaseSerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.transcoders.TranscoderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhalinTranscoder
extends BaseSerializingTranscoder
implements Transcoder<Object> {
    static final int SPECIAL_BYTE = 1;
    static final int SPECIAL_BOOLEAN = 8192;
    static final int SPECIAL_INT = 4;
    static final int SPECIAL_LONG = 16384;
    static final int SPECIAL_CHARACTER = 16;
    static final int SPECIAL_STRING = 32;
    static final int SPECIAL_STRINGBUFFER = 64;
    static final int SPECIAL_FLOAT = 128;
    static final int SPECIAL_SHORT = 256;
    static final int SPECIAL_DOUBLE = 512;
    static final int SPECIAL_DATE = 1024;
    static final int SPECIAL_STRINGBUILDER = 2048;
    static final int SPECIAL_BYTEARRAY = 4096;
    static final int COMPRESSED = 2;
    static final int SERIALIZED = 8;
    private final TranscoderUtils tu = new TranscoderUtils(false);

    public WhalinTranscoder() {
        super(0x1400000);
    }

    @Override
    public Object decode(CachedData d) {
        byte[] data = d.getData();
        Object rv = null;
        if ((d.getFlags() & 2) != 0) {
            data = this.decompress(d.getData());
        }
        if ((d.getFlags() & 8) != 0) {
            rv = this.deserialize(data);
        } else {
            int f = d.getFlags() & 0xFFFFFFFD;
            switch (f) {
                case 8192: {
                    rv = this.decodeBoolean(data);
                    break;
                }
                case 4: {
                    rv = new Integer(this.tu.decodeInt(data));
                    break;
                }
                case 256: {
                    rv = new Short((short)this.tu.decodeInt(data));
                    break;
                }
                case 16384: {
                    rv = new Long(this.tu.decodeLong(data));
                    break;
                }
                case 1024: {
                    rv = new Date(this.tu.decodeLong(data));
                    break;
                }
                case 1: {
                    rv = new Byte(this.tu.decodeByte(data));
                    break;
                }
                case 128: {
                    rv = new Float(Float.intBitsToFloat(this.tu.decodeInt(data)));
                    break;
                }
                case 512: {
                    rv = new Double(Double.longBitsToDouble(this.tu.decodeLong(data)));
                    break;
                }
                case 4096: {
                    rv = data;
                    break;
                }
                case 32: {
                    rv = this.decodeString(data);
                    break;
                }
                case 64: {
                    rv = new StringBuffer(this.decodeString(data));
                    break;
                }
                case 2048: {
                    rv = new StringBuilder(this.decodeString(data));
                    break;
                }
                case 16: {
                    rv = this.decodeCharacter(data);
                    break;
                }
                default: {
                    this.getLogger().warn("Cannot handle data with flags %x", f);
                }
            }
        }
        return rv;
    }

    @Override
    public CachedData encode(Object o) {
        byte[] b = null;
        int flags = 0;
        if (o instanceof String) {
            b = this.encodeString((String)o);
            flags |= 0x20;
        } else if (o instanceof StringBuffer) {
            flags |= 0x40;
            b = this.encodeString(String.valueOf(o));
        } else if (o instanceof StringBuilder) {
            flags |= 0x800;
            b = this.encodeString(String.valueOf(o));
        } else if (o instanceof Long) {
            b = this.tu.encodeLong((Long)o);
            flags |= 0x4000;
        } else if (o instanceof Integer) {
            b = this.tu.encodeInt((Integer)o);
            flags |= 4;
        } else if (o instanceof Short) {
            b = this.tu.encodeInt(((Short)o).shortValue());
            flags |= 0x100;
        } else if (o instanceof Boolean) {
            b = this.encodeBoolean((Boolean)o);
            flags |= 0x2000;
        } else if (o instanceof Date) {
            b = this.tu.encodeLong(((Date)o).getTime());
            flags |= 0x400;
        } else if (o instanceof Byte) {
            b = this.tu.encodeByte((Byte)o);
            flags |= 1;
        } else if (o instanceof Float) {
            b = this.tu.encodeInt(Float.floatToIntBits(((Float)o).floatValue()));
            flags |= 0x80;
        } else if (o instanceof Double) {
            b = this.tu.encodeLong(Double.doubleToLongBits((Double)o));
            flags |= 0x200;
        } else if (o instanceof byte[]) {
            b = (byte[])o;
            flags |= 0x1000;
        } else if (o instanceof Character) {
            b = this.tu.encodeInt(((Character)o).charValue());
            flags |= 0x10;
        } else {
            b = this.serialize(o);
            flags |= 8;
        }
        assert (b != null);
        if (b.length > this.compressionThreshold) {
            byte[] compressed = this.compress(b);
            if (compressed.length < b.length) {
                this.getLogger().debug("Compressed %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
                b = compressed;
                flags |= 2;
            } else {
                this.getLogger().info("Compression increased the size of %s from %d to %d", o.getClass().getName(), b.length, compressed.length);
            }
        }
        return new CachedData(flags, b, this.getMaxSize());
    }

    protected Character decodeCharacter(byte[] b) {
        return Character.valueOf((char)this.tu.decodeInt(b));
    }

    public byte[] encodeBoolean(boolean b) {
        byte[] rv = new byte[]{(byte)(b ? 1 : 0)};
        return rv;
    }

    public boolean decodeBoolean(byte[] in) {
        assert (in.length == 1) : "Wrong length for a boolean";
        return in[0] == 1;
    }
}

