/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.SessionTrackerValve;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.TranscoderService;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BackupSessionTask
implements Callable<BackupResult> {
    private static final Log _log = LogFactory.getLog(BackupSessionTask.class);
    private final MemcachedBackupSession _session;
    private final boolean _force;
    private final TranscoderService _transcoderService;
    private final boolean _sessionBackupAsync;
    private final int _sessionBackupTimeout;
    private final MemcachedClient _memcached;
    private final MemcachedNodesManager _memcachedNodesManager;
    private final Statistics _statistics;

    public BackupSessionTask(MemcachedBackupSession session, boolean sessionIdChanged, TranscoderService transcoderService, boolean sessionBackupAsync, int sessionBackupTimeout, MemcachedClient memcached, MemcachedNodesManager memcachedNodesManager, Statistics statistics) {
        this._session = session;
        this._force = sessionIdChanged;
        this._transcoderService = transcoderService;
        this._sessionBackupAsync = sessionBackupAsync;
        this._sessionBackupTimeout = sessionBackupTimeout;
        this._memcached = memcached;
        this._memcachedNodesManager = memcachedNodesManager;
        this._statistics = statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackupResult call() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Starting for session id " + this._session.getId()));
        }
        this._session.setBackupRunning(true);
        try {
            BackupResult result;
            long startBackup = System.currentTimeMillis();
            Map<String, Object> attributes = this._session.getAttributesFiltered();
            byte[] attributesData = this.serializeAttributes(this._session, attributes);
            int hashCode = Arrays.hashCode(attributesData);
            if (this._session.getDataHashCode() != hashCode || this._force || this._session.authenticationChanged()) {
                this._session.setLastBackupTime(System.currentTimeMillis());
                byte[] data = this._transcoderService.serialize(this._session, attributesData);
                result = this.doBackupSession(this._session, data, attributesData);
                if (result.isSuccess()) {
                    this._session.setDataHashCode(hashCode);
                }
            } else {
                result = new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.SKIPPED);
            }
            switch (result.getStatus()) {
                case FAILURE: {
                    this._statistics.requestWithBackupFailure();
                    this._session.backupFailed();
                    break;
                }
                case SKIPPED: {
                    this._statistics.requestWithoutSessionModification();
                    this._session.storeThisAccessedTimeFromLastBackupCheck();
                    break;
                }
                case SUCCESS: {
                    this._statistics.registerSince(Statistics.StatsType.BACKUP, startBackup);
                    this._session.storeThisAccessedTimeFromLastBackupCheck();
                    this._session.backupFinished();
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished for session id " + this._session.getId() + ", returning status " + (Object)((Object)result.getStatus())));
            }
            BackupResult backupResult = result;
            return backupResult;
        }
        finally {
            this._session.setBackupRunning(false);
            this.releaseLock();
        }
    }

    private void releaseLock() {
        if (this._session.isLocked()) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Releasing lock for session " + this._session.getIdInternal()));
                }
                long start = System.currentTimeMillis();
                this._memcached.delete(this._memcachedNodesManager.getSessionIdFormat().createLockName(this._session.getIdInternal()));
                this._statistics.registerSince(Statistics.StatsType.RELEASE_LOCK, start);
                this._session.releaseLock();
            }
            catch (Exception e) {
                _log.warn((Object)("Caught exception when trying to release lock for session " + this._session.getIdInternal()));
            }
        }
    }

    private byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        long start = System.currentTimeMillis();
        byte[] attributesData = this._transcoderService.serializeAttributes(session, attributes);
        this._statistics.registerSince(Statistics.StatsType.ATTRIBUTES_SERIALIZATION, start);
        return attributesData;
    }

    BackupResult doBackupSession(MemcachedBackupSession session, byte[] data, byte[] attributesData) throws InterruptedException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Trying to store session in memcached: " + session.getId()));
        }
        try {
            this.storeSessionInMemcached(session, data);
            return new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.SUCCESS, data, attributesData);
        }
        catch (ExecutionException e) {
            this.handleException(session, e);
            return new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.FAILURE, data, null);
        }
        catch (TimeoutException e) {
            this.handleException(session, e);
            return new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.FAILURE, data, null);
        }
    }

    private void handleException(MemcachedBackupSession session, Exception e) {
        String msg = "Could not store session " + session.getId() + " in memcached.";
        if (this._force) {
            msg = msg + "\nNote that this session was relocated to this node because the original node was not available.";
        }
        _log.warn((Object)msg, (Throwable)e);
        this._memcachedNodesManager.setNodeAvailableForSessionId(session.getId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionInMemcached(MemcachedBackupSession session, byte[] data) throws InterruptedException, ExecutionException, TimeoutException {
        int expirationTime = session.getMemcachedExpirationTimeToSet();
        long start = System.currentTimeMillis();
        try {
            OperationFuture future = this._memcached.set(session.getId(), expirationTime, (Object)data);
            if (!this._sessionBackupAsync) {
                future.get(this._sessionBackupTimeout, TimeUnit.MILLISECONDS);
                session.setLastMemcachedExpirationTime(expirationTime);
                session.setLastBackupTime(System.currentTimeMillis());
            } else {
                session.setLastMemcachedExpirationTime(expirationTime);
                session.setLastBackupTime(System.currentTimeMillis());
            }
        }
        finally {
            this._statistics.registerSince(Statistics.StatsType.MEMCACHED_UPDATE, start);
        }
    }

    static final class BackupResult {
        public static final BackupResult SKIPPED = new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.SKIPPED);
        public static final BackupResult FAILURE = new BackupResult(SessionTrackerValve.SessionBackupService.BackupResultStatus.FAILURE);
        private final SessionTrackerValve.SessionBackupService.BackupResultStatus _status;
        private final byte[] _data;
        private final byte[] _attributesData;

        public BackupResult(@Nonnull SessionTrackerValve.SessionBackupService.BackupResultStatus status) {
            this(status, null, null);
        }

        public BackupResult(@Nonnull SessionTrackerValve.SessionBackupService.BackupResultStatus status, @Nullable byte[] data, @Nullable byte[] attributesData) {
            this._status = status;
            this._data = data;
            this._attributesData = attributesData;
        }

        @Nonnull
        SessionTrackerValve.SessionBackupService.BackupResultStatus getStatus() {
            return this._status;
        }

        @CheckForNull
        byte[] getData() {
            return this._data;
        }

        @CheckForNull
        byte[] getAttributesData() {
            return this._attributesData;
        }

        public boolean isSuccess() {
            return this._status == SessionTrackerValve.SessionBackupService.BackupResultStatus.SUCCESS;
        }

        public String toString() {
            return "BackupResult [_status=" + (Object)((Object)this._status) + ", _data=" + (this._data != null ? "byte[" + this._data.length + "]" : "null") + ", _attributesData=" + (this._attributesData != null ? "byte[" + this._attributesData.length + "]" : "null") + "]";
        }
    }
}

