/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GregorianCalendarSerializer
extends SimpleSerializer<GregorianCalendar> {
    private final Field _zoneField;

    public GregorianCalendarSerializer() {
        try {
            this._zoneField = Calendar.class.getDeclaredField("zone");
            this._zoneField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GregorianCalendar read(ByteBuffer buffer) {
        Calendar result = GregorianCalendar.getInstance();
        result.setTimeInMillis(LongSerializer.get((ByteBuffer)buffer, (boolean)true));
        result.setLenient(this.fromInt(IntSerializer.get((ByteBuffer)buffer, (boolean)true)));
        result.setFirstDayOfWeek(IntSerializer.get((ByteBuffer)buffer, (boolean)true));
        result.setMinimalDaysInFirstWeek(IntSerializer.get((ByteBuffer)buffer, (boolean)true));
        String timeZoneId = StringSerializer.get((ByteBuffer)buffer);
        if (!this.getTimeZone(result).getID().equals(timeZoneId)) {
            result.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        }
        return (GregorianCalendar)result;
    }

    public void write(ByteBuffer buffer, GregorianCalendar calendar) {
        LongSerializer.put((ByteBuffer)buffer, (long)calendar.getTimeInMillis(), (boolean)true);
        IntSerializer.put((ByteBuffer)buffer, (int)this.toInt(calendar.isLenient()), (boolean)true);
        IntSerializer.put((ByteBuffer)buffer, (int)calendar.getFirstDayOfWeek(), (boolean)true);
        IntSerializer.put((ByteBuffer)buffer, (int)calendar.getMinimalDaysInFirstWeek(), (boolean)true);
        StringSerializer.put((ByteBuffer)buffer, (String)this.getTimeZone(calendar).getID());
    }

    private int toInt(boolean b) {
        return b ? 1 : 0;
    }

    private boolean fromInt(int value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new IllegalArgumentException("The value " + value + " cannot be translated into a boolean value, only 0 or 1 are considered valid.");
    }

    private TimeZone getTimeZone(Calendar obj) {
        try {
            return (TimeZone)this._zoneField.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

