/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

public class SubListSerializer
extends Serializer {
    private static final Class<?> SUBLIST_CLASS = SubListSerializer.getClass("java.util.SubList");
    private final Kryo _kryo;
    private Field _listField;
    private Field _offsetField;
    private Field _sizeField;

    public SubListSerializer(Kryo kryo) {
        this._kryo = kryo;
        try {
            Class<?> clazz = Class.forName("java.util.SubList");
            this._listField = clazz.getDeclaredField("l");
            this._offsetField = clazz.getDeclaredField("offset");
            this._sizeField = clazz.getDeclaredField("size");
            this._listField.setAccessible(true);
            this._offsetField.setAccessible(true);
            this._sizeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canSerialize(Class<?> type) {
        return SUBLIST_CLASS.isAssignableFrom(type);
    }

    public <T> T readObjectData(ByteBuffer buffer, Class<T> clazz) {
        List list = (List)this._kryo.readClassAndObject(buffer);
        int fromIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
        int toIndex = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
        return (T)list.subList(fromIndex, toIndex);
    }

    public void writeObjectData(ByteBuffer buffer, Object obj) {
        try {
            this._kryo.writeClassAndObject(buffer, this._listField.get(obj));
            int fromIndex = this._offsetField.getInt(obj);
            IntSerializer.put((ByteBuffer)buffer, (int)fromIndex, (boolean)true);
            int toIndex = fromIndex + this._sizeField.getInt(obj);
            IntSerializer.put((ByteBuffer)buffer, (int)toIndex, (boolean)true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

