/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.serialize.FieldSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.util.IntHashMap;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFieldSerializer
extends FieldSerializer {
    public ReferenceFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        Integer reference;
        Context context = Kryo.getContext();
        References references = (References)context.getTemp("references");
        if (references == null) {
            references = (References)context.get("references");
            if (references == null) {
                references = new References();
                context.put("references", references);
            } else {
                references.reset();
            }
            context.putTemp("references", references);
        }
        if ((reference = references.objectToReference.get(object)) != null) {
            IntSerializer.put(buffer, reference, true);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Wrote object reference " + reference + ": " + object));
            }
            return;
        }
        buffer.put((byte)0);
        ++references.referenceCount;
        references.objectToReference.put(object, references.referenceCount);
        super.writeObjectData(buffer, object);
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        int reference;
        Context context = Kryo.getContext();
        References references = (References)context.getTemp("references");
        if (references == null) {
            references = (References)context.get("references");
            if (references == null) {
                references = new References();
                context.put("references", references);
            } else {
                references.reset();
            }
            context.putTemp("references", references);
        }
        if ((reference = IntSerializer.get(buffer, true)) != 0) {
            Object object = references.referenceToObject.get(reference);
            if (object == null) {
                throw new SerializationException("Invalid object reference: " + reference);
            }
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read object reference " + reference + ": " + object));
            }
            return object;
        }
        T object = this.newInstance(this.kryo, type);
        ++references.referenceCount;
        references.referenceToObject.put(references.referenceCount, object);
        return super.readObjectData(object, buffer, type);
    }

    static class References {
        public IdentityHashMap<Object, Integer> objectToReference = new IdentityHashMap();
        public IntHashMap referenceToObject = new IntHashMap();
        public int referenceCount = 1;

        References() {
        }

        public void reset() {
            this.objectToReference.clear();
            this.referenceToObject.clear();
            this.referenceCount = 1;
        }
    }
}

