/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DataInfo {
    public static final byte FLAG_CLOSE = 1;
    public static final byte FLAG_COMPRESS = 2;
    private final AtomicInteger consumed = new AtomicInteger();
    private boolean close;
    private boolean compress;

    public DataInfo(boolean close) {
        this.setClose(close);
    }

    public DataInfo(boolean close, boolean compress) {
        this.setClose(close);
        this.setCompress(compress);
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public byte getFlags() {
        byte flags = this.isClose() ? (byte)1 : 0;
        flags = (byte)(flags | (this.isCompress() ? 2 : 0));
        return flags;
    }

    public abstract int length();

    public abstract int available();

    public abstract int readInto(ByteBuffer var1);

    public int consumeInto(ByteBuffer output) {
        int read = this.readInto(output);
        this.consume(read);
        return read;
    }

    public void consume(int delta) {
        if (delta < 0) {
            throw new IllegalArgumentException();
        }
        int read = this.length() - this.available();
        int newConsumed = this.consumed() + delta;
        this.consumed.addAndGet(delta);
    }

    public int consumed() {
        return this.consumed.get();
    }

    public String asString(String charset, boolean consume) {
        ByteBuffer buffer = this.asByteBuffer(consume);
        return Charset.forName(charset).decode(buffer).toString();
    }

    public byte[] asBytes(boolean consume) {
        ByteBuffer buffer = this.asByteBuffer(consume);
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public ByteBuffer asByteBuffer(boolean consume) {
        ByteBuffer buffer = this.allocate(this.available());
        if (consume) {
            this.consumeInto(buffer);
        } else {
            this.readInto(buffer);
        }
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public String toString() {
        return String.format("DATA @%x available=%d consumed=%d close=%b compress=%b", this.hashCode(), this.available(), this.consumed(), this.isClose(), this.isCompress());
    }
}

