/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.api.DataInfo;

public class DataFrameGenerator {
    private final ByteBufferPool bufferPool;

    public DataFrameGenerator(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public ByteBuffer generate(int streamId, int length, DataInfo dataInfo) {
        ByteBuffer buffer = this.bufferPool.acquire(8 + length, true);
        buffer.position(8);
        int read = dataInfo.readInto(buffer);
        buffer.putInt(0, streamId & Integer.MAX_VALUE);
        buffer.putInt(4, read & 0xFFFFFF);
        byte flags = dataInfo.getFlags();
        if (dataInfo.available() > 0) {
            flags = (byte)(flags & 0xFFFFFFFE);
        }
        buffer.put(4, flags);
        buffer.flip();
        return buffer;
    }
}

