/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;

public class Module {
    private Path file;
    private String fileRef;
    private String logicalName;
    private int depth = 0;
    private Set<String> parentNames;
    private Set<String> optionalParentNames;
    private Set<Module> parentEdges;
    private Set<Module> childEdges;
    private List<String> xmls;
    private List<String> defaultConfig;
    private boolean hasDefaultConfig = false;
    private List<String> libs;
    private List<String> files;
    private List<String> jvmArgs;
    private List<String> license;
    private boolean enabled = false;
    private final Set<String> sources = new HashSet<String>();
    private boolean licenseAck = false;

    public Module(BaseHome basehome, Path file) throws FileNotFoundException, IOException {
        this.file = file;
        this.logicalName = this.fileRef = Pattern.compile(".mod$", 2).matcher(file.getFileName().toString()).replaceFirst("");
        this.init(basehome);
        this.process(basehome);
    }

    public void addChildEdge(Module child) {
        if (this.childEdges.contains(child)) {
            return;
        }
        this.childEdges.add(child);
    }

    public void addParentEdge(Module parent) {
        if (this.parentEdges.contains(parent)) {
            return;
        }
        this.parentEdges.add(parent);
    }

    public void addSources(List<String> sources) {
        this.sources.addAll(sources);
    }

    public void clearSources() {
        this.sources.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        return !(this.fileRef == null ? other.fileRef != null : !this.fileRef.equals(other.fileRef));
    }

    public void expandProperties(Props props) {
        HashSet<String> parents = new HashSet<String>();
        for (String parent : this.parentNames) {
            parents.add(props.expand(parent));
        }
        this.parentNames.clear();
        this.parentNames.addAll(parents);
    }

    public Set<Module> getChildEdges() {
        return this.childEdges;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getFilesystemRef() {
        return this.fileRef;
    }

    public List<String> getDefaultConfig() {
        return this.defaultConfig;
    }

    public boolean hasDefaultConfig() {
        return this.hasDefaultConfig;
    }

    public List<String> getLibs() {
        return this.libs;
    }

    public String getName() {
        return this.logicalName;
    }

    public Set<String> getOptionalParentNames() {
        return this.optionalParentNames;
    }

    public Set<Module> getParentEdges() {
        return this.parentEdges;
    }

    public Set<String> getParentNames() {
        return this.parentNames;
    }

    public Set<String> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public List<String> getXmls() {
        return this.xmls;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public boolean hasLicense() {
        return this.license != null && this.license.size() > 0;
    }

    public boolean acknowledgeLicense() throws IOException {
        if (!this.hasLicense() || this.licenseAck) {
            return true;
        }
        System.err.printf("%nModule %s:%n", this.getName());
        System.err.printf(" + contains software not provided by the Eclipse Foundation!%n", new Object[0]);
        System.err.printf(" + contains software not covered by the Eclipse Public License!%n", new Object[0]);
        System.err.printf(" + has not been audited for compliance with its license%n", new Object[0]);
        System.err.printf("%n", new Object[0]);
        for (String l : this.getLicense()) {
            System.err.printf("    %s%n", l);
        }
        String propBasedAckName = "org.eclipse.jetty.start.ack.license." + this.getName();
        String propBasedAckValue = System.getProperty(propBasedAckName);
        if (propBasedAckValue != null) {
            StartLog.log("TESTING MODE", "Programmatic ACK - %s=%s", propBasedAckName, propBasedAckValue);
            this.licenseAck = Boolean.parseBoolean(propBasedAckValue);
        } else {
            if (Boolean.getBoolean("org.eclipse.jetty.start.testing")) {
                throw new RuntimeException("Test Configuration Missing - Pre-specify answer to (" + propBasedAckName + ") in test case");
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader(System.in));){
                System.err.printf("%nProceed (y/N)? ", new Object[0]);
                String line = input.readLine();
                this.licenseAck = line != null && line.length() != 0 && line.toLowerCase().startsWith("y");
            }
        }
        return this.licenseAck;
    }

    public List<String> getLicense() {
        return this.license;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileRef == null ? 0 : this.fileRef.hashCode());
        return result;
    }

    private void init(BaseHome basehome) {
        this.parentNames = new HashSet<String>();
        this.optionalParentNames = new HashSet<String>();
        this.parentEdges = new HashSet<Module>();
        this.childEdges = new HashSet<Module>();
        this.xmls = new ArrayList<String>();
        this.defaultConfig = new ArrayList<String>();
        this.libs = new ArrayList<String>();
        this.files = new ArrayList<String>();
        this.jvmArgs = new ArrayList<String>();
        this.license = new ArrayList<String>();
        String name = basehome.toShortForm(this.file);
        Pattern pat = Pattern.compile("^.*[/\\\\]{1}modules[/\\\\]{1}(.*).mod$", 2);
        Matcher mat = pat.matcher(name);
        if (!mat.find()) {
            throw new RuntimeException("Invalid Module location (must be located under /modules/ directory): " + name);
        }
        this.logicalName = this.fileRef = mat.group(1).replace('\\', '/');
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasFiles(BaseHome baseHome) {
        for (String ref : this.getFiles()) {
            FileArg farg = new FileArg(this, ref);
            Path refPath = baseHome.getBasePath(farg.location);
            if (Files.exists(refPath, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public void process(BaseHome basehome) throws FileNotFoundException, IOException {
        Pattern section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        if (!FS.canReadFile(this.file)) {
            StartLog.debug("Skipping read of missing file: %s", basehome.toShortForm(this.file));
            return;
        }
        try (BufferedReader buf = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
            String line;
            String sectionType = "";
            block35: while ((line = buf.readLine()) != null) {
                Matcher sectionMatcher = section.matcher(line = line.trim());
                if (sectionMatcher.matches()) {
                    sectionType = sectionMatcher.group(1).trim().toUpperCase(Locale.ENGLISH);
                    continue;
                }
                if (line.length() == 0 || line.startsWith("#")) {
                    if (!"INI-TEMPLATE".equals(sectionType)) continue;
                    this.defaultConfig.add(line);
                    continue;
                }
                switch (sectionType) {
                    case "": {
                        continue block35;
                    }
                    case "DEPEND": {
                        this.parentNames.add(line);
                        continue block35;
                    }
                    case "FILES": {
                        this.files.add(line);
                        continue block35;
                    }
                    case "DEFAULTS": 
                    case "INI-TEMPLATE": {
                        this.defaultConfig.add(line);
                        this.hasDefaultConfig = true;
                        continue block35;
                    }
                    case "LIB": {
                        this.libs.add(line);
                        continue block35;
                    }
                    case "LICENSE": 
                    case "LICENCE": {
                        this.license.add(line);
                        continue block35;
                    }
                    case "NAME": {
                        this.logicalName = line;
                        continue block35;
                    }
                    case "OPTIONAL": {
                        this.optionalParentNames.add(line);
                        continue block35;
                    }
                    case "EXEC": {
                        this.jvmArgs.add(line);
                        continue block35;
                    }
                    case "XML": {
                        this.xmls.add(line);
                        continue block35;
                    }
                }
                throw new IOException("Unrecognized Module section: [" + sectionType + "]");
            }
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setParentNames(Set<String> parents) {
        this.parentNames.clear();
        this.parentEdges.clear();
        if (parents != null) {
            this.parentNames.addAll(parents);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Module[").append(this.logicalName);
        if (!this.logicalName.equals(this.fileRef)) {
            str.append(",file=").append(this.fileRef);
        }
        if (this.enabled) {
            str.append(",enabled");
        }
        str.append(']');
        return str.toString();
    }

    public static class NameComparator
    implements Comparator<Module> {
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(Module o1, Module o2) {
            CollationKey k1 = this.collator.getCollationKey(o1.fileRef);
            CollationKey k2 = this.collator.getCollationKey(o2.fileRef);
            return k1.compareTo(k2);
        }
    }

    public static class DepthComparator
    implements Comparator<Module> {
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(Module o1, Module o2) {
            int diff = o1.depth - o2.depth;
            if (diff != 0) {
                return diff;
            }
            CollationKey k1 = this.collator.getCollationKey(o1.fileRef);
            CollationKey k2 = this.collator.getCollationKey(o2.fileRef);
            return k1.compareTo(k2);
        }
    }
}

