/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Objects;
import org.eclipse.jetty.http2.BufferingFlowControlStrategy;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HTTP2ServerSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.strategy.ProduceExecuteConsume;

@ManagedObject
public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private final Connection.Listener connectionListener = new ConnectionListener();
    private final HttpConfiguration httpConfiguration;
    private int maxDynamicTableSize = 4096;
    private int initialStreamRecvWindow = 65535;
    private int initialSessionRecvWindow = 65535;
    private int maxConcurrentStreams = -1;
    private int maxHeaderBlockFragment = 0;
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private ExecutionStrategy.Factory executionStrategyFactory = new ProduceExecuteConsume.Factory();

    public AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2", "h2-17", "h2-16", "h2-15", "h2-14");
    }

    protected AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(protocols);
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.addBean(httpConfiguration);
    }

    @ManagedAttribute(value="The HPACK dynamic table maximum size")
    public int getMaxDynamicTableSize() {
        return this.maxDynamicTableSize;
    }

    public void setMaxDynamicTableSize(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @Deprecated
    public int getInitialStreamSendWindow() {
        return this.getInitialStreamRecvWindow();
    }

    @Deprecated
    public void setInitialStreamSendWindow(int initialStreamSendWindow) {
        this.setInitialStreamRecvWindow(initialStreamSendWindow);
    }

    @ManagedAttribute(value="The max number of concurrent streams per session")
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getMaxHeaderBlockFragment() {
        return this.maxHeaderBlockFragment;
    }

    public void setMaxHeaderBlockFragment(int maxHeaderBlockFragment) {
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    public ExecutionStrategy.Factory getExecutionStrategyFactory() {
        return this.executionStrategyFactory;
    }

    public void setExecutionStrategyFactory(ExecutionStrategy.Factory executionStrategyFactory) {
        this.executionStrategyFactory = executionStrategyFactory;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.getMaxDynamicTableSize(), this.getMaxHeaderBlockFragment());
        FlowControlStrategy flowControl = this.newFlowControlStrategy();
        if (flowControl == null) {
            flowControl = this.getFlowControlStrategyFactory().newFlowControlStrategy();
        }
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, generator, listener, flowControl);
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        session.setStreamIdleTimeout(endPoint.getIdleTimeout());
        session.setInitialSessionRecvWindow(this.getInitialSessionRecvWindow());
        ServerParser parser = this.newServerParser(connector, session);
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, this.httpConfiguration, parser, (ISession)session, this.getInputBufferSize(), this.getExecutionStrategyFactory(), listener);
        connection.addListener(this.connectionListener);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }

    @Deprecated
    protected FlowControlStrategy newFlowControlStrategy() {
        return null;
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    protected ServerParser newServerParser(Connector connector, ServerParser.Listener listener) {
        return new ServerParser(connector.getByteBufferPool(), listener, this.getMaxDynamicTableSize(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    private class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        public void onOpened(Connection connection) {
            AbstractHTTP2ServerConnectionFactory.this.addManaged((LifeCycle)((HTTP2Connection)connection).getSession());
        }

        public void onClosed(Connection connection) {
            AbstractHTTP2ServerConnectionFactory.this.removeBean(((HTTP2Connection)connection).getSession());
        }
    }
}

