/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ServerSession
extends HTTP2Session
implements ServerParser.Listener {
    private static final Logger LOG = Log.getLogger(HTTP2ServerSession.class);
    private final ServerSessionListener listener;

    public HTTP2ServerSession(Scheduler scheduler, EndPoint endPoint, Generator generator, ServerSessionListener listener, FlowControlStrategy flowControl) {
        super(scheduler, endPoint, generator, (Session.Listener)listener, flowControl, 2);
        this.listener = listener;
    }

    public void onPreface() {
        Map<Integer, Integer> settings = this.notifyPreface((Session)this);
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        SettingsFrame settingsFrame = new SettingsFrame(settings, false);
        WindowUpdateFrame windowFrame = null;
        int sessionWindow = this.getInitialSessionRecvWindow() - 65535;
        if (sessionWindow > 0) {
            windowFrame = new WindowUpdateFrame(0, sessionWindow);
        }
        if (windowFrame == null) {
            this.frames(null, Callback.NOOP, (Frame)settingsFrame, Frame.EMPTY_ARRAY);
        } else {
            this.frames(null, Callback.NOOP, (Frame)settingsFrame, new Frame[]{windowFrame});
        }
    }

    public void onHeaders(HeadersFrame frame) {
        MetaData metaData;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", new Object[]{frame});
        }
        if ((metaData = frame.getMetaData()).isRequest()) {
            IStream stream = this.createRemoteStream(frame.getStreamId());
            if (stream != null) {
                stream.process((Frame)frame, Callback.NOOP);
                Stream.Listener listener = this.notifyNewStream((Stream)stream, frame);
                stream.setListener(listener);
            }
        } else {
            this.onConnectionFailure(ErrorCode.INTERNAL_ERROR.code, "invalid_request");
        }
    }

    public void onPushPromise(PushPromiseFrame frame) {
        this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "push_promise");
    }

    private Map<Integer, Integer> notifyPreface(Session session) {
        try {
            return this.listener.onPreface(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return null;
        }
    }

    public void onFrame(Frame frame) {
        switch (frame.getType()) {
            case PREFACE: {
                this.onPreface();
                break;
            }
            case SETTINGS: {
                this.onSettings((SettingsFrame)frame, false);
                break;
            }
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame);
                break;
            }
            default: {
                super.onFrame(frame);
            }
        }
    }
}

