/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class ExpiredSessionRemover<MV, AV, L>
implements Remover<String> {
    private final SessionFactory<MV, AV, L> factory;
    private final SessionExpirationListener listener;

    public ExpiredSessionRemover(SessionFactory<MV, AV, L> factory, SessionExpirationListener listener) {
        this.factory = factory;
        this.listener = listener;
    }

    public boolean remove(String id) {
        ImmutableSessionMetaData metaData;
        Object metaDataValue = this.factory.getMetaDataFactory().tryValue(id);
        if (metaDataValue != null && (metaData = this.factory.getMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue)).isExpired()) {
            Object attributesValue = this.factory.getAttributesFactory().findValue(id);
            if (attributesValue != null) {
                ImmutableSessionAttributes attributes = this.factory.getAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
                ImmutableSession session = this.factory.createImmutableSession(id, metaData, attributes);
                InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s has expired.", id);
                this.listener.sessionExpired(session);
            }
            return this.factory.remove(id);
        }
        return false;
    }
}

