/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealthReporter;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.health.CheckOperation;
import org.wildfly.extension.microprofile.health.HealthContextService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthExtension;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemAdd;

public class MicroProfileHealthSubsystemDefinition
extends PersistentResourceDefinition {
    static final String HEALTH_REPORTER_CAPABILITY = "org.wildlfy.microprofile.health.reporter";
    static final RuntimeCapability<Void> HEALTH_REPORTER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildlfy.microprofile.health.reporter", SmallRyeHealthReporter.class).build();
    public static final ServiceName HEALTH_REPORTER_SERVICE = ServiceName.parse((String)"org.wildlfy.microprofile.health.reporter");
    static final String HTTP_EXTENSIBILITY_CAPABILITY = "org.wildfly.management.http.extensible";
    static final RuntimeCapability<Void> HTTP_CONTEXT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.microprofile.health.http-context", HealthContextService.class).addRequirements(new String[]{"org.wildfly.management.http.extensible"}).build();
    static final ServiceName HTTP_CONTEXT_SERVICE = HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName();
    static final AttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_ENABLED};
    private boolean registerRuntimeOperations;

    protected MicroProfileHealthSubsystemDefinition(boolean registerRuntimeOperations) {
        super(new PersistentResourceDefinition.Parameters(MicroProfileHealthExtension.SUBSYSTEM_PATH, MicroProfileHealthExtension.getResourceDescriptionResolver("microprofile-health-smallrye")).setAddHandler((OperationStepHandler)MicroProfileHealthSubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler((AbstractAddStepHandler)MicroProfileHealthSubsystemAdd.INSTANCE, new RuntimeCapability[0])).setCapabilities(new RuntimeCapability[]{HEALTH_REPORTER_RUNTIME_CAPABILITY, HTTP_CONTEXT_CAPABILITY}));
        this.registerRuntimeOperations = registerRuntimeOperations;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOperations) {
            CheckOperation.register(resourceRegistration);
        }
    }
}

