/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.util.ImmutableHopscotchHashSet;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;

public class LocalizedCacheTopology
extends CacheTopology {
    private final Address localAddress;
    private boolean connected;
    private final Set<Address> membersSet;
    private final KeyPartitioner keyPartitioner;
    private final boolean isDistributed;
    private final boolean allLocal;
    private final int numSegments;
    private final int maxOwners;
    private final DistributionInfo[] distributionInfos;
    private final boolean isScattered;
    private final IntSet localReadSegments;

    public static LocalizedCacheTopology makeSingletonTopology(CacheMode cacheMode, Address localAddress) {
        List<Address> members = Collections.singletonList(localAddress);
        CacheTopology cacheTopology = new CacheTopology(-1, -1, null, null, CacheTopology.Phase.NO_REBALANCE, members, null);
        return new LocalizedCacheTopology(CacheMode.LOCAL, cacheTopology, SingleSegmentKeyPartitioner.getInstance(), localAddress, false);
    }

    public static LocalizedCacheTopology makeSegmentedSingletonTopology(KeyPartitioner keyPartitioner, int numSegments, Address localAddress) {
        return new LocalizedCacheTopology(keyPartitioner, numSegments, localAddress);
    }

    public LocalizedCacheTopology(CacheMode cacheMode, CacheTopology cacheTopology, KeyPartitioner keyPartitioner, Address localAddress, boolean connected) {
        super(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), cacheTopology.getUnionCH(), cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
        ConsistentHash readCH = this.getReadConsistentHash();
        ConsistentHash writeCH = this.getWriteConsistentHash();
        this.localAddress = localAddress;
        this.connected = connected;
        this.membersSet = new ImmutableHopscotchHashSet(cacheTopology.getMembers());
        this.keyPartitioner = keyPartitioner;
        this.isDistributed = cacheMode.isDistributed();
        this.isScattered = cacheMode.isScattered();
        boolean isReplicated = cacheMode.isReplicated();
        if (this.isDistributed || this.isScattered) {
            this.numSegments = readCH.getNumSegments();
            this.distributionInfos = new DistributionInfo[this.numSegments];
            int maxOwners = 1;
            IntSet localReadSegments = IntSets.mutableEmptySet((int)this.numSegments);
            for (int segmentId = 0; segmentId < this.numSegments; ++segmentId) {
                Address primary = readCH.locatePrimaryOwnerForSegment(segmentId);
                List<Address> readOwners = readCH.locateOwnersForSegment(segmentId);
                List<Address> writeOwners = writeCH.locateOwnersForSegment(segmentId);
                List<Address> writeBackups = this.isScattered ? Collections.emptyList() : writeOwners.subList(1, writeOwners.size());
                this.distributionInfos[segmentId] = new DistributionInfo(segmentId, primary, readOwners, writeOwners, writeBackups, localAddress);
                maxOwners = Math.max(maxOwners, writeOwners.size());
                if (!readOwners.contains(localAddress)) continue;
                localReadSegments.set(segmentId);
            }
            this.maxOwners = maxOwners;
            this.allLocal = false;
            this.localReadSegments = IntSets.immutableSet((IntSet)localReadSegments);
        } else if (isReplicated) {
            this.numSegments = readCH.getNumSegments();
            HashMap<Address, List> readOwnersMap = new HashMap<Address, List>();
            HashMap<Address, List> writeOwnersMap = new HashMap<Address, List>();
            this.distributionInfos = new DistributionInfo[this.numSegments];
            for (int segmentId = 0; segmentId < this.numSegments; ++segmentId) {
                int segmentCopy = segmentId;
                Address primary = readCH.locatePrimaryOwnerForSegment(segmentId);
                List readOwners = readOwnersMap.computeIfAbsent(primary, p -> Immutables.immutableListCopy(readCH.locateOwnersForSegment(segmentCopy)));
                List writeOwners = writeOwnersMap.computeIfAbsent(primary, p -> Immutables.immutableListCopy(writeCH.locateOwnersForSegment(segmentCopy)));
                List<Address> writeBackups = writeOwners.subList(1, writeOwners.size());
                this.distributionInfos[segmentId] = new DistributionInfo(segmentId, primary, readOwners, writeOwners, writeBackups, localAddress);
            }
            this.maxOwners = cacheTopology.getMembers().size();
            this.allLocal = readOwnersMap.containsKey(localAddress);
            this.localReadSegments = IntSets.immutableRangeSet((int)(this.allLocal ? this.numSegments : 0));
        } else {
            assert (cacheMode.isInvalidation() || cacheMode == CacheMode.LOCAL);
            this.numSegments = 1;
            List<Address> owners = Collections.singletonList(localAddress);
            List<Address> writeBackups = Collections.emptyList();
            this.distributionInfos = new DistributionInfo[]{new DistributionInfo(0, localAddress, owners, owners, writeBackups, localAddress)};
            this.maxOwners = 1;
            this.allLocal = true;
            this.localReadSegments = IntSets.immutableRangeSet((int)this.numSegments);
        }
    }

    private LocalizedCacheTopology(KeyPartitioner keyPartitioner, int numSegments, Address localAddress) {
        super(-1, -1, null, null, null, Collections.singletonList(localAddress), null);
        this.localAddress = localAddress;
        this.numSegments = numSegments;
        this.keyPartitioner = keyPartitioner;
        this.membersSet = Collections.unmodifiableSet(Collections.singleton(localAddress));
        this.isDistributed = false;
        this.isScattered = false;
        List<Address> owners = Collections.singletonList(localAddress);
        this.distributionInfos = new DistributionInfo[numSegments];
        for (int i = 0; i < this.distributionInfos.length; ++i) {
            this.distributionInfos[i] = new DistributionInfo(i, localAddress, owners, owners, Collections.emptyList(), localAddress);
        }
        this.maxOwners = 1;
        this.allLocal = true;
        this.localReadSegments = IntSets.immutableRangeSet((int)numSegments);
    }

    public boolean isReadOwner(Object key) {
        if (this.allLocal) {
            return true;
        }
        int segmentId = this.keyPartitioner.getSegment(key);
        return this.distributionInfos[segmentId].isReadOwner();
    }

    public boolean isSegmentReadOwner(int segment) {
        return this.allLocal || this.distributionInfos[segment].isReadOwner();
    }

    public boolean isWriteOwner(Object key) {
        if (this.allLocal) {
            return true;
        }
        int segmentId = this.keyPartitioner.getSegment(key);
        return this.distributionInfos[segmentId].isWriteOwner();
    }

    public boolean isSegmentWriteOwner(int segment) {
        return this.allLocal || this.distributionInfos[segment].isWriteOwner();
    }

    public int getSegment(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    @Deprecated
    public DistributionInfo getDistributionForSegment(int segmentId) {
        return this.getSegmentDistribution(segmentId);
    }

    public DistributionInfo getSegmentDistribution(int segmentId) {
        return this.distributionInfos[segmentId];
    }

    public DistributionInfo getDistribution(Object key) {
        int segmentId = this.keyPartitioner.getSegment(key);
        return this.distributionInfos[segmentId];
    }

    public Collection<Address> getWriteOwners(Object key) {
        int segmentId = this.isDistributed || this.isScattered ? this.keyPartitioner.getSegment(key) : 0;
        return this.distributionInfos[segmentId].writeOwners();
    }

    public Collection<Address> getWriteOwners(Collection<?> keys) {
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.isDistributed || this.isScattered) {
            if (keys.size() == 1) {
                Object singleKey = keys.iterator().next();
                return this.getDistribution(singleKey).writeOwners();
            }
            IntSet segments = IntSets.mutableEmptySet((int)this.numSegments);
            HashSet<Address> owners = new HashSet<Address>(2 * this.maxOwners);
            for (Object key : keys) {
                int segment = this.keyPartitioner.getSegment(key);
                if (!segments.add(segment)) continue;
                owners.addAll(this.getSegmentDistribution(segment).writeOwners());
            }
            return owners;
        }
        return this.getSegmentDistribution(0).writeOwners();
    }

    public IntSet getLocalReadSegments() {
        return this.localReadSegments;
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public Set<Address> getMembersSet() {
        return this.membersSet;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

