/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.Arrays;
import java.util.HashMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;

@Command(name="stat", description="prints out basic stats associated with queues. Output includes CONSUMER_COUNT (number of consumers), MESSAGE_COUNT (current message count on the queue, including scheduled, paged and in-delivery messages), MESSAGES_ADDED (messages added to the queue), DELIVERING_COUNT (messages broker is currently delivering to consumer(s)), MESSAGES_ACKED (messages acknowledged from the consumer(s)). Queues can be filtered using EITHER '--queueName X' where X is contained in the queue name OR using a full filter '--field NAME --operation EQUALS --value X'.")
public class StatQueue
extends AbstractAction {
    @Option(name={"--queueName"}, description="display queue stats for queue(s) with names containing this string.")
    private String queueName;
    @Option(name={"--field"}, description="field to use in filter. Possible values NAME, ADDRESS, MESSAGE_COUNT, MESSAGES_ADDED, DELIVERING_COUNT, MESSAGES_ACKED.")
    private String fieldName;
    @Option(name={"--operation"}, description="operation to use in filter. Possible values CONTAINS, EQUALS, GREATER_THAN, LESS_THAN.")
    private String operationName;
    @Option(name={"--value"}, description="value to use in the filter.")
    private String value;
    @Option(name={"--maxRows"}, description="max number of queues displayed. Default is 50.")
    private int maxRows = 50;

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setverbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        String filter = this.createFilter();
        if (filter == null) {
            return null;
        }
        if (this.verbose) {
            context.out.println("filter is '" + filter + "'");
            context.out.println("maxRows='" + this.maxRows + "'");
        }
        this.printStats(context, filter, this.maxRows);
        return null;
    }

    private void printStats(final ActionContext context, final String filter, final int maxRows) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listQueues", (Object[])new Object[]{filter, 1, maxRows});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                StatQueue.this.printStats(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to get Stats for Queues. Reason: " + errMsg);
            }
        });
    }

    private void printStats(String result) {
        this.printHeadings();
        if (result == null) {
            if (this.verbose) {
                this.context.err.println("printStats(): got NULL result string.");
            }
            return;
        }
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)result);
        JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        for (int i = 0; i < array.size(); ++i) {
            this.printQueueStats(array.getJsonObject(i));
        }
    }

    private void printHeadings() {
        StringBuilder stringBuilder = new StringBuilder(134).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.NAME.toString()), 25)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.ADDRESS.toString()), 25)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.CONSUMER_COUNT.toString() + " "), 15)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.MESSAGE_COUNT.toString() + " "), 14)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.MESSAGES_ADDED.toString() + " "), 15)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.DELIVERING_COUNT.toString() + " "), 17)).append('|').append((CharSequence)this.paddingString(new StringBuilder(FIELD.MESSAGES_ACKED.toString() + " "), 15)).append('|');
        this.context.out.println(stringBuilder);
    }

    private void printQueueStats(JsonObject jsonObject) {
        if (jsonObject == null) {
            if (this.verbose) {
                this.context.err.println("printQueueStats(): jsonObject is null");
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(134).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.NAME.getJsonId())), 25)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.ADDRESS.getJsonId())), 25)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.CONSUMER_COUNT.getJsonId())), 15)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.MESSAGE_COUNT.getJsonId())), 14)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.MESSAGES_ADDED.getJsonId())), 15)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.DELIVERING_COUNT.getJsonId())), 17)).append('|').append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(FIELD.MESSAGES_ACKED.getJsonId())), 15)).append('|');
        this.context.out.println(stringBuilder);
    }

    private StringBuilder paddingString(StringBuilder value, int size) {
        int length;
        if (value == null) {
            return new StringBuilder(size);
        }
        if (value.length() == 0) {
            value.append("NO DATA");
        }
        if ((length = value.length()) >= size) {
            return value;
        }
        int i = 1;
        while (i + length <= size) {
            value.append(' ');
            ++i;
        }
        return value;
    }

    private String createFilter() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (this.fieldName != null && this.fieldName.trim().length() > 0 && this.queueName != null && this.queueName.trim().length() > 0) {
            this.context.err.println("'--field' and '--queueName' cannot be specified together.");
            return null;
        }
        if (this.fieldName != null && this.fieldName.trim().length() > 0) {
            try {
                FIELD field = FIELD.valueOf(this.fieldName);
                filterMap.put("field", field.toString());
            }
            catch (IllegalArgumentException ex) {
                this.context.err.println("'--field' must be set to one of the following " + Arrays.toString((Object[])FIELD.values()));
                return null;
            }
            if (this.value == null || this.value.trim().length() == 0) {
                this.context.err.println("'--value' needs to be set when '--field' is specified");
                return null;
            }
            filterMap.put("value", this.value);
            if (this.operationName == null) {
                this.context.err.println("'--operation' must be set when '--field' is specified " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
            try {
                OPERATION operation = OPERATION.valueOf(this.operationName);
                filterMap.put("operation", operation.toString());
            }
            catch (IllegalArgumentException ex) {
                this.context.err.println("'--operation' must be set to one of the following " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
        }
        if (this.queueName != null && this.queueName.trim().length() > 0) {
            filterMap.put("field", FIELD.NAME.toString());
            filterMap.put("value", this.queueName);
            filterMap.put("operation", OPERATION.CONTAINS.toString());
        } else {
            filterMap.put("field", "");
            filterMap.put("value", "");
            filterMap.put("operation", "");
        }
        JsonObject filterJsonObject = JsonUtil.toJsonObject(filterMap);
        return filterJsonObject.toString();
    }

    public static enum OPERATION {
        CONTAINS,
        EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }

    public static enum FIELD {
        NAME("name"),
        ADDRESS("address"),
        CONSUMER_COUNT("consumerCount"),
        MESSAGE_COUNT("messageCount"),
        MESSAGES_ADDED("messagesAdded"),
        DELIVERING_COUNT("deliveringCount"),
        MESSAGES_ACKED("messagesAcked");

        private String jsonId;

        private FIELD(String jsonId) {
            this.jsonId = jsonId;
        }

        String getJsonId() {
            return this.jsonId;
        }
    }
}

