/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.hibernate;

import org.jboss.as.hibernate.TransformedState;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.objectweb.asm.MethodVisitor;
import org.wildfly.security.manager.WildFlySecurityManager;

class MethodAdapter
extends MethodVisitor {
    private static final boolean disableAmbiguousChanges = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"Hibernate51CompatibilityTransformer.disableAmbiguousChanges", (String)"false"));
    public static final BasicLogger logger = Logger.getLogger((String)"org.jboss.as.hibernate.transformer");
    private final boolean rewriteSessionImplementor;
    private final TransformedState transformedState;
    private final MethodVisitor mv;
    private final String moduleName;
    private final String className;

    MethodAdapter(boolean rewriteSessionImplementor, int api, MethodVisitor mv, String moduleName, String className, TransformedState transformedState) {
        super(api, mv);
        this.rewriteSessionImplementor = rewriteSessionImplementor;
        this.mv = mv;
        this.moduleName = moduleName;
        this.className = className;
        this.transformedState = transformedState;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.rewriteSessionImplementor && this.hasSessionImplementor(desc) && (opcode == 183 || opcode == 182)) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s' is calling method %s.%s, which must be changed to use SharedSessionContractImplementor as parameter.", new Object[]{this.moduleName, this.className, owner, name});
            this.mv.visitMethodInsn(opcode, owner, name, MethodAdapter.replaceSessionImplementor(desc), itf);
            this.transformedState.setClassTransformed(true);
        } else if (opcode == 185 && (owner.equals("org/hibernate/Session") || owner.equals("org/hibernate/BasicQueryContract")) && name.equals("getFlushMode") && desc.equals("()Lorg/hibernate/FlushMode;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s' is calling %s.getFlushMode, which must be changed to call getHibernateFlushMode().", (Object)this.moduleName, (Object)this.className, (Object)owner);
            name = "getHibernateFlushMode";
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.transformedState.setClassTransformed(true);
        } else if (opcode == 185 && owner.equals("org/hibernate/Query") && name.equals("getFirstResult") && desc.equals("()Ljava/lang/Integer;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s', is calling org.hibernate.Query.getFirstResult, which must be changed to call getHibernateFirstResult() so null can be returned when the value is uninitialized. Please note that if a negative value was set using org.hibernate.Query.setFirstResult, then getHibernateFirstResult() will return 0.", (Object)this.moduleName, (Object)this.className);
            name = "getHibernateFirstResult";
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.transformedState.setClassTransformed(true);
        } else if (opcode == 185 && owner.equals("org/hibernate/Query") && name.equals("getMaxResults") && desc.equals("()Ljava/lang/Integer;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s', is calling org.hibernate.Query.getMaxResults, which must be changed to call getHibernateMaxResults() so that null will be returned when the value is uninitialized or ORM 5.1 org.hibernate.Query#setMaxResults was used to set a value <= 0", (Object)this.moduleName, (Object)this.className);
            name = "getHibernateMaxResults";
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.transformedState.setClassTransformed(true);
        } else if (!disableAmbiguousChanges && opcode == 185 && owner.equals("org/hibernate/Query") && name.equals("setFirstResult") && desc.equals("(I)Lorg/hibernate/Query;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s', is calling org.hibernate.Query.setFirstResult, which must be changed to call setHibernateFirstResult() so setting a value < 0 results in pagination starting with the 0th row as was done in Hibernate ORM 5.1 (instead of throwing IllegalArgumentException as specified by JPA).", (Object)this.moduleName, (Object)this.className);
            name = "setHibernateFirstResult";
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.transformedState.setClassTransformed(true);
        } else if (!disableAmbiguousChanges && opcode == 185 && owner.equals("org/hibernate/Query") && name.equals("setMaxResults") && desc.equals("(I)Lorg/hibernate/Query;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s', is calling org.hibernate.Query.setMaxResults, which must be changed to call setHibernateMaxResults() so that values <= 0 are treated the same as uninitialized.  Review Hibernate ORM migration doc ", (Object)this.moduleName, (Object)this.className);
            name = "setHibernateMaxResults";
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            this.transformedState.setClassTransformed(true);
        } else {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 178 && owner.equals("org/hibernate/FlushMode") && name.equals("NEVER") && desc.equals("Lorg/hibernate/FlushMode;")) {
            logger.debugf("Deprecated Hibernate51CompatibilityTransformer transformed application classes in '%s', class '%s' is using org.hibernate.FlushMode.NEVER, change to org.hibernate.FlushMode.MANUAL.", (Object)this.moduleName, (Object)this.className);
            this.mv.visitFieldInsn(opcode, owner, "MANUAL", desc);
            this.transformedState.setClassTransformed(true);
        } else {
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private static String replaceSessionImplementor(String desc) {
        return desc.replace("Lorg/hibernate/engine/spi/SessionImplementor;", "Lorg/hibernate/engine/spi/SharedSessionContractImplementor;");
    }

    private boolean hasSessionImplementor(String desc) {
        return desc.contains("Lorg/hibernate/engine/spi/SessionImplementor;");
    }
}

