/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.Encrypt;
import org.jgroups.protocols.EncryptHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.ResponseCollectorTask;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Asymmetric encryption protocol. The secret key for encryption and decryption of messages is fetched from a key server (the coordinator) via asymmetric encryption")
public class ASYM_ENCRYPT
extends Encrypt<KeyStore.PrivateKeyEntry> {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    @Property(description="When a member leaves, change the secret key, preventing old members from eavesdropping")
    protected boolean change_key_on_leave = true;
    @Property(description="If true, a separate KeyExchange protocol (somewhere below in ths stack) is used to fetch the shared secret key. If false, the default (built-in) key exchange protocol will be used.")
    protected boolean use_external_key_exchange;
    @Property(description="Interval (in ms) to send out announcements when the key server changed. Members will then start the key exchange protocol. When all members have acked, the task is cancelled.")
    protected long key_server_interval = 1000L;
    protected volatile Address key_server_addr;
    protected KeyPair key_pair;
    protected Cipher asym_cipher;
    @Property(description="Min time (in millis) between key requests")
    protected long min_time_between_key_requests = 2000L;
    protected volatile long last_key_request;
    protected List<BiPredicate<Message, Boolean>> bypassers;
    protected ResponseCollectorTask<Boolean> key_requesters;

    @Override
    public void setKeyStoreEntry(KeyStore.PrivateKeyEntry entry) {
        this.key_pair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
    }

    public boolean getChangeKeyOnLeave() {
        return this.change_key_on_leave;
    }

    public ASYM_ENCRYPT setChangeKeyOnLeave(boolean c) {
        this.change_key_on_leave = c;
        return this;
    }

    public boolean getUseExternalKeyExchange() {
        return this.use_external_key_exchange;
    }

    public ASYM_ENCRYPT setUseExternalKeyExchange(boolean u) {
        this.use_external_key_exchange = u;
        return this;
    }

    public long getKeyserverInterval() {
        return this.key_server_interval;
    }

    public ASYM_ENCRYPT setKeyserverInterval(long i) {
        this.key_server_interval = i;
        return this;
    }

    public KeyPair keyPair() {
        return this.key_pair;
    }

    public Cipher asymCipher() {
        return this.asym_cipher;
    }

    public Address keyServerAddr() {
        return this.key_server_addr;
    }

    public ASYM_ENCRYPT keyServerAddr(Address ks) {
        this.key_server_addr = ks;
        return this;
    }

    @Override
    public List<Integer> providedDownServices() {
        return Arrays.asList(111, 112);
    }

    public synchronized ASYM_ENCRYPT registerBypasser(BiPredicate<Message, Boolean> bypasser) {
        if (bypasser != null) {
            if (this.bypassers == null) {
                this.bypassers = new ArrayList<BiPredicate<Message, Boolean>>();
            }
            this.bypassers.add(bypasser);
        }
        return this;
    }

    public synchronized ASYM_ENCRYPT unregisterBypasser(BiPredicate<Message, Boolean> bypasser) {
        if (bypasser != null && this.bypassers != null && this.bypassers.remove(bypasser) && this.bypassers.isEmpty()) {
            this.bypassers = null;
        }
        return this;
    }

    @ManagedAttribute(description="The current key server")
    public String getKeyServerAddress() {
        return this.key_server_addr != null ? this.key_server_addr.toString() : "null";
    }

    @ManagedOperation(description="Triggers a request for the secret key to the current keyserver")
    public void sendKeyRequest() {
        if (this.key_server_addr == null) {
            this.log.debug("%s: sending secret key request failed as the key server is currently not set", this.local_addr);
            return;
        }
        this.sendKeyRequest(this.key_server_addr);
    }

    @ManagedAttribute(description="True if this member is the current key server, false otherwise")
    public boolean isKeyServer() {
        return Objects.equals(this.key_server_addr, this.local_addr);
    }

    @Override
    public void init() throws Exception {
        List<Integer> provided_up_services;
        this.initKeyPair();
        super.init();
        if (this.use_external_key_exchange && ((provided_up_services = this.getDownServices()) == null || !provided_up_services.contains(110))) {
            throw new IllegalStateException("found no key exchange protocol below servicing event FETCH_SECRET_KEY");
        }
    }

    @Override
    public void stop() {
        if (this.key_requesters != null) {
            this.key_requesters.stop();
        }
        super.stop();
    }

    @Override
    public Object down(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (ASYM_ENCRYPT.skip(hdr) || this.bypass(msg, false)) {
            return this.down_prot.down(msg);
        }
        return super.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.type()) {
            case 111: {
                return new Tuple<Key, byte[]>(this.secret_key, this.sym_version);
            }
            case 112: {
                Tuple tuple = (Tuple)evt.arg();
                try {
                    this.setKeys(null, (SecretKey)tuple.getVal1(), (byte[])tuple.getVal2());
                }
                catch (Exception ex) {
                    this.log.error("failed setting secret key", ex);
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        if (this.bypass(msg, true)) {
            return this.up_prot.up(msg);
        }
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return super.up(msg);
        }
        if (ASYM_ENCRYPT.skip(hdr)) {
            return this.up_prot.up(msg);
        }
        if (ASYM_ENCRYPT.isJoinOrInstallViewMessage(hdr)) {
            Address key_server = msg.getSrc();
            this.sendKeyRequest(key_server);
        }
        return super.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            EncryptHeader eh;
            if (this.bypass(msg, true)) {
                this.up_prot.up(msg);
                batch.remove(msg);
                continue;
            }
            GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
            if (hdr != null) {
                if (ASYM_ENCRYPT.skip(hdr)) {
                    try {
                        this.up_prot.up(msg);
                        batch.remove(msg);
                    }
                    catch (Throwable t) {
                        this.log.error("failed passing up message from %s: %s, ex=%s", msg.src(), msg.printHeaders(), t);
                    }
                    continue;
                }
                if (ASYM_ENCRYPT.isJoinOrInstallViewMessage(hdr)) {
                    Address key_server = batch.sender();
                    this.sendKeyRequest(key_server);
                }
            }
            if ((eh = (EncryptHeader)msg.getHeader(this.id)) == null || eh.type == 1) continue;
            this.handleUpEvent(msg, eh);
            batch.remove(msg);
        }
        if (!batch.isEmpty()) {
            super.up(batch);
        }
    }

    protected static boolean skip(GMS.GmsHeader hdr) {
        if (hdr == null) {
            return false;
        }
        switch (hdr.getType()) {
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isJoinOrInstallViewMessage(GMS.GmsHeader hdr) {
        if (hdr == null) {
            return false;
        }
        switch (hdr.getType()) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected boolean bypass(Message msg, boolean up2) {
        List<BiPredicate<Message, Boolean>> tmp = this.bypassers;
        if (tmp == null) {
            return false;
        }
        for (BiPredicate<Message, Boolean> pred : tmp) {
            if (!pred.test(msg, up2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object handleUpEvent(Message msg, EncryptHeader hdr) {
        switch (hdr.type()) {
            case 2: {
                this.handleSecretKeyRequest(msg);
                break;
            }
            case 4: {
                this.handleSecretKeyResponse(msg, hdr.version());
                this.sendNewKeyserverAck(msg.src());
                break;
            }
            case 8: {
                Address sender = msg.src();
                if (!this.inView(sender, "key server %s is not in the current view %s; ignoring NEW_KEYSERVER msg")) {
                    return null;
                }
                if (!Arrays.equals(this.sym_version, hdr.version)) {
                    this.sendKeyRequest(sender);
                    break;
                }
                this.sendNewKeyserverAck(sender);
                break;
            }
            case 16: {
                if (this.key_requesters == null) break;
                this.key_requesters.add(msg.src(), true);
            }
        }
        return null;
    }

    @Override
    protected void versionMismatch(Message msg) {
        this.sendKeyRequest(this.key_server_addr);
    }

    @Override
    protected void handleUnknownVersion(byte[] version) {
        if (!this.isKeyServer()) {
            this.log.debug("%s: received msg encrypted with version %s (my version: %s), getting new secret key from %s", this.local_addr, Util.byteArrayToHexString(version), Util.byteArrayToHexString(this.sym_version), this.key_server_addr);
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    @Override
    protected void secretKeyNotAvailable() {
        if (!this.isKeyServer()) {
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected void handleSecretKeyRequest(Message msg) {
        if (!this.inView(msg.src(), "key requester %s is not in current view %s; ignoring key request")) {
            return;
        }
        this.log.debug("%s: received secret key request from %s", this.local_addr, msg.getSrc());
        try {
            PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
            this.sendSecretKey(this.secret_key, tmpKey, msg.getSrc());
        }
        catch (Exception e) {
            this.log.warn("%s: unable to reconstitute peer's public key", this.local_addr);
        }
    }

    protected void handleSecretKeyResponse(Message msg, byte[] key_version) {
        if (!this.inView(msg.src(), "ignoring secret key sent by %s which is not in current view %s")) {
            return;
        }
        if (Arrays.equals(this.sym_version, key_version)) {
            this.log.debug("%s: secret key (version %s) already installed, ignoring key response from %s", this.local_addr, Util.byteArrayToHexString(key_version), msg.src());
            return;
        }
        try {
            SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
            if (tmp == null) {
                this.sendKeyRequest(this.key_server_addr);
            } else {
                this.setKeys(msg.src(), tmp, key_version);
            }
        }
        catch (Exception e) {
            this.log.warn("%s: unable to process key received from %s: %s", this.local_addr, msg.src(), e);
        }
    }

    protected SecretKey createSecretKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm), this.provider) : KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
        keyGen.init(this.sym_keylength);
        return keyGen.generateKey();
    }

    protected void initKeyPair() throws Exception {
        if (this.key_pair == null) {
            KeyPairGenerator KpairGen = null;
            KpairGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm), this.provider) : KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            KpairGen.initialize(this.asym_keylength, new SecureRandom());
            this.key_pair = KpairGen.generateKeyPair();
        }
        this.asym_cipher = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        this.asym_cipher.init(2, this.key_pair.getPrivate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleView(View v) {
        Address old_key_server;
        boolean left_mbrs;
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            left_mbrs = this.change_key_on_leave && this.view != null && !v.containsMembers(this.view.getMembersRaw());
            boolean create_new_key = this.secret_key == null || left_mbrs;
            super.handleView(v);
            if (this.key_requesters != null) {
                this.key_requesters.retainAll(v.getMembers());
            }
            old_key_server = this.key_server_addr;
            this.key_server_addr = v.getCoord();
            if (Objects.equals(this.key_server_addr, this.local_addr)) {
                if (!Objects.equals(this.key_server_addr, old_key_server)) {
                    this.log.debug("%s: I'm the new key server", this.local_addr);
                }
                if (create_new_key) {
                    this.createNewKey();
                    if (this.key_requesters != null) {
                        this.key_requesters.stop();
                    }
                    ArrayList<Address> targets = new ArrayList<Address>(v.getMembers());
                    targets.remove(this.local_addr);
                    if (!targets.isEmpty()) {
                        this.key_requesters = new ResponseCollectorTask(targets).setPeriodicTask(c -> {
                            Message msg = new Message(null).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(this.id, new EncryptHeader(8, this.sym_version));
                            this.down_prot.down(msg);
                        }).start(this.getTransport().getTimer(), 0L, this.key_server_interval);
                    }
                }
                return;
            }
        }
        this.handleNewKeyServer(old_key_server, v instanceof MergeView, left_mbrs);
    }

    protected void createNewKey() {
        try {
            this.secret_key = this.createSecretKey();
            this.initSymCiphers(this.sym_algorithm, this.secret_key);
            this.log.debug("%s: created new secret key (version: %s)", this.local_addr, Util.byteArrayToHexString(this.sym_version));
        }
        catch (Exception ex) {
            this.log.error("%s: failed creating secret key and initializing ciphers", this.local_addr, ex);
        }
    }

    protected void handleNewKeyServer(Address old_key_server, boolean merge_view, boolean left_mbrs) {
        if (this.change_key_on_leave && (this.keyServerChanged(old_key_server) || merge_view || left_mbrs)) {
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected boolean keyServerChanged(Address old_keyserver) {
        return !Objects.equals(this.key_server_addr, old_keyserver);
    }

    protected synchronized void setKeys(Address sender, SecretKey key, byte[] version) throws Exception {
        Cipher decoding_cipher;
        if (Arrays.equals(this.sym_version, version)) {
            this.log.debug("%s: ignoring secret key received from %s (version: %s), as it has already been installed", this.local_addr, sender != null ? sender : "key exchange protocol", Util.byteArrayToHexString(version));
            return;
        }
        Cipher cipher = decoding_cipher = this.secret_key != null ? (Cipher)this.decoding_ciphers.take() : null;
        if (decoding_cipher != null) {
            this.key_map.putIfAbsent(new AsciiString(version), decoding_cipher);
        }
        this.log.debug("%s: installing secret key received from %s (version: %s)", this.local_addr, sender != null ? sender : "key exchange protocol", Util.byteArrayToHexString(version));
        this.secret_key = key;
        this.initSymCiphers(key.getAlgorithm(), key);
        this.sym_version = version;
    }

    protected void sendSecretKey(Key secret_key, PublicKey public_key, Address source) throws Exception {
        byte[] encryptedKey = this.encryptSecretKey(secret_key, public_key);
        Message newMsg = new Message(source, encryptedKey).src(this.local_addr).putHeader(this.id, new EncryptHeader(4, this.symVersion()));
        this.log.debug("%s: sending secret key response to %s (version: %s)", this.local_addr, source, Util.byteArrayToHexString(this.sym_version));
        this.down_prot.down(newMsg);
    }

    protected byte[] encryptSecretKey(Key secret_key, PublicKey public_key) throws Exception {
        Cipher tmp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        tmp.init(1, public_key);
        return tmp.doFinal(secret_key.getEncoded());
    }

    protected void sendKeyRequest(Address key_server) {
        if (key_server == null) {
            return;
        }
        if (this.last_key_request != 0L && System.currentTimeMillis() - this.last_key_request <= this.min_time_between_key_requests) {
            return;
        }
        this.last_key_request = System.currentTimeMillis();
        if (this.use_external_key_exchange) {
            this.log.debug("%s: asking key exchange protocol to get secret key from %s", this.local_addr, key_server);
            this.down_prot.down(new Event(110, key_server));
            return;
        }
        this.log.debug("%s: asking %s for the secret key (my version: %s)", this.local_addr, key_server, Util.byteArrayToHexString(this.sym_version));
        Message newMsg = new Message(key_server, this.key_pair.getPublic().getEncoded()).src(this.local_addr).putHeader(this.id, new EncryptHeader(2, null));
        this.down_prot.down(newMsg);
    }

    protected void sendNewKeyserverAck(Address dest) {
        Message msg = new Message(dest).putHeader(this.id, new EncryptHeader(16, null));
        this.down_prot.down(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            try {
                keyBytes = this.asym_cipher.doFinal(encodedKey);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                this.asym_cipher.init(2, this.key_pair.getPrivate());
                throw e;
            }
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
            Cipher temp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.sym_algorithm, this.provider) : Cipher.getInstance(this.sym_algorithm);
            temp.init(3, keySpec);
            return keySpec;
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDecodingKey"), e);
            return null;
        }
    }

    protected PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }
}

