-- Copyright (c) 2016, 2018, Oracle and/or its affiliates. All rights reserved.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License, version 2.0,
-- as published by the Free Software Foundation.
--
-- This program is also distributed with certain software (including
-- but not limited to OpenSSL) that is licensed under separate terms,
-- as designated in a particular file or component or in included license
-- documentation.  The authors of MySQL hereby grant you an additional
-- permission to link the program and your derivative works with the
-- separately licensed software that they have included with MySQL.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License, version 2.0, for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

--
-- Upgrade system table contents
--

-- Deprecate spatial reference systems

-- Deprecation must happen before new SRSs are added/updated since there
-- typically are new SRSs with the same names.

CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 6956 NAME 'VN-2000 / TM-3 zone 481 (6956 deprecated)' ORGANIZATION 'EPSG' IDENTIFIED BY 6956 DEFINITION 'PROJCS["VN-2000 / TM-3 zone 481",GEOGCS["VN-2000",DATUM["Vietnam 2000",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278],AUTHORITY["EPSG","6756"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4756"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","6956"]]' DESCRIPTION 'Deprecated since EPSG Dataset 9.3. Superseded by SRID 5896.';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 6957 NAME 'VN-2000 / TM-3 zone 482 (6957 deprecated)' ORGANIZATION 'EPSG' IDENTIFIED BY 6957 DEFINITION 'PROJCS["VN-2000 / TM-3 zone 482",GEOGCS["VN-2000",DATUM["Vietnam 2000",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278],AUTHORITY["EPSG","6756"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4756"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","6957"]]' DESCRIPTION 'Deprecated since EPSG Dataset 9.3. Superseded by SRID 5897.';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 6958 NAME 'VN-2000 / TM-3 zone 491 (6958 deprecated)' ORGANIZATION 'EPSG' IDENTIFIED BY 6958 DEFINITION 'PROJCS["VN-2000 / TM-3 zone 491",GEOGCS["VN-2000",DATUM["Vietnam 2000",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278],AUTHORITY["EPSG","6756"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4756"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","6958"]]' DESCRIPTION 'Deprecated since EPSG Dataset 9.3. Superseded by SRID 5898.';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 6959 NAME 'VN-2000 / TM-3 Da Nang zone (6959 deprecated)' ORGANIZATION 'EPSG' IDENTIFIED BY 6959 DEFINITION 'PROJCS["VN-2000 / TM-3 Da Nang zone",GEOGCS["VN-2000",DATUM["Vietnam 2000",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278],AUTHORITY["EPSG","6756"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4756"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",107.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","6959"]]' DESCRIPTION 'Deprecated since EPSG Dataset 9.3. Superseded by SRID 5899.';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 7082 NAME 'RGTAAF07 / Terre Adelie Polar Stereographic (7082 deprecated)' ORGANIZATION 'EPSG' IDENTIFIED BY 7082 DEFINITION 'PROJCS["RGTAAF07 / Terre Adelie Polar Stereographic",GEOGCS["RGTAAF07",DATUM["Reseau Geodesique des Terres Australes et Antarctiques Francaises 2007",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],AUTHORITY["EPSG","1113"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","7073"]],PROJECTION["Polar Stereographic (variant C)",AUTHORITY["EPSG","9830"]],PARAMETER["Latitude of standard parallel",-67,AUTHORITY["EPSG","8832"]],PARAMETER["Longitude of origin",140,AUTHORITY["EPSG","8833"]],PARAMETER["Easting at false origin",300000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",200000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","7082"]]' DESCRIPTION 'Deprecated since EPSG Dataset 9.3.';

-- Add spatial reference systems

CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2000 NAME 'Anguilla 1957 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2000 DEFINITION 'PROJCS["Anguilla 1957 / British West Indies Grid",GEOGCS["Anguilla 1957",DATUM["Anguilla 1957",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6600"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4600"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2000"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2001 NAME 'Antigua 1943 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2001 DEFINITION 'PROJCS["Antigua 1943 / British West Indies Grid",GEOGCS["Antigua 1943",DATUM["Antigua 1943",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY["EPSG","6601"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4601"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2001"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2002 NAME 'Dominica 1945 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2002 DEFINITION 'PROJCS["Dominica 1945 / British West Indies Grid",GEOGCS["Dominica 1945",DATUM["Dominica 1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY["EPSG","6602"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4602"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2002"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2003 NAME 'Grenada 1953 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2003 DEFINITION 'PROJCS["Grenada 1953 / British West Indies Grid",GEOGCS["Grenada 1953",DATUM["Grenada 1953",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY["EPSG","6603"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4603"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2003"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2004 NAME 'Montserrat 1958 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2004 DEFINITION 'PROJCS["Montserrat 1958 / British West Indies Grid",GEOGCS["Montserrat 1958",DATUM["Montserrat 1958",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[174,359,365,0,0,0,0],AUTHORITY["EPSG","6604"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4604"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2004"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2005 NAME 'St. Kitts 1955 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2005 DEFINITION 'PROJCS["St. Kitts 1955 / British West Indies Grid",GEOGCS["St. Kitts 1955",DATUM["St. Kitts 1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY["EPSG","6605"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4605"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2005"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2006 NAME 'St. Lucia 1955 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2006 DEFINITION 'PROJCS["St. Lucia 1955 / British West Indies Grid",GEOGCS["St. Lucia 1955",DATUM["St. Lucia 1955",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-153,153,307,0,0,0,0],AUTHORITY["EPSG","6606"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4606"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2006"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2007 NAME 'St. Vincent 45 / British West Indies Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2007 DEFINITION 'PROJCS["St. Vincent 45 / British West Indies Grid",GEOGCS["St. Vincent 1945",DATUM["St. Vincent 1945",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[195.671,332.517,274.607,0,0,0,0],AUTHORITY["EPSG","6607"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4607"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-62,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2007"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2009 NAME 'NAD27(CGQ77) / SCoPQ zone 3' ORGANIZATION 'EPSG' IDENTIFIED BY 2009 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 3",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-58.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2009"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2010 NAME 'NAD27(CGQ77) / SCoPQ zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2010 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 4",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2010"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2011 NAME 'NAD27(CGQ77) / SCoPQ zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2011 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 5",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2011"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2012 NAME 'NAD27(CGQ77) / SCoPQ zone 6' ORGANIZATION 'EPSG' IDENTIFIED BY 2012 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 6",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-67.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2012"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2013 NAME 'NAD27(CGQ77) / SCoPQ zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2013 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 7",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-70.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2013"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2014 NAME 'NAD27(CGQ77) / SCoPQ zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2014 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 8",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-73.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2014"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2015 NAME 'NAD27(CGQ77) / SCoPQ zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2015 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 9",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2015"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2016 NAME 'NAD27(CGQ77) / SCoPQ zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2016 DEFINITION 'PROJCS["NAD27(CGQ77) / SCoPQ zone 10",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-79.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2016"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2017 NAME 'NAD27(76) / MTM zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2017 DEFINITION 'PROJCS["NAD27(76) / MTM zone 8",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-73.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2017"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2018 NAME 'NAD27(76) / MTM zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2018 DEFINITION 'PROJCS["NAD27(76) / MTM zone 9",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2018"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2019 NAME 'NAD27(76) / MTM zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2019 DEFINITION 'PROJCS["NAD27(76) / MTM zone 10",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-79.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2019"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2020 NAME 'NAD27(76) / MTM zone 11' ORGANIZATION 'EPSG' IDENTIFIED BY 2020 DEFINITION 'PROJCS["NAD27(76) / MTM zone 11",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2020"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2021 NAME 'NAD27(76) / MTM zone 12' ORGANIZATION 'EPSG' IDENTIFIED BY 2021 DEFINITION 'PROJCS["NAD27(76) / MTM zone 12",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2021"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2022 NAME 'NAD27(76) / MTM zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2022 DEFINITION 'PROJCS["NAD27(76) / MTM zone 13",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2022"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2023 NAME 'NAD27(76) / MTM zone 14' ORGANIZATION 'EPSG' IDENTIFIED BY 2023 DEFINITION 'PROJCS["NAD27(76) / MTM zone 14",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2023"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2024 NAME 'NAD27(76) / MTM zone 15' ORGANIZATION 'EPSG' IDENTIFIED BY 2024 DEFINITION 'PROJCS["NAD27(76) / MTM zone 15",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2024"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2025 NAME 'NAD27(76) / MTM zone 16' ORGANIZATION 'EPSG' IDENTIFIED BY 2025 DEFINITION 'PROJCS["NAD27(76) / MTM zone 16",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2025"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2026 NAME 'NAD27(76) / MTM zone 17' ORGANIZATION 'EPSG' IDENTIFIED BY 2026 DEFINITION 'PROJCS["NAD27(76) / MTM zone 17",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2026"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2027 NAME 'NAD27(76) / UTM zone 15N' ORGANIZATION 'EPSG' IDENTIFIED BY 2027 DEFINITION 'PROJCS["NAD27(76) / UTM zone 15N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2027"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2028 NAME 'NAD27(76) / UTM zone 16N' ORGANIZATION 'EPSG' IDENTIFIED BY 2028 DEFINITION 'PROJCS["NAD27(76) / UTM zone 16N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2028"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2029 NAME 'NAD27(76) / UTM zone 17N' ORGANIZATION 'EPSG' IDENTIFIED BY 2029 DEFINITION 'PROJCS["NAD27(76) / UTM zone 17N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2029"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2030 NAME 'NAD27(76) / UTM zone 18N' ORGANIZATION 'EPSG' IDENTIFIED BY 2030 DEFINITION 'PROJCS["NAD27(76) / UTM zone 18N",GEOGCS["NAD27(76)",DATUM["North American Datum 1927 (1976)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6608"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4608"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2030"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2031 NAME 'NAD27(CGQ77) / UTM zone 17N' ORGANIZATION 'EPSG' IDENTIFIED BY 2031 DEFINITION 'PROJCS["NAD27(CGQ77) / UTM zone 17N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2031"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2032 NAME 'NAD27(CGQ77) / UTM zone 18N' ORGANIZATION 'EPSG' IDENTIFIED BY 2032 DEFINITION 'PROJCS["NAD27(CGQ77) / UTM zone 18N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2032"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2033 NAME 'NAD27(CGQ77) / UTM zone 19N' ORGANIZATION 'EPSG' IDENTIFIED BY 2033 DEFINITION 'PROJCS["NAD27(CGQ77) / UTM zone 19N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2033"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2034 NAME 'NAD27(CGQ77) / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2034 DEFINITION 'PROJCS["NAD27(CGQ77) / UTM zone 20N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2034"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2035 NAME 'NAD27(CGQ77) / UTM zone 21N' ORGANIZATION 'EPSG' IDENTIFIED BY 2035 DEFINITION 'PROJCS["NAD27(CGQ77) / UTM zone 21N",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2035"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2039 NAME 'Israel 1993 / Israeli TM Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2039 DEFINITION 'PROJCS["Israel 1993 / Israeli TM Grid",GEOGCS["Israel 1993",DATUM["Israel 1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-48,55,52,0,0,0,0],AUTHORITY["EPSG","6141"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4141"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31.7343936111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",35.2045169444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1.0000067,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",219529.584,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",626907.39,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2039"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2040 NAME 'Locodjo 1965 / UTM zone 30N' ORGANIZATION 'EPSG' IDENTIFIED BY 2040 DEFINITION 'PROJCS["Locodjo 1965 / UTM zone 30N",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-3,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2040"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2041 NAME 'Abidjan 1987 / UTM zone 30N' ORGANIZATION 'EPSG' IDENTIFIED BY 2041 DEFINITION 'PROJCS["Abidjan 1987 / UTM zone 30N",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-3,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2041"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2042 NAME 'Locodjo 1965 / UTM zone 29N' ORGANIZATION 'EPSG' IDENTIFIED BY 2042 DEFINITION 'PROJCS["Locodjo 1965 / UTM zone 29N",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2042"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2043 NAME 'Abidjan 1987 / UTM zone 29N' ORGANIZATION 'EPSG' IDENTIFIED BY 2043 DEFINITION 'PROJCS["Abidjan 1987 / UTM zone 29N",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2043"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2044 NAME 'Hanoi 1972 / Gauss-Kruger zone 18' ORGANIZATION 'EPSG' IDENTIFIED BY 2044 DEFINITION 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 18",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2044"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2045 NAME 'Hanoi 1972 / Gauss-Kruger zone 19' ORGANIZATION 'EPSG' IDENTIFIED BY 2045 DEFINITION 'PROJCS["Hanoi 1972 / Gauss-Kruger zone 19",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2045"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2046 NAME 'Hartebeesthoek94 / Lo15' ORGANIZATION 'EPSG' IDENTIFIED BY 2046 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo15",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2046"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2047 NAME 'Hartebeesthoek94 / Lo17' ORGANIZATION 'EPSG' IDENTIFIED BY 2047 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo17",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2047"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2048 NAME 'Hartebeesthoek94 / Lo19' ORGANIZATION 'EPSG' IDENTIFIED BY 2048 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo19",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2048"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2049 NAME 'Hartebeesthoek94 / Lo21' ORGANIZATION 'EPSG' IDENTIFIED BY 2049 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo21",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2049"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2050 NAME 'Hartebeesthoek94 / Lo23' ORGANIZATION 'EPSG' IDENTIFIED BY 2050 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo23",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",23,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2050"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2051 NAME 'Hartebeesthoek94 / Lo25' ORGANIZATION 'EPSG' IDENTIFIED BY 2051 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo25",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2051"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2052 NAME 'Hartebeesthoek94 / Lo27' ORGANIZATION 'EPSG' IDENTIFIED BY 2052 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo27",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2052"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2053 NAME 'Hartebeesthoek94 / Lo29' ORGANIZATION 'EPSG' IDENTIFIED BY 2053 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo29",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",29,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2053"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2054 NAME 'Hartebeesthoek94 / Lo31' ORGANIZATION 'EPSG' IDENTIFIED BY 2054 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo31",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",31,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2054"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2055 NAME 'Hartebeesthoek94 / Lo33' ORGANIZATION 'EPSG' IDENTIFIED BY 2055 DEFINITION 'PROJCS["Hartebeesthoek94 / Lo33",GEOGCS["Hartebeesthoek94",DATUM["Hartebeesthoek94",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6148"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4148"]],PROJECTION["Transverse Mercator (South Orientated)",AUTHORITY["EPSG","9808"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",WEST],AXIS["X",SOUTH],AUTHORITY["EPSG","2055"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2056 NAME 'CH1903+ / LV95' ORGANIZATION 'EPSG' IDENTIFIED BY 2056 DEFINITION 'PROJCS["CH1903+ / LV95",GEOGCS["CH1903+",DATUM["CH1903+",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[674.374,15.056,405.346,0,0,0,0],AUTHORITY["EPSG","6150"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4150"]],PROJECTION["Hotine Oblique Mercator (variant B)",AUTHORITY["EPSG","9815"]],PARAMETER["Latitude of projection centre",46.9524055555556,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of projection centre",7.43958333333333,AUTHORITY["EPSG","8812"]],PARAMETER["Azimuth of initial line",90,AUTHORITY["EPSG","8813"]],PARAMETER["Angle from Rectified to Skew Grid",90,AUTHORITY["EPSG","8814"]],PARAMETER["Scale factor on initial line",1,AUTHORITY["EPSG","8815"]],PARAMETER["Easting at projection centre",2600000,AUTHORITY["EPSG","8816"]],PARAMETER["Northing at projection centre",1200000,AUTHORITY["EPSG","8817"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2056"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2057 NAME 'Rassadiran / Nakhl e Taqi' ORGANIZATION 'EPSG' IDENTIFIED BY 2057 DEFINITION 'PROJCS["Rassadiran / Nakhl e Taqi",GEOGCS["Rassadiran",DATUM["Rassadiran",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-133.63,-157.5,-158.62,0,0,0,0],AUTHORITY["EPSG","6153"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4153"]],PROJECTION["Hotine Oblique Mercator (variant B)",AUTHORITY["EPSG","9815"]],PARAMETER["Latitude of projection centre",27.5188288055556,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of projection centre",52.6035391666667,AUTHORITY["EPSG","8812"]],PARAMETER["Azimuth of initial line",0.571661194444444,AUTHORITY["EPSG","8813"]],PARAMETER["Angle from Rectified to Skew Grid",0.571661194444444,AUTHORITY["EPSG","8814"]],PARAMETER["Scale factor on initial line",0.999895934,AUTHORITY["EPSG","8815"]],PARAMETER["Easting at projection centre",658377.437,AUTHORITY["EPSG","8816"]],PARAMETER["Northing at projection centre",3044969.194,AUTHORITY["EPSG","8817"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2057"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2058 NAME 'ED50(ED77) / UTM zone 38N' ORGANIZATION 'EPSG' IDENTIFIED BY 2058 DEFINITION 'PROJCS["ED50(ED77) / UTM zone 38N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2058"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2059 NAME 'ED50(ED77) / UTM zone 39N' ORGANIZATION 'EPSG' IDENTIFIED BY 2059 DEFINITION 'PROJCS["ED50(ED77) / UTM zone 39N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2059"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2060 NAME 'ED50(ED77) / UTM zone 40N' ORGANIZATION 'EPSG' IDENTIFIED BY 2060 DEFINITION 'PROJCS["ED50(ED77) / UTM zone 40N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2060"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2061 NAME 'ED50(ED77) / UTM zone 41N' ORGANIZATION 'EPSG' IDENTIFIED BY 2061 DEFINITION 'PROJCS["ED50(ED77) / UTM zone 41N",GEOGCS["ED50(ED77)",DATUM["European Datum 1950(1977)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-110.33,-97.73,-119.85,0.3423,1.1634,0.2715,0.063],AUTHORITY["EPSG","6154"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4154"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2061"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2062 NAME 'Madrid 1870 (Madrid) / Spain' ORGANIZATION 'EPSG' IDENTIFIED BY 2062 DEFINITION 'PROJCS["Madrid 1870 (Madrid) / Spain",GEOGCS["Madrid 1870 (Madrid)",DATUM["Madrid 1870 (Madrid)",SPHEROID["Struve 1860",6378298.3,294.73,AUTHORITY["EPSG","7028"]],AUTHORITY["EPSG","6903"]],PRIMEM["Madrid",-3.6879388888888895,AUTHORITY["EPSG","8905"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4903"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",0,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9988085293,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",600000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2062"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2065 NAME 'S-JTSK (Ferro) / Krovak' ORGANIZATION 'EPSG' IDENTIFIED BY 2065 DEFINITION 'PROJCS["S-JTSK (Ferro) / Krovak",GEOGCS["S-JTSK (Ferro)",DATUM["System of the Unified Trigonometrical Cadastral Network (Ferro)",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6818"]],PRIMEM["Ferro",-17.677777777777774,AUTHORITY["EPSG","8909"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4818"]],PROJECTION["Krovak",AUTHORITY["EPSG","9819"]],PARAMETER["Latitude of projection centre",49.5111111111111,AUTHORITY["EPSG","8811"]],PARAMETER["Longitude of origin",42.5111111111111,AUTHORITY["EPSG","8833"]],PARAMETER["Co-latitude of cone axis",30.2881397222222,AUTHORITY["EPSG","1036"]],PARAMETER["Latitude of pseudo standard parallel",78.5111111111111,AUTHORITY["EPSG","8818"]],PARAMETER["Scale factor on pseudo standard parallel",0.9999,AUTHORITY["EPSG","8819"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",SOUTH],AXIS["Y",WEST],AUTHORITY["EPSG","2065"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2066 NAME 'Mount Dillon / Tobago Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2066 DEFINITION 'PROJCS["Mount Dillon / Tobago Grid",GEOGCS["Mount Dillon",DATUM["Mount Dillon",SPHEROID["Clarke 1858",6378293.645208759,294.26067636926103,AUTHORITY["EPSG","7007"]],AUTHORITY["EPSG","6157"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4157"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",11.2521786111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-60.6860088888889,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",187500,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",180000,AUTHORITY["EPSG","8807"]],UNIT["Clarke\'s link",0.201166195164,AUTHORITY["EPSG","9039"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2066"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2067 NAME 'Naparima 1955 / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2067 DEFINITION 'PROJCS["Naparima 1955 / UTM zone 20N",GEOGCS["Naparima 1955",DATUM["Naparima 1955",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-0.465,372.095,171.736,0,0,0,0],AUTHORITY["EPSG","6158"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4158"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2067"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2068 NAME 'ELD79 / Libya zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2068 DEFINITION 'PROJCS["ELD79 / Libya zone 5",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2068"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2069 NAME 'ELD79 / Libya zone 6' ORGANIZATION 'EPSG' IDENTIFIED BY 2069 DEFINITION 'PROJCS["ELD79 / Libya zone 6",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",11,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2069"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2070 NAME 'ELD79 / Libya zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2070 DEFINITION 'PROJCS["ELD79 / Libya zone 7",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",13,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2070"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2071 NAME 'ELD79 / Libya zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2071 DEFINITION 'PROJCS["ELD79 / Libya zone 8",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2071"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2072 NAME 'ELD79 / Libya zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2072 DEFINITION 'PROJCS["ELD79 / Libya zone 9",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2072"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2073 NAME 'ELD79 / Libya zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2073 DEFINITION 'PROJCS["ELD79 / Libya zone 10",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2073"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2074 NAME 'ELD79 / Libya zone 11' ORGANIZATION 'EPSG' IDENTIFIED BY 2074 DEFINITION 'PROJCS["ELD79 / Libya zone 11",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2074"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2075 NAME 'ELD79 / Libya zone 12' ORGANIZATION 'EPSG' IDENTIFIED BY 2075 DEFINITION 'PROJCS["ELD79 / Libya zone 12",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",23,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2075"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2076 NAME 'ELD79 / Libya zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2076 DEFINITION 'PROJCS["ELD79 / Libya zone 13",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2076"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2077 NAME 'ELD79 / UTM zone 32N' ORGANIZATION 'EPSG' IDENTIFIED BY 2077 DEFINITION 'PROJCS["ELD79 / UTM zone 32N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2077"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2078 NAME 'ELD79 / UTM zone 33N' ORGANIZATION 'EPSG' IDENTIFIED BY 2078 DEFINITION 'PROJCS["ELD79 / UTM zone 33N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2078"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2079 NAME 'ELD79 / UTM zone 34N' ORGANIZATION 'EPSG' IDENTIFIED BY 2079 DEFINITION 'PROJCS["ELD79 / UTM zone 34N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2079"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2080 NAME 'ELD79 / UTM zone 35N' ORGANIZATION 'EPSG' IDENTIFIED BY 2080 DEFINITION 'PROJCS["ELD79 / UTM zone 35N",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2080"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2081 NAME 'Chos Malal 1914 / Argentina 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2081 DEFINITION 'PROJCS["Chos Malal 1914 / Argentina 2",GEOGCS["Chos Malal 1914",DATUM["Chos Malal 1914",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6160"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4160"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2081"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2082 NAME 'Pampa del Castillo / Argentina 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2082 DEFINITION 'PROJCS["Pampa del Castillo / Argentina 2",GEOGCS["Pampa del Castillo",DATUM["Pampa del Castillo",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[27.5,14,186.4,0,0,0,0],AUTHORITY["EPSG","6161"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4161"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2082"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2083 NAME 'Hito XVIII 1963 / Argentina 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2083 DEFINITION 'PROJCS["Hito XVIII 1963 / Argentina 2",GEOGCS["Hito XVIII 1963",DATUM["Hito XVIII 1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-90,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2083"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2084 NAME 'Hito XVIII 1963 / UTM zone 19S' ORGANIZATION 'EPSG' IDENTIFIED BY 2084 DEFINITION 'PROJCS["Hito XVIII 1963 / UTM zone 19S",GEOGCS["Hito XVIII 1963",DATUM["Hito XVIII 1963",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013],AUTHORITY["EPSG","6254"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4254"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2084"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2087 NAME 'ELD79 / TM 12 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2087 DEFINITION 'PROJCS["ELD79 / TM 12 NE",GEOGCS["ELD79",DATUM["European Libyan Datum 1979",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175],AUTHORITY["EPSG","6159"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4159"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2087"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2088 NAME 'Carthage / TM 11 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2088 DEFINITION 'PROJCS["Carthage / TM 11 NE",GEOGCS["Carthage",DATUM["Carthage",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-263,6,431,0,0,0,0],AUTHORITY["EPSG","6223"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4223"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",11,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2088"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2089 NAME 'Yemen NGN96 / UTM zone 38N' ORGANIZATION 'EPSG' IDENTIFIED BY 2089 DEFINITION 'PROJCS["Yemen NGN96 / UTM zone 38N",GEOGCS["Yemen NGN96",DATUM["Yemen National Geodetic Network 1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2089"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2090 NAME 'Yemen NGN96 / UTM zone 39N' ORGANIZATION 'EPSG' IDENTIFIED BY 2090 DEFINITION 'PROJCS["Yemen NGN96 / UTM zone 39N",GEOGCS["Yemen NGN96",DATUM["Yemen National Geodetic Network 1996",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6163"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4163"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2090"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2093 NAME 'Hanoi 1972 / GK 106 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2093 DEFINITION 'PROJCS["Hanoi 1972 / GK 106 NE",GEOGCS["Hanoi 1972",DATUM["Hanoi 1972",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY["EPSG","6147"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4147"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",106,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2093"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2094 NAME 'WGS 72BE / TM 106 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2094 DEFINITION 'PROJCS["WGS 72BE / TM 106 NE",GEOGCS["WGS 72BE",DATUM["WGS 72 Transit Broadcast Ephemeris",SPHEROID["WGS 72",6378135,298.26,AUTHORITY["EPSG","7043"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY["EPSG","6324"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4324"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",106,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2094"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2095 NAME 'Bissau / UTM zone 28N' ORGANIZATION 'EPSG' IDENTIFIED BY 2095 DEFINITION 'PROJCS["Bissau / UTM zone 28N",GEOGCS["Bissau",DATUM["Bissau",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-173,253,27,0,0,0,0],AUTHORITY["EPSG","6165"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4165"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2095"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2096 NAME 'Korean 1985 / East Belt' ORGANIZATION 'EPSG' IDENTIFIED BY 2096 DEFINITION 'PROJCS["Korean 1985 / East Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2096"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2097 NAME 'Korean 1985 / Central Belt' ORGANIZATION 'EPSG' IDENTIFIED BY 2097 DEFINITION 'PROJCS["Korean 1985 / Central Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",127,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2097"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2098 NAME 'Korean 1985 / West Belt' ORGANIZATION 'EPSG' IDENTIFIED BY 2098 DEFINITION 'PROJCS["Korean 1985 / West Belt",GEOGCS["Korean 1985",DATUM["Korean Datum 1985",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-145.907,505.034,685.756,1.162,-2.347,-1.592,6.342],AUTHORITY["EPSG","6162"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4162"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",125,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2098"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2099 NAME 'Qatar 1948 / Qatar Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2099 DEFINITION 'PROJCS["Qatar 1948 / Qatar Grid",GEOGCS["Qatar 1948",DATUM["Qatar 1948",SPHEROID["Helmert 1906",6378200,298.3,AUTHORITY["EPSG","7020"]],AUTHORITY["EPSG","6286"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4286"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",25.3823611111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",50.7613888888889,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",100000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2099"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2100 NAME 'GGRS87 / Greek Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2100 DEFINITION 'PROJCS["GGRS87 / Greek Grid",GEOGCS["GGRS87",DATUM["Greek Geodetic Reference System 1987",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-199.87,74.79,246.62,0,0,0,0],AUTHORITY["EPSG","6121"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4121"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2100"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2101 NAME 'Lake / Maracaibo Grid M1' ORGANIZATION 'EPSG' IDENTIFIED BY 2101 DEFINITION 'PROJCS["Lake / Maracaibo Grid M1",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-52684.972,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2101"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2102 NAME 'Lake / Maracaibo Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2102 DEFINITION 'PROJCS["Lake / Maracaibo Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",147315.028,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2102"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2103 NAME 'Lake / Maracaibo Grid M3' ORGANIZATION 'EPSG' IDENTIFIED BY 2103 DEFINITION 'PROJCS["Lake / Maracaibo Grid M3",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",447315.028,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2103"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2104 NAME 'Lake / Maracaibo La Rosa Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2104 DEFINITION 'PROJCS["Lake / Maracaibo La Rosa Grid",GEOGCS["Lake",DATUM["Lake",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],AUTHORITY["EPSG","6249"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4249"]],PROJECTION["Lambert Conic Conformal (1SP)",AUTHORITY["EPSG","9801"]],PARAMETER["Latitude of natural origin",10.1777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6056177777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",-17044,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-23139.97,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2104"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2105 NAME 'NZGD2000 / Mount Eden 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2105 DEFINITION 'PROJCS["NZGD2000 / Mount Eden 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-36.8797222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.764166666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2105"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2106 NAME 'NZGD2000 / Bay of Plenty 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2106 DEFINITION 'PROJCS["NZGD2000 / Bay of Plenty 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-37.7611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",176.466111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2106"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2107 NAME 'NZGD2000 / Poverty Bay 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2107 DEFINITION 'PROJCS["NZGD2000 / Poverty Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-38.6244444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177.885555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2107"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2108 NAME 'NZGD2000 / Hawkes Bay 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2108 DEFINITION 'PROJCS["NZGD2000 / Hawkes Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.6508333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",176.673611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2108"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2109 NAME 'NZGD2000 / Taranaki 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2109 DEFINITION 'PROJCS["NZGD2000 / Taranaki 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.1355555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.227777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2109"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2110 NAME 'NZGD2000 / Tuhirangi 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2110 DEFINITION 'PROJCS["NZGD2000 / Tuhirangi 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-39.5122222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2110"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2111 NAME 'NZGD2000 / Wanganui 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2111 DEFINITION 'PROJCS["NZGD2000 / Wanganui 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.2419444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.488055555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2111"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2112 NAME 'NZGD2000 / Wairarapa 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2112 DEFINITION 'PROJCS["NZGD2000 / Wairarapa 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.9252777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",175.647222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2112"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2113 NAME 'NZGD2000 / Wellington 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2113 DEFINITION 'PROJCS["NZGD2000 / Wellington 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.3011111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174.776388888889,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2113"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2114 NAME 'NZGD2000 / Collingwood 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2114 DEFINITION 'PROJCS["NZGD2000 / Collingwood 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-40.7147222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.671944444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2114"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2115 NAME 'NZGD2000 / Nelson 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2115 DEFINITION 'PROJCS["NZGD2000 / Nelson 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.2744444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.299166666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2115"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2116 NAME 'NZGD2000 / Karamea 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2116 DEFINITION 'PROJCS["NZGD2000 / Karamea 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.2897222222222,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.108888888889,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2116"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2117 NAME 'NZGD2000 / Buller 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2117 DEFINITION 'PROJCS["NZGD2000 / Buller 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.8105555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.581111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2117"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2118 NAME 'NZGD2000 / Grey 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2118 DEFINITION 'PROJCS["NZGD2000 / Grey 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.3336111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.549722222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2118"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2119 NAME 'NZGD2000 / Amuri 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2119 DEFINITION 'PROJCS["NZGD2000 / Amuri 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.6888888888889,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.01,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2119"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2120 NAME 'NZGD2000 / Marlborough 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2120 DEFINITION 'PROJCS["NZGD2000 / Marlborough 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-41.5444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173.801944444445,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2120"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2121 NAME 'NZGD2000 / Hokitika 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2121 DEFINITION 'PROJCS["NZGD2000 / Hokitika 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-42.8861111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.979722222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2121"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2122 NAME 'NZGD2000 / Okarito 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2122 DEFINITION 'PROJCS["NZGD2000 / Okarito 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.11,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.260833333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2122"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2123 NAME 'NZGD2000 / Jacksons Bay 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2123 DEFINITION 'PROJCS["NZGD2000 / Jacksons Bay 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.9777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.606111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2123"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2124 NAME 'NZGD2000 / Mount Pleasant 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2124 DEFINITION 'PROJCS["NZGD2000 / Mount Pleasant 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.5905555555556,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",172.726944444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2124"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2125 NAME 'NZGD2000 / Gawler 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2125 DEFINITION 'PROJCS["NZGD2000 / Gawler 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-43.7486111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.360555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2125"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2126 NAME 'NZGD2000 / Timaru 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2126 DEFINITION 'PROJCS["NZGD2000 / Timaru 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-44.4019444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171.057222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2126"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2127 NAME 'NZGD2000 / Lindis Peak 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2127 DEFINITION 'PROJCS["NZGD2000 / Lindis Peak 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-44.735,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",169.4675,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2127"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2128 NAME 'NZGD2000 / Mount Nicholas 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2128 DEFINITION 'PROJCS["NZGD2000 / Mount Nicholas 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.1327777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.398611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2128"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2129 NAME 'NZGD2000 / Mount York 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2129 DEFINITION 'PROJCS["NZGD2000 / Mount York 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.5636111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",167.738611111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2129"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2130 NAME 'NZGD2000 / Observation Point 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2130 DEFINITION 'PROJCS["NZGD2000 / Observation Point 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.8161111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.628333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2130"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2131 NAME 'NZGD2000 / North Taieri 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2131 DEFINITION 'PROJCS["NZGD2000 / North Taieri 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-45.8613888888889,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",170.2825,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2131"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2132 NAME 'NZGD2000 / Bluff 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2132 DEFINITION 'PROJCS["NZGD2000 / Bluff 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",-46.6111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168.342777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2132"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2133 NAME 'NZGD2000 / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2133 DEFINITION 'PROJCS["NZGD2000 / UTM zone 58S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2133"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2134 NAME 'NZGD2000 / UTM zone 59S' ORGANIZATION 'EPSG' IDENTIFIED BY 2134 DEFINITION 'PROJCS["NZGD2000 / UTM zone 59S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2134"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2135 NAME 'NZGD2000 / UTM zone 60S' ORGANIZATION 'EPSG' IDENTIFIED BY 2135 DEFINITION 'PROJCS["NZGD2000 / UTM zone 60S",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2135"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2136 NAME 'Accra / Ghana National Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2136 DEFINITION 'PROJCS["Accra / Ghana National Grid",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",4.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-1,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99975,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2136"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2137 NAME 'Accra / TM 1 NW' ORGANIZATION 'EPSG' IDENTIFIED BY 2137 DEFINITION 'PROJCS["Accra / TM 1 NW",GEOGCS["Accra",DATUM["Accra",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],TOWGS84[-199,32,322,0,0,0,0],AUTHORITY["EPSG","6168"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4168"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-1,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2137"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2138 NAME 'NAD27(CGQ77) / Quebec Lambert' ORGANIZATION 'EPSG' IDENTIFIED BY 2138 DEFINITION 'PROJCS["NAD27(CGQ77) / Quebec Lambert",GEOGCS["NAD27(CGQ77)",DATUM["North American Datum 1927 (CGQ77)",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],AUTHORITY["EPSG","6609"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4609"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-68.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",60,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",0,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2138"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2154 NAME 'RGF93 / Lambert-93' ORGANIZATION 'EPSG' IDENTIFIED BY 2154 DEFINITION 'PROJCS["RGF93 / Lambert-93",GEOGCS["RGF93",DATUM["Reseau Geodesique Francais 1993",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6171"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4171"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",46.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",3,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",700000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6600000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2154"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2157 NAME 'IRENET95 / Irish Transverse Mercator' ORGANIZATION 'EPSG' IDENTIFIED BY 2157 DEFINITION 'PROJCS["IRENET95 / Irish Transverse Mercator",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",53.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-8,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99982,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",750000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2157"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2158 NAME 'IRENET95 / UTM zone 29N' ORGANIZATION 'EPSG' IDENTIFIED BY 2158 DEFINITION 'PROJCS["IRENET95 / UTM zone 29N",GEOGCS["IRENET95",DATUM["IRENET95",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6173"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4173"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2158"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2159 NAME 'Sierra Leone 1924 / New Colony Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2159 DEFINITION 'PROJCS["Sierra Leone 1924 / New Colony Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra Leone Colony 1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",6.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2159"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2160 NAME 'Sierra Leone 1924 / New War Office Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2160 DEFINITION 'PROJCS["Sierra Leone 1924 / New War Office Grid",GEOGCS["Sierra Leone 1924",DATUM["Sierra Leone Colony 1924",SPHEROID["War Office",6378300,296,AUTHORITY["EPSG","7029"]],AUTHORITY["EPSG","6174"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4174"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",6.66666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",600000,AUTHORITY["EPSG","8807"]],UNIT["Gold Coast foot",0.3047997101815088,AUTHORITY["EPSG","9094"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2160"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2161 NAME 'Sierra Leone 1968 / UTM zone 28N' ORGANIZATION 'EPSG' IDENTIFIED BY 2161 DEFINITION 'PROJCS["Sierra Leone 1968 / UTM zone 28N",GEOGCS["Sierra Leone 1968",DATUM["Sierra Leone 1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2161"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2162 NAME 'Sierra Leone 1968 / UTM zone 29N' ORGANIZATION 'EPSG' IDENTIFIED BY 2162 DEFINITION 'PROJCS["Sierra Leone 1968 / UTM zone 29N",GEOGCS["Sierra Leone 1968",DATUM["Sierra Leone 1968",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-88,4,101,0,0,0,0],AUTHORITY["EPSG","6175"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4175"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2162"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2163 NAME 'US National Atlas Equal Area' ORGANIZATION 'EPSG' IDENTIFIED BY 2163 DEFINITION 'PROJCS["US National Atlas Equal Area",GEOGCS["Unspecified datum based upon the Clarke 1866 Authalic Sphere",DATUM["Not specified (based on Clarke 1866 Authalic Sphere)",SPHEROID["Clarke 1866 Authalic Sphere",6370997,0,AUTHORITY["EPSG","7052"]],AUTHORITY["EPSG","6052"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4052"]],PROJECTION["Lambert Azimuthal Equal Area (Spherical)",AUTHORITY["EPSG","1027"]],PARAMETER["Latitude of natural origin",45,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-100,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2163"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2164 NAME 'Locodjo 1965 / TM 5 NW' ORGANIZATION 'EPSG' IDENTIFIED BY 2164 DEFINITION 'PROJCS["Locodjo 1965 / TM 5 NW",GEOGCS["Locodjo 1965",DATUM["Locodjo 1965",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY["EPSG","6142"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4142"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2164"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2165 NAME 'Abidjan 1987 / TM 5 NW' ORGANIZATION 'EPSG' IDENTIFIED BY 2165 DEFINITION 'PROJCS["Abidjan 1987 / TM 5 NW",GEOGCS["Abidjan 1987",DATUM["Abidjan 1987",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHORITY["EPSG","6143"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4143"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2165"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2169 NAME 'Luxembourg 1930 / Gauss' ORGANIZATION 'EPSG' IDENTIFIED BY 2169 DEFINITION 'PROJCS["Luxembourg 1930 / Gauss",GEOGCS["Luxembourg 1930",DATUM["Luxembourg 1930",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-189.6806,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598],AUTHORITY["EPSG","6181"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4181"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",49.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",6.17777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",80000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2169"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2172 NAME 'Pulkovo 1942(58) / Poland zone II' ORGANIZATION 'EPSG' IDENTIFIED BY 2172 DEFINITION 'PROJCS["Pulkovo 1942(58) / Poland zone II",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",53.0019444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21.5027777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4603000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5806000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2172"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2173 NAME 'Pulkovo 1942(58) / Poland zone III' ORGANIZATION 'EPSG' IDENTIFIED BY 2173 DEFINITION 'PROJCS["Pulkovo 1942(58) / Poland zone III",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",53.5833333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17.0083333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3501000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5999000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2173"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2174 NAME 'Pulkovo 1942(58) / Poland zone IV' ORGANIZATION 'EPSG' IDENTIFIED BY 2174 DEFINITION 'PROJCS["Pulkovo 1942(58) / Poland zone IV",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",51.6708333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",16.6722222222222,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9998,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3703000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",5627000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2174"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2175 NAME 'Pulkovo 1942(58) / Poland zone V' ORGANIZATION 'EPSG' IDENTIFIED BY 2175 DEFINITION 'PROJCS["Pulkovo 1942(58) / Poland zone V",GEOGCS["Pulkovo 1942(58)",DATUM["Pulkovo 1942(58)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHORITY["EPSG","6179"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4179"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18.9583333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999983,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",237000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-4700000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2175"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2176 NAME 'ETRS89 / Poland CS2000 zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2176 DEFINITION 'PROJCS["ETRS89 / Poland CS2000 zone 5",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2176"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2177 NAME 'ETRS89 / Poland CS2000 zone 6' ORGANIZATION 'EPSG' IDENTIFIED BY 2177 DEFINITION 'PROJCS["ETRS89 / Poland CS2000 zone 6",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",6500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2177"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2178 NAME 'ETRS89 / Poland CS2000 zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2178 DEFINITION 'PROJCS["ETRS89 / Poland CS2000 zone 7",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2178"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2179 NAME 'ETRS89 / Poland CS2000 zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2179 DEFINITION 'PROJCS["ETRS89 / Poland CS2000 zone 8",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999923,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2179"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2180 NAME 'ETRS89 / Poland CS92' ORGANIZATION 'EPSG' IDENTIFIED BY 2180 DEFINITION 'PROJCS["ETRS89 / Poland CS92",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",19,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9993,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",-5300000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["x",NORTH],AXIS["y",EAST],AUTHORITY["EPSG","2180"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2188 NAME 'Azores Occidental 1939 / UTM zone 25N' ORGANIZATION 'EPSG' IDENTIFIED BY 2188 DEFINITION 'PROJCS["Azores Occidental 1939 / UTM zone 25N",GEOGCS["Azores Occidental 1939",DATUM["Azores Occidental Islands 1939",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-422.651,-172.995,84.02,0,0,0,0],AUTHORITY["EPSG","6182"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4182"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2188"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2189 NAME 'Azores Central 1948 / UTM zone 26N' ORGANIZATION 'EPSG' IDENTIFIED BY 2189 DEFINITION 'PROJCS["Azores Central 1948 / UTM zone 26N",GEOGCS["Azores Central 1948",DATUM["Azores Central Islands 1948",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-104,167,-38,0,0,0,0],AUTHORITY["EPSG","6183"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4183"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2189"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2190 NAME 'Azores Oriental 1940 / UTM zone 26N' ORGANIZATION 'EPSG' IDENTIFIED BY 2190 DEFINITION 'PROJCS["Azores Oriental 1940 / UTM zone 26N",GEOGCS["Azores Oriental 1940",DATUM["Azores Oriental Islands 1940",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-203,141,53,0,0,0,0],AUTHORITY["EPSG","6184"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4184"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2190"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2193 NAME 'NZGD2000 / New Zealand Transverse Mercator 2000' ORGANIZATION 'EPSG' IDENTIFIED BY 2193 DEFINITION 'PROJCS["NZGD2000 / New Zealand Transverse Mercator 2000",GEOGCS["NZGD2000",DATUM["New Zealand Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6167"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4167"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",173,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2193"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2195 NAME 'NAD83(HARN) / UTM zone 2S' ORGANIZATION 'EPSG' IDENTIFIED BY 2195 DEFINITION 'PROJCS["NAD83(HARN) / UTM zone 2S",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2195"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2196 NAME 'ETRS89 / Kp2000 Jutland' ORGANIZATION 'EPSG' IDENTIFIED BY 2196 DEFINITION 'PROJCS["ETRS89 / Kp2000 Jutland",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2196"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2197 NAME 'ETRS89 / Kp2000 Zealand' ORGANIZATION 'EPSG' IDENTIFIED BY 2197 DEFINITION 'PROJCS["ETRS89 / Kp2000 Zealand",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2197"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2198 NAME 'ETRS89 / Kp2000 Bornholm' ORGANIZATION 'EPSG' IDENTIFIED BY 2198 DEFINITION 'PROJCS["ETRS89 / Kp2000 Bornholm",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2198"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2200 NAME 'ATS77 / New Brunswick Stereographic (ATS77)' ORGANIZATION 'EPSG' IDENTIFIED BY 2200 DEFINITION 'PROJCS["ATS77 / New Brunswick Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",46.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-66.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2200"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2201 NAME 'REGVEN / UTM zone 18N' ORGANIZATION 'EPSG' IDENTIFIED BY 2201 DEFINITION 'PROJCS["REGVEN / UTM zone 18N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2201"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2202 NAME 'REGVEN / UTM zone 19N' ORGANIZATION 'EPSG' IDENTIFIED BY 2202 DEFINITION 'PROJCS["REGVEN / UTM zone 19N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2202"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2203 NAME 'REGVEN / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2203 DEFINITION 'PROJCS["REGVEN / UTM zone 20N",GEOGCS["REGVEN",DATUM["Red Geodesica Venezolana",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6189"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4189"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2203"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2204 NAME 'NAD27 / Tennessee' ORGANIZATION 'EPSG' IDENTIFIED BY 2204 DEFINITION 'PROJCS["NAD27 / Tennessee",GEOGCS["NAD27",DATUM["North American Datum 1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-32.3841359,180.4090461,120.8442577,-2.1545854,-0.1498782,0.5742915,8.1049164],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4267"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.4166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",100000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2204"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2205 NAME 'NAD83 / Kentucky North' ORGANIZATION 'EPSG' IDENTIFIED BY 2205 DEFINITION 'PROJCS["NAD83 / Kentucky North",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2205"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2206 NAME 'ED50 / 3-degree Gauss-Kruger zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2206 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 9",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2206"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2207 NAME 'ED50 / 3-degree Gauss-Kruger zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2207 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 10",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2207"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2208 NAME 'ED50 / 3-degree Gauss-Kruger zone 11' ORGANIZATION 'EPSG' IDENTIFIED BY 2208 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 11",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2208"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2209 NAME 'ED50 / 3-degree Gauss-Kruger zone 12' ORGANIZATION 'EPSG' IDENTIFIED BY 2209 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 12",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2209"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2210 NAME 'ED50 / 3-degree Gauss-Kruger zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2210 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 13",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2210"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2211 NAME 'ED50 / 3-degree Gauss-Kruger zone 14' ORGANIZATION 'EPSG' IDENTIFIED BY 2211 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 14",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2211"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2212 NAME 'ED50 / 3-degree Gauss-Kruger zone 15' ORGANIZATION 'EPSG' IDENTIFIED BY 2212 DEFINITION 'PROJCS["ED50 / 3-degree Gauss-Kruger zone 15",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2212"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2213 NAME 'ETRS89 / TM 30 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2213 DEFINITION 'PROJCS["ETRS89 / TM 30 NE",GEOGCS["ETRS89",DATUM["European Terrestrial Reference System 1989",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6258"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4258"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2213"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2215 NAME 'Manoca 1962 / UTM zone 32N' ORGANIZATION 'EPSG' IDENTIFIED BY 2215 DEFINITION 'PROJCS["Manoca 1962 / UTM zone 32N",GEOGCS["Manoca 1962",DATUM["Manoca 1962",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY["EPSG","6193"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4193"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2215"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2216 NAME 'Qornoq 1927 / UTM zone 22N' ORGANIZATION 'EPSG' IDENTIFIED BY 2216 DEFINITION 'PROJCS["Qornoq 1927 / UTM zone 22N",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2216"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2217 NAME 'Qornoq 1927 / UTM zone 23N' ORGANIZATION 'EPSG' IDENTIFIED BY 2217 DEFINITION 'PROJCS["Qornoq 1927 / UTM zone 23N",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2217"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2218 NAME 'Scoresbysund 1952 / Greenland zone 5 east' ORGANIZATION 'EPSG' IDENTIFIED BY 2218 DEFINITION 'PROJCS["Scoresbysund 1952 / Greenland zone 5 east",GEOGCS["Scoresbysund 1952",DATUM["Scoresbysund 1952",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[105,326,-102.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6195"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4195"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",70.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2218"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2219 NAME 'ATS77 / UTM zone 19N' ORGANIZATION 'EPSG' IDENTIFIED BY 2219 DEFINITION 'PROJCS["ATS77 / UTM zone 19N",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2219"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2220 NAME 'ATS77 / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2220 DEFINITION 'PROJCS["ATS77 / UTM zone 20N",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2220"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2221 NAME 'Scoresbysund 1952 / Greenland zone 6 east' ORGANIZATION 'EPSG' IDENTIFIED BY 2221 DEFINITION 'PROJCS["Scoresbysund 1952 / Greenland zone 6 east",GEOGCS["Scoresbysund 1952",DATUM["Scoresbysund 1952",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[105,326,-102.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6195"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4195"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",67.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-32,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2221"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2222 NAME 'NAD83 / Arizona East (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2222 DEFINITION 'PROJCS["NAD83 / Arizona East (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2222"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2223 NAME 'NAD83 / Arizona Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2223 DEFINITION 'PROJCS["NAD83 / Arizona Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111.927777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2223"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2224 NAME 'NAD83 / Arizona West (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2224 DEFINITION 'PROJCS["NAD83 / Arizona West (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-113.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2224"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2225 NAME 'NAD83 / California zone 1 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2225 DEFINITION 'PROJCS["NAD83 / California zone 1 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2225"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2226 NAME 'NAD83 / California zone 2 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2226 DEFINITION 'PROJCS["NAD83 / California zone 2 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2226"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2227 NAME 'NAD83 / California zone 3 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2227 DEFINITION 'PROJCS["NAD83 / California zone 3 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2227"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2228 NAME 'NAD83 / California zone 4 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2228 DEFINITION 'PROJCS["NAD83 / California zone 4 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-119,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2228"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2229 NAME 'NAD83 / California zone 5 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2229 DEFINITION 'PROJCS["NAD83 / California zone 5 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-118,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.4666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2229"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2230 NAME 'NAD83 / California zone 6 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2230 DEFINITION 'PROJCS["NAD83 / California zone 6 (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-116.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2230"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2231 NAME 'NAD83 / Colorado North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2231 DEFINITION 'PROJCS["NAD83 / Colorado North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2231"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2232 NAME 'NAD83 / Colorado Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2232 DEFINITION 'PROJCS["NAD83 / Colorado Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.75,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2232"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2233 NAME 'NAD83 / Colorado South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2233 DEFINITION 'PROJCS["NAD83 / Colorado South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2233"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2234 NAME 'NAD83 / Connecticut (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2234 DEFINITION 'PROJCS["NAD83 / Connecticut (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-72.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.8666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2234"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2235 NAME 'NAD83 / Delaware (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2235 DEFINITION 'PROJCS["NAD83 / Delaware (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75.4166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2235"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2236 NAME 'NAD83 / Florida East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2236 DEFINITION 'PROJCS["NAD83 / Florida East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2236"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2237 NAME 'NAD83 / Florida West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2237 DEFINITION 'PROJCS["NAD83 / Florida West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2237"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2238 NAME 'NAD83 / Florida North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2238 DEFINITION 'PROJCS["NAD83 / Florida North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.5833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2238"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2239 NAME 'NAD83 / Georgia East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2239 DEFINITION 'PROJCS["NAD83 / Georgia East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2239"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2240 NAME 'NAD83 / Georgia West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2240 DEFINITION 'PROJCS["NAD83 / Georgia West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2240"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2241 NAME 'NAD83 / Idaho East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2241 DEFINITION 'PROJCS["NAD83 / Idaho East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-112.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2241"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2242 NAME 'NAD83 / Idaho Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2242 DEFINITION 'PROJCS["NAD83 / Idaho Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2242"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2243 NAME 'NAD83 / Idaho West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2243 DEFINITION 'PROJCS["NAD83 / Idaho West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2624666.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2243"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2246 NAME 'NAD83 / Kentucky North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2246 DEFINITION 'PROJCS["NAD83 / Kentucky North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2246"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2247 NAME 'NAD83 / Kentucky South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2247 DEFINITION 'PROJCS["NAD83 / Kentucky South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-85.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2247"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2248 NAME 'NAD83 / Maryland (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2248 DEFINITION 'PROJCS["NAD83 / Maryland (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.45,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1312333.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2248"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2249 NAME 'NAD83 / Massachusetts Mainland (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2249 DEFINITION 'PROJCS["NAD83 / Massachusetts Mainland (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-71.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",42.6944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2460625,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2249"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2250 NAME 'NAD83 / Massachusetts Island (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2250 DEFINITION 'PROJCS["NAD83 / Massachusetts Island (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-70.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2250"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2251 NAME 'NAD83 / Michigan North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2251 DEFINITION 'PROJCS["NAD83 / Michigan North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.7944444444444,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-87,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.0944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.4944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",26246719.16,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2251"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2252 NAME 'NAD83 / Michigan Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2252 DEFINITION 'PROJCS["NAD83 / Michigan Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.3277777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",19685039.37,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2252"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2253 NAME 'NAD83 / Michigan South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2253 DEFINITION 'PROJCS["NAD83 / Michigan South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.1,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",13123359.58,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2253"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2254 NAME 'NAD83 / Mississippi East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2254 DEFINITION 'PROJCS["NAD83 / Mississippi East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",984250,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2254"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2255 NAME 'NAD83 / Mississippi West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2255 DEFINITION 'PROJCS["NAD83 / Mississippi West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2255"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2256 NAME 'NAD83 / Montana (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2256 DEFINITION 'PROJCS["NAD83 / Montana (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.2611111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-109.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2256"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2257 NAME 'NAD83 / New Mexico East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2257 DEFINITION 'PROJCS["NAD83 / New Mexico East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-104.333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999909091,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",541337.5,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2257"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2258 NAME 'NAD83 / New Mexico Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2258 DEFINITION 'PROJCS["NAD83 / New Mexico Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-106.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2258"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2259 NAME 'NAD83 / New Mexico West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2259 DEFINITION 'PROJCS["NAD83 / New Mexico West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-107.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999916667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2723091.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2259"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2260 NAME 'NAD83 / New York East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2260 DEFINITION 'PROJCS["NAD83 / New York East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-74.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",492125,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2260"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2261 NAME 'NAD83 / New York Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2261 DEFINITION 'PROJCS["NAD83 / New York Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",820208.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2261"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2262 NAME 'NAD83 / New York West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2262 DEFINITION 'PROJCS["NAD83 / New York West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-78.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1148291.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2262"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2263 NAME 'NAD83 / New York Long Island (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2263 DEFINITION 'PROJCS["NAD83 / New York Long Island (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-74,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.0333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2263"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2264 NAME 'NAD83 / North Carolina (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2264 DEFINITION 'PROJCS["NAD83 / North Carolina (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-79,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2264"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2265 NAME 'NAD83 / North Dakota North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2265 DEFINITION 'PROJCS["NAD83 / North Dakota North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.4444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2265"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2266 NAME 'NAD83 / North Dakota South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2266 DEFINITION 'PROJCS["NAD83 / North Dakota South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2266"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2267 NAME 'NAD83 / Oklahoma North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2267 DEFINITION 'PROJCS["NAD83 / Oklahoma North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2267"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2268 NAME 'NAD83 / Oklahoma South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2268 DEFINITION 'PROJCS["NAD83 / Oklahoma South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2268"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2269 NAME 'NAD83 / Oregon North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2269 DEFINITION 'PROJCS["NAD83 / Oregon North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",8202099.738,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2269"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2270 NAME 'NAD83 / Oregon South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2270 DEFINITION 'PROJCS["NAD83 / Oregon South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",4921259.843,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2270"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2271 NAME 'NAD83 / Pennsylvania North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2271 DEFINITION 'PROJCS["NAD83 / Pennsylvania North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.95,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.8833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2271"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2272 NAME 'NAD83 / Pennsylvania South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2272 DEFINITION 'PROJCS["NAD83 / Pennsylvania South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2272"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2273 NAME 'NAD83 / South Carolina (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2273 DEFINITION 'PROJCS["NAD83 / South Carolina (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-81,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",34.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2273"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2274 NAME 'NAD83 / Tennessee (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2274 DEFINITION 'PROJCS["NAD83 / Tennessee (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.4166666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2274"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2275 NAME 'NAD83 / Texas North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2275 DEFINITION 'PROJCS["NAD83 / Texas North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-101.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.65,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2275"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2276 NAME 'NAD83 / Texas North Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2276 DEFINITION 'PROJCS["NAD83 / Texas North Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.1444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2276"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2277 NAME 'NAD83 / Texas Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2277 DEFINITION 'PROJCS["NAD83 / Texas Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",31.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",30.1166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2296583.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842500,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2277"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2278 NAME 'NAD83 / Texas South Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2278 DEFINITION 'PROJCS["NAD83 / Texas South Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",27.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-99,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.2833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",28.3833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",13123333.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2278"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2279 NAME 'NAD83 / Texas South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2279 DEFINITION 'PROJCS["NAD83 / Texas South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",27.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",26.1666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",16404166.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2279"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2280 NAME 'NAD83 / Utah North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2280 DEFINITION 'PROJCS["NAD83 / Utah North (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280839.895,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2280"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2281 NAME 'NAD83 / Utah Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2281 DEFINITION 'PROJCS["NAD83 / Utah Central (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.65,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.0277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561679.79,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2281"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2282 NAME 'NAD83 / Utah South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2282 DEFINITION 'PROJCS["NAD83 / Utah South (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.35,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842519.685,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2282"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2283 NAME 'NAD83 / Virginia North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2283 DEFINITION 'PROJCS["NAD83 / Virginia North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.2111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2283"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2284 NAME 'NAD83 / Virginia South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2284 DEFINITION 'PROJCS["NAD83 / Virginia South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2284"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2285 NAME 'NAD83 / Washington North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2285 DEFINITION 'PROJCS["NAD83 / Washington North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.833333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2285"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2286 NAME 'NAD83 / Washington South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2286 DEFINITION 'PROJCS["NAD83 / Washington South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.3333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.8333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2286"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2287 NAME 'NAD83 / Wisconsin North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2287 DEFINITION 'PROJCS["NAD83 / Wisconsin North (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2287"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2288 NAME 'NAD83 / Wisconsin Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2288 DEFINITION 'PROJCS["NAD83 / Wisconsin Central (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.5111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2288"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2289 NAME 'NAD83 / Wisconsin South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2289 DEFINITION 'PROJCS["NAD83 / Wisconsin South (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",42,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44.0777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2289"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2290 NAME 'ATS77 / Prince Edward Isl. Stereographic (ATS77)' ORGANIZATION 'EPSG' IDENTIFIED BY 2290 DEFINITION 'PROJCS["ATS77 / Prince Edward Isl. Stereographic (ATS77)",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",47.2611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",400000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2290"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2294 NAME 'ATS77 / MTM Nova Scotia zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2294 DEFINITION 'PROJCS["ATS77 / MTM Nova Scotia zone 4",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2294"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2295 NAME 'ATS77 / MTM Nova Scotia zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2295 DEFINITION 'PROJCS["ATS77 / MTM Nova Scotia zone 5",GEOGCS["ATS77",DATUM["Average Terrestrial System 1977",SPHEROID["Average Terrestrial System 1977",6378135,298.257,AUTHORITY["EPSG","7041"]],AUTHORITY["EPSG","6122"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4122"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2295"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2296 NAME 'Ammassalik 1958 / Greenland zone 7 east' ORGANIZATION 'EPSG' IDENTIFIED BY 2296 DEFINITION 'PROJCS["Ammassalik 1958 / Greenland zone 7 east",GEOGCS["Ammassalik 1958",DATUM["Ammassalik 1958",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-45,417,-3.5,0,0,0.814,-0.6],AUTHORITY["EPSG","6196"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4196"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",64.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-40,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2296"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2299 NAME 'Qornoq 1927 / Greenland zone 2 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2299 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 2 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",79.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2299"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2301 NAME 'Qornoq 1927 / Greenland zone 3 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2301 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 3 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",76.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2301"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2303 NAME 'Qornoq 1927 / Greenland zone 4 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2303 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 4 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",73.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2303"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2304 NAME 'Qornoq 1927 / Greenland zone 5 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2304 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 5 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",70.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2304"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2305 NAME 'Qornoq 1927 / Greenland zone 6 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2305 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 6 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",67.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2305"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2306 NAME 'Qornoq 1927 / Greenland zone 7 west' ORGANIZATION 'EPSG' IDENTIFIED BY 2306 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 7 west",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",64.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-52,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2306"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2307 NAME 'Qornoq 1927 / Greenland zone 8 east' ORGANIZATION 'EPSG' IDENTIFIED BY 2307 DEFINITION 'PROJCS["Qornoq 1927 / Greenland zone 8 east",GEOGCS["Qornoq 1927",DATUM["Qornoq 1927",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[163.511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY["EPSG","6194"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4194"]],PROJECTION["Lambert Conic Conformal (West Orientated)",AUTHORITY["EPSG","9826"]],PARAMETER["Latitude of natural origin",61.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Y",NORTH],AXIS["X",WEST],AUTHORITY["EPSG","2307"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2308 NAME 'Batavia / TM 109 SE' ORGANIZATION 'EPSG' IDENTIFIED BY 2308 DEFINITION 'PROJCS["Batavia / TM 109 SE",GEOGCS["Batavia",DATUM["Batavia",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-377.7,675.1,-52.2,0,0,0,0],AUTHORITY["EPSG","6211"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4211"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",109,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2308"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2309 NAME 'WGS 84 / TM 116 SE' ORGANIZATION 'EPSG' IDENTIFIED BY 2309 DEFINITION 'PROJCS["WGS 84 / TM 116 SE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",116,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2309"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2310 NAME 'WGS 84 / TM 132 SE' ORGANIZATION 'EPSG' IDENTIFIED BY 2310 DEFINITION 'PROJCS["WGS 84 / TM 132 SE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2310"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2311 NAME 'WGS 84 / TM 6 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2311 DEFINITION 'PROJCS["WGS 84 / TM 6 NE",GEOGCS["WGS 84",DATUM["World Geodetic System 1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4326"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",6,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2311"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2312 NAME 'Garoua / UTM zone 33N' ORGANIZATION 'EPSG' IDENTIFIED BY 2312 DEFINITION 'PROJCS["Garoua / UTM zone 33N",GEOGCS["Garoua",DATUM["Garoua",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6197"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4197"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2312"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2313 NAME 'Kousseri / UTM zone 33N' ORGANIZATION 'EPSG' IDENTIFIED BY 2313 DEFINITION 'PROJCS["Kousseri / UTM zone 33N",GEOGCS["Kousseri",DATUM["Kousseri",SPHEROID["Clarke 1880 (RGS)",6378249.145,293.465,AUTHORITY["EPSG","7012"]],AUTHORITY["EPSG","6198"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4198"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2313"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2314 NAME 'Trinidad 1903 / Trinidad Grid (ftCla)' ORGANIZATION 'EPSG' IDENTIFIED BY 2314 DEFINITION 'PROJCS["Trinidad 1903 / Trinidad Grid (ftCla)",GEOGCS["Trinidad 1903",DATUM["Trinidad 1903",SPHEROID["Clarke 1858",6378293.645208759,294.26067636926103,AUTHORITY["EPSG","7007"]],TOWGS84[-61.702,284.488,472.052,0,0,0,0],AUTHORITY["EPSG","6302"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4302"]],PROJECTION["Cassini-Soldner",AUTHORITY["EPSG","9806"]],PARAMETER["Latitude of natural origin",10.4416666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",283800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",214500,AUTHORITY["EPSG","8807"]],UNIT["Clarke\'s foot",0.3047972654,AUTHORITY["EPSG","9005"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2314"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2315 NAME 'Campo Inchauspe / UTM zone 19S' ORGANIZATION 'EPSG' IDENTIFIED BY 2315 DEFINITION 'PROJCS["Campo Inchauspe / UTM zone 19S",GEOGCS["Campo Inchauspe",DATUM["Campo Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2315"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2316 NAME 'Campo Inchauspe / UTM zone 20S' ORGANIZATION 'EPSG' IDENTIFIED BY 2316 DEFINITION 'PROJCS["Campo Inchauspe / UTM zone 20S",GEOGCS["Campo Inchauspe",DATUM["Campo Inchauspe",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY["EPSG","6221"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4221"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2316"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2317 NAME 'PSAD56 / ICN Regional' ORGANIZATION 'EPSG' IDENTIFIED BY 2317 DEFINITION 'PROJCS["PSAD56 / ICN Regional",GEOGCS["PSAD56",DATUM["Provisional South American Datum 1956",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-60.31,245.935,31.008,12.324,3.755,-7.37,0.447],AUTHORITY["EPSG","6248"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4248"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",6,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-66,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",9,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",3,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2317"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2318 NAME 'Ain el Abd / Aramco Lambert' ORGANIZATION 'EPSG' IDENTIFIED BY 2318 DEFINITION 'PROJCS["Ain el Abd / Aramco Lambert",GEOGCS["Ain el Abd",DATUM["Ain el Abd 1970",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-18.944,-379.364,-24.063,0.04,-0.764,6.431,3.657],AUTHORITY["EPSG","6204"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4204"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.08951,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",48,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",17,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",0,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2318"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2319 NAME 'ED50 / TM27' ORGANIZATION 'EPSG' IDENTIFIED BY 2319 DEFINITION 'PROJCS["ED50 / TM27",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2319"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2320 NAME 'ED50 / TM30' ORGANIZATION 'EPSG' IDENTIFIED BY 2320 DEFINITION 'PROJCS["ED50 / TM30",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2320"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2321 NAME 'ED50 / TM33' ORGANIZATION 'EPSG' IDENTIFIED BY 2321 DEFINITION 'PROJCS["ED50 / TM33",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2321"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2322 NAME 'ED50 / TM36' ORGANIZATION 'EPSG' IDENTIFIED BY 2322 DEFINITION 'PROJCS["ED50 / TM36",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2322"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2323 NAME 'ED50 / TM39' ORGANIZATION 'EPSG' IDENTIFIED BY 2323 DEFINITION 'PROJCS["ED50 / TM39",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2323"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2324 NAME 'ED50 / TM42' ORGANIZATION 'EPSG' IDENTIFIED BY 2324 DEFINITION 'PROJCS["ED50 / TM42",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2324"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2325 NAME 'ED50 / TM45' ORGANIZATION 'EPSG' IDENTIFIED BY 2325 DEFINITION 'PROJCS["ED50 / TM45",GEOGCS["ED50",DATUM["European Datum 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-157.89,-17.16,-78.41,2.118,2.697,-1.434,-5.38],AUTHORITY["EPSG","6230"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4230"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2325"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2326 NAME 'Hong Kong 1980 Grid System' ORGANIZATION 'EPSG' IDENTIFIED BY 2326 DEFINITION 'PROJCS["Hong Kong 1980 Grid System",GEOGCS["Hong Kong 1980",DATUM["Hong Kong 1980",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246],AUTHORITY["EPSG","6611"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4611"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",22.3121333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114.178555555556,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",836694.05,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",819069.8,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2326"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2327 NAME 'Xian 1980 / Gauss-Kruger zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2327 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 13",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2327"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2328 NAME 'Xian 1980 / Gauss-Kruger zone 14' ORGANIZATION 'EPSG' IDENTIFIED BY 2328 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 14",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2328"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2329 NAME 'Xian 1980 / Gauss-Kruger zone 15' ORGANIZATION 'EPSG' IDENTIFIED BY 2329 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 15",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2329"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2330 NAME 'Xian 1980 / Gauss-Kruger zone 16' ORGANIZATION 'EPSG' IDENTIFIED BY 2330 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 16",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2330"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2331 NAME 'Xian 1980 / Gauss-Kruger zone 17' ORGANIZATION 'EPSG' IDENTIFIED BY 2331 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 17",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2331"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2332 NAME 'Xian 1980 / Gauss-Kruger zone 18' ORGANIZATION 'EPSG' IDENTIFIED BY 2332 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 18",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2332"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2333 NAME 'Xian 1980 / Gauss-Kruger zone 19' ORGANIZATION 'EPSG' IDENTIFIED BY 2333 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 19",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2333"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2334 NAME 'Xian 1980 / Gauss-Kruger zone 20' ORGANIZATION 'EPSG' IDENTIFIED BY 2334 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 20",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2334"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2335 NAME 'Xian 1980 / Gauss-Kruger zone 21' ORGANIZATION 'EPSG' IDENTIFIED BY 2335 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 21",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2335"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2336 NAME 'Xian 1980 / Gauss-Kruger zone 22' ORGANIZATION 'EPSG' IDENTIFIED BY 2336 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 22",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2336"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2337 NAME 'Xian 1980 / Gauss-Kruger zone 23' ORGANIZATION 'EPSG' IDENTIFIED BY 2337 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger zone 23",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2337"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2338 NAME 'Xian 1980 / Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2338 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2338"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2339 NAME 'Xian 1980 / Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2339 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2339"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2340 NAME 'Xian 1980 / Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2340 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2340"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2341 NAME 'Xian 1980 / Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2341 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2341"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2342 NAME 'Xian 1980 / Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2342 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2342"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2343 NAME 'Xian 1980 / Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2343 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2343"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2344 NAME 'Xian 1980 / Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2344 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2344"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2345 NAME 'Xian 1980 / Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2345 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2345"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2346 NAME 'Xian 1980 / Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2346 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2346"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2347 NAME 'Xian 1980 / Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2347 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2347"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2348 NAME 'Xian 1980 / Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2348 DEFINITION 'PROJCS["Xian 1980 / Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2348"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2349 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 25' ORGANIZATION 'EPSG' IDENTIFIED BY 2349 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 25",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2349"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2350 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 26' ORGANIZATION 'EPSG' IDENTIFIED BY 2350 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 26",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2350"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2351 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 27' ORGANIZATION 'EPSG' IDENTIFIED BY 2351 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 27",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2351"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2352 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 28' ORGANIZATION 'EPSG' IDENTIFIED BY 2352 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 28",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2352"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2353 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 29' ORGANIZATION 'EPSG' IDENTIFIED BY 2353 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 29",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2353"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2354 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 30' ORGANIZATION 'EPSG' IDENTIFIED BY 2354 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 30",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2354"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2355 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 31' ORGANIZATION 'EPSG' IDENTIFIED BY 2355 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 31",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2355"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2356 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 32' ORGANIZATION 'EPSG' IDENTIFIED BY 2356 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 32",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2356"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2357 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 33' ORGANIZATION 'EPSG' IDENTIFIED BY 2357 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 33",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2357"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2358 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 34' ORGANIZATION 'EPSG' IDENTIFIED BY 2358 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 34",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2358"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2359 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 35' ORGANIZATION 'EPSG' IDENTIFIED BY 2359 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 35",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2359"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2360 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 36' ORGANIZATION 'EPSG' IDENTIFIED BY 2360 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 36",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2360"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2361 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 37' ORGANIZATION 'EPSG' IDENTIFIED BY 2361 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 37",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2361"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2362 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 38' ORGANIZATION 'EPSG' IDENTIFIED BY 2362 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 38",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2362"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2363 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 39' ORGANIZATION 'EPSG' IDENTIFIED BY 2363 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 39",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2363"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2364 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 40' ORGANIZATION 'EPSG' IDENTIFIED BY 2364 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 40",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2364"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2365 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 41' ORGANIZATION 'EPSG' IDENTIFIED BY 2365 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 41",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2365"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2366 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 42' ORGANIZATION 'EPSG' IDENTIFIED BY 2366 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 42",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2366"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2367 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 43' ORGANIZATION 'EPSG' IDENTIFIED BY 2367 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 43",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2367"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2368 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 44' ORGANIZATION 'EPSG' IDENTIFIED BY 2368 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 44",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2368"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2369 NAME 'Xian 1980 / 3-degree Gauss-Kruger zone 45' ORGANIZATION 'EPSG' IDENTIFIED BY 2369 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger zone 45",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2369"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2370 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2370 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2370"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2371 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 78E' ORGANIZATION 'EPSG' IDENTIFIED BY 2371 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2371"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2372 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2372 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2372"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2373 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 84E' ORGANIZATION 'EPSG' IDENTIFIED BY 2373 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2373"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2374 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2374 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2374"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2375 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 90E' ORGANIZATION 'EPSG' IDENTIFIED BY 2375 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2375"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2376 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2376 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2376"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2377 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 96E' ORGANIZATION 'EPSG' IDENTIFIED BY 2377 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2377"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2378 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2378 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2378"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2379 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 102E' ORGANIZATION 'EPSG' IDENTIFIED BY 2379 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2379"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2380 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2380 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2380"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2381 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 108E' ORGANIZATION 'EPSG' IDENTIFIED BY 2381 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2381"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2382 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2382 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2382"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2383 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 114E' ORGANIZATION 'EPSG' IDENTIFIED BY 2383 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2383"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2384 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2384 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2384"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2385 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 120E' ORGANIZATION 'EPSG' IDENTIFIED BY 2385 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2385"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2386 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2386 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2386"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2387 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 126E' ORGANIZATION 'EPSG' IDENTIFIED BY 2387 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2387"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2388 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2388 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2388"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2389 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 132E' ORGANIZATION 'EPSG' IDENTIFIED BY 2389 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2389"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2390 NAME 'Xian 1980 / 3-degree Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2390 DEFINITION 'PROJCS["Xian 1980 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Xian 1980",DATUM["Xian 1980",SPHEROID["IAG 1975",6378140,298.257,AUTHORITY["EPSG","7049"]],AUTHORITY["EPSG","6610"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4610"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2390"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2391 NAME 'KKJ / Finland zone 1' ORGANIZATION 'EPSG' IDENTIFIED BY 2391 DEFINITION 'PROJCS["KKJ / Finland zone 1",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2391"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2392 NAME 'KKJ / Finland zone 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2392 DEFINITION 'PROJCS["KKJ / Finland zone 2",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2392"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2393 NAME 'KKJ / Finland Uniform Coordinate System' ORGANIZATION 'EPSG' IDENTIFIED BY 2393 DEFINITION 'PROJCS["KKJ / Finland Uniform Coordinate System",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2393"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2394 NAME 'KKJ / Finland zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2394 DEFINITION 'PROJCS["KKJ / Finland zone 4",GEOGCS["KKJ",DATUM["Kartastokoordinaattijarjestelma (1966)",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496],AUTHORITY["EPSG","6123"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4123"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2394"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2395 NAME 'South Yemen / Gauss-Kruger zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2395 DEFINITION 'PROJCS["South Yemen / Gauss-Kruger zone 8",GEOGCS["South Yemen",DATUM["South Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2395"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2396 NAME 'South Yemen / Gauss-Kruger zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2396 DEFINITION 'PROJCS["South Yemen / Gauss-Kruger zone 9",GEOGCS["South Yemen",DATUM["South Yemen",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY["EPSG","6164"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4164"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2396"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2397 NAME 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3' ORGANIZATION 'EPSG' IDENTIFIED BY 2397 DEFINITION 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2397"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2398 NAME 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2398 DEFINITION 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2398"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2399 NAME 'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2399 DEFINITION 'PROJCS["Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5",GEOGCS["Pulkovo 1942(83)",DATUM["Pulkovo 1942(83)",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1],AUTHORITY["EPSG","6178"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4178"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",5500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2399"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2401 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 25' ORGANIZATION 'EPSG' IDENTIFIED BY 2401 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 25",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2401"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2402 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 26' ORGANIZATION 'EPSG' IDENTIFIED BY 2402 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 26",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2402"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2403 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 27' ORGANIZATION 'EPSG' IDENTIFIED BY 2403 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 27",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2403"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2404 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 28' ORGANIZATION 'EPSG' IDENTIFIED BY 2404 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 28",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2404"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2405 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 29' ORGANIZATION 'EPSG' IDENTIFIED BY 2405 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 29",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2405"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2406 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 30' ORGANIZATION 'EPSG' IDENTIFIED BY 2406 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 30",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2406"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2407 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 31' ORGANIZATION 'EPSG' IDENTIFIED BY 2407 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 31",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2407"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2408 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 32' ORGANIZATION 'EPSG' IDENTIFIED BY 2408 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 32",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2408"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2409 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 33' ORGANIZATION 'EPSG' IDENTIFIED BY 2409 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 33",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2409"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2410 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 34' ORGANIZATION 'EPSG' IDENTIFIED BY 2410 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 34",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2410"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2411 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 35' ORGANIZATION 'EPSG' IDENTIFIED BY 2411 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 35",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2411"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2412 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 36' ORGANIZATION 'EPSG' IDENTIFIED BY 2412 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 36",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2412"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2413 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 37' ORGANIZATION 'EPSG' IDENTIFIED BY 2413 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 37",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2413"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2414 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 38' ORGANIZATION 'EPSG' IDENTIFIED BY 2414 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 38",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2414"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2415 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 39' ORGANIZATION 'EPSG' IDENTIFIED BY 2415 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 39",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2415"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2416 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 40' ORGANIZATION 'EPSG' IDENTIFIED BY 2416 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 40",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2416"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2417 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 41' ORGANIZATION 'EPSG' IDENTIFIED BY 2417 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 41",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2417"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2418 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 42' ORGANIZATION 'EPSG' IDENTIFIED BY 2418 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 42",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2418"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2419 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 43' ORGANIZATION 'EPSG' IDENTIFIED BY 2419 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 43",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2419"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2420 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 44' ORGANIZATION 'EPSG' IDENTIFIED BY 2420 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 44",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2420"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2421 NAME 'Beijing 1954 / 3-degree Gauss-Kruger zone 45' ORGANIZATION 'EPSG' IDENTIFIED BY 2421 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger zone 45",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2421"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2422 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2422 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2422"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2423 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 78E' ORGANIZATION 'EPSG' IDENTIFIED BY 2423 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2423"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2424 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2424 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2424"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2425 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 84E' ORGANIZATION 'EPSG' IDENTIFIED BY 2425 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2425"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2426 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2426 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2426"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2427 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 90E' ORGANIZATION 'EPSG' IDENTIFIED BY 2427 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2427"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2428 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2428 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2428"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2429 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 96E' ORGANIZATION 'EPSG' IDENTIFIED BY 2429 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2429"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2430 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2430 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2430"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2431 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 102E' ORGANIZATION 'EPSG' IDENTIFIED BY 2431 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2431"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2432 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2432 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2432"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2433 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 108E' ORGANIZATION 'EPSG' IDENTIFIED BY 2433 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2433"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2434 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2434 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2434"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2435 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 114E' ORGANIZATION 'EPSG' IDENTIFIED BY 2435 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2435"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2436 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2436 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2436"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2437 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 120E' ORGANIZATION 'EPSG' IDENTIFIED BY 2437 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2437"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2438 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2438 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2438"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2439 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 126E' ORGANIZATION 'EPSG' IDENTIFIED BY 2439 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2439"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2440 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2440 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2440"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2441 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 132E' ORGANIZATION 'EPSG' IDENTIFIED BY 2441 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2441"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2442 NAME 'Beijing 1954 / 3-degree Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2442 DEFINITION 'PROJCS["Beijing 1954 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Beijing 1954",DATUM["Beijing 1954",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[18,-136.8,-73.7,0,0,0.814,-0.38],AUTHORITY["EPSG","6214"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4214"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2442"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2443 NAME 'JGD2000 / Japan Plane Rectangular CS I' ORGANIZATION 'EPSG' IDENTIFIED BY 2443 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS I",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2443"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2444 NAME 'JGD2000 / Japan Plane Rectangular CS II' ORGANIZATION 'EPSG' IDENTIFIED BY 2444 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS II",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",131,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2444"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2445 NAME 'JGD2000 / Japan Plane Rectangular CS III' ORGANIZATION 'EPSG' IDENTIFIED BY 2445 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS III",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2445"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2446 NAME 'JGD2000 / Japan Plane Rectangular CS IV' ORGANIZATION 'EPSG' IDENTIFIED BY 2446 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS IV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",33,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",133.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2446"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2447 NAME 'JGD2000 / Japan Plane Rectangular CS V' ORGANIZATION 'EPSG' IDENTIFIED BY 2447 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS V",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",134.344444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2447"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2448 NAME 'JGD2000 / Japan Plane Rectangular CS VI' ORGANIZATION 'EPSG' IDENTIFIED BY 2448 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS VI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",136,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2448"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2449 NAME 'JGD2000 / Japan Plane Rectangular CS VII' ORGANIZATION 'EPSG' IDENTIFIED BY 2449 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS VII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",137.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2449"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2450 NAME 'JGD2000 / Japan Plane Rectangular CS VIII' ORGANIZATION 'EPSG' IDENTIFIED BY 2450 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS VIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2450"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2451 NAME 'JGD2000 / Japan Plane Rectangular CS IX' ORGANIZATION 'EPSG' IDENTIFIED BY 2451 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS IX",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",139.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2451"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2452 NAME 'JGD2000 / Japan Plane Rectangular CS X' ORGANIZATION 'EPSG' IDENTIFIED BY 2452 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS X",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",140.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2452"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2453 NAME 'JGD2000 / Japan Plane Rectangular CS XI' ORGANIZATION 'EPSG' IDENTIFIED BY 2453 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",140.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2453"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2454 NAME 'JGD2000 / Japan Plane Rectangular CS XII' ORGANIZATION 'EPSG' IDENTIFIED BY 2454 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",142.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2454"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2455 NAME 'JGD2000 / Japan Plane Rectangular CS XIII' ORGANIZATION 'EPSG' IDENTIFIED BY 2455 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",44,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2455"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2456 NAME 'JGD2000 / Japan Plane Rectangular CS XIV' ORGANIZATION 'EPSG' IDENTIFIED BY 2456 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",142,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2456"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2457 NAME 'JGD2000 / Japan Plane Rectangular CS XV' ORGANIZATION 'EPSG' IDENTIFIED BY 2457 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XV",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",127.511111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2457"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2458 NAME 'JGD2000 / Japan Plane Rectangular CS XVI' ORGANIZATION 'EPSG' IDENTIFIED BY 2458 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVI",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",124,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2458"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2459 NAME 'JGD2000 / Japan Plane Rectangular CS XVII' ORGANIZATION 'EPSG' IDENTIFIED BY 2459 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",131,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2459"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2460 NAME 'JGD2000 / Japan Plane Rectangular CS XVIII' ORGANIZATION 'EPSG' IDENTIFIED BY 2460 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XVIII",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",20,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",136,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2460"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2461 NAME 'JGD2000 / Japan Plane Rectangular CS XIX' ORGANIZATION 'EPSG' IDENTIFIED BY 2461 DEFINITION 'PROJCS["JGD2000 / Japan Plane Rectangular CS XIX",GEOGCS["JGD2000",DATUM["Japanese Geodetic Datum 2000",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6612"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4612"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",26,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",154,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2461"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2462 NAME 'Albanian 1987 / Gauss-Kruger zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2462 DEFINITION 'PROJCS["Albanian 1987 / Gauss-Kruger zone 4",GEOGCS["Albanian 1987",DATUM["Albanian 1987",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703],AUTHORITY["EPSG","6191"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4191"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2462"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2463 NAME 'Pulkovo 1995 / Gauss-Kruger CM 21E' ORGANIZATION 'EPSG' IDENTIFIED BY 2463 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2463"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2464 NAME 'Pulkovo 1995 / Gauss-Kruger CM 27E' ORGANIZATION 'EPSG' IDENTIFIED BY 2464 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2464"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2465 NAME 'Pulkovo 1995 / Gauss-Kruger CM 33E' ORGANIZATION 'EPSG' IDENTIFIED BY 2465 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2465"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2466 NAME 'Pulkovo 1995 / Gauss-Kruger CM 39E' ORGANIZATION 'EPSG' IDENTIFIED BY 2466 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2466"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2467 NAME 'Pulkovo 1995 / Gauss-Kruger CM 45E' ORGANIZATION 'EPSG' IDENTIFIED BY 2467 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2467"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2468 NAME 'Pulkovo 1995 / Gauss-Kruger CM 51E' ORGANIZATION 'EPSG' IDENTIFIED BY 2468 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2468"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2469 NAME 'Pulkovo 1995 / Gauss-Kruger CM 57E' ORGANIZATION 'EPSG' IDENTIFIED BY 2469 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2469"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2470 NAME 'Pulkovo 1995 / Gauss-Kruger CM 63E' ORGANIZATION 'EPSG' IDENTIFIED BY 2470 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2470"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2471 NAME 'Pulkovo 1995 / Gauss-Kruger CM 69E' ORGANIZATION 'EPSG' IDENTIFIED BY 2471 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2471"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2472 NAME 'Pulkovo 1995 / Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2472 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2472"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2473 NAME 'Pulkovo 1995 / Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2473 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2473"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2474 NAME 'Pulkovo 1995 / Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2474 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2474"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2475 NAME 'Pulkovo 1995 / Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2475 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2475"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2476 NAME 'Pulkovo 1995 / Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2476 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2476"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2477 NAME 'Pulkovo 1995 / Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2477 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2477"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2478 NAME 'Pulkovo 1995 / Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2478 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2478"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2479 NAME 'Pulkovo 1995 / Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2479 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2479"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2480 NAME 'Pulkovo 1995 / Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2480 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2480"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2481 NAME 'Pulkovo 1995 / Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2481 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2481"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2482 NAME 'Pulkovo 1995 / Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2482 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2482"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2483 NAME 'Pulkovo 1995 / Gauss-Kruger CM 141E' ORGANIZATION 'EPSG' IDENTIFIED BY 2483 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2483"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2484 NAME 'Pulkovo 1995 / Gauss-Kruger CM 147E' ORGANIZATION 'EPSG' IDENTIFIED BY 2484 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2484"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2485 NAME 'Pulkovo 1995 / Gauss-Kruger CM 153E' ORGANIZATION 'EPSG' IDENTIFIED BY 2485 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2485"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2486 NAME 'Pulkovo 1995 / Gauss-Kruger CM 159E' ORGANIZATION 'EPSG' IDENTIFIED BY 2486 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2486"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2487 NAME 'Pulkovo 1995 / Gauss-Kruger CM 165E' ORGANIZATION 'EPSG' IDENTIFIED BY 2487 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2487"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2488 NAME 'Pulkovo 1995 / Gauss-Kruger CM 171E' ORGANIZATION 'EPSG' IDENTIFIED BY 2488 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2488"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2489 NAME 'Pulkovo 1995 / Gauss-Kruger CM 177E' ORGANIZATION 'EPSG' IDENTIFIED BY 2489 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2489"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2490 NAME 'Pulkovo 1995 / Gauss-Kruger CM 177W' ORGANIZATION 'EPSG' IDENTIFIED BY 2490 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2490"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2491 NAME 'Pulkovo 1995 / Gauss-Kruger CM 171W' ORGANIZATION 'EPSG' IDENTIFIED BY 2491 DEFINITION 'PROJCS["Pulkovo 1995 / Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2491"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2494 NAME 'Pulkovo 1942 / Gauss-Kruger CM 21E' ORGANIZATION 'EPSG' IDENTIFIED BY 2494 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2494"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2495 NAME 'Pulkovo 1942 / Gauss-Kruger CM 27E' ORGANIZATION 'EPSG' IDENTIFIED BY 2495 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2495"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2496 NAME 'Pulkovo 1942 / Gauss-Kruger CM 33E' ORGANIZATION 'EPSG' IDENTIFIED BY 2496 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2496"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2497 NAME 'Pulkovo 1942 / Gauss-Kruger CM 39E' ORGANIZATION 'EPSG' IDENTIFIED BY 2497 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2497"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2498 NAME 'Pulkovo 1942 / Gauss-Kruger CM 45E' ORGANIZATION 'EPSG' IDENTIFIED BY 2498 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2498"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2499 NAME 'Pulkovo 1942 / Gauss-Kruger CM 51E' ORGANIZATION 'EPSG' IDENTIFIED BY 2499 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2499"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2500 NAME 'Pulkovo 1942 / Gauss-Kruger CM 57E' ORGANIZATION 'EPSG' IDENTIFIED BY 2500 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2500"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2501 NAME 'Pulkovo 1942 / Gauss-Kruger CM 63E' ORGANIZATION 'EPSG' IDENTIFIED BY 2501 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2501"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2502 NAME 'Pulkovo 1942 / Gauss-Kruger CM 69E' ORGANIZATION 'EPSG' IDENTIFIED BY 2502 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2502"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2503 NAME 'Pulkovo 1942 / Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2503 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2503"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2504 NAME 'Pulkovo 1942 / Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2504 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2504"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2505 NAME 'Pulkovo 1942 / Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2505 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2505"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2506 NAME 'Pulkovo 1942 / Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2506 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2506"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2507 NAME 'Pulkovo 1942 / Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2507 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2507"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2508 NAME 'Pulkovo 1942 / Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2508 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2508"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2509 NAME 'Pulkovo 1942 / Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2509 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2509"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2510 NAME 'Pulkovo 1942 / Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2510 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2510"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2511 NAME 'Pulkovo 1942 / Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2511 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2511"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2512 NAME 'Pulkovo 1942 / Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2512 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2512"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2513 NAME 'Pulkovo 1942 / Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2513 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2513"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2514 NAME 'Pulkovo 1942 / Gauss-Kruger CM 141E' ORGANIZATION 'EPSG' IDENTIFIED BY 2514 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2514"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2515 NAME 'Pulkovo 1942 / Gauss-Kruger CM 147E' ORGANIZATION 'EPSG' IDENTIFIED BY 2515 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2515"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2516 NAME 'Pulkovo 1942 / Gauss-Kruger CM 153E' ORGANIZATION 'EPSG' IDENTIFIED BY 2516 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2516"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2517 NAME 'Pulkovo 1942 / Gauss-Kruger CM 159E' ORGANIZATION 'EPSG' IDENTIFIED BY 2517 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2517"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2518 NAME 'Pulkovo 1942 / Gauss-Kruger CM 165E' ORGANIZATION 'EPSG' IDENTIFIED BY 2518 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2518"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2519 NAME 'Pulkovo 1942 / Gauss-Kruger CM 171E' ORGANIZATION 'EPSG' IDENTIFIED BY 2519 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2519"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2520 NAME 'Pulkovo 1942 / Gauss-Kruger CM 177E' ORGANIZATION 'EPSG' IDENTIFIED BY 2520 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2520"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2521 NAME 'Pulkovo 1942 / Gauss-Kruger CM 177W' ORGANIZATION 'EPSG' IDENTIFIED BY 2521 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2521"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2522 NAME 'Pulkovo 1942 / Gauss-Kruger CM 171W' ORGANIZATION 'EPSG' IDENTIFIED BY 2522 DEFINITION 'PROJCS["Pulkovo 1942 / Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2522"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2523 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2523 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 7",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2523"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2524 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2524 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 8",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2524"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2525 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2525 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 9",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2525"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2526 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2526 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 10",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2526"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2527 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 11' ORGANIZATION 'EPSG' IDENTIFIED BY 2527 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 11",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2527"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2528 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 12' ORGANIZATION 'EPSG' IDENTIFIED BY 2528 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 12",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2528"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2529 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2529 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 13",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2529"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2530 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 14' ORGANIZATION 'EPSG' IDENTIFIED BY 2530 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 14",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2530"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2531 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 15' ORGANIZATION 'EPSG' IDENTIFIED BY 2531 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 15",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2531"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2532 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 16' ORGANIZATION 'EPSG' IDENTIFIED BY 2532 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 16",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2532"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2533 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 17' ORGANIZATION 'EPSG' IDENTIFIED BY 2533 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 17",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2533"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2534 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 18' ORGANIZATION 'EPSG' IDENTIFIED BY 2534 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 18",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2534"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2535 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 19' ORGANIZATION 'EPSG' IDENTIFIED BY 2535 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 19",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2535"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2536 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 20' ORGANIZATION 'EPSG' IDENTIFIED BY 2536 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 20",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2536"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2537 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 21' ORGANIZATION 'EPSG' IDENTIFIED BY 2537 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 21",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2537"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2538 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 22' ORGANIZATION 'EPSG' IDENTIFIED BY 2538 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 22",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2538"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2539 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 23' ORGANIZATION 'EPSG' IDENTIFIED BY 2539 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 23",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2539"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2540 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 24' ORGANIZATION 'EPSG' IDENTIFIED BY 2540 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 24",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",24500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2540"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2541 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 25' ORGANIZATION 'EPSG' IDENTIFIED BY 2541 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 25",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2541"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2542 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 26' ORGANIZATION 'EPSG' IDENTIFIED BY 2542 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 26",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2542"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2543 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 27' ORGANIZATION 'EPSG' IDENTIFIED BY 2543 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 27",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2543"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2544 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 28' ORGANIZATION 'EPSG' IDENTIFIED BY 2544 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 28",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2544"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2545 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 29' ORGANIZATION 'EPSG' IDENTIFIED BY 2545 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 29",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2545"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2546 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 30' ORGANIZATION 'EPSG' IDENTIFIED BY 2546 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 30",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2546"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2547 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 31' ORGANIZATION 'EPSG' IDENTIFIED BY 2547 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 31",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2547"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2548 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 32' ORGANIZATION 'EPSG' IDENTIFIED BY 2548 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 32",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2548"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2549 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 33' ORGANIZATION 'EPSG' IDENTIFIED BY 2549 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 33",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2549"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2551 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 34' ORGANIZATION 'EPSG' IDENTIFIED BY 2551 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 34",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2551"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2552 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 35' ORGANIZATION 'EPSG' IDENTIFIED BY 2552 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 35",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2552"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2553 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 36' ORGANIZATION 'EPSG' IDENTIFIED BY 2553 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 36",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2553"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2554 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 37' ORGANIZATION 'EPSG' IDENTIFIED BY 2554 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 37",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2554"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2555 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 38' ORGANIZATION 'EPSG' IDENTIFIED BY 2555 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 38",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2555"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2556 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 39' ORGANIZATION 'EPSG' IDENTIFIED BY 2556 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 39",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2556"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2557 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 40' ORGANIZATION 'EPSG' IDENTIFIED BY 2557 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 40",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2557"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2558 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 41' ORGANIZATION 'EPSG' IDENTIFIED BY 2558 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 41",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2558"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2559 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 42' ORGANIZATION 'EPSG' IDENTIFIED BY 2559 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 42",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2559"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2560 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 43' ORGANIZATION 'EPSG' IDENTIFIED BY 2560 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 43",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2560"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2561 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 44' ORGANIZATION 'EPSG' IDENTIFIED BY 2561 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 44",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2561"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2562 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 45' ORGANIZATION 'EPSG' IDENTIFIED BY 2562 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 45",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2562"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2563 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 46' ORGANIZATION 'EPSG' IDENTIFIED BY 2563 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 46",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",46500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2563"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2564 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 47' ORGANIZATION 'EPSG' IDENTIFIED BY 2564 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 47",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",47500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2564"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2565 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 48' ORGANIZATION 'EPSG' IDENTIFIED BY 2565 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 48",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",48500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2565"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2566 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 49' ORGANIZATION 'EPSG' IDENTIFIED BY 2566 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 49",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",49500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2566"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2567 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 50' ORGANIZATION 'EPSG' IDENTIFIED BY 2567 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 50",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",50500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2567"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2568 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 51' ORGANIZATION 'EPSG' IDENTIFIED BY 2568 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 51",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",51500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2568"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2569 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 52' ORGANIZATION 'EPSG' IDENTIFIED BY 2569 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 52",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",52500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2569"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2570 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 53' ORGANIZATION 'EPSG' IDENTIFIED BY 2570 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 53",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",53500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2570"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2571 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 54' ORGANIZATION 'EPSG' IDENTIFIED BY 2571 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 54",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",54500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2571"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2572 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 55' ORGANIZATION 'EPSG' IDENTIFIED BY 2572 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 55",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",55500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2572"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2573 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 56' ORGANIZATION 'EPSG' IDENTIFIED BY 2573 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 56",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",56500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2573"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2574 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 57' ORGANIZATION 'EPSG' IDENTIFIED BY 2574 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 57",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",57500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2574"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2575 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 58' ORGANIZATION 'EPSG' IDENTIFIED BY 2575 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 58",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",58500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2575"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2576 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 59' ORGANIZATION 'EPSG' IDENTIFIED BY 2576 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 59",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",59500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2576"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2578 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 61' ORGANIZATION 'EPSG' IDENTIFIED BY 2578 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 61",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",61500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2578"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2579 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 62' ORGANIZATION 'EPSG' IDENTIFIED BY 2579 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 62",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",62500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2579"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2580 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 63' ORGANIZATION 'EPSG' IDENTIFIED BY 2580 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 63",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",63500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2580"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2581 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger zone 64' ORGANIZATION 'EPSG' IDENTIFIED BY 2581 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger zone 64",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",64500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2581"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2582 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E' ORGANIZATION 'EPSG' IDENTIFIED BY 2582 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2582"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2583 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E' ORGANIZATION 'EPSG' IDENTIFIED BY 2583 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2583"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2584 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E' ORGANIZATION 'EPSG' IDENTIFIED BY 2584 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2584"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2585 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E' ORGANIZATION 'EPSG' IDENTIFIED BY 2585 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2585"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2586 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E' ORGANIZATION 'EPSG' IDENTIFIED BY 2586 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2586"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2587 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E' ORGANIZATION 'EPSG' IDENTIFIED BY 2587 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2587"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2588 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E' ORGANIZATION 'EPSG' IDENTIFIED BY 2588 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2588"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2589 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E' ORGANIZATION 'EPSG' IDENTIFIED BY 2589 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2589"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2590 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E' ORGANIZATION 'EPSG' IDENTIFIED BY 2590 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2590"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2591 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E' ORGANIZATION 'EPSG' IDENTIFIED BY 2591 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2591"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2592 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E' ORGANIZATION 'EPSG' IDENTIFIED BY 2592 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2592"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2593 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E' ORGANIZATION 'EPSG' IDENTIFIED BY 2593 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2593"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2594 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E' ORGANIZATION 'EPSG' IDENTIFIED BY 2594 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2594"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2595 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E' ORGANIZATION 'EPSG' IDENTIFIED BY 2595 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2595"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2596 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E' ORGANIZATION 'EPSG' IDENTIFIED BY 2596 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2596"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2597 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E' ORGANIZATION 'EPSG' IDENTIFIED BY 2597 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2597"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2598 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E' ORGANIZATION 'EPSG' IDENTIFIED BY 2598 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2598"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2599 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E' ORGANIZATION 'EPSG' IDENTIFIED BY 2599 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2599"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2601 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2601 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2601"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2602 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E' ORGANIZATION 'EPSG' IDENTIFIED BY 2602 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2602"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2603 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2603 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2603"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2604 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E' ORGANIZATION 'EPSG' IDENTIFIED BY 2604 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2604"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2605 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2605 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2605"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2606 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E' ORGANIZATION 'EPSG' IDENTIFIED BY 2606 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2606"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2607 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2607 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2607"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2608 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E' ORGANIZATION 'EPSG' IDENTIFIED BY 2608 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2608"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2609 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2609 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2609"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2610 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E' ORGANIZATION 'EPSG' IDENTIFIED BY 2610 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2610"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2611 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2611 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2611"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2612 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E' ORGANIZATION 'EPSG' IDENTIFIED BY 2612 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2612"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2613 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2613 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2613"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2614 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E' ORGANIZATION 'EPSG' IDENTIFIED BY 2614 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2614"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2615 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2615 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2615"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2616 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E' ORGANIZATION 'EPSG' IDENTIFIED BY 2616 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2616"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2617 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2617 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2617"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2618 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E' ORGANIZATION 'EPSG' IDENTIFIED BY 2618 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2618"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2619 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2619 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2619"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2620 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E' ORGANIZATION 'EPSG' IDENTIFIED BY 2620 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2620"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2621 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2621 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2621"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2622 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E' ORGANIZATION 'EPSG' IDENTIFIED BY 2622 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2622"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2623 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E' ORGANIZATION 'EPSG' IDENTIFIED BY 2623 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2623"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2624 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E' ORGANIZATION 'EPSG' IDENTIFIED BY 2624 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2624"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2625 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E' ORGANIZATION 'EPSG' IDENTIFIED BY 2625 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2625"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2626 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E' ORGANIZATION 'EPSG' IDENTIFIED BY 2626 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2626"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2627 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E' ORGANIZATION 'EPSG' IDENTIFIED BY 2627 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2627"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2628 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E' ORGANIZATION 'EPSG' IDENTIFIED BY 2628 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 156E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2628"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2629 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E' ORGANIZATION 'EPSG' IDENTIFIED BY 2629 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2629"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2630 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E' ORGANIZATION 'EPSG' IDENTIFIED BY 2630 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 162E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2630"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2631 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E' ORGANIZATION 'EPSG' IDENTIFIED BY 2631 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2631"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2632 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E' ORGANIZATION 'EPSG' IDENTIFIED BY 2632 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 168E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2632"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2633 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E' ORGANIZATION 'EPSG' IDENTIFIED BY 2633 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2633"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2634 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E' ORGANIZATION 'EPSG' IDENTIFIED BY 2634 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 174E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2634"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2635 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E' ORGANIZATION 'EPSG' IDENTIFIED BY 2635 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2635"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2636 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E' ORGANIZATION 'EPSG' IDENTIFIED BY 2636 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 180E",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",180,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2636"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2637 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W' ORGANIZATION 'EPSG' IDENTIFIED BY 2637 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2637"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2638 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W' ORGANIZATION 'EPSG' IDENTIFIED BY 2638 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 174W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2638"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2639 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W' ORGANIZATION 'EPSG' IDENTIFIED BY 2639 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2639"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2640 NAME 'Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W' ORGANIZATION 'EPSG' IDENTIFIED BY 2640 DEFINITION 'PROJCS["Pulkovo 1942 / 3-degree Gauss-Kruger CM 168W",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2640"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2641 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2641 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 7",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",7500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2641"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2642 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2642 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 8",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",8500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2642"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2643 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2643 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 9",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",9500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2643"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2644 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2644 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 10",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",10500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2644"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2645 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 11' ORGANIZATION 'EPSG' IDENTIFIED BY 2645 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 11",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",11500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2645"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2646 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 12' ORGANIZATION 'EPSG' IDENTIFIED BY 2646 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 12",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",12500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2646"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2647 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 13' ORGANIZATION 'EPSG' IDENTIFIED BY 2647 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 13",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",13500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2647"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2648 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 14' ORGANIZATION 'EPSG' IDENTIFIED BY 2648 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 14",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",14500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2648"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2649 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 15' ORGANIZATION 'EPSG' IDENTIFIED BY 2649 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 15",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",15500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2649"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2650 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 16' ORGANIZATION 'EPSG' IDENTIFIED BY 2650 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 16",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",16500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2650"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2651 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 17' ORGANIZATION 'EPSG' IDENTIFIED BY 2651 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 17",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",17500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2651"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2652 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 18' ORGANIZATION 'EPSG' IDENTIFIED BY 2652 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 18",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",18500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2652"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2653 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 19' ORGANIZATION 'EPSG' IDENTIFIED BY 2653 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 19",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",19500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2653"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2654 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 20' ORGANIZATION 'EPSG' IDENTIFIED BY 2654 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 20",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",20500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2654"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2655 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 21' ORGANIZATION 'EPSG' IDENTIFIED BY 2655 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 21",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",21500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2655"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2656 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 22' ORGANIZATION 'EPSG' IDENTIFIED BY 2656 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 22",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",22500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2656"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2657 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 23' ORGANIZATION 'EPSG' IDENTIFIED BY 2657 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 23",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",23500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2657"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2658 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 24' ORGANIZATION 'EPSG' IDENTIFIED BY 2658 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 24",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",24500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2658"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2659 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 25' ORGANIZATION 'EPSG' IDENTIFIED BY 2659 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 25",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",25500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2659"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2660 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 26' ORGANIZATION 'EPSG' IDENTIFIED BY 2660 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 26",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",26500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2660"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2661 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 27' ORGANIZATION 'EPSG' IDENTIFIED BY 2661 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 27",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",27500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2661"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2662 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 28' ORGANIZATION 'EPSG' IDENTIFIED BY 2662 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 28",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",28500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2662"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2663 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 29' ORGANIZATION 'EPSG' IDENTIFIED BY 2663 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 29",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",29500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2663"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2664 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 30' ORGANIZATION 'EPSG' IDENTIFIED BY 2664 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 30",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",30500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2664"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2665 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 31' ORGANIZATION 'EPSG' IDENTIFIED BY 2665 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 31",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",31500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2665"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2666 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 32' ORGANIZATION 'EPSG' IDENTIFIED BY 2666 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 32",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",32500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2666"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2667 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 33' ORGANIZATION 'EPSG' IDENTIFIED BY 2667 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 33",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",33500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2667"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2668 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 34' ORGANIZATION 'EPSG' IDENTIFIED BY 2668 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 34",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",34500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2668"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2669 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 35' ORGANIZATION 'EPSG' IDENTIFIED BY 2669 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 35",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",35500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2669"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2670 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 36' ORGANIZATION 'EPSG' IDENTIFIED BY 2670 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 36",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",36500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2670"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2671 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 37' ORGANIZATION 'EPSG' IDENTIFIED BY 2671 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 37",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",37500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2671"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2672 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 38' ORGANIZATION 'EPSG' IDENTIFIED BY 2672 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 38",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",38500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2672"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2673 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 39' ORGANIZATION 'EPSG' IDENTIFIED BY 2673 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 39",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",39500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2673"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2674 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 40' ORGANIZATION 'EPSG' IDENTIFIED BY 2674 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 40",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",40500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2674"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2675 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 41' ORGANIZATION 'EPSG' IDENTIFIED BY 2675 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 41",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",41500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2675"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2676 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 42' ORGANIZATION 'EPSG' IDENTIFIED BY 2676 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 42",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",42500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2676"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2677 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 43' ORGANIZATION 'EPSG' IDENTIFIED BY 2677 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 43",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",43500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2677"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2678 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 44' ORGANIZATION 'EPSG' IDENTIFIED BY 2678 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 44",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",44500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2678"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2679 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 45' ORGANIZATION 'EPSG' IDENTIFIED BY 2679 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 45",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",45500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2679"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2680 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 46' ORGANIZATION 'EPSG' IDENTIFIED BY 2680 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 46",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",46500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2680"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2681 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 47' ORGANIZATION 'EPSG' IDENTIFIED BY 2681 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 47",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",47500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2681"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2682 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 48' ORGANIZATION 'EPSG' IDENTIFIED BY 2682 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 48",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",48500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2682"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2683 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 49' ORGANIZATION 'EPSG' IDENTIFIED BY 2683 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 49",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",49500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2683"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2684 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 50' ORGANIZATION 'EPSG' IDENTIFIED BY 2684 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 50",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",50500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2684"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2685 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 51' ORGANIZATION 'EPSG' IDENTIFIED BY 2685 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 51",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",51500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2685"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2686 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 52' ORGANIZATION 'EPSG' IDENTIFIED BY 2686 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 52",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",52500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2686"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2687 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 53' ORGANIZATION 'EPSG' IDENTIFIED BY 2687 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 53",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",53500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2687"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2688 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 54' ORGANIZATION 'EPSG' IDENTIFIED BY 2688 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 54",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",54500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2688"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2689 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 55' ORGANIZATION 'EPSG' IDENTIFIED BY 2689 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 55",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",55500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2689"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2690 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 56' ORGANIZATION 'EPSG' IDENTIFIED BY 2690 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 56",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",56500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2690"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2691 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 57' ORGANIZATION 'EPSG' IDENTIFIED BY 2691 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 57",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",57500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2691"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2692 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 58' ORGANIZATION 'EPSG' IDENTIFIED BY 2692 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 58",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",58500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2692"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2693 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 59' ORGANIZATION 'EPSG' IDENTIFIED BY 2693 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 59",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",59500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2693"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2695 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 61' ORGANIZATION 'EPSG' IDENTIFIED BY 2695 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 61",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",61500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2695"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2696 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 62' ORGANIZATION 'EPSG' IDENTIFIED BY 2696 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 62",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",62500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2696"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2697 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 63' ORGANIZATION 'EPSG' IDENTIFIED BY 2697 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 63",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",63500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2697"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2698 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger zone 64' ORGANIZATION 'EPSG' IDENTIFIED BY 2698 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger zone 64",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",64500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2698"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2699 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E' ORGANIZATION 'EPSG' IDENTIFIED BY 2699 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 21E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2699"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2700 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E' ORGANIZATION 'EPSG' IDENTIFIED BY 2700 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 24E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",24,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2700"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2701 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E' ORGANIZATION 'EPSG' IDENTIFIED BY 2701 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 27E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",27,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2701"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2702 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E' ORGANIZATION 'EPSG' IDENTIFIED BY 2702 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 30E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",30,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2702"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2703 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E' ORGANIZATION 'EPSG' IDENTIFIED BY 2703 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 33E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2703"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2704 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E' ORGANIZATION 'EPSG' IDENTIFIED BY 2704 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 36E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",36,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2704"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2705 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E' ORGANIZATION 'EPSG' IDENTIFIED BY 2705 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 39E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2705"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2706 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E' ORGANIZATION 'EPSG' IDENTIFIED BY 2706 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 42E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",42,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2706"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2707 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E' ORGANIZATION 'EPSG' IDENTIFIED BY 2707 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 45E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2707"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2708 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E' ORGANIZATION 'EPSG' IDENTIFIED BY 2708 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 48E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",48,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2708"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2709 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 51E' ORGANIZATION 'EPSG' IDENTIFIED BY 2709 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 51E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2709"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2710 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 54E' ORGANIZATION 'EPSG' IDENTIFIED BY 2710 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 54E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",54,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2710"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2711 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 57E' ORGANIZATION 'EPSG' IDENTIFIED BY 2711 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 57E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2711"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2712 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 60E' ORGANIZATION 'EPSG' IDENTIFIED BY 2712 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 60E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",60,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2712"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2713 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 63E' ORGANIZATION 'EPSG' IDENTIFIED BY 2713 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 63E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2713"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2714 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 66E' ORGANIZATION 'EPSG' IDENTIFIED BY 2714 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 66E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",66,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2714"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2715 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 69E' ORGANIZATION 'EPSG' IDENTIFIED BY 2715 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 69E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2715"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2716 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 72E' ORGANIZATION 'EPSG' IDENTIFIED BY 2716 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 72E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",72,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2716"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2717 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 75E' ORGANIZATION 'EPSG' IDENTIFIED BY 2717 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 75E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2717"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2718 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 78E' ORGANIZATION 'EPSG' IDENTIFIED BY 2718 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 78E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",78,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2718"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2719 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 81E' ORGANIZATION 'EPSG' IDENTIFIED BY 2719 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 81E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2719"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2720 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 84E' ORGANIZATION 'EPSG' IDENTIFIED BY 2720 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 84E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",84,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2720"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2721 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 87E' ORGANIZATION 'EPSG' IDENTIFIED BY 2721 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 87E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",87,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2721"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2722 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 90E' ORGANIZATION 'EPSG' IDENTIFIED BY 2722 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 90E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",90,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2722"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2723 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 93E' ORGANIZATION 'EPSG' IDENTIFIED BY 2723 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 93E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",93,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2723"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2724 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 96E' ORGANIZATION 'EPSG' IDENTIFIED BY 2724 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 96E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",96,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2724"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2725 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 99E' ORGANIZATION 'EPSG' IDENTIFIED BY 2725 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 99E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",99,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2725"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2726 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 102E' ORGANIZATION 'EPSG' IDENTIFIED BY 2726 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 102E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",102,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2726"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2727 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 105E' ORGANIZATION 'EPSG' IDENTIFIED BY 2727 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 105E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2727"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2728 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 108E' ORGANIZATION 'EPSG' IDENTIFIED BY 2728 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 108E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",108,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2728"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2729 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E' ORGANIZATION 'EPSG' IDENTIFIED BY 2729 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 111E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2729"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2730 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E' ORGANIZATION 'EPSG' IDENTIFIED BY 2730 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 114E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2730"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2731 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E' ORGANIZATION 'EPSG' IDENTIFIED BY 2731 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 117E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2731"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2732 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E' ORGANIZATION 'EPSG' IDENTIFIED BY 2732 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 120E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",120,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2732"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2733 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E' ORGANIZATION 'EPSG' IDENTIFIED BY 2733 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 123E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",123,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2733"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2734 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E' ORGANIZATION 'EPSG' IDENTIFIED BY 2734 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 126E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",126,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2734"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2735 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E' ORGANIZATION 'EPSG' IDENTIFIED BY 2735 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 129E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",129,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2735"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2736 NAME 'Tete / UTM zone 36S' ORGANIZATION 'EPSG' IDENTIFIED BY 2736 DEFINITION 'PROJCS["Tete / UTM zone 36S",GEOGCS["Tete",DATUM["Tete",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115.064,-87.39,-101.716,-0.058,4.001,-2.062,9.366],AUTHORITY["EPSG","6127"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4127"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",33,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2736"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2737 NAME 'Tete / UTM zone 37S' ORGANIZATION 'EPSG' IDENTIFIED BY 2737 DEFINITION 'PROJCS["Tete / UTM zone 37S",GEOGCS["Tete",DATUM["Tete",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-115.064,-87.39,-101.716,-0.058,4.001,-2.062,9.366],AUTHORITY["EPSG","6127"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4127"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",39,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2737"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2738 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E' ORGANIZATION 'EPSG' IDENTIFIED BY 2738 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 132E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",132,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2738"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2739 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E' ORGANIZATION 'EPSG' IDENTIFIED BY 2739 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 135E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",135,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2739"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2740 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E' ORGANIZATION 'EPSG' IDENTIFIED BY 2740 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 138E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",138,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2740"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2741 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E' ORGANIZATION 'EPSG' IDENTIFIED BY 2741 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 141E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2741"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2742 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E' ORGANIZATION 'EPSG' IDENTIFIED BY 2742 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 144E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",144,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2742"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2743 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E' ORGANIZATION 'EPSG' IDENTIFIED BY 2743 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 147E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2743"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2744 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E' ORGANIZATION 'EPSG' IDENTIFIED BY 2744 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 150E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",150,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2744"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2745 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E' ORGANIZATION 'EPSG' IDENTIFIED BY 2745 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 153E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2745"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2746 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E' ORGANIZATION 'EPSG' IDENTIFIED BY 2746 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 156E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",156,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2746"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2747 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E' ORGANIZATION 'EPSG' IDENTIFIED BY 2747 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 159E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",159,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2747"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2748 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E' ORGANIZATION 'EPSG' IDENTIFIED BY 2748 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 162E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",162,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2748"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2749 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E' ORGANIZATION 'EPSG' IDENTIFIED BY 2749 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 165E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2749"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2750 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E' ORGANIZATION 'EPSG' IDENTIFIED BY 2750 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 168E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2750"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2751 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E' ORGANIZATION 'EPSG' IDENTIFIED BY 2751 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 171E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2751"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2752 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E' ORGANIZATION 'EPSG' IDENTIFIED BY 2752 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 174E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2752"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2753 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E' ORGANIZATION 'EPSG' IDENTIFIED BY 2753 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 177E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2753"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2754 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E' ORGANIZATION 'EPSG' IDENTIFIED BY 2754 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 180E",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",180,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2754"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2755 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W' ORGANIZATION 'EPSG' IDENTIFIED BY 2755 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 177W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2755"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2756 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W' ORGANIZATION 'EPSG' IDENTIFIED BY 2756 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 174W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-174,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2756"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2757 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W' ORGANIZATION 'EPSG' IDENTIFIED BY 2757 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 171W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-171,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2757"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2758 NAME 'Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W' ORGANIZATION 'EPSG' IDENTIFIED BY 2758 DEFINITION 'PROJCS["Pulkovo 1995 / 3-degree Gauss-Kruger CM 168W",GEOGCS["Pulkovo 1995",DATUM["Pulkovo 1995",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY["EPSG","6200"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4200"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-168,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2758"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2759 NAME 'NAD83(HARN) / Alabama East' ORGANIZATION 'EPSG' IDENTIFIED BY 2759 DEFINITION 'PROJCS["NAD83(HARN) / Alabama East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2759"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2760 NAME 'NAD83(HARN) / Alabama West' ORGANIZATION 'EPSG' IDENTIFIED BY 2760 DEFINITION 'PROJCS["NAD83(HARN) / Alabama West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2760"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2761 NAME 'NAD83(HARN) / Arizona East' ORGANIZATION 'EPSG' IDENTIFIED BY 2761 DEFINITION 'PROJCS["NAD83(HARN) / Arizona East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2761"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2762 NAME 'NAD83(HARN) / Arizona Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2762 DEFINITION 'PROJCS["NAD83(HARN) / Arizona Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111.927777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2762"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2763 NAME 'NAD83(HARN) / Arizona West' ORGANIZATION 'EPSG' IDENTIFIED BY 2763 DEFINITION 'PROJCS["NAD83(HARN) / Arizona West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-113.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",213360,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2763"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2764 NAME 'NAD83(HARN) / Arkansas North' ORGANIZATION 'EPSG' IDENTIFIED BY 2764 DEFINITION 'PROJCS["NAD83(HARN) / Arkansas North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-92,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2764"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2765 NAME 'NAD83(HARN) / Arkansas South' ORGANIZATION 'EPSG' IDENTIFIED BY 2765 DEFINITION 'PROJCS["NAD83(HARN) / Arkansas South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-92,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",34.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",400000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2765"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2766 NAME 'NAD83(HARN) / California zone 1' ORGANIZATION 'EPSG' IDENTIFIED BY 2766 DEFINITION 'PROJCS["NAD83(HARN) / California zone 1",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2766"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2767 NAME 'NAD83(HARN) / California zone 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2767 DEFINITION 'PROJCS["NAD83(HARN) / California zone 2",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2767"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2768 NAME 'NAD83(HARN) / California zone 3' ORGANIZATION 'EPSG' IDENTIFIED BY 2768 DEFINITION 'PROJCS["NAD83(HARN) / California zone 3",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2768"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2769 NAME 'NAD83(HARN) / California zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2769 DEFINITION 'PROJCS["NAD83(HARN) / California zone 4",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-119,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2769"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2770 NAME 'NAD83(HARN) / California zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2770 DEFINITION 'PROJCS["NAD83(HARN) / California zone 5",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-118,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.4666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2770"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2771 NAME 'NAD83(HARN) / California zone 6' ORGANIZATION 'EPSG' IDENTIFIED BY 2771 DEFINITION 'PROJCS["NAD83(HARN) / California zone 6",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-116.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2771"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2772 NAME 'NAD83(HARN) / Colorado North' ORGANIZATION 'EPSG' IDENTIFIED BY 2772 DEFINITION 'PROJCS["NAD83(HARN) / Colorado North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2772"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2773 NAME 'NAD83(HARN) / Colorado Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2773 DEFINITION 'PROJCS["NAD83(HARN) / Colorado Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.75,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2773"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2774 NAME 'NAD83(HARN) / Colorado South' ORGANIZATION 'EPSG' IDENTIFIED BY 2774 DEFINITION 'PROJCS["NAD83(HARN) / Colorado South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",914401.8289,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",304800.6096,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2774"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2775 NAME 'NAD83(HARN) / Connecticut' ORGANIZATION 'EPSG' IDENTIFIED BY 2775 DEFINITION 'PROJCS["NAD83(HARN) / Connecticut",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-72.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.8666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",304800.6096,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",152400.3048,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2775"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2776 NAME 'NAD83(HARN) / Delaware' ORGANIZATION 'EPSG' IDENTIFIED BY 2776 DEFINITION 'PROJCS["NAD83(HARN) / Delaware",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75.4166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2776"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2777 NAME 'NAD83(HARN) / Florida East' ORGANIZATION 'EPSG' IDENTIFIED BY 2777 DEFINITION 'PROJCS["NAD83(HARN) / Florida East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2777"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2778 NAME 'NAD83(HARN) / Florida West' ORGANIZATION 'EPSG' IDENTIFIED BY 2778 DEFINITION 'PROJCS["NAD83(HARN) / Florida West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2778"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2779 NAME 'NAD83(HARN) / Florida North' ORGANIZATION 'EPSG' IDENTIFIED BY 2779 DEFINITION 'PROJCS["NAD83(HARN) / Florida North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.5833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2779"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2780 NAME 'NAD83(HARN) / Georgia East' ORGANIZATION 'EPSG' IDENTIFIED BY 2780 DEFINITION 'PROJCS["NAD83(HARN) / Georgia East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2780"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2781 NAME 'NAD83(HARN) / Georgia West' ORGANIZATION 'EPSG' IDENTIFIED BY 2781 DEFINITION 'PROJCS["NAD83(HARN) / Georgia West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2781"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2782 NAME 'NAD83(HARN) / Hawaii zone 1' ORGANIZATION 'EPSG' IDENTIFIED BY 2782 DEFINITION 'PROJCS["NAD83(HARN) / Hawaii zone 1",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",18.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-155.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2782"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2783 NAME 'NAD83(HARN) / Hawaii zone 2' ORGANIZATION 'EPSG' IDENTIFIED BY 2783 DEFINITION 'PROJCS["NAD83(HARN) / Hawaii zone 2",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",20.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-156.666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2783"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2784 NAME 'NAD83(HARN) / Hawaii zone 3' ORGANIZATION 'EPSG' IDENTIFIED BY 2784 DEFINITION 'PROJCS["NAD83(HARN) / Hawaii zone 3",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.1666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-158,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2784"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2785 NAME 'NAD83(HARN) / Hawaii zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2785 DEFINITION 'PROJCS["NAD83(HARN) / Hawaii zone 4",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-159.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2785"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2786 NAME 'NAD83(HARN) / Hawaii zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2786 DEFINITION 'PROJCS["NAD83(HARN) / Hawaii zone 5",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",21.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-160.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2786"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2787 NAME 'NAD83(HARN) / Idaho East' ORGANIZATION 'EPSG' IDENTIFIED BY 2787 DEFINITION 'PROJCS["NAD83(HARN) / Idaho East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-112.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2787"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2788 NAME 'NAD83(HARN) / Idaho Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2788 DEFINITION 'PROJCS["NAD83(HARN) / Idaho Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2788"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2789 NAME 'NAD83(HARN) / Idaho West' ORGANIZATION 'EPSG' IDENTIFIED BY 2789 DEFINITION 'PROJCS["NAD83(HARN) / Idaho West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2789"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2790 NAME 'NAD83(HARN) / Illinois East' ORGANIZATION 'EPSG' IDENTIFIED BY 2790 DEFINITION 'PROJCS["NAD83(HARN) / Illinois East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999975,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2790"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2791 NAME 'NAD83(HARN) / Illinois West' ORGANIZATION 'EPSG' IDENTIFIED BY 2791 DEFINITION 'PROJCS["NAD83(HARN) / Illinois West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2791"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2792 NAME 'NAD83(HARN) / Indiana East' ORGANIZATION 'EPSG' IDENTIFIED BY 2792 DEFINITION 'PROJCS["NAD83(HARN) / Indiana East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.6666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",100000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",250000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2792"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2793 NAME 'NAD83(HARN) / Indiana West' ORGANIZATION 'EPSG' IDENTIFIED BY 2793 DEFINITION 'PROJCS["NAD83(HARN) / Indiana West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.0944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",250000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2793"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2794 NAME 'NAD83(HARN) / Iowa North' ORGANIZATION 'EPSG' IDENTIFIED BY 2794 DEFINITION 'PROJCS["NAD83(HARN) / Iowa North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-93.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.2777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2794"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2795 NAME 'NAD83(HARN) / Iowa South' ORGANIZATION 'EPSG' IDENTIFIED BY 2795 DEFINITION 'PROJCS["NAD83(HARN) / Iowa South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-93.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2795"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2796 NAME 'NAD83(HARN) / Kansas North' ORGANIZATION 'EPSG' IDENTIFIED BY 2796 DEFINITION 'PROJCS["NAD83(HARN) / Kansas North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2796"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2797 NAME 'NAD83(HARN) / Kansas South' ORGANIZATION 'EPSG' IDENTIFIED BY 2797 DEFINITION 'PROJCS["NAD83(HARN) / Kansas South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.5666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",400000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2797"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2798 NAME 'NAD83(HARN) / Kentucky North' ORGANIZATION 'EPSG' IDENTIFIED BY 2798 DEFINITION 'PROJCS["NAD83(HARN) / Kentucky North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2798"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2799 NAME 'NAD83(HARN) / Kentucky South' ORGANIZATION 'EPSG' IDENTIFIED BY 2799 DEFINITION 'PROJCS["NAD83(HARN) / Kentucky South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-85.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2799"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2800 NAME 'NAD83(HARN) / Louisiana North' ORGANIZATION 'EPSG' IDENTIFIED BY 2800 DEFINITION 'PROJCS["NAD83(HARN) / Louisiana North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",30.5,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-92.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",32.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",31.1666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2800"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2801 NAME 'NAD83(HARN) / Louisiana South' ORGANIZATION 'EPSG' IDENTIFIED BY 2801 DEFINITION 'PROJCS["NAD83(HARN) / Louisiana South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",28.5,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-91.3333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2801"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2802 NAME 'NAD83(HARN) / Maine East' ORGANIZATION 'EPSG' IDENTIFIED BY 2802 DEFINITION 'PROJCS["NAD83(HARN) / Maine East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",43.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-68.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2802"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2803 NAME 'NAD83(HARN) / Maine West' ORGANIZATION 'EPSG' IDENTIFIED BY 2803 DEFINITION 'PROJCS["NAD83(HARN) / Maine West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",42.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-70.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2803"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2804 NAME 'NAD83(HARN) / Maryland' ORGANIZATION 'EPSG' IDENTIFIED BY 2804 DEFINITION 'PROJCS["NAD83(HARN) / Maryland",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.45,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2804"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2805 NAME 'NAD83(HARN) / Massachusetts Mainland' ORGANIZATION 'EPSG' IDENTIFIED BY 2805 DEFINITION 'PROJCS["NAD83(HARN) / Massachusetts Mainland",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-71.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",42.6944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",200000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",750000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2805"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2806 NAME 'NAD83(HARN) / Massachusetts Island' ORGANIZATION 'EPSG' IDENTIFIED BY 2806 DEFINITION 'PROJCS["NAD83(HARN) / Massachusetts Island",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-70.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2806"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2807 NAME 'NAD83(HARN) / Michigan North' ORGANIZATION 'EPSG' IDENTIFIED BY 2807 DEFINITION 'PROJCS["NAD83(HARN) / Michigan North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.7944444444444,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-87,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.0944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.4944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",8000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2807"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2808 NAME 'NAD83(HARN) / Michigan Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2808 DEFINITION 'PROJCS["NAD83(HARN) / Michigan Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.3277777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2808"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2809 NAME 'NAD83(HARN) / Michigan South' ORGANIZATION 'EPSG' IDENTIFIED BY 2809 DEFINITION 'PROJCS["NAD83(HARN) / Michigan South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.1,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",4000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2809"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2810 NAME 'NAD83(HARN) / Minnesota North' ORGANIZATION 'EPSG' IDENTIFIED BY 2810 DEFINITION 'PROJCS["NAD83(HARN) / Minnesota North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",46.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-93.1,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.6333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",800000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",100000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2810"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2811 NAME 'NAD83(HARN) / Minnesota Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2811 DEFINITION 'PROJCS["NAD83(HARN) / Minnesota Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-94.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.05,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.6277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",800000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",100000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2811"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2812 NAME 'NAD83(HARN) / Minnesota South' ORGANIZATION 'EPSG' IDENTIFIED BY 2812 DEFINITION 'PROJCS["NAD83(HARN) / Minnesota South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-94,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.2166666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",43.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",800000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",100000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2812"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2813 NAME 'NAD83(HARN) / Mississippi East' ORGANIZATION 'EPSG' IDENTIFIED BY 2813 DEFINITION 'PROJCS["NAD83(HARN) / Mississippi East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2813"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2814 NAME 'NAD83(HARN) / Mississippi West' ORGANIZATION 'EPSG' IDENTIFIED BY 2814 DEFINITION 'PROJCS["NAD83(HARN) / Mississippi West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2814"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2815 NAME 'NAD83(HARN) / Missouri East' ORGANIZATION 'EPSG' IDENTIFIED BY 2815 DEFINITION 'PROJCS["NAD83(HARN) / Missouri East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",35.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",250000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2815"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2816 NAME 'NAD83(HARN) / Missouri Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2816 DEFINITION 'PROJCS["NAD83(HARN) / Missouri Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",35.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-92.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2816"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2817 NAME 'NAD83(HARN) / Missouri West' ORGANIZATION 'EPSG' IDENTIFIED BY 2817 DEFINITION 'PROJCS["NAD83(HARN) / Missouri West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",36.1666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-94.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",850000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2817"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2818 NAME 'NAD83(HARN) / Montana' ORGANIZATION 'EPSG' IDENTIFIED BY 2818 DEFINITION 'PROJCS["NAD83(HARN) / Montana",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.2611111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-109.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2818"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2819 NAME 'NAD83(HARN) / Nebraska' ORGANIZATION 'EPSG' IDENTIFIED BY 2819 DEFINITION 'PROJCS["NAD83(HARN) / Nebraska",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2819"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2820 NAME 'NAD83(HARN) / Nevada East' ORGANIZATION 'EPSG' IDENTIFIED BY 2820 DEFINITION 'PROJCS["NAD83(HARN) / Nevada East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",34.75,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.594444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",8000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2820"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2821 NAME 'NAD83(HARN) / Nevada Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2821 DEFINITION 'PROJCS["NAD83(HARN) / Nevada Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",34.75,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-116.666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",6000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2821"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2822 NAME 'NAD83(HARN) / Nevada West' ORGANIZATION 'EPSG' IDENTIFIED BY 2822 DEFINITION 'PROJCS["NAD83(HARN) / Nevada West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",34.75,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-118.594444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",4000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2822"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2823 NAME 'NAD83(HARN) / New Hampshire' ORGANIZATION 'EPSG' IDENTIFIED BY 2823 DEFINITION 'PROJCS["NAD83(HARN) / New Hampshire",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",42.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.6666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2823"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2824 NAME 'NAD83(HARN) / New Jersey' ORGANIZATION 'EPSG' IDENTIFIED BY 2824 DEFINITION 'PROJCS["NAD83(HARN) / New Jersey",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-74.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2824"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2825 NAME 'NAD83(HARN) / New Mexico East' ORGANIZATION 'EPSG' IDENTIFIED BY 2825 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-104.333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999909091,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",165000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2825"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2826 NAME 'NAD83(HARN) / New Mexico Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2826 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-106.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2826"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2827 NAME 'NAD83(HARN) / New Mexico West' ORGANIZATION 'EPSG' IDENTIFIED BY 2827 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-107.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999916667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",830000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2827"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2828 NAME 'NAD83(HARN) / New York East' ORGANIZATION 'EPSG' IDENTIFIED BY 2828 DEFINITION 'PROJCS["NAD83(HARN) / New York East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-74.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2828"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2829 NAME 'NAD83(HARN) / New York Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2829 DEFINITION 'PROJCS["NAD83(HARN) / New York Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",250000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2829"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2830 NAME 'NAD83(HARN) / New York West' ORGANIZATION 'EPSG' IDENTIFIED BY 2830 DEFINITION 'PROJCS["NAD83(HARN) / New York West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-78.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",350000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2830"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2831 NAME 'NAD83(HARN) / New York Long Island' ORGANIZATION 'EPSG' IDENTIFIED BY 2831 DEFINITION 'PROJCS["NAD83(HARN) / New York Long Island",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-74,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.0333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",300000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2831"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2832 NAME 'NAD83(HARN) / North Dakota North' ORGANIZATION 'EPSG' IDENTIFIED BY 2832 DEFINITION 'PROJCS["NAD83(HARN) / North Dakota North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.4444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2832"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2833 NAME 'NAD83(HARN) / North Dakota South' ORGANIZATION 'EPSG' IDENTIFIED BY 2833 DEFINITION 'PROJCS["NAD83(HARN) / North Dakota South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2833"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2834 NAME 'NAD83(HARN) / Ohio North' ORGANIZATION 'EPSG' IDENTIFIED BY 2834 DEFINITION 'PROJCS["NAD83(HARN) / Ohio North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-82.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.4444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2834"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2835 NAME 'NAD83(HARN) / Ohio South' ORGANIZATION 'EPSG' IDENTIFIED BY 2835 DEFINITION 'PROJCS["NAD83(HARN) / Ohio South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-82.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.0333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2835"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2836 NAME 'NAD83(HARN) / Oklahoma North' ORGANIZATION 'EPSG' IDENTIFIED BY 2836 DEFINITION 'PROJCS["NAD83(HARN) / Oklahoma North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2836"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2837 NAME 'NAD83(HARN) / Oklahoma South' ORGANIZATION 'EPSG' IDENTIFIED BY 2837 DEFINITION 'PROJCS["NAD83(HARN) / Oklahoma South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2837"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2838 NAME 'NAD83(HARN) / Oregon North' ORGANIZATION 'EPSG' IDENTIFIED BY 2838 DEFINITION 'PROJCS["NAD83(HARN) / Oregon North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2838"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2839 NAME 'NAD83(HARN) / Oregon South' ORGANIZATION 'EPSG' IDENTIFIED BY 2839 DEFINITION 'PROJCS["NAD83(HARN) / Oregon South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2839"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2840 NAME 'NAD83(HARN) / Rhode Island' ORGANIZATION 'EPSG' IDENTIFIED BY 2840 DEFINITION 'PROJCS["NAD83(HARN) / Rhode Island",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.0944444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-71.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",100000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2840"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2841 NAME 'NAD83(HARN) / South Dakota North' ORGANIZATION 'EPSG' IDENTIFIED BY 2841 DEFINITION 'PROJCS["NAD83(HARN) / South Dakota North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.6944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.4166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2841"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2842 NAME 'NAD83(HARN) / South Dakota South' ORGANIZATION 'EPSG' IDENTIFIED BY 2842 DEFINITION 'PROJCS["NAD83(HARN) / South Dakota South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",42.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44.4,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.8333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2842"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2843 NAME 'NAD83(HARN) / Tennessee' ORGANIZATION 'EPSG' IDENTIFIED BY 2843 DEFINITION 'PROJCS["NAD83(HARN) / Tennessee",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.4166666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2843"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2844 NAME 'NAD83(HARN) / Texas North' ORGANIZATION 'EPSG' IDENTIFIED BY 2844 DEFINITION 'PROJCS["NAD83(HARN) / Texas North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-101.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.65,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",200000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2844"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2845 NAME 'NAD83(HARN) / Texas North Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2845 DEFINITION 'PROJCS["NAD83(HARN) / Texas North Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.1444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2845"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2846 NAME 'NAD83(HARN) / Texas Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2846 DEFINITION 'PROJCS["NAD83(HARN) / Texas Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",31.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",30.1166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",700000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2846"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2847 NAME 'NAD83(HARN) / Texas South Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2847 DEFINITION 'PROJCS["NAD83(HARN) / Texas South Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",27.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-99,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.2833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",28.3833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",4000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2847"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2848 NAME 'NAD83(HARN) / Texas South' ORGANIZATION 'EPSG' IDENTIFIED BY 2848 DEFINITION 'PROJCS["NAD83(HARN) / Texas South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",27.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",26.1666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",300000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",5000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2848"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2849 NAME 'NAD83(HARN) / Utah North' ORGANIZATION 'EPSG' IDENTIFIED BY 2849 DEFINITION 'PROJCS["NAD83(HARN) / Utah North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2849"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2850 NAME 'NAD83(HARN) / Utah Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2850 DEFINITION 'PROJCS["NAD83(HARN) / Utah Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.65,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.0277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2850"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2851 NAME 'NAD83(HARN) / Utah South' ORGANIZATION 'EPSG' IDENTIFIED BY 2851 DEFINITION 'PROJCS["NAD83(HARN) / Utah South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.35,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2851"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2852 NAME 'NAD83(HARN) / Vermont' ORGANIZATION 'EPSG' IDENTIFIED BY 2852 DEFINITION 'PROJCS["NAD83(HARN) / Vermont",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",42.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-72.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999964286,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2852"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2853 NAME 'NAD83(HARN) / Virginia North' ORGANIZATION 'EPSG' IDENTIFIED BY 2853 DEFINITION 'PROJCS["NAD83(HARN) / Virginia North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.2111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2853"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2854 NAME 'NAD83(HARN) / Virginia South' ORGANIZATION 'EPSG' IDENTIFIED BY 2854 DEFINITION 'PROJCS["NAD83(HARN) / Virginia South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2854"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2855 NAME 'NAD83(HARN) / Washington North' ORGANIZATION 'EPSG' IDENTIFIED BY 2855 DEFINITION 'PROJCS["NAD83(HARN) / Washington North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.833333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2855"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2856 NAME 'NAD83(HARN) / Washington South' ORGANIZATION 'EPSG' IDENTIFIED BY 2856 DEFINITION 'PROJCS["NAD83(HARN) / Washington South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.3333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.8333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",500000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2856"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2857 NAME 'NAD83(HARN) / West Virginia North' ORGANIZATION 'EPSG' IDENTIFIED BY 2857 DEFINITION 'PROJCS["NAD83(HARN) / West Virginia North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-79.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2857"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2858 NAME 'NAD83(HARN) / West Virginia South' ORGANIZATION 'EPSG' IDENTIFIED BY 2858 DEFINITION 'PROJCS["NAD83(HARN) / West Virginia South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-81,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.4944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2858"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2859 NAME 'NAD83(HARN) / Wisconsin North' ORGANIZATION 'EPSG' IDENTIFIED BY 2859 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin North",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2859"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2860 NAME 'NAD83(HARN) / Wisconsin Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2860 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.5111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2860"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2861 NAME 'NAD83(HARN) / Wisconsin South' ORGANIZATION 'EPSG' IDENTIFIED BY 2861 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin South",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",42,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44.0777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",600000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2861"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2862 NAME 'NAD83(HARN) / Wyoming East' ORGANIZATION 'EPSG' IDENTIFIED BY 2862 DEFINITION 'PROJCS["NAD83(HARN) / Wyoming East",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-105.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2862"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2863 NAME 'NAD83(HARN) / Wyoming East Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2863 DEFINITION 'PROJCS["NAD83(HARN) / Wyoming East Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-107.333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2863"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2864 NAME 'NAD83(HARN) / Wyoming West Central' ORGANIZATION 'EPSG' IDENTIFIED BY 2864 DEFINITION 'PROJCS["NAD83(HARN) / Wyoming West Central",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-108.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",600000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2864"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2865 NAME 'NAD83(HARN) / Wyoming West' ORGANIZATION 'EPSG' IDENTIFIED BY 2865 DEFINITION 'PROJCS["NAD83(HARN) / Wyoming West",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.094444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",800000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",100000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2865"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2866 NAME 'NAD83(HARN) / Puerto Rico and Virgin Is.' ORGANIZATION 'EPSG' IDENTIFIED BY 2866 DEFINITION 'PROJCS["NAD83(HARN) / Puerto Rico and Virgin Is.",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",17.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-66.4333333333334,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",18.4333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",18.0444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",200000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",200000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2866"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2867 NAME 'NAD83(HARN) / Arizona East (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2867 DEFINITION 'PROJCS["NAD83(HARN) / Arizona East (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-110.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2867"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2868 NAME 'NAD83(HARN) / Arizona Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2868 DEFINITION 'PROJCS["NAD83(HARN) / Arizona Central (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111.927777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2868"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2869 NAME 'NAD83(HARN) / Arizona West (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2869 DEFINITION 'PROJCS["NAD83(HARN) / Arizona West (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-113.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",700000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2869"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2870 NAME 'NAD83(HARN) / California zone 1 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2870 DEFINITION 'PROJCS["NAD83(HARN) / California zone 1 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2870"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2871 NAME 'NAD83(HARN) / California zone 2 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2871 DEFINITION 'PROJCS["NAD83(HARN) / California zone 2 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-122,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2871"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2872 NAME 'NAD83(HARN) / California zone 3 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2872 DEFINITION 'PROJCS["NAD83(HARN) / California zone 3 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.0777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2872"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2873 NAME 'NAD83(HARN) / California zone 4 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2873 DEFINITION 'PROJCS["NAD83(HARN) / California zone 4 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-119,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.2611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2873"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2874 NAME 'NAD83(HARN) / California zone 5 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2874 DEFINITION 'PROJCS["NAD83(HARN) / California zone 5 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-118,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.4666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2874"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2875 NAME 'NAD83(HARN) / California zone 6 (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2875 DEFINITION 'PROJCS["NAD83(HARN) / California zone 6 (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",32.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-116.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.7944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",6561666.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2875"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2876 NAME 'NAD83(HARN) / Colorado North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2876 DEFINITION 'PROJCS["NAD83(HARN) / Colorado North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",39.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2876"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2877 NAME 'NAD83(HARN) / Colorado Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2877 DEFINITION 'PROJCS["NAD83(HARN) / Colorado Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.75,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2877"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2878 NAME 'NAD83(HARN) / Colorado South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2878 DEFINITION 'PROJCS["NAD83(HARN) / Colorado South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-105.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.4444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",3000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1000000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2878"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2879 NAME 'NAD83(HARN) / Connecticut (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2879 DEFINITION 'PROJCS["NAD83(HARN) / Connecticut (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-72.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.8666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",500000,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2879"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2880 NAME 'NAD83(HARN) / Delaware (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2880 DEFINITION 'PROJCS["NAD83(HARN) / Delaware (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75.4166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2880"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2881 NAME 'NAD83(HARN) / Florida East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2881 DEFINITION 'PROJCS["NAD83(HARN) / Florida East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2881"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2882 NAME 'NAD83(HARN) / Florida West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2882 DEFINITION 'PROJCS["NAD83(HARN) / Florida West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.3444444444444,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999941177,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2882"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2883 NAME 'NAD83(HARN) / Florida North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2883 DEFINITION 'PROJCS["NAD83(HARN) / Florida North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.7611111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",29.5833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2883"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2884 NAME 'NAD83(HARN) / Georgia East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2884 DEFINITION 'PROJCS["NAD83(HARN) / Georgia East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-82.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2884"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2885 NAME 'NAD83(HARN) / Georgia West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2885 DEFINITION 'PROJCS["NAD83(HARN) / Georgia West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",30,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-84.1777777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2885"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2886 NAME 'NAD83(HARN) / Idaho East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2886 DEFINITION 'PROJCS["NAD83(HARN) / Idaho East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-112.177777777778,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",656166.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2886"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2887 NAME 'NAD83(HARN) / Idaho Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2887 DEFINITION 'PROJCS["NAD83(HARN) / Idaho Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-114,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999947368,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2887"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2888 NAME 'NAD83(HARN) / Idaho West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2888 DEFINITION 'PROJCS["NAD83(HARN) / Idaho West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",41.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-115.75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999933333,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2624666.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2888"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2891 NAME 'NAD83(HARN) / Kentucky North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2891 DEFINITION 'PROJCS["NAD83(HARN) / Kentucky North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.25,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.9777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2891"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2892 NAME 'NAD83(HARN) / Kentucky South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2892 DEFINITION 'PROJCS["NAD83(HARN) / Kentucky South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-85.75,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",1640416.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2892"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2893 NAME 'NAD83(HARN) / Maryland (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2893 DEFINITION 'PROJCS["NAD83(HARN) / Maryland (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-77,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.45,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.3111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1312333.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2893"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2894 NAME 'NAD83(HARN) / Massachusetts Mainland (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2894 DEFINITION 'PROJCS["NAD83(HARN) / Massachusetts Mainland (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-71.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",42.6944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",2460625,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2894"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2895 NAME 'NAD83(HARN) / Massachusetts Island (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2895 DEFINITION 'PROJCS["NAD83(HARN) / Massachusetts Island (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-70.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",41.2833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2895"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2896 NAME 'NAD83(HARN) / Michigan North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2896 DEFINITION 'PROJCS["NAD83(HARN) / Michigan North (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.7944444444444,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-87,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.0944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.4944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",26246719.16,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2896"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2897 NAME 'NAD83(HARN) / Michigan Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2897 DEFINITION 'PROJCS["NAD83(HARN) / Michigan Central (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.3277777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.7,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",19685039.37,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2897"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2898 NAME 'NAD83(HARN) / Michigan South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2898 DEFINITION 'PROJCS["NAD83(HARN) / Michigan South (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.5111111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-84.3777777777778,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43.6777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.1,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",13123359.58,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2898"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2899 NAME 'NAD83(HARN) / Mississippi East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2899 DEFINITION 'PROJCS["NAD83(HARN) / Mississippi East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-88.8333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",984250,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2899"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2900 NAME 'NAD83(HARN) / Mississippi West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2900 DEFINITION 'PROJCS["NAD83(HARN) / Mississippi West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",29.5,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-90.3333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99995,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2296583.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2900"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2901 NAME 'NAD83(HARN) / Montana (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2901 DEFINITION 'PROJCS["NAD83(HARN) / Montana (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",44.2611111111111,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-109.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",49,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2901"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2902 NAME 'NAD83(HARN) / New Mexico East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2902 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-104.333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999909091,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",541337.5,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2902"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2903 NAME 'NAD83(HARN) / New Mexico Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2903 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-106.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1640416.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2903"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2904 NAME 'NAD83(HARN) / New Mexico West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2904 DEFINITION 'PROJCS["NAD83(HARN) / New Mexico West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",31,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-107.833333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999916667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2723091.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2904"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2905 NAME 'NAD83(HARN) / New York East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2905 DEFINITION 'PROJCS["NAD83(HARN) / New York East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",38.8333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-74.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",492125,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2905"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2906 NAME 'NAD83(HARN) / New York Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2906 DEFINITION 'PROJCS["NAD83(HARN) / New York Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",820208.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2906"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2907 NAME 'NAD83(HARN) / New York West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2907 DEFINITION 'PROJCS["NAD83(HARN) / New York West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",40,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-78.5944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999375,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1148291.667,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2907"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2908 NAME 'NAD83(HARN) / New York Long Island (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2908 DEFINITION 'PROJCS["NAD83(HARN) / New York Long Island (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-74,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.0333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.6777777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2908"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2909 NAME 'NAD83(HARN) / North Dakota North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2909 DEFINITION 'PROJCS["NAD83(HARN) / North Dakota North (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.4444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2909"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2910 NAME 'NAD83(HARN) / North Dakota South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2910 DEFINITION 'PROJCS["NAD83(HARN) / North Dakota South (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.4944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",46.1944444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968503.937,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2910"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2911 NAME 'NAD83(HARN) / Oklahoma North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2911 DEFINITION 'PROJCS["NAD83(HARN) / Oklahoma North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",35,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2911"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2912 NAME 'NAD83(HARN) / Oklahoma South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2912 DEFINITION 'PROJCS["NAD83(HARN) / Oklahoma South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",33.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",35.2333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",33.9333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2912"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2913 NAME 'NAD83(HARN) / Oregon North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2913 DEFINITION 'PROJCS["NAD83(HARN) / Oregon North (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",8202099.738,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2913"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2914 NAME 'NAD83(HARN) / Oregon South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2914 DEFINITION 'PROJCS["NAD83(HARN) / Oregon South (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.3333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",4921259.843,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2914"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2915 NAME 'NAD83(HARN) / Tennessee (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2915 DEFINITION 'PROJCS["NAD83(HARN) / Tennessee (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-86,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.4166666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",35.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2915"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2916 NAME 'NAD83(HARN) / Texas North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2916 DEFINITION 'PROJCS["NAD83(HARN) / Texas North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",34,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-101.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",36.1944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",34.65,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",656166.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2916"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2917 NAME 'NAD83(HARN) / Texas North Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2917 DEFINITION 'PROJCS["NAD83(HARN) / Texas North Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",31.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",33.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",32.1444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2917"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2918 NAME 'NAD83(HARN) / Texas Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2918 DEFINITION 'PROJCS["NAD83(HARN) / Texas Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",29.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-100.333333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",31.8833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",30.1166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",2296583.333,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842500,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2918"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2919 NAME 'NAD83(HARN) / Texas South Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2919 DEFINITION 'PROJCS["NAD83(HARN) / Texas South Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",27.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-99,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",30.2833333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",28.3833333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",13123333.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2919"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2920 NAME 'NAD83(HARN) / Texas South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2920 DEFINITION 'PROJCS["NAD83(HARN) / Texas South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",25.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-98.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",27.8333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",26.1666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",984250,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",16404166.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2920"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2921 NAME 'NAD83(HARN) / Utah North (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2921 DEFINITION 'PROJCS["NAD83(HARN) / Utah North (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",40.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",41.7944444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",40.7277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280839.895,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2921"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2922 NAME 'NAD83(HARN) / Utah Central (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2922 DEFINITION 'PROJCS["NAD83(HARN) / Utah Central (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",38.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",40.65,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",39.0277777777778,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561679.79,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2922"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2923 NAME 'NAD83(HARN) / Utah South (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2923 DEFINITION 'PROJCS["NAD83(HARN) / Utah South (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-111.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",38.35,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",37.2166666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640419.948,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",9842519.685,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2923"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2924 NAME 'NAD83(HARN) / Virginia North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2924 DEFINITION 'PROJCS["NAD83(HARN) / Virginia North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",37.6777777777778,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",39.2111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",38.0333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",6561666.667,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2924"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2925 NAME 'NAD83(HARN) / Virginia South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2925 DEFINITION 'PROJCS["NAD83(HARN) / Virginia South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",36.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-78.5111111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",37.9777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",36.7666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",11482916.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",3280833.333,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2925"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2926 NAME 'NAD83(HARN) / Washington North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2926 DEFINITION 'PROJCS["NAD83(HARN) / Washington North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",47,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.833333333333,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",48.7444444444444,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",47.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2926"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2927 NAME 'NAD83(HARN) / Washington South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2927 DEFINITION 'PROJCS["NAD83(HARN) / Washington South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.3333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",47.3333333333333,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.8333333333333,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1640416.667,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2927"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2928 NAME 'NAD83(HARN) / Wisconsin North (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2928 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin North (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",45.1666666666667,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",46.7666666666667,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5666666666667,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2928"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2929 NAME 'NAD83(HARN) / Wisconsin Central (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2929 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin Central (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",43.8333333333333,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",45.5111111111111,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",44.2611111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2929"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2930 NAME 'NAD83(HARN) / Wisconsin South (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2930 DEFINITION 'PROJCS["NAD83(HARN) / Wisconsin South (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",42,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-90,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",44.0777777777778,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",42.7444444444444,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1968500,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2930"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2931 NAME 'Beduaram / TM 13 NE' ORGANIZATION 'EPSG' IDENTIFIED BY 2931 DEFINITION 'PROJCS["Beduaram / TM 13 NE",GEOGCS["Beduaram",DATUM["Beduaram",SPHEROID["Clarke 1880 (IGN)",6378249.2,293.4660212936269,AUTHORITY["EPSG","7011"]],TOWGS84[-106,-87,188,0,0,0,0],AUTHORITY["EPSG","6213"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4213"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",13,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2931"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2932 NAME 'QND95 / Qatar National Grid' ORGANIZATION 'EPSG' IDENTIFIED BY 2932 DEFINITION 'PROJCS["QND95 / Qatar National Grid",GEOGCS["QND95",DATUM["Qatar National Datum 1995",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,3.657065],AUTHORITY["EPSG","6614"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4614"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",24.4611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",51.2166666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.99999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",200000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",300000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2932"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2933 NAME 'Segara / UTM zone 50S' ORGANIZATION 'EPSG' IDENTIFIED BY 2933 DEFINITION 'PROJCS["Segara / UTM zone 50S",GEOGCS["Segara",DATUM["Gunung Segara",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY["EPSG","6613"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4613"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2933"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2935 NAME 'Pulkovo 1942 / CS63 zone A1' ORGANIZATION 'EPSG' IDENTIFIED BY 2935 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone A1",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.116666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",41.5333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2935"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2936 NAME 'Pulkovo 1942 / CS63 zone A2' ORGANIZATION 'EPSG' IDENTIFIED BY 2936 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone A2",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.116666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",44.5333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2936"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2937 NAME 'Pulkovo 1942 / CS63 zone A3' ORGANIZATION 'EPSG' IDENTIFIED BY 2937 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone A3",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.116666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",47.5333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2937"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2938 NAME 'Pulkovo 1942 / CS63 zone A4' ORGANIZATION 'EPSG' IDENTIFIED BY 2938 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone A4",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.116666666666667,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",50.5333333333333,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2938"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2939 NAME 'Pulkovo 1942 / CS63 zone K2' ORGANIZATION 'EPSG' IDENTIFIED BY 2939 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone K2",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.133333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",50.7666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2939"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2940 NAME 'Pulkovo 1942 / CS63 zone K3' ORGANIZATION 'EPSG' IDENTIFIED BY 2940 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone K3",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.133333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",53.7666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2940"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2941 NAME 'Pulkovo 1942 / CS63 zone K4' ORGANIZATION 'EPSG' IDENTIFIED BY 2941 DEFINITION 'PROJCS["Pulkovo 1942 / CS63 zone K4",GEOGCS["Pulkovo 1942",DATUM["Pulkovo 1942",SPHEROID["Krassowsky 1940",6378245,298.3,AUTHORITY["EPSG","7024"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY["EPSG","6284"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4284"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0.133333333333333,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",56.7666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",4300000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",EAST],AUTHORITY["EPSG","2941"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2942 NAME 'Porto Santo / UTM zone 28N' ORGANIZATION 'EPSG' IDENTIFIED BY 2942 DEFINITION 'PROJCS["Porto Santo / UTM zone 28N",GEOGCS["Porto Santo",DATUM["Porto Santo 1936",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-499,-249,314,0,0,0,0],AUTHORITY["EPSG","6615"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4615"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2942"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2943 NAME 'Selvagem Grande / UTM zone 28N' ORGANIZATION 'EPSG' IDENTIFIED BY 2943 DEFINITION 'PROJCS["Selvagem Grande / UTM zone 28N",GEOGCS["Selvagem Grande",DATUM["Selvagem Grande",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-289,-124,60,0,0,0,0],AUTHORITY["EPSG","6616"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4616"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2943"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2945 NAME 'NAD83(CSRS) / MTM zone 3' ORGANIZATION 'EPSG' IDENTIFIED BY 2945 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 3",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-58.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2945"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2946 NAME 'NAD83(CSRS) / MTM zone 4' ORGANIZATION 'EPSG' IDENTIFIED BY 2946 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 4",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-61.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2946"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2947 NAME 'NAD83(CSRS) / MTM zone 5' ORGANIZATION 'EPSG' IDENTIFIED BY 2947 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 5",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-64.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2947"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2948 NAME 'NAD83(CSRS) / MTM zone 6' ORGANIZATION 'EPSG' IDENTIFIED BY 2948 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 6",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-67.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2948"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2949 NAME 'NAD83(CSRS) / MTM zone 7' ORGANIZATION 'EPSG' IDENTIFIED BY 2949 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 7",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-70.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2949"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2950 NAME 'NAD83(CSRS) / MTM zone 8' ORGANIZATION 'EPSG' IDENTIFIED BY 2950 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 8",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-73.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2950"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2951 NAME 'NAD83(CSRS) / MTM zone 9' ORGANIZATION 'EPSG' IDENTIFIED BY 2951 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 9",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-76.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2951"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2952 NAME 'NAD83(CSRS) / MTM zone 10' ORGANIZATION 'EPSG' IDENTIFIED BY 2952 DEFINITION 'PROJCS["NAD83(CSRS) / MTM zone 10",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-79.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9999,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",304800,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2952"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2953 NAME 'NAD83(CSRS) / New Brunswick Stereographic' ORGANIZATION 'EPSG' IDENTIFIED BY 2953 DEFINITION 'PROJCS["NAD83(CSRS) / New Brunswick Stereographic",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",46.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-66.5111111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",7500000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","2953"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2954 NAME 'NAD83(CSRS) / Prince Edward Isl. Stereographic (NAD83)' ORGANIZATION 'EPSG' IDENTIFIED BY 2954 DEFINITION 'PROJCS["NAD83(CSRS) / Prince Edward Isl. Stereographic (NAD83)",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Oblique Stereographic",AUTHORITY["EPSG","9809"]],PARAMETER["Latitude of natural origin",47.2611111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999912,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",400000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",800000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E(X)",EAST],AXIS["N(Y)",NORTH],AUTHORITY["EPSG","2954"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2955 NAME 'NAD83(CSRS) / UTM zone 11N' ORGANIZATION 'EPSG' IDENTIFIED BY 2955 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 11N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-117,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2955"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2956 NAME 'NAD83(CSRS) / UTM zone 12N' ORGANIZATION 'EPSG' IDENTIFIED BY 2956 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 12N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2956"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2957 NAME 'NAD83(CSRS) / UTM zone 13N' ORGANIZATION 'EPSG' IDENTIFIED BY 2957 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 13N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-105,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2957"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2958 NAME 'NAD83(CSRS) / UTM zone 17N' ORGANIZATION 'EPSG' IDENTIFIED BY 2958 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 17N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-81,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2958"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2959 NAME 'NAD83(CSRS) / UTM zone 18N' ORGANIZATION 'EPSG' IDENTIFIED BY 2959 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 18N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-75,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2959"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2960 NAME 'NAD83(CSRS) / UTM zone 19N' ORGANIZATION 'EPSG' IDENTIFIED BY 2960 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 19N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-69,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2960"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2961 NAME 'NAD83(CSRS) / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2961 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 20N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2961"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2962 NAME 'NAD83(CSRS) / UTM zone 21N' ORGANIZATION 'EPSG' IDENTIFIED BY 2962 DEFINITION 'PROJCS["NAD83(CSRS) / UTM zone 21N",GEOGCS["NAD83(CSRS)",DATUM["NAD83 Canadian Spatial Reference System",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[-0.991,1.9072,0.5129,0.0257899075194932,0.00965009896027041,0.0116599432323421,0],AUTHORITY["EPSG","6140"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4617"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2962"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2963 NAME 'Lisbon 1890 (Lisbon) / Portugal Bonne' ORGANIZATION 'EPSG' IDENTIFIED BY 2963 DEFINITION 'PROJCS["Lisbon 1890 (Lisbon) / Portugal Bonne",GEOGCS["Lisbon 1890 (Lisbon)",DATUM["Lisbon 1890 (Lisbon)",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],AUTHORITY["EPSG","6904"]],PRIMEM["Lisbon",-9.131906111111112,AUTHORITY["EPSG","8902"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4904"]],PROJECTION["Bonne (South Orientated)",AUTHORITY["EPSG","9828"]],PARAMETER["Latitude of natural origin",39.6777777777778,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",1,AUTHORITY["EPSG","8802"]],PARAMETER["False easting",0,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["P",SOUTH],AXIS["M",WEST],AUTHORITY["EPSG","2963"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2964 NAME 'NAD27 / Alaska Albers' ORGANIZATION 'EPSG' IDENTIFIED BY 2964 DEFINITION 'PROJCS["NAD27 / Alaska Albers",GEOGCS["NAD27",DATUM["North American Datum 1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[-32.3841359,180.4090461,120.8442577,-2.1545854,-0.1498782,0.5742915,8.1049164],AUTHORITY["EPSG","6267"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4267"]],PROJECTION["Albers Equal Area",AUTHORITY["EPSG","9822"]],PARAMETER["Latitude of false origin",50,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-154,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",55,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",65,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",0,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2964"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2965 NAME 'NAD83 / Indiana East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2965 DEFINITION 'PROJCS["NAD83 / Indiana East (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.6666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",328083.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",820208.333,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2965"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2966 NAME 'NAD83 / Indiana West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2966 DEFINITION 'PROJCS["NAD83 / Indiana West (ftUS)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.0944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2952750,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",820208.333,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2966"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2967 NAME 'NAD83(HARN) / Indiana East (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2967 DEFINITION 'PROJCS["NAD83(HARN) / Indiana East (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-85.6666666666667,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",328083.333,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",820208.333,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2967"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2968 NAME 'NAD83(HARN) / Indiana West (ftUS)' ORGANIZATION 'EPSG' IDENTIFIED BY 2968 DEFINITION 'PROJCS["NAD83(HARN) / Indiana West (ftUS)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",37.5111111111111,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-87.0944444444444,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.999966667,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2952750,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",820208.333,AUTHORITY["EPSG","8807"]],UNIT["US survey foot",0.30480060960121924,AUTHORITY["EPSG","9003"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2968"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2969 NAME 'Fort Marigot / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2969 DEFINITION 'PROJCS["Fort Marigot / UTM zone 20N",GEOGCS["Fort Marigot",DATUM["Fort Marigot",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[137,248,-430,0,0,0,0],AUTHORITY["EPSG","6621"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4621"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2969"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2970 NAME 'Guadeloupe 1948 / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2970 DEFINITION 'PROJCS["Guadeloupe 1948 / UTM zone 20N",GEOGCS["Guadeloupe 1948",DATUM["Guadeloupe 1948",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,1.8984],AUTHORITY["EPSG","6622"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4622"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2970"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2971 NAME 'CSG67 / UTM zone 22N' ORGANIZATION 'EPSG' IDENTIFIED BY 2971 DEFINITION 'PROJCS["CSG67 / UTM zone 22N",GEOGCS["CSG67",DATUM["Centre Spatial Guyanais 1967",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-186,230,110,0,0,0,0],AUTHORITY["EPSG","6623"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4623"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2971"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2972 NAME 'RGFG95 / UTM zone 22N' ORGANIZATION 'EPSG' IDENTIFIED BY 2972 DEFINITION 'PROJCS["RGFG95 / UTM zone 22N",GEOGCS["RGFG95",DATUM["Reseau Geodesique Francais Guyane 1995",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6624"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4624"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-51,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2972"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2973 NAME 'Martinique 1938 / UTM zone 20N' ORGANIZATION 'EPSG' IDENTIFIED BY 2973 DEFINITION 'PROJCS["Martinique 1938 / UTM zone 20N",GEOGCS["Martinique 1938",DATUM["Martinique 1938",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[126.93,547.94,130.41,-2.7867,5.1612,-0.8584,13.8227],AUTHORITY["EPSG","6625"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4625"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-63,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2973"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2975 NAME 'RGR92 / UTM zone 40S' ORGANIZATION 'EPSG' IDENTIFIED BY 2975 DEFINITION 'PROJCS["RGR92 / UTM zone 40S",GEOGCS["RGR92",DATUM["Reseau Geodesique de la Reunion 1992",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6627"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4627"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2975"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2976 NAME 'Tahiti 52 / UTM zone 6S' ORGANIZATION 'EPSG' IDENTIFIED BY 2976 DEFINITION 'PROJCS["Tahiti 52 / UTM zone 6S",GEOGCS["Tahiti 52",DATUM["Tahiti 52",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[162,117,154,0,0,0,0],AUTHORITY["EPSG","6628"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4628"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-147,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2976"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2977 NAME 'Tahaa 54 / UTM zone 5S' ORGANIZATION 'EPSG' IDENTIFIED BY 2977 DEFINITION 'PROJCS["Tahaa 54 / UTM zone 5S",GEOGCS["Tahaa 54",DATUM["Tahaa 54",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[72.438,345.918,79.486,1.6045,0.8823,0.5565,1.3746],AUTHORITY["EPSG","6629"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4629"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-153,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2977"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2978 NAME 'IGN72 Nuku Hiva / UTM zone 7S' ORGANIZATION 'EPSG' IDENTIFIED BY 2978 DEFINITION 'PROJCS["IGN72 Nuku Hiva / UTM zone 7S",GEOGCS["IGN72 Nuku Hiva",DATUM["IGN72 Nuku Hiva",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[84,274,65,0,0,0,0],AUTHORITY["EPSG","6630"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4630"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-141,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2978"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2980 NAME 'Combani 1950 / UTM zone 38S' ORGANIZATION 'EPSG' IDENTIFIED BY 2980 DEFINITION 'PROJCS["Combani 1950 / UTM zone 38S",GEOGCS["Combani 1950",DATUM["Combani 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-382,-59,-262,0,0,0,0],AUTHORITY["EPSG","6632"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4632"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2980"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2981 NAME 'IGN56 Lifou / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2981 DEFINITION 'PROJCS["IGN56 Lifou / UTM zone 58S",GEOGCS["IGN56 Lifou",DATUM["IGN56 Lifou",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[137.092,131.66,91.475,-1.9436,-11.5993,-4.3321,-7.4824],AUTHORITY["EPSG","6633"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4633"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2981"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2985 NAME 'Petrels 1972 / Terre Adelie Polar Stereographic' ORGANIZATION 'EPSG' IDENTIFIED BY 2985 DEFINITION 'PROJCS["Petrels 1972 / Terre Adelie Polar Stereographic",GEOGCS["Petrels 1972",DATUM["Petrels 1972",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[365,194,166,0,0,0,0],AUTHORITY["EPSG","6636"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4636"]],PROJECTION["Polar Stereographic (variant C)",AUTHORITY["EPSG","9830"]],PARAMETER["Latitude of standard parallel",-67,AUTHORITY["EPSG","8832"]],PARAMETER["Longitude of origin",140,AUTHORITY["EPSG","8833"]],PARAMETER["Easting at false origin",300000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",200000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",NORTH],AUTHORITY["EPSG","2985"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2986 NAME 'Perroud 1950 / Terre Adelie Polar Stereographic' ORGANIZATION 'EPSG' IDENTIFIED BY 2986 DEFINITION 'PROJCS["Perroud 1950 / Terre Adelie Polar Stereographic",GEOGCS["Perroud 1950",DATUM["Pointe Geologie Perroud 1950",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[325,154,172,0,0,0,0],AUTHORITY["EPSG","6637"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4637"]],PROJECTION["Polar Stereographic (variant C)",AUTHORITY["EPSG","9830"]],PARAMETER["Latitude of standard parallel",-67,AUTHORITY["EPSG","8832"]],PARAMETER["Longitude of origin",140,AUTHORITY["EPSG","8833"]],PARAMETER["Easting at false origin",300000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",200000,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",NORTH],AXIS["Y",NORTH],AUTHORITY["EPSG","2986"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2987 NAME 'Saint Pierre et Miquelon 1950 / UTM zone 21N' ORGANIZATION 'EPSG' IDENTIFIED BY 2987 DEFINITION 'PROJCS["Saint Pierre et Miquelon 1950 / UTM zone 21N",GEOGCS["Saint Pierre et Miquelon 1950",DATUM["Saint Pierre et Miquelon 1950",SPHEROID["Clarke 1866",6378206.4,294.9786982138982,AUTHORITY["EPSG","7008"]],TOWGS84[11.363,424.148,373.13,0,0,0,0],AUTHORITY["EPSG","6638"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4638"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-57,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2987"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2988 NAME 'MOP78 / UTM zone 1S' ORGANIZATION 'EPSG' IDENTIFIED BY 2988 DEFINITION 'PROJCS["MOP78 / UTM zone 1S",GEOGCS["MOP78",DATUM["MOP78",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[253,-132,-127,0,0,0,0],AUTHORITY["EPSG","6639"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4639"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",-177,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2988"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2991 NAME 'NAD83 / Oregon LCC (m)' ORGANIZATION 'EPSG' IDENTIFIED BY 2991 DEFINITION 'PROJCS["NAD83 / Oregon LCC (m)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2991"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2992 NAME 'NAD83 / Oregon GIC Lambert (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2992 DEFINITION 'PROJCS["NAD83 / Oregon GIC Lambert (ft)",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1312335.958,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2992"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2993 NAME 'NAD83(HARN) / Oregon LCC (m)' ORGANIZATION 'EPSG' IDENTIFIED BY 2993 DEFINITION 'PROJCS["NAD83(HARN) / Oregon LCC (m)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",400000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2993"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2994 NAME 'NAD83(HARN) / Oregon GIC Lambert (ft)' ORGANIZATION 'EPSG' IDENTIFIED BY 2994 DEFINITION 'PROJCS["NAD83(HARN) / Oregon GIC Lambert (ft)",GEOGCS["NAD83(HARN)",DATUM["NAD83 (High Accuracy Reference Network)",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6152"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4152"]],PROJECTION["Lambert Conic Conformal (2SP)",AUTHORITY["EPSG","9802"]],PARAMETER["Latitude of false origin",41.75,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-120.511111111111,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",43,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",45.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1312335.958,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["foot",0.3048,AUTHORITY["EPSG","9002"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","2994"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2995 NAME 'IGN53 Mare / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2995 DEFINITION 'PROJCS["IGN53 Mare / UTM zone 58S",GEOGCS["IGN53 Mare",DATUM["IGN53 Mare",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-408.809,366.856,-412.987,1.8842,-0.5308,2.1655,-121.0993],AUTHORITY["EPSG","6641"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4641"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2995"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2996 NAME 'ST84 Ile des Pins / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2996 DEFINITION 'PROJCS["ST84 Ile des Pins / UTM zone 58S",GEOGCS["ST84 Ile des Pins",DATUM["ST84 Ile des Pins",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-13,-348,292,0,0,0,0],AUTHORITY["EPSG","6642"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4642"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2996"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2997 NAME 'ST71 Belep / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2997 DEFINITION 'PROJCS["ST71 Belep / UTM zone 58S",GEOGCS["ST71 Belep",DATUM["ST71 Belep",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7002],AUTHORITY["EPSG","6643"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4643"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2997"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2998 NAME 'NEA74 Noumea / UTM zone 58S' ORGANIZATION 'EPSG' IDENTIFIED BY 2998 DEFINITION 'PROJCS["NEA74 Noumea / UTM zone 58S",GEOGCS["NEA74 Noumea",DATUM["NEA74 Noumea",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-10.18,-350.43,291.37,0,0,0,0],AUTHORITY["EPSG","6644"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4644"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",165,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2998"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 2999 NAME 'Grand Comoros / UTM zone 38S' ORGANIZATION 'EPSG' IDENTIFIED BY 2999 DEFINITION 'PROJCS["Grand Comoros / UTM zone 38S",GEOGCS["Grand Comoros",DATUM["Grand Comoros",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-963,510,-359,0,0,0,0],AUTHORITY["EPSG","6646"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4646"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",45,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",10000000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","2999"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3000 NAME 'Segara / NEIEZ' ORGANIZATION 'EPSG' IDENTIFIED BY 3000 DEFINITION 'PROJCS["Segara / NEIEZ",GEOGCS["Segara",DATUM["Gunung Segara",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY["EPSG","6613"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4613"]],PROJECTION["Mercator (variant A)",AUTHORITY["EPSG","9804"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",110,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.997,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",900000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","3000"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3001 NAME 'Batavia / NEIEZ' ORGANIZATION 'EPSG' IDENTIFIED BY 3001 DEFINITION 'PROJCS["Batavia / NEIEZ",GEOGCS["Batavia",DATUM["Batavia",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-377.7,675.1,-52.2,0,0,0,0],AUTHORITY["EPSG","6211"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4211"]],PROJECTION["Mercator (variant A)",AUTHORITY["EPSG","9804"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",110,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.997,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",900000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","3001"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3002 NAME 'Makassar / NEIEZ' ORGANIZATION 'EPSG' IDENTIFIED BY 3002 DEFINITION 'PROJCS["Makassar / NEIEZ",GEOGCS["Makassar",DATUM["Makassar",SPHEROID["Bessel 1841",6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],AUTHORITY["EPSG","6257"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4257"]],PROJECTION["Mercator (variant A)",AUTHORITY["EPSG","9804"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",110,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.997,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",3900000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",900000,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","3002"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3003 NAME 'Monte Mario / Italy zone 1' ORGANIZATION 'EPSG' IDENTIFIED BY 3003 DEFINITION 'PROJCS["Monte Mario / Italy zone 1",GEOGCS["Monte Mario",DATUM["Monte Mario",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68],AUTHORITY["EPSG","6265"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4265"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",9,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",1500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","3003"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3004 NAME 'Monte Mario / Italy zone 2' ORGANIZATION 'EPSG' IDENTIFIED BY 3004 DEFINITION 'PROJCS["Monte Mario / Italy zone 2",GEOGCS["Monte Mario",DATUM["Monte Mario",SPHEROID["International 1924",6378388,297,AUTHORITY["EPSG","7022"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68],AUTHORITY["EPSG","6265"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4265"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",2520000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],AUTHORITY["EPSG","3004"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3005 NAME 'NAD83 / BC Albers' ORGANIZATION 'EPSG' IDENTIFIED BY 3005 DEFINITION 'PROJCS["NAD83 / BC Albers",GEOGCS["NAD83",DATUM["North American Datum 1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[1,1,-1,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4269"]],PROJECTION["Albers Equal Area",AUTHORITY["EPSG","9822"]],PARAMETER["Latitude of false origin",45,AUTHORITY["EPSG","8821"]],PARAMETER["Longitude of false origin",-126,AUTHORITY["EPSG","8822"]],PARAMETER["Latitude of 1st standard parallel",50,AUTHORITY["EPSG","8823"]],PARAMETER["Latitude of 2nd standard parallel",58.5111111111111,AUTHORITY["EPSG","8824"]],PARAMETER["Easting at false origin",1000000,AUTHORITY["EPSG","8826"]],PARAMETER["Northing at false origin",0,AUTHORITY["EPSG","8827"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["E",EAST],AXIS["N",NORTH],AUTHORITY["EPSG","3005"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3006 NAME 'SWEREF99 TM' ORGANIZATION 'EPSG' IDENTIFIED BY 3006 DEFINITION 'PROJCS["SWEREF99 TM",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",0.9996,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",500000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3006"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3007 NAME 'SWEREF99 12 00' ORGANIZATION 'EPSG' IDENTIFIED BY 3007 DEFINITION 'PROJCS["SWEREF99 12 00",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",12,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3007"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3008 NAME 'SWEREF99 13 30' ORGANIZATION 'EPSG' IDENTIFIED BY 3008 DEFINITION 'PROJCS["SWEREF99 13 30",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",13.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3008"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3009 NAME 'SWEREF99 15 00' ORGANIZATION 'EPSG' IDENTIFIED BY 3009 DEFINITION 'PROJCS["SWEREF99 15 00",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3009"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3010 NAME 'SWEREF99 16 30' ORGANIZATION 'EPSG' IDENTIFIED BY 3010 DEFINITION 'PROJCS["SWEREF99 16 30",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",16.5,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3010"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3011 NAME 'SWEREF99 18 00' ORGANIZATION 'EPSG' IDENTIFIED BY 3011 DEFINITION 'PROJCS["SWEREF99 18 00",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3011"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3012 NAME 'SWEREF99 14 15' ORGANIZATION 'EPSG' IDENTIFIED BY 3012 DEFINITION 'PROJCS["SWEREF99 14 15",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",14.25,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3012"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3013 NAME 'SWEREF99 15 45' ORGANIZATION 'EPSG' IDENTIFIED BY 3013 DEFINITION 'PROJCS["SWEREF99 15 45",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",15.7611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3013"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3014 NAME 'SWEREF99 17 15' ORGANIZATION 'EPSG' IDENTIFIED BY 3014 DEFINITION 'PROJCS["SWEREF99 17 15",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",17.2611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3014"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3015 NAME 'SWEREF99 18 45' ORGANIZATION 'EPSG' IDENTIFIED BY 3015 DEFINITION 'PROJCS["SWEREF99 18 45",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",18.7611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3015"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3016 NAME 'SWEREF99 20 15' ORGANIZATION 'EPSG' IDENTIFIED BY 3016 DEFINITION 'PROJCS["SWEREF99 20 15",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",20.2611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3016"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3017 NAME 'SWEREF99 21 45' ORGANIZATION 'EPSG' IDENTIFIED BY 3017 DEFINITION 'PROJCS["SWEREF99 21 45",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",21.7611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3017"]]';
CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 3018 NAME 'SWEREF99 23 15' ORGANIZATION 'EPSG' IDENTIFIED BY 3018 DEFINITION 'PROJCS["SWEREF99 23 15",GEOGCS["SWEREF99",DATUM["SWEREF99",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6619"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],AUTHORITY["EPSG","4619"]],PROJECTION["Transverse Mercator",AUTHORITY["EPSG","9807"]],PARAMETER["Latitude of natural origin",0,AUTHORITY["EPSG","8801"]],PARAMETER["Longitude of natural origin",23.2611111111111,AUTHORITY["EPSG","8802"]],PARAMETER["Scale factor at natural origin",1,AUTHORITY["EPSG","8805"]],PARAMETER["False easting",150000,AUTHORITY["EPSG","8806"]],PARAMETER["False northing",0,AUTHORITY["EPSG","8807"]],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["N",NORTH],AXIS["E",EAST],AUTHORITY["EPSG","3