.TH "ZIP_FILE_GET_EXTERNAL_ATTRIBUTES" "3" "December 29, 2016" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_get_external_attributes\fR
\- get external attributes for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.PD 0
.HP 4n
\fBzip_file_get_external_attributes\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_flags_t\ flags\fR, \fIzip_uint8_t\ *opsys\fR, \fIzip_uint32_t\ *attributes\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_get_external_attributes\fR()
function returns the operating system and external attributes for the
file at position
\fIindex\fR
in the zip archive.
The external attributes usually contain the operating system-specific
file permissions.
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged values are returned.
If
\fIopsys\fR
or
\fIattributes\fR
are
\fRNULL\fR,
they are not filled in.
.PP
The following operating systems are defined by the zip specification:
.RS 6n
.PD 0
.PP
\fRZIP_OPSYS_ACORN_RISC\fR
.PP
\fRZIP_OPSYS_ALTERNATE_MVS\fR
.PP
\fRZIP_OPSYS_AMIGA\fR
.PP
\fRZIP_OPSYS_ATARI_ST\fR
.PP
\fRZIP_OPSYS_BEOS\fR
.PP
\fRZIP_OPSYS_CPM\fR
.PP
\fRZIP_OPSYS_DOS\fR
.PP
\fRZIP_OPSYS_MACINTOSH\fR
.PP
\fRZIP_OPSYS_MVS\fR
.PP
\fRZIP_OPSYS_OPENVMS\fR
.PP
\fRZIP_OPSYS_OS_2\fR
.PP
\fRZIP_OPSYS_OS_400\fR
.PP
\fRZIP_OPSYS_OS_X\fR
.PP
\fRZIP_OPSYS_TANDEM\fR
.PP
\fRZIP_OPSYS_UNIX\fR
.PP
\fRZIP_OPSYS_VFAT\fR
.PP
\fRZIP_OPSYS_VM_CMS\fR
.PP
\fRZIP_OPSYS_VSE\fR
.PP
\fRZIP_OPSYS_WINDOWS_NTFS\fR
(uncommon, use
\fRZIP_OPSYS_DOS\fR
instead)
.PP
\fRZIP_OPSYS_Z_SYSTEM\fR
.RE
.PD
.PP
The defines above follow the PKWARE Inc. Appnote; please note that
the InfoZIP Appnote has a slightly different mapping.
.SH "RETURN VALUES"
Upon successful completion, 0 is returned.
In case of an error,
\fR\-1\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "EXAMPLES"
The following code can be used to expand
\fIattributes\fR
if the operating system is
\fRZIP_OPSYS_DOS\fR.
.nf
.sp
.RS 0n
#include <sys/stat.h>

#define FA_RDONLY       0x01            // FILE_ATTRIBUTE_READONLY
#define FA_DIREC        0x10            // FILE_ATTRIBUTE_DIRECTORY

static mode_t
_zip_dos_attr2mode(zip_uint32_t attr)
{
   mode_t m = S_IRUSR | S_IRGRP | S_IROTH;
   if (0 == (attr & FA_RDONLY))
      m |= S_IWUSR | S_IWGRP | S_IWOTH;

   if (attr & FA_DIREC)
      m = (S_IFDIR | (m & ~S_IFMT)) | S_IXUSR | S_IXGRP | S_IXOTH;

   return m;
}
.RE
.fi
.SH "ERRORS"
\fBzip_file_get_external_attributes\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_file_set_external_attributes(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
