"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Qiniu = exports.S3_MODE = exports.KODO_MODE = void 0;
const kodo_1 = require("./kodo");
const s3_1 = require("./s3");
exports.KODO_MODE = 'kodo';
exports.S3_MODE = 's3';
class Qiniu {
    constructor(accessKey, secretKey, ucUrl, appendedUserAgent, regions) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.ucUrl = ucUrl;
        this.appendedUserAgent = appendedUserAgent;
        this.regions = regions || [];
    }
    static register(modeName, adapter) {
        Qiniu.ADAPTERS[modeName] = adapter;
    }
    mode(modeName, options) {
        const adapter = Qiniu.ADAPTERS[modeName];
        if (!adapter) {
            throw new Error(`Invalid qiniu mode: ${modeName}`);
        }
        return new adapter({
            accessKey: this.accessKey,
            secretKey: this.secretKey,
            regions: this.regions,
            ucUrl: this.ucUrl,
            appendedUserAgent: this.appendedUserAgent,
            appName: options === null || options === void 0 ? void 0 : options.appName,
            appVersion: options === null || options === void 0 ? void 0 : options.appVersion,
            uplogBufferSize: options === null || options === void 0 ? void 0 : options.uplogBufferSize,
            requestCallback: options === null || options === void 0 ? void 0 : options.requestCallback,
            responseCallback: options === null || options === void 0 ? void 0 : options.responseCallback,
        });
    }
}
exports.Qiniu = Qiniu;
Qiniu.ADAPTERS = {};
Qiniu.register(exports.KODO_MODE, kodo_1.Kodo);
Qiniu.register(exports.S3_MODE, s3_1.S3);
//# sourceMappingURL=qiniu.js.map