/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1 "k8s.io/ingress-nginx/internal/checksum/ingress/apis/checksum/v1"
	checksumv1 "k8s.io/ingress-nginx/internal/checksum/ingress/client/applyconfiguration/checksum/v1"
	scheme "k8s.io/ingress-nginx/internal/checksum/ingress/client/clientset/versioned/scheme"
)

// IngressCheckSumsGetter has a method to return a IngressCheckSumInterface.
// A group's client should implement this interface.
type IngressCheckSumsGetter interface {
	IngressCheckSums(namespace string) IngressCheckSumInterface
}

// IngressCheckSumInterface has methods to work with IngressCheckSum resources.
type IngressCheckSumInterface interface {
	Create(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.CreateOptions) (*v1.IngressCheckSum, error)
	Update(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.UpdateOptions) (*v1.IngressCheckSum, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.IngressCheckSum, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.IngressCheckSumList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IngressCheckSum, err error)
	Apply(ctx context.Context, ingressCheckSum *checksumv1.IngressCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.IngressCheckSum, err error)
	IngressCheckSumExpansion
}

// ingressCheckSums implements IngressCheckSumInterface
type ingressCheckSums struct {
	client rest.Interface
	ns     string
}

// newIngressCheckSums returns a IngressCheckSums
func newIngressCheckSums(c *TengineV1Client, namespace string) *ingressCheckSums {
	return &ingressCheckSums{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ingressCheckSum, and returns the corresponding ingressCheckSum object, and an error if there is any.
func (c *ingressCheckSums) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.IngressCheckSum, err error) {
	result = &v1.IngressCheckSum{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ingresschecksums").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of IngressCheckSums that match those selectors.
func (c *ingressCheckSums) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IngressCheckSumList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.IngressCheckSumList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ingresschecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ingressCheckSums.
func (c *ingressCheckSums) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("ingresschecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ingressCheckSum and creates it.  Returns the server's representation of the ingressCheckSum, and an error, if there is any.
func (c *ingressCheckSums) Create(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.CreateOptions) (result *v1.IngressCheckSum, err error) {
	result = &v1.IngressCheckSum{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("ingresschecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ingressCheckSum).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ingressCheckSum and updates it. Returns the server's representation of the ingressCheckSum, and an error, if there is any.
func (c *ingressCheckSums) Update(ctx context.Context, ingressCheckSum *v1.IngressCheckSum, opts metav1.UpdateOptions) (result *v1.IngressCheckSum, err error) {
	result = &v1.IngressCheckSum{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ingresschecksums").
		Name(ingressCheckSum.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ingressCheckSum).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ingressCheckSum and deletes it. Returns an error if one occurs.
func (c *ingressCheckSums) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ingresschecksums").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ingressCheckSums) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ingresschecksums").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ingressCheckSum.
func (c *ingressCheckSums) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IngressCheckSum, err error) {
	result = &v1.IngressCheckSum{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("ingresschecksums").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied ingressCheckSum.
func (c *ingressCheckSums) Apply(ctx context.Context, ingressCheckSum *checksumv1.IngressCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.IngressCheckSum, err error) {
	if ingressCheckSum == nil {
		return nil, fmt.Errorf("ingressCheckSum provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(ingressCheckSum)
	if err != nil {
		return nil, err
	}
	name := ingressCheckSum.Name
	if name == nil {
		return nil, fmt.Errorf("ingressCheckSum.Name must be provided to Apply")
	}
	result = &v1.IngressCheckSum{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("ingresschecksums").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
