/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1 "k8s.io/ingress-nginx/internal/checksum/secret/apis/checksum/v1"
	checksumv1 "k8s.io/ingress-nginx/internal/checksum/secret/client/applyconfiguration/checksum/v1"
	scheme "k8s.io/ingress-nginx/internal/checksum/secret/client/clientset/versioned/scheme"
)

// SecretCheckSumsGetter has a method to return a SecretCheckSumInterface.
// A group's client should implement this interface.
type SecretCheckSumsGetter interface {
	SecretCheckSums(namespace string) SecretCheckSumInterface
}

// SecretCheckSumInterface has methods to work with SecretCheckSum resources.
type SecretCheckSumInterface interface {
	Create(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.CreateOptions) (*v1.SecretCheckSum, error)
	Update(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.UpdateOptions) (*v1.SecretCheckSum, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.SecretCheckSum, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.SecretCheckSumList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SecretCheckSum, err error)
	Apply(ctx context.Context, secretCheckSum *checksumv1.SecretCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.SecretCheckSum, err error)
	SecretCheckSumExpansion
}

// secretCheckSums implements SecretCheckSumInterface
type secretCheckSums struct {
	client rest.Interface
	ns     string
}

// newSecretCheckSums returns a SecretCheckSums
func newSecretCheckSums(c *TengineV1Client, namespace string) *secretCheckSums {
	return &secretCheckSums{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the secretCheckSum, and returns the corresponding secretCheckSum object, and an error if there is any.
func (c *secretCheckSums) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SecretCheckSum, err error) {
	result = &v1.SecretCheckSum{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("secretchecksums").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SecretCheckSums that match those selectors.
func (c *secretCheckSums) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SecretCheckSumList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SecretCheckSumList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("secretchecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested secretCheckSums.
func (c *secretCheckSums) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("secretchecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a secretCheckSum and creates it.  Returns the server's representation of the secretCheckSum, and an error, if there is any.
func (c *secretCheckSums) Create(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.CreateOptions) (result *v1.SecretCheckSum, err error) {
	result = &v1.SecretCheckSum{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("secretchecksums").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(secretCheckSum).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a secretCheckSum and updates it. Returns the server's representation of the secretCheckSum, and an error, if there is any.
func (c *secretCheckSums) Update(ctx context.Context, secretCheckSum *v1.SecretCheckSum, opts metav1.UpdateOptions) (result *v1.SecretCheckSum, err error) {
	result = &v1.SecretCheckSum{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("secretchecksums").
		Name(secretCheckSum.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(secretCheckSum).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the secretCheckSum and deletes it. Returns an error if one occurs.
func (c *secretCheckSums) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("secretchecksums").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *secretCheckSums) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("secretchecksums").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched secretCheckSum.
func (c *secretCheckSums) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SecretCheckSum, err error) {
	result = &v1.SecretCheckSum{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("secretchecksums").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied secretCheckSum.
func (c *secretCheckSums) Apply(ctx context.Context, secretCheckSum *checksumv1.SecretCheckSumApplyConfiguration, opts metav1.ApplyOptions) (result *v1.SecretCheckSum, err error) {
	if secretCheckSum == nil {
		return nil, fmt.Errorf("secretCheckSum provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(secretCheckSum)
	if err != nil {
		return nil, err
	}
	name := secretCheckSum.Name
	if name == nil {
		return nil, fmt.Errorf("secretCheckSum.Name must be provided to Apply")
	}
	result = &v1.SecretCheckSum{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("secretchecksums").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
