/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1 "k8s.io/ingress-nginx/internal/checksum/ingress/apis/checksum/v1"
)

// IngressCheckSumLister helps list IngressCheckSums.
// All objects returned here must be treated as read-only.
type IngressCheckSumLister interface {
	// List lists all IngressCheckSums in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.IngressCheckSum, err error)
	// IngressCheckSums returns an object that can list and get IngressCheckSums.
	IngressCheckSums(namespace string) IngressCheckSumNamespaceLister
	IngressCheckSumListerExpansion
}

// ingressCheckSumLister implements the IngressCheckSumLister interface.
type ingressCheckSumLister struct {
	indexer cache.Indexer
}

// NewIngressCheckSumLister returns a new IngressCheckSumLister.
func NewIngressCheckSumLister(indexer cache.Indexer) IngressCheckSumLister {
	return &ingressCheckSumLister{indexer: indexer}
}

// List lists all IngressCheckSums in the indexer.
func (s *ingressCheckSumLister) List(selector labels.Selector) (ret []*v1.IngressCheckSum, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.IngressCheckSum))
	})
	return ret, err
}

// IngressCheckSums returns an object that can list and get IngressCheckSums.
func (s *ingressCheckSumLister) IngressCheckSums(namespace string) IngressCheckSumNamespaceLister {
	return ingressCheckSumNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IngressCheckSumNamespaceLister helps list and get IngressCheckSums.
// All objects returned here must be treated as read-only.
type IngressCheckSumNamespaceLister interface {
	// List lists all IngressCheckSums in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.IngressCheckSum, err error)
	// Get retrieves the IngressCheckSum from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.IngressCheckSum, error)
	IngressCheckSumNamespaceListerExpansion
}

// ingressCheckSumNamespaceLister implements the IngressCheckSumNamespaceLister
// interface.
type ingressCheckSumNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all IngressCheckSums in the indexer for a given namespace.
func (s ingressCheckSumNamespaceLister) List(selector labels.Selector) (ret []*v1.IngressCheckSum, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.IngressCheckSum))
	})
	return ret, err
}

// Get retrieves the IngressCheckSum from the indexer for a given namespace and name.
func (s ingressCheckSumNamespaceLister) Get(name string) (*v1.IngressCheckSum, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("ingresschecksum"), name)
	}
	return obj.(*v1.IngressCheckSum), nil
}
