.\" Start URL macro. Copied from an-ext.tmac for portability
.de UR
.  ds m1 \\$1\"
.  nh
.  if \\n(mH \{\
.    \" Start diversion in a new environment.
.    do ev URL-div
.    do di URL-div
.  \}
..
.\" End URL macro. Copied from an-ext.tmac for portability
.de UE
.  ie \\n(mH \{\
.    br
.    di
.    ev
.
.    \" Has there been one or more input lines for the link text?
.    ie \\n(dn \{\
.      do HTML-NS "<a href=""\\*(m1"">"
.      \" Yes, strip off final newline of diversion and emit it.
.      do chop URL-div
.      do URL-div
\c
.      do HTML-NS </a>
.    \}
.    el \
.      do HTML-NS "<a href=""\\*(m1"">\\*(m1</a>"
\&\\$*\"
.  \}
.  el \
\\*(la\\*(m1\\*(ra\\$*\"
.
.  hy \\n(HY
..
.TH ZABBIX_AGENT2 8 "2019\-01\-29" Zabbix
.SH NAME
zabbix_agent2 \- Zabbix agent 2
.SH SYNOPSIS
.B zabbix_agent2
.RB [ \-c
.IR config\-file ]
.br
.B zabbix_agent2
.RB [ \-c
.IR config\-file ]
.RB [ \-v ]
.B \-p
.br
.B zabbix_agent2
.RB [ \-c
.IR config\-file ]
.RB [ \-v ]
.B \-t
.I item\-key
.br
.B zabbix_agent2
.RB [ \-c
.IR config\-file ]
.B \-R
.I runtime\-option
.br
.B zabbix_agent2 \-h
.br
.B zabbix_agent2 \-V
.SH DESCRIPTION
.B zabbix_agent2
is an application for monitoring parameters of various services. 
.SH OPTIONS
.IP "\fB\-c\fR, \fB\-\-config\fR \fIconfig\-file\fR"
Use the alternate \fIconfig\-file\fR instead of the default one.
.IP "\fB\-R\fR, \fB\-\-runtime\-control\fR \fIruntime\-option\fR"
Perform administrative functions according to \fIruntime\-option\fR.
.SS
.RS 4
Runtime control options
.RS 4
.TP 4
\fBloglevel increase\fR
Increase log level
.RE
.RS 4
.TP 4
\fBloglevel decrease\fR
Decrease log level
.RE
.RS 4
.TP 4
\fBhelp\fR
List available runtime control options
.RE
.RS 4
.TP 4
\fBmetrics\fR
List available metrics
.RE
.RS 4
.TP 4
\fBversion\fR
Display version
.RE
.RE
.IP "\fB\-p\fR, \fB\-\-print\fR"
Print known items and exit.
For each item either generic defaults are used, or specific defaults for testing are supplied.
These defaults are listed in square brackets as item key parameters.
Returned values are enclosed in square brackets and prefixed with the type of the returned value, separated by a pipe character.
For user parameters type is always \fBt\fR, as the agent can not determine all possible return values.
Items, displayed as working, are not guaranteed to work from the Zabbix server or zabbix_get when querying a running agent daemon as permissions or environment may be different.
Returned value types are:
.RS 4
.TP 4
d
Number with a decimal part.
.RE
.RS 4
.TP 4
m
Not supported.
This could be caused by querying an item that only works in the active mode like a log monitoring item or an item that requires multiple collected values.
Permission issues or incorrect user parameters could also result in the not supported state.
.RE
.RS 4
.TP 4
s
Text.
Maximum length not limited.
.RE
.RS 4
.TP 4
t
Text.
Same as \fBs\fR.
.RE
.RS 4
.TP 4
u
Unsigned integer.
.RE
.IP "\fB\-t\fR, \fB\-\-test\fR \fIitem\-key\fR"
Test single item and exit.
See \fB\-\-print\fR for output description.
.IP "\fB\-v\fR, \fB\-\-verbose\fR"
Enable verbose output when test item or print known items.
.IP "\fB\-h\fR, \fB\-\-help\fR"
Display this help and exit.
.IP "\fB\-V\fR, \fB\-\-version\fR"
Output version information and exit.
.SH FILES
.TP
.I /usr/local/etc/zabbix_agent2.conf
Default location of Zabbix agent 2 configuration file (if not modified during compile time).
.SH "SEE ALSO"
.UR https://www.zabbix.com/manuals
Documentation
.UE
.PP
.BR zabbix_agentd (8),
.BR zabbix_get (1),
.BR zabbix_proxy (8),
.BR zabbix_sender (1),
.BR zabbix_server (8),
.BR zabbix_js (1),
.BR zabbix_web_service (8)
.SH AUTHOR
Zabbix LLC
